// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about the knowledge base.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KnowledgeBaseData {
    /// <p>The identifier of the knowledge base.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub knowledge_base_arn: std::option::Option<std::string::String>,
    /// <p>The name of the knowledge base.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of knowledge base.</p>
    pub knowledge_base_type: std::option::Option<crate::model::KnowledgeBaseType>,
    /// <p>The status of the knowledge base.</p>
    pub status: std::option::Option<crate::model::KnowledgeBaseStatus>,
    /// <p>An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.</p>
    pub last_content_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Source configuration information about the knowledge base.</p>
    pub source_configuration: std::option::Option<crate::model::SourceConfiguration>,
    /// <p>Information about how to render the content.</p>
    pub rendering_configuration: std::option::Option<crate::model::RenderingConfiguration>,
    /// <p>The KMS key used for encryption.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl KnowledgeBaseData {
    /// <p>The identifier of the knowledge base.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub fn knowledge_base_arn(&self) -> std::option::Option<&str> {
        self.knowledge_base_arn.as_deref()
    }
    /// <p>The name of the knowledge base.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of knowledge base.</p>
    pub fn knowledge_base_type(&self) -> std::option::Option<&crate::model::KnowledgeBaseType> {
        self.knowledge_base_type.as_ref()
    }
    /// <p>The status of the knowledge base.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::KnowledgeBaseStatus> {
        self.status.as_ref()
    }
    /// <p>An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.</p>
    pub fn last_content_modification_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_content_modification_time.as_ref()
    }
    /// <p>Source configuration information about the knowledge base.</p>
    pub fn source_configuration(&self) -> std::option::Option<&crate::model::SourceConfiguration> {
        self.source_configuration.as_ref()
    }
    /// <p>Information about how to render the content.</p>
    pub fn rendering_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RenderingConfiguration> {
        self.rendering_configuration.as_ref()
    }
    /// <p>The KMS key used for encryption.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for KnowledgeBaseData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KnowledgeBaseData");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("knowledge_base_arn", &self.knowledge_base_arn);
        formatter.field("name", &self.name);
        formatter.field("knowledge_base_type", &self.knowledge_base_type);
        formatter.field("status", &self.status);
        formatter.field(
            "last_content_modification_time",
            &self.last_content_modification_time,
        );
        formatter.field("source_configuration", &self.source_configuration);
        formatter.field("rendering_configuration", &self.rendering_configuration);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`KnowledgeBaseData`](crate::model::KnowledgeBaseData)
pub mod knowledge_base_data {
    /// A builder for [`KnowledgeBaseData`](crate::model::KnowledgeBaseData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_type: std::option::Option<crate::model::KnowledgeBaseType>,
        pub(crate) status: std::option::Option<crate::model::KnowledgeBaseStatus>,
        pub(crate) last_content_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_configuration: std::option::Option<crate::model::SourceConfiguration>,
        pub(crate) rendering_configuration:
            std::option::Option<crate::model::RenderingConfiguration>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the knowledge base.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn knowledge_base_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn set_knowledge_base_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_arn = input;
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of knowledge base.</p>
        pub fn knowledge_base_type(mut self, input: crate::model::KnowledgeBaseType) -> Self {
            self.knowledge_base_type = Some(input);
            self
        }
        /// <p>The type of knowledge base.</p>
        pub fn set_knowledge_base_type(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseType>,
        ) -> Self {
            self.knowledge_base_type = input;
            self
        }
        /// <p>The status of the knowledge base.</p>
        pub fn status(mut self, input: crate::model::KnowledgeBaseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the knowledge base.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.</p>
        pub fn last_content_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_content_modification_time = Some(input);
            self
        }
        /// <p>An epoch timestamp indicating the most recent content modification inside the knowledge base. If no content exists in a knowledge base, this value is unset.</p>
        pub fn set_last_content_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_content_modification_time = input;
            self
        }
        /// <p>Source configuration information about the knowledge base.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.source_configuration = Some(input);
            self
        }
        /// <p>Source configuration information about the knowledge base.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.source_configuration = input;
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn rendering_configuration(
            mut self,
            input: crate::model::RenderingConfiguration,
        ) -> Self {
            self.rendering_configuration = Some(input);
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn set_rendering_configuration(
            mut self,
            input: std::option::Option<crate::model::RenderingConfiguration>,
        ) -> Self {
            self.rendering_configuration = input;
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`KnowledgeBaseData`](crate::model::KnowledgeBaseData)
        pub fn build(self) -> crate::model::KnowledgeBaseData {
            crate::model::KnowledgeBaseData {
                knowledge_base_id: self.knowledge_base_id,
                knowledge_base_arn: self.knowledge_base_arn,
                name: self.name,
                knowledge_base_type: self.knowledge_base_type,
                status: self.status,
                last_content_modification_time: self.last_content_modification_time,
                source_configuration: self.source_configuration,
                rendering_configuration: self.rendering_configuration,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl KnowledgeBaseData {
    /// Creates a new builder-style object to manufacture [`KnowledgeBaseData`](crate::model::KnowledgeBaseData)
    pub fn builder() -> crate::model::knowledge_base_data::Builder {
        crate::model::knowledge_base_data::Builder::default()
    }
}

/// <p>The KMS key used for encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryptionConfiguration {
    /// <p>The KMS key. For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl ServerSideEncryptionConfiguration {
    /// <p>The KMS key. For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for ServerSideEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryptionConfiguration");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
pub mod server_side_encryption_configuration {
    /// A builder for [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The KMS key. For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key. For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
        pub fn build(self) -> crate::model::ServerSideEncryptionConfiguration {
            crate::model::ServerSideEncryptionConfiguration {
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ServerSideEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    pub fn builder() -> crate::model::server_side_encryption_configuration::Builder {
        crate::model::server_side_encryption_configuration::Builder::default()
    }
}

/// <p>Information about how to render the content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenderingConfiguration {
    /// <p>A URI template containing exactly one variable in <code>${variableName} </code>format. This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce and ServiceNow, the variable must be one of the following:</p>
    /// <ul>
    /// <li> <p>Salesforce: <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, or <code>IsDeleted</code> </p> </li>
    /// <li> <p>ServiceNow: <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, or <code>active</code> </p> </li>
    /// </ul>
    /// <p>The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a>. </p>
    pub template_uri: std::option::Option<std::string::String>,
}
impl RenderingConfiguration {
    /// <p>A URI template containing exactly one variable in <code>${variableName} </code>format. This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce and ServiceNow, the variable must be one of the following:</p>
    /// <ul>
    /// <li> <p>Salesforce: <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, or <code>IsDeleted</code> </p> </li>
    /// <li> <p>ServiceNow: <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, or <code>active</code> </p> </li>
    /// </ul>
    /// <p>The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a>. </p>
    pub fn template_uri(&self) -> std::option::Option<&str> {
        self.template_uri.as_deref()
    }
}
impl std::fmt::Debug for RenderingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenderingConfiguration");
        formatter.field("template_uri", &self.template_uri);
        formatter.finish()
    }
}
/// See [`RenderingConfiguration`](crate::model::RenderingConfiguration)
pub mod rendering_configuration {
    /// A builder for [`RenderingConfiguration`](crate::model::RenderingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A URI template containing exactly one variable in <code>${variableName} </code>format. This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce and ServiceNow, the variable must be one of the following:</p>
        /// <ul>
        /// <li> <p>Salesforce: <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, or <code>IsDeleted</code> </p> </li>
        /// <li> <p>ServiceNow: <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, or <code>active</code> </p> </li>
        /// </ul>
        /// <p>The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a>. </p>
        pub fn template_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_uri = Some(input.into());
            self
        }
        /// <p>A URI template containing exactly one variable in <code>${variableName} </code>format. This can only be set for <code>EXTERNAL</code> knowledge bases. For Salesforce and ServiceNow, the variable must be one of the following:</p>
        /// <ul>
        /// <li> <p>Salesforce: <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, or <code>IsDeleted</code> </p> </li>
        /// <li> <p>ServiceNow: <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, or <code>active</code> </p> </li>
        /// </ul>
        /// <p>The variable is replaced with the actual value for a piece of content when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a>. </p>
        pub fn set_template_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`RenderingConfiguration`](crate::model::RenderingConfiguration)
        pub fn build(self) -> crate::model::RenderingConfiguration {
            crate::model::RenderingConfiguration {
                template_uri: self.template_uri,
            }
        }
    }
}
impl RenderingConfiguration {
    /// Creates a new builder-style object to manufacture [`RenderingConfiguration`](crate::model::RenderingConfiguration)
    pub fn builder() -> crate::model::rendering_configuration::Builder {
        crate::model::rendering_configuration::Builder::default()
    }
}

/// <p>Configuration information about the external data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum SourceConfiguration {
    /// <p>Configuration information for Amazon AppIntegrations to automatically ingest content.</p>
    AppIntegrations(crate::model::AppIntegrationsConfiguration),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl SourceConfiguration {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`AppIntegrations`](crate::model::SourceConfiguration::AppIntegrations), extracting the inner [`AppIntegrationsConfiguration`](crate::model::AppIntegrationsConfiguration).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_app_integrations(
        &self,
    ) -> std::result::Result<&crate::model::AppIntegrationsConfiguration, &Self> {
        if let SourceConfiguration::AppIntegrations(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AppIntegrations`](crate::model::SourceConfiguration::AppIntegrations).
    pub fn is_app_integrations(&self) -> bool {
        self.as_app_integrations().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Configuration information for Amazon AppIntegrations to automatically ingest content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppIntegrationsConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.</p>
    pub app_integration_arn: std::option::Option<std::string::String>,
    /// <p>The fields from the source that are made available to your agents in Wisdom. </p>
    /// <ul>
    /// <li> <p> For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>. </p> </li>
    /// <li> <p>For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>. </p> </li>
    /// </ul>
    /// <p>Make sure to include additional fields. These fields are indexed and used to source recommendations. </p>
    pub object_fields: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AppIntegrationsConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.</p>
    pub fn app_integration_arn(&self) -> std::option::Option<&str> {
        self.app_integration_arn.as_deref()
    }
    /// <p>The fields from the source that are made available to your agents in Wisdom. </p>
    /// <ul>
    /// <li> <p> For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>. </p> </li>
    /// <li> <p>For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>. </p> </li>
    /// </ul>
    /// <p>Make sure to include additional fields. These fields are indexed and used to source recommendations. </p>
    pub fn object_fields(&self) -> std::option::Option<&[std::string::String]> {
        self.object_fields.as_deref()
    }
}
impl std::fmt::Debug for AppIntegrationsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppIntegrationsConfiguration");
        formatter.field("app_integration_arn", &self.app_integration_arn);
        formatter.field("object_fields", &self.object_fields);
        formatter.finish()
    }
}
/// See [`AppIntegrationsConfiguration`](crate::model::AppIntegrationsConfiguration)
pub mod app_integrations_configuration {
    /// A builder for [`AppIntegrationsConfiguration`](crate::model::AppIntegrationsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_integration_arn: std::option::Option<std::string::String>,
        pub(crate) object_fields: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.</p>
        pub fn app_integration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_integration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to use for ingesting content.</p>
        pub fn set_app_integration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_integration_arn = input;
            self
        }
        /// Appends an item to `object_fields`.
        ///
        /// To override the contents of this collection use [`set_object_fields`](Self::set_object_fields).
        ///
        /// <p>The fields from the source that are made available to your agents in Wisdom. </p>
        /// <ul>
        /// <li> <p> For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>. </p> </li>
        /// <li> <p>For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>. </p> </li>
        /// </ul>
        /// <p>Make sure to include additional fields. These fields are indexed and used to source recommendations. </p>
        pub fn object_fields(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.object_fields.unwrap_or_default();
            v.push(input.into());
            self.object_fields = Some(v);
            self
        }
        /// <p>The fields from the source that are made available to your agents in Wisdom. </p>
        /// <ul>
        /// <li> <p> For <a href="https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm"> Salesforce</a>, you must include at least <code>Id</code>, <code>ArticleNumber</code>, <code>VersionNumber</code>, <code>Title</code>, <code>PublishStatus</code>, and <code>IsDeleted</code>. </p> </li>
        /// <li> <p>For <a href="https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api"> ServiceNow</a>, you must include at least <code>number</code>, <code>short_description</code>, <code>sys_mod_count</code>, <code>workflow_state</code>, and <code>active</code>. </p> </li>
        /// </ul>
        /// <p>Make sure to include additional fields. These fields are indexed and used to source recommendations. </p>
        pub fn set_object_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.object_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`AppIntegrationsConfiguration`](crate::model::AppIntegrationsConfiguration)
        pub fn build(self) -> crate::model::AppIntegrationsConfiguration {
            crate::model::AppIntegrationsConfiguration {
                app_integration_arn: self.app_integration_arn,
                object_fields: self.object_fields,
            }
        }
    }
}
impl AppIntegrationsConfiguration {
    /// Creates a new builder-style object to manufacture [`AppIntegrationsConfiguration`](crate::model::AppIntegrationsConfiguration)
    pub fn builder() -> crate::model::app_integrations_configuration::Builder {
        crate::model::app_integrations_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KnowledgeBaseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KnowledgeBaseStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => KnowledgeBaseStatus::Active,
            "CREATE_FAILED" => KnowledgeBaseStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => KnowledgeBaseStatus::CreateInProgress,
            "DELETED" => KnowledgeBaseStatus::Deleted,
            "DELETE_FAILED" => KnowledgeBaseStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => KnowledgeBaseStatus::DeleteInProgress,
            other => KnowledgeBaseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KnowledgeBaseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KnowledgeBaseStatus::from(s))
    }
}
impl KnowledgeBaseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KnowledgeBaseStatus::Active => "ACTIVE",
            KnowledgeBaseStatus::CreateFailed => "CREATE_FAILED",
            KnowledgeBaseStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            KnowledgeBaseStatus::Deleted => "DELETED",
            KnowledgeBaseStatus::DeleteFailed => "DELETE_FAILED",
            KnowledgeBaseStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            KnowledgeBaseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for KnowledgeBaseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KnowledgeBaseType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    External,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KnowledgeBaseType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => KnowledgeBaseType::Custom,
            "EXTERNAL" => KnowledgeBaseType::External,
            other => KnowledgeBaseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KnowledgeBaseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KnowledgeBaseType::from(s))
    }
}
impl KnowledgeBaseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KnowledgeBaseType::Custom => "CUSTOM",
            KnowledgeBaseType::External => "EXTERNAL",
            KnowledgeBaseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM", "EXTERNAL"]
    }
}
impl AsRef<str> for KnowledgeBaseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about the content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentSummary {
    /// <p>The Amazon Resource Name (ARN) of the content.</p>
    pub content_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the content.</p>
    pub content_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub knowledge_base_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the knowledge base.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The name of the content.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the revision of the content.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The title of the content.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The media type of the content.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The status of the content.</p>
    pub status: std::option::Option<crate::model::ContentStatus>,
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ContentSummary {
    /// <p>The Amazon Resource Name (ARN) of the content.</p>
    pub fn content_arn(&self) -> std::option::Option<&str> {
        self.content_arn.as_deref()
    }
    /// <p>The identifier of the content.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub fn knowledge_base_arn(&self) -> std::option::Option<&str> {
        self.knowledge_base_arn.as_deref()
    }
    /// <p>The identifier of the knowledge base.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The name of the content.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the revision of the content.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The title of the content.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The media type of the content.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The status of the content.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ContentStatus> {
        self.status.as_ref()
    }
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ContentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentSummary");
        formatter.field("content_arn", &self.content_arn);
        formatter.field("content_id", &self.content_id);
        formatter.field("knowledge_base_arn", &self.knowledge_base_arn);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("title", &self.title);
        formatter.field("content_type", &self.content_type);
        formatter.field("status", &self.status);
        formatter.field("metadata", &self.metadata);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ContentSummary`](crate::model::ContentSummary)
pub mod content_summary {
    /// A builder for [`ContentSummary`](crate::model::ContentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_arn: std::option::Option<std::string::String>,
        pub(crate) content_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_arn: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ContentStatus>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the content.</p>
        pub fn content_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the content.</p>
        pub fn set_content_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_arn = input;
            self
        }
        /// <p>The identifier of the content.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn knowledge_base_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn set_knowledge_base_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_arn = input;
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The name of the content.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the content.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the revision of the content.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The identifier of the revision of the content.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The title of the content.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the content.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The media type of the content.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The media type of the content.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The status of the content.</p>
        pub fn status(mut self, input: crate::model::ContentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the content.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentSummary`](crate::model::ContentSummary)
        pub fn build(self) -> crate::model::ContentSummary {
            crate::model::ContentSummary {
                content_arn: self.content_arn,
                content_id: self.content_id,
                knowledge_base_arn: self.knowledge_base_arn,
                knowledge_base_id: self.knowledge_base_id,
                name: self.name,
                revision_id: self.revision_id,
                title: self.title,
                content_type: self.content_type,
                status: self.status,
                metadata: self.metadata,
                tags: self.tags,
            }
        }
    }
}
impl ContentSummary {
    /// Creates a new builder-style object to manufacture [`ContentSummary`](crate::model::ContentSummary)
    pub fn builder() -> crate::model::content_summary::Builder {
        crate::model::content_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ContentStatus::Active,
            "CREATE_FAILED" => ContentStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => ContentStatus::CreateInProgress,
            "DELETED" => ContentStatus::Deleted,
            "DELETE_FAILED" => ContentStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => ContentStatus::DeleteInProgress,
            "UPDATE_FAILED" => ContentStatus::UpdateFailed,
            other => ContentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentStatus::from(s))
    }
}
impl ContentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentStatus::Active => "ACTIVE",
            ContentStatus::CreateFailed => "CREATE_FAILED",
            ContentStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            ContentStatus::Deleted => "DELETED",
            ContentStatus::DeleteFailed => "DELETE_FAILED",
            ContentStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            ContentStatus::UpdateFailed => "UPDATE_FAILED",
            ContentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "UPDATE_FAILED",
        ]
    }
}
impl AsRef<str> for ContentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The search expression.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchExpression {
    /// <p>The search expression filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl SearchExpression {
    /// <p>The search expression filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for SearchExpression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchExpression");
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}
/// See [`SearchExpression`](crate::model::SearchExpression)
pub mod search_expression {
    /// A builder for [`SearchExpression`](crate::model::SearchExpression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The search expression filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>The search expression filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchExpression`](crate::model::SearchExpression)
        pub fn build(self) -> crate::model::SearchExpression {
            crate::model::SearchExpression {
                filters: self.filters,
            }
        }
    }
}
impl SearchExpression {
    /// Creates a new builder-style object to manufacture [`SearchExpression`](crate::model::SearchExpression)
    pub fn builder() -> crate::model::search_expression::Builder {
        crate::model::search_expression::Builder::default()
    }
}

/// <p>A search filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The field on which to filter.</p>
    pub field: std::option::Option<crate::model::FilterField>,
    /// <p>The operator to use for comparing the field’s value with the provided value.</p>
    pub operator: std::option::Option<crate::model::FilterOperator>,
    /// <p>The desired field value on which to filter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Filter {
    /// <p>The field on which to filter.</p>
    pub fn field(&self) -> std::option::Option<&crate::model::FilterField> {
        self.field.as_ref()
    }
    /// <p>The operator to use for comparing the field’s value with the provided value.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::FilterOperator> {
        self.operator.as_ref()
    }
    /// <p>The desired field value on which to filter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("field", &self.field);
        formatter.field("operator", &self.operator);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<crate::model::FilterField>,
        pub(crate) operator: std::option::Option<crate::model::FilterOperator>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field on which to filter.</p>
        pub fn field(mut self, input: crate::model::FilterField) -> Self {
            self.field = Some(input);
            self
        }
        /// <p>The field on which to filter.</p>
        pub fn set_field(mut self, input: std::option::Option<crate::model::FilterField>) -> Self {
            self.field = input;
            self
        }
        /// <p>The operator to use for comparing the field’s value with the provided value.</p>
        pub fn operator(mut self, input: crate::model::FilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for comparing the field’s value with the provided value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::FilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// <p>The desired field value on which to filter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The desired field value on which to filter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                field: self.field,
                operator: self.operator,
                value: self.value,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => FilterOperator::Equals,
            other => FilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterOperator::from(s))
    }
}
impl FilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterOperator::Equals => "EQUALS",
            FilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS"]
    }
}
impl AsRef<str> for FilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterField {
    #[allow(missing_docs)] // documentation missing in model
    Name,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterField {
    fn from(s: &str) -> Self {
        match s {
            "NAME" => FilterField::Name,
            other => FilterField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterField::from(s))
    }
}
impl FilterField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterField::Name => "NAME",
            FilterField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NAME"]
    }
}
impl AsRef<str> for FilterField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about the knowledge base.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KnowledgeBaseSummary {
    /// <p>The identifier of the knowledge base.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub knowledge_base_arn: std::option::Option<std::string::String>,
    /// <p>The name of the knowledge base.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of knowledge base.</p>
    pub knowledge_base_type: std::option::Option<crate::model::KnowledgeBaseType>,
    /// <p>The status of the knowledge base summary.</p>
    pub status: std::option::Option<crate::model::KnowledgeBaseStatus>,
    /// <p>Configuration information about the external data source.</p>
    pub source_configuration: std::option::Option<crate::model::SourceConfiguration>,
    /// <p>Information about how to render the content.</p>
    pub rendering_configuration: std::option::Option<crate::model::RenderingConfiguration>,
    /// <p>The KMS key used for encryption.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    /// <p>The description of the knowledge base.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl KnowledgeBaseSummary {
    /// <p>The identifier of the knowledge base.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub fn knowledge_base_arn(&self) -> std::option::Option<&str> {
        self.knowledge_base_arn.as_deref()
    }
    /// <p>The name of the knowledge base.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of knowledge base.</p>
    pub fn knowledge_base_type(&self) -> std::option::Option<&crate::model::KnowledgeBaseType> {
        self.knowledge_base_type.as_ref()
    }
    /// <p>The status of the knowledge base summary.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::KnowledgeBaseStatus> {
        self.status.as_ref()
    }
    /// <p>Configuration information about the external data source.</p>
    pub fn source_configuration(&self) -> std::option::Option<&crate::model::SourceConfiguration> {
        self.source_configuration.as_ref()
    }
    /// <p>Information about how to render the content.</p>
    pub fn rendering_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RenderingConfiguration> {
        self.rendering_configuration.as_ref()
    }
    /// <p>The KMS key used for encryption.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
    /// <p>The description of the knowledge base.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for KnowledgeBaseSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KnowledgeBaseSummary");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("knowledge_base_arn", &self.knowledge_base_arn);
        formatter.field("name", &self.name);
        formatter.field("knowledge_base_type", &self.knowledge_base_type);
        formatter.field("status", &self.status);
        formatter.field("source_configuration", &self.source_configuration);
        formatter.field("rendering_configuration", &self.rendering_configuration);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`KnowledgeBaseSummary`](crate::model::KnowledgeBaseSummary)
pub mod knowledge_base_summary {
    /// A builder for [`KnowledgeBaseSummary`](crate::model::KnowledgeBaseSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_type: std::option::Option<crate::model::KnowledgeBaseType>,
        pub(crate) status: std::option::Option<crate::model::KnowledgeBaseStatus>,
        pub(crate) source_configuration: std::option::Option<crate::model::SourceConfiguration>,
        pub(crate) rendering_configuration:
            std::option::Option<crate::model::RenderingConfiguration>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the knowledge base.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn knowledge_base_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn set_knowledge_base_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_arn = input;
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of knowledge base.</p>
        pub fn knowledge_base_type(mut self, input: crate::model::KnowledgeBaseType) -> Self {
            self.knowledge_base_type = Some(input);
            self
        }
        /// <p>The type of knowledge base.</p>
        pub fn set_knowledge_base_type(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseType>,
        ) -> Self {
            self.knowledge_base_type = input;
            self
        }
        /// <p>The status of the knowledge base summary.</p>
        pub fn status(mut self, input: crate::model::KnowledgeBaseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the knowledge base summary.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Configuration information about the external data source.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.source_configuration = Some(input);
            self
        }
        /// <p>Configuration information about the external data source.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.source_configuration = input;
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn rendering_configuration(
            mut self,
            input: crate::model::RenderingConfiguration,
        ) -> Self {
            self.rendering_configuration = Some(input);
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn set_rendering_configuration(
            mut self,
            input: std::option::Option<crate::model::RenderingConfiguration>,
        ) -> Self {
            self.rendering_configuration = input;
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The description of the knowledge base.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the knowledge base.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`KnowledgeBaseSummary`](crate::model::KnowledgeBaseSummary)
        pub fn build(self) -> crate::model::KnowledgeBaseSummary {
            crate::model::KnowledgeBaseSummary {
                knowledge_base_id: self.knowledge_base_id,
                knowledge_base_arn: self.knowledge_base_arn,
                name: self.name,
                knowledge_base_type: self.knowledge_base_type,
                status: self.status,
                source_configuration: self.source_configuration,
                rendering_configuration: self.rendering_configuration,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl KnowledgeBaseSummary {
    /// Creates a new builder-style object to manufacture [`KnowledgeBaseSummary`](crate::model::KnowledgeBaseSummary)
    pub fn builder() -> crate::model::knowledge_base_summary::Builder {
        crate::model::knowledge_base_summary::Builder::default()
    }
}

/// <p>Information about the content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentData {
    /// <p>The Amazon Resource Name (ARN) of the content.</p>
    pub content_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the content.</p>
    pub content_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub knowledge_base_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the knowledge base.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The name of the content.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The identifier of the content revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The title of the content.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The media type of the content.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The status of the content.</p>
    pub status: std::option::Option<crate::model::ContentStatus>,
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The URI of the content.</p>
    pub link_out_uri: std::option::Option<std::string::String>,
    /// <p>The URL of the content.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The expiration time of the URL as an epoch timestamp.</p>
    pub url_expiry: std::option::Option<aws_smithy_types::DateTime>,
}
impl ContentData {
    /// <p>The Amazon Resource Name (ARN) of the content.</p>
    pub fn content_arn(&self) -> std::option::Option<&str> {
        self.content_arn.as_deref()
    }
    /// <p>The identifier of the content.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub fn knowledge_base_arn(&self) -> std::option::Option<&str> {
        self.knowledge_base_arn.as_deref()
    }
    /// <p>The identifier of the knowledge base.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The name of the content.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The identifier of the content revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The title of the content.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The media type of the content.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The status of the content.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ContentStatus> {
        self.status.as_ref()
    }
    /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The URI of the content.</p>
    pub fn link_out_uri(&self) -> std::option::Option<&str> {
        self.link_out_uri.as_deref()
    }
    /// <p>The URL of the content.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The expiration time of the URL as an epoch timestamp.</p>
    pub fn url_expiry(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.url_expiry.as_ref()
    }
}
impl std::fmt::Debug for ContentData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentData");
        formatter.field("content_arn", &self.content_arn);
        formatter.field("content_id", &self.content_id);
        formatter.field("knowledge_base_arn", &self.knowledge_base_arn);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("name", &self.name);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("title", &self.title);
        formatter.field("content_type", &self.content_type);
        formatter.field("status", &self.status);
        formatter.field("metadata", &self.metadata);
        formatter.field("tags", &self.tags);
        formatter.field("link_out_uri", &self.link_out_uri);
        formatter.field("url", &"*** Sensitive Data Redacted ***");
        formatter.field("url_expiry", &self.url_expiry);
        formatter.finish()
    }
}
/// See [`ContentData`](crate::model::ContentData)
pub mod content_data {
    /// A builder for [`ContentData`](crate::model::ContentData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_arn: std::option::Option<std::string::String>,
        pub(crate) content_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_arn: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ContentStatus>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) link_out_uri: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) url_expiry: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the content.</p>
        pub fn content_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the content.</p>
        pub fn set_content_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_arn = input;
            self
        }
        /// <p>The identifier of the content.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn knowledge_base_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn set_knowledge_base_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_arn = input;
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The name of the content.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the content.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier of the content revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The title of the content.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the content.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The media type of the content.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The media type of the content.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The status of the content.</p>
        pub fn status(mut self, input: crate::model::ContentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the content.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The URI of the content.</p>
        pub fn link_out_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.link_out_uri = Some(input.into());
            self
        }
        /// <p>The URI of the content.</p>
        pub fn set_link_out_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link_out_uri = input;
            self
        }
        /// <p>The URL of the content.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the content.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The expiration time of the URL as an epoch timestamp.</p>
        pub fn url_expiry(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.url_expiry = Some(input);
            self
        }
        /// <p>The expiration time of the URL as an epoch timestamp.</p>
        pub fn set_url_expiry(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.url_expiry = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentData`](crate::model::ContentData)
        pub fn build(self) -> crate::model::ContentData {
            crate::model::ContentData {
                content_arn: self.content_arn,
                content_id: self.content_id,
                knowledge_base_arn: self.knowledge_base_arn,
                knowledge_base_id: self.knowledge_base_id,
                name: self.name,
                revision_id: self.revision_id,
                title: self.title,
                content_type: self.content_type,
                status: self.status,
                metadata: self.metadata,
                tags: self.tags,
                link_out_uri: self.link_out_uri,
                url: self.url,
                url_expiry: self.url_expiry,
            }
        }
    }
}
impl ContentData {
    /// Creates a new builder-style object to manufacture [`ContentData`](crate::model::ContentData)
    pub fn builder() -> crate::model::content_data::Builder {
        crate::model::content_data::Builder::default()
    }
}

/// <p>Summary information about the session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionSummary {
    /// <p>The identifier of the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the session.</p>
    pub session_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the Wisdom assistant.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub assistant_arn: std::option::Option<std::string::String>,
}
impl SessionSummary {
    /// <p>The identifier of the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the session.</p>
    pub fn session_arn(&self) -> std::option::Option<&str> {
        self.session_arn.as_deref()
    }
    /// <p>The identifier of the Wisdom assistant.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub fn assistant_arn(&self) -> std::option::Option<&str> {
        self.assistant_arn.as_deref()
    }
}
impl std::fmt::Debug for SessionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionSummary");
        formatter.field("session_id", &self.session_id);
        formatter.field("session_arn", &self.session_arn);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("assistant_arn", &self.assistant_arn);
        formatter.finish()
    }
}
/// See [`SessionSummary`](crate::model::SessionSummary)
pub mod session_summary {
    /// A builder for [`SessionSummary`](crate::model::SessionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) session_arn: std::option::Option<std::string::String>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) assistant_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session.</p>
        pub fn session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session.</p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_arn = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn assistant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn set_assistant_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionSummary`](crate::model::SessionSummary)
        pub fn build(self) -> crate::model::SessionSummary {
            crate::model::SessionSummary {
                session_id: self.session_id,
                session_arn: self.session_arn,
                assistant_id: self.assistant_id,
                assistant_arn: self.assistant_arn,
            }
        }
    }
}
impl SessionSummary {
    /// Creates a new builder-style object to manufacture [`SessionSummary`](crate::model::SessionSummary)
    pub fn builder() -> crate::model::session_summary::Builder {
        crate::model::session_summary::Builder::default()
    }
}

/// <p>Information about the result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultData {
    /// <p>The identifier of the result data.</p>
    pub result_id: std::option::Option<std::string::String>,
    /// <p>The document.</p>
    pub document: std::option::Option<crate::model::Document>,
    /// <p>The relevance score of the results.</p>
    pub relevance_score: f64,
}
impl ResultData {
    /// <p>The identifier of the result data.</p>
    pub fn result_id(&self) -> std::option::Option<&str> {
        self.result_id.as_deref()
    }
    /// <p>The document.</p>
    pub fn document(&self) -> std::option::Option<&crate::model::Document> {
        self.document.as_ref()
    }
    /// <p>The relevance score of the results.</p>
    pub fn relevance_score(&self) -> f64 {
        self.relevance_score
    }
}
impl std::fmt::Debug for ResultData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultData");
        formatter.field("result_id", &self.result_id);
        formatter.field("document", &self.document);
        formatter.field("relevance_score", &self.relevance_score);
        formatter.finish()
    }
}
/// See [`ResultData`](crate::model::ResultData)
pub mod result_data {
    /// A builder for [`ResultData`](crate::model::ResultData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_id: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<crate::model::Document>,
        pub(crate) relevance_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The identifier of the result data.</p>
        pub fn result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_id = Some(input.into());
            self
        }
        /// <p>The identifier of the result data.</p>
        pub fn set_result_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_id = input;
            self
        }
        /// <p>The document.</p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>The document.</p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.document = input;
            self
        }
        /// <p>The relevance score of the results.</p>
        pub fn relevance_score(mut self, input: f64) -> Self {
            self.relevance_score = Some(input);
            self
        }
        /// <p>The relevance score of the results.</p>
        pub fn set_relevance_score(mut self, input: std::option::Option<f64>) -> Self {
            self.relevance_score = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultData`](crate::model::ResultData)
        pub fn build(self) -> crate::model::ResultData {
            crate::model::ResultData {
                result_id: self.result_id,
                document: self.document,
                relevance_score: self.relevance_score.unwrap_or_default(),
            }
        }
    }
}
impl ResultData {
    /// Creates a new builder-style object to manufacture [`ResultData`](crate::model::ResultData)
    pub fn builder() -> crate::model::result_data::Builder {
        crate::model::result_data::Builder::default()
    }
}

/// <p>The document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Document {
    /// <p>A reference to the content resource.</p>
    pub content_reference: std::option::Option<crate::model::ContentReference>,
    /// <p>The title of the document.</p>
    pub title: std::option::Option<crate::model::DocumentText>,
    /// <p>The excerpt from the document.</p>
    pub excerpt: std::option::Option<crate::model::DocumentText>,
}
impl Document {
    /// <p>A reference to the content resource.</p>
    pub fn content_reference(&self) -> std::option::Option<&crate::model::ContentReference> {
        self.content_reference.as_ref()
    }
    /// <p>The title of the document.</p>
    pub fn title(&self) -> std::option::Option<&crate::model::DocumentText> {
        self.title.as_ref()
    }
    /// <p>The excerpt from the document.</p>
    pub fn excerpt(&self) -> std::option::Option<&crate::model::DocumentText> {
        self.excerpt.as_ref()
    }
}
impl std::fmt::Debug for Document {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Document");
        formatter.field("content_reference", &self.content_reference);
        formatter.field("title", &self.title);
        formatter.field("excerpt", &self.excerpt);
        formatter.finish()
    }
}
/// See [`Document`](crate::model::Document)
pub mod document {
    /// A builder for [`Document`](crate::model::Document)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_reference: std::option::Option<crate::model::ContentReference>,
        pub(crate) title: std::option::Option<crate::model::DocumentText>,
        pub(crate) excerpt: std::option::Option<crate::model::DocumentText>,
    }
    impl Builder {
        /// <p>A reference to the content resource.</p>
        pub fn content_reference(mut self, input: crate::model::ContentReference) -> Self {
            self.content_reference = Some(input);
            self
        }
        /// <p>A reference to the content resource.</p>
        pub fn set_content_reference(
            mut self,
            input: std::option::Option<crate::model::ContentReference>,
        ) -> Self {
            self.content_reference = input;
            self
        }
        /// <p>The title of the document.</p>
        pub fn title(mut self, input: crate::model::DocumentText) -> Self {
            self.title = Some(input);
            self
        }
        /// <p>The title of the document.</p>
        pub fn set_title(mut self, input: std::option::Option<crate::model::DocumentText>) -> Self {
            self.title = input;
            self
        }
        /// <p>The excerpt from the document.</p>
        pub fn excerpt(mut self, input: crate::model::DocumentText) -> Self {
            self.excerpt = Some(input);
            self
        }
        /// <p>The excerpt from the document.</p>
        pub fn set_excerpt(
            mut self,
            input: std::option::Option<crate::model::DocumentText>,
        ) -> Self {
            self.excerpt = input;
            self
        }
        /// Consumes the builder and constructs a [`Document`](crate::model::Document)
        pub fn build(self) -> crate::model::Document {
            crate::model::Document {
                content_reference: self.content_reference,
                title: self.title,
                excerpt: self.excerpt,
            }
        }
    }
}
impl Document {
    /// Creates a new builder-style object to manufacture [`Document`](crate::model::Document)
    pub fn builder() -> crate::model::document::Builder {
        crate::model::document::Builder::default()
    }
}

/// <p>The text of the document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentText {
    /// <p>Text in the document.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>Highlights in the document text.</p>
    pub highlights: std::option::Option<std::vec::Vec<crate::model::Highlight>>,
}
impl DocumentText {
    /// <p>Text in the document.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>Highlights in the document text.</p>
    pub fn highlights(&self) -> std::option::Option<&[crate::model::Highlight]> {
        self.highlights.as_deref()
    }
}
impl std::fmt::Debug for DocumentText {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentText");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("highlights", &self.highlights);
        formatter.finish()
    }
}
/// See [`DocumentText`](crate::model::DocumentText)
pub mod document_text {
    /// A builder for [`DocumentText`](crate::model::DocumentText)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) highlights: std::option::Option<std::vec::Vec<crate::model::Highlight>>,
    }
    impl Builder {
        /// <p>Text in the document.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>Text in the document.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `highlights`.
        ///
        /// To override the contents of this collection use [`set_highlights`](Self::set_highlights).
        ///
        /// <p>Highlights in the document text.</p>
        pub fn highlights(mut self, input: crate::model::Highlight) -> Self {
            let mut v = self.highlights.unwrap_or_default();
            v.push(input);
            self.highlights = Some(v);
            self
        }
        /// <p>Highlights in the document text.</p>
        pub fn set_highlights(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Highlight>>,
        ) -> Self {
            self.highlights = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentText`](crate::model::DocumentText)
        pub fn build(self) -> crate::model::DocumentText {
            crate::model::DocumentText {
                text: self.text,
                highlights: self.highlights,
            }
        }
    }
}
impl DocumentText {
    /// Creates a new builder-style object to manufacture [`DocumentText`](crate::model::DocumentText)
    pub fn builder() -> crate::model::document_text::Builder {
        crate::model::document_text::Builder::default()
    }
}

/// <p>Offset specification to describe highlighting of document excerpts for rendering search results and recommendations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Highlight {
    /// <p>The offset for the start of the highlight.</p>
    pub begin_offset_inclusive: i32,
    /// <p>The offset for the end of the highlight.</p>
    pub end_offset_exclusive: i32,
}
impl Highlight {
    /// <p>The offset for the start of the highlight.</p>
    pub fn begin_offset_inclusive(&self) -> i32 {
        self.begin_offset_inclusive
    }
    /// <p>The offset for the end of the highlight.</p>
    pub fn end_offset_exclusive(&self) -> i32 {
        self.end_offset_exclusive
    }
}
impl std::fmt::Debug for Highlight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Highlight");
        formatter.field("begin_offset_inclusive", &self.begin_offset_inclusive);
        formatter.field("end_offset_exclusive", &self.end_offset_exclusive);
        formatter.finish()
    }
}
/// See [`Highlight`](crate::model::Highlight)
pub mod highlight {
    /// A builder for [`Highlight`](crate::model::Highlight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin_offset_inclusive: std::option::Option<i32>,
        pub(crate) end_offset_exclusive: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The offset for the start of the highlight.</p>
        pub fn begin_offset_inclusive(mut self, input: i32) -> Self {
            self.begin_offset_inclusive = Some(input);
            self
        }
        /// <p>The offset for the start of the highlight.</p>
        pub fn set_begin_offset_inclusive(mut self, input: std::option::Option<i32>) -> Self {
            self.begin_offset_inclusive = input;
            self
        }
        /// <p>The offset for the end of the highlight.</p>
        pub fn end_offset_exclusive(mut self, input: i32) -> Self {
            self.end_offset_exclusive = Some(input);
            self
        }
        /// <p>The offset for the end of the highlight.</p>
        pub fn set_end_offset_exclusive(mut self, input: std::option::Option<i32>) -> Self {
            self.end_offset_exclusive = input;
            self
        }
        /// Consumes the builder and constructs a [`Highlight`](crate::model::Highlight)
        pub fn build(self) -> crate::model::Highlight {
            crate::model::Highlight {
                begin_offset_inclusive: self.begin_offset_inclusive.unwrap_or_default(),
                end_offset_exclusive: self.end_offset_exclusive.unwrap_or_default(),
            }
        }
    }
}
impl Highlight {
    /// Creates a new builder-style object to manufacture [`Highlight`](crate::model::Highlight)
    pub fn builder() -> crate::model::highlight::Builder {
        crate::model::highlight::Builder::default()
    }
}

/// <p>Reference information about the content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentReference {
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub knowledge_base_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the knowledge base.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the content.</p>
    pub content_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the content.</p>
    pub content_id: std::option::Option<std::string::String>,
}
impl ContentReference {
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub fn knowledge_base_arn(&self) -> std::option::Option<&str> {
        self.knowledge_base_arn.as_deref()
    }
    /// <p>The identifier of the knowledge base.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the content.</p>
    pub fn content_arn(&self) -> std::option::Option<&str> {
        self.content_arn.as_deref()
    }
    /// <p>The identifier of the content.</p>
    pub fn content_id(&self) -> std::option::Option<&str> {
        self.content_id.as_deref()
    }
}
impl std::fmt::Debug for ContentReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentReference");
        formatter.field("knowledge_base_arn", &self.knowledge_base_arn);
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("content_arn", &self.content_arn);
        formatter.field("content_id", &self.content_id);
        formatter.finish()
    }
}
/// See [`ContentReference`](crate::model::ContentReference)
pub mod content_reference {
    /// A builder for [`ContentReference`](crate::model::ContentReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_arn: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) content_arn: std::option::Option<std::string::String>,
        pub(crate) content_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn knowledge_base_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn set_knowledge_base_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_arn = input;
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the content.</p>
        pub fn content_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the content.</p>
        pub fn set_content_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_arn = input;
            self
        }
        /// <p>The identifier of the content.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_id = Some(input.into());
            self
        }
        /// <p>The identifier of the content.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentReference`](crate::model::ContentReference)
        pub fn build(self) -> crate::model::ContentReference {
            crate::model::ContentReference {
                knowledge_base_arn: self.knowledge_base_arn,
                knowledge_base_id: self.knowledge_base_id,
                content_arn: self.content_arn,
                content_id: self.content_id,
            }
        }
    }
}
impl ContentReference {
    /// Creates a new builder-style object to manufacture [`ContentReference`](crate::model::ContentReference)
    pub fn builder() -> crate::model::content_reference::Builder {
        crate::model::content_reference::Builder::default()
    }
}

/// <p>An error occurred when creating a recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotifyRecommendationsReceivedError {
    /// <p>The identifier of the recommendation that is in error.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>A recommendation is causing an error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NotifyRecommendationsReceivedError {
    /// <p>The identifier of the recommendation that is in error.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>A recommendation is causing an error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for NotifyRecommendationsReceivedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotifyRecommendationsReceivedError");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`NotifyRecommendationsReceivedError`](crate::model::NotifyRecommendationsReceivedError)
pub mod notify_recommendations_received_error {
    /// A builder for [`NotifyRecommendationsReceivedError`](crate::model::NotifyRecommendationsReceivedError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the recommendation that is in error.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the recommendation that is in error.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>A recommendation is causing an error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A recommendation is causing an error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotifyRecommendationsReceivedError`](crate::model::NotifyRecommendationsReceivedError)
        pub fn build(self) -> crate::model::NotifyRecommendationsReceivedError {
            crate::model::NotifyRecommendationsReceivedError {
                recommendation_id: self.recommendation_id,
                message: self.message,
            }
        }
    }
}
impl NotifyRecommendationsReceivedError {
    /// Creates a new builder-style object to manufacture [`NotifyRecommendationsReceivedError`](crate::model::NotifyRecommendationsReceivedError)
    pub fn builder() -> crate::model::notify_recommendations_received_error::Builder {
        crate::model::notify_recommendations_received_error::Builder::default()
    }
}

/// <p>A recommendation trigger provides context on the event that produced the referenced recommendations. Recommendations are only referenced in <code>recommendationIds</code> by a single RecommendationTrigger.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationTrigger {
    /// <p>The identifier of the recommendation trigger.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of recommendation trigger.</p>
    pub r#type: std::option::Option<crate::model::RecommendationTriggerType>,
    /// <p>The source of the recommendation trigger.</p>
    /// <ul>
    /// <li> <p>ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.</p> </li>
    /// <li> <p>RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.</p> </li>
    /// </ul>
    pub source: std::option::Option<crate::model::RecommendationSourceType>,
    /// <p>A union type containing information related to the trigger.</p>
    pub data: std::option::Option<crate::model::RecommendationTriggerData>,
    /// <p>The identifiers of the recommendations.</p>
    pub recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RecommendationTrigger {
    /// <p>The identifier of the recommendation trigger.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of recommendation trigger.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RecommendationTriggerType> {
        self.r#type.as_ref()
    }
    /// <p>The source of the recommendation trigger.</p>
    /// <ul>
    /// <li> <p>ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.</p> </li>
    /// <li> <p>RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.</p> </li>
    /// </ul>
    pub fn source(&self) -> std::option::Option<&crate::model::RecommendationSourceType> {
        self.source.as_ref()
    }
    /// <p>A union type containing information related to the trigger.</p>
    pub fn data(&self) -> std::option::Option<&crate::model::RecommendationTriggerData> {
        self.data.as_ref()
    }
    /// <p>The identifiers of the recommendations.</p>
    pub fn recommendation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.recommendation_ids.as_deref()
    }
}
impl std::fmt::Debug for RecommendationTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationTrigger");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("source", &self.source);
        formatter.field("data", &self.data);
        formatter.field("recommendation_ids", &self.recommendation_ids);
        formatter.finish()
    }
}
/// See [`RecommendationTrigger`](crate::model::RecommendationTrigger)
pub mod recommendation_trigger {
    /// A builder for [`RecommendationTrigger`](crate::model::RecommendationTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::RecommendationTriggerType>,
        pub(crate) source: std::option::Option<crate::model::RecommendationSourceType>,
        pub(crate) data: std::option::Option<crate::model::RecommendationTriggerData>,
        pub(crate) recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the recommendation trigger.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the recommendation trigger.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of recommendation trigger.</p>
        pub fn r#type(mut self, input: crate::model::RecommendationTriggerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of recommendation trigger.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RecommendationTriggerType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The source of the recommendation trigger.</p>
        /// <ul>
        /// <li> <p>ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.</p> </li>
        /// <li> <p>RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.</p> </li>
        /// </ul>
        pub fn source(mut self, input: crate::model::RecommendationSourceType) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The source of the recommendation trigger.</p>
        /// <ul>
        /// <li> <p>ISSUE_DETECTION: The corresponding recommendations were triggered by a Contact Lens issue.</p> </li>
        /// <li> <p>RULE_EVALUATION: The corresponding recommendations were triggered by a Contact Lens rule.</p> </li>
        /// </ul>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::RecommendationSourceType>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>A union type containing information related to the trigger.</p>
        pub fn data(mut self, input: crate::model::RecommendationTriggerData) -> Self {
            self.data = Some(input);
            self
        }
        /// <p>A union type containing information related to the trigger.</p>
        pub fn set_data(
            mut self,
            input: std::option::Option<crate::model::RecommendationTriggerData>,
        ) -> Self {
            self.data = input;
            self
        }
        /// Appends an item to `recommendation_ids`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>The identifiers of the recommendations.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommendation_ids.unwrap_or_default();
            v.push(input.into());
            self.recommendation_ids = Some(v);
            self
        }
        /// <p>The identifiers of the recommendations.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommendation_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationTrigger`](crate::model::RecommendationTrigger)
        pub fn build(self) -> crate::model::RecommendationTrigger {
            crate::model::RecommendationTrigger {
                id: self.id,
                r#type: self.r#type,
                source: self.source,
                data: self.data,
                recommendation_ids: self.recommendation_ids,
            }
        }
    }
}
impl RecommendationTrigger {
    /// Creates a new builder-style object to manufacture [`RecommendationTrigger`](crate::model::RecommendationTrigger)
    pub fn builder() -> crate::model::recommendation_trigger::Builder {
        crate::model::recommendation_trigger::Builder::default()
    }
}

/// <p>A union type containing information related to the trigger.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum RecommendationTriggerData {
    /// <p>Data associated with the QUERY RecommendationTriggerType.</p>
    Query(crate::model::QueryRecommendationTriggerData),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl RecommendationTriggerData {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`Query`](crate::model::RecommendationTriggerData::Query), extracting the inner [`QueryRecommendationTriggerData`](crate::model::QueryRecommendationTriggerData).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_query(
        &self,
    ) -> std::result::Result<&crate::model::QueryRecommendationTriggerData, &Self> {
        if let RecommendationTriggerData::Query(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Query`](crate::model::RecommendationTriggerData::Query).
    pub fn is_query(&self) -> bool {
        self.as_query().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Data associated with the QUERY RecommendationTriggerType.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryRecommendationTriggerData {
    /// <p>The text associated with the recommendation trigger.</p>
    pub text: std::option::Option<std::string::String>,
}
impl QueryRecommendationTriggerData {
    /// <p>The text associated with the recommendation trigger.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
}
impl std::fmt::Debug for QueryRecommendationTriggerData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryRecommendationTriggerData");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`QueryRecommendationTriggerData`](crate::model::QueryRecommendationTriggerData)
pub mod query_recommendation_trigger_data {
    /// A builder for [`QueryRecommendationTriggerData`](crate::model::QueryRecommendationTriggerData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text associated with the recommendation trigger.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text associated with the recommendation trigger.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryRecommendationTriggerData`](crate::model::QueryRecommendationTriggerData)
        pub fn build(self) -> crate::model::QueryRecommendationTriggerData {
            crate::model::QueryRecommendationTriggerData { text: self.text }
        }
    }
}
impl QueryRecommendationTriggerData {
    /// Creates a new builder-style object to manufacture [`QueryRecommendationTriggerData`](crate::model::QueryRecommendationTriggerData)
    pub fn builder() -> crate::model::query_recommendation_trigger_data::Builder {
        crate::model::query_recommendation_trigger_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationSourceType {
    #[allow(missing_docs)] // documentation missing in model
    IssueDetection,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    RuleEvaluation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ISSUE_DETECTION" => RecommendationSourceType::IssueDetection,
            "OTHER" => RecommendationSourceType::Other,
            "RULE_EVALUATION" => RecommendationSourceType::RuleEvaluation,
            other => RecommendationSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationSourceType::from(s))
    }
}
impl RecommendationSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationSourceType::IssueDetection => "ISSUE_DETECTION",
            RecommendationSourceType::Other => "OTHER",
            RecommendationSourceType::RuleEvaluation => "RULE_EVALUATION",
            RecommendationSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ISSUE_DETECTION", "OTHER", "RULE_EVALUATION"]
    }
}
impl AsRef<str> for RecommendationSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationTriggerType {
    #[allow(missing_docs)] // documentation missing in model
    Query,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationTriggerType {
    fn from(s: &str) -> Self {
        match s {
            "QUERY" => RecommendationTriggerType::Query,
            other => RecommendationTriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationTriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationTriggerType::from(s))
    }
}
impl RecommendationTriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationTriggerType::Query => "QUERY",
            RecommendationTriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["QUERY"]
    }
}
impl AsRef<str> for RecommendationTriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationData {
    /// <p>The identifier of the recommendation.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The recommended document.</p>
    pub document: std::option::Option<crate::model::Document>,
    /// <p>The relevance score of the recommendation.</p>
    pub relevance_score: f64,
    /// <p>The relevance level of the recommendation.</p>
    pub relevance_level: std::option::Option<crate::model::RelevanceLevel>,
    /// <p>The type of recommendation.</p>
    pub r#type: std::option::Option<crate::model::RecommendationType>,
}
impl RecommendationData {
    /// <p>The identifier of the recommendation.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The recommended document.</p>
    pub fn document(&self) -> std::option::Option<&crate::model::Document> {
        self.document.as_ref()
    }
    /// <p>The relevance score of the recommendation.</p>
    pub fn relevance_score(&self) -> f64 {
        self.relevance_score
    }
    /// <p>The relevance level of the recommendation.</p>
    pub fn relevance_level(&self) -> std::option::Option<&crate::model::RelevanceLevel> {
        self.relevance_level.as_ref()
    }
    /// <p>The type of recommendation.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RecommendationType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for RecommendationData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationData");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("document", &self.document);
        formatter.field("relevance_score", &self.relevance_score);
        formatter.field("relevance_level", &self.relevance_level);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RecommendationData`](crate::model::RecommendationData)
pub mod recommendation_data {
    /// A builder for [`RecommendationData`](crate::model::RecommendationData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<crate::model::Document>,
        pub(crate) relevance_score: std::option::Option<f64>,
        pub(crate) relevance_level: std::option::Option<crate::model::RelevanceLevel>,
        pub(crate) r#type: std::option::Option<crate::model::RecommendationType>,
    }
    impl Builder {
        /// <p>The identifier of the recommendation.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the recommendation.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The recommended document.</p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.document = Some(input);
            self
        }
        /// <p>The recommended document.</p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.document = input;
            self
        }
        /// <p>The relevance score of the recommendation.</p>
        pub fn relevance_score(mut self, input: f64) -> Self {
            self.relevance_score = Some(input);
            self
        }
        /// <p>The relevance score of the recommendation.</p>
        pub fn set_relevance_score(mut self, input: std::option::Option<f64>) -> Self {
            self.relevance_score = input;
            self
        }
        /// <p>The relevance level of the recommendation.</p>
        pub fn relevance_level(mut self, input: crate::model::RelevanceLevel) -> Self {
            self.relevance_level = Some(input);
            self
        }
        /// <p>The relevance level of the recommendation.</p>
        pub fn set_relevance_level(
            mut self,
            input: std::option::Option<crate::model::RelevanceLevel>,
        ) -> Self {
            self.relevance_level = input;
            self
        }
        /// <p>The type of recommendation.</p>
        pub fn r#type(mut self, input: crate::model::RecommendationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of recommendation.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RecommendationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationData`](crate::model::RecommendationData)
        pub fn build(self) -> crate::model::RecommendationData {
            crate::model::RecommendationData {
                recommendation_id: self.recommendation_id,
                document: self.document,
                relevance_score: self.relevance_score.unwrap_or_default(),
                relevance_level: self.relevance_level,
                r#type: self.r#type,
            }
        }
    }
}
impl RecommendationData {
    /// Creates a new builder-style object to manufacture [`RecommendationData`](crate::model::RecommendationData)
    pub fn builder() -> crate::model::recommendation_data::Builder {
        crate::model::recommendation_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationType {
    #[allow(missing_docs)] // documentation missing in model
    KnowledgeContent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationType {
    fn from(s: &str) -> Self {
        match s {
            "KNOWLEDGE_CONTENT" => RecommendationType::KnowledgeContent,
            other => RecommendationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationType::from(s))
    }
}
impl RecommendationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationType::KnowledgeContent => "KNOWLEDGE_CONTENT",
            RecommendationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KNOWLEDGE_CONTENT"]
    }
}
impl AsRef<str> for RecommendationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelevanceLevel {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelevanceLevel {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => RelevanceLevel::High,
            "LOW" => RelevanceLevel::Low,
            "MEDIUM" => RelevanceLevel::Medium,
            other => RelevanceLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelevanceLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelevanceLevel::from(s))
    }
}
impl RelevanceLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelevanceLevel::High => "HIGH",
            RelevanceLevel::Low => "LOW",
            RelevanceLevel::Medium => "MEDIUM",
            RelevanceLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for RelevanceLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about the assistant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssistantSummary {
    /// <p>The identifier of the Wisdom assistant.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub assistant_arn: std::option::Option<std::string::String>,
    /// <p>The name of the assistant.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the assistant.</p>
    pub r#type: std::option::Option<crate::model::AssistantType>,
    /// <p>The status of the assistant.</p>
    pub status: std::option::Option<crate::model::AssistantStatus>,
    /// <p>The description of the assistant.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The KMS key used for encryption.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
}
impl AssistantSummary {
    /// <p>The identifier of the Wisdom assistant.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub fn assistant_arn(&self) -> std::option::Option<&str> {
        self.assistant_arn.as_deref()
    }
    /// <p>The name of the assistant.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the assistant.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AssistantType> {
        self.r#type.as_ref()
    }
    /// <p>The status of the assistant.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AssistantStatus> {
        self.status.as_ref()
    }
    /// <p>The description of the assistant.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The KMS key used for encryption.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
}
impl std::fmt::Debug for AssistantSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssistantSummary");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("assistant_arn", &self.assistant_arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.finish()
    }
}
/// See [`AssistantSummary`](crate::model::AssistantSummary)
pub mod assistant_summary {
    /// A builder for [`AssistantSummary`](crate::model::AssistantSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) assistant_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AssistantType>,
        pub(crate) status: std::option::Option<crate::model::AssistantStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn assistant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn set_assistant_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_arn = input;
            self
        }
        /// <p>The name of the assistant.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the assistant.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the assistant.</p>
        pub fn r#type(mut self, input: crate::model::AssistantType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the assistant.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AssistantType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The status of the assistant.</p>
        pub fn status(mut self, input: crate::model::AssistantStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the assistant.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssistantStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description of the assistant.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the assistant.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AssistantSummary`](crate::model::AssistantSummary)
        pub fn build(self) -> crate::model::AssistantSummary {
            crate::model::AssistantSummary {
                assistant_id: self.assistant_id,
                assistant_arn: self.assistant_arn,
                name: self.name,
                r#type: self.r#type,
                status: self.status,
                description: self.description,
                tags: self.tags,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
            }
        }
    }
}
impl AssistantSummary {
    /// Creates a new builder-style object to manufacture [`AssistantSummary`](crate::model::AssistantSummary)
    pub fn builder() -> crate::model::assistant_summary::Builder {
        crate::model::assistant_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssistantStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssistantStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AssistantStatus::Active,
            "CREATE_FAILED" => AssistantStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => AssistantStatus::CreateInProgress,
            "DELETED" => AssistantStatus::Deleted,
            "DELETE_FAILED" => AssistantStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => AssistantStatus::DeleteInProgress,
            other => AssistantStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssistantStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssistantStatus::from(s))
    }
}
impl AssistantStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssistantStatus::Active => "ACTIVE",
            AssistantStatus::CreateFailed => "CREATE_FAILED",
            AssistantStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            AssistantStatus::Deleted => "DELETED",
            AssistantStatus::DeleteFailed => "DELETE_FAILED",
            AssistantStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            AssistantStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETED",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for AssistantStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssistantType {
    #[allow(missing_docs)] // documentation missing in model
    Agent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssistantType {
    fn from(s: &str) -> Self {
        match s {
            "AGENT" => AssistantType::Agent,
            other => AssistantType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssistantType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssistantType::from(s))
    }
}
impl AssistantType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssistantType::Agent => "AGENT",
            AssistantType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AGENT"]
    }
}
impl AsRef<str> for AssistantType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The assistant data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssistantData {
    /// <p>The identifier of the Wisdom assistant.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub assistant_arn: std::option::Option<std::string::String>,
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of assistant.</p>
    pub r#type: std::option::Option<crate::model::AssistantType>,
    /// <p>The status of the assistant.</p>
    pub status: std::option::Option<crate::model::AssistantStatus>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The KMS key used for encryption.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
}
impl AssistantData {
    /// <p>The identifier of the Wisdom assistant.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub fn assistant_arn(&self) -> std::option::Option<&str> {
        self.assistant_arn.as_deref()
    }
    /// <p>The name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of assistant.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AssistantType> {
        self.r#type.as_ref()
    }
    /// <p>The status of the assistant.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AssistantStatus> {
        self.status.as_ref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The KMS key used for encryption.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
}
impl std::fmt::Debug for AssistantData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssistantData");
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("assistant_arn", &self.assistant_arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.finish()
    }
}
/// See [`AssistantData`](crate::model::AssistantData)
pub mod assistant_data {
    /// A builder for [`AssistantData`](crate::model::AssistantData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) assistant_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AssistantType>,
        pub(crate) status: std::option::Option<crate::model::AssistantStatus>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    }
    impl Builder {
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn assistant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn set_assistant_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_arn = input;
            self
        }
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of assistant.</p>
        pub fn r#type(mut self, input: crate::model::AssistantType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of assistant.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AssistantType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The status of the assistant.</p>
        pub fn status(mut self, input: crate::model::AssistantStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the assistant.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssistantStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AssistantData`](crate::model::AssistantData)
        pub fn build(self) -> crate::model::AssistantData {
            crate::model::AssistantData {
                assistant_id: self.assistant_id,
                assistant_arn: self.assistant_arn,
                name: self.name,
                r#type: self.r#type,
                status: self.status,
                description: self.description,
                tags: self.tags,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
            }
        }
    }
}
impl AssistantData {
    /// Creates a new builder-style object to manufacture [`AssistantData`](crate::model::AssistantData)
    pub fn builder() -> crate::model::assistant_data::Builder {
        crate::model::assistant_data::Builder::default()
    }
}

/// <p>Information about the session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionData {
    /// <p>The Amazon Resource Name (ARN) of the session.</p>
    pub session_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The name of the session.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the session.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SessionData {
    /// <p>The Amazon Resource Name (ARN) of the session.</p>
    pub fn session_arn(&self) -> std::option::Option<&str> {
        self.session_arn.as_deref()
    }
    /// <p>The identifier of the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The name of the session.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the session.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for SessionData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionData");
        formatter.field("session_arn", &self.session_arn);
        formatter.field("session_id", &self.session_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`SessionData`](crate::model::SessionData)
pub mod session_data {
    /// A builder for [`SessionData`](crate::model::SessionData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_arn: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the session.</p>
        pub fn session_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the session.</p>
        pub fn set_session_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_arn = input;
            self
        }
        /// <p>The identifier of the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The name of the session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the session.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the session.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionData`](crate::model::SessionData)
        pub fn build(self) -> crate::model::SessionData {
            crate::model::SessionData {
                session_arn: self.session_arn,
                session_id: self.session_id,
                name: self.name,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl SessionData {
    /// Creates a new builder-style object to manufacture [`SessionData`](crate::model::SessionData)
    pub fn builder() -> crate::model::session_data::Builder {
        crate::model::session_data::Builder::default()
    }
}

/// <p>Summary information about the assistant association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssistantAssociationSummary {
    /// <p>The identifier of the assistant association.</p>
    pub assistant_association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
    pub assistant_association_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the Wisdom assistant.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub assistant_arn: std::option::Option<std::string::String>,
    /// <p>The type of association.</p>
    pub association_type: std::option::Option<crate::model::AssociationType>,
    /// <p>The association data.</p>
    pub association_data: std::option::Option<crate::model::AssistantAssociationOutputData>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AssistantAssociationSummary {
    /// <p>The identifier of the assistant association.</p>
    pub fn assistant_association_id(&self) -> std::option::Option<&str> {
        self.assistant_association_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
    pub fn assistant_association_arn(&self) -> std::option::Option<&str> {
        self.assistant_association_arn.as_deref()
    }
    /// <p>The identifier of the Wisdom assistant.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub fn assistant_arn(&self) -> std::option::Option<&str> {
        self.assistant_arn.as_deref()
    }
    /// <p>The type of association.</p>
    pub fn association_type(&self) -> std::option::Option<&crate::model::AssociationType> {
        self.association_type.as_ref()
    }
    /// <p>The association data.</p>
    pub fn association_data(
        &self,
    ) -> std::option::Option<&crate::model::AssistantAssociationOutputData> {
        self.association_data.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AssistantAssociationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssistantAssociationSummary");
        formatter.field("assistant_association_id", &self.assistant_association_id);
        formatter.field("assistant_association_arn", &self.assistant_association_arn);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("assistant_arn", &self.assistant_arn);
        formatter.field("association_type", &self.association_type);
        formatter.field("association_data", &self.association_data);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AssistantAssociationSummary`](crate::model::AssistantAssociationSummary)
pub mod assistant_association_summary {
    /// A builder for [`AssistantAssociationSummary`](crate::model::AssistantAssociationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association_id: std::option::Option<std::string::String>,
        pub(crate) assistant_association_arn: std::option::Option<std::string::String>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) assistant_arn: std::option::Option<std::string::String>,
        pub(crate) association_type: std::option::Option<crate::model::AssociationType>,
        pub(crate) association_data:
            std::option::Option<crate::model::AssistantAssociationOutputData>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the assistant association.</p>
        pub fn assistant_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the assistant association.</p>
        pub fn set_assistant_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_association_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
        pub fn assistant_association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
        pub fn set_assistant_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_association_arn = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn assistant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn set_assistant_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_arn = input;
            self
        }
        /// <p>The type of association.</p>
        pub fn association_type(mut self, input: crate::model::AssociationType) -> Self {
            self.association_type = Some(input);
            self
        }
        /// <p>The type of association.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationType>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// <p>The association data.</p>
        pub fn association_data(
            mut self,
            input: crate::model::AssistantAssociationOutputData,
        ) -> Self {
            self.association_data = Some(input);
            self
        }
        /// <p>The association data.</p>
        pub fn set_association_data(
            mut self,
            input: std::option::Option<crate::model::AssistantAssociationOutputData>,
        ) -> Self {
            self.association_data = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AssistantAssociationSummary`](crate::model::AssistantAssociationSummary)
        pub fn build(self) -> crate::model::AssistantAssociationSummary {
            crate::model::AssistantAssociationSummary {
                assistant_association_id: self.assistant_association_id,
                assistant_association_arn: self.assistant_association_arn,
                assistant_id: self.assistant_id,
                assistant_arn: self.assistant_arn,
                association_type: self.association_type,
                association_data: self.association_data,
                tags: self.tags,
            }
        }
    }
}
impl AssistantAssociationSummary {
    /// Creates a new builder-style object to manufacture [`AssistantAssociationSummary`](crate::model::AssistantAssociationSummary)
    pub fn builder() -> crate::model::assistant_association_summary::Builder {
        crate::model::assistant_association_summary::Builder::default()
    }
}

/// <p>The data that is output as a result of the assistant association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AssistantAssociationOutputData {
    /// <p>The knowledge base where output data is sent.</p>
    KnowledgeBaseAssociation(crate::model::KnowledgeBaseAssociationData),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AssistantAssociationOutputData {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`KnowledgeBaseAssociation`](crate::model::AssistantAssociationOutputData::KnowledgeBaseAssociation), extracting the inner [`KnowledgeBaseAssociationData`](crate::model::KnowledgeBaseAssociationData).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_knowledge_base_association(
        &self,
    ) -> std::result::Result<&crate::model::KnowledgeBaseAssociationData, &Self> {
        if let AssistantAssociationOutputData::KnowledgeBaseAssociation(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`KnowledgeBaseAssociation`](crate::model::AssistantAssociationOutputData::KnowledgeBaseAssociation).
    pub fn is_knowledge_base_association(&self) -> bool {
        self.as_knowledge_base_association().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Association information about the knowledge base.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KnowledgeBaseAssociationData {
    /// <p>The identifier of the knowledge base.</p>
    pub knowledge_base_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub knowledge_base_arn: std::option::Option<std::string::String>,
}
impl KnowledgeBaseAssociationData {
    /// <p>The identifier of the knowledge base.</p>
    pub fn knowledge_base_id(&self) -> std::option::Option<&str> {
        self.knowledge_base_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
    pub fn knowledge_base_arn(&self) -> std::option::Option<&str> {
        self.knowledge_base_arn.as_deref()
    }
}
impl std::fmt::Debug for KnowledgeBaseAssociationData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KnowledgeBaseAssociationData");
        formatter.field("knowledge_base_id", &self.knowledge_base_id);
        formatter.field("knowledge_base_arn", &self.knowledge_base_arn);
        formatter.finish()
    }
}
/// See [`KnowledgeBaseAssociationData`](crate::model::KnowledgeBaseAssociationData)
pub mod knowledge_base_association_data {
    /// A builder for [`KnowledgeBaseAssociationData`](crate::model::KnowledgeBaseAssociationData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) knowledge_base_id: std::option::Option<std::string::String>,
        pub(crate) knowledge_base_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the knowledge base.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_id = Some(input.into());
            self
        }
        /// <p>The identifier of the knowledge base.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn knowledge_base_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.knowledge_base_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
        pub fn set_knowledge_base_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.knowledge_base_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KnowledgeBaseAssociationData`](crate::model::KnowledgeBaseAssociationData)
        pub fn build(self) -> crate::model::KnowledgeBaseAssociationData {
            crate::model::KnowledgeBaseAssociationData {
                knowledge_base_id: self.knowledge_base_id,
                knowledge_base_arn: self.knowledge_base_arn,
            }
        }
    }
}
impl KnowledgeBaseAssociationData {
    /// Creates a new builder-style object to manufacture [`KnowledgeBaseAssociationData`](crate::model::KnowledgeBaseAssociationData)
    pub fn builder() -> crate::model::knowledge_base_association_data::Builder {
        crate::model::knowledge_base_association_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssociationType {
    #[allow(missing_docs)] // documentation missing in model
    KnowledgeBase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssociationType {
    fn from(s: &str) -> Self {
        match s {
            "KNOWLEDGE_BASE" => AssociationType::KnowledgeBase,
            other => AssociationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssociationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssociationType::from(s))
    }
}
impl AssociationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssociationType::KnowledgeBase => "KNOWLEDGE_BASE",
            AssociationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KNOWLEDGE_BASE"]
    }
}
impl AsRef<str> for AssociationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the assistant association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssistantAssociationData {
    /// <p>The identifier of the assistant association.</p>
    pub assistant_association_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
    pub assistant_association_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the Wisdom assistant.</p>
    pub assistant_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub assistant_arn: std::option::Option<std::string::String>,
    /// <p>The type of association.</p>
    pub association_type: std::option::Option<crate::model::AssociationType>,
    /// <p>A union type that currently has a single argument, the knowledge base ID.</p>
    pub association_data: std::option::Option<crate::model::AssistantAssociationOutputData>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AssistantAssociationData {
    /// <p>The identifier of the assistant association.</p>
    pub fn assistant_association_id(&self) -> std::option::Option<&str> {
        self.assistant_association_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
    pub fn assistant_association_arn(&self) -> std::option::Option<&str> {
        self.assistant_association_arn.as_deref()
    }
    /// <p>The identifier of the Wisdom assistant.</p>
    pub fn assistant_id(&self) -> std::option::Option<&str> {
        self.assistant_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
    pub fn assistant_arn(&self) -> std::option::Option<&str> {
        self.assistant_arn.as_deref()
    }
    /// <p>The type of association.</p>
    pub fn association_type(&self) -> std::option::Option<&crate::model::AssociationType> {
        self.association_type.as_ref()
    }
    /// <p>A union type that currently has a single argument, the knowledge base ID.</p>
    pub fn association_data(
        &self,
    ) -> std::option::Option<&crate::model::AssistantAssociationOutputData> {
        self.association_data.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AssistantAssociationData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssistantAssociationData");
        formatter.field("assistant_association_id", &self.assistant_association_id);
        formatter.field("assistant_association_arn", &self.assistant_association_arn);
        formatter.field("assistant_id", &self.assistant_id);
        formatter.field("assistant_arn", &self.assistant_arn);
        formatter.field("association_type", &self.association_type);
        formatter.field("association_data", &self.association_data);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AssistantAssociationData`](crate::model::AssistantAssociationData)
pub mod assistant_association_data {
    /// A builder for [`AssistantAssociationData`](crate::model::AssistantAssociationData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assistant_association_id: std::option::Option<std::string::String>,
        pub(crate) assistant_association_arn: std::option::Option<std::string::String>,
        pub(crate) assistant_id: std::option::Option<std::string::String>,
        pub(crate) assistant_arn: std::option::Option<std::string::String>,
        pub(crate) association_type: std::option::Option<crate::model::AssociationType>,
        pub(crate) association_data:
            std::option::Option<crate::model::AssistantAssociationOutputData>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the assistant association.</p>
        pub fn assistant_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the assistant association.</p>
        pub fn set_assistant_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_association_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
        pub fn assistant_association_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_association_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assistant association.</p>
        pub fn set_assistant_association_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_association_arn = input;
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.assistant_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn assistant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assistant_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Wisdom assistant.</p>
        pub fn set_assistant_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assistant_arn = input;
            self
        }
        /// <p>The type of association.</p>
        pub fn association_type(mut self, input: crate::model::AssociationType) -> Self {
            self.association_type = Some(input);
            self
        }
        /// <p>The type of association.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationType>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// <p>A union type that currently has a single argument, the knowledge base ID.</p>
        pub fn association_data(
            mut self,
            input: crate::model::AssistantAssociationOutputData,
        ) -> Self {
            self.association_data = Some(input);
            self
        }
        /// <p>A union type that currently has a single argument, the knowledge base ID.</p>
        pub fn set_association_data(
            mut self,
            input: std::option::Option<crate::model::AssistantAssociationOutputData>,
        ) -> Self {
            self.association_data = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AssistantAssociationData`](crate::model::AssistantAssociationData)
        pub fn build(self) -> crate::model::AssistantAssociationData {
            crate::model::AssistantAssociationData {
                assistant_association_id: self.assistant_association_id,
                assistant_association_arn: self.assistant_association_arn,
                assistant_id: self.assistant_id,
                assistant_arn: self.assistant_arn,
                association_type: self.association_type,
                association_data: self.association_data,
                tags: self.tags,
            }
        }
    }
}
impl AssistantAssociationData {
    /// Creates a new builder-style object to manufacture [`AssistantAssociationData`](crate::model::AssistantAssociationData)
    pub fn builder() -> crate::model::assistant_association_data::Builder {
        crate::model::assistant_association_data::Builder::default()
    }
}

/// <p>The data that is input into Wisdom as a result of the assistant association.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AssistantAssociationInputData {
    /// <p>The identifier of the knowledge base.</p>
    KnowledgeBaseId(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AssistantAssociationInputData {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`KnowledgeBaseId`](crate::model::AssistantAssociationInputData::KnowledgeBaseId), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_knowledge_base_id(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AssistantAssociationInputData::KnowledgeBaseId(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`KnowledgeBaseId`](crate::model::AssistantAssociationInputData::KnowledgeBaseId).
    pub fn is_knowledge_base_id(&self) -> bool {
        self.as_knowledge_base_id().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
