// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Connect Wisdom Service
///
/// Client for invoking operations on Amazon Connect Wisdom Service. Each operation on Amazon Connect Wisdom Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_wisdom::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_wisdom::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_wisdom::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAssistant`](crate::client::fluent_builders::CreateAssistant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAssistant::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAssistant::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAssistant::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAssistant::set_name): <p>The name of the assistant.</p>
    ///   - [`r#type(AssistantType)`](crate::client::fluent_builders::CreateAssistant::type) / [`set_type(Option<AssistantType>)`](crate::client::fluent_builders::CreateAssistant::set_type): <p>The type of assistant.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAssistant::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAssistant::set_description): <p>The description of the assistant.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAssistant::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAssistant::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    ///   - [`server_side_encryption_configuration(ServerSideEncryptionConfiguration)`](crate::client::fluent_builders::CreateAssistant::server_side_encryption_configuration) / [`set_server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::client::fluent_builders::CreateAssistant::set_server_side_encryption_configuration): <p>The KMS key used for encryption.</p>
    /// - On success, responds with [`CreateAssistantOutput`](crate::output::CreateAssistantOutput) with field(s):
    ///   - [`assistant(Option<AssistantData>)`](crate::output::CreateAssistantOutput::assistant): <p>Information about the assistant.</p>
    /// - On failure, responds with [`SdkError<CreateAssistantError>`](crate::error::CreateAssistantError)
    pub fn create_assistant(&self) -> fluent_builders::CreateAssistant {
        fluent_builders::CreateAssistant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssistantAssociation`](crate::client::fluent_builders::CreateAssistantAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::CreateAssistantAssociation::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::CreateAssistantAssociation::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`association_type(AssociationType)`](crate::client::fluent_builders::CreateAssistantAssociation::association_type) / [`set_association_type(Option<AssociationType>)`](crate::client::fluent_builders::CreateAssistantAssociation::set_association_type): <p>The type of association.</p>
    ///   - [`association(AssistantAssociationInputData)`](crate::client::fluent_builders::CreateAssistantAssociation::association) / [`set_association(Option<AssistantAssociationInputData>)`](crate::client::fluent_builders::CreateAssistantAssociation::set_association): <p>The identifier of the associated resource.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAssistantAssociation::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAssistantAssociation::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAssistantAssociation::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAssistantAssociation::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateAssistantAssociationOutput`](crate::output::CreateAssistantAssociationOutput) with field(s):
    ///   - [`assistant_association(Option<AssistantAssociationData>)`](crate::output::CreateAssistantAssociationOutput::assistant_association): <p>The assistant association.</p>
    /// - On failure, responds with [`SdkError<CreateAssistantAssociationError>`](crate::error::CreateAssistantAssociationError)
    pub fn create_assistant_association(&self) -> fluent_builders::CreateAssistantAssociation {
        fluent_builders::CreateAssistantAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContent`](crate::client::fluent_builders::CreateContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::CreateContent::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::CreateContent::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateContent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateContent::set_name): <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::CreateContent::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::CreateContent::set_title): <p>The title of the content. If not set, the title is equal to the name.</p>
    ///   - [`override_link_out_uri(impl Into<String>)`](crate::client::fluent_builders::CreateContent::override_link_out_uri) / [`set_override_link_out_uri(Option<String>)`](crate::client::fluent_builders::CreateContent::set_override_link_out_uri): <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::CreateContent::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateContent::set_metadata): <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::CreateContent::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::CreateContent::set_upload_id): <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateContent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateContent::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateContent::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateContent::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateContentOutput`](crate::output::CreateContentOutput) with field(s):
    ///   - [`content(Option<ContentData>)`](crate::output::CreateContentOutput::content): <p>The content.</p>
    /// - On failure, responds with [`SdkError<CreateContentError>`](crate::error::CreateContentError)
    pub fn create_content(&self) -> fluent_builders::CreateContent {
        fluent_builders::CreateContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateKnowledgeBase`](crate::client::fluent_builders::CreateKnowledgeBase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateKnowledgeBase::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateKnowledgeBase::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_name): <p>The name of the knowledge base.</p>
    ///   - [`knowledge_base_type(KnowledgeBaseType)`](crate::client::fluent_builders::CreateKnowledgeBase::knowledge_base_type) / [`set_knowledge_base_type(Option<KnowledgeBaseType>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_knowledge_base_type): <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
    ///   - [`source_configuration(SourceConfiguration)`](crate::client::fluent_builders::CreateKnowledgeBase::source_configuration) / [`set_source_configuration(Option<SourceConfiguration>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_source_configuration): <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
    ///   - [`rendering_configuration(RenderingConfiguration)`](crate::client::fluent_builders::CreateKnowledgeBase::rendering_configuration) / [`set_rendering_configuration(Option<RenderingConfiguration>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_rendering_configuration): <p>Information about how to render the content.</p>
    ///   - [`server_side_encryption_configuration(ServerSideEncryptionConfiguration)`](crate::client::fluent_builders::CreateKnowledgeBase::server_side_encryption_configuration) / [`set_server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_server_side_encryption_configuration): <p>The KMS key used for encryption.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateKnowledgeBase::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_description): <p>The description.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateKnowledgeBase::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateKnowledgeBase::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateKnowledgeBaseOutput`](crate::output::CreateKnowledgeBaseOutput) with field(s):
    ///   - [`knowledge_base(Option<KnowledgeBaseData>)`](crate::output::CreateKnowledgeBaseOutput::knowledge_base): <p>The knowledge base.</p>
    /// - On failure, responds with [`SdkError<CreateKnowledgeBaseError>`](crate::error::CreateKnowledgeBaseError)
    pub fn create_knowledge_base(&self) -> fluent_builders::CreateKnowledgeBase {
        fluent_builders::CreateKnowledgeBase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSession`](crate::client::fluent_builders::CreateSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateSession::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateSession::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::CreateSession::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::CreateSession::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSession::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSession::set_name): <p>The name of the session.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSession::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSession::set_description): <p>The description.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateSession::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSession::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateSessionOutput`](crate::output::CreateSessionOutput) with field(s):
    ///   - [`session(Option<SessionData>)`](crate::output::CreateSessionOutput::session): <p>The session.</p>
    /// - On failure, responds with [`SdkError<CreateSessionError>`](crate::error::CreateSessionError)
    pub fn create_session(&self) -> fluent_builders::CreateSession {
        fluent_builders::CreateSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssistant`](crate::client::fluent_builders::DeleteAssistant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssistant::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::DeleteAssistant::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`DeleteAssistantOutput`](crate::output::DeleteAssistantOutput)

    /// - On failure, responds with [`SdkError<DeleteAssistantError>`](crate::error::DeleteAssistantError)
    pub fn delete_assistant(&self) -> fluent_builders::DeleteAssistant {
        fluent_builders::DeleteAssistant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssistantAssociation`](crate::client::fluent_builders::DeleteAssistantAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssistantAssociation::assistant_association_id) / [`set_assistant_association_id(Option<String>)`](crate::client::fluent_builders::DeleteAssistantAssociation::set_assistant_association_id): <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssistantAssociation::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::DeleteAssistantAssociation::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`DeleteAssistantAssociationOutput`](crate::output::DeleteAssistantAssociationOutput)

    /// - On failure, responds with [`SdkError<DeleteAssistantAssociationError>`](crate::error::DeleteAssistantAssociationError)
    pub fn delete_assistant_association(&self) -> fluent_builders::DeleteAssistantAssociation {
        fluent_builders::DeleteAssistantAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContent`](crate::client::fluent_builders::DeleteContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContent::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::DeleteContent::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`content_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContent::content_id) / [`set_content_id(Option<String>)`](crate::client::fluent_builders::DeleteContent::set_content_id): <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`DeleteContentOutput`](crate::output::DeleteContentOutput)

    /// - On failure, responds with [`SdkError<DeleteContentError>`](crate::error::DeleteContentError)
    pub fn delete_content(&self) -> fluent_builders::DeleteContent {
        fluent_builders::DeleteContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteKnowledgeBase`](crate::client::fluent_builders::DeleteKnowledgeBase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::DeleteKnowledgeBase::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::DeleteKnowledgeBase::set_knowledge_base_id): <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`DeleteKnowledgeBaseOutput`](crate::output::DeleteKnowledgeBaseOutput)

    /// - On failure, responds with [`SdkError<DeleteKnowledgeBaseError>`](crate::error::DeleteKnowledgeBaseError)
    pub fn delete_knowledge_base(&self) -> fluent_builders::DeleteKnowledgeBase {
        fluent_builders::DeleteKnowledgeBase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssistant`](crate::client::fluent_builders::GetAssistant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::GetAssistant::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::GetAssistant::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`GetAssistantOutput`](crate::output::GetAssistantOutput) with field(s):
    ///   - [`assistant(Option<AssistantData>)`](crate::output::GetAssistantOutput::assistant): <p>Information about the assistant.</p>
    /// - On failure, responds with [`SdkError<GetAssistantError>`](crate::error::GetAssistantError)
    pub fn get_assistant(&self) -> fluent_builders::GetAssistant {
        fluent_builders::GetAssistant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssistantAssociation`](crate::client::fluent_builders::GetAssistantAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_association_id(impl Into<String>)`](crate::client::fluent_builders::GetAssistantAssociation::assistant_association_id) / [`set_assistant_association_id(Option<String>)`](crate::client::fluent_builders::GetAssistantAssociation::set_assistant_association_id): <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::GetAssistantAssociation::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::GetAssistantAssociation::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`GetAssistantAssociationOutput`](crate::output::GetAssistantAssociationOutput) with field(s):
    ///   - [`assistant_association(Option<AssistantAssociationData>)`](crate::output::GetAssistantAssociationOutput::assistant_association): <p>The assistant association.</p>
    /// - On failure, responds with [`SdkError<GetAssistantAssociationError>`](crate::error::GetAssistantAssociationError)
    pub fn get_assistant_association(&self) -> fluent_builders::GetAssistantAssociation {
        fluent_builders::GetAssistantAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContent`](crate::client::fluent_builders::GetContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`content_id(impl Into<String>)`](crate::client::fluent_builders::GetContent::content_id) / [`set_content_id(Option<String>)`](crate::client::fluent_builders::GetContent::set_content_id): <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::GetContent::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::GetContent::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`GetContentOutput`](crate::output::GetContentOutput) with field(s):
    ///   - [`content(Option<ContentData>)`](crate::output::GetContentOutput::content): <p>The content.</p>
    /// - On failure, responds with [`SdkError<GetContentError>`](crate::error::GetContentError)
    pub fn get_content(&self) -> fluent_builders::GetContent {
        fluent_builders::GetContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContentSummary`](crate::client::fluent_builders::GetContentSummary) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`content_id(impl Into<String>)`](crate::client::fluent_builders::GetContentSummary::content_id) / [`set_content_id(Option<String>)`](crate::client::fluent_builders::GetContentSummary::set_content_id): <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::GetContentSummary::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::GetContentSummary::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`GetContentSummaryOutput`](crate::output::GetContentSummaryOutput) with field(s):
    ///   - [`content_summary(Option<ContentSummary>)`](crate::output::GetContentSummaryOutput::content_summary): <p>The content summary.</p>
    /// - On failure, responds with [`SdkError<GetContentSummaryError>`](crate::error::GetContentSummaryError)
    pub fn get_content_summary(&self) -> fluent_builders::GetContentSummary {
        fluent_builders::GetContentSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetKnowledgeBase`](crate::client::fluent_builders::GetKnowledgeBase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::GetKnowledgeBase::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::GetKnowledgeBase::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`GetKnowledgeBaseOutput`](crate::output::GetKnowledgeBaseOutput) with field(s):
    ///   - [`knowledge_base(Option<KnowledgeBaseData>)`](crate::output::GetKnowledgeBaseOutput::knowledge_base): <p>The knowledge base.</p>
    /// - On failure, responds with [`SdkError<GetKnowledgeBaseError>`](crate::error::GetKnowledgeBaseError)
    pub fn get_knowledge_base(&self) -> fluent_builders::GetKnowledgeBase {
        fluent_builders::GetKnowledgeBase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecommendations`](crate::client::fluent_builders::GetRecommendations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::GetRecommendations::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::GetRecommendations::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::GetRecommendations::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::GetRecommendations::set_session_id): <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetRecommendations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetRecommendations::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`wait_time_seconds(i32)`](crate::client::fluent_builders::GetRecommendations::wait_time_seconds) / [`set_wait_time_seconds(i32)`](crate::client::fluent_builders::GetRecommendations::set_wait_time_seconds): <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
    /// - On success, responds with [`GetRecommendationsOutput`](crate::output::GetRecommendationsOutput) with field(s):
    ///   - [`recommendations(Option<Vec<RecommendationData>>)`](crate::output::GetRecommendationsOutput::recommendations): <p>The recommendations.</p>
    ///   - [`triggers(Option<Vec<RecommendationTrigger>>)`](crate::output::GetRecommendationsOutput::triggers): <p>The triggers corresponding to recommendations.</p>
    /// - On failure, responds with [`SdkError<GetRecommendationsError>`](crate::error::GetRecommendationsError)
    pub fn get_recommendations(&self) -> fluent_builders::GetRecommendations {
        fluent_builders::GetRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSession`](crate::client::fluent_builders::GetSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::GetSession::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::GetSession::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::GetSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::GetSession::set_session_id): <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`GetSessionOutput`](crate::output::GetSessionOutput) with field(s):
    ///   - [`session(Option<SessionData>)`](crate::output::GetSessionOutput::session): <p>The session.</p>
    /// - On failure, responds with [`SdkError<GetSessionError>`](crate::error::GetSessionError)
    pub fn get_session(&self) -> fluent_builders::GetSession {
        fluent_builders::GetSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssistantAssociations`](crate::client::fluent_builders::ListAssistantAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssistantAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssistantAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssistantAssociations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssistantAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssistantAssociations::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::ListAssistantAssociations::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::ListAssistantAssociations::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`ListAssistantAssociationsOutput`](crate::output::ListAssistantAssociationsOutput) with field(s):
    ///   - [`assistant_association_summaries(Option<Vec<AssistantAssociationSummary>>)`](crate::output::ListAssistantAssociationsOutput::assistant_association_summaries): <p>Summary information about assistant associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssistantAssociationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAssistantAssociationsError>`](crate::error::ListAssistantAssociationsError)
    pub fn list_assistant_associations(&self) -> fluent_builders::ListAssistantAssociations {
        fluent_builders::ListAssistantAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssistants`](crate::client::fluent_builders::ListAssistants) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssistants::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssistants::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssistants::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssistants::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssistants::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListAssistantsOutput`](crate::output::ListAssistantsOutput) with field(s):
    ///   - [`assistant_summaries(Option<Vec<AssistantSummary>>)`](crate::output::ListAssistantsOutput::assistant_summaries): <p>Information about the assistants.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssistantsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAssistantsError>`](crate::error::ListAssistantsError)
    pub fn list_assistants(&self) -> fluent_builders::ListAssistants {
        fluent_builders::ListAssistants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContents`](crate::client::fluent_builders::ListContents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContents::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContents::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::ListContents::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::ListContents::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`ListContentsOutput`](crate::output::ListContentsOutput) with field(s):
    ///   - [`content_summaries(Option<Vec<ContentSummary>>)`](crate::output::ListContentsOutput::content_summaries): <p>Information about the content.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContentsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListContentsError>`](crate::error::ListContentsError)
    pub fn list_contents(&self) -> fluent_builders::ListContents {
        fluent_builders::ListContents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKnowledgeBases`](crate::client::fluent_builders::ListKnowledgeBases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListKnowledgeBases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListKnowledgeBases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListKnowledgeBases::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListKnowledgeBases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListKnowledgeBases::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListKnowledgeBasesOutput`](crate::output::ListKnowledgeBasesOutput) with field(s):
    ///   - [`knowledge_base_summaries(Option<Vec<KnowledgeBaseSummary>>)`](crate::output::ListKnowledgeBasesOutput::knowledge_base_summaries): <p>Information about the knowledge bases.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListKnowledgeBasesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListKnowledgeBasesError>`](crate::error::ListKnowledgeBasesError)
    pub fn list_knowledge_bases(&self) -> fluent_builders::ListKnowledgeBases {
        fluent_builders::ListKnowledgeBases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`NotifyRecommendationsReceived`](crate::client::fluent_builders::NotifyRecommendationsReceived) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::NotifyRecommendationsReceived::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::NotifyRecommendationsReceived::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::NotifyRecommendationsReceived::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::NotifyRecommendationsReceived::set_session_id): <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`recommendation_ids(Vec<String>)`](crate::client::fluent_builders::NotifyRecommendationsReceived::recommendation_ids) / [`set_recommendation_ids(Option<Vec<String>>)`](crate::client::fluent_builders::NotifyRecommendationsReceived::set_recommendation_ids): <p>The identifiers of the recommendations.</p>
    /// - On success, responds with [`NotifyRecommendationsReceivedOutput`](crate::output::NotifyRecommendationsReceivedOutput) with field(s):
    ///   - [`recommendation_ids(Option<Vec<String>>)`](crate::output::NotifyRecommendationsReceivedOutput::recommendation_ids): <p>The identifiers of the recommendations.</p>
    ///   - [`errors(Option<Vec<NotifyRecommendationsReceivedError>>)`](crate::output::NotifyRecommendationsReceivedOutput::errors): <p>The identifiers of recommendations that are causing errors.</p>
    /// - On failure, responds with [`SdkError<NotifyRecommendationsReceivedError>`](crate::error::NotifyRecommendationsReceivedError)
    pub fn notify_recommendations_received(
        &self,
    ) -> fluent_builders::NotifyRecommendationsReceived {
        fluent_builders::NotifyRecommendationsReceived::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`QueryAssistant`](crate::client::fluent_builders::QueryAssistant) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::QueryAssistant::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::QueryAssistant::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::QueryAssistant::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`query_text(impl Into<String>)`](crate::client::fluent_builders::QueryAssistant::query_text) / [`set_query_text(Option<String>)`](crate::client::fluent_builders::QueryAssistant::set_query_text): <p>The text to search for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::QueryAssistant::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::QueryAssistant::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::QueryAssistant::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::QueryAssistant::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`QueryAssistantOutput`](crate::output::QueryAssistantOutput) with field(s):
    ///   - [`results(Option<Vec<ResultData>>)`](crate::output::QueryAssistantOutput::results): <p>The results of the query.</p>
    ///   - [`next_token(Option<String>)`](crate::output::QueryAssistantOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<QueryAssistantError>`](crate::error::QueryAssistantError)
    pub fn query_assistant(&self) -> fluent_builders::QueryAssistant {
        fluent_builders::QueryAssistant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveKnowledgeBaseTemplateUri`](crate::client::fluent_builders::RemoveKnowledgeBaseTemplateUri) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::RemoveKnowledgeBaseTemplateUri::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::RemoveKnowledgeBaseTemplateUri::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    /// - On success, responds with [`RemoveKnowledgeBaseTemplateUriOutput`](crate::output::RemoveKnowledgeBaseTemplateUriOutput)

    /// - On failure, responds with [`SdkError<RemoveKnowledgeBaseTemplateUriError>`](crate::error::RemoveKnowledgeBaseTemplateUriError)
    pub fn remove_knowledge_base_template_uri(
        &self,
    ) -> fluent_builders::RemoveKnowledgeBaseTemplateUri {
        fluent_builders::RemoveKnowledgeBaseTemplateUri::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchContent`](crate::client::fluent_builders::SearchContent) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchContent::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchContent::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchContent::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchContent::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchContent::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::SearchContent::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::SearchContent::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`search_expression(SearchExpression)`](crate::client::fluent_builders::SearchContent::search_expression) / [`set_search_expression(Option<SearchExpression>)`](crate::client::fluent_builders::SearchContent::set_search_expression): <p>The search expression to filter results.</p>
    /// - On success, responds with [`SearchContentOutput`](crate::output::SearchContentOutput) with field(s):
    ///   - [`content_summaries(Option<Vec<ContentSummary>>)`](crate::output::SearchContentOutput::content_summaries): <p>Summary information about the content.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchContentOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<SearchContentError>`](crate::error::SearchContentError)
    pub fn search_content(&self) -> fluent_builders::SearchContent {
        fluent_builders::SearchContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchSessions`](crate::client::fluent_builders::SearchSessions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchSessions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchSessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchSessions::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchSessions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchSessions::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`assistant_id(impl Into<String>)`](crate::client::fluent_builders::SearchSessions::assistant_id) / [`set_assistant_id(Option<String>)`](crate::client::fluent_builders::SearchSessions::set_assistant_id): <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`search_expression(SearchExpression)`](crate::client::fluent_builders::SearchSessions::search_expression) / [`set_search_expression(Option<SearchExpression>)`](crate::client::fluent_builders::SearchSessions::set_search_expression): <p>The search expression to filter results.</p>
    /// - On success, responds with [`SearchSessionsOutput`](crate::output::SearchSessionsOutput) with field(s):
    ///   - [`session_summaries(Option<Vec<SessionSummary>>)`](crate::output::SearchSessionsOutput::session_summaries): <p>Summary information about the sessions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchSessionsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<SearchSessionsError>`](crate::error::SearchSessionsError)
    pub fn search_sessions(&self) -> fluent_builders::SearchSessions {
        fluent_builders::SearchSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartContentUpload`](crate::client::fluent_builders::StartContentUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::StartContentUpload::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::StartContentUpload::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::StartContentUpload::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::StartContentUpload::set_content_type): <p>The type of content to upload.</p>
    /// - On success, responds with [`StartContentUploadOutput`](crate::output::StartContentUploadOutput) with field(s):
    ///   - [`upload_id(Option<String>)`](crate::output::StartContentUploadOutput::upload_id): <p>The identifier of the upload.</p>
    ///   - [`url(Option<String>)`](crate::output::StartContentUploadOutput::url): <p>The URL of the upload.</p>
    ///   - [`url_expiry(Option<DateTime>)`](crate::output::StartContentUploadOutput::url_expiry): <p>The expiration time of the URL as an epoch timestamp.</p>
    ///   - [`headers_to_include(Option<HashMap<String, String>>)`](crate::output::StartContentUploadOutput::headers_to_include): <p>The headers to include in the upload.</p>
    /// - On failure, responds with [`SdkError<StartContentUploadError>`](crate::error::StartContentUploadError)
    pub fn start_content_upload(&self) -> fluent_builders::StartContentUpload {
        fluent_builders::StartContentUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContent`](crate::client::fluent_builders::UpdateContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContent::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::UpdateContent::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN</p>
    ///   - [`content_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContent::content_id) / [`set_content_id(Option<String>)`](crate::client::fluent_builders::UpdateContent::set_content_id): <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContent::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateContent::set_revision_id): <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::UpdateContent::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::UpdateContent::set_title): <p>The title of the content.</p>
    ///   - [`override_link_out_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateContent::override_link_out_uri) / [`set_override_link_out_uri(Option<String>)`](crate::client::fluent_builders::UpdateContent::set_override_link_out_uri): <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
    ///   - [`remove_override_link_out_uri(bool)`](crate::client::fluent_builders::UpdateContent::remove_override_link_out_uri) / [`set_remove_override_link_out_uri(Option<bool>)`](crate::client::fluent_builders::UpdateContent::set_remove_override_link_out_uri): <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::UpdateContent::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateContent::set_metadata): <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContent::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::UpdateContent::set_upload_id): <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
    /// - On success, responds with [`UpdateContentOutput`](crate::output::UpdateContentOutput) with field(s):
    ///   - [`content(Option<ContentData>)`](crate::output::UpdateContentOutput::content): <p>The content.</p>
    /// - On failure, responds with [`SdkError<UpdateContentError>`](crate::error::UpdateContentError)
    pub fn update_content(&self) -> fluent_builders::UpdateContent {
        fluent_builders::UpdateContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateKnowledgeBaseTemplateUri`](crate::client::fluent_builders::UpdateKnowledgeBaseTemplateUri) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`knowledge_base_id(impl Into<String>)`](crate::client::fluent_builders::UpdateKnowledgeBaseTemplateUri::knowledge_base_id) / [`set_knowledge_base_id(Option<String>)`](crate::client::fluent_builders::UpdateKnowledgeBaseTemplateUri::set_knowledge_base_id): <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
    ///   - [`template_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateKnowledgeBaseTemplateUri::template_uri) / [`set_template_uri(Option<String>)`](crate::client::fluent_builders::UpdateKnowledgeBaseTemplateUri::set_template_uri): <p>The template URI to update.</p>
    /// - On success, responds with [`UpdateKnowledgeBaseTemplateUriOutput`](crate::output::UpdateKnowledgeBaseTemplateUriOutput) with field(s):
    ///   - [`knowledge_base(Option<KnowledgeBaseData>)`](crate::output::UpdateKnowledgeBaseTemplateUriOutput::knowledge_base): <p>The knowledge base to update.</p>
    /// - On failure, responds with [`SdkError<UpdateKnowledgeBaseTemplateUriError>`](crate::error::UpdateKnowledgeBaseTemplateUriError)
    pub fn update_knowledge_base_template_uri(
        &self,
    ) -> fluent_builders::UpdateKnowledgeBaseTemplateUri {
        fluent_builders::UpdateKnowledgeBaseTemplateUri::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAssistant`.
    ///
    /// <p>Creates an Amazon Connect Wisdom assistant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssistant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assistant_input::Builder,
    }
    impl CreateAssistant {
        /// Creates a new `CreateAssistant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssistantOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssistantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the assistant.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the assistant.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of assistant.</p>
        pub fn r#type(mut self, input: crate::model::AssistantType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of assistant.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AssistantType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The description of the assistant.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the assistant.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssistantAssociation`.
    ///
    /// <p>Creates an association between an Amazon Connect Wisdom assistant and another resource. Currently, the only supported association is with a knowledge base. An assistant can have only a single association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssistantAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assistant_association_input::Builder,
    }
    impl CreateAssistantAssociation {
        /// Creates a new `CreateAssistantAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssistantAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssistantAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The type of association.</p>
        pub fn association_type(mut self, input: crate::model::AssociationType) -> Self {
            self.inner = self.inner.association_type(input);
            self
        }
        /// <p>The type of association.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationType>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
        /// <p>The identifier of the associated resource.</p>
        pub fn association(mut self, input: crate::model::AssistantAssociationInputData) -> Self {
            self.inner = self.inner.association(input);
            self
        }
        /// <p>The identifier of the associated resource.</p>
        pub fn set_association(
            mut self,
            input: std::option::Option<crate::model::AssistantAssociationInputData>,
        ) -> Self {
            self.inner = self.inner.set_association(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContent`.
    ///
    /// <p>Creates Wisdom content. Before to calling this API, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a> to upload an asset.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_content_input::Builder,
    }
    impl CreateContent {
        /// Creates a new `CreateContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
        /// <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the content. Each piece of content in a knowledge base must have a unique name. You can retrieve a piece of content using only its knowledge base and its name with the <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html">SearchContent</a> API.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The title of the content. If not set, the title is equal to the name.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p>The title of the content. If not set, the title is equal to the name.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
        pub fn override_link_out_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.override_link_out_uri(input.into());
            self
        }
        /// <p>The URI you want to use for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content.</p>
        pub fn set_override_link_out_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_override_link_out_uri(input);
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v.into());
            self
        }
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKnowledgeBase`.
    ///
    /// <p>Creates a knowledge base.</p> <note>
    /// <p>When using this API, you cannot reuse <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a> DataIntegrations with external knowledge bases such as Salesforce and ServiceNow. If you do, you'll get an <code>InvalidRequestException</code> error. </p>
    /// <p>For example, you're programmatically managing your external knowledge base, and you want to add or remove one of the fields that is being ingested from Salesforce. Do the following:</p>
    /// <ol>
    /// <li> <p>Call <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html">DeleteKnowledgeBase</a>.</p> </li>
    /// <li> <p>Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration</a>.</p> </li>
    /// <li> <p>Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> to recreate the DataIntegration or a create different one.</p> </li>
    /// <li> <p>Call CreateKnowledgeBase.</p> </li>
    /// </ol>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKnowledgeBase {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_knowledge_base_input::Builder,
    }
    impl CreateKnowledgeBase {
        /// Creates a new `CreateKnowledgeBase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKnowledgeBaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKnowledgeBaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the knowledge base.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
        pub fn knowledge_base_type(mut self, input: crate::model::KnowledgeBaseType) -> Self {
            self.inner = self.inner.knowledge_base_type(input);
            self
        }
        /// <p>The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically. </p>
        pub fn set_knowledge_base_type(
            mut self,
            input: std::option::Option<crate::model::KnowledgeBaseType>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_type(input);
            self
        }
        /// <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.inner = self.inner.source_configuration(input);
            self
        }
        /// <p>The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_source_configuration(input);
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn rendering_configuration(
            mut self,
            input: crate::model::RenderingConfiguration,
        ) -> Self {
            self.inner = self.inner.rendering_configuration(input);
            self
        }
        /// <p>Information about how to render the content.</p>
        pub fn set_rendering_configuration(
            mut self,
            input: std::option::Option<crate::model::RenderingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_rendering_configuration(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(input);
            self
        }
        /// <p>The KMS key used for encryption.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSession`.
    ///
    /// <p>Creates a session. A session is a contextual container used for generating recommendations. Amazon Connect creates a new Wisdom session for each contact on which Wisdom is enabled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_session_input::Builder,
    }
    impl CreateSession {
        /// Creates a new `CreateSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The name of the session.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the session.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssistant`.
    ///
    /// <p>Deletes an assistant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssistant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assistant_input::Builder,
    }
    impl DeleteAssistant {
        /// Creates a new `DeleteAssistant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssistantOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssistantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssistantAssociation`.
    ///
    /// <p>Deletes an assistant association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssistantAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assistant_association_input::Builder,
    }
    impl DeleteAssistantAssociation {
        /// Creates a new `DeleteAssistantAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssistantAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssistantAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_association_id(input.into());
            self
        }
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assistant_association_id(input);
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContent`.
    ///
    /// <p>Deletes the content.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_content_input::Builder,
    }
    impl DeleteContent {
        /// Creates a new `DeleteContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_id(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKnowledgeBase`.
    ///
    /// <p>Deletes the knowledge base.</p> <note>
    /// <p>When you use this API to delete an external knowledge base such as Salesforce or ServiceNow, you must also delete the <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html">Amazon AppIntegrations</a> DataIntegration. This is because you can't reuse the DataIntegration after it's been associated with an external knowledge base. However, you can delete and recreate it. See <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration</a> and <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a> in the <i>Amazon AppIntegrations API Reference</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteKnowledgeBase {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_knowledge_base_input::Builder,
    }
    impl DeleteKnowledgeBase {
        /// Creates a new `DeleteKnowledgeBase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKnowledgeBaseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKnowledgeBaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The knowledge base to delete content from. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssistant`.
    ///
    /// <p>Retrieves information about an assistant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssistant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assistant_input::Builder,
    }
    impl GetAssistant {
        /// Creates a new `GetAssistant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssistantOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssistantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssistantAssociation`.
    ///
    /// <p>Retrieves information about an assistant association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssistantAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assistant_association_input::Builder,
    }
    impl GetAssistantAssociation {
        /// Creates a new `GetAssistantAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssistantAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssistantAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_association_id(input.into());
            self
        }
        /// <p>The identifier of the assistant association. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assistant_association_id(input);
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContent`.
    ///
    /// <p>Retrieves content, including a pre-signed URL to download the content.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_content_input::Builder,
    }
    impl GetContent {
        /// Creates a new `GetContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_id(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_id(input);
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContentSummary`.
    ///
    /// <p>Retrieves summary information about the content.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContentSummary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_content_summary_input::Builder,
    }
    impl GetContentSummary {
        /// Creates a new `GetContentSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContentSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContentSummaryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_id(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_id(input);
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKnowledgeBase`.
    ///
    /// <p>Retrieves information about the knowledge base.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetKnowledgeBase {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_knowledge_base_input::Builder,
    }
    impl GetKnowledgeBase {
        /// Creates a new `GetKnowledgeBase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKnowledgeBaseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKnowledgeBaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecommendations`.
    ///
    /// <p>Retrieves recommendations for the specified session. To avoid retrieving the same recommendations in subsequent calls, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html">NotifyRecommendationsReceived</a>. This API supports long-polling behavior with the <code>waitTimeSeconds</code> parameter. Short poll is the default behavior and only returns recommendations already available. To perform a manual query against an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html">QueryAssistant</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_recommendations_input::Builder,
    }
    impl GetRecommendations {
        /// Creates a new `GetRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
        pub fn wait_time_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.wait_time_seconds(input);
            self
        }
        /// <p>The duration (in seconds) for which the call waits for a recommendation to be made available before returning. If a recommendation is available, the call returns sooner than <code>WaitTimeSeconds</code>. If no messages are available and the wait time expires, the call returns successfully with an empty list.</p>
        pub fn set_wait_time_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_wait_time_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSession`.
    ///
    /// <p>Retrieves information for a specified session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_session_input::Builder,
    }
    impl GetSession {
        /// Creates a new `GetSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssistantAssociations`.
    ///
    /// <p>Lists information about assistant associations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssistantAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assistant_associations_input::Builder,
    }
    impl ListAssistantAssociations {
        /// Creates a new `ListAssistantAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssistantAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssistantAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssistantAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssistantAssociationsPaginator {
            crate::paginator::ListAssistantAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssistants`.
    ///
    /// <p>Lists information about assistants.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssistants {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assistants_input::Builder,
    }
    impl ListAssistants {
        /// Creates a new `ListAssistants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssistantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssistantsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssistantsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssistantsPaginator {
            crate::paginator::ListAssistantsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContents`.
    ///
    /// <p>Lists the content.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_contents_input::Builder,
    }
    impl ListContents {
        /// Creates a new `ListContents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContentsPaginator {
            crate::paginator::ListContentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKnowledgeBases`.
    ///
    /// <p>Lists the knowledge bases.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKnowledgeBases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_knowledge_bases_input::Builder,
    }
    impl ListKnowledgeBases {
        /// Creates a new `ListKnowledgeBases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKnowledgeBasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKnowledgeBasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListKnowledgeBasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListKnowledgeBasesPaginator {
            crate::paginator::ListKnowledgeBasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `NotifyRecommendationsReceived`.
    ///
    /// <p>Removes the specified recommendations from the specified assistant's queue of newly available recommendations. You can use this API in conjunction with <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations</a> and a <code>waitTimeSeconds</code> input for long-polling behavior and avoiding duplicate recommendations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct NotifyRecommendationsReceived {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::notify_recommendations_received_input::Builder,
    }
    impl NotifyRecommendationsReceived {
        /// Creates a new `NotifyRecommendationsReceived`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::NotifyRecommendationsReceivedOutput,
            aws_smithy_http::result::SdkError<crate::error::NotifyRecommendationsReceivedError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The identifier of the session. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// Appends an item to `recommendationIds`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>The identifiers of the recommendations.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommendation_ids(input.into());
            self
        }
        /// <p>The identifiers of the recommendations.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `QueryAssistant`.
    ///
    /// <p>Performs a manual search against the specified assistant. To retrieve recommendations for an assistant, use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html">GetRecommendations</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct QueryAssistant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::query_assistant_input::Builder,
    }
    impl QueryAssistant {
        /// Creates a new `QueryAssistant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QueryAssistantOutput,
            aws_smithy_http::result::SdkError<crate::error::QueryAssistantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::QueryAssistantPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::QueryAssistantPaginator {
            crate::paginator::QueryAssistantPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The text to search for.</p>
        pub fn query_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_text(input.into());
            self
        }
        /// <p>The text to search for.</p>
        pub fn set_query_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_text(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveKnowledgeBaseTemplateUri`.
    ///
    /// <p>Removes a URI template from a knowledge base.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveKnowledgeBaseTemplateUri {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_knowledge_base_template_uri_input::Builder,
    }
    impl RemoveKnowledgeBaseTemplateUri {
        /// Creates a new `RemoveKnowledgeBaseTemplateUri`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveKnowledgeBaseTemplateUriOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveKnowledgeBaseTemplateUriError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchContent`.
    ///
    /// <p>Searches for content in a specified knowledge base. Can be used to get a specific content resource by its name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_content_input::Builder,
    }
    impl SearchContent {
        /// Creates a new `SearchContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchContentOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchContentPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchContentPaginator {
            crate::paginator::SearchContentPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn search_expression(mut self, input: crate::model::SearchExpression) -> Self {
            self.inner = self.inner.search_expression(input);
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn set_search_expression(
            mut self,
            input: std::option::Option<crate::model::SearchExpression>,
        ) -> Self {
            self.inner = self.inner.set_search_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchSessions`.
    ///
    /// <p>Searches for sessions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchSessions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_sessions_input::Builder,
    }
    impl SearchSessions {
        /// Creates a new `SearchSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchSessionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchSessionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchSessionsPaginator {
            crate::paginator::SearchSessionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn assistant_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assistant_id(input.into());
            self
        }
        /// <p>The identifier of the Wisdom assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_assistant_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_assistant_id(input);
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn search_expression(mut self, input: crate::model::SearchExpression) -> Self {
            self.inner = self.inner.search_expression(input);
            self
        }
        /// <p>The search expression to filter results.</p>
        pub fn set_search_expression(
            mut self,
            input: std::option::Option<crate::model::SearchExpression>,
        ) -> Self {
            self.inner = self.inner.set_search_expression(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContentUpload`.
    ///
    /// <p>Get a URL to upload content to a knowledge base. To upload content, first make a PUT request to the returned URL with your file, making sure to include the required headers. Then use <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html">CreateContent</a> to finalize the content creation process or <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html">UpdateContent</a> to modify an existing resource. You can only upload content to a knowledge base of type CUSTOM.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartContentUpload {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_content_upload_input::Builder,
    }
    impl StartContentUpload {
        /// Creates a new `StartContentUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContentUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContentUploadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
        /// <p>The type of content to upload.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The type of content to upload.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContent`.
    ///
    /// <p>Updates information about the content.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_content_input::Builder,
    }
    impl UpdateContent {
        /// Creates a new `UpdateContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn content_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_id(input.into());
            self
        }
        /// <p>The identifier of the content. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_content_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_id(input);
            self
        }
        /// <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The <code>revisionId</code> of the content resource to update, taken from an earlier call to <code>GetContent</code>, <code>GetContentSummary</code>, <code>SearchContent</code>, or <code>ListContents</code>. If included, this argument acts as an optimistic lock to ensure content was not modified since it was last read. If it has been modified, this API throws a <code>PreconditionFailedException</code>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>The title of the content.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p>The title of the content.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
        pub fn override_link_out_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.override_link_out_uri(input.into());
            self
        }
        /// <p>The URI for the article. If the knowledge base has a templateUri, setting this argument overrides it for this piece of content. To remove an existing <code>overrideLinkOurUri</code>, exclude this argument and set <code>removeOverrideLinkOutUri</code> to true.</p>
        pub fn set_override_link_out_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_override_link_out_uri(input);
            self
        }
        /// <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
        pub fn remove_override_link_out_uri(mut self, input: bool) -> Self {
            self.inner = self.inner.remove_override_link_out_uri(input);
            self
        }
        /// <p>Unset the existing <code>overrideLinkOutUri</code> if it exists.</p>
        pub fn set_remove_override_link_out_uri(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_remove_override_link_out_uri(input);
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v.into());
            self
        }
        /// <p>A key/value map to store attributes without affecting tagging or recommendations. For example, when synchronizing data between an external system and Wisdom, you can store an external version identifier as metadata to utilize for determining drift.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>A pointer to the uploaded asset. This value is returned by <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html">StartContentUpload</a>. </p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateKnowledgeBaseTemplateUri`.
    ///
    /// <p>Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL. Include a single variable in <code>${variable}</code> format; this interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce article, it has an <code>Id</code> value, and you can set the template URI to <code>https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*${Id}*/view</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateKnowledgeBaseTemplateUri {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_knowledge_base_template_uri_input::Builder,
    }
    impl UpdateKnowledgeBaseTemplateUri {
        /// Creates a new `UpdateKnowledgeBaseTemplateUri`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateKnowledgeBaseTemplateUriOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateKnowledgeBaseTemplateUriError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn knowledge_base_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.knowledge_base_id(input.into());
            self
        }
        /// <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.</p>
        pub fn set_knowledge_base_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_knowledge_base_id(input);
            self
        }
        /// <p>The template URI to update.</p>
        pub fn template_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_uri(input.into());
            self
        }
        /// <p>The template URI to update.</p>
        pub fn set_template_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_uri(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
