// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateLenses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_lenses`](crate::client::Client::associate_lenses).
///
/// See [`crate::client::fluent_builders::AssociateLenses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateLenses {
    _private: (),
}
impl AssociateLenses {
    /// Creates a new builder-style object to manufacture [`AssociateLensesInput`](crate::input::AssociateLensesInput)
    pub fn builder() -> crate::input::associate_lenses_input::Builder {
        crate::input::associate_lenses_input::Builder::default()
    }
    /// Creates a new `AssociateLenses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateLenses {
    type Output = std::result::Result<
        crate::output::AssociateLensesOutput,
        crate::error::AssociateLensesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_lenses_error(response)
        } else {
            crate::operation_deser::parse_associate_lenses_response(response)
        }
    }
}

/// Operation shape for `CreateLensShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_lens_share`](crate::client::Client::create_lens_share).
///
/// See [`crate::client::fluent_builders::CreateLensShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLensShare {
    _private: (),
}
impl CreateLensShare {
    /// Creates a new builder-style object to manufacture [`CreateLensShareInput`](crate::input::CreateLensShareInput)
    pub fn builder() -> crate::input::create_lens_share_input::Builder {
        crate::input::create_lens_share_input::Builder::default()
    }
    /// Creates a new `CreateLensShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLensShare {
    type Output = std::result::Result<
        crate::output::CreateLensShareOutput,
        crate::error::CreateLensShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_lens_share_error(response)
        } else {
            crate::operation_deser::parse_create_lens_share_response(response)
        }
    }
}

/// Operation shape for `CreateLensVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_lens_version`](crate::client::Client::create_lens_version).
///
/// See [`crate::client::fluent_builders::CreateLensVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLensVersion {
    _private: (),
}
impl CreateLensVersion {
    /// Creates a new builder-style object to manufacture [`CreateLensVersionInput`](crate::input::CreateLensVersionInput)
    pub fn builder() -> crate::input::create_lens_version_input::Builder {
        crate::input::create_lens_version_input::Builder::default()
    }
    /// Creates a new `CreateLensVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLensVersion {
    type Output = std::result::Result<
        crate::output::CreateLensVersionOutput,
        crate::error::CreateLensVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_lens_version_error(response)
        } else {
            crate::operation_deser::parse_create_lens_version_response(response)
        }
    }
}

/// Operation shape for `CreateMilestone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_milestone`](crate::client::Client::create_milestone).
///
/// See [`crate::client::fluent_builders::CreateMilestone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMilestone {
    _private: (),
}
impl CreateMilestone {
    /// Creates a new builder-style object to manufacture [`CreateMilestoneInput`](crate::input::CreateMilestoneInput)
    pub fn builder() -> crate::input::create_milestone_input::Builder {
        crate::input::create_milestone_input::Builder::default()
    }
    /// Creates a new `CreateMilestone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMilestone {
    type Output = std::result::Result<
        crate::output::CreateMilestoneOutput,
        crate::error::CreateMilestoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_milestone_error(response)
        } else {
            crate::operation_deser::parse_create_milestone_response(response)
        }
    }
}

/// Operation shape for `CreateWorkload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workload`](crate::client::Client::create_workload).
///
/// See [`crate::client::fluent_builders::CreateWorkload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkload {
    _private: (),
}
impl CreateWorkload {
    /// Creates a new builder-style object to manufacture [`CreateWorkloadInput`](crate::input::CreateWorkloadInput)
    pub fn builder() -> crate::input::create_workload_input::Builder {
        crate::input::create_workload_input::Builder::default()
    }
    /// Creates a new `CreateWorkload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkload {
    type Output =
        std::result::Result<crate::output::CreateWorkloadOutput, crate::error::CreateWorkloadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workload_error(response)
        } else {
            crate::operation_deser::parse_create_workload_response(response)
        }
    }
}

/// Operation shape for `CreateWorkloadShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workload_share`](crate::client::Client::create_workload_share).
///
/// See [`crate::client::fluent_builders::CreateWorkloadShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkloadShare {
    _private: (),
}
impl CreateWorkloadShare {
    /// Creates a new builder-style object to manufacture [`CreateWorkloadShareInput`](crate::input::CreateWorkloadShareInput)
    pub fn builder() -> crate::input::create_workload_share_input::Builder {
        crate::input::create_workload_share_input::Builder::default()
    }
    /// Creates a new `CreateWorkloadShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkloadShare {
    type Output = std::result::Result<
        crate::output::CreateWorkloadShareOutput,
        crate::error::CreateWorkloadShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workload_share_error(response)
        } else {
            crate::operation_deser::parse_create_workload_share_response(response)
        }
    }
}

/// Operation shape for `DeleteLens`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_lens`](crate::client::Client::delete_lens).
///
/// See [`crate::client::fluent_builders::DeleteLens`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLens {
    _private: (),
}
impl DeleteLens {
    /// Creates a new builder-style object to manufacture [`DeleteLensInput`](crate::input::DeleteLensInput)
    pub fn builder() -> crate::input::delete_lens_input::Builder {
        crate::input::delete_lens_input::Builder::default()
    }
    /// Creates a new `DeleteLens` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLens {
    type Output =
        std::result::Result<crate::output::DeleteLensOutput, crate::error::DeleteLensError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_lens_error(response)
        } else {
            crate::operation_deser::parse_delete_lens_response(response)
        }
    }
}

/// Operation shape for `DeleteLensShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_lens_share`](crate::client::Client::delete_lens_share).
///
/// See [`crate::client::fluent_builders::DeleteLensShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLensShare {
    _private: (),
}
impl DeleteLensShare {
    /// Creates a new builder-style object to manufacture [`DeleteLensShareInput`](crate::input::DeleteLensShareInput)
    pub fn builder() -> crate::input::delete_lens_share_input::Builder {
        crate::input::delete_lens_share_input::Builder::default()
    }
    /// Creates a new `DeleteLensShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLensShare {
    type Output = std::result::Result<
        crate::output::DeleteLensShareOutput,
        crate::error::DeleteLensShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_lens_share_error(response)
        } else {
            crate::operation_deser::parse_delete_lens_share_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workload`](crate::client::Client::delete_workload).
///
/// See [`crate::client::fluent_builders::DeleteWorkload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkload {
    _private: (),
}
impl DeleteWorkload {
    /// Creates a new builder-style object to manufacture [`DeleteWorkloadInput`](crate::input::DeleteWorkloadInput)
    pub fn builder() -> crate::input::delete_workload_input::Builder {
        crate::input::delete_workload_input::Builder::default()
    }
    /// Creates a new `DeleteWorkload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkload {
    type Output =
        std::result::Result<crate::output::DeleteWorkloadOutput, crate::error::DeleteWorkloadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workload_error(response)
        } else {
            crate::operation_deser::parse_delete_workload_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkloadShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workload_share`](crate::client::Client::delete_workload_share).
///
/// See [`crate::client::fluent_builders::DeleteWorkloadShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkloadShare {
    _private: (),
}
impl DeleteWorkloadShare {
    /// Creates a new builder-style object to manufacture [`DeleteWorkloadShareInput`](crate::input::DeleteWorkloadShareInput)
    pub fn builder() -> crate::input::delete_workload_share_input::Builder {
        crate::input::delete_workload_share_input::Builder::default()
    }
    /// Creates a new `DeleteWorkloadShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkloadShare {
    type Output = std::result::Result<
        crate::output::DeleteWorkloadShareOutput,
        crate::error::DeleteWorkloadShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workload_share_error(response)
        } else {
            crate::operation_deser::parse_delete_workload_share_response(response)
        }
    }
}

/// Operation shape for `DisassociateLenses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_lenses`](crate::client::Client::disassociate_lenses).
///
/// See [`crate::client::fluent_builders::DisassociateLenses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateLenses {
    _private: (),
}
impl DisassociateLenses {
    /// Creates a new builder-style object to manufacture [`DisassociateLensesInput`](crate::input::DisassociateLensesInput)
    pub fn builder() -> crate::input::disassociate_lenses_input::Builder {
        crate::input::disassociate_lenses_input::Builder::default()
    }
    /// Creates a new `DisassociateLenses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateLenses {
    type Output = std::result::Result<
        crate::output::DisassociateLensesOutput,
        crate::error::DisassociateLensesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_lenses_error(response)
        } else {
            crate::operation_deser::parse_disassociate_lenses_response(response)
        }
    }
}

/// Operation shape for `ExportLens`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_lens`](crate::client::Client::export_lens).
///
/// See [`crate::client::fluent_builders::ExportLens`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportLens {
    _private: (),
}
impl ExportLens {
    /// Creates a new builder-style object to manufacture [`ExportLensInput`](crate::input::ExportLensInput)
    pub fn builder() -> crate::input::export_lens_input::Builder {
        crate::input::export_lens_input::Builder::default()
    }
    /// Creates a new `ExportLens` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportLens {
    type Output =
        std::result::Result<crate::output::ExportLensOutput, crate::error::ExportLensError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_lens_error(response)
        } else {
            crate::operation_deser::parse_export_lens_response(response)
        }
    }
}

/// Operation shape for `GetAnswer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_answer`](crate::client::Client::get_answer).
///
/// See [`crate::client::fluent_builders::GetAnswer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnswer {
    _private: (),
}
impl GetAnswer {
    /// Creates a new builder-style object to manufacture [`GetAnswerInput`](crate::input::GetAnswerInput)
    pub fn builder() -> crate::input::get_answer_input::Builder {
        crate::input::get_answer_input::Builder::default()
    }
    /// Creates a new `GetAnswer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnswer {
    type Output = std::result::Result<crate::output::GetAnswerOutput, crate::error::GetAnswerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_answer_error(response)
        } else {
            crate::operation_deser::parse_get_answer_response(response)
        }
    }
}

/// Operation shape for `GetLens`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lens`](crate::client::Client::get_lens).
///
/// See [`crate::client::fluent_builders::GetLens`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLens {
    _private: (),
}
impl GetLens {
    /// Creates a new builder-style object to manufacture [`GetLensInput`](crate::input::GetLensInput)
    pub fn builder() -> crate::input::get_lens_input::Builder {
        crate::input::get_lens_input::Builder::default()
    }
    /// Creates a new `GetLens` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLens {
    type Output = std::result::Result<crate::output::GetLensOutput, crate::error::GetLensError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lens_error(response)
        } else {
            crate::operation_deser::parse_get_lens_response(response)
        }
    }
}

/// Operation shape for `GetLensReview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lens_review`](crate::client::Client::get_lens_review).
///
/// See [`crate::client::fluent_builders::GetLensReview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLensReview {
    _private: (),
}
impl GetLensReview {
    /// Creates a new builder-style object to manufacture [`GetLensReviewInput`](crate::input::GetLensReviewInput)
    pub fn builder() -> crate::input::get_lens_review_input::Builder {
        crate::input::get_lens_review_input::Builder::default()
    }
    /// Creates a new `GetLensReview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLensReview {
    type Output =
        std::result::Result<crate::output::GetLensReviewOutput, crate::error::GetLensReviewError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lens_review_error(response)
        } else {
            crate::operation_deser::parse_get_lens_review_response(response)
        }
    }
}

/// Operation shape for `GetLensReviewReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lens_review_report`](crate::client::Client::get_lens_review_report).
///
/// See [`crate::client::fluent_builders::GetLensReviewReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLensReviewReport {
    _private: (),
}
impl GetLensReviewReport {
    /// Creates a new builder-style object to manufacture [`GetLensReviewReportInput`](crate::input::GetLensReviewReportInput)
    pub fn builder() -> crate::input::get_lens_review_report_input::Builder {
        crate::input::get_lens_review_report_input::Builder::default()
    }
    /// Creates a new `GetLensReviewReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLensReviewReport {
    type Output = std::result::Result<
        crate::output::GetLensReviewReportOutput,
        crate::error::GetLensReviewReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lens_review_report_error(response)
        } else {
            crate::operation_deser::parse_get_lens_review_report_response(response)
        }
    }
}

/// Operation shape for `GetLensVersionDifference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lens_version_difference`](crate::client::Client::get_lens_version_difference).
///
/// See [`crate::client::fluent_builders::GetLensVersionDifference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLensVersionDifference {
    _private: (),
}
impl GetLensVersionDifference {
    /// Creates a new builder-style object to manufacture [`GetLensVersionDifferenceInput`](crate::input::GetLensVersionDifferenceInput)
    pub fn builder() -> crate::input::get_lens_version_difference_input::Builder {
        crate::input::get_lens_version_difference_input::Builder::default()
    }
    /// Creates a new `GetLensVersionDifference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLensVersionDifference {
    type Output = std::result::Result<
        crate::output::GetLensVersionDifferenceOutput,
        crate::error::GetLensVersionDifferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lens_version_difference_error(response)
        } else {
            crate::operation_deser::parse_get_lens_version_difference_response(response)
        }
    }
}

/// Operation shape for `GetMilestone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_milestone`](crate::client::Client::get_milestone).
///
/// See [`crate::client::fluent_builders::GetMilestone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMilestone {
    _private: (),
}
impl GetMilestone {
    /// Creates a new builder-style object to manufacture [`GetMilestoneInput`](crate::input::GetMilestoneInput)
    pub fn builder() -> crate::input::get_milestone_input::Builder {
        crate::input::get_milestone_input::Builder::default()
    }
    /// Creates a new `GetMilestone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMilestone {
    type Output =
        std::result::Result<crate::output::GetMilestoneOutput, crate::error::GetMilestoneError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_milestone_error(response)
        } else {
            crate::operation_deser::parse_get_milestone_response(response)
        }
    }
}

/// Operation shape for `GetWorkload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workload`](crate::client::Client::get_workload).
///
/// See [`crate::client::fluent_builders::GetWorkload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkload {
    _private: (),
}
impl GetWorkload {
    /// Creates a new builder-style object to manufacture [`GetWorkloadInput`](crate::input::GetWorkloadInput)
    pub fn builder() -> crate::input::get_workload_input::Builder {
        crate::input::get_workload_input::Builder::default()
    }
    /// Creates a new `GetWorkload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkload {
    type Output =
        std::result::Result<crate::output::GetWorkloadOutput, crate::error::GetWorkloadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workload_error(response)
        } else {
            crate::operation_deser::parse_get_workload_response(response)
        }
    }
}

/// Operation shape for `ImportLens`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_lens`](crate::client::Client::import_lens).
///
/// See [`crate::client::fluent_builders::ImportLens`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportLens {
    _private: (),
}
impl ImportLens {
    /// Creates a new builder-style object to manufacture [`ImportLensInput`](crate::input::ImportLensInput)
    pub fn builder() -> crate::input::import_lens_input::Builder {
        crate::input::import_lens_input::Builder::default()
    }
    /// Creates a new `ImportLens` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportLens {
    type Output =
        std::result::Result<crate::output::ImportLensOutput, crate::error::ImportLensError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_lens_error(response)
        } else {
            crate::operation_deser::parse_import_lens_response(response)
        }
    }
}

/// Operation shape for `ListAnswers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_answers`](crate::client::Client::list_answers).
///
/// See [`crate::client::fluent_builders::ListAnswers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnswers {
    _private: (),
}
impl ListAnswers {
    /// Creates a new builder-style object to manufacture [`ListAnswersInput`](crate::input::ListAnswersInput)
    pub fn builder() -> crate::input::list_answers_input::Builder {
        crate::input::list_answers_input::Builder::default()
    }
    /// Creates a new `ListAnswers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnswers {
    type Output =
        std::result::Result<crate::output::ListAnswersOutput, crate::error::ListAnswersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_answers_error(response)
        } else {
            crate::operation_deser::parse_list_answers_response(response)
        }
    }
}

/// Operation shape for `ListLenses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lenses`](crate::client::Client::list_lenses).
///
/// See [`crate::client::fluent_builders::ListLenses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLenses {
    _private: (),
}
impl ListLenses {
    /// Creates a new builder-style object to manufacture [`ListLensesInput`](crate::input::ListLensesInput)
    pub fn builder() -> crate::input::list_lenses_input::Builder {
        crate::input::list_lenses_input::Builder::default()
    }
    /// Creates a new `ListLenses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLenses {
    type Output =
        std::result::Result<crate::output::ListLensesOutput, crate::error::ListLensesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lenses_error(response)
        } else {
            crate::operation_deser::parse_list_lenses_response(response)
        }
    }
}

/// Operation shape for `ListLensReviewImprovements`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lens_review_improvements`](crate::client::Client::list_lens_review_improvements).
///
/// See [`crate::client::fluent_builders::ListLensReviewImprovements`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLensReviewImprovements {
    _private: (),
}
impl ListLensReviewImprovements {
    /// Creates a new builder-style object to manufacture [`ListLensReviewImprovementsInput`](crate::input::ListLensReviewImprovementsInput)
    pub fn builder() -> crate::input::list_lens_review_improvements_input::Builder {
        crate::input::list_lens_review_improvements_input::Builder::default()
    }
    /// Creates a new `ListLensReviewImprovements` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLensReviewImprovements {
    type Output = std::result::Result<
        crate::output::ListLensReviewImprovementsOutput,
        crate::error::ListLensReviewImprovementsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lens_review_improvements_error(response)
        } else {
            crate::operation_deser::parse_list_lens_review_improvements_response(response)
        }
    }
}

/// Operation shape for `ListLensReviews`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lens_reviews`](crate::client::Client::list_lens_reviews).
///
/// See [`crate::client::fluent_builders::ListLensReviews`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLensReviews {
    _private: (),
}
impl ListLensReviews {
    /// Creates a new builder-style object to manufacture [`ListLensReviewsInput`](crate::input::ListLensReviewsInput)
    pub fn builder() -> crate::input::list_lens_reviews_input::Builder {
        crate::input::list_lens_reviews_input::Builder::default()
    }
    /// Creates a new `ListLensReviews` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLensReviews {
    type Output = std::result::Result<
        crate::output::ListLensReviewsOutput,
        crate::error::ListLensReviewsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lens_reviews_error(response)
        } else {
            crate::operation_deser::parse_list_lens_reviews_response(response)
        }
    }
}

/// Operation shape for `ListLensShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_lens_shares`](crate::client::Client::list_lens_shares).
///
/// See [`crate::client::fluent_builders::ListLensShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLensShares {
    _private: (),
}
impl ListLensShares {
    /// Creates a new builder-style object to manufacture [`ListLensSharesInput`](crate::input::ListLensSharesInput)
    pub fn builder() -> crate::input::list_lens_shares_input::Builder {
        crate::input::list_lens_shares_input::Builder::default()
    }
    /// Creates a new `ListLensShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLensShares {
    type Output =
        std::result::Result<crate::output::ListLensSharesOutput, crate::error::ListLensSharesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_lens_shares_error(response)
        } else {
            crate::operation_deser::parse_list_lens_shares_response(response)
        }
    }
}

/// Operation shape for `ListMilestones`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_milestones`](crate::client::Client::list_milestones).
///
/// See [`crate::client::fluent_builders::ListMilestones`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMilestones {
    _private: (),
}
impl ListMilestones {
    /// Creates a new builder-style object to manufacture [`ListMilestonesInput`](crate::input::ListMilestonesInput)
    pub fn builder() -> crate::input::list_milestones_input::Builder {
        crate::input::list_milestones_input::Builder::default()
    }
    /// Creates a new `ListMilestones` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMilestones {
    type Output =
        std::result::Result<crate::output::ListMilestonesOutput, crate::error::ListMilestonesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_milestones_error(response)
        } else {
            crate::operation_deser::parse_list_milestones_response(response)
        }
    }
}

/// Operation shape for `ListNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_notifications`](crate::client::Client::list_notifications).
///
/// See [`crate::client::fluent_builders::ListNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNotifications {
    _private: (),
}
impl ListNotifications {
    /// Creates a new builder-style object to manufacture [`ListNotificationsInput`](crate::input::ListNotificationsInput)
    pub fn builder() -> crate::input::list_notifications_input::Builder {
        crate::input::list_notifications_input::Builder::default()
    }
    /// Creates a new `ListNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNotifications {
    type Output = std::result::Result<
        crate::output::ListNotificationsOutput,
        crate::error::ListNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_notifications_error(response)
        } else {
            crate::operation_deser::parse_list_notifications_response(response)
        }
    }
}

/// Operation shape for `ListShareInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_share_invitations`](crate::client::Client::list_share_invitations).
///
/// See [`crate::client::fluent_builders::ListShareInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListShareInvitations {
    _private: (),
}
impl ListShareInvitations {
    /// Creates a new builder-style object to manufacture [`ListShareInvitationsInput`](crate::input::ListShareInvitationsInput)
    pub fn builder() -> crate::input::list_share_invitations_input::Builder {
        crate::input::list_share_invitations_input::Builder::default()
    }
    /// Creates a new `ListShareInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListShareInvitations {
    type Output = std::result::Result<
        crate::output::ListShareInvitationsOutput,
        crate::error::ListShareInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_share_invitations_error(response)
        } else {
            crate::operation_deser::parse_list_share_invitations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWorkloads`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workloads`](crate::client::Client::list_workloads).
///
/// See [`crate::client::fluent_builders::ListWorkloads`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkloads {
    _private: (),
}
impl ListWorkloads {
    /// Creates a new builder-style object to manufacture [`ListWorkloadsInput`](crate::input::ListWorkloadsInput)
    pub fn builder() -> crate::input::list_workloads_input::Builder {
        crate::input::list_workloads_input::Builder::default()
    }
    /// Creates a new `ListWorkloads` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkloads {
    type Output =
        std::result::Result<crate::output::ListWorkloadsOutput, crate::error::ListWorkloadsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workloads_error(response)
        } else {
            crate::operation_deser::parse_list_workloads_response(response)
        }
    }
}

/// Operation shape for `ListWorkloadShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workload_shares`](crate::client::Client::list_workload_shares).
///
/// See [`crate::client::fluent_builders::ListWorkloadShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkloadShares {
    _private: (),
}
impl ListWorkloadShares {
    /// Creates a new builder-style object to manufacture [`ListWorkloadSharesInput`](crate::input::ListWorkloadSharesInput)
    pub fn builder() -> crate::input::list_workload_shares_input::Builder {
        crate::input::list_workload_shares_input::Builder::default()
    }
    /// Creates a new `ListWorkloadShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkloadShares {
    type Output = std::result::Result<
        crate::output::ListWorkloadSharesOutput,
        crate::error::ListWorkloadSharesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workload_shares_error(response)
        } else {
            crate::operation_deser::parse_list_workload_shares_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAnswer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_answer`](crate::client::Client::update_answer).
///
/// See [`crate::client::fluent_builders::UpdateAnswer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAnswer {
    _private: (),
}
impl UpdateAnswer {
    /// Creates a new builder-style object to manufacture [`UpdateAnswerInput`](crate::input::UpdateAnswerInput)
    pub fn builder() -> crate::input::update_answer_input::Builder {
        crate::input::update_answer_input::Builder::default()
    }
    /// Creates a new `UpdateAnswer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAnswer {
    type Output =
        std::result::Result<crate::output::UpdateAnswerOutput, crate::error::UpdateAnswerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_answer_error(response)
        } else {
            crate::operation_deser::parse_update_answer_response(response)
        }
    }
}

/// Operation shape for `UpdateLensReview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_lens_review`](crate::client::Client::update_lens_review).
///
/// See [`crate::client::fluent_builders::UpdateLensReview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLensReview {
    _private: (),
}
impl UpdateLensReview {
    /// Creates a new builder-style object to manufacture [`UpdateLensReviewInput`](crate::input::UpdateLensReviewInput)
    pub fn builder() -> crate::input::update_lens_review_input::Builder {
        crate::input::update_lens_review_input::Builder::default()
    }
    /// Creates a new `UpdateLensReview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLensReview {
    type Output = std::result::Result<
        crate::output::UpdateLensReviewOutput,
        crate::error::UpdateLensReviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_lens_review_error(response)
        } else {
            crate::operation_deser::parse_update_lens_review_response(response)
        }
    }
}

/// Operation shape for `UpdateShareInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_share_invitation`](crate::client::Client::update_share_invitation).
///
/// See [`crate::client::fluent_builders::UpdateShareInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateShareInvitation {
    _private: (),
}
impl UpdateShareInvitation {
    /// Creates a new builder-style object to manufacture [`UpdateShareInvitationInput`](crate::input::UpdateShareInvitationInput)
    pub fn builder() -> crate::input::update_share_invitation_input::Builder {
        crate::input::update_share_invitation_input::Builder::default()
    }
    /// Creates a new `UpdateShareInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateShareInvitation {
    type Output = std::result::Result<
        crate::output::UpdateShareInvitationOutput,
        crate::error::UpdateShareInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_share_invitation_error(response)
        } else {
            crate::operation_deser::parse_update_share_invitation_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workload`](crate::client::Client::update_workload).
///
/// See [`crate::client::fluent_builders::UpdateWorkload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkload {
    _private: (),
}
impl UpdateWorkload {
    /// Creates a new builder-style object to manufacture [`UpdateWorkloadInput`](crate::input::UpdateWorkloadInput)
    pub fn builder() -> crate::input::update_workload_input::Builder {
        crate::input::update_workload_input::Builder::default()
    }
    /// Creates a new `UpdateWorkload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkload {
    type Output =
        std::result::Result<crate::output::UpdateWorkloadOutput, crate::error::UpdateWorkloadError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workload_error(response)
        } else {
            crate::operation_deser::parse_update_workload_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkloadShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workload_share`](crate::client::Client::update_workload_share).
///
/// See [`crate::client::fluent_builders::UpdateWorkloadShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkloadShare {
    _private: (),
}
impl UpdateWorkloadShare {
    /// Creates a new builder-style object to manufacture [`UpdateWorkloadShareInput`](crate::input::UpdateWorkloadShareInput)
    pub fn builder() -> crate::input::update_workload_share_input::Builder {
        crate::input::update_workload_share_input::Builder::default()
    }
    /// Creates a new `UpdateWorkloadShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkloadShare {
    type Output = std::result::Result<
        crate::output::UpdateWorkloadShareOutput,
        crate::error::UpdateWorkloadShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workload_share_error(response)
        } else {
            crate::operation_deser::parse_update_workload_share_response(response)
        }
    }
}

/// Operation shape for `UpgradeLensReview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upgrade_lens_review`](crate::client::Client::upgrade_lens_review).
///
/// See [`crate::client::fluent_builders::UpgradeLensReview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpgradeLensReview {
    _private: (),
}
impl UpgradeLensReview {
    /// Creates a new builder-style object to manufacture [`UpgradeLensReviewInput`](crate::input::UpgradeLensReviewInput)
    pub fn builder() -> crate::input::upgrade_lens_review_input::Builder {
        crate::input::upgrade_lens_review_input::Builder::default()
    }
    /// Creates a new `UpgradeLensReview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpgradeLensReview {
    type Output = std::result::Result<
        crate::output::UpgradeLensReviewOutput,
        crate::error::UpgradeLensReviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upgrade_lens_review_error(response)
        } else {
            crate::operation_deser::parse_upgrade_lens_review_response(response)
        }
    }
}
