// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Well-Architected Tool
///
/// Client for invoking operations on AWS Well-Architected Tool. Each operation on AWS Well-Architected Tool is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_wellarchitected::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_wellarchitected::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_wellarchitected::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateLenses`](crate::client::fluent_builders::AssociateLenses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLenses::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::AssociateLenses::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_aliases(Vec<String>)`](crate::client::fluent_builders::AssociateLenses::lens_aliases) / [`set_lens_aliases(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateLenses::set_lens_aliases): <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>  <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
    /// - On success, responds with [`AssociateLensesOutput`](crate::output::AssociateLensesOutput)

    /// - On failure, responds with [`SdkError<AssociateLensesError>`](crate::error::AssociateLensesError)
    pub fn associate_lenses(&self) -> fluent_builders::AssociateLenses<C, M, R> {
        fluent_builders::AssociateLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLensShare`](crate::client::fluent_builders::CreateLensShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::CreateLensShare::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::CreateLensShare::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`shared_with(impl Into<String>)`](crate::client::fluent_builders::CreateLensShare::shared_with) / [`set_shared_with(Option<String>)`](crate::client::fluent_builders::CreateLensShare::set_shared_with): <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateLensShare::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateLensShare::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`CreateLensShareOutput`](crate::output::CreateLensShareOutput) with field(s):
    ///   - [`share_id(Option<String>)`](crate::output::CreateLensShareOutput::share_id): <p>The ID associated with the workload share.</p>
    /// - On failure, responds with [`SdkError<CreateLensShareError>`](crate::error::CreateLensShareError)
    pub fn create_lens_share(&self) -> fluent_builders::CreateLensShare<C, M, R> {
        fluent_builders::CreateLensShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLensVersion`](crate::client::fluent_builders::CreateLensVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::CreateLensVersion::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::CreateLensVersion::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_version(impl Into<String>)`](crate::client::fluent_builders::CreateLensVersion::lens_version) / [`set_lens_version(Option<String>)`](crate::client::fluent_builders::CreateLensVersion::set_lens_version): <p>The version of the lens being created.</p>
    ///   - [`is_major_version(bool)`](crate::client::fluent_builders::CreateLensVersion::is_major_version) / [`set_is_major_version(bool)`](crate::client::fluent_builders::CreateLensVersion::set_is_major_version): <p>Set to true if this new major lens version.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateLensVersion::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateLensVersion::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`CreateLensVersionOutput`](crate::output::CreateLensVersionOutput) with field(s):
    ///   - [`lens_arn(Option<String>)`](crate::output::CreateLensVersionOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`lens_version(Option<String>)`](crate::output::CreateLensVersionOutput::lens_version): <p>The version of the lens.</p>
    /// - On failure, responds with [`SdkError<CreateLensVersionError>`](crate::error::CreateLensVersionError)
    pub fn create_lens_version(&self) -> fluent_builders::CreateLensVersion<C, M, R> {
        fluent_builders::CreateLensVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMilestone`](crate::client::fluent_builders::CreateMilestone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::CreateMilestone::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::CreateMilestone::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_name(impl Into<String>)`](crate::client::fluent_builders::CreateMilestone::milestone_name) / [`set_milestone_name(Option<String>)`](crate::client::fluent_builders::CreateMilestone::set_milestone_name): <p>The name of the milestone in a workload.</p>  <p>Milestone names must be unique within a workload.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMilestone::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMilestone::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`CreateMilestoneOutput`](crate::output::CreateMilestoneOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::CreateMilestoneOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::CreateMilestoneOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    /// - On failure, responds with [`SdkError<CreateMilestoneError>`](crate::error::CreateMilestoneError)
    pub fn create_milestone(&self) -> fluent_builders::CreateMilestone<C, M, R> {
        fluent_builders::CreateMilestone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkload`](crate::client::fluent_builders::CreateWorkload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_name(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::workload_name) / [`set_workload_name(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_workload_name): <p>The name of the workload.</p>  <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_description): <p>The description for the workload.</p>
    ///   - [`environment(WorkloadEnvironment)`](crate::client::fluent_builders::CreateWorkload::environment) / [`set_environment(Option<WorkloadEnvironment>)`](crate::client::fluent_builders::CreateWorkload::set_environment): <p>The environment for the workload.</p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::CreateWorkload::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateWorkload::set_account_ids): <p>The list of Amazon Web Services account IDs associated with the workload.</p>
    ///   - [`aws_regions(Vec<String>)`](crate::client::fluent_builders::CreateWorkload::aws_regions) / [`set_aws_regions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateWorkload::set_aws_regions): <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
    ///   - [`non_aws_regions(Vec<String>)`](crate::client::fluent_builders::CreateWorkload::non_aws_regions) / [`set_non_aws_regions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateWorkload::set_non_aws_regions): <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
    ///   - [`pillar_priorities(Vec<String>)`](crate::client::fluent_builders::CreateWorkload::pillar_priorities) / [`set_pillar_priorities(Option<Vec<String>>)`](crate::client::fluent_builders::CreateWorkload::set_pillar_priorities): <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
    ///   - [`architectural_design(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::architectural_design) / [`set_architectural_design(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_architectural_design): <p>The URL of the architectural design for the workload.</p>
    ///   - [`review_owner(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::review_owner) / [`set_review_owner(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_review_owner): <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
    ///   - [`industry_type(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::industry_type) / [`set_industry_type(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_industry_type): <p>The industry type for the workload.</p>  <p>If specified, must be one of the following:</p>  <ul>   <li> <p> <code>Agriculture</code> </p> </li>   <li> <p> <code>Automobile</code> </p> </li>   <li> <p> <code>Defense</code> </p> </li>   <li> <p> <code>Design and Engineering</code> </p> </li>   <li> <p> <code>Digital Advertising</code> </p> </li>   <li> <p> <code>Education</code> </p> </li>   <li> <p> <code>Environmental Protection</code> </p> </li>   <li> <p> <code>Financial Services</code> </p> </li>   <li> <p> <code>Gaming</code> </p> </li>   <li> <p> <code>General Public Services</code> </p> </li>   <li> <p> <code>Healthcare</code> </p> </li>   <li> <p> <code>Hospitality</code> </p> </li>   <li> <p> <code>InfoTech</code> </p> </li>   <li> <p> <code>Justice and Public Safety</code> </p> </li>   <li> <p> <code>Life Sciences</code> </p> </li>   <li> <p> <code>Manufacturing</code> </p> </li>   <li> <p> <code>Media &amp; Entertainment</code> </p> </li>   <li> <p> <code>Mining &amp; Resources</code> </p> </li>   <li> <p> <code>Oil &amp; Gas</code> </p> </li>   <li> <p> <code>Power &amp; Utilities</code> </p> </li>   <li> <p> <code>Professional Services</code> </p> </li>   <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>   <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>   <li> <p> <code>Social Protection</code> </p> </li>   <li> <p> <code>Telecommunications</code> </p> </li>   <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>   <li> <p> <code>Other</code> </p> </li>  </ul>
    ///   - [`industry(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::industry) / [`set_industry(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_industry): <p>The industry for the workload.</p>
    ///   - [`lenses(Vec<String>)`](crate::client::fluent_builders::CreateWorkload::lenses) / [`set_lenses(Option<Vec<String>>)`](crate::client::fluent_builders::CreateWorkload::set_lenses): <p>The list of lenses associated with the workload. Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`notes(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::notes) / [`set_notes(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_notes): <p>The notes associated with the workload.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateWorkload::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateWorkload::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateWorkload::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateWorkload::set_tags): <p>The tags to be associated with the workload.</p>
    /// - On success, responds with [`CreateWorkloadOutput`](crate::output::CreateWorkloadOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::CreateWorkloadOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`workload_arn(Option<String>)`](crate::output::CreateWorkloadOutput::workload_arn): <p>The ARN for the workload.</p>
    /// - On failure, responds with [`SdkError<CreateWorkloadError>`](crate::error::CreateWorkloadError)
    pub fn create_workload(&self) -> fluent_builders::CreateWorkload<C, M, R> {
        fluent_builders::CreateWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkloadShare`](crate::client::fluent_builders::CreateWorkloadShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::CreateWorkloadShare::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::CreateWorkloadShare::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`shared_with(impl Into<String>)`](crate::client::fluent_builders::CreateWorkloadShare::shared_with) / [`set_shared_with(Option<String>)`](crate::client::fluent_builders::CreateWorkloadShare::set_shared_with): <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    ///   - [`permission_type(PermissionType)`](crate::client::fluent_builders::CreateWorkloadShare::permission_type) / [`set_permission_type(Option<PermissionType>)`](crate::client::fluent_builders::CreateWorkloadShare::set_permission_type): <p>Permission granted on a workload share.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateWorkloadShare::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateWorkloadShare::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`CreateWorkloadShareOutput`](crate::output::CreateWorkloadShareOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::CreateWorkloadShareOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`share_id(Option<String>)`](crate::output::CreateWorkloadShareOutput::share_id): <p>The ID associated with the workload share.</p>
    /// - On failure, responds with [`SdkError<CreateWorkloadShareError>`](crate::error::CreateWorkloadShareError)
    pub fn create_workload_share(&self) -> fluent_builders::CreateWorkloadShare<C, M, R> {
        fluent_builders::CreateWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLens`](crate::client::fluent_builders::DeleteLens) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::DeleteLens::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::DeleteLens::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteLens::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteLens::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    ///   - [`lens_status(LensStatusType)`](crate::client::fluent_builders::DeleteLens::lens_status) / [`set_lens_status(Option<LensStatusType>)`](crate::client::fluent_builders::DeleteLens::set_lens_status): <p>The status of the lens to be deleted.</p>
    /// - On success, responds with [`DeleteLensOutput`](crate::output::DeleteLensOutput)

    /// - On failure, responds with [`SdkError<DeleteLensError>`](crate::error::DeleteLensError)
    pub fn delete_lens(&self) -> fluent_builders::DeleteLens<C, M, R> {
        fluent_builders::DeleteLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLensShare`](crate::client::fluent_builders::DeleteLensShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`share_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLensShare::share_id) / [`set_share_id(Option<String>)`](crate::client::fluent_builders::DeleteLensShare::set_share_id): <p>The ID associated with the workload share.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::DeleteLensShare::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::DeleteLensShare::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteLensShare::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteLensShare::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`DeleteLensShareOutput`](crate::output::DeleteLensShareOutput)

    /// - On failure, responds with [`SdkError<DeleteLensShareError>`](crate::error::DeleteLensShareError)
    pub fn delete_lens_share(&self) -> fluent_builders::DeleteLensShare<C, M, R> {
        fluent_builders::DeleteLensShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkload`](crate::client::fluent_builders::DeleteWorkload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkload::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkload::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkload::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteWorkload::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`DeleteWorkloadOutput`](crate::output::DeleteWorkloadOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkloadError>`](crate::error::DeleteWorkloadError)
    pub fn delete_workload(&self) -> fluent_builders::DeleteWorkload<C, M, R> {
        fluent_builders::DeleteWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkloadShare`](crate::client::fluent_builders::DeleteWorkloadShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`share_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkloadShare::share_id) / [`set_share_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkloadShare::set_share_id): <p>The ID associated with the workload share.</p>
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkloadShare::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkloadShare::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkloadShare::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DeleteWorkloadShare::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`DeleteWorkloadShareOutput`](crate::output::DeleteWorkloadShareOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkloadShareError>`](crate::error::DeleteWorkloadShareError)
    pub fn delete_workload_share(&self) -> fluent_builders::DeleteWorkloadShare<C, M, R> {
        fluent_builders::DeleteWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateLenses`](crate::client::fluent_builders::DisassociateLenses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLenses::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::DisassociateLenses::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_aliases(Vec<String>)`](crate::client::fluent_builders::DisassociateLenses::lens_aliases) / [`set_lens_aliases(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateLenses::set_lens_aliases): <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>  <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
    /// - On success, responds with [`DisassociateLensesOutput`](crate::output::DisassociateLensesOutput)

    /// - On failure, responds with [`SdkError<DisassociateLensesError>`](crate::error::DisassociateLensesError)
    pub fn disassociate_lenses(&self) -> fluent_builders::DisassociateLenses<C, M, R> {
        fluent_builders::DisassociateLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportLens`](crate::client::fluent_builders::ExportLens) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::ExportLens::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::ExportLens::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_version(impl Into<String>)`](crate::client::fluent_builders::ExportLens::lens_version) / [`set_lens_version(Option<String>)`](crate::client::fluent_builders::ExportLens::set_lens_version): <p>The lens version to be exported.</p>
    /// - On success, responds with [`ExportLensOutput`](crate::output::ExportLensOutput) with field(s):
    ///   - [`lens_json(Option<String>)`](crate::output::ExportLensOutput::lens_json): <p>The JSON for the lens.</p>
    /// - On failure, responds with [`SdkError<ExportLensError>`](crate::error::ExportLensError)
    pub fn export_lens(&self) -> fluent_builders::ExportLens<C, M, R> {
        fluent_builders::ExportLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAnswer`](crate::client::fluent_builders::GetAnswer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::GetAnswer::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::GetAnswer::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::GetAnswer::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::GetAnswer::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`question_id(impl Into<String>)`](crate::client::fluent_builders::GetAnswer::question_id) / [`set_question_id(Option<String>)`](crate::client::fluent_builders::GetAnswer::set_question_id): <p>The ID of the question.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::GetAnswer::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::GetAnswer::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    /// - On success, responds with [`GetAnswerOutput`](crate::output::GetAnswerOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::GetAnswerOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::GetAnswerOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`lens_alias(Option<String>)`](crate::output::GetAnswerOutput::lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_arn(Option<String>)`](crate::output::GetAnswerOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`answer(Option<Answer>)`](crate::output::GetAnswerOutput::answer): <p>An answer of the question.</p>
    /// - On failure, responds with [`SdkError<GetAnswerError>`](crate::error::GetAnswerError)
    pub fn get_answer(&self) -> fluent_builders::GetAnswer<C, M, R> {
        fluent_builders::GetAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLens`](crate::client::fluent_builders::GetLens) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::GetLens::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::GetLens::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_version(impl Into<String>)`](crate::client::fluent_builders::GetLens::lens_version) / [`set_lens_version(Option<String>)`](crate::client::fluent_builders::GetLens::set_lens_version): <p>The lens version to be retrieved.</p>
    /// - On success, responds with [`GetLensOutput`](crate::output::GetLensOutput) with field(s):
    ///   - [`lens(Option<Lens>)`](crate::output::GetLensOutput::lens): <p>A lens return object.</p>
    /// - On failure, responds with [`SdkError<GetLensError>`](crate::error::GetLensError)
    pub fn get_lens(&self) -> fluent_builders::GetLens<C, M, R> {
        fluent_builders::GetLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLensReview`](crate::client::fluent_builders::GetLensReview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::GetLensReview::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::GetLensReview::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::GetLensReview::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::GetLensReview::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::GetLensReview::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::GetLensReview::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    /// - On success, responds with [`GetLensReviewOutput`](crate::output::GetLensReviewOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::GetLensReviewOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::GetLensReviewOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`lens_review(Option<LensReview>)`](crate::output::GetLensReviewOutput::lens_review): <p>A lens review of a question.</p>
    /// - On failure, responds with [`SdkError<GetLensReviewError>`](crate::error::GetLensReviewError)
    pub fn get_lens_review(&self) -> fluent_builders::GetLensReview<C, M, R> {
        fluent_builders::GetLensReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLensReviewReport`](crate::client::fluent_builders::GetLensReviewReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::GetLensReviewReport::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::GetLensReviewReport::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::GetLensReviewReport::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::GetLensReviewReport::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::GetLensReviewReport::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::GetLensReviewReport::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    /// - On success, responds with [`GetLensReviewReportOutput`](crate::output::GetLensReviewReportOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::GetLensReviewReportOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::GetLensReviewReportOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`lens_review_report(Option<LensReviewReport>)`](crate::output::GetLensReviewReportOutput::lens_review_report): <p>A report of a lens review.</p>
    /// - On failure, responds with [`SdkError<GetLensReviewReportError>`](crate::error::GetLensReviewReportError)
    pub fn get_lens_review_report(&self) -> fluent_builders::GetLensReviewReport<C, M, R> {
        fluent_builders::GetLensReviewReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLensVersionDifference`](crate::client::fluent_builders::GetLensVersionDifference) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::GetLensVersionDifference::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::GetLensVersionDifference::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`base_lens_version(impl Into<String>)`](crate::client::fluent_builders::GetLensVersionDifference::base_lens_version) / [`set_base_lens_version(Option<String>)`](crate::client::fluent_builders::GetLensVersionDifference::set_base_lens_version): <p>The base version of the lens.</p>
    ///   - [`target_lens_version(impl Into<String>)`](crate::client::fluent_builders::GetLensVersionDifference::target_lens_version) / [`set_target_lens_version(Option<String>)`](crate::client::fluent_builders::GetLensVersionDifference::set_target_lens_version): <p>The lens version to target a difference for.</p>
    /// - On success, responds with [`GetLensVersionDifferenceOutput`](crate::output::GetLensVersionDifferenceOutput) with field(s):
    ///   - [`lens_alias(Option<String>)`](crate::output::GetLensVersionDifferenceOutput::lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_arn(Option<String>)`](crate::output::GetLensVersionDifferenceOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`base_lens_version(Option<String>)`](crate::output::GetLensVersionDifferenceOutput::base_lens_version): <p>The base version of the lens.</p>
    ///   - [`target_lens_version(Option<String>)`](crate::output::GetLensVersionDifferenceOutput::target_lens_version): <p>The target lens version for the lens.</p>
    ///   - [`latest_lens_version(Option<String>)`](crate::output::GetLensVersionDifferenceOutput::latest_lens_version): <p>The latest version of the lens.</p>
    ///   - [`version_differences(Option<VersionDifferences>)`](crate::output::GetLensVersionDifferenceOutput::version_differences): <p>The differences between the base and latest versions of the lens.</p>
    /// - On failure, responds with [`SdkError<GetLensVersionDifferenceError>`](crate::error::GetLensVersionDifferenceError)
    pub fn get_lens_version_difference(
        &self,
    ) -> fluent_builders::GetLensVersionDifference<C, M, R> {
        fluent_builders::GetLensVersionDifference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMilestone`](crate::client::fluent_builders::GetMilestone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::GetMilestone::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::GetMilestone::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::GetMilestone::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::GetMilestone::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    /// - On success, responds with [`GetMilestoneOutput`](crate::output::GetMilestoneOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::GetMilestoneOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone(Option<Milestone>)`](crate::output::GetMilestoneOutput::milestone): <p>A milestone return object.</p>
    /// - On failure, responds with [`SdkError<GetMilestoneError>`](crate::error::GetMilestoneError)
    pub fn get_milestone(&self) -> fluent_builders::GetMilestone<C, M, R> {
        fluent_builders::GetMilestone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkload`](crate::client::fluent_builders::GetWorkload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::GetWorkload::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::GetWorkload::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    /// - On success, responds with [`GetWorkloadOutput`](crate::output::GetWorkloadOutput) with field(s):
    ///   - [`workload(Option<Workload>)`](crate::output::GetWorkloadOutput::workload): <p>A workload return object.</p>
    /// - On failure, responds with [`SdkError<GetWorkloadError>`](crate::error::GetWorkloadError)
    pub fn get_workload(&self) -> fluent_builders::GetWorkload<C, M, R> {
        fluent_builders::GetWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportLens`](crate::client::fluent_builders::ImportLens) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::ImportLens::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::ImportLens::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`json_string(impl Into<String>)`](crate::client::fluent_builders::ImportLens::json_string) / [`set_json_string(Option<String>)`](crate::client::fluent_builders::ImportLens::set_json_string): <p>The JSON representation of a lens.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::ImportLens::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::ImportLens::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::ImportLens::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ImportLens::set_tags): <p>Tags to associate to a lens.</p>
    /// - On success, responds with [`ImportLensOutput`](crate::output::ImportLensOutput) with field(s):
    ///   - [`lens_arn(Option<String>)`](crate::output::ImportLensOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`status(Option<ImportLensStatus>)`](crate::output::ImportLensOutput::status): <p>The status of the imported lens.</p>
    /// - On failure, responds with [`SdkError<ImportLensError>`](crate::error::ImportLensError)
    pub fn import_lens(&self) -> fluent_builders::ImportLens<C, M, R> {
        fluent_builders::ImportLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAnswers`](crate::client::fluent_builders::ListAnswers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAnswers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::ListAnswers::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::ListAnswers::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::ListAnswers::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::ListAnswers::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`pillar_id(impl Into<String>)`](crate::client::fluent_builders::ListAnswers::pillar_id) / [`set_pillar_id(Option<String>)`](crate::client::fluent_builders::ListAnswers::set_pillar_id): <p>The ID used to identify a pillar, for example, <code>security</code>.</p>  <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::ListAnswers::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::ListAnswers::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAnswers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAnswers::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAnswers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListAnswers::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListAnswersOutput`](crate::output::ListAnswersOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::ListAnswersOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::ListAnswersOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`lens_alias(Option<String>)`](crate::output::ListAnswersOutput::lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_arn(Option<String>)`](crate::output::ListAnswersOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`answer_summaries(Option<Vec<AnswerSummary>>)`](crate::output::ListAnswersOutput::answer_summaries): <p>List of answer summaries of lens review in a workload.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAnswersOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAnswersError>`](crate::error::ListAnswersError)
    pub fn list_answers(&self) -> fluent_builders::ListAnswers<C, M, R> {
        fluent_builders::ListAnswers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLenses`](crate::client::fluent_builders::ListLenses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLenses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLenses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLenses::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLenses::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListLenses::set_max_results): <p>The maximum number of results to return for this request.</p>
    ///   - [`lens_type(LensType)`](crate::client::fluent_builders::ListLenses::lens_type) / [`set_lens_type(Option<LensType>)`](crate::client::fluent_builders::ListLenses::set_lens_type): <p>The type of lenses to be returned.</p>
    ///   - [`lens_status(LensStatusType)`](crate::client::fluent_builders::ListLenses::lens_status) / [`set_lens_status(Option<LensStatusType>)`](crate::client::fluent_builders::ListLenses::set_lens_status): <p>The status of lenses to be returned.</p>
    ///   - [`lens_name(impl Into<String>)`](crate::client::fluent_builders::ListLenses::lens_name) / [`set_lens_name(Option<String>)`](crate::client::fluent_builders::ListLenses::set_lens_name): <p>The full name of the lens.</p>
    /// - On success, responds with [`ListLensesOutput`](crate::output::ListLensesOutput) with field(s):
    ///   - [`lens_summaries(Option<Vec<LensSummary>>)`](crate::output::ListLensesOutput::lens_summaries): <p>List of lens summaries of available lenses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLensesOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLensesError>`](crate::error::ListLensesError)
    pub fn list_lenses(&self) -> fluent_builders::ListLenses<C, M, R> {
        fluent_builders::ListLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLensReviewImprovements`](crate::client::fluent_builders::ListLensReviewImprovements) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLensReviewImprovements::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`pillar_id(impl Into<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::pillar_id) / [`set_pillar_id(Option<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::set_pillar_id): <p>The ID used to identify a pillar, for example, <code>security</code>.</p>  <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::ListLensReviewImprovements::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::ListLensReviewImprovements::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLensReviewImprovements::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLensReviewImprovements::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListLensReviewImprovements::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListLensReviewImprovementsOutput`](crate::output::ListLensReviewImprovementsOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::ListLensReviewImprovementsOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::ListLensReviewImprovementsOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`lens_alias(Option<String>)`](crate::output::ListLensReviewImprovementsOutput::lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_arn(Option<String>)`](crate::output::ListLensReviewImprovementsOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`improvement_summaries(Option<Vec<ImprovementSummary>>)`](crate::output::ListLensReviewImprovementsOutput::improvement_summaries): <p>List of improvement summaries of lens review in a workload.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLensReviewImprovementsOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLensReviewImprovementsError>`](crate::error::ListLensReviewImprovementsError)
    pub fn list_lens_review_improvements(
        &self,
    ) -> fluent_builders::ListLensReviewImprovements<C, M, R> {
        fluent_builders::ListLensReviewImprovements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLensReviews`](crate::client::fluent_builders::ListLensReviews) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLensReviews::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::ListLensReviews::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::ListLensReviews::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::client::fluent_builders::ListLensReviews::milestone_number) / [`set_milestone_number(i32)`](crate::client::fluent_builders::ListLensReviews::set_milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLensReviews::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLensReviews::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLensReviews::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListLensReviews::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListLensReviewsOutput`](crate::output::ListLensReviewsOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::ListLensReviewsOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_number(i32)`](crate::output::ListLensReviewsOutput::milestone_number): <p>The milestone number.</p>  <p>A workload can have a maximum of 100 milestones.</p>
    ///   - [`lens_review_summaries(Option<Vec<LensReviewSummary>>)`](crate::output::ListLensReviewsOutput::lens_review_summaries): <p>List of lens summaries of lens reviews of a workload.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLensReviewsOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLensReviewsError>`](crate::error::ListLensReviewsError)
    pub fn list_lens_reviews(&self) -> fluent_builders::ListLensReviews<C, M, R> {
        fluent_builders::ListLensReviews::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLensShares`](crate::client::fluent_builders::ListLensShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLensShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::ListLensShares::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::ListLensShares::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`shared_with_prefix(impl Into<String>)`](crate::client::fluent_builders::ListLensShares::shared_with_prefix) / [`set_shared_with_prefix(Option<String>)`](crate::client::fluent_builders::ListLensShares::set_shared_with_prefix): <p>The Amazon Web Services account ID or IAM role with which the lens is shared.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLensShares::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLensShares::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLensShares::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListLensShares::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListLensSharesOutput`](crate::output::ListLensSharesOutput) with field(s):
    ///   - [`lens_share_summaries(Option<Vec<LensShareSummary>>)`](crate::output::ListLensSharesOutput::lens_share_summaries): <p>A list of lens share summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLensSharesOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLensSharesError>`](crate::error::ListLensSharesError)
    pub fn list_lens_shares(&self) -> fluent_builders::ListLensShares<C, M, R> {
        fluent_builders::ListLensShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMilestones`](crate::client::fluent_builders::ListMilestones) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMilestones::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::ListMilestones::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::ListMilestones::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMilestones::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMilestones::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMilestones::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListMilestones::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListMilestonesOutput`](crate::output::ListMilestonesOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::ListMilestonesOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`milestone_summaries(Option<Vec<MilestoneSummary>>)`](crate::output::ListMilestonesOutput::milestone_summaries): <p>A list of milestone summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMilestonesOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListMilestonesError>`](crate::error::ListMilestonesError)
    pub fn list_milestones(&self) -> fluent_builders::ListMilestones<C, M, R> {
        fluent_builders::ListMilestones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNotifications`](crate::client::fluent_builders::ListNotifications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNotifications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::ListNotifications::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::ListNotifications::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNotifications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNotifications::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNotifications::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListNotifications::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListNotificationsOutput`](crate::output::ListNotificationsOutput) with field(s):
    ///   - [`notification_summaries(Option<Vec<NotificationSummary>>)`](crate::output::ListNotificationsOutput::notification_summaries): <p>List of lens notification summaries in a workload.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNotificationsOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListNotificationsError>`](crate::error::ListNotificationsError)
    pub fn list_notifications(&self) -> fluent_builders::ListNotifications<C, M, R> {
        fluent_builders::ListNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListShareInvitations`](crate::client::fluent_builders::ListShareInvitations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListShareInvitations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListShareInvitations::workload_name_prefix) / [`set_workload_name_prefix(Option<String>)`](crate::client::fluent_builders::ListShareInvitations::set_workload_name_prefix): <p>An optional string added to the beginning of each workload name returned in the results.</p>
    ///   - [`lens_name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListShareInvitations::lens_name_prefix) / [`set_lens_name_prefix(Option<String>)`](crate::client::fluent_builders::ListShareInvitations::set_lens_name_prefix): <p>An optional string added to the beginning of each lens name returned in the results.</p>
    ///   - [`share_resource_type(ShareResourceType)`](crate::client::fluent_builders::ListShareInvitations::share_resource_type) / [`set_share_resource_type(Option<ShareResourceType>)`](crate::client::fluent_builders::ListShareInvitations::set_share_resource_type): <p>The type of share invitations to be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListShareInvitations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListShareInvitations::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListShareInvitations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListShareInvitations::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListShareInvitationsOutput`](crate::output::ListShareInvitationsOutput) with field(s):
    ///   - [`share_invitation_summaries(Option<Vec<ShareInvitationSummary>>)`](crate::output::ListShareInvitationsOutput::share_invitation_summaries): <p>List of share invitation summaries in a workload.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListShareInvitationsOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListShareInvitationsError>`](crate::error::ListShareInvitationsError)
    pub fn list_share_invitations(&self) -> fluent_builders::ListShareInvitations<C, M, R> {
        fluent_builders::ListShareInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::workload_arn) / [`set_workload_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_workload_arn): <p>The ARN for the workload.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkloads`](crate::client::fluent_builders::ListWorkloads) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkloads::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_name_prefix(impl Into<String>)`](crate::client::fluent_builders::ListWorkloads::workload_name_prefix) / [`set_workload_name_prefix(Option<String>)`](crate::client::fluent_builders::ListWorkloads::set_workload_name_prefix): <p>An optional string added to the beginning of each workload name returned in the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkloads::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkloads::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkloads::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListWorkloads::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListWorkloadsOutput`](crate::output::ListWorkloadsOutput) with field(s):
    ///   - [`workload_summaries(Option<Vec<WorkloadSummary>>)`](crate::output::ListWorkloadsOutput::workload_summaries): <p>A list of workload summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkloadsOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListWorkloadsError>`](crate::error::ListWorkloadsError)
    pub fn list_workloads(&self) -> fluent_builders::ListWorkloads<C, M, R> {
        fluent_builders::ListWorkloads::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkloadShares`](crate::client::fluent_builders::ListWorkloadShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkloadShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::ListWorkloadShares::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::ListWorkloadShares::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`shared_with_prefix(impl Into<String>)`](crate::client::fluent_builders::ListWorkloadShares::shared_with_prefix) / [`set_shared_with_prefix(Option<String>)`](crate::client::fluent_builders::ListWorkloadShares::set_shared_with_prefix): <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkloadShares::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkloadShares::set_next_token): <p>The token to use to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkloadShares::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListWorkloadShares::set_max_results): <p>The maximum number of results to return for this request.</p>
    /// - On success, responds with [`ListWorkloadSharesOutput`](crate::output::ListWorkloadSharesOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::ListWorkloadSharesOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`workload_share_summaries(Option<Vec<WorkloadShareSummary>>)`](crate::output::ListWorkloadSharesOutput::workload_share_summaries): <p>A list of workload share summaries.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkloadSharesOutput::next_token): <p>The token to use to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListWorkloadSharesError>`](crate::error::ListWorkloadSharesError)
    pub fn list_workload_shares(&self) -> fluent_builders::ListWorkloadShares<C, M, R> {
        fluent_builders::ListWorkloadShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::workload_arn) / [`set_workload_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_workload_arn): <p>The ARN for the workload.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags for the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::workload_arn) / [`set_workload_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_workload_arn): <p>The ARN for the workload.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAnswer`](crate::client::fluent_builders::UpdateAnswer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAnswer::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::UpdateAnswer::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::UpdateAnswer::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::UpdateAnswer::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`question_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAnswer::question_id) / [`set_question_id(Option<String>)`](crate::client::fluent_builders::UpdateAnswer::set_question_id): <p>The ID of the question.</p>
    ///   - [`selected_choices(Vec<String>)`](crate::client::fluent_builders::UpdateAnswer::selected_choices) / [`set_selected_choices(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateAnswer::set_selected_choices): <p>List of selected choice IDs in a question answer.</p>  <p>The values entered replace the previously selected choices.</p>
    ///   - [`choice_updates(HashMap<String, ChoiceUpdate>)`](crate::client::fluent_builders::UpdateAnswer::choice_updates) / [`set_choice_updates(Option<HashMap<String, ChoiceUpdate>>)`](crate::client::fluent_builders::UpdateAnswer::set_choice_updates): <p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>
    ///   - [`notes(impl Into<String>)`](crate::client::fluent_builders::UpdateAnswer::notes) / [`set_notes(Option<String>)`](crate::client::fluent_builders::UpdateAnswer::set_notes): <p>The notes associated with the workload.</p>
    ///   - [`is_applicable(bool)`](crate::client::fluent_builders::UpdateAnswer::is_applicable) / [`set_is_applicable(bool)`](crate::client::fluent_builders::UpdateAnswer::set_is_applicable): <p>Defines whether this question is applicable to a lens review.</p>
    ///   - [`reason(AnswerReason)`](crate::client::fluent_builders::UpdateAnswer::reason) / [`set_reason(Option<AnswerReason>)`](crate::client::fluent_builders::UpdateAnswer::set_reason): <p>The reason why a question is not applicable to your workload.</p>
    /// - On success, responds with [`UpdateAnswerOutput`](crate::output::UpdateAnswerOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::UpdateAnswerOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(Option<String>)`](crate::output::UpdateAnswerOutput::lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_arn(Option<String>)`](crate::output::UpdateAnswerOutput::lens_arn): <p>The ARN for the lens.</p>
    ///   - [`answer(Option<Answer>)`](crate::output::UpdateAnswerOutput::answer): <p>An answer of the question.</p>
    /// - On failure, responds with [`SdkError<UpdateAnswerError>`](crate::error::UpdateAnswerError)
    pub fn update_answer(&self) -> fluent_builders::UpdateAnswer<C, M, R> {
        fluent_builders::UpdateAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLensReview`](crate::client::fluent_builders::UpdateLensReview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::UpdateLensReview::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::UpdateLensReview::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::UpdateLensReview::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::UpdateLensReview::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`lens_notes(impl Into<String>)`](crate::client::fluent_builders::UpdateLensReview::lens_notes) / [`set_lens_notes(Option<String>)`](crate::client::fluent_builders::UpdateLensReview::set_lens_notes): <p>The notes associated with the workload.</p>
    ///   - [`pillar_notes(HashMap<String, String>)`](crate::client::fluent_builders::UpdateLensReview::pillar_notes) / [`set_pillar_notes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateLensReview::set_pillar_notes): <p>List of pillar notes of a lens review in a workload.</p>
    /// - On success, responds with [`UpdateLensReviewOutput`](crate::output::UpdateLensReviewOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::UpdateLensReviewOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_review(Option<LensReview>)`](crate::output::UpdateLensReviewOutput::lens_review): <p>A lens review of a question.</p>
    /// - On failure, responds with [`SdkError<UpdateLensReviewError>`](crate::error::UpdateLensReviewError)
    pub fn update_lens_review(&self) -> fluent_builders::UpdateLensReview<C, M, R> {
        fluent_builders::UpdateLensReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateShareInvitation`](crate::client::fluent_builders::UpdateShareInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`share_invitation_id(impl Into<String>)`](crate::client::fluent_builders::UpdateShareInvitation::share_invitation_id) / [`set_share_invitation_id(Option<String>)`](crate::client::fluent_builders::UpdateShareInvitation::set_share_invitation_id): <p>The ID assigned to the share invitation.</p>
    ///   - [`share_invitation_action(ShareInvitationAction)`](crate::client::fluent_builders::UpdateShareInvitation::share_invitation_action) / [`set_share_invitation_action(Option<ShareInvitationAction>)`](crate::client::fluent_builders::UpdateShareInvitation::set_share_invitation_action): <p>Share invitation action taken by contributor.</p>
    /// - On success, responds with [`UpdateShareInvitationOutput`](crate::output::UpdateShareInvitationOutput) with field(s):
    ///   - [`share_invitation(Option<ShareInvitation>)`](crate::output::UpdateShareInvitationOutput::share_invitation): <p>The updated workload share invitation.</p>
    /// - On failure, responds with [`SdkError<UpdateShareInvitationError>`](crate::error::UpdateShareInvitationError)
    pub fn update_share_invitation(&self) -> fluent_builders::UpdateShareInvitation<C, M, R> {
        fluent_builders::UpdateShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkload`](crate::client::fluent_builders::UpdateWorkload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`workload_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::workload_name) / [`set_workload_name(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_workload_name): <p>The name of the workload.</p>  <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_description): <p>The description for the workload.</p>
    ///   - [`environment(WorkloadEnvironment)`](crate::client::fluent_builders::UpdateWorkload::environment) / [`set_environment(Option<WorkloadEnvironment>)`](crate::client::fluent_builders::UpdateWorkload::set_environment): <p>The environment for the workload.</p>
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::UpdateWorkload::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateWorkload::set_account_ids): <p>The list of Amazon Web Services account IDs associated with the workload.</p>
    ///   - [`aws_regions(Vec<String>)`](crate::client::fluent_builders::UpdateWorkload::aws_regions) / [`set_aws_regions(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateWorkload::set_aws_regions): <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
    ///   - [`non_aws_regions(Vec<String>)`](crate::client::fluent_builders::UpdateWorkload::non_aws_regions) / [`set_non_aws_regions(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateWorkload::set_non_aws_regions): <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
    ///   - [`pillar_priorities(Vec<String>)`](crate::client::fluent_builders::UpdateWorkload::pillar_priorities) / [`set_pillar_priorities(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateWorkload::set_pillar_priorities): <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
    ///   - [`architectural_design(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::architectural_design) / [`set_architectural_design(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_architectural_design): <p>The URL of the architectural design for the workload.</p>
    ///   - [`review_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::review_owner) / [`set_review_owner(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_review_owner): <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
    ///   - [`is_review_owner_update_acknowledged(bool)`](crate::client::fluent_builders::UpdateWorkload::is_review_owner_update_acknowledged) / [`set_is_review_owner_update_acknowledged(bool)`](crate::client::fluent_builders::UpdateWorkload::set_is_review_owner_update_acknowledged): <p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p>  <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>
    ///   - [`industry_type(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::industry_type) / [`set_industry_type(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_industry_type): <p>The industry type for the workload.</p>  <p>If specified, must be one of the following:</p>  <ul>   <li> <p> <code>Agriculture</code> </p> </li>   <li> <p> <code>Automobile</code> </p> </li>   <li> <p> <code>Defense</code> </p> </li>   <li> <p> <code>Design and Engineering</code> </p> </li>   <li> <p> <code>Digital Advertising</code> </p> </li>   <li> <p> <code>Education</code> </p> </li>   <li> <p> <code>Environmental Protection</code> </p> </li>   <li> <p> <code>Financial Services</code> </p> </li>   <li> <p> <code>Gaming</code> </p> </li>   <li> <p> <code>General Public Services</code> </p> </li>   <li> <p> <code>Healthcare</code> </p> </li>   <li> <p> <code>Hospitality</code> </p> </li>   <li> <p> <code>InfoTech</code> </p> </li>   <li> <p> <code>Justice and Public Safety</code> </p> </li>   <li> <p> <code>Life Sciences</code> </p> </li>   <li> <p> <code>Manufacturing</code> </p> </li>   <li> <p> <code>Media &amp; Entertainment</code> </p> </li>   <li> <p> <code>Mining &amp; Resources</code> </p> </li>   <li> <p> <code>Oil &amp; Gas</code> </p> </li>   <li> <p> <code>Power &amp; Utilities</code> </p> </li>   <li> <p> <code>Professional Services</code> </p> </li>   <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>   <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>   <li> <p> <code>Social Protection</code> </p> </li>   <li> <p> <code>Telecommunications</code> </p> </li>   <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>   <li> <p> <code>Other</code> </p> </li>  </ul>
    ///   - [`industry(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::industry) / [`set_industry(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_industry): <p>The industry for the workload.</p>
    ///   - [`notes(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkload::notes) / [`set_notes(Option<String>)`](crate::client::fluent_builders::UpdateWorkload::set_notes): <p>The notes associated with the workload.</p>
    ///   - [`improvement_status(WorkloadImprovementStatus)`](crate::client::fluent_builders::UpdateWorkload::improvement_status) / [`set_improvement_status(Option<WorkloadImprovementStatus>)`](crate::client::fluent_builders::UpdateWorkload::set_improvement_status): <p>The improvement status for a workload.</p>
    /// - On success, responds with [`UpdateWorkloadOutput`](crate::output::UpdateWorkloadOutput) with field(s):
    ///   - [`workload(Option<Workload>)`](crate::output::UpdateWorkloadOutput::workload): <p>A workload return object.</p>
    /// - On failure, responds with [`SdkError<UpdateWorkloadError>`](crate::error::UpdateWorkloadError)
    pub fn update_workload(&self) -> fluent_builders::UpdateWorkload<C, M, R> {
        fluent_builders::UpdateWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkloadShare`](crate::client::fluent_builders::UpdateWorkloadShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`share_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkloadShare::share_id) / [`set_share_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkloadShare::set_share_id): <p>The ID associated with the workload share.</p>
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkloadShare::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkloadShare::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`permission_type(PermissionType)`](crate::client::fluent_builders::UpdateWorkloadShare::permission_type) / [`set_permission_type(Option<PermissionType>)`](crate::client::fluent_builders::UpdateWorkloadShare::set_permission_type): <p>Permission granted on a workload share.</p>
    /// - On success, responds with [`UpdateWorkloadShareOutput`](crate::output::UpdateWorkloadShareOutput) with field(s):
    ///   - [`workload_id(Option<String>)`](crate::output::UpdateWorkloadShareOutput::workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`workload_share(Option<WorkloadShare>)`](crate::output::UpdateWorkloadShareOutput::workload_share): <p>A workload share return object.</p>
    /// - On failure, responds with [`SdkError<UpdateWorkloadShareError>`](crate::error::UpdateWorkloadShareError)
    pub fn update_workload_share(&self) -> fluent_builders::UpdateWorkloadShare<C, M, R> {
        fluent_builders::UpdateWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpgradeLensReview`](crate::client::fluent_builders::UpgradeLensReview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workload_id(impl Into<String>)`](crate::client::fluent_builders::UpgradeLensReview::workload_id) / [`set_workload_id(Option<String>)`](crate::client::fluent_builders::UpgradeLensReview::set_workload_id): <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    ///   - [`lens_alias(impl Into<String>)`](crate::client::fluent_builders::UpgradeLensReview::lens_alias) / [`set_lens_alias(Option<String>)`](crate::client::fluent_builders::UpgradeLensReview::set_lens_alias): <p>The alias of the lens, for example, <code>serverless</code>.</p>  <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
    ///   - [`milestone_name(impl Into<String>)`](crate::client::fluent_builders::UpgradeLensReview::milestone_name) / [`set_milestone_name(Option<String>)`](crate::client::fluent_builders::UpgradeLensReview::set_milestone_name): <p>The name of the milestone in a workload.</p>  <p>Milestone names must be unique within a workload.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpgradeLensReview::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpgradeLensReview::set_client_request_token): <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>  <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>   <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>  </important>
    /// - On success, responds with [`UpgradeLensReviewOutput`](crate::output::UpgradeLensReviewOutput)

    /// - On failure, responds with [`SdkError<UpgradeLensReviewError>`](crate::error::UpgradeLensReviewError)
    pub fn upgrade_lens_review(&self) -> fluent_builders::UpgradeLensReview<C, M, R> {
        fluent_builders::UpgradeLensReview::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateLenses`.
    ///
    /// <p>Associate a lens to a workload.</p>
    /// <p>Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lenses_input::Builder,
    }
    impl<C, M, R> AssociateLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLensesInputOperationOutputAlias,
                crate::output::AssociateLensesOutput,
                crate::error::AssociateLensesError,
                crate::input::AssociateLensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// Appends an item to `LensAliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_aliases(input.into());
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lens_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLensShare`.
    ///
    /// <p>Create a lens share.</p>
    /// <p>The owner of a lens can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a lens is not removed until the lens invitation is deleted.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLensShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lens_share_input::Builder,
    }
    impl<C, M, R> CreateLensShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLensShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLensShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLensShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLensShareInputOperationOutputAlias,
                crate::output::CreateLensShareOutput,
                crate::error::CreateLensShareError,
                crate::input::CreateLensShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shared_with(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLensVersion`.
    ///
    /// <p>Create a new lens version.</p>
    /// <p>A lens can have up to 100 versions.</p>
    /// <p>After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a lens can delete it. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLensVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lens_version_input::Builder,
    }
    impl<C, M, R> CreateLensVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLensVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLensVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLensVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLensVersionInputOperationOutputAlias,
                crate::output::CreateLensVersionOutput,
                crate::error::CreateLensVersionError,
                crate::input::CreateLensVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The version of the lens being created.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_version(input.into());
            self
        }
        /// <p>The version of the lens being created.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_version(input);
            self
        }
        /// <p>Set to true if this new major lens version.</p>
        pub fn is_major_version(mut self, input: bool) -> Self {
            self.inner = self.inner.is_major_version(input);
            self
        }
        /// <p>Set to true if this new major lens version.</p>
        pub fn set_is_major_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_major_version(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMilestone`.
    ///
    /// <p>Create a milestone for an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMilestone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_milestone_input::Builder,
    }
    impl<C, M, R> CreateMilestone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMilestone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMilestoneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMilestoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMilestoneInputOperationOutputAlias,
                crate::output::CreateMilestoneOutput,
                crate::error::CreateMilestoneError,
                crate::input::CreateMilestoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.milestone_name(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_milestone_name(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkload`.
    ///
    /// <p>Create a new workload.</p>
    /// <p>The owner of a workload can share the workload with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a workload can delete it.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workload_input::Builder,
    }
    impl<C, M, R> CreateWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkloadInputOperationOutputAlias,
                crate::output::CreateWorkloadOutput,
                crate::error::CreateWorkloadError,
                crate::input::CreateWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name(input);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `AwsRegions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_regions(input.into());
            self
        }
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_regions(input);
            self
        }
        /// Appends an item to `NonAwsRegions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.non_aws_regions(input.into());
            self
        }
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_non_aws_regions(input);
            self
        }
        /// Appends an item to `PillarPriorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_priorities(input.into());
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pillar_priorities(input);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.architectural_design(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_architectural_design(input);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.review_owner(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_review_owner(input);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry_type(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_industry_type(input);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_industry(input);
            self
        }
        /// Appends an item to `Lenses`.
        ///
        /// To override the contents of this collection use [`set_lenses`](Self::set_lenses).
        ///
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lenses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lenses(input.into());
            self
        }
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lenses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lenses(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the workload.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be associated with the workload.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkloadShare`.
    ///
    /// <p>Create a workload share.</p>
    /// <p>The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workload_share_input::Builder,
    }
    impl<C, M, R> CreateWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkloadShareInputOperationOutputAlias,
                crate::output::CreateWorkloadShareOutput,
                crate::error::CreateWorkloadShareError,
                crate::input::CreateWorkloadShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shared_with(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLens`.
    ///
    /// <p>Delete an existing lens.</p>
    /// <p>Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads. </p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lens_input::Builder,
    }
    impl<C, M, R> DeleteLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLensOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLensInputOperationOutputAlias,
                crate::output::DeleteLensOutput,
                crate::error::DeleteLensError,
                crate::input::DeleteLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The status of the lens to be deleted.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatusType) -> Self {
            self.inner = self.inner.lens_status(input);
            self
        }
        /// <p>The status of the lens to be deleted.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatusType>,
        ) -> Self {
            self.inner = self.inner.set_lens_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLensShare`.
    ///
    /// <p>Delete a lens share.</p>
    /// <p>After the lens share is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLensShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lens_share_input::Builder,
    }
    impl<C, M, R> DeleteLensShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLensShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLensShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLensShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLensShareInputOperationOutputAlias,
                crate::output::DeleteLensShareOutput,
                crate::error::DeleteLensShareError,
                crate::input::DeleteLensShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkload`.
    ///
    /// <p>Delete an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workload_input::Builder,
    }
    impl<C, M, R> DeleteWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkloadInputOperationOutputAlias,
                crate::output::DeleteWorkloadOutput,
                crate::error::DeleteWorkloadError,
                crate::input::DeleteWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkloadShare`.
    ///
    /// <p>Delete a workload share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workload_share_input::Builder,
    }
    impl<C, M, R> DeleteWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkloadShareInputOperationOutputAlias,
                crate::output::DeleteWorkloadShareOutput,
                crate::error::DeleteWorkloadShareError,
                crate::input::DeleteWorkloadShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLenses`.
    ///
    /// <p>Disassociate a lens from a workload.</p>
    /// <p>Up to 10 lenses can be disassociated from a workload in a single API operation.</p> <note>
    /// <p>The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a workload.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lenses_input::Builder,
    }
    impl<C, M, R> DisassociateLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLensesInputOperationOutputAlias,
                crate::output::DisassociateLensesOutput,
                crate::error::DisassociateLensesError,
                crate::input::DisassociateLensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// Appends an item to `LensAliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_aliases(input.into());
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lens_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportLens`.
    ///
    /// <p>Export an existing lens.</p>
    /// <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>. Only the owner of a lens can export it. </p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_lens_input::Builder,
    }
    impl<C, M, R> ExportLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportLensOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportLensInputOperationOutputAlias,
                crate::output::ExportLensOutput,
                crate::error::ExportLensError,
                crate::input::ExportLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The lens version to be exported.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_version(input.into());
            self
        }
        /// <p>The lens version to be exported.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnswer`.
    ///
    /// <p>Get the answer to a specific question in a workload review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_answer_input::Builder,
    }
    impl<C, M, R> GetAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnswerInputOperationOutputAlias,
                crate::output::GetAnswerOutput,
                crate::error::GetAnswerError,
                crate::input::GetAnswerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_id(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLens`.
    ///
    /// <p>Get an existing lens.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_input::Builder,
    }
    impl<C, M, R> GetLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensInputOperationOutputAlias,
                crate::output::GetLensOutput,
                crate::error::GetLensError,
                crate::input::GetLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The lens version to be retrieved.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_version(input.into());
            self
        }
        /// <p>The lens version to be retrieved.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensReview`.
    ///
    /// <p>Get lens review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_review_input::Builder,
    }
    impl<C, M, R> GetLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensReviewInputOperationOutputAlias,
                crate::output::GetLensReviewOutput,
                crate::error::GetLensReviewError,
                crate::input::GetLensReviewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensReviewReport`.
    ///
    /// <p>Get lens review report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLensReviewReport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_review_report_input::Builder,
    }
    impl<C, M, R> GetLensReviewReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensReviewReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensReviewReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensReviewReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensReviewReportInputOperationOutputAlias,
                crate::output::GetLensReviewReportOutput,
                crate::error::GetLensReviewReportError,
                crate::input::GetLensReviewReportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensVersionDifference`.
    ///
    /// <p>Get lens version differences.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLensVersionDifference<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_version_difference_input::Builder,
    }
    impl<C, M, R> GetLensVersionDifference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensVersionDifference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensVersionDifferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensVersionDifferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensVersionDifferenceInputOperationOutputAlias,
                crate::output::GetLensVersionDifferenceOutput,
                crate::error::GetLensVersionDifferenceError,
                crate::input::GetLensVersionDifferenceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn base_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_lens_version(input.into());
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn set_base_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_lens_version(input);
            self
        }
        /// <p>The lens version to target a difference for.</p>
        pub fn target_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_lens_version(input.into());
            self
        }
        /// <p>The lens version to target a difference for.</p>
        pub fn set_target_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMilestone`.
    ///
    /// <p>Get a milestone for an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMilestone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_milestone_input::Builder,
    }
    impl<C, M, R> GetMilestone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMilestone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMilestoneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMilestoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMilestoneInputOperationOutputAlias,
                crate::output::GetMilestoneOutput,
                crate::error::GetMilestoneError,
                crate::input::GetMilestoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkload`.
    ///
    /// <p>Get an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workload_input::Builder,
    }
    impl<C, M, R> GetWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkloadInputOperationOutputAlias,
                crate::output::GetWorkloadOutput,
                crate::error::GetWorkloadError,
                crate::input::GetWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportLens`.
    ///
    /// <p>Import a new lens.</p>
    /// <p>The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with <code>CreateLensVersion</code> </p>
    /// <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>.</p>
    /// <p>A custom lens cannot exceed 500 KB in size.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_lens_input::Builder,
    }
    impl<C, M, R> ImportLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportLensOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportLensInputOperationOutputAlias,
                crate::output::ImportLensOutput,
                crate::error::ImportLensError,
                crate::input::ImportLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The JSON representation of a lens.</p>
        pub fn json_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.json_string(input.into());
            self
        }
        /// <p>The JSON representation of a lens.</p>
        pub fn set_json_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_json_string(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associate to a lens.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to associate to a lens.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnswers`.
    ///
    /// <p>List of answers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAnswers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_answers_input::Builder,
    }
    impl<C, M, R> ListAnswers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnswers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnswersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnswersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnswersInputOperationOutputAlias,
                crate::output::ListAnswersOutput,
                crate::error::ListAnswersError,
                crate::input::ListAnswersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAnswersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAnswersPaginator<C, M, R> {
            crate::paginator::ListAnswersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_id(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pillar_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLenses`.
    ///
    /// <p>List the available lenses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lenses_input::Builder,
    }
    impl<C, M, R> ListLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensesInputOperationOutputAlias,
                crate::output::ListLensesOutput,
                crate::error::ListLensesError,
                crate::input::ListLensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLensesPaginator<C, M, R> {
            crate::paginator::ListLensesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The type of lenses to be returned.</p>
        pub fn lens_type(mut self, input: crate::model::LensType) -> Self {
            self.inner = self.inner.lens_type(input);
            self
        }
        /// <p>The type of lenses to be returned.</p>
        pub fn set_lens_type(mut self, input: std::option::Option<crate::model::LensType>) -> Self {
            self.inner = self.inner.set_lens_type(input);
            self
        }
        /// <p>The status of lenses to be returned.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatusType) -> Self {
            self.inner = self.inner.lens_status(input);
            self
        }
        /// <p>The status of lenses to be returned.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatusType>,
        ) -> Self {
            self.inner = self.inner.set_lens_status(input);
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn lens_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_name(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_lens_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensReviewImprovements`.
    ///
    /// <p>List lens review improvements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLensReviewImprovements<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_review_improvements_input::Builder,
    }
    impl<C, M, R> ListLensReviewImprovements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensReviewImprovements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensReviewImprovementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensReviewImprovementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensReviewImprovementsInputOperationOutputAlias,
                crate::output::ListLensReviewImprovementsOutput,
                crate::error::ListLensReviewImprovementsError,
                crate::input::ListLensReviewImprovementsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensReviewImprovementsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListLensReviewImprovementsPaginator<C, M, R> {
            crate::paginator::ListLensReviewImprovementsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_id(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pillar_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensReviews`.
    ///
    /// <p>List lens reviews.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLensReviews<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_reviews_input::Builder,
    }
    impl<C, M, R> ListLensReviews<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensReviews`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensReviewsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensReviewsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensReviewsInputOperationOutputAlias,
                crate::output::ListLensReviewsOutput,
                crate::error::ListLensReviewsError,
                crate::input::ListLensReviewsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensReviewsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLensReviewsPaginator<C, M, R> {
            crate::paginator::ListLensReviewsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensShares`.
    ///
    /// <p>List the lens shares associated with the lens.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLensShares<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_shares_input::Builder,
    }
    impl<C, M, R> ListLensShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensSharesInputOperationOutputAlias,
                crate::output::ListLensSharesOutput,
                crate::error::ListLensSharesError,
                crate::input::ListLensSharesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLensSharesPaginator<C, M, R> {
            crate::paginator::ListLensSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the lens is shared.</p>
        pub fn shared_with_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with_prefix(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the lens is shared.</p>
        pub fn set_shared_with_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_with_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMilestones`.
    ///
    /// <p>List all milestones for an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMilestones<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_milestones_input::Builder,
    }
    impl<C, M, R> ListMilestones<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMilestones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMilestonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMilestonesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMilestonesInputOperationOutputAlias,
                crate::output::ListMilestonesOutput,
                crate::error::ListMilestonesError,
                crate::input::ListMilestonesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMilestonesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMilestonesPaginator<C, M, R> {
            crate::paginator::ListMilestonesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotifications`.
    ///
    /// <p>List lens notifications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_notifications_input::Builder,
    }
    impl<C, M, R> ListNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNotificationsInputOperationOutputAlias,
                crate::output::ListNotificationsOutput,
                crate::error::ListNotificationsError,
                crate::input::ListNotificationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNotificationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNotificationsPaginator<C, M, R> {
            crate::paginator::ListNotificationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListShareInvitations`.
    ///
    /// <p>List the workload invitations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListShareInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_share_invitations_input::Builder,
    }
    impl<C, M, R> ListShareInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListShareInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListShareInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListShareInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListShareInvitationsInputOperationOutputAlias,
                crate::output::ListShareInvitationsOutput,
                crate::error::ListShareInvitationsError,
                crate::input::ListShareInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListShareInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListShareInvitationsPaginator<C, M, R> {
            crate::paginator::ListShareInvitationsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn workload_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name_prefix(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name_prefix(input);
            self
        }
        /// <p>An optional string added to the beginning of each lens name returned in the results.</p>
        pub fn lens_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_name_prefix(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each lens name returned in the results.</p>
        pub fn set_lens_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lens_name_prefix(input);
            self
        }
        /// <p>The type of share invitations to be returned.</p>
        pub fn share_resource_type(mut self, input: crate::model::ShareResourceType) -> Self {
            self.inner = self.inner.share_resource_type(input);
            self
        }
        /// <p>The type of share invitations to be returned.</p>
        pub fn set_share_resource_type(
            mut self,
            input: std::option::Option<crate::model::ShareResourceType>,
        ) -> Self {
            self.inner = self.inner.set_share_resource_type(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkloads`.
    ///
    /// <p>List workloads. Paginated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkloads<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workloads_input::Builder,
    }
    impl<C, M, R> ListWorkloads<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkloads`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkloadsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkloadsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkloadsInputOperationOutputAlias,
                crate::output::ListWorkloadsOutput,
                crate::error::ListWorkloadsError,
                crate::input::ListWorkloadsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkloadsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkloadsPaginator<C, M, R> {
            crate::paginator::ListWorkloadsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn workload_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name_prefix(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkloadShares`.
    ///
    /// <p>List the workload shares associated with the workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkloadShares<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workload_shares_input::Builder,
    }
    impl<C, M, R> ListWorkloadShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkloadShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkloadSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkloadSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkloadSharesInputOperationOutputAlias,
                crate::output::ListWorkloadSharesOutput,
                crate::error::ListWorkloadSharesError,
                crate::input::ListWorkloadSharesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkloadSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkloadSharesPaginator<C, M, R> {
            crate::paginator::ListWorkloadSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with_prefix(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_with_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    /// <p>To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:</p>
    /// <p> <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnswer`.
    ///
    /// <p>Update the answer to a specific question in a workload review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_answer_input::Builder,
    }
    impl<C, M, R> UpdateAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnswerInputOperationOutputAlias,
                crate::output::UpdateAnswerOutput,
                crate::error::UpdateAnswerError,
                crate::input::UpdateAnswerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_id(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question_id(input);
            self
        }
        /// Appends an item to `SelectedChoices`.
        ///
        /// To override the contents of this collection use [`set_selected_choices`](Self::set_selected_choices).
        ///
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn selected_choices(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_choices(input.into());
            self
        }
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn set_selected_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_choices(input);
            self
        }
        /// Adds a key-value pair to `ChoiceUpdates`.
        ///
        /// To override the contents of this collection use [`set_choice_updates`](Self::set_choice_updates).
        ///
        /// <p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>
        pub fn choice_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ChoiceUpdate,
        ) -> Self {
            self.inner = self.inner.choice_updates(k.into(), v);
            self
        }
        /// <p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>
        pub fn set_choice_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ChoiceUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_choice_updates(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn is_applicable(mut self, input: bool) -> Self {
            self.inner = self.inner.is_applicable(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn set_is_applicable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_applicable(input);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn reason(mut self, input: crate::model::AnswerReason) -> Self {
            self.inner = self.inner.reason(input);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AnswerReason>,
        ) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLensReview`.
    ///
    /// <p>Update lens review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_lens_review_input::Builder,
    }
    impl<C, M, R> UpdateLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLensReviewInputOperationOutputAlias,
                crate::output::UpdateLensReviewOutput,
                crate::error::UpdateLensReviewError,
                crate::input::UpdateLensReviewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn lens_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_lens_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_notes(input);
            self
        }
        /// Adds a key-value pair to `PillarNotes`.
        ///
        /// To override the contents of this collection use [`set_pillar_notes`](Self::set_pillar_notes).
        ///
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn pillar_notes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pillar_notes(k.into(), v.into());
            self
        }
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn set_pillar_notes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_pillar_notes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateShareInvitation`.
    ///
    /// <p>Update a workload invitation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateShareInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_share_invitation_input::Builder,
    }
    impl<C, M, R> UpdateShareInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateShareInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateShareInvitationInputOperationOutputAlias,
                crate::output::UpdateShareInvitationOutput,
                crate::error::UpdateShareInvitationError,
                crate::input::UpdateShareInvitationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_invitation_id(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_share_invitation_id(input);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn share_invitation_action(
            mut self,
            input: crate::model::ShareInvitationAction,
        ) -> Self {
            self.inner = self.inner.share_invitation_action(input);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn set_share_invitation_action(
            mut self,
            input: std::option::Option<crate::model::ShareInvitationAction>,
        ) -> Self {
            self.inner = self.inner.set_share_invitation_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkload`.
    ///
    /// <p>Update an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workload_input::Builder,
    }
    impl<C, M, R> UpdateWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkloadInputOperationOutputAlias,
                crate::output::UpdateWorkloadOutput,
                crate::error::UpdateWorkloadError,
                crate::input::UpdateWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name(input);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `AwsRegions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_regions(input.into());
            self
        }
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_regions(input);
            self
        }
        /// Appends an item to `NonAwsRegions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.non_aws_regions(input.into());
            self
        }
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_non_aws_regions(input);
            self
        }
        /// Appends an item to `PillarPriorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_priorities(input.into());
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pillar_priorities(input);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.architectural_design(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_architectural_design(input);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.review_owner(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_review_owner(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>
        pub fn is_review_owner_update_acknowledged(mut self, input: bool) -> Self {
            self.inner = self.inner.is_review_owner_update_acknowledged(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>
        pub fn set_is_review_owner_update_acknowledged(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_is_review_owner_update_acknowledged(input);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry_type(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_industry_type(input);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_industry(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn improvement_status(
            mut self,
            input: crate::model::WorkloadImprovementStatus,
        ) -> Self {
            self.inner = self.inner.improvement_status(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn set_improvement_status(
            mut self,
            input: std::option::Option<crate::model::WorkloadImprovementStatus>,
        ) -> Self {
            self.inner = self.inner.set_improvement_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkloadShare`.
    ///
    /// <p>Update a workload share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workload_share_input::Builder,
    }
    impl<C, M, R> UpdateWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkloadShareInputOperationOutputAlias,
                crate::output::UpdateWorkloadShareOutput,
                crate::error::UpdateWorkloadShareError,
                crate::input::UpdateWorkloadShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeLensReview`.
    ///
    /// <p>Upgrade lens review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradeLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_lens_review_input::Builder,
    }
    impl<C, M, R> UpgradeLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradeLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradeLensReviewInputOperationOutputAlias,
                crate::output::UpgradeLensReviewOutput,
                crate::error::UpgradeLensReviewError,
                crate::input::UpgradeLensReviewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.milestone_name(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_milestone_name(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
