// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Well-Architected Tool
///
/// Client for invoking operations on AWS Well-Architected Tool. Each operation on AWS Well-Architected Tool is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_wellarchitected::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_wellarchitected::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_wellarchitected::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateLenses` operation.
    ///
    /// See [`AssociateLenses`](crate::client::fluent_builders::AssociateLenses) for more information about the
    /// operation and its arguments.
    pub fn associate_lenses(&self) -> fluent_builders::AssociateLenses<C, M, R> {
        fluent_builders::AssociateLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLensShare` operation.
    ///
    /// See [`CreateLensShare`](crate::client::fluent_builders::CreateLensShare) for more information about the
    /// operation and its arguments.
    pub fn create_lens_share(&self) -> fluent_builders::CreateLensShare<C, M, R> {
        fluent_builders::CreateLensShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLensVersion` operation.
    ///
    /// See [`CreateLensVersion`](crate::client::fluent_builders::CreateLensVersion) for more information about the
    /// operation and its arguments.
    pub fn create_lens_version(&self) -> fluent_builders::CreateLensVersion<C, M, R> {
        fluent_builders::CreateLensVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMilestone` operation.
    ///
    /// See [`CreateMilestone`](crate::client::fluent_builders::CreateMilestone) for more information about the
    /// operation and its arguments.
    pub fn create_milestone(&self) -> fluent_builders::CreateMilestone<C, M, R> {
        fluent_builders::CreateMilestone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkload` operation.
    ///
    /// See [`CreateWorkload`](crate::client::fluent_builders::CreateWorkload) for more information about the
    /// operation and its arguments.
    pub fn create_workload(&self) -> fluent_builders::CreateWorkload<C, M, R> {
        fluent_builders::CreateWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkloadShare` operation.
    ///
    /// See [`CreateWorkloadShare`](crate::client::fluent_builders::CreateWorkloadShare) for more information about the
    /// operation and its arguments.
    pub fn create_workload_share(&self) -> fluent_builders::CreateWorkloadShare<C, M, R> {
        fluent_builders::CreateWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLens` operation.
    ///
    /// See [`DeleteLens`](crate::client::fluent_builders::DeleteLens) for more information about the
    /// operation and its arguments.
    pub fn delete_lens(&self) -> fluent_builders::DeleteLens<C, M, R> {
        fluent_builders::DeleteLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLensShare` operation.
    ///
    /// See [`DeleteLensShare`](crate::client::fluent_builders::DeleteLensShare) for more information about the
    /// operation and its arguments.
    pub fn delete_lens_share(&self) -> fluent_builders::DeleteLensShare<C, M, R> {
        fluent_builders::DeleteLensShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkload` operation.
    ///
    /// See [`DeleteWorkload`](crate::client::fluent_builders::DeleteWorkload) for more information about the
    /// operation and its arguments.
    pub fn delete_workload(&self) -> fluent_builders::DeleteWorkload<C, M, R> {
        fluent_builders::DeleteWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkloadShare` operation.
    ///
    /// See [`DeleteWorkloadShare`](crate::client::fluent_builders::DeleteWorkloadShare) for more information about the
    /// operation and its arguments.
    pub fn delete_workload_share(&self) -> fluent_builders::DeleteWorkloadShare<C, M, R> {
        fluent_builders::DeleteWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateLenses` operation.
    ///
    /// See [`DisassociateLenses`](crate::client::fluent_builders::DisassociateLenses) for more information about the
    /// operation and its arguments.
    pub fn disassociate_lenses(&self) -> fluent_builders::DisassociateLenses<C, M, R> {
        fluent_builders::DisassociateLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportLens` operation.
    ///
    /// See [`ExportLens`](crate::client::fluent_builders::ExportLens) for more information about the
    /// operation and its arguments.
    pub fn export_lens(&self) -> fluent_builders::ExportLens<C, M, R> {
        fluent_builders::ExportLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAnswer` operation.
    ///
    /// See [`GetAnswer`](crate::client::fluent_builders::GetAnswer) for more information about the
    /// operation and its arguments.
    pub fn get_answer(&self) -> fluent_builders::GetAnswer<C, M, R> {
        fluent_builders::GetAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLens` operation.
    ///
    /// See [`GetLens`](crate::client::fluent_builders::GetLens) for more information about the
    /// operation and its arguments.
    pub fn get_lens(&self) -> fluent_builders::GetLens<C, M, R> {
        fluent_builders::GetLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLensReview` operation.
    ///
    /// See [`GetLensReview`](crate::client::fluent_builders::GetLensReview) for more information about the
    /// operation and its arguments.
    pub fn get_lens_review(&self) -> fluent_builders::GetLensReview<C, M, R> {
        fluent_builders::GetLensReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLensReviewReport` operation.
    ///
    /// See [`GetLensReviewReport`](crate::client::fluent_builders::GetLensReviewReport) for more information about the
    /// operation and its arguments.
    pub fn get_lens_review_report(&self) -> fluent_builders::GetLensReviewReport<C, M, R> {
        fluent_builders::GetLensReviewReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLensVersionDifference` operation.
    ///
    /// See [`GetLensVersionDifference`](crate::client::fluent_builders::GetLensVersionDifference) for more information about the
    /// operation and its arguments.
    pub fn get_lens_version_difference(
        &self,
    ) -> fluent_builders::GetLensVersionDifference<C, M, R> {
        fluent_builders::GetLensVersionDifference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMilestone` operation.
    ///
    /// See [`GetMilestone`](crate::client::fluent_builders::GetMilestone) for more information about the
    /// operation and its arguments.
    pub fn get_milestone(&self) -> fluent_builders::GetMilestone<C, M, R> {
        fluent_builders::GetMilestone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkload` operation.
    ///
    /// See [`GetWorkload`](crate::client::fluent_builders::GetWorkload) for more information about the
    /// operation and its arguments.
    pub fn get_workload(&self) -> fluent_builders::GetWorkload<C, M, R> {
        fluent_builders::GetWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportLens` operation.
    ///
    /// See [`ImportLens`](crate::client::fluent_builders::ImportLens) for more information about the
    /// operation and its arguments.
    pub fn import_lens(&self) -> fluent_builders::ImportLens<C, M, R> {
        fluent_builders::ImportLens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnswers` operation.
    ///
    /// See [`ListAnswers`](crate::client::fluent_builders::ListAnswers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAnswers::into_paginator).
    pub fn list_answers(&self) -> fluent_builders::ListAnswers<C, M, R> {
        fluent_builders::ListAnswers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLenses` operation.
    ///
    /// See [`ListLenses`](crate::client::fluent_builders::ListLenses) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLenses::into_paginator).
    pub fn list_lenses(&self) -> fluent_builders::ListLenses<C, M, R> {
        fluent_builders::ListLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLensReviewImprovements` operation.
    ///
    /// See [`ListLensReviewImprovements`](crate::client::fluent_builders::ListLensReviewImprovements) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLensReviewImprovements::into_paginator).
    pub fn list_lens_review_improvements(
        &self,
    ) -> fluent_builders::ListLensReviewImprovements<C, M, R> {
        fluent_builders::ListLensReviewImprovements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLensReviews` operation.
    ///
    /// See [`ListLensReviews`](crate::client::fluent_builders::ListLensReviews) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLensReviews::into_paginator).
    pub fn list_lens_reviews(&self) -> fluent_builders::ListLensReviews<C, M, R> {
        fluent_builders::ListLensReviews::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLensShares` operation.
    ///
    /// See [`ListLensShares`](crate::client::fluent_builders::ListLensShares) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLensShares::into_paginator).
    pub fn list_lens_shares(&self) -> fluent_builders::ListLensShares<C, M, R> {
        fluent_builders::ListLensShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMilestones` operation.
    ///
    /// See [`ListMilestones`](crate::client::fluent_builders::ListMilestones) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListMilestones::into_paginator).
    pub fn list_milestones(&self) -> fluent_builders::ListMilestones<C, M, R> {
        fluent_builders::ListMilestones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotifications` operation.
    ///
    /// See [`ListNotifications`](crate::client::fluent_builders::ListNotifications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListNotifications::into_paginator).
    pub fn list_notifications(&self) -> fluent_builders::ListNotifications<C, M, R> {
        fluent_builders::ListNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListShareInvitations` operation.
    ///
    /// See [`ListShareInvitations`](crate::client::fluent_builders::ListShareInvitations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListShareInvitations::into_paginator).
    pub fn list_share_invitations(&self) -> fluent_builders::ListShareInvitations<C, M, R> {
        fluent_builders::ListShareInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkloads` operation.
    ///
    /// See [`ListWorkloads`](crate::client::fluent_builders::ListWorkloads) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorkloads::into_paginator).
    pub fn list_workloads(&self) -> fluent_builders::ListWorkloads<C, M, R> {
        fluent_builders::ListWorkloads::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkloadShares` operation.
    ///
    /// See [`ListWorkloadShares`](crate::client::fluent_builders::ListWorkloadShares) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorkloadShares::into_paginator).
    pub fn list_workload_shares(&self) -> fluent_builders::ListWorkloadShares<C, M, R> {
        fluent_builders::ListWorkloadShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAnswer` operation.
    ///
    /// See [`UpdateAnswer`](crate::client::fluent_builders::UpdateAnswer) for more information about the
    /// operation and its arguments.
    pub fn update_answer(&self) -> fluent_builders::UpdateAnswer<C, M, R> {
        fluent_builders::UpdateAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLensReview` operation.
    ///
    /// See [`UpdateLensReview`](crate::client::fluent_builders::UpdateLensReview) for more information about the
    /// operation and its arguments.
    pub fn update_lens_review(&self) -> fluent_builders::UpdateLensReview<C, M, R> {
        fluent_builders::UpdateLensReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateShareInvitation` operation.
    ///
    /// See [`UpdateShareInvitation`](crate::client::fluent_builders::UpdateShareInvitation) for more information about the
    /// operation and its arguments.
    pub fn update_share_invitation(&self) -> fluent_builders::UpdateShareInvitation<C, M, R> {
        fluent_builders::UpdateShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkload` operation.
    ///
    /// See [`UpdateWorkload`](crate::client::fluent_builders::UpdateWorkload) for more information about the
    /// operation and its arguments.
    pub fn update_workload(&self) -> fluent_builders::UpdateWorkload<C, M, R> {
        fluent_builders::UpdateWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkloadShare` operation.
    ///
    /// See [`UpdateWorkloadShare`](crate::client::fluent_builders::UpdateWorkloadShare) for more information about the
    /// operation and its arguments.
    pub fn update_workload_share(&self) -> fluent_builders::UpdateWorkloadShare<C, M, R> {
        fluent_builders::UpdateWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpgradeLensReview` operation.
    ///
    /// See [`UpgradeLensReview`](crate::client::fluent_builders::UpgradeLensReview) for more information about the
    /// operation and its arguments.
    pub fn upgrade_lens_review(&self) -> fluent_builders::UpgradeLensReview<C, M, R> {
        fluent_builders::UpgradeLensReview::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateLenses`.
    ///
    /// <p>Associate a lens to a workload.</p>
    /// <p>Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lenses_input::Builder,
    }
    impl<C, M, R> AssociateLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLensesInputOperationOutputAlias,
                crate::output::AssociateLensesOutput,
                crate::error::AssociateLensesError,
                crate::input::AssociateLensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// Appends an item to `LensAliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_aliases(input.into());
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lens_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLensShare`.
    ///
    /// <p>Create a lens share.</p>
    /// <p>The owner of a lens can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a lens is not removed until the lens invitation is deleted.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLensShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lens_share_input::Builder,
    }
    impl<C, M, R> CreateLensShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLensShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLensShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLensShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLensShareInputOperationOutputAlias,
                crate::output::CreateLensShareOutput,
                crate::error::CreateLensShareError,
                crate::input::CreateLensShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shared_with(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLensVersion`.
    ///
    /// <p>Create a new lens version.</p>
    /// <p>A lens can have up to 100 versions.</p>
    /// <p>After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a lens can delete it. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLensVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_lens_version_input::Builder,
    }
    impl<C, M, R> CreateLensVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLensVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLensVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLensVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLensVersionInputOperationOutputAlias,
                crate::output::CreateLensVersionOutput,
                crate::error::CreateLensVersionError,
                crate::input::CreateLensVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The version of the lens being created.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_version(input.into());
            self
        }
        /// <p>The version of the lens being created.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_version(input);
            self
        }
        /// <p>Set to true if this new major lens version.</p>
        pub fn is_major_version(mut self, input: bool) -> Self {
            self.inner = self.inner.is_major_version(input);
            self
        }
        /// <p>Set to true if this new major lens version.</p>
        pub fn set_is_major_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_major_version(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMilestone`.
    ///
    /// <p>Create a milestone for an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMilestone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_milestone_input::Builder,
    }
    impl<C, M, R> CreateMilestone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMilestone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMilestoneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMilestoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMilestoneInputOperationOutputAlias,
                crate::output::CreateMilestoneOutput,
                crate::error::CreateMilestoneError,
                crate::input::CreateMilestoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.milestone_name(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_milestone_name(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkload`.
    ///
    /// <p>Create a new workload.</p>
    /// <p>The owner of a workload can share the workload with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a workload can delete it.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workload_input::Builder,
    }
    impl<C, M, R> CreateWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkloadInputOperationOutputAlias,
                crate::output::CreateWorkloadOutput,
                crate::error::CreateWorkloadError,
                crate::input::CreateWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name(input);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `AwsRegions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_regions(input.into());
            self
        }
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_regions(input);
            self
        }
        /// Appends an item to `NonAwsRegions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.non_aws_regions(input.into());
            self
        }
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_non_aws_regions(input);
            self
        }
        /// Appends an item to `PillarPriorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_priorities(input.into());
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pillar_priorities(input);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.architectural_design(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_architectural_design(input);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.review_owner(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_review_owner(input);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry_type(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_industry_type(input);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_industry(input);
            self
        }
        /// Appends an item to `Lenses`.
        ///
        /// To override the contents of this collection use [`set_lenses`](Self::set_lenses).
        ///
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lenses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lenses(input.into());
            self
        }
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lenses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lenses(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the workload.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to be associated with the workload.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkloadShare`.
    ///
    /// <p>Create a workload share.</p>
    /// <p>The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workload_share_input::Builder,
    }
    impl<C, M, R> CreateWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkloadShareInputOperationOutputAlias,
                crate::output::CreateWorkloadShareOutput,
                crate::error::CreateWorkloadShareError,
                crate::input::CreateWorkloadShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shared_with(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLens`.
    ///
    /// <p>Delete an existing lens.</p>
    /// <p>Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads. </p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lens_input::Builder,
    }
    impl<C, M, R> DeleteLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLensOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLensInputOperationOutputAlias,
                crate::output::DeleteLensOutput,
                crate::error::DeleteLensError,
                crate::input::DeleteLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The status of the lens to be deleted.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatusType) -> Self {
            self.inner = self.inner.lens_status(input);
            self
        }
        /// <p>The status of the lens to be deleted.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatusType>,
        ) -> Self {
            self.inner = self.inner.set_lens_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLensShare`.
    ///
    /// <p>Delete a lens share.</p>
    /// <p>After the lens share is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLensShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lens_share_input::Builder,
    }
    impl<C, M, R> DeleteLensShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLensShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLensShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLensShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLensShareInputOperationOutputAlias,
                crate::output::DeleteLensShareOutput,
                crate::error::DeleteLensShareError,
                crate::input::DeleteLensShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkload`.
    ///
    /// <p>Delete an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workload_input::Builder,
    }
    impl<C, M, R> DeleteWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkloadInputOperationOutputAlias,
                crate::output::DeleteWorkloadOutput,
                crate::error::DeleteWorkloadError,
                crate::input::DeleteWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkloadShare`.
    ///
    /// <p>Delete a workload share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workload_share_input::Builder,
    }
    impl<C, M, R> DeleteWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkloadShareInputOperationOutputAlias,
                crate::output::DeleteWorkloadShareOutput,
                crate::error::DeleteWorkloadShareError,
                crate::input::DeleteWorkloadShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLenses`.
    ///
    /// <p>Disassociate a lens from a workload.</p>
    /// <p>Up to 10 lenses can be disassociated from a workload in a single API operation.</p> <note>
    /// <p>The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a workload.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lenses_input::Builder,
    }
    impl<C, M, R> DisassociateLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLensesInputOperationOutputAlias,
                crate::output::DisassociateLensesOutput,
                crate::error::DisassociateLensesError,
                crate::input::DisassociateLensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// Appends an item to `LensAliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_aliases(input.into());
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p>
        /// <p>Identify a lens using its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lens_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportLens`.
    ///
    /// <p>Export an existing lens.</p>
    /// <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>. Only the owner of a lens can export it. </p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_lens_input::Builder,
    }
    impl<C, M, R> ExportLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportLensOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportLensInputOperationOutputAlias,
                crate::output::ExportLensOutput,
                crate::error::ExportLensError,
                crate::input::ExportLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The lens version to be exported.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_version(input.into());
            self
        }
        /// <p>The lens version to be exported.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnswer`.
    ///
    /// <p>Get the answer to a specific question in a workload review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_answer_input::Builder,
    }
    impl<C, M, R> GetAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnswerInputOperationOutputAlias,
                crate::output::GetAnswerOutput,
                crate::error::GetAnswerError,
                crate::input::GetAnswerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_id(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLens`.
    ///
    /// <p>Get an existing lens.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_input::Builder,
    }
    impl<C, M, R> GetLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensInputOperationOutputAlias,
                crate::output::GetLensOutput,
                crate::error::GetLensError,
                crate::input::GetLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The lens version to be retrieved.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_version(input.into());
            self
        }
        /// <p>The lens version to be retrieved.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensReview`.
    ///
    /// <p>Get lens review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_review_input::Builder,
    }
    impl<C, M, R> GetLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensReviewInputOperationOutputAlias,
                crate::output::GetLensReviewOutput,
                crate::error::GetLensReviewError,
                crate::input::GetLensReviewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensReviewReport`.
    ///
    /// <p>Get lens review report.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLensReviewReport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_review_report_input::Builder,
    }
    impl<C, M, R> GetLensReviewReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensReviewReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensReviewReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensReviewReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensReviewReportInputOperationOutputAlias,
                crate::output::GetLensReviewReportOutput,
                crate::error::GetLensReviewReportError,
                crate::input::GetLensReviewReportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensVersionDifference`.
    ///
    /// <p>Get lens version differences.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLensVersionDifference<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_version_difference_input::Builder,
    }
    impl<C, M, R> GetLensVersionDifference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensVersionDifference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensVersionDifferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensVersionDifferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensVersionDifferenceInputOperationOutputAlias,
                crate::output::GetLensVersionDifferenceOutput,
                crate::error::GetLensVersionDifferenceError,
                crate::input::GetLensVersionDifferenceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn base_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_lens_version(input.into());
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn set_base_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_lens_version(input);
            self
        }
        /// <p>The lens version to target a difference for.</p>
        pub fn target_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_lens_version(input.into());
            self
        }
        /// <p>The lens version to target a difference for.</p>
        pub fn set_target_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMilestone`.
    ///
    /// <p>Get a milestone for an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMilestone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_milestone_input::Builder,
    }
    impl<C, M, R> GetMilestone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMilestone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMilestoneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMilestoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMilestoneInputOperationOutputAlias,
                crate::output::GetMilestoneOutput,
                crate::error::GetMilestoneError,
                crate::input::GetMilestoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkload`.
    ///
    /// <p>Get an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workload_input::Builder,
    }
    impl<C, M, R> GetWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkloadInputOperationOutputAlias,
                crate::output::GetWorkloadOutput,
                crate::error::GetWorkloadError,
                crate::input::GetWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportLens`.
    ///
    /// <p>Import a new lens.</p>
    /// <p>The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it's published with <code>CreateLensVersion</code> </p>
    /// <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>.</p>
    /// <p>A custom lens cannot exceed 500 KB in size.</p> <note>
    /// <p> <b>Disclaimer</b> </p>
    /// <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportLens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_lens_input::Builder,
    }
    impl<C, M, R> ImportLens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportLens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportLensOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportLensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportLensInputOperationOutputAlias,
                crate::output::ImportLensOutput,
                crate::error::ImportLensError,
                crate::input::ImportLensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The JSON representation of a lens.</p>
        pub fn json_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.json_string(input.into());
            self
        }
        /// <p>The JSON representation of a lens.</p>
        pub fn set_json_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_json_string(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associate to a lens.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to associate to a lens.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnswers`.
    ///
    /// <p>List of answers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAnswers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_answers_input::Builder,
    }
    impl<C, M, R> ListAnswers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnswers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnswersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnswersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnswersInputOperationOutputAlias,
                crate::output::ListAnswersOutput,
                crate::error::ListAnswersError,
                crate::input::ListAnswersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAnswersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAnswersPaginator<C, M, R> {
            crate::paginator::ListAnswersPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_id(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pillar_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLenses`.
    ///
    /// <p>List the available lenses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lenses_input::Builder,
    }
    impl<C, M, R> ListLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensesInputOperationOutputAlias,
                crate::output::ListLensesOutput,
                crate::error::ListLensesError,
                crate::input::ListLensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLensesPaginator<C, M, R> {
            crate::paginator::ListLensesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The type of lenses to be returned.</p>
        pub fn lens_type(mut self, input: crate::model::LensType) -> Self {
            self.inner = self.inner.lens_type(input);
            self
        }
        /// <p>The type of lenses to be returned.</p>
        pub fn set_lens_type(mut self, input: std::option::Option<crate::model::LensType>) -> Self {
            self.inner = self.inner.set_lens_type(input);
            self
        }
        /// <p>The status of lenses to be returned.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatusType) -> Self {
            self.inner = self.inner.lens_status(input);
            self
        }
        /// <p>The status of lenses to be returned.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatusType>,
        ) -> Self {
            self.inner = self.inner.set_lens_status(input);
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn lens_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_name(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_lens_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensReviewImprovements`.
    ///
    /// <p>List lens review improvements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLensReviewImprovements<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_review_improvements_input::Builder,
    }
    impl<C, M, R> ListLensReviewImprovements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensReviewImprovements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensReviewImprovementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensReviewImprovementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensReviewImprovementsInputOperationOutputAlias,
                crate::output::ListLensReviewImprovementsOutput,
                crate::error::ListLensReviewImprovementsError,
                crate::input::ListLensReviewImprovementsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensReviewImprovementsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListLensReviewImprovementsPaginator<C, M, R> {
            crate::paginator::ListLensReviewImprovementsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_id(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pillar_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensReviews`.
    ///
    /// <p>List lens reviews.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLensReviews<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_reviews_input::Builder,
    }
    impl<C, M, R> ListLensReviews<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensReviews`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensReviewsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensReviewsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensReviewsInputOperationOutputAlias,
                crate::output::ListLensReviewsOutput,
                crate::error::ListLensReviewsError,
                crate::input::ListLensReviewsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensReviewsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLensReviewsPaginator<C, M, R> {
            crate::paginator::ListLensReviewsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.inner = self.inner.milestone_number(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensShares`.
    ///
    /// <p>List the lens shares associated with the lens.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLensShares<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_shares_input::Builder,
    }
    impl<C, M, R> ListLensShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensSharesInputOperationOutputAlias,
                crate::output::ListLensSharesOutput,
                crate::error::ListLensSharesError,
                crate::input::ListLensSharesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLensSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLensSharesPaginator<C, M, R> {
            crate::paginator::ListLensSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the lens is shared.</p>
        pub fn shared_with_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with_prefix(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the lens is shared.</p>
        pub fn set_shared_with_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_with_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMilestones`.
    ///
    /// <p>List all milestones for an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMilestones<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_milestones_input::Builder,
    }
    impl<C, M, R> ListMilestones<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMilestones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMilestonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMilestonesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMilestonesInputOperationOutputAlias,
                crate::output::ListMilestonesOutput,
                crate::error::ListMilestonesError,
                crate::input::ListMilestonesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMilestonesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMilestonesPaginator<C, M, R> {
            crate::paginator::ListMilestonesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotifications`.
    ///
    /// <p>List lens notifications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_notifications_input::Builder,
    }
    impl<C, M, R> ListNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNotificationsInputOperationOutputAlias,
                crate::output::ListNotificationsOutput,
                crate::error::ListNotificationsError,
                crate::input::ListNotificationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNotificationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNotificationsPaginator<C, M, R> {
            crate::paginator::ListNotificationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListShareInvitations`.
    ///
    /// <p>List the workload invitations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListShareInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_share_invitations_input::Builder,
    }
    impl<C, M, R> ListShareInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListShareInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListShareInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListShareInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListShareInvitationsInputOperationOutputAlias,
                crate::output::ListShareInvitationsOutput,
                crate::error::ListShareInvitationsError,
                crate::input::ListShareInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListShareInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListShareInvitationsPaginator<C, M, R> {
            crate::paginator::ListShareInvitationsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn workload_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name_prefix(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name_prefix(input);
            self
        }
        /// <p>An optional string added to the beginning of each lens name returned in the results.</p>
        pub fn lens_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_name_prefix(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each lens name returned in the results.</p>
        pub fn set_lens_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lens_name_prefix(input);
            self
        }
        /// <p>The type of share invitations to be returned.</p>
        pub fn share_resource_type(mut self, input: crate::model::ShareResourceType) -> Self {
            self.inner = self.inner.share_resource_type(input);
            self
        }
        /// <p>The type of share invitations to be returned.</p>
        pub fn set_share_resource_type(
            mut self,
            input: std::option::Option<crate::model::ShareResourceType>,
        ) -> Self {
            self.inner = self.inner.set_share_resource_type(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkloads`.
    ///
    /// <p>List workloads. Paginated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkloads<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workloads_input::Builder,
    }
    impl<C, M, R> ListWorkloads<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkloads`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkloadsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkloadsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkloadsInputOperationOutputAlias,
                crate::output::ListWorkloadsOutput,
                crate::error::ListWorkloadsError,
                crate::input::ListWorkloadsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkloadsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkloadsPaginator<C, M, R> {
            crate::paginator::ListWorkloadsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn workload_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name_prefix(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkloadShares`.
    ///
    /// <p>List the workload shares associated with the workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkloadShares<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workload_shares_input::Builder,
    }
    impl<C, M, R> ListWorkloadShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkloadShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkloadSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkloadSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkloadSharesInputOperationOutputAlias,
                crate::output::ListWorkloadSharesOutput,
                crate::error::ListWorkloadSharesError,
                crate::input::ListWorkloadSharesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkloadSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkloadSharesPaginator<C, M, R> {
            crate::paginator::ListWorkloadSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with_prefix(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_with_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    /// <p>To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:</p>
    /// <p> <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnswer`.
    ///
    /// <p>Update the answer to a specific question in a workload review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_answer_input::Builder,
    }
    impl<C, M, R> UpdateAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnswerInputOperationOutputAlias,
                crate::output::UpdateAnswerOutput,
                crate::error::UpdateAnswerError,
                crate::input::UpdateAnswerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_id(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question_id(input);
            self
        }
        /// Appends an item to `SelectedChoices`.
        ///
        /// To override the contents of this collection use [`set_selected_choices`](Self::set_selected_choices).
        ///
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn selected_choices(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_choices(input.into());
            self
        }
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn set_selected_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_choices(input);
            self
        }
        /// Adds a key-value pair to `ChoiceUpdates`.
        ///
        /// To override the contents of this collection use [`set_choice_updates`](Self::set_choice_updates).
        ///
        /// <p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>
        pub fn choice_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ChoiceUpdate,
        ) -> Self {
            self.inner = self.inner.choice_updates(k.into(), v);
            self
        }
        /// <p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>
        pub fn set_choice_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ChoiceUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_choice_updates(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn is_applicable(mut self, input: bool) -> Self {
            self.inner = self.inner.is_applicable(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn set_is_applicable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_applicable(input);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn reason(mut self, input: crate::model::AnswerReason) -> Self {
            self.inner = self.inner.reason(input);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AnswerReason>,
        ) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLensReview`.
    ///
    /// <p>Update lens review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_lens_review_input::Builder,
    }
    impl<C, M, R> UpdateLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLensReviewInputOperationOutputAlias,
                crate::output::UpdateLensReviewOutput,
                crate::error::UpdateLensReviewError,
                crate::input::UpdateLensReviewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn lens_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_lens_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_notes(input);
            self
        }
        /// Adds a key-value pair to `PillarNotes`.
        ///
        /// To override the contents of this collection use [`set_pillar_notes`](Self::set_pillar_notes).
        ///
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn pillar_notes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pillar_notes(k.into(), v.into());
            self
        }
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn set_pillar_notes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_pillar_notes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateShareInvitation`.
    ///
    /// <p>Update a workload invitation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateShareInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_share_invitation_input::Builder,
    }
    impl<C, M, R> UpdateShareInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateShareInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateShareInvitationInputOperationOutputAlias,
                crate::output::UpdateShareInvitationOutput,
                crate::error::UpdateShareInvitationError,
                crate::input::UpdateShareInvitationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_invitation_id(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_share_invitation_id(input);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn share_invitation_action(
            mut self,
            input: crate::model::ShareInvitationAction,
        ) -> Self {
            self.inner = self.inner.share_invitation_action(input);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn set_share_invitation_action(
            mut self,
            input: std::option::Option<crate::model::ShareInvitationAction>,
        ) -> Self {
            self.inner = self.inner.set_share_invitation_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkload`.
    ///
    /// <p>Update an existing workload.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workload_input::Builder,
    }
    impl<C, M, R> UpdateWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkloadInputOperationOutputAlias,
                crate::output::UpdateWorkloadOutput,
                crate::error::UpdateWorkloadError,
                crate::input::UpdateWorkloadInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name(input);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `AwsRegions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_regions(input.into());
            self
        }
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_regions(input);
            self
        }
        /// Appends an item to `NonAwsRegions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.non_aws_regions(input.into());
            self
        }
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_non_aws_regions(input);
            self
        }
        /// Appends an item to `PillarPriorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_priorities(input.into());
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <code>PillarReviewSummary$PillarId</code>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pillar_priorities(input);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.architectural_design(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_architectural_design(input);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.review_owner(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_review_owner(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>
        pub fn is_review_owner_update_acknowledged(mut self, input: bool) -> Self {
            self.inner = self.inner.is_review_owner_update_acknowledged(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>
        pub fn set_is_review_owner_update_acknowledged(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_is_review_owner_update_acknowledged(input);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry_type(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Agriculture</code> </p> </li>
        /// <li> <p> <code>Automobile</code> </p> </li>
        /// <li> <p> <code>Defense</code> </p> </li>
        /// <li> <p> <code>Design and Engineering</code> </p> </li>
        /// <li> <p> <code>Digital Advertising</code> </p> </li>
        /// <li> <p> <code>Education</code> </p> </li>
        /// <li> <p> <code>Environmental Protection</code> </p> </li>
        /// <li> <p> <code>Financial Services</code> </p> </li>
        /// <li> <p> <code>Gaming</code> </p> </li>
        /// <li> <p> <code>General Public Services</code> </p> </li>
        /// <li> <p> <code>Healthcare</code> </p> </li>
        /// <li> <p> <code>Hospitality</code> </p> </li>
        /// <li> <p> <code>InfoTech</code> </p> </li>
        /// <li> <p> <code>Justice and Public Safety</code> </p> </li>
        /// <li> <p> <code>Life Sciences</code> </p> </li>
        /// <li> <p> <code>Manufacturing</code> </p> </li>
        /// <li> <p> <code>Media &amp; Entertainment</code> </p> </li>
        /// <li> <p> <code>Mining &amp; Resources</code> </p> </li>
        /// <li> <p> <code>Oil &amp; Gas</code> </p> </li>
        /// <li> <p> <code>Power &amp; Utilities</code> </p> </li>
        /// <li> <p> <code>Professional Services</code> </p> </li>
        /// <li> <p> <code>Real Estate &amp; Construction</code> </p> </li>
        /// <li> <p> <code>Retail &amp; Wholesale</code> </p> </li>
        /// <li> <p> <code>Social Protection</code> </p> </li>
        /// <li> <p> <code>Telecommunications</code> </p> </li>
        /// <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li>
        /// <li> <p> <code>Other</code> </p> </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_industry_type(input);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_industry(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn improvement_status(
            mut self,
            input: crate::model::WorkloadImprovementStatus,
        ) -> Self {
            self.inner = self.inner.improvement_status(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn set_improvement_status(
            mut self,
            input: std::option::Option<crate::model::WorkloadImprovementStatus>,
        ) -> Self {
            self.inner = self.inner.set_improvement_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkloadShare`.
    ///
    /// <p>Update a workload share.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workload_share_input::Builder,
    }
    impl<C, M, R> UpdateWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkloadShareInputOperationOutputAlias,
                crate::output::UpdateWorkloadShareOutput,
                crate::error::UpdateWorkloadShareError,
                crate::input::UpdateWorkloadShareInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeLensReview`.
    ///
    /// <p>Upgrade lens review.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpgradeLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_lens_review_input::Builder,
    }
    impl<C, M, R> UpgradeLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradeLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradeLensReviewInputOperationOutputAlias,
                crate::output::UpgradeLensReviewOutput,
                crate::error::UpgradeLensReviewError,
                crate::input::UpgradeLensReviewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <code>LensSummary$LensAlias</code>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.milestone_name(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_milestone_name(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important>
        /// <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
