// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Stores information about a field passed inside a request that resulted in an exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The field name for which validation failed.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The field name for which validation failed.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Description of the error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field name for which validation failed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The field name for which validation failed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

/// <p>The reason why the request failed validation.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A workload share return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkloadShare {
    /// <p>The ID associated with the workload share.</p>
    pub share_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Web Services account ID.</p>
    pub shared_by: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub shared_with: std::option::Option<std::string::String>,
    /// <p>Permission granted on a workload share.</p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>The status of a workload share.</p>
    pub status: std::option::Option<crate::model::ShareStatus>,
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
}
impl WorkloadShare {
    /// <p>The ID associated with the workload share.</p>
    pub fn share_id(&self) -> std::option::Option<&str> {
        self.share_id.as_deref()
    }
    /// <p>An Amazon Web Services account ID.</p>
    pub fn shared_by(&self) -> std::option::Option<&str> {
        self.shared_by.as_deref()
    }
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub fn shared_with(&self) -> std::option::Option<&str> {
        self.shared_with.as_deref()
    }
    /// <p>Permission granted on a workload share.</p>
    pub fn permission_type(&self) -> std::option::Option<&crate::model::PermissionType> {
        self.permission_type.as_ref()
    }
    /// <p>The status of a workload share.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ShareStatus> {
        self.status.as_ref()
    }
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub fn workload_name(&self) -> std::option::Option<&str> {
        self.workload_name.as_deref()
    }
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
}
impl std::fmt::Debug for WorkloadShare {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkloadShare");
        formatter.field("share_id", &self.share_id);
        formatter.field("shared_by", &self.shared_by);
        formatter.field("shared_with", &self.shared_with);
        formatter.field("permission_type", &self.permission_type);
        formatter.field("status", &self.status);
        formatter.field("workload_name", &self.workload_name);
        formatter.field("workload_id", &self.workload_id);
        formatter.finish()
    }
}
/// See [`WorkloadShare`](crate::model::WorkloadShare)
pub mod workload_share {
    /// A builder for [`WorkloadShare`](crate::model::WorkloadShare)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_id: std::option::Option<std::string::String>,
        pub(crate) shared_by: std::option::Option<std::string::String>,
        pub(crate) shared_with: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) workload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn shared_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_by = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn set_shared_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_by = input;
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_with = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_with = input;
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The status of a workload share.</p>
        pub fn status(mut self, input: crate::model::ShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a workload share.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ShareStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkloadShare`](crate::model::WorkloadShare)
        pub fn build(self) -> crate::model::WorkloadShare {
            crate::model::WorkloadShare {
                share_id: self.share_id,
                shared_by: self.shared_by,
                shared_with: self.shared_with,
                permission_type: self.permission_type,
                status: self.status,
                workload_name: self.workload_name,
                workload_id: self.workload_id,
            }
        }
    }
}
impl WorkloadShare {
    /// Creates a new builder-style object to manufacture [`WorkloadShare`](crate::model::WorkloadShare)
    pub fn builder() -> crate::model::workload_share::Builder {
        crate::model::workload_share::Builder::default()
    }
}

/// <p>The status of a workload share.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareStatus {
    #[allow(missing_docs)] // documentation missing in model
    Accepted,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPTED" => ShareStatus::Accepted,
            "EXPIRED" => ShareStatus::Expired,
            "PENDING" => ShareStatus::Pending,
            "REJECTED" => ShareStatus::Rejected,
            "REVOKED" => ShareStatus::Revoked,
            other => ShareStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareStatus::from(s))
    }
}
impl ShareStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareStatus::Accepted => "ACCEPTED",
            ShareStatus::Expired => "EXPIRED",
            ShareStatus::Pending => "PENDING",
            ShareStatus::Rejected => "REJECTED",
            ShareStatus::Revoked => "REVOKED",
            ShareStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPTED", "EXPIRED", "PENDING", "REJECTED", "REVOKED"]
    }
}
impl AsRef<str> for ShareStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Permission granted on a workload share.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PermissionType {
    #[allow(missing_docs)] // documentation missing in model
    Contributor,
    #[allow(missing_docs)] // documentation missing in model
    Readonly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PermissionType {
    fn from(s: &str) -> Self {
        match s {
            "CONTRIBUTOR" => PermissionType::Contributor,
            "READONLY" => PermissionType::Readonly,
            other => PermissionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PermissionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PermissionType::from(s))
    }
}
impl PermissionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PermissionType::Contributor => "CONTRIBUTOR",
            PermissionType::Readonly => "READONLY",
            PermissionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTRIBUTOR", "READONLY"]
    }
}
impl AsRef<str> for PermissionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A workload return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Workload {
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The ARN for the workload.</p>
    pub workload_arn: std::option::Option<std::string::String>,
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>The description for the workload.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The environment for the workload.</p>
    pub environment: std::option::Option<crate::model::WorkloadEnvironment>,
    /// <p>The date and time recorded.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of Amazon Web Services Regions associated with the workload, for example,
    /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
    pub aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
    pub non_aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The URL of the architectural design for the workload.</p>
    pub architectural_design: std::option::Option<std::string::String>,
    /// <p>The review owner of the workload. The name, email address, or identifier for the
    /// primary group or individual that owns the workload review process.</p>
    pub review_owner: std::option::Option<std::string::String>,
    /// <p>The date and time recorded.</p>
    pub review_restriction_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
    /// owner</i> field is required.</p>
    /// <p>If a <b>Review owner</b> is not added to the workload within
    /// 60 days of acknowledgement, access to the workload is restricted until an owner is
    /// added.</p>
    pub is_review_owner_update_acknowledged: bool,
    /// <p>The industry type for the workload.</p>
    /// <p>If specified, must be one of the following:</p>  
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Agriculture</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Automobile</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Defense</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Design and Engineering</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Digital Advertising</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Education</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Environmental Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Financial Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Gaming</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>General Public Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Healthcare</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Hospitality</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InfoTech</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Justice and Public Safety</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Life Sciences</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Manufacturing</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Media & Entertainment</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Mining & Resources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Oil & Gas</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Power & Utilities</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Professional Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Real Estate & Construction</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Retail & Wholesale</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Social Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Telecommunications</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Travel, Transportation & Logistics</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Other</code>
    /// </p>
    /// </li>
    /// </ul>
    pub industry_type: std::option::Option<std::string::String>,
    /// <p>The industry for the workload.</p>
    pub industry: std::option::Option<std::string::String>,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>The improvement status for a workload.</p>
    pub improvement_status: std::option::Option<crate::model::WorkloadImprovementStatus>,
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub risk_counts: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
    /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
    /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_priorities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lenses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The ID assigned to the share invitation.</p>
    pub share_invitation_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the workload.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Workload {
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The ARN for the workload.</p>
    pub fn workload_arn(&self) -> std::option::Option<&str> {
        self.workload_arn.as_deref()
    }
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub fn workload_name(&self) -> std::option::Option<&str> {
        self.workload_name.as_deref()
    }
    /// <p>The description for the workload.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The environment for the workload.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::WorkloadEnvironment> {
        self.environment.as_ref()
    }
    /// <p>The date and time recorded.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>The list of Amazon Web Services Regions associated with the workload, for example,
    /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
    pub fn aws_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.aws_regions.as_deref()
    }
    /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
    pub fn non_aws_regions(&self) -> std::option::Option<&[std::string::String]> {
        self.non_aws_regions.as_deref()
    }
    /// <p>The URL of the architectural design for the workload.</p>
    pub fn architectural_design(&self) -> std::option::Option<&str> {
        self.architectural_design.as_deref()
    }
    /// <p>The review owner of the workload. The name, email address, or identifier for the
    /// primary group or individual that owns the workload review process.</p>
    pub fn review_owner(&self) -> std::option::Option<&str> {
        self.review_owner.as_deref()
    }
    /// <p>The date and time recorded.</p>
    pub fn review_restriction_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.review_restriction_date.as_ref()
    }
    /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
    /// owner</i> field is required.</p>
    /// <p>If a <b>Review owner</b> is not added to the workload within
    /// 60 days of acknowledgement, access to the workload is restricted until an owner is
    /// added.</p>
    pub fn is_review_owner_update_acknowledged(&self) -> bool {
        self.is_review_owner_update_acknowledged
    }
    /// <p>The industry type for the workload.</p>
    /// <p>If specified, must be one of the following:</p>  
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Agriculture</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Automobile</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Defense</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Design and Engineering</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Digital Advertising</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Education</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Environmental Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Financial Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Gaming</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>General Public Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Healthcare</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Hospitality</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InfoTech</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Justice and Public Safety</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Life Sciences</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Manufacturing</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Media & Entertainment</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Mining & Resources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Oil & Gas</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Power & Utilities</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Professional Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Real Estate & Construction</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Retail & Wholesale</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Social Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Telecommunications</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Travel, Transportation & Logistics</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Other</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn industry_type(&self) -> std::option::Option<&str> {
        self.industry_type.as_deref()
    }
    /// <p>The industry for the workload.</p>
    pub fn industry(&self) -> std::option::Option<&str> {
        self.industry.as_deref()
    }
    /// <p>The notes associated with the workload.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p>The improvement status for a workload.</p>
    pub fn improvement_status(
        &self,
    ) -> std::option::Option<&crate::model::WorkloadImprovementStatus> {
        self.improvement_status.as_ref()
    }
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub fn risk_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::Risk, i32>> {
        self.risk_counts.as_ref()
    }
    /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
    /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub fn pillar_priorities(&self) -> std::option::Option<&[std::string::String]> {
        self.pillar_priorities.as_deref()
    }
    /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lenses(&self) -> std::option::Option<&[std::string::String]> {
        self.lenses.as_deref()
    }
    /// <p>An Amazon Web Services account ID.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The ID assigned to the share invitation.</p>
    pub fn share_invitation_id(&self) -> std::option::Option<&str> {
        self.share_invitation_id.as_deref()
    }
    /// <p>The tags associated with the workload.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for Workload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Workload");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_arn", &self.workload_arn);
        formatter.field("workload_name", &self.workload_name);
        formatter.field("description", &self.description);
        formatter.field("environment", &self.environment);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("aws_regions", &self.aws_regions);
        formatter.field("non_aws_regions", &self.non_aws_regions);
        formatter.field("architectural_design", &self.architectural_design);
        formatter.field("review_owner", &self.review_owner);
        formatter.field("review_restriction_date", &self.review_restriction_date);
        formatter.field(
            "is_review_owner_update_acknowledged",
            &self.is_review_owner_update_acknowledged,
        );
        formatter.field("industry_type", &self.industry_type);
        formatter.field("industry", &self.industry);
        formatter.field("notes", &self.notes);
        formatter.field("improvement_status", &self.improvement_status);
        formatter.field("risk_counts", &self.risk_counts);
        formatter.field("pillar_priorities", &self.pillar_priorities);
        formatter.field("lenses", &self.lenses);
        formatter.field("owner", &self.owner);
        formatter.field("share_invitation_id", &self.share_invitation_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Workload`](crate::model::Workload)
pub mod workload {
    /// A builder for [`Workload`](crate::model::Workload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_arn: std::option::Option<std::string::String>,
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::WorkloadEnvironment>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) non_aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) architectural_design: std::option::Option<std::string::String>,
        pub(crate) review_owner: std::option::Option<std::string::String>,
        pub(crate) review_restriction_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) is_review_owner_update_acknowledged: std::option::Option<bool>,
        pub(crate) industry_type: std::option::Option<std::string::String>,
        pub(crate) industry: std::option::Option<std::string::String>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) improvement_status: std::option::Option<crate::model::WorkloadImprovementStatus>,
        pub(crate) risk_counts:
            std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        pub(crate) pillar_priorities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) lenses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) share_invitation_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_arn = input;
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of Amazon Web Services account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `aws_regions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_regions.unwrap_or_default();
            v.push(input.into());
            self.aws_regions = Some(v);
            self
        }
        /// <p>The list of Amazon Web Services Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_regions = input;
            self
        }
        /// Appends an item to `non_aws_regions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.non_aws_regions.unwrap_or_default();
            v.push(input.into());
            self.non_aws_regions = Some(v);
            self
        }
        /// <p> The list of non-Amazon Web Services Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.non_aws_regions = input;
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.architectural_design = Some(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.architectural_design = input;
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.review_owner = Some(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.review_owner = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn review_restriction_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.review_restriction_date = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_review_restriction_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.review_restriction_date = input;
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
        /// owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within
        /// 60 days of acknowledgement, access to the workload is restricted until an owner is
        /// added.</p>
        pub fn is_review_owner_update_acknowledged(mut self, input: bool) -> Self {
            self.is_review_owner_update_acknowledged = Some(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
        /// owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within
        /// 60 days of acknowledgement, access to the workload is restricted until an owner is
        /// added.</p>
        pub fn set_is_review_owner_update_acknowledged(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_review_owner_update_acknowledged = input;
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.industry_type = Some(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.industry_type = input;
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.industry = Some(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.industry = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn improvement_status(
            mut self,
            input: crate::model::WorkloadImprovementStatus,
        ) -> Self {
            self.improvement_status = Some(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn set_improvement_status(
            mut self,
            input: std::option::Option<crate::model::WorkloadImprovementStatus>,
        ) -> Self {
            self.improvement_status = input;
            self
        }
        /// Adds a key-value pair to `risk_counts`.
        ///
        /// To override the contents of this collection use [`set_risk_counts`](Self::set_risk_counts).
        ///
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn risk_counts(mut self, k: impl Into<crate::model::Risk>, v: impl Into<i32>) -> Self {
            let mut hash_map = self.risk_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.risk_counts = Some(hash_map);
            self
        }
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn set_risk_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        ) -> Self {
            self.risk_counts = input;
            self
        }
        /// Appends an item to `pillar_priorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pillar_priorities.unwrap_or_default();
            v.push(input.into());
            self.pillar_priorities = Some(v);
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pillar_priorities = input;
            self
        }
        /// Appends an item to `lenses`.
        ///
        /// To override the contents of this collection use [`set_lenses`](Self::set_lenses).
        ///
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lenses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lenses.unwrap_or_default();
            v.push(input.into());
            self.lenses = Some(v);
            self
        }
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lenses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lenses = input;
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_invitation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.share_invitation_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the workload.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the workload.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Workload`](crate::model::Workload)
        pub fn build(self) -> crate::model::Workload {
            crate::model::Workload {
                workload_id: self.workload_id,
                workload_arn: self.workload_arn,
                workload_name: self.workload_name,
                description: self.description,
                environment: self.environment,
                updated_at: self.updated_at,
                account_ids: self.account_ids,
                aws_regions: self.aws_regions,
                non_aws_regions: self.non_aws_regions,
                architectural_design: self.architectural_design,
                review_owner: self.review_owner,
                review_restriction_date: self.review_restriction_date,
                is_review_owner_update_acknowledged: self
                    .is_review_owner_update_acknowledged
                    .unwrap_or_default(),
                industry_type: self.industry_type,
                industry: self.industry,
                notes: self.notes,
                improvement_status: self.improvement_status,
                risk_counts: self.risk_counts,
                pillar_priorities: self.pillar_priorities,
                lenses: self.lenses,
                owner: self.owner,
                share_invitation_id: self.share_invitation_id,
                tags: self.tags,
            }
        }
    }
}
impl Workload {
    /// Creates a new builder-style object to manufacture [`Workload`](crate::model::Workload)
    pub fn builder() -> crate::model::workload::Builder {
        crate::model::workload::Builder::default()
    }
}

/// <p>The risk for a given workload, lens review, pillar, or question.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Risk {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    #[allow(missing_docs)] // documentation missing in model
    Unanswered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Risk {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => Risk::High,
            "MEDIUM" => Risk::Medium,
            "NONE" => Risk::None,
            "NOT_APPLICABLE" => Risk::NotApplicable,
            "UNANSWERED" => Risk::Unanswered,
            other => Risk::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Risk {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Risk::from(s))
    }
}
impl Risk {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Risk::High => "HIGH",
            Risk::Medium => "MEDIUM",
            Risk::None => "NONE",
            Risk::NotApplicable => "NOT_APPLICABLE",
            Risk::Unanswered => "UNANSWERED",
            Risk::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "MEDIUM", "NONE", "NOT_APPLICABLE", "UNANSWERED"]
    }
}
impl AsRef<str> for Risk {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The improvement status for a workload.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkloadImprovementStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    RiskAcknowledged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkloadImprovementStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => WorkloadImprovementStatus::Complete,
            "IN_PROGRESS" => WorkloadImprovementStatus::InProgress,
            "NOT_APPLICABLE" => WorkloadImprovementStatus::NotApplicable,
            "NOT_STARTED" => WorkloadImprovementStatus::NotStarted,
            "RISK_ACKNOWLEDGED" => WorkloadImprovementStatus::RiskAcknowledged,
            other => WorkloadImprovementStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkloadImprovementStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkloadImprovementStatus::from(s))
    }
}
impl WorkloadImprovementStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkloadImprovementStatus::Complete => "COMPLETE",
            WorkloadImprovementStatus::InProgress => "IN_PROGRESS",
            WorkloadImprovementStatus::NotApplicable => "NOT_APPLICABLE",
            WorkloadImprovementStatus::NotStarted => "NOT_STARTED",
            WorkloadImprovementStatus::RiskAcknowledged => "RISK_ACKNOWLEDGED",
            WorkloadImprovementStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETE",
            "IN_PROGRESS",
            "NOT_APPLICABLE",
            "NOT_STARTED",
            "RISK_ACKNOWLEDGED",
        ]
    }
}
impl AsRef<str> for WorkloadImprovementStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The environment for the workload.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkloadEnvironment {
    #[allow(missing_docs)] // documentation missing in model
    Preproduction,
    #[allow(missing_docs)] // documentation missing in model
    Production,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkloadEnvironment {
    fn from(s: &str) -> Self {
        match s {
            "PREPRODUCTION" => WorkloadEnvironment::Preproduction,
            "PRODUCTION" => WorkloadEnvironment::Production,
            other => WorkloadEnvironment::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkloadEnvironment {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkloadEnvironment::from(s))
    }
}
impl WorkloadEnvironment {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkloadEnvironment::Preproduction => "PREPRODUCTION",
            WorkloadEnvironment::Production => "PRODUCTION",
            WorkloadEnvironment::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PREPRODUCTION", "PRODUCTION"]
    }
}
impl AsRef<str> for WorkloadEnvironment {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The share invitation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareInvitation {
    /// <p>The ID assigned to the share invitation.</p>
    pub share_invitation_id: std::option::Option<std::string::String>,
    /// <p>The resource type of the share invitation.</p>
    pub share_resource_type: std::option::Option<crate::model::ShareResourceType>,
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ARN for the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
}
impl ShareInvitation {
    /// <p>The ID assigned to the share invitation.</p>
    pub fn share_invitation_id(&self) -> std::option::Option<&str> {
        self.share_invitation_id.as_deref()
    }
    /// <p>The resource type of the share invitation.</p>
    pub fn share_resource_type(&self) -> std::option::Option<&crate::model::ShareResourceType> {
        self.share_resource_type.as_ref()
    }
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The ARN for the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
}
impl std::fmt::Debug for ShareInvitation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareInvitation");
        formatter.field("share_invitation_id", &self.share_invitation_id);
        formatter.field("share_resource_type", &self.share_resource_type);
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_arn", &self.lens_arn);
        formatter.finish()
    }
}
/// See [`ShareInvitation`](crate::model::ShareInvitation)
pub mod share_invitation {
    /// A builder for [`ShareInvitation`](crate::model::ShareInvitation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_invitation_id: std::option::Option<std::string::String>,
        pub(crate) share_resource_type: std::option::Option<crate::model::ShareResourceType>,
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_invitation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.share_invitation_id = input;
            self
        }
        /// <p>The resource type of the share invitation.</p>
        pub fn share_resource_type(mut self, input: crate::model::ShareResourceType) -> Self {
            self.share_resource_type = Some(input);
            self
        }
        /// <p>The resource type of the share invitation.</p>
        pub fn set_share_resource_type(
            mut self,
            input: std::option::Option<crate::model::ShareResourceType>,
        ) -> Self {
            self.share_resource_type = input;
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareInvitation`](crate::model::ShareInvitation)
        pub fn build(self) -> crate::model::ShareInvitation {
            crate::model::ShareInvitation {
                share_invitation_id: self.share_invitation_id,
                share_resource_type: self.share_resource_type,
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                lens_arn: self.lens_arn,
            }
        }
    }
}
impl ShareInvitation {
    /// Creates a new builder-style object to manufacture [`ShareInvitation`](crate::model::ShareInvitation)
    pub fn builder() -> crate::model::share_invitation::Builder {
        crate::model::share_invitation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Lens,
    #[allow(missing_docs)] // documentation missing in model
    Workload,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareResourceType {
    fn from(s: &str) -> Self {
        match s {
            "LENS" => ShareResourceType::Lens,
            "WORKLOAD" => ShareResourceType::Workload,
            other => ShareResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareResourceType::from(s))
    }
}
impl ShareResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareResourceType::Lens => "LENS",
            ShareResourceType::Workload => "WORKLOAD",
            ShareResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LENS", "WORKLOAD"]
    }
}
impl AsRef<str> for ShareResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Share invitation action taken by contributor.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareInvitationAction {
    #[allow(missing_docs)] // documentation missing in model
    Accept,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareInvitationAction {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPT" => ShareInvitationAction::Accept,
            "REJECT" => ShareInvitationAction::Reject,
            other => ShareInvitationAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareInvitationAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareInvitationAction::from(s))
    }
}
impl ShareInvitationAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareInvitationAction::Accept => "ACCEPT",
            ShareInvitationAction::Reject => "REJECT",
            ShareInvitationAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPT", "REJECT"]
    }
}
impl AsRef<str> for ShareInvitationAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A lens review of a question.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LensReview {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ARN for the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
    /// <p>The version of the lens.</p>
    pub lens_version: std::option::Option<std::string::String>,
    /// <p>The full name of the lens.</p>
    pub lens_name: std::option::Option<std::string::String>,
    /// <p>The status of the lens.</p>
    pub lens_status: std::option::Option<crate::model::LensStatus>,
    /// <p>List of pillar review summaries of lens review in a workload.</p>
    pub pillar_review_summaries:
        std::option::Option<std::vec::Vec<crate::model::PillarReviewSummary>>,
    /// <p>The date and time recorded.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub risk_counts: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl LensReview {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The ARN for the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
    /// <p>The version of the lens.</p>
    pub fn lens_version(&self) -> std::option::Option<&str> {
        self.lens_version.as_deref()
    }
    /// <p>The full name of the lens.</p>
    pub fn lens_name(&self) -> std::option::Option<&str> {
        self.lens_name.as_deref()
    }
    /// <p>The status of the lens.</p>
    pub fn lens_status(&self) -> std::option::Option<&crate::model::LensStatus> {
        self.lens_status.as_ref()
    }
    /// <p>List of pillar review summaries of lens review in a workload.</p>
    pub fn pillar_review_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::PillarReviewSummary]> {
        self.pillar_review_summaries.as_deref()
    }
    /// <p>The date and time recorded.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The notes associated with the workload.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub fn risk_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::Risk, i32>> {
        self.risk_counts.as_ref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for LensReview {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LensReview");
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_arn", &self.lens_arn);
        formatter.field("lens_version", &self.lens_version);
        formatter.field("lens_name", &self.lens_name);
        formatter.field("lens_status", &self.lens_status);
        formatter.field("pillar_review_summaries", &self.pillar_review_summaries);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("notes", &self.notes);
        formatter.field("risk_counts", &self.risk_counts);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`LensReview`](crate::model::LensReview)
pub mod lens_review {
    /// A builder for [`LensReview`](crate::model::LensReview)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_arn: std::option::Option<std::string::String>,
        pub(crate) lens_version: std::option::Option<std::string::String>,
        pub(crate) lens_name: std::option::Option<std::string::String>,
        pub(crate) lens_status: std::option::Option<crate::model::LensStatus>,
        pub(crate) pillar_review_summaries:
            std::option::Option<std::vec::Vec<crate::model::PillarReviewSummary>>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) risk_counts:
            std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// <p>The version of the lens.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_version = Some(input.into());
            self
        }
        /// <p>The version of the lens.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_version = input;
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn lens_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_name = Some(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_lens_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_name = input;
            self
        }
        /// <p>The status of the lens.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatus) -> Self {
            self.lens_status = Some(input);
            self
        }
        /// <p>The status of the lens.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatus>,
        ) -> Self {
            self.lens_status = input;
            self
        }
        /// Appends an item to `pillar_review_summaries`.
        ///
        /// To override the contents of this collection use [`set_pillar_review_summaries`](Self::set_pillar_review_summaries).
        ///
        /// <p>List of pillar review summaries of lens review in a workload.</p>
        pub fn pillar_review_summaries(
            mut self,
            input: impl Into<crate::model::PillarReviewSummary>,
        ) -> Self {
            let mut v = self.pillar_review_summaries.unwrap_or_default();
            v.push(input.into());
            self.pillar_review_summaries = Some(v);
            self
        }
        /// <p>List of pillar review summaries of lens review in a workload.</p>
        pub fn set_pillar_review_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PillarReviewSummary>>,
        ) -> Self {
            self.pillar_review_summaries = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Adds a key-value pair to `risk_counts`.
        ///
        /// To override the contents of this collection use [`set_risk_counts`](Self::set_risk_counts).
        ///
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn risk_counts(mut self, k: impl Into<crate::model::Risk>, v: impl Into<i32>) -> Self {
            let mut hash_map = self.risk_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.risk_counts = Some(hash_map);
            self
        }
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn set_risk_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        ) -> Self {
            self.risk_counts = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`LensReview`](crate::model::LensReview)
        pub fn build(self) -> crate::model::LensReview {
            crate::model::LensReview {
                lens_alias: self.lens_alias,
                lens_arn: self.lens_arn,
                lens_version: self.lens_version,
                lens_name: self.lens_name,
                lens_status: self.lens_status,
                pillar_review_summaries: self.pillar_review_summaries,
                updated_at: self.updated_at,
                notes: self.notes,
                risk_counts: self.risk_counts,
                next_token: self.next_token,
            }
        }
    }
}
impl LensReview {
    /// Creates a new builder-style object to manufacture [`LensReview`](crate::model::LensReview)
    pub fn builder() -> crate::model::lens_review::Builder {
        crate::model::lens_review::Builder::default()
    }
}

/// <p>A pillar review summary of a lens review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PillarReviewSummary {
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The name of the pillar.</p>
    pub pillar_name: std::option::Option<std::string::String>,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub risk_counts: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
}
impl PillarReviewSummary {
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub fn pillar_id(&self) -> std::option::Option<&str> {
        self.pillar_id.as_deref()
    }
    /// <p>The name of the pillar.</p>
    pub fn pillar_name(&self) -> std::option::Option<&str> {
        self.pillar_name.as_deref()
    }
    /// <p>The notes associated with the workload.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub fn risk_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::Risk, i32>> {
        self.risk_counts.as_ref()
    }
}
impl std::fmt::Debug for PillarReviewSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PillarReviewSummary");
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("pillar_name", &self.pillar_name);
        formatter.field("notes", &self.notes);
        formatter.field("risk_counts", &self.risk_counts);
        formatter.finish()
    }
}
/// See [`PillarReviewSummary`](crate::model::PillarReviewSummary)
pub mod pillar_review_summary {
    /// A builder for [`PillarReviewSummary`](crate::model::PillarReviewSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) pillar_name: std::option::Option<std::string::String>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) risk_counts:
            std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
    }
    impl Builder {
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The name of the pillar.</p>
        pub fn pillar_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_name = Some(input.into());
            self
        }
        /// <p>The name of the pillar.</p>
        pub fn set_pillar_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_name = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Adds a key-value pair to `risk_counts`.
        ///
        /// To override the contents of this collection use [`set_risk_counts`](Self::set_risk_counts).
        ///
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn risk_counts(mut self, k: impl Into<crate::model::Risk>, v: impl Into<i32>) -> Self {
            let mut hash_map = self.risk_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.risk_counts = Some(hash_map);
            self
        }
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn set_risk_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        ) -> Self {
            self.risk_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`PillarReviewSummary`](crate::model::PillarReviewSummary)
        pub fn build(self) -> crate::model::PillarReviewSummary {
            crate::model::PillarReviewSummary {
                pillar_id: self.pillar_id,
                pillar_name: self.pillar_name,
                notes: self.notes,
                risk_counts: self.risk_counts,
            }
        }
    }
}
impl PillarReviewSummary {
    /// Creates a new builder-style object to manufacture [`PillarReviewSummary`](crate::model::PillarReviewSummary)
    pub fn builder() -> crate::model::pillar_review_summary::Builder {
        crate::model::pillar_review_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LensStatus {
    #[allow(missing_docs)] // documentation missing in model
    Current,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    NotCurrent,
    #[allow(missing_docs)] // documentation missing in model
    Unshared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LensStatus {
    fn from(s: &str) -> Self {
        match s {
            "CURRENT" => LensStatus::Current,
            "DELETED" => LensStatus::Deleted,
            "DEPRECATED" => LensStatus::Deprecated,
            "NOT_CURRENT" => LensStatus::NotCurrent,
            "UNSHARED" => LensStatus::Unshared,
            other => LensStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LensStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LensStatus::from(s))
    }
}
impl LensStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LensStatus::Current => "CURRENT",
            LensStatus::Deleted => "DELETED",
            LensStatus::Deprecated => "DEPRECATED",
            LensStatus::NotCurrent => "NOT_CURRENT",
            LensStatus::Unshared => "UNSHARED",
            LensStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CURRENT",
            "DELETED",
            "DEPRECATED",
            "NOT_CURRENT",
            "UNSHARED",
        ]
    }
}
impl AsRef<str> for LensStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An answer of the question.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Answer {
    /// <p>The ID of the question.</p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The title of the question.</p>
    pub question_title: std::option::Option<std::string::String>,
    /// <p>The description of the question.</p>
    pub question_description: std::option::Option<std::string::String>,
    /// <p>The improvement plan URL for a question.</p>
    /// <p>This value is only available if the question has been answered.</p>
    pub improvement_plan_url: std::option::Option<std::string::String>,
    /// <p>The helpful resource URL for a question.</p>
    pub helpful_resource_url: std::option::Option<std::string::String>,
    /// <p>The helpful resource text to be displayed.</p>
    pub helpful_resource_display_text: std::option::Option<std::string::String>,
    /// <p>List of choices available for a question.</p>
    pub choices: std::option::Option<std::vec::Vec<crate::model::Choice>>,
    /// <p>List of selected choice IDs in a question answer.</p>
    /// <p>The values entered replace the previously selected choices.</p>
    pub selected_choices: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of selected choices to a question in your workload.</p>
    pub choice_answers: std::option::Option<std::vec::Vec<crate::model::ChoiceAnswer>>,
    /// <p>Defines whether this question is applicable to a lens review.</p>
    pub is_applicable: bool,
    /// <p>The risk for a given workload, lens review, pillar, or question.</p>
    pub risk: std::option::Option<crate::model::Risk>,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>The reason why the question is not applicable to your workload.</p>
    pub reason: std::option::Option<crate::model::AnswerReason>,
}
impl Answer {
    /// <p>The ID of the question.</p>
    pub fn question_id(&self) -> std::option::Option<&str> {
        self.question_id.as_deref()
    }
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub fn pillar_id(&self) -> std::option::Option<&str> {
        self.pillar_id.as_deref()
    }
    /// <p>The title of the question.</p>
    pub fn question_title(&self) -> std::option::Option<&str> {
        self.question_title.as_deref()
    }
    /// <p>The description of the question.</p>
    pub fn question_description(&self) -> std::option::Option<&str> {
        self.question_description.as_deref()
    }
    /// <p>The improvement plan URL for a question.</p>
    /// <p>This value is only available if the question has been answered.</p>
    pub fn improvement_plan_url(&self) -> std::option::Option<&str> {
        self.improvement_plan_url.as_deref()
    }
    /// <p>The helpful resource URL for a question.</p>
    pub fn helpful_resource_url(&self) -> std::option::Option<&str> {
        self.helpful_resource_url.as_deref()
    }
    /// <p>The helpful resource text to be displayed.</p>
    pub fn helpful_resource_display_text(&self) -> std::option::Option<&str> {
        self.helpful_resource_display_text.as_deref()
    }
    /// <p>List of choices available for a question.</p>
    pub fn choices(&self) -> std::option::Option<&[crate::model::Choice]> {
        self.choices.as_deref()
    }
    /// <p>List of selected choice IDs in a question answer.</p>
    /// <p>The values entered replace the previously selected choices.</p>
    pub fn selected_choices(&self) -> std::option::Option<&[std::string::String]> {
        self.selected_choices.as_deref()
    }
    /// <p>A list of selected choices to a question in your workload.</p>
    pub fn choice_answers(&self) -> std::option::Option<&[crate::model::ChoiceAnswer]> {
        self.choice_answers.as_deref()
    }
    /// <p>Defines whether this question is applicable to a lens review.</p>
    pub fn is_applicable(&self) -> bool {
        self.is_applicable
    }
    /// <p>The risk for a given workload, lens review, pillar, or question.</p>
    pub fn risk(&self) -> std::option::Option<&crate::model::Risk> {
        self.risk.as_ref()
    }
    /// <p>The notes associated with the workload.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
    /// <p>The reason why the question is not applicable to your workload.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::AnswerReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for Answer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Answer");
        formatter.field("question_id", &self.question_id);
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("question_title", &self.question_title);
        formatter.field("question_description", &self.question_description);
        formatter.field("improvement_plan_url", &self.improvement_plan_url);
        formatter.field("helpful_resource_url", &self.helpful_resource_url);
        formatter.field(
            "helpful_resource_display_text",
            &self.helpful_resource_display_text,
        );
        formatter.field("choices", &self.choices);
        formatter.field("selected_choices", &self.selected_choices);
        formatter.field("choice_answers", &self.choice_answers);
        formatter.field("is_applicable", &self.is_applicable);
        formatter.field("risk", &self.risk);
        formatter.field("notes", &self.notes);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`Answer`](crate::model::Answer)
pub mod answer {
    /// A builder for [`Answer`](crate::model::Answer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) question_title: std::option::Option<std::string::String>,
        pub(crate) question_description: std::option::Option<std::string::String>,
        pub(crate) improvement_plan_url: std::option::Option<std::string::String>,
        pub(crate) helpful_resource_url: std::option::Option<std::string::String>,
        pub(crate) helpful_resource_display_text: std::option::Option<std::string::String>,
        pub(crate) choices: std::option::Option<std::vec::Vec<crate::model::Choice>>,
        pub(crate) selected_choices: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) choice_answers: std::option::Option<std::vec::Vec<crate::model::ChoiceAnswer>>,
        pub(crate) is_applicable: std::option::Option<bool>,
        pub(crate) risk: std::option::Option<crate::model::Risk>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::AnswerReason>,
    }
    impl Builder {
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The title of the question.</p>
        pub fn question_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_title = Some(input.into());
            self
        }
        /// <p>The title of the question.</p>
        pub fn set_question_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.question_title = input;
            self
        }
        /// <p>The description of the question.</p>
        pub fn question_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_description = Some(input.into());
            self
        }
        /// <p>The description of the question.</p>
        pub fn set_question_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.question_description = input;
            self
        }
        /// <p>The improvement plan URL for a question.</p>
        /// <p>This value is only available if the question has been answered.</p>
        pub fn improvement_plan_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.improvement_plan_url = Some(input.into());
            self
        }
        /// <p>The improvement plan URL for a question.</p>
        /// <p>This value is only available if the question has been answered.</p>
        pub fn set_improvement_plan_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.improvement_plan_url = input;
            self
        }
        /// <p>The helpful resource URL for a question.</p>
        pub fn helpful_resource_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.helpful_resource_url = Some(input.into());
            self
        }
        /// <p>The helpful resource URL for a question.</p>
        pub fn set_helpful_resource_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.helpful_resource_url = input;
            self
        }
        /// <p>The helpful resource text to be displayed.</p>
        pub fn helpful_resource_display_text(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.helpful_resource_display_text = Some(input.into());
            self
        }
        /// <p>The helpful resource text to be displayed.</p>
        pub fn set_helpful_resource_display_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.helpful_resource_display_text = input;
            self
        }
        /// Appends an item to `choices`.
        ///
        /// To override the contents of this collection use [`set_choices`](Self::set_choices).
        ///
        /// <p>List of choices available for a question.</p>
        pub fn choices(mut self, input: impl Into<crate::model::Choice>) -> Self {
            let mut v = self.choices.unwrap_or_default();
            v.push(input.into());
            self.choices = Some(v);
            self
        }
        /// <p>List of choices available for a question.</p>
        pub fn set_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Choice>>,
        ) -> Self {
            self.choices = input;
            self
        }
        /// Appends an item to `selected_choices`.
        ///
        /// To override the contents of this collection use [`set_selected_choices`](Self::set_selected_choices).
        ///
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn selected_choices(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.selected_choices.unwrap_or_default();
            v.push(input.into());
            self.selected_choices = Some(v);
            self
        }
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn set_selected_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.selected_choices = input;
            self
        }
        /// Appends an item to `choice_answers`.
        ///
        /// To override the contents of this collection use [`set_choice_answers`](Self::set_choice_answers).
        ///
        /// <p>A list of selected choices to a question in your workload.</p>
        pub fn choice_answers(mut self, input: impl Into<crate::model::ChoiceAnswer>) -> Self {
            let mut v = self.choice_answers.unwrap_or_default();
            v.push(input.into());
            self.choice_answers = Some(v);
            self
        }
        /// <p>A list of selected choices to a question in your workload.</p>
        pub fn set_choice_answers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChoiceAnswer>>,
        ) -> Self {
            self.choice_answers = input;
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn is_applicable(mut self, input: bool) -> Self {
            self.is_applicable = Some(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn set_is_applicable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_applicable = input;
            self
        }
        /// <p>The risk for a given workload, lens review, pillar, or question.</p>
        pub fn risk(mut self, input: crate::model::Risk) -> Self {
            self.risk = Some(input);
            self
        }
        /// <p>The risk for a given workload, lens review, pillar, or question.</p>
        pub fn set_risk(mut self, input: std::option::Option<crate::model::Risk>) -> Self {
            self.risk = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// <p>The reason why the question is not applicable to your workload.</p>
        pub fn reason(mut self, input: crate::model::AnswerReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why the question is not applicable to your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AnswerReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`Answer`](crate::model::Answer)
        pub fn build(self) -> crate::model::Answer {
            crate::model::Answer {
                question_id: self.question_id,
                pillar_id: self.pillar_id,
                question_title: self.question_title,
                question_description: self.question_description,
                improvement_plan_url: self.improvement_plan_url,
                helpful_resource_url: self.helpful_resource_url,
                helpful_resource_display_text: self.helpful_resource_display_text,
                choices: self.choices,
                selected_choices: self.selected_choices,
                choice_answers: self.choice_answers,
                is_applicable: self.is_applicable.unwrap_or_default(),
                risk: self.risk,
                notes: self.notes,
                reason: self.reason,
            }
        }
    }
}
impl Answer {
    /// Creates a new builder-style object to manufacture [`Answer`](crate::model::Answer)
    pub fn builder() -> crate::model::answer::Builder {
        crate::model::answer::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnswerReason {
    #[allow(missing_docs)] // documentation missing in model
    ArchitectureConstraints,
    #[allow(missing_docs)] // documentation missing in model
    BusinessPriorities,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    OutOfScope,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnswerReason {
    fn from(s: &str) -> Self {
        match s {
            "ARCHITECTURE_CONSTRAINTS" => AnswerReason::ArchitectureConstraints,
            "BUSINESS_PRIORITIES" => AnswerReason::BusinessPriorities,
            "NONE" => AnswerReason::None,
            "OTHER" => AnswerReason::Other,
            "OUT_OF_SCOPE" => AnswerReason::OutOfScope,
            other => AnswerReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnswerReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnswerReason::from(s))
    }
}
impl AnswerReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnswerReason::ArchitectureConstraints => "ARCHITECTURE_CONSTRAINTS",
            AnswerReason::BusinessPriorities => "BUSINESS_PRIORITIES",
            AnswerReason::None => "NONE",
            AnswerReason::Other => "OTHER",
            AnswerReason::OutOfScope => "OUT_OF_SCOPE",
            AnswerReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ARCHITECTURE_CONSTRAINTS",
            "BUSINESS_PRIORITIES",
            "NONE",
            "OTHER",
            "OUT_OF_SCOPE",
        ]
    }
}
impl AsRef<str> for AnswerReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A choice that has been answered on a question in your workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChoiceAnswer {
    /// <p>The ID of a choice.</p>
    pub choice_id: std::option::Option<std::string::String>,
    /// <p>The status of a choice.</p>
    pub status: std::option::Option<crate::model::ChoiceStatus>,
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub reason: std::option::Option<crate::model::ChoiceReason>,
    /// <p>The notes associated with a choice.</p>
    pub notes: std::option::Option<std::string::String>,
}
impl ChoiceAnswer {
    /// <p>The ID of a choice.</p>
    pub fn choice_id(&self) -> std::option::Option<&str> {
        self.choice_id.as_deref()
    }
    /// <p>The status of a choice.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChoiceStatus> {
        self.status.as_ref()
    }
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ChoiceReason> {
        self.reason.as_ref()
    }
    /// <p>The notes associated with a choice.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
}
impl std::fmt::Debug for ChoiceAnswer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChoiceAnswer");
        formatter.field("choice_id", &self.choice_id);
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.field("notes", &self.notes);
        formatter.finish()
    }
}
/// See [`ChoiceAnswer`](crate::model::ChoiceAnswer)
pub mod choice_answer {
    /// A builder for [`ChoiceAnswer`](crate::model::ChoiceAnswer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) choice_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ChoiceStatus>,
        pub(crate) reason: std::option::Option<crate::model::ChoiceReason>,
        pub(crate) notes: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a choice.</p>
        pub fn choice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.choice_id = Some(input.into());
            self
        }
        /// <p>The ID of a choice.</p>
        pub fn set_choice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.choice_id = input;
            self
        }
        /// <p>The status of a choice.</p>
        pub fn status(mut self, input: crate::model::ChoiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a choice.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChoiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn reason(mut self, input: crate::model::ChoiceReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ChoiceReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>The notes associated with a choice.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with a choice.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Consumes the builder and constructs a [`ChoiceAnswer`](crate::model::ChoiceAnswer)
        pub fn build(self) -> crate::model::ChoiceAnswer {
            crate::model::ChoiceAnswer {
                choice_id: self.choice_id,
                status: self.status,
                reason: self.reason,
                notes: self.notes,
            }
        }
    }
}
impl ChoiceAnswer {
    /// Creates a new builder-style object to manufacture [`ChoiceAnswer`](crate::model::ChoiceAnswer)
    pub fn builder() -> crate::model::choice_answer::Builder {
        crate::model::choice_answer::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChoiceReason {
    #[allow(missing_docs)] // documentation missing in model
    ArchitectureConstraints,
    #[allow(missing_docs)] // documentation missing in model
    BusinessPriorities,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    OutOfScope,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChoiceReason {
    fn from(s: &str) -> Self {
        match s {
            "ARCHITECTURE_CONSTRAINTS" => ChoiceReason::ArchitectureConstraints,
            "BUSINESS_PRIORITIES" => ChoiceReason::BusinessPriorities,
            "NONE" => ChoiceReason::None,
            "OTHER" => ChoiceReason::Other,
            "OUT_OF_SCOPE" => ChoiceReason::OutOfScope,
            other => ChoiceReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChoiceReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChoiceReason::from(s))
    }
}
impl ChoiceReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChoiceReason::ArchitectureConstraints => "ARCHITECTURE_CONSTRAINTS",
            ChoiceReason::BusinessPriorities => "BUSINESS_PRIORITIES",
            ChoiceReason::None => "NONE",
            ChoiceReason::Other => "OTHER",
            ChoiceReason::OutOfScope => "OUT_OF_SCOPE",
            ChoiceReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ARCHITECTURE_CONSTRAINTS",
            "BUSINESS_PRIORITIES",
            "NONE",
            "OTHER",
            "OUT_OF_SCOPE",
        ]
    }
}
impl AsRef<str> for ChoiceReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChoiceStatus {
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    #[allow(missing_docs)] // documentation missing in model
    Selected,
    #[allow(missing_docs)] // documentation missing in model
    Unselected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChoiceStatus {
    fn from(s: &str) -> Self {
        match s {
            "NOT_APPLICABLE" => ChoiceStatus::NotApplicable,
            "SELECTED" => ChoiceStatus::Selected,
            "UNSELECTED" => ChoiceStatus::Unselected,
            other => ChoiceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChoiceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChoiceStatus::from(s))
    }
}
impl ChoiceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChoiceStatus::NotApplicable => "NOT_APPLICABLE",
            ChoiceStatus::Selected => "SELECTED",
            ChoiceStatus::Unselected => "UNSELECTED",
            ChoiceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_APPLICABLE", "SELECTED", "UNSELECTED"]
    }
}
impl AsRef<str> for ChoiceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A choice available to answer question.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Choice {
    /// <p>The ID of a choice.</p>
    pub choice_id: std::option::Option<std::string::String>,
    /// <p>The title of a choice.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The description of a choice.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The choice level helpful resource.</p>
    pub helpful_resource: std::option::Option<crate::model::ChoiceContent>,
    /// <p>The choice level improvement plan.</p>
    pub improvement_plan: std::option::Option<crate::model::ChoiceContent>,
}
impl Choice {
    /// <p>The ID of a choice.</p>
    pub fn choice_id(&self) -> std::option::Option<&str> {
        self.choice_id.as_deref()
    }
    /// <p>The title of a choice.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The description of a choice.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The choice level helpful resource.</p>
    pub fn helpful_resource(&self) -> std::option::Option<&crate::model::ChoiceContent> {
        self.helpful_resource.as_ref()
    }
    /// <p>The choice level improvement plan.</p>
    pub fn improvement_plan(&self) -> std::option::Option<&crate::model::ChoiceContent> {
        self.improvement_plan.as_ref()
    }
}
impl std::fmt::Debug for Choice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Choice");
        formatter.field("choice_id", &self.choice_id);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("helpful_resource", &self.helpful_resource);
        formatter.field("improvement_plan", &self.improvement_plan);
        formatter.finish()
    }
}
/// See [`Choice`](crate::model::Choice)
pub mod choice {
    /// A builder for [`Choice`](crate::model::Choice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) choice_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) helpful_resource: std::option::Option<crate::model::ChoiceContent>,
        pub(crate) improvement_plan: std::option::Option<crate::model::ChoiceContent>,
    }
    impl Builder {
        /// <p>The ID of a choice.</p>
        pub fn choice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.choice_id = Some(input.into());
            self
        }
        /// <p>The ID of a choice.</p>
        pub fn set_choice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.choice_id = input;
            self
        }
        /// <p>The title of a choice.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of a choice.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The description of a choice.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of a choice.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The choice level helpful resource.</p>
        pub fn helpful_resource(mut self, input: crate::model::ChoiceContent) -> Self {
            self.helpful_resource = Some(input);
            self
        }
        /// <p>The choice level helpful resource.</p>
        pub fn set_helpful_resource(
            mut self,
            input: std::option::Option<crate::model::ChoiceContent>,
        ) -> Self {
            self.helpful_resource = input;
            self
        }
        /// <p>The choice level improvement plan.</p>
        pub fn improvement_plan(mut self, input: crate::model::ChoiceContent) -> Self {
            self.improvement_plan = Some(input);
            self
        }
        /// <p>The choice level improvement plan.</p>
        pub fn set_improvement_plan(
            mut self,
            input: std::option::Option<crate::model::ChoiceContent>,
        ) -> Self {
            self.improvement_plan = input;
            self
        }
        /// Consumes the builder and constructs a [`Choice`](crate::model::Choice)
        pub fn build(self) -> crate::model::Choice {
            crate::model::Choice {
                choice_id: self.choice_id,
                title: self.title,
                description: self.description,
                helpful_resource: self.helpful_resource,
                improvement_plan: self.improvement_plan,
            }
        }
    }
}
impl Choice {
    /// Creates a new builder-style object to manufacture [`Choice`](crate::model::Choice)
    pub fn builder() -> crate::model::choice::Builder {
        crate::model::choice::Builder::default()
    }
}

/// <p>The choice content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChoiceContent {
    /// <p>The display text for the choice content.</p>
    pub display_text: std::option::Option<std::string::String>,
    /// <p>The URL for the choice content.</p>
    pub url: std::option::Option<std::string::String>,
}
impl ChoiceContent {
    /// <p>The display text for the choice content.</p>
    pub fn display_text(&self) -> std::option::Option<&str> {
        self.display_text.as_deref()
    }
    /// <p>The URL for the choice content.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for ChoiceContent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChoiceContent");
        formatter.field("display_text", &self.display_text);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`ChoiceContent`](crate::model::ChoiceContent)
pub mod choice_content {
    /// A builder for [`ChoiceContent`](crate::model::ChoiceContent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_text: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The display text for the choice content.</p>
        pub fn display_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_text = Some(input.into());
            self
        }
        /// <p>The display text for the choice content.</p>
        pub fn set_display_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_text = input;
            self
        }
        /// <p>The URL for the choice content.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL for the choice content.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`ChoiceContent`](crate::model::ChoiceContent)
        pub fn build(self) -> crate::model::ChoiceContent {
            crate::model::ChoiceContent {
                display_text: self.display_text,
                url: self.url,
            }
        }
    }
}
impl ChoiceContent {
    /// Creates a new builder-style object to manufacture [`ChoiceContent`](crate::model::ChoiceContent)
    pub fn builder() -> crate::model::choice_content::Builder {
        crate::model::choice_content::Builder::default()
    }
}

/// <p>A list of choices to be updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChoiceUpdate {
    /// <p>The status of a choice.</p>
    pub status: std::option::Option<crate::model::ChoiceStatus>,
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub reason: std::option::Option<crate::model::ChoiceReason>,
    /// <p>The notes associated with a choice.</p>
    pub notes: std::option::Option<std::string::String>,
}
impl ChoiceUpdate {
    /// <p>The status of a choice.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChoiceStatus> {
        self.status.as_ref()
    }
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ChoiceReason> {
        self.reason.as_ref()
    }
    /// <p>The notes associated with a choice.</p>
    pub fn notes(&self) -> std::option::Option<&str> {
        self.notes.as_deref()
    }
}
impl std::fmt::Debug for ChoiceUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChoiceUpdate");
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.field("notes", &self.notes);
        formatter.finish()
    }
}
/// See [`ChoiceUpdate`](crate::model::ChoiceUpdate)
pub mod choice_update {
    /// A builder for [`ChoiceUpdate`](crate::model::ChoiceUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ChoiceStatus>,
        pub(crate) reason: std::option::Option<crate::model::ChoiceReason>,
        pub(crate) notes: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of a choice.</p>
        pub fn status(mut self, input: crate::model::ChoiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a choice.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChoiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn reason(mut self, input: crate::model::ChoiceReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ChoiceReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>The notes associated with a choice.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with a choice.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// Consumes the builder and constructs a [`ChoiceUpdate`](crate::model::ChoiceUpdate)
        pub fn build(self) -> crate::model::ChoiceUpdate {
            crate::model::ChoiceUpdate {
                status: self.status,
                reason: self.reason,
                notes: self.notes,
            }
        }
    }
}
impl ChoiceUpdate {
    /// Creates a new builder-style object to manufacture [`ChoiceUpdate`](crate::model::ChoiceUpdate)
    pub fn builder() -> crate::model::choice_update::Builder {
        crate::model::choice_update::Builder::default()
    }
}

/// <p>A workload share summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkloadShareSummary {
    /// <p>The ID associated with the workload share.</p>
    pub share_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub shared_with: std::option::Option<std::string::String>,
    /// <p>Permission granted on a workload share.</p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>The status of a workload share.</p>
    pub status: std::option::Option<crate::model::ShareStatus>,
}
impl WorkloadShareSummary {
    /// <p>The ID associated with the workload share.</p>
    pub fn share_id(&self) -> std::option::Option<&str> {
        self.share_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub fn shared_with(&self) -> std::option::Option<&str> {
        self.shared_with.as_deref()
    }
    /// <p>Permission granted on a workload share.</p>
    pub fn permission_type(&self) -> std::option::Option<&crate::model::PermissionType> {
        self.permission_type.as_ref()
    }
    /// <p>The status of a workload share.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ShareStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for WorkloadShareSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkloadShareSummary");
        formatter.field("share_id", &self.share_id);
        formatter.field("shared_with", &self.shared_with);
        formatter.field("permission_type", &self.permission_type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`WorkloadShareSummary`](crate::model::WorkloadShareSummary)
pub mod workload_share_summary {
    /// A builder for [`WorkloadShareSummary`](crate::model::WorkloadShareSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_id: std::option::Option<std::string::String>,
        pub(crate) shared_with: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) status: std::option::Option<crate::model::ShareStatus>,
    }
    impl Builder {
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_with = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_with = input;
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The status of a workload share.</p>
        pub fn status(mut self, input: crate::model::ShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a workload share.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ShareStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkloadShareSummary`](crate::model::WorkloadShareSummary)
        pub fn build(self) -> crate::model::WorkloadShareSummary {
            crate::model::WorkloadShareSummary {
                share_id: self.share_id,
                shared_with: self.shared_with,
                permission_type: self.permission_type,
                status: self.status,
            }
        }
    }
}
impl WorkloadShareSummary {
    /// Creates a new builder-style object to manufacture [`WorkloadShareSummary`](crate::model::WorkloadShareSummary)
    pub fn builder() -> crate::model::workload_share_summary::Builder {
        crate::model::workload_share_summary::Builder::default()
    }
}

/// <p>A workload summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkloadSummary {
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The ARN for the workload.</p>
    pub workload_arn: std::option::Option<std::string::String>,
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>An Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The date and time recorded.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lenses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub risk_counts: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
    /// <p>The improvement status for a workload.</p>
    pub improvement_status: std::option::Option<crate::model::WorkloadImprovementStatus>,
}
impl WorkloadSummary {
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The ARN for the workload.</p>
    pub fn workload_arn(&self) -> std::option::Option<&str> {
        self.workload_arn.as_deref()
    }
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub fn workload_name(&self) -> std::option::Option<&str> {
        self.workload_name.as_deref()
    }
    /// <p>An Amazon Web Services account ID.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The date and time recorded.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lenses(&self) -> std::option::Option<&[std::string::String]> {
        self.lenses.as_deref()
    }
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub fn risk_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::Risk, i32>> {
        self.risk_counts.as_ref()
    }
    /// <p>The improvement status for a workload.</p>
    pub fn improvement_status(
        &self,
    ) -> std::option::Option<&crate::model::WorkloadImprovementStatus> {
        self.improvement_status.as_ref()
    }
}
impl std::fmt::Debug for WorkloadSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkloadSummary");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_arn", &self.workload_arn);
        formatter.field("workload_name", &self.workload_name);
        formatter.field("owner", &self.owner);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("lenses", &self.lenses);
        formatter.field("risk_counts", &self.risk_counts);
        formatter.field("improvement_status", &self.improvement_status);
        formatter.finish()
    }
}
/// See [`WorkloadSummary`](crate::model::WorkloadSummary)
pub mod workload_summary {
    /// A builder for [`WorkloadSummary`](crate::model::WorkloadSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_arn: std::option::Option<std::string::String>,
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lenses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) risk_counts:
            std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        pub(crate) improvement_status: std::option::Option<crate::model::WorkloadImprovementStatus>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_arn = input;
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `lenses`.
        ///
        /// To override the contents of this collection use [`set_lenses`](Self::set_lenses).
        ///
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lenses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lenses.unwrap_or_default();
            v.push(input.into());
            self.lenses = Some(v);
            self
        }
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lenses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lenses = input;
            self
        }
        /// Adds a key-value pair to `risk_counts`.
        ///
        /// To override the contents of this collection use [`set_risk_counts`](Self::set_risk_counts).
        ///
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn risk_counts(mut self, k: impl Into<crate::model::Risk>, v: impl Into<i32>) -> Self {
            let mut hash_map = self.risk_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.risk_counts = Some(hash_map);
            self
        }
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn set_risk_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        ) -> Self {
            self.risk_counts = input;
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn improvement_status(
            mut self,
            input: crate::model::WorkloadImprovementStatus,
        ) -> Self {
            self.improvement_status = Some(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn set_improvement_status(
            mut self,
            input: std::option::Option<crate::model::WorkloadImprovementStatus>,
        ) -> Self {
            self.improvement_status = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkloadSummary`](crate::model::WorkloadSummary)
        pub fn build(self) -> crate::model::WorkloadSummary {
            crate::model::WorkloadSummary {
                workload_id: self.workload_id,
                workload_arn: self.workload_arn,
                workload_name: self.workload_name,
                owner: self.owner,
                updated_at: self.updated_at,
                lenses: self.lenses,
                risk_counts: self.risk_counts,
                improvement_status: self.improvement_status,
            }
        }
    }
}
impl WorkloadSummary {
    /// Creates a new builder-style object to manufacture [`WorkloadSummary`](crate::model::WorkloadSummary)
    pub fn builder() -> crate::model::workload_summary::Builder {
        crate::model::workload_summary::Builder::default()
    }
}

/// <p>A share invitation summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShareInvitationSummary {
    /// <p>The ID assigned to the share invitation.</p>
    pub share_invitation_id: std::option::Option<std::string::String>,
    /// <p>An Amazon Web Services account ID.</p>
    pub shared_by: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub shared_with: std::option::Option<std::string::String>,
    /// <p>Permission granted on a workload share.</p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>The resource type of the share invitation.</p>
    pub share_resource_type: std::option::Option<crate::model::ShareResourceType>,
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The full name of the lens.</p>
    pub lens_name: std::option::Option<std::string::String>,
    /// <p>The ARN for the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
}
impl ShareInvitationSummary {
    /// <p>The ID assigned to the share invitation.</p>
    pub fn share_invitation_id(&self) -> std::option::Option<&str> {
        self.share_invitation_id.as_deref()
    }
    /// <p>An Amazon Web Services account ID.</p>
    pub fn shared_by(&self) -> std::option::Option<&str> {
        self.shared_by.as_deref()
    }
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub fn shared_with(&self) -> std::option::Option<&str> {
        self.shared_with.as_deref()
    }
    /// <p>Permission granted on a workload share.</p>
    pub fn permission_type(&self) -> std::option::Option<&crate::model::PermissionType> {
        self.permission_type.as_ref()
    }
    /// <p>The resource type of the share invitation.</p>
    pub fn share_resource_type(&self) -> std::option::Option<&crate::model::ShareResourceType> {
        self.share_resource_type.as_ref()
    }
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub fn workload_name(&self) -> std::option::Option<&str> {
        self.workload_name.as_deref()
    }
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The full name of the lens.</p>
    pub fn lens_name(&self) -> std::option::Option<&str> {
        self.lens_name.as_deref()
    }
    /// <p>The ARN for the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
}
impl std::fmt::Debug for ShareInvitationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShareInvitationSummary");
        formatter.field("share_invitation_id", &self.share_invitation_id);
        formatter.field("shared_by", &self.shared_by);
        formatter.field("shared_with", &self.shared_with);
        formatter.field("permission_type", &self.permission_type);
        formatter.field("share_resource_type", &self.share_resource_type);
        formatter.field("workload_name", &self.workload_name);
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_name", &self.lens_name);
        formatter.field("lens_arn", &self.lens_arn);
        formatter.finish()
    }
}
/// See [`ShareInvitationSummary`](crate::model::ShareInvitationSummary)
pub mod share_invitation_summary {
    /// A builder for [`ShareInvitationSummary`](crate::model::ShareInvitationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_invitation_id: std::option::Option<std::string::String>,
        pub(crate) shared_by: std::option::Option<std::string::String>,
        pub(crate) shared_with: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) share_resource_type: std::option::Option<crate::model::ShareResourceType>,
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_name: std::option::Option<std::string::String>,
        pub(crate) lens_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_invitation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.share_invitation_id = input;
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn shared_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_by = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn set_shared_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_by = input;
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_with = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_with = input;
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The resource type of the share invitation.</p>
        pub fn share_resource_type(mut self, input: crate::model::ShareResourceType) -> Self {
            self.share_resource_type = Some(input);
            self
        }
        /// <p>The resource type of the share invitation.</p>
        pub fn set_share_resource_type(
            mut self,
            input: std::option::Option<crate::model::ShareResourceType>,
        ) -> Self {
            self.share_resource_type = input;
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn lens_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_name = Some(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_lens_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_name = input;
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ShareInvitationSummary`](crate::model::ShareInvitationSummary)
        pub fn build(self) -> crate::model::ShareInvitationSummary {
            crate::model::ShareInvitationSummary {
                share_invitation_id: self.share_invitation_id,
                shared_by: self.shared_by,
                shared_with: self.shared_with,
                permission_type: self.permission_type,
                share_resource_type: self.share_resource_type,
                workload_name: self.workload_name,
                workload_id: self.workload_id,
                lens_name: self.lens_name,
                lens_arn: self.lens_arn,
            }
        }
    }
}
impl ShareInvitationSummary {
    /// Creates a new builder-style object to manufacture [`ShareInvitationSummary`](crate::model::ShareInvitationSummary)
    pub fn builder() -> crate::model::share_invitation_summary::Builder {
        crate::model::share_invitation_summary::Builder::default()
    }
}

/// <p>A notification summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationSummary {
    /// <p>The type of notification.</p>
    pub r#type: std::option::Option<crate::model::NotificationType>,
    /// <p>Summary of lens upgrade.</p>
    pub lens_upgrade_summary: std::option::Option<crate::model::LensUpgradeSummary>,
}
impl NotificationSummary {
    /// <p>The type of notification.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::NotificationType> {
        self.r#type.as_ref()
    }
    /// <p>Summary of lens upgrade.</p>
    pub fn lens_upgrade_summary(&self) -> std::option::Option<&crate::model::LensUpgradeSummary> {
        self.lens_upgrade_summary.as_ref()
    }
}
impl std::fmt::Debug for NotificationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationSummary");
        formatter.field("r#type", &self.r#type);
        formatter.field("lens_upgrade_summary", &self.lens_upgrade_summary);
        formatter.finish()
    }
}
/// See [`NotificationSummary`](crate::model::NotificationSummary)
pub mod notification_summary {
    /// A builder for [`NotificationSummary`](crate::model::NotificationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::NotificationType>,
        pub(crate) lens_upgrade_summary: std::option::Option<crate::model::LensUpgradeSummary>,
    }
    impl Builder {
        /// <p>The type of notification.</p>
        pub fn r#type(mut self, input: crate::model::NotificationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of notification.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::NotificationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Summary of lens upgrade.</p>
        pub fn lens_upgrade_summary(mut self, input: crate::model::LensUpgradeSummary) -> Self {
            self.lens_upgrade_summary = Some(input);
            self
        }
        /// <p>Summary of lens upgrade.</p>
        pub fn set_lens_upgrade_summary(
            mut self,
            input: std::option::Option<crate::model::LensUpgradeSummary>,
        ) -> Self {
            self.lens_upgrade_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationSummary`](crate::model::NotificationSummary)
        pub fn build(self) -> crate::model::NotificationSummary {
            crate::model::NotificationSummary {
                r#type: self.r#type,
                lens_upgrade_summary: self.lens_upgrade_summary,
            }
        }
    }
}
impl NotificationSummary {
    /// Creates a new builder-style object to manufacture [`NotificationSummary`](crate::model::NotificationSummary)
    pub fn builder() -> crate::model::notification_summary::Builder {
        crate::model::notification_summary::Builder::default()
    }
}

/// <p>Lens upgrade summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LensUpgradeSummary {
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ARN for the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
    /// <p>The current version of the lens.</p>
    pub current_lens_version: std::option::Option<std::string::String>,
    /// <p>The latest version of the lens.</p>
    pub latest_lens_version: std::option::Option<std::string::String>,
}
impl LensUpgradeSummary {
    /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub fn workload_name(&self) -> std::option::Option<&str> {
        self.workload_name.as_deref()
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The ARN for the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
    /// <p>The current version of the lens.</p>
    pub fn current_lens_version(&self) -> std::option::Option<&str> {
        self.current_lens_version.as_deref()
    }
    /// <p>The latest version of the lens.</p>
    pub fn latest_lens_version(&self) -> std::option::Option<&str> {
        self.latest_lens_version.as_deref()
    }
}
impl std::fmt::Debug for LensUpgradeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LensUpgradeSummary");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_name", &self.workload_name);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_arn", &self.lens_arn);
        formatter.field("current_lens_version", &self.current_lens_version);
        formatter.field("latest_lens_version", &self.latest_lens_version);
        formatter.finish()
    }
}
/// See [`LensUpgradeSummary`](crate::model::LensUpgradeSummary)
pub mod lens_upgrade_summary {
    /// A builder for [`LensUpgradeSummary`](crate::model::LensUpgradeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_arn: std::option::Option<std::string::String>,
        pub(crate) current_lens_version: std::option::Option<std::string::String>,
        pub(crate) latest_lens_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// <p>The current version of the lens.</p>
        pub fn current_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_lens_version = Some(input.into());
            self
        }
        /// <p>The current version of the lens.</p>
        pub fn set_current_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_lens_version = input;
            self
        }
        /// <p>The latest version of the lens.</p>
        pub fn latest_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_lens_version = Some(input.into());
            self
        }
        /// <p>The latest version of the lens.</p>
        pub fn set_latest_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_lens_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LensUpgradeSummary`](crate::model::LensUpgradeSummary)
        pub fn build(self) -> crate::model::LensUpgradeSummary {
            crate::model::LensUpgradeSummary {
                workload_id: self.workload_id,
                workload_name: self.workload_name,
                lens_alias: self.lens_alias,
                lens_arn: self.lens_arn,
                current_lens_version: self.current_lens_version,
                latest_lens_version: self.latest_lens_version,
            }
        }
    }
}
impl LensUpgradeSummary {
    /// Creates a new builder-style object to manufacture [`LensUpgradeSummary`](crate::model::LensUpgradeSummary)
    pub fn builder() -> crate::model::lens_upgrade_summary::Builder {
        crate::model::lens_upgrade_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationType {
    #[allow(missing_docs)] // documentation missing in model
    LensVersionDeprecated,
    #[allow(missing_docs)] // documentation missing in model
    LensVersionUpgraded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationType {
    fn from(s: &str) -> Self {
        match s {
            "LENS_VERSION_DEPRECATED" => NotificationType::LensVersionDeprecated,
            "LENS_VERSION_UPGRADED" => NotificationType::LensVersionUpgraded,
            other => NotificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationType::from(s))
    }
}
impl NotificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationType::LensVersionDeprecated => "LENS_VERSION_DEPRECATED",
            NotificationType::LensVersionUpgraded => "LENS_VERSION_UPGRADED",
            NotificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LENS_VERSION_DEPRECATED", "LENS_VERSION_UPGRADED"]
    }
}
impl AsRef<str> for NotificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A milestone summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MilestoneSummary {
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The name of the milestone in a workload.</p>
    /// <p>Milestone names must be unique within a workload.</p>
    pub milestone_name: std::option::Option<std::string::String>,
    /// <p>The date and time recorded.</p>
    pub recorded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A workload summary return object.</p>
    pub workload_summary: std::option::Option<crate::model::WorkloadSummary>,
}
impl MilestoneSummary {
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>The name of the milestone in a workload.</p>
    /// <p>Milestone names must be unique within a workload.</p>
    pub fn milestone_name(&self) -> std::option::Option<&str> {
        self.milestone_name.as_deref()
    }
    /// <p>The date and time recorded.</p>
    pub fn recorded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.recorded_at.as_ref()
    }
    /// <p>A workload summary return object.</p>
    pub fn workload_summary(&self) -> std::option::Option<&crate::model::WorkloadSummary> {
        self.workload_summary.as_ref()
    }
}
impl std::fmt::Debug for MilestoneSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MilestoneSummary");
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("milestone_name", &self.milestone_name);
        formatter.field("recorded_at", &self.recorded_at);
        formatter.field("workload_summary", &self.workload_summary);
        formatter.finish()
    }
}
/// See [`MilestoneSummary`](crate::model::MilestoneSummary)
pub mod milestone_summary {
    /// A builder for [`MilestoneSummary`](crate::model::MilestoneSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) milestone_name: std::option::Option<std::string::String>,
        pub(crate) recorded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) workload_summary: std::option::Option<crate::model::WorkloadSummary>,
    }
    impl Builder {
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.milestone_name = Some(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.milestone_name = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn recorded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.recorded_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_recorded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.recorded_at = input;
            self
        }
        /// <p>A workload summary return object.</p>
        pub fn workload_summary(mut self, input: crate::model::WorkloadSummary) -> Self {
            self.workload_summary = Some(input);
            self
        }
        /// <p>A workload summary return object.</p>
        pub fn set_workload_summary(
            mut self,
            input: std::option::Option<crate::model::WorkloadSummary>,
        ) -> Self {
            self.workload_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`MilestoneSummary`](crate::model::MilestoneSummary)
        pub fn build(self) -> crate::model::MilestoneSummary {
            crate::model::MilestoneSummary {
                milestone_number: self.milestone_number.unwrap_or_default(),
                milestone_name: self.milestone_name,
                recorded_at: self.recorded_at,
                workload_summary: self.workload_summary,
            }
        }
    }
}
impl MilestoneSummary {
    /// Creates a new builder-style object to manufacture [`MilestoneSummary`](crate::model::MilestoneSummary)
    pub fn builder() -> crate::model::milestone_summary::Builder {
        crate::model::milestone_summary::Builder::default()
    }
}

/// <p>A lens share summary return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LensShareSummary {
    /// <p>The ID associated with the workload share.</p>
    pub share_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub shared_with: std::option::Option<std::string::String>,
    /// <p>The status of a workload share.</p>
    pub status: std::option::Option<crate::model::ShareStatus>,
}
impl LensShareSummary {
    /// <p>The ID associated with the workload share.</p>
    pub fn share_id(&self) -> std::option::Option<&str> {
        self.share_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
    pub fn shared_with(&self) -> std::option::Option<&str> {
        self.shared_with.as_deref()
    }
    /// <p>The status of a workload share.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ShareStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for LensShareSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LensShareSummary");
        formatter.field("share_id", &self.share_id);
        formatter.field("shared_with", &self.shared_with);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`LensShareSummary`](crate::model::LensShareSummary)
pub mod lens_share_summary {
    /// A builder for [`LensShareSummary`](crate::model::LensShareSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_id: std::option::Option<std::string::String>,
        pub(crate) shared_with: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ShareStatus>,
    }
    impl Builder {
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_with = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_with = input;
            self
        }
        /// <p>The status of a workload share.</p>
        pub fn status(mut self, input: crate::model::ShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a workload share.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ShareStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`LensShareSummary`](crate::model::LensShareSummary)
        pub fn build(self) -> crate::model::LensShareSummary {
            crate::model::LensShareSummary {
                share_id: self.share_id,
                shared_with: self.shared_with,
                status: self.status,
            }
        }
    }
}
impl LensShareSummary {
    /// Creates a new builder-style object to manufacture [`LensShareSummary`](crate::model::LensShareSummary)
    pub fn builder() -> crate::model::lens_share_summary::Builder {
        crate::model::lens_share_summary::Builder::default()
    }
}

/// <p>A lens review summary of a workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LensReviewSummary {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ARN for the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
    /// <p>The version of the lens.</p>
    pub lens_version: std::option::Option<std::string::String>,
    /// <p>The full name of the lens.</p>
    pub lens_name: std::option::Option<std::string::String>,
    /// <p>The status of the lens.</p>
    pub lens_status: std::option::Option<crate::model::LensStatus>,
    /// <p>The date and time recorded.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub risk_counts: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
}
impl LensReviewSummary {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The ARN for the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
    /// <p>The version of the lens.</p>
    pub fn lens_version(&self) -> std::option::Option<&str> {
        self.lens_version.as_deref()
    }
    /// <p>The full name of the lens.</p>
    pub fn lens_name(&self) -> std::option::Option<&str> {
        self.lens_name.as_deref()
    }
    /// <p>The status of the lens.</p>
    pub fn lens_status(&self) -> std::option::Option<&crate::model::LensStatus> {
        self.lens_status.as_ref()
    }
    /// <p>The date and time recorded.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>A map from risk names to the count of how questions have that rating.</p>
    pub fn risk_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::Risk, i32>> {
        self.risk_counts.as_ref()
    }
}
impl std::fmt::Debug for LensReviewSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LensReviewSummary");
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_arn", &self.lens_arn);
        formatter.field("lens_version", &self.lens_version);
        formatter.field("lens_name", &self.lens_name);
        formatter.field("lens_status", &self.lens_status);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("risk_counts", &self.risk_counts);
        formatter.finish()
    }
}
/// See [`LensReviewSummary`](crate::model::LensReviewSummary)
pub mod lens_review_summary {
    /// A builder for [`LensReviewSummary`](crate::model::LensReviewSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_arn: std::option::Option<std::string::String>,
        pub(crate) lens_version: std::option::Option<std::string::String>,
        pub(crate) lens_name: std::option::Option<std::string::String>,
        pub(crate) lens_status: std::option::Option<crate::model::LensStatus>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) risk_counts:
            std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
    }
    impl Builder {
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// <p>The version of the lens.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_version = Some(input.into());
            self
        }
        /// <p>The version of the lens.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_version = input;
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn lens_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_name = Some(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_lens_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_name = input;
            self
        }
        /// <p>The status of the lens.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatus) -> Self {
            self.lens_status = Some(input);
            self
        }
        /// <p>The status of the lens.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatus>,
        ) -> Self {
            self.lens_status = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Adds a key-value pair to `risk_counts`.
        ///
        /// To override the contents of this collection use [`set_risk_counts`](Self::set_risk_counts).
        ///
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn risk_counts(mut self, k: impl Into<crate::model::Risk>, v: impl Into<i32>) -> Self {
            let mut hash_map = self.risk_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.risk_counts = Some(hash_map);
            self
        }
        /// <p>A map from risk names to the count of how questions have that rating.</p>
        pub fn set_risk_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<crate::model::Risk, i32>>,
        ) -> Self {
            self.risk_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`LensReviewSummary`](crate::model::LensReviewSummary)
        pub fn build(self) -> crate::model::LensReviewSummary {
            crate::model::LensReviewSummary {
                lens_alias: self.lens_alias,
                lens_arn: self.lens_arn,
                lens_version: self.lens_version,
                lens_name: self.lens_name,
                lens_status: self.lens_status,
                updated_at: self.updated_at,
                risk_counts: self.risk_counts,
            }
        }
    }
}
impl LensReviewSummary {
    /// Creates a new builder-style object to manufacture [`LensReviewSummary`](crate::model::LensReviewSummary)
    pub fn builder() -> crate::model::lens_review_summary::Builder {
        crate::model::lens_review_summary::Builder::default()
    }
}

/// <p>An improvement summary of a lens review in a workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImprovementSummary {
    /// <p>The ID of the question.</p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The title of the question.</p>
    pub question_title: std::option::Option<std::string::String>,
    /// <p>The risk for a given workload, lens review, pillar, or question.</p>
    pub risk: std::option::Option<crate::model::Risk>,
    /// <p>The improvement plan URL for a question.</p>
    /// <p>This value is only available if the question has been answered.</p>
    pub improvement_plan_url: std::option::Option<std::string::String>,
    /// <p>The improvement plan details.</p>
    pub improvement_plans: std::option::Option<std::vec::Vec<crate::model::ChoiceImprovementPlan>>,
}
impl ImprovementSummary {
    /// <p>The ID of the question.</p>
    pub fn question_id(&self) -> std::option::Option<&str> {
        self.question_id.as_deref()
    }
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub fn pillar_id(&self) -> std::option::Option<&str> {
        self.pillar_id.as_deref()
    }
    /// <p>The title of the question.</p>
    pub fn question_title(&self) -> std::option::Option<&str> {
        self.question_title.as_deref()
    }
    /// <p>The risk for a given workload, lens review, pillar, or question.</p>
    pub fn risk(&self) -> std::option::Option<&crate::model::Risk> {
        self.risk.as_ref()
    }
    /// <p>The improvement plan URL for a question.</p>
    /// <p>This value is only available if the question has been answered.</p>
    pub fn improvement_plan_url(&self) -> std::option::Option<&str> {
        self.improvement_plan_url.as_deref()
    }
    /// <p>The improvement plan details.</p>
    pub fn improvement_plans(&self) -> std::option::Option<&[crate::model::ChoiceImprovementPlan]> {
        self.improvement_plans.as_deref()
    }
}
impl std::fmt::Debug for ImprovementSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImprovementSummary");
        formatter.field("question_id", &self.question_id);
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("question_title", &self.question_title);
        formatter.field("risk", &self.risk);
        formatter.field("improvement_plan_url", &self.improvement_plan_url);
        formatter.field("improvement_plans", &self.improvement_plans);
        formatter.finish()
    }
}
/// See [`ImprovementSummary`](crate::model::ImprovementSummary)
pub mod improvement_summary {
    /// A builder for [`ImprovementSummary`](crate::model::ImprovementSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) question_title: std::option::Option<std::string::String>,
        pub(crate) risk: std::option::Option<crate::model::Risk>,
        pub(crate) improvement_plan_url: std::option::Option<std::string::String>,
        pub(crate) improvement_plans:
            std::option::Option<std::vec::Vec<crate::model::ChoiceImprovementPlan>>,
    }
    impl Builder {
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The title of the question.</p>
        pub fn question_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_title = Some(input.into());
            self
        }
        /// <p>The title of the question.</p>
        pub fn set_question_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.question_title = input;
            self
        }
        /// <p>The risk for a given workload, lens review, pillar, or question.</p>
        pub fn risk(mut self, input: crate::model::Risk) -> Self {
            self.risk = Some(input);
            self
        }
        /// <p>The risk for a given workload, lens review, pillar, or question.</p>
        pub fn set_risk(mut self, input: std::option::Option<crate::model::Risk>) -> Self {
            self.risk = input;
            self
        }
        /// <p>The improvement plan URL for a question.</p>
        /// <p>This value is only available if the question has been answered.</p>
        pub fn improvement_plan_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.improvement_plan_url = Some(input.into());
            self
        }
        /// <p>The improvement plan URL for a question.</p>
        /// <p>This value is only available if the question has been answered.</p>
        pub fn set_improvement_plan_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.improvement_plan_url = input;
            self
        }
        /// Appends an item to `improvement_plans`.
        ///
        /// To override the contents of this collection use [`set_improvement_plans`](Self::set_improvement_plans).
        ///
        /// <p>The improvement plan details.</p>
        pub fn improvement_plans(
            mut self,
            input: impl Into<crate::model::ChoiceImprovementPlan>,
        ) -> Self {
            let mut v = self.improvement_plans.unwrap_or_default();
            v.push(input.into());
            self.improvement_plans = Some(v);
            self
        }
        /// <p>The improvement plan details.</p>
        pub fn set_improvement_plans(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChoiceImprovementPlan>>,
        ) -> Self {
            self.improvement_plans = input;
            self
        }
        /// Consumes the builder and constructs a [`ImprovementSummary`](crate::model::ImprovementSummary)
        pub fn build(self) -> crate::model::ImprovementSummary {
            crate::model::ImprovementSummary {
                question_id: self.question_id,
                pillar_id: self.pillar_id,
                question_title: self.question_title,
                risk: self.risk,
                improvement_plan_url: self.improvement_plan_url,
                improvement_plans: self.improvement_plans,
            }
        }
    }
}
impl ImprovementSummary {
    /// Creates a new builder-style object to manufacture [`ImprovementSummary`](crate::model::ImprovementSummary)
    pub fn builder() -> crate::model::improvement_summary::Builder {
        crate::model::improvement_summary::Builder::default()
    }
}

/// <p>The choice level improvement plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChoiceImprovementPlan {
    /// <p>The ID of a choice.</p>
    pub choice_id: std::option::Option<std::string::String>,
    /// <p>The display text for the improvement plan.</p>
    pub display_text: std::option::Option<std::string::String>,
    /// <p>The improvement plan URL for a question.</p>
    /// <p>This value is only available if the question has been answered.</p>
    pub improvement_plan_url: std::option::Option<std::string::String>,
}
impl ChoiceImprovementPlan {
    /// <p>The ID of a choice.</p>
    pub fn choice_id(&self) -> std::option::Option<&str> {
        self.choice_id.as_deref()
    }
    /// <p>The display text for the improvement plan.</p>
    pub fn display_text(&self) -> std::option::Option<&str> {
        self.display_text.as_deref()
    }
    /// <p>The improvement plan URL for a question.</p>
    /// <p>This value is only available if the question has been answered.</p>
    pub fn improvement_plan_url(&self) -> std::option::Option<&str> {
        self.improvement_plan_url.as_deref()
    }
}
impl std::fmt::Debug for ChoiceImprovementPlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChoiceImprovementPlan");
        formatter.field("choice_id", &self.choice_id);
        formatter.field("display_text", &self.display_text);
        formatter.field("improvement_plan_url", &self.improvement_plan_url);
        formatter.finish()
    }
}
/// See [`ChoiceImprovementPlan`](crate::model::ChoiceImprovementPlan)
pub mod choice_improvement_plan {
    /// A builder for [`ChoiceImprovementPlan`](crate::model::ChoiceImprovementPlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) choice_id: std::option::Option<std::string::String>,
        pub(crate) display_text: std::option::Option<std::string::String>,
        pub(crate) improvement_plan_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of a choice.</p>
        pub fn choice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.choice_id = Some(input.into());
            self
        }
        /// <p>The ID of a choice.</p>
        pub fn set_choice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.choice_id = input;
            self
        }
        /// <p>The display text for the improvement plan.</p>
        pub fn display_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_text = Some(input.into());
            self
        }
        /// <p>The display text for the improvement plan.</p>
        pub fn set_display_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_text = input;
            self
        }
        /// <p>The improvement plan URL for a question.</p>
        /// <p>This value is only available if the question has been answered.</p>
        pub fn improvement_plan_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.improvement_plan_url = Some(input.into());
            self
        }
        /// <p>The improvement plan URL for a question.</p>
        /// <p>This value is only available if the question has been answered.</p>
        pub fn set_improvement_plan_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.improvement_plan_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ChoiceImprovementPlan`](crate::model::ChoiceImprovementPlan)
        pub fn build(self) -> crate::model::ChoiceImprovementPlan {
            crate::model::ChoiceImprovementPlan {
                choice_id: self.choice_id,
                display_text: self.display_text,
                improvement_plan_url: self.improvement_plan_url,
            }
        }
    }
}
impl ChoiceImprovementPlan {
    /// Creates a new builder-style object to manufacture [`ChoiceImprovementPlan`](crate::model::ChoiceImprovementPlan)
    pub fn builder() -> crate::model::choice_improvement_plan::Builder {
        crate::model::choice_improvement_plan::Builder::default()
    }
}

/// <p>A lens summary of a lens.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LensSummary {
    /// <p>The ARN of the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The full name of the lens.</p>
    pub lens_name: std::option::Option<std::string::String>,
    /// <p>The type of the lens.</p>
    pub lens_type: std::option::Option<crate::model::LensType>,
    /// <p>The description of the lens.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time recorded.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time recorded.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The version of the lens.</p>
    pub lens_version: std::option::Option<std::string::String>,
    /// <p>An Amazon Web Services account ID.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The status of the lens.</p>
    pub lens_status: std::option::Option<crate::model::LensStatus>,
}
impl LensSummary {
    /// <p>The ARN of the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The full name of the lens.</p>
    pub fn lens_name(&self) -> std::option::Option<&str> {
        self.lens_name.as_deref()
    }
    /// <p>The type of the lens.</p>
    pub fn lens_type(&self) -> std::option::Option<&crate::model::LensType> {
        self.lens_type.as_ref()
    }
    /// <p>The description of the lens.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time recorded.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The date and time recorded.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The version of the lens.</p>
    pub fn lens_version(&self) -> std::option::Option<&str> {
        self.lens_version.as_deref()
    }
    /// <p>An Amazon Web Services account ID.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The status of the lens.</p>
    pub fn lens_status(&self) -> std::option::Option<&crate::model::LensStatus> {
        self.lens_status.as_ref()
    }
}
impl std::fmt::Debug for LensSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LensSummary");
        formatter.field("lens_arn", &self.lens_arn);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_name", &self.lens_name);
        formatter.field("lens_type", &self.lens_type);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("lens_version", &self.lens_version);
        formatter.field("owner", &self.owner);
        formatter.field("lens_status", &self.lens_status);
        formatter.finish()
    }
}
/// See [`LensSummary`](crate::model::LensSummary)
pub mod lens_summary {
    /// A builder for [`LensSummary`](crate::model::LensSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_arn: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_name: std::option::Option<std::string::String>,
        pub(crate) lens_type: std::option::Option<crate::model::LensType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) lens_version: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) lens_status: std::option::Option<crate::model::LensStatus>,
    }
    impl Builder {
        /// <p>The ARN of the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn lens_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_name = Some(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_lens_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_name = input;
            self
        }
        /// <p>The type of the lens.</p>
        pub fn lens_type(mut self, input: crate::model::LensType) -> Self {
            self.lens_type = Some(input);
            self
        }
        /// <p>The type of the lens.</p>
        pub fn set_lens_type(mut self, input: std::option::Option<crate::model::LensType>) -> Self {
            self.lens_type = input;
            self
        }
        /// <p>The description of the lens.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the lens.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The version of the lens.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_version = Some(input.into());
            self
        }
        /// <p>The version of the lens.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_version = input;
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>An Amazon Web Services account ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The status of the lens.</p>
        pub fn lens_status(mut self, input: crate::model::LensStatus) -> Self {
            self.lens_status = Some(input);
            self
        }
        /// <p>The status of the lens.</p>
        pub fn set_lens_status(
            mut self,
            input: std::option::Option<crate::model::LensStatus>,
        ) -> Self {
            self.lens_status = input;
            self
        }
        /// Consumes the builder and constructs a [`LensSummary`](crate::model::LensSummary)
        pub fn build(self) -> crate::model::LensSummary {
            crate::model::LensSummary {
                lens_arn: self.lens_arn,
                lens_alias: self.lens_alias,
                lens_name: self.lens_name,
                lens_type: self.lens_type,
                description: self.description,
                created_at: self.created_at,
                updated_at: self.updated_at,
                lens_version: self.lens_version,
                owner: self.owner,
                lens_status: self.lens_status,
            }
        }
    }
}
impl LensSummary {
    /// Creates a new builder-style object to manufacture [`LensSummary`](crate::model::LensSummary)
    pub fn builder() -> crate::model::lens_summary::Builder {
        crate::model::lens_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LensType {
    #[allow(missing_docs)] // documentation missing in model
    AwsOfficial,
    #[allow(missing_docs)] // documentation missing in model
    CustomSelf,
    #[allow(missing_docs)] // documentation missing in model
    CustomShared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LensType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_OFFICIAL" => LensType::AwsOfficial,
            "CUSTOM_SELF" => LensType::CustomSelf,
            "CUSTOM_SHARED" => LensType::CustomShared,
            other => LensType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LensType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LensType::from(s))
    }
}
impl LensType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LensType::AwsOfficial => "AWS_OFFICIAL",
            LensType::CustomSelf => "CUSTOM_SELF",
            LensType::CustomShared => "CUSTOM_SHARED",
            LensType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_OFFICIAL", "CUSTOM_SELF", "CUSTOM_SHARED"]
    }
}
impl AsRef<str> for LensType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LensStatusType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Draft,
    #[allow(missing_docs)] // documentation missing in model
    Published,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LensStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => LensStatusType::All,
            "DRAFT" => LensStatusType::Draft,
            "PUBLISHED" => LensStatusType::Published,
            other => LensStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LensStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LensStatusType::from(s))
    }
}
impl LensStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LensStatusType::All => "ALL",
            LensStatusType::Draft => "DRAFT",
            LensStatusType::Published => "PUBLISHED",
            LensStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "DRAFT", "PUBLISHED"]
    }
}
impl AsRef<str> for LensStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An answer summary of a lens review in a workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnswerSummary {
    /// <p>The ID of the question.</p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The title of the question.</p>
    pub question_title: std::option::Option<std::string::String>,
    /// <p>List of choices available for a question.</p>
    pub choices: std::option::Option<std::vec::Vec<crate::model::Choice>>,
    /// <p>List of selected choice IDs in a question answer.</p>
    /// <p>The values entered replace the previously selected choices.</p>
    pub selected_choices: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of selected choices to a question in your workload.</p>
    pub choice_answer_summaries:
        std::option::Option<std::vec::Vec<crate::model::ChoiceAnswerSummary>>,
    /// <p>Defines whether this question is applicable to a lens review.</p>
    pub is_applicable: bool,
    /// <p>The risk for a given workload, lens review, pillar, or question.</p>
    pub risk: std::option::Option<crate::model::Risk>,
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub reason: std::option::Option<crate::model::AnswerReason>,
}
impl AnswerSummary {
    /// <p>The ID of the question.</p>
    pub fn question_id(&self) -> std::option::Option<&str> {
        self.question_id.as_deref()
    }
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub fn pillar_id(&self) -> std::option::Option<&str> {
        self.pillar_id.as_deref()
    }
    /// <p>The title of the question.</p>
    pub fn question_title(&self) -> std::option::Option<&str> {
        self.question_title.as_deref()
    }
    /// <p>List of choices available for a question.</p>
    pub fn choices(&self) -> std::option::Option<&[crate::model::Choice]> {
        self.choices.as_deref()
    }
    /// <p>List of selected choice IDs in a question answer.</p>
    /// <p>The values entered replace the previously selected choices.</p>
    pub fn selected_choices(&self) -> std::option::Option<&[std::string::String]> {
        self.selected_choices.as_deref()
    }
    /// <p>A list of selected choices to a question in your workload.</p>
    pub fn choice_answer_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ChoiceAnswerSummary]> {
        self.choice_answer_summaries.as_deref()
    }
    /// <p>Defines whether this question is applicable to a lens review.</p>
    pub fn is_applicable(&self) -> bool {
        self.is_applicable
    }
    /// <p>The risk for a given workload, lens review, pillar, or question.</p>
    pub fn risk(&self) -> std::option::Option<&crate::model::Risk> {
        self.risk.as_ref()
    }
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::AnswerReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for AnswerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnswerSummary");
        formatter.field("question_id", &self.question_id);
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("question_title", &self.question_title);
        formatter.field("choices", &self.choices);
        formatter.field("selected_choices", &self.selected_choices);
        formatter.field("choice_answer_summaries", &self.choice_answer_summaries);
        formatter.field("is_applicable", &self.is_applicable);
        formatter.field("risk", &self.risk);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`AnswerSummary`](crate::model::AnswerSummary)
pub mod answer_summary {
    /// A builder for [`AnswerSummary`](crate::model::AnswerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) question_title: std::option::Option<std::string::String>,
        pub(crate) choices: std::option::Option<std::vec::Vec<crate::model::Choice>>,
        pub(crate) selected_choices: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) choice_answer_summaries:
            std::option::Option<std::vec::Vec<crate::model::ChoiceAnswerSummary>>,
        pub(crate) is_applicable: std::option::Option<bool>,
        pub(crate) risk: std::option::Option<crate::model::Risk>,
        pub(crate) reason: std::option::Option<crate::model::AnswerReason>,
    }
    impl Builder {
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The title of the question.</p>
        pub fn question_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_title = Some(input.into());
            self
        }
        /// <p>The title of the question.</p>
        pub fn set_question_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.question_title = input;
            self
        }
        /// Appends an item to `choices`.
        ///
        /// To override the contents of this collection use [`set_choices`](Self::set_choices).
        ///
        /// <p>List of choices available for a question.</p>
        pub fn choices(mut self, input: impl Into<crate::model::Choice>) -> Self {
            let mut v = self.choices.unwrap_or_default();
            v.push(input.into());
            self.choices = Some(v);
            self
        }
        /// <p>List of choices available for a question.</p>
        pub fn set_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Choice>>,
        ) -> Self {
            self.choices = input;
            self
        }
        /// Appends an item to `selected_choices`.
        ///
        /// To override the contents of this collection use [`set_selected_choices`](Self::set_selected_choices).
        ///
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn selected_choices(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.selected_choices.unwrap_or_default();
            v.push(input.into());
            self.selected_choices = Some(v);
            self
        }
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn set_selected_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.selected_choices = input;
            self
        }
        /// Appends an item to `choice_answer_summaries`.
        ///
        /// To override the contents of this collection use [`set_choice_answer_summaries`](Self::set_choice_answer_summaries).
        ///
        /// <p>A list of selected choices to a question in your workload.</p>
        pub fn choice_answer_summaries(
            mut self,
            input: impl Into<crate::model::ChoiceAnswerSummary>,
        ) -> Self {
            let mut v = self.choice_answer_summaries.unwrap_or_default();
            v.push(input.into());
            self.choice_answer_summaries = Some(v);
            self
        }
        /// <p>A list of selected choices to a question in your workload.</p>
        pub fn set_choice_answer_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChoiceAnswerSummary>>,
        ) -> Self {
            self.choice_answer_summaries = input;
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn is_applicable(mut self, input: bool) -> Self {
            self.is_applicable = Some(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn set_is_applicable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_applicable = input;
            self
        }
        /// <p>The risk for a given workload, lens review, pillar, or question.</p>
        pub fn risk(mut self, input: crate::model::Risk) -> Self {
            self.risk = Some(input);
            self
        }
        /// <p>The risk for a given workload, lens review, pillar, or question.</p>
        pub fn set_risk(mut self, input: std::option::Option<crate::model::Risk>) -> Self {
            self.risk = input;
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn reason(mut self, input: crate::model::AnswerReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AnswerReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AnswerSummary`](crate::model::AnswerSummary)
        pub fn build(self) -> crate::model::AnswerSummary {
            crate::model::AnswerSummary {
                question_id: self.question_id,
                pillar_id: self.pillar_id,
                question_title: self.question_title,
                choices: self.choices,
                selected_choices: self.selected_choices,
                choice_answer_summaries: self.choice_answer_summaries,
                is_applicable: self.is_applicable.unwrap_or_default(),
                risk: self.risk,
                reason: self.reason,
            }
        }
    }
}
impl AnswerSummary {
    /// Creates a new builder-style object to manufacture [`AnswerSummary`](crate::model::AnswerSummary)
    pub fn builder() -> crate::model::answer_summary::Builder {
        crate::model::answer_summary::Builder::default()
    }
}

/// <p>A choice summary that has been answered on a question in your workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChoiceAnswerSummary {
    /// <p>The ID of a choice.</p>
    pub choice_id: std::option::Option<std::string::String>,
    /// <p>The status of a choice.</p>
    pub status: std::option::Option<crate::model::ChoiceStatus>,
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub reason: std::option::Option<crate::model::ChoiceReason>,
}
impl ChoiceAnswerSummary {
    /// <p>The ID of a choice.</p>
    pub fn choice_id(&self) -> std::option::Option<&str> {
        self.choice_id.as_deref()
    }
    /// <p>The status of a choice.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChoiceStatus> {
        self.status.as_ref()
    }
    /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ChoiceReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for ChoiceAnswerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChoiceAnswerSummary");
        formatter.field("choice_id", &self.choice_id);
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ChoiceAnswerSummary`](crate::model::ChoiceAnswerSummary)
pub mod choice_answer_summary {
    /// A builder for [`ChoiceAnswerSummary`](crate::model::ChoiceAnswerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) choice_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ChoiceStatus>,
        pub(crate) reason: std::option::Option<crate::model::ChoiceReason>,
    }
    impl Builder {
        /// <p>The ID of a choice.</p>
        pub fn choice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.choice_id = Some(input.into());
            self
        }
        /// <p>The ID of a choice.</p>
        pub fn set_choice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.choice_id = input;
            self
        }
        /// <p>The status of a choice.</p>
        pub fn status(mut self, input: crate::model::ChoiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a choice.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChoiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn reason(mut self, input: crate::model::ChoiceReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why a choice is non-applicable to a question in your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ChoiceReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ChoiceAnswerSummary`](crate::model::ChoiceAnswerSummary)
        pub fn build(self) -> crate::model::ChoiceAnswerSummary {
            crate::model::ChoiceAnswerSummary {
                choice_id: self.choice_id,
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl ChoiceAnswerSummary {
    /// Creates a new builder-style object to manufacture [`ChoiceAnswerSummary`](crate::model::ChoiceAnswerSummary)
    pub fn builder() -> crate::model::choice_answer_summary::Builder {
        crate::model::choice_answer_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportLensStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportLensStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ImportLensStatus::Complete,
            "ERROR" => ImportLensStatus::Error,
            "IN_PROGRESS" => ImportLensStatus::InProgress,
            other => ImportLensStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportLensStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportLensStatus::from(s))
    }
}
impl ImportLensStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportLensStatus::Complete => "COMPLETE",
            ImportLensStatus::Error => "ERROR",
            ImportLensStatus::InProgress => "IN_PROGRESS",
            ImportLensStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "ERROR", "IN_PROGRESS"]
    }
}
impl AsRef<str> for ImportLensStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A milestone return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Milestone {
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The name of the milestone in a workload.</p>
    /// <p>Milestone names must be unique within a workload.</p>
    pub milestone_name: std::option::Option<std::string::String>,
    /// <p>The date and time recorded.</p>
    pub recorded_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A workload return object.</p>
    pub workload: std::option::Option<crate::model::Workload>,
}
impl Milestone {
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>The name of the milestone in a workload.</p>
    /// <p>Milestone names must be unique within a workload.</p>
    pub fn milestone_name(&self) -> std::option::Option<&str> {
        self.milestone_name.as_deref()
    }
    /// <p>The date and time recorded.</p>
    pub fn recorded_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.recorded_at.as_ref()
    }
    /// <p>A workload return object.</p>
    pub fn workload(&self) -> std::option::Option<&crate::model::Workload> {
        self.workload.as_ref()
    }
}
impl std::fmt::Debug for Milestone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Milestone");
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("milestone_name", &self.milestone_name);
        formatter.field("recorded_at", &self.recorded_at);
        formatter.field("workload", &self.workload);
        formatter.finish()
    }
}
/// See [`Milestone`](crate::model::Milestone)
pub mod milestone {
    /// A builder for [`Milestone`](crate::model::Milestone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) milestone_name: std::option::Option<std::string::String>,
        pub(crate) recorded_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) workload: std::option::Option<crate::model::Workload>,
    }
    impl Builder {
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.milestone_name = Some(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.milestone_name = input;
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn recorded_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.recorded_at = Some(input);
            self
        }
        /// <p>The date and time recorded.</p>
        pub fn set_recorded_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.recorded_at = input;
            self
        }
        /// <p>A workload return object.</p>
        pub fn workload(mut self, input: crate::model::Workload) -> Self {
            self.workload = Some(input);
            self
        }
        /// <p>A workload return object.</p>
        pub fn set_workload(mut self, input: std::option::Option<crate::model::Workload>) -> Self {
            self.workload = input;
            self
        }
        /// Consumes the builder and constructs a [`Milestone`](crate::model::Milestone)
        pub fn build(self) -> crate::model::Milestone {
            crate::model::Milestone {
                milestone_number: self.milestone_number.unwrap_or_default(),
                milestone_name: self.milestone_name,
                recorded_at: self.recorded_at,
                workload: self.workload,
            }
        }
    }
}
impl Milestone {
    /// Creates a new builder-style object to manufacture [`Milestone`](crate::model::Milestone)
    pub fn builder() -> crate::model::milestone::Builder {
        crate::model::milestone::Builder::default()
    }
}

/// <p>The differences between the base and latest versions of the lens.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersionDifferences {
    /// <p>The differences between the base and latest versions of the lens.</p>
    pub pillar_differences: std::option::Option<std::vec::Vec<crate::model::PillarDifference>>,
}
impl VersionDifferences {
    /// <p>The differences between the base and latest versions of the lens.</p>
    pub fn pillar_differences(&self) -> std::option::Option<&[crate::model::PillarDifference]> {
        self.pillar_differences.as_deref()
    }
}
impl std::fmt::Debug for VersionDifferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersionDifferences");
        formatter.field("pillar_differences", &self.pillar_differences);
        formatter.finish()
    }
}
/// See [`VersionDifferences`](crate::model::VersionDifferences)
pub mod version_differences {
    /// A builder for [`VersionDifferences`](crate::model::VersionDifferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pillar_differences:
            std::option::Option<std::vec::Vec<crate::model::PillarDifference>>,
    }
    impl Builder {
        /// Appends an item to `pillar_differences`.
        ///
        /// To override the contents of this collection use [`set_pillar_differences`](Self::set_pillar_differences).
        ///
        /// <p>The differences between the base and latest versions of the lens.</p>
        pub fn pillar_differences(
            mut self,
            input: impl Into<crate::model::PillarDifference>,
        ) -> Self {
            let mut v = self.pillar_differences.unwrap_or_default();
            v.push(input.into());
            self.pillar_differences = Some(v);
            self
        }
        /// <p>The differences between the base and latest versions of the lens.</p>
        pub fn set_pillar_differences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PillarDifference>>,
        ) -> Self {
            self.pillar_differences = input;
            self
        }
        /// Consumes the builder and constructs a [`VersionDifferences`](crate::model::VersionDifferences)
        pub fn build(self) -> crate::model::VersionDifferences {
            crate::model::VersionDifferences {
                pillar_differences: self.pillar_differences,
            }
        }
    }
}
impl VersionDifferences {
    /// Creates a new builder-style object to manufacture [`VersionDifferences`](crate::model::VersionDifferences)
    pub fn builder() -> crate::model::version_differences::Builder {
        crate::model::version_differences::Builder::default()
    }
}

/// <p>A pillar difference return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PillarDifference {
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The name of the pillar.</p>
    pub pillar_name: std::option::Option<std::string::String>,
    /// <p>Indicates the type of change to the pillar.</p>
    pub difference_status: std::option::Option<crate::model::DifferenceStatus>,
    /// <p>List of question differences.</p>
    pub question_differences: std::option::Option<std::vec::Vec<crate::model::QuestionDifference>>,
}
impl PillarDifference {
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub fn pillar_id(&self) -> std::option::Option<&str> {
        self.pillar_id.as_deref()
    }
    /// <p>The name of the pillar.</p>
    pub fn pillar_name(&self) -> std::option::Option<&str> {
        self.pillar_name.as_deref()
    }
    /// <p>Indicates the type of change to the pillar.</p>
    pub fn difference_status(&self) -> std::option::Option<&crate::model::DifferenceStatus> {
        self.difference_status.as_ref()
    }
    /// <p>List of question differences.</p>
    pub fn question_differences(&self) -> std::option::Option<&[crate::model::QuestionDifference]> {
        self.question_differences.as_deref()
    }
}
impl std::fmt::Debug for PillarDifference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PillarDifference");
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("pillar_name", &self.pillar_name);
        formatter.field("difference_status", &self.difference_status);
        formatter.field("question_differences", &self.question_differences);
        formatter.finish()
    }
}
/// See [`PillarDifference`](crate::model::PillarDifference)
pub mod pillar_difference {
    /// A builder for [`PillarDifference`](crate::model::PillarDifference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) pillar_name: std::option::Option<std::string::String>,
        pub(crate) difference_status: std::option::Option<crate::model::DifferenceStatus>,
        pub(crate) question_differences:
            std::option::Option<std::vec::Vec<crate::model::QuestionDifference>>,
    }
    impl Builder {
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The name of the pillar.</p>
        pub fn pillar_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_name = Some(input.into());
            self
        }
        /// <p>The name of the pillar.</p>
        pub fn set_pillar_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_name = input;
            self
        }
        /// <p>Indicates the type of change to the pillar.</p>
        pub fn difference_status(mut self, input: crate::model::DifferenceStatus) -> Self {
            self.difference_status = Some(input);
            self
        }
        /// <p>Indicates the type of change to the pillar.</p>
        pub fn set_difference_status(
            mut self,
            input: std::option::Option<crate::model::DifferenceStatus>,
        ) -> Self {
            self.difference_status = input;
            self
        }
        /// Appends an item to `question_differences`.
        ///
        /// To override the contents of this collection use [`set_question_differences`](Self::set_question_differences).
        ///
        /// <p>List of question differences.</p>
        pub fn question_differences(
            mut self,
            input: impl Into<crate::model::QuestionDifference>,
        ) -> Self {
            let mut v = self.question_differences.unwrap_or_default();
            v.push(input.into());
            self.question_differences = Some(v);
            self
        }
        /// <p>List of question differences.</p>
        pub fn set_question_differences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QuestionDifference>>,
        ) -> Self {
            self.question_differences = input;
            self
        }
        /// Consumes the builder and constructs a [`PillarDifference`](crate::model::PillarDifference)
        pub fn build(self) -> crate::model::PillarDifference {
            crate::model::PillarDifference {
                pillar_id: self.pillar_id,
                pillar_name: self.pillar_name,
                difference_status: self.difference_status,
                question_differences: self.question_differences,
            }
        }
    }
}
impl PillarDifference {
    /// Creates a new builder-style object to manufacture [`PillarDifference`](crate::model::PillarDifference)
    pub fn builder() -> crate::model::pillar_difference::Builder {
        crate::model::pillar_difference::Builder::default()
    }
}

/// <p>A question difference return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuestionDifference {
    /// <p>The ID of the question.</p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p>The title of the question.</p>
    pub question_title: std::option::Option<std::string::String>,
    /// <p>Indicates the type of change to the question.</p>
    pub difference_status: std::option::Option<crate::model::DifferenceStatus>,
}
impl QuestionDifference {
    /// <p>The ID of the question.</p>
    pub fn question_id(&self) -> std::option::Option<&str> {
        self.question_id.as_deref()
    }
    /// <p>The title of the question.</p>
    pub fn question_title(&self) -> std::option::Option<&str> {
        self.question_title.as_deref()
    }
    /// <p>Indicates the type of change to the question.</p>
    pub fn difference_status(&self) -> std::option::Option<&crate::model::DifferenceStatus> {
        self.difference_status.as_ref()
    }
}
impl std::fmt::Debug for QuestionDifference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuestionDifference");
        formatter.field("question_id", &self.question_id);
        formatter.field("question_title", &self.question_title);
        formatter.field("difference_status", &self.difference_status);
        formatter.finish()
    }
}
/// See [`QuestionDifference`](crate::model::QuestionDifference)
pub mod question_difference {
    /// A builder for [`QuestionDifference`](crate::model::QuestionDifference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) question_title: std::option::Option<std::string::String>,
        pub(crate) difference_status: std::option::Option<crate::model::DifferenceStatus>,
    }
    impl Builder {
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// <p>The title of the question.</p>
        pub fn question_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_title = Some(input.into());
            self
        }
        /// <p>The title of the question.</p>
        pub fn set_question_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.question_title = input;
            self
        }
        /// <p>Indicates the type of change to the question.</p>
        pub fn difference_status(mut self, input: crate::model::DifferenceStatus) -> Self {
            self.difference_status = Some(input);
            self
        }
        /// <p>Indicates the type of change to the question.</p>
        pub fn set_difference_status(
            mut self,
            input: std::option::Option<crate::model::DifferenceStatus>,
        ) -> Self {
            self.difference_status = input;
            self
        }
        /// Consumes the builder and constructs a [`QuestionDifference`](crate::model::QuestionDifference)
        pub fn build(self) -> crate::model::QuestionDifference {
            crate::model::QuestionDifference {
                question_id: self.question_id,
                question_title: self.question_title,
                difference_status: self.difference_status,
            }
        }
    }
}
impl QuestionDifference {
    /// Creates a new builder-style object to manufacture [`QuestionDifference`](crate::model::QuestionDifference)
    pub fn builder() -> crate::model::question_difference::Builder {
        crate::model::question_difference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DifferenceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Updated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DifferenceStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => DifferenceStatus::Deleted,
            "NEW" => DifferenceStatus::New,
            "UPDATED" => DifferenceStatus::Updated,
            other => DifferenceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DifferenceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DifferenceStatus::from(s))
    }
}
impl DifferenceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DifferenceStatus::Deleted => "DELETED",
            DifferenceStatus::New => "NEW",
            DifferenceStatus::Updated => "UPDATED",
            DifferenceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "NEW", "UPDATED"]
    }
}
impl AsRef<str> for DifferenceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A report of a lens review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LensReviewReport {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ARN for the lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
    /// <p>The Base64-encoded string representation of a lens review report.</p>
    /// <p>This data can be used to create a PDF file.</p>
    pub base64_string: std::option::Option<std::string::String>,
}
impl LensReviewReport {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The ARN for the lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
    /// <p>The Base64-encoded string representation of a lens review report.</p>
    /// <p>This data can be used to create a PDF file.</p>
    pub fn base64_string(&self) -> std::option::Option<&str> {
        self.base64_string.as_deref()
    }
}
impl std::fmt::Debug for LensReviewReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LensReviewReport");
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_arn", &self.lens_arn);
        formatter.field("base64_string", &self.base64_string);
        formatter.finish()
    }
}
/// See [`LensReviewReport`](crate::model::LensReviewReport)
pub mod lens_review_report {
    /// A builder for [`LensReviewReport`](crate::model::LensReviewReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_arn: std::option::Option<std::string::String>,
        pub(crate) base64_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// <p>The Base64-encoded string representation of a lens review report.</p>
        /// <p>This data can be used to create a PDF file.</p>
        pub fn base64_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.base64_string = Some(input.into());
            self
        }
        /// <p>The Base64-encoded string representation of a lens review report.</p>
        /// <p>This data can be used to create a PDF file.</p>
        pub fn set_base64_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base64_string = input;
            self
        }
        /// Consumes the builder and constructs a [`LensReviewReport`](crate::model::LensReviewReport)
        pub fn build(self) -> crate::model::LensReviewReport {
            crate::model::LensReviewReport {
                lens_alias: self.lens_alias,
                lens_arn: self.lens_arn,
                base64_string: self.base64_string,
            }
        }
    }
}
impl LensReviewReport {
    /// Creates a new builder-style object to manufacture [`LensReviewReport`](crate::model::LensReviewReport)
    pub fn builder() -> crate::model::lens_review_report::Builder {
        crate::model::lens_review_report::Builder::default()
    }
}

/// <p>A lens return object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Lens {
    /// <p>The ARN of a lens.</p>
    pub lens_arn: std::option::Option<std::string::String>,
    /// <p>The version of a lens.</p>
    pub lens_version: std::option::Option<std::string::String>,
    /// <p>The full name of the lens.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the lens.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID that owns the lens.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The ID assigned to the share invitation.</p>
    pub share_invitation_id: std::option::Option<std::string::String>,
}
impl Lens {
    /// <p>The ARN of a lens.</p>
    pub fn lens_arn(&self) -> std::option::Option<&str> {
        self.lens_arn.as_deref()
    }
    /// <p>The version of a lens.</p>
    pub fn lens_version(&self) -> std::option::Option<&str> {
        self.lens_version.as_deref()
    }
    /// <p>The full name of the lens.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the lens.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Web Services account ID that owns the lens.</p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>The ID assigned to the share invitation.</p>
    pub fn share_invitation_id(&self) -> std::option::Option<&str> {
        self.share_invitation_id.as_deref()
    }
}
impl std::fmt::Debug for Lens {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Lens");
        formatter.field("lens_arn", &self.lens_arn);
        formatter.field("lens_version", &self.lens_version);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("owner", &self.owner);
        formatter.field("share_invitation_id", &self.share_invitation_id);
        formatter.finish()
    }
}
/// See [`Lens`](crate::model::Lens)
pub mod lens {
    /// A builder for [`Lens`](crate::model::Lens)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_arn: std::option::Option<std::string::String>,
        pub(crate) lens_version: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) share_invitation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of a lens.</p>
        pub fn lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a lens.</p>
        pub fn set_lens_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_arn = input;
            self
        }
        /// <p>The version of a lens.</p>
        pub fn lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_version = Some(input.into());
            self
        }
        /// <p>The version of a lens.</p>
        pub fn set_lens_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_version = input;
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The full name of the lens.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the lens.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the lens.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Web Services account ID that owns the lens.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the lens.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_invitation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.share_invitation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Lens`](crate::model::Lens)
        pub fn build(self) -> crate::model::Lens {
            crate::model::Lens {
                lens_arn: self.lens_arn,
                lens_version: self.lens_version,
                name: self.name,
                description: self.description,
                owner: self.owner,
                share_invitation_id: self.share_invitation_id,
            }
        }
    }
}
impl Lens {
    /// Creates a new builder-style object to manufacture [`Lens`](crate::model::Lens)
    pub fn builder() -> crate::model::lens::Builder {
        crate::model::lens::Builder::default()
    }
}
