// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeLensReviewOutput {}
impl std::fmt::Debug for UpgradeLensReviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeLensReviewOutput");
        formatter.finish()
    }
}
/// See [`UpgradeLensReviewOutput`](crate::output::UpgradeLensReviewOutput)
pub mod upgrade_lens_review_output {
    /// A builder for [`UpgradeLensReviewOutput`](crate::output::UpgradeLensReviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpgradeLensReviewOutput`](crate::output::UpgradeLensReviewOutput)
        pub fn build(self) -> crate::output::UpgradeLensReviewOutput {
            crate::output::UpgradeLensReviewOutput {}
        }
    }
}
impl UpgradeLensReviewOutput {
    /// Creates a new builder-style object to manufacture [`UpgradeLensReviewOutput`](crate::output::UpgradeLensReviewOutput)
    pub fn builder() -> crate::output::upgrade_lens_review_output::Builder {
        crate::output::upgrade_lens_review_output::Builder::default()
    }
}

/// <p>Input for Update Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkloadShareOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A workload share return object.</p>
    pub workload_share: std::option::Option<crate::model::WorkloadShare>,
}
impl UpdateWorkloadShareOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>A workload share return object.</p>
    pub fn workload_share(&self) -> std::option::Option<&crate::model::WorkloadShare> {
        self.workload_share.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkloadShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkloadShareOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_share", &self.workload_share);
        formatter.finish()
    }
}
/// See [`UpdateWorkloadShareOutput`](crate::output::UpdateWorkloadShareOutput)
pub mod update_workload_share_output {
    /// A builder for [`UpdateWorkloadShareOutput`](crate::output::UpdateWorkloadShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_share: std::option::Option<crate::model::WorkloadShare>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>A workload share return object.</p>
        pub fn workload_share(mut self, input: crate::model::WorkloadShare) -> Self {
            self.workload_share = Some(input);
            self
        }
        /// <p>A workload share return object.</p>
        pub fn set_workload_share(
            mut self,
            input: std::option::Option<crate::model::WorkloadShare>,
        ) -> Self {
            self.workload_share = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkloadShareOutput`](crate::output::UpdateWorkloadShareOutput)
        pub fn build(self) -> crate::output::UpdateWorkloadShareOutput {
            crate::output::UpdateWorkloadShareOutput {
                workload_id: self.workload_id,
                workload_share: self.workload_share,
            }
        }
    }
}
impl UpdateWorkloadShareOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkloadShareOutput`](crate::output::UpdateWorkloadShareOutput)
    pub fn builder() -> crate::output::update_workload_share_output::Builder {
        crate::output::update_workload_share_output::Builder::default()
    }
}

/// <p>Output of an update workload call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkloadOutput {
    /// <p>A workload return object.</p>
    pub workload: std::option::Option<crate::model::Workload>,
}
impl UpdateWorkloadOutput {
    /// <p>A workload return object.</p>
    pub fn workload(&self) -> std::option::Option<&crate::model::Workload> {
        self.workload.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkloadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkloadOutput");
        formatter.field("workload", &self.workload);
        formatter.finish()
    }
}
/// See [`UpdateWorkloadOutput`](crate::output::UpdateWorkloadOutput)
pub mod update_workload_output {
    /// A builder for [`UpdateWorkloadOutput`](crate::output::UpdateWorkloadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload: std::option::Option<crate::model::Workload>,
    }
    impl Builder {
        /// <p>A workload return object.</p>
        pub fn workload(mut self, input: crate::model::Workload) -> Self {
            self.workload = Some(input);
            self
        }
        /// <p>A workload return object.</p>
        pub fn set_workload(mut self, input: std::option::Option<crate::model::Workload>) -> Self {
            self.workload = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkloadOutput`](crate::output::UpdateWorkloadOutput)
        pub fn build(self) -> crate::output::UpdateWorkloadOutput {
            crate::output::UpdateWorkloadOutput {
                workload: self.workload,
            }
        }
    }
}
impl UpdateWorkloadOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkloadOutput`](crate::output::UpdateWorkloadOutput)
    pub fn builder() -> crate::output::update_workload_output::Builder {
        crate::output::update_workload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateShareInvitationOutput {
    /// <p>The updated workload share invitation.</p>
    pub share_invitation: std::option::Option<crate::model::ShareInvitation>,
}
impl UpdateShareInvitationOutput {
    /// <p>The updated workload share invitation.</p>
    pub fn share_invitation(&self) -> std::option::Option<&crate::model::ShareInvitation> {
        self.share_invitation.as_ref()
    }
}
impl std::fmt::Debug for UpdateShareInvitationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateShareInvitationOutput");
        formatter.field("share_invitation", &self.share_invitation);
        formatter.finish()
    }
}
/// See [`UpdateShareInvitationOutput`](crate::output::UpdateShareInvitationOutput)
pub mod update_share_invitation_output {
    /// A builder for [`UpdateShareInvitationOutput`](crate::output::UpdateShareInvitationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_invitation: std::option::Option<crate::model::ShareInvitation>,
    }
    impl Builder {
        /// <p>The updated workload share invitation.</p>
        pub fn share_invitation(mut self, input: crate::model::ShareInvitation) -> Self {
            self.share_invitation = Some(input);
            self
        }
        /// <p>The updated workload share invitation.</p>
        pub fn set_share_invitation(
            mut self,
            input: std::option::Option<crate::model::ShareInvitation>,
        ) -> Self {
            self.share_invitation = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateShareInvitationOutput`](crate::output::UpdateShareInvitationOutput)
        pub fn build(self) -> crate::output::UpdateShareInvitationOutput {
            crate::output::UpdateShareInvitationOutput {
                share_invitation: self.share_invitation,
            }
        }
    }
}
impl UpdateShareInvitationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateShareInvitationOutput`](crate::output::UpdateShareInvitationOutput)
    pub fn builder() -> crate::output::update_share_invitation_output::Builder {
        crate::output::update_share_invitation_output::Builder::default()
    }
}

/// <p>Output of a update lens review call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLensReviewOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A lens review of a question.</p>
    pub lens_review: std::option::Option<crate::model::LensReview>,
}
impl UpdateLensReviewOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>A lens review of a question.</p>
    pub fn lens_review(&self) -> std::option::Option<&crate::model::LensReview> {
        self.lens_review.as_ref()
    }
}
impl std::fmt::Debug for UpdateLensReviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLensReviewOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_review", &self.lens_review);
        formatter.finish()
    }
}
/// See [`UpdateLensReviewOutput`](crate::output::UpdateLensReviewOutput)
pub mod update_lens_review_output {
    /// A builder for [`UpdateLensReviewOutput`](crate::output::UpdateLensReviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_review: std::option::Option<crate::model::LensReview>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>A lens review of a question.</p>
        pub fn lens_review(mut self, input: crate::model::LensReview) -> Self {
            self.lens_review = Some(input);
            self
        }
        /// <p>A lens review of a question.</p>
        pub fn set_lens_review(
            mut self,
            input: std::option::Option<crate::model::LensReview>,
        ) -> Self {
            self.lens_review = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLensReviewOutput`](crate::output::UpdateLensReviewOutput)
        pub fn build(self) -> crate::output::UpdateLensReviewOutput {
            crate::output::UpdateLensReviewOutput {
                workload_id: self.workload_id,
                lens_review: self.lens_review,
            }
        }
    }
}
impl UpdateLensReviewOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLensReviewOutput`](crate::output::UpdateLensReviewOutput)
    pub fn builder() -> crate::output::update_lens_review_output::Builder {
        crate::output::update_lens_review_output::Builder::default()
    }
}

/// <p>Output of a update answer call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnswerOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>An answer of the question.</p>
    pub answer: std::option::Option<crate::model::Answer>,
}
impl UpdateAnswerOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>An answer of the question.</p>
    pub fn answer(&self) -> std::option::Option<&crate::model::Answer> {
        self.answer.as_ref()
    }
}
impl std::fmt::Debug for UpdateAnswerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnswerOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("answer", &self.answer);
        formatter.finish()
    }
}
/// See [`UpdateAnswerOutput`](crate::output::UpdateAnswerOutput)
pub mod update_answer_output {
    /// A builder for [`UpdateAnswerOutput`](crate::output::UpdateAnswerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) answer: std::option::Option<crate::model::Answer>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>An answer of the question.</p>
        pub fn answer(mut self, input: crate::model::Answer) -> Self {
            self.answer = Some(input);
            self
        }
        /// <p>An answer of the question.</p>
        pub fn set_answer(mut self, input: std::option::Option<crate::model::Answer>) -> Self {
            self.answer = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnswerOutput`](crate::output::UpdateAnswerOutput)
        pub fn build(self) -> crate::output::UpdateAnswerOutput {
            crate::output::UpdateAnswerOutput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                answer: self.answer,
            }
        }
    }
}
impl UpdateAnswerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAnswerOutput`](crate::output::UpdateAnswerOutput)
    pub fn builder() -> crate::output::update_answer_output::Builder {
        crate::output::update_answer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>Input for List Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkloadSharesOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A list of workload share summaries.</p>
    pub workload_share_summaries:
        std::option::Option<std::vec::Vec<crate::model::WorkloadShareSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkloadSharesOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>A list of workload share summaries.</p>
    pub fn workload_share_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::WorkloadShareSummary]> {
        self.workload_share_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkloadSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkloadSharesOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_share_summaries", &self.workload_share_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkloadSharesOutput`](crate::output::ListWorkloadSharesOutput)
pub mod list_workload_shares_output {
    /// A builder for [`ListWorkloadSharesOutput`](crate::output::ListWorkloadSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_share_summaries:
            std::option::Option<std::vec::Vec<crate::model::WorkloadShareSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// Appends an item to `workload_share_summaries`.
        ///
        /// To override the contents of this collection use [`set_workload_share_summaries`](Self::set_workload_share_summaries).
        ///
        /// <p>A list of workload share summaries.</p>
        pub fn workload_share_summaries(
            mut self,
            input: impl Into<crate::model::WorkloadShareSummary>,
        ) -> Self {
            let mut v = self.workload_share_summaries.unwrap_or_default();
            v.push(input.into());
            self.workload_share_summaries = Some(v);
            self
        }
        /// <p>A list of workload share summaries.</p>
        pub fn set_workload_share_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkloadShareSummary>>,
        ) -> Self {
            self.workload_share_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkloadSharesOutput`](crate::output::ListWorkloadSharesOutput)
        pub fn build(self) -> crate::output::ListWorkloadSharesOutput {
            crate::output::ListWorkloadSharesOutput {
                workload_id: self.workload_id,
                workload_share_summaries: self.workload_share_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkloadSharesOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkloadSharesOutput`](crate::output::ListWorkloadSharesOutput)
    pub fn builder() -> crate::output::list_workload_shares_output::Builder {
        crate::output::list_workload_shares_output::Builder::default()
    }
}

/// <p>Output of a list workloads call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkloadsOutput {
    /// <p>A list of workload summaries.</p>
    pub workload_summaries: std::option::Option<std::vec::Vec<crate::model::WorkloadSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkloadsOutput {
    /// <p>A list of workload summaries.</p>
    pub fn workload_summaries(&self) -> std::option::Option<&[crate::model::WorkloadSummary]> {
        self.workload_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkloadsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkloadsOutput");
        formatter.field("workload_summaries", &self.workload_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkloadsOutput`](crate::output::ListWorkloadsOutput)
pub mod list_workloads_output {
    /// A builder for [`ListWorkloadsOutput`](crate::output::ListWorkloadsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_summaries:
            std::option::Option<std::vec::Vec<crate::model::WorkloadSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workload_summaries`.
        ///
        /// To override the contents of this collection use [`set_workload_summaries`](Self::set_workload_summaries).
        ///
        /// <p>A list of workload summaries.</p>
        pub fn workload_summaries(
            mut self,
            input: impl Into<crate::model::WorkloadSummary>,
        ) -> Self {
            let mut v = self.workload_summaries.unwrap_or_default();
            v.push(input.into());
            self.workload_summaries = Some(v);
            self
        }
        /// <p>A list of workload summaries.</p>
        pub fn set_workload_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkloadSummary>>,
        ) -> Self {
            self.workload_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkloadsOutput`](crate::output::ListWorkloadsOutput)
        pub fn build(self) -> crate::output::ListWorkloadsOutput {
            crate::output::ListWorkloadsOutput {
                workload_summaries: self.workload_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkloadsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkloadsOutput`](crate::output::ListWorkloadsOutput)
    pub fn builder() -> crate::output::list_workloads_output::Builder {
        crate::output::list_workloads_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>Input for List Share Invitations</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListShareInvitationsOutput {
    /// <p>List of share invitation summaries in a workload.</p>
    pub share_invitation_summaries:
        std::option::Option<std::vec::Vec<crate::model::ShareInvitationSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListShareInvitationsOutput {
    /// <p>List of share invitation summaries in a workload.</p>
    pub fn share_invitation_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ShareInvitationSummary]> {
        self.share_invitation_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListShareInvitationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListShareInvitationsOutput");
        formatter.field(
            "share_invitation_summaries",
            &self.share_invitation_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListShareInvitationsOutput`](crate::output::ListShareInvitationsOutput)
pub mod list_share_invitations_output {
    /// A builder for [`ListShareInvitationsOutput`](crate::output::ListShareInvitationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_invitation_summaries:
            std::option::Option<std::vec::Vec<crate::model::ShareInvitationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `share_invitation_summaries`.
        ///
        /// To override the contents of this collection use [`set_share_invitation_summaries`](Self::set_share_invitation_summaries).
        ///
        /// <p>List of share invitation summaries in a workload.</p>
        pub fn share_invitation_summaries(
            mut self,
            input: impl Into<crate::model::ShareInvitationSummary>,
        ) -> Self {
            let mut v = self.share_invitation_summaries.unwrap_or_default();
            v.push(input.into());
            self.share_invitation_summaries = Some(v);
            self
        }
        /// <p>List of share invitation summaries in a workload.</p>
        pub fn set_share_invitation_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ShareInvitationSummary>>,
        ) -> Self {
            self.share_invitation_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListShareInvitationsOutput`](crate::output::ListShareInvitationsOutput)
        pub fn build(self) -> crate::output::ListShareInvitationsOutput {
            crate::output::ListShareInvitationsOutput {
                share_invitation_summaries: self.share_invitation_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListShareInvitationsOutput {
    /// Creates a new builder-style object to manufacture [`ListShareInvitationsOutput`](crate::output::ListShareInvitationsOutput)
    pub fn builder() -> crate::output::list_share_invitations_output::Builder {
        crate::output::list_share_invitations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationsOutput {
    /// <p>List of lens notification summaries in a workload.</p>
    pub notification_summaries:
        std::option::Option<std::vec::Vec<crate::model::NotificationSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNotificationsOutput {
    /// <p>List of lens notification summaries in a workload.</p>
    pub fn notification_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationSummary]> {
        self.notification_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationsOutput");
        formatter.field("notification_summaries", &self.notification_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
pub mod list_notifications_output {
    /// A builder for [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_summaries:
            std::option::Option<std::vec::Vec<crate::model::NotificationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `notification_summaries`.
        ///
        /// To override the contents of this collection use [`set_notification_summaries`](Self::set_notification_summaries).
        ///
        /// <p>List of lens notification summaries in a workload.</p>
        pub fn notification_summaries(
            mut self,
            input: impl Into<crate::model::NotificationSummary>,
        ) -> Self {
            let mut v = self.notification_summaries.unwrap_or_default();
            v.push(input.into());
            self.notification_summaries = Some(v);
            self
        }
        /// <p>List of lens notification summaries in a workload.</p>
        pub fn set_notification_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationSummary>>,
        ) -> Self {
            self.notification_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
        pub fn build(self) -> crate::output::ListNotificationsOutput {
            crate::output::ListNotificationsOutput {
                notification_summaries: self.notification_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
    pub fn builder() -> crate::output::list_notifications_output::Builder {
        crate::output::list_notifications_output::Builder::default()
    }
}

/// <p>Output of a list milestones call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMilestonesOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A list of milestone summaries.</p>
    pub milestone_summaries: std::option::Option<std::vec::Vec<crate::model::MilestoneSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMilestonesOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>A list of milestone summaries.</p>
    pub fn milestone_summaries(&self) -> std::option::Option<&[crate::model::MilestoneSummary]> {
        self.milestone_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMilestonesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMilestonesOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_summaries", &self.milestone_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMilestonesOutput`](crate::output::ListMilestonesOutput)
pub mod list_milestones_output {
    /// A builder for [`ListMilestonesOutput`](crate::output::ListMilestonesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_summaries:
            std::option::Option<std::vec::Vec<crate::model::MilestoneSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// Appends an item to `milestone_summaries`.
        ///
        /// To override the contents of this collection use [`set_milestone_summaries`](Self::set_milestone_summaries).
        ///
        /// <p>A list of milestone summaries.</p>
        pub fn milestone_summaries(
            mut self,
            input: impl Into<crate::model::MilestoneSummary>,
        ) -> Self {
            let mut v = self.milestone_summaries.unwrap_or_default();
            v.push(input.into());
            self.milestone_summaries = Some(v);
            self
        }
        /// <p>A list of milestone summaries.</p>
        pub fn set_milestone_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MilestoneSummary>>,
        ) -> Self {
            self.milestone_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMilestonesOutput`](crate::output::ListMilestonesOutput)
        pub fn build(self) -> crate::output::ListMilestonesOutput {
            crate::output::ListMilestonesOutput {
                workload_id: self.workload_id,
                milestone_summaries: self.milestone_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMilestonesOutput {
    /// Creates a new builder-style object to manufacture [`ListMilestonesOutput`](crate::output::ListMilestonesOutput)
    pub fn builder() -> crate::output::list_milestones_output::Builder {
        crate::output::list_milestones_output::Builder::default()
    }
}

/// <p>Output of a list lens reviews call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLensReviewsOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>List of lens summaries of lens reviews of a workload.</p>
    pub lens_review_summaries: std::option::Option<std::vec::Vec<crate::model::LensReviewSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLensReviewsOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>List of lens summaries of lens reviews of a workload.</p>
    pub fn lens_review_summaries(&self) -> std::option::Option<&[crate::model::LensReviewSummary]> {
        self.lens_review_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLensReviewsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLensReviewsOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("lens_review_summaries", &self.lens_review_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLensReviewsOutput`](crate::output::ListLensReviewsOutput)
pub mod list_lens_reviews_output {
    /// A builder for [`ListLensReviewsOutput`](crate::output::ListLensReviewsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) lens_review_summaries:
            std::option::Option<std::vec::Vec<crate::model::LensReviewSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// Appends an item to `lens_review_summaries`.
        ///
        /// To override the contents of this collection use [`set_lens_review_summaries`](Self::set_lens_review_summaries).
        ///
        /// <p>List of lens summaries of lens reviews of a workload.</p>
        pub fn lens_review_summaries(
            mut self,
            input: impl Into<crate::model::LensReviewSummary>,
        ) -> Self {
            let mut v = self.lens_review_summaries.unwrap_or_default();
            v.push(input.into());
            self.lens_review_summaries = Some(v);
            self
        }
        /// <p>List of lens summaries of lens reviews of a workload.</p>
        pub fn set_lens_review_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LensReviewSummary>>,
        ) -> Self {
            self.lens_review_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLensReviewsOutput`](crate::output::ListLensReviewsOutput)
        pub fn build(self) -> crate::output::ListLensReviewsOutput {
            crate::output::ListLensReviewsOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                lens_review_summaries: self.lens_review_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLensReviewsOutput {
    /// Creates a new builder-style object to manufacture [`ListLensReviewsOutput`](crate::output::ListLensReviewsOutput)
    pub fn builder() -> crate::output::list_lens_reviews_output::Builder {
        crate::output::list_lens_reviews_output::Builder::default()
    }
}

/// <p>Output of a list lens review improvements call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLensReviewImprovementsOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>List of improvement summaries of lens review in a workload.</p>
    pub improvement_summaries: std::option::Option<std::vec::Vec<crate::model::ImprovementSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLensReviewImprovementsOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>List of improvement summaries of lens review in a workload.</p>
    pub fn improvement_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ImprovementSummary]> {
        self.improvement_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLensReviewImprovementsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLensReviewImprovementsOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("improvement_summaries", &self.improvement_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLensReviewImprovementsOutput`](crate::output::ListLensReviewImprovementsOutput)
pub mod list_lens_review_improvements_output {
    /// A builder for [`ListLensReviewImprovementsOutput`](crate::output::ListLensReviewImprovementsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) improvement_summaries:
            std::option::Option<std::vec::Vec<crate::model::ImprovementSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// Appends an item to `improvement_summaries`.
        ///
        /// To override the contents of this collection use [`set_improvement_summaries`](Self::set_improvement_summaries).
        ///
        /// <p>List of improvement summaries of lens review in a workload.</p>
        pub fn improvement_summaries(
            mut self,
            input: impl Into<crate::model::ImprovementSummary>,
        ) -> Self {
            let mut v = self.improvement_summaries.unwrap_or_default();
            v.push(input.into());
            self.improvement_summaries = Some(v);
            self
        }
        /// <p>List of improvement summaries of lens review in a workload.</p>
        pub fn set_improvement_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImprovementSummary>>,
        ) -> Self {
            self.improvement_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLensReviewImprovementsOutput`](crate::output::ListLensReviewImprovementsOutput)
        pub fn build(self) -> crate::output::ListLensReviewImprovementsOutput {
            crate::output::ListLensReviewImprovementsOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                lens_alias: self.lens_alias,
                improvement_summaries: self.improvement_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLensReviewImprovementsOutput {
    /// Creates a new builder-style object to manufacture [`ListLensReviewImprovementsOutput`](crate::output::ListLensReviewImprovementsOutput)
    pub fn builder() -> crate::output::list_lens_review_improvements_output::Builder {
        crate::output::list_lens_review_improvements_output::Builder::default()
    }
}

/// <p>Output of a list lenses call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLensesOutput {
    /// <p>List of lens summaries of available lenses.</p>
    pub lens_summaries: std::option::Option<std::vec::Vec<crate::model::LensSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLensesOutput {
    /// <p>List of lens summaries of available lenses.</p>
    pub fn lens_summaries(&self) -> std::option::Option<&[crate::model::LensSummary]> {
        self.lens_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLensesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLensesOutput");
        formatter.field("lens_summaries", &self.lens_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLensesOutput`](crate::output::ListLensesOutput)
pub mod list_lenses_output {
    /// A builder for [`ListLensesOutput`](crate::output::ListLensesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_summaries: std::option::Option<std::vec::Vec<crate::model::LensSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `lens_summaries`.
        ///
        /// To override the contents of this collection use [`set_lens_summaries`](Self::set_lens_summaries).
        ///
        /// <p>List of lens summaries of available lenses.</p>
        pub fn lens_summaries(mut self, input: impl Into<crate::model::LensSummary>) -> Self {
            let mut v = self.lens_summaries.unwrap_or_default();
            v.push(input.into());
            self.lens_summaries = Some(v);
            self
        }
        /// <p>List of lens summaries of available lenses.</p>
        pub fn set_lens_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LensSummary>>,
        ) -> Self {
            self.lens_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLensesOutput`](crate::output::ListLensesOutput)
        pub fn build(self) -> crate::output::ListLensesOutput {
            crate::output::ListLensesOutput {
                lens_summaries: self.lens_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLensesOutput {
    /// Creates a new builder-style object to manufacture [`ListLensesOutput`](crate::output::ListLensesOutput)
    pub fn builder() -> crate::output::list_lenses_output::Builder {
        crate::output::list_lenses_output::Builder::default()
    }
}

/// <p>Output of a list answers call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnswersOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>List of answer summaries of lens review in a workload.</p>
    pub answer_summaries: std::option::Option<std::vec::Vec<crate::model::AnswerSummary>>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnswersOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>List of answer summaries of lens review in a workload.</p>
    pub fn answer_summaries(&self) -> std::option::Option<&[crate::model::AnswerSummary]> {
        self.answer_summaries.as_deref()
    }
    /// <p>The token to use to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnswersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnswersOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("answer_summaries", &self.answer_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAnswersOutput`](crate::output::ListAnswersOutput)
pub mod list_answers_output {
    /// A builder for [`ListAnswersOutput`](crate::output::ListAnswersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) answer_summaries:
            std::option::Option<std::vec::Vec<crate::model::AnswerSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// Appends an item to `answer_summaries`.
        ///
        /// To override the contents of this collection use [`set_answer_summaries`](Self::set_answer_summaries).
        ///
        /// <p>List of answer summaries of lens review in a workload.</p>
        pub fn answer_summaries(mut self, input: impl Into<crate::model::AnswerSummary>) -> Self {
            let mut v = self.answer_summaries.unwrap_or_default();
            v.push(input.into());
            self.answer_summaries = Some(v);
            self
        }
        /// <p>List of answer summaries of lens review in a workload.</p>
        pub fn set_answer_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnswerSummary>>,
        ) -> Self {
            self.answer_summaries = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnswersOutput`](crate::output::ListAnswersOutput)
        pub fn build(self) -> crate::output::ListAnswersOutput {
            crate::output::ListAnswersOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                lens_alias: self.lens_alias,
                answer_summaries: self.answer_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAnswersOutput {
    /// Creates a new builder-style object to manufacture [`ListAnswersOutput`](crate::output::ListAnswersOutput)
    pub fn builder() -> crate::output::list_answers_output::Builder {
        crate::output::list_answers_output::Builder::default()
    }
}

/// <p>Output of a get workload call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkloadOutput {
    /// <p>A workload return object.</p>
    pub workload: std::option::Option<crate::model::Workload>,
}
impl GetWorkloadOutput {
    /// <p>A workload return object.</p>
    pub fn workload(&self) -> std::option::Option<&crate::model::Workload> {
        self.workload.as_ref()
    }
}
impl std::fmt::Debug for GetWorkloadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkloadOutput");
        formatter.field("workload", &self.workload);
        formatter.finish()
    }
}
/// See [`GetWorkloadOutput`](crate::output::GetWorkloadOutput)
pub mod get_workload_output {
    /// A builder for [`GetWorkloadOutput`](crate::output::GetWorkloadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload: std::option::Option<crate::model::Workload>,
    }
    impl Builder {
        /// <p>A workload return object.</p>
        pub fn workload(mut self, input: crate::model::Workload) -> Self {
            self.workload = Some(input);
            self
        }
        /// <p>A workload return object.</p>
        pub fn set_workload(mut self, input: std::option::Option<crate::model::Workload>) -> Self {
            self.workload = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkloadOutput`](crate::output::GetWorkloadOutput)
        pub fn build(self) -> crate::output::GetWorkloadOutput {
            crate::output::GetWorkloadOutput {
                workload: self.workload,
            }
        }
    }
}
impl GetWorkloadOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkloadOutput`](crate::output::GetWorkloadOutput)
    pub fn builder() -> crate::output::get_workload_output::Builder {
        crate::output::get_workload_output::Builder::default()
    }
}

/// <p>Output of a get milestone call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMilestoneOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A milestone return object.</p>
    pub milestone: std::option::Option<crate::model::Milestone>,
}
impl GetMilestoneOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>A milestone return object.</p>
    pub fn milestone(&self) -> std::option::Option<&crate::model::Milestone> {
        self.milestone.as_ref()
    }
}
impl std::fmt::Debug for GetMilestoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMilestoneOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone", &self.milestone);
        formatter.finish()
    }
}
/// See [`GetMilestoneOutput`](crate::output::GetMilestoneOutput)
pub mod get_milestone_output {
    /// A builder for [`GetMilestoneOutput`](crate::output::GetMilestoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone: std::option::Option<crate::model::Milestone>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>A milestone return object.</p>
        pub fn milestone(mut self, input: crate::model::Milestone) -> Self {
            self.milestone = Some(input);
            self
        }
        /// <p>A milestone return object.</p>
        pub fn set_milestone(
            mut self,
            input: std::option::Option<crate::model::Milestone>,
        ) -> Self {
            self.milestone = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMilestoneOutput`](crate::output::GetMilestoneOutput)
        pub fn build(self) -> crate::output::GetMilestoneOutput {
            crate::output::GetMilestoneOutput {
                workload_id: self.workload_id,
                milestone: self.milestone,
            }
        }
    }
}
impl GetMilestoneOutput {
    /// Creates a new builder-style object to manufacture [`GetMilestoneOutput`](crate::output::GetMilestoneOutput)
    pub fn builder() -> crate::output::get_milestone_output::Builder {
        crate::output::get_milestone_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLensVersionDifferenceOutput {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The base version of the lens.</p>
    pub base_lens_version: std::option::Option<std::string::String>,
    /// <p>The latest version of the lens.</p>
    pub latest_lens_version: std::option::Option<std::string::String>,
    /// <p>The differences between the base and latest versions of the lens.</p>
    pub version_differences: std::option::Option<crate::model::VersionDifferences>,
}
impl GetLensVersionDifferenceOutput {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>The base version of the lens.</p>
    pub fn base_lens_version(&self) -> std::option::Option<&str> {
        self.base_lens_version.as_deref()
    }
    /// <p>The latest version of the lens.</p>
    pub fn latest_lens_version(&self) -> std::option::Option<&str> {
        self.latest_lens_version.as_deref()
    }
    /// <p>The differences between the base and latest versions of the lens.</p>
    pub fn version_differences(&self) -> std::option::Option<&crate::model::VersionDifferences> {
        self.version_differences.as_ref()
    }
}
impl std::fmt::Debug for GetLensVersionDifferenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLensVersionDifferenceOutput");
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("base_lens_version", &self.base_lens_version);
        formatter.field("latest_lens_version", &self.latest_lens_version);
        formatter.field("version_differences", &self.version_differences);
        formatter.finish()
    }
}
/// See [`GetLensVersionDifferenceOutput`](crate::output::GetLensVersionDifferenceOutput)
pub mod get_lens_version_difference_output {
    /// A builder for [`GetLensVersionDifferenceOutput`](crate::output::GetLensVersionDifferenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) base_lens_version: std::option::Option<std::string::String>,
        pub(crate) latest_lens_version: std::option::Option<std::string::String>,
        pub(crate) version_differences: std::option::Option<crate::model::VersionDifferences>,
    }
    impl Builder {
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn base_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_lens_version = Some(input.into());
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn set_base_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_lens_version = input;
            self
        }
        /// <p>The latest version of the lens.</p>
        pub fn latest_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_lens_version = Some(input.into());
            self
        }
        /// <p>The latest version of the lens.</p>
        pub fn set_latest_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_lens_version = input;
            self
        }
        /// <p>The differences between the base and latest versions of the lens.</p>
        pub fn version_differences(mut self, input: crate::model::VersionDifferences) -> Self {
            self.version_differences = Some(input);
            self
        }
        /// <p>The differences between the base and latest versions of the lens.</p>
        pub fn set_version_differences(
            mut self,
            input: std::option::Option<crate::model::VersionDifferences>,
        ) -> Self {
            self.version_differences = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLensVersionDifferenceOutput`](crate::output::GetLensVersionDifferenceOutput)
        pub fn build(self) -> crate::output::GetLensVersionDifferenceOutput {
            crate::output::GetLensVersionDifferenceOutput {
                lens_alias: self.lens_alias,
                base_lens_version: self.base_lens_version,
                latest_lens_version: self.latest_lens_version,
                version_differences: self.version_differences,
            }
        }
    }
}
impl GetLensVersionDifferenceOutput {
    /// Creates a new builder-style object to manufacture [`GetLensVersionDifferenceOutput`](crate::output::GetLensVersionDifferenceOutput)
    pub fn builder() -> crate::output::get_lens_version_difference_output::Builder {
        crate::output::get_lens_version_difference_output::Builder::default()
    }
}

/// <p>Output of a get lens review report call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLensReviewReportOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>A report of a lens review.</p>
    pub lens_review_report: std::option::Option<crate::model::LensReviewReport>,
}
impl GetLensReviewReportOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>A report of a lens review.</p>
    pub fn lens_review_report(&self) -> std::option::Option<&crate::model::LensReviewReport> {
        self.lens_review_report.as_ref()
    }
}
impl std::fmt::Debug for GetLensReviewReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLensReviewReportOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("lens_review_report", &self.lens_review_report);
        formatter.finish()
    }
}
/// See [`GetLensReviewReportOutput`](crate::output::GetLensReviewReportOutput)
pub mod get_lens_review_report_output {
    /// A builder for [`GetLensReviewReportOutput`](crate::output::GetLensReviewReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) lens_review_report: std::option::Option<crate::model::LensReviewReport>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>A report of a lens review.</p>
        pub fn lens_review_report(mut self, input: crate::model::LensReviewReport) -> Self {
            self.lens_review_report = Some(input);
            self
        }
        /// <p>A report of a lens review.</p>
        pub fn set_lens_review_report(
            mut self,
            input: std::option::Option<crate::model::LensReviewReport>,
        ) -> Self {
            self.lens_review_report = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLensReviewReportOutput`](crate::output::GetLensReviewReportOutput)
        pub fn build(self) -> crate::output::GetLensReviewReportOutput {
            crate::output::GetLensReviewReportOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                lens_review_report: self.lens_review_report,
            }
        }
    }
}
impl GetLensReviewReportOutput {
    /// Creates a new builder-style object to manufacture [`GetLensReviewReportOutput`](crate::output::GetLensReviewReportOutput)
    pub fn builder() -> crate::output::get_lens_review_report_output::Builder {
        crate::output::get_lens_review_report_output::Builder::default()
    }
}

/// <p>Output of a get lens review call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLensReviewOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>A lens review of a question.</p>
    pub lens_review: std::option::Option<crate::model::LensReview>,
}
impl GetLensReviewOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>A lens review of a question.</p>
    pub fn lens_review(&self) -> std::option::Option<&crate::model::LensReview> {
        self.lens_review.as_ref()
    }
}
impl std::fmt::Debug for GetLensReviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLensReviewOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("lens_review", &self.lens_review);
        formatter.finish()
    }
}
/// See [`GetLensReviewOutput`](crate::output::GetLensReviewOutput)
pub mod get_lens_review_output {
    /// A builder for [`GetLensReviewOutput`](crate::output::GetLensReviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) lens_review: std::option::Option<crate::model::LensReview>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>A lens review of a question.</p>
        pub fn lens_review(mut self, input: crate::model::LensReview) -> Self {
            self.lens_review = Some(input);
            self
        }
        /// <p>A lens review of a question.</p>
        pub fn set_lens_review(
            mut self,
            input: std::option::Option<crate::model::LensReview>,
        ) -> Self {
            self.lens_review = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLensReviewOutput`](crate::output::GetLensReviewOutput)
        pub fn build(self) -> crate::output::GetLensReviewOutput {
            crate::output::GetLensReviewOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                lens_review: self.lens_review,
            }
        }
    }
}
impl GetLensReviewOutput {
    /// Creates a new builder-style object to manufacture [`GetLensReviewOutput`](crate::output::GetLensReviewOutput)
    pub fn builder() -> crate::output::get_lens_review_output::Builder {
        crate::output::get_lens_review_output::Builder::default()
    }
}

/// <p>Output of a get answer call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnswerOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>An answer of the question.</p>
    pub answer: std::option::Option<crate::model::Answer>,
}
impl GetAnswerOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub fn lens_alias(&self) -> std::option::Option<&str> {
        self.lens_alias.as_deref()
    }
    /// <p>An answer of the question.</p>
    pub fn answer(&self) -> std::option::Option<&crate::model::Answer> {
        self.answer.as_ref()
    }
}
impl std::fmt::Debug for GetAnswerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnswerOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("answer", &self.answer);
        formatter.finish()
    }
}
/// See [`GetAnswerOutput`](crate::output::GetAnswerOutput)
pub mod get_answer_output {
    /// A builder for [`GetAnswerOutput`](crate::output::GetAnswerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) answer: std::option::Option<crate::model::Answer>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>An answer of the question.</p>
        pub fn answer(mut self, input: crate::model::Answer) -> Self {
            self.answer = Some(input);
            self
        }
        /// <p>An answer of the question.</p>
        pub fn set_answer(mut self, input: std::option::Option<crate::model::Answer>) -> Self {
            self.answer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnswerOutput`](crate::output::GetAnswerOutput)
        pub fn build(self) -> crate::output::GetAnswerOutput {
            crate::output::GetAnswerOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                lens_alias: self.lens_alias,
                answer: self.answer,
            }
        }
    }
}
impl GetAnswerOutput {
    /// Creates a new builder-style object to manufacture [`GetAnswerOutput`](crate::output::GetAnswerOutput)
    pub fn builder() -> crate::output::get_answer_output::Builder {
        crate::output::get_answer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLensesOutput {}
impl std::fmt::Debug for DisassociateLensesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLensesOutput");
        formatter.finish()
    }
}
/// See [`DisassociateLensesOutput`](crate::output::DisassociateLensesOutput)
pub mod disassociate_lenses_output {
    /// A builder for [`DisassociateLensesOutput`](crate::output::DisassociateLensesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateLensesOutput`](crate::output::DisassociateLensesOutput)
        pub fn build(self) -> crate::output::DisassociateLensesOutput {
            crate::output::DisassociateLensesOutput {}
        }
    }
}
impl DisassociateLensesOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateLensesOutput`](crate::output::DisassociateLensesOutput)
    pub fn builder() -> crate::output::disassociate_lenses_output::Builder {
        crate::output::disassociate_lenses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkloadShareOutput {}
impl std::fmt::Debug for DeleteWorkloadShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkloadShareOutput");
        formatter.finish()
    }
}
/// See [`DeleteWorkloadShareOutput`](crate::output::DeleteWorkloadShareOutput)
pub mod delete_workload_share_output {
    /// A builder for [`DeleteWorkloadShareOutput`](crate::output::DeleteWorkloadShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWorkloadShareOutput`](crate::output::DeleteWorkloadShareOutput)
        pub fn build(self) -> crate::output::DeleteWorkloadShareOutput {
            crate::output::DeleteWorkloadShareOutput {}
        }
    }
}
impl DeleteWorkloadShareOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkloadShareOutput`](crate::output::DeleteWorkloadShareOutput)
    pub fn builder() -> crate::output::delete_workload_share_output::Builder {
        crate::output::delete_workload_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkloadOutput {}
impl std::fmt::Debug for DeleteWorkloadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkloadOutput");
        formatter.finish()
    }
}
/// See [`DeleteWorkloadOutput`](crate::output::DeleteWorkloadOutput)
pub mod delete_workload_output {
    /// A builder for [`DeleteWorkloadOutput`](crate::output::DeleteWorkloadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWorkloadOutput`](crate::output::DeleteWorkloadOutput)
        pub fn build(self) -> crate::output::DeleteWorkloadOutput {
            crate::output::DeleteWorkloadOutput {}
        }
    }
}
impl DeleteWorkloadOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkloadOutput`](crate::output::DeleteWorkloadOutput)
    pub fn builder() -> crate::output::delete_workload_output::Builder {
        crate::output::delete_workload_output::Builder::default()
    }
}

/// <p>Input for Create Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkloadShareOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The ID associated with the workload share.</p>
    pub share_id: std::option::Option<std::string::String>,
}
impl CreateWorkloadShareOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The ID associated with the workload share.</p>
    pub fn share_id(&self) -> std::option::Option<&str> {
        self.share_id.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkloadShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkloadShareOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("share_id", &self.share_id);
        formatter.finish()
    }
}
/// See [`CreateWorkloadShareOutput`](crate::output::CreateWorkloadShareOutput)
pub mod create_workload_share_output {
    /// A builder for [`CreateWorkloadShareOutput`](crate::output::CreateWorkloadShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) share_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkloadShareOutput`](crate::output::CreateWorkloadShareOutput)
        pub fn build(self) -> crate::output::CreateWorkloadShareOutput {
            crate::output::CreateWorkloadShareOutput {
                workload_id: self.workload_id,
                share_id: self.share_id,
            }
        }
    }
}
impl CreateWorkloadShareOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkloadShareOutput`](crate::output::CreateWorkloadShareOutput)
    pub fn builder() -> crate::output::create_workload_share_output::Builder {
        crate::output::create_workload_share_output::Builder::default()
    }
}

/// <p>Output of a create workload call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkloadOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The ARN for the workload.</p>
    pub workload_arn: std::option::Option<std::string::String>,
}
impl CreateWorkloadOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The ARN for the workload.</p>
    pub fn workload_arn(&self) -> std::option::Option<&str> {
        self.workload_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkloadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkloadOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_arn", &self.workload_arn);
        formatter.finish()
    }
}
/// See [`CreateWorkloadOutput`](crate::output::CreateWorkloadOutput)
pub mod create_workload_output {
    /// A builder for [`CreateWorkloadOutput`](crate::output::CreateWorkloadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkloadOutput`](crate::output::CreateWorkloadOutput)
        pub fn build(self) -> crate::output::CreateWorkloadOutput {
            crate::output::CreateWorkloadOutput {
                workload_id: self.workload_id,
                workload_arn: self.workload_arn,
            }
        }
    }
}
impl CreateWorkloadOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkloadOutput`](crate::output::CreateWorkloadOutput)
    pub fn builder() -> crate::output::create_workload_output::Builder {
        crate::output::create_workload_output::Builder::default()
    }
}

/// <p>Output of a create milestone call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMilestoneOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
}
impl CreateMilestoneOutput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub fn workload_id(&self) -> std::option::Option<&str> {
        self.workload_id.as_deref()
    }
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub fn milestone_number(&self) -> i32 {
        self.milestone_number
    }
}
impl std::fmt::Debug for CreateMilestoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMilestoneOutput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.finish()
    }
}
/// See [`CreateMilestoneOutput`](crate::output::CreateMilestoneOutput)
pub mod create_milestone_output {
    /// A builder for [`CreateMilestoneOutput`](crate::output::CreateMilestoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMilestoneOutput`](crate::output::CreateMilestoneOutput)
        pub fn build(self) -> crate::output::CreateMilestoneOutput {
            crate::output::CreateMilestoneOutput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
            }
        }
    }
}
impl CreateMilestoneOutput {
    /// Creates a new builder-style object to manufacture [`CreateMilestoneOutput`](crate::output::CreateMilestoneOutput)
    pub fn builder() -> crate::output::create_milestone_output::Builder {
        crate::output::create_milestone_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLensesOutput {}
impl std::fmt::Debug for AssociateLensesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLensesOutput");
        formatter.finish()
    }
}
/// See [`AssociateLensesOutput`](crate::output::AssociateLensesOutput)
pub mod associate_lenses_output {
    /// A builder for [`AssociateLensesOutput`](crate::output::AssociateLensesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateLensesOutput`](crate::output::AssociateLensesOutput)
        pub fn build(self) -> crate::output::AssociateLensesOutput {
            crate::output::AssociateLensesOutput {}
        }
    }
}
impl AssociateLensesOutput {
    /// Creates a new builder-style object to manufacture [`AssociateLensesOutput`](crate::output::AssociateLensesOutput)
    pub fn builder() -> crate::output::associate_lenses_output::Builder {
        crate::output::associate_lenses_output::Builder::default()
    }
}
