// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `WellArchitectedApiServiceLambda`.
///
/// This client allows ergonomic access to a `WellArchitectedApiServiceLambda`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateLenses` operation.
    ///
    /// See [`AssociateLenses`](crate::client::fluent_builders::AssociateLenses) for more information about the
    /// operation and its arguments.
    pub fn associate_lenses(&self) -> fluent_builders::AssociateLenses<C, M, R> {
        fluent_builders::AssociateLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMilestone` operation.
    ///
    /// See [`CreateMilestone`](crate::client::fluent_builders::CreateMilestone) for more information about the
    /// operation and its arguments.
    pub fn create_milestone(&self) -> fluent_builders::CreateMilestone<C, M, R> {
        fluent_builders::CreateMilestone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkload` operation.
    ///
    /// See [`CreateWorkload`](crate::client::fluent_builders::CreateWorkload) for more information about the
    /// operation and its arguments.
    pub fn create_workload(&self) -> fluent_builders::CreateWorkload<C, M, R> {
        fluent_builders::CreateWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkloadShare` operation.
    ///
    /// See [`CreateWorkloadShare`](crate::client::fluent_builders::CreateWorkloadShare) for more information about the
    /// operation and its arguments.
    pub fn create_workload_share(&self) -> fluent_builders::CreateWorkloadShare<C, M, R> {
        fluent_builders::CreateWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkload` operation.
    ///
    /// See [`DeleteWorkload`](crate::client::fluent_builders::DeleteWorkload) for more information about the
    /// operation and its arguments.
    pub fn delete_workload(&self) -> fluent_builders::DeleteWorkload<C, M, R> {
        fluent_builders::DeleteWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkloadShare` operation.
    ///
    /// See [`DeleteWorkloadShare`](crate::client::fluent_builders::DeleteWorkloadShare) for more information about the
    /// operation and its arguments.
    pub fn delete_workload_share(&self) -> fluent_builders::DeleteWorkloadShare<C, M, R> {
        fluent_builders::DeleteWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateLenses` operation.
    ///
    /// See [`DisassociateLenses`](crate::client::fluent_builders::DisassociateLenses) for more information about the
    /// operation and its arguments.
    pub fn disassociate_lenses(&self) -> fluent_builders::DisassociateLenses<C, M, R> {
        fluent_builders::DisassociateLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAnswer` operation.
    ///
    /// See [`GetAnswer`](crate::client::fluent_builders::GetAnswer) for more information about the
    /// operation and its arguments.
    pub fn get_answer(&self) -> fluent_builders::GetAnswer<C, M, R> {
        fluent_builders::GetAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLensReview` operation.
    ///
    /// See [`GetLensReview`](crate::client::fluent_builders::GetLensReview) for more information about the
    /// operation and its arguments.
    pub fn get_lens_review(&self) -> fluent_builders::GetLensReview<C, M, R> {
        fluent_builders::GetLensReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLensReviewReport` operation.
    ///
    /// See [`GetLensReviewReport`](crate::client::fluent_builders::GetLensReviewReport) for more information about the
    /// operation and its arguments.
    pub fn get_lens_review_report(&self) -> fluent_builders::GetLensReviewReport<C, M, R> {
        fluent_builders::GetLensReviewReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLensVersionDifference` operation.
    ///
    /// See [`GetLensVersionDifference`](crate::client::fluent_builders::GetLensVersionDifference) for more information about the
    /// operation and its arguments.
    pub fn get_lens_version_difference(
        &self,
    ) -> fluent_builders::GetLensVersionDifference<C, M, R> {
        fluent_builders::GetLensVersionDifference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMilestone` operation.
    ///
    /// See [`GetMilestone`](crate::client::fluent_builders::GetMilestone) for more information about the
    /// operation and its arguments.
    pub fn get_milestone(&self) -> fluent_builders::GetMilestone<C, M, R> {
        fluent_builders::GetMilestone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkload` operation.
    ///
    /// See [`GetWorkload`](crate::client::fluent_builders::GetWorkload) for more information about the
    /// operation and its arguments.
    pub fn get_workload(&self) -> fluent_builders::GetWorkload<C, M, R> {
        fluent_builders::GetWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnswers` operation.
    ///
    /// See [`ListAnswers`](crate::client::fluent_builders::ListAnswers) for more information about the
    /// operation and its arguments.
    pub fn list_answers(&self) -> fluent_builders::ListAnswers<C, M, R> {
        fluent_builders::ListAnswers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLenses` operation.
    ///
    /// See [`ListLenses`](crate::client::fluent_builders::ListLenses) for more information about the
    /// operation and its arguments.
    pub fn list_lenses(&self) -> fluent_builders::ListLenses<C, M, R> {
        fluent_builders::ListLenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLensReviewImprovements` operation.
    ///
    /// See [`ListLensReviewImprovements`](crate::client::fluent_builders::ListLensReviewImprovements) for more information about the
    /// operation and its arguments.
    pub fn list_lens_review_improvements(
        &self,
    ) -> fluent_builders::ListLensReviewImprovements<C, M, R> {
        fluent_builders::ListLensReviewImprovements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLensReviews` operation.
    ///
    /// See [`ListLensReviews`](crate::client::fluent_builders::ListLensReviews) for more information about the
    /// operation and its arguments.
    pub fn list_lens_reviews(&self) -> fluent_builders::ListLensReviews<C, M, R> {
        fluent_builders::ListLensReviews::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMilestones` operation.
    ///
    /// See [`ListMilestones`](crate::client::fluent_builders::ListMilestones) for more information about the
    /// operation and its arguments.
    pub fn list_milestones(&self) -> fluent_builders::ListMilestones<C, M, R> {
        fluent_builders::ListMilestones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotifications` operation.
    ///
    /// See [`ListNotifications`](crate::client::fluent_builders::ListNotifications) for more information about the
    /// operation and its arguments.
    pub fn list_notifications(&self) -> fluent_builders::ListNotifications<C, M, R> {
        fluent_builders::ListNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListShareInvitations` operation.
    ///
    /// See [`ListShareInvitations`](crate::client::fluent_builders::ListShareInvitations) for more information about the
    /// operation and its arguments.
    pub fn list_share_invitations(&self) -> fluent_builders::ListShareInvitations<C, M, R> {
        fluent_builders::ListShareInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkloads` operation.
    ///
    /// See [`ListWorkloads`](crate::client::fluent_builders::ListWorkloads) for more information about the
    /// operation and its arguments.
    pub fn list_workloads(&self) -> fluent_builders::ListWorkloads<C, M, R> {
        fluent_builders::ListWorkloads::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkloadShares` operation.
    ///
    /// See [`ListWorkloadShares`](crate::client::fluent_builders::ListWorkloadShares) for more information about the
    /// operation and its arguments.
    pub fn list_workload_shares(&self) -> fluent_builders::ListWorkloadShares<C, M, R> {
        fluent_builders::ListWorkloadShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAnswer` operation.
    ///
    /// See [`UpdateAnswer`](crate::client::fluent_builders::UpdateAnswer) for more information about the
    /// operation and its arguments.
    pub fn update_answer(&self) -> fluent_builders::UpdateAnswer<C, M, R> {
        fluent_builders::UpdateAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLensReview` operation.
    ///
    /// See [`UpdateLensReview`](crate::client::fluent_builders::UpdateLensReview) for more information about the
    /// operation and its arguments.
    pub fn update_lens_review(&self) -> fluent_builders::UpdateLensReview<C, M, R> {
        fluent_builders::UpdateLensReview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateShareInvitation` operation.
    ///
    /// See [`UpdateShareInvitation`](crate::client::fluent_builders::UpdateShareInvitation) for more information about the
    /// operation and its arguments.
    pub fn update_share_invitation(&self) -> fluent_builders::UpdateShareInvitation<C, M, R> {
        fluent_builders::UpdateShareInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkload` operation.
    ///
    /// See [`UpdateWorkload`](crate::client::fluent_builders::UpdateWorkload) for more information about the
    /// operation and its arguments.
    pub fn update_workload(&self) -> fluent_builders::UpdateWorkload<C, M, R> {
        fluent_builders::UpdateWorkload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkloadShare` operation.
    ///
    /// See [`UpdateWorkloadShare`](crate::client::fluent_builders::UpdateWorkloadShare) for more information about the
    /// operation and its arguments.
    pub fn update_workload_share(&self) -> fluent_builders::UpdateWorkloadShare<C, M, R> {
        fluent_builders::UpdateWorkloadShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpgradeLensReview` operation.
    ///
    /// See [`UpgradeLensReview`](crate::client::fluent_builders::UpgradeLensReview) for more information about the
    /// operation and its arguments.
    pub fn upgrade_lens_review(&self) -> fluent_builders::UpgradeLensReview<C, M, R> {
        fluent_builders::UpgradeLensReview::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateLenses`.
    ///
    /// <p>Associate a lens to a workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lenses_input::Builder,
    }
    impl<C, M, R> AssociateLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLensesInputOperationOutputAlias,
                crate::output::AssociateLensesOutput,
                crate::error::AssociateLensesError,
                crate::input::AssociateLensesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// Appends an item to `LensAliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_aliases(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_aliases(inp);
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lens_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMilestone`.
    ///
    /// <p>Create a milestone for an existing workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMilestone<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_milestone_input::Builder,
    }
    impl<C, M, R> CreateMilestone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMilestone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMilestoneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMilestoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMilestoneInputOperationOutputAlias,
                crate::output::CreateMilestoneOutput,
                crate::error::CreateMilestoneError,
                crate::input::CreateMilestoneInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.milestone_name(inp);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_milestone_name(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkload`.
    ///
    /// <p>Create a new workload.</p>
    /// <p>The owner of a workload can share the workload with other AWS accounts and IAM users
    /// in the same AWS Region. Only the owner of a workload can delete it.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a> in the
    /// <i>AWS Well-Architected Tool User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workload_input::Builder,
    }
    impl<C, M, R> CreateWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkloadInputOperationOutputAlias,
                crate::output::CreateWorkloadOutput,
                crate::error::CreateWorkloadError,
                crate::input::CreateWorkloadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name(inp);
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name(input);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, inp: crate::model::WorkloadEnvironment) -> Self {
            self.inner = self.inner.environment(inp);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `AwsRegions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_regions(inp);
            self
        }
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_regions(input);
            self
        }
        /// Appends an item to `NonAwsRegions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.non_aws_regions(inp);
            self
        }
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_non_aws_regions(input);
            self
        }
        /// Appends an item to `PillarPriorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_priorities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_priorities(inp);
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pillar_priorities(input);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.architectural_design(inp);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_architectural_design(input);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.review_owner(inp);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_review_owner(input);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn industry_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry_type(inp);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_industry_type(input);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry(inp);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_industry(input);
            self
        }
        /// Appends an item to `Lenses`.
        ///
        /// To override the contents of this collection use [`set_lenses`](Self::set_lenses).
        ///
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lenses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lenses(inp);
            self
        }
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lenses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lenses(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(inp);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the workload.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be associated with the workload.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkloadShare`.
    ///
    /// <p>Create a workload share.</p>
    /// <p>The owner of a workload can share it with other AWS accounts and IAM users in the same
    /// AWS Region. Shared access to a workload is not removed until the workload invitation is
    /// deleted.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a Workload</a> in the
    /// <i>AWS Well-Architected Tool User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workload_share_input::Builder,
    }
    impl<C, M, R> CreateWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkloadShareInputOperationOutputAlias,
                crate::output::CreateWorkloadShareOutput,
                crate::error::CreateWorkloadShareError,
                crate::input::CreateWorkloadShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with(inp);
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shared_with(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, inp: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(inp);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkload`.
    ///
    /// <p>Delete an existing workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workload_input::Builder,
    }
    impl<C, M, R> DeleteWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkloadInputOperationOutputAlias,
                crate::output::DeleteWorkloadOutput,
                crate::error::DeleteWorkloadError,
                crate::input::DeleteWorkloadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkloadShare`.
    ///
    /// <p>Delete a workload share.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workload_share_input::Builder,
    }
    impl<C, M, R> DeleteWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkloadShareInputOperationOutputAlias,
                crate::output::DeleteWorkloadShareOutput,
                crate::error::DeleteWorkloadShareError,
                crate::input::DeleteWorkloadShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(inp);
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLenses`.
    ///
    /// <p>Disassociate a lens from a workload.</p>
    /// <note>
    /// <p>The AWS Well-Architected Framework lens (<code>wellarchitected</code>) cannot be
    /// removed from a workload.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lenses_input::Builder,
    }
    impl<C, M, R> DisassociateLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLensesInputOperationOutputAlias,
                crate::output::DisassociateLensesOutput,
                crate::error::DisassociateLensesError,
                crate::input::DisassociateLensesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// Appends an item to `LensAliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_aliases(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_aliases(inp);
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_lens_aliases(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnswer`.
    ///
    /// <p>Get the answer to a specific question in a workload review.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_answer_input::Builder,
    }
    impl<C, M, R> GetAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnswerInputOperationOutputAlias,
                crate::output::GetAnswerOutput,
                crate::error::GetAnswerError,
                crate::input::GetAnswerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_id(inp);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensReview`.
    ///
    /// <p>Get lens review.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_review_input::Builder,
    }
    impl<C, M, R> GetLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensReviewInputOperationOutputAlias,
                crate::output::GetLensReviewOutput,
                crate::error::GetLensReviewError,
                crate::input::GetLensReviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensReviewReport`.
    ///
    /// <p>Get lens review report.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLensReviewReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_review_report_input::Builder,
    }
    impl<C, M, R> GetLensReviewReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensReviewReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensReviewReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensReviewReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensReviewReportInputOperationOutputAlias,
                crate::output::GetLensReviewReportOutput,
                crate::error::GetLensReviewReportError,
                crate::input::GetLensReviewReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLensVersionDifference`.
    ///
    /// <p>Get lens version differences.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLensVersionDifference<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lens_version_difference_input::Builder,
    }
    impl<C, M, R> GetLensVersionDifference<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLensVersionDifference`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLensVersionDifferenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLensVersionDifferenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLensVersionDifferenceInputOperationOutputAlias,
                crate::output::GetLensVersionDifferenceOutput,
                crate::error::GetLensVersionDifferenceError,
                crate::input::GetLensVersionDifferenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn base_lens_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_lens_version(inp);
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn set_base_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_base_lens_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMilestone`.
    ///
    /// <p>Get a milestone for an existing workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMilestone<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_milestone_input::Builder,
    }
    impl<C, M, R> GetMilestone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMilestone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMilestoneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMilestoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMilestoneInputOperationOutputAlias,
                crate::output::GetMilestoneOutput,
                crate::error::GetMilestoneError,
                crate::input::GetMilestoneInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkload`.
    ///
    /// <p>Get an existing workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workload_input::Builder,
    }
    impl<C, M, R> GetWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkloadInputOperationOutputAlias,
                crate::output::GetWorkloadOutput,
                crate::error::GetWorkloadError,
                crate::input::GetWorkloadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnswers`.
    ///
    /// <p>List of answers.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnswers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_answers_input::Builder,
    }
    impl<C, M, R> ListAnswers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnswers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnswersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnswersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnswersInputOperationOutputAlias,
                crate::output::ListAnswersOutput,
                crate::error::ListAnswersError,
                crate::input::ListAnswersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_id(inp);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pillar_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLenses`.
    ///
    /// <p>List the available lenses.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLenses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lenses_input::Builder,
    }
    impl<C, M, R> ListLenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensesInputOperationOutputAlias,
                crate::output::ListLensesOutput,
                crate::error::ListLensesError,
                crate::input::ListLensesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensReviewImprovements`.
    ///
    /// <p>List lens review improvements.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLensReviewImprovements<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_review_improvements_input::Builder,
    }
    impl<C, M, R> ListLensReviewImprovements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensReviewImprovements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensReviewImprovementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensReviewImprovementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensReviewImprovementsInputOperationOutputAlias,
                crate::output::ListLensReviewImprovementsOutput,
                crate::error::ListLensReviewImprovementsError,
                crate::input::ListLensReviewImprovementsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_id(inp);
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pillar_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLensReviews`.
    ///
    /// <p>List lens reviews.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLensReviews<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lens_reviews_input::Builder,
    }
    impl<C, M, R> ListLensReviews<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLensReviews`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLensReviewsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLensReviewsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLensReviewsInputOperationOutputAlias,
                crate::output::ListLensReviewsOutput,
                crate::error::ListLensReviewsError,
                crate::input::ListLensReviewsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, inp: i32) -> Self {
            self.inner = self.inner.milestone_number(inp);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_milestone_number(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMilestones`.
    ///
    /// <p>List all milestones for an existing workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMilestones<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_milestones_input::Builder,
    }
    impl<C, M, R> ListMilestones<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMilestones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMilestonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMilestonesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMilestonesInputOperationOutputAlias,
                crate::output::ListMilestonesOutput,
                crate::error::ListMilestonesError,
                crate::input::ListMilestonesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotifications`.
    ///
    /// <p>List lens notifications.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_notifications_input::Builder,
    }
    impl<C, M, R> ListNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNotificationsInputOperationOutputAlias,
                crate::output::ListNotificationsOutput,
                crate::error::ListNotificationsError,
                crate::input::ListNotificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListShareInvitations`.
    ///
    /// <p>List  the workload invitations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListShareInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_share_invitations_input::Builder,
    }
    impl<C, M, R> ListShareInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListShareInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListShareInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListShareInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListShareInvitationsInputOperationOutputAlias,
                crate::output::ListShareInvitationsOutput,
                crate::error::ListShareInvitationsError,
                crate::input::ListShareInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn workload_name_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name_prefix(inp);
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(inp);
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkloads`.
    ///
    /// <p>List workloads. Paginated.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkloads<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workloads_input::Builder,
    }
    impl<C, M, R> ListWorkloads<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkloads`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkloadsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkloadsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkloadsInputOperationOutputAlias,
                crate::output::ListWorkloadsOutput,
                crate::error::ListWorkloadsError,
                crate::input::ListWorkloadsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn workload_name_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name_prefix(inp);
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkloadShares`.
    ///
    /// <p>List the workload shares associated with the workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkloadShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workload_shares_input::Builder,
    }
    impl<C, M, R> ListWorkloadShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkloadShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkloadSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkloadSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkloadSharesInputOperationOutputAlias,
                crate::output::ListWorkloadSharesOutput,
                crate::error::ListWorkloadSharesError,
                crate::input::ListWorkloadSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_with_prefix(inp);
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_with_prefix(input);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(inp);
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    /// <p>To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:</p>
    /// <p>
    /// <code>DELETE /tags/WorkloadArn?tagKeys=key1&tagKeys=key2</code>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_arn(inp);
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource
        /// whose keys are members of this list are removed from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource
        /// whose keys are members of this list are removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnswer`.
    ///
    /// <p>Update the answer to a specific question in a workload review.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_answer_input::Builder,
    }
    impl<C, M, R> UpdateAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnswerInputOperationOutputAlias,
                crate::output::UpdateAnswerOutput,
                crate::error::UpdateAnswerError,
                crate::input::UpdateAnswerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.question_id(inp);
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_question_id(input);
            self
        }
        /// Appends an item to `SelectedChoices`.
        ///
        /// To override the contents of this collection use [`set_selected_choices`](Self::set_selected_choices).
        ///
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn selected_choices(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.selected_choices(inp);
            self
        }
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn set_selected_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_selected_choices(input);
            self
        }
        /// Adds a key-value pair to `ChoiceUpdates`.
        ///
        /// To override the contents of this collection use [`set_choice_updates`](Self::set_choice_updates).
        ///
        /// <p>A list of choices to update on a question in your workload.  The String key
        /// corresponds to the choice ID to be updated.</p>
        pub fn choice_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ChoiceUpdate>,
        ) -> Self {
            self.inner = self.inner.choice_updates(k, v);
            self
        }
        /// <p>A list of choices to update on a question in your workload.  The String key
        /// corresponds to the choice ID to be updated.</p>
        pub fn set_choice_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ChoiceUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_choice_updates(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(inp);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn is_applicable(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_applicable(inp);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn set_is_applicable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_applicable(input);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn reason(mut self, inp: crate::model::AnswerReason) -> Self {
            self.inner = self.inner.reason(inp);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AnswerReason>,
        ) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLensReview`.
    ///
    /// <p>Update lens review.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_lens_review_input::Builder,
    }
    impl<C, M, R> UpdateLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLensReviewInputOperationOutputAlias,
                crate::output::UpdateLensReviewOutput,
                crate::error::UpdateLensReviewError,
                crate::input::UpdateLensReviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn lens_notes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_notes(inp);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_lens_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_notes(input);
            self
        }
        /// Adds a key-value pair to `PillarNotes`.
        ///
        /// To override the contents of this collection use [`set_pillar_notes`](Self::set_pillar_notes).
        ///
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn pillar_notes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pillar_notes(k, v);
            self
        }
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn set_pillar_notes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_pillar_notes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateShareInvitation`.
    ///
    /// <p>Update a workload invitation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateShareInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_share_invitation_input::Builder,
    }
    impl<C, M, R> UpdateShareInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateShareInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateShareInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateShareInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateShareInvitationInputOperationOutputAlias,
                crate::output::UpdateShareInvitationOutput,
                crate::error::UpdateShareInvitationError,
                crate::input::UpdateShareInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_invitation_id(inp);
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_share_invitation_id(input);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn share_invitation_action(mut self, inp: crate::model::ShareInvitationAction) -> Self {
            self.inner = self.inner.share_invitation_action(inp);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn set_share_invitation_action(
            mut self,
            input: std::option::Option<crate::model::ShareInvitationAction>,
        ) -> Self {
            self.inner = self.inner.set_share_invitation_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkload`.
    ///
    /// <p>Update an existing workload.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWorkload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workload_input::Builder,
    }
    impl<C, M, R> UpdateWorkload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkloadOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkloadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkloadInputOperationOutputAlias,
                crate::output::UpdateWorkloadOutput,
                crate::error::UpdateWorkloadError,
                crate::input::UpdateWorkloadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_name(inp);
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workload_name(input);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, inp: crate::model::WorkloadEnvironment) -> Self {
            self.inner = self.inner.environment(inp);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// Appends an item to `AwsRegions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_regions(inp);
            self
        }
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_aws_regions(input);
            self
        }
        /// Appends an item to `NonAwsRegions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.non_aws_regions(inp);
            self
        }
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_non_aws_regions(input);
            self
        }
        /// Appends an item to `PillarPriorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_priorities(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pillar_priorities(inp);
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_pillar_priorities(input);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.architectural_design(inp);
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_architectural_design(input);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.review_owner(inp);
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_review_owner(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
        /// owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within
        /// 60 days of acknowledgement, access to the workload is restricted until an owner is
        /// added.</p>
        pub fn is_review_owner_update_acknowledged(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_review_owner_update_acknowledged(inp);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
        /// owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within
        /// 60 days of acknowledgement, access to the workload is restricted until an owner is
        /// added.</p>
        pub fn set_is_review_owner_update_acknowledged(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_is_review_owner_update_acknowledged(input);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn industry_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry_type(inp);
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_industry_type(input);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.industry(inp);
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_industry(input);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notes(inp);
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_notes(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn improvement_status(mut self, inp: crate::model::WorkloadImprovementStatus) -> Self {
            self.inner = self.inner.improvement_status(inp);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn set_improvement_status(
            mut self,
            input: std::option::Option<crate::model::WorkloadImprovementStatus>,
        ) -> Self {
            self.inner = self.inner.set_improvement_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkloadShare`.
    ///
    /// <p>Update a workload share.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWorkloadShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workload_share_input::Builder,
    }
    impl<C, M, R> UpdateWorkloadShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkloadShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkloadShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkloadShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkloadShareInputOperationOutputAlias,
                crate::output::UpdateWorkloadShareOutput,
                crate::error::UpdateWorkloadShareError,
                crate::input::UpdateWorkloadShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.share_id(inp);
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_share_id(input);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, inp: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(inp);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpgradeLensReview`.
    ///
    /// <p>Upgrade lens review.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpgradeLensReview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upgrade_lens_review_input::Builder,
    }
    impl<C, M, R> UpgradeLensReview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpgradeLensReview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpgradeLensReviewOutput,
            aws_smithy_http::result::SdkError<crate::error::UpgradeLensReviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpgradeLensReviewInputOperationOutputAlias,
                crate::output::UpgradeLensReviewOutput,
                crate::error::UpgradeLensReviewError,
                crate::input::UpgradeLensReviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workload_id(inp);
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workload_id(input);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lens_alias(inp);
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lens_alias(input);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.milestone_name(inp);
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_milestone_name(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
