// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateLensesInput`](crate::input::AssociateLensesInput)
pub mod associate_lenses_input {
    /// A builder for [`AssociateLensesInput`](crate::input::AssociateLensesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// Appends an item to `lens_aliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lens_aliases.unwrap_or_default();
            v.push(input.into());
            self.lens_aliases = Some(v);
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lens_aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLensesInput`](crate::input::AssociateLensesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateLensesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateLensesInput {
                workload_id: self.workload_id,
                lens_aliases: self.lens_aliases,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateLensesInputOperationOutputAlias = crate::operation::AssociateLenses;
#[doc(hidden)]
pub type AssociateLensesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateLensesInput {
    /// Consumes the builder and constructs an Operation<[`AssociateLenses`](crate::operation::AssociateLenses)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateLenses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateLensesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.workload_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_1, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/associateLenses",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateLensesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateLensesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_lenses(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateLenses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateLenses",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateLensesInput`](crate::input::AssociateLensesInput)
    pub fn builder() -> crate::input::associate_lenses_input::Builder {
        crate::input::associate_lenses_input::Builder::default()
    }
}

/// See [`CreateMilestoneInput`](crate::input::CreateMilestoneInput)
pub mod create_milestone_input {
    /// A builder for [`CreateMilestoneInput`](crate::input::CreateMilestoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.milestone_name = Some(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.milestone_name = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMilestoneInput`](crate::input::CreateMilestoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMilestoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMilestoneInput {
                workload_id: self.workload_id,
                milestone_name: self.milestone_name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMilestoneInputOperationOutputAlias = crate::operation::CreateMilestone;
#[doc(hidden)]
pub type CreateMilestoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMilestoneInput {
    /// Consumes the builder and constructs an Operation<[`CreateMilestone`](crate::operation::CreateMilestone)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMilestone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMilestoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.workload_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_2, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/milestones",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMilestoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMilestoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_milestone(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMilestone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMilestone",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMilestoneInput`](crate::input::CreateMilestoneInput)
    pub fn builder() -> crate::input::create_milestone_input::Builder {
        crate::input::create_milestone_input::Builder::default()
    }
}

/// See [`CreateWorkloadInput`](crate::input::CreateWorkloadInput)
pub mod create_workload_input {
    /// A builder for [`CreateWorkloadInput`](crate::input::CreateWorkloadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::WorkloadEnvironment>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) non_aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) pillar_priorities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) architectural_design: std::option::Option<std::string::String>,
        pub(crate) review_owner: std::option::Option<std::string::String>,
        pub(crate) industry_type: std::option::Option<std::string::String>,
        pub(crate) industry: std::option::Option<std::string::String>,
        pub(crate) lenses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `aws_regions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_regions.unwrap_or_default();
            v.push(input.into());
            self.aws_regions = Some(v);
            self
        }
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_regions = input;
            self
        }
        /// Appends an item to `non_aws_regions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.non_aws_regions.unwrap_or_default();
            v.push(input.into());
            self.non_aws_regions = Some(v);
            self
        }
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.non_aws_regions = input;
            self
        }
        /// Appends an item to `pillar_priorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pillar_priorities.unwrap_or_default();
            v.push(input.into());
            self.pillar_priorities = Some(v);
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pillar_priorities = input;
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.architectural_design = Some(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.architectural_design = input;
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.review_owner = Some(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.review_owner = input;
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.industry_type = Some(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.industry_type = input;
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.industry = Some(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.industry = input;
            self
        }
        /// Appends an item to `lenses`.
        ///
        /// To override the contents of this collection use [`set_lenses`](Self::set_lenses).
        ///
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lenses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lenses.unwrap_or_default();
            v.push(input.into());
            self.lenses = Some(v);
            self
        }
        /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lenses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lenses = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be associated with the workload.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be associated with the workload.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkloadInput`](crate::input::CreateWorkloadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkloadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkloadInput {
                workload_name: self.workload_name,
                description: self.description,
                environment: self.environment,
                account_ids: self.account_ids,
                aws_regions: self.aws_regions,
                non_aws_regions: self.non_aws_regions,
                pillar_priorities: self.pillar_priorities,
                architectural_design: self.architectural_design,
                review_owner: self.review_owner,
                industry_type: self.industry_type,
                industry: self.industry,
                lenses: self.lenses,
                notes: self.notes,
                client_request_token: self.client_request_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkloadInputOperationOutputAlias = crate::operation::CreateWorkload;
#[doc(hidden)]
pub type CreateWorkloadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkloadInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkload`](crate::operation::CreateWorkload)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkloadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/workloads").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkloadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkloadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_workload(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkload",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkloadInput`](crate::input::CreateWorkloadInput)
    pub fn builder() -> crate::input::create_workload_input::Builder {
        crate::input::create_workload_input::Builder::default()
    }
}

/// See [`CreateWorkloadShareInput`](crate::input::CreateWorkloadShareInput)
pub mod create_workload_share_input {
    /// A builder for [`CreateWorkloadShareInput`](crate::input::CreateWorkloadShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) shared_with: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_with = Some(input.into());
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.shared_with = input;
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkloadShareInput`](crate::input::CreateWorkloadShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkloadShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkloadShareInput {
                workload_id: self.workload_id,
                shared_with: self.shared_with,
                permission_type: self.permission_type,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkloadShareInputOperationOutputAlias = crate::operation::CreateWorkloadShare;
#[doc(hidden)]
pub type CreateWorkloadShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkloadShareInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkloadShare`](crate::operation::CreateWorkloadShare)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkloadShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkloadShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.workload_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_3, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/shares",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkloadShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkloadShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workload_share(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkloadShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkloadShare",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkloadShareInput`](crate::input::CreateWorkloadShareInput)
    pub fn builder() -> crate::input::create_workload_share_input::Builder {
        crate::input::create_workload_share_input::Builder::default()
    }
}

/// See [`DeleteWorkloadInput`](crate::input::DeleteWorkloadInput)
pub mod delete_workload_input {
    /// A builder for [`DeleteWorkloadInput`](crate::input::DeleteWorkloadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkloadInput`](crate::input::DeleteWorkloadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkloadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkloadInput {
                workload_id: self.workload_id,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkloadInputOperationOutputAlias = crate::operation::DeleteWorkload;
#[doc(hidden)]
pub type DeleteWorkloadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkloadInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkload`](crate::operation::DeleteWorkload)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkloadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.workload_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_4, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/workloads/{WorkloadId}", WorkloadId = workload_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteWorkloadInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.client_request_token {
                query.push_kv(
                    "ClientRequestToken",
                    &aws_smithy_http::query::fmt_string(&inner_5),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkloadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkloadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkload",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkloadInput`](crate::input::DeleteWorkloadInput)
    pub fn builder() -> crate::input::delete_workload_input::Builder {
        crate::input::delete_workload_input::Builder::default()
    }
}

/// See [`DeleteWorkloadShareInput`](crate::input::DeleteWorkloadShareInput)
pub mod delete_workload_share_input {
    /// A builder for [`DeleteWorkloadShareInput`](crate::input::DeleteWorkloadShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_id: std::option::Option<std::string::String>,
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkloadShareInput`](crate::input::DeleteWorkloadShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkloadShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkloadShareInput {
                share_id: self.share_id,
                workload_id: self.workload_id,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkloadShareInputOperationOutputAlias = crate::operation::DeleteWorkloadShare;
#[doc(hidden)]
pub type DeleteWorkloadShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkloadShareInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkloadShare`](crate::operation::DeleteWorkloadShare)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkloadShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkloadShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.workload_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_6, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.share_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "share_id",
                        details: "cannot be empty or unset",
                    })?;
            let share_id = aws_smithy_http::label::fmt_string(input_7, false);
            if share_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "share_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/shares/{ShareId}",
                WorkloadId = workload_id,
                ShareId = share_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteWorkloadShareInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.client_request_token {
                query.push_kv(
                    "ClientRequestToken",
                    &aws_smithy_http::query::fmt_string(&inner_8),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkloadShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkloadShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkloadShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkloadShare",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkloadShareInput`](crate::input::DeleteWorkloadShareInput)
    pub fn builder() -> crate::input::delete_workload_share_input::Builder {
        crate::input::delete_workload_share_input::Builder::default()
    }
}

/// See [`DisassociateLensesInput`](crate::input::DisassociateLensesInput)
pub mod disassociate_lenses_input {
    /// A builder for [`DisassociateLensesInput`](crate::input::DisassociateLensesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// Appends an item to `lens_aliases`.
        ///
        /// To override the contents of this collection use [`set_lens_aliases`](Self::set_lens_aliases).
        ///
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lens_aliases.unwrap_or_default();
            v.push(input.into());
            self.lens_aliases = Some(v);
            self
        }
        /// <p>List of lens aliases to associate or disassociate with a workload.</p>
        /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lens_aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLensesInput`](crate::input::DisassociateLensesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateLensesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateLensesInput {
                workload_id: self.workload_id,
                lens_aliases: self.lens_aliases,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateLensesInputOperationOutputAlias = crate::operation::DisassociateLenses;
#[doc(hidden)]
pub type DisassociateLensesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateLensesInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateLenses`](crate::operation::DisassociateLenses)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateLenses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateLensesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.workload_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_9, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/disassociateLenses",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateLensesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateLensesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_lenses(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateLenses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateLenses",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateLensesInput`](crate::input::DisassociateLensesInput)
    pub fn builder() -> crate::input::disassociate_lenses_input::Builder {
        crate::input::disassociate_lenses_input::Builder::default()
    }
}

/// See [`GetAnswerInput`](crate::input::GetAnswerInput)
pub mod get_answer_input {
    /// A builder for [`GetAnswerInput`](crate::input::GetAnswerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnswerInput`](crate::input::GetAnswerInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAnswerInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAnswerInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                question_id: self.question_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnswerInputOperationOutputAlias = crate::operation::GetAnswer;
#[doc(hidden)]
pub type GetAnswerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAnswerInput {
    /// Consumes the builder and constructs an Operation<[`GetAnswer`](crate::operation::GetAnswer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnswer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAnswerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.workload_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_10, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.lens_alias;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_11, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.question_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "question_id",
                        details: "cannot be empty or unset",
                    })?;
            let question_id = aws_smithy_http::label::fmt_string(input_12, false);
            if question_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "question_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
                WorkloadId = workload_id,
                LensAlias = lens_alias,
                QuestionId = question_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetAnswerInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.milestone_number != 0 {
                query.push_kv(
                    "MilestoneNumber",
                    &aws_smithy_types::primitive::Encoder::from(_input.milestone_number).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAnswerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAnswerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetAnswer::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetAnswer",
                    "wellarchitected",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAnswerInput`](crate::input::GetAnswerInput)
    pub fn builder() -> crate::input::get_answer_input::Builder {
        crate::input::get_answer_input::Builder::default()
    }
}

/// See [`GetLensReviewInput`](crate::input::GetLensReviewInput)
pub mod get_lens_review_input {
    /// A builder for [`GetLensReviewInput`](crate::input::GetLensReviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLensReviewInput`](crate::input::GetLensReviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLensReviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLensReviewInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                milestone_number: self.milestone_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetLensReviewInputOperationOutputAlias = crate::operation::GetLensReview;
#[doc(hidden)]
pub type GetLensReviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLensReviewInput {
    /// Consumes the builder and constructs an Operation<[`GetLensReview`](crate::operation::GetLensReview)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLensReview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLensReviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.workload_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_13, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.lens_alias;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_14, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
                WorkloadId = workload_id,
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetLensReviewInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.milestone_number != 0 {
                query.push_kv(
                    "MilestoneNumber",
                    &aws_smithy_types::primitive::Encoder::from(_input.milestone_number).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLensReviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLensReviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLensReview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLensReview",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLensReviewInput`](crate::input::GetLensReviewInput)
    pub fn builder() -> crate::input::get_lens_review_input::Builder {
        crate::input::get_lens_review_input::Builder::default()
    }
}

/// See [`GetLensReviewReportInput`](crate::input::GetLensReviewReportInput)
pub mod get_lens_review_report_input {
    /// A builder for [`GetLensReviewReportInput`](crate::input::GetLensReviewReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLensReviewReportInput`](crate::input::GetLensReviewReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLensReviewReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLensReviewReportInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                milestone_number: self.milestone_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetLensReviewReportInputOperationOutputAlias = crate::operation::GetLensReviewReport;
#[doc(hidden)]
pub type GetLensReviewReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLensReviewReportInput {
    /// Consumes the builder and constructs an Operation<[`GetLensReviewReport`](crate::operation::GetLensReviewReport)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLensReviewReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLensReviewReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.workload_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_15, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.lens_alias;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_16, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}/report",
                WorkloadId = workload_id,
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetLensReviewReportInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.milestone_number != 0 {
                query.push_kv(
                    "MilestoneNumber",
                    &aws_smithy_types::primitive::Encoder::from(_input.milestone_number).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLensReviewReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLensReviewReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLensReviewReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLensReviewReport",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLensReviewReportInput`](crate::input::GetLensReviewReportInput)
    pub fn builder() -> crate::input::get_lens_review_report_input::Builder {
        crate::input::get_lens_review_report_input::Builder::default()
    }
}

/// See [`GetLensVersionDifferenceInput`](crate::input::GetLensVersionDifferenceInput)
pub mod get_lens_version_difference_input {
    /// A builder for [`GetLensVersionDifferenceInput`](crate::input::GetLensVersionDifferenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) base_lens_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn base_lens_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_lens_version = Some(input.into());
            self
        }
        /// <p>The base version of the lens.</p>
        pub fn set_base_lens_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_lens_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLensVersionDifferenceInput`](crate::input::GetLensVersionDifferenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLensVersionDifferenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLensVersionDifferenceInput {
                lens_alias: self.lens_alias,
                base_lens_version: self.base_lens_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLensVersionDifferenceInputOperationOutputAlias =
    crate::operation::GetLensVersionDifference;
#[doc(hidden)]
pub type GetLensVersionDifferenceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLensVersionDifferenceInput {
    /// Consumes the builder and constructs an Operation<[`GetLensVersionDifference`](crate::operation::GetLensVersionDifference)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLensVersionDifference,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLensVersionDifferenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.lens_alias;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_17, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/lenses/{LensAlias}/versionDifference",
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetLensVersionDifferenceInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.base_lens_version {
                query.push_kv(
                    "BaseLensVersion",
                    &aws_smithy_http::query::fmt_string(&inner_18),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLensVersionDifferenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLensVersionDifferenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLensVersionDifference::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLensVersionDifference",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLensVersionDifferenceInput`](crate::input::GetLensVersionDifferenceInput)
    pub fn builder() -> crate::input::get_lens_version_difference_input::Builder {
        crate::input::get_lens_version_difference_input::Builder::default()
    }
}

/// See [`GetMilestoneInput`](crate::input::GetMilestoneInput)
pub mod get_milestone_input {
    /// A builder for [`GetMilestoneInput`](crate::input::GetMilestoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMilestoneInput`](crate::input::GetMilestoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMilestoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMilestoneInput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetMilestoneInputOperationOutputAlias = crate::operation::GetMilestone;
#[doc(hidden)]
pub type GetMilestoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMilestoneInput {
    /// Consumes the builder and constructs an Operation<[`GetMilestone`](crate::operation::GetMilestone)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMilestone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMilestoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.workload_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_19, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_20 = &_input.milestone_number;
            let mut milestone_number_encoder =
                aws_smithy_types::primitive::Encoder::from(*input_20);
            let milestone_number = milestone_number_encoder.encode();
            if milestone_number.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "milestone_number",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/milestones/{MilestoneNumber}",
                WorkloadId = workload_id,
                MilestoneNumber = milestone_number
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMilestoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMilestoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMilestone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMilestone",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMilestoneInput`](crate::input::GetMilestoneInput)
    pub fn builder() -> crate::input::get_milestone_input::Builder {
        crate::input::get_milestone_input::Builder::default()
    }
}

/// See [`GetWorkloadInput`](crate::input::GetWorkloadInput)
pub mod get_workload_input {
    /// A builder for [`GetWorkloadInput`](crate::input::GetWorkloadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkloadInput`](crate::input::GetWorkloadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkloadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkloadInput {
                workload_id: self.workload_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkloadInputOperationOutputAlias = crate::operation::GetWorkload;
#[doc(hidden)]
pub type GetWorkloadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetWorkloadInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkload`](crate::operation::GetWorkload)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWorkloadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.workload_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_21, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/workloads/{WorkloadId}", WorkloadId = workload_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWorkloadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWorkloadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkload",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWorkloadInput`](crate::input::GetWorkloadInput)
    pub fn builder() -> crate::input::get_workload_input::Builder {
        crate::input::get_workload_input::Builder::default()
    }
}

/// See [`ListAnswersInput`](crate::input::ListAnswersInput)
pub mod list_answers_input {
    /// A builder for [`ListAnswersInput`](crate::input::ListAnswersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnswersInput`](crate::input::ListAnswersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnswersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnswersInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                pillar_id: self.pillar_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnswersInputOperationOutputAlias = crate::operation::ListAnswers;
#[doc(hidden)]
pub type ListAnswersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAnswersInput {
    /// Consumes the builder and constructs an Operation<[`ListAnswers`](crate::operation::ListAnswers)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnswers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAnswersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.workload_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_22, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.lens_alias;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_23, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers",
                WorkloadId = workload_id,
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListAnswersInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_24) = &_input.pillar_id {
                query.push_kv("PillarId", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if _input.milestone_number != 0 {
                query.push_kv(
                    "MilestoneNumber",
                    &aws_smithy_types::primitive::Encoder::from(_input.milestone_number).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAnswersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAnswersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnswers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnswers",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAnswersInput`](crate::input::ListAnswersInput)
    pub fn builder() -> crate::input::list_answers_input::Builder {
        crate::input::list_answers_input::Builder::default()
    }
}

/// See [`ListLensesInput`](crate::input::ListLensesInput)
pub mod list_lenses_input {
    /// A builder for [`ListLensesInput`](crate::input::ListLensesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLensesInput`](crate::input::ListLensesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLensesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLensesInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListLensesInputOperationOutputAlias = crate::operation::ListLenses;
#[doc(hidden)]
pub type ListLensesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLensesInput {
    /// Consumes the builder and constructs an Operation<[`ListLenses`](crate::operation::ListLenses)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLenses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLensesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/lenses").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListLensesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLensesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLensesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLenses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLenses",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLensesInput`](crate::input::ListLensesInput)
    pub fn builder() -> crate::input::list_lenses_input::Builder {
        crate::input::list_lenses_input::Builder::default()
    }
}

/// See [`ListLensReviewImprovementsInput`](crate::input::ListLensReviewImprovementsInput)
pub mod list_lens_review_improvements_input {
    /// A builder for [`ListLensReviewImprovementsInput`](crate::input::ListLensReviewImprovementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) pillar_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pillar_id = Some(input.into());
            self
        }
        /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
        /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pillar_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLensReviewImprovementsInput`](crate::input::ListLensReviewImprovementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLensReviewImprovementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLensReviewImprovementsInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                pillar_id: self.pillar_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListLensReviewImprovementsInputOperationOutputAlias =
    crate::operation::ListLensReviewImprovements;
#[doc(hidden)]
pub type ListLensReviewImprovementsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLensReviewImprovementsInput {
    /// Consumes the builder and constructs an Operation<[`ListLensReviewImprovements`](crate::operation::ListLensReviewImprovements)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLensReviewImprovements,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLensReviewImprovementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.workload_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_27, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.lens_alias;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_28, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}/improvements",
                WorkloadId = workload_id,
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListLensReviewImprovementsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_29) = &_input.pillar_id {
                query.push_kv("PillarId", &aws_smithy_http::query::fmt_string(&inner_29));
            }
            if _input.milestone_number != 0 {
                query.push_kv(
                    "MilestoneNumber",
                    &aws_smithy_types::primitive::Encoder::from(_input.milestone_number).encode(),
                );
            }
            if let Some(inner_30) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_30));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLensReviewImprovementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLensReviewImprovementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLensReviewImprovements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLensReviewImprovements",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLensReviewImprovementsInput`](crate::input::ListLensReviewImprovementsInput)
    pub fn builder() -> crate::input::list_lens_review_improvements_input::Builder {
        crate::input::list_lens_review_improvements_input::Builder::default()
    }
}

/// See [`ListLensReviewsInput`](crate::input::ListLensReviewsInput)
pub mod list_lens_reviews_input {
    /// A builder for [`ListLensReviewsInput`](crate::input::ListLensReviewsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) milestone_number: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn milestone_number(mut self, input: i32) -> Self {
            self.milestone_number = Some(input);
            self
        }
        /// <p>The milestone number.</p>
        /// <p>A workload can have a maximum of 100 milestones.</p>
        pub fn set_milestone_number(mut self, input: std::option::Option<i32>) -> Self {
            self.milestone_number = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLensReviewsInput`](crate::input::ListLensReviewsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLensReviewsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLensReviewsInput {
                workload_id: self.workload_id,
                milestone_number: self.milestone_number.unwrap_or_default(),
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListLensReviewsInputOperationOutputAlias = crate::operation::ListLensReviews;
#[doc(hidden)]
pub type ListLensReviewsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLensReviewsInput {
    /// Consumes the builder and constructs an Operation<[`ListLensReviews`](crate::operation::ListLensReviews)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLensReviews,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLensReviewsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.workload_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_31, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListLensReviewsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.milestone_number != 0 {
                query.push_kv(
                    "MilestoneNumber",
                    &aws_smithy_types::primitive::Encoder::from(_input.milestone_number).encode(),
                );
            }
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLensReviewsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLensReviewsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLensReviews::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLensReviews",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLensReviewsInput`](crate::input::ListLensReviewsInput)
    pub fn builder() -> crate::input::list_lens_reviews_input::Builder {
        crate::input::list_lens_reviews_input::Builder::default()
    }
}

/// See [`ListMilestonesInput`](crate::input::ListMilestonesInput)
pub mod list_milestones_input {
    /// A builder for [`ListMilestonesInput`](crate::input::ListMilestonesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMilestonesInput`](crate::input::ListMilestonesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMilestonesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMilestonesInput {
                workload_id: self.workload_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListMilestonesInputOperationOutputAlias = crate::operation::ListMilestones;
#[doc(hidden)]
pub type ListMilestonesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMilestonesInput {
    /// Consumes the builder and constructs an Operation<[`ListMilestones`](crate::operation::ListMilestones)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMilestones,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMilestonesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.workload_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_33, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/milestonesSummaries",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMilestonesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMilestonesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_milestones(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMilestones::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMilestones",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMilestonesInput`](crate::input::ListMilestonesInput)
    pub fn builder() -> crate::input::list_milestones_input::Builder {
        crate::input::list_milestones_input::Builder::default()
    }
}

/// See [`ListNotificationsInput`](crate::input::ListNotificationsInput)
pub mod list_notifications_input {
    /// A builder for [`ListNotificationsInput`](crate::input::ListNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationsInput`](crate::input::ListNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNotificationsInput {
                workload_id: self.workload_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListNotificationsInputOperationOutputAlias = crate::operation::ListNotifications;
#[doc(hidden)]
pub type ListNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`ListNotifications`](crate::operation::ListNotifications)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/notifications").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_notifications(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNotifications",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNotificationsInput`](crate::input::ListNotificationsInput)
    pub fn builder() -> crate::input::list_notifications_input::Builder {
        crate::input::list_notifications_input::Builder::default()
    }
}

/// See [`ListShareInvitationsInput`](crate::input::ListShareInvitationsInput)
pub mod list_share_invitations_input {
    /// A builder for [`ListShareInvitationsInput`](crate::input::ListShareInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_name_prefix: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn workload_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name_prefix = Some(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name_prefix = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListShareInvitationsInput`](crate::input::ListShareInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListShareInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListShareInvitationsInput {
                workload_name_prefix: self.workload_name_prefix,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListShareInvitationsInputOperationOutputAlias = crate::operation::ListShareInvitations;
#[doc(hidden)]
pub type ListShareInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListShareInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`ListShareInvitations`](crate::operation::ListShareInvitations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListShareInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListShareInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/shareInvitations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListShareInvitationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.workload_name_prefix {
                query.push_kv(
                    "WorkloadNamePrefix",
                    &aws_smithy_http::query::fmt_string(&inner_34),
                );
            }
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListShareInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListShareInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListShareInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListShareInvitations",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListShareInvitationsInput`](crate::input::ListShareInvitationsInput)
    pub fn builder() -> crate::input::list_share_invitations_input::Builder {
        crate::input::list_share_invitations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                workload_arn: self.workload_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.workload_arn;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_arn",
                        details: "cannot be empty or unset",
                    })?;
            let workload_arn = aws_smithy_http::label::fmt_string(input_36, false);
            if workload_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{WorkloadArn}", WorkloadArn = workload_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWorkloadsInput`](crate::input::ListWorkloadsInput)
pub mod list_workloads_input {
    /// A builder for [`ListWorkloadsInput`](crate::input::ListWorkloadsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_name_prefix: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn workload_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name_prefix = Some(input.into());
            self
        }
        /// <p>An optional string added to the beginning of each workload name returned in the
        /// results.</p>
        pub fn set_workload_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name_prefix = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkloadsInput`](crate::input::ListWorkloadsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkloadsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkloadsInput {
                workload_name_prefix: self.workload_name_prefix,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkloadsInputOperationOutputAlias = crate::operation::ListWorkloads;
#[doc(hidden)]
pub type ListWorkloadsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkloadsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkloads`](crate::operation::ListWorkloads)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkloads,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkloadsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/workloadsSummaries").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkloadsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkloadsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_workloads(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkloads::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkloads",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkloadsInput`](crate::input::ListWorkloadsInput)
    pub fn builder() -> crate::input::list_workloads_input::Builder {
        crate::input::list_workloads_input::Builder::default()
    }
}

/// See [`ListWorkloadSharesInput`](crate::input::ListWorkloadSharesInput)
pub mod list_workload_shares_input {
    /// A builder for [`ListWorkloadSharesInput`](crate::input::ListWorkloadSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) shared_with_prefix: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn shared_with_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_with_prefix = Some(input.into());
            self
        }
        /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
        pub fn set_shared_with_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_with_prefix = input;
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return for this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkloadSharesInput`](crate::input::ListWorkloadSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkloadSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkloadSharesInput {
                workload_id: self.workload_id,
                shared_with_prefix: self.shared_with_prefix,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkloadSharesInputOperationOutputAlias = crate::operation::ListWorkloadShares;
#[doc(hidden)]
pub type ListWorkloadSharesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkloadSharesInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkloadShares`](crate::operation::ListWorkloadShares)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkloadShares,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkloadSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.workload_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_37, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/shares",
                WorkloadId = workload_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListWorkloadSharesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_38) = &_input.shared_with_prefix {
                query.push_kv(
                    "SharedWithPrefix",
                    &aws_smithy_http::query::fmt_string(&inner_38),
                );
            }
            if let Some(inner_39) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkloadSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkloadSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkloadShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkloadShares",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkloadSharesInput`](crate::input::ListWorkloadSharesInput)
    pub fn builder() -> crate::input::list_workload_shares_input::Builder {
        crate::input::list_workload_shares_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                workload_arn: self.workload_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.workload_arn;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_arn",
                        details: "cannot be empty or unset",
                    })?;
            let workload_arn = aws_smithy_http::label::fmt_string(input_40, false);
            if workload_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{WorkloadArn}", WorkloadArn = workload_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN for the workload.</p>
        pub fn workload_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the workload.</p>
        pub fn set_workload_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource
        /// whose keys are members of this list are removed from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource
        /// whose keys are members of this list are removed from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                workload_arn: self.workload_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.workload_arn;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_arn",
                        details: "cannot be empty or unset",
                    })?;
            let workload_arn = aws_smithy_http::label::fmt_string(input_41, false);
            if workload_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{WorkloadArn}", WorkloadArn = workload_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_42) = &_input.tag_keys {
                for inner_43 in inner_42 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_43));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAnswerInput`](crate::input::UpdateAnswerInput)
pub mod update_answer_input {
    /// A builder for [`UpdateAnswerInput`](crate::input::UpdateAnswerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) question_id: std::option::Option<std::string::String>,
        pub(crate) selected_choices: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) choice_updates: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ChoiceUpdate>,
        >,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) is_applicable: std::option::Option<bool>,
        pub(crate) reason: std::option::Option<crate::model::AnswerReason>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The ID of the question.</p>
        pub fn question_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.question_id = Some(input.into());
            self
        }
        /// <p>The ID of the question.</p>
        pub fn set_question_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.question_id = input;
            self
        }
        /// Appends an item to `selected_choices`.
        ///
        /// To override the contents of this collection use [`set_selected_choices`](Self::set_selected_choices).
        ///
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn selected_choices(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.selected_choices.unwrap_or_default();
            v.push(input.into());
            self.selected_choices = Some(v);
            self
        }
        /// <p>List of selected choice IDs in a question answer.</p>
        /// <p>The values entered replace the previously selected choices.</p>
        pub fn set_selected_choices(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.selected_choices = input;
            self
        }
        /// Adds a key-value pair to `choice_updates`.
        ///
        /// To override the contents of this collection use [`set_choice_updates`](Self::set_choice_updates).
        ///
        /// <p>A list of choices to update on a question in your workload.  The String key
        /// corresponds to the choice ID to be updated.</p>
        pub fn choice_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ChoiceUpdate>,
        ) -> Self {
            let mut hash_map = self.choice_updates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.choice_updates = Some(hash_map);
            self
        }
        /// <p>A list of choices to update on a question in your workload.  The String key
        /// corresponds to the choice ID to be updated.</p>
        pub fn set_choice_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ChoiceUpdate>,
            >,
        ) -> Self {
            self.choice_updates = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn is_applicable(mut self, input: bool) -> Self {
            self.is_applicable = Some(input);
            self
        }
        /// <p>Defines whether this question is applicable to a lens review.</p>
        pub fn set_is_applicable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_applicable = input;
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn reason(mut self, input: crate::model::AnswerReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why a question is not applicable to your workload.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AnswerReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnswerInput`](crate::input::UpdateAnswerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAnswerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAnswerInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                question_id: self.question_id,
                selected_choices: self.selected_choices,
                choice_updates: self.choice_updates,
                notes: self.notes,
                is_applicable: self.is_applicable.unwrap_or_default(),
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAnswerInputOperationOutputAlias = crate::operation::UpdateAnswer;
#[doc(hidden)]
pub type UpdateAnswerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAnswerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAnswer`](crate::operation::UpdateAnswer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAnswer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAnswerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.workload_id;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_44, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_45 = &_input.lens_alias;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_45, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_46 = &_input.question_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "question_id",
                        details: "cannot be empty or unset",
                    })?;
            let question_id = aws_smithy_http::label::fmt_string(input_46, false);
            if question_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "question_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}/answers/{QuestionId}",
                WorkloadId = workload_id,
                LensAlias = lens_alias,
                QuestionId = question_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAnswerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAnswerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_answer(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAnswer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAnswer",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAnswerInput`](crate::input::UpdateAnswerInput)
    pub fn builder() -> crate::input::update_answer_input::Builder {
        crate::input::update_answer_input::Builder::default()
    }
}

/// See [`UpdateLensReviewInput`](crate::input::UpdateLensReviewInput)
pub mod update_lens_review_input {
    /// A builder for [`UpdateLensReviewInput`](crate::input::UpdateLensReviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) lens_notes: std::option::Option<std::string::String>,
        pub(crate) pillar_notes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn lens_notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_lens_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_notes = input;
            self
        }
        /// Adds a key-value pair to `pillar_notes`.
        ///
        /// To override the contents of this collection use [`set_pillar_notes`](Self::set_pillar_notes).
        ///
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn pillar_notes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.pillar_notes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.pillar_notes = Some(hash_map);
            self
        }
        /// <p>List of pillar notes of a lens review in a workload.</p>
        pub fn set_pillar_notes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.pillar_notes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLensReviewInput`](crate::input::UpdateLensReviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLensReviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLensReviewInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                lens_notes: self.lens_notes,
                pillar_notes: self.pillar_notes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLensReviewInputOperationOutputAlias = crate::operation::UpdateLensReview;
#[doc(hidden)]
pub type UpdateLensReviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLensReviewInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLensReview`](crate::operation::UpdateLensReview)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLensReview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLensReviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.workload_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_47, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_48 = &_input.lens_alias;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_48, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}",
                WorkloadId = workload_id,
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLensReviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLensReviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_lens_review(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLensReview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLensReview",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLensReviewInput`](crate::input::UpdateLensReviewInput)
    pub fn builder() -> crate::input::update_lens_review_input::Builder {
        crate::input::update_lens_review_input::Builder::default()
    }
}

/// See [`UpdateShareInvitationInput`](crate::input::UpdateShareInvitationInput)
pub mod update_share_invitation_input {
    /// A builder for [`UpdateShareInvitationInput`](crate::input::UpdateShareInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_invitation_id: std::option::Option<std::string::String>,
        pub(crate) share_invitation_action:
            std::option::Option<crate::model::ShareInvitationAction>,
    }
    impl Builder {
        /// <p>The ID assigned to the share invitation.</p>
        pub fn share_invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_invitation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the share invitation.</p>
        pub fn set_share_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.share_invitation_id = input;
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn share_invitation_action(
            mut self,
            input: crate::model::ShareInvitationAction,
        ) -> Self {
            self.share_invitation_action = Some(input);
            self
        }
        /// <p>Share invitation action taken by contributor.</p>
        pub fn set_share_invitation_action(
            mut self,
            input: std::option::Option<crate::model::ShareInvitationAction>,
        ) -> Self {
            self.share_invitation_action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateShareInvitationInput`](crate::input::UpdateShareInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateShareInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateShareInvitationInput {
                share_invitation_id: self.share_invitation_id,
                share_invitation_action: self.share_invitation_action,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateShareInvitationInputOperationOutputAlias = crate::operation::UpdateShareInvitation;
#[doc(hidden)]
pub type UpdateShareInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateShareInvitationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateShareInvitation`](crate::operation::UpdateShareInvitation)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateShareInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateShareInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.share_invitation_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "share_invitation_id",
                        details: "cannot be empty or unset",
                    })?;
            let share_invitation_id = aws_smithy_http::label::fmt_string(input_49, false);
            if share_invitation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "share_invitation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/shareInvitations/{ShareInvitationId}",
                ShareInvitationId = share_invitation_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateShareInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateShareInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_share_invitation(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateShareInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateShareInvitation",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateShareInvitationInput`](crate::input::UpdateShareInvitationInput)
    pub fn builder() -> crate::input::update_share_invitation_input::Builder {
        crate::input::update_share_invitation_input::Builder::default()
    }
}

/// See [`UpdateWorkloadInput`](crate::input::UpdateWorkloadInput)
pub mod update_workload_input {
    /// A builder for [`UpdateWorkloadInput`](crate::input::UpdateWorkloadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) workload_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::WorkloadEnvironment>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) non_aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) pillar_priorities: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) architectural_design: std::option::Option<std::string::String>,
        pub(crate) review_owner: std::option::Option<std::string::String>,
        pub(crate) is_review_owner_update_acknowledged: std::option::Option<bool>,
        pub(crate) industry_type: std::option::Option<std::string::String>,
        pub(crate) industry: std::option::Option<std::string::String>,
        pub(crate) notes: std::option::Option<std::string::String>,
        pub(crate) improvement_status: std::option::Option<crate::model::WorkloadImprovementStatus>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn workload_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_name = Some(input.into());
            self
        }
        /// <p>The name of the workload.</p>
        /// <p>The name must be unique within an account within a Region. Spaces and capitalization
        /// are ignored when checking for uniqueness.</p>
        pub fn set_workload_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workload_name = input;
            self
        }
        /// <p>The description for the workload.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the workload.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn environment(mut self, input: crate::model::WorkloadEnvironment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The environment for the workload.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::WorkloadEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The list of AWS account IDs associated with the workload.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `aws_regions`.
        ///
        /// To override the contents of this collection use [`set_aws_regions`](Self::set_aws_regions).
        ///
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_regions.unwrap_or_default();
            v.push(input.into());
            self.aws_regions = Some(v);
            self
        }
        /// <p>The list of AWS Regions associated with the workload, for example,
        /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
        pub fn set_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_regions = input;
            self
        }
        /// Appends an item to `non_aws_regions`.
        ///
        /// To override the contents of this collection use [`set_non_aws_regions`](Self::set_non_aws_regions).
        ///
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn non_aws_regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.non_aws_regions.unwrap_or_default();
            v.push(input.into());
            self.non_aws_regions = Some(v);
            self
        }
        /// <p> The list of non-AWS Regions associated with the workload.</p>
        pub fn set_non_aws_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.non_aws_regions = input;
            self
        }
        /// Appends an item to `pillar_priorities`.
        ///
        /// To override the contents of this collection use [`set_pillar_priorities`](Self::set_pillar_priorities).
        ///
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn pillar_priorities(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pillar_priorities.unwrap_or_default();
            v.push(input.into());
            self.pillar_priorities = Some(v);
            self
        }
        /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
        /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
        pub fn set_pillar_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pillar_priorities = input;
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn architectural_design(mut self, input: impl Into<std::string::String>) -> Self {
            self.architectural_design = Some(input.into());
            self
        }
        /// <p>The URL of the architectural design for the workload.</p>
        pub fn set_architectural_design(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.architectural_design = input;
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn review_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.review_owner = Some(input.into());
            self
        }
        /// <p>The review owner of the workload. The name, email address, or identifier for the
        /// primary group or individual that owns the workload review process.</p>
        pub fn set_review_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.review_owner = input;
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
        /// owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within
        /// 60 days of acknowledgement, access to the workload is restricted until an owner is
        /// added.</p>
        pub fn is_review_owner_update_acknowledged(mut self, input: bool) -> Self {
            self.is_review_owner_update_acknowledged = Some(input);
            self
        }
        /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
        /// owner</i> field is required.</p>
        /// <p>If a <b>Review owner</b> is not added to the workload within
        /// 60 days of acknowledgement, access to the workload is restricted until an owner is
        /// added.</p>
        pub fn set_is_review_owner_update_acknowledged(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_review_owner_update_acknowledged = input;
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn industry_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.industry_type = Some(input.into());
            self
        }
        /// <p>The industry type for the workload.</p>
        /// <p>If specified, must be one of the following:</p>  
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Agriculture</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Automobile</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Defense</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Design and Engineering</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Digital Advertising</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Education</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Environmental Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Financial Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Gaming</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>General Public Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Healthcare</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Hospitality</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InfoTech</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Justice and Public Safety</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Life Sciences</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Manufacturing</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Media & Entertainment</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Mining & Resources</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Oil & Gas</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Power & Utilities</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Professional Services</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Real Estate & Construction</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Retail & Wholesale</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Social Protection</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Telecommunications</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Travel, Transportation & Logistics</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Other</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_industry_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.industry_type = input;
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn industry(mut self, input: impl Into<std::string::String>) -> Self {
            self.industry = Some(input.into());
            self
        }
        /// <p>The industry for the workload.</p>
        pub fn set_industry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.industry = input;
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn notes(mut self, input: impl Into<std::string::String>) -> Self {
            self.notes = Some(input.into());
            self
        }
        /// <p>The notes associated with the workload.</p>
        pub fn set_notes(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.notes = input;
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn improvement_status(
            mut self,
            input: crate::model::WorkloadImprovementStatus,
        ) -> Self {
            self.improvement_status = Some(input);
            self
        }
        /// <p>The improvement status for a workload.</p>
        pub fn set_improvement_status(
            mut self,
            input: std::option::Option<crate::model::WorkloadImprovementStatus>,
        ) -> Self {
            self.improvement_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkloadInput`](crate::input::UpdateWorkloadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkloadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkloadInput {
                workload_id: self.workload_id,
                workload_name: self.workload_name,
                description: self.description,
                environment: self.environment,
                account_ids: self.account_ids,
                aws_regions: self.aws_regions,
                non_aws_regions: self.non_aws_regions,
                pillar_priorities: self.pillar_priorities,
                architectural_design: self.architectural_design,
                review_owner: self.review_owner,
                is_review_owner_update_acknowledged: self
                    .is_review_owner_update_acknowledged
                    .unwrap_or_default(),
                industry_type: self.industry_type,
                industry: self.industry,
                notes: self.notes,
                improvement_status: self.improvement_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkloadInputOperationOutputAlias = crate::operation::UpdateWorkload;
#[doc(hidden)]
pub type UpdateWorkloadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkloadInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkload`](crate::operation::UpdateWorkload)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkloadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.workload_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_50, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/workloads/{WorkloadId}", WorkloadId = workload_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkloadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkloadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_workload(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkload",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkloadInput`](crate::input::UpdateWorkloadInput)
    pub fn builder() -> crate::input::update_workload_input::Builder {
        crate::input::update_workload_input::Builder::default()
    }
}

/// See [`UpdateWorkloadShareInput`](crate::input::UpdateWorkloadShareInput)
pub mod update_workload_share_input {
    /// A builder for [`UpdateWorkloadShareInput`](crate::input::UpdateWorkloadShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) share_id: std::option::Option<std::string::String>,
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
    }
    impl Builder {
        /// <p>The ID associated with the workload share.</p>
        pub fn share_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.share_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the workload share.</p>
        pub fn set_share_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.share_id = input;
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>Permission granted on a workload share.</p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkloadShareInput`](crate::input::UpdateWorkloadShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkloadShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkloadShareInput {
                share_id: self.share_id,
                workload_id: self.workload_id,
                permission_type: self.permission_type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkloadShareInputOperationOutputAlias = crate::operation::UpdateWorkloadShare;
#[doc(hidden)]
pub type UpdateWorkloadShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkloadShareInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkloadShare`](crate::operation::UpdateWorkloadShare)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkloadShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkloadShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.workload_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_51, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_52 = &_input.share_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "share_id",
                        details: "cannot be empty or unset",
                    })?;
            let share_id = aws_smithy_http::label::fmt_string(input_52, false);
            if share_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "share_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/shares/{ShareId}",
                WorkloadId = workload_id,
                ShareId = share_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkloadShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkloadShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_workload_share(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkloadShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkloadShare",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkloadShareInput`](crate::input::UpdateWorkloadShareInput)
    pub fn builder() -> crate::input::update_workload_share_input::Builder {
        crate::input::update_workload_share_input::Builder::default()
    }
}

/// See [`UpgradeLensReviewInput`](crate::input::UpgradeLensReviewInput)
pub mod upgrade_lens_review_input {
    /// A builder for [`UpgradeLensReviewInput`](crate::input::UpgradeLensReviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workload_id: std::option::Option<std::string::String>,
        pub(crate) lens_alias: std::option::Option<std::string::String>,
        pub(crate) milestone_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn workload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workload_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
        pub fn set_workload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workload_id = input;
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn lens_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.lens_alias = Some(input.into());
            self
        }
        /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
        /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
        pub fn set_lens_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lens_alias = input;
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn milestone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.milestone_name = Some(input.into());
            self
        }
        /// <p>The name of the milestone in a workload.</p>
        /// <p>Milestone names must be unique within a workload.</p>
        pub fn set_milestone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.milestone_name = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure that this request is idempotent
        /// (executes only once).</p>
        /// <p>You should not reuse the same token for other requests. If you retry a request with
        /// the same client request token and the same parameters after it has completed
        /// successfully, the result of the original request is returned. </p>
        /// <important>
        /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
        /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
        /// you must provide this token or the request will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeLensReviewInput`](crate::input::UpgradeLensReviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpgradeLensReviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpgradeLensReviewInput {
                workload_id: self.workload_id,
                lens_alias: self.lens_alias,
                milestone_name: self.milestone_name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpgradeLensReviewInputOperationOutputAlias = crate::operation::UpgradeLensReview;
#[doc(hidden)]
pub type UpgradeLensReviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpgradeLensReviewInput {
    /// Consumes the builder and constructs an Operation<[`UpgradeLensReview`](crate::operation::UpgradeLensReview)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpgradeLensReview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpgradeLensReviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.workload_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workload_id",
                        details: "cannot be empty or unset",
                    })?;
            let workload_id = aws_smithy_http::label::fmt_string(input_53, false);
            if workload_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workload_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_54 = &_input.lens_alias;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "lens_alias",
                        details: "cannot be empty or unset",
                    })?;
            let lens_alias = aws_smithy_http::label::fmt_string(input_54, false);
            if lens_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "lens_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workloads/{WorkloadId}/lensReviews/{LensAlias}/upgrade",
                WorkloadId = workload_id,
                LensAlias = lens_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpgradeLensReviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpgradeLensReviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_upgrade_lens_review(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpgradeLensReview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpgradeLensReview",
            "wellarchitected",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpgradeLensReviewInput`](crate::input::UpgradeLensReviewInput)
    pub fn builder() -> crate::input::upgrade_lens_review_input::Builder {
        crate::input::upgrade_lens_review_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeLensReviewInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The name of the milestone in a workload.</p>
    /// <p>Milestone names must be unique within a workload.</p>
    pub milestone_name: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure that this request is idempotent
    /// (executes only once).</p>
    /// <p>You should not reuse the same token for other requests. If you retry a request with
    /// the same client request token and the same parameters after it has completed
    /// successfully, the result of the original request is returned. </p>
    /// <important>
    /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
    /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
    /// you must provide this token or the request will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpgradeLensReviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeLensReviewInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("milestone_name", &self.milestone_name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

/// <p>Input for Update Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkloadShareInput {
    /// <p>The ID associated with the workload share.</p>
    pub share_id: std::option::Option<std::string::String>,
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>Permission granted on a workload share.</p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
}
impl std::fmt::Debug for UpdateWorkloadShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkloadShareInput");
        formatter.field("share_id", &self.share_id);
        formatter.field("workload_id", &self.workload_id);
        formatter.field("permission_type", &self.permission_type);
        formatter.finish()
    }
}

/// <p>Input to update a workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkloadInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within a Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>The description for the workload.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The environment for the workload.</p>
    pub environment: std::option::Option<crate::model::WorkloadEnvironment>,
    /// <p>The list of AWS account IDs associated with the workload.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of AWS Regions associated with the workload, for example,
    /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
    pub aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The list of non-AWS Regions associated with the workload.</p>
    pub non_aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
    /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_priorities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The URL of the architectural design for the workload.</p>
    pub architectural_design: std::option::Option<std::string::String>,
    /// <p>The review owner of the workload. The name, email address, or identifier for the
    /// primary group or individual that owns the workload review process.</p>
    pub review_owner: std::option::Option<std::string::String>,
    /// <p>Flag indicating whether the workload owner has acknowledged that the <i>Review
    /// owner</i> field is required.</p>
    /// <p>If a <b>Review owner</b> is not added to the workload within
    /// 60 days of acknowledgement, access to the workload is restricted until an owner is
    /// added.</p>
    pub is_review_owner_update_acknowledged: bool,
    /// <p>The industry type for the workload.</p>
    /// <p>If specified, must be one of the following:</p>  
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Agriculture</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Automobile</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Defense</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Design and Engineering</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Digital Advertising</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Education</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Environmental Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Financial Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Gaming</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>General Public Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Healthcare</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Hospitality</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InfoTech</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Justice and Public Safety</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Life Sciences</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Manufacturing</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Media & Entertainment</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Mining & Resources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Oil & Gas</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Power & Utilities</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Professional Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Real Estate & Construction</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Retail & Wholesale</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Social Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Telecommunications</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Travel, Transportation & Logistics</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Other</code>
    /// </p>
    /// </li>
    /// </ul>
    pub industry_type: std::option::Option<std::string::String>,
    /// <p>The industry for the workload.</p>
    pub industry: std::option::Option<std::string::String>,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>The improvement status for a workload.</p>
    pub improvement_status: std::option::Option<crate::model::WorkloadImprovementStatus>,
}
impl std::fmt::Debug for UpdateWorkloadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkloadInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("workload_name", &self.workload_name);
        formatter.field("description", &self.description);
        formatter.field("environment", &self.environment);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("aws_regions", &self.aws_regions);
        formatter.field("non_aws_regions", &self.non_aws_regions);
        formatter.field("pillar_priorities", &self.pillar_priorities);
        formatter.field("architectural_design", &self.architectural_design);
        formatter.field("review_owner", &self.review_owner);
        formatter.field(
            "is_review_owner_update_acknowledged",
            &self.is_review_owner_update_acknowledged,
        );
        formatter.field("industry_type", &self.industry_type);
        formatter.field("industry", &self.industry);
        formatter.field("notes", &self.notes);
        formatter.field("improvement_status", &self.improvement_status);
        formatter.finish()
    }
}

/// <p>Input for Update Share Invitation</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateShareInvitationInput {
    /// <p>The ID assigned to the share invitation.</p>
    pub share_invitation_id: std::option::Option<std::string::String>,
    /// <p>Share invitation action taken by contributor.</p>
    pub share_invitation_action: std::option::Option<crate::model::ShareInvitationAction>,
}
impl std::fmt::Debug for UpdateShareInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateShareInvitationInput");
        formatter.field("share_invitation_id", &self.share_invitation_id);
        formatter.field("share_invitation_action", &self.share_invitation_action);
        formatter.finish()
    }
}

/// <p>Input for update lens review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLensReviewInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The notes associated with the workload.</p>
    pub lens_notes: std::option::Option<std::string::String>,
    /// <p>List of pillar notes of a lens review in a workload.</p>
    pub pillar_notes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for UpdateLensReviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLensReviewInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("lens_notes", &self.lens_notes);
        formatter.field("pillar_notes", &self.pillar_notes);
        formatter.finish()
    }
}

/// <p>Input to update answer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnswerInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the question.</p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p>List of selected choice IDs in a question answer.</p>
    /// <p>The values entered replace the previously selected choices.</p>
    pub selected_choices: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of choices to update on a question in your workload.  The String key
    /// corresponds to the choice ID to be updated.</p>
    pub choice_updates: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ChoiceUpdate>,
    >,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>Defines whether this question is applicable to a lens review.</p>
    pub is_applicable: bool,
    /// <p>The reason why a question is not applicable to your workload.</p>
    pub reason: std::option::Option<crate::model::AnswerReason>,
}
impl std::fmt::Debug for UpdateAnswerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnswerInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("question_id", &self.question_id);
        formatter.field("selected_choices", &self.selected_choices);
        formatter.field("choice_updates", &self.choice_updates);
        formatter.field("notes", &self.notes);
        formatter.field("is_applicable", &self.is_applicable);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN for the workload.</p>
    pub workload_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys. Existing tags of the resource
    /// whose keys are members of this list are removed from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("workload_arn", &self.workload_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN for the workload.</p>
    pub workload_arn: std::option::Option<std::string::String>,
    /// <p>The tags for the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("workload_arn", &self.workload_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Input for List Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkloadSharesInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
    pub shared_with_prefix: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListWorkloadSharesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkloadSharesInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("shared_with_prefix", &self.shared_with_prefix);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to list all workloads.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkloadsInput {
    /// <p>An optional string added to the beginning of each workload name returned in the
    /// results.</p>
    pub workload_name_prefix: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListWorkloadsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkloadsInput");
        formatter.field("workload_name_prefix", &self.workload_name_prefix);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN for the workload.</p>
    pub workload_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("workload_arn", &self.workload_arn);
        formatter.finish()
    }
}

/// <p>Input for List Share Invitations</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListShareInvitationsInput {
    /// <p>An optional string added to the beginning of each workload name returned in the
    /// results.</p>
    pub workload_name_prefix: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListShareInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListShareInvitationsInput");
        formatter.field("workload_name_prefix", &self.workload_name_prefix);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationsInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationsInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to list all milestones for a workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMilestonesInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListMilestonesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMilestonesInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to list lens reviews.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLensReviewsInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListLensReviewsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLensReviewsInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to list lens review improvements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLensReviewImprovementsInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListLensReviewImprovementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLensReviewImprovementsInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to list lenses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLensesInput {
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListLensesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLensesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to list answers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnswersInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ID used to identify a pillar, for example, <code>security</code>.</p>
    /// <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
    /// <p>The token to use to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return for this request.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListAnswersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnswersInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("pillar_id", &self.pillar_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Input to get a workload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkloadInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetWorkloadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkloadInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.finish()
    }
}

/// <p>Input to get a milestone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMilestoneInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
}
impl std::fmt::Debug for GetMilestoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMilestoneInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLensVersionDifferenceInput {
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The base version of the lens.</p>
    pub base_lens_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLensVersionDifferenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLensVersionDifferenceInput");
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("base_lens_version", &self.base_lens_version);
        formatter.finish()
    }
}

/// <p>Input to get lens review report.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLensReviewReportInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
}
impl std::fmt::Debug for GetLensReviewReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLensReviewReportInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.finish()
    }
}

/// <p>Input to get lens review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLensReviewInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
}
impl std::fmt::Debug for GetLensReviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLensReviewInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.finish()
    }
}

/// <p>Input to get answer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnswerInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The alias of the lens, for example, <code>serverless</code>.</p>
    /// <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lens_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the question.</p>
    pub question_id: std::option::Option<std::string::String>,
    /// <p>The milestone number.</p>
    /// <p>A workload can have a maximum of 100 milestones.</p>
    pub milestone_number: i32,
}
impl std::fmt::Debug for GetAnswerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnswerInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_alias", &self.lens_alias);
        formatter.field("question_id", &self.question_id);
        formatter.field("milestone_number", &self.milestone_number);
        formatter.finish()
    }
}

/// <p>Input to disassociate lens reviews.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLensesInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>List of lens aliases to associate or disassociate with a workload.</p>
    /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
    pub lens_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DisassociateLensesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLensesInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_aliases", &self.lens_aliases);
        formatter.finish()
    }
}

/// <p>Input for Delete Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkloadShareInput {
    /// <p>The ID associated with the workload share.</p>
    pub share_id: std::option::Option<std::string::String>,
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure that this request is idempotent
    /// (executes only once).</p>
    /// <p>You should not reuse the same token for other requests. If you retry a request with
    /// the same client request token and the same parameters after it has completed
    /// successfully, the result of the original request is returned. </p>
    /// <important>
    /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
    /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
    /// you must provide this token or the request will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteWorkloadShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkloadShareInput");
        formatter.field("share_id", &self.share_id);
        formatter.field("workload_id", &self.workload_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

/// <p>Input for workload deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkloadInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure that this request is idempotent
    /// (executes only once).</p>
    /// <p>You should not reuse the same token for other requests. If you retry a request with
    /// the same client request token and the same parameters after it has completed
    /// successfully, the result of the original request is returned. </p>
    /// <important>
    /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
    /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
    /// you must provide this token or the request will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteWorkloadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkloadInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

/// <p>Input for Create Workload Share</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkloadShareInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The AWS account ID or IAM role with which the workload is shared.</p>
    pub shared_with: std::option::Option<std::string::String>,
    /// <p>Permission granted on a workload share.</p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>A unique case-sensitive string used to ensure that this request is idempotent
    /// (executes only once).</p>
    /// <p>You should not reuse the same token for other requests. If you retry a request with
    /// the same client request token and the same parameters after it has completed
    /// successfully, the result of the original request is returned. </p>
    /// <important>
    /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
    /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
    /// you must provide this token or the request will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateWorkloadShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkloadShareInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("shared_with", &self.shared_with);
        formatter.field("permission_type", &self.permission_type);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

/// <p>Input for workload creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkloadInput {
    /// <p>The name of the workload.</p>
    /// <p>The name must be unique within an account within a Region. Spaces and capitalization
    /// are ignored when checking for uniqueness.</p>
    pub workload_name: std::option::Option<std::string::String>,
    /// <p>The description for the workload.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The environment for the workload.</p>
    pub environment: std::option::Option<crate::model::WorkloadEnvironment>,
    /// <p>The list of AWS account IDs associated with the workload.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of AWS Regions associated with the workload, for example,
    /// <code>us-east-2</code>, or <code>ca-central-1</code>.</p>
    pub aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The list of non-AWS Regions associated with the workload.</p>
    pub non_aws_regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The priorities of the pillars, which are used to order items in the improvement plan.
    /// Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>
    pub pillar_priorities: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The URL of the architectural design for the workload.</p>
    pub architectural_design: std::option::Option<std::string::String>,
    /// <p>The review owner of the workload. The name, email address, or identifier for the
    /// primary group or individual that owns the workload review process.</p>
    pub review_owner: std::option::Option<std::string::String>,
    /// <p>The industry type for the workload.</p>
    /// <p>If specified, must be one of the following:</p>  
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Agriculture</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Automobile</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Defense</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Design and Engineering</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Digital Advertising</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Education</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Environmental Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Financial Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Gaming</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>General Public Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Healthcare</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Hospitality</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InfoTech</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Justice and Public Safety</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Life Sciences</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Manufacturing</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Media & Entertainment</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Mining & Resources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Oil & Gas</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Power & Utilities</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Professional Services</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Real Estate & Construction</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Retail & Wholesale</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Social Protection</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Telecommunications</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Travel, Transportation & Logistics</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Other</code>
    /// </p>
    /// </li>
    /// </ul>
    pub industry_type: std::option::Option<std::string::String>,
    /// <p>The industry for the workload.</p>
    pub industry: std::option::Option<std::string::String>,
    /// <p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>
    pub lenses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The notes associated with the workload.</p>
    pub notes: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure that this request is idempotent
    /// (executes only once).</p>
    /// <p>You should not reuse the same token for other requests. If you retry a request with
    /// the same client request token and the same parameters after it has completed
    /// successfully, the result of the original request is returned. </p>
    /// <important>
    /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
    /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
    /// you must provide this token or the request will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The tags to be associated with the workload.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateWorkloadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkloadInput");
        formatter.field("workload_name", &self.workload_name);
        formatter.field("description", &self.description);
        formatter.field("environment", &self.environment);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("aws_regions", &self.aws_regions);
        formatter.field("non_aws_regions", &self.non_aws_regions);
        formatter.field("pillar_priorities", &self.pillar_priorities);
        formatter.field("architectural_design", &self.architectural_design);
        formatter.field("review_owner", &self.review_owner);
        formatter.field("industry_type", &self.industry_type);
        formatter.field("industry", &self.industry);
        formatter.field("lenses", &self.lenses);
        formatter.field("notes", &self.notes);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Input for milestone creation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMilestoneInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>The name of the milestone in a workload.</p>
    /// <p>Milestone names must be unique within a workload.</p>
    pub milestone_name: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure that this request is idempotent
    /// (executes only once).</p>
    /// <p>You should not reuse the same token for other requests. If you retry a request with
    /// the same client request token and the same parameters after it has completed
    /// successfully, the result of the original request is returned. </p>
    /// <important>
    /// <p>This token is listed as required, however, if you do not specify it, the AWS SDKs
    /// automatically generate one for you. If you are not using the AWS SDK or the AWS CLI,
    /// you must provide this token or the request will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateMilestoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMilestoneInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("milestone_name", &self.milestone_name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

/// <p>Input to associate lens reviews.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLensesInput {
    /// <p>The ID assigned to the workload. This ID is unique within an AWS Region.</p>
    pub workload_id: std::option::Option<std::string::String>,
    /// <p>List of lens aliases to associate or disassociate with a workload.</p>
    /// <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>
    pub lens_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AssociateLensesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLensesInput");
        formatter.field("workload_id", &self.workload_id);
        formatter.field("lens_aliases", &self.lens_aliases);
        formatter.finish()
    }
}
