// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateLenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateLensesError {
    /// Kind of error that occurred.
    pub kind: AssociateLensesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateLenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateLensesErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateLensesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateLensesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateLensesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateLensesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateLensesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateLensesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateLensesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateLensesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateLensesError {
    fn code(&self) -> Option<&str> {
        AssociateLensesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateLensesError {
    /// Creates a new `AssociateLensesError`.
    pub fn new(kind: AssociateLensesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateLensesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateLensesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateLensesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateLensesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateLensesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLensesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `AssociateLensesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AssociateLensesErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `AssociateLensesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLensesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `AssociateLensesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLensesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AssociateLensesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AssociateLensesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `AssociateLensesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AssociateLensesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AssociateLensesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateLensesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateLensesErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateLensesErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateLensesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateLensesErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateLensesErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateLensesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMilestone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMilestoneError {
    /// Kind of error that occurred.
    pub kind: CreateMilestoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMilestone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMilestoneErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has reached their resource quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMilestoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMilestoneErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateMilestoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMilestoneError {
    fn code(&self) -> Option<&str> {
        CreateMilestoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMilestoneError {
    /// Creates a new `CreateMilestoneError`.
    pub fn new(kind: CreateMilestoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMilestoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMilestoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMilestoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMilestoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMilestoneErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateMilestoneErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMilestoneErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMilestoneErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMilestoneErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateMilestoneErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateMilestoneErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateMilestoneErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateMilestoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMilestoneErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::ValidationException(_inner) => Some(_inner),
            CreateMilestoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkloadError {
    /// Kind of error that occurred.
    pub kind: CreateWorkloadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkloadErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The user has reached their resource quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkloadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkloadErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkloadErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWorkloadErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWorkloadErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateWorkloadErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWorkloadErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWorkloadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkloadError {
    fn code(&self) -> Option<&str> {
        CreateWorkloadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkloadError {
    /// Creates a new `CreateWorkloadError`.
    pub fn new(kind: CreateWorkloadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkloadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkloadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkloadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkloadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateWorkloadErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkloadErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateWorkloadErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkloadErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateWorkloadErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkloadErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateWorkloadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkloadErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkloadErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWorkloadErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWorkloadErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateWorkloadErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWorkloadErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWorkloadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkloadShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkloadShareError {
    /// Kind of error that occurred.
    pub kind: CreateWorkloadShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkloadShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkloadShareErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has reached their resource quota.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkloadShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkloadShareErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWorkloadShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkloadShareError {
    fn code(&self) -> Option<&str> {
        CreateWorkloadShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkloadShareError {
    /// Creates a new `CreateWorkloadShareError`.
    pub fn new(kind: CreateWorkloadShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkloadShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkloadShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkloadShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkloadShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkloadShareErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkloadShareErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateWorkloadShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkloadShareErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWorkloadShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkloadError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkloadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkloadErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkloadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkloadErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkloadErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteWorkloadErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWorkloadErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkloadErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWorkloadErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWorkloadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkloadError {
    fn code(&self) -> Option<&str> {
        DeleteWorkloadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkloadError {
    /// Creates a new `DeleteWorkloadError`.
    pub fn new(kind: DeleteWorkloadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkloadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkloadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkloadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkloadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteWorkloadErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkloadErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteWorkloadErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkloadErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteWorkloadErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkloadErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteWorkloadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkloadErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkloadErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteWorkloadErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWorkloadErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkloadErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWorkloadErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWorkloadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkloadShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkloadShareError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkloadShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkloadShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkloadShareErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkloadShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkloadShareErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkloadShareErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteWorkloadShareErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWorkloadShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkloadShareErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWorkloadShareErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWorkloadShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkloadShareError {
    fn code(&self) -> Option<&str> {
        DeleteWorkloadShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkloadShareError {
    /// Creates a new `DeleteWorkloadShareError`.
    pub fn new(kind: DeleteWorkloadShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkloadShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkloadShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkloadShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkloadShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteWorkloadShareErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadShareErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadShareErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadShareErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadShareErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadShareErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadShareErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadShareErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadShareErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkloadShareErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkloadShareErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteWorkloadShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkloadShareErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkloadShareErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteWorkloadShareErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWorkloadShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkloadShareErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWorkloadShareErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWorkloadShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateLenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateLensesError {
    /// Kind of error that occurred.
    pub kind: DisassociateLensesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateLenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateLensesErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateLensesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateLensesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateLensesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateLensesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateLensesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateLensesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateLensesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateLensesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateLensesError {
    fn code(&self) -> Option<&str> {
        DisassociateLensesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateLensesError {
    /// Creates a new `DisassociateLensesError`.
    pub fn new(kind: DisassociateLensesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateLensesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateLensesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateLensesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateLensesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateLensesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLensesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateLensesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLensesErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateLensesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLensesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateLensesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLensesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateLensesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLensesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateLensesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLensesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateLensesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateLensesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateLensesErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateLensesErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateLensesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateLensesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateLensesErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateLensesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAnswer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAnswerError {
    /// Kind of error that occurred.
    pub kind: GetAnswerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAnswer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAnswerErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAnswerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAnswerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAnswerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAnswerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAnswerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAnswerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAnswerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAnswerError {
    fn code(&self) -> Option<&str> {
        GetAnswerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAnswerError {
    /// Creates a new `GetAnswerError`.
    pub fn new(kind: GetAnswerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAnswerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAnswerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAnswerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAnswerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetAnswerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetAnswerErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetAnswerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetAnswerErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetAnswerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAnswerErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetAnswerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetAnswerErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetAnswerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetAnswerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetAnswerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAnswerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAnswerErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAnswerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAnswerErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAnswerErrorKind::ValidationException(_inner) => Some(_inner),
            GetAnswerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLensReview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLensReviewError {
    /// Kind of error that occurred.
    pub kind: GetLensReviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLensReview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLensReviewErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLensReviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLensReviewErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLensReviewErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLensReviewErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLensReviewErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLensReviewErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLensReviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLensReviewError {
    fn code(&self) -> Option<&str> {
        GetLensReviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLensReviewError {
    /// Creates a new `GetLensReviewError`.
    pub fn new(kind: GetLensReviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLensReviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLensReviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLensReviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLensReviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLensReviewErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetLensReviewErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetLensReviewErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetLensReviewErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLensReviewErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetLensReviewErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetLensReviewErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetLensReviewErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetLensReviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLensReviewErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLensReviewErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLensReviewErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLensReviewErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLensReviewErrorKind::ValidationException(_inner) => Some(_inner),
            GetLensReviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLensReviewReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLensReviewReportError {
    /// Kind of error that occurred.
    pub kind: GetLensReviewReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLensReviewReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLensReviewReportErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLensReviewReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLensReviewReportErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLensReviewReportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLensReviewReportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLensReviewReportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLensReviewReportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLensReviewReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLensReviewReportError {
    fn code(&self) -> Option<&str> {
        GetLensReviewReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLensReviewReportError {
    /// Creates a new `GetLensReviewReportError`.
    pub fn new(kind: GetLensReviewReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLensReviewReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLensReviewReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLensReviewReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLensReviewReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLensReviewReportErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewReportErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLensReviewReportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewReportErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetLensReviewReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewReportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLensReviewReportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewReportErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetLensReviewReportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensReviewReportErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLensReviewReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLensReviewReportErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLensReviewReportErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLensReviewReportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLensReviewReportErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLensReviewReportErrorKind::ValidationException(_inner) => Some(_inner),
            GetLensReviewReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLensVersionDifference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLensVersionDifferenceError {
    /// Kind of error that occurred.
    pub kind: GetLensVersionDifferenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLensVersionDifference` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLensVersionDifferenceErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLensVersionDifferenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLensVersionDifferenceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLensVersionDifferenceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetLensVersionDifferenceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLensVersionDifferenceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetLensVersionDifferenceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLensVersionDifferenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLensVersionDifferenceError {
    fn code(&self) -> Option<&str> {
        GetLensVersionDifferenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLensVersionDifferenceError {
    /// Creates a new `GetLensVersionDifferenceError`.
    pub fn new(kind: GetLensVersionDifferenceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLensVersionDifferenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLensVersionDifferenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLensVersionDifferenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLensVersionDifferenceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetLensVersionDifferenceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensVersionDifferenceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetLensVersionDifferenceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensVersionDifferenceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetLensVersionDifferenceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensVersionDifferenceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetLensVersionDifferenceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensVersionDifferenceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `GetLensVersionDifferenceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLensVersionDifferenceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLensVersionDifferenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLensVersionDifferenceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLensVersionDifferenceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetLensVersionDifferenceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLensVersionDifferenceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetLensVersionDifferenceErrorKind::ValidationException(_inner) => Some(_inner),
            GetLensVersionDifferenceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMilestone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMilestoneError {
    /// Kind of error that occurred.
    pub kind: GetMilestoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMilestone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMilestoneErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMilestoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMilestoneErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMilestoneErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMilestoneErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMilestoneErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMilestoneErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMilestoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMilestoneError {
    fn code(&self) -> Option<&str> {
        GetMilestoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMilestoneError {
    /// Creates a new `GetMilestoneError`.
    pub fn new(kind: GetMilestoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMilestoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMilestoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMilestoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMilestoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetMilestoneErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetMilestoneErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetMilestoneErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMilestoneErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetMilestoneErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMilestoneErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetMilestoneErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMilestoneErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetMilestoneErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetMilestoneErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetMilestoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMilestoneErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMilestoneErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMilestoneErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMilestoneErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMilestoneErrorKind::ValidationException(_inner) => Some(_inner),
            GetMilestoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkloadError {
    /// Kind of error that occurred.
    pub kind: GetWorkloadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkloadErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkloadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkloadErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetWorkloadErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWorkloadErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetWorkloadErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetWorkloadErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetWorkloadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkloadError {
    fn code(&self) -> Option<&str> {
        GetWorkloadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkloadError {
    /// Creates a new `GetWorkloadError`.
    pub fn new(kind: GetWorkloadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkloadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkloadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkloadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkloadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetWorkloadErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetWorkloadErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetWorkloadErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetWorkloadErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetWorkloadErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkloadErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetWorkloadErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetWorkloadErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `GetWorkloadErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetWorkloadErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetWorkloadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkloadErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetWorkloadErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWorkloadErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetWorkloadErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetWorkloadErrorKind::ValidationException(_inner) => Some(_inner),
            GetWorkloadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnswers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnswersError {
    /// Kind of error that occurred.
    pub kind: ListAnswersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnswers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnswersErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnswersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnswersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAnswersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAnswersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAnswersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAnswersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAnswersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnswersError {
    fn code(&self) -> Option<&str> {
        ListAnswersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnswersError {
    /// Creates a new `ListAnswersError`.
    pub fn new(kind: ListAnswersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnswersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnswersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnswersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnswersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAnswersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListAnswersErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListAnswersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListAnswersErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `ListAnswersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnswersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAnswersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListAnswersErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListAnswersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListAnswersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListAnswersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnswersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAnswersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAnswersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAnswersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAnswersErrorKind::ValidationException(_inner) => Some(_inner),
            ListAnswersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLensesError {
    /// Kind of error that occurred.
    pub kind: ListLensesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLensesErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLensesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLensesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLensesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListLensesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLensesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLensesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLensesError {
    fn code(&self) -> Option<&str> {
        ListLensesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLensesError {
    /// Creates a new `ListLensesError`.
    pub fn new(kind: ListLensesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLensesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLensesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLensesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLensesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLensesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListLensesErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListLensesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListLensesErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `ListLensesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListLensesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListLensesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListLensesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListLensesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLensesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLensesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListLensesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLensesErrorKind::ValidationException(_inner) => Some(_inner),
            ListLensesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLensReviewImprovements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLensReviewImprovementsError {
    /// Kind of error that occurred.
    pub kind: ListLensReviewImprovementsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLensReviewImprovements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLensReviewImprovementsErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLensReviewImprovementsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLensReviewImprovementsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLensReviewImprovementsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListLensReviewImprovementsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLensReviewImprovementsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLensReviewImprovementsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLensReviewImprovementsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLensReviewImprovementsError {
    fn code(&self) -> Option<&str> {
        ListLensReviewImprovementsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLensReviewImprovementsError {
    /// Creates a new `ListLensReviewImprovementsError`.
    pub fn new(kind: ListLensReviewImprovementsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLensReviewImprovementsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLensReviewImprovementsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLensReviewImprovementsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLensReviewImprovementsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLensReviewImprovementsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewImprovementsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewImprovementsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewImprovementsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewImprovementsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewImprovementsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewImprovementsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewImprovementsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewImprovementsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewImprovementsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListLensReviewImprovementsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLensReviewImprovementsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLensReviewImprovementsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListLensReviewImprovementsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLensReviewImprovementsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLensReviewImprovementsErrorKind::ValidationException(_inner) => Some(_inner),
            ListLensReviewImprovementsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLensReviews` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLensReviewsError {
    /// Kind of error that occurred.
    pub kind: ListLensReviewsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLensReviews` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLensReviewsErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLensReviewsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLensReviewsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLensReviewsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListLensReviewsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLensReviewsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLensReviewsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLensReviewsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLensReviewsError {
    fn code(&self) -> Option<&str> {
        ListLensReviewsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLensReviewsError {
    /// Creates a new `ListLensReviewsError`.
    pub fn new(kind: ListLensReviewsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLensReviewsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLensReviewsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLensReviewsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLensReviewsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListLensReviewsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLensReviewsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListLensReviewsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListLensReviewsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListLensReviewsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListLensReviewsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListLensReviewsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLensReviewsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLensReviewsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListLensReviewsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLensReviewsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLensReviewsErrorKind::ValidationException(_inner) => Some(_inner),
            ListLensReviewsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMilestones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMilestonesError {
    /// Kind of error that occurred.
    pub kind: ListMilestonesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMilestones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMilestonesErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMilestonesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMilestonesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMilestonesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListMilestonesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMilestonesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMilestonesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListMilestonesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMilestonesError {
    fn code(&self) -> Option<&str> {
        ListMilestonesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMilestonesError {
    /// Creates a new `ListMilestonesError`.
    pub fn new(kind: ListMilestonesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMilestonesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMilestonesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMilestonesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMilestonesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListMilestonesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMilestonesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListMilestonesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMilestonesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListMilestonesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMilestonesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListMilestonesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListMilestonesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListMilestonesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListMilestonesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListMilestonesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMilestonesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMilestonesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListMilestonesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMilestonesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMilestonesErrorKind::ValidationException(_inner) => Some(_inner),
            ListMilestonesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNotificationsError {
    /// Kind of error that occurred.
    pub kind: ListNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNotificationsErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNotificationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNotificationsError {
    fn code(&self) -> Option<&str> {
        ListNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNotificationsError {
    /// Creates a new `ListNotificationsError`.
    pub fn new(kind: ListNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListNotificationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListNotificationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListNotificationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListNotificationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNotificationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNotificationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNotificationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNotificationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListShareInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListShareInvitationsError {
    /// Kind of error that occurred.
    pub kind: ListShareInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListShareInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListShareInvitationsErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListShareInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListShareInvitationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListShareInvitationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListShareInvitationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListShareInvitationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListShareInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListShareInvitationsError {
    fn code(&self) -> Option<&str> {
        ListShareInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListShareInvitationsError {
    /// Creates a new `ListShareInvitationsError`.
    pub fn new(kind: ListShareInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListShareInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListShareInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListShareInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListShareInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListShareInvitationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListShareInvitationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListShareInvitationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListShareInvitationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListShareInvitationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListShareInvitationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListShareInvitationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListShareInvitationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListShareInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListShareInvitationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListShareInvitationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListShareInvitationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListShareInvitationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListShareInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkloads` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkloadsError {
    /// Kind of error that occurred.
    pub kind: ListWorkloadsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkloads` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkloadsErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkloadsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkloadsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListWorkloadsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWorkloadsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWorkloadsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWorkloadsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkloadsError {
    fn code(&self) -> Option<&str> {
        ListWorkloadsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkloadsError {
    /// Creates a new `ListWorkloadsError`.
    pub fn new(kind: ListWorkloadsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkloadsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkloadsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkloadsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkloadsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListWorkloadsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListWorkloadsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListWorkloadsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkloadsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListWorkloadsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListWorkloadsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListWorkloadsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListWorkloadsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListWorkloadsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkloadsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListWorkloadsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWorkloadsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWorkloadsErrorKind::ValidationException(_inner) => Some(_inner),
            ListWorkloadsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkloadShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkloadSharesError {
    /// Kind of error that occurred.
    pub kind: ListWorkloadSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkloadShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkloadSharesErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkloadSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkloadSharesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListWorkloadSharesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWorkloadSharesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListWorkloadSharesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWorkloadSharesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListWorkloadSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkloadSharesError {
    fn code(&self) -> Option<&str> {
        ListWorkloadSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkloadSharesError {
    /// Creates a new `ListWorkloadSharesError`.
    pub fn new(kind: ListWorkloadSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkloadSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkloadSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkloadSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkloadSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListWorkloadSharesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkloadSharesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListWorkloadSharesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkloadSharesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListWorkloadSharesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkloadSharesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListWorkloadSharesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkloadSharesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListWorkloadSharesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkloadSharesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListWorkloadSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkloadSharesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListWorkloadSharesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWorkloadSharesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListWorkloadSharesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWorkloadSharesErrorKind::ValidationException(_inner) => Some(_inner),
            ListWorkloadSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAnswer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAnswerError {
    /// Kind of error that occurred.
    pub kind: UpdateAnswerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAnswer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAnswerErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAnswerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAnswerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAnswerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateAnswerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAnswerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAnswerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAnswerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAnswerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAnswerError {
    fn code(&self) -> Option<&str> {
        UpdateAnswerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAnswerError {
    /// Creates a new `UpdateAnswerError`.
    pub fn new(kind: UpdateAnswerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAnswerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAnswerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAnswerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAnswerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateAnswerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateAnswerErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateAnswerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateAnswerErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateAnswerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnswerErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAnswerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnswerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateAnswerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateAnswerErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UpdateAnswerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateAnswerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateAnswerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAnswerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAnswerErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateAnswerErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAnswerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAnswerErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAnswerErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAnswerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLensReview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLensReviewError {
    /// Kind of error that occurred.
    pub kind: UpdateLensReviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLensReview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLensReviewErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLensReviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLensReviewErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLensReviewErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateLensReviewErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateLensReviewErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateLensReviewErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateLensReviewErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateLensReviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLensReviewError {
    fn code(&self) -> Option<&str> {
        UpdateLensReviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLensReviewError {
    /// Creates a new `UpdateLensReviewError`.
    pub fn new(kind: UpdateLensReviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLensReviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLensReviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLensReviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLensReviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateLensReviewErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLensReviewErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLensReviewErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateLensReviewErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateLensReviewErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLensReviewErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLensReviewErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLensReviewErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLensReviewErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLensReviewErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateLensReviewErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLensReviewErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLensReviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLensReviewErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLensReviewErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateLensReviewErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateLensReviewErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateLensReviewErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateLensReviewErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateLensReviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateShareInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateShareInvitationError {
    /// Kind of error that occurred.
    pub kind: UpdateShareInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateShareInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateShareInvitationErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateShareInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateShareInvitationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateShareInvitationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateShareInvitationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateShareInvitationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateShareInvitationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateShareInvitationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateShareInvitationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateShareInvitationError {
    fn code(&self) -> Option<&str> {
        UpdateShareInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateShareInvitationError {
    /// Creates a new `UpdateShareInvitationError`.
    pub fn new(kind: UpdateShareInvitationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateShareInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateShareInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateShareInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateShareInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateShareInvitationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShareInvitationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateShareInvitationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShareInvitationErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateShareInvitationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShareInvitationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateShareInvitationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShareInvitationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateShareInvitationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShareInvitationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateShareInvitationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateShareInvitationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateShareInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateShareInvitationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateShareInvitationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateShareInvitationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateShareInvitationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateShareInvitationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateShareInvitationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateShareInvitationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkloadError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkloadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkloadErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkloadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkloadErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkloadErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateWorkloadErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWorkloadErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkloadErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWorkloadErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWorkloadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkloadError {
    fn code(&self) -> Option<&str> {
        UpdateWorkloadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkloadError {
    /// Creates a new `UpdateWorkloadError`.
    pub fn new(kind: UpdateWorkloadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkloadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkloadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkloadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkloadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateWorkloadErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkloadErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpdateWorkloadErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkloadErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UpdateWorkloadErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkloadErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateWorkloadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkloadErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkloadErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateWorkloadErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkloadErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWorkloadErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWorkloadErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWorkloadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkloadShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkloadShareError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkloadShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkloadShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkloadShareErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkloadShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkloadShareErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkloadShareErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateWorkloadShareErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWorkloadShareErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkloadShareErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWorkloadShareErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWorkloadShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkloadShareError {
    fn code(&self) -> Option<&str> {
        UpdateWorkloadShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkloadShareError {
    /// Creates a new `UpdateWorkloadShareError`.
    pub fn new(kind: UpdateWorkloadShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkloadShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkloadShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkloadShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkloadShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateWorkloadShareErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadShareErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadShareErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadShareErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadShareErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadShareErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadShareErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadShareErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadShareErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkloadShareErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkloadShareErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateWorkloadShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkloadShareErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkloadShareErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateWorkloadShareErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkloadShareErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWorkloadShareErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWorkloadShareErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWorkloadShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpgradeLensReview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpgradeLensReviewError {
    /// Kind of error that occurred.
    pub kind: UpgradeLensReviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpgradeLensReview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpgradeLensReviewErrorKind {
    /// <p>User does not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The resource already exists.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Request was denied due to request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input is not valid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpgradeLensReviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpgradeLensReviewErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpgradeLensReviewErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpgradeLensReviewErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpgradeLensReviewErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpgradeLensReviewErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpgradeLensReviewErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpgradeLensReviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpgradeLensReviewError {
    fn code(&self) -> Option<&str> {
        UpgradeLensReviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpgradeLensReviewError {
    /// Creates a new `UpgradeLensReviewError`.
    pub fn new(kind: UpgradeLensReviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpgradeLensReviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpgradeLensReviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpgradeLensReviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpgradeLensReviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpgradeLensReviewErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeLensReviewErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeLensReviewErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpgradeLensReviewErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UpgradeLensReviewErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeLensReviewErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeLensReviewErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeLensReviewErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeLensReviewErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeLensReviewErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpgradeLensReviewErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpgradeLensReviewErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpgradeLensReviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpgradeLensReviewErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpgradeLensReviewErrorKind::ConflictException(_inner) => Some(_inner),
            UpgradeLensReviewErrorKind::InternalServerException(_inner) => Some(_inner),
            UpgradeLensReviewErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpgradeLensReviewErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpgradeLensReviewErrorKind::ValidationException(_inner) => Some(_inner),
            UpgradeLensReviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The user input is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason why the request failed validation.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The fields that caused the error, if applicable.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason why the request failed validation.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason why the request failed validation.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The fields that caused the error, if applicable.</p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>The fields that caused the error, if applicable.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Request was denied due to request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Service Quotas requirement to identify originating quota.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>Service Quotas requirement to identify originating service.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Service Quotas requirement to identify originating quota.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Service Quotas requirement to identify originating quota.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>Service Quotas requirement to identify originating service.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Service Quotas requirement to identify originating service.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The requested resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource affected.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource affected.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>There is a problem with the AWS Well-Architected Tool API service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource affected.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource affected.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>User does not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The user has reached their resource quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// <p>Description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Identifier of the resource affected.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of the resource affected.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>Service Quotas requirement to identify originating quota.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>Service Quotas requirement to identify originating service.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Identifier of the resource affected.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Type of the resource affected.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Service Quotas requirement to identify originating quota.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>Service Quotas requirement to identify originating quota.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>Service Quotas requirement to identify originating service.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>Service Quotas requirement to identify originating service.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
