// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS WAFV2
///
/// Client for invoking operations on AWS WAFV2. Each operation on AWS WAFV2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_wafv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_wafv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_wafv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateWebACL`](crate::client::fluent_builders::AssociateWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateWebACL::web_acl_arn) / [`set_web_acl_arn(Option<String>)`](crate::client::fluent_builders::AssociateWebACL::set_web_acl_arn): <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateWebACL::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::AssociateWebACL::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p>  <p>The ARN must be in one of the following formats:</p>  <ul>   <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>   <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>   <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>  </ul>
    /// - On success, responds with [`AssociateWebAclOutput`](crate::output::AssociateWebAclOutput)

    /// - On failure, responds with [`SdkError<AssociateWebACLError>`](crate::error::AssociateWebACLError)
    pub fn associate_web_acl(&self) -> fluent_builders::AssociateWebACL {
        fluent_builders::AssociateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckCapacity`](crate::client::fluent_builders::CheckCapacity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::CheckCapacity::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::CheckCapacity::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::CheckCapacity::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::CheckCapacity::set_rules): <p>An array of <code>Rule</code> that you're configuring to use in a rule group or web ACL. </p>
    /// - On success, responds with [`CheckCapacityOutput`](crate::output::CheckCapacityOutput) with field(s):
    ///   - [`capacity(i64)`](crate::output::CheckCapacityOutput::capacity): <p>The capacity required by the rules and scope.</p>
    /// - On failure, responds with [`SdkError<CheckCapacityError>`](crate::error::CheckCapacityError)
    pub fn check_capacity(&self) -> fluent_builders::CheckCapacity {
        fluent_builders::CheckCapacity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIPSet`](crate::client::fluent_builders::CreateIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateIPSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateIPSet::set_name): <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::CreateIPSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::CreateIPSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateIPSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateIPSet::set_description): <p>A description of the IP set that helps with identification. </p>
    ///   - [`ip_address_version(IpAddressVersion)`](crate::client::fluent_builders::CreateIPSet::ip_address_version) / [`set_ip_address_version(Option<IpAddressVersion>)`](crate::client::fluent_builders::CreateIPSet::set_ip_address_version): <p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>
    ///   - [`addresses(Vec<String>)`](crate::client::fluent_builders::CreateIPSet::addresses) / [`set_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::CreateIPSet::set_addresses): <p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>  <p>Example address strings: </p>  <ul>   <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>   <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>   <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>   <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>  </ul>  <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>  <p>Example JSON <code>Addresses</code> specifications: </p>  <ul>   <li> <p>Empty array: <code>"Addresses": []</code> </p> </li>   <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li>   <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li>   <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateIPSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateIPSet::set_tags): <p>An array of key:value pairs to associate with the resource.</p>
    /// - On success, responds with [`CreateIpSetOutput`](crate::output::CreateIpSetOutput) with field(s):
    ///   - [`summary(Option<IpSetSummary>)`](crate::output::CreateIpSetOutput::summary): <p>High-level information about an <code>IPSet</code>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage an <code>IPSet</code>, and the ARN, that you provide to the <code>IPSetReferenceStatement</code> to use the address set in a <code>Rule</code>.</p>
    /// - On failure, responds with [`SdkError<CreateIPSetError>`](crate::error::CreateIPSetError)
    pub fn create_ip_set(&self) -> fluent_builders::CreateIPSet {
        fluent_builders::CreateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRegexPatternSet`](crate::client::fluent_builders::CreateRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_name): <p>The name of the set. You cannot change the name after you create the set.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::CreateRegexPatternSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_description): <p>A description of the set that helps with identification. </p>
    ///   - [`regular_expression_list(Vec<Regex>)`](crate::client::fluent_builders::CreateRegexPatternSet::regular_expression_list) / [`set_regular_expression_list(Option<Vec<Regex>>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_regular_expression_list): <p>Array of regular expression strings. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRegexPatternSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_tags): <p>An array of key:value pairs to associate with the resource.</p>
    /// - On success, responds with [`CreateRegexPatternSetOutput`](crate::output::CreateRegexPatternSetOutput) with field(s):
    ///   - [`summary(Option<RegexPatternSetSummary>)`](crate::output::CreateRegexPatternSetOutput::summary): <p>High-level information about a <code>RegexPatternSet</code>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RegexPatternSet</code>, and the ARN, that you provide to the <code>RegexPatternSetReferenceStatement</code> to use the pattern set in a <code>Rule</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRegexPatternSetError>`](crate::error::CreateRegexPatternSetError)
    pub fn create_regex_pattern_set(&self) -> fluent_builders::CreateRegexPatternSet {
        fluent_builders::CreateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRuleGroup`](crate::client::fluent_builders::CreateRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_name): <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::CreateRuleGroup::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::CreateRuleGroup::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`capacity(i64)`](crate::client::fluent_builders::CreateRuleGroup::capacity) / [`set_capacity(i64)`](crate::client::fluent_builders::CreateRuleGroup::set_capacity): <p>The web ACL capacity units (WCUs) required for this rule group.</p>  <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <code>CheckCapacity</code>.</p>  <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_description): <p>A description of the rule group that helps with identification. </p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::CreateRuleGroup::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::CreateRuleGroup::set_rules): <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
    ///   - [`visibility_config(VisibilityConfig)`](crate::client::fluent_builders::CreateRuleGroup::visibility_config) / [`set_visibility_config(Option<VisibilityConfig>)`](crate::client::fluent_builders::CreateRuleGroup::set_visibility_config): <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRuleGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRuleGroup::set_tags): <p>An array of key:value pairs to associate with the resource.</p>
    ///   - [`custom_response_bodies(HashMap<String, CustomResponseBody>)`](crate::client::fluent_builders::CreateRuleGroup::custom_response_bodies) / [`set_custom_response_bodies(Option<HashMap<String, CustomResponseBody>>)`](crate::client::fluent_builders::CreateRuleGroup::set_custom_response_bodies): <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>  <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>  <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
    /// - On success, responds with [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput) with field(s):
    ///   - [`summary(Option<RuleGroupSummary>)`](crate::output::CreateRuleGroupOutput::summary): <p>High-level information about a <code>RuleGroup</code>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>RuleGroup</code>, and the ARN, that you provide to the <code>RuleGroupReferenceStatement</code> to use the rule group in a <code>Rule</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRuleGroupError>`](crate::error::CreateRuleGroupError)
    pub fn create_rule_group(&self) -> fluent_builders::CreateRuleGroup {
        fluent_builders::CreateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWebACL`](crate::client::fluent_builders::CreateWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateWebACL::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateWebACL::set_name): <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::CreateWebACL::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::CreateWebACL::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`default_action(DefaultAction)`](crate::client::fluent_builders::CreateWebACL::default_action) / [`set_default_action(Option<DefaultAction>)`](crate::client::fluent_builders::CreateWebACL::set_default_action): <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWebACL::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWebACL::set_description): <p>A description of the web ACL that helps with identification. </p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::CreateWebACL::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::CreateWebACL::set_rules): <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
    ///   - [`visibility_config(VisibilityConfig)`](crate::client::fluent_builders::CreateWebACL::visibility_config) / [`set_visibility_config(Option<VisibilityConfig>)`](crate::client::fluent_builders::CreateWebACL::set_visibility_config): <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWebACL::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWebACL::set_tags): <p>An array of key:value pairs to associate with the resource.</p>
    ///   - [`custom_response_bodies(HashMap<String, CustomResponseBody>)`](crate::client::fluent_builders::CreateWebACL::custom_response_bodies) / [`set_custom_response_bodies(Option<HashMap<String, CustomResponseBody>>)`](crate::client::fluent_builders::CreateWebACL::set_custom_response_bodies): <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>  <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>  <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
    ///   - [`captcha_config(CaptchaConfig)`](crate::client::fluent_builders::CreateWebACL::captcha_config) / [`set_captcha_config(Option<CaptchaConfig>)`](crate::client::fluent_builders::CreateWebACL::set_captcha_config): <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
    /// - On success, responds with [`CreateWebAclOutput`](crate::output::CreateWebAclOutput) with field(s):
    ///   - [`summary(Option<WebAclSummary>)`](crate::output::CreateWebAclOutput::summary): <p>High-level information about a <code>WebACL</code>, returned by operations like create and list. This provides information like the ID, that you can use to retrieve and manage a <code>WebACL</code>, and the ARN, that you provide to operations like <code>AssociateWebACL</code>.</p>
    /// - On failure, responds with [`SdkError<CreateWebACLError>`](crate::error::CreateWebACLError)
    pub fn create_web_acl(&self) -> fluent_builders::CreateWebACL {
        fluent_builders::CreateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFirewallManagerRuleGroups`](crate::client::fluent_builders::DeleteFirewallManagerRuleGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallManagerRuleGroups::web_acl_arn) / [`set_web_acl_arn(Option<String>)`](crate::client::fluent_builders::DeleteFirewallManagerRuleGroups::set_web_acl_arn): <p>The Amazon Resource Name (ARN) of the web ACL.</p>
    ///   - [`web_acl_lock_token(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallManagerRuleGroups::web_acl_lock_token) / [`set_web_acl_lock_token(Option<String>)`](crate::client::fluent_builders::DeleteFirewallManagerRuleGroups::set_web_acl_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`DeleteFirewallManagerRuleGroupsOutput`](crate::output::DeleteFirewallManagerRuleGroupsOutput) with field(s):
    ///   - [`next_web_acl_lock_token(Option<String>)`](crate::output::DeleteFirewallManagerRuleGroupsOutput::next_web_acl_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<DeleteFirewallManagerRuleGroupsError>`](crate::error::DeleteFirewallManagerRuleGroupsError)
    pub fn delete_firewall_manager_rule_groups(
        &self,
    ) -> fluent_builders::DeleteFirewallManagerRuleGroups {
        fluent_builders::DeleteFirewallManagerRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIPSet`](crate::client::fluent_builders::DeleteIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteIPSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteIPSet::set_name): <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::DeleteIPSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::DeleteIPSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteIPSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteIPSet::set_id): <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::DeleteIPSet::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::DeleteIPSet::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`DeleteIpSetOutput`](crate::output::DeleteIpSetOutput)

    /// - On failure, responds with [`SdkError<DeleteIPSetError>`](crate::error::DeleteIPSetError)
    pub fn delete_ip_set(&self) -> fluent_builders::DeleteIPSet {
        fluent_builders::DeleteIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLoggingConfiguration`](crate::client::fluent_builders::DeleteLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLoggingConfiguration::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteLoggingConfiguration::set_resource_arn): <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
    /// - On success, responds with [`DeleteLoggingConfigurationOutput`](crate::output::DeleteLoggingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteLoggingConfigurationError>`](crate::error::DeleteLoggingConfigurationError)
    pub fn delete_logging_configuration(&self) -> fluent_builders::DeleteLoggingConfiguration {
        fluent_builders::DeleteLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePermissionPolicy`](crate::client::fluent_builders::DeletePermissionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePermissionPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeletePermissionPolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p>  <p>You must be the owner of the rule group to perform this operation.</p>
    /// - On success, responds with [`DeletePermissionPolicyOutput`](crate::output::DeletePermissionPolicyOutput)

    /// - On failure, responds with [`SdkError<DeletePermissionPolicyError>`](crate::error::DeletePermissionPolicyError)
    pub fn delete_permission_policy(&self) -> fluent_builders::DeletePermissionPolicy {
        fluent_builders::DeletePermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRegexPatternSet`](crate::client::fluent_builders::DeleteRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::set_name): <p>The name of the set. You cannot change the name after you create the set.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::DeleteRegexPatternSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::DeleteRegexPatternSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::set_id): <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`DeleteRegexPatternSetOutput`](crate::output::DeleteRegexPatternSetOutput)

    /// - On failure, responds with [`SdkError<DeleteRegexPatternSetError>`](crate::error::DeleteRegexPatternSetError)
    pub fn delete_regex_pattern_set(&self) -> fluent_builders::DeleteRegexPatternSet {
        fluent_builders::DeleteRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRuleGroup`](crate::client::fluent_builders::DeleteRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_name): <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::DeleteRuleGroup::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::DeleteRuleGroup::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_id): <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteRuleGroupError>`](crate::error::DeleteRuleGroupError)
    pub fn delete_rule_group(&self) -> fluent_builders::DeleteRuleGroup {
        fluent_builders::DeleteRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWebACL`](crate::client::fluent_builders::DeleteWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteWebACL::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteWebACL::set_name): <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::DeleteWebACL::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::DeleteWebACL::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteWebACL::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteWebACL::set_id): <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::DeleteWebACL::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::DeleteWebACL::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`DeleteWebAclOutput`](crate::output::DeleteWebAclOutput)

    /// - On failure, responds with [`SdkError<DeleteWebACLError>`](crate::error::DeleteWebACLError)
    pub fn delete_web_acl(&self) -> fluent_builders::DeleteWebACL {
        fluent_builders::DeleteWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeManagedRuleGroup`](crate::client::fluent_builders::DescribeManagedRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vendor_name(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::vendor_name) / [`set_vendor_name(Option<String>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::set_vendor_name): <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::set_name): <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::DescribeManagedRuleGroup::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::DescribeManagedRuleGroup::set_version_name): <p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version. </p>
    /// - On success, responds with [`DescribeManagedRuleGroupOutput`](crate::output::DescribeManagedRuleGroupOutput) with field(s):
    ///   - [`version_name(Option<String>)`](crate::output::DescribeManagedRuleGroupOutput::version_name): <p>The managed rule group's version. </p>
    ///   - [`sns_topic_arn(Option<String>)`](crate::output::DescribeManagedRuleGroupOutput::sns_topic_arn): <p>The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to record changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service Developer Guide</a>.</p>
    ///   - [`capacity(i64)`](crate::output::DescribeManagedRuleGroupOutput::capacity): <p>The web ACL capacity units (WCUs) required for this rule group. WAF uses web ACL capacity units (WCU) to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect each rule's relative cost. Rule group capacity is fixed at creation, so users can plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
    ///   - [`rules(Option<Vec<RuleSummary>>)`](crate::output::DescribeManagedRuleGroupOutput::rules): <p></p>
    ///   - [`label_namespace(Option<String>)`](crate::output::DescribeManagedRuleGroupOutput::label_namespace): <p>The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix. </p>  <ul>   <li> <p>The syntax for the label namespace prefix for a managed rule group is the following: </p> <p> <code>awswaf:managed:     <vendor>      :      <rule group name></rule>     </vendor></code>:</p> </li>   <li> <p>When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon: </p> <p> <code><label namespace>:<label from rule></label></label></code> </p> </li>  </ul>
    ///   - [`available_labels(Option<Vec<LabelSummary>>)`](crate::output::DescribeManagedRuleGroupOutput::available_labels): <p>The labels that one or more rules in this rule group add to matching web requests. These labels are defined in the <code>RuleLabels</code> for a <code>Rule</code>.</p>
    ///   - [`consumed_labels(Option<Vec<LabelSummary>>)`](crate::output::DescribeManagedRuleGroupOutput::consumed_labels): <p>The labels that one or more rules in this rule group match against in label match statements. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <code>Statement</code> definition of a rule. </p>
    /// - On failure, responds with [`SdkError<DescribeManagedRuleGroupError>`](crate::error::DescribeManagedRuleGroupError)
    pub fn describe_managed_rule_group(&self) -> fluent_builders::DescribeManagedRuleGroup {
        fluent_builders::DescribeManagedRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateWebACL`](crate::client::fluent_builders::DisassociateWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateWebACL::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DisassociateWebACL::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p>  <p>The ARN must be in one of the following formats:</p>  <ul>   <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>   <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>   <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>  </ul>
    /// - On success, responds with [`DisassociateWebAclOutput`](crate::output::DisassociateWebAclOutput)

    /// - On failure, responds with [`SdkError<DisassociateWebACLError>`](crate::error::DisassociateWebACLError)
    pub fn disassociate_web_acl(&self) -> fluent_builders::DisassociateWebACL {
        fluent_builders::DisassociateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GenerateMobileSdkReleaseUrl`](crate::client::fluent_builders::GenerateMobileSdkReleaseUrl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform(Platform)`](crate::client::fluent_builders::GenerateMobileSdkReleaseUrl::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::GenerateMobileSdkReleaseUrl::set_platform): <p>The device platform.</p>
    ///   - [`release_version(impl Into<String>)`](crate::client::fluent_builders::GenerateMobileSdkReleaseUrl::release_version) / [`set_release_version(Option<String>)`](crate::client::fluent_builders::GenerateMobileSdkReleaseUrl::set_release_version): <p>The release version. For the latest available version, specify <code>LATEST</code>.</p>
    /// - On success, responds with [`GenerateMobileSdkReleaseUrlOutput`](crate::output::GenerateMobileSdkReleaseUrlOutput) with field(s):
    ///   - [`url(Option<String>)`](crate::output::GenerateMobileSdkReleaseUrlOutput::url): <p>The presigned download URL for the specified SDK release.</p>
    /// - On failure, responds with [`SdkError<GenerateMobileSdkReleaseUrlError>`](crate::error::GenerateMobileSdkReleaseUrlError)
    pub fn generate_mobile_sdk_release_url(&self) -> fluent_builders::GenerateMobileSdkReleaseUrl {
        fluent_builders::GenerateMobileSdkReleaseUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIPSet`](crate::client::fluent_builders::GetIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetIPSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetIPSet::set_name): <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetIPSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetIPSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetIPSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetIPSet::set_id): <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    /// - On success, responds with [`GetIpSetOutput`](crate::output::GetIpSetOutput) with field(s):
    ///   - [`ip_set(Option<IpSet>)`](crate::output::GetIpSetOutput::ip_set): <p></p>
    ///   - [`lock_token(Option<String>)`](crate::output::GetIpSetOutput::lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<GetIPSetError>`](crate::error::GetIPSetError)
    pub fn get_ip_set(&self) -> fluent_builders::GetIPSet {
        fluent_builders::GetIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLoggingConfiguration`](crate::client::fluent_builders::GetLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetLoggingConfiguration::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetLoggingConfiguration::set_resource_arn): <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
    /// - On success, responds with [`GetLoggingConfigurationOutput`](crate::output::GetLoggingConfigurationOutput) with field(s):
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::GetLoggingConfigurationOutput::logging_configuration): <p>The <code>LoggingConfiguration</code> for the specified web ACL.</p>
    /// - On failure, responds with [`SdkError<GetLoggingConfigurationError>`](crate::error::GetLoggingConfigurationError)
    pub fn get_logging_configuration(&self) -> fluent_builders::GetLoggingConfiguration {
        fluent_builders::GetLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetManagedRuleSet`](crate::client::fluent_builders::GetManagedRuleSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetManagedRuleSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetManagedRuleSet::set_name): <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>  <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetManagedRuleSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetManagedRuleSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetManagedRuleSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetManagedRuleSet::set_id): <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
    /// - On success, responds with [`GetManagedRuleSetOutput`](crate::output::GetManagedRuleSetOutput) with field(s):
    ///   - [`managed_rule_set(Option<ManagedRuleSet>)`](crate::output::GetManagedRuleSetOutput::managed_rule_set): <p>The managed rule set that you requested. </p>
    ///   - [`lock_token(Option<String>)`](crate::output::GetManagedRuleSetOutput::lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<GetManagedRuleSetError>`](crate::error::GetManagedRuleSetError)
    pub fn get_managed_rule_set(&self) -> fluent_builders::GetManagedRuleSet {
        fluent_builders::GetManagedRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMobileSdkRelease`](crate::client::fluent_builders::GetMobileSdkRelease) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform(Platform)`](crate::client::fluent_builders::GetMobileSdkRelease::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::GetMobileSdkRelease::set_platform): <p>The device platform.</p>
    ///   - [`release_version(impl Into<String>)`](crate::client::fluent_builders::GetMobileSdkRelease::release_version) / [`set_release_version(Option<String>)`](crate::client::fluent_builders::GetMobileSdkRelease::set_release_version): <p>The release version. For the latest available version, specify <code>LATEST</code>.</p>
    /// - On success, responds with [`GetMobileSdkReleaseOutput`](crate::output::GetMobileSdkReleaseOutput) with field(s):
    ///   - [`mobile_sdk_release(Option<MobileSdkRelease>)`](crate::output::GetMobileSdkReleaseOutput::mobile_sdk_release): <p>Information for a specified SDK release, including release notes and tags.</p>
    /// - On failure, responds with [`SdkError<GetMobileSdkReleaseError>`](crate::error::GetMobileSdkReleaseError)
    pub fn get_mobile_sdk_release(&self) -> fluent_builders::GetMobileSdkRelease {
        fluent_builders::GetMobileSdkRelease::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPermissionPolicy`](crate::client::fluent_builders::GetPermissionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetPermissionPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetPermissionPolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>
    /// - On success, responds with [`GetPermissionPolicyOutput`](crate::output::GetPermissionPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetPermissionPolicyOutput::policy): <p>The IAM policy that is attached to the specified rule group.</p>
    /// - On failure, responds with [`SdkError<GetPermissionPolicyError>`](crate::error::GetPermissionPolicyError)
    pub fn get_permission_policy(&self) -> fluent_builders::GetPermissionPolicy {
        fluent_builders::GetPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRateBasedStatementManagedKeys`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`web_acl_name(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::web_acl_name) / [`set_web_acl_name(Option<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::set_web_acl_name): <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::set_web_acl_id): <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`rule_group_rule_name(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::rule_group_rule_name) / [`set_rule_group_rule_name(Option<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::set_rule_group_rule_name): <p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>
    ///   - [`rule_name(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::rule_name) / [`set_rule_name(Option<String>)`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys::set_rule_name): <p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>
    /// - On success, responds with [`GetRateBasedStatementManagedKeysOutput`](crate::output::GetRateBasedStatementManagedKeysOutput) with field(s):
    ///   - [`managed_keys_ipv4(Option<RateBasedStatementManagedKeysIpSet>)`](crate::output::GetRateBasedStatementManagedKeysOutput::managed_keys_ipv4): <p>The keys that are of Internet Protocol version 4 (IPv4). </p>
    ///   - [`managed_keys_ipv6(Option<RateBasedStatementManagedKeysIpSet>)`](crate::output::GetRateBasedStatementManagedKeysOutput::managed_keys_ipv6): <p>The keys that are of Internet Protocol version 6 (IPv6). </p>
    /// - On failure, responds with [`SdkError<GetRateBasedStatementManagedKeysError>`](crate::error::GetRateBasedStatementManagedKeysError)
    pub fn get_rate_based_statement_managed_keys(
        &self,
    ) -> fluent_builders::GetRateBasedStatementManagedKeys {
        fluent_builders::GetRateBasedStatementManagedKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRegexPatternSet`](crate::client::fluent_builders::GetRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetRegexPatternSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetRegexPatternSet::set_name): <p>The name of the set. You cannot change the name after you create the set.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetRegexPatternSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetRegexPatternSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetRegexPatternSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetRegexPatternSet::set_id): <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    /// - On success, responds with [`GetRegexPatternSetOutput`](crate::output::GetRegexPatternSetOutput) with field(s):
    ///   - [`regex_pattern_set(Option<RegexPatternSet>)`](crate::output::GetRegexPatternSetOutput::regex_pattern_set): <p></p>
    ///   - [`lock_token(Option<String>)`](crate::output::GetRegexPatternSetOutput::lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<GetRegexPatternSetError>`](crate::error::GetRegexPatternSetError)
    pub fn get_regex_pattern_set(&self) -> fluent_builders::GetRegexPatternSet {
        fluent_builders::GetRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRuleGroup`](crate::client::fluent_builders::GetRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetRuleGroup::set_name): <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetRuleGroup::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetRuleGroup::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetRuleGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetRuleGroup::set_id): <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetRuleGroup::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetRuleGroup::set_arn): <p>The Amazon Resource Name (ARN) of the entity.</p>
    /// - On success, responds with [`GetRuleGroupOutput`](crate::output::GetRuleGroupOutput) with field(s):
    ///   - [`rule_group(Option<RuleGroup>)`](crate::output::GetRuleGroupOutput::rule_group): <p></p>
    ///   - [`lock_token(Option<String>)`](crate::output::GetRuleGroupOutput::lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<GetRuleGroupError>`](crate::error::GetRuleGroupError)
    pub fn get_rule_group(&self) -> fluent_builders::GetRuleGroup {
        fluent_builders::GetRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSampledRequests`](crate::client::fluent_builders::GetSampledRequests) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_arn(impl Into<String>)`](crate::client::fluent_builders::GetSampledRequests::web_acl_arn) / [`set_web_acl_arn(Option<String>)`](crate::client::fluent_builders::GetSampledRequests::set_web_acl_arn): <p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>
    ///   - [`rule_metric_name(impl Into<String>)`](crate::client::fluent_builders::GetSampledRequests::rule_metric_name) / [`set_rule_metric_name(Option<String>)`](crate::client::fluent_builders::GetSampledRequests::set_rule_metric_name): <p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of requests.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetSampledRequests::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetSampledRequests::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`time_window(TimeWindow)`](crate::client::fluent_builders::GetSampledRequests::time_window) / [`set_time_window(Option<TimeWindow>)`](crate::client::fluent_builders::GetSampledRequests::set_time_window): <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.</p>
    ///   - [`max_items(i64)`](crate::client::fluent_builders::GetSampledRequests::max_items) / [`set_max_items(i64)`](crate::client::fluent_builders::GetSampledRequests::set_max_items): <p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
    /// - On success, responds with [`GetSampledRequestsOutput`](crate::output::GetSampledRequestsOutput) with field(s):
    ///   - [`sampled_requests(Option<Vec<SampledHttpRequest>>)`](crate::output::GetSampledRequestsOutput::sampled_requests): <p>A complex type that contains detailed information about each of the requests in the sample.</p>
    ///   - [`population_size(i64)`](crate::output::GetSampledRequestsOutput::population_size): <p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your Amazon Web Services resource received during the specified time range.</p>
    ///   - [`time_window(Option<TimeWindow>)`](crate::output::GetSampledRequestsOutput::time_window): <p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your Amazon Web Services resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>
    /// - On failure, responds with [`SdkError<GetSampledRequestsError>`](crate::error::GetSampledRequestsError)
    pub fn get_sampled_requests(&self) -> fluent_builders::GetSampledRequests {
        fluent_builders::GetSampledRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWebACL`](crate::client::fluent_builders::GetWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetWebACL::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetWebACL::set_name): <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::GetWebACL::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::GetWebACL::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetWebACL::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetWebACL::set_id): <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    /// - On success, responds with [`GetWebAclOutput`](crate::output::GetWebAclOutput) with field(s):
    ///   - [`web_acl(Option<WebAcl>)`](crate::output::GetWebAclOutput::web_acl): <p>The web ACL specification. You can modify the settings in this web ACL and use it to update this web ACL or create a new one.</p>
    ///   - [`lock_token(Option<String>)`](crate::output::GetWebAclOutput::lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    ///   - [`application_integration_url(Option<String>)`](crate::output::GetWebAclOutput::application_integration_url): <p>The URL to use in SDK integrations with Amazon Web Services managed rule groups. For example, you can use the integration SDKs with the account takeover prevention managed rule group <code>AWSManagedRulesATPRuleSet</code>. This is only populated if you are using a rule group in your web ACL that integrates with your applications in this way. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GetWebACLError>`](crate::error::GetWebACLError)
    pub fn get_web_acl(&self) -> fluent_builders::GetWebACL {
        fluent_builders::GetWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWebACLForResource`](crate::client::fluent_builders::GetWebACLForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetWebACLForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetWebACLForResource::set_resource_arn): <p>The ARN (Amazon Resource Name) of the resource.</p>
    /// - On success, responds with [`GetWebAclForResourceOutput`](crate::output::GetWebAclForResourceOutput) with field(s):
    ///   - [`web_acl(Option<WebAcl>)`](crate::output::GetWebAclForResourceOutput::web_acl): <p>The web ACL that is associated with the resource. If there is no associated resource, WAF returns a null web ACL.</p>
    /// - On failure, responds with [`SdkError<GetWebACLForResourceError>`](crate::error::GetWebACLForResourceError)
    pub fn get_web_acl_for_resource(&self) -> fluent_builders::GetWebACLForResource {
        fluent_builders::GetWebACLForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAvailableManagedRuleGroups`](crate::client::fluent_builders::ListAvailableManagedRuleGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListAvailableManagedRuleGroups::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroups::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroups::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroups::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListAvailableManagedRuleGroups::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroups::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListAvailableManagedRuleGroupsOutput`](crate::output::ListAvailableManagedRuleGroupsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListAvailableManagedRuleGroupsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`managed_rule_groups(Option<Vec<ManagedRuleGroupSummary>>)`](crate::output::ListAvailableManagedRuleGroupsOutput::managed_rule_groups): <p></p>
    /// - On failure, responds with [`SdkError<ListAvailableManagedRuleGroupsError>`](crate::error::ListAvailableManagedRuleGroupsError)
    pub fn list_available_managed_rule_groups(
        &self,
    ) -> fluent_builders::ListAvailableManagedRuleGroups {
        fluent_builders::ListAvailableManagedRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAvailableManagedRuleGroupVersions`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vendor_name(impl Into<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::vendor_name) / [`set_vendor_name(Option<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::set_vendor_name): <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::set_name): <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListAvailableManagedRuleGroupVersionsOutput`](crate::output::ListAvailableManagedRuleGroupVersionsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListAvailableManagedRuleGroupVersionsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`versions(Option<Vec<ManagedRuleGroupVersion>>)`](crate::output::ListAvailableManagedRuleGroupVersionsOutput::versions): <p>The versions that are currently available for the specified managed rule group. </p>
    /// - On failure, responds with [`SdkError<ListAvailableManagedRuleGroupVersionsError>`](crate::error::ListAvailableManagedRuleGroupVersionsError)
    pub fn list_available_managed_rule_group_versions(
        &self,
    ) -> fluent_builders::ListAvailableManagedRuleGroupVersions {
        fluent_builders::ListAvailableManagedRuleGroupVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIPSets`](crate::client::fluent_builders::ListIPSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListIPSets::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListIPSets::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListIPSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListIPSets::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListIPSets::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListIPSets::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListIpSetsOutput`](crate::output::ListIpSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListIpSetsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`ip_sets(Option<Vec<IpSetSummary>>)`](crate::output::ListIpSetsOutput::ip_sets): <p>Array of IPSets. This may not be the full list of IPSets that you have defined. See the <code>Limit</code> specification for this request.</p>
    /// - On failure, responds with [`SdkError<ListIPSetsError>`](crate::error::ListIPSetsError)
    pub fn list_ip_sets(&self) -> fluent_builders::ListIPSets {
        fluent_builders::ListIPSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLoggingConfigurations`](crate::client::fluent_builders::ListLoggingConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListLoggingConfigurations::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListLoggingConfigurations::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListLoggingConfigurations::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListLoggingConfigurations::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListLoggingConfigurations::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListLoggingConfigurations::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListLoggingConfigurationsOutput`](crate::output::ListLoggingConfigurationsOutput) with field(s):
    ///   - [`logging_configurations(Option<Vec<LoggingConfiguration>>)`](crate::output::ListLoggingConfigurationsOutput::logging_configurations): <p></p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListLoggingConfigurationsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    /// - On failure, responds with [`SdkError<ListLoggingConfigurationsError>`](crate::error::ListLoggingConfigurationsError)
    pub fn list_logging_configurations(&self) -> fluent_builders::ListLoggingConfigurations {
        fluent_builders::ListLoggingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListManagedRuleSets`](crate::client::fluent_builders::ListManagedRuleSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListManagedRuleSets::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListManagedRuleSets::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListManagedRuleSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListManagedRuleSets::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListManagedRuleSets::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListManagedRuleSets::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListManagedRuleSetsOutput`](crate::output::ListManagedRuleSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListManagedRuleSetsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`managed_rule_sets(Option<Vec<ManagedRuleSetSummary>>)`](crate::output::ListManagedRuleSetsOutput::managed_rule_sets): <p>Your managed rule sets. </p>
    /// - On failure, responds with [`SdkError<ListManagedRuleSetsError>`](crate::error::ListManagedRuleSetsError)
    pub fn list_managed_rule_sets(&self) -> fluent_builders::ListManagedRuleSets {
        fluent_builders::ListManagedRuleSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMobileSdkReleases`](crate::client::fluent_builders::ListMobileSdkReleases) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform(Platform)`](crate::client::fluent_builders::ListMobileSdkReleases::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::ListMobileSdkReleases::set_platform): <p>The device platform to retrieve the list for.</p>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListMobileSdkReleases::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListMobileSdkReleases::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListMobileSdkReleases::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListMobileSdkReleases::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListMobileSdkReleasesOutput`](crate::output::ListMobileSdkReleasesOutput) with field(s):
    ///   - [`release_summaries(Option<Vec<ReleaseSummary>>)`](crate::output::ListMobileSdkReleasesOutput::release_summaries): <p>High level information for the available SDK releases. </p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListMobileSdkReleasesOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    /// - On failure, responds with [`SdkError<ListMobileSdkReleasesError>`](crate::error::ListMobileSdkReleasesError)
    pub fn list_mobile_sdk_releases(&self) -> fluent_builders::ListMobileSdkReleases {
        fluent_builders::ListMobileSdkReleases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRegexPatternSets`](crate::client::fluent_builders::ListRegexPatternSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListRegexPatternSets::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListRegexPatternSets::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRegexPatternSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRegexPatternSets::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRegexPatternSets::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListRegexPatternSets::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListRegexPatternSetsOutput`](crate::output::ListRegexPatternSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRegexPatternSetsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`regex_pattern_sets(Option<Vec<RegexPatternSetSummary>>)`](crate::output::ListRegexPatternSetsOutput::regex_pattern_sets): <p></p>
    /// - On failure, responds with [`SdkError<ListRegexPatternSetsError>`](crate::error::ListRegexPatternSetsError)
    pub fn list_regex_pattern_sets(&self) -> fluent_builders::ListRegexPatternSets {
        fluent_builders::ListRegexPatternSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourcesForWebACL`](crate::client::fluent_builders::ListResourcesForWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_arn(impl Into<String>)`](crate::client::fluent_builders::ListResourcesForWebACL::web_acl_arn) / [`set_web_acl_arn(Option<String>)`](crate::client::fluent_builders::ListResourcesForWebACL::set_web_acl_arn): <p>The Amazon Resource Name (ARN) of the web ACL.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::ListResourcesForWebACL::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::ListResourcesForWebACL::set_resource_type): <p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
    /// - On success, responds with [`ListResourcesForWebAclOutput`](crate::output::ListResourcesForWebAclOutput) with field(s):
    ///   - [`resource_arns(Option<Vec<String>>)`](crate::output::ListResourcesForWebAclOutput::resource_arns): <p>The array of Amazon Resource Names (ARNs) of the associated resources.</p>
    /// - On failure, responds with [`SdkError<ListResourcesForWebACLError>`](crate::error::ListResourcesForWebACLError)
    pub fn list_resources_for_web_acl(&self) -> fluent_builders::ListResourcesForWebACL {
        fluent_builders::ListResourcesForWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRuleGroups`](crate::client::fluent_builders::ListRuleGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListRuleGroups::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListRuleGroups::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRuleGroups::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRuleGroups::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRuleGroups::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListRuleGroups::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRuleGroupsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`rule_groups(Option<Vec<RuleGroupSummary>>)`](crate::output::ListRuleGroupsOutput::rule_groups): <p></p>
    /// - On failure, responds with [`SdkError<ListRuleGroupsError>`](crate::error::ListRuleGroupsError)
    pub fn list_rule_groups(&self) -> fluent_builders::ListRuleGroups {
        fluent_builders::ListRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTagsForResource::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListTagsForResourceOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`tag_info_for_resource(Option<TagInfoForResource>)`](crate::output::ListTagsForResourceOutput::tag_info_for_resource): <p>The collection of tagging definitions for the resource. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWebACLs`](crate::client::fluent_builders::ListWebACLs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(Scope)`](crate::client::fluent_builders::ListWebACLs::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::ListWebACLs::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListWebACLs::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListWebACLs::set_next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListWebACLs::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListWebACLs::set_limit): <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`ListWebAcLsOutput`](crate::output::ListWebAcLsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListWebAcLsOutput::next_marker): <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`web_ac_ls(Option<Vec<WebAclSummary>>)`](crate::output::ListWebAcLsOutput::web_ac_ls): <p></p>
    /// - On failure, responds with [`SdkError<ListWebACLsError>`](crate::error::ListWebACLsError)
    pub fn list_web_ac_ls(&self) -> fluent_builders::ListWebACLs {
        fluent_builders::ListWebACLs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLoggingConfiguration`](crate::client::fluent_builders::PutLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`logging_configuration(LoggingConfiguration)`](crate::client::fluent_builders::PutLoggingConfiguration::logging_configuration) / [`set_logging_configuration(Option<LoggingConfiguration>)`](crate::client::fluent_builders::PutLoggingConfiguration::set_logging_configuration): <p></p>
    /// - On success, responds with [`PutLoggingConfigurationOutput`](crate::output::PutLoggingConfigurationOutput) with field(s):
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::PutLoggingConfigurationOutput::logging_configuration): <p></p>
    /// - On failure, responds with [`SdkError<PutLoggingConfigurationError>`](crate::error::PutLoggingConfigurationError)
    pub fn put_logging_configuration(&self) -> fluent_builders::PutLoggingConfiguration {
        fluent_builders::PutLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutManagedRuleSetVersions`](crate::client::fluent_builders::PutManagedRuleSetVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::set_name): <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>  <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::PutManagedRuleSetVersions::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::set_id): <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    ///   - [`recommended_version(impl Into<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::recommended_version) / [`set_recommended_version(Option<String>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::set_recommended_version): <p>The version of the named managed rule group that you'd like your customers to choose, from among your version offerings. </p>
    ///   - [`versions_to_publish(HashMap<String, VersionToPublish>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::versions_to_publish) / [`set_versions_to_publish(Option<HashMap<String, VersionToPublish>>)`](crate::client::fluent_builders::PutManagedRuleSetVersions::set_versions_to_publish): <p>The versions of the named managed rule group that you want to offer to your customers. </p>
    /// - On success, responds with [`PutManagedRuleSetVersionsOutput`](crate::output::PutManagedRuleSetVersionsOutput) with field(s):
    ///   - [`next_lock_token(Option<String>)`](crate::output::PutManagedRuleSetVersionsOutput::next_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<PutManagedRuleSetVersionsError>`](crate::error::PutManagedRuleSetVersionsError)
    pub fn put_managed_rule_set_versions(&self) -> fluent_builders::PutManagedRuleSetVersions {
        fluent_builders::PutManagedRuleSetVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPermissionPolicy`](crate::client::fluent_builders::PutPermissionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutPermissionPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutPermissionPolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the <code>RuleGroup</code> to which you want to attach the policy.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutPermissionPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutPermissionPolicy::set_policy): <p>The policy to attach to the specified rule group. </p>  <p>The policy specifications must conform to the following:</p>  <ul>   <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>   <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>   <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>   <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>   <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
    /// - On success, responds with [`PutPermissionPolicyOutput`](crate::output::PutPermissionPolicyOutput)

    /// - On failure, responds with [`SdkError<PutPermissionPolicyError>`](crate::error::PutPermissionPolicyError)
    pub fn put_permission_policy(&self) -> fluent_builders::PutPermissionPolicy {
        fluent_builders::PutPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>An array of key:value pairs to associate with the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>An array of keys identifying the tags to disassociate from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIPSet`](crate::client::fluent_builders::UpdateIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateIPSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateIPSet::set_name): <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::UpdateIPSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::UpdateIPSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateIPSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateIPSet::set_id): <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateIPSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateIPSet::set_description): <p>A description of the IP set that helps with identification. </p>
    ///   - [`addresses(Vec<String>)`](crate::client::fluent_builders::UpdateIPSet::addresses) / [`set_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateIPSet::set_addresses): <p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>  <p>Example address strings: </p>  <ul>   <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>   <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>   <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>   <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>  </ul>  <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>  <p>Example JSON <code>Addresses</code> specifications: </p>  <ul>   <li> <p>Empty array: <code>"Addresses": []</code> </p> </li>   <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li>   <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li>   <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li>  </ul>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::UpdateIPSet::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::UpdateIPSet::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`UpdateIpSetOutput`](crate::output::UpdateIpSetOutput) with field(s):
    ///   - [`next_lock_token(Option<String>)`](crate::output::UpdateIpSetOutput::next_lock_token): <p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateIPSetError>`](crate::error::UpdateIPSetError)
    pub fn update_ip_set(&self) -> fluent_builders::UpdateIPSet {
        fluent_builders::UpdateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateManagedRuleSetVersionExpiryDate`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::set_name): <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>  <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::set_id): <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    ///   - [`version_to_expire(impl Into<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::version_to_expire) / [`set_version_to_expire(Option<String>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::set_version_to_expire): <p>The version that you want to remove from your list of offerings for the named managed rule group. </p>
    ///   - [`expiry_timestamp(DateTime)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::expiry_timestamp) / [`set_expiry_timestamp(Option<DateTime>)`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate::set_expiry_timestamp): <p>The time that you want the version to expire.</p>  <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>
    /// - On success, responds with [`UpdateManagedRuleSetVersionExpiryDateOutput`](crate::output::UpdateManagedRuleSetVersionExpiryDateOutput) with field(s):
    ///   - [`expiring_version(Option<String>)`](crate::output::UpdateManagedRuleSetVersionExpiryDateOutput::expiring_version): <p>The version that is set to expire. </p>
    ///   - [`expiry_timestamp(Option<DateTime>)`](crate::output::UpdateManagedRuleSetVersionExpiryDateOutput::expiry_timestamp): <p>The time that the version will expire. </p>  <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>
    ///   - [`next_lock_token(Option<String>)`](crate::output::UpdateManagedRuleSetVersionExpiryDateOutput::next_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On failure, responds with [`SdkError<UpdateManagedRuleSetVersionExpiryDateError>`](crate::error::UpdateManagedRuleSetVersionExpiryDateError)
    pub fn update_managed_rule_set_version_expiry_date(
        &self,
    ) -> fluent_builders::UpdateManagedRuleSetVersionExpiryDate {
        fluent_builders::UpdateManagedRuleSetVersionExpiryDate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRegexPatternSet`](crate::client::fluent_builders::UpdateRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_name): <p>The name of the set. You cannot change the name after you create the set.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::UpdateRegexPatternSet::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_id): <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_description): <p>A description of the set that helps with identification. </p>
    ///   - [`regular_expression_list(Vec<Regex>)`](crate::client::fluent_builders::UpdateRegexPatternSet::regular_expression_list) / [`set_regular_expression_list(Option<Vec<Regex>>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_regular_expression_list): <p></p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    /// - On success, responds with [`UpdateRegexPatternSetOutput`](crate::output::UpdateRegexPatternSetOutput) with field(s):
    ///   - [`next_lock_token(Option<String>)`](crate::output::UpdateRegexPatternSetOutput::next_lock_token): <p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateRegexPatternSetError>`](crate::error::UpdateRegexPatternSetError)
    pub fn update_regex_pattern_set(&self) -> fluent_builders::UpdateRegexPatternSet {
        fluent_builders::UpdateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRuleGroup`](crate::client::fluent_builders::UpdateRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_name): <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::UpdateRuleGroup::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::UpdateRuleGroup::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_id): <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_description): <p>A description of the rule group that helps with identification. </p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::UpdateRuleGroup::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::UpdateRuleGroup::set_rules): <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
    ///   - [`visibility_config(VisibilityConfig)`](crate::client::fluent_builders::UpdateRuleGroup::visibility_config) / [`set_visibility_config(Option<VisibilityConfig>)`](crate::client::fluent_builders::UpdateRuleGroup::set_visibility_config): <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    ///   - [`custom_response_bodies(HashMap<String, CustomResponseBody>)`](crate::client::fluent_builders::UpdateRuleGroup::custom_response_bodies) / [`set_custom_response_bodies(Option<HashMap<String, CustomResponseBody>>)`](crate::client::fluent_builders::UpdateRuleGroup::set_custom_response_bodies): <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>  <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>  <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
    /// - On success, responds with [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput) with field(s):
    ///   - [`next_lock_token(Option<String>)`](crate::output::UpdateRuleGroupOutput::next_lock_token): <p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateRuleGroupError>`](crate::error::UpdateRuleGroupError)
    pub fn update_rule_group(&self) -> fluent_builders::UpdateRuleGroup {
        fluent_builders::UpdateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWebACL`](crate::client::fluent_builders::UpdateWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateWebACL::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateWebACL::set_name): <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::UpdateWebACL::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::UpdateWebACL::set_scope): <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>  <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>  <ul>   <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>   <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>  </ul>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateWebACL::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateWebACL::set_id): <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
    ///   - [`default_action(DefaultAction)`](crate::client::fluent_builders::UpdateWebACL::default_action) / [`set_default_action(Option<DefaultAction>)`](crate::client::fluent_builders::UpdateWebACL::set_default_action): <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateWebACL::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateWebACL::set_description): <p>A description of the web ACL that helps with identification. </p>
    ///   - [`rules(Vec<Rule>)`](crate::client::fluent_builders::UpdateWebACL::rules) / [`set_rules(Option<Vec<Rule>>)`](crate::client::fluent_builders::UpdateWebACL::set_rules): <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
    ///   - [`visibility_config(VisibilityConfig)`](crate::client::fluent_builders::UpdateWebACL::visibility_config) / [`set_visibility_config(Option<VisibilityConfig>)`](crate::client::fluent_builders::UpdateWebACL::set_visibility_config): <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
    ///   - [`lock_token(impl Into<String>)`](crate::client::fluent_builders::UpdateWebACL::lock_token) / [`set_lock_token(Option<String>)`](crate::client::fluent_builders::UpdateWebACL::set_lock_token): <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
    ///   - [`custom_response_bodies(HashMap<String, CustomResponseBody>)`](crate::client::fluent_builders::UpdateWebACL::custom_response_bodies) / [`set_custom_response_bodies(Option<HashMap<String, CustomResponseBody>>)`](crate::client::fluent_builders::UpdateWebACL::set_custom_response_bodies): <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>  <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>  <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
    ///   - [`captcha_config(CaptchaConfig)`](crate::client::fluent_builders::UpdateWebACL::captcha_config) / [`set_captcha_config(Option<CaptchaConfig>)`](crate::client::fluent_builders::UpdateWebACL::set_captcha_config): <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
    /// - On success, responds with [`UpdateWebAclOutput`](crate::output::UpdateWebAclOutput) with field(s):
    ///   - [`next_lock_token(Option<String>)`](crate::output::UpdateWebAclOutput::next_lock_token): <p>A token used for optimistic locking. WAF returns this token to your <code>update</code> requests. You use <code>NextLockToken</code> in the same manner as you use <code>LockToken</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateWebACLError>`](crate::error::UpdateWebACLError)
    pub fn update_web_acl(&self) -> fluent_builders::UpdateWebACL {
        fluent_builders::UpdateWebACL::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateWebACL`.
    ///
    /// <p>Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
    /// <p>For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_web_acl_input::Builder,
    }
    impl AssociateWebACL {
        /// Creates a new `AssociateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckCapacity`.
    ///
    /// <p>Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a <code>RuleGroup</code> or <code>WebACL</code>. </p>
    /// <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckCapacity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::check_capacity_input::Builder,
    }
    impl CheckCapacity {
        /// Creates a new `CheckCapacity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckCapacityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckCapacityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of <code>Rule</code> that you're configuring to use in a rule group or web ACL. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>An array of <code>Rule</code> that you're configuring to use in a rule group or web ACL. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIPSet`.
    ///
    /// <p>Creates an <code>IPSet</code>, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ip_set_input::Builder,
    }
    impl CreateIPSet {
        /// Creates a new `CreateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>
        pub fn ip_address_version(mut self, input: crate::model::IpAddressVersion) -> Self {
            self.inner = self.inner.ip_address_version(input);
            self
        }
        /// <p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>
        pub fn set_ip_address_version(
            mut self,
            input: std::option::Option<crate::model::IpAddressVersion>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_version(input);
            self
        }
        /// Appends an item to `Addresses`.
        ///
        /// To override the contents of this collection use [`set_addresses`](Self::set_addresses).
        ///
        /// <p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Example address strings: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        /// <p>Example JSON <code>Addresses</code> specifications: </p>
        /// <ul>
        /// <li> <p>Empty array: <code>"Addresses": []</code> </p> </li>
        /// <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li>
        /// <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li>
        /// <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li>
        /// </ul>
        pub fn addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addresses(input.into());
            self
        }
        /// <p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Example address strings: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        /// <p>Example JSON <code>Addresses</code> specifications: </p>
        /// <ul>
        /// <li> <p>Empty array: <code>"Addresses": []</code> </p> </li>
        /// <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li>
        /// <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li>
        /// <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li>
        /// </ul>
        pub fn set_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_addresses(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegexPatternSet`.
    ///
    /// <p>Creates a <code>RegexPatternSet</code>, which you reference in a <code>RegexPatternSetReferenceStatement</code>, to have WAF inspect a web request component for the specified patterns.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_regex_pattern_set_input::Builder,
    }
    impl CreateRegexPatternSet {
        /// Creates a new `CreateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `RegularExpressionList`.
        ///
        /// To override the contents of this collection use [`set_regular_expression_list`](Self::set_regular_expression_list).
        ///
        /// <p>Array of regular expression strings. </p>
        pub fn regular_expression_list(mut self, input: crate::model::Regex) -> Self {
            self.inner = self.inner.regular_expression_list(input);
            self
        }
        /// <p>Array of regular expression strings. </p>
        pub fn set_regular_expression_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Regex>>,
        ) -> Self {
            self.inner = self.inner.set_regular_expression_list(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroup`.
    ///
    /// <p>Creates a <code>RuleGroup</code> per the specifications provided. </p>
    /// <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <code>WebACL</code>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rule_group_input::Builder,
    }
    impl CreateRuleGroup {
        /// Creates a new `CreateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The web ACL capacity units (WCUs) required for this rule group.</p>
        /// <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <code>CheckCapacity</code>.</p>
        /// <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
        pub fn capacity(mut self, input: i64) -> Self {
            self.inner = self.inner.capacity(input);
            self
        }
        /// <p>The web ACL capacity units (WCUs) required for this rule group.</p>
        /// <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <code>CheckCapacity</code>.</p>
        /// <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
        pub fn set_capacity(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebACL`.
    ///
    /// <p>Creates a <code>WebACL</code> per the specifications provided.</p>
    /// <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <code>Rule</code>, <code>RuleGroup</code>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_web_acl_input::Builder,
    }
    impl CreateWebACL {
        /// Creates a new `CreateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn default_action(mut self, input: crate::model::DefaultAction) -> Self {
            self.inner = self.inner.default_action(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::DefaultAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn captcha_config(mut self, input: crate::model::CaptchaConfig) -> Self {
            self.inner = self.inner.captcha_config(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn set_captcha_config(
            mut self,
            input: std::option::Option<crate::model::CaptchaConfig>,
        ) -> Self {
            self.inner = self.inner.set_captcha_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallManagerRuleGroups`.
    ///
    /// <p>Deletes all rule groups that are managed by Firewall Manager for the specified web ACL. </p>
    /// <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <code>WebACL</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewallManagerRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_firewall_manager_rule_groups_input::Builder,
    }
    impl DeleteFirewallManagerRuleGroups {
        /// Creates a new `DeleteFirewallManagerRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallManagerRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallManagerRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn web_acl_lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_web_acl_lock_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_web_acl_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIPSet`.
    ///
    /// <p>Deletes the specified <code>IPSet</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ip_set_input::Builder,
    }
    impl DeleteIPSet {
        /// Creates a new `DeleteIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoggingConfiguration`.
    ///
    /// <p>Deletes the <code>LoggingConfiguration</code> from the specified web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_logging_configuration_input::Builder,
    }
    impl DeleteLoggingConfiguration {
        /// Creates a new `DeleteLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermissionPolicy`.
    ///
    /// <p>Permanently deletes an IAM policy from the specified rule group.</p>
    /// <p>You must be the owner of the rule group to perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePermissionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_permission_policy_input::Builder,
    }
    impl DeletePermissionPolicy {
        /// Creates a new `DeletePermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p>
        /// <p>You must be the owner of the rule group to perform this operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p>
        /// <p>You must be the owner of the rule group to perform this operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegexPatternSet`.
    ///
    /// <p>Deletes the specified <code>RegexPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_regex_pattern_set_input::Builder,
    }
    impl DeleteRegexPatternSet {
        /// Creates a new `DeleteRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroup`.
    ///
    /// <p>Deletes the specified <code>RuleGroup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_group_input::Builder,
    }
    impl DeleteRuleGroup {
        /// Creates a new `DeleteRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebACL`.
    ///
    /// <p>Deletes the specified <code>WebACL</code>.</p>
    /// <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <code>WebACL</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_web_acl_input::Builder,
    }
    impl DeleteWebACL {
        /// Creates a new `DeleteWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeManagedRuleGroup`.
    ///
    /// <p>Provides high-level information for a managed rule group, including descriptions of the rules. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeManagedRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_managed_rule_group_input::Builder,
    }
    impl DescribeManagedRuleGroup {
        /// Creates a new `DescribeManagedRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeManagedRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeManagedRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn vendor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor_name(input.into());
            self
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn set_vendor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor_name(input);
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version. </p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version. </p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWebACL`.
    ///
    /// <p>Disassociates a web ACL from a regional application resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
    /// <p>For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_web_acl_input::Builder,
    }
    impl DisassociateWebACL {
        /// Creates a new `DisassociateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateMobileSdkReleaseUrl`.
    ///
    /// <p>Generates a presigned download URL for the specified release of the mobile SDK.</p>
    /// <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GenerateMobileSdkReleaseUrl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::generate_mobile_sdk_release_url_input::Builder,
    }
    impl GenerateMobileSdkReleaseUrl {
        /// Creates a new `GenerateMobileSdkReleaseUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateMobileSdkReleaseUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateMobileSdkReleaseUrlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device platform.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The device platform.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The release version. For the latest available version, specify <code>LATEST</code>.</p>
        pub fn release_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_version(input.into());
            self
        }
        /// <p>The release version. For the latest available version, specify <code>LATEST</code>.</p>
        pub fn set_release_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIPSet`.
    ///
    /// <p>Retrieves the specified <code>IPSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_ip_set_input::Builder,
    }
    impl GetIPSet {
        /// Creates a new `GetIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggingConfiguration`.
    ///
    /// <p>Returns the <code>LoggingConfiguration</code> for the specified web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_logging_configuration_input::Builder,
    }
    impl GetLoggingConfiguration {
        /// Creates a new `GetLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetManagedRuleSet`.
    ///
    /// <p>Retrieves the specified managed rule set. </p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetManagedRuleSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_managed_rule_set_input::Builder,
    }
    impl GetManagedRuleSet {
        /// Creates a new `GetManagedRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetManagedRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetManagedRuleSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMobileSdkRelease`.
    ///
    /// <p>Retrieves information for the specified mobile SDK release, including release notes and tags.</p>
    /// <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMobileSdkRelease {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_mobile_sdk_release_input::Builder,
    }
    impl GetMobileSdkRelease {
        /// Creates a new `GetMobileSdkRelease`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMobileSdkReleaseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMobileSdkReleaseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device platform.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The device platform.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The release version. For the latest available version, specify <code>LATEST</code>.</p>
        pub fn release_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_version(input.into());
            self
        }
        /// <p>The release version. For the latest available version, specify <code>LATEST</code>.</p>
        pub fn set_release_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPermissionPolicy`.
    ///
    /// <p>Returns the IAM policy that is attached to the specified rule group.</p>
    /// <p>You must be the owner of the rule group to perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPermissionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_permission_policy_input::Builder,
    }
    impl GetPermissionPolicy {
        /// Creates a new `GetPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPermissionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRateBasedStatementManagedKeys`.
    ///
    /// <p>Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.</p>
    /// <p>For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name. </p>
    /// <p>WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRateBasedStatementManagedKeys {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rate_based_statement_managed_keys_input::Builder,
    }
    impl GetRateBasedStatementManagedKeys {
        /// Creates a new `GetRateBasedStatementManagedKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRateBasedStatementManagedKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRateBasedStatementManagedKeysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn web_acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_web_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_name(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>
        pub fn rule_group_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_rule_name(input.into());
            self
        }
        /// <p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>
        pub fn set_rule_group_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_rule_name(input);
            self
        }
        /// <p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegexPatternSet`.
    ///
    /// <p>Retrieves the specified <code>RegexPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_regex_pattern_set_input::Builder,
    }
    impl GetRegexPatternSet {
        /// Creates a new `GetRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRuleGroup`.
    ///
    /// <p>Retrieves the specified <code>RuleGroup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rule_group_input::Builder,
    }
    impl GetRuleGroup {
        /// Creates a new `GetRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSampledRequests`.
    ///
    /// <p>Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.</p>
    /// <p> <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSampledRequests {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sampled_requests_input::Builder,
    }
    impl GetSampledRequests {
        /// Creates a new `GetSampledRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSampledRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSampledRequestsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of requests.</p>
        pub fn rule_metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_metric_name(input.into());
            self
        }
        /// <p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of requests.</p>
        pub fn set_rule_metric_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_metric_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.</p>
        pub fn time_window(mut self, input: crate::model::TimeWindow) -> Self {
            self.inner = self.inner.time_window(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.</p>
        pub fn set_time_window(
            mut self,
            input: std::option::Option<crate::model::TimeWindow>,
        ) -> Self {
            self.inner = self.inner.set_time_window(input);
            self
        }
        /// <p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
        pub fn max_items(mut self, input: i64) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebACL`.
    ///
    /// <p>Retrieves the specified <code>WebACL</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_web_acl_input::Builder,
    }
    impl GetWebACL {
        /// Creates a new `GetWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebACLForResource`.
    ///
    /// <p>Retrieves the <code>WebACL</code> for the specified resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWebACLForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_web_acl_for_resource_input::Builder,
    }
    impl GetWebACLForResource {
        /// Creates a new `GetWebACLForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebAclForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebACLForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableManagedRuleGroups`.
    ///
    /// <p>Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableManagedRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_available_managed_rule_groups_input::Builder,
    }
    impl ListAvailableManagedRuleGroups {
        /// Creates a new `ListAvailableManagedRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableManagedRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableManagedRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableManagedRuleGroupVersions`.
    ///
    /// <p>Returns a list of the available versions for the specified managed rule group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableManagedRuleGroupVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_available_managed_rule_group_versions_input::Builder,
    }
    impl ListAvailableManagedRuleGroupVersions {
        /// Creates a new `ListAvailableManagedRuleGroupVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableManagedRuleGroupVersionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAvailableManagedRuleGroupVersionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn vendor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor_name(input.into());
            self
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn set_vendor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor_name(input);
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIPSets`.
    ///
    /// <p>Retrieves an array of <code>IPSetSummary</code> objects for the IP sets that you manage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIPSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_ip_sets_input::Builder,
    }
    impl ListIPSets {
        /// Creates a new `ListIPSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIPSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLoggingConfigurations`.
    ///
    /// <p>Retrieves an array of your <code>LoggingConfiguration</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLoggingConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_logging_configurations_input::Builder,
    }
    impl ListLoggingConfigurations {
        /// Creates a new `ListLoggingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLoggingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLoggingConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedRuleSets`.
    ///
    /// <p>Retrieves the managed rule sets that you own. </p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedRuleSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_managed_rule_sets_input::Builder,
    }
    impl ListManagedRuleSets {
        /// Creates a new `ListManagedRuleSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedRuleSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedRuleSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMobileSdkReleases`.
    ///
    /// <p>Retrieves a list of the available releases for the mobile SDK and the specified device platform. </p>
    /// <p>The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html">WAF client application integration</a> in the <i>WAF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMobileSdkReleases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mobile_sdk_releases_input::Builder,
    }
    impl ListMobileSdkReleases {
        /// Creates a new `ListMobileSdkReleases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMobileSdkReleasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMobileSdkReleasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device platform to retrieve the list for.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The device platform to retrieve the list for.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegexPatternSets`.
    ///
    /// <p>Retrieves an array of <code>RegexPatternSetSummary</code> objects for the regex pattern sets that you manage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRegexPatternSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_regex_pattern_sets_input::Builder,
    }
    impl ListRegexPatternSets {
        /// Creates a new `ListRegexPatternSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegexPatternSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegexPatternSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesForWebACL`.
    ///
    /// <p>Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call <code>ListDistributionsByWebACLId</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourcesForWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resources_for_web_acl_input::Builder,
    }
    impl ListResourcesForWebACL {
        /// Creates a new `ListResourcesForWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesForWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesForWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroups`.
    ///
    /// <p>Retrieves an array of <code>RuleGroupSummary</code> objects for the rule groups that you manage. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rule_groups_input::Builder,
    }
    impl ListRuleGroups {
        /// Creates a new `ListRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the <code>TagInfoForResource</code> for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebACLs`.
    ///
    /// <p>Retrieves an array of <code>WebACLSummary</code> objects for the web ACLs that you manage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebACLs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_web_ac_ls_input::Builder,
    }
    impl ListWebACLs {
        /// Creates a new `ListWebACLs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebAcLsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebACLsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingConfiguration`.
    ///
    /// <p>Enables the specified <code>LoggingConfiguration</code>, to start logging from a web ACL, according to the configuration provided. </p> <note>
    /// <p>You can define one logging destination per web ACL.</p>
    /// </note>
    /// <p>You can access information about the traffic that WAF inspects using the following steps:</p>
    /// <ol>
    /// <li> <p>Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. For information about configuring logging destinations and the permissions that are required for each, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p> </li>
    /// <li> <p>Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.</p> </li>
    /// </ol>
    /// <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.</p>
    /// <p>For additional information about web ACL logging, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling <code>GetLoggingConfiguration</code>, update the settings as needed, and then provide the complete logging configuration specification to this call.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_logging_configuration_input::Builder,
    }
    impl PutLoggingConfiguration {
        /// Creates a new `PutLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p></p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutManagedRuleSetVersions`.
    ///
    /// <p>Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.</p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    /// <p>Customers retrieve their managed rule group list by calling <code>ListAvailableManagedRuleGroups</code>. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling <code>ListAvailableManagedRuleGroupVersions</code>. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using. </p>
    /// <p>To initiate the expiration of a managed rule group version, use <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutManagedRuleSetVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_managed_rule_set_versions_input::Builder,
    }
    impl PutManagedRuleSetVersions {
        /// Creates a new `PutManagedRuleSetVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutManagedRuleSetVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutManagedRuleSetVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// <p>The version of the named managed rule group that you'd like your customers to choose, from among your version offerings. </p>
        pub fn recommended_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommended_version(input.into());
            self
        }
        /// <p>The version of the named managed rule group that you'd like your customers to choose, from among your version offerings. </p>
        pub fn set_recommended_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommended_version(input);
            self
        }
        /// Adds a key-value pair to `VersionsToPublish`.
        ///
        /// To override the contents of this collection use [`set_versions_to_publish`](Self::set_versions_to_publish).
        ///
        /// <p>The versions of the named managed rule group that you want to offer to your customers. </p>
        pub fn versions_to_publish(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::VersionToPublish,
        ) -> Self {
            self.inner = self.inner.versions_to_publish(k.into(), v);
            self
        }
        /// <p>The versions of the named managed rule group that you want to offer to your customers. </p>
        pub fn set_versions_to_publish(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::VersionToPublish>,
            >,
        ) -> Self {
            self.inner = self.inner.set_versions_to_publish(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermissionPolicy`.
    ///
    /// <p>Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.</p>
    /// <p>You must be the owner of the rule group to perform this operation.</p>
    /// <p>This action is subject to the following restrictions:</p>
    /// <ul>
    /// <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li>
    /// <li> <p>The ARN in the request must be a valid WAF <code>RuleGroup</code> ARN and the rule group must exist in the same Region.</p> </li>
    /// <li> <p>The user making the request must be the owner of the rule group.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPermissionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_permission_policy_input::Builder,
    }
    impl PutPermissionPolicy {
        /// Creates a new `PutPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>RuleGroup</code> to which you want to attach the policy.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>RuleGroup</code> to which you want to attach the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The policy to attach to the specified rule group. </p>
        /// <p>The policy specifications must conform to the following:</p>
        /// <ul>
        /// <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>
        /// <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>
        /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
        /// <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>
        /// <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to attach to the specified rule group. </p>
        /// <p>The policy specifications must conform to the following:</p>
        /// <ul>
        /// <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>
        /// <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>
        /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
        /// <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>
        /// <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of keys identifying the tags to disassociate from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>An array of keys identifying the tags to disassociate from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIPSet`.
    ///
    /// <p>Updates the specified <code>IPSet</code>. </p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling <code>GetIPSet</code>, update the settings as needed, and then provide the complete IP set specification to this call.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_ip_set_input::Builder,
    }
    impl UpdateIPSet {
        /// Creates a new `UpdateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Addresses`.
        ///
        /// To override the contents of this collection use [`set_addresses`](Self::set_addresses).
        ///
        /// <p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Example address strings: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        /// <p>Example JSON <code>Addresses</code> specifications: </p>
        /// <ul>
        /// <li> <p>Empty array: <code>"Addresses": []</code> </p> </li>
        /// <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li>
        /// <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li>
        /// <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li>
        /// </ul>
        pub fn addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addresses(input.into());
            self
        }
        /// <p>Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Example address strings: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        /// <p>Example JSON <code>Addresses</code> specifications: </p>
        /// <ul>
        /// <li> <p>Empty array: <code>"Addresses": []</code> </p> </li>
        /// <li> <p>Array with one address: <code>"Addresses": ["192.0.2.44/32"]</code> </p> </li>
        /// <li> <p>Array with three addresses: <code>"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]</code> </p> </li>
        /// <li> <p>INVALID specification: <code>"Addresses": [""]</code> INVALID </p> </li>
        /// </ul>
        pub fn set_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_addresses(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateManagedRuleSetVersionExpiryDate`.
    ///
    /// <p>Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the reponse to <code>ListAvailableManagedRuleGroupVersions</code> for the managed rule group. </p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateManagedRuleSetVersionExpiryDate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_managed_rule_set_version_expiry_date_input::Builder,
    }
    impl UpdateManagedRuleSetVersionExpiryDate {
        /// Creates a new `UpdateManagedRuleSetVersionExpiryDate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateManagedRuleSetVersionExpiryDateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateManagedRuleSetVersionExpiryDateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// <p>The version that you want to remove from your list of offerings for the named managed rule group. </p>
        pub fn version_to_expire(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_to_expire(input.into());
            self
        }
        /// <p>The version that you want to remove from your list of offerings for the named managed rule group. </p>
        pub fn set_version_to_expire(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_to_expire(input);
            self
        }
        /// <p>The time that you want the version to expire.</p>
        /// <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>
        pub fn expiry_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expiry_timestamp(input);
            self
        }
        /// <p>The time that you want the version to expire.</p>
        /// <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>
        pub fn set_expiry_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expiry_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegexPatternSet`.
    ///
    /// <p>Updates the specified <code>RegexPatternSet</code>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling <code>GetRegexPatternSet</code>, update the settings as needed, and then provide the complete regex pattern set specification to this call.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_regex_pattern_set_input::Builder,
    }
    impl UpdateRegexPatternSet {
        /// Creates a new `UpdateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `RegularExpressionList`.
        ///
        /// To override the contents of this collection use [`set_regular_expression_list`](Self::set_regular_expression_list).
        ///
        /// <p></p>
        pub fn regular_expression_list(mut self, input: crate::model::Regex) -> Self {
            self.inner = self.inner.regular_expression_list(input);
            self
        }
        /// <p></p>
        pub fn set_regular_expression_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Regex>>,
        ) -> Self {
            self.inner = self.inner.set_regular_expression_list(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleGroup`.
    ///
    /// <p>Updates the specified <code>RuleGroup</code>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling <code>GetRuleGroup</code>, update the settings as needed, and then provide the complete rule group specification to this call.</p>
    /// </note>
    /// <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <code>WebACL</code>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rule_group_input::Builder,
    }
    impl UpdateRuleGroup {
        /// Creates a new `UpdateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebACL`.
    ///
    /// <p>Updates the specified <code>WebACL</code>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling <code>GetWebACL</code>, update the settings as needed, and then provide the complete web ACL specification to this call.</p>
    /// </note>
    /// <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <code>Rule</code>, <code>RuleGroup</code>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_web_acl_input::Builder,
    }
    impl UpdateWebACL {
        /// Creates a new `UpdateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn default_action(mut self, input: crate::model::DefaultAction) -> Self {
            self.inner = self.inner.default_action(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::DefaultAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn captcha_config(mut self, input: crate::model::CaptchaConfig) -> Self {
            self.inner = self.inner.captcha_config(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn set_captcha_config(
            mut self,
            input: std::option::Option<crate::model::CaptchaConfig>,
        ) -> Self {
            self.inner = self.inner.set_captcha_config(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
