// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS WAFV2
///
/// Client for invoking operations on AWS WAFV2. Each operation on AWS WAFV2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_wafv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_wafv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_wafv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateWebACL` operation.
    ///
    /// See [`AssociateWebACL`](crate::client::fluent_builders::AssociateWebACL) for more information about the
    /// operation and its arguments.
    pub fn associate_web_acl(&self) -> fluent_builders::AssociateWebACL<C, M, R> {
        fluent_builders::AssociateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckCapacity` operation.
    ///
    /// See [`CheckCapacity`](crate::client::fluent_builders::CheckCapacity) for more information about the
    /// operation and its arguments.
    pub fn check_capacity(&self) -> fluent_builders::CheckCapacity<C, M, R> {
        fluent_builders::CheckCapacity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIPSet` operation.
    ///
    /// See [`CreateIPSet`](crate::client::fluent_builders::CreateIPSet) for more information about the
    /// operation and its arguments.
    pub fn create_ip_set(&self) -> fluent_builders::CreateIPSet<C, M, R> {
        fluent_builders::CreateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRegexPatternSet` operation.
    ///
    /// See [`CreateRegexPatternSet`](crate::client::fluent_builders::CreateRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn create_regex_pattern_set(&self) -> fluent_builders::CreateRegexPatternSet<C, M, R> {
        fluent_builders::CreateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRuleGroup` operation.
    ///
    /// See [`CreateRuleGroup`](crate::client::fluent_builders::CreateRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn create_rule_group(&self) -> fluent_builders::CreateRuleGroup<C, M, R> {
        fluent_builders::CreateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWebACL` operation.
    ///
    /// See [`CreateWebACL`](crate::client::fluent_builders::CreateWebACL) for more information about the
    /// operation and its arguments.
    pub fn create_web_acl(&self) -> fluent_builders::CreateWebACL<C, M, R> {
        fluent_builders::CreateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFirewallManagerRuleGroups` operation.
    ///
    /// See [`DeleteFirewallManagerRuleGroups`](crate::client::fluent_builders::DeleteFirewallManagerRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn delete_firewall_manager_rule_groups(
        &self,
    ) -> fluent_builders::DeleteFirewallManagerRuleGroups<C, M, R> {
        fluent_builders::DeleteFirewallManagerRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIPSet` operation.
    ///
    /// See [`DeleteIPSet`](crate::client::fluent_builders::DeleteIPSet) for more information about the
    /// operation and its arguments.
    pub fn delete_ip_set(&self) -> fluent_builders::DeleteIPSet<C, M, R> {
        fluent_builders::DeleteIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoggingConfiguration` operation.
    ///
    /// See [`DeleteLoggingConfiguration`](crate::client::fluent_builders::DeleteLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_logging_configuration(
        &self,
    ) -> fluent_builders::DeleteLoggingConfiguration<C, M, R> {
        fluent_builders::DeleteLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePermissionPolicy` operation.
    ///
    /// See [`DeletePermissionPolicy`](crate::client::fluent_builders::DeletePermissionPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_permission_policy(&self) -> fluent_builders::DeletePermissionPolicy<C, M, R> {
        fluent_builders::DeletePermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRegexPatternSet` operation.
    ///
    /// See [`DeleteRegexPatternSet`](crate::client::fluent_builders::DeleteRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn delete_regex_pattern_set(&self) -> fluent_builders::DeleteRegexPatternSet<C, M, R> {
        fluent_builders::DeleteRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRuleGroup` operation.
    ///
    /// See [`DeleteRuleGroup`](crate::client::fluent_builders::DeleteRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_rule_group(&self) -> fluent_builders::DeleteRuleGroup<C, M, R> {
        fluent_builders::DeleteRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWebACL` operation.
    ///
    /// See [`DeleteWebACL`](crate::client::fluent_builders::DeleteWebACL) for more information about the
    /// operation and its arguments.
    pub fn delete_web_acl(&self) -> fluent_builders::DeleteWebACL<C, M, R> {
        fluent_builders::DeleteWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeManagedRuleGroup` operation.
    ///
    /// See [`DescribeManagedRuleGroup`](crate::client::fluent_builders::DescribeManagedRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_managed_rule_group(
        &self,
    ) -> fluent_builders::DescribeManagedRuleGroup<C, M, R> {
        fluent_builders::DescribeManagedRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateWebACL` operation.
    ///
    /// See [`DisassociateWebACL`](crate::client::fluent_builders::DisassociateWebACL) for more information about the
    /// operation and its arguments.
    pub fn disassociate_web_acl(&self) -> fluent_builders::DisassociateWebACL<C, M, R> {
        fluent_builders::DisassociateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIPSet` operation.
    ///
    /// See [`GetIPSet`](crate::client::fluent_builders::GetIPSet) for more information about the
    /// operation and its arguments.
    pub fn get_ip_set(&self) -> fluent_builders::GetIPSet<C, M, R> {
        fluent_builders::GetIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoggingConfiguration` operation.
    ///
    /// See [`GetLoggingConfiguration`](crate::client::fluent_builders::GetLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_logging_configuration(&self) -> fluent_builders::GetLoggingConfiguration<C, M, R> {
        fluent_builders::GetLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetManagedRuleSet` operation.
    ///
    /// See [`GetManagedRuleSet`](crate::client::fluent_builders::GetManagedRuleSet) for more information about the
    /// operation and its arguments.
    pub fn get_managed_rule_set(&self) -> fluent_builders::GetManagedRuleSet<C, M, R> {
        fluent_builders::GetManagedRuleSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPermissionPolicy` operation.
    ///
    /// See [`GetPermissionPolicy`](crate::client::fluent_builders::GetPermissionPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_permission_policy(&self) -> fluent_builders::GetPermissionPolicy<C, M, R> {
        fluent_builders::GetPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRateBasedStatementManagedKeys` operation.
    ///
    /// See [`GetRateBasedStatementManagedKeys`](crate::client::fluent_builders::GetRateBasedStatementManagedKeys) for more information about the
    /// operation and its arguments.
    pub fn get_rate_based_statement_managed_keys(
        &self,
    ) -> fluent_builders::GetRateBasedStatementManagedKeys<C, M, R> {
        fluent_builders::GetRateBasedStatementManagedKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegexPatternSet` operation.
    ///
    /// See [`GetRegexPatternSet`](crate::client::fluent_builders::GetRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn get_regex_pattern_set(&self) -> fluent_builders::GetRegexPatternSet<C, M, R> {
        fluent_builders::GetRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRuleGroup` operation.
    ///
    /// See [`GetRuleGroup`](crate::client::fluent_builders::GetRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn get_rule_group(&self) -> fluent_builders::GetRuleGroup<C, M, R> {
        fluent_builders::GetRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSampledRequests` operation.
    ///
    /// See [`GetSampledRequests`](crate::client::fluent_builders::GetSampledRequests) for more information about the
    /// operation and its arguments.
    pub fn get_sampled_requests(&self) -> fluent_builders::GetSampledRequests<C, M, R> {
        fluent_builders::GetSampledRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWebACL` operation.
    ///
    /// See [`GetWebACL`](crate::client::fluent_builders::GetWebACL) for more information about the
    /// operation and its arguments.
    pub fn get_web_acl(&self) -> fluent_builders::GetWebACL<C, M, R> {
        fluent_builders::GetWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWebACLForResource` operation.
    ///
    /// See [`GetWebACLForResource`](crate::client::fluent_builders::GetWebACLForResource) for more information about the
    /// operation and its arguments.
    pub fn get_web_acl_for_resource(&self) -> fluent_builders::GetWebACLForResource<C, M, R> {
        fluent_builders::GetWebACLForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAvailableManagedRuleGroups` operation.
    ///
    /// See [`ListAvailableManagedRuleGroups`](crate::client::fluent_builders::ListAvailableManagedRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn list_available_managed_rule_groups(
        &self,
    ) -> fluent_builders::ListAvailableManagedRuleGroups<C, M, R> {
        fluent_builders::ListAvailableManagedRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAvailableManagedRuleGroupVersions` operation.
    ///
    /// See [`ListAvailableManagedRuleGroupVersions`](crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions) for more information about the
    /// operation and its arguments.
    pub fn list_available_managed_rule_group_versions(
        &self,
    ) -> fluent_builders::ListAvailableManagedRuleGroupVersions<C, M, R> {
        fluent_builders::ListAvailableManagedRuleGroupVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIPSets` operation.
    ///
    /// See [`ListIPSets`](crate::client::fluent_builders::ListIPSets) for more information about the
    /// operation and its arguments.
    pub fn list_ip_sets(&self) -> fluent_builders::ListIPSets<C, M, R> {
        fluent_builders::ListIPSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLoggingConfigurations` operation.
    ///
    /// See [`ListLoggingConfigurations`](crate::client::fluent_builders::ListLoggingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_logging_configurations(
        &self,
    ) -> fluent_builders::ListLoggingConfigurations<C, M, R> {
        fluent_builders::ListLoggingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListManagedRuleSets` operation.
    ///
    /// See [`ListManagedRuleSets`](crate::client::fluent_builders::ListManagedRuleSets) for more information about the
    /// operation and its arguments.
    pub fn list_managed_rule_sets(&self) -> fluent_builders::ListManagedRuleSets<C, M, R> {
        fluent_builders::ListManagedRuleSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRegexPatternSets` operation.
    ///
    /// See [`ListRegexPatternSets`](crate::client::fluent_builders::ListRegexPatternSets) for more information about the
    /// operation and its arguments.
    pub fn list_regex_pattern_sets(&self) -> fluent_builders::ListRegexPatternSets<C, M, R> {
        fluent_builders::ListRegexPatternSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourcesForWebACL` operation.
    ///
    /// See [`ListResourcesForWebACL`](crate::client::fluent_builders::ListResourcesForWebACL) for more information about the
    /// operation and its arguments.
    pub fn list_resources_for_web_acl(&self) -> fluent_builders::ListResourcesForWebACL<C, M, R> {
        fluent_builders::ListResourcesForWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRuleGroups` operation.
    ///
    /// See [`ListRuleGroups`](crate::client::fluent_builders::ListRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn list_rule_groups(&self) -> fluent_builders::ListRuleGroups<C, M, R> {
        fluent_builders::ListRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWebACLs` operation.
    ///
    /// See [`ListWebACLs`](crate::client::fluent_builders::ListWebACLs) for more information about the
    /// operation and its arguments.
    pub fn list_web_ac_ls(&self) -> fluent_builders::ListWebACLs<C, M, R> {
        fluent_builders::ListWebACLs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLoggingConfiguration` operation.
    ///
    /// See [`PutLoggingConfiguration`](crate::client::fluent_builders::PutLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_logging_configuration(&self) -> fluent_builders::PutLoggingConfiguration<C, M, R> {
        fluent_builders::PutLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutManagedRuleSetVersions` operation.
    ///
    /// See [`PutManagedRuleSetVersions`](crate::client::fluent_builders::PutManagedRuleSetVersions) for more information about the
    /// operation and its arguments.
    pub fn put_managed_rule_set_versions(
        &self,
    ) -> fluent_builders::PutManagedRuleSetVersions<C, M, R> {
        fluent_builders::PutManagedRuleSetVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPermissionPolicy` operation.
    ///
    /// See [`PutPermissionPolicy`](crate::client::fluent_builders::PutPermissionPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_permission_policy(&self) -> fluent_builders::PutPermissionPolicy<C, M, R> {
        fluent_builders::PutPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIPSet` operation.
    ///
    /// See [`UpdateIPSet`](crate::client::fluent_builders::UpdateIPSet) for more information about the
    /// operation and its arguments.
    pub fn update_ip_set(&self) -> fluent_builders::UpdateIPSet<C, M, R> {
        fluent_builders::UpdateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateManagedRuleSetVersionExpiryDate` operation.
    ///
    /// See [`UpdateManagedRuleSetVersionExpiryDate`](crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate) for more information about the
    /// operation and its arguments.
    pub fn update_managed_rule_set_version_expiry_date(
        &self,
    ) -> fluent_builders::UpdateManagedRuleSetVersionExpiryDate<C, M, R> {
        fluent_builders::UpdateManagedRuleSetVersionExpiryDate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRegexPatternSet` operation.
    ///
    /// See [`UpdateRegexPatternSet`](crate::client::fluent_builders::UpdateRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn update_regex_pattern_set(&self) -> fluent_builders::UpdateRegexPatternSet<C, M, R> {
        fluent_builders::UpdateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRuleGroup` operation.
    ///
    /// See [`UpdateRuleGroup`](crate::client::fluent_builders::UpdateRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn update_rule_group(&self) -> fluent_builders::UpdateRuleGroup<C, M, R> {
        fluent_builders::UpdateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWebACL` operation.
    ///
    /// See [`UpdateWebACL`](crate::client::fluent_builders::UpdateWebACL) for more information about the
    /// operation and its arguments.
    pub fn update_web_acl(&self) -> fluent_builders::UpdateWebACL<C, M, R> {
        fluent_builders::UpdateWebACL::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateWebACL`.
    ///
    /// <p>Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
    /// <p>For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call <code>UpdateDistribution</code>, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_web_acl_input::Builder,
    }
    impl<C, M, R> AssociateWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateWebAclInputOperationOutputAlias,
                crate::output::AssociateWebAclOutput,
                crate::error::AssociateWebACLError,
                crate::input::AssociateWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with the resource.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to associate with the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckCapacity`.
    ///
    /// <p>Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a <code>RuleGroup</code> or <code>WebACL</code>. </p>
    /// <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckCapacity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_capacity_input::Builder,
    }
    impl<C, M, R> CheckCapacity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckCapacity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckCapacityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckCapacityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckCapacityInputOperationOutputAlias,
                crate::output::CheckCapacityOutput,
                crate::error::CheckCapacityError,
                crate::input::CheckCapacityInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of <code>Rule</code> that you're configuring to use in a rule group or web ACL. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>An array of <code>Rule</code> that you're configuring to use in a rule group or web ACL. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIPSet`.
    ///
    /// <p>Creates an <code>IPSet</code>, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ip_set_input::Builder,
    }
    impl<C, M, R> CreateIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpSetInputOperationOutputAlias,
                crate::output::CreateIpSetOutput,
                crate::error::CreateIPSetError,
                crate::input::CreateIpSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>
        pub fn ip_address_version(mut self, input: crate::model::IpAddressVersion) -> Self {
            self.inner = self.inner.ip_address_version(input);
            self
        }
        /// <p>The version of the IP addresses, either <code>IPV4</code> or <code>IPV6</code>. </p>
        pub fn set_ip_address_version(
            mut self,
            input: std::option::Option<crate::model::IpAddressVersion>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_version(input);
            self
        }
        /// Appends an item to `Addresses`.
        ///
        /// To override the contents of this collection use [`set_addresses`](Self::set_addresses).
        ///
        /// <p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        pub fn addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addresses(input.into());
            self
        }
        /// <p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        pub fn set_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_addresses(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegexPatternSet`.
    ///
    /// <p>Creates a <code>RegexPatternSet</code>, which you reference in a <code>RegexPatternSetReferenceStatement</code>, to have WAF inspect a web request component for the specified patterns.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> CreateRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRegexPatternSetInputOperationOutputAlias,
                crate::output::CreateRegexPatternSetOutput,
                crate::error::CreateRegexPatternSetError,
                crate::input::CreateRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `RegularExpressionList`.
        ///
        /// To override the contents of this collection use [`set_regular_expression_list`](Self::set_regular_expression_list).
        ///
        /// <p>Array of regular expression strings. </p>
        pub fn regular_expression_list(mut self, input: crate::model::Regex) -> Self {
            self.inner = self.inner.regular_expression_list(input);
            self
        }
        /// <p>Array of regular expression strings. </p>
        pub fn set_regular_expression_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Regex>>,
        ) -> Self {
            self.inner = self.inner.set_regular_expression_list(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroup`.
    ///
    /// <p>Creates a <code>RuleGroup</code> per the specifications provided. </p>
    /// <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <code>WebACL</code>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_group_input::Builder,
    }
    impl<C, M, R> CreateRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleGroupInputOperationOutputAlias,
                crate::output::CreateRuleGroupOutput,
                crate::error::CreateRuleGroupError,
                crate::input::CreateRuleGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The web ACL capacity units (WCUs) required for this rule group.</p>
        /// <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <code>CheckCapacity</code>.</p>
        /// <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
        pub fn capacity(mut self, input: i64) -> Self {
            self.inner = self.inner.capacity(input);
            self
        }
        /// <p>The web ACL capacity units (WCUs) required for this rule group.</p>
        /// <p>When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using <code>CheckCapacity</code>.</p>
        /// <p>WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500. </p>
        pub fn set_capacity(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_capacity(input);
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebACL`.
    ///
    /// <p>Creates a <code>WebACL</code> per the specifications provided.</p>
    /// <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <code>Rule</code>, <code>RuleGroup</code>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_web_acl_input::Builder,
    }
    impl<C, M, R> CreateWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWebAclInputOperationOutputAlias,
                crate::output::CreateWebAclOutput,
                crate::error::CreateWebACLError,
                crate::input::CreateWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn default_action(mut self, input: crate::model::DefaultAction) -> Self {
            self.inner = self.inner.default_action(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::DefaultAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn captcha_config(mut self, input: crate::model::CaptchaConfig) -> Self {
            self.inner = self.inner.captcha_config(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn set_captcha_config(
            mut self,
            input: std::option::Option<crate::model::CaptchaConfig>,
        ) -> Self {
            self.inner = self.inner.set_captcha_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallManagerRuleGroups`.
    ///
    /// <p>Deletes all rule groups that are managed by Firewall Manager for the specified web ACL. </p>
    /// <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <code>WebACL</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewallManagerRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_firewall_manager_rule_groups_input::Builder,
    }
    impl<C, M, R> DeleteFirewallManagerRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFirewallManagerRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallManagerRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallManagerRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFirewallManagerRuleGroupsInputOperationOutputAlias,
                crate::output::DeleteFirewallManagerRuleGroupsOutput,
                crate::error::DeleteFirewallManagerRuleGroupsError,
                crate::input::DeleteFirewallManagerRuleGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn web_acl_lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_web_acl_lock_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_web_acl_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIPSet`.
    ///
    /// <p>Deletes the specified <code>IPSet</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ip_set_input::Builder,
    }
    impl<C, M, R> DeleteIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIpSetInputOperationOutputAlias,
                crate::output::DeleteIpSetOutput,
                crate::error::DeleteIPSetError,
                crate::input::DeleteIpSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoggingConfiguration`.
    ///
    /// <p>Deletes the <code>LoggingConfiguration</code> from the specified web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_logging_configuration_input::Builder,
    }
    impl<C, M, R> DeleteLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoggingConfigurationInputOperationOutputAlias,
                crate::output::DeleteLoggingConfigurationOutput,
                crate::error::DeleteLoggingConfigurationError,
                crate::input::DeleteLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermissionPolicy`.
    ///
    /// <p>Permanently deletes an IAM policy from the specified rule group.</p>
    /// <p>You must be the owner of the rule group to perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePermissionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_permission_policy_input::Builder,
    }
    impl<C, M, R> DeletePermissionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePermissionPolicyInputOperationOutputAlias,
                crate::output::DeletePermissionPolicyOutput,
                crate::error::DeletePermissionPolicyError,
                crate::input::DeletePermissionPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p>
        /// <p>You must be the owner of the rule group to perform this operation.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group from which you want to delete the policy.</p>
        /// <p>You must be the owner of the rule group to perform this operation.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegexPatternSet`.
    ///
    /// <p>Deletes the specified <code>RegexPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> DeleteRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegexPatternSetInputOperationOutputAlias,
                crate::output::DeleteRegexPatternSetOutput,
                crate::error::DeleteRegexPatternSetError,
                crate::input::DeleteRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroup`.
    ///
    /// <p>Deletes the specified <code>RuleGroup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_group_input::Builder,
    }
    impl<C, M, R> DeleteRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleGroupInputOperationOutputAlias,
                crate::output::DeleteRuleGroupOutput,
                crate::error::DeleteRuleGroupError,
                crate::input::DeleteRuleGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebACL`.
    ///
    /// <p>Deletes the specified <code>WebACL</code>.</p>
    /// <p>You can only use this if <code>ManagedByFirewallManager</code> is false in the specified <code>WebACL</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_web_acl_input::Builder,
    }
    impl<C, M, R> DeleteWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWebAclInputOperationOutputAlias,
                crate::output::DeleteWebAclOutput,
                crate::error::DeleteWebACLError,
                crate::input::DeleteWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeManagedRuleGroup`.
    ///
    /// <p>Provides high-level information for a managed rule group, including descriptions of the rules. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeManagedRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_managed_rule_group_input::Builder,
    }
    impl<C, M, R> DescribeManagedRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeManagedRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeManagedRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeManagedRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeManagedRuleGroupInputOperationOutputAlias,
                crate::output::DescribeManagedRuleGroupOutput,
                crate::error::DescribeManagedRuleGroupError,
                crate::input::DescribeManagedRuleGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn vendor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor_name(input.into());
            self
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn set_vendor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor_name(input);
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version. </p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>The version of the rule group. You can only use a version that is not scheduled for expiration. If you don't provide this, WAF uses the vendor's default version. </p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateWebACL`.
    ///
    /// <p>Disassociates a web ACL from a regional application resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
    /// <p>For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call <code>UpdateDistribution</code>. For information, see <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">UpdateDistribution</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_web_acl_input::Builder,
    }
    impl<C, M, R> DisassociateWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateWebAclInputOperationOutputAlias,
                crate::output::DisassociateWebAclOutput,
                crate::error::DisassociateWebACLError,
                crate::input::DisassociateWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to disassociate from the web ACL. </p>
        /// <p>The ARN must be in one of the following formats:</p>
        /// <ul>
        /// <li> <p>For an Application Load Balancer: <code>arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> </p> </li>
        /// <li> <p>For an Amazon API Gateway REST API: <code>arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> </code> </p> </li>
        /// <li> <p>For an AppSync GraphQL API: <code>arn:aws:appsync:<i>region</i>:<i>account-id</i>:apis/<i>GraphQLApiId</i> </code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIPSet`.
    ///
    /// <p>Retrieves the specified <code>IPSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ip_set_input::Builder,
    }
    impl<C, M, R> GetIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIpSetInputOperationOutputAlias,
                crate::output::GetIpSetOutput,
                crate::error::GetIPSetError,
                crate::input::GetIpSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggingConfiguration`.
    ///
    /// <p>Returns the <code>LoggingConfiguration</code> for the specified web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_logging_configuration_input::Builder,
    }
    impl<C, M, R> GetLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoggingConfigurationInputOperationOutputAlias,
                crate::output::GetLoggingConfigurationOutput,
                crate::error::GetLoggingConfigurationError,
                crate::input::GetLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetManagedRuleSet`.
    ///
    /// <p>Retrieves the specified managed rule set. </p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetManagedRuleSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_managed_rule_set_input::Builder,
    }
    impl<C, M, R> GetManagedRuleSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetManagedRuleSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetManagedRuleSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetManagedRuleSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetManagedRuleSetInputOperationOutputAlias,
                crate::output::GetManagedRuleSetOutput,
                crate::error::GetManagedRuleSetError,
                crate::input::GetManagedRuleSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPermissionPolicy`.
    ///
    /// <p>Returns the IAM policy that is attached to the specified rule group.</p>
    /// <p>You must be the owner of the rule group to perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPermissionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_permission_policy_input::Builder,
    }
    impl<C, M, R> GetPermissionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPermissionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPermissionPolicyInputOperationOutputAlias,
                crate::output::GetPermissionPolicyOutput,
                crate::error::GetPermissionPolicyError,
                crate::input::GetPermissionPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule group for which you want to get the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRateBasedStatementManagedKeys`.
    ///
    /// <p>Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.</p>
    /// <p>For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name. </p>
    /// <p>WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRateBasedStatementManagedKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rate_based_statement_managed_keys_input::Builder,
    }
    impl<C, M, R> GetRateBasedStatementManagedKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRateBasedStatementManagedKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRateBasedStatementManagedKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRateBasedStatementManagedKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRateBasedStatementManagedKeysInputOperationOutputAlias,
                crate::output::GetRateBasedStatementManagedKeysOutput,
                crate::error::GetRateBasedStatementManagedKeysError,
                crate::input::GetRateBasedStatementManagedKeysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn web_acl_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_web_acl_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_name(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>
        pub fn rule_group_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_rule_name(input.into());
            self
        }
        /// <p>The name of the rule group reference statement in your web ACL. This is required only when you have the rate-based rule nested inside a rule group. </p>
        pub fn set_rule_group_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_rule_name(input);
            self
        }
        /// <p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>
        pub fn rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_name(input.into());
            self
        }
        /// <p>The name of the rate-based rule to get the keys for. If you have the rule defined inside a rule group that you're using in your web ACL, also provide the name of the rule group reference statement in the request parameter <code>RuleGroupRuleName</code>.</p>
        pub fn set_rule_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegexPatternSet`.
    ///
    /// <p>Retrieves the specified <code>RegexPatternSet</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> GetRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegexPatternSetInputOperationOutputAlias,
                crate::output::GetRegexPatternSetOutput,
                crate::error::GetRegexPatternSetError,
                crate::input::GetRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRuleGroup`.
    ///
    /// <p>Retrieves the specified <code>RuleGroup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rule_group_input::Builder,
    }
    impl<C, M, R> GetRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRuleGroupInputOperationOutputAlias,
                crate::output::GetRuleGroupOutput,
                crate::error::GetRuleGroupError,
                crate::input::GetRuleGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSampledRequests`.
    ///
    /// <p>Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.</p>
    /// <p> <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSampledRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sampled_requests_input::Builder,
    }
    impl<C, M, R> GetSampledRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSampledRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSampledRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSampledRequestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSampledRequestsInputOperationOutputAlias,
                crate::output::GetSampledRequestsOutput,
                crate::error::GetSampledRequestsError,
                crate::input::GetSampledRequestsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) of the <code>WebACL</code> for which you want a sample of requests.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of requests.</p>
        pub fn rule_metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_metric_name(input.into());
            self
        }
        /// <p>The metric name assigned to the <code>Rule</code> or <code>RuleGroup</code> for which you want a sample of requests.</p>
        pub fn set_rule_metric_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_metric_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.</p>
        pub fn time_window(mut self, input: crate::model::TimeWindow) -> Self {
            self.inner = self.inner.time_window(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours. If you specify a start time that's earlier than three hours ago, WAF sets it to three hours ago.</p>
        pub fn set_time_window(
            mut self,
            input: std::option::Option<crate::model::TimeWindow>,
        ) -> Self {
            self.inner = self.inner.set_time_window(input);
            self
        }
        /// <p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
        pub fn max_items(mut self, input: i64) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of requests that you want WAF to return from among the first 5,000 requests that your Amazon Web Services resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebACL`.
    ///
    /// <p>Retrieves the specified <code>WebACL</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_web_acl_input::Builder,
    }
    impl<C, M, R> GetWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWebAclInputOperationOutputAlias,
                crate::output::GetWebAclOutput,
                crate::error::GetWebACLError,
                crate::input::GetWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebACLForResource`.
    ///
    /// <p>Retrieves the <code>WebACL</code> for the specified resource. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWebACLForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_web_acl_for_resource_input::Builder,
    }
    impl<C, M, R> GetWebACLForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWebACLForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebAclForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebACLForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWebAclForResourceInputOperationOutputAlias,
                crate::output::GetWebAclForResourceOutput,
                crate::error::GetWebACLForResourceError,
                crate::input::GetWebAclForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableManagedRuleGroups`.
    ///
    /// <p>Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableManagedRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_available_managed_rule_groups_input::Builder,
    }
    impl<C, M, R> ListAvailableManagedRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAvailableManagedRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableManagedRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAvailableManagedRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAvailableManagedRuleGroupsInputOperationOutputAlias,
                crate::output::ListAvailableManagedRuleGroupsOutput,
                crate::error::ListAvailableManagedRuleGroupsError,
                crate::input::ListAvailableManagedRuleGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAvailableManagedRuleGroupVersions`.
    ///
    /// <p>Returns a list of the available versions for the specified managed rule group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAvailableManagedRuleGroupVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_available_managed_rule_group_versions_input::Builder,
    }
    impl<C, M, R> ListAvailableManagedRuleGroupVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAvailableManagedRuleGroupVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAvailableManagedRuleGroupVersionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAvailableManagedRuleGroupVersionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAvailableManagedRuleGroupVersionsInputOperationOutputAlias,
                crate::output::ListAvailableManagedRuleGroupVersionsOutput,
                crate::error::ListAvailableManagedRuleGroupVersionsError,
                crate::input::ListAvailableManagedRuleGroupVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn vendor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vendor_name(input.into());
            self
        }
        /// <p>The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.</p>
        pub fn set_vendor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vendor_name(input);
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIPSets`.
    ///
    /// <p>Retrieves an array of <code>IPSetSummary</code> objects for the IP sets that you manage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIPSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ip_sets_input::Builder,
    }
    impl<C, M, R> ListIPSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIPSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIPSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIpSetsInputOperationOutputAlias,
                crate::output::ListIpSetsOutput,
                crate::error::ListIPSetsError,
                crate::input::ListIpSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLoggingConfigurations`.
    ///
    /// <p>Retrieves an array of your <code>LoggingConfiguration</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLoggingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_logging_configurations_input::Builder,
    }
    impl<C, M, R> ListLoggingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLoggingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLoggingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLoggingConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLoggingConfigurationsInputOperationOutputAlias,
                crate::output::ListLoggingConfigurationsOutput,
                crate::error::ListLoggingConfigurationsError,
                crate::input::ListLoggingConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedRuleSets`.
    ///
    /// <p>Retrieves the managed rule sets that you own. </p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedRuleSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_managed_rule_sets_input::Builder,
    }
    impl<C, M, R> ListManagedRuleSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListManagedRuleSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedRuleSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedRuleSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListManagedRuleSetsInputOperationOutputAlias,
                crate::output::ListManagedRuleSetsOutput,
                crate::error::ListManagedRuleSetsError,
                crate::input::ListManagedRuleSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegexPatternSets`.
    ///
    /// <p>Retrieves an array of <code>RegexPatternSetSummary</code> objects for the regex pattern sets that you manage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRegexPatternSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_regex_pattern_sets_input::Builder,
    }
    impl<C, M, R> ListRegexPatternSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRegexPatternSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegexPatternSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegexPatternSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRegexPatternSetsInputOperationOutputAlias,
                crate::output::ListRegexPatternSetsOutput,
                crate::error::ListRegexPatternSetsError,
                crate::input::ListRegexPatternSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourcesForWebACL`.
    ///
    /// <p>Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call <code>ListDistributionsByWebACLId</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourcesForWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resources_for_web_acl_input::Builder,
    }
    impl<C, M, R> ListResourcesForWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourcesForWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourcesForWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourcesForWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourcesForWebAclInputOperationOutputAlias,
                crate::output::ListResourcesForWebAclOutput,
                crate::error::ListResourcesForWebACLError,
                crate::input::ListResourcesForWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_arn(input);
            self
        }
        /// <p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>Used for web ACLs that are scoped for regional applications. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroups`.
    ///
    /// <p>Retrieves an array of <code>RuleGroupSummary</code> objects for the rule groups that you manage. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rule_groups_input::Builder,
    }
    impl<C, M, R> ListRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRuleGroupsInputOperationOutputAlias,
                crate::output::ListRuleGroupsOutput,
                crate::error::ListRuleGroupsError,
                crate::input::ListRuleGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the <code>TagInfoForResource</code> for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebACLs`.
    ///
    /// <p>Retrieves an array of <code>WebACLSummary</code> objects for the web ACLs that you manage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebACLs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_web_ac_ls_input::Builder,
    }
    impl<C, M, R> ListWebACLs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWebACLs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebAcLsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebACLsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWebAcLsInputOperationOutputAlias,
                crate::output::ListWebAcLsOutput,
                crate::error::ListWebACLsError,
                crate::input::ListWebAcLsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>When you request a list of objects with a <code>Limit</code> setting, if the number of objects that are still available for retrieval exceeds the limit, WAF returns a <code>NextMarker</code> value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of objects that you want WAF to return for this request. If more objects are available, in the response, WAF provides a <code>NextMarker</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingConfiguration`.
    ///
    /// <p>Enables the specified <code>LoggingConfiguration</code>, to start logging from a web ACL, according to the configuration provided.</p>
    /// <p>You can access information about all traffic that WAF inspects using the following steps:</p>
    /// <ol>
    /// <li> <p>Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. For information about configuring logging destinations and the permissions that are required for each, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p> </li>
    /// <li> <p>Associate your logging destination to your web ACL using a <code>PutLoggingConfiguration</code> request.</p> </li>
    /// </ol>
    /// <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling <code>GetLoggingConfiguration</code>, update the settings as needed, and then provide the complete logging configuration specification to this call.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_logging_configuration_input::Builder,
    }
    impl<C, M, R> PutLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLoggingConfigurationInputOperationOutputAlias,
                crate::output::PutLoggingConfigurationOutput,
                crate::error::PutLoggingConfigurationError,
                crate::input::PutLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p></p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutManagedRuleSetVersions`.
    ///
    /// <p>Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.</p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    /// <p>Customers retrieve their managed rule group list by calling <code>ListAvailableManagedRuleGroups</code>. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling <code>ListAvailableManagedRuleGroupVersions</code>. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using. </p>
    /// <p>To initiate the expiration of a managed rule group version, use <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutManagedRuleSetVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_managed_rule_set_versions_input::Builder,
    }
    impl<C, M, R> PutManagedRuleSetVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutManagedRuleSetVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutManagedRuleSetVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutManagedRuleSetVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutManagedRuleSetVersionsInputOperationOutputAlias,
                crate::output::PutManagedRuleSetVersionsOutput,
                crate::error::PutManagedRuleSetVersionsError,
                crate::input::PutManagedRuleSetVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// <p>The version of the named managed rule group that you'd like your customers to choose, from among your version offerings. </p>
        pub fn recommended_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommended_version(input.into());
            self
        }
        /// <p>The version of the named managed rule group that you'd like your customers to choose, from among your version offerings. </p>
        pub fn set_recommended_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommended_version(input);
            self
        }
        /// Adds a key-value pair to `VersionsToPublish`.
        ///
        /// To override the contents of this collection use [`set_versions_to_publish`](Self::set_versions_to_publish).
        ///
        /// <p>The versions of the named managed rule group that you want to offer to your customers. </p>
        pub fn versions_to_publish(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::VersionToPublish,
        ) -> Self {
            self.inner = self.inner.versions_to_publish(k.into(), v);
            self
        }
        /// <p>The versions of the named managed rule group that you want to offer to your customers. </p>
        pub fn set_versions_to_publish(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::VersionToPublish>,
            >,
        ) -> Self {
            self.inner = self.inner.set_versions_to_publish(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermissionPolicy`.
    ///
    /// <p>Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.</p>
    /// <p>You must be the owner of the rule group to perform this operation.</p>
    /// <p>This action is subject to the following restrictions:</p>
    /// <ul>
    /// <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li>
    /// <li> <p>The ARN in the request must be a valid WAF <code>RuleGroup</code> ARN and the rule group must exist in the same Region.</p> </li>
    /// <li> <p>The user making the request must be the owner of the rule group.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPermissionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_permission_policy_input::Builder,
    }
    impl<C, M, R> PutPermissionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPermissionPolicyInputOperationOutputAlias,
                crate::output::PutPermissionPolicyOutput,
                crate::error::PutPermissionPolicyError,
                crate::input::PutPermissionPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>RuleGroup</code> to which you want to attach the policy.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>RuleGroup</code> to which you want to attach the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The policy to attach to the specified rule group. </p>
        /// <p>The policy specifications must conform to the following:</p>
        /// <ul>
        /// <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>
        /// <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>
        /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
        /// <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>
        /// <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to attach to the specified rule group. </p>
        /// <p>The policy specifications must conform to the following:</p>
        /// <ul>
        /// <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>
        /// <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>
        /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
        /// <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>
        /// <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.</p>
    /// <p>You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key:value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array of keys identifying the tags to disassociate from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>An array of keys identifying the tags to disassociate from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIPSet`.
    ///
    /// <p>Updates the specified <code>IPSet</code>. </p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling <code>GetIPSet</code>, update the settings as needed, and then provide the complete IP set specification to this call.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ip_set_input::Builder,
    }
    impl<C, M, R> UpdateIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIpSetInputOperationOutputAlias,
                crate::output::UpdateIpSetOutput,
                crate::error::UpdateIPSetError,
                crate::input::UpdateIpSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the IP set. You cannot change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the IP set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Addresses`.
        ///
        /// To override the contents of this collection use [`set_addresses`](Self::set_addresses).
        ///
        /// <p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        pub fn addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addresses(input.into());
            self
        }
        /// <p>Contains an array of strings that specify one or more IP addresses or blocks of IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for /0. </p>
        /// <p>Examples: </p>
        /// <ul>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        pub fn set_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_addresses(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateManagedRuleSetVersionExpiryDate`.
    ///
    /// <p>Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the reponse to <code>ListAvailableManagedRuleGroupVersions</code> for the managed rule group. </p> <note>
    /// <p>This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers. </p>
    /// <p>Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are <code>ListManagedRuleSets</code>, <code>GetManagedRuleSet</code>, <code>PutManagedRuleSetVersions</code>, and <code>UpdateManagedRuleSetVersionExpiryDate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateManagedRuleSetVersionExpiryDate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_managed_rule_set_version_expiry_date_input::Builder,
    }
    impl<C, M, R> UpdateManagedRuleSetVersionExpiryDate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateManagedRuleSetVersionExpiryDate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateManagedRuleSetVersionExpiryDateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateManagedRuleSetVersionExpiryDateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateManagedRuleSetVersionExpiryDateInputOperationOutputAlias,
                crate::output::UpdateManagedRuleSetVersionExpiryDateOutput,
                crate::error::UpdateManagedRuleSetVersionExpiryDateError,
                crate::input::UpdateManagedRuleSetVersionExpiryDateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the managed rule set. You use this, along with the rule set ID, to identify the rule set.</p>
        /// <p>This name is assigned to the corresponding managed rule group, which your customers can access and use. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the managed rule set. The ID is returned in the responses to commands like <code>list</code>. You provide it to operations like <code>get</code> and <code>update</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// <p>The version that you want to remove from your list of offerings for the named managed rule group. </p>
        pub fn version_to_expire(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_to_expire(input.into());
            self
        }
        /// <p>The version that you want to remove from your list of offerings for the named managed rule group. </p>
        pub fn set_version_to_expire(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_to_expire(input);
            self
        }
        /// <p>The time that you want the version to expire.</p>
        /// <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>
        pub fn expiry_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expiry_timestamp(input);
            self
        }
        /// <p>The time that you want the version to expire.</p>
        /// <p>Times are in Coordinated Universal Time (UTC) format. UTC format includes the special designator, Z. For example, "2016-09-27T14:50Z". </p>
        pub fn set_expiry_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expiry_timestamp(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegexPatternSet`.
    ///
    /// <p>Updates the specified <code>RegexPatternSet</code>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling <code>GetRegexPatternSet</code>, update the settings as needed, and then provide the complete regex pattern set specification to this call.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> UpdateRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRegexPatternSetInputOperationOutputAlias,
                crate::output::UpdateRegexPatternSetOutput,
                crate::error::UpdateRegexPatternSetError,
                crate::input::UpdateRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the set. You cannot change the name after you create the set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the set that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `RegularExpressionList`.
        ///
        /// To override the contents of this collection use [`set_regular_expression_list`](Self::set_regular_expression_list).
        ///
        /// <p></p>
        pub fn regular_expression_list(mut self, input: crate::model::Regex) -> Self {
            self.inner = self.inner.regular_expression_list(input);
            self
        }
        /// <p></p>
        pub fn set_regular_expression_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Regex>>,
        ) -> Self {
            self.inner = self.inner.set_regular_expression_list(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleGroup`.
    ///
    /// <p>Updates the specified <code>RuleGroup</code>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling <code>GetRuleGroup</code>, update the settings as needed, and then provide the complete rule group specification to this call.</p>
    /// </note>
    /// <p> A rule group defines a collection of rules to inspect and control web requests that you can use in a <code>WebACL</code>. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rule_group_input::Builder,
    }
    impl<C, M, R> UpdateRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRuleGroupInputOperationOutputAlias,
                crate::output::UpdateRuleGroupOutput,
                crate::error::UpdateRuleGroupError,
                crate::input::UpdateRuleGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group. You cannot change the name of a rule group after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule group that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebACL`.
    ///
    /// <p>Updates the specified <code>WebACL</code>.</p> <note>
    /// <p>This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling <code>GetWebACL</code>, update the settings as needed, and then provide the complete web ACL specification to this call.</p>
    /// </note>
    /// <p> A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types <code>Rule</code>, <code>RuleGroup</code>, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_web_acl_input::Builder,
    }
    impl<C, M, R> UpdateWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWebAclInputOperationOutputAlias,
                crate::output::UpdateWebAclOutput,
                crate::error::UpdateWebACLError,
                crate::input::UpdateWebAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the web ACL. You cannot change the name of a web ACL after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API. </p>
        /// <p>To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows: </p>
        /// <ul>
        /// <li> <p>CLI - Specify the Region when you use the CloudFront scope: <code>--scope=CLOUDFRONT --region=us-east-1</code>. </p> </li>
        /// <li> <p>API and SDKs - For all calls, use the Region endpoint us-east-1. </p> </li>
        /// </ul>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the web ACL. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn default_action(mut self, input: crate::model::DefaultAction) -> Self {
            self.inner = self.inner.default_action(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. </p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::DefaultAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the web ACL that helps with identification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn rules(mut self, input: crate::model::Rule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Rule</code> statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn visibility_config(mut self, input: crate::model::VisibilityConfig) -> Self {
            self.inner = self.inner.visibility_config(input);
            self
        }
        /// <p>Defines and enables Amazon CloudWatch metrics and web request sample collection. </p>
        pub fn set_visibility_config(
            mut self,
            input: std::option::Option<crate::model::VisibilityConfig>,
        ) -> Self {
            self.inner = self.inner.set_visibility_config(input);
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn lock_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lock_token(input.into());
            self
        }
        /// <p>A token used for optimistic locking. WAF returns a token to your <code>get</code> and <code>list</code> requests, to mark the state of the entity at the time of the request. To make changes to the entity associated with the token, you provide the token to operations like <code>update</code> and <code>delete</code>. WAF uses the token to ensure that no changes have been made to the entity since you last retrieved it. If a change has been made, the update fails with a <code>WAFOptimisticLockException</code>. If this happens, perform another <code>get</code>, and use the new token returned by that operation. </p>
        pub fn set_lock_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lock_token(input);
            self
        }
        /// Adds a key-value pair to `CustomResponseBodies`.
        ///
        /// To override the contents of this collection use [`set_custom_response_bodies`](Self::set_custom_response_bodies).
        ///
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn custom_response_bodies(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CustomResponseBody,
        ) -> Self {
            self.inner = self.inner.custom_response_bodies(k.into(), v);
            self
        }
        /// <p>A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. </p>
        /// <p>For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        /// <p>For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">WAF Developer Guide</a>. </p>
        pub fn set_custom_response_bodies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CustomResponseBody>,
            >,
        ) -> Self {
            self.inner = self.inner.set_custom_response_bodies(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn captcha_config(mut self, input: crate::model::CaptchaConfig) -> Self {
            self.inner = self.inner.captcha_config(input);
            self
        }
        /// <p>Specifies how WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings. If you don't specify this, WAF uses its default settings for <code>CaptchaConfig</code>. </p>
        pub fn set_captcha_config(
            mut self,
            input: std::option::Option<crate::model::CaptchaConfig>,
        ) -> Self {
            self.inner = self.inner.set_captcha_config(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
