// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateWebAclOutput, crate::error::AssociateWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateWebAclOutput, crate::error::AssociateWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_web_acl_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_check_capacity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CheckCapacityOutput, crate::error::CheckCapacityError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CheckCapacityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CheckCapacityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFExpiredManagedRuleGroupVersionException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafExpiredManagedRuleGroupVersionException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_expired_managed_rule_group_version_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_expired_managed_rule_group_version_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInternalErrorException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidResourceException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafInvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFSubscriptionNotFoundException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafSubscriptionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_subscription_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_subscription_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::CheckCapacityError {
            meta: generic,
            kind: crate::error::CheckCapacityErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CheckCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CheckCapacityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_check_capacity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CheckCapacityOutput, crate::error::CheckCapacityError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::check_capacity_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_check_capacity(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CheckCapacityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::CreateIPSetError {
                meta: generic,
                kind: crate::error::CreateIPSetErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRegexPatternSetOutput,
    crate::error::CreateRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind:
                crate::error::CreateRegexPatternSetErrorKind::WafTagOperationInternalErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::CreateRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRegexPatternSetOutput,
    crate::error::CreateRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleGroupOutput, crate::error::CreateRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFSubscriptionNotFoundException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafSubscriptionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_subscription_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_subscription_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafTagOperationInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_tag_operation_internal_error_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleGroupOutput, crate::error::CreateRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWebAclOutput, crate::error::CreateWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidResourceException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFSubscriptionNotFoundException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafSubscriptionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_subscription_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_subscription_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::CreateWebACLError {
                meta: generic,
                kind: crate::error::CreateWebACLErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "WAFUnavailableEntityException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWebAclOutput, crate::error::CreateWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_firewall_manager_rule_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFirewallManagerRuleGroupsOutput,
    crate::error::DeleteFirewallManagerRuleGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteFirewallManagerRuleGroupsError {
            meta: generic,
            kind: crate::error::DeleteFirewallManagerRuleGroupsErrorKind::WafInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInvalidOperationException" => crate::error::DeleteFirewallManagerRuleGroupsError {
            meta: generic,
            kind:
                crate::error::DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidOperationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_invalid_operation_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFInvalidParameterException" => crate::error::DeleteFirewallManagerRuleGroupsError {
            meta: generic,
            kind:
                crate::error::DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFNonexistentItemException" => crate::error::DeleteFirewallManagerRuleGroupsError {
            meta: generic,
            kind:
                crate::error::DeleteFirewallManagerRuleGroupsErrorKind::WafNonexistentItemException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_nonexistent_item_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFOptimisticLockException" => crate::error::DeleteFirewallManagerRuleGroupsError {
            meta: generic,
            kind:
                crate::error::DeleteFirewallManagerRuleGroupsErrorKind::WafOptimisticLockException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_optimistic_lock_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DeleteFirewallManagerRuleGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_firewall_manager_rule_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFirewallManagerRuleGroupsOutput,
    crate::error::DeleteFirewallManagerRuleGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_firewall_manager_rule_groups_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_delete_firewall_manager_rule_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DeleteFirewallManagerRuleGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFAssociatedItemException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafAssociatedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_associated_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_associated_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::DeleteIPSetError {
                meta: generic,
                kind: crate::error::DeleteIPSetErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_ip_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_logging_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoggingConfigurationOutput,
    crate::error::DeleteLoggingConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteLoggingConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafInvalidOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInvalidParameterException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafInvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFNonexistentItemException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLoggingConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_logging_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoggingConfigurationOutput,
    crate::error::DeleteLoggingConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_logging_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_permission_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePermissionPolicyOutput,
    crate::error::DeletePermissionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeletePermissionPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeletePermissionPolicyError {
            meta: generic,
            kind: crate::error::DeletePermissionPolicyErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DeletePermissionPolicyError {
            meta: generic,
            kind: crate::error::DeletePermissionPolicyErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeletePermissionPolicyError {
            meta: generic,
            kind: crate::error::DeletePermissionPolicyErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePermissionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_permission_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePermissionPolicyOutput,
    crate::error::DeletePermissionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_permission_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegexPatternSetOutput,
    crate::error::DeleteRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFAssociatedItemException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafAssociatedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_associated_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_associated_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind:
                crate::error::DeleteRegexPatternSetErrorKind::WafTagOperationInternalErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DeleteRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegexPatternSetOutput,
    crate::error::DeleteRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_regex_pattern_set_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleGroupOutput, crate::error::DeleteRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFAssociatedItemException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafAssociatedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_associated_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_associated_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_tag_operation_internal_error_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleGroupOutput, crate::error::DeleteRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_rule_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWebAclOutput, crate::error::DeleteWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFAssociatedItemException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafAssociatedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_associated_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_associated_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::DeleteWebACLError {
                meta: generic,
                kind: crate::error::DeleteWebACLErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWebAclOutput, crate::error::DeleteWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_web_acl_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_managed_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeManagedRuleGroupOutput,
    crate::error::DescribeManagedRuleGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeManagedRuleGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFExpiredManagedRuleGroupVersionException" => crate::error::DescribeManagedRuleGroupError { meta: generic, kind: crate::error::DescribeManagedRuleGroupErrorKind::WafExpiredManagedRuleGroupVersionException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_expired_managed_rule_group_version_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_expired_managed_rule_group_version_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInternalErrorException" => crate::error::DescribeManagedRuleGroupError { meta: generic, kind: crate::error::DescribeManagedRuleGroupErrorKind::WafInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidOperationException" => crate::error::DescribeManagedRuleGroupError { meta: generic, kind: crate::error::DescribeManagedRuleGroupErrorKind::WafInvalidOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidParameterException" => crate::error::DescribeManagedRuleGroupError { meta: generic, kind: crate::error::DescribeManagedRuleGroupErrorKind::WafInvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidResourceException" => crate::error::DescribeManagedRuleGroupError { meta: generic, kind: crate::error::DescribeManagedRuleGroupErrorKind::WafInvalidResourceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFNonexistentItemException" => crate::error::DescribeManagedRuleGroupError { meta: generic, kind: crate::error::DescribeManagedRuleGroupErrorKind::WafNonexistentItemException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeManagedRuleGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_managed_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeManagedRuleGroupOutput,
    crate::error::DescribeManagedRuleGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_managed_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_managed_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeManagedRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateWebAclOutput,
    crate::error::DisassociateWebACLError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateWebAclOutput,
    crate::error::DisassociateWebACLError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_web_acl_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_logging_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoggingConfigurationOutput,
    crate::error::GetLoggingConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetLoggingConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetLoggingConfigurationError {
            meta: generic,
            kind: crate::error::GetLoggingConfigurationErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetLoggingConfigurationError {
            meta: generic,
            kind: crate::error::GetLoggingConfigurationErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetLoggingConfigurationError {
            meta: generic,
            kind: crate::error::GetLoggingConfigurationErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetLoggingConfigurationError {
            meta: generic,
            kind: crate::error::GetLoggingConfigurationErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLoggingConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_logging_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoggingConfigurationOutput,
    crate::error::GetLoggingConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_logging_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_logging_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_managed_rule_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetManagedRuleSetOutput, crate::error::GetManagedRuleSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetManagedRuleSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetManagedRuleSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetManagedRuleSetError {
            meta: generic,
            kind: crate::error::GetManagedRuleSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetManagedRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetManagedRuleSetError {
            meta: generic,
            kind: crate::error::GetManagedRuleSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetManagedRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetManagedRuleSetError {
            meta: generic,
            kind: crate::error::GetManagedRuleSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetManagedRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetManagedRuleSetError {
            meta: generic,
            kind: crate::error::GetManagedRuleSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetManagedRuleSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetManagedRuleSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_managed_rule_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetManagedRuleSetOutput, crate::error::GetManagedRuleSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_managed_rule_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_managed_rule_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetManagedRuleSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_permission_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPermissionPolicyOutput,
    crate::error::GetPermissionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPermissionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPermissionPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetPermissionPolicyError {
            meta: generic,
            kind: crate::error::GetPermissionPolicyErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetPermissionPolicyError {
            meta: generic,
            kind: crate::error::GetPermissionPolicyErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetPermissionPolicyError {
            meta: generic,
            kind: crate::error::GetPermissionPolicyErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPermissionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_permission_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPermissionPolicyOutput,
    crate::error::GetPermissionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_permission_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_permission_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPermissionPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rate_based_statement_managed_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRateBasedStatementManagedKeysOutput,
    crate::error::GetRateBasedStatementManagedKeysError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRateBasedStatementManagedKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRateBasedStatementManagedKeysError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRateBasedStatementManagedKeysError { meta: generic, kind: crate::error::GetRateBasedStatementManagedKeysErrorKind::WafInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedStatementManagedKeysError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidOperationException" => crate::error::GetRateBasedStatementManagedKeysError { meta: generic, kind: crate::error::GetRateBasedStatementManagedKeysErrorKind::WafInvalidOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedStatementManagedKeysError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidParameterException" => crate::error::GetRateBasedStatementManagedKeysError { meta: generic, kind: crate::error::GetRateBasedStatementManagedKeysErrorKind::WafInvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedStatementManagedKeysError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFNonexistentItemException" => crate::error::GetRateBasedStatementManagedKeysError { meta: generic, kind: crate::error::GetRateBasedStatementManagedKeysErrorKind::WafNonexistentItemException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedStatementManagedKeysError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRateBasedStatementManagedKeysError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rate_based_statement_managed_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRateBasedStatementManagedKeysOutput,
    crate::error::GetRateBasedStatementManagedKeysError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_rate_based_statement_managed_keys_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_rate_based_statement_managed_keys(response.body().as_ref(), output).map_err(crate::error::GetRateBasedStatementManagedKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRegexPatternSetOutput,
    crate::error::GetRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRegexPatternSetOutput,
    crate::error::GetRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRuleGroupOutput, crate::error::GetRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRuleGroupError {
            meta: generic,
            kind: crate::error::GetRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetRuleGroupError {
            meta: generic,
            kind: crate::error::GetRuleGroupErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetRuleGroupError {
            meta: generic,
            kind: crate::error::GetRuleGroupErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRuleGroupError {
            meta: generic,
            kind: crate::error::GetRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRuleGroupOutput, crate::error::GetRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sampled_requests_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSampledRequestsOutput,
    crate::error::GetSampledRequestsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSampledRequestsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSampledRequestsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetSampledRequestsError {
            meta: generic,
            kind: crate::error::GetSampledRequestsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSampledRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetSampledRequestsError {
            meta: generic,
            kind: crate::error::GetSampledRequestsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSampledRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetSampledRequestsError {
            meta: generic,
            kind: crate::error::GetSampledRequestsErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSampledRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSampledRequestsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sampled_requests_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSampledRequestsOutput,
    crate::error::GetSampledRequestsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_sampled_requests_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_sampled_requests(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSampledRequestsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetWebAclOutput, crate::error::GetWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetWebAclOutput, crate::error::GetWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetWebAclForResourceOutput,
    crate::error::GetWebACLForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetWebACLForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetWebACLForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetWebACLForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetWebAclForResourceOutput,
    crate::error::GetWebACLForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_web_acl_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_web_acl_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetWebACLForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_managed_rule_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableManagedRuleGroupsOutput,
    crate::error::ListAvailableManagedRuleGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAvailableManagedRuleGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAvailableManagedRuleGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListAvailableManagedRuleGroupsError {
            meta: generic,
            kind: crate::error::ListAvailableManagedRuleGroupsErrorKind::WafInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInvalidOperationException" => crate::error::ListAvailableManagedRuleGroupsError {
            meta: generic,
            kind:
                crate::error::ListAvailableManagedRuleGroupsErrorKind::WafInvalidOperationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_invalid_operation_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFInvalidParameterException" => crate::error::ListAvailableManagedRuleGroupsError {
            meta: generic,
            kind:
                crate::error::ListAvailableManagedRuleGroupsErrorKind::WafInvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ListAvailableManagedRuleGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_managed_rule_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableManagedRuleGroupsOutput,
    crate::error::ListAvailableManagedRuleGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_available_managed_rule_groups_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_available_managed_rule_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListAvailableManagedRuleGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_managed_rule_group_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableManagedRuleGroupVersionsOutput,
    crate::error::ListAvailableManagedRuleGroupVersionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAvailableManagedRuleGroupVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListAvailableManagedRuleGroupVersionsError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListAvailableManagedRuleGroupVersionsError { meta: generic, kind: crate::error::ListAvailableManagedRuleGroupVersionsErrorKind::WafInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupVersionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidOperationException" => crate::error::ListAvailableManagedRuleGroupVersionsError { meta: generic, kind: crate::error::ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupVersionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidParameterException" => crate::error::ListAvailableManagedRuleGroupVersionsError { meta: generic, kind: crate::error::ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupVersionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListAvailableManagedRuleGroupVersionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_available_managed_rule_group_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAvailableManagedRuleGroupVersionsOutput,
    crate::error::ListAvailableManagedRuleGroupVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_available_managed_rule_group_versions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_available_managed_rule_group_versions(response.body().as_ref(), output).map_err(crate::error::ListAvailableManagedRuleGroupVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ip_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIPSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListIPSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListIPSetsError {
            meta: generic,
            kind: crate::error::ListIPSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIPSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListIPSetsError {
            meta: generic,
            kind: crate::error::ListIPSetsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIPSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListIPSetsError {
            meta: generic,
            kind: crate::error::ListIPSetsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIPSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListIPSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ip_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_ip_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_ip_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIPSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_logging_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLoggingConfigurationsOutput,
    crate::error::ListLoggingConfigurationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListLoggingConfigurationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListLoggingConfigurationsError {
            meta: generic,
            kind: crate::error::ListLoggingConfigurationsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListLoggingConfigurationsError {
            meta: generic,
            kind: crate::error::ListLoggingConfigurationsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListLoggingConfigurationsError {
            meta: generic,
            kind: crate::error::ListLoggingConfigurationsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLoggingConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_logging_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLoggingConfigurationsOutput,
    crate::error::ListLoggingConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_logging_configurations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_logging_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_managed_rule_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListManagedRuleSetsOutput,
    crate::error::ListManagedRuleSetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListManagedRuleSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListManagedRuleSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListManagedRuleSetsError {
            meta: generic,
            kind: crate::error::ListManagedRuleSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListManagedRuleSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListManagedRuleSetsError {
            meta: generic,
            kind: crate::error::ListManagedRuleSetsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListManagedRuleSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListManagedRuleSetsError {
            meta: generic,
            kind: crate::error::ListManagedRuleSetsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListManagedRuleSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListManagedRuleSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_managed_rule_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListManagedRuleSetsOutput,
    crate::error::ListManagedRuleSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_managed_rule_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_managed_rule_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListManagedRuleSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regex_pattern_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegexPatternSetsOutput,
    crate::error::ListRegexPatternSetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRegexPatternSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRegexPatternSetsError {
            meta: generic,
            kind: crate::error::ListRegexPatternSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListRegexPatternSetsError {
            meta: generic,
            kind: crate::error::ListRegexPatternSetsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListRegexPatternSetsError {
            meta: generic,
            kind: crate::error::ListRegexPatternSetsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRegexPatternSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regex_pattern_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegexPatternSetsOutput,
    crate::error::ListRegexPatternSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_regex_pattern_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_regex_pattern_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_for_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesForWebAclOutput,
    crate::error::ListResourcesForWebACLError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListResourcesForWebACLError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListResourcesForWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_for_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesForWebAclOutput,
    crate::error::ListResourcesForWebACLError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_resources_for_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resources_for_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rule_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRuleGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRuleGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRuleGroupsError {
            meta: generic,
            kind: crate::error::ListRuleGroupsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRuleGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListRuleGroupsError {
            meta: generic,
            kind: crate::error::ListRuleGroupsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRuleGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListRuleGroupsError {
            meta: generic,
            kind: crate::error::ListRuleGroupsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRuleGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRuleGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rule_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_rule_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_rule_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRuleGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_web_ac_ls_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWebAcLsOutput, crate::error::ListWebACLsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWebACLsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListWebACLsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListWebACLsError {
            meta: generic,
            kind: crate::error::ListWebACLsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebACLsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::ListWebACLsError {
            meta: generic,
            kind: crate::error::ListWebACLsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebACLsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListWebACLsError {
            meta: generic,
            kind: crate::error::ListWebACLsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebACLsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListWebACLsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_web_ac_ls_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWebAcLsOutput, crate::error::ListWebACLsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_web_ac_ls_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_web_ac_ls(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListWebACLsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_logging_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLoggingConfigurationOutput,
    crate::error::PutLoggingConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutLoggingConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidOperationException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafInvalidOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidParameterException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafInvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFLimitsExceededException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafLimitsExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFLogDestinationPermissionIssueException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafLogDestinationPermissionIssueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_log_destination_permission_issue_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_log_destination_permission_issue_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFNonexistentItemException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafNonexistentItemException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFOptimisticLockException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafOptimisticLockException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFServiceLinkedRoleErrorException" => crate::error::PutLoggingConfigurationError { meta: generic, kind: crate::error::PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_service_linked_role_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_service_linked_role_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutLoggingConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_logging_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLoggingConfigurationOutput,
    crate::error::PutLoggingConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_logging_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_logging_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_managed_rule_set_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutManagedRuleSetVersionsOutput,
    crate::error::PutManagedRuleSetVersionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutManagedRuleSetVersionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::PutManagedRuleSetVersionsError {
            meta: generic,
            kind: crate::error::PutManagedRuleSetVersionsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::PutManagedRuleSetVersionsError {
            meta: generic,
            kind: crate::error::PutManagedRuleSetVersionsErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::PutManagedRuleSetVersionsError {
            meta: generic,
            kind: crate::error::PutManagedRuleSetVersionsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::PutManagedRuleSetVersionsError {
            meta: generic,
            kind: crate::error::PutManagedRuleSetVersionsErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::PutManagedRuleSetVersionsError {
            meta: generic,
            kind: crate::error::PutManagedRuleSetVersionsErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutManagedRuleSetVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_managed_rule_set_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutManagedRuleSetVersionsOutput,
    crate::error::PutManagedRuleSetVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_managed_rule_set_versions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_managed_rule_set_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutManagedRuleSetVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_permission_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPermissionPolicyOutput,
    crate::error::PutPermissionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutPermissionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutPermissionPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::PutPermissionPolicyError {
            meta: generic,
            kind: crate::error::PutPermissionPolicyErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::PutPermissionPolicyError {
            meta: generic,
            kind: crate::error::PutPermissionPolicyErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidPermissionPolicyException" => {
            crate::error::PutPermissionPolicyError {
                meta: generic,
                kind:
                    crate::error::PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::waf_invalid_permission_policy_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_waf_invalid_permission_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "WAFNonexistentItemException" => crate::error::PutPermissionPolicyError {
            meta: generic,
            kind: crate::error::PutPermissionPolicyErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutPermissionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_permission_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPermissionPolicyOutput,
    crate::error::PutPermissionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_permission_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafTagOperationInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_tag_operation_internal_error_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_managed_rule_set_version_expiry_date_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateManagedRuleSetVersionExpiryDateOutput,
    crate::error::UpdateManagedRuleSetVersionExpiryDateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateManagedRuleSetVersionExpiryDateError { meta: generic, kind: crate::error::UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInternalErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidOperationException" => crate::error::UpdateManagedRuleSetVersionExpiryDateError { meta: generic, kind: crate::error::UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidOperationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFInvalidParameterException" => crate::error::UpdateManagedRuleSetVersionExpiryDateError { meta: generic, kind: crate::error::UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFNonexistentItemException" => crate::error::UpdateManagedRuleSetVersionExpiryDateError { meta: generic, kind: crate::error::UpdateManagedRuleSetVersionExpiryDateErrorKind::WafNonexistentItemException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "WAFOptimisticLockException" => crate::error::UpdateManagedRuleSetVersionExpiryDateError { meta: generic, kind: crate::error::UpdateManagedRuleSetVersionExpiryDateErrorKind::WafOptimisticLockException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateManagedRuleSetVersionExpiryDateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_managed_rule_set_version_expiry_date_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateManagedRuleSetVersionExpiryDateOutput,
    crate::error::UpdateManagedRuleSetVersionExpiryDateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_managed_rule_set_version_expiry_date_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_managed_rule_set_version_expiry_date(response.body().as_ref(), output).map_err(crate::error::UpdateManagedRuleSetVersionExpiryDateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRegexPatternSetOutput,
    crate::error::UpdateRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRegexPatternSetOutput,
    crate::error::UpdateRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRuleGroupOutput, crate::error::UpdateRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFSubscriptionNotFoundException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafSubscriptionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_subscription_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_subscription_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRuleGroupOutput, crate::error::UpdateRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWebAclOutput, crate::error::UpdateWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDuplicateItemException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafDuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFExpiredManagedRuleGroupVersionException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafExpiredManagedRuleGroupVersionException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_expired_managed_rule_group_version_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_expired_managed_rule_group_version_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInternalErrorException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidResourceException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInvalidResourceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_resource_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_resource_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFOptimisticLockException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafOptimisticLockException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_optimistic_lock_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_optimistic_lock_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFSubscriptionNotFoundException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafSubscriptionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_subscription_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_subscription_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWebAclOutput, crate::error::UpdateWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateWebACLError::unhandled)?;
        output.build()
    })
}
