// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateWebACLError {
    /// Kind of error that occurred.
    pub kind: AssociateWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateWebACLErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            AssociateWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            AssociateWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            AssociateWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            AssociateWebACLErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            AssociateWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateWebACLError {
    fn code(&self) -> Option<&str> {
        AssociateWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateWebACLError {
    /// Creates a new `AssociateWebACLError`.
    pub fn new(kind: AssociateWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateWebACLErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateWebACLErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for AssociateWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            AssociateWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            AssociateWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            AssociateWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            AssociateWebACLErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            AssociateWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckCapacityError {
    /// Kind of error that occurred.
    pub kind: CheckCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckCapacityErrorKind {
    /// <p>The operation failed because the specified version for the managed rule group has expired. You can retrieve the available versions for the managed rule group by calling <code>ListAvailableManagedRuleGroupVersions</code>.</p>
    WafExpiredManagedRuleGroupVersionException(
        crate::error::WafExpiredManagedRuleGroupVersionException,
    ),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>
    WafInvalidResourceException(crate::error::WafInvalidResourceException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it yet. </p>
    WafSubscriptionNotFoundException(crate::error::WafSubscriptionNotFoundException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckCapacityErrorKind::WafExpiredManagedRuleGroupVersionException(_inner) => {
                _inner.fmt(f)
            }
            CheckCapacityErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::WafInvalidResourceException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::WafSubscriptionNotFoundException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            CheckCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckCapacityError {
    fn code(&self) -> Option<&str> {
        CheckCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckCapacityError {
    /// Creates a new `CheckCapacityError`.
    pub fn new(kind: CheckCapacityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckCapacityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafExpiredManagedRuleGroupVersionException`.
    pub fn is_waf_expired_managed_rule_group_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafExpiredManagedRuleGroupVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafInvalidResourceException`.
    pub fn is_waf_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafInvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafSubscriptionNotFoundException`.
    pub fn is_waf_subscription_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafSubscriptionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckCapacityErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckCapacityErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for CheckCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckCapacityErrorKind::WafExpiredManagedRuleGroupVersionException(_inner) => {
                Some(_inner)
            }
            CheckCapacityErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CheckCapacityErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CheckCapacityErrorKind::WafInvalidResourceException(_inner) => Some(_inner),
            CheckCapacityErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CheckCapacityErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            CheckCapacityErrorKind::WafSubscriptionNotFoundException(_inner) => Some(_inner),
            CheckCapacityErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            CheckCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIPSetError {
    /// Kind of error that occurred.
    pub kind: CreateIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIPSetErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIPSetErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIPSetError {
    fn code(&self) -> Option<&str> {
        CreateIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIPSetError {
    /// Creates a new `CreateIPSetError`.
    pub fn new(kind: CreateIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for CreateIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIPSetErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            CreateIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: CreateRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRegexPatternSetErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRegexPatternSetErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        CreateRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRegexPatternSetError {
    /// Creates a new `CreateRegexPatternSetError`.
    pub fn new(kind: CreateRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for CreateRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRegexPatternSetErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafTagOperationInternalErrorException(_inner) => {
                Some(_inner)
            }
            CreateRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleGroupError {
    /// Kind of error that occurred.
    pub kind: CreateRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleGroupErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it yet. </p>
    WafSubscriptionNotFoundException(crate::error::WafSubscriptionNotFoundException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleGroupErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafSubscriptionNotFoundException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateRuleGroupErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleGroupError {
    fn code(&self) -> Option<&str> {
        CreateRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRuleGroupError {
    /// Creates a new `CreateRuleGroupError`.
    pub fn new(kind: CreateRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafSubscriptionNotFoundException`.
    pub fn is_waf_subscription_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafSubscriptionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for CreateRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleGroupErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafSubscriptionNotFoundException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWebACLError {
    /// Kind of error that occurred.
    pub kind: CreateWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWebACLErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>
    WafInvalidResourceException(crate::error::WafInvalidResourceException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it yet. </p>
    WafSubscriptionNotFoundException(crate::error::WafSubscriptionNotFoundException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWebACLErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInvalidResourceException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafSubscriptionNotFoundException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWebACLError {
    fn code(&self) -> Option<&str> {
        CreateWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWebACLError {
    /// Creates a new `CreateWebACLError`.
    pub fn new(kind: CreateWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInvalidResourceException`.
    pub fn is_waf_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafSubscriptionNotFoundException`.
    pub fn is_waf_subscription_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafSubscriptionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for CreateWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWebACLErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInvalidResourceException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafSubscriptionNotFoundException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            CreateWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFirewallManagerRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFirewallManagerRuleGroupsError {
    /// Kind of error that occurred.
    pub kind: DeleteFirewallManagerRuleGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFirewallManagerRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFirewallManagerRuleGroupsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFirewallManagerRuleGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFirewallManagerRuleGroupsErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafOptimisticLockException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFirewallManagerRuleGroupsError {
    fn code(&self) -> Option<&str> {
        DeleteFirewallManagerRuleGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFirewallManagerRuleGroupsError {
    /// Creates a new `DeleteFirewallManagerRuleGroupsError`.
    pub fn new(
        kind: DeleteFirewallManagerRuleGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFirewallManagerRuleGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFirewallManagerRuleGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFirewallManagerRuleGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFirewallManagerRuleGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFirewallManagerRuleGroupsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallManagerRuleGroupsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFirewallManagerRuleGroupsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallManagerRuleGroupsErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFirewallManagerRuleGroupsErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFirewallManagerRuleGroupsErrorKind::WafOptimisticLockException(_)
        )
    }
}
impl std::error::Error for DeleteFirewallManagerRuleGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFirewallManagerRuleGroupsErrorKind::WafInternalErrorException(_inner) => {
                Some(_inner)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::WafOptimisticLockException(_inner) => {
                Some(_inner)
            }
            DeleteFirewallManagerRuleGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIPSetError {
    /// Kind of error that occurred.
    pub kind: DeleteIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIPSetErrorKind {
    /// <p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>
    WafAssociatedItemException(crate::error::WafAssociatedItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIPSetErrorKind::WafAssociatedItemException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIPSetError {
    fn code(&self) -> Option<&str> {
        DeleteIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIPSetError {
    /// Creates a new `DeleteIPSetError`.
    pub fn new(kind: DeleteIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafAssociatedItemException`.
    pub fn is_waf_associated_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafAssociatedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIPSetErrorKind::WafAssociatedItemException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoggingConfigurationErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteLoggingConfigurationErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoggingConfigurationErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoggingConfigurationErrorKind::WafOptimisticLockException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoggingConfigurationError {
    /// Creates a new `DeleteLoggingConfigurationError`.
    pub fn new(kind: DeleteLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafOptimisticLockException(_)
        )
    }
}
impl std::error::Error for DeleteLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteLoggingConfigurationErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            DeleteLoggingConfigurationErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            DeleteLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            DeleteLoggingConfigurationErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            DeleteLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePermissionPolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePermissionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePermissionPolicyErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePermissionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePermissionPolicyErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeletePermissionPolicyErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            DeletePermissionPolicyErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeletePermissionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePermissionPolicyError {
    fn code(&self) -> Option<&str> {
        DeletePermissionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePermissionPolicyError {
    /// Creates a new `DeletePermissionPolicyError`.
    pub fn new(kind: DeletePermissionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePermissionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePermissionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePermissionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePermissionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePermissionPolicyErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionPolicyErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionPolicyErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionPolicyErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionPolicyErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionPolicyErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for DeletePermissionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePermissionPolicyErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeletePermissionPolicyErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DeletePermissionPolicyErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeletePermissionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: DeleteRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegexPatternSetErrorKind {
    /// <p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>
    WafAssociatedItemException(crate::error::WafAssociatedItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegexPatternSetErrorKind::WafAssociatedItemException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        DeleteRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegexPatternSetError {
    /// Creates a new `DeleteRegexPatternSetError`.
    pub fn new(kind: DeleteRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafAssociatedItemException`.
    pub fn is_waf_associated_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafAssociatedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegexPatternSetErrorKind::WafAssociatedItemException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafTagOperationInternalErrorException(_inner) => {
                Some(_inner)
            }
            DeleteRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleGroupErrorKind {
    /// <p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>
    WafAssociatedItemException(crate::error::WafAssociatedItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleGroupErrorKind::WafAssociatedItemException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleGroupError {
    fn code(&self) -> Option<&str> {
        DeleteRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleGroupError {
    /// Creates a new `DeleteRuleGroupError`.
    pub fn new(kind: DeleteRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafAssociatedItemException`.
    pub fn is_waf_associated_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafAssociatedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleGroupErrorKind::WafAssociatedItemException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWebACLError {
    /// Kind of error that occurred.
    pub kind: DeleteWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWebACLErrorKind {
    /// <p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>
    WafAssociatedItemException(crate::error::WafAssociatedItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWebACLErrorKind::WafAssociatedItemException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWebACLError {
    fn code(&self) -> Option<&str> {
        DeleteWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWebACLError {
    /// Creates a new `DeleteWebACLError`.
    pub fn new(kind: DeleteWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafAssociatedItemException`.
    pub fn is_waf_associated_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafAssociatedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWebACLErrorKind::WafAssociatedItemException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeManagedRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeManagedRuleGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeManagedRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeManagedRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeManagedRuleGroupErrorKind {
    /// <p>The operation failed because the specified version for the managed rule group has expired. You can retrieve the available versions for the managed rule group by calling <code>ListAvailableManagedRuleGroupVersions</code>.</p>
    WafExpiredManagedRuleGroupVersionException(
        crate::error::WafExpiredManagedRuleGroupVersionException,
    ),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>
    WafInvalidResourceException(crate::error::WafInvalidResourceException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeManagedRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeManagedRuleGroupErrorKind::WafExpiredManagedRuleGroupVersionException(
                _inner,
            ) => _inner.fmt(f),
            DescribeManagedRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DescribeManagedRuleGroupErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeManagedRuleGroupErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeManagedRuleGroupErrorKind::WafInvalidResourceException(_inner) => _inner.fmt(f),
            DescribeManagedRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DescribeManagedRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeManagedRuleGroupError {
    fn code(&self) -> Option<&str> {
        DescribeManagedRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeManagedRuleGroupError {
    /// Creates a new `DescribeManagedRuleGroupError`.
    pub fn new(kind: DescribeManagedRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeManagedRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeManagedRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeManagedRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeManagedRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeManagedRuleGroupErrorKind::WafExpiredManagedRuleGroupVersionException`.
    pub fn is_waf_expired_managed_rule_group_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedRuleGroupErrorKind::WafExpiredManagedRuleGroupVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedRuleGroupErrorKind::WafInvalidResourceException`.
    pub fn is_waf_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedRuleGroupErrorKind::WafInvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeManagedRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeManagedRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for DescribeManagedRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeManagedRuleGroupErrorKind::WafExpiredManagedRuleGroupVersionException(
                _inner,
            ) => Some(_inner),
            DescribeManagedRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DescribeManagedRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DescribeManagedRuleGroupErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DescribeManagedRuleGroupErrorKind::WafInvalidResourceException(_inner) => Some(_inner),
            DescribeManagedRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DescribeManagedRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateWebACLError {
    /// Kind of error that occurred.
    pub kind: DisassociateWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateWebACLErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DisassociateWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            DisassociateWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DisassociateWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateWebACLError {
    fn code(&self) -> Option<&str> {
        DisassociateWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateWebACLError {
    /// Creates a new `DisassociateWebACLError`.
    pub fn new(kind: DisassociateWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for DisassociateWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DisassociateWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DisassociateWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            DisassociateWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DisassociateWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateMobileSdkReleaseUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateMobileSdkReleaseUrlError {
    /// Kind of error that occurred.
    pub kind: GenerateMobileSdkReleaseUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateMobileSdkReleaseUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateMobileSdkReleaseUrlErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateMobileSdkReleaseUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateMobileSdkReleaseUrlErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            GenerateMobileSdkReleaseUrlErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            GenerateMobileSdkReleaseUrlErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GenerateMobileSdkReleaseUrlErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            GenerateMobileSdkReleaseUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateMobileSdkReleaseUrlError {
    fn code(&self) -> Option<&str> {
        GenerateMobileSdkReleaseUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateMobileSdkReleaseUrlError {
    /// Creates a new `GenerateMobileSdkReleaseUrlError`.
    pub fn new(kind: GenerateMobileSdkReleaseUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateMobileSdkReleaseUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateMobileSdkReleaseUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateMobileSdkReleaseUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateMobileSdkReleaseUrlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateMobileSdkReleaseUrlErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateMobileSdkReleaseUrlErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateMobileSdkReleaseUrlErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateMobileSdkReleaseUrlErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateMobileSdkReleaseUrlErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateMobileSdkReleaseUrlErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateMobileSdkReleaseUrlErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateMobileSdkReleaseUrlErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GenerateMobileSdkReleaseUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateMobileSdkReleaseUrlErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GenerateMobileSdkReleaseUrlErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            GenerateMobileSdkReleaseUrlErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            GenerateMobileSdkReleaseUrlErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            GenerateMobileSdkReleaseUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIPSetError {
    /// Kind of error that occurred.
    pub kind: GetIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIPSetErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIPSetError {
    fn code(&self) -> Option<&str> {
        GetIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIPSetError {
    /// Creates a new `GetIPSetError`.
    pub fn new(kind: GetIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetIPSetErrorKind::WafInternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIPSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIPSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIPSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetIPSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetIPSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetIPSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoggingConfigurationErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetLoggingConfigurationErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetLoggingConfigurationErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoggingConfigurationError {
    /// Creates a new `GetLoggingConfigurationError`.
    pub fn new(kind: GetLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoggingConfigurationErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingConfigurationErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoggingConfigurationErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingConfigurationErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoggingConfigurationErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingConfigurationErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoggingConfigurationErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingConfigurationErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetLoggingConfigurationErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetLoggingConfigurationErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetManagedRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetManagedRuleSetError {
    /// Kind of error that occurred.
    pub kind: GetManagedRuleSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetManagedRuleSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetManagedRuleSetErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetManagedRuleSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetManagedRuleSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetManagedRuleSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetManagedRuleSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetManagedRuleSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetManagedRuleSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetManagedRuleSetError {
    fn code(&self) -> Option<&str> {
        GetManagedRuleSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetManagedRuleSetError {
    /// Creates a new `GetManagedRuleSetError`.
    pub fn new(kind: GetManagedRuleSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetManagedRuleSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetManagedRuleSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetManagedRuleSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetManagedRuleSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetManagedRuleSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetManagedRuleSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetManagedRuleSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetManagedRuleSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetManagedRuleSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetManagedRuleSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetManagedRuleSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetManagedRuleSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetManagedRuleSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetManagedRuleSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetManagedRuleSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetManagedRuleSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetManagedRuleSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetManagedRuleSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMobileSdkRelease` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMobileSdkReleaseError {
    /// Kind of error that occurred.
    pub kind: GetMobileSdkReleaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMobileSdkRelease` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMobileSdkReleaseErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMobileSdkReleaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMobileSdkReleaseErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetMobileSdkReleaseErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetMobileSdkReleaseErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetMobileSdkReleaseErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetMobileSdkReleaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMobileSdkReleaseError {
    fn code(&self) -> Option<&str> {
        GetMobileSdkReleaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMobileSdkReleaseError {
    /// Creates a new `GetMobileSdkReleaseError`.
    pub fn new(kind: GetMobileSdkReleaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMobileSdkReleaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMobileSdkReleaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMobileSdkReleaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMobileSdkReleaseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMobileSdkReleaseErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileSdkReleaseErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileSdkReleaseErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileSdkReleaseErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileSdkReleaseErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileSdkReleaseErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMobileSdkReleaseErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMobileSdkReleaseErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetMobileSdkReleaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMobileSdkReleaseErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetMobileSdkReleaseErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetMobileSdkReleaseErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetMobileSdkReleaseErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetMobileSdkReleaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPermissionPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPermissionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPermissionPolicyErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPermissionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPermissionPolicyErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetPermissionPolicyErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetPermissionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPermissionPolicyError {
    fn code(&self) -> Option<&str> {
        GetPermissionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPermissionPolicyError {
    /// Creates a new `GetPermissionPolicyError`.
    pub fn new(kind: GetPermissionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPermissionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPermissionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPermissionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPermissionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPermissionPolicyErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionPolicyErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionPolicyErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionPolicyErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionPolicyErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionPolicyErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetPermissionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPermissionPolicyErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetPermissionPolicyErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetPermissionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRateBasedStatementManagedKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRateBasedStatementManagedKeysError {
    /// Kind of error that occurred.
    pub kind: GetRateBasedStatementManagedKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRateBasedStatementManagedKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRateBasedStatementManagedKeysErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRateBasedStatementManagedKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRateBasedStatementManagedKeysErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedStatementManagedKeysErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedStatementManagedKeysErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedStatementManagedKeysErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedStatementManagedKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRateBasedStatementManagedKeysError {
    fn code(&self) -> Option<&str> {
        GetRateBasedStatementManagedKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRateBasedStatementManagedKeysError {
    /// Creates a new `GetRateBasedStatementManagedKeysError`.
    pub fn new(
        kind: GetRateBasedStatementManagedKeysErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRateBasedStatementManagedKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRateBasedStatementManagedKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRateBasedStatementManagedKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRateBasedStatementManagedKeysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRateBasedStatementManagedKeysErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedStatementManagedKeysErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedStatementManagedKeysErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedStatementManagedKeysErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedStatementManagedKeysErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedStatementManagedKeysErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedStatementManagedKeysErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedStatementManagedKeysErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRateBasedStatementManagedKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRateBasedStatementManagedKeysErrorKind::WafInternalErrorException(_inner) => {
                Some(_inner)
            }
            GetRateBasedStatementManagedKeysErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            GetRateBasedStatementManagedKeysErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetRateBasedStatementManagedKeysErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            GetRateBasedStatementManagedKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: GetRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegexPatternSetErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        GetRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegexPatternSetError {
    /// Creates a new `GetRegexPatternSetError`.
    pub fn new(kind: GetRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRuleGroupError {
    /// Kind of error that occurred.
    pub kind: GetRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRuleGroupErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRuleGroupErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetRuleGroupErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRuleGroupError {
    fn code(&self) -> Option<&str> {
        GetRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRuleGroupError {
    /// Creates a new `GetRuleGroupError`.
    pub fn new(kind: GetRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetRuleGroupErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSampledRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSampledRequestsError {
    /// Kind of error that occurred.
    pub kind: GetSampledRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSampledRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSampledRequestsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSampledRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSampledRequestsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetSampledRequestsErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetSampledRequestsErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetSampledRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSampledRequestsError {
    fn code(&self) -> Option<&str> {
        GetSampledRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSampledRequestsError {
    /// Creates a new `GetSampledRequestsError`.
    pub fn new(kind: GetSampledRequestsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSampledRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSampledRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSampledRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSampledRequestsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSampledRequestsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampledRequestsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSampledRequestsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampledRequestsErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSampledRequestsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampledRequestsErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetSampledRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSampledRequestsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetSampledRequestsErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetSampledRequestsErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetSampledRequestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWebACLError {
    /// Kind of error that occurred.
    pub kind: GetWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWebACLErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWebACLError {
    fn code(&self) -> Option<&str> {
        GetWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWebACLError {
    /// Creates a new `GetWebACLError`.
    pub fn new(kind: GetWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetWebACLErrorKind::WafInternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWebACLForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWebACLForResourceError {
    /// Kind of error that occurred.
    pub kind: GetWebACLForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWebACLForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWebACLForResourceErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWebACLForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWebACLForResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetWebACLForResourceErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            GetWebACLForResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            GetWebACLForResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetWebACLForResourceErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            GetWebACLForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWebACLForResourceError {
    fn code(&self) -> Option<&str> {
        GetWebACLForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWebACLForResourceError {
    /// Creates a new `GetWebACLForResourceError`.
    pub fn new(kind: GetWebACLForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWebACLForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWebACLForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWebACLForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWebACLForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWebACLForResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLForResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLForResourceErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLForResourceErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLForResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLForResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLForResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLForResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLForResourceErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLForResourceErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for GetWebACLForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWebACLForResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetWebACLForResourceErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            GetWebACLForResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            GetWebACLForResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetWebACLForResourceErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            GetWebACLForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAvailableManagedRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAvailableManagedRuleGroupsError {
    /// Kind of error that occurred.
    pub kind: ListAvailableManagedRuleGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAvailableManagedRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAvailableManagedRuleGroupsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAvailableManagedRuleGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAvailableManagedRuleGroupsErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagedRuleGroupsErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagedRuleGroupsErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagedRuleGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAvailableManagedRuleGroupsError {
    fn code(&self) -> Option<&str> {
        ListAvailableManagedRuleGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAvailableManagedRuleGroupsError {
    /// Creates a new `ListAvailableManagedRuleGroupsError`.
    pub fn new(
        kind: ListAvailableManagedRuleGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAvailableManagedRuleGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAvailableManagedRuleGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAvailableManagedRuleGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAvailableManagedRuleGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListAvailableManagedRuleGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAvailableManagedRuleGroupsErrorKind::WafInternalErrorException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagedRuleGroupsErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagedRuleGroupsErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagedRuleGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAvailableManagedRuleGroupVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAvailableManagedRuleGroupVersionsError {
    /// Kind of error that occurred.
    pub kind: ListAvailableManagedRuleGroupVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAvailableManagedRuleGroupVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAvailableManagedRuleGroupVersionsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAvailableManagedRuleGroupVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidOperationException(
                _inner,
            ) => _inner.fmt(f),
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidParameterException(
                _inner,
            ) => _inner.fmt(f),
            ListAvailableManagedRuleGroupVersionsErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            ListAvailableManagedRuleGroupVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAvailableManagedRuleGroupVersionsError {
    fn code(&self) -> Option<&str> {
        ListAvailableManagedRuleGroupVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAvailableManagedRuleGroupVersionsError {
    /// Creates a new `ListAvailableManagedRuleGroupVersionsError`.
    pub fn new(
        kind: ListAvailableManagedRuleGroupVersionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAvailableManagedRuleGroupVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAvailableManagedRuleGroupVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAvailableManagedRuleGroupVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAvailableManagedRuleGroupVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupVersionsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAvailableManagedRuleGroupVersionsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAvailableManagedRuleGroupVersionsErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for ListAvailableManagedRuleGroupVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInternalErrorException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidOperationException(
                _inner,
            ) => Some(_inner),
            ListAvailableManagedRuleGroupVersionsErrorKind::WafInvalidParameterException(
                _inner,
            ) => Some(_inner),
            ListAvailableManagedRuleGroupVersionsErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            ListAvailableManagedRuleGroupVersionsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListIPSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIPSetsError {
    /// Kind of error that occurred.
    pub kind: ListIPSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIPSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIPSetsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIPSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIPSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIPSetsError {
    fn code(&self) -> Option<&str> {
        ListIPSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIPSetsError {
    /// Creates a new `ListIPSetsError`.
    pub fn new(kind: ListIPSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIPSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIPSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIPSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIPSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIPSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIPSetsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIPSetsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListIPSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIPSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListIPSetsErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListIPSetsErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListIPSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLoggingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLoggingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListLoggingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLoggingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLoggingConfigurationsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLoggingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLoggingConfigurationsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListLoggingConfigurationsErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            ListLoggingConfigurationsErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListLoggingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLoggingConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListLoggingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLoggingConfigurationsError {
    /// Creates a new `ListLoggingConfigurationsError`.
    pub fn new(kind: ListLoggingConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLoggingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLoggingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLoggingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLoggingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLoggingConfigurationsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLoggingConfigurationsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLoggingConfigurationsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLoggingConfigurationsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLoggingConfigurationsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLoggingConfigurationsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListLoggingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLoggingConfigurationsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListLoggingConfigurationsErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            ListLoggingConfigurationsErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListLoggingConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListManagedRuleSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListManagedRuleSetsError {
    /// Kind of error that occurred.
    pub kind: ListManagedRuleSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListManagedRuleSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListManagedRuleSetsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListManagedRuleSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListManagedRuleSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListManagedRuleSetsErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListManagedRuleSetsErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListManagedRuleSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListManagedRuleSetsError {
    fn code(&self) -> Option<&str> {
        ListManagedRuleSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListManagedRuleSetsError {
    /// Creates a new `ListManagedRuleSetsError`.
    pub fn new(kind: ListManagedRuleSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListManagedRuleSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListManagedRuleSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListManagedRuleSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListManagedRuleSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListManagedRuleSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedRuleSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedRuleSetsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedRuleSetsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListManagedRuleSetsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListManagedRuleSetsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListManagedRuleSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListManagedRuleSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListManagedRuleSetsErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListManagedRuleSetsErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListManagedRuleSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMobileSdkReleases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMobileSdkReleasesError {
    /// Kind of error that occurred.
    pub kind: ListMobileSdkReleasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMobileSdkReleases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMobileSdkReleasesErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMobileSdkReleasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMobileSdkReleasesErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListMobileSdkReleasesErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListMobileSdkReleasesErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListMobileSdkReleasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMobileSdkReleasesError {
    fn code(&self) -> Option<&str> {
        ListMobileSdkReleasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMobileSdkReleasesError {
    /// Creates a new `ListMobileSdkReleasesError`.
    pub fn new(kind: ListMobileSdkReleasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMobileSdkReleasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMobileSdkReleasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMobileSdkReleasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMobileSdkReleasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMobileSdkReleasesErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileSdkReleasesErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileSdkReleasesErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileSdkReleasesErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMobileSdkReleasesErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMobileSdkReleasesErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListMobileSdkReleasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMobileSdkReleasesErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListMobileSdkReleasesErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListMobileSdkReleasesErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListMobileSdkReleasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRegexPatternSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRegexPatternSetsError {
    /// Kind of error that occurred.
    pub kind: ListRegexPatternSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRegexPatternSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRegexPatternSetsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRegexPatternSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRegexPatternSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRegexPatternSetsErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListRegexPatternSetsErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListRegexPatternSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRegexPatternSetsError {
    fn code(&self) -> Option<&str> {
        ListRegexPatternSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRegexPatternSetsError {
    /// Creates a new `ListRegexPatternSetsError`.
    pub fn new(kind: ListRegexPatternSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRegexPatternSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRegexPatternSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRegexPatternSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRegexPatternSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRegexPatternSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexPatternSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRegexPatternSetsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexPatternSetsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRegexPatternSetsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexPatternSetsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListRegexPatternSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRegexPatternSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRegexPatternSetsErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListRegexPatternSetsErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListRegexPatternSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourcesForWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourcesForWebACLError {
    /// Kind of error that occurred.
    pub kind: ListResourcesForWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourcesForWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourcesForWebACLErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourcesForWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourcesForWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListResourcesForWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListResourcesForWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListResourcesForWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            ListResourcesForWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourcesForWebACLError {
    fn code(&self) -> Option<&str> {
        ListResourcesForWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourcesForWebACLError {
    /// Creates a new `ListResourcesForWebACLError`.
    pub fn new(kind: ListResourcesForWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourcesForWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourcesForWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourcesForWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourcesForWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourcesForWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesForWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesForWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourcesForWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourcesForWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for ListResourcesForWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourcesForWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListResourcesForWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListResourcesForWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListResourcesForWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            ListResourcesForWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRuleGroupsError {
    /// Kind of error that occurred.
    pub kind: ListRuleGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRuleGroupsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRuleGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRuleGroupsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRuleGroupsError {
    fn code(&self) -> Option<&str> {
        ListRuleGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRuleGroupsError {
    /// Creates a new `ListRuleGroupsError`.
    pub fn new(kind: ListRuleGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRuleGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRuleGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRuleGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRuleGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRuleGroupsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleGroupsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleGroupsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListRuleGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRuleGroupsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafTagOperationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(_inner) => {
                Some(_inner)
            }
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWebACLs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWebACLsError {
    /// Kind of error that occurred.
    pub kind: ListWebACLsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWebACLs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWebACLsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWebACLsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWebACLsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListWebACLsErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            ListWebACLsErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListWebACLsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWebACLsError {
    fn code(&self) -> Option<&str> {
        ListWebACLsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWebACLsError {
    /// Creates a new `ListWebACLsError`.
    pub fn new(kind: ListWebACLsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWebACLsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWebACLsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWebACLsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWebACLsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWebACLsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebACLsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebACLsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebACLsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebACLsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebACLsErrorKind::WafInvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListWebACLsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWebACLsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListWebACLsErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            ListWebACLsErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListWebACLsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLoggingConfigurationErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you don't have the permissions that your logging configuration requires. For information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>
    WafLogDestinationPermissionIssueException(
        crate::error::WafLogDestinationPermissionIssueException,
    ),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>WAF is not able to access the service linked role. This can be caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20 seconds. Please try your request again. The service linked role can also be locked by a previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the request again. If you receive this same exception again, you will have to wait additional time until the role is unlocked.</p>
    WafServiceLinkedRoleErrorException(crate::error::WafServiceLinkedRoleErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafLogDestinationPermissionIssueException(_inner) => {
                _inner.fmt(f)
            }
            PutLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(_inner) => {
                _inner.fmt(f)
            }
            PutLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        PutLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLoggingConfigurationError {
    /// Creates a new `PutLoggingConfigurationError`.
    pub fn new(kind: PutLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafLogDestinationPermissionIssueException`.
    pub fn is_waf_log_destination_permission_issue_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafLogDestinationPermissionIssueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException`.
    pub fn is_waf_service_linked_role_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(_)
        )
    }
}
impl std::error::Error for PutLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafLogDestinationPermissionIssueException(_inner) => {
                Some(_inner)
            }
            PutLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(_inner) => {
                Some(_inner)
            }
            PutLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutManagedRuleSetVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutManagedRuleSetVersionsError {
    /// Kind of error that occurred.
    pub kind: PutManagedRuleSetVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutManagedRuleSetVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutManagedRuleSetVersionsErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutManagedRuleSetVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutManagedRuleSetVersionsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            PutManagedRuleSetVersionsErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            PutManagedRuleSetVersionsErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutManagedRuleSetVersionsErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            PutManagedRuleSetVersionsErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            PutManagedRuleSetVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutManagedRuleSetVersionsError {
    fn code(&self) -> Option<&str> {
        PutManagedRuleSetVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutManagedRuleSetVersionsError {
    /// Creates a new `PutManagedRuleSetVersionsError`.
    pub fn new(kind: PutManagedRuleSetVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutManagedRuleSetVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutManagedRuleSetVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutManagedRuleSetVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutManagedRuleSetVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutManagedRuleSetVersionsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutManagedRuleSetVersionsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutManagedRuleSetVersionsErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutManagedRuleSetVersionsErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutManagedRuleSetVersionsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutManagedRuleSetVersionsErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutManagedRuleSetVersionsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutManagedRuleSetVersionsErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `PutManagedRuleSetVersionsErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutManagedRuleSetVersionsErrorKind::WafOptimisticLockException(_)
        )
    }
}
impl std::error::Error for PutManagedRuleSetVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutManagedRuleSetVersionsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            PutManagedRuleSetVersionsErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            PutManagedRuleSetVersionsErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            PutManagedRuleSetVersionsErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            PutManagedRuleSetVersionsErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            PutManagedRuleSetVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPermissionPolicyError {
    /// Kind of error that occurred.
    pub kind: PutPermissionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPermissionPolicyErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the specified policy isn't in the proper format. </p>
    /// <p>The policy specifications must conform to the following:</p>
    /// <ul>
    /// <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>
    /// <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>
    /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
    /// <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>
    /// <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
    WafInvalidPermissionPolicyException(crate::error::WafInvalidPermissionPolicyException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPermissionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPermissionPolicyErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            PutPermissionPolicyErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(_inner) => {
                _inner.fmt(f)
            }
            PutPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            PutPermissionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPermissionPolicyError {
    fn code(&self) -> Option<&str> {
        PutPermissionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPermissionPolicyError {
    /// Creates a new `PutPermissionPolicyError`.
    pub fn new(kind: PutPermissionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPermissionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPermissionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPermissionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPermissionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException`.
    pub fn is_waf_invalid_permission_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for PutPermissionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPermissionPolicyErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            PutPermissionPolicyErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(_inner) => {
                Some(_inner)
            }
            PutPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            PutPermissionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            TagResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            TagResourceErrorKind::WafTagOperationException(_inner) => Some(_inner),
            TagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>An error occurred during the tagging operation. Retry your request.</p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafTagOperationException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIPSetError {
    /// Kind of error that occurred.
    pub kind: UpdateIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIPSetErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIPSetErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIPSetError {
    fn code(&self) -> Option<&str> {
        UpdateIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIPSetError {
    /// Creates a new `UpdateIPSetError`.
    pub fn new(kind: UpdateIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafOptimisticLockException(_)
        )
    }
}
impl std::error::Error for UpdateIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIPSetErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateManagedRuleSetVersionExpiryDate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateManagedRuleSetVersionExpiryDateError {
    /// Kind of error that occurred.
    pub kind: UpdateManagedRuleSetVersionExpiryDateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateManagedRuleSetVersionExpiryDate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateManagedRuleSetVersionExpiryDateErrorKind {
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateManagedRuleSetVersionExpiryDateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidOperationException(
                _inner,
            ) => _inner.fmt(f),
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidParameterException(
                _inner,
            ) => _inner.fmt(f),
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafOptimisticLockException(_inner) => {
                _inner.fmt(f)
            }
            UpdateManagedRuleSetVersionExpiryDateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateManagedRuleSetVersionExpiryDateError {
    fn code(&self) -> Option<&str> {
        UpdateManagedRuleSetVersionExpiryDateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateManagedRuleSetVersionExpiryDateError {
    /// Creates a new `UpdateManagedRuleSetVersionExpiryDateError`.
    pub fn new(
        kind: UpdateManagedRuleSetVersionExpiryDateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateManagedRuleSetVersionExpiryDateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateManagedRuleSetVersionExpiryDateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateManagedRuleSetVersionExpiryDateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateManagedRuleSetVersionExpiryDateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateManagedRuleSetVersionExpiryDateErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateManagedRuleSetVersionExpiryDateErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafOptimisticLockException(_)
        )
    }
}
impl std::error::Error for UpdateManagedRuleSetVersionExpiryDateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInternalErrorException(_inner) => {
                Some(_inner)
            }
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidOperationException(
                _inner,
            ) => Some(_inner),
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafInvalidParameterException(
                _inner,
            ) => Some(_inner),
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            UpdateManagedRuleSetVersionExpiryDateErrorKind::WafOptimisticLockException(_inner) => {
                Some(_inner)
            }
            UpdateManagedRuleSetVersionExpiryDateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: UpdateRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRegexPatternSetErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRegexPatternSetErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        UpdateRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRegexPatternSetError {
    /// Creates a new `UpdateRegexPatternSetError`.
    pub fn new(kind: UpdateRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafOptimisticLockException(_)
        )
    }
}
impl std::error::Error for UpdateRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRegexPatternSetErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuleGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuleGroupErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it yet. </p>
    WafSubscriptionNotFoundException(crate::error::WafSubscriptionNotFoundException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuleGroupErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafSubscriptionNotFoundException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuleGroupError {
    fn code(&self) -> Option<&str> {
        UpdateRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuleGroupError {
    /// Creates a new `UpdateRuleGroupError`.
    pub fn new(kind: UpdateRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafSubscriptionNotFoundException`.
    pub fn is_waf_subscription_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafSubscriptionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuleGroupErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafSubscriptionNotFoundException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWebACLError {
    /// Kind of error that occurred.
    pub kind: UpdateWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWebACLErrorKind {
    /// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
    WafDuplicateItemException(crate::error::WafDuplicateItemException),
    /// <p>The operation failed because the specified version for the managed rule group has expired. You can retrieve the available versions for the managed rule group by calling <code>ListAvailableManagedRuleGroupVersions</code>.</p>
    WafExpiredManagedRuleGroupVersionException(
        crate::error::WafExpiredManagedRuleGroupVersionException,
    ),
    /// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation isn't valid. </p>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
    /// <ul>
    /// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
    /// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>
    WafInvalidResourceException(crate::error::WafInvalidResourceException),
    /// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
    WafOptimisticLockException(crate::error::WafOptimisticLockException),
    /// <p>You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it yet. </p>
    WafSubscriptionNotFoundException(crate::error::WafSubscriptionNotFoundException),
    /// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
    WafUnavailableEntityException(crate::error::WafUnavailableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWebACLErrorKind::WafDuplicateItemException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafExpiredManagedRuleGroupVersionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafInvalidResourceException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafOptimisticLockException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafSubscriptionNotFoundException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafUnavailableEntityException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWebACLError {
    fn code(&self) -> Option<&str> {
        UpdateWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWebACLError {
    /// Creates a new `UpdateWebACLError`.
    pub fn new(kind: UpdateWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafDuplicateItemException`.
    pub fn is_waf_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafDuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafExpiredManagedRuleGroupVersionException`.
    pub fn is_waf_expired_managed_rule_group_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafExpiredManagedRuleGroupVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInvalidResourceException`.
    pub fn is_waf_invalid_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInvalidResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafOptimisticLockException`.
    pub fn is_waf_optimistic_lock_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafOptimisticLockException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafSubscriptionNotFoundException`.
    pub fn is_waf_subscription_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafSubscriptionNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafUnavailableEntityException`.
    pub fn is_waf_unavailable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafUnavailableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWebACLErrorKind::WafDuplicateItemException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafExpiredManagedRuleGroupVersionException(_inner) => {
                Some(_inner)
            }
            UpdateWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafInvalidResourceException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafOptimisticLockException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafSubscriptionNotFoundException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafUnavailableEntityException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>WAF couldn’t retrieve the resource that you requested. Retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafUnavailableEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafUnavailableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafUnavailableEntityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafUnavailableEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafUnavailableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafUnavailableEntityException [WAFUnavailableEntityException]"
        )?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafUnavailableEntityException {}
/// See [`WafUnavailableEntityException`](crate::error::WafUnavailableEntityException)
pub mod waf_unavailable_entity_exception {
    /// A builder for [`WafUnavailableEntityException`](crate::error::WafUnavailableEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafUnavailableEntityException`](crate::error::WafUnavailableEntityException)
        pub fn build(self) -> crate::error::WafUnavailableEntityException {
            crate::error::WafUnavailableEntityException {
                message: self.message,
            }
        }
    }
}
impl WafUnavailableEntityException {
    /// Creates a new builder-style object to manufacture [`WafUnavailableEntityException`](crate::error::WafUnavailableEntityException)
    pub fn builder() -> crate::error::waf_unavailable_entity_exception::Builder {
        crate::error::waf_unavailable_entity_exception::Builder::default()
    }
}

/// <p>You tried to use a managed rule group that's available by subscription, but you aren't subscribed to it yet. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafSubscriptionNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafSubscriptionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafSubscriptionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafSubscriptionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafSubscriptionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafSubscriptionNotFoundException [WAFSubscriptionNotFoundException]"
        )?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafSubscriptionNotFoundException {}
/// See [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
pub mod waf_subscription_not_found_exception {
    /// A builder for [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
        pub fn build(self) -> crate::error::WafSubscriptionNotFoundException {
            crate::error::WafSubscriptionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl WafSubscriptionNotFoundException {
    /// Creates a new builder-style object to manufacture [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
    pub fn builder() -> crate::error::waf_subscription_not_found_exception::Builder {
        crate::error::waf_subscription_not_found_exception::Builder::default()
    }
}

/// <p>WAF couldn’t save your changes because you tried to update or delete a resource that has changed since you last retrieved it. Get the resource again, make any changes you need to make to the new copy, and retry your operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafOptimisticLockException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafOptimisticLockException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafOptimisticLockException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafOptimisticLockException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafOptimisticLockException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafOptimisticLockException [WAFOptimisticLockException]")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafOptimisticLockException {}
/// See [`WafOptimisticLockException`](crate::error::WafOptimisticLockException)
pub mod waf_optimistic_lock_exception {
    /// A builder for [`WafOptimisticLockException`](crate::error::WafOptimisticLockException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafOptimisticLockException`](crate::error::WafOptimisticLockException)
        pub fn build(self) -> crate::error::WafOptimisticLockException {
            crate::error::WafOptimisticLockException {
                message: self.message,
            }
        }
    }
}
impl WafOptimisticLockException {
    /// Creates a new builder-style object to manufacture [`WafOptimisticLockException`](crate::error::WafOptimisticLockException)
    pub fn builder() -> crate::error::waf_optimistic_lock_exception::Builder {
        crate::error::waf_optimistic_lock_exception::Builder::default()
    }
}

/// <p>WAF couldn’t perform the operation because your resource doesn’t exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafNonexistentItemException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafNonexistentItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafNonexistentItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafNonexistentItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafNonexistentItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafNonexistentItemException [WAFNonexistentItemException]"
        )?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafNonexistentItemException {}
/// See [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
pub mod waf_nonexistent_item_exception {
    /// A builder for [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
        pub fn build(self) -> crate::error::WafNonexistentItemException {
            crate::error::WafNonexistentItemException {
                message: self.message,
            }
        }
    }
}
impl WafNonexistentItemException {
    /// Creates a new builder-style object to manufacture [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
    pub fn builder() -> crate::error::waf_nonexistent_item_exception::Builder {
        crate::error::waf_nonexistent_item_exception::Builder::default()
    }
}

/// <p>WAF couldn’t perform the operation because you exceeded your resource limit. For example, the maximum number of <code>WebACL</code> objects that you can create for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">WAF quotas</a> in the <i>WAF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafLimitsExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafLimitsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafLimitsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafLimitsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafLimitsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafLimitsExceededException [WAFLimitsExceededException]")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafLimitsExceededException {}
/// See [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
pub mod waf_limits_exceeded_exception {
    /// A builder for [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
        pub fn build(self) -> crate::error::WafLimitsExceededException {
            crate::error::WafLimitsExceededException {
                message: self.message,
            }
        }
    }
}
impl WafLimitsExceededException {
    /// Creates a new builder-style object to manufacture [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
    pub fn builder() -> crate::error::waf_limits_exceeded_exception::Builder {
        crate::error::waf_limits_exceeded_exception::Builder::default()
    }
}

/// <p>WAF couldn’t perform the operation because the resource that you requested isn’t valid. Check the resource, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidResourceException [WAFInvalidResourceException]"
        )?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidResourceException {}
/// See [`WafInvalidResourceException`](crate::error::WafInvalidResourceException)
pub mod waf_invalid_resource_exception {
    /// A builder for [`WafInvalidResourceException`](crate::error::WafInvalidResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidResourceException`](crate::error::WafInvalidResourceException)
        pub fn build(self) -> crate::error::WafInvalidResourceException {
            crate::error::WafInvalidResourceException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidResourceException {
    /// Creates a new builder-style object to manufacture [`WafInvalidResourceException`](crate::error::WafInvalidResourceException)
    pub fn builder() -> crate::error::waf_invalid_resource_exception::Builder {
        crate::error::waf_invalid_resource_exception::Builder::default()
    }
}

/// <p>The operation failed because WAF didn't recognize a parameter in the request. For example: </p>
/// <ul>
/// <li> <p>You specified a parameter name or value that isn't valid.</p> </li>
/// <li> <p>Your nested statement isn't valid. You might have tried to nest a statement that can’t be nested. </p> </li>
/// <li> <p>You tried to update a <code>WebACL</code> with a <code>DefaultAction</code> that isn't among the types available at <code>DefaultAction</code>.</p> </li>
/// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL can't be associated.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The settings where the invalid parameter was found. </p>
    pub field: std::option::Option<crate::model::ParameterExceptionField>,
    /// <p>The invalid parameter that resulted in the exception. </p>
    pub parameter: std::option::Option<std::string::String>,
    /// <p>Additional information about the exception.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl WafInvalidParameterException {
    /// <p>The settings where the invalid parameter was found. </p>
    pub fn field(&self) -> std::option::Option<&crate::model::ParameterExceptionField> {
        self.field.as_ref()
    }
    /// <p>The invalid parameter that resulted in the exception. </p>
    pub fn parameter(&self) -> std::option::Option<&str> {
        self.parameter.as_deref()
    }
    /// <p>Additional information about the exception.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for WafInvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidParameterException");
        formatter.field("message", &self.message);
        formatter.field("field", &self.field);
        formatter.field("parameter", &self.parameter);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl WafInvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidParameterException [WAFInvalidParameterException]"
        )?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidParameterException {}
/// See [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
pub mod waf_invalid_parameter_exception {
    /// A builder for [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) field: std::option::Option<crate::model::ParameterExceptionField>,
        pub(crate) parameter: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The settings where the invalid parameter was found. </p>
        pub fn field(mut self, input: crate::model::ParameterExceptionField) -> Self {
            self.field = Some(input);
            self
        }
        /// <p>The settings where the invalid parameter was found. </p>
        pub fn set_field(
            mut self,
            input: std::option::Option<crate::model::ParameterExceptionField>,
        ) -> Self {
            self.field = input;
            self
        }
        /// <p>The invalid parameter that resulted in the exception. </p>
        pub fn parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter = Some(input.into());
            self
        }
        /// <p>The invalid parameter that resulted in the exception. </p>
        pub fn set_parameter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameter = input;
            self
        }
        /// <p>Additional information about the exception.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Additional information about the exception.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
        pub fn build(self) -> crate::error::WafInvalidParameterException {
            crate::error::WafInvalidParameterException {
                message: self.message,
                field: self.field,
                parameter: self.parameter,
                reason: self.reason,
            }
        }
    }
}
impl WafInvalidParameterException {
    /// Creates a new builder-style object to manufacture [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
    pub fn builder() -> crate::error::waf_invalid_parameter_exception::Builder {
        crate::error::waf_invalid_parameter_exception::Builder::default()
    }
}

/// <p>The operation isn't valid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidOperationException [WAFInvalidOperationException]"
        )?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidOperationException {}
/// See [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
pub mod waf_invalid_operation_exception {
    /// A builder for [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
        pub fn build(self) -> crate::error::WafInvalidOperationException {
            crate::error::WafInvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidOperationException {
    /// Creates a new builder-style object to manufacture [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
    pub fn builder() -> crate::error::waf_invalid_operation_exception::Builder {
        crate::error::waf_invalid_operation_exception::Builder::default()
    }
}

/// <p>Your request is valid, but WAF couldn’t perform the operation because of a system problem. Retry your request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafInternalErrorException [WAFInternalErrorException]")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInternalErrorException {}
/// See [`WafInternalErrorException`](crate::error::WafInternalErrorException)
pub mod waf_internal_error_exception {
    /// A builder for [`WafInternalErrorException`](crate::error::WafInternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInternalErrorException`](crate::error::WafInternalErrorException)
        pub fn build(self) -> crate::error::WafInternalErrorException {
            crate::error::WafInternalErrorException {
                message: self.message,
            }
        }
    }
}
impl WafInternalErrorException {
    /// Creates a new builder-style object to manufacture [`WafInternalErrorException`](crate::error::WafInternalErrorException)
    pub fn builder() -> crate::error::waf_internal_error_exception::Builder {
        crate::error::waf_internal_error_exception::Builder::default()
    }
}

/// <p>The operation failed because the specified version for the managed rule group has expired. You can retrieve the available versions for the managed rule group by calling <code>ListAvailableManagedRuleGroupVersions</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafExpiredManagedRuleGroupVersionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafExpiredManagedRuleGroupVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafExpiredManagedRuleGroupVersionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafExpiredManagedRuleGroupVersionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafExpiredManagedRuleGroupVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafExpiredManagedRuleGroupVersionException [WAFExpiredManagedRuleGroupVersionException]")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafExpiredManagedRuleGroupVersionException {}
/// See [`WafExpiredManagedRuleGroupVersionException`](crate::error::WafExpiredManagedRuleGroupVersionException)
pub mod waf_expired_managed_rule_group_version_exception {
    /// A builder for [`WafExpiredManagedRuleGroupVersionException`](crate::error::WafExpiredManagedRuleGroupVersionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafExpiredManagedRuleGroupVersionException`](crate::error::WafExpiredManagedRuleGroupVersionException)
        pub fn build(self) -> crate::error::WafExpiredManagedRuleGroupVersionException {
            crate::error::WafExpiredManagedRuleGroupVersionException {
                message: self.message,
            }
        }
    }
}
impl WafExpiredManagedRuleGroupVersionException {
    /// Creates a new builder-style object to manufacture [`WafExpiredManagedRuleGroupVersionException`](crate::error::WafExpiredManagedRuleGroupVersionException)
    pub fn builder() -> crate::error::waf_expired_managed_rule_group_version_exception::Builder {
        crate::error::waf_expired_managed_rule_group_version_exception::Builder::default()
    }
}

/// <p>WAF couldn’t perform the operation because the resource that you tried to save is a duplicate of an existing one.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafDuplicateItemException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafDuplicateItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafDuplicateItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafDuplicateItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafDuplicateItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafDuplicateItemException [WAFDuplicateItemException]")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafDuplicateItemException {}
/// See [`WafDuplicateItemException`](crate::error::WafDuplicateItemException)
pub mod waf_duplicate_item_exception {
    /// A builder for [`WafDuplicateItemException`](crate::error::WafDuplicateItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafDuplicateItemException`](crate::error::WafDuplicateItemException)
        pub fn build(self) -> crate::error::WafDuplicateItemException {
            crate::error::WafDuplicateItemException {
                message: self.message,
            }
        }
    }
}
impl WafDuplicateItemException {
    /// Creates a new builder-style object to manufacture [`WafDuplicateItemException`](crate::error::WafDuplicateItemException)
    pub fn builder() -> crate::error::waf_duplicate_item_exception::Builder {
        crate::error::waf_duplicate_item_exception::Builder::default()
    }
}

/// <p>WAF couldn’t perform your tagging operation because of an internal error. Retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafTagOperationInternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafTagOperationInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafTagOperationInternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafTagOperationInternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafTagOperationInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafTagOperationInternalErrorException [WAFTagOperationInternalErrorException]"
        )?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafTagOperationInternalErrorException {}
/// See [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
pub mod waf_tag_operation_internal_error_exception {
    /// A builder for [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
        pub fn build(self) -> crate::error::WafTagOperationInternalErrorException {
            crate::error::WafTagOperationInternalErrorException {
                message: self.message,
            }
        }
    }
}
impl WafTagOperationInternalErrorException {
    /// Creates a new builder-style object to manufacture [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
    pub fn builder() -> crate::error::waf_tag_operation_internal_error_exception::Builder {
        crate::error::waf_tag_operation_internal_error_exception::Builder::default()
    }
}

/// <p>An error occurred during the tagging operation. Retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafTagOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafTagOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafTagOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafTagOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafTagOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafTagOperationException [WAFTagOperationException]")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafTagOperationException {}
/// See [`WafTagOperationException`](crate::error::WafTagOperationException)
pub mod waf_tag_operation_exception {
    /// A builder for [`WafTagOperationException`](crate::error::WafTagOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafTagOperationException`](crate::error::WafTagOperationException)
        pub fn build(self) -> crate::error::WafTagOperationException {
            crate::error::WafTagOperationException {
                message: self.message,
            }
        }
    }
}
impl WafTagOperationException {
    /// Creates a new builder-style object to manufacture [`WafTagOperationException`](crate::error::WafTagOperationException)
    pub fn builder() -> crate::error::waf_tag_operation_exception::Builder {
        crate::error::waf_tag_operation_exception::Builder::default()
    }
}

/// <p>The operation failed because the specified policy isn't in the proper format. </p>
/// <p>The policy specifications must conform to the following:</p>
/// <ul>
/// <li> <p>The policy must be composed using IAM Policy version 2012-10-17 or version 2015-01-01.</p> </li>
/// <li> <p>The policy must include specifications for <code>Effect</code>, <code>Action</code>, and <code>Principal</code>.</p> </li>
/// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
/// <li> <p> <code>Action</code> must specify <code>wafv2:CreateWebACL</code>, <code>wafv2:UpdateWebACL</code>, and <code>wafv2:PutFirewallManagerRuleGroups</code> and may optionally specify <code>wafv2:GetRuleGroup</code>. WAF rejects any extra actions or wildcard actions in the policy.</p> </li>
/// <li> <p>The policy must not include a <code>Resource</code> parameter.</p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidPermissionPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidPermissionPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidPermissionPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidPermissionPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidPermissionPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidPermissionPolicyException [WAFInvalidPermissionPolicyException]"
        )?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidPermissionPolicyException {}
/// See [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
pub mod waf_invalid_permission_policy_exception {
    /// A builder for [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
        pub fn build(self) -> crate::error::WafInvalidPermissionPolicyException {
            crate::error::WafInvalidPermissionPolicyException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidPermissionPolicyException {
    /// Creates a new builder-style object to manufacture [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
    pub fn builder() -> crate::error::waf_invalid_permission_policy_exception::Builder {
        crate::error::waf_invalid_permission_policy_exception::Builder::default()
    }
}

/// <p>WAF is not able to access the service linked role. This can be caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20 seconds. Please try your request again. The service linked role can also be locked by a previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you recently made a call to <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the request again. If you receive this same exception again, you will have to wait additional time until the role is unlocked.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafServiceLinkedRoleErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafServiceLinkedRoleErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafServiceLinkedRoleErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafServiceLinkedRoleErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafServiceLinkedRoleErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafServiceLinkedRoleErrorException [WAFServiceLinkedRoleErrorException]"
        )?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafServiceLinkedRoleErrorException {}
/// See [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
pub mod waf_service_linked_role_error_exception {
    /// A builder for [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
        pub fn build(self) -> crate::error::WafServiceLinkedRoleErrorException {
            crate::error::WafServiceLinkedRoleErrorException {
                message: self.message,
            }
        }
    }
}
impl WafServiceLinkedRoleErrorException {
    /// Creates a new builder-style object to manufacture [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
    pub fn builder() -> crate::error::waf_service_linked_role_error_exception::Builder {
        crate::error::waf_service_linked_role_error_exception::Builder::default()
    }
}

/// <p>The operation failed because you don't have the permissions that your logging configuration requires. For information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <i>WAF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafLogDestinationPermissionIssueException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafLogDestinationPermissionIssueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafLogDestinationPermissionIssueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafLogDestinationPermissionIssueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafLogDestinationPermissionIssueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafLogDestinationPermissionIssueException [WAFLogDestinationPermissionIssueException]"
        )?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafLogDestinationPermissionIssueException {}
/// See [`WafLogDestinationPermissionIssueException`](crate::error::WafLogDestinationPermissionIssueException)
pub mod waf_log_destination_permission_issue_exception {
    /// A builder for [`WafLogDestinationPermissionIssueException`](crate::error::WafLogDestinationPermissionIssueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafLogDestinationPermissionIssueException`](crate::error::WafLogDestinationPermissionIssueException)
        pub fn build(self) -> crate::error::WafLogDestinationPermissionIssueException {
            crate::error::WafLogDestinationPermissionIssueException {
                message: self.message,
            }
        }
    }
}
impl WafLogDestinationPermissionIssueException {
    /// Creates a new builder-style object to manufacture [`WafLogDestinationPermissionIssueException`](crate::error::WafLogDestinationPermissionIssueException)
    pub fn builder() -> crate::error::waf_log_destination_permission_issue_exception::Builder {
        crate::error::waf_log_destination_permission_issue_exception::Builder::default()
    }
}

/// <p>WAF couldn’t perform the operation because your resource is being used by another resource or it’s associated with another resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafAssociatedItemException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafAssociatedItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafAssociatedItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafAssociatedItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafAssociatedItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafAssociatedItemException [WAFAssociatedItemException]")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafAssociatedItemException {}
/// See [`WafAssociatedItemException`](crate::error::WafAssociatedItemException)
pub mod waf_associated_item_exception {
    /// A builder for [`WafAssociatedItemException`](crate::error::WafAssociatedItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafAssociatedItemException`](crate::error::WafAssociatedItemException)
        pub fn build(self) -> crate::error::WafAssociatedItemException {
            crate::error::WafAssociatedItemException {
                message: self.message,
            }
        }
    }
}
impl WafAssociatedItemException {
    /// Creates a new builder-style object to manufacture [`WafAssociatedItemException`](crate::error::WafAssociatedItemException)
    pub fn builder() -> crate::error::waf_associated_item_exception::Builder {
        crate::error::waf_associated_item_exception::Builder::default()
    }
}
