// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_web_acl`](crate::client::Client::associate_web_acl).
///
/// See [`crate::client::fluent_builders::AssociateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWebACL {
    _private: (),
}
impl AssociateWebACL {
    /// Creates a new builder-style object to manufacture [`AssociateWebAclInput`](crate::input::AssociateWebAclInput)
    pub fn builder() -> crate::input::associate_web_acl_input::Builder {
        crate::input::associate_web_acl_input::Builder::default()
    }
    /// Creates a new `AssociateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWebACL {
    type Output = std::result::Result<
        crate::output::AssociateWebAclOutput,
        crate::error::AssociateWebACLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_web_acl_error(response)
        } else {
            crate::operation_deser::parse_associate_web_acl_response(response)
        }
    }
}

/// Operation shape for `CheckCapacity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`check_capacity`](crate::client::Client::check_capacity).
///
/// See [`crate::client::fluent_builders::CheckCapacity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckCapacity {
    _private: (),
}
impl CheckCapacity {
    /// Creates a new builder-style object to manufacture [`CheckCapacityInput`](crate::input::CheckCapacityInput)
    pub fn builder() -> crate::input::check_capacity_input::Builder {
        crate::input::check_capacity_input::Builder::default()
    }
    /// Creates a new `CheckCapacity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckCapacity {
    type Output =
        std::result::Result<crate::output::CheckCapacityOutput, crate::error::CheckCapacityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_check_capacity_error(response)
        } else {
            crate::operation_deser::parse_check_capacity_response(response)
        }
    }
}

/// Operation shape for `CreateIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ip_set`](crate::client::Client::create_ip_set).
///
/// See [`crate::client::fluent_builders::CreateIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIPSet {
    _private: (),
}
impl CreateIPSet {
    /// Creates a new builder-style object to manufacture [`CreateIpSetInput`](crate::input::CreateIpSetInput)
    pub fn builder() -> crate::input::create_ip_set_input::Builder {
        crate::input::create_ip_set_input::Builder::default()
    }
    /// Creates a new `CreateIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIPSet {
    type Output =
        std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ip_set_error(response)
        } else {
            crate::operation_deser::parse_create_ip_set_response(response)
        }
    }
}

/// Operation shape for `CreateRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_regex_pattern_set`](crate::client::Client::create_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::CreateRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRegexPatternSet {
    _private: (),
}
impl CreateRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`CreateRegexPatternSetInput`](crate::input::CreateRegexPatternSetInput)
    pub fn builder() -> crate::input::create_regex_pattern_set_input::Builder {
        crate::input::create_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `CreateRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRegexPatternSet {
    type Output = std::result::Result<
        crate::output::CreateRegexPatternSetOutput,
        crate::error::CreateRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_create_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `CreateRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rule_group`](crate::client::Client::create_rule_group).
///
/// See [`crate::client::fluent_builders::CreateRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRuleGroup {
    _private: (),
}
impl CreateRuleGroup {
    /// Creates a new builder-style object to manufacture [`CreateRuleGroupInput`](crate::input::CreateRuleGroupInput)
    pub fn builder() -> crate::input::create_rule_group_input::Builder {
        crate::input::create_rule_group_input::Builder::default()
    }
    /// Creates a new `CreateRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRuleGroup {
    type Output = std::result::Result<
        crate::output::CreateRuleGroupOutput,
        crate::error::CreateRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rule_group_error(response)
        } else {
            crate::operation_deser::parse_create_rule_group_response(response)
        }
    }
}

/// Operation shape for `CreateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_web_acl`](crate::client::Client::create_web_acl).
///
/// See [`crate::client::fluent_builders::CreateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWebACL {
    _private: (),
}
impl CreateWebACL {
    /// Creates a new builder-style object to manufacture [`CreateWebAclInput`](crate::input::CreateWebAclInput)
    pub fn builder() -> crate::input::create_web_acl_input::Builder {
        crate::input::create_web_acl_input::Builder::default()
    }
    /// Creates a new `CreateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWebACL {
    type Output =
        std::result::Result<crate::output::CreateWebAclOutput, crate::error::CreateWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_web_acl_error(response)
        } else {
            crate::operation_deser::parse_create_web_acl_response(response)
        }
    }
}

/// Operation shape for `DeleteFirewallManagerRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_firewall_manager_rule_groups`](crate::client::Client::delete_firewall_manager_rule_groups).
///
/// See [`crate::client::fluent_builders::DeleteFirewallManagerRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFirewallManagerRuleGroups {
    _private: (),
}
impl DeleteFirewallManagerRuleGroups {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallManagerRuleGroupsInput`](crate::input::DeleteFirewallManagerRuleGroupsInput)
    pub fn builder() -> crate::input::delete_firewall_manager_rule_groups_input::Builder {
        crate::input::delete_firewall_manager_rule_groups_input::Builder::default()
    }
    /// Creates a new `DeleteFirewallManagerRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFirewallManagerRuleGroups {
    type Output = std::result::Result<
        crate::output::DeleteFirewallManagerRuleGroupsOutput,
        crate::error::DeleteFirewallManagerRuleGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_firewall_manager_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_delete_firewall_manager_rule_groups_response(response)
        }
    }
}

/// Operation shape for `DeleteIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ip_set`](crate::client::Client::delete_ip_set).
///
/// See [`crate::client::fluent_builders::DeleteIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIPSet {
    _private: (),
}
impl DeleteIPSet {
    /// Creates a new builder-style object to manufacture [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
    pub fn builder() -> crate::input::delete_ip_set_input::Builder {
        crate::input::delete_ip_set_input::Builder::default()
    }
    /// Creates a new `DeleteIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIPSet {
    type Output =
        std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ip_set_error(response)
        } else {
            crate::operation_deser::parse_delete_ip_set_response(response)
        }
    }
}

/// Operation shape for `DeleteLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_logging_configuration`](crate::client::Client::delete_logging_configuration).
///
/// See [`crate::client::fluent_builders::DeleteLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoggingConfiguration {
    _private: (),
}
impl DeleteLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteLoggingConfigurationInput`](crate::input::DeleteLoggingConfigurationInput)
    pub fn builder() -> crate::input::delete_logging_configuration_input::Builder {
        crate::input::delete_logging_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteLoggingConfigurationOutput,
        crate::error::DeleteLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `DeletePermissionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_permission_policy`](crate::client::Client::delete_permission_policy).
///
/// See [`crate::client::fluent_builders::DeletePermissionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePermissionPolicy {
    _private: (),
}
impl DeletePermissionPolicy {
    /// Creates a new builder-style object to manufacture [`DeletePermissionPolicyInput`](crate::input::DeletePermissionPolicyInput)
    pub fn builder() -> crate::input::delete_permission_policy_input::Builder {
        crate::input::delete_permission_policy_input::Builder::default()
    }
    /// Creates a new `DeletePermissionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePermissionPolicy {
    type Output = std::result::Result<
        crate::output::DeletePermissionPolicyOutput,
        crate::error::DeletePermissionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_permission_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_permission_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_regex_pattern_set`](crate::client::Client::delete_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::DeleteRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegexPatternSet {
    _private: (),
}
impl DeleteRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`DeleteRegexPatternSetInput`](crate::input::DeleteRegexPatternSetInput)
    pub fn builder() -> crate::input::delete_regex_pattern_set_input::Builder {
        crate::input::delete_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `DeleteRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegexPatternSet {
    type Output = std::result::Result<
        crate::output::DeleteRegexPatternSetOutput,
        crate::error::DeleteRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_delete_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `DeleteRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule_group`](crate::client::Client::delete_rule_group).
///
/// See [`crate::client::fluent_builders::DeleteRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRuleGroup {
    _private: (),
}
impl DeleteRuleGroup {
    /// Creates a new builder-style object to manufacture [`DeleteRuleGroupInput`](crate::input::DeleteRuleGroupInput)
    pub fn builder() -> crate::input::delete_rule_group_input::Builder {
        crate::input::delete_rule_group_input::Builder::default()
    }
    /// Creates a new `DeleteRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRuleGroup {
    type Output = std::result::Result<
        crate::output::DeleteRuleGroupOutput,
        crate::error::DeleteRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_group_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_group_response(response)
        }
    }
}

/// Operation shape for `DeleteWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_web_acl`](crate::client::Client::delete_web_acl).
///
/// See [`crate::client::fluent_builders::DeleteWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWebACL {
    _private: (),
}
impl DeleteWebACL {
    /// Creates a new builder-style object to manufacture [`DeleteWebAclInput`](crate::input::DeleteWebAclInput)
    pub fn builder() -> crate::input::delete_web_acl_input::Builder {
        crate::input::delete_web_acl_input::Builder::default()
    }
    /// Creates a new `DeleteWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWebACL {
    type Output =
        std::result::Result<crate::output::DeleteWebAclOutput, crate::error::DeleteWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_web_acl_error(response)
        } else {
            crate::operation_deser::parse_delete_web_acl_response(response)
        }
    }
}

/// Operation shape for `DescribeManagedRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_managed_rule_group`](crate::client::Client::describe_managed_rule_group).
///
/// See [`crate::client::fluent_builders::DescribeManagedRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeManagedRuleGroup {
    _private: (),
}
impl DescribeManagedRuleGroup {
    /// Creates a new builder-style object to manufacture [`DescribeManagedRuleGroupInput`](crate::input::DescribeManagedRuleGroupInput)
    pub fn builder() -> crate::input::describe_managed_rule_group_input::Builder {
        crate::input::describe_managed_rule_group_input::Builder::default()
    }
    /// Creates a new `DescribeManagedRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeManagedRuleGroup {
    type Output = std::result::Result<
        crate::output::DescribeManagedRuleGroupOutput,
        crate::error::DescribeManagedRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_managed_rule_group_error(response)
        } else {
            crate::operation_deser::parse_describe_managed_rule_group_response(response)
        }
    }
}

/// Operation shape for `DisassociateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_web_acl`](crate::client::Client::disassociate_web_acl).
///
/// See [`crate::client::fluent_builders::DisassociateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWebACL {
    _private: (),
}
impl DisassociateWebACL {
    /// Creates a new builder-style object to manufacture [`DisassociateWebAclInput`](crate::input::DisassociateWebAclInput)
    pub fn builder() -> crate::input::disassociate_web_acl_input::Builder {
        crate::input::disassociate_web_acl_input::Builder::default()
    }
    /// Creates a new `DisassociateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWebACL {
    type Output = std::result::Result<
        crate::output::DisassociateWebAclOutput,
        crate::error::DisassociateWebACLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_web_acl_error(response)
        } else {
            crate::operation_deser::parse_disassociate_web_acl_response(response)
        }
    }
}

/// Operation shape for `GetIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ip_set`](crate::client::Client::get_ip_set).
///
/// See [`crate::client::fluent_builders::GetIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIPSet {
    _private: (),
}
impl GetIPSet {
    /// Creates a new builder-style object to manufacture [`GetIpSetInput`](crate::input::GetIpSetInput)
    pub fn builder() -> crate::input::get_ip_set_input::Builder {
        crate::input::get_ip_set_input::Builder::default()
    }
    /// Creates a new `GetIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIPSet {
    type Output = std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ip_set_error(response)
        } else {
            crate::operation_deser::parse_get_ip_set_response(response)
        }
    }
}

/// Operation shape for `GetLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_logging_configuration`](crate::client::Client::get_logging_configuration).
///
/// See [`crate::client::fluent_builders::GetLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoggingConfiguration {
    _private: (),
}
impl GetLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetLoggingConfigurationInput`](crate::input::GetLoggingConfigurationInput)
    pub fn builder() -> crate::input::get_logging_configuration_input::Builder {
        crate::input::get_logging_configuration_input::Builder::default()
    }
    /// Creates a new `GetLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::GetLoggingConfigurationOutput,
        crate::error::GetLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `GetManagedRuleSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_managed_rule_set`](crate::client::Client::get_managed_rule_set).
///
/// See [`crate::client::fluent_builders::GetManagedRuleSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetManagedRuleSet {
    _private: (),
}
impl GetManagedRuleSet {
    /// Creates a new builder-style object to manufacture [`GetManagedRuleSetInput`](crate::input::GetManagedRuleSetInput)
    pub fn builder() -> crate::input::get_managed_rule_set_input::Builder {
        crate::input::get_managed_rule_set_input::Builder::default()
    }
    /// Creates a new `GetManagedRuleSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetManagedRuleSet {
    type Output = std::result::Result<
        crate::output::GetManagedRuleSetOutput,
        crate::error::GetManagedRuleSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_managed_rule_set_error(response)
        } else {
            crate::operation_deser::parse_get_managed_rule_set_response(response)
        }
    }
}

/// Operation shape for `GetPermissionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_permission_policy`](crate::client::Client::get_permission_policy).
///
/// See [`crate::client::fluent_builders::GetPermissionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPermissionPolicy {
    _private: (),
}
impl GetPermissionPolicy {
    /// Creates a new builder-style object to manufacture [`GetPermissionPolicyInput`](crate::input::GetPermissionPolicyInput)
    pub fn builder() -> crate::input::get_permission_policy_input::Builder {
        crate::input::get_permission_policy_input::Builder::default()
    }
    /// Creates a new `GetPermissionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPermissionPolicy {
    type Output = std::result::Result<
        crate::output::GetPermissionPolicyOutput,
        crate::error::GetPermissionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_permission_policy_error(response)
        } else {
            crate::operation_deser::parse_get_permission_policy_response(response)
        }
    }
}

/// Operation shape for `GetRateBasedStatementManagedKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rate_based_statement_managed_keys`](crate::client::Client::get_rate_based_statement_managed_keys).
///
/// See [`crate::client::fluent_builders::GetRateBasedStatementManagedKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRateBasedStatementManagedKeys {
    _private: (),
}
impl GetRateBasedStatementManagedKeys {
    /// Creates a new builder-style object to manufacture [`GetRateBasedStatementManagedKeysInput`](crate::input::GetRateBasedStatementManagedKeysInput)
    pub fn builder() -> crate::input::get_rate_based_statement_managed_keys_input::Builder {
        crate::input::get_rate_based_statement_managed_keys_input::Builder::default()
    }
    /// Creates a new `GetRateBasedStatementManagedKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRateBasedStatementManagedKeys {
    type Output = std::result::Result<
        crate::output::GetRateBasedStatementManagedKeysOutput,
        crate::error::GetRateBasedStatementManagedKeysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rate_based_statement_managed_keys_error(response)
        } else {
            crate::operation_deser::parse_get_rate_based_statement_managed_keys_response(response)
        }
    }
}

/// Operation shape for `GetRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_regex_pattern_set`](crate::client::Client::get_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::GetRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegexPatternSet {
    _private: (),
}
impl GetRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`GetRegexPatternSetInput`](crate::input::GetRegexPatternSetInput)
    pub fn builder() -> crate::input::get_regex_pattern_set_input::Builder {
        crate::input::get_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `GetRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegexPatternSet {
    type Output = std::result::Result<
        crate::output::GetRegexPatternSetOutput,
        crate::error::GetRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_get_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `GetRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rule_group`](crate::client::Client::get_rule_group).
///
/// See [`crate::client::fluent_builders::GetRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRuleGroup {
    _private: (),
}
impl GetRuleGroup {
    /// Creates a new builder-style object to manufacture [`GetRuleGroupInput`](crate::input::GetRuleGroupInput)
    pub fn builder() -> crate::input::get_rule_group_input::Builder {
        crate::input::get_rule_group_input::Builder::default()
    }
    /// Creates a new `GetRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRuleGroup {
    type Output =
        std::result::Result<crate::output::GetRuleGroupOutput, crate::error::GetRuleGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rule_group_error(response)
        } else {
            crate::operation_deser::parse_get_rule_group_response(response)
        }
    }
}

/// Operation shape for `GetSampledRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sampled_requests`](crate::client::Client::get_sampled_requests).
///
/// See [`crate::client::fluent_builders::GetSampledRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSampledRequests {
    _private: (),
}
impl GetSampledRequests {
    /// Creates a new builder-style object to manufacture [`GetSampledRequestsInput`](crate::input::GetSampledRequestsInput)
    pub fn builder() -> crate::input::get_sampled_requests_input::Builder {
        crate::input::get_sampled_requests_input::Builder::default()
    }
    /// Creates a new `GetSampledRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSampledRequests {
    type Output = std::result::Result<
        crate::output::GetSampledRequestsOutput,
        crate::error::GetSampledRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sampled_requests_error(response)
        } else {
            crate::operation_deser::parse_get_sampled_requests_response(response)
        }
    }
}

/// Operation shape for `GetWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_web_acl`](crate::client::Client::get_web_acl).
///
/// See [`crate::client::fluent_builders::GetWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWebACL {
    _private: (),
}
impl GetWebACL {
    /// Creates a new builder-style object to manufacture [`GetWebAclInput`](crate::input::GetWebAclInput)
    pub fn builder() -> crate::input::get_web_acl_input::Builder {
        crate::input::get_web_acl_input::Builder::default()
    }
    /// Creates a new `GetWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWebACL {
    type Output = std::result::Result<crate::output::GetWebAclOutput, crate::error::GetWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_web_acl_error(response)
        } else {
            crate::operation_deser::parse_get_web_acl_response(response)
        }
    }
}

/// Operation shape for `GetWebACLForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_web_acl_for_resource`](crate::client::Client::get_web_acl_for_resource).
///
/// See [`crate::client::fluent_builders::GetWebACLForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWebACLForResource {
    _private: (),
}
impl GetWebACLForResource {
    /// Creates a new builder-style object to manufacture [`GetWebAclForResourceInput`](crate::input::GetWebAclForResourceInput)
    pub fn builder() -> crate::input::get_web_acl_for_resource_input::Builder {
        crate::input::get_web_acl_for_resource_input::Builder::default()
    }
    /// Creates a new `GetWebACLForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWebACLForResource {
    type Output = std::result::Result<
        crate::output::GetWebAclForResourceOutput,
        crate::error::GetWebACLForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_web_acl_for_resource_error(response)
        } else {
            crate::operation_deser::parse_get_web_acl_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListAvailableManagedRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_available_managed_rule_groups`](crate::client::Client::list_available_managed_rule_groups).
///
/// See [`crate::client::fluent_builders::ListAvailableManagedRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAvailableManagedRuleGroups {
    _private: (),
}
impl ListAvailableManagedRuleGroups {
    /// Creates a new builder-style object to manufacture [`ListAvailableManagedRuleGroupsInput`](crate::input::ListAvailableManagedRuleGroupsInput)
    pub fn builder() -> crate::input::list_available_managed_rule_groups_input::Builder {
        crate::input::list_available_managed_rule_groups_input::Builder::default()
    }
    /// Creates a new `ListAvailableManagedRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAvailableManagedRuleGroups {
    type Output = std::result::Result<
        crate::output::ListAvailableManagedRuleGroupsOutput,
        crate::error::ListAvailableManagedRuleGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_available_managed_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_list_available_managed_rule_groups_response(response)
        }
    }
}

/// Operation shape for `ListAvailableManagedRuleGroupVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_available_managed_rule_group_versions`](crate::client::Client::list_available_managed_rule_group_versions).
///
/// See [`crate::client::fluent_builders::ListAvailableManagedRuleGroupVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAvailableManagedRuleGroupVersions {
    _private: (),
}
impl ListAvailableManagedRuleGroupVersions {
    /// Creates a new builder-style object to manufacture [`ListAvailableManagedRuleGroupVersionsInput`](crate::input::ListAvailableManagedRuleGroupVersionsInput)
    pub fn builder() -> crate::input::list_available_managed_rule_group_versions_input::Builder {
        crate::input::list_available_managed_rule_group_versions_input::Builder::default()
    }
    /// Creates a new `ListAvailableManagedRuleGroupVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAvailableManagedRuleGroupVersions {
    type Output = std::result::Result<
        crate::output::ListAvailableManagedRuleGroupVersionsOutput,
        crate::error::ListAvailableManagedRuleGroupVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_available_managed_rule_group_versions_error(response)
        } else {
            crate::operation_deser::parse_list_available_managed_rule_group_versions_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListIPSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ip_sets`](crate::client::Client::list_ip_sets).
///
/// See [`crate::client::fluent_builders::ListIPSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIPSets {
    _private: (),
}
impl ListIPSets {
    /// Creates a new builder-style object to manufacture [`ListIpSetsInput`](crate::input::ListIpSetsInput)
    pub fn builder() -> crate::input::list_ip_sets_input::Builder {
        crate::input::list_ip_sets_input::Builder::default()
    }
    /// Creates a new `ListIPSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIPSets {
    type Output =
        std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ip_sets_error(response)
        } else {
            crate::operation_deser::parse_list_ip_sets_response(response)
        }
    }
}

/// Operation shape for `ListLoggingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_logging_configurations`](crate::client::Client::list_logging_configurations).
///
/// See [`crate::client::fluent_builders::ListLoggingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLoggingConfigurations {
    _private: (),
}
impl ListLoggingConfigurations {
    /// Creates a new builder-style object to manufacture [`ListLoggingConfigurationsInput`](crate::input::ListLoggingConfigurationsInput)
    pub fn builder() -> crate::input::list_logging_configurations_input::Builder {
        crate::input::list_logging_configurations_input::Builder::default()
    }
    /// Creates a new `ListLoggingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLoggingConfigurations {
    type Output = std::result::Result<
        crate::output::ListLoggingConfigurationsOutput,
        crate::error::ListLoggingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_logging_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_logging_configurations_response(response)
        }
    }
}

/// Operation shape for `ListManagedRuleSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_managed_rule_sets`](crate::client::Client::list_managed_rule_sets).
///
/// See [`crate::client::fluent_builders::ListManagedRuleSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListManagedRuleSets {
    _private: (),
}
impl ListManagedRuleSets {
    /// Creates a new builder-style object to manufacture [`ListManagedRuleSetsInput`](crate::input::ListManagedRuleSetsInput)
    pub fn builder() -> crate::input::list_managed_rule_sets_input::Builder {
        crate::input::list_managed_rule_sets_input::Builder::default()
    }
    /// Creates a new `ListManagedRuleSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListManagedRuleSets {
    type Output = std::result::Result<
        crate::output::ListManagedRuleSetsOutput,
        crate::error::ListManagedRuleSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_managed_rule_sets_error(response)
        } else {
            crate::operation_deser::parse_list_managed_rule_sets_response(response)
        }
    }
}

/// Operation shape for `ListRegexPatternSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_regex_pattern_sets`](crate::client::Client::list_regex_pattern_sets).
///
/// See [`crate::client::fluent_builders::ListRegexPatternSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRegexPatternSets {
    _private: (),
}
impl ListRegexPatternSets {
    /// Creates a new builder-style object to manufacture [`ListRegexPatternSetsInput`](crate::input::ListRegexPatternSetsInput)
    pub fn builder() -> crate::input::list_regex_pattern_sets_input::Builder {
        crate::input::list_regex_pattern_sets_input::Builder::default()
    }
    /// Creates a new `ListRegexPatternSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRegexPatternSets {
    type Output = std::result::Result<
        crate::output::ListRegexPatternSetsOutput,
        crate::error::ListRegexPatternSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_regex_pattern_sets_error(response)
        } else {
            crate::operation_deser::parse_list_regex_pattern_sets_response(response)
        }
    }
}

/// Operation shape for `ListResourcesForWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources_for_web_acl`](crate::client::Client::list_resources_for_web_acl).
///
/// See [`crate::client::fluent_builders::ListResourcesForWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourcesForWebACL {
    _private: (),
}
impl ListResourcesForWebACL {
    /// Creates a new builder-style object to manufacture [`ListResourcesForWebAclInput`](crate::input::ListResourcesForWebAclInput)
    pub fn builder() -> crate::input::list_resources_for_web_acl_input::Builder {
        crate::input::list_resources_for_web_acl_input::Builder::default()
    }
    /// Creates a new `ListResourcesForWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourcesForWebACL {
    type Output = std::result::Result<
        crate::output::ListResourcesForWebAclOutput,
        crate::error::ListResourcesForWebACLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_for_web_acl_error(response)
        } else {
            crate::operation_deser::parse_list_resources_for_web_acl_response(response)
        }
    }
}

/// Operation shape for `ListRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rule_groups`](crate::client::Client::list_rule_groups).
///
/// See [`crate::client::fluent_builders::ListRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRuleGroups {
    _private: (),
}
impl ListRuleGroups {
    /// Creates a new builder-style object to manufacture [`ListRuleGroupsInput`](crate::input::ListRuleGroupsInput)
    pub fn builder() -> crate::input::list_rule_groups_input::Builder {
        crate::input::list_rule_groups_input::Builder::default()
    }
    /// Creates a new `ListRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRuleGroups {
    type Output =
        std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_list_rule_groups_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWebACLs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_web_ac_ls`](crate::client::Client::list_web_ac_ls).
///
/// See [`crate::client::fluent_builders::ListWebACLs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWebACLs {
    _private: (),
}
impl ListWebACLs {
    /// Creates a new builder-style object to manufacture [`ListWebAcLsInput`](crate::input::ListWebAcLsInput)
    pub fn builder() -> crate::input::list_web_ac_ls_input::Builder {
        crate::input::list_web_ac_ls_input::Builder::default()
    }
    /// Creates a new `ListWebACLs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWebACLs {
    type Output =
        std::result::Result<crate::output::ListWebAcLsOutput, crate::error::ListWebACLsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_web_ac_ls_error(response)
        } else {
            crate::operation_deser::parse_list_web_ac_ls_response(response)
        }
    }
}

/// Operation shape for `PutLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_logging_configuration`](crate::client::Client::put_logging_configuration).
///
/// See [`crate::client::fluent_builders::PutLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLoggingConfiguration {
    _private: (),
}
impl PutLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`PutLoggingConfigurationInput`](crate::input::PutLoggingConfigurationInput)
    pub fn builder() -> crate::input::put_logging_configuration_input::Builder {
        crate::input::put_logging_configuration_input::Builder::default()
    }
    /// Creates a new `PutLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::PutLoggingConfigurationOutput,
        crate::error::PutLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `PutManagedRuleSetVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_managed_rule_set_versions`](crate::client::Client::put_managed_rule_set_versions).
///
/// See [`crate::client::fluent_builders::PutManagedRuleSetVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutManagedRuleSetVersions {
    _private: (),
}
impl PutManagedRuleSetVersions {
    /// Creates a new builder-style object to manufacture [`PutManagedRuleSetVersionsInput`](crate::input::PutManagedRuleSetVersionsInput)
    pub fn builder() -> crate::input::put_managed_rule_set_versions_input::Builder {
        crate::input::put_managed_rule_set_versions_input::Builder::default()
    }
    /// Creates a new `PutManagedRuleSetVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutManagedRuleSetVersions {
    type Output = std::result::Result<
        crate::output::PutManagedRuleSetVersionsOutput,
        crate::error::PutManagedRuleSetVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_managed_rule_set_versions_error(response)
        } else {
            crate::operation_deser::parse_put_managed_rule_set_versions_response(response)
        }
    }
}

/// Operation shape for `PutPermissionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_permission_policy`](crate::client::Client::put_permission_policy).
///
/// See [`crate::client::fluent_builders::PutPermissionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPermissionPolicy {
    _private: (),
}
impl PutPermissionPolicy {
    /// Creates a new builder-style object to manufacture [`PutPermissionPolicyInput`](crate::input::PutPermissionPolicyInput)
    pub fn builder() -> crate::input::put_permission_policy_input::Builder {
        crate::input::put_permission_policy_input::Builder::default()
    }
    /// Creates a new `PutPermissionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPermissionPolicy {
    type Output = std::result::Result<
        crate::output::PutPermissionPolicyOutput,
        crate::error::PutPermissionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_permission_policy_error(response)
        } else {
            crate::operation_deser::parse_put_permission_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ip_set`](crate::client::Client::update_ip_set).
///
/// See [`crate::client::fluent_builders::UpdateIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIPSet {
    _private: (),
}
impl UpdateIPSet {
    /// Creates a new builder-style object to manufacture [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
    pub fn builder() -> crate::input::update_ip_set_input::Builder {
        crate::input::update_ip_set_input::Builder::default()
    }
    /// Creates a new `UpdateIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIPSet {
    type Output =
        std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ip_set_error(response)
        } else {
            crate::operation_deser::parse_update_ip_set_response(response)
        }
    }
}

/// Operation shape for `UpdateManagedRuleSetVersionExpiryDate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_managed_rule_set_version_expiry_date`](crate::client::Client::update_managed_rule_set_version_expiry_date).
///
/// See [`crate::client::fluent_builders::UpdateManagedRuleSetVersionExpiryDate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateManagedRuleSetVersionExpiryDate {
    _private: (),
}
impl UpdateManagedRuleSetVersionExpiryDate {
    /// Creates a new builder-style object to manufacture [`UpdateManagedRuleSetVersionExpiryDateInput`](crate::input::UpdateManagedRuleSetVersionExpiryDateInput)
    pub fn builder() -> crate::input::update_managed_rule_set_version_expiry_date_input::Builder {
        crate::input::update_managed_rule_set_version_expiry_date_input::Builder::default()
    }
    /// Creates a new `UpdateManagedRuleSetVersionExpiryDate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateManagedRuleSetVersionExpiryDate {
    type Output = std::result::Result<
        crate::output::UpdateManagedRuleSetVersionExpiryDateOutput,
        crate::error::UpdateManagedRuleSetVersionExpiryDateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_managed_rule_set_version_expiry_date_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_managed_rule_set_version_expiry_date_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_regex_pattern_set`](crate::client::Client::update_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::UpdateRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRegexPatternSet {
    _private: (),
}
impl UpdateRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`UpdateRegexPatternSetInput`](crate::input::UpdateRegexPatternSetInput)
    pub fn builder() -> crate::input::update_regex_pattern_set_input::Builder {
        crate::input::update_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `UpdateRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRegexPatternSet {
    type Output = std::result::Result<
        crate::output::UpdateRegexPatternSetOutput,
        crate::error::UpdateRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_update_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `UpdateRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rule_group`](crate::client::Client::update_rule_group).
///
/// See [`crate::client::fluent_builders::UpdateRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuleGroup {
    _private: (),
}
impl UpdateRuleGroup {
    /// Creates a new builder-style object to manufacture [`UpdateRuleGroupInput`](crate::input::UpdateRuleGroupInput)
    pub fn builder() -> crate::input::update_rule_group_input::Builder {
        crate::input::update_rule_group_input::Builder::default()
    }
    /// Creates a new `UpdateRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuleGroup {
    type Output = std::result::Result<
        crate::output::UpdateRuleGroupOutput,
        crate::error::UpdateRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rule_group_error(response)
        } else {
            crate::operation_deser::parse_update_rule_group_response(response)
        }
    }
}

/// Operation shape for `UpdateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_web_acl`](crate::client::Client::update_web_acl).
///
/// See [`crate::client::fluent_builders::UpdateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWebACL {
    _private: (),
}
impl UpdateWebACL {
    /// Creates a new builder-style object to manufacture [`UpdateWebAclInput`](crate::input::UpdateWebAclInput)
    pub fn builder() -> crate::input::update_web_acl_input::Builder {
        crate::input::update_web_acl_input::Builder::default()
    }
    /// Creates a new `UpdateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWebACL {
    type Output =
        std::result::Result<crate::output::UpdateWebAclOutput, crate::error::UpdateWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_web_acl_error(response)
        } else {
            crate::operation_deser::parse_update_web_acl_response(response)
        }
    }
}
