// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateWebAclOutput, crate::error::AssociateWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AssociateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::AssociateWebACLError {
            meta: generic,
            kind: crate::error::AssociateWebACLErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AssociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AssociateWebAclOutput, crate::error::AssociateWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_web_acl_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_byte_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateByteMatchSetOutput,
    crate::error::CreateByteMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateByteMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateByteMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateByteMatchSetError {
            meta: generic,
            kind: crate::error::CreateByteMatchSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateByteMatchSetError {
            meta: generic,
            kind: crate::error::CreateByteMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateByteMatchSetError {
            meta: generic,
            kind: crate::error::CreateByteMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateByteMatchSetError {
            meta: generic,
            kind: crate::error::CreateByteMatchSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateByteMatchSetError {
            meta: generic,
            kind: crate::error::CreateByteMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateByteMatchSetError {
            meta: generic,
            kind: crate::error::CreateByteMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateByteMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_byte_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateByteMatchSetOutput,
    crate::error::CreateByteMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_byte_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_byte_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateByteMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_geo_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGeoMatchSetOutput, crate::error::CreateGeoMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGeoMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateGeoMatchSetError {
            meta: generic,
            kind: crate::error::CreateGeoMatchSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateGeoMatchSetError {
            meta: generic,
            kind: crate::error::CreateGeoMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateGeoMatchSetError {
            meta: generic,
            kind: crate::error::CreateGeoMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateGeoMatchSetError {
            meta: generic,
            kind: crate::error::CreateGeoMatchSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateGeoMatchSetError {
            meta: generic,
            kind: crate::error::CreateGeoMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateGeoMatchSetError {
            meta: generic,
            kind: crate::error::CreateGeoMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGeoMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_geo_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGeoMatchSetOutput, crate::error::CreateGeoMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_geo_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_geo_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGeoMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateIPSetError {
            meta: generic,
            kind: crate::error::CreateIPSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rate_based_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRateBasedRuleOutput,
    crate::error::CreateRateBasedRuleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRateBasedRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFDisallowedNameException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::CreateRateBasedRuleError {
            meta: generic,
            kind: crate::error::CreateRateBasedRuleErrorKind::WafTagOperationInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateRateBasedRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rate_based_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRateBasedRuleOutput,
    crate::error::CreateRateBasedRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_rate_based_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_rate_based_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRateBasedRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_regex_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRegexMatchSetOutput,
    crate::error::CreateRegexMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRegexMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRegexMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateRegexMatchSetError {
            meta: generic,
            kind: crate::error::CreateRegexMatchSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRegexMatchSetError {
            meta: generic,
            kind: crate::error::CreateRegexMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRegexMatchSetError {
            meta: generic,
            kind: crate::error::CreateRegexMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateRegexMatchSetError {
            meta: generic,
            kind: crate::error::CreateRegexMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRegexMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_regex_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRegexMatchSetOutput,
    crate::error::CreateRegexMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_regex_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_regex_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRegexMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRegexPatternSetOutput,
    crate::error::CreateRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateRegexPatternSetError {
            meta: generic,
            kind: crate::error::CreateRegexPatternSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRegexPatternSetOutput,
    crate::error::CreateRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFDisallowedNameException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateRuleError {
            meta: generic,
            kind: crate::error::CreateRuleErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::CreateRuleError {
                meta: generic,
                kind: crate::error::CreateRuleErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleGroupOutput, crate::error::CreateRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFDisallowedNameException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::CreateRuleGroupError {
            meta: generic,
            kind: crate::error::CreateRuleGroupErrorKind::WafTagOperationInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_tag_operation_internal_error_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRuleGroupOutput, crate::error::CreateRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_size_constraint_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSizeConstraintSetOutput,
    crate::error::CreateSizeConstraintSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateSizeConstraintSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::CreateSizeConstraintSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::CreateSizeConstraintSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::CreateSizeConstraintSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::CreateSizeConstraintSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::CreateSizeConstraintSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::CreateSizeConstraintSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSizeConstraintSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_size_constraint_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSizeConstraintSetOutput,
    crate::error::CreateSizeConstraintSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_size_constraint_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_size_constraint_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSizeConstraintSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_sql_injection_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSqlInjectionMatchSetOutput,
    crate::error::CreateSqlInjectionMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateSqlInjectionMatchSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::CreateSqlInjectionMatchSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::CreateSqlInjectionMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::CreateSqlInjectionMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::CreateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFLimitsExceededException" => crate::error::CreateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::CreateSqlInjectionMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::CreateSqlInjectionMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSqlInjectionMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_sql_injection_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSqlInjectionMatchSetOutput,
    crate::error::CreateSqlInjectionMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_sql_injection_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_sql_injection_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSqlInjectionMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWebAclOutput, crate::error::CreateWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFDisallowedNameException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::CreateWebACLError {
            meta: generic,
            kind: crate::error::CreateWebACLErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::CreateWebACLError {
                meta: generic,
                kind: crate::error::CreateWebACLErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateWebAclOutput, crate::error::CreateWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_web_acl_migration_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateWebAclMigrationStackOutput,
    crate::error::CreateWebACLMigrationStackError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateWebACLMigrationStackError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFEntityMigrationException" => crate::error::CreateWebACLMigrationStackError {
            meta: generic,
            kind: crate::error::CreateWebACLMigrationStackErrorKind::WafEntityMigrationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_entity_migration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_entity_migration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateWebACLMigrationStackError {
            meta: generic,
            kind: crate::error::CreateWebACLMigrationStackErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::CreateWebACLMigrationStackError {
            meta: generic,
            kind: crate::error::CreateWebACLMigrationStackErrorKind::WafInvalidOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInvalidParameterException" => crate::error::CreateWebACLMigrationStackError {
            meta: generic,
            kind: crate::error::CreateWebACLMigrationStackErrorKind::WafInvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFNonexistentItemException" => crate::error::CreateWebACLMigrationStackError {
            meta: generic,
            kind: crate::error::CreateWebACLMigrationStackErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateWebACLMigrationStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_web_acl_migration_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateWebAclMigrationStackOutput,
    crate::error::CreateWebACLMigrationStackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_web_acl_migration_stack_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_web_acl_migration_stack(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateWebACLMigrationStackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_xss_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateXssMatchSetOutput, crate::error::CreateXssMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateXssMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateXssMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::CreateXssMatchSetError {
            meta: generic,
            kind: crate::error::CreateXssMatchSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::CreateXssMatchSetError {
            meta: generic,
            kind: crate::error::CreateXssMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::CreateXssMatchSetError {
            meta: generic,
            kind: crate::error::CreateXssMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::CreateXssMatchSetError {
            meta: generic,
            kind: crate::error::CreateXssMatchSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::CreateXssMatchSetError {
            meta: generic,
            kind: crate::error::CreateXssMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::CreateXssMatchSetError {
            meta: generic,
            kind: crate::error::CreateXssMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateXssMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_xss_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateXssMatchSetOutput, crate::error::CreateXssMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_xss_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_xss_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateXssMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_byte_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteByteMatchSetOutput,
    crate::error::DeleteByteMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteByteMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteByteMatchSetError {
            meta: generic,
            kind: crate::error::DeleteByteMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteByteMatchSetError {
            meta: generic,
            kind: crate::error::DeleteByteMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteByteMatchSetError {
            meta: generic,
            kind: crate::error::DeleteByteMatchSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteByteMatchSetError {
            meta: generic,
            kind: crate::error::DeleteByteMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteByteMatchSetError {
            meta: generic,
            kind: crate::error::DeleteByteMatchSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteByteMatchSetError {
            meta: generic,
            kind: crate::error::DeleteByteMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteByteMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_byte_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteByteMatchSetOutput,
    crate::error::DeleteByteMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_byte_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_byte_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteByteMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_geo_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGeoMatchSetOutput, crate::error::DeleteGeoMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGeoMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteGeoMatchSetError {
            meta: generic,
            kind: crate::error::DeleteGeoMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteGeoMatchSetError {
            meta: generic,
            kind: crate::error::DeleteGeoMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteGeoMatchSetError {
            meta: generic,
            kind: crate::error::DeleteGeoMatchSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteGeoMatchSetError {
            meta: generic,
            kind: crate::error::DeleteGeoMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteGeoMatchSetError {
            meta: generic,
            kind: crate::error::DeleteGeoMatchSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteGeoMatchSetError {
            meta: generic,
            kind: crate::error::DeleteGeoMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGeoMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_geo_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGeoMatchSetOutput, crate::error::DeleteGeoMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_geo_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_geo_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteGeoMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteIPSetError {
            meta: generic,
            kind: crate::error::DeleteIPSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_logging_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoggingConfigurationOutput,
    crate::error::DeleteLoggingConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteLoggingConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteLoggingConfigurationError {
            meta: generic,
            kind: crate::error::DeleteLoggingConfigurationErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLoggingConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_logging_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoggingConfigurationOutput,
    crate::error::DeleteLoggingConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_logging_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_permission_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePermissionPolicyOutput,
    crate::error::DeletePermissionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeletePermissionPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeletePermissionPolicyError {
            meta: generic,
            kind: crate::error::DeletePermissionPolicyErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeletePermissionPolicyError {
            meta: generic,
            kind: crate::error::DeletePermissionPolicyErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeletePermissionPolicyError {
            meta: generic,
            kind: crate::error::DeletePermissionPolicyErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePermissionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_permission_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePermissionPolicyOutput,
    crate::error::DeletePermissionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_permission_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rate_based_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRateBasedRuleOutput,
    crate::error::DeleteRateBasedRuleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRateBasedRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::DeleteRateBasedRuleError {
            meta: generic,
            kind: crate::error::DeleteRateBasedRuleErrorKind::WafTagOperationInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteRateBasedRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rate_based_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRateBasedRuleOutput,
    crate::error::DeleteRateBasedRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_rate_based_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_rate_based_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRateBasedRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_regex_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegexMatchSetOutput,
    crate::error::DeleteRegexMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRegexMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteRegexMatchSetError {
            meta: generic,
            kind: crate::error::DeleteRegexMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteRegexMatchSetError {
            meta: generic,
            kind: crate::error::DeleteRegexMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteRegexMatchSetError {
            meta: generic,
            kind: crate::error::DeleteRegexMatchSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRegexMatchSetError {
            meta: generic,
            kind: crate::error::DeleteRegexMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteRegexMatchSetError {
            meta: generic,
            kind: crate::error::DeleteRegexMatchSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteRegexMatchSetError {
            meta: generic,
            kind: crate::error::DeleteRegexMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRegexMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_regex_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegexMatchSetOutput,
    crate::error::DeleteRegexMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_regex_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_regex_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRegexMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegexPatternSetOutput,
    crate::error::DeleteRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteRegexPatternSetError {
            meta: generic,
            kind: crate::error::DeleteRegexPatternSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegexPatternSetOutput,
    crate::error::DeleteRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteRuleError {
            meta: generic,
            kind: crate::error::DeleteRuleErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::DeleteRuleError {
                meta: generic,
                kind: crate::error::DeleteRuleErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleGroupOutput, crate::error::DeleteRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::DeleteRuleGroupError {
            meta: generic,
            kind: crate::error::DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_tag_operation_internal_error_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRuleGroupOutput, crate::error::DeleteRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_size_constraint_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSizeConstraintSetOutput,
    crate::error::DeleteSizeConstraintSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSizeConstraintSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteSizeConstraintSetError {
            meta: generic,
            kind: crate::error::DeleteSizeConstraintSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteSizeConstraintSetError {
            meta: generic,
            kind: crate::error::DeleteSizeConstraintSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteSizeConstraintSetError {
            meta: generic,
            kind: crate::error::DeleteSizeConstraintSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteSizeConstraintSetError {
            meta: generic,
            kind: crate::error::DeleteSizeConstraintSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteSizeConstraintSetError {
            meta: generic,
            kind: crate::error::DeleteSizeConstraintSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteSizeConstraintSetError {
            meta: generic,
            kind: crate::error::DeleteSizeConstraintSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSizeConstraintSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_size_constraint_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSizeConstraintSetOutput,
    crate::error::DeleteSizeConstraintSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_size_constraint_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_size_constraint_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSizeConstraintSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_sql_injection_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSqlInjectionMatchSetOutput,
    crate::error::DeleteSqlInjectionMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSqlInjectionMatchSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::DeleteSqlInjectionMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::DeleteSqlInjectionMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::DeleteSqlInjectionMatchSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::DeleteSqlInjectionMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::DeleteSqlInjectionMatchSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::DeleteSqlInjectionMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSqlInjectionMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_sql_injection_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSqlInjectionMatchSetOutput,
    crate::error::DeleteSqlInjectionMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_sql_injection_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_sql_injection_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSqlInjectionMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWebAclOutput, crate::error::DeleteWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::DeleteWebACLError {
            meta: generic,
            kind: crate::error::DeleteWebACLErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::DeleteWebACLError {
                meta: generic,
                kind: crate::error::DeleteWebACLErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteWebACLError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteWebAclOutput, crate::error::DeleteWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_xss_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteXssMatchSetOutput, crate::error::DeleteXssMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteXssMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DeleteXssMatchSetError {
            meta: generic,
            kind: crate::error::DeleteXssMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DeleteXssMatchSetError {
            meta: generic,
            kind: crate::error::DeleteXssMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonEmptyEntityException" => crate::error::DeleteXssMatchSetError {
            meta: generic,
            kind: crate::error::DeleteXssMatchSetErrorKind::WafNonEmptyEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_non_empty_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_non_empty_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DeleteXssMatchSetError {
            meta: generic,
            kind: crate::error::DeleteXssMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::DeleteXssMatchSetError {
            meta: generic,
            kind: crate::error::DeleteXssMatchSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::DeleteXssMatchSetError {
            meta: generic,
            kind: crate::error::DeleteXssMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteXssMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_xss_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteXssMatchSetOutput, crate::error::DeleteXssMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_xss_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_xss_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteXssMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateWebAclOutput,
    crate::error::DisassociateWebACLError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisassociateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::DisassociateWebACLError {
            meta: generic,
            kind: crate::error::DisassociateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisassociateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateWebAclOutput,
    crate::error::DisassociateWebACLError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_web_acl_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_byte_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetByteMatchSetOutput, crate::error::GetByteMatchSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetByteMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetByteMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetByteMatchSetError {
            meta: generic,
            kind: crate::error::GetByteMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetByteMatchSetError {
            meta: generic,
            kind: crate::error::GetByteMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetByteMatchSetError {
            meta: generic,
            kind: crate::error::GetByteMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetByteMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_byte_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetByteMatchSetOutput, crate::error::GetByteMatchSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_byte_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_byte_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetByteMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_change_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetChangeTokenOutput, crate::error::GetChangeTokenError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetChangeTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetChangeTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetChangeTokenError {
            meta: generic,
            kind: crate::error::GetChangeTokenErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChangeTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetChangeTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_change_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetChangeTokenOutput, crate::error::GetChangeTokenError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_change_token_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_change_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetChangeTokenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_change_token_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetChangeTokenStatusOutput,
    crate::error::GetChangeTokenStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetChangeTokenStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetChangeTokenStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetChangeTokenStatusError {
            meta: generic,
            kind: crate::error::GetChangeTokenStatusErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChangeTokenStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetChangeTokenStatusError {
            meta: generic,
            kind: crate::error::GetChangeTokenStatusErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetChangeTokenStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetChangeTokenStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_change_token_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetChangeTokenStatusOutput,
    crate::error::GetChangeTokenStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_change_token_status_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_change_token_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetChangeTokenStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_geo_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGeoMatchSetOutput, crate::error::GetGeoMatchSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetGeoMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetGeoMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetGeoMatchSetError {
            meta: generic,
            kind: crate::error::GetGeoMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetGeoMatchSetError {
            meta: generic,
            kind: crate::error::GetGeoMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetGeoMatchSetError {
            meta: generic,
            kind: crate::error::GetGeoMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetGeoMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_geo_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGeoMatchSetOutput, crate::error::GetGeoMatchSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_geo_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_geo_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetGeoMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetIPSetError {
            meta: generic,
            kind: crate::error::GetIPSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_logging_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoggingConfigurationOutput,
    crate::error::GetLoggingConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetLoggingConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetLoggingConfigurationError {
            meta: generic,
            kind: crate::error::GetLoggingConfigurationErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetLoggingConfigurationError {
            meta: generic,
            kind: crate::error::GetLoggingConfigurationErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLoggingConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_logging_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoggingConfigurationOutput,
    crate::error::GetLoggingConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_logging_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_logging_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLoggingConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_permission_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPermissionPolicyOutput,
    crate::error::GetPermissionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPermissionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPermissionPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetPermissionPolicyError {
            meta: generic,
            kind: crate::error::GetPermissionPolicyErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetPermissionPolicyError {
            meta: generic,
            kind: crate::error::GetPermissionPolicyErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPermissionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_permission_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPermissionPolicyOutput,
    crate::error::GetPermissionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_permission_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_permission_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPermissionPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rate_based_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRateBasedRuleOutput, crate::error::GetRateBasedRuleError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRateBasedRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRateBasedRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRateBasedRuleError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetRateBasedRuleError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRateBasedRuleError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRateBasedRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rate_based_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRateBasedRuleOutput, crate::error::GetRateBasedRuleError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_rate_based_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_rate_based_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRateBasedRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rate_based_rule_managed_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRateBasedRuleManagedKeysOutput,
    crate::error::GetRateBasedRuleManagedKeysError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRateBasedRuleManagedKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRateBasedRuleManagedKeysError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRateBasedRuleManagedKeysError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleManagedKeysErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleManagedKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetRateBasedRuleManagedKeysError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleManagedKeysErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleManagedKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetRateBasedRuleManagedKeysError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleManagedKeysErrorKind::WafInvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleManagedKeysError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFNonexistentItemException" => crate::error::GetRateBasedRuleManagedKeysError {
            meta: generic,
            kind: crate::error::GetRateBasedRuleManagedKeysErrorKind::WafNonexistentItemException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_nonexistent_item_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRateBasedRuleManagedKeysError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetRateBasedRuleManagedKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rate_based_rule_managed_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRateBasedRuleManagedKeysOutput,
    crate::error::GetRateBasedRuleManagedKeysError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_rate_based_rule_managed_keys_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_rate_based_rule_managed_keys(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRateBasedRuleManagedKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regex_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRegexMatchSetOutput, crate::error::GetRegexMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRegexMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRegexMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRegexMatchSetError {
            meta: generic,
            kind: crate::error::GetRegexMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetRegexMatchSetError {
            meta: generic,
            kind: crate::error::GetRegexMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRegexMatchSetError {
            meta: generic,
            kind: crate::error::GetRegexMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRegexMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regex_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRegexMatchSetOutput, crate::error::GetRegexMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_regex_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_regex_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRegexMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRegexPatternSetOutput,
    crate::error::GetRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRegexPatternSetError {
            meta: generic,
            kind: crate::error::GetRegexPatternSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRegexPatternSetOutput,
    crate::error::GetRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRuleOutput, crate::error::GetRuleError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRuleError {
            meta: generic,
            kind: crate::error::GetRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetRuleError {
            meta: generic,
            kind: crate::error::GetRuleErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRuleError {
            meta: generic,
            kind: crate::error::GetRuleErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRuleOutput, crate::error::GetRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRuleGroupOutput, crate::error::GetRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetRuleGroupError {
            meta: generic,
            kind: crate::error::GetRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetRuleGroupError {
            meta: generic,
            kind: crate::error::GetRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRuleGroupOutput, crate::error::GetRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sampled_requests_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSampledRequestsOutput,
    crate::error::GetSampledRequestsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSampledRequestsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSampledRequestsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetSampledRequestsError {
            meta: generic,
            kind: crate::error::GetSampledRequestsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSampledRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetSampledRequestsError {
            meta: generic,
            kind: crate::error::GetSampledRequestsErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSampledRequestsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSampledRequestsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sampled_requests_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSampledRequestsOutput,
    crate::error::GetSampledRequestsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_sampled_requests_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_sampled_requests(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSampledRequestsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_size_constraint_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSizeConstraintSetOutput,
    crate::error::GetSizeConstraintSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSizeConstraintSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSizeConstraintSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetSizeConstraintSetError {
            meta: generic,
            kind: crate::error::GetSizeConstraintSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetSizeConstraintSetError {
            meta: generic,
            kind: crate::error::GetSizeConstraintSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetSizeConstraintSetError {
            meta: generic,
            kind: crate::error::GetSizeConstraintSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSizeConstraintSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_size_constraint_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSizeConstraintSetOutput,
    crate::error::GetSizeConstraintSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_size_constraint_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_size_constraint_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSizeConstraintSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sql_injection_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSqlInjectionMatchSetOutput,
    crate::error::GetSqlInjectionMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSqlInjectionMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSqlInjectionMatchSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::GetSqlInjectionMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::GetSqlInjectionMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::GetSqlInjectionMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSqlInjectionMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_sql_injection_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSqlInjectionMatchSetOutput,
    crate::error::GetSqlInjectionMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_sql_injection_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_sql_injection_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSqlInjectionMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetWebAclOutput, crate::error::GetWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetWebACLError {
            meta: generic,
            kind: crate::error::GetWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetWebAclOutput, crate::error::GetWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetWebAclForResourceOutput,
    crate::error::GetWebACLForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetWebACLForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetWebACLForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFUnavailableEntityException" => crate::error::GetWebACLForResourceError {
            meta: generic,
            kind: crate::error::GetWebACLForResourceErrorKind::WafUnavailableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_unavailable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_unavailable_entity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetWebACLForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetWebACLForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_web_acl_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetWebAclForResourceOutput,
    crate::error::GetWebACLForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_web_acl_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_web_acl_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetWebACLForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_xss_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetXssMatchSetOutput, crate::error::GetXssMatchSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetXssMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetXssMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::GetXssMatchSetError {
            meta: generic,
            kind: crate::error::GetXssMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::GetXssMatchSetError {
            meta: generic,
            kind: crate::error::GetXssMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::GetXssMatchSetError {
            meta: generic,
            kind: crate::error::GetXssMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetXssMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_xss_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetXssMatchSetOutput, crate::error::GetXssMatchSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_xss_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_xss_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetXssMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_activated_rules_in_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListActivatedRulesInRuleGroupOutput,
    crate::error::ListActivatedRulesInRuleGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListActivatedRulesInRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListActivatedRulesInRuleGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListActivatedRulesInRuleGroupError {
            meta: generic,
            kind: crate::error::ListActivatedRulesInRuleGroupErrorKind::WafInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActivatedRulesInRuleGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInvalidParameterException" => crate::error::ListActivatedRulesInRuleGroupError {
            meta: generic,
            kind:
                crate::error::ListActivatedRulesInRuleGroupErrorKind::WafInvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActivatedRulesInRuleGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFNonexistentItemException" => crate::error::ListActivatedRulesInRuleGroupError {
            meta: generic,
            kind: crate::error::ListActivatedRulesInRuleGroupErrorKind::WafNonexistentItemException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_nonexistent_item_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListActivatedRulesInRuleGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListActivatedRulesInRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_activated_rules_in_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListActivatedRulesInRuleGroupOutput,
    crate::error::ListActivatedRulesInRuleGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_activated_rules_in_rule_group_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_activated_rules_in_rule_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListActivatedRulesInRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_byte_match_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListByteMatchSetsOutput, crate::error::ListByteMatchSetsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListByteMatchSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListByteMatchSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListByteMatchSetsError {
            meta: generic,
            kind: crate::error::ListByteMatchSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListByteMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListByteMatchSetsError {
            meta: generic,
            kind: crate::error::ListByteMatchSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListByteMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListByteMatchSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_byte_match_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListByteMatchSetsOutput, crate::error::ListByteMatchSetsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_byte_match_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_byte_match_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListByteMatchSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_geo_match_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGeoMatchSetsOutput, crate::error::ListGeoMatchSetsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGeoMatchSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGeoMatchSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListGeoMatchSetsError {
            meta: generic,
            kind: crate::error::ListGeoMatchSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGeoMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListGeoMatchSetsError {
            meta: generic,
            kind: crate::error::ListGeoMatchSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGeoMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGeoMatchSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_geo_match_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGeoMatchSetsOutput, crate::error::ListGeoMatchSetsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_geo_match_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_geo_match_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGeoMatchSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ip_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListIPSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListIPSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListIPSetsError {
            meta: generic,
            kind: crate::error::ListIPSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIPSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListIPSetsError {
            meta: generic,
            kind: crate::error::ListIPSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListIPSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListIPSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ip_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_ip_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_ip_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListIPSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_logging_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLoggingConfigurationsOutput,
    crate::error::ListLoggingConfigurationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListLoggingConfigurationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListLoggingConfigurationsError {
            meta: generic,
            kind: crate::error::ListLoggingConfigurationsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListLoggingConfigurationsError {
            meta: generic,
            kind: crate::error::ListLoggingConfigurationsErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::ListLoggingConfigurationsError {
            meta: generic,
            kind: crate::error::ListLoggingConfigurationsErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLoggingConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_logging_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListLoggingConfigurationsOutput,
    crate::error::ListLoggingConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_logging_configurations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_logging_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLoggingConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rate_based_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRateBasedRulesOutput,
    crate::error::ListRateBasedRulesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRateBasedRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRateBasedRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRateBasedRulesError {
            meta: generic,
            kind: crate::error::ListRateBasedRulesErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRateBasedRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListRateBasedRulesError {
            meta: generic,
            kind: crate::error::ListRateBasedRulesErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRateBasedRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRateBasedRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rate_based_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRateBasedRulesOutput,
    crate::error::ListRateBasedRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_rate_based_rules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_rate_based_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRateBasedRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regex_match_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegexMatchSetsOutput,
    crate::error::ListRegexMatchSetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRegexMatchSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRegexMatchSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRegexMatchSetsError {
            meta: generic,
            kind: crate::error::ListRegexMatchSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListRegexMatchSetsError {
            meta: generic,
            kind: crate::error::ListRegexMatchSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRegexMatchSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regex_match_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegexMatchSetsOutput,
    crate::error::ListRegexMatchSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_regex_match_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_regex_match_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRegexMatchSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regex_pattern_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegexPatternSetsOutput,
    crate::error::ListRegexPatternSetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRegexPatternSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRegexPatternSetsError {
            meta: generic,
            kind: crate::error::ListRegexPatternSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListRegexPatternSetsError {
            meta: generic,
            kind: crate::error::ListRegexPatternSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRegexPatternSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regex_pattern_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegexPatternSetsOutput,
    crate::error::ListRegexPatternSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_regex_pattern_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_regex_pattern_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRegexPatternSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_for_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesForWebAclOutput,
    crate::error::ListResourcesForWebACLError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListResourcesForWebACLError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::ListResourcesForWebACLError {
            meta: generic,
            kind: crate::error::ListResourcesForWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListResourcesForWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_resources_for_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListResourcesForWebAclOutput,
    crate::error::ListResourcesForWebACLError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_resources_for_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_resources_for_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListResourcesForWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rule_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRuleGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRuleGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRuleGroupsError {
            meta: generic,
            kind: crate::error::ListRuleGroupsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRuleGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRuleGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rule_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_rule_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_rule_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRuleGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRulesOutput, crate::error::ListRulesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListRulesError {
            meta: generic,
            kind: crate::error::ListRulesErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListRulesError {
            meta: generic,
            kind: crate::error::ListRulesErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRulesOutput, crate::error::ListRulesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_rules_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_size_constraint_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSizeConstraintSetsOutput,
    crate::error::ListSizeConstraintSetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSizeConstraintSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSizeConstraintSetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListSizeConstraintSetsError {
            meta: generic,
            kind: crate::error::ListSizeConstraintSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSizeConstraintSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListSizeConstraintSetsError {
            meta: generic,
            kind: crate::error::ListSizeConstraintSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSizeConstraintSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSizeConstraintSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_size_constraint_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSizeConstraintSetsOutput,
    crate::error::ListSizeConstraintSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_size_constraint_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_size_constraint_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSizeConstraintSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_sql_injection_match_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSqlInjectionMatchSetsOutput,
    crate::error::ListSqlInjectionMatchSetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSqlInjectionMatchSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSqlInjectionMatchSetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListSqlInjectionMatchSetsError {
            meta: generic,
            kind: crate::error::ListSqlInjectionMatchSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSqlInjectionMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListSqlInjectionMatchSetsError {
            meta: generic,
            kind: crate::error::ListSqlInjectionMatchSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSqlInjectionMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSqlInjectionMatchSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_sql_injection_match_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSqlInjectionMatchSetsOutput,
    crate::error::ListSqlInjectionMatchSetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_sql_injection_match_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_sql_injection_match_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSqlInjectionMatchSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscribed_rule_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSubscribedRuleGroupsOutput,
    crate::error::ListSubscribedRuleGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSubscribedRuleGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSubscribedRuleGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListSubscribedRuleGroupsError {
            meta: generic,
            kind: crate::error::ListSubscribedRuleGroupsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSubscribedRuleGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::ListSubscribedRuleGroupsError {
            meta: generic,
            kind: crate::error::ListSubscribedRuleGroupsErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSubscribedRuleGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSubscribedRuleGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_subscribed_rule_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSubscribedRuleGroupsOutput,
    crate::error::ListSubscribedRuleGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_subscribed_rule_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_subscribed_rule_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSubscribedRuleGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_web_ac_ls_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWebAcLsOutput, crate::error::ListWebACLsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListWebACLsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListWebACLsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListWebACLsError {
            meta: generic,
            kind: crate::error::ListWebACLsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebACLsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListWebACLsError {
            meta: generic,
            kind: crate::error::ListWebACLsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListWebACLsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListWebACLsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_web_ac_ls_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListWebAcLsOutput, crate::error::ListWebACLsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_web_ac_ls_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_web_ac_ls(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListWebACLsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_xss_match_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListXssMatchSetsOutput, crate::error::ListXssMatchSetsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListXssMatchSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListXssMatchSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::ListXssMatchSetsError {
            meta: generic,
            kind: crate::error::ListXssMatchSetsErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListXssMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::ListXssMatchSetsError {
            meta: generic,
            kind: crate::error::ListXssMatchSetsErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListXssMatchSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListXssMatchSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_xss_match_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListXssMatchSetsOutput, crate::error::ListXssMatchSetsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_xss_match_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_xss_match_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListXssMatchSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_logging_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLoggingConfigurationOutput,
    crate::error::PutLoggingConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutLoggingConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::PutLoggingConfigurationError {
            meta: generic,
            kind: crate::error::PutLoggingConfigurationErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::PutLoggingConfigurationError {
            meta: generic,
            kind: crate::error::PutLoggingConfigurationErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFServiceLinkedRoleErrorException" => crate::error::PutLoggingConfigurationError {
            meta: generic,
            kind:
                crate::error::PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::waf_service_linked_role_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_service_linked_role_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFStaleDataException" => crate::error::PutLoggingConfigurationError {
            meta: generic,
            kind: crate::error::PutLoggingConfigurationErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutLoggingConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_logging_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLoggingConfigurationOutput,
    crate::error::PutLoggingConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_logging_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_logging_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutLoggingConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_permission_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPermissionPolicyOutput,
    crate::error::PutPermissionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutPermissionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutPermissionPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::PutPermissionPolicyError {
            meta: generic,
            kind: crate::error::PutPermissionPolicyErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidPermissionPolicyException" => {
            crate::error::PutPermissionPolicyError {
                meta: generic,
                kind:
                    crate::error::PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::waf_invalid_permission_policy_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_waf_invalid_permission_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "WAFNonexistentItemException" => crate::error::PutPermissionPolicyError {
            meta: generic,
            kind: crate::error::PutPermissionPolicyErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::PutPermissionPolicyError {
            meta: generic,
            kind: crate::error::PutPermissionPolicyErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutPermissionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutPermissionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_permission_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPermissionPolicyOutput,
    crate::error::PutPermissionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_permission_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::WafTagOperationInternalErrorException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::waf_tag_operation_internal_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFBadRequestException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafBadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafTagOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_tag_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFTagOperationInternalErrorException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::WafTagOperationInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_tag_operation_internal_error_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_tag_operation_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_byte_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateByteMatchSetOutput,
    crate::error::UpdateByteMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateByteMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateByteMatchSetError {
            meta: generic,
            kind: crate::error::UpdateByteMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateByteMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_byte_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateByteMatchSetOutput,
    crate::error::UpdateByteMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_byte_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_byte_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateByteMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_geo_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGeoMatchSetOutput, crate::error::UpdateGeoMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateGeoMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateGeoMatchSetError {
            meta: generic,
            kind: crate::error::UpdateGeoMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGeoMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_geo_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGeoMatchSetOutput, crate::error::UpdateGeoMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_geo_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_geo_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateGeoMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ip_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateIPSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateIPSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateIPSetError {
            meta: generic,
            kind: crate::error::UpdateIPSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateIPSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateIPSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ip_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_ip_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_ip_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateIPSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rate_based_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRateBasedRuleOutput,
    crate::error::UpdateRateBasedRuleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRateBasedRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateRateBasedRuleError {
            meta: generic,
            kind: crate::error::UpdateRateBasedRuleErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRateBasedRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rate_based_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRateBasedRuleOutput,
    crate::error::UpdateRateBasedRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_rate_based_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_rate_based_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRateBasedRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_regex_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRegexMatchSetOutput,
    crate::error::UpdateRegexMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRegexMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFDisallowedNameException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafDisallowedNameException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_disallowed_name_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_disallowed_name_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInternalErrorException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateRegexMatchSetError {
            meta: generic,
            kind: crate::error::UpdateRegexMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRegexMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_regex_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRegexMatchSetOutput,
    crate::error::UpdateRegexMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_regex_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_regex_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRegexMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_regex_pattern_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRegexPatternSetOutput,
    crate::error::UpdateRegexPatternSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRegexPatternSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidRegexPatternException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafInvalidRegexPatternException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_regex_pattern_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_regex_pattern_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateRegexPatternSetError {
            meta: generic,
            kind: crate::error::UpdateRegexPatternSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRegexPatternSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_regex_pattern_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRegexPatternSetOutput,
    crate::error::UpdateRegexPatternSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_regex_pattern_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_regex_pattern_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRegexPatternSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRuleOutput, crate::error::UpdateRuleError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateRuleError {
            meta: generic,
            kind: crate::error::UpdateRuleErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRuleOutput, crate::error::UpdateRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rule_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRuleGroupOutput, crate::error::UpdateRuleGroupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRuleGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRuleGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateRuleGroupError {
            meta: generic,
            kind: crate::error::UpdateRuleGroupErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateRuleGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRuleGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_rule_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRuleGroupOutput, crate::error::UpdateRuleGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_rule_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_rule_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRuleGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_size_constraint_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSizeConstraintSetOutput,
    crate::error::UpdateSizeConstraintSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSizeConstraintSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafNonexistentContainerException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_nonexistent_container_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFNonexistentItemException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateSizeConstraintSetError {
            meta: generic,
            kind: crate::error::UpdateSizeConstraintSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSizeConstraintSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_size_constraint_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSizeConstraintSetOutput,
    crate::error::UpdateSizeConstraintSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_size_constraint_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_size_constraint_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSizeConstraintSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_sql_injection_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSqlInjectionMatchSetOutput,
    crate::error::UpdateSqlInjectionMatchSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSqlInjectionMatchSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafInvalidOperationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_operation_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFInvalidParameterException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::waf_invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "WAFLimitsExceededException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind:
                crate::error::UpdateSqlInjectionMatchSetErrorKind::WafNonexistentContainerException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::waf_nonexistent_container_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "WAFNonexistentItemException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateSqlInjectionMatchSetError {
            meta: generic,
            kind: crate::error::UpdateSqlInjectionMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSqlInjectionMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_sql_injection_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSqlInjectionMatchSetOutput,
    crate::error::UpdateSqlInjectionMatchSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_sql_injection_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_sql_injection_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSqlInjectionMatchSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_web_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWebAclOutput, crate::error::UpdateWebACLError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateWebACLError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateWebACLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFReferencedItemException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafReferencedItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_referenced_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_referenced_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFSubscriptionNotFoundException" => crate::error::UpdateWebACLError {
            meta: generic,
            kind: crate::error::UpdateWebACLErrorKind::WafSubscriptionNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_subscription_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_subscription_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateWebACLError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateWebACLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_web_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateWebAclOutput, crate::error::UpdateWebACLError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_web_acl_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_web_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateWebACLError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_xss_match_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateXssMatchSetOutput, crate::error::UpdateXssMatchSetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateXssMatchSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "WAFInternalErrorException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafInternalErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_internal_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_internal_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidAccountException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafInvalidAccountException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_account_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_account_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidOperationException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafInvalidOperationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_operation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_operation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFInvalidParameterException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafInvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFLimitsExceededException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafLimitsExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_limits_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_limits_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentContainerException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafNonexistentContainerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_container_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_container_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFNonexistentItemException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafNonexistentItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::waf_nonexistent_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_nonexistent_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "WAFStaleDataException" => crate::error::UpdateXssMatchSetError {
            meta: generic,
            kind: crate::error::UpdateXssMatchSetErrorKind::WafStaleDataException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::waf_stale_data_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_waf_stale_data_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateXssMatchSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_xss_match_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateXssMatchSetOutput, crate::error::UpdateXssMatchSetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_xss_match_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_xss_match_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateXssMatchSetError::unhandled)?;
        output.build()
    })
}
