// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_web_acl`](crate::client::Client::associate_web_acl).
///
/// See [`crate::client::fluent_builders::AssociateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateWebACL {
    _private: (),
}
impl AssociateWebACL {
    /// Creates a new builder-style object to manufacture [`AssociateWebAclInput`](crate::input::AssociateWebAclInput)
    pub fn builder() -> crate::input::associate_web_acl_input::Builder {
        crate::input::associate_web_acl_input::Builder::default()
    }
    /// Creates a new `AssociateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateWebACL {
    type Output = std::result::Result<
        crate::output::AssociateWebAclOutput,
        crate::error::AssociateWebACLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_web_acl_error(response)
        } else {
            crate::operation_deser::parse_associate_web_acl_response(response)
        }
    }
}

/// Operation shape for `CreateByteMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_byte_match_set`](crate::client::Client::create_byte_match_set).
///
/// See [`crate::client::fluent_builders::CreateByteMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateByteMatchSet {
    _private: (),
}
impl CreateByteMatchSet {
    /// Creates a new builder-style object to manufacture [`CreateByteMatchSetInput`](crate::input::CreateByteMatchSetInput)
    pub fn builder() -> crate::input::create_byte_match_set_input::Builder {
        crate::input::create_byte_match_set_input::Builder::default()
    }
    /// Creates a new `CreateByteMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateByteMatchSet {
    type Output = std::result::Result<
        crate::output::CreateByteMatchSetOutput,
        crate::error::CreateByteMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_byte_match_set_error(response)
        } else {
            crate::operation_deser::parse_create_byte_match_set_response(response)
        }
    }
}

/// Operation shape for `CreateGeoMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_geo_match_set`](crate::client::Client::create_geo_match_set).
///
/// See [`crate::client::fluent_builders::CreateGeoMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGeoMatchSet {
    _private: (),
}
impl CreateGeoMatchSet {
    /// Creates a new builder-style object to manufacture [`CreateGeoMatchSetInput`](crate::input::CreateGeoMatchSetInput)
    pub fn builder() -> crate::input::create_geo_match_set_input::Builder {
        crate::input::create_geo_match_set_input::Builder::default()
    }
    /// Creates a new `CreateGeoMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGeoMatchSet {
    type Output = std::result::Result<
        crate::output::CreateGeoMatchSetOutput,
        crate::error::CreateGeoMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_geo_match_set_error(response)
        } else {
            crate::operation_deser::parse_create_geo_match_set_response(response)
        }
    }
}

/// Operation shape for `CreateIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ip_set`](crate::client::Client::create_ip_set).
///
/// See [`crate::client::fluent_builders::CreateIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIPSet {
    _private: (),
}
impl CreateIPSet {
    /// Creates a new builder-style object to manufacture [`CreateIpSetInput`](crate::input::CreateIpSetInput)
    pub fn builder() -> crate::input::create_ip_set_input::Builder {
        crate::input::create_ip_set_input::Builder::default()
    }
    /// Creates a new `CreateIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIPSet {
    type Output =
        std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ip_set_error(response)
        } else {
            crate::operation_deser::parse_create_ip_set_response(response)
        }
    }
}

/// Operation shape for `CreateRateBasedRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rate_based_rule`](crate::client::Client::create_rate_based_rule).
///
/// See [`crate::client::fluent_builders::CreateRateBasedRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRateBasedRule {
    _private: (),
}
impl CreateRateBasedRule {
    /// Creates a new builder-style object to manufacture [`CreateRateBasedRuleInput`](crate::input::CreateRateBasedRuleInput)
    pub fn builder() -> crate::input::create_rate_based_rule_input::Builder {
        crate::input::create_rate_based_rule_input::Builder::default()
    }
    /// Creates a new `CreateRateBasedRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRateBasedRule {
    type Output = std::result::Result<
        crate::output::CreateRateBasedRuleOutput,
        crate::error::CreateRateBasedRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rate_based_rule_error(response)
        } else {
            crate::operation_deser::parse_create_rate_based_rule_response(response)
        }
    }
}

/// Operation shape for `CreateRegexMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_regex_match_set`](crate::client::Client::create_regex_match_set).
///
/// See [`crate::client::fluent_builders::CreateRegexMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRegexMatchSet {
    _private: (),
}
impl CreateRegexMatchSet {
    /// Creates a new builder-style object to manufacture [`CreateRegexMatchSetInput`](crate::input::CreateRegexMatchSetInput)
    pub fn builder() -> crate::input::create_regex_match_set_input::Builder {
        crate::input::create_regex_match_set_input::Builder::default()
    }
    /// Creates a new `CreateRegexMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRegexMatchSet {
    type Output = std::result::Result<
        crate::output::CreateRegexMatchSetOutput,
        crate::error::CreateRegexMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_regex_match_set_error(response)
        } else {
            crate::operation_deser::parse_create_regex_match_set_response(response)
        }
    }
}

/// Operation shape for `CreateRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_regex_pattern_set`](crate::client::Client::create_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::CreateRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRegexPatternSet {
    _private: (),
}
impl CreateRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`CreateRegexPatternSetInput`](crate::input::CreateRegexPatternSetInput)
    pub fn builder() -> crate::input::create_regex_pattern_set_input::Builder {
        crate::input::create_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `CreateRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRegexPatternSet {
    type Output = std::result::Result<
        crate::output::CreateRegexPatternSetOutput,
        crate::error::CreateRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_create_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `CreateRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rule`](crate::client::Client::create_rule).
///
/// See [`crate::client::fluent_builders::CreateRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRule {
    _private: (),
}
impl CreateRule {
    /// Creates a new builder-style object to manufacture [`CreateRuleInput`](crate::input::CreateRuleInput)
    pub fn builder() -> crate::input::create_rule_input::Builder {
        crate::input::create_rule_input::Builder::default()
    }
    /// Creates a new `CreateRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRule {
    type Output =
        std::result::Result<crate::output::CreateRuleOutput, crate::error::CreateRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rule_error(response)
        } else {
            crate::operation_deser::parse_create_rule_response(response)
        }
    }
}

/// Operation shape for `CreateRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_rule_group`](crate::client::Client::create_rule_group).
///
/// See [`crate::client::fluent_builders::CreateRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRuleGroup {
    _private: (),
}
impl CreateRuleGroup {
    /// Creates a new builder-style object to manufacture [`CreateRuleGroupInput`](crate::input::CreateRuleGroupInput)
    pub fn builder() -> crate::input::create_rule_group_input::Builder {
        crate::input::create_rule_group_input::Builder::default()
    }
    /// Creates a new `CreateRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRuleGroup {
    type Output = std::result::Result<
        crate::output::CreateRuleGroupOutput,
        crate::error::CreateRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_rule_group_error(response)
        } else {
            crate::operation_deser::parse_create_rule_group_response(response)
        }
    }
}

/// Operation shape for `CreateSizeConstraintSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_size_constraint_set`](crate::client::Client::create_size_constraint_set).
///
/// See [`crate::client::fluent_builders::CreateSizeConstraintSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSizeConstraintSet {
    _private: (),
}
impl CreateSizeConstraintSet {
    /// Creates a new builder-style object to manufacture [`CreateSizeConstraintSetInput`](crate::input::CreateSizeConstraintSetInput)
    pub fn builder() -> crate::input::create_size_constraint_set_input::Builder {
        crate::input::create_size_constraint_set_input::Builder::default()
    }
    /// Creates a new `CreateSizeConstraintSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSizeConstraintSet {
    type Output = std::result::Result<
        crate::output::CreateSizeConstraintSetOutput,
        crate::error::CreateSizeConstraintSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_size_constraint_set_error(response)
        } else {
            crate::operation_deser::parse_create_size_constraint_set_response(response)
        }
    }
}

/// Operation shape for `CreateSqlInjectionMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sql_injection_match_set`](crate::client::Client::create_sql_injection_match_set).
///
/// See [`crate::client::fluent_builders::CreateSqlInjectionMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSqlInjectionMatchSet {
    _private: (),
}
impl CreateSqlInjectionMatchSet {
    /// Creates a new builder-style object to manufacture [`CreateSqlInjectionMatchSetInput`](crate::input::CreateSqlInjectionMatchSetInput)
    pub fn builder() -> crate::input::create_sql_injection_match_set_input::Builder {
        crate::input::create_sql_injection_match_set_input::Builder::default()
    }
    /// Creates a new `CreateSqlInjectionMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSqlInjectionMatchSet {
    type Output = std::result::Result<
        crate::output::CreateSqlInjectionMatchSetOutput,
        crate::error::CreateSqlInjectionMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_sql_injection_match_set_error(response)
        } else {
            crate::operation_deser::parse_create_sql_injection_match_set_response(response)
        }
    }
}

/// Operation shape for `CreateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_web_acl`](crate::client::Client::create_web_acl).
///
/// See [`crate::client::fluent_builders::CreateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWebACL {
    _private: (),
}
impl CreateWebACL {
    /// Creates a new builder-style object to manufacture [`CreateWebAclInput`](crate::input::CreateWebAclInput)
    pub fn builder() -> crate::input::create_web_acl_input::Builder {
        crate::input::create_web_acl_input::Builder::default()
    }
    /// Creates a new `CreateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWebACL {
    type Output =
        std::result::Result<crate::output::CreateWebAclOutput, crate::error::CreateWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_web_acl_error(response)
        } else {
            crate::operation_deser::parse_create_web_acl_response(response)
        }
    }
}

/// Operation shape for `CreateWebACLMigrationStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_web_acl_migration_stack`](crate::client::Client::create_web_acl_migration_stack).
///
/// See [`crate::client::fluent_builders::CreateWebACLMigrationStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWebACLMigrationStack {
    _private: (),
}
impl CreateWebACLMigrationStack {
    /// Creates a new builder-style object to manufacture [`CreateWebAclMigrationStackInput`](crate::input::CreateWebAclMigrationStackInput)
    pub fn builder() -> crate::input::create_web_acl_migration_stack_input::Builder {
        crate::input::create_web_acl_migration_stack_input::Builder::default()
    }
    /// Creates a new `CreateWebACLMigrationStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWebACLMigrationStack {
    type Output = std::result::Result<
        crate::output::CreateWebAclMigrationStackOutput,
        crate::error::CreateWebACLMigrationStackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_web_acl_migration_stack_error(response)
        } else {
            crate::operation_deser::parse_create_web_acl_migration_stack_response(response)
        }
    }
}

/// Operation shape for `CreateXssMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_xss_match_set`](crate::client::Client::create_xss_match_set).
///
/// See [`crate::client::fluent_builders::CreateXssMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateXssMatchSet {
    _private: (),
}
impl CreateXssMatchSet {
    /// Creates a new builder-style object to manufacture [`CreateXssMatchSetInput`](crate::input::CreateXssMatchSetInput)
    pub fn builder() -> crate::input::create_xss_match_set_input::Builder {
        crate::input::create_xss_match_set_input::Builder::default()
    }
    /// Creates a new `CreateXssMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateXssMatchSet {
    type Output = std::result::Result<
        crate::output::CreateXssMatchSetOutput,
        crate::error::CreateXssMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_xss_match_set_error(response)
        } else {
            crate::operation_deser::parse_create_xss_match_set_response(response)
        }
    }
}

/// Operation shape for `DeleteByteMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_byte_match_set`](crate::client::Client::delete_byte_match_set).
///
/// See [`crate::client::fluent_builders::DeleteByteMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteByteMatchSet {
    _private: (),
}
impl DeleteByteMatchSet {
    /// Creates a new builder-style object to manufacture [`DeleteByteMatchSetInput`](crate::input::DeleteByteMatchSetInput)
    pub fn builder() -> crate::input::delete_byte_match_set_input::Builder {
        crate::input::delete_byte_match_set_input::Builder::default()
    }
    /// Creates a new `DeleteByteMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteByteMatchSet {
    type Output = std::result::Result<
        crate::output::DeleteByteMatchSetOutput,
        crate::error::DeleteByteMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_byte_match_set_error(response)
        } else {
            crate::operation_deser::parse_delete_byte_match_set_response(response)
        }
    }
}

/// Operation shape for `DeleteGeoMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_geo_match_set`](crate::client::Client::delete_geo_match_set).
///
/// See [`crate::client::fluent_builders::DeleteGeoMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGeoMatchSet {
    _private: (),
}
impl DeleteGeoMatchSet {
    /// Creates a new builder-style object to manufacture [`DeleteGeoMatchSetInput`](crate::input::DeleteGeoMatchSetInput)
    pub fn builder() -> crate::input::delete_geo_match_set_input::Builder {
        crate::input::delete_geo_match_set_input::Builder::default()
    }
    /// Creates a new `DeleteGeoMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGeoMatchSet {
    type Output = std::result::Result<
        crate::output::DeleteGeoMatchSetOutput,
        crate::error::DeleteGeoMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_geo_match_set_error(response)
        } else {
            crate::operation_deser::parse_delete_geo_match_set_response(response)
        }
    }
}

/// Operation shape for `DeleteIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ip_set`](crate::client::Client::delete_ip_set).
///
/// See [`crate::client::fluent_builders::DeleteIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIPSet {
    _private: (),
}
impl DeleteIPSet {
    /// Creates a new builder-style object to manufacture [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
    pub fn builder() -> crate::input::delete_ip_set_input::Builder {
        crate::input::delete_ip_set_input::Builder::default()
    }
    /// Creates a new `DeleteIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIPSet {
    type Output =
        std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ip_set_error(response)
        } else {
            crate::operation_deser::parse_delete_ip_set_response(response)
        }
    }
}

/// Operation shape for `DeleteLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_logging_configuration`](crate::client::Client::delete_logging_configuration).
///
/// See [`crate::client::fluent_builders::DeleteLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoggingConfiguration {
    _private: (),
}
impl DeleteLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteLoggingConfigurationInput`](crate::input::DeleteLoggingConfigurationInput)
    pub fn builder() -> crate::input::delete_logging_configuration_input::Builder {
        crate::input::delete_logging_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteLoggingConfigurationOutput,
        crate::error::DeleteLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `DeletePermissionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_permission_policy`](crate::client::Client::delete_permission_policy).
///
/// See [`crate::client::fluent_builders::DeletePermissionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePermissionPolicy {
    _private: (),
}
impl DeletePermissionPolicy {
    /// Creates a new builder-style object to manufacture [`DeletePermissionPolicyInput`](crate::input::DeletePermissionPolicyInput)
    pub fn builder() -> crate::input::delete_permission_policy_input::Builder {
        crate::input::delete_permission_policy_input::Builder::default()
    }
    /// Creates a new `DeletePermissionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePermissionPolicy {
    type Output = std::result::Result<
        crate::output::DeletePermissionPolicyOutput,
        crate::error::DeletePermissionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_permission_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_permission_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteRateBasedRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rate_based_rule`](crate::client::Client::delete_rate_based_rule).
///
/// See [`crate::client::fluent_builders::DeleteRateBasedRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRateBasedRule {
    _private: (),
}
impl DeleteRateBasedRule {
    /// Creates a new builder-style object to manufacture [`DeleteRateBasedRuleInput`](crate::input::DeleteRateBasedRuleInput)
    pub fn builder() -> crate::input::delete_rate_based_rule_input::Builder {
        crate::input::delete_rate_based_rule_input::Builder::default()
    }
    /// Creates a new `DeleteRateBasedRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRateBasedRule {
    type Output = std::result::Result<
        crate::output::DeleteRateBasedRuleOutput,
        crate::error::DeleteRateBasedRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rate_based_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_rate_based_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteRegexMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_regex_match_set`](crate::client::Client::delete_regex_match_set).
///
/// See [`crate::client::fluent_builders::DeleteRegexMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegexMatchSet {
    _private: (),
}
impl DeleteRegexMatchSet {
    /// Creates a new builder-style object to manufacture [`DeleteRegexMatchSetInput`](crate::input::DeleteRegexMatchSetInput)
    pub fn builder() -> crate::input::delete_regex_match_set_input::Builder {
        crate::input::delete_regex_match_set_input::Builder::default()
    }
    /// Creates a new `DeleteRegexMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegexMatchSet {
    type Output = std::result::Result<
        crate::output::DeleteRegexMatchSetOutput,
        crate::error::DeleteRegexMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_regex_match_set_error(response)
        } else {
            crate::operation_deser::parse_delete_regex_match_set_response(response)
        }
    }
}

/// Operation shape for `DeleteRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_regex_pattern_set`](crate::client::Client::delete_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::DeleteRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegexPatternSet {
    _private: (),
}
impl DeleteRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`DeleteRegexPatternSetInput`](crate::input::DeleteRegexPatternSetInput)
    pub fn builder() -> crate::input::delete_regex_pattern_set_input::Builder {
        crate::input::delete_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `DeleteRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegexPatternSet {
    type Output = std::result::Result<
        crate::output::DeleteRegexPatternSetOutput,
        crate::error::DeleteRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_delete_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `DeleteRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule`](crate::client::Client::delete_rule).
///
/// See [`crate::client::fluent_builders::DeleteRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRule {
    _private: (),
}
impl DeleteRule {
    /// Creates a new builder-style object to manufacture [`DeleteRuleInput`](crate::input::DeleteRuleInput)
    pub fn builder() -> crate::input::delete_rule_input::Builder {
        crate::input::delete_rule_input::Builder::default()
    }
    /// Creates a new `DeleteRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRule {
    type Output =
        std::result::Result<crate::output::DeleteRuleOutput, crate::error::DeleteRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_rule_group`](crate::client::Client::delete_rule_group).
///
/// See [`crate::client::fluent_builders::DeleteRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRuleGroup {
    _private: (),
}
impl DeleteRuleGroup {
    /// Creates a new builder-style object to manufacture [`DeleteRuleGroupInput`](crate::input::DeleteRuleGroupInput)
    pub fn builder() -> crate::input::delete_rule_group_input::Builder {
        crate::input::delete_rule_group_input::Builder::default()
    }
    /// Creates a new `DeleteRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRuleGroup {
    type Output = std::result::Result<
        crate::output::DeleteRuleGroupOutput,
        crate::error::DeleteRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_rule_group_error(response)
        } else {
            crate::operation_deser::parse_delete_rule_group_response(response)
        }
    }
}

/// Operation shape for `DeleteSizeConstraintSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_size_constraint_set`](crate::client::Client::delete_size_constraint_set).
///
/// See [`crate::client::fluent_builders::DeleteSizeConstraintSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSizeConstraintSet {
    _private: (),
}
impl DeleteSizeConstraintSet {
    /// Creates a new builder-style object to manufacture [`DeleteSizeConstraintSetInput`](crate::input::DeleteSizeConstraintSetInput)
    pub fn builder() -> crate::input::delete_size_constraint_set_input::Builder {
        crate::input::delete_size_constraint_set_input::Builder::default()
    }
    /// Creates a new `DeleteSizeConstraintSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSizeConstraintSet {
    type Output = std::result::Result<
        crate::output::DeleteSizeConstraintSetOutput,
        crate::error::DeleteSizeConstraintSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_size_constraint_set_error(response)
        } else {
            crate::operation_deser::parse_delete_size_constraint_set_response(response)
        }
    }
}

/// Operation shape for `DeleteSqlInjectionMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_sql_injection_match_set`](crate::client::Client::delete_sql_injection_match_set).
///
/// See [`crate::client::fluent_builders::DeleteSqlInjectionMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSqlInjectionMatchSet {
    _private: (),
}
impl DeleteSqlInjectionMatchSet {
    /// Creates a new builder-style object to manufacture [`DeleteSqlInjectionMatchSetInput`](crate::input::DeleteSqlInjectionMatchSetInput)
    pub fn builder() -> crate::input::delete_sql_injection_match_set_input::Builder {
        crate::input::delete_sql_injection_match_set_input::Builder::default()
    }
    /// Creates a new `DeleteSqlInjectionMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSqlInjectionMatchSet {
    type Output = std::result::Result<
        crate::output::DeleteSqlInjectionMatchSetOutput,
        crate::error::DeleteSqlInjectionMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_sql_injection_match_set_error(response)
        } else {
            crate::operation_deser::parse_delete_sql_injection_match_set_response(response)
        }
    }
}

/// Operation shape for `DeleteWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_web_acl`](crate::client::Client::delete_web_acl).
///
/// See [`crate::client::fluent_builders::DeleteWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWebACL {
    _private: (),
}
impl DeleteWebACL {
    /// Creates a new builder-style object to manufacture [`DeleteWebAclInput`](crate::input::DeleteWebAclInput)
    pub fn builder() -> crate::input::delete_web_acl_input::Builder {
        crate::input::delete_web_acl_input::Builder::default()
    }
    /// Creates a new `DeleteWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWebACL {
    type Output =
        std::result::Result<crate::output::DeleteWebAclOutput, crate::error::DeleteWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_web_acl_error(response)
        } else {
            crate::operation_deser::parse_delete_web_acl_response(response)
        }
    }
}

/// Operation shape for `DeleteXssMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_xss_match_set`](crate::client::Client::delete_xss_match_set).
///
/// See [`crate::client::fluent_builders::DeleteXssMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteXssMatchSet {
    _private: (),
}
impl DeleteXssMatchSet {
    /// Creates a new builder-style object to manufacture [`DeleteXssMatchSetInput`](crate::input::DeleteXssMatchSetInput)
    pub fn builder() -> crate::input::delete_xss_match_set_input::Builder {
        crate::input::delete_xss_match_set_input::Builder::default()
    }
    /// Creates a new `DeleteXssMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteXssMatchSet {
    type Output = std::result::Result<
        crate::output::DeleteXssMatchSetOutput,
        crate::error::DeleteXssMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_xss_match_set_error(response)
        } else {
            crate::operation_deser::parse_delete_xss_match_set_response(response)
        }
    }
}

/// Operation shape for `DisassociateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_web_acl`](crate::client::Client::disassociate_web_acl).
///
/// See [`crate::client::fluent_builders::DisassociateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateWebACL {
    _private: (),
}
impl DisassociateWebACL {
    /// Creates a new builder-style object to manufacture [`DisassociateWebAclInput`](crate::input::DisassociateWebAclInput)
    pub fn builder() -> crate::input::disassociate_web_acl_input::Builder {
        crate::input::disassociate_web_acl_input::Builder::default()
    }
    /// Creates a new `DisassociateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateWebACL {
    type Output = std::result::Result<
        crate::output::DisassociateWebAclOutput,
        crate::error::DisassociateWebACLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_web_acl_error(response)
        } else {
            crate::operation_deser::parse_disassociate_web_acl_response(response)
        }
    }
}

/// Operation shape for `GetByteMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_byte_match_set`](crate::client::Client::get_byte_match_set).
///
/// See [`crate::client::fluent_builders::GetByteMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetByteMatchSet {
    _private: (),
}
impl GetByteMatchSet {
    /// Creates a new builder-style object to manufacture [`GetByteMatchSetInput`](crate::input::GetByteMatchSetInput)
    pub fn builder() -> crate::input::get_byte_match_set_input::Builder {
        crate::input::get_byte_match_set_input::Builder::default()
    }
    /// Creates a new `GetByteMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetByteMatchSet {
    type Output = std::result::Result<
        crate::output::GetByteMatchSetOutput,
        crate::error::GetByteMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_byte_match_set_error(response)
        } else {
            crate::operation_deser::parse_get_byte_match_set_response(response)
        }
    }
}

/// Operation shape for `GetChangeToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_change_token`](crate::client::Client::get_change_token).
///
/// See [`crate::client::fluent_builders::GetChangeToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChangeToken {
    _private: (),
}
impl GetChangeToken {
    /// Creates a new builder-style object to manufacture [`GetChangeTokenInput`](crate::input::GetChangeTokenInput)
    pub fn builder() -> crate::input::get_change_token_input::Builder {
        crate::input::get_change_token_input::Builder::default()
    }
    /// Creates a new `GetChangeToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChangeToken {
    type Output =
        std::result::Result<crate::output::GetChangeTokenOutput, crate::error::GetChangeTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_change_token_error(response)
        } else {
            crate::operation_deser::parse_get_change_token_response(response)
        }
    }
}

/// Operation shape for `GetChangeTokenStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_change_token_status`](crate::client::Client::get_change_token_status).
///
/// See [`crate::client::fluent_builders::GetChangeTokenStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChangeTokenStatus {
    _private: (),
}
impl GetChangeTokenStatus {
    /// Creates a new builder-style object to manufacture [`GetChangeTokenStatusInput`](crate::input::GetChangeTokenStatusInput)
    pub fn builder() -> crate::input::get_change_token_status_input::Builder {
        crate::input::get_change_token_status_input::Builder::default()
    }
    /// Creates a new `GetChangeTokenStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChangeTokenStatus {
    type Output = std::result::Result<
        crate::output::GetChangeTokenStatusOutput,
        crate::error::GetChangeTokenStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_change_token_status_error(response)
        } else {
            crate::operation_deser::parse_get_change_token_status_response(response)
        }
    }
}

/// Operation shape for `GetGeoMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_geo_match_set`](crate::client::Client::get_geo_match_set).
///
/// See [`crate::client::fluent_builders::GetGeoMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGeoMatchSet {
    _private: (),
}
impl GetGeoMatchSet {
    /// Creates a new builder-style object to manufacture [`GetGeoMatchSetInput`](crate::input::GetGeoMatchSetInput)
    pub fn builder() -> crate::input::get_geo_match_set_input::Builder {
        crate::input::get_geo_match_set_input::Builder::default()
    }
    /// Creates a new `GetGeoMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGeoMatchSet {
    type Output =
        std::result::Result<crate::output::GetGeoMatchSetOutput, crate::error::GetGeoMatchSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_geo_match_set_error(response)
        } else {
            crate::operation_deser::parse_get_geo_match_set_response(response)
        }
    }
}

/// Operation shape for `GetIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ip_set`](crate::client::Client::get_ip_set).
///
/// See [`crate::client::fluent_builders::GetIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIPSet {
    _private: (),
}
impl GetIPSet {
    /// Creates a new builder-style object to manufacture [`GetIpSetInput`](crate::input::GetIpSetInput)
    pub fn builder() -> crate::input::get_ip_set_input::Builder {
        crate::input::get_ip_set_input::Builder::default()
    }
    /// Creates a new `GetIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIPSet {
    type Output = std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ip_set_error(response)
        } else {
            crate::operation_deser::parse_get_ip_set_response(response)
        }
    }
}

/// Operation shape for `GetLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_logging_configuration`](crate::client::Client::get_logging_configuration).
///
/// See [`crate::client::fluent_builders::GetLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoggingConfiguration {
    _private: (),
}
impl GetLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`GetLoggingConfigurationInput`](crate::input::GetLoggingConfigurationInput)
    pub fn builder() -> crate::input::get_logging_configuration_input::Builder {
        crate::input::get_logging_configuration_input::Builder::default()
    }
    /// Creates a new `GetLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::GetLoggingConfigurationOutput,
        crate::error::GetLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `GetPermissionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_permission_policy`](crate::client::Client::get_permission_policy).
///
/// See [`crate::client::fluent_builders::GetPermissionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPermissionPolicy {
    _private: (),
}
impl GetPermissionPolicy {
    /// Creates a new builder-style object to manufacture [`GetPermissionPolicyInput`](crate::input::GetPermissionPolicyInput)
    pub fn builder() -> crate::input::get_permission_policy_input::Builder {
        crate::input::get_permission_policy_input::Builder::default()
    }
    /// Creates a new `GetPermissionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPermissionPolicy {
    type Output = std::result::Result<
        crate::output::GetPermissionPolicyOutput,
        crate::error::GetPermissionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_permission_policy_error(response)
        } else {
            crate::operation_deser::parse_get_permission_policy_response(response)
        }
    }
}

/// Operation shape for `GetRateBasedRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rate_based_rule`](crate::client::Client::get_rate_based_rule).
///
/// See [`crate::client::fluent_builders::GetRateBasedRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRateBasedRule {
    _private: (),
}
impl GetRateBasedRule {
    /// Creates a new builder-style object to manufacture [`GetRateBasedRuleInput`](crate::input::GetRateBasedRuleInput)
    pub fn builder() -> crate::input::get_rate_based_rule_input::Builder {
        crate::input::get_rate_based_rule_input::Builder::default()
    }
    /// Creates a new `GetRateBasedRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRateBasedRule {
    type Output = std::result::Result<
        crate::output::GetRateBasedRuleOutput,
        crate::error::GetRateBasedRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rate_based_rule_error(response)
        } else {
            crate::operation_deser::parse_get_rate_based_rule_response(response)
        }
    }
}

/// Operation shape for `GetRateBasedRuleManagedKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rate_based_rule_managed_keys`](crate::client::Client::get_rate_based_rule_managed_keys).
///
/// See [`crate::client::fluent_builders::GetRateBasedRuleManagedKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRateBasedRuleManagedKeys {
    _private: (),
}
impl GetRateBasedRuleManagedKeys {
    /// Creates a new builder-style object to manufacture [`GetRateBasedRuleManagedKeysInput`](crate::input::GetRateBasedRuleManagedKeysInput)
    pub fn builder() -> crate::input::get_rate_based_rule_managed_keys_input::Builder {
        crate::input::get_rate_based_rule_managed_keys_input::Builder::default()
    }
    /// Creates a new `GetRateBasedRuleManagedKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRateBasedRuleManagedKeys {
    type Output = std::result::Result<
        crate::output::GetRateBasedRuleManagedKeysOutput,
        crate::error::GetRateBasedRuleManagedKeysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rate_based_rule_managed_keys_error(response)
        } else {
            crate::operation_deser::parse_get_rate_based_rule_managed_keys_response(response)
        }
    }
}

/// Operation shape for `GetRegexMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_regex_match_set`](crate::client::Client::get_regex_match_set).
///
/// See [`crate::client::fluent_builders::GetRegexMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegexMatchSet {
    _private: (),
}
impl GetRegexMatchSet {
    /// Creates a new builder-style object to manufacture [`GetRegexMatchSetInput`](crate::input::GetRegexMatchSetInput)
    pub fn builder() -> crate::input::get_regex_match_set_input::Builder {
        crate::input::get_regex_match_set_input::Builder::default()
    }
    /// Creates a new `GetRegexMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegexMatchSet {
    type Output = std::result::Result<
        crate::output::GetRegexMatchSetOutput,
        crate::error::GetRegexMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_regex_match_set_error(response)
        } else {
            crate::operation_deser::parse_get_regex_match_set_response(response)
        }
    }
}

/// Operation shape for `GetRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_regex_pattern_set`](crate::client::Client::get_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::GetRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegexPatternSet {
    _private: (),
}
impl GetRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`GetRegexPatternSetInput`](crate::input::GetRegexPatternSetInput)
    pub fn builder() -> crate::input::get_regex_pattern_set_input::Builder {
        crate::input::get_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `GetRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegexPatternSet {
    type Output = std::result::Result<
        crate::output::GetRegexPatternSetOutput,
        crate::error::GetRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_get_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `GetRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rule`](crate::client::Client::get_rule).
///
/// See [`crate::client::fluent_builders::GetRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRule {
    _private: (),
}
impl GetRule {
    /// Creates a new builder-style object to manufacture [`GetRuleInput`](crate::input::GetRuleInput)
    pub fn builder() -> crate::input::get_rule_input::Builder {
        crate::input::get_rule_input::Builder::default()
    }
    /// Creates a new `GetRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRule {
    type Output = std::result::Result<crate::output::GetRuleOutput, crate::error::GetRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rule_error(response)
        } else {
            crate::operation_deser::parse_get_rule_response(response)
        }
    }
}

/// Operation shape for `GetRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rule_group`](crate::client::Client::get_rule_group).
///
/// See [`crate::client::fluent_builders::GetRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRuleGroup {
    _private: (),
}
impl GetRuleGroup {
    /// Creates a new builder-style object to manufacture [`GetRuleGroupInput`](crate::input::GetRuleGroupInput)
    pub fn builder() -> crate::input::get_rule_group_input::Builder {
        crate::input::get_rule_group_input::Builder::default()
    }
    /// Creates a new `GetRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRuleGroup {
    type Output =
        std::result::Result<crate::output::GetRuleGroupOutput, crate::error::GetRuleGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rule_group_error(response)
        } else {
            crate::operation_deser::parse_get_rule_group_response(response)
        }
    }
}

/// Operation shape for `GetSampledRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sampled_requests`](crate::client::Client::get_sampled_requests).
///
/// See [`crate::client::fluent_builders::GetSampledRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSampledRequests {
    _private: (),
}
impl GetSampledRequests {
    /// Creates a new builder-style object to manufacture [`GetSampledRequestsInput`](crate::input::GetSampledRequestsInput)
    pub fn builder() -> crate::input::get_sampled_requests_input::Builder {
        crate::input::get_sampled_requests_input::Builder::default()
    }
    /// Creates a new `GetSampledRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSampledRequests {
    type Output = std::result::Result<
        crate::output::GetSampledRequestsOutput,
        crate::error::GetSampledRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sampled_requests_error(response)
        } else {
            crate::operation_deser::parse_get_sampled_requests_response(response)
        }
    }
}

/// Operation shape for `GetSizeConstraintSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_size_constraint_set`](crate::client::Client::get_size_constraint_set).
///
/// See [`crate::client::fluent_builders::GetSizeConstraintSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSizeConstraintSet {
    _private: (),
}
impl GetSizeConstraintSet {
    /// Creates a new builder-style object to manufacture [`GetSizeConstraintSetInput`](crate::input::GetSizeConstraintSetInput)
    pub fn builder() -> crate::input::get_size_constraint_set_input::Builder {
        crate::input::get_size_constraint_set_input::Builder::default()
    }
    /// Creates a new `GetSizeConstraintSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSizeConstraintSet {
    type Output = std::result::Result<
        crate::output::GetSizeConstraintSetOutput,
        crate::error::GetSizeConstraintSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_size_constraint_set_error(response)
        } else {
            crate::operation_deser::parse_get_size_constraint_set_response(response)
        }
    }
}

/// Operation shape for `GetSqlInjectionMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sql_injection_match_set`](crate::client::Client::get_sql_injection_match_set).
///
/// See [`crate::client::fluent_builders::GetSqlInjectionMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSqlInjectionMatchSet {
    _private: (),
}
impl GetSqlInjectionMatchSet {
    /// Creates a new builder-style object to manufacture [`GetSqlInjectionMatchSetInput`](crate::input::GetSqlInjectionMatchSetInput)
    pub fn builder() -> crate::input::get_sql_injection_match_set_input::Builder {
        crate::input::get_sql_injection_match_set_input::Builder::default()
    }
    /// Creates a new `GetSqlInjectionMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSqlInjectionMatchSet {
    type Output = std::result::Result<
        crate::output::GetSqlInjectionMatchSetOutput,
        crate::error::GetSqlInjectionMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sql_injection_match_set_error(response)
        } else {
            crate::operation_deser::parse_get_sql_injection_match_set_response(response)
        }
    }
}

/// Operation shape for `GetWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_web_acl`](crate::client::Client::get_web_acl).
///
/// See [`crate::client::fluent_builders::GetWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWebACL {
    _private: (),
}
impl GetWebACL {
    /// Creates a new builder-style object to manufacture [`GetWebAclInput`](crate::input::GetWebAclInput)
    pub fn builder() -> crate::input::get_web_acl_input::Builder {
        crate::input::get_web_acl_input::Builder::default()
    }
    /// Creates a new `GetWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWebACL {
    type Output = std::result::Result<crate::output::GetWebAclOutput, crate::error::GetWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_web_acl_error(response)
        } else {
            crate::operation_deser::parse_get_web_acl_response(response)
        }
    }
}

/// Operation shape for `GetWebACLForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_web_acl_for_resource`](crate::client::Client::get_web_acl_for_resource).
///
/// See [`crate::client::fluent_builders::GetWebACLForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWebACLForResource {
    _private: (),
}
impl GetWebACLForResource {
    /// Creates a new builder-style object to manufacture [`GetWebAclForResourceInput`](crate::input::GetWebAclForResourceInput)
    pub fn builder() -> crate::input::get_web_acl_for_resource_input::Builder {
        crate::input::get_web_acl_for_resource_input::Builder::default()
    }
    /// Creates a new `GetWebACLForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWebACLForResource {
    type Output = std::result::Result<
        crate::output::GetWebAclForResourceOutput,
        crate::error::GetWebACLForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_web_acl_for_resource_error(response)
        } else {
            crate::operation_deser::parse_get_web_acl_for_resource_response(response)
        }
    }
}

/// Operation shape for `GetXssMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_xss_match_set`](crate::client::Client::get_xss_match_set).
///
/// See [`crate::client::fluent_builders::GetXssMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetXssMatchSet {
    _private: (),
}
impl GetXssMatchSet {
    /// Creates a new builder-style object to manufacture [`GetXssMatchSetInput`](crate::input::GetXssMatchSetInput)
    pub fn builder() -> crate::input::get_xss_match_set_input::Builder {
        crate::input::get_xss_match_set_input::Builder::default()
    }
    /// Creates a new `GetXssMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetXssMatchSet {
    type Output =
        std::result::Result<crate::output::GetXssMatchSetOutput, crate::error::GetXssMatchSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_xss_match_set_error(response)
        } else {
            crate::operation_deser::parse_get_xss_match_set_response(response)
        }
    }
}

/// Operation shape for `ListActivatedRulesInRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_activated_rules_in_rule_group`](crate::client::Client::list_activated_rules_in_rule_group).
///
/// See [`crate::client::fluent_builders::ListActivatedRulesInRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActivatedRulesInRuleGroup {
    _private: (),
}
impl ListActivatedRulesInRuleGroup {
    /// Creates a new builder-style object to manufacture [`ListActivatedRulesInRuleGroupInput`](crate::input::ListActivatedRulesInRuleGroupInput)
    pub fn builder() -> crate::input::list_activated_rules_in_rule_group_input::Builder {
        crate::input::list_activated_rules_in_rule_group_input::Builder::default()
    }
    /// Creates a new `ListActivatedRulesInRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActivatedRulesInRuleGroup {
    type Output = std::result::Result<
        crate::output::ListActivatedRulesInRuleGroupOutput,
        crate::error::ListActivatedRulesInRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_activated_rules_in_rule_group_error(response)
        } else {
            crate::operation_deser::parse_list_activated_rules_in_rule_group_response(response)
        }
    }
}

/// Operation shape for `ListByteMatchSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_byte_match_sets`](crate::client::Client::list_byte_match_sets).
///
/// See [`crate::client::fluent_builders::ListByteMatchSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListByteMatchSets {
    _private: (),
}
impl ListByteMatchSets {
    /// Creates a new builder-style object to manufacture [`ListByteMatchSetsInput`](crate::input::ListByteMatchSetsInput)
    pub fn builder() -> crate::input::list_byte_match_sets_input::Builder {
        crate::input::list_byte_match_sets_input::Builder::default()
    }
    /// Creates a new `ListByteMatchSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListByteMatchSets {
    type Output = std::result::Result<
        crate::output::ListByteMatchSetsOutput,
        crate::error::ListByteMatchSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_byte_match_sets_error(response)
        } else {
            crate::operation_deser::parse_list_byte_match_sets_response(response)
        }
    }
}

/// Operation shape for `ListGeoMatchSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_geo_match_sets`](crate::client::Client::list_geo_match_sets).
///
/// See [`crate::client::fluent_builders::ListGeoMatchSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGeoMatchSets {
    _private: (),
}
impl ListGeoMatchSets {
    /// Creates a new builder-style object to manufacture [`ListGeoMatchSetsInput`](crate::input::ListGeoMatchSetsInput)
    pub fn builder() -> crate::input::list_geo_match_sets_input::Builder {
        crate::input::list_geo_match_sets_input::Builder::default()
    }
    /// Creates a new `ListGeoMatchSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGeoMatchSets {
    type Output = std::result::Result<
        crate::output::ListGeoMatchSetsOutput,
        crate::error::ListGeoMatchSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_geo_match_sets_error(response)
        } else {
            crate::operation_deser::parse_list_geo_match_sets_response(response)
        }
    }
}

/// Operation shape for `ListIPSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ip_sets`](crate::client::Client::list_ip_sets).
///
/// See [`crate::client::fluent_builders::ListIPSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIPSets {
    _private: (),
}
impl ListIPSets {
    /// Creates a new builder-style object to manufacture [`ListIpSetsInput`](crate::input::ListIpSetsInput)
    pub fn builder() -> crate::input::list_ip_sets_input::Builder {
        crate::input::list_ip_sets_input::Builder::default()
    }
    /// Creates a new `ListIPSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIPSets {
    type Output =
        std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ip_sets_error(response)
        } else {
            crate::operation_deser::parse_list_ip_sets_response(response)
        }
    }
}

/// Operation shape for `ListLoggingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_logging_configurations`](crate::client::Client::list_logging_configurations).
///
/// See [`crate::client::fluent_builders::ListLoggingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLoggingConfigurations {
    _private: (),
}
impl ListLoggingConfigurations {
    /// Creates a new builder-style object to manufacture [`ListLoggingConfigurationsInput`](crate::input::ListLoggingConfigurationsInput)
    pub fn builder() -> crate::input::list_logging_configurations_input::Builder {
        crate::input::list_logging_configurations_input::Builder::default()
    }
    /// Creates a new `ListLoggingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLoggingConfigurations {
    type Output = std::result::Result<
        crate::output::ListLoggingConfigurationsOutput,
        crate::error::ListLoggingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_logging_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_logging_configurations_response(response)
        }
    }
}

/// Operation shape for `ListRateBasedRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rate_based_rules`](crate::client::Client::list_rate_based_rules).
///
/// See [`crate::client::fluent_builders::ListRateBasedRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRateBasedRules {
    _private: (),
}
impl ListRateBasedRules {
    /// Creates a new builder-style object to manufacture [`ListRateBasedRulesInput`](crate::input::ListRateBasedRulesInput)
    pub fn builder() -> crate::input::list_rate_based_rules_input::Builder {
        crate::input::list_rate_based_rules_input::Builder::default()
    }
    /// Creates a new `ListRateBasedRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRateBasedRules {
    type Output = std::result::Result<
        crate::output::ListRateBasedRulesOutput,
        crate::error::ListRateBasedRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rate_based_rules_error(response)
        } else {
            crate::operation_deser::parse_list_rate_based_rules_response(response)
        }
    }
}

/// Operation shape for `ListRegexMatchSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_regex_match_sets`](crate::client::Client::list_regex_match_sets).
///
/// See [`crate::client::fluent_builders::ListRegexMatchSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRegexMatchSets {
    _private: (),
}
impl ListRegexMatchSets {
    /// Creates a new builder-style object to manufacture [`ListRegexMatchSetsInput`](crate::input::ListRegexMatchSetsInput)
    pub fn builder() -> crate::input::list_regex_match_sets_input::Builder {
        crate::input::list_regex_match_sets_input::Builder::default()
    }
    /// Creates a new `ListRegexMatchSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRegexMatchSets {
    type Output = std::result::Result<
        crate::output::ListRegexMatchSetsOutput,
        crate::error::ListRegexMatchSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_regex_match_sets_error(response)
        } else {
            crate::operation_deser::parse_list_regex_match_sets_response(response)
        }
    }
}

/// Operation shape for `ListRegexPatternSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_regex_pattern_sets`](crate::client::Client::list_regex_pattern_sets).
///
/// See [`crate::client::fluent_builders::ListRegexPatternSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRegexPatternSets {
    _private: (),
}
impl ListRegexPatternSets {
    /// Creates a new builder-style object to manufacture [`ListRegexPatternSetsInput`](crate::input::ListRegexPatternSetsInput)
    pub fn builder() -> crate::input::list_regex_pattern_sets_input::Builder {
        crate::input::list_regex_pattern_sets_input::Builder::default()
    }
    /// Creates a new `ListRegexPatternSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRegexPatternSets {
    type Output = std::result::Result<
        crate::output::ListRegexPatternSetsOutput,
        crate::error::ListRegexPatternSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_regex_pattern_sets_error(response)
        } else {
            crate::operation_deser::parse_list_regex_pattern_sets_response(response)
        }
    }
}

/// Operation shape for `ListResourcesForWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resources_for_web_acl`](crate::client::Client::list_resources_for_web_acl).
///
/// See [`crate::client::fluent_builders::ListResourcesForWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourcesForWebACL {
    _private: (),
}
impl ListResourcesForWebACL {
    /// Creates a new builder-style object to manufacture [`ListResourcesForWebAclInput`](crate::input::ListResourcesForWebAclInput)
    pub fn builder() -> crate::input::list_resources_for_web_acl_input::Builder {
        crate::input::list_resources_for_web_acl_input::Builder::default()
    }
    /// Creates a new `ListResourcesForWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourcesForWebACL {
    type Output = std::result::Result<
        crate::output::ListResourcesForWebAclOutput,
        crate::error::ListResourcesForWebACLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resources_for_web_acl_error(response)
        } else {
            crate::operation_deser::parse_list_resources_for_web_acl_response(response)
        }
    }
}

/// Operation shape for `ListRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rule_groups`](crate::client::Client::list_rule_groups).
///
/// See [`crate::client::fluent_builders::ListRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRuleGroups {
    _private: (),
}
impl ListRuleGroups {
    /// Creates a new builder-style object to manufacture [`ListRuleGroupsInput`](crate::input::ListRuleGroupsInput)
    pub fn builder() -> crate::input::list_rule_groups_input::Builder {
        crate::input::list_rule_groups_input::Builder::default()
    }
    /// Creates a new `ListRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRuleGroups {
    type Output =
        std::result::Result<crate::output::ListRuleGroupsOutput, crate::error::ListRuleGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_list_rule_groups_response(response)
        }
    }
}

/// Operation shape for `ListRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rules`](crate::client::Client::list_rules).
///
/// See [`crate::client::fluent_builders::ListRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRules {
    _private: (),
}
impl ListRules {
    /// Creates a new builder-style object to manufacture [`ListRulesInput`](crate::input::ListRulesInput)
    pub fn builder() -> crate::input::list_rules_input::Builder {
        crate::input::list_rules_input::Builder::default()
    }
    /// Creates a new `ListRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRules {
    type Output = std::result::Result<crate::output::ListRulesOutput, crate::error::ListRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rules_error(response)
        } else {
            crate::operation_deser::parse_list_rules_response(response)
        }
    }
}

/// Operation shape for `ListSizeConstraintSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_size_constraint_sets`](crate::client::Client::list_size_constraint_sets).
///
/// See [`crate::client::fluent_builders::ListSizeConstraintSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSizeConstraintSets {
    _private: (),
}
impl ListSizeConstraintSets {
    /// Creates a new builder-style object to manufacture [`ListSizeConstraintSetsInput`](crate::input::ListSizeConstraintSetsInput)
    pub fn builder() -> crate::input::list_size_constraint_sets_input::Builder {
        crate::input::list_size_constraint_sets_input::Builder::default()
    }
    /// Creates a new `ListSizeConstraintSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSizeConstraintSets {
    type Output = std::result::Result<
        crate::output::ListSizeConstraintSetsOutput,
        crate::error::ListSizeConstraintSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_size_constraint_sets_error(response)
        } else {
            crate::operation_deser::parse_list_size_constraint_sets_response(response)
        }
    }
}

/// Operation shape for `ListSqlInjectionMatchSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sql_injection_match_sets`](crate::client::Client::list_sql_injection_match_sets).
///
/// See [`crate::client::fluent_builders::ListSqlInjectionMatchSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSqlInjectionMatchSets {
    _private: (),
}
impl ListSqlInjectionMatchSets {
    /// Creates a new builder-style object to manufacture [`ListSqlInjectionMatchSetsInput`](crate::input::ListSqlInjectionMatchSetsInput)
    pub fn builder() -> crate::input::list_sql_injection_match_sets_input::Builder {
        crate::input::list_sql_injection_match_sets_input::Builder::default()
    }
    /// Creates a new `ListSqlInjectionMatchSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSqlInjectionMatchSets {
    type Output = std::result::Result<
        crate::output::ListSqlInjectionMatchSetsOutput,
        crate::error::ListSqlInjectionMatchSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sql_injection_match_sets_error(response)
        } else {
            crate::operation_deser::parse_list_sql_injection_match_sets_response(response)
        }
    }
}

/// Operation shape for `ListSubscribedRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_subscribed_rule_groups`](crate::client::Client::list_subscribed_rule_groups).
///
/// See [`crate::client::fluent_builders::ListSubscribedRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSubscribedRuleGroups {
    _private: (),
}
impl ListSubscribedRuleGroups {
    /// Creates a new builder-style object to manufacture [`ListSubscribedRuleGroupsInput`](crate::input::ListSubscribedRuleGroupsInput)
    pub fn builder() -> crate::input::list_subscribed_rule_groups_input::Builder {
        crate::input::list_subscribed_rule_groups_input::Builder::default()
    }
    /// Creates a new `ListSubscribedRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSubscribedRuleGroups {
    type Output = std::result::Result<
        crate::output::ListSubscribedRuleGroupsOutput,
        crate::error::ListSubscribedRuleGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_subscribed_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_list_subscribed_rule_groups_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWebACLs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_web_ac_ls`](crate::client::Client::list_web_ac_ls).
///
/// See [`crate::client::fluent_builders::ListWebACLs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWebACLs {
    _private: (),
}
impl ListWebACLs {
    /// Creates a new builder-style object to manufacture [`ListWebAcLsInput`](crate::input::ListWebAcLsInput)
    pub fn builder() -> crate::input::list_web_ac_ls_input::Builder {
        crate::input::list_web_ac_ls_input::Builder::default()
    }
    /// Creates a new `ListWebACLs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWebACLs {
    type Output =
        std::result::Result<crate::output::ListWebAcLsOutput, crate::error::ListWebACLsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_web_ac_ls_error(response)
        } else {
            crate::operation_deser::parse_list_web_ac_ls_response(response)
        }
    }
}

/// Operation shape for `ListXssMatchSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_xss_match_sets`](crate::client::Client::list_xss_match_sets).
///
/// See [`crate::client::fluent_builders::ListXssMatchSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListXssMatchSets {
    _private: (),
}
impl ListXssMatchSets {
    /// Creates a new builder-style object to manufacture [`ListXssMatchSetsInput`](crate::input::ListXssMatchSetsInput)
    pub fn builder() -> crate::input::list_xss_match_sets_input::Builder {
        crate::input::list_xss_match_sets_input::Builder::default()
    }
    /// Creates a new `ListXssMatchSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListXssMatchSets {
    type Output = std::result::Result<
        crate::output::ListXssMatchSetsOutput,
        crate::error::ListXssMatchSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_xss_match_sets_error(response)
        } else {
            crate::operation_deser::parse_list_xss_match_sets_response(response)
        }
    }
}

/// Operation shape for `PutLoggingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_logging_configuration`](crate::client::Client::put_logging_configuration).
///
/// See [`crate::client::fluent_builders::PutLoggingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLoggingConfiguration {
    _private: (),
}
impl PutLoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`PutLoggingConfigurationInput`](crate::input::PutLoggingConfigurationInput)
    pub fn builder() -> crate::input::put_logging_configuration_input::Builder {
        crate::input::put_logging_configuration_input::Builder::default()
    }
    /// Creates a new `PutLoggingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLoggingConfiguration {
    type Output = std::result::Result<
        crate::output::PutLoggingConfigurationOutput,
        crate::error::PutLoggingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_logging_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_logging_configuration_response(response)
        }
    }
}

/// Operation shape for `PutPermissionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_permission_policy`](crate::client::Client::put_permission_policy).
///
/// See [`crate::client::fluent_builders::PutPermissionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPermissionPolicy {
    _private: (),
}
impl PutPermissionPolicy {
    /// Creates a new builder-style object to manufacture [`PutPermissionPolicyInput`](crate::input::PutPermissionPolicyInput)
    pub fn builder() -> crate::input::put_permission_policy_input::Builder {
        crate::input::put_permission_policy_input::Builder::default()
    }
    /// Creates a new `PutPermissionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPermissionPolicy {
    type Output = std::result::Result<
        crate::output::PutPermissionPolicyOutput,
        crate::error::PutPermissionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_permission_policy_error(response)
        } else {
            crate::operation_deser::parse_put_permission_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateByteMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_byte_match_set`](crate::client::Client::update_byte_match_set).
///
/// See [`crate::client::fluent_builders::UpdateByteMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateByteMatchSet {
    _private: (),
}
impl UpdateByteMatchSet {
    /// Creates a new builder-style object to manufacture [`UpdateByteMatchSetInput`](crate::input::UpdateByteMatchSetInput)
    pub fn builder() -> crate::input::update_byte_match_set_input::Builder {
        crate::input::update_byte_match_set_input::Builder::default()
    }
    /// Creates a new `UpdateByteMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateByteMatchSet {
    type Output = std::result::Result<
        crate::output::UpdateByteMatchSetOutput,
        crate::error::UpdateByteMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_byte_match_set_error(response)
        } else {
            crate::operation_deser::parse_update_byte_match_set_response(response)
        }
    }
}

/// Operation shape for `UpdateGeoMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_geo_match_set`](crate::client::Client::update_geo_match_set).
///
/// See [`crate::client::fluent_builders::UpdateGeoMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGeoMatchSet {
    _private: (),
}
impl UpdateGeoMatchSet {
    /// Creates a new builder-style object to manufacture [`UpdateGeoMatchSetInput`](crate::input::UpdateGeoMatchSetInput)
    pub fn builder() -> crate::input::update_geo_match_set_input::Builder {
        crate::input::update_geo_match_set_input::Builder::default()
    }
    /// Creates a new `UpdateGeoMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGeoMatchSet {
    type Output = std::result::Result<
        crate::output::UpdateGeoMatchSetOutput,
        crate::error::UpdateGeoMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_geo_match_set_error(response)
        } else {
            crate::operation_deser::parse_update_geo_match_set_response(response)
        }
    }
}

/// Operation shape for `UpdateIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ip_set`](crate::client::Client::update_ip_set).
///
/// See [`crate::client::fluent_builders::UpdateIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIPSet {
    _private: (),
}
impl UpdateIPSet {
    /// Creates a new builder-style object to manufacture [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
    pub fn builder() -> crate::input::update_ip_set_input::Builder {
        crate::input::update_ip_set_input::Builder::default()
    }
    /// Creates a new `UpdateIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIPSet {
    type Output =
        std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ip_set_error(response)
        } else {
            crate::operation_deser::parse_update_ip_set_response(response)
        }
    }
}

/// Operation shape for `UpdateRateBasedRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rate_based_rule`](crate::client::Client::update_rate_based_rule).
///
/// See [`crate::client::fluent_builders::UpdateRateBasedRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRateBasedRule {
    _private: (),
}
impl UpdateRateBasedRule {
    /// Creates a new builder-style object to manufacture [`UpdateRateBasedRuleInput`](crate::input::UpdateRateBasedRuleInput)
    pub fn builder() -> crate::input::update_rate_based_rule_input::Builder {
        crate::input::update_rate_based_rule_input::Builder::default()
    }
    /// Creates a new `UpdateRateBasedRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRateBasedRule {
    type Output = std::result::Result<
        crate::output::UpdateRateBasedRuleOutput,
        crate::error::UpdateRateBasedRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rate_based_rule_error(response)
        } else {
            crate::operation_deser::parse_update_rate_based_rule_response(response)
        }
    }
}

/// Operation shape for `UpdateRegexMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_regex_match_set`](crate::client::Client::update_regex_match_set).
///
/// See [`crate::client::fluent_builders::UpdateRegexMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRegexMatchSet {
    _private: (),
}
impl UpdateRegexMatchSet {
    /// Creates a new builder-style object to manufacture [`UpdateRegexMatchSetInput`](crate::input::UpdateRegexMatchSetInput)
    pub fn builder() -> crate::input::update_regex_match_set_input::Builder {
        crate::input::update_regex_match_set_input::Builder::default()
    }
    /// Creates a new `UpdateRegexMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRegexMatchSet {
    type Output = std::result::Result<
        crate::output::UpdateRegexMatchSetOutput,
        crate::error::UpdateRegexMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_regex_match_set_error(response)
        } else {
            crate::operation_deser::parse_update_regex_match_set_response(response)
        }
    }
}

/// Operation shape for `UpdateRegexPatternSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_regex_pattern_set`](crate::client::Client::update_regex_pattern_set).
///
/// See [`crate::client::fluent_builders::UpdateRegexPatternSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRegexPatternSet {
    _private: (),
}
impl UpdateRegexPatternSet {
    /// Creates a new builder-style object to manufacture [`UpdateRegexPatternSetInput`](crate::input::UpdateRegexPatternSetInput)
    pub fn builder() -> crate::input::update_regex_pattern_set_input::Builder {
        crate::input::update_regex_pattern_set_input::Builder::default()
    }
    /// Creates a new `UpdateRegexPatternSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRegexPatternSet {
    type Output = std::result::Result<
        crate::output::UpdateRegexPatternSetOutput,
        crate::error::UpdateRegexPatternSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_regex_pattern_set_error(response)
        } else {
            crate::operation_deser::parse_update_regex_pattern_set_response(response)
        }
    }
}

/// Operation shape for `UpdateRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rule`](crate::client::Client::update_rule).
///
/// See [`crate::client::fluent_builders::UpdateRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRule {
    _private: (),
}
impl UpdateRule {
    /// Creates a new builder-style object to manufacture [`UpdateRuleInput`](crate::input::UpdateRuleInput)
    pub fn builder() -> crate::input::update_rule_input::Builder {
        crate::input::update_rule_input::Builder::default()
    }
    /// Creates a new `UpdateRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRule {
    type Output =
        std::result::Result<crate::output::UpdateRuleOutput, crate::error::UpdateRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rule_error(response)
        } else {
            crate::operation_deser::parse_update_rule_response(response)
        }
    }
}

/// Operation shape for `UpdateRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_rule_group`](crate::client::Client::update_rule_group).
///
/// See [`crate::client::fluent_builders::UpdateRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRuleGroup {
    _private: (),
}
impl UpdateRuleGroup {
    /// Creates a new builder-style object to manufacture [`UpdateRuleGroupInput`](crate::input::UpdateRuleGroupInput)
    pub fn builder() -> crate::input::update_rule_group_input::Builder {
        crate::input::update_rule_group_input::Builder::default()
    }
    /// Creates a new `UpdateRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRuleGroup {
    type Output = std::result::Result<
        crate::output::UpdateRuleGroupOutput,
        crate::error::UpdateRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_rule_group_error(response)
        } else {
            crate::operation_deser::parse_update_rule_group_response(response)
        }
    }
}

/// Operation shape for `UpdateSizeConstraintSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_size_constraint_set`](crate::client::Client::update_size_constraint_set).
///
/// See [`crate::client::fluent_builders::UpdateSizeConstraintSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSizeConstraintSet {
    _private: (),
}
impl UpdateSizeConstraintSet {
    /// Creates a new builder-style object to manufacture [`UpdateSizeConstraintSetInput`](crate::input::UpdateSizeConstraintSetInput)
    pub fn builder() -> crate::input::update_size_constraint_set_input::Builder {
        crate::input::update_size_constraint_set_input::Builder::default()
    }
    /// Creates a new `UpdateSizeConstraintSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSizeConstraintSet {
    type Output = std::result::Result<
        crate::output::UpdateSizeConstraintSetOutput,
        crate::error::UpdateSizeConstraintSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_size_constraint_set_error(response)
        } else {
            crate::operation_deser::parse_update_size_constraint_set_response(response)
        }
    }
}

/// Operation shape for `UpdateSqlInjectionMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_sql_injection_match_set`](crate::client::Client::update_sql_injection_match_set).
///
/// See [`crate::client::fluent_builders::UpdateSqlInjectionMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSqlInjectionMatchSet {
    _private: (),
}
impl UpdateSqlInjectionMatchSet {
    /// Creates a new builder-style object to manufacture [`UpdateSqlInjectionMatchSetInput`](crate::input::UpdateSqlInjectionMatchSetInput)
    pub fn builder() -> crate::input::update_sql_injection_match_set_input::Builder {
        crate::input::update_sql_injection_match_set_input::Builder::default()
    }
    /// Creates a new `UpdateSqlInjectionMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSqlInjectionMatchSet {
    type Output = std::result::Result<
        crate::output::UpdateSqlInjectionMatchSetOutput,
        crate::error::UpdateSqlInjectionMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_sql_injection_match_set_error(response)
        } else {
            crate::operation_deser::parse_update_sql_injection_match_set_response(response)
        }
    }
}

/// Operation shape for `UpdateWebACL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_web_acl`](crate::client::Client::update_web_acl).
///
/// See [`crate::client::fluent_builders::UpdateWebACL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWebACL {
    _private: (),
}
impl UpdateWebACL {
    /// Creates a new builder-style object to manufacture [`UpdateWebAclInput`](crate::input::UpdateWebAclInput)
    pub fn builder() -> crate::input::update_web_acl_input::Builder {
        crate::input::update_web_acl_input::Builder::default()
    }
    /// Creates a new `UpdateWebACL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWebACL {
    type Output =
        std::result::Result<crate::output::UpdateWebAclOutput, crate::error::UpdateWebACLError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_web_acl_error(response)
        } else {
            crate::operation_deser::parse_update_web_acl_response(response)
        }
    }
}

/// Operation shape for `UpdateXssMatchSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_xss_match_set`](crate::client::Client::update_xss_match_set).
///
/// See [`crate::client::fluent_builders::UpdateXssMatchSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateXssMatchSet {
    _private: (),
}
impl UpdateXssMatchSet {
    /// Creates a new builder-style object to manufacture [`UpdateXssMatchSetInput`](crate::input::UpdateXssMatchSetInput)
    pub fn builder() -> crate::input::update_xss_match_set_input::Builder {
        crate::input::update_xss_match_set_input::Builder::default()
    }
    /// Creates a new `UpdateXssMatchSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateXssMatchSet {
    type Output = std::result::Result<
        crate::output::UpdateXssMatchSetOutput,
        crate::error::UpdateXssMatchSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_xss_match_set_error(response)
        } else {
            crate::operation_deser::parse_update_xss_match_set_response(response)
        }
    }
}
