// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    IllegalArgument,
    #[allow(missing_docs)] // documentation missing in model
    IllegalCombination,
    #[allow(missing_docs)] // documentation missing in model
    InvalidOption,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTagKey,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ILLEGAL_ARGUMENT" => ParameterExceptionReason::IllegalArgument,
            "ILLEGAL_COMBINATION" => ParameterExceptionReason::IllegalCombination,
            "INVALID_OPTION" => ParameterExceptionReason::InvalidOption,
            "INVALID_TAG_KEY" => ParameterExceptionReason::InvalidTagKey,
            other => ParameterExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterExceptionReason::from(s))
    }
}
impl ParameterExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterExceptionReason::IllegalArgument => "ILLEGAL_ARGUMENT",
            ParameterExceptionReason::IllegalCombination => "ILLEGAL_COMBINATION",
            ParameterExceptionReason::InvalidOption => "INVALID_OPTION",
            ParameterExceptionReason::InvalidTagKey => "INVALID_TAG_KEY",
            ParameterExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ILLEGAL_ARGUMENT",
            "ILLEGAL_COMBINATION",
            "INVALID_OPTION",
            "INVALID_TAG_KEY",
        ]
    }
}
impl AsRef<str> for ParameterExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterExceptionField {
    #[allow(missing_docs)] // documentation missing in model
    ByteMatchFieldType,
    #[allow(missing_docs)] // documentation missing in model
    ByteMatchPositionalConstraint,
    #[allow(missing_docs)] // documentation missing in model
    ByteMatchTextTransformation,
    #[allow(missing_docs)] // documentation missing in model
    ChangeAction,
    #[allow(missing_docs)] // documentation missing in model
    GeoMatchLocationType,
    #[allow(missing_docs)] // documentation missing in model
    GeoMatchLocationValue,
    #[allow(missing_docs)] // documentation missing in model
    IpsetType,
    #[allow(missing_docs)] // documentation missing in model
    NextMarker,
    #[allow(missing_docs)] // documentation missing in model
    PredicateType,
    #[allow(missing_docs)] // documentation missing in model
    RateKey,
    #[allow(missing_docs)] // documentation missing in model
    ResourceArn,
    #[allow(missing_docs)] // documentation missing in model
    RuleType,
    #[allow(missing_docs)] // documentation missing in model
    SizeConstraintComparisonOperator,
    #[allow(missing_docs)] // documentation missing in model
    SqlInjectionMatchFieldType,
    #[allow(missing_docs)] // documentation missing in model
    Tags,
    #[allow(missing_docs)] // documentation missing in model
    TagKeys,
    #[allow(missing_docs)] // documentation missing in model
    WafAction,
    #[allow(missing_docs)] // documentation missing in model
    WafOverrideAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterExceptionField {
    fn from(s: &str) -> Self {
        match s {
            "BYTE_MATCH_FIELD_TYPE" => ParameterExceptionField::ByteMatchFieldType,
            "BYTE_MATCH_POSITIONAL_CONSTRAINT" => {
                ParameterExceptionField::ByteMatchPositionalConstraint
            }
            "BYTE_MATCH_TEXT_TRANSFORMATION" => {
                ParameterExceptionField::ByteMatchTextTransformation
            }
            "CHANGE_ACTION" => ParameterExceptionField::ChangeAction,
            "GEO_MATCH_LOCATION_TYPE" => ParameterExceptionField::GeoMatchLocationType,
            "GEO_MATCH_LOCATION_VALUE" => ParameterExceptionField::GeoMatchLocationValue,
            "IPSET_TYPE" => ParameterExceptionField::IpsetType,
            "NEXT_MARKER" => ParameterExceptionField::NextMarker,
            "PREDICATE_TYPE" => ParameterExceptionField::PredicateType,
            "RATE_KEY" => ParameterExceptionField::RateKey,
            "RESOURCE_ARN" => ParameterExceptionField::ResourceArn,
            "RULE_TYPE" => ParameterExceptionField::RuleType,
            "SIZE_CONSTRAINT_COMPARISON_OPERATOR" => {
                ParameterExceptionField::SizeConstraintComparisonOperator
            }
            "SQL_INJECTION_MATCH_FIELD_TYPE" => ParameterExceptionField::SqlInjectionMatchFieldType,
            "TAGS" => ParameterExceptionField::Tags,
            "TAG_KEYS" => ParameterExceptionField::TagKeys,
            "WAF_ACTION" => ParameterExceptionField::WafAction,
            "WAF_OVERRIDE_ACTION" => ParameterExceptionField::WafOverrideAction,
            other => ParameterExceptionField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterExceptionField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterExceptionField::from(s))
    }
}
impl ParameterExceptionField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterExceptionField::ByteMatchFieldType => "BYTE_MATCH_FIELD_TYPE",
            ParameterExceptionField::ByteMatchPositionalConstraint => {
                "BYTE_MATCH_POSITIONAL_CONSTRAINT"
            }
            ParameterExceptionField::ByteMatchTextTransformation => {
                "BYTE_MATCH_TEXT_TRANSFORMATION"
            }
            ParameterExceptionField::ChangeAction => "CHANGE_ACTION",
            ParameterExceptionField::GeoMatchLocationType => "GEO_MATCH_LOCATION_TYPE",
            ParameterExceptionField::GeoMatchLocationValue => "GEO_MATCH_LOCATION_VALUE",
            ParameterExceptionField::IpsetType => "IPSET_TYPE",
            ParameterExceptionField::NextMarker => "NEXT_MARKER",
            ParameterExceptionField::PredicateType => "PREDICATE_TYPE",
            ParameterExceptionField::RateKey => "RATE_KEY",
            ParameterExceptionField::ResourceArn => "RESOURCE_ARN",
            ParameterExceptionField::RuleType => "RULE_TYPE",
            ParameterExceptionField::SizeConstraintComparisonOperator => {
                "SIZE_CONSTRAINT_COMPARISON_OPERATOR"
            }
            ParameterExceptionField::SqlInjectionMatchFieldType => "SQL_INJECTION_MATCH_FIELD_TYPE",
            ParameterExceptionField::Tags => "TAGS",
            ParameterExceptionField::TagKeys => "TAG_KEYS",
            ParameterExceptionField::WafAction => "WAF_ACTION",
            ParameterExceptionField::WafOverrideAction => "WAF_OVERRIDE_ACTION",
            ParameterExceptionField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BYTE_MATCH_FIELD_TYPE",
            "BYTE_MATCH_POSITIONAL_CONSTRAINT",
            "BYTE_MATCH_TEXT_TRANSFORMATION",
            "CHANGE_ACTION",
            "GEO_MATCH_LOCATION_TYPE",
            "GEO_MATCH_LOCATION_VALUE",
            "IPSET_TYPE",
            "NEXT_MARKER",
            "PREDICATE_TYPE",
            "RATE_KEY",
            "RESOURCE_ARN",
            "RULE_TYPE",
            "SIZE_CONSTRAINT_COMPARISON_OPERATOR",
            "SQL_INJECTION_MATCH_FIELD_TYPE",
            "TAGS",
            "TAG_KEYS",
            "WAF_ACTION",
            "WAF_OVERRIDE_ACTION",
        ]
    }
}
impl AsRef<str> for ParameterExceptionField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the part of a web request that you want to inspect for cross-site scripting attacks and indicates whether you want to add the specification to an <code>XssMatchSet</code> or delete it from an <code>XssMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XssMatchSetUpdate {
    /// <p>Specify <code>INSERT</code> to add an <code>XssMatchSetUpdate</code> to an <code>XssMatchSet</code>. Use <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.</p>
    pub xss_match_tuple: std::option::Option<crate::model::XssMatchTuple>,
}
impl XssMatchSetUpdate {
    /// <p>Specify <code>INSERT</code> to add an <code>XssMatchSetUpdate</code> to an <code>XssMatchSet</code>. Use <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.</p>
    pub fn xss_match_tuple(&self) -> std::option::Option<&crate::model::XssMatchTuple> {
        self.xss_match_tuple.as_ref()
    }
}
impl std::fmt::Debug for XssMatchSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XssMatchSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("xss_match_tuple", &self.xss_match_tuple);
        formatter.finish()
    }
}
/// See [`XssMatchSetUpdate`](crate::model::XssMatchSetUpdate)
pub mod xss_match_set_update {
    /// A builder for [`XssMatchSetUpdate`](crate::model::XssMatchSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) xss_match_tuple: std::option::Option<crate::model::XssMatchTuple>,
    }
    impl Builder {
        /// <p>Specify <code>INSERT</code> to add an <code>XssMatchSetUpdate</code> to an <code>XssMatchSet</code>. Use <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specify <code>INSERT</code> to add an <code>XssMatchSetUpdate</code> to an <code>XssMatchSet</code>. Use <code>DELETE</code> to remove an <code>XssMatchSetUpdate</code> from an <code>XssMatchSet</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.</p>
        pub fn xss_match_tuple(mut self, input: crate::model::XssMatchTuple) -> Self {
            self.xss_match_tuple = Some(input);
            self
        }
        /// <p>Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.</p>
        pub fn set_xss_match_tuple(
            mut self,
            input: std::option::Option<crate::model::XssMatchTuple>,
        ) -> Self {
            self.xss_match_tuple = input;
            self
        }
        /// Consumes the builder and constructs a [`XssMatchSetUpdate`](crate::model::XssMatchSetUpdate)
        pub fn build(self) -> crate::model::XssMatchSetUpdate {
            crate::model::XssMatchSetUpdate {
                action: self.action,
                xss_match_tuple: self.xss_match_tuple,
            }
        }
    }
}
impl XssMatchSetUpdate {
    /// Creates a new builder-style object to manufacture [`XssMatchSetUpdate`](crate::model::XssMatchSetUpdate)
    pub fn builder() -> crate::model::xss_match_set_update::Builder {
        crate::model::xss_match_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XssMatchTuple {
    /// <p>Specifies where in a web request to look for cross-site scripting attacks.</p>
    pub field_to_match: std::option::Option<crate::model::FieldToMatch>,
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub text_transformation: std::option::Option<crate::model::TextTransformation>,
}
impl XssMatchTuple {
    /// <p>Specifies where in a web request to look for cross-site scripting attacks.</p>
    pub fn field_to_match(&self) -> std::option::Option<&crate::model::FieldToMatch> {
        self.field_to_match.as_ref()
    }
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub fn text_transformation(&self) -> std::option::Option<&crate::model::TextTransformation> {
        self.text_transformation.as_ref()
    }
}
impl std::fmt::Debug for XssMatchTuple {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XssMatchTuple");
        formatter.field("field_to_match", &self.field_to_match);
        formatter.field("text_transformation", &self.text_transformation);
        formatter.finish()
    }
}
/// See [`XssMatchTuple`](crate::model::XssMatchTuple)
pub mod xss_match_tuple {
    /// A builder for [`XssMatchTuple`](crate::model::XssMatchTuple)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_to_match: std::option::Option<crate::model::FieldToMatch>,
        pub(crate) text_transformation: std::option::Option<crate::model::TextTransformation>,
    }
    impl Builder {
        /// <p>Specifies where in a web request to look for cross-site scripting attacks.</p>
        pub fn field_to_match(mut self, input: crate::model::FieldToMatch) -> Self {
            self.field_to_match = Some(input);
            self
        }
        /// <p>Specifies where in a web request to look for cross-site scripting attacks.</p>
        pub fn set_field_to_match(
            mut self,
            input: std::option::Option<crate::model::FieldToMatch>,
        ) -> Self {
            self.field_to_match = input;
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn text_transformation(mut self, input: crate::model::TextTransformation) -> Self {
            self.text_transformation = Some(input);
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn set_text_transformation(
            mut self,
            input: std::option::Option<crate::model::TextTransformation>,
        ) -> Self {
            self.text_transformation = input;
            self
        }
        /// Consumes the builder and constructs a [`XssMatchTuple`](crate::model::XssMatchTuple)
        pub fn build(self) -> crate::model::XssMatchTuple {
            crate::model::XssMatchTuple {
                field_to_match: self.field_to_match,
                text_transformation: self.text_transformation,
            }
        }
    }
}
impl XssMatchTuple {
    /// Creates a new builder-style object to manufacture [`XssMatchTuple`](crate::model::XssMatchTuple)
    pub fn builder() -> crate::model::xss_match_tuple::Builder {
        crate::model::xss_match_tuple::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TextTransformation {
    #[allow(missing_docs)] // documentation missing in model
    CmdLine,
    #[allow(missing_docs)] // documentation missing in model
    CompressWhiteSpace,
    #[allow(missing_docs)] // documentation missing in model
    HtmlEntityDecode,
    #[allow(missing_docs)] // documentation missing in model
    Lowercase,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    UrlDecode,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TextTransformation {
    fn from(s: &str) -> Self {
        match s {
            "CMD_LINE" => TextTransformation::CmdLine,
            "COMPRESS_WHITE_SPACE" => TextTransformation::CompressWhiteSpace,
            "HTML_ENTITY_DECODE" => TextTransformation::HtmlEntityDecode,
            "LOWERCASE" => TextTransformation::Lowercase,
            "NONE" => TextTransformation::None,
            "URL_DECODE" => TextTransformation::UrlDecode,
            other => TextTransformation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TextTransformation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TextTransformation::from(s))
    }
}
impl TextTransformation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TextTransformation::CmdLine => "CMD_LINE",
            TextTransformation::CompressWhiteSpace => "COMPRESS_WHITE_SPACE",
            TextTransformation::HtmlEntityDecode => "HTML_ENTITY_DECODE",
            TextTransformation::Lowercase => "LOWERCASE",
            TextTransformation::None => "NONE",
            TextTransformation::UrlDecode => "URL_DECODE",
            TextTransformation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CMD_LINE",
            "COMPRESS_WHITE_SPACE",
            "HTML_ENTITY_DECODE",
            "LOWERCASE",
            "NONE",
            "URL_DECODE",
        ]
    }
}
impl AsRef<str> for TextTransformation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies where in a web request to look for <code>TargetString</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldToMatch {
    /// <p>The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you can search include the following:</p>
    /// <ul>
    /// <li> <p> <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in <code>Data</code>.</p> </li>
    /// <li> <p> <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
    /// <li> <p> <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code> character, if any.</p> </li>
    /// <li> <p> <code>URI</code>: The part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
    /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
    /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
    /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::MatchFieldType>,
    /// <p>When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header is not case sensitive.</p>
    /// <p>When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The parameter name is not case sensitive.</p>
    /// <p>If the value of <code>Type</code> is any other value, omit <code>Data</code>.</p>
    pub data: std::option::Option<std::string::String>,
}
impl FieldToMatch {
    /// <p>The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you can search include the following:</p>
    /// <ul>
    /// <li> <p> <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in <code>Data</code>.</p> </li>
    /// <li> <p> <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
    /// <li> <p> <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code> character, if any.</p> </li>
    /// <li> <p> <code>URI</code>: The part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
    /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
    /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
    /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MatchFieldType> {
        self.r#type.as_ref()
    }
    /// <p>When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header is not case sensitive.</p>
    /// <p>When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The parameter name is not case sensitive.</p>
    /// <p>If the value of <code>Type</code> is any other value, omit <code>Data</code>.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
}
impl std::fmt::Debug for FieldToMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldToMatch");
        formatter.field("r#type", &self.r#type);
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`FieldToMatch`](crate::model::FieldToMatch)
pub mod field_to_match {
    /// A builder for [`FieldToMatch`](crate::model::FieldToMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::MatchFieldType>,
        pub(crate) data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you can search include the following:</p>
        /// <ul>
        /// <li> <p> <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in <code>Data</code>.</p> </li>
        /// <li> <p> <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
        /// <li> <p> <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code> character, if any.</p> </li>
        /// <li> <p> <code>URI</code>: The part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
        /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
        /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
        /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::MatchFieldType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The part of the web request that you want AWS WAF to search for a specified string. Parts of a request that you can search include the following:</p>
        /// <ul>
        /// <li> <p> <code>HEADER</code>: A specified request header, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header. If you choose <code>HEADER</code> for the type, specify the name of the header in <code>Data</code>.</p> </li>
        /// <li> <p> <code>METHOD</code>: The HTTP method, which indicated the type of operation that the request is asking the origin to perform. Amazon CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
        /// <li> <p> <code>QUERY_STRING</code>: A query string, which is the part of a URL that appears after a <code>?</code> character, if any.</p> </li>
        /// <li> <p> <code>URI</code>: The part of a web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
        /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
        /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
        /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but rather than inspecting a single parameter, AWS WAF will inspect all parameters within the query for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::MatchFieldType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header is not case sensitive.</p>
        /// <p>When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The parameter name is not case sensitive.</p>
        /// <p>If the value of <code>Type</code> is any other value, omit <code>Data</code>.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>When the value of <code>Type</code> is <code>HEADER</code>, enter the name of the header that you want AWS WAF to search, for example, <code>User-Agent</code> or <code>Referer</code>. The name of the header is not case sensitive.</p>
        /// <p>When the value of <code>Type</code> is <code>SINGLE_QUERY_ARG</code>, enter the name of the parameter that you want AWS WAF to search, for example, <code>UserName</code> or <code>SalesRegion</code>. The parameter name is not case sensitive.</p>
        /// <p>If the value of <code>Type</code> is any other value, omit <code>Data</code>.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldToMatch`](crate::model::FieldToMatch)
        pub fn build(self) -> crate::model::FieldToMatch {
            crate::model::FieldToMatch {
                r#type: self.r#type,
                data: self.data,
            }
        }
    }
}
impl FieldToMatch {
    /// Creates a new builder-style object to manufacture [`FieldToMatch`](crate::model::FieldToMatch)
    pub fn builder() -> crate::model::field_to_match::Builder {
        crate::model::field_to_match::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MatchFieldType {
    #[allow(missing_docs)] // documentation missing in model
    AllQueryArgs,
    #[allow(missing_docs)] // documentation missing in model
    Body,
    #[allow(missing_docs)] // documentation missing in model
    Header,
    #[allow(missing_docs)] // documentation missing in model
    Method,
    #[allow(missing_docs)] // documentation missing in model
    QueryString,
    #[allow(missing_docs)] // documentation missing in model
    SingleQueryArg,
    #[allow(missing_docs)] // documentation missing in model
    Uri,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MatchFieldType {
    fn from(s: &str) -> Self {
        match s {
            "ALL_QUERY_ARGS" => MatchFieldType::AllQueryArgs,
            "BODY" => MatchFieldType::Body,
            "HEADER" => MatchFieldType::Header,
            "METHOD" => MatchFieldType::Method,
            "QUERY_STRING" => MatchFieldType::QueryString,
            "SINGLE_QUERY_ARG" => MatchFieldType::SingleQueryArg,
            "URI" => MatchFieldType::Uri,
            other => MatchFieldType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MatchFieldType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MatchFieldType::from(s))
    }
}
impl MatchFieldType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MatchFieldType::AllQueryArgs => "ALL_QUERY_ARGS",
            MatchFieldType::Body => "BODY",
            MatchFieldType::Header => "HEADER",
            MatchFieldType::Method => "METHOD",
            MatchFieldType::QueryString => "QUERY_STRING",
            MatchFieldType::SingleQueryArg => "SINGLE_QUERY_ARG",
            MatchFieldType::Uri => "URI",
            MatchFieldType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL_QUERY_ARGS",
            "BODY",
            "HEADER",
            "METHOD",
            "QUERY_STRING",
            "SINGLE_QUERY_ARG",
            "URI",
        ]
    }
}
impl AsRef<str> for MatchFieldType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeAction {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeAction {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => ChangeAction::Delete,
            "INSERT" => ChangeAction::Insert,
            other => ChangeAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeAction::from(s))
    }
}
impl ChangeAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeAction::Delete => "DELETE",
            ChangeAction::Insert => "INSERT",
            ChangeAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "INSERT"]
    }
}
impl AsRef<str> for ChangeAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>For the action that is associated with a rule in a <code>WebACL</code>, specifies the action that you want AWS WAF to perform when a web request matches all of the conditions in a rule. For the default action in a <code>WebACL</code>, specifies the action that you want AWS WAF to take when a web request doesn't match all of the conditions in any of the rules in a <code>WebACL</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafAction {
    /// <p>Specifies how you want AWS WAF to respond to requests that match the settings in a <code>Rule</code>. Valid settings include the following:</p>
    /// <ul>
    /// <li> <p> <code>ALLOW</code>: AWS WAF allows requests</p> </li>
    /// <li> <p> <code>BLOCK</code>: AWS WAF blocks requests</p> </li>
    /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify <code>COUNT</code> for the default action for a <code>WebACL</code>.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::WafActionType>,
}
impl WafAction {
    /// <p>Specifies how you want AWS WAF to respond to requests that match the settings in a <code>Rule</code>. Valid settings include the following:</p>
    /// <ul>
    /// <li> <p> <code>ALLOW</code>: AWS WAF allows requests</p> </li>
    /// <li> <p> <code>BLOCK</code>: AWS WAF blocks requests</p> </li>
    /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify <code>COUNT</code> for the default action for a <code>WebACL</code>.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WafActionType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for WafAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafAction");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`WafAction`](crate::model::WafAction)
pub mod waf_action {
    /// A builder for [`WafAction`](crate::model::WafAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WafActionType>,
    }
    impl Builder {
        /// <p>Specifies how you want AWS WAF to respond to requests that match the settings in a <code>Rule</code>. Valid settings include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code>: AWS WAF allows requests</p> </li>
        /// <li> <p> <code>BLOCK</code>: AWS WAF blocks requests</p> </li>
        /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify <code>COUNT</code> for the default action for a <code>WebACL</code>.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::WafActionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies how you want AWS WAF to respond to requests that match the settings in a <code>Rule</code>. Valid settings include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code>: AWS WAF allows requests</p> </li>
        /// <li> <p> <code>BLOCK</code>: AWS WAF blocks requests</p> </li>
        /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify <code>COUNT</code> for the default action for a <code>WebACL</code>.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::WafActionType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`WafAction`](crate::model::WafAction)
        pub fn build(self) -> crate::model::WafAction {
            crate::model::WafAction {
                r#type: self.r#type,
            }
        }
    }
}
impl WafAction {
    /// Creates a new builder-style object to manufacture [`WafAction`](crate::model::WafAction)
    pub fn builder() -> crate::model::waf_action::Builder {
        crate::model::waf_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WafActionType {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Block,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WafActionType {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => WafActionType::Allow,
            "BLOCK" => WafActionType::Block,
            "COUNT" => WafActionType::Count,
            other => WafActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WafActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WafActionType::from(s))
    }
}
impl WafActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WafActionType::Allow => "ALLOW",
            WafActionType::Block => "BLOCK",
            WafActionType::Count => "COUNT",
            WafActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "BLOCK", "COUNT"]
    }
}
impl AsRef<str> for WafActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebAclUpdate {
    /// <p>Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The <code>ActivatedRule</code> object in an <code>UpdateWebACL</code> request specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
    pub activated_rule: std::option::Option<crate::model::ActivatedRule>,
}
impl WebAclUpdate {
    /// <p>Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The <code>ActivatedRule</code> object in an <code>UpdateWebACL</code> request specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
    pub fn activated_rule(&self) -> std::option::Option<&crate::model::ActivatedRule> {
        self.activated_rule.as_ref()
    }
}
impl std::fmt::Debug for WebAclUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebAclUpdate");
        formatter.field("action", &self.action);
        formatter.field("activated_rule", &self.activated_rule);
        formatter.finish()
    }
}
/// See [`WebAclUpdate`](crate::model::WebAclUpdate)
pub mod web_acl_update {
    /// A builder for [`WebAclUpdate`](crate::model::WebAclUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) activated_rule: std::option::Option<crate::model::ActivatedRule>,
    }
    impl Builder {
        /// <p>Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether to insert a <code>Rule</code> into or delete a <code>Rule</code> from a <code>WebACL</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The <code>ActivatedRule</code> object in an <code>UpdateWebACL</code> request specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
        pub fn activated_rule(mut self, input: crate::model::ActivatedRule) -> Self {
            self.activated_rule = Some(input);
            self
        }
        /// <p>The <code>ActivatedRule</code> object in an <code>UpdateWebACL</code> request specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
        pub fn set_activated_rule(
            mut self,
            input: std::option::Option<crate::model::ActivatedRule>,
        ) -> Self {
            self.activated_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`WebAclUpdate`](crate::model::WebAclUpdate)
        pub fn build(self) -> crate::model::WebAclUpdate {
            crate::model::WebAclUpdate {
                action: self.action,
                activated_rule: self.activated_rule,
            }
        }
    }
}
impl WebAclUpdate {
    /// Creates a new builder-style object to manufacture [`WebAclUpdate`](crate::model::WebAclUpdate)
    pub fn builder() -> crate::model::web_acl_update::Builder {
        crate::model::web_acl_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The <code>ActivatedRule</code> object in an <code>UpdateWebACL</code> request specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
/// <p>To specify whether to insert or delete a <code>Rule</code>, use the <code>Action</code> parameter in the <code>WebACLUpdate</code> data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivatedRule {
    /// <p>Specifies the order in which the <code>Rules</code> in a <code>WebACL</code> are evaluated. Rules with a lower value for <code>Priority</code> are evaluated before <code>Rules</code> with a higher value. The value must be a unique integer. If you add multiple <code>Rules</code> to a <code>WebACL</code>, the values don't need to be consecutive.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The <code>RuleId</code> for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
    /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the <code>Rule</code>. Valid values for <code>Action</code> include the following:</p>
    /// <ul>
    /// <li> <p> <code>ALLOW</code>: CloudFront responds with the requested object.</p> </li>
    /// <li> <p> <code>BLOCK</code>: CloudFront responds with an HTTP 403 (Forbidden) status code.</p> </li>
    /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of requests that match the conditions in the rule and then continues to inspect the web request based on the remaining rules in the web ACL. </p> </li>
    /// </ul>
    /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
    pub action: std::option::Option<crate::model::WafAction>,
    /// <p>Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p>
    /// <p>Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> will block a request if any individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request. However if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to <code>Count</code>. The <code>RuleGroup</code> will then override any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests will be counted. You can view a record of counted requests using <code>GetSampledRequests</code>. </p>
    /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
    pub override_action: std::option::Option<crate::model::WafOverrideAction>,
    /// <p>The rule type, either <code>REGULAR</code>, as defined by <code>Rule</code>, <code>RATE_BASED</code>, as defined by <code>RateBasedRule</code>, or <code>GROUP</code>, as defined by <code>RuleGroup</code>. The default is REGULAR. Although this field is optional, be aware that if you try to add a RATE_BASED rule to a web ACL without setting the type, the <code>UpdateWebACL</code> request will fail because the request tries to add a REGULAR rule with the specified ID, which does not exist. </p>
    pub r#type: std::option::Option<crate::model::WafRuleType>,
    /// <p>An array of rules to exclude from a rule group. This is applicable only when the <code>ActivatedRule</code> refers to a <code>RuleGroup</code>.</p>
    /// <p>Sometimes it is necessary to troubleshoot rule groups that are blocking traffic unexpectedly (false positives). One troubleshooting technique is to identify the specific rule within the rule group that is blocking the legitimate traffic and then disable (exclude) that particular rule. You can exclude rules from both your own rule groups and AWS Marketplace rule groups that have been associated with a web ACL.</p>
    /// <p>Specifying <code>ExcludedRules</code> does not remove those rules from the rule group. Rather, it changes the action for the rules to <code>COUNT</code>. Therefore, requests that match an <code>ExcludedRule</code> are counted but not blocked. The <code>RuleGroup</code> owner will receive COUNT metrics for each <code>ExcludedRule</code>.</p>
    /// <p>If you want to exclude rules from a rule group that is already associated with a web ACL, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use the AWS WAF logs to identify the IDs of the rules that you want to exclude. For more information about the logs, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL Traffic Information</a>.</p> </li>
    /// <li> <p>Submit an <code>UpdateWebACL</code> request that has two actions:</p>
    /// <ul>
    /// <li> <p>The first action deletes the existing rule group from the web ACL. That is, in the <code>UpdateWebACL</code> request, the first <code>Updates:Action</code> should be <code>DELETE</code> and <code>Updates:ActivatedRule:RuleId</code> should be the rule group that contains the rules that you want to exclude.</p> </li>
    /// <li> <p>The second action inserts the same rule group back in, but specifying the rules to exclude. That is, the second <code>Updates:Action</code> should be <code>INSERT</code>, <code>Updates:ActivatedRule:RuleId</code> should be the rule group that you just removed, and <code>ExcludedRules</code> should contain the rules that you want to exclude.</p> </li>
    /// </ul> </li>
    /// </ol>
    pub excluded_rules: std::option::Option<std::vec::Vec<crate::model::ExcludedRule>>,
}
impl ActivatedRule {
    /// <p>Specifies the order in which the <code>Rules</code> in a <code>WebACL</code> are evaluated. Rules with a lower value for <code>Priority</code> are evaluated before <code>Rules</code> with a higher value. The value must be a unique integer. If you add multiple <code>Rules</code> to a <code>WebACL</code>, the values don't need to be consecutive.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The <code>RuleId</code> for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
    /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the <code>Rule</code>. Valid values for <code>Action</code> include the following:</p>
    /// <ul>
    /// <li> <p> <code>ALLOW</code>: CloudFront responds with the requested object.</p> </li>
    /// <li> <p> <code>BLOCK</code>: CloudFront responds with an HTTP 403 (Forbidden) status code.</p> </li>
    /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of requests that match the conditions in the rule and then continues to inspect the web request based on the remaining rules in the web ACL. </p> </li>
    /// </ul>
    /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::WafAction> {
        self.action.as_ref()
    }
    /// <p>Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p>
    /// <p>Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> will block a request if any individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request. However if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to <code>Count</code>. The <code>RuleGroup</code> will then override any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests will be counted. You can view a record of counted requests using <code>GetSampledRequests</code>. </p>
    /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
    pub fn override_action(&self) -> std::option::Option<&crate::model::WafOverrideAction> {
        self.override_action.as_ref()
    }
    /// <p>The rule type, either <code>REGULAR</code>, as defined by <code>Rule</code>, <code>RATE_BASED</code>, as defined by <code>RateBasedRule</code>, or <code>GROUP</code>, as defined by <code>RuleGroup</code>. The default is REGULAR. Although this field is optional, be aware that if you try to add a RATE_BASED rule to a web ACL without setting the type, the <code>UpdateWebACL</code> request will fail because the request tries to add a REGULAR rule with the specified ID, which does not exist. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WafRuleType> {
        self.r#type.as_ref()
    }
    /// <p>An array of rules to exclude from a rule group. This is applicable only when the <code>ActivatedRule</code> refers to a <code>RuleGroup</code>.</p>
    /// <p>Sometimes it is necessary to troubleshoot rule groups that are blocking traffic unexpectedly (false positives). One troubleshooting technique is to identify the specific rule within the rule group that is blocking the legitimate traffic and then disable (exclude) that particular rule. You can exclude rules from both your own rule groups and AWS Marketplace rule groups that have been associated with a web ACL.</p>
    /// <p>Specifying <code>ExcludedRules</code> does not remove those rules from the rule group. Rather, it changes the action for the rules to <code>COUNT</code>. Therefore, requests that match an <code>ExcludedRule</code> are counted but not blocked. The <code>RuleGroup</code> owner will receive COUNT metrics for each <code>ExcludedRule</code>.</p>
    /// <p>If you want to exclude rules from a rule group that is already associated with a web ACL, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use the AWS WAF logs to identify the IDs of the rules that you want to exclude. For more information about the logs, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL Traffic Information</a>.</p> </li>
    /// <li> <p>Submit an <code>UpdateWebACL</code> request that has two actions:</p>
    /// <ul>
    /// <li> <p>The first action deletes the existing rule group from the web ACL. That is, in the <code>UpdateWebACL</code> request, the first <code>Updates:Action</code> should be <code>DELETE</code> and <code>Updates:ActivatedRule:RuleId</code> should be the rule group that contains the rules that you want to exclude.</p> </li>
    /// <li> <p>The second action inserts the same rule group back in, but specifying the rules to exclude. That is, the second <code>Updates:Action</code> should be <code>INSERT</code>, <code>Updates:ActivatedRule:RuleId</code> should be the rule group that you just removed, and <code>ExcludedRules</code> should contain the rules that you want to exclude.</p> </li>
    /// </ul> </li>
    /// </ol>
    pub fn excluded_rules(&self) -> std::option::Option<&[crate::model::ExcludedRule]> {
        self.excluded_rules.as_deref()
    }
}
impl std::fmt::Debug for ActivatedRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivatedRule");
        formatter.field("priority", &self.priority);
        formatter.field("rule_id", &self.rule_id);
        formatter.field("action", &self.action);
        formatter.field("override_action", &self.override_action);
        formatter.field("r#type", &self.r#type);
        formatter.field("excluded_rules", &self.excluded_rules);
        formatter.finish()
    }
}
/// See [`ActivatedRule`](crate::model::ActivatedRule)
pub mod activated_rule {
    /// A builder for [`ActivatedRule`](crate::model::ActivatedRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::WafAction>,
        pub(crate) override_action: std::option::Option<crate::model::WafOverrideAction>,
        pub(crate) r#type: std::option::Option<crate::model::WafRuleType>,
        pub(crate) excluded_rules: std::option::Option<std::vec::Vec<crate::model::ExcludedRule>>,
    }
    impl Builder {
        /// <p>Specifies the order in which the <code>Rules</code> in a <code>WebACL</code> are evaluated. Rules with a lower value for <code>Priority</code> are evaluated before <code>Rules</code> with a higher value. The value must be a unique integer. If you add multiple <code>Rules</code> to a <code>WebACL</code>, the values don't need to be consecutive.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>Specifies the order in which the <code>Rules</code> in a <code>WebACL</code> are evaluated. Rules with a lower value for <code>Priority</code> are evaluated before <code>Rules</code> with a higher value. The value must be a unique integer. If you add multiple <code>Rules</code> to a <code>WebACL</code>, the values don't need to be consecutive.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The <code>RuleId</code> for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
        /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The <code>RuleId</code> for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
        /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the <code>Rule</code>. Valid values for <code>Action</code> include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code>: CloudFront responds with the requested object.</p> </li>
        /// <li> <p> <code>BLOCK</code>: CloudFront responds with an HTTP 403 (Forbidden) status code.</p> </li>
        /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of requests that match the conditions in the rule and then continues to inspect the web request based on the remaining rules in the web ACL. </p> </li>
        /// </ul>
        /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn action(mut self, input: crate::model::WafAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the <code>Rule</code>. Valid values for <code>Action</code> include the following:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code>: CloudFront responds with the requested object.</p> </li>
        /// <li> <p> <code>BLOCK</code>: CloudFront responds with an HTTP 403 (Forbidden) status code.</p> </li>
        /// <li> <p> <code>COUNT</code>: AWS WAF increments a counter of requests that match the conditions in the rule and then continues to inspect the web request based on the remaining rules in the web ACL. </p> </li>
        /// </ul>
        /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::WafAction>) -> Self {
            self.action = input;
            self
        }
        /// <p>Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p>
        /// <p>Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> will block a request if any individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request. However if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to <code>Count</code>. The <code>RuleGroup</code> will then override any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests will be counted. You can view a record of counted requests using <code>GetSampledRequests</code>. </p>
        /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn override_action(mut self, input: crate::model::WafOverrideAction) -> Self {
            self.override_action = Some(input);
            self
        }
        /// <p>Use the <code>OverrideAction</code> to test your <code>RuleGroup</code>.</p>
        /// <p>Any rule in a <code>RuleGroup</code> can potentially block a request. If you set the <code>OverrideAction</code> to <code>None</code>, the <code>RuleGroup</code> will block a request if any individual rule in the <code>RuleGroup</code> matches the request and is configured to block that request. However if you first want to test the <code>RuleGroup</code>, set the <code>OverrideAction</code> to <code>Count</code>. The <code>RuleGroup</code> will then override any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests will be counted. You can view a record of counted requests using <code>GetSampledRequests</code>. </p>
        /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn set_override_action(
            mut self,
            input: std::option::Option<crate::model::WafOverrideAction>,
        ) -> Self {
            self.override_action = input;
            self
        }
        /// <p>The rule type, either <code>REGULAR</code>, as defined by <code>Rule</code>, <code>RATE_BASED</code>, as defined by <code>RateBasedRule</code>, or <code>GROUP</code>, as defined by <code>RuleGroup</code>. The default is REGULAR. Although this field is optional, be aware that if you try to add a RATE_BASED rule to a web ACL without setting the type, the <code>UpdateWebACL</code> request will fail because the request tries to add a REGULAR rule with the specified ID, which does not exist. </p>
        pub fn r#type(mut self, input: crate::model::WafRuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The rule type, either <code>REGULAR</code>, as defined by <code>Rule</code>, <code>RATE_BASED</code>, as defined by <code>RateBasedRule</code>, or <code>GROUP</code>, as defined by <code>RuleGroup</code>. The default is REGULAR. Although this field is optional, be aware that if you try to add a RATE_BASED rule to a web ACL without setting the type, the <code>UpdateWebACL</code> request will fail because the request tries to add a REGULAR rule with the specified ID, which does not exist. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::WafRuleType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `excluded_rules`.
        ///
        /// To override the contents of this collection use [`set_excluded_rules`](Self::set_excluded_rules).
        ///
        /// <p>An array of rules to exclude from a rule group. This is applicable only when the <code>ActivatedRule</code> refers to a <code>RuleGroup</code>.</p>
        /// <p>Sometimes it is necessary to troubleshoot rule groups that are blocking traffic unexpectedly (false positives). One troubleshooting technique is to identify the specific rule within the rule group that is blocking the legitimate traffic and then disable (exclude) that particular rule. You can exclude rules from both your own rule groups and AWS Marketplace rule groups that have been associated with a web ACL.</p>
        /// <p>Specifying <code>ExcludedRules</code> does not remove those rules from the rule group. Rather, it changes the action for the rules to <code>COUNT</code>. Therefore, requests that match an <code>ExcludedRule</code> are counted but not blocked. The <code>RuleGroup</code> owner will receive COUNT metrics for each <code>ExcludedRule</code>.</p>
        /// <p>If you want to exclude rules from a rule group that is already associated with a web ACL, perform the following steps:</p>
        /// <ol>
        /// <li> <p>Use the AWS WAF logs to identify the IDs of the rules that you want to exclude. For more information about the logs, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL Traffic Information</a>.</p> </li>
        /// <li> <p>Submit an <code>UpdateWebACL</code> request that has two actions:</p>
        /// <ul>
        /// <li> <p>The first action deletes the existing rule group from the web ACL. That is, in the <code>UpdateWebACL</code> request, the first <code>Updates:Action</code> should be <code>DELETE</code> and <code>Updates:ActivatedRule:RuleId</code> should be the rule group that contains the rules that you want to exclude.</p> </li>
        /// <li> <p>The second action inserts the same rule group back in, but specifying the rules to exclude. That is, the second <code>Updates:Action</code> should be <code>INSERT</code>, <code>Updates:ActivatedRule:RuleId</code> should be the rule group that you just removed, and <code>ExcludedRules</code> should contain the rules that you want to exclude.</p> </li>
        /// </ul> </li>
        /// </ol>
        pub fn excluded_rules(mut self, input: crate::model::ExcludedRule) -> Self {
            let mut v = self.excluded_rules.unwrap_or_default();
            v.push(input);
            self.excluded_rules = Some(v);
            self
        }
        /// <p>An array of rules to exclude from a rule group. This is applicable only when the <code>ActivatedRule</code> refers to a <code>RuleGroup</code>.</p>
        /// <p>Sometimes it is necessary to troubleshoot rule groups that are blocking traffic unexpectedly (false positives). One troubleshooting technique is to identify the specific rule within the rule group that is blocking the legitimate traffic and then disable (exclude) that particular rule. You can exclude rules from both your own rule groups and AWS Marketplace rule groups that have been associated with a web ACL.</p>
        /// <p>Specifying <code>ExcludedRules</code> does not remove those rules from the rule group. Rather, it changes the action for the rules to <code>COUNT</code>. Therefore, requests that match an <code>ExcludedRule</code> are counted but not blocked. The <code>RuleGroup</code> owner will receive COUNT metrics for each <code>ExcludedRule</code>.</p>
        /// <p>If you want to exclude rules from a rule group that is already associated with a web ACL, perform the following steps:</p>
        /// <ol>
        /// <li> <p>Use the AWS WAF logs to identify the IDs of the rules that you want to exclude. For more information about the logs, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL Traffic Information</a>.</p> </li>
        /// <li> <p>Submit an <code>UpdateWebACL</code> request that has two actions:</p>
        /// <ul>
        /// <li> <p>The first action deletes the existing rule group from the web ACL. That is, in the <code>UpdateWebACL</code> request, the first <code>Updates:Action</code> should be <code>DELETE</code> and <code>Updates:ActivatedRule:RuleId</code> should be the rule group that contains the rules that you want to exclude.</p> </li>
        /// <li> <p>The second action inserts the same rule group back in, but specifying the rules to exclude. That is, the second <code>Updates:Action</code> should be <code>INSERT</code>, <code>Updates:ActivatedRule:RuleId</code> should be the rule group that you just removed, and <code>ExcludedRules</code> should contain the rules that you want to exclude.</p> </li>
        /// </ul> </li>
        /// </ol>
        pub fn set_excluded_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExcludedRule>>,
        ) -> Self {
            self.excluded_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivatedRule`](crate::model::ActivatedRule)
        pub fn build(self) -> crate::model::ActivatedRule {
            crate::model::ActivatedRule {
                priority: self.priority,
                rule_id: self.rule_id,
                action: self.action,
                override_action: self.override_action,
                r#type: self.r#type,
                excluded_rules: self.excluded_rules,
            }
        }
    }
}
impl ActivatedRule {
    /// Creates a new builder-style object to manufacture [`ActivatedRule`](crate::model::ActivatedRule)
    pub fn builder() -> crate::model::activated_rule::Builder {
        crate::model::activated_rule::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The rule to exclude from a rule group. This is applicable only when the <code>ActivatedRule</code> refers to a <code>RuleGroup</code>. The rule must belong to the <code>RuleGroup</code> that is specified by the <code>ActivatedRule</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExcludedRule {
    /// <p>The unique identifier for the rule to exclude from the rule group.</p>
    pub rule_id: std::option::Option<std::string::String>,
}
impl ExcludedRule {
    /// <p>The unique identifier for the rule to exclude from the rule group.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
}
impl std::fmt::Debug for ExcludedRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExcludedRule");
        formatter.field("rule_id", &self.rule_id);
        formatter.finish()
    }
}
/// See [`ExcludedRule`](crate::model::ExcludedRule)
pub mod excluded_rule {
    /// A builder for [`ExcludedRule`](crate::model::ExcludedRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the rule to exclude from the rule group.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the rule to exclude from the rule group.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExcludedRule`](crate::model::ExcludedRule)
        pub fn build(self) -> crate::model::ExcludedRule {
            crate::model::ExcludedRule {
                rule_id: self.rule_id,
            }
        }
    }
}
impl ExcludedRule {
    /// Creates a new builder-style object to manufacture [`ExcludedRule`](crate::model::ExcludedRule)
    pub fn builder() -> crate::model::excluded_rule::Builder {
        crate::model::excluded_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WafRuleType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    RateBased,
    #[allow(missing_docs)] // documentation missing in model
    Regular,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WafRuleType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => WafRuleType::Group,
            "RATE_BASED" => WafRuleType::RateBased,
            "REGULAR" => WafRuleType::Regular,
            other => WafRuleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WafRuleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WafRuleType::from(s))
    }
}
impl WafRuleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WafRuleType::Group => "GROUP",
            WafRuleType::RateBased => "RATE_BASED",
            WafRuleType::Regular => "REGULAR",
            WafRuleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "RATE_BASED", "REGULAR"]
    }
}
impl AsRef<str> for WafRuleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The action to take if any rule within the <code>RuleGroup</code> matches a request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafOverrideAction {
    /// <p> <code>COUNT</code> overrides the action specified by the individual rule within a <code>RuleGroup</code> . If set to <code>NONE</code>, the rule's action will take place.</p>
    pub r#type: std::option::Option<crate::model::WafOverrideActionType>,
}
impl WafOverrideAction {
    /// <p> <code>COUNT</code> overrides the action specified by the individual rule within a <code>RuleGroup</code> . If set to <code>NONE</code>, the rule's action will take place.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WafOverrideActionType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for WafOverrideAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafOverrideAction");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`WafOverrideAction`](crate::model::WafOverrideAction)
pub mod waf_override_action {
    /// A builder for [`WafOverrideAction`](crate::model::WafOverrideAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WafOverrideActionType>,
    }
    impl Builder {
        /// <p> <code>COUNT</code> overrides the action specified by the individual rule within a <code>RuleGroup</code> . If set to <code>NONE</code>, the rule's action will take place.</p>
        pub fn r#type(mut self, input: crate::model::WafOverrideActionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> <code>COUNT</code> overrides the action specified by the individual rule within a <code>RuleGroup</code> . If set to <code>NONE</code>, the rule's action will take place.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WafOverrideActionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`WafOverrideAction`](crate::model::WafOverrideAction)
        pub fn build(self) -> crate::model::WafOverrideAction {
            crate::model::WafOverrideAction {
                r#type: self.r#type,
            }
        }
    }
}
impl WafOverrideAction {
    /// Creates a new builder-style object to manufacture [`WafOverrideAction`](crate::model::WafOverrideAction)
    pub fn builder() -> crate::model::waf_override_action::Builder {
        crate::model::waf_override_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WafOverrideActionType {
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WafOverrideActionType {
    fn from(s: &str) -> Self {
        match s {
            "COUNT" => WafOverrideActionType::Count,
            "NONE" => WafOverrideActionType::None,
            other => WafOverrideActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WafOverrideActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WafOverrideActionType::from(s))
    }
}
impl WafOverrideActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WafOverrideActionType::Count => "COUNT",
            WafOverrideActionType::None => "NONE",
            WafOverrideActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COUNT", "NONE"]
    }
}
impl AsRef<str> for WafOverrideActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the part of a web request that you want to inspect for snippets of malicious SQL code and indicates whether you want to add the specification to a <code>SqlInjectionMatchSet</code> or delete it from a <code>SqlInjectionMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlInjectionMatchSetUpdate {
    /// <p>Specify <code>INSERT</code> to add a <code>SqlInjectionMatchSetUpdate</code> to a <code>SqlInjectionMatchSet</code>. Use <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.</p>
    pub sql_injection_match_tuple: std::option::Option<crate::model::SqlInjectionMatchTuple>,
}
impl SqlInjectionMatchSetUpdate {
    /// <p>Specify <code>INSERT</code> to add a <code>SqlInjectionMatchSetUpdate</code> to a <code>SqlInjectionMatchSet</code>. Use <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.</p>
    pub fn sql_injection_match_tuple(
        &self,
    ) -> std::option::Option<&crate::model::SqlInjectionMatchTuple> {
        self.sql_injection_match_tuple.as_ref()
    }
}
impl std::fmt::Debug for SqlInjectionMatchSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlInjectionMatchSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("sql_injection_match_tuple", &self.sql_injection_match_tuple);
        formatter.finish()
    }
}
/// See [`SqlInjectionMatchSetUpdate`](crate::model::SqlInjectionMatchSetUpdate)
pub mod sql_injection_match_set_update {
    /// A builder for [`SqlInjectionMatchSetUpdate`](crate::model::SqlInjectionMatchSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) sql_injection_match_tuple:
            std::option::Option<crate::model::SqlInjectionMatchTuple>,
    }
    impl Builder {
        /// <p>Specify <code>INSERT</code> to add a <code>SqlInjectionMatchSetUpdate</code> to a <code>SqlInjectionMatchSet</code>. Use <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specify <code>INSERT</code> to add a <code>SqlInjectionMatchSetUpdate</code> to a <code>SqlInjectionMatchSet</code>. Use <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.</p>
        pub fn sql_injection_match_tuple(
            mut self,
            input: crate::model::SqlInjectionMatchTuple,
        ) -> Self {
            self.sql_injection_match_tuple = Some(input);
            self
        }
        /// <p>Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.</p>
        pub fn set_sql_injection_match_tuple(
            mut self,
            input: std::option::Option<crate::model::SqlInjectionMatchTuple>,
        ) -> Self {
            self.sql_injection_match_tuple = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlInjectionMatchSetUpdate`](crate::model::SqlInjectionMatchSetUpdate)
        pub fn build(self) -> crate::model::SqlInjectionMatchSetUpdate {
            crate::model::SqlInjectionMatchSetUpdate {
                action: self.action,
                sql_injection_match_tuple: self.sql_injection_match_tuple,
            }
        }
    }
}
impl SqlInjectionMatchSetUpdate {
    /// Creates a new builder-style object to manufacture [`SqlInjectionMatchSetUpdate`](crate::model::SqlInjectionMatchSetUpdate)
    pub fn builder() -> crate::model::sql_injection_match_set_update::Builder {
        crate::model::sql_injection_match_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlInjectionMatchTuple {
    /// <p>Specifies where in a web request to look for snippets of malicious SQL code.</p>
    pub field_to_match: std::option::Option<crate::model::FieldToMatch>,
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub text_transformation: std::option::Option<crate::model::TextTransformation>,
}
impl SqlInjectionMatchTuple {
    /// <p>Specifies where in a web request to look for snippets of malicious SQL code.</p>
    pub fn field_to_match(&self) -> std::option::Option<&crate::model::FieldToMatch> {
        self.field_to_match.as_ref()
    }
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub fn text_transformation(&self) -> std::option::Option<&crate::model::TextTransformation> {
        self.text_transformation.as_ref()
    }
}
impl std::fmt::Debug for SqlInjectionMatchTuple {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlInjectionMatchTuple");
        formatter.field("field_to_match", &self.field_to_match);
        formatter.field("text_transformation", &self.text_transformation);
        formatter.finish()
    }
}
/// See [`SqlInjectionMatchTuple`](crate::model::SqlInjectionMatchTuple)
pub mod sql_injection_match_tuple {
    /// A builder for [`SqlInjectionMatchTuple`](crate::model::SqlInjectionMatchTuple)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_to_match: std::option::Option<crate::model::FieldToMatch>,
        pub(crate) text_transformation: std::option::Option<crate::model::TextTransformation>,
    }
    impl Builder {
        /// <p>Specifies where in a web request to look for snippets of malicious SQL code.</p>
        pub fn field_to_match(mut self, input: crate::model::FieldToMatch) -> Self {
            self.field_to_match = Some(input);
            self
        }
        /// <p>Specifies where in a web request to look for snippets of malicious SQL code.</p>
        pub fn set_field_to_match(
            mut self,
            input: std::option::Option<crate::model::FieldToMatch>,
        ) -> Self {
            self.field_to_match = input;
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn text_transformation(mut self, input: crate::model::TextTransformation) -> Self {
            self.text_transformation = Some(input);
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn set_text_transformation(
            mut self,
            input: std::option::Option<crate::model::TextTransformation>,
        ) -> Self {
            self.text_transformation = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlInjectionMatchTuple`](crate::model::SqlInjectionMatchTuple)
        pub fn build(self) -> crate::model::SqlInjectionMatchTuple {
            crate::model::SqlInjectionMatchTuple {
                field_to_match: self.field_to_match,
                text_transformation: self.text_transformation,
            }
        }
    }
}
impl SqlInjectionMatchTuple {
    /// Creates a new builder-style object to manufacture [`SqlInjectionMatchTuple`](crate::model::SqlInjectionMatchTuple)
    pub fn builder() -> crate::model::sql_injection_match_tuple::Builder {
        crate::model::sql_injection_match_tuple::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the part of a web request that you want to inspect the size of and indicates whether you want to add the specification to a <code>SizeConstraintSet</code> or delete it from a <code>SizeConstraintSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SizeConstraintSetUpdate {
    /// <p>Specify <code>INSERT</code> to add a <code>SizeConstraintSetUpdate</code> to a <code>SizeConstraintSet</code>. Use <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>, <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
    pub size_constraint: std::option::Option<crate::model::SizeConstraint>,
}
impl SizeConstraintSetUpdate {
    /// <p>Specify <code>INSERT</code> to add a <code>SizeConstraintSetUpdate</code> to a <code>SizeConstraintSet</code>. Use <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>, <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
    pub fn size_constraint(&self) -> std::option::Option<&crate::model::SizeConstraint> {
        self.size_constraint.as_ref()
    }
}
impl std::fmt::Debug for SizeConstraintSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SizeConstraintSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("size_constraint", &self.size_constraint);
        formatter.finish()
    }
}
/// See [`SizeConstraintSetUpdate`](crate::model::SizeConstraintSetUpdate)
pub mod size_constraint_set_update {
    /// A builder for [`SizeConstraintSetUpdate`](crate::model::SizeConstraintSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) size_constraint: std::option::Option<crate::model::SizeConstraint>,
    }
    impl Builder {
        /// <p>Specify <code>INSERT</code> to add a <code>SizeConstraintSetUpdate</code> to a <code>SizeConstraintSet</code>. Use <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specify <code>INSERT</code> to add a <code>SizeConstraintSetUpdate</code> to a <code>SizeConstraintSet</code>. Use <code>DELETE</code> to remove a <code>SizeConstraintSetUpdate</code> from a <code>SizeConstraintSet</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>, <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
        pub fn size_constraint(mut self, input: crate::model::SizeConstraint) -> Self {
            self.size_constraint = Some(input);
            self
        }
        /// <p>Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>, <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
        pub fn set_size_constraint(
            mut self,
            input: std::option::Option<crate::model::SizeConstraint>,
        ) -> Self {
            self.size_constraint = input;
            self
        }
        /// Consumes the builder and constructs a [`SizeConstraintSetUpdate`](crate::model::SizeConstraintSetUpdate)
        pub fn build(self) -> crate::model::SizeConstraintSetUpdate {
            crate::model::SizeConstraintSetUpdate {
                action: self.action,
                size_constraint: self.size_constraint,
            }
        }
    }
}
impl SizeConstraintSetUpdate {
    /// Creates a new builder-style object to manufacture [`SizeConstraintSetUpdate`](crate::model::SizeConstraintSetUpdate)
    pub fn builder() -> crate::model::size_constraint_set_update::Builder {
        crate::model::size_constraint_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies a constraint on the size of a part of the web request. AWS WAF uses the <code>Size</code>, <code>ComparisonOperator</code>, and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SizeConstraint {
    /// <p>Specifies where in a web request to look for the size constraint.</p>
    pub field_to_match: std::option::Option<crate::model::FieldToMatch>,
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p>Note that if you choose <code>BODY</code> for the value of <code>Type</code>, you must choose <code>NONE</code> for <code>TextTransformation</code> because CloudFront forwards only the first 8192 bytes for inspection. </p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    pub text_transformation: std::option::Option<crate::model::TextTransformation>,
    /// <p>The type of comparison you want AWS WAF to perform. AWS WAF uses this in combination with the provided <code>Size</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
    /// <p> <b>EQ</b>: Used to test if the <code>Size</code> is equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>NE</b>: Used to test if the <code>Size</code> is not equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>LE</b>: Used to test if the <code>Size</code> is less than or equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>LT</b>: Used to test if the <code>Size</code> is strictly less than the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>GE</b>: Used to test if the <code>Size</code> is greater than or equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>GT</b>: Used to test if the <code>Size</code> is strictly greater than the size of the <code>FieldToMatch</code> </p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The size in bytes that you want AWS WAF to compare against the size of the specified <code>FieldToMatch</code>. AWS WAF uses this in combination with <code>ComparisonOperator</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
    /// <p>Valid values for size are 0 - 21474836480 bytes (0 - 20 GB).</p>
    /// <p>If you specify <code>URI</code> for the value of <code>Type</code>, the / in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>
    pub size: i64,
}
impl SizeConstraint {
    /// <p>Specifies where in a web request to look for the size constraint.</p>
    pub fn field_to_match(&self) -> std::option::Option<&crate::model::FieldToMatch> {
        self.field_to_match.as_ref()
    }
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p>Note that if you choose <code>BODY</code> for the value of <code>Type</code>, you must choose <code>NONE</code> for <code>TextTransformation</code> because CloudFront forwards only the first 8192 bytes for inspection. </p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    pub fn text_transformation(&self) -> std::option::Option<&crate::model::TextTransformation> {
        self.text_transformation.as_ref()
    }
    /// <p>The type of comparison you want AWS WAF to perform. AWS WAF uses this in combination with the provided <code>Size</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
    /// <p> <b>EQ</b>: Used to test if the <code>Size</code> is equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>NE</b>: Used to test if the <code>Size</code> is not equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>LE</b>: Used to test if the <code>Size</code> is less than or equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>LT</b>: Used to test if the <code>Size</code> is strictly less than the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>GE</b>: Used to test if the <code>Size</code> is greater than or equal to the size of the <code>FieldToMatch</code> </p>
    /// <p> <b>GT</b>: Used to test if the <code>Size</code> is strictly greater than the size of the <code>FieldToMatch</code> </p>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>The size in bytes that you want AWS WAF to compare against the size of the specified <code>FieldToMatch</code>. AWS WAF uses this in combination with <code>ComparisonOperator</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
    /// <p>Valid values for size are 0 - 21474836480 bytes (0 - 20 GB).</p>
    /// <p>If you specify <code>URI</code> for the value of <code>Type</code>, the / in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
}
impl std::fmt::Debug for SizeConstraint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SizeConstraint");
        formatter.field("field_to_match", &self.field_to_match);
        formatter.field("text_transformation", &self.text_transformation);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`SizeConstraint`](crate::model::SizeConstraint)
pub mod size_constraint {
    /// A builder for [`SizeConstraint`](crate::model::SizeConstraint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_to_match: std::option::Option<crate::model::FieldToMatch>,
        pub(crate) text_transformation: std::option::Option<crate::model::TextTransformation>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies where in a web request to look for the size constraint.</p>
        pub fn field_to_match(mut self, input: crate::model::FieldToMatch) -> Self {
            self.field_to_match = Some(input);
            self
        }
        /// <p>Specifies where in a web request to look for the size constraint.</p>
        pub fn set_field_to_match(
            mut self,
            input: std::option::Option<crate::model::FieldToMatch>,
        ) -> Self {
            self.field_to_match = input;
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p>Note that if you choose <code>BODY</code> for the value of <code>Type</code>, you must choose <code>NONE</code> for <code>TextTransformation</code> because CloudFront forwards only the first 8192 bytes for inspection. </p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        pub fn text_transformation(mut self, input: crate::model::TextTransformation) -> Self {
            self.text_transformation = Some(input);
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p>Note that if you choose <code>BODY</code> for the value of <code>Type</code>, you must choose <code>NONE</code> for <code>TextTransformation</code> because CloudFront forwards only the first 8192 bytes for inspection. </p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        pub fn set_text_transformation(
            mut self,
            input: std::option::Option<crate::model::TextTransformation>,
        ) -> Self {
            self.text_transformation = input;
            self
        }
        /// <p>The type of comparison you want AWS WAF to perform. AWS WAF uses this in combination with the provided <code>Size</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
        /// <p> <b>EQ</b>: Used to test if the <code>Size</code> is equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>NE</b>: Used to test if the <code>Size</code> is not equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>LE</b>: Used to test if the <code>Size</code> is less than or equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>LT</b>: Used to test if the <code>Size</code> is strictly less than the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>GE</b>: Used to test if the <code>Size</code> is greater than or equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>GT</b>: Used to test if the <code>Size</code> is strictly greater than the size of the <code>FieldToMatch</code> </p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>The type of comparison you want AWS WAF to perform. AWS WAF uses this in combination with the provided <code>Size</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
        /// <p> <b>EQ</b>: Used to test if the <code>Size</code> is equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>NE</b>: Used to test if the <code>Size</code> is not equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>LE</b>: Used to test if the <code>Size</code> is less than or equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>LT</b>: Used to test if the <code>Size</code> is strictly less than the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>GE</b>: Used to test if the <code>Size</code> is greater than or equal to the size of the <code>FieldToMatch</code> </p>
        /// <p> <b>GT</b>: Used to test if the <code>Size</code> is strictly greater than the size of the <code>FieldToMatch</code> </p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>The size in bytes that you want AWS WAF to compare against the size of the specified <code>FieldToMatch</code>. AWS WAF uses this in combination with <code>ComparisonOperator</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
        /// <p>Valid values for size are 0 - 21474836480 bytes (0 - 20 GB).</p>
        /// <p>If you specify <code>URI</code> for the value of <code>Type</code>, the / in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size in bytes that you want AWS WAF to compare against the size of the specified <code>FieldToMatch</code>. AWS WAF uses this in combination with <code>ComparisonOperator</code> and <code>FieldToMatch</code> to build an expression in the form of "<code>Size</code> <code>ComparisonOperator</code> size in bytes of <code>FieldToMatch</code>". If that expression is true, the <code>SizeConstraint</code> is considered to match.</p>
        /// <p>Valid values for size are 0 - 21474836480 bytes (0 - 20 GB).</p>
        /// <p>If you specify <code>URI</code> for the value of <code>Type</code>, the / in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`SizeConstraint`](crate::model::SizeConstraint)
        pub fn build(self) -> crate::model::SizeConstraint {
            crate::model::SizeConstraint {
                field_to_match: self.field_to_match,
                text_transformation: self.text_transformation,
                comparison_operator: self.comparison_operator,
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl SizeConstraint {
    /// Creates a new builder-style object to manufacture [`SizeConstraint`](crate::model::SizeConstraint)
    pub fn builder() -> crate::model::size_constraint::Builder {
        crate::model::size_constraint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Le,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "EQ" => ComparisonOperator::Eq,
            "GE" => ComparisonOperator::Ge,
            "GT" => ComparisonOperator::Gt,
            "LE" => ComparisonOperator::Le,
            "LT" => ComparisonOperator::Lt,
            "NE" => ComparisonOperator::Ne,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::Eq => "EQ",
            ComparisonOperator::Ge => "GE",
            ComparisonOperator::Gt => "GT",
            ComparisonOperator::Le => "LE",
            ComparisonOperator::Lt => "LT",
            ComparisonOperator::Ne => "NE",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQ", "GE", "GT", "LE", "LT", "NE"]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies an <code>ActivatedRule</code> and indicates whether you want to add it to a <code>RuleGroup</code> or delete it from a <code>RuleGroup</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupUpdate {
    /// <p>Specify <code>INSERT</code> to add an <code>ActivatedRule</code> to a <code>RuleGroup</code>. Use <code>DELETE</code> to remove an <code>ActivatedRule</code> from a <code>RuleGroup</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The <code>ActivatedRule</code> object specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
    pub activated_rule: std::option::Option<crate::model::ActivatedRule>,
}
impl RuleGroupUpdate {
    /// <p>Specify <code>INSERT</code> to add an <code>ActivatedRule</code> to a <code>RuleGroup</code>. Use <code>DELETE</code> to remove an <code>ActivatedRule</code> from a <code>RuleGroup</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The <code>ActivatedRule</code> object specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
    pub fn activated_rule(&self) -> std::option::Option<&crate::model::ActivatedRule> {
        self.activated_rule.as_ref()
    }
}
impl std::fmt::Debug for RuleGroupUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupUpdate");
        formatter.field("action", &self.action);
        formatter.field("activated_rule", &self.activated_rule);
        formatter.finish()
    }
}
/// See [`RuleGroupUpdate`](crate::model::RuleGroupUpdate)
pub mod rule_group_update {
    /// A builder for [`RuleGroupUpdate`](crate::model::RuleGroupUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) activated_rule: std::option::Option<crate::model::ActivatedRule>,
    }
    impl Builder {
        /// <p>Specify <code>INSERT</code> to add an <code>ActivatedRule</code> to a <code>RuleGroup</code>. Use <code>DELETE</code> to remove an <code>ActivatedRule</code> from a <code>RuleGroup</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specify <code>INSERT</code> to add an <code>ActivatedRule</code> to a <code>RuleGroup</code>. Use <code>DELETE</code> to remove an <code>ActivatedRule</code> from a <code>RuleGroup</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The <code>ActivatedRule</code> object specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
        pub fn activated_rule(mut self, input: crate::model::ActivatedRule) -> Self {
            self.activated_rule = Some(input);
            self
        }
        /// <p>The <code>ActivatedRule</code> object specifies a <code>Rule</code> that you want to insert or delete, the priority of the <code>Rule</code> in the <code>WebACL</code>, and the action that you want AWS WAF to take when a web request matches the <code>Rule</code> (<code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>).</p>
        pub fn set_activated_rule(
            mut self,
            input: std::option::Option<crate::model::ActivatedRule>,
        ) -> Self {
            self.activated_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupUpdate`](crate::model::RuleGroupUpdate)
        pub fn build(self) -> crate::model::RuleGroupUpdate {
            crate::model::RuleGroupUpdate {
                action: self.action,
                activated_rule: self.activated_rule,
            }
        }
    }
}
impl RuleGroupUpdate {
    /// Creates a new builder-style object to manufacture [`RuleGroupUpdate`](crate::model::RuleGroupUpdate)
    pub fn builder() -> crate::model::rule_group_update::Builder {
        crate::model::rule_group_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies a <code>Predicate</code> (such as an <code>IPSet</code>) and indicates whether you want to add it to a <code>Rule</code> or delete it from a <code>Rule</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleUpdate {
    /// <p>Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a <code>Rule</code>.</p>
    pub predicate: std::option::Option<crate::model::Predicate>,
}
impl RuleUpdate {
    /// <p>Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a <code>Rule</code>.</p>
    pub fn predicate(&self) -> std::option::Option<&crate::model::Predicate> {
        self.predicate.as_ref()
    }
}
impl std::fmt::Debug for RuleUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleUpdate");
        formatter.field("action", &self.action);
        formatter.field("predicate", &self.predicate);
        formatter.finish()
    }
}
/// See [`RuleUpdate`](crate::model::RuleUpdate)
pub mod rule_update {
    /// A builder for [`RuleUpdate`](crate::model::RuleUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) predicate: std::option::Option<crate::model::Predicate>,
    }
    impl Builder {
        /// <p>Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specify <code>INSERT</code> to add a <code>Predicate</code> to a <code>Rule</code>. Use <code>DELETE</code> to remove a <code>Predicate</code> from a <code>Rule</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a <code>Rule</code>.</p>
        pub fn predicate(mut self, input: crate::model::Predicate) -> Self {
            self.predicate = Some(input);
            self
        }
        /// <p>The ID of the <code>Predicate</code> (such as an <code>IPSet</code>) that you want to add to a <code>Rule</code>.</p>
        pub fn set_predicate(
            mut self,
            input: std::option::Option<crate::model::Predicate>,
        ) -> Self {
            self.predicate = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleUpdate`](crate::model::RuleUpdate)
        pub fn build(self) -> crate::model::RuleUpdate {
            crate::model::RuleUpdate {
                action: self.action,
                predicate: self.predicate,
            }
        }
    }
}
impl RuleUpdate {
    /// Creates a new builder-style object to manufacture [`RuleUpdate`](crate::model::RuleUpdate)
    pub fn builder() -> crate::model::rule_update::Builder {
        crate::model::rule_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and <code>SizeConstraintSet</code> objects that you want to add to a <code>Rule</code> and, for each object, indicates whether you want to negate the settings, for example, requests that do NOT originate from the IP address 192.0.2.44. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Predicate {
    /// <p>Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block requests based on that IP address.</p>
    /// <p>Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or count requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.</p>
    pub negated: std::option::Option<bool>,
    /// <p>The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.</p>
    pub r#type: std::option::Option<crate::model::PredicateType>,
    /// <p>A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.</p>
    pub data_id: std::option::Option<std::string::String>,
}
impl Predicate {
    /// <p>Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block requests based on that IP address.</p>
    /// <p>Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or count requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.</p>
    pub fn negated(&self) -> std::option::Option<bool> {
        self.negated
    }
    /// <p>The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PredicateType> {
        self.r#type.as_ref()
    }
    /// <p>A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.</p>
    pub fn data_id(&self) -> std::option::Option<&str> {
        self.data_id.as_deref()
    }
}
impl std::fmt::Debug for Predicate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Predicate");
        formatter.field("negated", &self.negated);
        formatter.field("r#type", &self.r#type);
        formatter.field("data_id", &self.data_id);
        formatter.finish()
    }
}
/// See [`Predicate`](crate::model::Predicate)
pub mod predicate {
    /// A builder for [`Predicate`](crate::model::Predicate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) negated: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<crate::model::PredicateType>,
        pub(crate) data_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block requests based on that IP address.</p>
        /// <p>Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or count requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.</p>
        pub fn negated(mut self, input: bool) -> Self {
            self.negated = Some(input);
            self
        }
        /// <p>Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow or block requests based on that IP address.</p>
        /// <p>Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>, <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, or <code>SizeConstraintSet</code>. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code>, AWS WAF will allow, block, or count requests based on all IP addresses <i>except</i> <code>192.0.2.44</code>.</p>
        pub fn set_negated(mut self, input: std::option::Option<bool>) -> Self {
            self.negated = input;
            self
        }
        /// <p>The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.</p>
        pub fn r#type(mut self, input: crate::model::PredicateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of predicate in a <code>Rule</code>, such as <code>ByteMatch</code> or <code>IPSet</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::PredicateType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.</p>
        pub fn data_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a predicate in a <code>Rule</code>, such as <code>ByteMatchSetId</code> or <code>IPSetId</code>. The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.</p>
        pub fn set_data_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Predicate`](crate::model::Predicate)
        pub fn build(self) -> crate::model::Predicate {
            crate::model::Predicate {
                negated: self.negated,
                r#type: self.r#type,
                data_id: self.data_id,
            }
        }
    }
}
impl Predicate {
    /// Creates a new builder-style object to manufacture [`Predicate`](crate::model::Predicate)
    pub fn builder() -> crate::model::predicate::Builder {
        crate::model::predicate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredicateType {
    #[allow(missing_docs)] // documentation missing in model
    ByteMatch,
    #[allow(missing_docs)] // documentation missing in model
    GeoMatch,
    #[allow(missing_docs)] // documentation missing in model
    IpMatch,
    #[allow(missing_docs)] // documentation missing in model
    RegexMatch,
    #[allow(missing_docs)] // documentation missing in model
    SizeConstraint,
    #[allow(missing_docs)] // documentation missing in model
    SqlInjectionMatch,
    #[allow(missing_docs)] // documentation missing in model
    XssMatch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredicateType {
    fn from(s: &str) -> Self {
        match s {
            "ByteMatch" => PredicateType::ByteMatch,
            "GeoMatch" => PredicateType::GeoMatch,
            "IPMatch" => PredicateType::IpMatch,
            "RegexMatch" => PredicateType::RegexMatch,
            "SizeConstraint" => PredicateType::SizeConstraint,
            "SqlInjectionMatch" => PredicateType::SqlInjectionMatch,
            "XssMatch" => PredicateType::XssMatch,
            other => PredicateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredicateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredicateType::from(s))
    }
}
impl PredicateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredicateType::ByteMatch => "ByteMatch",
            PredicateType::GeoMatch => "GeoMatch",
            PredicateType::IpMatch => "IPMatch",
            PredicateType::RegexMatch => "RegexMatch",
            PredicateType::SizeConstraint => "SizeConstraint",
            PredicateType::SqlInjectionMatch => "SqlInjectionMatch",
            PredicateType::XssMatch => "XssMatch",
            PredicateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ByteMatch",
            "GeoMatch",
            "IPMatch",
            "RegexMatch",
            "SizeConstraint",
            "SqlInjectionMatch",
            "XssMatch",
        ]
    }
}
impl AsRef<str> for PredicateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>In an <code>UpdateRegexPatternSet</code> request, <code>RegexPatternSetUpdate</code> specifies whether to insert or delete a <code>RegexPatternString</code> and includes the settings for the <code>RegexPatternString</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexPatternSetUpdate {
    /// <p>Specifies whether to insert or delete a <code>RegexPatternString</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
    pub regex_pattern_string: std::option::Option<std::string::String>,
}
impl RegexPatternSetUpdate {
    /// <p>Specifies whether to insert or delete a <code>RegexPatternString</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
    pub fn regex_pattern_string(&self) -> std::option::Option<&str> {
        self.regex_pattern_string.as_deref()
    }
}
impl std::fmt::Debug for RegexPatternSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexPatternSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("regex_pattern_string", &self.regex_pattern_string);
        formatter.finish()
    }
}
/// See [`RegexPatternSetUpdate`](crate::model::RegexPatternSetUpdate)
pub mod regex_pattern_set_update {
    /// A builder for [`RegexPatternSetUpdate`](crate::model::RegexPatternSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) regex_pattern_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether to insert or delete a <code>RegexPatternString</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether to insert or delete a <code>RegexPatternString</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
        pub fn regex_pattern_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex_pattern_string = Some(input.into());
            self
        }
        /// <p>Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
        pub fn set_regex_pattern_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regex_pattern_string = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexPatternSetUpdate`](crate::model::RegexPatternSetUpdate)
        pub fn build(self) -> crate::model::RegexPatternSetUpdate {
            crate::model::RegexPatternSetUpdate {
                action: self.action,
                regex_pattern_string: self.regex_pattern_string,
            }
        }
    }
}
impl RegexPatternSetUpdate {
    /// Creates a new builder-style object to manufacture [`RegexPatternSetUpdate`](crate::model::RegexPatternSetUpdate)
    pub fn builder() -> crate::model::regex_pattern_set_update::Builder {
        crate::model::regex_pattern_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>In an <code>UpdateRegexMatchSet</code> request, <code>RegexMatchSetUpdate</code> specifies whether to insert or delete a <code>RegexMatchTuple</code> and includes the settings for the <code>RegexMatchTuple</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexMatchSetUpdate {
    /// <p>Specifies whether to insert or delete a <code>RegexMatchTuple</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values in the <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.</p>
    pub regex_match_tuple: std::option::Option<crate::model::RegexMatchTuple>,
}
impl RegexMatchSetUpdate {
    /// <p>Specifies whether to insert or delete a <code>RegexMatchTuple</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values in the <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.</p>
    pub fn regex_match_tuple(&self) -> std::option::Option<&crate::model::RegexMatchTuple> {
        self.regex_match_tuple.as_ref()
    }
}
impl std::fmt::Debug for RegexMatchSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexMatchSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("regex_match_tuple", &self.regex_match_tuple);
        formatter.finish()
    }
}
/// See [`RegexMatchSetUpdate`](crate::model::RegexMatchSetUpdate)
pub mod regex_match_set_update {
    /// A builder for [`RegexMatchSetUpdate`](crate::model::RegexMatchSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) regex_match_tuple: std::option::Option<crate::model::RegexMatchTuple>,
    }
    impl Builder {
        /// <p>Specifies whether to insert or delete a <code>RegexMatchTuple</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether to insert or delete a <code>RegexMatchTuple</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values in the <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.</p>
        pub fn regex_match_tuple(mut self, input: crate::model::RegexMatchTuple) -> Self {
            self.regex_match_tuple = Some(input);
            self
        }
        /// <p>Information about the part of a web request that you want AWS WAF to inspect and the identifier of the regular expression (regex) pattern that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>RegexMatchTuple</code> values must exactly match the values in the <code>RegexMatchTuple</code> that you want to delete from the <code>RegexMatchSet</code>.</p>
        pub fn set_regex_match_tuple(
            mut self,
            input: std::option::Option<crate::model::RegexMatchTuple>,
        ) -> Self {
            self.regex_match_tuple = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexMatchSetUpdate`](crate::model::RegexMatchSetUpdate)
        pub fn build(self) -> crate::model::RegexMatchSetUpdate {
            crate::model::RegexMatchSetUpdate {
                action: self.action,
                regex_match_tuple: self.regex_match_tuple,
            }
        }
    }
}
impl RegexMatchSetUpdate {
    /// Creates a new builder-style object to manufacture [`RegexMatchSetUpdate`](crate::model::RegexMatchSetUpdate)
    pub fn builder() -> crate::model::regex_match_set_update::Builder {
        crate::model::regex_match_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. Each <code>RegexMatchTuple</code> object contains: </p>
/// <ul>
/// <li> <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
/// <li> <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <code>RegexPatternSet</code>. </p> </li>
/// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexMatchTuple {
    /// <p>Specifies where in a web request to look for the <code>RegexPatternSet</code>.</p>
    pub field_to_match: std::option::Option<crate::model::FieldToMatch>,
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>RegexPatternSet</code> before inspecting a request for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system commandline command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub text_transformation: std::option::Option<crate::model::TextTransformation>,
    /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code> (see <code>GetRegexPatternSet</code>), update a <code>RegexPatternSet</code> (see <code>UpdateRegexPatternSet</code>), insert a <code>RegexPatternSet</code> into a <code>RegexMatchSet</code> or delete one from a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), and delete an <code>RegexPatternSet</code> from AWS WAF (see <code>DeleteRegexPatternSet</code>).</p>
    /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    pub regex_pattern_set_id: std::option::Option<std::string::String>,
}
impl RegexMatchTuple {
    /// <p>Specifies where in a web request to look for the <code>RegexPatternSet</code>.</p>
    pub fn field_to_match(&self) -> std::option::Option<&crate::model::FieldToMatch> {
        self.field_to_match.as_ref()
    }
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>RegexPatternSet</code> before inspecting a request for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system commandline command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub fn text_transformation(&self) -> std::option::Option<&crate::model::TextTransformation> {
        self.text_transformation.as_ref()
    }
    /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code> (see <code>GetRegexPatternSet</code>), update a <code>RegexPatternSet</code> (see <code>UpdateRegexPatternSet</code>), insert a <code>RegexPatternSet</code> into a <code>RegexMatchSet</code> or delete one from a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), and delete an <code>RegexPatternSet</code> from AWS WAF (see <code>DeleteRegexPatternSet</code>).</p>
    /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    pub fn regex_pattern_set_id(&self) -> std::option::Option<&str> {
        self.regex_pattern_set_id.as_deref()
    }
}
impl std::fmt::Debug for RegexMatchTuple {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexMatchTuple");
        formatter.field("field_to_match", &self.field_to_match);
        formatter.field("text_transformation", &self.text_transformation);
        formatter.field("regex_pattern_set_id", &self.regex_pattern_set_id);
        formatter.finish()
    }
}
/// See [`RegexMatchTuple`](crate::model::RegexMatchTuple)
pub mod regex_match_tuple {
    /// A builder for [`RegexMatchTuple`](crate::model::RegexMatchTuple)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_to_match: std::option::Option<crate::model::FieldToMatch>,
        pub(crate) text_transformation: std::option::Option<crate::model::TextTransformation>,
        pub(crate) regex_pattern_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies where in a web request to look for the <code>RegexPatternSet</code>.</p>
        pub fn field_to_match(mut self, input: crate::model::FieldToMatch) -> Self {
            self.field_to_match = Some(input);
            self
        }
        /// <p>Specifies where in a web request to look for the <code>RegexPatternSet</code>.</p>
        pub fn set_field_to_match(
            mut self,
            input: std::option::Option<crate::model::FieldToMatch>,
        ) -> Self {
            self.field_to_match = input;
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>RegexPatternSet</code> before inspecting a request for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system commandline command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn text_transformation(mut self, input: crate::model::TextTransformation) -> Self {
            self.text_transformation = Some(input);
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>RegexPatternSet</code> before inspecting a request for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system commandline command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn set_text_transformation(
            mut self,
            input: std::option::Option<crate::model::TextTransformation>,
        ) -> Self {
            self.text_transformation = input;
            self
        }
        /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code> (see <code>GetRegexPatternSet</code>), update a <code>RegexPatternSet</code> (see <code>UpdateRegexPatternSet</code>), insert a <code>RegexPatternSet</code> into a <code>RegexMatchSet</code> or delete one from a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), and delete an <code>RegexPatternSet</code> from AWS WAF (see <code>DeleteRegexPatternSet</code>).</p>
        /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn regex_pattern_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex_pattern_set_id = Some(input.into());
            self
        }
        /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code> (see <code>GetRegexPatternSet</code>), update a <code>RegexPatternSet</code> (see <code>UpdateRegexPatternSet</code>), insert a <code>RegexPatternSet</code> into a <code>RegexMatchSet</code> or delete one from a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), and delete an <code>RegexPatternSet</code> from AWS WAF (see <code>DeleteRegexPatternSet</code>).</p>
        /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regex_pattern_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexMatchTuple`](crate::model::RegexMatchTuple)
        pub fn build(self) -> crate::model::RegexMatchTuple {
            crate::model::RegexMatchTuple {
                field_to_match: self.field_to_match,
                text_transformation: self.text_transformation,
                regex_pattern_set_id: self.regex_pattern_set_id,
            }
        }
    }
}
impl RegexMatchTuple {
    /// Creates a new builder-style object to manufacture [`RegexMatchTuple`](crate::model::RegexMatchTuple)
    pub fn builder() -> crate::model::regex_match_tuple::Builder {
        crate::model::regex_match_tuple::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the type of update to perform to an <code>IPSet</code> with <code>UpdateIPSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpSetUpdate {
    /// <p>Specifies whether to insert or delete an IP address with <code>UpdateIPSet</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from.</p>
    pub ip_set_descriptor: std::option::Option<crate::model::IpSetDescriptor>,
}
impl IpSetUpdate {
    /// <p>Specifies whether to insert or delete an IP address with <code>UpdateIPSet</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from.</p>
    pub fn ip_set_descriptor(&self) -> std::option::Option<&crate::model::IpSetDescriptor> {
        self.ip_set_descriptor.as_ref()
    }
}
impl std::fmt::Debug for IpSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("ip_set_descriptor", &self.ip_set_descriptor);
        formatter.finish()
    }
}
/// See [`IpSetUpdate`](crate::model::IpSetUpdate)
pub mod ip_set_update {
    /// A builder for [`IpSetUpdate`](crate::model::IpSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) ip_set_descriptor: std::option::Option<crate::model::IpSetDescriptor>,
    }
    impl Builder {
        /// <p>Specifies whether to insert or delete an IP address with <code>UpdateIPSet</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether to insert or delete an IP address with <code>UpdateIPSet</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from.</p>
        pub fn ip_set_descriptor(mut self, input: crate::model::IpSetDescriptor) -> Self {
            self.ip_set_descriptor = Some(input);
            self
        }
        /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from.</p>
        pub fn set_ip_set_descriptor(
            mut self,
            input: std::option::Option<crate::model::IpSetDescriptor>,
        ) -> Self {
            self.ip_set_descriptor = input;
            self
        }
        /// Consumes the builder and constructs a [`IpSetUpdate`](crate::model::IpSetUpdate)
        pub fn build(self) -> crate::model::IpSetUpdate {
            crate::model::IpSetUpdate {
                action: self.action,
                ip_set_descriptor: self.ip_set_descriptor,
            }
        }
    }
}
impl IpSetUpdate {
    /// Creates a new builder-style object to manufacture [`IpSetUpdate`](crate::model::IpSetUpdate)
    pub fn builder() -> crate::model::ip_set_update::Builder {
        crate::model::ip_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR format) that web requests originate from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpSetDescriptor {
    /// <p>Specify <code>IPV4</code> or <code>IPV6</code>.</p>
    pub r#type: std::option::Option<crate::model::IpSetDescriptorType>,
    /// <p>Specify an IPv4 address by using CIDR notation. For example:</p>
    /// <ul>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
    /// <p>Specify an IPv6 address by using CIDR notation. For example:</p>
    /// <ul>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
    /// </ul>
    pub value: std::option::Option<std::string::String>,
}
impl IpSetDescriptor {
    /// <p>Specify <code>IPV4</code> or <code>IPV6</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::IpSetDescriptorType> {
        self.r#type.as_ref()
    }
    /// <p>Specify an IPv4 address by using CIDR notation. For example:</p>
    /// <ul>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
    /// </ul>
    /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
    /// <p>Specify an IPv6 address by using CIDR notation. For example:</p>
    /// <ul>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
    /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
    /// </ul>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for IpSetDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpSetDescriptor");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`IpSetDescriptor`](crate::model::IpSetDescriptor)
pub mod ip_set_descriptor {
    /// A builder for [`IpSetDescriptor`](crate::model::IpSetDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::IpSetDescriptorType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify <code>IPV4</code> or <code>IPV6</code>.</p>
        pub fn r#type(mut self, input: crate::model::IpSetDescriptorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specify <code>IPV4</code> or <code>IPV6</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::IpSetDescriptorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specify an IPv4 address by using CIDR notation. For example:</p>
        /// <ul>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        /// <p>Specify an IPv6 address by using CIDR notation. For example:</p>
        /// <ul>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Specify an IPv4 address by using CIDR notation. For example:</p>
        /// <ul>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify <code>192.0.2.44/32</code>.</p> </li>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify <code>192.0.2.0/24</code>.</p> </li>
        /// </ul>
        /// <p>For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
        /// <p>Specify an IPv6 address by using CIDR notation. For example:</p>
        /// <ul>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify <code>1111:0000:0000:0000:0000:0000:0000:0111/128</code>.</p> </li>
        /// <li> <p>To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify <code>1111:0000:0000:0000:0000:0000:0000:0000/64</code>.</p> </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`IpSetDescriptor`](crate::model::IpSetDescriptor)
        pub fn build(self) -> crate::model::IpSetDescriptor {
            crate::model::IpSetDescriptor {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl IpSetDescriptor {
    /// Creates a new builder-style object to manufacture [`IpSetDescriptor`](crate::model::IpSetDescriptor)
    pub fn builder() -> crate::model::ip_set_descriptor::Builder {
        crate::model::ip_set_descriptor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpSetDescriptorType {
    #[allow(missing_docs)] // documentation missing in model
    Ipv4,
    #[allow(missing_docs)] // documentation missing in model
    Ipv6,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpSetDescriptorType {
    fn from(s: &str) -> Self {
        match s {
            "IPV4" => IpSetDescriptorType::Ipv4,
            "IPV6" => IpSetDescriptorType::Ipv6,
            other => IpSetDescriptorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpSetDescriptorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpSetDescriptorType::from(s))
    }
}
impl IpSetDescriptorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpSetDescriptorType::Ipv4 => "IPV4",
            IpSetDescriptorType::Ipv6 => "IPV6",
            IpSetDescriptorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IPV4", "IPV6"]
    }
}
impl AsRef<str> for IpSetDescriptorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Specifies the type of update to perform to an <code>GeoMatchSet</code> with <code>UpdateGeoMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoMatchSetUpdate {
    /// <p>Specifies whether to insert or delete a country with <code>UpdateGeoMatchSet</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>The country from which web requests originate that you want AWS WAF to search for.</p>
    pub geo_match_constraint: std::option::Option<crate::model::GeoMatchConstraint>,
}
impl GeoMatchSetUpdate {
    /// <p>Specifies whether to insert or delete a country with <code>UpdateGeoMatchSet</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>The country from which web requests originate that you want AWS WAF to search for.</p>
    pub fn geo_match_constraint(&self) -> std::option::Option<&crate::model::GeoMatchConstraint> {
        self.geo_match_constraint.as_ref()
    }
}
impl std::fmt::Debug for GeoMatchSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoMatchSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("geo_match_constraint", &self.geo_match_constraint);
        formatter.finish()
    }
}
/// See [`GeoMatchSetUpdate`](crate::model::GeoMatchSetUpdate)
pub mod geo_match_set_update {
    /// A builder for [`GeoMatchSetUpdate`](crate::model::GeoMatchSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) geo_match_constraint: std::option::Option<crate::model::GeoMatchConstraint>,
    }
    impl Builder {
        /// <p>Specifies whether to insert or delete a country with <code>UpdateGeoMatchSet</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether to insert or delete a country with <code>UpdateGeoMatchSet</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The country from which web requests originate that you want AWS WAF to search for.</p>
        pub fn geo_match_constraint(mut self, input: crate::model::GeoMatchConstraint) -> Self {
            self.geo_match_constraint = Some(input);
            self
        }
        /// <p>The country from which web requests originate that you want AWS WAF to search for.</p>
        pub fn set_geo_match_constraint(
            mut self,
            input: std::option::Option<crate::model::GeoMatchConstraint>,
        ) -> Self {
            self.geo_match_constraint = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoMatchSetUpdate`](crate::model::GeoMatchSetUpdate)
        pub fn build(self) -> crate::model::GeoMatchSetUpdate {
            crate::model::GeoMatchSetUpdate {
                action: self.action,
                geo_match_constraint: self.geo_match_constraint,
            }
        }
    }
}
impl GeoMatchSetUpdate {
    /// Creates a new builder-style object to manufacture [`GeoMatchSetUpdate`](crate::model::GeoMatchSetUpdate)
    pub fn builder() -> crate::model::geo_match_set_update::Builder {
        crate::model::geo_match_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The country from which web requests originate that you want AWS WAF to search for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoMatchConstraint {
    /// <p>The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only valid value.</p>
    pub r#type: std::option::Option<crate::model::GeoMatchConstraintType>,
    /// <p>The country that you want AWS WAF to search for.</p>
    pub value: std::option::Option<crate::model::GeoMatchConstraintValue>,
}
impl GeoMatchConstraint {
    /// <p>The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only valid value.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::GeoMatchConstraintType> {
        self.r#type.as_ref()
    }
    /// <p>The country that you want AWS WAF to search for.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::GeoMatchConstraintValue> {
        self.value.as_ref()
    }
}
impl std::fmt::Debug for GeoMatchConstraint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoMatchConstraint");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`GeoMatchConstraint`](crate::model::GeoMatchConstraint)
pub mod geo_match_constraint {
    /// A builder for [`GeoMatchConstraint`](crate::model::GeoMatchConstraint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::GeoMatchConstraintType>,
        pub(crate) value: std::option::Option<crate::model::GeoMatchConstraintValue>,
    }
    impl Builder {
        /// <p>The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only valid value.</p>
        pub fn r#type(mut self, input: crate::model::GeoMatchConstraintType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of geographical area you want AWS WAF to search for. Currently <code>Country</code> is the only valid value.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::GeoMatchConstraintType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The country that you want AWS WAF to search for.</p>
        pub fn value(mut self, input: crate::model::GeoMatchConstraintValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The country that you want AWS WAF to search for.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::GeoMatchConstraintValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoMatchConstraint`](crate::model::GeoMatchConstraint)
        pub fn build(self) -> crate::model::GeoMatchConstraint {
            crate::model::GeoMatchConstraint {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl GeoMatchConstraint {
    /// Creates a new builder-style object to manufacture [`GeoMatchConstraint`](crate::model::GeoMatchConstraint)
    pub fn builder() -> crate::model::geo_match_constraint::Builder {
        crate::model::geo_match_constraint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeoMatchConstraintValue {
    #[allow(missing_docs)] // documentation missing in model
    Ad,
    #[allow(missing_docs)] // documentation missing in model
    Ae,
    #[allow(missing_docs)] // documentation missing in model
    Af,
    #[allow(missing_docs)] // documentation missing in model
    Ag,
    #[allow(missing_docs)] // documentation missing in model
    Ai,
    #[allow(missing_docs)] // documentation missing in model
    Al,
    #[allow(missing_docs)] // documentation missing in model
    Am,
    #[allow(missing_docs)] // documentation missing in model
    Ao,
    #[allow(missing_docs)] // documentation missing in model
    Aq,
    #[allow(missing_docs)] // documentation missing in model
    Ar,
    #[allow(missing_docs)] // documentation missing in model
    As,
    #[allow(missing_docs)] // documentation missing in model
    At,
    #[allow(missing_docs)] // documentation missing in model
    Au,
    #[allow(missing_docs)] // documentation missing in model
    Aw,
    #[allow(missing_docs)] // documentation missing in model
    Ax,
    #[allow(missing_docs)] // documentation missing in model
    Az,
    #[allow(missing_docs)] // documentation missing in model
    Ba,
    #[allow(missing_docs)] // documentation missing in model
    Bb,
    #[allow(missing_docs)] // documentation missing in model
    Bd,
    #[allow(missing_docs)] // documentation missing in model
    Be,
    #[allow(missing_docs)] // documentation missing in model
    Bf,
    #[allow(missing_docs)] // documentation missing in model
    Bg,
    #[allow(missing_docs)] // documentation missing in model
    Bh,
    #[allow(missing_docs)] // documentation missing in model
    Bi,
    #[allow(missing_docs)] // documentation missing in model
    Bj,
    #[allow(missing_docs)] // documentation missing in model
    Bl,
    #[allow(missing_docs)] // documentation missing in model
    Bm,
    #[allow(missing_docs)] // documentation missing in model
    Bn,
    #[allow(missing_docs)] // documentation missing in model
    Bo,
    #[allow(missing_docs)] // documentation missing in model
    Bq,
    #[allow(missing_docs)] // documentation missing in model
    Br,
    #[allow(missing_docs)] // documentation missing in model
    Bs,
    #[allow(missing_docs)] // documentation missing in model
    Bt,
    #[allow(missing_docs)] // documentation missing in model
    Bv,
    #[allow(missing_docs)] // documentation missing in model
    Bw,
    #[allow(missing_docs)] // documentation missing in model
    By,
    #[allow(missing_docs)] // documentation missing in model
    Bz,
    #[allow(missing_docs)] // documentation missing in model
    Ca,
    #[allow(missing_docs)] // documentation missing in model
    Cc,
    #[allow(missing_docs)] // documentation missing in model
    Cd,
    #[allow(missing_docs)] // documentation missing in model
    Cf,
    #[allow(missing_docs)] // documentation missing in model
    Cg,
    #[allow(missing_docs)] // documentation missing in model
    Ch,
    #[allow(missing_docs)] // documentation missing in model
    Ci,
    #[allow(missing_docs)] // documentation missing in model
    Ck,
    #[allow(missing_docs)] // documentation missing in model
    Cl,
    #[allow(missing_docs)] // documentation missing in model
    Cm,
    #[allow(missing_docs)] // documentation missing in model
    Cn,
    #[allow(missing_docs)] // documentation missing in model
    Co,
    #[allow(missing_docs)] // documentation missing in model
    Cr,
    #[allow(missing_docs)] // documentation missing in model
    Cu,
    #[allow(missing_docs)] // documentation missing in model
    Cv,
    #[allow(missing_docs)] // documentation missing in model
    Cw,
    #[allow(missing_docs)] // documentation missing in model
    Cx,
    #[allow(missing_docs)] // documentation missing in model
    Cy,
    #[allow(missing_docs)] // documentation missing in model
    Cz,
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    Dj,
    #[allow(missing_docs)] // documentation missing in model
    Dk,
    #[allow(missing_docs)] // documentation missing in model
    Dm,
    #[allow(missing_docs)] // documentation missing in model
    Do,
    #[allow(missing_docs)] // documentation missing in model
    Dz,
    #[allow(missing_docs)] // documentation missing in model
    Ec,
    #[allow(missing_docs)] // documentation missing in model
    Ee,
    #[allow(missing_docs)] // documentation missing in model
    Eg,
    #[allow(missing_docs)] // documentation missing in model
    Eh,
    #[allow(missing_docs)] // documentation missing in model
    Er,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Et,
    #[allow(missing_docs)] // documentation missing in model
    Fi,
    #[allow(missing_docs)] // documentation missing in model
    Fj,
    #[allow(missing_docs)] // documentation missing in model
    Fk,
    #[allow(missing_docs)] // documentation missing in model
    Fm,
    #[allow(missing_docs)] // documentation missing in model
    Fo,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    Ga,
    #[allow(missing_docs)] // documentation missing in model
    Gb,
    #[allow(missing_docs)] // documentation missing in model
    Gd,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gf,
    #[allow(missing_docs)] // documentation missing in model
    Gg,
    #[allow(missing_docs)] // documentation missing in model
    Gh,
    #[allow(missing_docs)] // documentation missing in model
    Gi,
    #[allow(missing_docs)] // documentation missing in model
    Gl,
    #[allow(missing_docs)] // documentation missing in model
    Gm,
    #[allow(missing_docs)] // documentation missing in model
    Gn,
    #[allow(missing_docs)] // documentation missing in model
    Gp,
    #[allow(missing_docs)] // documentation missing in model
    Gq,
    #[allow(missing_docs)] // documentation missing in model
    Gr,
    #[allow(missing_docs)] // documentation missing in model
    Gs,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Gu,
    #[allow(missing_docs)] // documentation missing in model
    Gw,
    #[allow(missing_docs)] // documentation missing in model
    Gy,
    #[allow(missing_docs)] // documentation missing in model
    Hk,
    #[allow(missing_docs)] // documentation missing in model
    Hm,
    #[allow(missing_docs)] // documentation missing in model
    Hn,
    #[allow(missing_docs)] // documentation missing in model
    Hr,
    #[allow(missing_docs)] // documentation missing in model
    Ht,
    #[allow(missing_docs)] // documentation missing in model
    Hu,
    #[allow(missing_docs)] // documentation missing in model
    Id,
    #[allow(missing_docs)] // documentation missing in model
    Ie,
    #[allow(missing_docs)] // documentation missing in model
    Il,
    #[allow(missing_docs)] // documentation missing in model
    Im,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Io,
    #[allow(missing_docs)] // documentation missing in model
    Iq,
    #[allow(missing_docs)] // documentation missing in model
    Ir,
    #[allow(missing_docs)] // documentation missing in model
    Is,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Je,
    #[allow(missing_docs)] // documentation missing in model
    Jm,
    #[allow(missing_docs)] // documentation missing in model
    Jo,
    #[allow(missing_docs)] // documentation missing in model
    Jp,
    #[allow(missing_docs)] // documentation missing in model
    Ke,
    #[allow(missing_docs)] // documentation missing in model
    Kg,
    #[allow(missing_docs)] // documentation missing in model
    Kh,
    #[allow(missing_docs)] // documentation missing in model
    Ki,
    #[allow(missing_docs)] // documentation missing in model
    Km,
    #[allow(missing_docs)] // documentation missing in model
    Kn,
    #[allow(missing_docs)] // documentation missing in model
    Kp,
    #[allow(missing_docs)] // documentation missing in model
    Kr,
    #[allow(missing_docs)] // documentation missing in model
    Kw,
    #[allow(missing_docs)] // documentation missing in model
    Ky,
    #[allow(missing_docs)] // documentation missing in model
    Kz,
    #[allow(missing_docs)] // documentation missing in model
    La,
    #[allow(missing_docs)] // documentation missing in model
    Lb,
    #[allow(missing_docs)] // documentation missing in model
    Lc,
    #[allow(missing_docs)] // documentation missing in model
    Li,
    #[allow(missing_docs)] // documentation missing in model
    Lk,
    #[allow(missing_docs)] // documentation missing in model
    Lr,
    #[allow(missing_docs)] // documentation missing in model
    Ls,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Lu,
    #[allow(missing_docs)] // documentation missing in model
    Lv,
    #[allow(missing_docs)] // documentation missing in model
    Ly,
    #[allow(missing_docs)] // documentation missing in model
    Ma,
    #[allow(missing_docs)] // documentation missing in model
    Mc,
    #[allow(missing_docs)] // documentation missing in model
    Md,
    #[allow(missing_docs)] // documentation missing in model
    Me,
    #[allow(missing_docs)] // documentation missing in model
    Mf,
    #[allow(missing_docs)] // documentation missing in model
    Mg,
    #[allow(missing_docs)] // documentation missing in model
    Mh,
    #[allow(missing_docs)] // documentation missing in model
    Mk,
    #[allow(missing_docs)] // documentation missing in model
    Ml,
    #[allow(missing_docs)] // documentation missing in model
    Mm,
    #[allow(missing_docs)] // documentation missing in model
    Mn,
    #[allow(missing_docs)] // documentation missing in model
    Mo,
    #[allow(missing_docs)] // documentation missing in model
    Mp,
    #[allow(missing_docs)] // documentation missing in model
    Mq,
    #[allow(missing_docs)] // documentation missing in model
    Mr,
    #[allow(missing_docs)] // documentation missing in model
    Ms,
    #[allow(missing_docs)] // documentation missing in model
    Mt,
    #[allow(missing_docs)] // documentation missing in model
    Mu,
    #[allow(missing_docs)] // documentation missing in model
    Mv,
    #[allow(missing_docs)] // documentation missing in model
    Mw,
    #[allow(missing_docs)] // documentation missing in model
    Mx,
    #[allow(missing_docs)] // documentation missing in model
    My,
    #[allow(missing_docs)] // documentation missing in model
    Mz,
    #[allow(missing_docs)] // documentation missing in model
    Na,
    #[allow(missing_docs)] // documentation missing in model
    Nc,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    #[allow(missing_docs)] // documentation missing in model
    Nf,
    #[allow(missing_docs)] // documentation missing in model
    Ng,
    #[allow(missing_docs)] // documentation missing in model
    Ni,
    #[allow(missing_docs)] // documentation missing in model
    Nl,
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Np,
    #[allow(missing_docs)] // documentation missing in model
    Nr,
    #[allow(missing_docs)] // documentation missing in model
    Nu,
    #[allow(missing_docs)] // documentation missing in model
    Nz,
    #[allow(missing_docs)] // documentation missing in model
    Om,
    #[allow(missing_docs)] // documentation missing in model
    Pa,
    #[allow(missing_docs)] // documentation missing in model
    Pe,
    #[allow(missing_docs)] // documentation missing in model
    Pf,
    #[allow(missing_docs)] // documentation missing in model
    Pg,
    #[allow(missing_docs)] // documentation missing in model
    Ph,
    #[allow(missing_docs)] // documentation missing in model
    Pk,
    #[allow(missing_docs)] // documentation missing in model
    Pl,
    #[allow(missing_docs)] // documentation missing in model
    Pm,
    #[allow(missing_docs)] // documentation missing in model
    Pn,
    #[allow(missing_docs)] // documentation missing in model
    Pr,
    #[allow(missing_docs)] // documentation missing in model
    Ps,
    #[allow(missing_docs)] // documentation missing in model
    Pt,
    #[allow(missing_docs)] // documentation missing in model
    Pw,
    #[allow(missing_docs)] // documentation missing in model
    Py,
    #[allow(missing_docs)] // documentation missing in model
    Qa,
    #[allow(missing_docs)] // documentation missing in model
    Re,
    #[allow(missing_docs)] // documentation missing in model
    Ro,
    #[allow(missing_docs)] // documentation missing in model
    Rs,
    #[allow(missing_docs)] // documentation missing in model
    Ru,
    #[allow(missing_docs)] // documentation missing in model
    Rw,
    #[allow(missing_docs)] // documentation missing in model
    Sa,
    #[allow(missing_docs)] // documentation missing in model
    Sb,
    #[allow(missing_docs)] // documentation missing in model
    Sc,
    #[allow(missing_docs)] // documentation missing in model
    Sd,
    #[allow(missing_docs)] // documentation missing in model
    Se,
    #[allow(missing_docs)] // documentation missing in model
    Sg,
    #[allow(missing_docs)] // documentation missing in model
    Sh,
    #[allow(missing_docs)] // documentation missing in model
    Si,
    #[allow(missing_docs)] // documentation missing in model
    Sj,
    #[allow(missing_docs)] // documentation missing in model
    Sk,
    #[allow(missing_docs)] // documentation missing in model
    Sl,
    #[allow(missing_docs)] // documentation missing in model
    Sm,
    #[allow(missing_docs)] // documentation missing in model
    Sn,
    #[allow(missing_docs)] // documentation missing in model
    So,
    #[allow(missing_docs)] // documentation missing in model
    Sr,
    #[allow(missing_docs)] // documentation missing in model
    Ss,
    #[allow(missing_docs)] // documentation missing in model
    St,
    #[allow(missing_docs)] // documentation missing in model
    Sv,
    #[allow(missing_docs)] // documentation missing in model
    Sx,
    #[allow(missing_docs)] // documentation missing in model
    Sy,
    #[allow(missing_docs)] // documentation missing in model
    Sz,
    #[allow(missing_docs)] // documentation missing in model
    Tc,
    #[allow(missing_docs)] // documentation missing in model
    Td,
    #[allow(missing_docs)] // documentation missing in model
    Tf,
    #[allow(missing_docs)] // documentation missing in model
    Tg,
    #[allow(missing_docs)] // documentation missing in model
    Th,
    #[allow(missing_docs)] // documentation missing in model
    Tj,
    #[allow(missing_docs)] // documentation missing in model
    Tk,
    #[allow(missing_docs)] // documentation missing in model
    Tl,
    #[allow(missing_docs)] // documentation missing in model
    Tm,
    #[allow(missing_docs)] // documentation missing in model
    Tn,
    #[allow(missing_docs)] // documentation missing in model
    To,
    #[allow(missing_docs)] // documentation missing in model
    Tr,
    #[allow(missing_docs)] // documentation missing in model
    Tt,
    #[allow(missing_docs)] // documentation missing in model
    Tv,
    #[allow(missing_docs)] // documentation missing in model
    Tw,
    #[allow(missing_docs)] // documentation missing in model
    Tz,
    #[allow(missing_docs)] // documentation missing in model
    Ua,
    #[allow(missing_docs)] // documentation missing in model
    Ug,
    #[allow(missing_docs)] // documentation missing in model
    Um,
    #[allow(missing_docs)] // documentation missing in model
    Us,
    #[allow(missing_docs)] // documentation missing in model
    Uy,
    #[allow(missing_docs)] // documentation missing in model
    Uz,
    #[allow(missing_docs)] // documentation missing in model
    Va,
    #[allow(missing_docs)] // documentation missing in model
    Vc,
    #[allow(missing_docs)] // documentation missing in model
    Ve,
    #[allow(missing_docs)] // documentation missing in model
    Vg,
    #[allow(missing_docs)] // documentation missing in model
    Vi,
    #[allow(missing_docs)] // documentation missing in model
    Vn,
    #[allow(missing_docs)] // documentation missing in model
    Vu,
    #[allow(missing_docs)] // documentation missing in model
    Wf,
    #[allow(missing_docs)] // documentation missing in model
    Ws,
    #[allow(missing_docs)] // documentation missing in model
    Ye,
    #[allow(missing_docs)] // documentation missing in model
    Yt,
    #[allow(missing_docs)] // documentation missing in model
    Za,
    #[allow(missing_docs)] // documentation missing in model
    Zm,
    #[allow(missing_docs)] // documentation missing in model
    Zw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeoMatchConstraintValue {
    fn from(s: &str) -> Self {
        match s {
            "AD" => GeoMatchConstraintValue::Ad,
            "AE" => GeoMatchConstraintValue::Ae,
            "AF" => GeoMatchConstraintValue::Af,
            "AG" => GeoMatchConstraintValue::Ag,
            "AI" => GeoMatchConstraintValue::Ai,
            "AL" => GeoMatchConstraintValue::Al,
            "AM" => GeoMatchConstraintValue::Am,
            "AO" => GeoMatchConstraintValue::Ao,
            "AQ" => GeoMatchConstraintValue::Aq,
            "AR" => GeoMatchConstraintValue::Ar,
            "AS" => GeoMatchConstraintValue::As,
            "AT" => GeoMatchConstraintValue::At,
            "AU" => GeoMatchConstraintValue::Au,
            "AW" => GeoMatchConstraintValue::Aw,
            "AX" => GeoMatchConstraintValue::Ax,
            "AZ" => GeoMatchConstraintValue::Az,
            "BA" => GeoMatchConstraintValue::Ba,
            "BB" => GeoMatchConstraintValue::Bb,
            "BD" => GeoMatchConstraintValue::Bd,
            "BE" => GeoMatchConstraintValue::Be,
            "BF" => GeoMatchConstraintValue::Bf,
            "BG" => GeoMatchConstraintValue::Bg,
            "BH" => GeoMatchConstraintValue::Bh,
            "BI" => GeoMatchConstraintValue::Bi,
            "BJ" => GeoMatchConstraintValue::Bj,
            "BL" => GeoMatchConstraintValue::Bl,
            "BM" => GeoMatchConstraintValue::Bm,
            "BN" => GeoMatchConstraintValue::Bn,
            "BO" => GeoMatchConstraintValue::Bo,
            "BQ" => GeoMatchConstraintValue::Bq,
            "BR" => GeoMatchConstraintValue::Br,
            "BS" => GeoMatchConstraintValue::Bs,
            "BT" => GeoMatchConstraintValue::Bt,
            "BV" => GeoMatchConstraintValue::Bv,
            "BW" => GeoMatchConstraintValue::Bw,
            "BY" => GeoMatchConstraintValue::By,
            "BZ" => GeoMatchConstraintValue::Bz,
            "CA" => GeoMatchConstraintValue::Ca,
            "CC" => GeoMatchConstraintValue::Cc,
            "CD" => GeoMatchConstraintValue::Cd,
            "CF" => GeoMatchConstraintValue::Cf,
            "CG" => GeoMatchConstraintValue::Cg,
            "CH" => GeoMatchConstraintValue::Ch,
            "CI" => GeoMatchConstraintValue::Ci,
            "CK" => GeoMatchConstraintValue::Ck,
            "CL" => GeoMatchConstraintValue::Cl,
            "CM" => GeoMatchConstraintValue::Cm,
            "CN" => GeoMatchConstraintValue::Cn,
            "CO" => GeoMatchConstraintValue::Co,
            "CR" => GeoMatchConstraintValue::Cr,
            "CU" => GeoMatchConstraintValue::Cu,
            "CV" => GeoMatchConstraintValue::Cv,
            "CW" => GeoMatchConstraintValue::Cw,
            "CX" => GeoMatchConstraintValue::Cx,
            "CY" => GeoMatchConstraintValue::Cy,
            "CZ" => GeoMatchConstraintValue::Cz,
            "DE" => GeoMatchConstraintValue::De,
            "DJ" => GeoMatchConstraintValue::Dj,
            "DK" => GeoMatchConstraintValue::Dk,
            "DM" => GeoMatchConstraintValue::Dm,
            "DO" => GeoMatchConstraintValue::Do,
            "DZ" => GeoMatchConstraintValue::Dz,
            "EC" => GeoMatchConstraintValue::Ec,
            "EE" => GeoMatchConstraintValue::Ee,
            "EG" => GeoMatchConstraintValue::Eg,
            "EH" => GeoMatchConstraintValue::Eh,
            "ER" => GeoMatchConstraintValue::Er,
            "ES" => GeoMatchConstraintValue::Es,
            "ET" => GeoMatchConstraintValue::Et,
            "FI" => GeoMatchConstraintValue::Fi,
            "FJ" => GeoMatchConstraintValue::Fj,
            "FK" => GeoMatchConstraintValue::Fk,
            "FM" => GeoMatchConstraintValue::Fm,
            "FO" => GeoMatchConstraintValue::Fo,
            "FR" => GeoMatchConstraintValue::Fr,
            "GA" => GeoMatchConstraintValue::Ga,
            "GB" => GeoMatchConstraintValue::Gb,
            "GD" => GeoMatchConstraintValue::Gd,
            "GE" => GeoMatchConstraintValue::Ge,
            "GF" => GeoMatchConstraintValue::Gf,
            "GG" => GeoMatchConstraintValue::Gg,
            "GH" => GeoMatchConstraintValue::Gh,
            "GI" => GeoMatchConstraintValue::Gi,
            "GL" => GeoMatchConstraintValue::Gl,
            "GM" => GeoMatchConstraintValue::Gm,
            "GN" => GeoMatchConstraintValue::Gn,
            "GP" => GeoMatchConstraintValue::Gp,
            "GQ" => GeoMatchConstraintValue::Gq,
            "GR" => GeoMatchConstraintValue::Gr,
            "GS" => GeoMatchConstraintValue::Gs,
            "GT" => GeoMatchConstraintValue::Gt,
            "GU" => GeoMatchConstraintValue::Gu,
            "GW" => GeoMatchConstraintValue::Gw,
            "GY" => GeoMatchConstraintValue::Gy,
            "HK" => GeoMatchConstraintValue::Hk,
            "HM" => GeoMatchConstraintValue::Hm,
            "HN" => GeoMatchConstraintValue::Hn,
            "HR" => GeoMatchConstraintValue::Hr,
            "HT" => GeoMatchConstraintValue::Ht,
            "HU" => GeoMatchConstraintValue::Hu,
            "ID" => GeoMatchConstraintValue::Id,
            "IE" => GeoMatchConstraintValue::Ie,
            "IL" => GeoMatchConstraintValue::Il,
            "IM" => GeoMatchConstraintValue::Im,
            "IN" => GeoMatchConstraintValue::In,
            "IO" => GeoMatchConstraintValue::Io,
            "IQ" => GeoMatchConstraintValue::Iq,
            "IR" => GeoMatchConstraintValue::Ir,
            "IS" => GeoMatchConstraintValue::Is,
            "IT" => GeoMatchConstraintValue::It,
            "JE" => GeoMatchConstraintValue::Je,
            "JM" => GeoMatchConstraintValue::Jm,
            "JO" => GeoMatchConstraintValue::Jo,
            "JP" => GeoMatchConstraintValue::Jp,
            "KE" => GeoMatchConstraintValue::Ke,
            "KG" => GeoMatchConstraintValue::Kg,
            "KH" => GeoMatchConstraintValue::Kh,
            "KI" => GeoMatchConstraintValue::Ki,
            "KM" => GeoMatchConstraintValue::Km,
            "KN" => GeoMatchConstraintValue::Kn,
            "KP" => GeoMatchConstraintValue::Kp,
            "KR" => GeoMatchConstraintValue::Kr,
            "KW" => GeoMatchConstraintValue::Kw,
            "KY" => GeoMatchConstraintValue::Ky,
            "KZ" => GeoMatchConstraintValue::Kz,
            "LA" => GeoMatchConstraintValue::La,
            "LB" => GeoMatchConstraintValue::Lb,
            "LC" => GeoMatchConstraintValue::Lc,
            "LI" => GeoMatchConstraintValue::Li,
            "LK" => GeoMatchConstraintValue::Lk,
            "LR" => GeoMatchConstraintValue::Lr,
            "LS" => GeoMatchConstraintValue::Ls,
            "LT" => GeoMatchConstraintValue::Lt,
            "LU" => GeoMatchConstraintValue::Lu,
            "LV" => GeoMatchConstraintValue::Lv,
            "LY" => GeoMatchConstraintValue::Ly,
            "MA" => GeoMatchConstraintValue::Ma,
            "MC" => GeoMatchConstraintValue::Mc,
            "MD" => GeoMatchConstraintValue::Md,
            "ME" => GeoMatchConstraintValue::Me,
            "MF" => GeoMatchConstraintValue::Mf,
            "MG" => GeoMatchConstraintValue::Mg,
            "MH" => GeoMatchConstraintValue::Mh,
            "MK" => GeoMatchConstraintValue::Mk,
            "ML" => GeoMatchConstraintValue::Ml,
            "MM" => GeoMatchConstraintValue::Mm,
            "MN" => GeoMatchConstraintValue::Mn,
            "MO" => GeoMatchConstraintValue::Mo,
            "MP" => GeoMatchConstraintValue::Mp,
            "MQ" => GeoMatchConstraintValue::Mq,
            "MR" => GeoMatchConstraintValue::Mr,
            "MS" => GeoMatchConstraintValue::Ms,
            "MT" => GeoMatchConstraintValue::Mt,
            "MU" => GeoMatchConstraintValue::Mu,
            "MV" => GeoMatchConstraintValue::Mv,
            "MW" => GeoMatchConstraintValue::Mw,
            "MX" => GeoMatchConstraintValue::Mx,
            "MY" => GeoMatchConstraintValue::My,
            "MZ" => GeoMatchConstraintValue::Mz,
            "NA" => GeoMatchConstraintValue::Na,
            "NC" => GeoMatchConstraintValue::Nc,
            "NE" => GeoMatchConstraintValue::Ne,
            "NF" => GeoMatchConstraintValue::Nf,
            "NG" => GeoMatchConstraintValue::Ng,
            "NI" => GeoMatchConstraintValue::Ni,
            "NL" => GeoMatchConstraintValue::Nl,
            "NO" => GeoMatchConstraintValue::No,
            "NP" => GeoMatchConstraintValue::Np,
            "NR" => GeoMatchConstraintValue::Nr,
            "NU" => GeoMatchConstraintValue::Nu,
            "NZ" => GeoMatchConstraintValue::Nz,
            "OM" => GeoMatchConstraintValue::Om,
            "PA" => GeoMatchConstraintValue::Pa,
            "PE" => GeoMatchConstraintValue::Pe,
            "PF" => GeoMatchConstraintValue::Pf,
            "PG" => GeoMatchConstraintValue::Pg,
            "PH" => GeoMatchConstraintValue::Ph,
            "PK" => GeoMatchConstraintValue::Pk,
            "PL" => GeoMatchConstraintValue::Pl,
            "PM" => GeoMatchConstraintValue::Pm,
            "PN" => GeoMatchConstraintValue::Pn,
            "PR" => GeoMatchConstraintValue::Pr,
            "PS" => GeoMatchConstraintValue::Ps,
            "PT" => GeoMatchConstraintValue::Pt,
            "PW" => GeoMatchConstraintValue::Pw,
            "PY" => GeoMatchConstraintValue::Py,
            "QA" => GeoMatchConstraintValue::Qa,
            "RE" => GeoMatchConstraintValue::Re,
            "RO" => GeoMatchConstraintValue::Ro,
            "RS" => GeoMatchConstraintValue::Rs,
            "RU" => GeoMatchConstraintValue::Ru,
            "RW" => GeoMatchConstraintValue::Rw,
            "SA" => GeoMatchConstraintValue::Sa,
            "SB" => GeoMatchConstraintValue::Sb,
            "SC" => GeoMatchConstraintValue::Sc,
            "SD" => GeoMatchConstraintValue::Sd,
            "SE" => GeoMatchConstraintValue::Se,
            "SG" => GeoMatchConstraintValue::Sg,
            "SH" => GeoMatchConstraintValue::Sh,
            "SI" => GeoMatchConstraintValue::Si,
            "SJ" => GeoMatchConstraintValue::Sj,
            "SK" => GeoMatchConstraintValue::Sk,
            "SL" => GeoMatchConstraintValue::Sl,
            "SM" => GeoMatchConstraintValue::Sm,
            "SN" => GeoMatchConstraintValue::Sn,
            "SO" => GeoMatchConstraintValue::So,
            "SR" => GeoMatchConstraintValue::Sr,
            "SS" => GeoMatchConstraintValue::Ss,
            "ST" => GeoMatchConstraintValue::St,
            "SV" => GeoMatchConstraintValue::Sv,
            "SX" => GeoMatchConstraintValue::Sx,
            "SY" => GeoMatchConstraintValue::Sy,
            "SZ" => GeoMatchConstraintValue::Sz,
            "TC" => GeoMatchConstraintValue::Tc,
            "TD" => GeoMatchConstraintValue::Td,
            "TF" => GeoMatchConstraintValue::Tf,
            "TG" => GeoMatchConstraintValue::Tg,
            "TH" => GeoMatchConstraintValue::Th,
            "TJ" => GeoMatchConstraintValue::Tj,
            "TK" => GeoMatchConstraintValue::Tk,
            "TL" => GeoMatchConstraintValue::Tl,
            "TM" => GeoMatchConstraintValue::Tm,
            "TN" => GeoMatchConstraintValue::Tn,
            "TO" => GeoMatchConstraintValue::To,
            "TR" => GeoMatchConstraintValue::Tr,
            "TT" => GeoMatchConstraintValue::Tt,
            "TV" => GeoMatchConstraintValue::Tv,
            "TW" => GeoMatchConstraintValue::Tw,
            "TZ" => GeoMatchConstraintValue::Tz,
            "UA" => GeoMatchConstraintValue::Ua,
            "UG" => GeoMatchConstraintValue::Ug,
            "UM" => GeoMatchConstraintValue::Um,
            "US" => GeoMatchConstraintValue::Us,
            "UY" => GeoMatchConstraintValue::Uy,
            "UZ" => GeoMatchConstraintValue::Uz,
            "VA" => GeoMatchConstraintValue::Va,
            "VC" => GeoMatchConstraintValue::Vc,
            "VE" => GeoMatchConstraintValue::Ve,
            "VG" => GeoMatchConstraintValue::Vg,
            "VI" => GeoMatchConstraintValue::Vi,
            "VN" => GeoMatchConstraintValue::Vn,
            "VU" => GeoMatchConstraintValue::Vu,
            "WF" => GeoMatchConstraintValue::Wf,
            "WS" => GeoMatchConstraintValue::Ws,
            "YE" => GeoMatchConstraintValue::Ye,
            "YT" => GeoMatchConstraintValue::Yt,
            "ZA" => GeoMatchConstraintValue::Za,
            "ZM" => GeoMatchConstraintValue::Zm,
            "ZW" => GeoMatchConstraintValue::Zw,
            other => GeoMatchConstraintValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeoMatchConstraintValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeoMatchConstraintValue::from(s))
    }
}
impl GeoMatchConstraintValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeoMatchConstraintValue::Ad => "AD",
            GeoMatchConstraintValue::Ae => "AE",
            GeoMatchConstraintValue::Af => "AF",
            GeoMatchConstraintValue::Ag => "AG",
            GeoMatchConstraintValue::Ai => "AI",
            GeoMatchConstraintValue::Al => "AL",
            GeoMatchConstraintValue::Am => "AM",
            GeoMatchConstraintValue::Ao => "AO",
            GeoMatchConstraintValue::Aq => "AQ",
            GeoMatchConstraintValue::Ar => "AR",
            GeoMatchConstraintValue::As => "AS",
            GeoMatchConstraintValue::At => "AT",
            GeoMatchConstraintValue::Au => "AU",
            GeoMatchConstraintValue::Aw => "AW",
            GeoMatchConstraintValue::Ax => "AX",
            GeoMatchConstraintValue::Az => "AZ",
            GeoMatchConstraintValue::Ba => "BA",
            GeoMatchConstraintValue::Bb => "BB",
            GeoMatchConstraintValue::Bd => "BD",
            GeoMatchConstraintValue::Be => "BE",
            GeoMatchConstraintValue::Bf => "BF",
            GeoMatchConstraintValue::Bg => "BG",
            GeoMatchConstraintValue::Bh => "BH",
            GeoMatchConstraintValue::Bi => "BI",
            GeoMatchConstraintValue::Bj => "BJ",
            GeoMatchConstraintValue::Bl => "BL",
            GeoMatchConstraintValue::Bm => "BM",
            GeoMatchConstraintValue::Bn => "BN",
            GeoMatchConstraintValue::Bo => "BO",
            GeoMatchConstraintValue::Bq => "BQ",
            GeoMatchConstraintValue::Br => "BR",
            GeoMatchConstraintValue::Bs => "BS",
            GeoMatchConstraintValue::Bt => "BT",
            GeoMatchConstraintValue::Bv => "BV",
            GeoMatchConstraintValue::Bw => "BW",
            GeoMatchConstraintValue::By => "BY",
            GeoMatchConstraintValue::Bz => "BZ",
            GeoMatchConstraintValue::Ca => "CA",
            GeoMatchConstraintValue::Cc => "CC",
            GeoMatchConstraintValue::Cd => "CD",
            GeoMatchConstraintValue::Cf => "CF",
            GeoMatchConstraintValue::Cg => "CG",
            GeoMatchConstraintValue::Ch => "CH",
            GeoMatchConstraintValue::Ci => "CI",
            GeoMatchConstraintValue::Ck => "CK",
            GeoMatchConstraintValue::Cl => "CL",
            GeoMatchConstraintValue::Cm => "CM",
            GeoMatchConstraintValue::Cn => "CN",
            GeoMatchConstraintValue::Co => "CO",
            GeoMatchConstraintValue::Cr => "CR",
            GeoMatchConstraintValue::Cu => "CU",
            GeoMatchConstraintValue::Cv => "CV",
            GeoMatchConstraintValue::Cw => "CW",
            GeoMatchConstraintValue::Cx => "CX",
            GeoMatchConstraintValue::Cy => "CY",
            GeoMatchConstraintValue::Cz => "CZ",
            GeoMatchConstraintValue::De => "DE",
            GeoMatchConstraintValue::Dj => "DJ",
            GeoMatchConstraintValue::Dk => "DK",
            GeoMatchConstraintValue::Dm => "DM",
            GeoMatchConstraintValue::Do => "DO",
            GeoMatchConstraintValue::Dz => "DZ",
            GeoMatchConstraintValue::Ec => "EC",
            GeoMatchConstraintValue::Ee => "EE",
            GeoMatchConstraintValue::Eg => "EG",
            GeoMatchConstraintValue::Eh => "EH",
            GeoMatchConstraintValue::Er => "ER",
            GeoMatchConstraintValue::Es => "ES",
            GeoMatchConstraintValue::Et => "ET",
            GeoMatchConstraintValue::Fi => "FI",
            GeoMatchConstraintValue::Fj => "FJ",
            GeoMatchConstraintValue::Fk => "FK",
            GeoMatchConstraintValue::Fm => "FM",
            GeoMatchConstraintValue::Fo => "FO",
            GeoMatchConstraintValue::Fr => "FR",
            GeoMatchConstraintValue::Ga => "GA",
            GeoMatchConstraintValue::Gb => "GB",
            GeoMatchConstraintValue::Gd => "GD",
            GeoMatchConstraintValue::Ge => "GE",
            GeoMatchConstraintValue::Gf => "GF",
            GeoMatchConstraintValue::Gg => "GG",
            GeoMatchConstraintValue::Gh => "GH",
            GeoMatchConstraintValue::Gi => "GI",
            GeoMatchConstraintValue::Gl => "GL",
            GeoMatchConstraintValue::Gm => "GM",
            GeoMatchConstraintValue::Gn => "GN",
            GeoMatchConstraintValue::Gp => "GP",
            GeoMatchConstraintValue::Gq => "GQ",
            GeoMatchConstraintValue::Gr => "GR",
            GeoMatchConstraintValue::Gs => "GS",
            GeoMatchConstraintValue::Gt => "GT",
            GeoMatchConstraintValue::Gu => "GU",
            GeoMatchConstraintValue::Gw => "GW",
            GeoMatchConstraintValue::Gy => "GY",
            GeoMatchConstraintValue::Hk => "HK",
            GeoMatchConstraintValue::Hm => "HM",
            GeoMatchConstraintValue::Hn => "HN",
            GeoMatchConstraintValue::Hr => "HR",
            GeoMatchConstraintValue::Ht => "HT",
            GeoMatchConstraintValue::Hu => "HU",
            GeoMatchConstraintValue::Id => "ID",
            GeoMatchConstraintValue::Ie => "IE",
            GeoMatchConstraintValue::Il => "IL",
            GeoMatchConstraintValue::Im => "IM",
            GeoMatchConstraintValue::In => "IN",
            GeoMatchConstraintValue::Io => "IO",
            GeoMatchConstraintValue::Iq => "IQ",
            GeoMatchConstraintValue::Ir => "IR",
            GeoMatchConstraintValue::Is => "IS",
            GeoMatchConstraintValue::It => "IT",
            GeoMatchConstraintValue::Je => "JE",
            GeoMatchConstraintValue::Jm => "JM",
            GeoMatchConstraintValue::Jo => "JO",
            GeoMatchConstraintValue::Jp => "JP",
            GeoMatchConstraintValue::Ke => "KE",
            GeoMatchConstraintValue::Kg => "KG",
            GeoMatchConstraintValue::Kh => "KH",
            GeoMatchConstraintValue::Ki => "KI",
            GeoMatchConstraintValue::Km => "KM",
            GeoMatchConstraintValue::Kn => "KN",
            GeoMatchConstraintValue::Kp => "KP",
            GeoMatchConstraintValue::Kr => "KR",
            GeoMatchConstraintValue::Kw => "KW",
            GeoMatchConstraintValue::Ky => "KY",
            GeoMatchConstraintValue::Kz => "KZ",
            GeoMatchConstraintValue::La => "LA",
            GeoMatchConstraintValue::Lb => "LB",
            GeoMatchConstraintValue::Lc => "LC",
            GeoMatchConstraintValue::Li => "LI",
            GeoMatchConstraintValue::Lk => "LK",
            GeoMatchConstraintValue::Lr => "LR",
            GeoMatchConstraintValue::Ls => "LS",
            GeoMatchConstraintValue::Lt => "LT",
            GeoMatchConstraintValue::Lu => "LU",
            GeoMatchConstraintValue::Lv => "LV",
            GeoMatchConstraintValue::Ly => "LY",
            GeoMatchConstraintValue::Ma => "MA",
            GeoMatchConstraintValue::Mc => "MC",
            GeoMatchConstraintValue::Md => "MD",
            GeoMatchConstraintValue::Me => "ME",
            GeoMatchConstraintValue::Mf => "MF",
            GeoMatchConstraintValue::Mg => "MG",
            GeoMatchConstraintValue::Mh => "MH",
            GeoMatchConstraintValue::Mk => "MK",
            GeoMatchConstraintValue::Ml => "ML",
            GeoMatchConstraintValue::Mm => "MM",
            GeoMatchConstraintValue::Mn => "MN",
            GeoMatchConstraintValue::Mo => "MO",
            GeoMatchConstraintValue::Mp => "MP",
            GeoMatchConstraintValue::Mq => "MQ",
            GeoMatchConstraintValue::Mr => "MR",
            GeoMatchConstraintValue::Ms => "MS",
            GeoMatchConstraintValue::Mt => "MT",
            GeoMatchConstraintValue::Mu => "MU",
            GeoMatchConstraintValue::Mv => "MV",
            GeoMatchConstraintValue::Mw => "MW",
            GeoMatchConstraintValue::Mx => "MX",
            GeoMatchConstraintValue::My => "MY",
            GeoMatchConstraintValue::Mz => "MZ",
            GeoMatchConstraintValue::Na => "NA",
            GeoMatchConstraintValue::Nc => "NC",
            GeoMatchConstraintValue::Ne => "NE",
            GeoMatchConstraintValue::Nf => "NF",
            GeoMatchConstraintValue::Ng => "NG",
            GeoMatchConstraintValue::Ni => "NI",
            GeoMatchConstraintValue::Nl => "NL",
            GeoMatchConstraintValue::No => "NO",
            GeoMatchConstraintValue::Np => "NP",
            GeoMatchConstraintValue::Nr => "NR",
            GeoMatchConstraintValue::Nu => "NU",
            GeoMatchConstraintValue::Nz => "NZ",
            GeoMatchConstraintValue::Om => "OM",
            GeoMatchConstraintValue::Pa => "PA",
            GeoMatchConstraintValue::Pe => "PE",
            GeoMatchConstraintValue::Pf => "PF",
            GeoMatchConstraintValue::Pg => "PG",
            GeoMatchConstraintValue::Ph => "PH",
            GeoMatchConstraintValue::Pk => "PK",
            GeoMatchConstraintValue::Pl => "PL",
            GeoMatchConstraintValue::Pm => "PM",
            GeoMatchConstraintValue::Pn => "PN",
            GeoMatchConstraintValue::Pr => "PR",
            GeoMatchConstraintValue::Ps => "PS",
            GeoMatchConstraintValue::Pt => "PT",
            GeoMatchConstraintValue::Pw => "PW",
            GeoMatchConstraintValue::Py => "PY",
            GeoMatchConstraintValue::Qa => "QA",
            GeoMatchConstraintValue::Re => "RE",
            GeoMatchConstraintValue::Ro => "RO",
            GeoMatchConstraintValue::Rs => "RS",
            GeoMatchConstraintValue::Ru => "RU",
            GeoMatchConstraintValue::Rw => "RW",
            GeoMatchConstraintValue::Sa => "SA",
            GeoMatchConstraintValue::Sb => "SB",
            GeoMatchConstraintValue::Sc => "SC",
            GeoMatchConstraintValue::Sd => "SD",
            GeoMatchConstraintValue::Se => "SE",
            GeoMatchConstraintValue::Sg => "SG",
            GeoMatchConstraintValue::Sh => "SH",
            GeoMatchConstraintValue::Si => "SI",
            GeoMatchConstraintValue::Sj => "SJ",
            GeoMatchConstraintValue::Sk => "SK",
            GeoMatchConstraintValue::Sl => "SL",
            GeoMatchConstraintValue::Sm => "SM",
            GeoMatchConstraintValue::Sn => "SN",
            GeoMatchConstraintValue::So => "SO",
            GeoMatchConstraintValue::Sr => "SR",
            GeoMatchConstraintValue::Ss => "SS",
            GeoMatchConstraintValue::St => "ST",
            GeoMatchConstraintValue::Sv => "SV",
            GeoMatchConstraintValue::Sx => "SX",
            GeoMatchConstraintValue::Sy => "SY",
            GeoMatchConstraintValue::Sz => "SZ",
            GeoMatchConstraintValue::Tc => "TC",
            GeoMatchConstraintValue::Td => "TD",
            GeoMatchConstraintValue::Tf => "TF",
            GeoMatchConstraintValue::Tg => "TG",
            GeoMatchConstraintValue::Th => "TH",
            GeoMatchConstraintValue::Tj => "TJ",
            GeoMatchConstraintValue::Tk => "TK",
            GeoMatchConstraintValue::Tl => "TL",
            GeoMatchConstraintValue::Tm => "TM",
            GeoMatchConstraintValue::Tn => "TN",
            GeoMatchConstraintValue::To => "TO",
            GeoMatchConstraintValue::Tr => "TR",
            GeoMatchConstraintValue::Tt => "TT",
            GeoMatchConstraintValue::Tv => "TV",
            GeoMatchConstraintValue::Tw => "TW",
            GeoMatchConstraintValue::Tz => "TZ",
            GeoMatchConstraintValue::Ua => "UA",
            GeoMatchConstraintValue::Ug => "UG",
            GeoMatchConstraintValue::Um => "UM",
            GeoMatchConstraintValue::Us => "US",
            GeoMatchConstraintValue::Uy => "UY",
            GeoMatchConstraintValue::Uz => "UZ",
            GeoMatchConstraintValue::Va => "VA",
            GeoMatchConstraintValue::Vc => "VC",
            GeoMatchConstraintValue::Ve => "VE",
            GeoMatchConstraintValue::Vg => "VG",
            GeoMatchConstraintValue::Vi => "VI",
            GeoMatchConstraintValue::Vn => "VN",
            GeoMatchConstraintValue::Vu => "VU",
            GeoMatchConstraintValue::Wf => "WF",
            GeoMatchConstraintValue::Ws => "WS",
            GeoMatchConstraintValue::Ye => "YE",
            GeoMatchConstraintValue::Yt => "YT",
            GeoMatchConstraintValue::Za => "ZA",
            GeoMatchConstraintValue::Zm => "ZM",
            GeoMatchConstraintValue::Zw => "ZW",
            GeoMatchConstraintValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW",
            "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN",
            "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG",
            "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX", "CY", "CZ",
            "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI",
            "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL",
            "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR",
            "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM",
            "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA",
            "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME",
            "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU",
            "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP",
            "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR",
            "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD",
            "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV",
            "SX", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO",
            "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE",
            "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW",
        ]
    }
}
impl AsRef<str> for GeoMatchConstraintValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeoMatchConstraintType {
    #[allow(missing_docs)] // documentation missing in model
    Country,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeoMatchConstraintType {
    fn from(s: &str) -> Self {
        match s {
            "Country" => GeoMatchConstraintType::Country,
            other => GeoMatchConstraintType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeoMatchConstraintType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeoMatchConstraintType::from(s))
    }
}
impl GeoMatchConstraintType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeoMatchConstraintType::Country => "Country",
            GeoMatchConstraintType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Country"]
    }
}
impl AsRef<str> for GeoMatchConstraintType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>In an <code>UpdateByteMatchSet</code> request, <code>ByteMatchSetUpdate</code> specifies whether to insert or delete a <code>ByteMatchTuple</code> and includes the settings for the <code>ByteMatchTuple</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByteMatchSetUpdate {
    /// <p>Specifies whether to insert or delete a <code>ByteMatchTuple</code>.</p>
    pub action: std::option::Option<crate::model::ChangeAction>,
    /// <p>Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you want to delete from the <code>ByteMatchSet</code>.</p>
    pub byte_match_tuple: std::option::Option<crate::model::ByteMatchTuple>,
}
impl ByteMatchSetUpdate {
    /// <p>Specifies whether to insert or delete a <code>ByteMatchTuple</code>.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::ChangeAction> {
        self.action.as_ref()
    }
    /// <p>Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you want to delete from the <code>ByteMatchSet</code>.</p>
    pub fn byte_match_tuple(&self) -> std::option::Option<&crate::model::ByteMatchTuple> {
        self.byte_match_tuple.as_ref()
    }
}
impl std::fmt::Debug for ByteMatchSetUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByteMatchSetUpdate");
        formatter.field("action", &self.action);
        formatter.field("byte_match_tuple", &self.byte_match_tuple);
        formatter.finish()
    }
}
/// See [`ByteMatchSetUpdate`](crate::model::ByteMatchSetUpdate)
pub mod byte_match_set_update {
    /// A builder for [`ByteMatchSetUpdate`](crate::model::ByteMatchSetUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::ChangeAction>,
        pub(crate) byte_match_tuple: std::option::Option<crate::model::ByteMatchTuple>,
    }
    impl Builder {
        /// <p>Specifies whether to insert or delete a <code>ByteMatchTuple</code>.</p>
        pub fn action(mut self, input: crate::model::ChangeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether to insert or delete a <code>ByteMatchTuple</code>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ChangeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you want to delete from the <code>ByteMatchSet</code>.</p>
        pub fn byte_match_tuple(mut self, input: crate::model::ByteMatchTuple) -> Self {
            self.byte_match_tuple = Some(input);
            self
        }
        /// <p>Information about the part of a web request that you want AWS WAF to inspect and the value that you want AWS WAF to search for. If you specify <code>DELETE</code> for the value of <code>Action</code>, the <code>ByteMatchTuple</code> values must exactly match the values in the <code>ByteMatchTuple</code> that you want to delete from the <code>ByteMatchSet</code>.</p>
        pub fn set_byte_match_tuple(
            mut self,
            input: std::option::Option<crate::model::ByteMatchTuple>,
        ) -> Self {
            self.byte_match_tuple = input;
            self
        }
        /// Consumes the builder and constructs a [`ByteMatchSetUpdate`](crate::model::ByteMatchSetUpdate)
        pub fn build(self) -> crate::model::ByteMatchSetUpdate {
            crate::model::ByteMatchSetUpdate {
                action: self.action,
                byte_match_tuple: self.byte_match_tuple,
            }
        }
    }
}
impl ByteMatchSetUpdate {
    /// Creates a new builder-style object to manufacture [`ByteMatchSetUpdate`](crate::model::ByteMatchSetUpdate)
    pub fn builder() -> crate::model::byte_match_set_update::Builder {
        crate::model::byte_match_set_update::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByteMatchTuple {
    /// <p>The part of a web request that you want AWS WAF to search, such as a specified header or a query string. For more information, see <code>FieldToMatch</code>.</p>
    pub field_to_match: std::option::Option<crate::model::FieldToMatch>,
    /// <p>The value that you want AWS WAF to search for. AWS WAF searches for the specified string in the part of web requests that you specified in <code>FieldToMatch</code>. The maximum length of the value is 50 bytes.</p>
    /// <p>Valid values depend on the values that you specified for <code>FieldToMatch</code>:</p>
    /// <ul>
    /// <li> <p> <code>HEADER</code>: The value that you want AWS WAF to search for in the request header that you specified in <code>FieldToMatch</code>, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header.</p> </li>
    /// <li> <p> <code>METHOD</code>: The HTTP method, which indicates the type of operation specified in the request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
    /// <li> <p> <code>QUERY_STRING</code>: The value that you want AWS WAF to search for in the query string, which is the part of a URL that appears after a <code>?</code> character.</p> </li>
    /// <li> <p> <code>URI</code>: The value that you want AWS WAF to search for in the part of a URL that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
    /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
    /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
    /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but instead of inspecting a single parameter, AWS WAF inspects all parameters within the query string for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
    /// </ul>
    /// <p>If <code>TargetString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.</p>
    /// <p> <b>If you're using the AWS WAF API</b> </p>
    /// <p>Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.</p>
    /// <p>For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code>. If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code>, you base64-encode <code>BadBot</code> using MIME base64-encoding and include the resulting value, <code>QmFkQm90</code>, in the value of <code>TargetString</code>.</p>
    /// <p> <b>If you're using the AWS CLI or one of the AWS SDKs</b> </p>
    /// <p>The value that you want AWS WAF to search for. The SDK automatically base64 encodes the value.</p>
    pub target_string: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub text_transformation: std::option::Option<crate::model::TextTransformation>,
    /// <p>Within the portion of a web request that you want to search (for example, in the query string, if any), specify where you want AWS WAF to search. Valid values include the following:</p>
    /// <p> <b>CONTAINS</b> </p>
    /// <p>The specified part of the web request must include the value of <code>TargetString</code>, but the location doesn't matter.</p>
    /// <p> <b>CONTAINS_WORD</b> </p>
    /// <p>The specified part of the web request must include the value of <code>TargetString</code>, and <code>TargetString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>TargetString</code> must be a word, which means one of the following:</p>
    /// <ul>
    /// <li> <p> <code>TargetString</code> exactly matches the value of the specified part of the web request, such as the value of a header.</p> </li>
    /// <li> <p> <code>TargetString</code> is at the beginning of the specified part of the web request and is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code>.</p> </li>
    /// <li> <p> <code>TargetString</code> is at the end of the specified part of the web request and is preceded by a character other than an alphanumeric character or underscore (_), for example, <code>;BadBot</code>.</p> </li>
    /// <li> <p> <code>TargetString</code> is in the middle of the specified part of the web request and is preceded and followed by characters other than alphanumeric characters or underscore (_), for example, <code>-BadBot;</code>.</p> </li>
    /// </ul>
    /// <p> <b>EXACTLY</b> </p>
    /// <p>The value of the specified part of the web request must exactly match the value of <code>TargetString</code>.</p>
    /// <p> <b>STARTS_WITH</b> </p>
    /// <p>The value of <code>TargetString</code> must appear at the beginning of the specified part of the web request.</p>
    /// <p> <b>ENDS_WITH</b> </p>
    /// <p>The value of <code>TargetString</code> must appear at the end of the specified part of the web request.</p>
    pub positional_constraint: std::option::Option<crate::model::PositionalConstraint>,
}
impl ByteMatchTuple {
    /// <p>The part of a web request that you want AWS WAF to search, such as a specified header or a query string. For more information, see <code>FieldToMatch</code>.</p>
    pub fn field_to_match(&self) -> std::option::Option<&crate::model::FieldToMatch> {
        self.field_to_match.as_ref()
    }
    /// <p>The value that you want AWS WAF to search for. AWS WAF searches for the specified string in the part of web requests that you specified in <code>FieldToMatch</code>. The maximum length of the value is 50 bytes.</p>
    /// <p>Valid values depend on the values that you specified for <code>FieldToMatch</code>:</p>
    /// <ul>
    /// <li> <p> <code>HEADER</code>: The value that you want AWS WAF to search for in the request header that you specified in <code>FieldToMatch</code>, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header.</p> </li>
    /// <li> <p> <code>METHOD</code>: The HTTP method, which indicates the type of operation specified in the request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
    /// <li> <p> <code>QUERY_STRING</code>: The value that you want AWS WAF to search for in the query string, which is the part of a URL that appears after a <code>?</code> character.</p> </li>
    /// <li> <p> <code>URI</code>: The value that you want AWS WAF to search for in the part of a URL that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
    /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
    /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
    /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but instead of inspecting a single parameter, AWS WAF inspects all parameters within the query string for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
    /// </ul>
    /// <p>If <code>TargetString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.</p>
    /// <p> <b>If you're using the AWS WAF API</b> </p>
    /// <p>Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.</p>
    /// <p>For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code>. If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code>, you base64-encode <code>BadBot</code> using MIME base64-encoding and include the resulting value, <code>QmFkQm90</code>, in the value of <code>TargetString</code>.</p>
    /// <p> <b>If you're using the AWS CLI or one of the AWS SDKs</b> </p>
    /// <p>The value that you want AWS WAF to search for. The SDK automatically base64 encodes the value.</p>
    pub fn target_string(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.target_string.as_ref()
    }
    /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// <p> <b>CMD_LINE</b> </p>
    /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
    /// <ul>
    /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
    /// <li> <p>Delete spaces before the following characters: / (</p> </li>
    /// <li> <p>Replace the following characters with a space: , ;</p> </li>
    /// <li> <p>Replace multiple spaces with one space</p> </li>
    /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
    /// </ul>
    /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
    /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
    /// <ul>
    /// <li> <p>\f, formfeed, decimal 12</p> </li>
    /// <li> <p>\t, tab, decimal 9</p> </li>
    /// <li> <p>\n, newline, decimal 10</p> </li>
    /// <li> <p>\r, carriage return, decimal 13</p> </li>
    /// <li> <p>\v, vertical tab, decimal 11</p> </li>
    /// <li> <p>non-breaking space, decimal 160</p> </li>
    /// </ul>
    /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
    /// <p> <b>HTML_ENTITY_DECODE</b> </p>
    /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
    /// <ul>
    /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
    /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
    /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
    /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
    /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
    /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
    /// </ul>
    /// <p> <b>LOWERCASE</b> </p>
    /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
    /// <p> <b>URL_DECODE</b> </p>
    /// <p>Use this option to decode a URL-encoded value.</p>
    /// <p> <b>NONE</b> </p>
    /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
    pub fn text_transformation(&self) -> std::option::Option<&crate::model::TextTransformation> {
        self.text_transformation.as_ref()
    }
    /// <p>Within the portion of a web request that you want to search (for example, in the query string, if any), specify where you want AWS WAF to search. Valid values include the following:</p>
    /// <p> <b>CONTAINS</b> </p>
    /// <p>The specified part of the web request must include the value of <code>TargetString</code>, but the location doesn't matter.</p>
    /// <p> <b>CONTAINS_WORD</b> </p>
    /// <p>The specified part of the web request must include the value of <code>TargetString</code>, and <code>TargetString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>TargetString</code> must be a word, which means one of the following:</p>
    /// <ul>
    /// <li> <p> <code>TargetString</code> exactly matches the value of the specified part of the web request, such as the value of a header.</p> </li>
    /// <li> <p> <code>TargetString</code> is at the beginning of the specified part of the web request and is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code>.</p> </li>
    /// <li> <p> <code>TargetString</code> is at the end of the specified part of the web request and is preceded by a character other than an alphanumeric character or underscore (_), for example, <code>;BadBot</code>.</p> </li>
    /// <li> <p> <code>TargetString</code> is in the middle of the specified part of the web request and is preceded and followed by characters other than alphanumeric characters or underscore (_), for example, <code>-BadBot;</code>.</p> </li>
    /// </ul>
    /// <p> <b>EXACTLY</b> </p>
    /// <p>The value of the specified part of the web request must exactly match the value of <code>TargetString</code>.</p>
    /// <p> <b>STARTS_WITH</b> </p>
    /// <p>The value of <code>TargetString</code> must appear at the beginning of the specified part of the web request.</p>
    /// <p> <b>ENDS_WITH</b> </p>
    /// <p>The value of <code>TargetString</code> must appear at the end of the specified part of the web request.</p>
    pub fn positional_constraint(
        &self,
    ) -> std::option::Option<&crate::model::PositionalConstraint> {
        self.positional_constraint.as_ref()
    }
}
impl std::fmt::Debug for ByteMatchTuple {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByteMatchTuple");
        formatter.field("field_to_match", &self.field_to_match);
        formatter.field("target_string", &self.target_string);
        formatter.field("text_transformation", &self.text_transformation);
        formatter.field("positional_constraint", &self.positional_constraint);
        formatter.finish()
    }
}
/// See [`ByteMatchTuple`](crate::model::ByteMatchTuple)
pub mod byte_match_tuple {
    /// A builder for [`ByteMatchTuple`](crate::model::ByteMatchTuple)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_to_match: std::option::Option<crate::model::FieldToMatch>,
        pub(crate) target_string: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) text_transformation: std::option::Option<crate::model::TextTransformation>,
        pub(crate) positional_constraint: std::option::Option<crate::model::PositionalConstraint>,
    }
    impl Builder {
        /// <p>The part of a web request that you want AWS WAF to search, such as a specified header or a query string. For more information, see <code>FieldToMatch</code>.</p>
        pub fn field_to_match(mut self, input: crate::model::FieldToMatch) -> Self {
            self.field_to_match = Some(input);
            self
        }
        /// <p>The part of a web request that you want AWS WAF to search, such as a specified header or a query string. For more information, see <code>FieldToMatch</code>.</p>
        pub fn set_field_to_match(
            mut self,
            input: std::option::Option<crate::model::FieldToMatch>,
        ) -> Self {
            self.field_to_match = input;
            self
        }
        /// <p>The value that you want AWS WAF to search for. AWS WAF searches for the specified string in the part of web requests that you specified in <code>FieldToMatch</code>. The maximum length of the value is 50 bytes.</p>
        /// <p>Valid values depend on the values that you specified for <code>FieldToMatch</code>:</p>
        /// <ul>
        /// <li> <p> <code>HEADER</code>: The value that you want AWS WAF to search for in the request header that you specified in <code>FieldToMatch</code>, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header.</p> </li>
        /// <li> <p> <code>METHOD</code>: The HTTP method, which indicates the type of operation specified in the request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
        /// <li> <p> <code>QUERY_STRING</code>: The value that you want AWS WAF to search for in the query string, which is the part of a URL that appears after a <code>?</code> character.</p> </li>
        /// <li> <p> <code>URI</code>: The value that you want AWS WAF to search for in the part of a URL that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
        /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
        /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
        /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but instead of inspecting a single parameter, AWS WAF inspects all parameters within the query string for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
        /// </ul>
        /// <p>If <code>TargetString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.</p>
        /// <p> <b>If you're using the AWS WAF API</b> </p>
        /// <p>Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.</p>
        /// <p>For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code>. If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code>, you base64-encode <code>BadBot</code> using MIME base64-encoding and include the resulting value, <code>QmFkQm90</code>, in the value of <code>TargetString</code>.</p>
        /// <p> <b>If you're using the AWS CLI or one of the AWS SDKs</b> </p>
        /// <p>The value that you want AWS WAF to search for. The SDK automatically base64 encodes the value.</p>
        pub fn target_string(mut self, input: aws_smithy_types::Blob) -> Self {
            self.target_string = Some(input);
            self
        }
        /// <p>The value that you want AWS WAF to search for. AWS WAF searches for the specified string in the part of web requests that you specified in <code>FieldToMatch</code>. The maximum length of the value is 50 bytes.</p>
        /// <p>Valid values depend on the values that you specified for <code>FieldToMatch</code>:</p>
        /// <ul>
        /// <li> <p> <code>HEADER</code>: The value that you want AWS WAF to search for in the request header that you specified in <code>FieldToMatch</code>, for example, the value of the <code>User-Agent</code> or <code>Referer</code> header.</p> </li>
        /// <li> <p> <code>METHOD</code>: The HTTP method, which indicates the type of operation specified in the request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>.</p> </li>
        /// <li> <p> <code>QUERY_STRING</code>: The value that you want AWS WAF to search for in the query string, which is the part of a URL that appears after a <code>?</code> character.</p> </li>
        /// <li> <p> <code>URI</code>: The value that you want AWS WAF to search for in the part of a URL that identifies a resource, for example, <code>/images/daily-ad.jpg</code>.</p> </li>
        /// <li> <p> <code>BODY</code>: The part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. The request body immediately follows the request headers. Note that only the first <code>8192</code> bytes of the request body are forwarded to AWS WAF for inspection. To allow or block requests based on the length of the body, you can create a size constraint set. For more information, see <code>CreateSizeConstraintSet</code>. </p> </li>
        /// <li> <p> <code>SINGLE_QUERY_ARG</code>: The parameter in the query string that you will inspect, such as <i>UserName</i> or <i>SalesRegion</i>. The maximum length for <code>SINGLE_QUERY_ARG</code> is 30 characters.</p> </li>
        /// <li> <p> <code>ALL_QUERY_ARGS</code>: Similar to <code>SINGLE_QUERY_ARG</code>, but instead of inspecting a single parameter, AWS WAF inspects all parameters within the query string for the value or regex pattern that you specify in <code>TargetString</code>.</p> </li>
        /// </ul>
        /// <p>If <code>TargetString</code> includes alphabetic characters A-Z and a-z, note that the value is case sensitive.</p>
        /// <p> <b>If you're using the AWS WAF API</b> </p>
        /// <p>Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.</p>
        /// <p>For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code>. If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code>, you base64-encode <code>BadBot</code> using MIME base64-encoding and include the resulting value, <code>QmFkQm90</code>, in the value of <code>TargetString</code>.</p>
        /// <p> <b>If you're using the AWS CLI or one of the AWS SDKs</b> </p>
        /// <p>The value that you want AWS WAF to search for. The SDK automatically base64 encodes the value.</p>
        pub fn set_target_string(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.target_string = input;
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn text_transformation(mut self, input: crate::model::TextTransformation) -> Self {
            self.text_transformation = Some(input);
            self
        }
        /// <p>Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass AWS WAF. If you specify a transformation, AWS WAF performs the transformation on <code>FieldToMatch</code> before inspecting it for a match.</p>
        /// <p>You can only specify a single type of TextTransformation.</p>
        /// <p> <b>CMD_LINE</b> </p>
        /// <p>When you're concerned that attackers are injecting an operating system command line command and using unusual formatting to disguise some or all of the command, use this option to perform the following transformations:</p>
        /// <ul>
        /// <li> <p>Delete the following characters: \ " ' ^</p> </li>
        /// <li> <p>Delete spaces before the following characters: / (</p> </li>
        /// <li> <p>Replace the following characters with a space: , ;</p> </li>
        /// <li> <p>Replace multiple spaces with one space</p> </li>
        /// <li> <p>Convert uppercase letters (A-Z) to lowercase (a-z)</p> </li>
        /// </ul>
        /// <p> <b>COMPRESS_WHITE_SPACE</b> </p>
        /// <p>Use this option to replace the following characters with a space character (decimal 32):</p>
        /// <ul>
        /// <li> <p>\f, formfeed, decimal 12</p> </li>
        /// <li> <p>\t, tab, decimal 9</p> </li>
        /// <li> <p>\n, newline, decimal 10</p> </li>
        /// <li> <p>\r, carriage return, decimal 13</p> </li>
        /// <li> <p>\v, vertical tab, decimal 11</p> </li>
        /// <li> <p>non-breaking space, decimal 160</p> </li>
        /// </ul>
        /// <p> <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.</p>
        /// <p> <b>HTML_ENTITY_DECODE</b> </p>
        /// <p>Use this option to replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs the following operations:</p>
        /// <ul>
        /// <li> <p>Replaces <code>(ampersand)quot;</code> with <code>"</code> </p> </li>
        /// <li> <p>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</p> </li>
        /// <li> <p>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</p> </li>
        /// <li> <p>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code> </p> </li>
        /// <li> <p>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code>, with the corresponding characters</p> </li>
        /// <li> <p>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code>, with the corresponding characters</p> </li>
        /// </ul>
        /// <p> <b>LOWERCASE</b> </p>
        /// <p>Use this option to convert uppercase letters (A-Z) to lowercase (a-z).</p>
        /// <p> <b>URL_DECODE</b> </p>
        /// <p>Use this option to decode a URL-encoded value.</p>
        /// <p> <b>NONE</b> </p>
        /// <p>Specify <code>NONE</code> if you don't want to perform any text transformations.</p>
        pub fn set_text_transformation(
            mut self,
            input: std::option::Option<crate::model::TextTransformation>,
        ) -> Self {
            self.text_transformation = input;
            self
        }
        /// <p>Within the portion of a web request that you want to search (for example, in the query string, if any), specify where you want AWS WAF to search. Valid values include the following:</p>
        /// <p> <b>CONTAINS</b> </p>
        /// <p>The specified part of the web request must include the value of <code>TargetString</code>, but the location doesn't matter.</p>
        /// <p> <b>CONTAINS_WORD</b> </p>
        /// <p>The specified part of the web request must include the value of <code>TargetString</code>, and <code>TargetString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>TargetString</code> must be a word, which means one of the following:</p>
        /// <ul>
        /// <li> <p> <code>TargetString</code> exactly matches the value of the specified part of the web request, such as the value of a header.</p> </li>
        /// <li> <p> <code>TargetString</code> is at the beginning of the specified part of the web request and is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code>.</p> </li>
        /// <li> <p> <code>TargetString</code> is at the end of the specified part of the web request and is preceded by a character other than an alphanumeric character or underscore (_), for example, <code>;BadBot</code>.</p> </li>
        /// <li> <p> <code>TargetString</code> is in the middle of the specified part of the web request and is preceded and followed by characters other than alphanumeric characters or underscore (_), for example, <code>-BadBot;</code>.</p> </li>
        /// </ul>
        /// <p> <b>EXACTLY</b> </p>
        /// <p>The value of the specified part of the web request must exactly match the value of <code>TargetString</code>.</p>
        /// <p> <b>STARTS_WITH</b> </p>
        /// <p>The value of <code>TargetString</code> must appear at the beginning of the specified part of the web request.</p>
        /// <p> <b>ENDS_WITH</b> </p>
        /// <p>The value of <code>TargetString</code> must appear at the end of the specified part of the web request.</p>
        pub fn positional_constraint(mut self, input: crate::model::PositionalConstraint) -> Self {
            self.positional_constraint = Some(input);
            self
        }
        /// <p>Within the portion of a web request that you want to search (for example, in the query string, if any), specify where you want AWS WAF to search. Valid values include the following:</p>
        /// <p> <b>CONTAINS</b> </p>
        /// <p>The specified part of the web request must include the value of <code>TargetString</code>, but the location doesn't matter.</p>
        /// <p> <b>CONTAINS_WORD</b> </p>
        /// <p>The specified part of the web request must include the value of <code>TargetString</code>, and <code>TargetString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>TargetString</code> must be a word, which means one of the following:</p>
        /// <ul>
        /// <li> <p> <code>TargetString</code> exactly matches the value of the specified part of the web request, such as the value of a header.</p> </li>
        /// <li> <p> <code>TargetString</code> is at the beginning of the specified part of the web request and is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code>.</p> </li>
        /// <li> <p> <code>TargetString</code> is at the end of the specified part of the web request and is preceded by a character other than an alphanumeric character or underscore (_), for example, <code>;BadBot</code>.</p> </li>
        /// <li> <p> <code>TargetString</code> is in the middle of the specified part of the web request and is preceded and followed by characters other than alphanumeric characters or underscore (_), for example, <code>-BadBot;</code>.</p> </li>
        /// </ul>
        /// <p> <b>EXACTLY</b> </p>
        /// <p>The value of the specified part of the web request must exactly match the value of <code>TargetString</code>.</p>
        /// <p> <b>STARTS_WITH</b> </p>
        /// <p>The value of <code>TargetString</code> must appear at the beginning of the specified part of the web request.</p>
        /// <p> <b>ENDS_WITH</b> </p>
        /// <p>The value of <code>TargetString</code> must appear at the end of the specified part of the web request.</p>
        pub fn set_positional_constraint(
            mut self,
            input: std::option::Option<crate::model::PositionalConstraint>,
        ) -> Self {
            self.positional_constraint = input;
            self
        }
        /// Consumes the builder and constructs a [`ByteMatchTuple`](crate::model::ByteMatchTuple)
        pub fn build(self) -> crate::model::ByteMatchTuple {
            crate::model::ByteMatchTuple {
                field_to_match: self.field_to_match,
                target_string: self.target_string,
                text_transformation: self.text_transformation,
                positional_constraint: self.positional_constraint,
            }
        }
    }
}
impl ByteMatchTuple {
    /// Creates a new builder-style object to manufacture [`ByteMatchTuple`](crate::model::ByteMatchTuple)
    pub fn builder() -> crate::model::byte_match_tuple::Builder {
        crate::model::byte_match_tuple::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PositionalConstraint {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    ContainsWord,
    #[allow(missing_docs)] // documentation missing in model
    EndsWith,
    #[allow(missing_docs)] // documentation missing in model
    Exactly,
    #[allow(missing_docs)] // documentation missing in model
    StartsWith,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PositionalConstraint {
    fn from(s: &str) -> Self {
        match s {
            "CONTAINS" => PositionalConstraint::Contains,
            "CONTAINS_WORD" => PositionalConstraint::ContainsWord,
            "ENDS_WITH" => PositionalConstraint::EndsWith,
            "EXACTLY" => PositionalConstraint::Exactly,
            "STARTS_WITH" => PositionalConstraint::StartsWith,
            other => PositionalConstraint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PositionalConstraint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PositionalConstraint::from(s))
    }
}
impl PositionalConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PositionalConstraint::Contains => "CONTAINS",
            PositionalConstraint::ContainsWord => "CONTAINS_WORD",
            PositionalConstraint::EndsWith => "ENDS_WITH",
            PositionalConstraint::Exactly => "EXACTLY",
            PositionalConstraint::StartsWith => "STARTS_WITH",
            PositionalConstraint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONTAINS",
            "CONTAINS_WORD",
            "ENDS_WITH",
            "EXACTLY",
            "STARTS_WITH",
        ]
    }
}
impl AsRef<str> for PositionalConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A tag associated with an AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
/// <p>Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p></p>
    pub key: std::option::Option<std::string::String>,
    /// <p></p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p></p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p></p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p></p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The Amazon Kinesis Data Firehose, <code>RedactedFields</code> information, and the web ACL Amazon Resource Name (ARN).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An array of Amazon Kinesis Data Firehose ARNs.</p>
    pub log_destination_configs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The parts of the request that you want redacted from the logs. For example, if you redact the cookie field, the cookie field in the firehose will be <code>xxx</code>. </p>
    pub redacted_fields: std::option::Option<std::vec::Vec<crate::model::FieldToMatch>>,
}
impl LoggingConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An array of Amazon Kinesis Data Firehose ARNs.</p>
    pub fn log_destination_configs(&self) -> std::option::Option<&[std::string::String]> {
        self.log_destination_configs.as_deref()
    }
    /// <p>The parts of the request that you want redacted from the logs. For example, if you redact the cookie field, the cookie field in the firehose will be <code>xxx</code>. </p>
    pub fn redacted_fields(&self) -> std::option::Option<&[crate::model::FieldToMatch]> {
        self.redacted_fields.as_deref()
    }
}
impl std::fmt::Debug for LoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfiguration");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("log_destination_configs", &self.log_destination_configs);
        formatter.field("redacted_fields", &self.redacted_fields);
        formatter.finish()
    }
}
/// See [`LoggingConfiguration`](crate::model::LoggingConfiguration)
pub mod logging_configuration {
    /// A builder for [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) log_destination_configs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) redacted_fields: std::option::Option<std::vec::Vec<crate::model::FieldToMatch>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL that you want to associate with <code>LogDestinationConfigs</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `log_destination_configs`.
        ///
        /// To override the contents of this collection use [`set_log_destination_configs`](Self::set_log_destination_configs).
        ///
        /// <p>An array of Amazon Kinesis Data Firehose ARNs.</p>
        pub fn log_destination_configs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_destination_configs.unwrap_or_default();
            v.push(input.into());
            self.log_destination_configs = Some(v);
            self
        }
        /// <p>An array of Amazon Kinesis Data Firehose ARNs.</p>
        pub fn set_log_destination_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_destination_configs = input;
            self
        }
        /// Appends an item to `redacted_fields`.
        ///
        /// To override the contents of this collection use [`set_redacted_fields`](Self::set_redacted_fields).
        ///
        /// <p>The parts of the request that you want redacted from the logs. For example, if you redact the cookie field, the cookie field in the firehose will be <code>xxx</code>. </p>
        pub fn redacted_fields(mut self, input: crate::model::FieldToMatch) -> Self {
            let mut v = self.redacted_fields.unwrap_or_default();
            v.push(input);
            self.redacted_fields = Some(v);
            self
        }
        /// <p>The parts of the request that you want redacted from the logs. For example, if you redact the cookie field, the cookie field in the firehose will be <code>xxx</code>. </p>
        pub fn set_redacted_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FieldToMatch>>,
        ) -> Self {
            self.redacted_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfiguration`](crate::model::LoggingConfiguration)
        pub fn build(self) -> crate::model::LoggingConfiguration {
            crate::model::LoggingConfiguration {
                resource_arn: self.resource_arn,
                log_destination_configs: self.log_destination_configs,
                redacted_fields: self.redacted_fields,
            }
        }
    }
}
impl LoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    pub fn builder() -> crate::model::logging_configuration::Builder {
        crate::model::logging_configuration::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The <code>Id</code> and <code>Name</code> of an <code>XssMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XssMatchSetSummary {
    /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about a <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
    /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    pub xss_match_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl XssMatchSetSummary {
    /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about a <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
    /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    pub fn xss_match_set_id(&self) -> std::option::Option<&str> {
        self.xss_match_set_id.as_deref()
    }
    /// <p>The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for XssMatchSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XssMatchSetSummary");
        formatter.field("xss_match_set_id", &self.xss_match_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`XssMatchSetSummary`](crate::model::XssMatchSetSummary)
pub mod xss_match_set_summary {
    /// A builder for [`XssMatchSetSummary`](crate::model::XssMatchSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xss_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about a <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
        /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn xss_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.xss_match_set_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about a <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
        /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.xss_match_set_id = input;
            self
        }
        /// <p>The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>XssMatchSet</code>, if any, specified by <code>Id</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`XssMatchSetSummary`](crate::model::XssMatchSetSummary)
        pub fn build(self) -> crate::model::XssMatchSetSummary {
            crate::model::XssMatchSetSummary {
                xss_match_set_id: self.xss_match_set_id,
                name: self.name,
            }
        }
    }
}
impl XssMatchSetSummary {
    /// Creates a new builder-style object to manufacture [`XssMatchSetSummary`](crate::model::XssMatchSetSummary)
    pub fn builder() -> crate::model::xss_match_set_summary::Builder {
        crate::model::xss_match_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains the identifier and the name or description of the <code>WebACL</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebAclSummary {
    /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
    /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    pub web_acl_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
}
impl WebAclSummary {
    /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
    /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    pub fn web_acl_id(&self) -> std::option::Option<&str> {
        self.web_acl_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for WebAclSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebAclSummary");
        formatter.field("web_acl_id", &self.web_acl_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`WebAclSummary`](crate::model::WebAclSummary)
pub mod web_acl_summary {
    /// A builder for [`WebAclSummary`](crate::model::WebAclSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) web_acl_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
        /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
        /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`WebAclSummary`](crate::model::WebAclSummary)
        pub fn build(self) -> crate::model::WebAclSummary {
            crate::model::WebAclSummary {
                web_acl_id: self.web_acl_id,
                name: self.name,
            }
        }
    }
}
impl WebAclSummary {
    /// Creates a new builder-style object to manufacture [`WebAclSummary`](crate::model::WebAclSummary)
    pub fn builder() -> crate::model::web_acl_summary::Builder {
        crate::model::web_acl_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Information for a tag associated with an AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
/// <p>Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagInfoForResource {
    /// <p></p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p></p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagInfoForResource {
    /// <p></p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p></p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for TagInfoForResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagInfoForResource");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`TagInfoForResource`](crate::model::TagInfoForResource)
pub mod tag_info_for_resource {
    /// A builder for [`TagInfoForResource`](crate::model::TagInfoForResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p></p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p></p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`TagInfoForResource`](crate::model::TagInfoForResource)
        pub fn build(self) -> crate::model::TagInfoForResource {
            crate::model::TagInfoForResource {
                resource_arn: self.resource_arn,
                tag_list: self.tag_list,
            }
        }
    }
}
impl TagInfoForResource {
    /// Creates a new builder-style object to manufacture [`TagInfoForResource`](crate::model::TagInfoForResource)
    pub fn builder() -> crate::model::tag_info_for_resource::Builder {
        crate::model::tag_info_for_resource::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A summary of the rule groups you are subscribed to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscribedRuleGroupSummary {
    /// <p>A unique identifier for a <code>RuleGroup</code>.</p>
    pub rule_group_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
    pub metric_name: std::option::Option<std::string::String>,
}
impl SubscribedRuleGroupSummary {
    /// <p>A unique identifier for a <code>RuleGroup</code>.</p>
    pub fn rule_group_id(&self) -> std::option::Option<&str> {
        self.rule_group_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
}
impl std::fmt::Debug for SubscribedRuleGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscribedRuleGroupSummary");
        formatter.field("rule_group_id", &self.rule_group_id);
        formatter.field("name", &self.name);
        formatter.field("metric_name", &self.metric_name);
        formatter.finish()
    }
}
/// See [`SubscribedRuleGroupSummary`](crate::model::SubscribedRuleGroupSummary)
pub mod subscribed_rule_group_summary {
    /// A builder for [`SubscribedRuleGroupSummary`](crate::model::SubscribedRuleGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>RuleGroup</code>.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>RuleGroup</code>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscribedRuleGroupSummary`](crate::model::SubscribedRuleGroupSummary)
        pub fn build(self) -> crate::model::SubscribedRuleGroupSummary {
            crate::model::SubscribedRuleGroupSummary {
                rule_group_id: self.rule_group_id,
                name: self.name,
                metric_name: self.metric_name,
            }
        }
    }
}
impl SubscribedRuleGroupSummary {
    /// Creates a new builder-style object to manufacture [`SubscribedRuleGroupSummary`](crate::model::SubscribedRuleGroupSummary)
    pub fn builder() -> crate::model::subscribed_rule_group_summary::Builder {
        crate::model::subscribed_rule_group_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The <code>Id</code> and <code>Name</code> of a <code>SqlInjectionMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlInjectionMatchSetSummary {
    /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
    /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    pub sql_injection_match_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the <code>SqlInjectionMatchSet</code>, if any, specified by <code>Id</code>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl SqlInjectionMatchSetSummary {
    /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
    /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    pub fn sql_injection_match_set_id(&self) -> std::option::Option<&str> {
        self.sql_injection_match_set_id.as_deref()
    }
    /// <p>The name of the <code>SqlInjectionMatchSet</code>, if any, specified by <code>Id</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for SqlInjectionMatchSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlInjectionMatchSetSummary");
        formatter.field(
            "sql_injection_match_set_id",
            &self.sql_injection_match_set_id,
        );
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`SqlInjectionMatchSetSummary`](crate::model::SqlInjectionMatchSetSummary)
pub mod sql_injection_match_set_summary {
    /// A builder for [`SqlInjectionMatchSetSummary`](crate::model::SqlInjectionMatchSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql_injection_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
        /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn sql_injection_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql_injection_match_set_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
        /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sql_injection_match_set_id = input;
            self
        }
        /// <p>The name of the <code>SqlInjectionMatchSet</code>, if any, specified by <code>Id</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>SqlInjectionMatchSet</code>, if any, specified by <code>Id</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlInjectionMatchSetSummary`](crate::model::SqlInjectionMatchSetSummary)
        pub fn build(self) -> crate::model::SqlInjectionMatchSetSummary {
            crate::model::SqlInjectionMatchSetSummary {
                sql_injection_match_set_id: self.sql_injection_match_set_id,
                name: self.name,
            }
        }
    }
}
impl SqlInjectionMatchSetSummary {
    /// Creates a new builder-style object to manufacture [`SqlInjectionMatchSetSummary`](crate::model::SqlInjectionMatchSetSummary)
    pub fn builder() -> crate::model::sql_injection_match_set_summary::Builder {
        crate::model::sql_injection_match_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The <code>Id</code> and <code>Name</code> of a <code>SizeConstraintSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SizeConstraintSetSummary {
    /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
    /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    pub size_constraint_set_id: std::option::Option<std::string::String>,
    /// <p>The name of the <code>SizeConstraintSet</code>, if any.</p>
    pub name: std::option::Option<std::string::String>,
}
impl SizeConstraintSetSummary {
    /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
    /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    pub fn size_constraint_set_id(&self) -> std::option::Option<&str> {
        self.size_constraint_set_id.as_deref()
    }
    /// <p>The name of the <code>SizeConstraintSet</code>, if any.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for SizeConstraintSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SizeConstraintSetSummary");
        formatter.field("size_constraint_set_id", &self.size_constraint_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`SizeConstraintSetSummary`](crate::model::SizeConstraintSetSummary)
pub mod size_constraint_set_summary {
    /// A builder for [`SizeConstraintSetSummary`](crate::model::SizeConstraintSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_constraint_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
        /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn size_constraint_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.size_constraint_set_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
        /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.size_constraint_set_id = input;
            self
        }
        /// <p>The name of the <code>SizeConstraintSet</code>, if any.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>SizeConstraintSet</code>, if any.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`SizeConstraintSetSummary`](crate::model::SizeConstraintSetSummary)
        pub fn build(self) -> crate::model::SizeConstraintSetSummary {
            crate::model::SizeConstraintSetSummary {
                size_constraint_set_id: self.size_constraint_set_id,
                name: self.name,
            }
        }
    }
}
impl SizeConstraintSetSummary {
    /// Creates a new builder-style object to manufacture [`SizeConstraintSetSummary`](crate::model::SizeConstraintSetSummary)
    pub fn builder() -> crate::model::size_constraint_set_summary::Builder {
        crate::model::size_constraint_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains the identifier and the friendly name or description of the <code>Rule</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleSummary {
    /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
    /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
}
impl RuleSummary {
    /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
    /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for RuleSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleSummary");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RuleSummary`](crate::model::RuleSummary)
pub mod rule_summary {
    /// A builder for [`RuleSummary`](crate::model::RuleSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
        /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
        /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleSummary`](crate::model::RuleSummary)
        pub fn build(self) -> crate::model::RuleSummary {
            crate::model::RuleSummary {
                rule_id: self.rule_id,
                name: self.name,
            }
        }
    }
}
impl RuleSummary {
    /// Creates a new builder-style object to manufacture [`RuleSummary`](crate::model::RuleSummary)
    pub fn builder() -> crate::model::rule_summary::Builder {
        crate::model::rule_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains the identifier and the friendly name or description of the <code>RuleGroup</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroupSummary {
    /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
    /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    pub rule_group_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
}
impl RuleGroupSummary {
    /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
    /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    pub fn rule_group_id(&self) -> std::option::Option<&str> {
        self.rule_group_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for RuleGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroupSummary");
        formatter.field("rule_group_id", &self.rule_group_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RuleGroupSummary`](crate::model::RuleGroupSummary)
pub mod rule_group_summary {
    /// A builder for [`RuleGroupSummary`](crate::model::RuleGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
        /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
        /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroupSummary`](crate::model::RuleGroupSummary)
        pub fn build(self) -> crate::model::RuleGroupSummary {
            crate::model::RuleGroupSummary {
                rule_group_id: self.rule_group_id,
                name: self.name,
            }
        }
    }
}
impl RuleGroupSummary {
    /// Creates a new builder-style object to manufacture [`RuleGroupSummary`](crate::model::RuleGroupSummary)
    pub fn builder() -> crate::model::rule_group_summary::Builder {
        crate::model::rule_group_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Returned by <code>ListRegexPatternSets</code>. Each <code>RegexPatternSetSummary</code> object includes the <code>Name</code> and <code>RegexPatternSetId</code> for one <code>RegexPatternSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexPatternSetSummary {
    /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
    /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    pub regex_pattern_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl RegexPatternSetSummary {
    /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
    /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    pub fn regex_pattern_set_id(&self) -> std::option::Option<&str> {
        self.regex_pattern_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for RegexPatternSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexPatternSetSummary");
        formatter.field("regex_pattern_set_id", &self.regex_pattern_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RegexPatternSetSummary`](crate::model::RegexPatternSetSummary)
pub mod regex_pattern_set_summary {
    /// A builder for [`RegexPatternSetSummary`](crate::model::RegexPatternSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_pattern_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
        /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn regex_pattern_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex_pattern_set_id = Some(input.into());
            self
        }
        /// <p>The <code>RegexPatternSetId</code> for a <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
        /// <p> <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regex_pattern_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexPatternSetSummary`](crate::model::RegexPatternSetSummary)
        pub fn build(self) -> crate::model::RegexPatternSetSummary {
            crate::model::RegexPatternSetSummary {
                regex_pattern_set_id: self.regex_pattern_set_id,
                name: self.name,
            }
        }
    }
}
impl RegexPatternSetSummary {
    /// Creates a new builder-style object to manufacture [`RegexPatternSetSummary`](crate::model::RegexPatternSetSummary)
    pub fn builder() -> crate::model::regex_pattern_set_summary::Builder {
        crate::model::regex_pattern_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Returned by <code>ListRegexMatchSets</code>. Each <code>RegexMatchSetSummary</code> object includes the <code>Name</code> and <code>RegexMatchSetId</code> for one <code>RegexMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexMatchSetSummary {
    /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS WAF.</p>
    /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    pub regex_match_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl RegexMatchSetSummary {
    /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS WAF.</p>
    /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    pub fn regex_match_set_id(&self) -> std::option::Option<&str> {
        self.regex_match_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for RegexMatchSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexMatchSetSummary");
        formatter.field("regex_match_set_id", &self.regex_match_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`RegexMatchSetSummary`](crate::model::RegexMatchSetSummary)
pub mod regex_match_set_summary {
    /// A builder for [`RegexMatchSetSummary`](crate::model::RegexMatchSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS WAF.</p>
        /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn regex_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex_match_set_id = Some(input.into());
            self
        }
        /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code>, update a <code>RegexMatchSet</code>, remove a <code>RegexMatchSet</code> from a <code>Rule</code>, and delete a <code>RegexMatchSet</code> from AWS WAF.</p>
        /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regex_match_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexMatchSetSummary`](crate::model::RegexMatchSetSummary)
        pub fn build(self) -> crate::model::RegexMatchSetSummary {
            crate::model::RegexMatchSetSummary {
                regex_match_set_id: self.regex_match_set_id,
                name: self.name,
            }
        }
    }
}
impl RegexMatchSetSummary {
    /// Creates a new builder-style object to manufacture [`RegexMatchSetSummary`](crate::model::RegexMatchSetSummary)
    pub fn builder() -> crate::model::regex_match_set_summary::Builder {
        crate::model::regex_match_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains the identifier and the name of the <code>IPSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpSetSummary {
    /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You can use <code>IPSetId</code> in a <code>GetIPSet</code> request to get detailed information about an <code>IPSet</code>.</p>
    pub ip_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
}
impl IpSetSummary {
    /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You can use <code>IPSetId</code> in a <code>GetIPSet</code> request to get detailed information about an <code>IPSet</code>.</p>
    pub fn ip_set_id(&self) -> std::option::Option<&str> {
        self.ip_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for IpSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpSetSummary");
        formatter.field("ip_set_id", &self.ip_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`IpSetSummary`](crate::model::IpSetSummary)
pub mod ip_set_summary {
    /// A builder for [`IpSetSummary`](crate::model::IpSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You can use <code>IPSetId</code> in a <code>GetIPSet</code> request to get detailed information about an <code>IPSet</code>.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_set_id = Some(input.into());
            self
        }
        /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You can use <code>IPSetId</code> in a <code>GetIPSet</code> request to get detailed information about an <code>IPSet</code>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`IpSetSummary`](crate::model::IpSetSummary)
        pub fn build(self) -> crate::model::IpSetSummary {
            crate::model::IpSetSummary {
                ip_set_id: self.ip_set_id,
                name: self.name,
            }
        }
    }
}
impl IpSetSummary {
    /// Creates a new builder-style object to manufacture [`IpSetSummary`](crate::model::IpSetSummary)
    pub fn builder() -> crate::model::ip_set_summary::Builder {
        crate::model::ip_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains the identifier and the name of the <code>GeoMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoMatchSetSummary {
    /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You can use <code>GeoMatchSetId</code> in a <code>GetGeoMatchSet</code> request to get detailed information about an <code>GeoMatchSet</code>.</p>
    pub geo_match_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GeoMatchSetSummary {
    /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You can use <code>GeoMatchSetId</code> in a <code>GetGeoMatchSet</code> request to get detailed information about an <code>GeoMatchSet</code>.</p>
    pub fn geo_match_set_id(&self) -> std::option::Option<&str> {
        self.geo_match_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GeoMatchSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoMatchSetSummary");
        formatter.field("geo_match_set_id", &self.geo_match_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`GeoMatchSetSummary`](crate::model::GeoMatchSetSummary)
pub mod geo_match_set_summary {
    /// A builder for [`GeoMatchSetSummary`](crate::model::GeoMatchSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You can use <code>GeoMatchSetId</code> in a <code>GetGeoMatchSet</code> request to get detailed information about an <code>GeoMatchSet</code>.</p>
        pub fn geo_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geo_match_set_id = Some(input.into());
            self
        }
        /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You can use <code>GeoMatchSetId</code> in a <code>GetGeoMatchSet</code> request to get detailed information about an <code>GeoMatchSet</code>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.geo_match_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoMatchSetSummary`](crate::model::GeoMatchSetSummary)
        pub fn build(self) -> crate::model::GeoMatchSetSummary {
            crate::model::GeoMatchSetSummary {
                geo_match_set_id: self.geo_match_set_id,
                name: self.name,
            }
        }
    }
}
impl GeoMatchSetSummary {
    /// Creates a new builder-style object to manufacture [`GeoMatchSetSummary`](crate::model::GeoMatchSetSummary)
    pub fn builder() -> crate::model::geo_match_set_summary::Builder {
        crate::model::geo_match_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Returned by <code>ListByteMatchSets</code>. Each <code>ByteMatchSetSummary</code> object includes the <code>Name</code> and <code>ByteMatchSetId</code> for one <code>ByteMatchSet</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByteMatchSetSummary {
    /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code>, update a <code>ByteMatchSet</code>, remove a <code>ByteMatchSet</code> from a <code>Rule</code>, and delete a <code>ByteMatchSet</code> from AWS WAF.</p>
    /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    pub byte_match_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ByteMatchSetSummary {
    /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code>, update a <code>ByteMatchSet</code>, remove a <code>ByteMatchSet</code> from a <code>Rule</code>, and delete a <code>ByteMatchSet</code> from AWS WAF.</p>
    /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    pub fn byte_match_set_id(&self) -> std::option::Option<&str> {
        self.byte_match_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ByteMatchSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByteMatchSetSummary");
        formatter.field("byte_match_set_id", &self.byte_match_set_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ByteMatchSetSummary`](crate::model::ByteMatchSetSummary)
pub mod byte_match_set_summary {
    /// A builder for [`ByteMatchSetSummary`](crate::model::ByteMatchSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) byte_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code>, update a <code>ByteMatchSet</code>, remove a <code>ByteMatchSet</code> from a <code>Rule</code>, and delete a <code>ByteMatchSet</code> from AWS WAF.</p>
        /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn byte_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.byte_match_set_id = Some(input.into());
            self
        }
        /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code>, update a <code>ByteMatchSet</code>, remove a <code>ByteMatchSet</code> from a <code>Rule</code>, and delete a <code>ByteMatchSet</code> from AWS WAF.</p>
        /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.byte_match_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ByteMatchSetSummary`](crate::model::ByteMatchSetSummary)
        pub fn build(self) -> crate::model::ByteMatchSetSummary {
            crate::model::ByteMatchSetSummary {
                byte_match_set_id: self.byte_match_set_id,
                name: self.name,
            }
        }
    }
}
impl ByteMatchSetSummary {
    /// Creates a new builder-style object to manufacture [`ByteMatchSetSummary`](crate::model::ByteMatchSetSummary)
    pub fn builder() -> crate::model::byte_match_set_summary::Builder {
        crate::model::byte_match_set_summary::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A complex type that contains <code>XssMatchTuple</code> objects, which specify the parts of web requests that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header. If a <code>XssMatchSet</code> contains more than one <code>XssMatchTuple</code> object, a request needs to include cross-site scripting attacks in only one of the specified parts of the request to be considered a match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XssMatchSet {
    /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about an <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
    /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    pub xss_match_set_id: std::option::Option<std::string::String>,
    /// <p>The name, if any, of the <code>XssMatchSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.</p>
    pub xss_match_tuples: std::option::Option<std::vec::Vec<crate::model::XssMatchTuple>>,
}
impl XssMatchSet {
    /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about an <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
    /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    pub fn xss_match_set_id(&self) -> std::option::Option<&str> {
        self.xss_match_set_id.as_deref()
    }
    /// <p>The name, if any, of the <code>XssMatchSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.</p>
    pub fn xss_match_tuples(&self) -> std::option::Option<&[crate::model::XssMatchTuple]> {
        self.xss_match_tuples.as_deref()
    }
}
impl std::fmt::Debug for XssMatchSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XssMatchSet");
        formatter.field("xss_match_set_id", &self.xss_match_set_id);
        formatter.field("name", &self.name);
        formatter.field("xss_match_tuples", &self.xss_match_tuples);
        formatter.finish()
    }
}
/// See [`XssMatchSet`](crate::model::XssMatchSet)
pub mod xss_match_set {
    /// A builder for [`XssMatchSet`](crate::model::XssMatchSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xss_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) xss_match_tuples:
            std::option::Option<std::vec::Vec<crate::model::XssMatchTuple>>,
    }
    impl Builder {
        /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about an <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
        /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn xss_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.xss_match_set_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for an <code>XssMatchSet</code>. You use <code>XssMatchSetId</code> to get information about an <code>XssMatchSet</code> (see <code>GetXssMatchSet</code>), update an <code>XssMatchSet</code> (see <code>UpdateXssMatchSet</code>), insert an <code>XssMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>XssMatchSet</code> from AWS WAF (see <code>DeleteXssMatchSet</code>).</p>
        /// <p> <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.xss_match_set_id = input;
            self
        }
        /// <p>The name, if any, of the <code>XssMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name, if any, of the <code>XssMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `xss_match_tuples`.
        ///
        /// To override the contents of this collection use [`set_xss_match_tuples`](Self::set_xss_match_tuples).
        ///
        /// <p>Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.</p>
        pub fn xss_match_tuples(mut self, input: crate::model::XssMatchTuple) -> Self {
            let mut v = self.xss_match_tuples.unwrap_or_default();
            v.push(input);
            self.xss_match_tuples = Some(v);
            self
        }
        /// <p>Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.</p>
        pub fn set_xss_match_tuples(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::XssMatchTuple>>,
        ) -> Self {
            self.xss_match_tuples = input;
            self
        }
        /// Consumes the builder and constructs a [`XssMatchSet`](crate::model::XssMatchSet)
        pub fn build(self) -> crate::model::XssMatchSet {
            crate::model::XssMatchSet {
                xss_match_set_id: self.xss_match_set_id,
                name: self.name,
                xss_match_tuples: self.xss_match_tuples,
            }
        }
    }
}
impl XssMatchSet {
    /// Creates a new builder-style object to manufacture [`XssMatchSet`](crate::model::XssMatchSet)
    pub fn builder() -> crate::model::xss_match_set::Builder {
        crate::model::xss_match_set::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains the <code>Rules</code> that identify the requests that you want to allow, block, or count. In a <code>WebACL</code>, you also specify a default action (<code>ALLOW</code> or <code>BLOCK</code>), and the action for each <code>Rule</code> that you add to a <code>WebACL</code>, for example, block requests from specified IP addresses or block requests from specified referrers. You also associate the <code>WebACL</code> with a CloudFront distribution to identify the requests that you want AWS WAF to filter. If you add more than one <code>Rule</code> to a <code>WebACL</code>, a request needs to match only one of the specifications to be allowed, blocked, or counted. For more information, see <code>UpdateWebACL</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebAcl {
    /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
    /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    pub web_acl_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A friendly name or description for the metrics for this <code>WebACL</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. The action is specified by the <code>WafAction</code> object.</p>
    pub default_action: std::option::Option<crate::model::WafAction>,
    /// <p>An array that contains the action for each <code>Rule</code> in a <code>WebACL</code>, the priority of the <code>Rule</code>, and the ID of the <code>Rule</code>.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ActivatedRule>>,
    /// <p>Tha Amazon Resource Name (ARN) of the web ACL.</p>
    pub web_acl_arn: std::option::Option<std::string::String>,
}
impl WebAcl {
    /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
    /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    pub fn web_acl_id(&self) -> std::option::Option<&str> {
        self.web_acl_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A friendly name or description for the metrics for this <code>WebACL</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. The action is specified by the <code>WafAction</code> object.</p>
    pub fn default_action(&self) -> std::option::Option<&crate::model::WafAction> {
        self.default_action.as_ref()
    }
    /// <p>An array that contains the action for each <code>Rule</code> in a <code>WebACL</code>, the priority of the <code>Rule</code>, and the ID of the <code>Rule</code>.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::ActivatedRule]> {
        self.rules.as_deref()
    }
    /// <p>Tha Amazon Resource Name (ARN) of the web ACL.</p>
    pub fn web_acl_arn(&self) -> std::option::Option<&str> {
        self.web_acl_arn.as_deref()
    }
}
impl std::fmt::Debug for WebAcl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebAcl");
        formatter.field("web_acl_id", &self.web_acl_id);
        formatter.field("name", &self.name);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("default_action", &self.default_action);
        formatter.field("rules", &self.rules);
        formatter.field("web_acl_arn", &self.web_acl_arn);
        formatter.finish()
    }
}
/// See [`WebAcl`](crate::model::WebAcl)
pub mod web_acl {
    /// A builder for [`WebAcl`](crate::model::WebAcl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) web_acl_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) default_action: std::option::Option<crate::model::WafAction>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ActivatedRule>>,
        pub(crate) web_acl_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
        /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>WebACL</code>. You use <code>WebACLId</code> to get information about a <code>WebACL</code> (see <code>GetWebACL</code>), update a <code>WebACL</code> (see <code>UpdateWebACL</code>), and delete a <code>WebACL</code> from AWS WAF (see <code>DeleteWebACL</code>).</p>
        /// <p> <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>WebACL</code>. You can't change the name of a <code>WebACL</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>WebACL</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>WebACL</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. The action is specified by the <code>WafAction</code> object.</p>
        pub fn default_action(mut self, input: crate::model::WafAction) -> Self {
            self.default_action = Some(input);
            self
        }
        /// <p>The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. The action is specified by the <code>WafAction</code> object.</p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::WafAction>,
        ) -> Self {
            self.default_action = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array that contains the action for each <code>Rule</code> in a <code>WebACL</code>, the priority of the <code>Rule</code>, and the ID of the <code>Rule</code>.</p>
        pub fn rules(mut self, input: crate::model::ActivatedRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>An array that contains the action for each <code>Rule</code> in a <code>WebACL</code>, the priority of the <code>Rule</code>, and the ID of the <code>Rule</code>.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActivatedRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>Tha Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_acl_arn = Some(input.into());
            self
        }
        /// <p>Tha Amazon Resource Name (ARN) of the web ACL.</p>
        pub fn set_web_acl_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.web_acl_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`WebAcl`](crate::model::WebAcl)
        pub fn build(self) -> crate::model::WebAcl {
            crate::model::WebAcl {
                web_acl_id: self.web_acl_id,
                name: self.name,
                metric_name: self.metric_name,
                default_action: self.default_action,
                rules: self.rules,
                web_acl_arn: self.web_acl_arn,
            }
        }
    }
}
impl WebAcl {
    /// Creates a new builder-style object to manufacture [`WebAcl`](crate::model::WebAcl)
    pub fn builder() -> crate::model::web_acl::Builder {
        crate::model::web_acl::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A complex type that contains <code>SqlInjectionMatchTuple</code> objects, which specify the parts of web requests that you want AWS WAF to inspect for snippets of malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header. If a <code>SqlInjectionMatchSet</code> contains more than one <code>SqlInjectionMatchTuple</code> object, a request needs to include snippets of SQL code in only one of the specified parts of the request to be considered a match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlInjectionMatchSet {
    /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
    /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    pub sql_injection_match_set_id: std::option::Option<std::string::String>,
    /// <p>The name, if any, of the <code>SqlInjectionMatchSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.</p>
    pub sql_injection_match_tuples:
        std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchTuple>>,
}
impl SqlInjectionMatchSet {
    /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
    /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    pub fn sql_injection_match_set_id(&self) -> std::option::Option<&str> {
        self.sql_injection_match_set_id.as_deref()
    }
    /// <p>The name, if any, of the <code>SqlInjectionMatchSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.</p>
    pub fn sql_injection_match_tuples(
        &self,
    ) -> std::option::Option<&[crate::model::SqlInjectionMatchTuple]> {
        self.sql_injection_match_tuples.as_deref()
    }
}
impl std::fmt::Debug for SqlInjectionMatchSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlInjectionMatchSet");
        formatter.field(
            "sql_injection_match_set_id",
            &self.sql_injection_match_set_id,
        );
        formatter.field("name", &self.name);
        formatter.field(
            "sql_injection_match_tuples",
            &self.sql_injection_match_tuples,
        );
        formatter.finish()
    }
}
/// See [`SqlInjectionMatchSet`](crate::model::SqlInjectionMatchSet)
pub mod sql_injection_match_set {
    /// A builder for [`SqlInjectionMatchSet`](crate::model::SqlInjectionMatchSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql_injection_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sql_injection_match_tuples:
            std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchTuple>>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
        /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn sql_injection_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql_injection_match_set_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>SqlInjectionMatchSet</code>. You use <code>SqlInjectionMatchSetId</code> to get information about a <code>SqlInjectionMatchSet</code> (see <code>GetSqlInjectionMatchSet</code>), update a <code>SqlInjectionMatchSet</code> (see <code>UpdateSqlInjectionMatchSet</code>), insert a <code>SqlInjectionMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SqlInjectionMatchSet</code> from AWS WAF (see <code>DeleteSqlInjectionMatchSet</code>).</p>
        /// <p> <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sql_injection_match_set_id = input;
            self
        }
        /// <p>The name, if any, of the <code>SqlInjectionMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name, if any, of the <code>SqlInjectionMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `sql_injection_match_tuples`.
        ///
        /// To override the contents of this collection use [`set_sql_injection_match_tuples`](Self::set_sql_injection_match_tuples).
        ///
        /// <p>Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.</p>
        pub fn sql_injection_match_tuples(
            mut self,
            input: crate::model::SqlInjectionMatchTuple,
        ) -> Self {
            let mut v = self.sql_injection_match_tuples.unwrap_or_default();
            v.push(input);
            self.sql_injection_match_tuples = Some(v);
            self
        }
        /// <p>Specifies the parts of web requests that you want to inspect for snippets of malicious SQL code.</p>
        pub fn set_sql_injection_match_tuples(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchTuple>>,
        ) -> Self {
            self.sql_injection_match_tuples = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlInjectionMatchSet`](crate::model::SqlInjectionMatchSet)
        pub fn build(self) -> crate::model::SqlInjectionMatchSet {
            crate::model::SqlInjectionMatchSet {
                sql_injection_match_set_id: self.sql_injection_match_set_id,
                name: self.name,
                sql_injection_match_tuples: self.sql_injection_match_tuples,
            }
        }
    }
}
impl SqlInjectionMatchSet {
    /// Creates a new builder-style object to manufacture [`SqlInjectionMatchSet`](crate::model::SqlInjectionMatchSet)
    pub fn builder() -> crate::model::sql_injection_match_set::Builder {
        crate::model::sql_injection_match_set::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A complex type that contains <code>SizeConstraint</code> objects, which specify the parts of web requests that you want AWS WAF to inspect the size of. If a <code>SizeConstraintSet</code> contains more than one <code>SizeConstraint</code> object, a request only needs to match one constraint to be considered a match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SizeConstraintSet {
    /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
    /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    pub size_constraint_set_id: std::option::Option<std::string::String>,
    /// <p>The name, if any, of the <code>SizeConstraintSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the parts of web requests that you want to inspect the size of.</p>
    pub size_constraints: std::option::Option<std::vec::Vec<crate::model::SizeConstraint>>,
}
impl SizeConstraintSet {
    /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
    /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    pub fn size_constraint_set_id(&self) -> std::option::Option<&str> {
        self.size_constraint_set_id.as_deref()
    }
    /// <p>The name, if any, of the <code>SizeConstraintSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the parts of web requests that you want to inspect the size of.</p>
    pub fn size_constraints(&self) -> std::option::Option<&[crate::model::SizeConstraint]> {
        self.size_constraints.as_deref()
    }
}
impl std::fmt::Debug for SizeConstraintSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SizeConstraintSet");
        formatter.field("size_constraint_set_id", &self.size_constraint_set_id);
        formatter.field("name", &self.name);
        formatter.field("size_constraints", &self.size_constraints);
        formatter.finish()
    }
}
/// See [`SizeConstraintSet`](crate::model::SizeConstraintSet)
pub mod size_constraint_set {
    /// A builder for [`SizeConstraintSet`](crate::model::SizeConstraintSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_constraint_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) size_constraints:
            std::option::Option<std::vec::Vec<crate::model::SizeConstraint>>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
        /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn size_constraint_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.size_constraint_set_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>SizeConstraintSet</code>. You use <code>SizeConstraintSetId</code> to get information about a <code>SizeConstraintSet</code> (see <code>GetSizeConstraintSet</code>), update a <code>SizeConstraintSet</code> (see <code>UpdateSizeConstraintSet</code>), insert a <code>SizeConstraintSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>SizeConstraintSet</code> from AWS WAF (see <code>DeleteSizeConstraintSet</code>).</p>
        /// <p> <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.size_constraint_set_id = input;
            self
        }
        /// <p>The name, if any, of the <code>SizeConstraintSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name, if any, of the <code>SizeConstraintSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `size_constraints`.
        ///
        /// To override the contents of this collection use [`set_size_constraints`](Self::set_size_constraints).
        ///
        /// <p>Specifies the parts of web requests that you want to inspect the size of.</p>
        pub fn size_constraints(mut self, input: crate::model::SizeConstraint) -> Self {
            let mut v = self.size_constraints.unwrap_or_default();
            v.push(input);
            self.size_constraints = Some(v);
            self
        }
        /// <p>Specifies the parts of web requests that you want to inspect the size of.</p>
        pub fn set_size_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SizeConstraint>>,
        ) -> Self {
            self.size_constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`SizeConstraintSet`](crate::model::SizeConstraintSet)
        pub fn build(self) -> crate::model::SizeConstraintSet {
            crate::model::SizeConstraintSet {
                size_constraint_set_id: self.size_constraint_set_id,
                name: self.name,
                size_constraints: self.size_constraints,
            }
        }
    }
}
impl SizeConstraintSet {
    /// Creates a new builder-style object to manufacture [`SizeConstraintSet`](crate::model::SizeConstraintSet)
    pub fn builder() -> crate::model::size_constraint_set::Builder {
        crate::model::size_constraint_set::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>In a <code>GetSampledRequests</code> request, the <code>StartTime</code> and <code>EndTime</code> objects specify the time range for which you want AWS WAF to return a sample of web requests.</p>
/// <p>You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. </p>
/// <p>In a <code>GetSampledRequests</code> response, the <code>StartTime</code> and <code>EndTime</code> objects specify the time range for which AWS WAF actually returned a sample of web requests. AWS WAF gets the specified number of requests from among the first 5,000 requests that your AWS resource receives during the specified time period. If your resource receives more than 5,000 requests during that period, AWS WAF stops sampling after the 5,000th request. In that case, <code>EndTime</code> is the time that AWS WAF received the 5,000th request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeWindow {
    /// <p>The beginning of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl TimeWindow {
    /// <p>The beginning of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for TimeWindow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeWindow");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`TimeWindow`](crate::model::TimeWindow)
pub mod time_window {
    /// A builder for [`TimeWindow`](crate::model::TimeWindow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The beginning of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time range from which you want <code>GetSampledRequests</code> to return a sample of the requests that your AWS resource received. You must specify the date and time in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeWindow`](crate::model::TimeWindow)
        pub fn build(self) -> crate::model::TimeWindow {
            crate::model::TimeWindow {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl TimeWindow {
    /// Creates a new builder-style object to manufacture [`TimeWindow`](crate::model::TimeWindow)
    pub fn builder() -> crate::model::time_window::Builder {
        crate::model::time_window::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The response from a <code>GetSampledRequests</code> request includes a <code>SampledHTTPRequests</code> complex type that appears as <code>SampledRequests</code> in the response syntax. <code>SampledHTTPRequests</code> contains one <code>SampledHTTPRequest</code> object for each web request that is returned by <code>GetSampledRequests</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SampledHttpRequest {
    /// <p>A complex type that contains detailed information about the request.</p>
    pub request: std::option::Option<crate::model::HttpRequest>,
    /// <p>A value that indicates how one result in the response relates proportionally to other results in the response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web requests as a result that has a weight of <code>1</code>.</p>
    pub weight: i64,
    /// <p>The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the rule within the specified <code>RuleGroup</code> that matched the request listed in the response.</p>
    pub rule_within_rule_group: std::option::Option<std::string::String>,
}
impl SampledHttpRequest {
    /// <p>A complex type that contains detailed information about the request.</p>
    pub fn request(&self) -> std::option::Option<&crate::model::HttpRequest> {
        self.request.as_ref()
    }
    /// <p>A value that indicates how one result in the response relates proportionally to other results in the response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web requests as a result that has a weight of <code>1</code>.</p>
    pub fn weight(&self) -> i64 {
        self.weight
    }
    /// <p>The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the rule within the specified <code>RuleGroup</code> that matched the request listed in the response.</p>
    pub fn rule_within_rule_group(&self) -> std::option::Option<&str> {
        self.rule_within_rule_group.as_deref()
    }
}
impl std::fmt::Debug for SampledHttpRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SampledHttpRequest");
        formatter.field("request", &self.request);
        formatter.field("weight", &self.weight);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("action", &self.action);
        formatter.field("rule_within_rule_group", &self.rule_within_rule_group);
        formatter.finish()
    }
}
/// See [`SampledHttpRequest`](crate::model::SampledHttpRequest)
pub mod sampled_http_request {
    /// A builder for [`SampledHttpRequest`](crate::model::SampledHttpRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request: std::option::Option<crate::model::HttpRequest>,
        pub(crate) weight: std::option::Option<i64>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) rule_within_rule_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains detailed information about the request.</p>
        pub fn request(mut self, input: crate::model::HttpRequest) -> Self {
            self.request = Some(input);
            self
        }
        /// <p>A complex type that contains detailed information about the request.</p>
        pub fn set_request(
            mut self,
            input: std::option::Option<crate::model::HttpRequest>,
        ) -> Self {
            self.request = input;
            self
        }
        /// <p>A value that indicates how one result in the response relates proportionally to other results in the response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web requests as a result that has a weight of <code>1</code>.</p>
        pub fn weight(mut self, input: i64) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>A value that indicates how one result in the response relates proportionally to other results in the response. A result that has a weight of <code>2</code> represents roughly twice as many CloudFront web requests as a result that has a weight of <code>1</code>.</p>
        pub fn set_weight(mut self, input: std::option::Option<i64>) -> Self {
            self.weight = input;
            self
        }
        /// <p>The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The action for the <code>Rule</code> that the request matched: <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the rule within the specified <code>RuleGroup</code> that matched the request listed in the response.</p>
        pub fn rule_within_rule_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_within_rule_group = Some(input.into());
            self
        }
        /// <p>This value is returned if the <code>GetSampledRequests</code> request specifies the ID of a <code>RuleGroup</code> rather than the ID of an individual rule. <code>RuleWithinRuleGroup</code> is the rule within the specified <code>RuleGroup</code> that matched the request listed in the response.</p>
        pub fn set_rule_within_rule_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_within_rule_group = input;
            self
        }
        /// Consumes the builder and constructs a [`SampledHttpRequest`](crate::model::SampledHttpRequest)
        pub fn build(self) -> crate::model::SampledHttpRequest {
            crate::model::SampledHttpRequest {
                request: self.request,
                weight: self.weight.unwrap_or_default(),
                timestamp: self.timestamp,
                action: self.action,
                rule_within_rule_group: self.rule_within_rule_group,
            }
        }
    }
}
impl SampledHttpRequest {
    /// Creates a new builder-style object to manufacture [`SampledHttpRequest`](crate::model::SampledHttpRequest)
    pub fn builder() -> crate::model::sampled_http_request::Builder {
        crate::model::sampled_http_request::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The response from a <code>GetSampledRequests</code> request includes an <code>HTTPRequest</code> complex type that appears as <code>Request</code> in the response syntax. <code>HTTPRequest</code> contains information about one of the web requests that were returned by <code>GetSampledRequests</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpRequest {
    /// <p>The IP address that the request originated from. If the <code>WebACL</code> is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:</p>
    /// <ul>
    /// <li> <p> <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request</p> </li>
    /// <li> <p> <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request</p> </li>
    /// </ul>
    pub client_ip: std::option::Option<std::string::String>,
    /// <p>The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The part of a web request that identifies the resource, for example, <code>/images/daily-ad.jpg</code>.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The HTTP method specified in the sampled web request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>. </p>
    pub method: std::option::Option<std::string::String>,
    /// <p>The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.</p>
    pub http_version: std::option::Option<std::string::String>,
    /// <p>A complex type that contains two values for each header in the sampled web request: the name of the header and the value of the header.</p>
    pub headers: std::option::Option<std::vec::Vec<crate::model::HttpHeader>>,
}
impl HttpRequest {
    /// <p>The IP address that the request originated from. If the <code>WebACL</code> is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:</p>
    /// <ul>
    /// <li> <p> <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request</p> </li>
    /// <li> <p> <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request</p> </li>
    /// </ul>
    pub fn client_ip(&self) -> std::option::Option<&str> {
        self.client_ip.as_deref()
    }
    /// <p>The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>The part of a web request that identifies the resource, for example, <code>/images/daily-ad.jpg</code>.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The HTTP method specified in the sampled web request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>. </p>
    pub fn method(&self) -> std::option::Option<&str> {
        self.method.as_deref()
    }
    /// <p>The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.</p>
    pub fn http_version(&self) -> std::option::Option<&str> {
        self.http_version.as_deref()
    }
    /// <p>A complex type that contains two values for each header in the sampled web request: the name of the header and the value of the header.</p>
    pub fn headers(&self) -> std::option::Option<&[crate::model::HttpHeader]> {
        self.headers.as_deref()
    }
}
impl std::fmt::Debug for HttpRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpRequest");
        formatter.field("client_ip", &self.client_ip);
        formatter.field("country", &self.country);
        formatter.field("uri", &self.uri);
        formatter.field("method", &self.method);
        formatter.field("http_version", &self.http_version);
        formatter.field("headers", &self.headers);
        formatter.finish()
    }
}
/// See [`HttpRequest`](crate::model::HttpRequest)
pub mod http_request {
    /// A builder for [`HttpRequest`](crate::model::HttpRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_ip: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) method: std::option::Option<std::string::String>,
        pub(crate) http_version: std::option::Option<std::string::String>,
        pub(crate) headers: std::option::Option<std::vec::Vec<crate::model::HttpHeader>>,
    }
    impl Builder {
        /// <p>The IP address that the request originated from. If the <code>WebACL</code> is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:</p>
        /// <ul>
        /// <li> <p> <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request</p> </li>
        /// <li> <p> <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request</p> </li>
        /// </ul>
        pub fn client_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_ip = Some(input.into());
            self
        }
        /// <p>The IP address that the request originated from. If the <code>WebACL</code> is associated with a CloudFront distribution, this is the value of one of the following fields in CloudFront access logs:</p>
        /// <ul>
        /// <li> <p> <code>c-ip</code>, if the viewer did not use an HTTP proxy or a load balancer to send the request</p> </li>
        /// <li> <p> <code>x-forwarded-for</code>, if the viewer did use an HTTP proxy or a load balancer to send the request</p> </li>
        /// </ul>
        pub fn set_client_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_ip = input;
            self
        }
        /// <p>The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The two-letter country code for the country that the request originated from. For a current list of country codes, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a>.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The part of a web request that identifies the resource, for example, <code>/images/daily-ad.jpg</code>.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The part of a web request that identifies the resource, for example, <code>/images/daily-ad.jpg</code>.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The HTTP method specified in the sampled web request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>. </p>
        pub fn method(mut self, input: impl Into<std::string::String>) -> Self {
            self.method = Some(input.into());
            self
        }
        /// <p>The HTTP method specified in the sampled web request. CloudFront supports the following methods: <code>DELETE</code>, <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PATCH</code>, <code>POST</code>, and <code>PUT</code>. </p>
        pub fn set_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.method = input;
            self
        }
        /// <p>The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.</p>
        pub fn http_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_version = Some(input.into());
            self
        }
        /// <p>The HTTP version specified in the sampled web request, for example, <code>HTTP/1.1</code>.</p>
        pub fn set_http_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_version = input;
            self
        }
        /// Appends an item to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p>A complex type that contains two values for each header in the sampled web request: the name of the header and the value of the header.</p>
        pub fn headers(mut self, input: crate::model::HttpHeader) -> Self {
            let mut v = self.headers.unwrap_or_default();
            v.push(input);
            self.headers = Some(v);
            self
        }
        /// <p>A complex type that contains two values for each header in the sampled web request: the name of the header and the value of the header.</p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HttpHeader>>,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpRequest`](crate::model::HttpRequest)
        pub fn build(self) -> crate::model::HttpRequest {
            crate::model::HttpRequest {
                client_ip: self.client_ip,
                country: self.country,
                uri: self.uri,
                method: self.method,
                http_version: self.http_version,
                headers: self.headers,
            }
        }
    }
}
impl HttpRequest {
    /// Creates a new builder-style object to manufacture [`HttpRequest`](crate::model::HttpRequest)
    pub fn builder() -> crate::model::http_request::Builder {
        crate::model::http_request::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The response from a <code>GetSampledRequests</code> request includes an <code>HTTPHeader</code> complex type that appears as <code>Headers</code> in the response syntax. <code>HTTPHeader</code> contains the names and values of all of the headers that appear in one of the web requests that were returned by <code>GetSampledRequests</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpHeader {
    /// <p>The name of one of the headers in the sampled web request.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of one of the headers in the sampled web request.</p>
    pub value: std::option::Option<std::string::String>,
}
impl HttpHeader {
    /// <p>The name of one of the headers in the sampled web request.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of one of the headers in the sampled web request.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for HttpHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpHeader");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`HttpHeader`](crate::model::HttpHeader)
pub mod http_header {
    /// A builder for [`HttpHeader`](crate::model::HttpHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of one of the headers in the sampled web request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of one of the headers in the sampled web request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of one of the headers in the sampled web request.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of one of the headers in the sampled web request.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpHeader`](crate::model::HttpHeader)
        pub fn build(self) -> crate::model::HttpHeader {
            crate::model::HttpHeader {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl HttpHeader {
    /// Creates a new builder-style object to manufacture [`HttpHeader`](crate::model::HttpHeader)
    pub fn builder() -> crate::model::http_header::Builder {
        crate::model::http_header::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A collection of predefined rules that you can add to a web ACL.</p>
/// <p>Rule groups are subject to the following limits:</p>
/// <ul>
/// <li> <p>Three rule groups per account. You can request an increase to this limit by contacting customer support.</p> </li>
/// <li> <p>One rule group per web ACL.</p> </li>
/// <li> <p>Ten rules per rule group.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleGroup {
    /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
    /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    pub rule_group_id: std::option::Option<std::string::String>,
    /// <p>The friendly name or description for the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
    pub metric_name: std::option::Option<std::string::String>,
}
impl RuleGroup {
    /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
    /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    pub fn rule_group_id(&self) -> std::option::Option<&str> {
        self.rule_group_id.as_deref()
    }
    /// <p>The friendly name or description for the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
}
impl std::fmt::Debug for RuleGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleGroup");
        formatter.field("rule_group_id", &self.rule_group_id);
        formatter.field("name", &self.name);
        formatter.field("metric_name", &self.metric_name);
        formatter.finish()
    }
}
/// See [`RuleGroup`](crate::model::RuleGroup)
pub mod rule_group {
    /// A builder for [`RuleGroup`](crate::model::RuleGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
        /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_group_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>RuleGroup</code>. You use <code>RuleGroupId</code> to get more information about a <code>RuleGroup</code> (see <code>GetRuleGroup</code>), update a <code>RuleGroup</code> (see <code>UpdateRuleGroup</code>), insert a <code>RuleGroup</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RuleGroup</code> from AWS WAF (see <code>DeleteRuleGroup</code>).</p>
        /// <p> <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_group_id = input;
            self
        }
        /// <p>The friendly name or description for the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name or description for the <code>RuleGroup</code>. You can't change the name of a <code>RuleGroup</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleGroup`](crate::model::RuleGroup)
        pub fn build(self) -> crate::model::RuleGroup {
            crate::model::RuleGroup {
                rule_group_id: self.rule_group_id,
                name: self.name,
                metric_name: self.metric_name,
            }
        }
    }
}
impl RuleGroup {
    /// Creates a new builder-style object to manufacture [`RuleGroup`](crate::model::RuleGroup)
    pub fn builder() -> crate::model::rule_group::Builder {
        crate::model::rule_group::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A combination of <code>ByteMatchSet</code>, <code>IPSet</code>, and/or <code>SqlInjectionMatchSet</code> objects that identify the web requests that you want to allow, block, or count. For example, you might create a <code>Rule</code> that includes the following predicates:</p>
/// <ul>
/// <li> <p>An <code>IPSet</code> that causes AWS WAF to search for web requests that originate from the IP address <code>192.0.2.44</code> </p> </li>
/// <li> <p>A <code>ByteMatchSet</code> that causes AWS WAF to search for web requests for which the value of the <code>User-Agent</code> header is <code>BadBot</code>.</p> </li>
/// </ul>
/// <p>To match the settings in this <code>Rule</code>, a request must originate from <code>192.0.2.44</code> AND include a <code>User-Agent</code> header for which the value is <code>BadBot</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rule {
    /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
    /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>The friendly name or description for the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>Rule</code>.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code>.</p>
    pub predicates: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
}
impl Rule {
    /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
    /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>The friendly name or description for the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>Rule</code>.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code>.</p>
    pub fn predicates(&self) -> std::option::Option<&[crate::model::Predicate]> {
        self.predicates.as_deref()
    }
}
impl std::fmt::Debug for Rule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rule");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("name", &self.name);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("predicates", &self.predicates);
        formatter.finish()
    }
}
/// See [`Rule`](crate::model::Rule)
pub mod rule {
    /// A builder for [`Rule`](crate::model::Rule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) predicates: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
        /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>Rule</code>. You use <code>RuleId</code> to get more information about a <code>Rule</code> (see <code>GetRule</code>), update a <code>Rule</code> (see <code>UpdateRule</code>), insert a <code>Rule</code> into a <code>WebACL</code> or delete a one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>Rule</code> from AWS WAF (see <code>DeleteRule</code>).</p>
        /// <p> <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>The friendly name or description for the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name or description for the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>Rule</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>Rule</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `predicates`.
        ///
        /// To override the contents of this collection use [`set_predicates`](Self::set_predicates).
        ///
        /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code>.</p>
        pub fn predicates(mut self, input: crate::model::Predicate) -> Self {
            let mut v = self.predicates.unwrap_or_default();
            v.push(input);
            self.predicates = Some(v);
            self
        }
        /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code>.</p>
        pub fn set_predicates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        ) -> Self {
            self.predicates = input;
            self
        }
        /// Consumes the builder and constructs a [`Rule`](crate::model::Rule)
        pub fn build(self) -> crate::model::Rule {
            crate::model::Rule {
                rule_id: self.rule_id,
                name: self.name,
                metric_name: self.metric_name,
                predicates: self.predicates,
            }
        }
    }
}
impl Rule {
    /// Creates a new builder-style object to manufacture [`Rule`](crate::model::Rule)
    pub fn builder() -> crate::model::rule::Builder {
        crate::model::rule::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>The <code>RegexPatternSet</code> specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexPatternSet {
    /// <p>The identifier for the <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
    /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    pub regex_pattern_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
    pub regex_pattern_strings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RegexPatternSet {
    /// <p>The identifier for the <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
    /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    pub fn regex_pattern_set_id(&self) -> std::option::Option<&str> {
        self.regex_pattern_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
    pub fn regex_pattern_strings(&self) -> std::option::Option<&[std::string::String]> {
        self.regex_pattern_strings.as_deref()
    }
}
impl std::fmt::Debug for RegexPatternSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexPatternSet");
        formatter.field("regex_pattern_set_id", &self.regex_pattern_set_id);
        formatter.field("name", &self.name);
        formatter.field("regex_pattern_strings", &self.regex_pattern_strings);
        formatter.finish()
    }
}
/// See [`RegexPatternSet`](crate::model::RegexPatternSet)
pub mod regex_pattern_set {
    /// A builder for [`RegexPatternSet`](crate::model::RegexPatternSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_pattern_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) regex_pattern_strings: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier for the <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
        /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn regex_pattern_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex_pattern_set_id = Some(input.into());
            self
        }
        /// <p>The identifier for the <code>RegexPatternSet</code>. You use <code>RegexPatternSetId</code> to get information about a <code>RegexPatternSet</code>, update a <code>RegexPatternSet</code>, remove a <code>RegexPatternSet</code> from a <code>RegexMatchSet</code>, and delete a <code>RegexPatternSet</code> from AWS WAF.</p>
        /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regex_pattern_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `regex_pattern_strings`.
        ///
        /// To override the contents of this collection use [`set_regex_pattern_strings`](Self::set_regex_pattern_strings).
        ///
        /// <p>Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
        pub fn regex_pattern_strings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regex_pattern_strings.unwrap_or_default();
            v.push(input.into());
            self.regex_pattern_strings = Some(v);
            self
        }
        /// <p>Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>.</p>
        pub fn set_regex_pattern_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regex_pattern_strings = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexPatternSet`](crate::model::RegexPatternSet)
        pub fn build(self) -> crate::model::RegexPatternSet {
            crate::model::RegexPatternSet {
                regex_pattern_set_id: self.regex_pattern_set_id,
                name: self.name,
                regex_pattern_strings: self.regex_pattern_strings,
            }
        }
    }
}
impl RegexPatternSet {
    /// Creates a new builder-style object to manufacture [`RegexPatternSet`](crate::model::RegexPatternSet)
    pub fn builder() -> crate::model::regex_pattern_set::Builder {
        crate::model::regex_pattern_set::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>In a <code>GetRegexMatchSet</code> request, <code>RegexMatchSet</code> is a complex type that contains the <code>RegexMatchSetId</code> and <code>Name</code> of a <code>RegexMatchSet</code>, and the values that you specified when you updated the <code>RegexMatchSet</code>.</p>
/// <p> The values are contained in a <code>RegexMatchTuple</code> object, which specify the parts of web requests that you want AWS WAF to inspect and the values that you want AWS WAF to search for. If a <code>RegexMatchSet</code> contains more than one <code>RegexMatchTuple</code> object, a request needs to match the settings in only one <code>ByteMatchTuple</code> to be considered a match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegexMatchSet {
    /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code> (see <code>GetRegexMatchSet</code>), update a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), insert a <code>RegexMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>RegexMatchSet</code> from AWS WAF (see <code>DeleteRegexMatchSet</code>).</p>
    /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    pub regex_match_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Contains an array of <code>RegexMatchTuple</code> objects. Each <code>RegexMatchTuple</code> object contains: </p>
    /// <ul>
    /// <li> <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
    /// <li> <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <code>RegexPatternSet</code>.</p> </li>
    /// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
    /// </ul>
    pub regex_match_tuples: std::option::Option<std::vec::Vec<crate::model::RegexMatchTuple>>,
}
impl RegexMatchSet {
    /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code> (see <code>GetRegexMatchSet</code>), update a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), insert a <code>RegexMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>RegexMatchSet</code> from AWS WAF (see <code>DeleteRegexMatchSet</code>).</p>
    /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    pub fn regex_match_set_id(&self) -> std::option::Option<&str> {
        self.regex_match_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Contains an array of <code>RegexMatchTuple</code> objects. Each <code>RegexMatchTuple</code> object contains: </p>
    /// <ul>
    /// <li> <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
    /// <li> <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <code>RegexPatternSet</code>.</p> </li>
    /// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
    /// </ul>
    pub fn regex_match_tuples(&self) -> std::option::Option<&[crate::model::RegexMatchTuple]> {
        self.regex_match_tuples.as_deref()
    }
}
impl std::fmt::Debug for RegexMatchSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegexMatchSet");
        formatter.field("regex_match_set_id", &self.regex_match_set_id);
        formatter.field("name", &self.name);
        formatter.field("regex_match_tuples", &self.regex_match_tuples);
        formatter.finish()
    }
}
/// See [`RegexMatchSet`](crate::model::RegexMatchSet)
pub mod regex_match_set {
    /// A builder for [`RegexMatchSet`](crate::model::RegexMatchSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) regex_match_tuples:
            std::option::Option<std::vec::Vec<crate::model::RegexMatchTuple>>,
    }
    impl Builder {
        /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code> (see <code>GetRegexMatchSet</code>), update a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), insert a <code>RegexMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>RegexMatchSet</code> from AWS WAF (see <code>DeleteRegexMatchSet</code>).</p>
        /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn regex_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex_match_set_id = Some(input.into());
            self
        }
        /// <p>The <code>RegexMatchSetId</code> for a <code>RegexMatchSet</code>. You use <code>RegexMatchSetId</code> to get information about a <code>RegexMatchSet</code> (see <code>GetRegexMatchSet</code>), update a <code>RegexMatchSet</code> (see <code>UpdateRegexMatchSet</code>), insert a <code>RegexMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>RegexMatchSet</code> from AWS WAF (see <code>DeleteRegexMatchSet</code>).</p>
        /// <p> <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.regex_match_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `regex_match_tuples`.
        ///
        /// To override the contents of this collection use [`set_regex_match_tuples`](Self::set_regex_match_tuples).
        ///
        /// <p>Contains an array of <code>RegexMatchTuple</code> objects. Each <code>RegexMatchTuple</code> object contains: </p>
        /// <ul>
        /// <li> <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
        /// <li> <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <code>RegexPatternSet</code>.</p> </li>
        /// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
        /// </ul>
        pub fn regex_match_tuples(mut self, input: crate::model::RegexMatchTuple) -> Self {
            let mut v = self.regex_match_tuples.unwrap_or_default();
            v.push(input);
            self.regex_match_tuples = Some(v);
            self
        }
        /// <p>Contains an array of <code>RegexMatchTuple</code> objects. Each <code>RegexMatchTuple</code> object contains: </p>
        /// <ul>
        /// <li> <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
        /// <li> <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <code>RegexPatternSet</code>.</p> </li>
        /// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
        /// </ul>
        pub fn set_regex_match_tuples(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexMatchTuple>>,
        ) -> Self {
            self.regex_match_tuples = input;
            self
        }
        /// Consumes the builder and constructs a [`RegexMatchSet`](crate::model::RegexMatchSet)
        pub fn build(self) -> crate::model::RegexMatchSet {
            crate::model::RegexMatchSet {
                regex_match_set_id: self.regex_match_set_id,
                name: self.name,
                regex_match_tuples: self.regex_match_tuples,
            }
        }
    }
}
impl RegexMatchSet {
    /// Creates a new builder-style object to manufacture [`RegexMatchSet`](crate::model::RegexMatchSet)
    pub fn builder() -> crate::model::regex_match_set::Builder {
        crate::model::regex_match_set::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>A <code>RateBasedRule</code> is identical to a regular <code>Rule</code>, with one addition: a <code>RateBasedRule</code> counts the number of requests that arrive from a specified IP address every five minutes. For example, based on recent requests that you've seen from an attacker, you might create a <code>RateBasedRule</code> that includes the following conditions: </p>
/// <ul>
/// <li> <p>The requests come from 192.0.2.44.</p> </li>
/// <li> <p>They contain the value <code>BadBot</code> in the <code>User-Agent</code> header.</p> </li>
/// </ul>
/// <p>In the rule, you also define the rate limit as 1,000.</p>
/// <p>Requests that meet both of these conditions and exceed 1,000 requests every five minutes trigger the rule's action (block or count), which is defined in the web ACL.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RateBasedRule {
    /// <p>A unique identifier for a <code>RateBasedRule</code>. You use <code>RuleId</code> to get more information about a <code>RateBasedRule</code> (see <code>GetRateBasedRule</code>), update a <code>RateBasedRule</code> (see <code>UpdateRateBasedRule</code>), insert a <code>RateBasedRule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RateBasedRule</code> from AWS WAF (see <code>DeleteRateBasedRule</code>).</p>
    pub rule_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description for a <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A friendly name or description for the metrics for a <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>RateBasedRule</code>.</p>
    pub match_predicates: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
    /// <p>The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
    pub rate_key: std::option::Option<crate::model::RateKey>,
    /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
    pub rate_limit: i64,
}
impl RateBasedRule {
    /// <p>A unique identifier for a <code>RateBasedRule</code>. You use <code>RuleId</code> to get more information about a <code>RateBasedRule</code> (see <code>GetRateBasedRule</code>), update a <code>RateBasedRule</code> (see <code>UpdateRateBasedRule</code>), insert a <code>RateBasedRule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RateBasedRule</code> from AWS WAF (see <code>DeleteRateBasedRule</code>).</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
    /// <p>A friendly name or description for a <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A friendly name or description for the metrics for a <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>RateBasedRule</code>.</p>
    pub fn match_predicates(&self) -> std::option::Option<&[crate::model::Predicate]> {
        self.match_predicates.as_deref()
    }
    /// <p>The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
    pub fn rate_key(&self) -> std::option::Option<&crate::model::RateKey> {
        self.rate_key.as_ref()
    }
    /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
    pub fn rate_limit(&self) -> i64 {
        self.rate_limit
    }
}
impl std::fmt::Debug for RateBasedRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RateBasedRule");
        formatter.field("rule_id", &self.rule_id);
        formatter.field("name", &self.name);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("match_predicates", &self.match_predicates);
        formatter.field("rate_key", &self.rate_key);
        formatter.field("rate_limit", &self.rate_limit);
        formatter.finish()
    }
}
/// See [`RateBasedRule`](crate::model::RateBasedRule)
pub mod rate_based_rule {
    /// A builder for [`RateBasedRule`](crate::model::RateBasedRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) match_predicates: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        pub(crate) rate_key: std::option::Option<crate::model::RateKey>,
        pub(crate) rate_limit: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>A unique identifier for a <code>RateBasedRule</code>. You use <code>RuleId</code> to get more information about a <code>RateBasedRule</code> (see <code>GetRateBasedRule</code>), update a <code>RateBasedRule</code> (see <code>UpdateRateBasedRule</code>), insert a <code>RateBasedRule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RateBasedRule</code> from AWS WAF (see <code>DeleteRateBasedRule</code>).</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a <code>RateBasedRule</code>. You use <code>RuleId</code> to get more information about a <code>RateBasedRule</code> (see <code>GetRateBasedRule</code>), update a <code>RateBasedRule</code> (see <code>UpdateRateBasedRule</code>), insert a <code>RateBasedRule</code> into a <code>WebACL</code> or delete one from a <code>WebACL</code> (see <code>UpdateWebACL</code>), or delete a <code>RateBasedRule</code> from AWS WAF (see <code>DeleteRateBasedRule</code>).</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// <p>A friendly name or description for a <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description for a <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A friendly name or description for the metrics for a <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for a <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `match_predicates`.
        ///
        /// To override the contents of this collection use [`set_match_predicates`](Self::set_match_predicates).
        ///
        /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>RateBasedRule</code>.</p>
        pub fn match_predicates(mut self, input: crate::model::Predicate) -> Self {
            let mut v = self.match_predicates.unwrap_or_default();
            v.push(input);
            self.match_predicates = Some(v);
            self
        }
        /// <p>The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code>, <code>IPSet</code>, or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>RateBasedRule</code>.</p>
        pub fn set_match_predicates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Predicate>>,
        ) -> Self {
            self.match_predicates = input;
            self
        }
        /// <p>The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
        pub fn rate_key(mut self, input: crate::model::RateKey) -> Self {
            self.rate_key = Some(input);
            self
        }
        /// <p>The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
        pub fn set_rate_key(mut self, input: std::option::Option<crate::model::RateKey>) -> Self {
            self.rate_key = input;
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn rate_limit(mut self, input: i64) -> Self {
            self.rate_limit = Some(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.rate_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`RateBasedRule`](crate::model::RateBasedRule)
        pub fn build(self) -> crate::model::RateBasedRule {
            crate::model::RateBasedRule {
                rule_id: self.rule_id,
                name: self.name,
                metric_name: self.metric_name,
                match_predicates: self.match_predicates,
                rate_key: self.rate_key,
                rate_limit: self.rate_limit.unwrap_or_default(),
            }
        }
    }
}
impl RateBasedRule {
    /// Creates a new builder-style object to manufacture [`RateBasedRule`](crate::model::RateBasedRule)
    pub fn builder() -> crate::model::rate_based_rule::Builder {
        crate::model::rate_based_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RateKey {
    #[allow(missing_docs)] // documentation missing in model
    Ip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RateKey {
    fn from(s: &str) -> Self {
        match s {
            "IP" => RateKey::Ip,
            other => RateKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RateKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RateKey::from(s))
    }
}
impl RateKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RateKey::Ip => "IP",
            RateKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IP"]
    }
}
impl AsRef<str> for RateKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains one or more IP addresses or blocks of IP addresses specified in Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128.</p>
/// <p>To specify an individual IP address, you specify the four-part IP address followed by a <code>/32</code>, for example, 192.0.2.0/32. To block a range of IP addresses, you can specify /8 or any range between /16 through /32 (for IPv4) or /24, /32, /48, /56, /64, or /128 (for IPv6). For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpSet {
    /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You use <code>IPSetId</code> to get information about an <code>IPSet</code> (see <code>GetIPSet</code>), update an <code>IPSet</code> (see <code>UpdateIPSet</code>), insert an <code>IPSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>IPSet</code> from AWS WAF (see <code>DeleteIPSet</code>).</p>
    /// <p> <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
    pub ip_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from. If the <code>WebACL</code> is associated with a CloudFront distribution and the viewer did not use an HTTP proxy or a load balancer to send the request, this is the value of the c-ip field in the CloudFront access logs.</p>
    pub ip_set_descriptors: std::option::Option<std::vec::Vec<crate::model::IpSetDescriptor>>,
}
impl IpSet {
    /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You use <code>IPSetId</code> to get information about an <code>IPSet</code> (see <code>GetIPSet</code>), update an <code>IPSet</code> (see <code>UpdateIPSet</code>), insert an <code>IPSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>IPSet</code> from AWS WAF (see <code>DeleteIPSet</code>).</p>
    /// <p> <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
    pub fn ip_set_id(&self) -> std::option::Option<&str> {
        self.ip_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from. If the <code>WebACL</code> is associated with a CloudFront distribution and the viewer did not use an HTTP proxy or a load balancer to send the request, this is the value of the c-ip field in the CloudFront access logs.</p>
    pub fn ip_set_descriptors(&self) -> std::option::Option<&[crate::model::IpSetDescriptor]> {
        self.ip_set_descriptors.as_deref()
    }
}
impl std::fmt::Debug for IpSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpSet");
        formatter.field("ip_set_id", &self.ip_set_id);
        formatter.field("name", &self.name);
        formatter.field("ip_set_descriptors", &self.ip_set_descriptors);
        formatter.finish()
    }
}
/// See [`IpSet`](crate::model::IpSet)
pub mod ip_set {
    /// A builder for [`IpSet`](crate::model::IpSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_set_descriptors:
            std::option::Option<std::vec::Vec<crate::model::IpSetDescriptor>>,
    }
    impl Builder {
        /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You use <code>IPSetId</code> to get information about an <code>IPSet</code> (see <code>GetIPSet</code>), update an <code>IPSet</code> (see <code>UpdateIPSet</code>), insert an <code>IPSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>IPSet</code> from AWS WAF (see <code>DeleteIPSet</code>).</p>
        /// <p> <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_set_id = Some(input.into());
            self
        }
        /// <p>The <code>IPSetId</code> for an <code>IPSet</code>. You use <code>IPSetId</code> to get information about an <code>IPSet</code> (see <code>GetIPSet</code>), update an <code>IPSet</code> (see <code>UpdateIPSet</code>), insert an <code>IPSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete an <code>IPSet</code> from AWS WAF (see <code>DeleteIPSet</code>).</p>
        /// <p> <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>IPSet</code>. You can't change the name of an <code>IPSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `ip_set_descriptors`.
        ///
        /// To override the contents of this collection use [`set_ip_set_descriptors`](Self::set_ip_set_descriptors).
        ///
        /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from. If the <code>WebACL</code> is associated with a CloudFront distribution and the viewer did not use an HTTP proxy or a load balancer to send the request, this is the value of the c-ip field in the CloudFront access logs.</p>
        pub fn ip_set_descriptors(mut self, input: crate::model::IpSetDescriptor) -> Self {
            let mut v = self.ip_set_descriptors.unwrap_or_default();
            v.push(input);
            self.ip_set_descriptors = Some(v);
            self
        }
        /// <p>The IP address type (<code>IPV4</code> or <code>IPV6</code>) and the IP address range (in CIDR notation) that web requests originate from. If the <code>WebACL</code> is associated with a CloudFront distribution and the viewer did not use an HTTP proxy or a load balancer to send the request, this is the value of the c-ip field in the CloudFront access logs.</p>
        pub fn set_ip_set_descriptors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpSetDescriptor>>,
        ) -> Self {
            self.ip_set_descriptors = input;
            self
        }
        /// Consumes the builder and constructs a [`IpSet`](crate::model::IpSet)
        pub fn build(self) -> crate::model::IpSet {
            crate::model::IpSet {
                ip_set_id: self.ip_set_id,
                name: self.name,
                ip_set_descriptors: self.ip_set_descriptors,
            }
        }
    }
}
impl IpSet {
    /// Creates a new builder-style object to manufacture [`IpSet`](crate::model::IpSet)
    pub fn builder() -> crate::model::ip_set::Builder {
        crate::model::ip_set::Builder::default()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>Contains one or more countries that AWS WAF will search for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoMatchSet {
    /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get information about a <code>GeoMatchSet</code> (see <code>GeoMatchSet</code>), update a <code>GeoMatchSet</code> (see <code>UpdateGeoMatchSet</code>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>GeoMatchSet</code> from AWS WAF (see <code>DeleteGeoMatchSet</code>).</p>
    /// <p> <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
    pub geo_match_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.</p>
    pub geo_match_constraints: std::option::Option<std::vec::Vec<crate::model::GeoMatchConstraint>>,
}
impl GeoMatchSet {
    /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get information about a <code>GeoMatchSet</code> (see <code>GeoMatchSet</code>), update a <code>GeoMatchSet</code> (see <code>UpdateGeoMatchSet</code>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>GeoMatchSet</code> from AWS WAF (see <code>DeleteGeoMatchSet</code>).</p>
    /// <p> <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
    pub fn geo_match_set_id(&self) -> std::option::Option<&str> {
        self.geo_match_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.</p>
    pub fn geo_match_constraints(
        &self,
    ) -> std::option::Option<&[crate::model::GeoMatchConstraint]> {
        self.geo_match_constraints.as_deref()
    }
}
impl std::fmt::Debug for GeoMatchSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoMatchSet");
        formatter.field("geo_match_set_id", &self.geo_match_set_id);
        formatter.field("name", &self.name);
        formatter.field("geo_match_constraints", &self.geo_match_constraints);
        formatter.finish()
    }
}
/// See [`GeoMatchSet`](crate::model::GeoMatchSet)
pub mod geo_match_set {
    /// A builder for [`GeoMatchSet`](crate::model::GeoMatchSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) geo_match_constraints:
            std::option::Option<std::vec::Vec<crate::model::GeoMatchConstraint>>,
    }
    impl Builder {
        /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get information about a <code>GeoMatchSet</code> (see <code>GeoMatchSet</code>), update a <code>GeoMatchSet</code> (see <code>UpdateGeoMatchSet</code>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>GeoMatchSet</code> from AWS WAF (see <code>DeleteGeoMatchSet</code>).</p>
        /// <p> <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn geo_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geo_match_set_id = Some(input.into());
            self
        }
        /// <p>The <code>GeoMatchSetId</code> for an <code>GeoMatchSet</code>. You use <code>GeoMatchSetId</code> to get information about a <code>GeoMatchSet</code> (see <code>GeoMatchSet</code>), update a <code>GeoMatchSet</code> (see <code>UpdateGeoMatchSet</code>), insert a <code>GeoMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>GeoMatchSet</code> from AWS WAF (see <code>DeleteGeoMatchSet</code>).</p>
        /// <p> <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.geo_match_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change the name of an <code>GeoMatchSet</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `geo_match_constraints`.
        ///
        /// To override the contents of this collection use [`set_geo_match_constraints`](Self::set_geo_match_constraints).
        ///
        /// <p>An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.</p>
        pub fn geo_match_constraints(mut self, input: crate::model::GeoMatchConstraint) -> Self {
            let mut v = self.geo_match_constraints.unwrap_or_default();
            v.push(input);
            self.geo_match_constraints = Some(v);
            self
        }
        /// <p>An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.</p>
        pub fn set_geo_match_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeoMatchConstraint>>,
        ) -> Self {
            self.geo_match_constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoMatchSet`](crate::model::GeoMatchSet)
        pub fn build(self) -> crate::model::GeoMatchSet {
            crate::model::GeoMatchSet {
                geo_match_set_id: self.geo_match_set_id,
                name: self.name,
                geo_match_constraints: self.geo_match_constraints,
            }
        }
    }
}
impl GeoMatchSet {
    /// Creates a new builder-style object to manufacture [`GeoMatchSet`](crate::model::GeoMatchSet)
    pub fn builder() -> crate::model::geo_match_set::Builder {
        crate::model::geo_match_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeTokenStatus {
    #[allow(missing_docs)] // documentation missing in model
    Insync,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Provisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeTokenStatus {
    fn from(s: &str) -> Self {
        match s {
            "INSYNC" => ChangeTokenStatus::Insync,
            "PENDING" => ChangeTokenStatus::Pending,
            "PROVISIONED" => ChangeTokenStatus::Provisioned,
            other => ChangeTokenStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeTokenStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeTokenStatus::from(s))
    }
}
impl ChangeTokenStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeTokenStatus::Insync => "INSYNC",
            ChangeTokenStatus::Pending => "PENDING",
            ChangeTokenStatus::Provisioned => "PROVISIONED",
            ChangeTokenStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSYNC", "PENDING", "PROVISIONED"]
    }
}
impl AsRef<str> for ChangeTokenStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <note>
/// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
/// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
/// </note>
/// <p>In a <code>GetByteMatchSet</code> request, <code>ByteMatchSet</code> is a complex type that contains the <code>ByteMatchSetId</code> and <code>Name</code> of a <code>ByteMatchSet</code>, and the values that you specified when you updated the <code>ByteMatchSet</code>. </p>
/// <p>A complex type that contains <code>ByteMatchTuple</code> objects, which specify the parts of web requests that you want AWS WAF to inspect and the values that you want AWS WAF to search for. If a <code>ByteMatchSet</code> contains more than one <code>ByteMatchTuple</code> object, a request needs to match the settings in only one <code>ByteMatchTuple</code> to be considered a match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByteMatchSet {
    /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code> (see <code>GetByteMatchSet</code>), update a <code>ByteMatchSet</code> (see <code>UpdateByteMatchSet</code>), insert a <code>ByteMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>ByteMatchSet</code> from AWS WAF (see <code>DeleteByteMatchSet</code>).</p>
    /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    pub byte_match_set_id: std::option::Option<std::string::String>,
    /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.</p>
    pub byte_match_tuples: std::option::Option<std::vec::Vec<crate::model::ByteMatchTuple>>,
}
impl ByteMatchSet {
    /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code> (see <code>GetByteMatchSet</code>), update a <code>ByteMatchSet</code> (see <code>UpdateByteMatchSet</code>), insert a <code>ByteMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>ByteMatchSet</code> from AWS WAF (see <code>DeleteByteMatchSet</code>).</p>
    /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    pub fn byte_match_set_id(&self) -> std::option::Option<&str> {
        self.byte_match_set_id.as_deref()
    }
    /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.</p>
    pub fn byte_match_tuples(&self) -> std::option::Option<&[crate::model::ByteMatchTuple]> {
        self.byte_match_tuples.as_deref()
    }
}
impl std::fmt::Debug for ByteMatchSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByteMatchSet");
        formatter.field("byte_match_set_id", &self.byte_match_set_id);
        formatter.field("name", &self.name);
        formatter.field("byte_match_tuples", &self.byte_match_tuples);
        formatter.finish()
    }
}
/// See [`ByteMatchSet`](crate::model::ByteMatchSet)
pub mod byte_match_set {
    /// A builder for [`ByteMatchSet`](crate::model::ByteMatchSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) byte_match_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) byte_match_tuples:
            std::option::Option<std::vec::Vec<crate::model::ByteMatchTuple>>,
    }
    impl Builder {
        /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code> (see <code>GetByteMatchSet</code>), update a <code>ByteMatchSet</code> (see <code>UpdateByteMatchSet</code>), insert a <code>ByteMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>ByteMatchSet</code> from AWS WAF (see <code>DeleteByteMatchSet</code>).</p>
        /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn byte_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.byte_match_set_id = Some(input.into());
            self
        }
        /// <p>The <code>ByteMatchSetId</code> for a <code>ByteMatchSet</code>. You use <code>ByteMatchSetId</code> to get information about a <code>ByteMatchSet</code> (see <code>GetByteMatchSet</code>), update a <code>ByteMatchSet</code> (see <code>UpdateByteMatchSet</code>), insert a <code>ByteMatchSet</code> into a <code>Rule</code> or delete one from a <code>Rule</code> (see <code>UpdateRule</code>), and delete a <code>ByteMatchSet</code> from AWS WAF (see <code>DeleteByteMatchSet</code>).</p>
        /// <p> <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.byte_match_set_id = input;
            self
        }
        /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `byte_match_tuples`.
        ///
        /// To override the contents of this collection use [`set_byte_match_tuples`](Self::set_byte_match_tuples).
        ///
        /// <p>Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.</p>
        pub fn byte_match_tuples(mut self, input: crate::model::ByteMatchTuple) -> Self {
            let mut v = self.byte_match_tuples.unwrap_or_default();
            v.push(input);
            self.byte_match_tuples = Some(v);
            self
        }
        /// <p>Specifies the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings.</p>
        pub fn set_byte_match_tuples(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ByteMatchTuple>>,
        ) -> Self {
            self.byte_match_tuples = input;
            self
        }
        /// Consumes the builder and constructs a [`ByteMatchSet`](crate::model::ByteMatchSet)
        pub fn build(self) -> crate::model::ByteMatchSet {
            crate::model::ByteMatchSet {
                byte_match_set_id: self.byte_match_set_id,
                name: self.name,
                byte_match_tuples: self.byte_match_tuples,
            }
        }
    }
}
impl ByteMatchSet {
    /// Creates a new builder-style object to manufacture [`ByteMatchSet`](crate::model::ByteMatchSet)
    pub fn builder() -> crate::model::byte_match_set::Builder {
        crate::model::byte_match_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MigrationErrorType {
    #[allow(missing_docs)] // documentation missing in model
    EntityNotFound,
    #[allow(missing_docs)] // documentation missing in model
    EntityNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketInvalidRegion,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketNotAccessible,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketNotFound,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketNoPermission,
    #[allow(missing_docs)] // documentation missing in model
    S3InternalError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MigrationErrorType {
    fn from(s: &str) -> Self {
        match s {
            "ENTITY_NOT_FOUND" => MigrationErrorType::EntityNotFound,
            "ENTITY_NOT_SUPPORTED" => MigrationErrorType::EntityNotSupported,
            "S3_BUCKET_INVALID_REGION" => MigrationErrorType::S3BucketInvalidRegion,
            "S3_BUCKET_NOT_ACCESSIBLE" => MigrationErrorType::S3BucketNotAccessible,
            "S3_BUCKET_NOT_FOUND" => MigrationErrorType::S3BucketNotFound,
            "S3_BUCKET_NO_PERMISSION" => MigrationErrorType::S3BucketNoPermission,
            "S3_INTERNAL_ERROR" => MigrationErrorType::S3InternalError,
            other => MigrationErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MigrationErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MigrationErrorType::from(s))
    }
}
impl MigrationErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MigrationErrorType::EntityNotFound => "ENTITY_NOT_FOUND",
            MigrationErrorType::EntityNotSupported => "ENTITY_NOT_SUPPORTED",
            MigrationErrorType::S3BucketInvalidRegion => "S3_BUCKET_INVALID_REGION",
            MigrationErrorType::S3BucketNotAccessible => "S3_BUCKET_NOT_ACCESSIBLE",
            MigrationErrorType::S3BucketNotFound => "S3_BUCKET_NOT_FOUND",
            MigrationErrorType::S3BucketNoPermission => "S3_BUCKET_NO_PERMISSION",
            MigrationErrorType::S3InternalError => "S3_INTERNAL_ERROR",
            MigrationErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ENTITY_NOT_FOUND",
            "ENTITY_NOT_SUPPORTED",
            "S3_BUCKET_INVALID_REGION",
            "S3_BUCKET_NOT_ACCESSIBLE",
            "S3_BUCKET_NOT_FOUND",
            "S3_BUCKET_NO_PERMISSION",
            "S3_INTERNAL_ERROR",
        ]
    }
}
impl AsRef<str> for MigrationErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
