// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateByteMatchSetError {
    /// Kind of error that occurred.
    pub kind: CreateByteMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateByteMatchSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateByteMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateByteMatchSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateByteMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateByteMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            CreateByteMatchSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateByteMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateByteMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateByteMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateByteMatchSetError {
    fn code(&self) -> Option<&str> {
        CreateByteMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateByteMatchSetError {
    /// Creates a new `CreateByteMatchSetError`.
    pub fn new(kind: CreateByteMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateByteMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateByteMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateByteMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateByteMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateByteMatchSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateByteMatchSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateByteMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateByteMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateByteMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateByteMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateByteMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateByteMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateByteMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateByteMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateByteMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateByteMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateByteMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateByteMatchSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateByteMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateByteMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateByteMatchSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateByteMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateByteMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateByteMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGeoMatchSetError {
    /// Kind of error that occurred.
    pub kind: CreateGeoMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGeoMatchSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGeoMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGeoMatchSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateGeoMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            CreateGeoMatchSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateGeoMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateGeoMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateGeoMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGeoMatchSetError {
    fn code(&self) -> Option<&str> {
        CreateGeoMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGeoMatchSetError {
    /// Creates a new `CreateGeoMatchSetError`.
    pub fn new(kind: CreateGeoMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGeoMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGeoMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGeoMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGeoMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGeoMatchSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGeoMatchSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGeoMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGeoMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGeoMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGeoMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGeoMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGeoMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGeoMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGeoMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGeoMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGeoMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateGeoMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGeoMatchSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateGeoMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateGeoMatchSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateGeoMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateGeoMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateGeoMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIPSetError {
    /// Kind of error that occurred.
    pub kind: CreateIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIPSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIPSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIPSetError {
    fn code(&self) -> Option<&str> {
        CreateIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIPSetError {
    /// Creates a new `CreateIPSetError`.
    pub fn new(kind: CreateIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, CreateIPSetErrorKind::WafStaleDataException(_))
    }
}
impl std::error::Error for CreateIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIPSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateIPSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRateBasedRuleError {
    /// Kind of error that occurred.
    pub kind: CreateRateBasedRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRateBasedRuleErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRateBasedRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRateBasedRuleErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateRateBasedRuleErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateRateBasedRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRateBasedRuleError {
    fn code(&self) -> Option<&str> {
        CreateRateBasedRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRateBasedRuleError {
    /// Creates a new `CreateRateBasedRuleError`.
    pub fn new(kind: CreateRateBasedRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRateBasedRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRateBasedRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRateBasedRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRateBasedRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafBadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafStaleDataException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRateBasedRuleErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRateBasedRuleErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for CreateRateBasedRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRateBasedRuleErrorKind::WafBadRequestException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateRateBasedRuleErrorKind::WafTagOperationInternalErrorException(_inner) => {
                Some(_inner)
            }
            CreateRateBasedRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRegexMatchSetError {
    /// Kind of error that occurred.
    pub kind: CreateRegexMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRegexMatchSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRegexMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRegexMatchSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateRegexMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRegexMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRegexMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateRegexMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRegexMatchSetError {
    fn code(&self) -> Option<&str> {
        CreateRegexMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRegexMatchSetError {
    /// Creates a new `CreateRegexMatchSetError`.
    pub fn new(kind: CreateRegexMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRegexMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRegexMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRegexMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRegexMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRegexMatchSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexMatchSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateRegexMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRegexMatchSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateRegexMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRegexMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRegexMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateRegexMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: CreateRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRegexPatternSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRegexPatternSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        CreateRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRegexPatternSetError {
    /// Creates a new `CreateRegexPatternSetError`.
    pub fn new(kind: CreateRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegexPatternSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegexPatternSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRegexPatternSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleError {
    /// Kind of error that occurred.
    pub kind: CreateRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            CreateRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleError {
    fn code(&self) -> Option<&str> {
        CreateRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRuleError {
    /// Creates a new `CreateRuleError`.
    pub fn new(kind: CreateRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::WafBadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::WafStaleDataException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(&self.kind, CreateRuleErrorKind::WafTagOperationException(_))
    }
    /// Returns `true` if the error kind is `CreateRuleErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for CreateRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleErrorKind::WafBadRequestException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateRuleErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            CreateRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRuleGroupError {
    /// Kind of error that occurred.
    pub kind: CreateRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRuleGroupErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRuleGroupErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRuleGroupError {
    fn code(&self) -> Option<&str> {
        CreateRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRuleGroupError {
    /// Creates a new `CreateRuleGroupError`.
    pub fn new(kind: CreateRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafBadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafStaleDataException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRuleGroupErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRuleGroupErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for CreateRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRuleGroupErrorKind::WafBadRequestException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            CreateRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSizeConstraintSetError {
    /// Kind of error that occurred.
    pub kind: CreateSizeConstraintSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSizeConstraintSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSizeConstraintSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSizeConstraintSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            CreateSizeConstraintSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateSizeConstraintSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateSizeConstraintSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateSizeConstraintSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSizeConstraintSetError {
    fn code(&self) -> Option<&str> {
        CreateSizeConstraintSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSizeConstraintSetError {
    /// Creates a new `CreateSizeConstraintSetError`.
    pub fn new(kind: CreateSizeConstraintSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSizeConstraintSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSizeConstraintSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSizeConstraintSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSizeConstraintSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSizeConstraintSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSizeConstraintSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSizeConstraintSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSizeConstraintSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSizeConstraintSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSizeConstraintSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSizeConstraintSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSizeConstraintSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSizeConstraintSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSizeConstraintSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSizeConstraintSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSizeConstraintSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateSizeConstraintSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSizeConstraintSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateSizeConstraintSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateSizeConstraintSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateSizeConstraintSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateSizeConstraintSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSqlInjectionMatchSetError {
    /// Kind of error that occurred.
    pub kind: CreateSqlInjectionMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSqlInjectionMatchSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSqlInjectionMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSqlInjectionMatchSetErrorKind::WafDisallowedNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => {
                _inner.fmt(f)
            }
            CreateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            CreateSqlInjectionMatchSetErrorKind::WafLimitsExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateSqlInjectionMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateSqlInjectionMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSqlInjectionMatchSetError {
    fn code(&self) -> Option<&str> {
        CreateSqlInjectionMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSqlInjectionMatchSetError {
    /// Creates a new `CreateSqlInjectionMatchSetError`.
    pub fn new(kind: CreateSqlInjectionMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSqlInjectionMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSqlInjectionMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSqlInjectionMatchSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSqlInjectionMatchSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSqlInjectionMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSqlInjectionMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSqlInjectionMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSqlInjectionMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSqlInjectionMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSqlInjectionMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSqlInjectionMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSqlInjectionMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateSqlInjectionMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSqlInjectionMatchSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            CreateSqlInjectionMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateSqlInjectionMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateSqlInjectionMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWebACLError {
    /// Kind of error that occurred.
    pub kind: CreateWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWebACLErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWebACLErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            CreateWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWebACLError {
    fn code(&self) -> Option<&str> {
        CreateWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWebACLError {
    /// Creates a new `CreateWebACLError`.
    pub fn new(kind: CreateWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateWebACLErrorKind::WafBadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, CreateWebACLErrorKind::WafStaleDataException(_))
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for CreateWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWebACLErrorKind::WafBadRequestException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafTagOperationException(_inner) => Some(_inner),
            CreateWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            CreateWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWebACLMigrationStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWebACLMigrationStackError {
    /// Kind of error that occurred.
    pub kind: CreateWebACLMigrationStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWebACLMigrationStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWebACLMigrationStackErrorKind {
    /// <p>The operation failed due to a problem with the migration. The failure cause is provided in the exception, in the <code>MigrationErrorType</code>: </p>
    /// <ul>
    /// <li> <p> <code>ENTITY_NOT_SUPPORTED</code> - The web ACL has an unsupported entity but the <code>IgnoreUnsupportedType</code> is not set to true.</p> </li>
    /// <li> <p> <code>ENTITY_NOT_FOUND</code> - The web ACL doesn't exist. </p> </li>
    /// <li> <p> <code>S3_BUCKET_NO_PERMISSION</code> - You don't have permission to perform the <code>PutObject</code> action to the specified Amazon S3 bucket.</p> </li>
    /// <li> <p> <code>S3_BUCKET_NOT_ACCESSIBLE</code> - The bucket policy doesn't allow AWS WAF to perform the <code>PutObject</code> action in the bucket.</p> </li>
    /// <li> <p> <code>S3_BUCKET_NOT_FOUND</code> - The S3 bucket doesn't exist. </p> </li>
    /// <li> <p> <code>S3_BUCKET_INVALID_REGION</code> - The S3 bucket is not in the same Region as the web ACL.</p> </li>
    /// <li> <p> <code>S3_INTERNAL_ERROR</code> - AWS WAF failed to create the template in the S3 bucket for another reason.</p> </li>
    /// </ul>
    WafEntityMigrationException(crate::error::WafEntityMigrationException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWebACLMigrationStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWebACLMigrationStackErrorKind::WafEntityMigrationException(_inner) => {
                _inner.fmt(f)
            }
            CreateWebACLMigrationStackErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateWebACLMigrationStackErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            CreateWebACLMigrationStackErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            CreateWebACLMigrationStackErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            CreateWebACLMigrationStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWebACLMigrationStackError {
    fn code(&self) -> Option<&str> {
        CreateWebACLMigrationStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWebACLMigrationStackError {
    /// Creates a new `CreateWebACLMigrationStackError`.
    pub fn new(kind: CreateWebACLMigrationStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWebACLMigrationStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWebACLMigrationStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWebACLMigrationStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWebACLMigrationStackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWebACLMigrationStackErrorKind::WafEntityMigrationException`.
    pub fn is_waf_entity_migration_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLMigrationStackErrorKind::WafEntityMigrationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLMigrationStackErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLMigrationStackErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLMigrationStackErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLMigrationStackErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLMigrationStackErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLMigrationStackErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebACLMigrationStackErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebACLMigrationStackErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for CreateWebACLMigrationStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWebACLMigrationStackErrorKind::WafEntityMigrationException(_inner) => {
                Some(_inner)
            }
            CreateWebACLMigrationStackErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateWebACLMigrationStackErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            CreateWebACLMigrationStackErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            CreateWebACLMigrationStackErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            CreateWebACLMigrationStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateXssMatchSetError {
    /// Kind of error that occurred.
    pub kind: CreateXssMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateXssMatchSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateXssMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateXssMatchSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            CreateXssMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            CreateXssMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            CreateXssMatchSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            CreateXssMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            CreateXssMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            CreateXssMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateXssMatchSetError {
    fn code(&self) -> Option<&str> {
        CreateXssMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateXssMatchSetError {
    /// Creates a new `CreateXssMatchSetError`.
    pub fn new(kind: CreateXssMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateXssMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateXssMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateXssMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateXssMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateXssMatchSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateXssMatchSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateXssMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateXssMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateXssMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateXssMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateXssMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateXssMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateXssMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateXssMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateXssMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateXssMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for CreateXssMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateXssMatchSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            CreateXssMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            CreateXssMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            CreateXssMatchSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            CreateXssMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            CreateXssMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            CreateXssMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteByteMatchSetError {
    /// Kind of error that occurred.
    pub kind: DeleteByteMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteByteMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteByteMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteByteMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteByteMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteByteMatchSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteByteMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteByteMatchSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteByteMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteByteMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteByteMatchSetError {
    fn code(&self) -> Option<&str> {
        DeleteByteMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteByteMatchSetError {
    /// Creates a new `DeleteByteMatchSetError`.
    pub fn new(kind: DeleteByteMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteByteMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteByteMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteByteMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteByteMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteByteMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteByteMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteByteMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteByteMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteByteMatchSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteByteMatchSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteByteMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteByteMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteByteMatchSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteByteMatchSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteByteMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteByteMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteByteMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteByteMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteByteMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteByteMatchSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteByteMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteByteMatchSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteByteMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteByteMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGeoMatchSetError {
    /// Kind of error that occurred.
    pub kind: DeleteGeoMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGeoMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGeoMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGeoMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteGeoMatchSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteGeoMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteGeoMatchSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteGeoMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteGeoMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGeoMatchSetError {
    fn code(&self) -> Option<&str> {
        DeleteGeoMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGeoMatchSetError {
    /// Creates a new `DeleteGeoMatchSetError`.
    pub fn new(kind: DeleteGeoMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGeoMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGeoMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGeoMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGeoMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGeoMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGeoMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGeoMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGeoMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGeoMatchSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGeoMatchSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGeoMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGeoMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGeoMatchSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGeoMatchSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGeoMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGeoMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteGeoMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGeoMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteGeoMatchSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteGeoMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteGeoMatchSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteGeoMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteGeoMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIPSetError {
    /// Kind of error that occurred.
    pub kind: DeleteIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIPSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIPSetError {
    fn code(&self) -> Option<&str> {
        DeleteIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIPSetError {
    /// Creates a new `DeleteIPSetError`.
    pub fn new(kind: DeleteIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, DeleteIPSetErrorKind::WafStaleDataException(_))
    }
}
impl std::error::Error for DeleteIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoggingConfigurationErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoggingConfigurationErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoggingConfigurationError {
    /// Creates a new `DeleteLoggingConfigurationError`.
    pub fn new(kind: DeleteLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoggingConfigurationErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoggingConfigurationErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            DeleteLoggingConfigurationErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePermissionPolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePermissionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePermissionPolicyErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePermissionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePermissionPolicyErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeletePermissionPolicyErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeletePermissionPolicyErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeletePermissionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePermissionPolicyError {
    fn code(&self) -> Option<&str> {
        DeletePermissionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePermissionPolicyError {
    /// Creates a new `DeletePermissionPolicyError`.
    pub fn new(kind: DeletePermissionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePermissionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePermissionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePermissionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePermissionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePermissionPolicyErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionPolicyErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionPolicyErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionPolicyErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePermissionPolicyErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePermissionPolicyErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeletePermissionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePermissionPolicyErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeletePermissionPolicyErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeletePermissionPolicyErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeletePermissionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRateBasedRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteRateBasedRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRateBasedRuleErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRateBasedRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRateBasedRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteRateBasedRuleErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRateBasedRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRateBasedRuleError {
    fn code(&self) -> Option<&str> {
        DeleteRateBasedRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRateBasedRuleError {
    /// Creates a new `DeleteRateBasedRuleError`.
    pub fn new(kind: DeleteRateBasedRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRateBasedRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRateBasedRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRateBasedRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRateBasedRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafStaleDataException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRateBasedRuleErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRateBasedRuleErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteRateBasedRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRateBasedRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteRateBasedRuleErrorKind::WafTagOperationInternalErrorException(_inner) => {
                Some(_inner)
            }
            DeleteRateBasedRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegexMatchSetError {
    /// Kind of error that occurred.
    pub kind: DeleteRegexMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegexMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegexMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegexMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRegexMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteRegexMatchSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteRegexMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRegexMatchSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteRegexMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteRegexMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegexMatchSetError {
    fn code(&self) -> Option<&str> {
        DeleteRegexMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegexMatchSetError {
    /// Creates a new `DeleteRegexMatchSetError`.
    pub fn new(kind: DeleteRegexMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegexMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegexMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegexMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegexMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRegexMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexMatchSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexMatchSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexMatchSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexMatchSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteRegexMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegexMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRegexMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteRegexMatchSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteRegexMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRegexMatchSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteRegexMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteRegexMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: DeleteRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegexPatternSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        DeleteRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegexPatternSetError {
    /// Creates a new `DeleteRegexPatternSetError`.
    pub fn new(kind: DeleteRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegexPatternSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegexPatternSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleError {
    fn code(&self) -> Option<&str> {
        DeleteRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleError {
    /// Creates a new `DeleteRuleError`.
    pub fn new(kind: DeleteRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::WafStaleDataException(_))
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::WafTagOperationException(_))
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteRuleErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            DeleteRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleGroupErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleGroupError {
    fn code(&self) -> Option<&str> {
        DeleteRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleGroupError {
    /// Creates a new `DeleteRuleGroupError`.
    pub fn new(kind: DeleteRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafStaleDataException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            DeleteRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSizeConstraintSetError {
    /// Kind of error that occurred.
    pub kind: DeleteSizeConstraintSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSizeConstraintSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSizeConstraintSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteSizeConstraintSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteSizeConstraintSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteSizeConstraintSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteSizeConstraintSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteSizeConstraintSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSizeConstraintSetError {
    fn code(&self) -> Option<&str> {
        DeleteSizeConstraintSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSizeConstraintSetError {
    /// Creates a new `DeleteSizeConstraintSetError`.
    pub fn new(kind: DeleteSizeConstraintSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSizeConstraintSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSizeConstraintSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSizeConstraintSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSizeConstraintSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSizeConstraintSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSizeConstraintSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSizeConstraintSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSizeConstraintSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSizeConstraintSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSizeConstraintSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSizeConstraintSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSizeConstraintSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSizeConstraintSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSizeConstraintSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSizeConstraintSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSizeConstraintSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteSizeConstraintSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteSizeConstraintSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteSizeConstraintSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteSizeConstraintSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteSizeConstraintSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteSizeConstraintSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSqlInjectionMatchSetError {
    /// Kind of error that occurred.
    pub kind: DeleteSqlInjectionMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSqlInjectionMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSqlInjectionMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSqlInjectionMatchSetErrorKind::WafNonEmptyEntityException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSqlInjectionMatchSetErrorKind::WafReferencedItemException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSqlInjectionMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteSqlInjectionMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSqlInjectionMatchSetError {
    fn code(&self) -> Option<&str> {
        DeleteSqlInjectionMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSqlInjectionMatchSetError {
    /// Creates a new `DeleteSqlInjectionMatchSetError`.
    pub fn new(kind: DeleteSqlInjectionMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSqlInjectionMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSqlInjectionMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSqlInjectionMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSqlInjectionMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSqlInjectionMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSqlInjectionMatchSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSqlInjectionMatchSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSqlInjectionMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSqlInjectionMatchSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSqlInjectionMatchSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSqlInjectionMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSqlInjectionMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteSqlInjectionMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteSqlInjectionMatchSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            DeleteSqlInjectionMatchSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteSqlInjectionMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteSqlInjectionMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWebACLError {
    /// Kind of error that occurred.
    pub kind: DeleteWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWebACLErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            DeleteWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWebACLError {
    fn code(&self) -> Option<&str> {
        DeleteWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWebACLError {
    /// Creates a new `DeleteWebACLError`.
    pub fn new(kind: DeleteWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, DeleteWebACLErrorKind::WafStaleDataException(_))
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebACLErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebACLErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for DeleteWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafTagOperationException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            DeleteWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteXssMatchSetError {
    /// Kind of error that occurred.
    pub kind: DeleteXssMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteXssMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
    /// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
    /// </ul>
    WafNonEmptyEntityException(crate::error::WafNonEmptyEntityException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteXssMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteXssMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            DeleteXssMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            DeleteXssMatchSetErrorKind::WafNonEmptyEntityException(_inner) => _inner.fmt(f),
            DeleteXssMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            DeleteXssMatchSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            DeleteXssMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            DeleteXssMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteXssMatchSetError {
    fn code(&self) -> Option<&str> {
        DeleteXssMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteXssMatchSetError {
    /// Creates a new `DeleteXssMatchSetError`.
    pub fn new(kind: DeleteXssMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteXssMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteXssMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteXssMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteXssMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteXssMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteXssMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteXssMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteXssMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteXssMatchSetErrorKind::WafNonEmptyEntityException`.
    pub fn is_waf_non_empty_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteXssMatchSetErrorKind::WafNonEmptyEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteXssMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteXssMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteXssMatchSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteXssMatchSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteXssMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteXssMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for DeleteXssMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteXssMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            DeleteXssMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            DeleteXssMatchSetErrorKind::WafNonEmptyEntityException(_inner) => Some(_inner),
            DeleteXssMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            DeleteXssMatchSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            DeleteXssMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            DeleteXssMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetByteMatchSetError {
    /// Kind of error that occurred.
    pub kind: GetByteMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetByteMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetByteMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetByteMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetByteMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetByteMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetByteMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetByteMatchSetError {
    fn code(&self) -> Option<&str> {
        GetByteMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetByteMatchSetError {
    /// Creates a new `GetByteMatchSetError`.
    pub fn new(kind: GetByteMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetByteMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetByteMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetByteMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetByteMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetByteMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetByteMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetByteMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetByteMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetByteMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetByteMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetByteMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetByteMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetByteMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetByteMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetByteMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChangeToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChangeTokenError {
    /// Kind of error that occurred.
    pub kind: GetChangeTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChangeToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChangeTokenErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChangeTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChangeTokenErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetChangeTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChangeTokenError {
    fn code(&self) -> Option<&str> {
        GetChangeTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChangeTokenError {
    /// Creates a new `GetChangeTokenError`.
    pub fn new(kind: GetChangeTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChangeTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChangeTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChangeTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChangeTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChangeTokenErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangeTokenErrorKind::WafInternalErrorException(_)
        )
    }
}
impl std::error::Error for GetChangeTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChangeTokenErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetChangeTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChangeTokenStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChangeTokenStatusError {
    /// Kind of error that occurred.
    pub kind: GetChangeTokenStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChangeTokenStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChangeTokenStatusErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChangeTokenStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChangeTokenStatusErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetChangeTokenStatusErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetChangeTokenStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChangeTokenStatusError {
    fn code(&self) -> Option<&str> {
        GetChangeTokenStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChangeTokenStatusError {
    /// Creates a new `GetChangeTokenStatusError`.
    pub fn new(kind: GetChangeTokenStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChangeTokenStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChangeTokenStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChangeTokenStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChangeTokenStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChangeTokenStatusErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangeTokenStatusErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChangeTokenStatusErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangeTokenStatusErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetChangeTokenStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChangeTokenStatusErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetChangeTokenStatusErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetChangeTokenStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGeoMatchSetError {
    /// Kind of error that occurred.
    pub kind: GetGeoMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGeoMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGeoMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGeoMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetGeoMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetGeoMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGeoMatchSetError {
    fn code(&self) -> Option<&str> {
        GetGeoMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGeoMatchSetError {
    /// Creates a new `GetGeoMatchSetError`.
    pub fn new(kind: GetGeoMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGeoMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGeoMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGeoMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGeoMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGeoMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeoMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGeoMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeoMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGeoMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGeoMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetGeoMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGeoMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetGeoMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetGeoMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIPSetError {
    /// Kind of error that occurred.
    pub kind: GetIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIPSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIPSetError {
    fn code(&self) -> Option<&str> {
        GetIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIPSetError {
    /// Creates a new `GetIPSetError`.
    pub fn new(kind: GetIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetIPSetErrorKind::WafInternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(&self.kind, GetIPSetErrorKind::WafInvalidAccountException(_))
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIPSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetIPSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetIPSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoggingConfigurationErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        GetLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoggingConfigurationError {
    /// Creates a new `GetLoggingConfigurationError`.
    pub fn new(kind: GetLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoggingConfigurationErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingConfigurationErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoggingConfigurationErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoggingConfigurationErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPermissionPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPermissionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPermissionPolicyErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPermissionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPermissionPolicyErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetPermissionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPermissionPolicyError {
    fn code(&self) -> Option<&str> {
        GetPermissionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPermissionPolicyError {
    /// Creates a new `GetPermissionPolicyError`.
    pub fn new(kind: GetPermissionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPermissionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPermissionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPermissionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPermissionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPermissionPolicyErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionPolicyErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPermissionPolicyErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPermissionPolicyErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetPermissionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPermissionPolicyErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetPermissionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRateBasedRuleError {
    /// Kind of error that occurred.
    pub kind: GetRateBasedRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRateBasedRuleErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRateBasedRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRateBasedRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRateBasedRuleErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetRateBasedRuleErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRateBasedRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRateBasedRuleError {
    fn code(&self) -> Option<&str> {
        GetRateBasedRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRateBasedRuleError {
    /// Creates a new `GetRateBasedRuleError`.
    pub fn new(kind: GetRateBasedRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRateBasedRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRateBasedRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRateBasedRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRateBasedRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRateBasedRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRateBasedRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRateBasedRuleErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetRateBasedRuleErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRateBasedRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRateBasedRuleManagedKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRateBasedRuleManagedKeysError {
    /// Kind of error that occurred.
    pub kind: GetRateBasedRuleManagedKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRateBasedRuleManagedKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRateBasedRuleManagedKeysErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRateBasedRuleManagedKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRateBasedRuleManagedKeysErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedRuleManagedKeysErrorKind::WafInvalidAccountException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedRuleManagedKeysErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedRuleManagedKeysErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            GetRateBasedRuleManagedKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRateBasedRuleManagedKeysError {
    fn code(&self) -> Option<&str> {
        GetRateBasedRuleManagedKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRateBasedRuleManagedKeysError {
    /// Creates a new `GetRateBasedRuleManagedKeysError`.
    pub fn new(kind: GetRateBasedRuleManagedKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRateBasedRuleManagedKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRateBasedRuleManagedKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRateBasedRuleManagedKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRateBasedRuleManagedKeysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleManagedKeysErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleManagedKeysErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleManagedKeysErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleManagedKeysErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleManagedKeysErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleManagedKeysErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRateBasedRuleManagedKeysErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRateBasedRuleManagedKeysErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRateBasedRuleManagedKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRateBasedRuleManagedKeysErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRateBasedRuleManagedKeysErrorKind::WafInvalidAccountException(_inner) => {
                Some(_inner)
            }
            GetRateBasedRuleManagedKeysErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetRateBasedRuleManagedKeysErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            GetRateBasedRuleManagedKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegexMatchSetError {
    /// Kind of error that occurred.
    pub kind: GetRegexMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegexMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegexMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegexMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRegexMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetRegexMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRegexMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegexMatchSetError {
    fn code(&self) -> Option<&str> {
        GetRegexMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegexMatchSetError {
    /// Creates a new `GetRegexMatchSetError`.
    pub fn new(kind: GetRegexMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegexMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegexMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegexMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegexMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegexMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRegexMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegexMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRegexMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetRegexMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRegexMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: GetRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegexPatternSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        GetRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegexPatternSetError {
    /// Creates a new `GetRegexPatternSetError`.
    pub fn new(kind: GetRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegexPatternSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegexPatternSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRuleError {
    /// Kind of error that occurred.
    pub kind: GetRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRuleErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRuleErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetRuleErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRuleError {
    fn code(&self) -> Option<&str> {
        GetRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRuleError {
    /// Creates a new `GetRuleError`.
    pub fn new(kind: GetRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetRuleErrorKind::WafInternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetRuleErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(&self.kind, GetRuleErrorKind::WafInvalidAccountException(_))
    }
    /// Returns `true` if the error kind is `GetRuleErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(&self.kind, GetRuleErrorKind::WafNonexistentItemException(_))
    }
}
impl std::error::Error for GetRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRuleErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetRuleErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRuleGroupError {
    /// Kind of error that occurred.
    pub kind: GetRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRuleGroupErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRuleGroupError {
    fn code(&self) -> Option<&str> {
        GetRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRuleGroupError {
    /// Creates a new `GetRuleGroupError`.
    pub fn new(kind: GetRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSampledRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSampledRequestsError {
    /// Kind of error that occurred.
    pub kind: GetSampledRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSampledRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSampledRequestsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSampledRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSampledRequestsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetSampledRequestsErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetSampledRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSampledRequestsError {
    fn code(&self) -> Option<&str> {
        GetSampledRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSampledRequestsError {
    /// Creates a new `GetSampledRequestsError`.
    pub fn new(kind: GetSampledRequestsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSampledRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSampledRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSampledRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSampledRequestsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSampledRequestsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampledRequestsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSampledRequestsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampledRequestsErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetSampledRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSampledRequestsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetSampledRequestsErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetSampledRequestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSizeConstraintSetError {
    /// Kind of error that occurred.
    pub kind: GetSizeConstraintSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSizeConstraintSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSizeConstraintSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetSizeConstraintSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetSizeConstraintSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSizeConstraintSetError {
    fn code(&self) -> Option<&str> {
        GetSizeConstraintSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSizeConstraintSetError {
    /// Creates a new `GetSizeConstraintSetError`.
    pub fn new(kind: GetSizeConstraintSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSizeConstraintSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSizeConstraintSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSizeConstraintSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSizeConstraintSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSizeConstraintSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSizeConstraintSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSizeConstraintSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSizeConstraintSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSizeConstraintSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSizeConstraintSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetSizeConstraintSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetSizeConstraintSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetSizeConstraintSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSqlInjectionMatchSetError {
    /// Kind of error that occurred.
    pub kind: GetSqlInjectionMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSqlInjectionMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSqlInjectionMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetSqlInjectionMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSqlInjectionMatchSetError {
    fn code(&self) -> Option<&str> {
        GetSqlInjectionMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSqlInjectionMatchSetError {
    /// Creates a new `GetSqlInjectionMatchSetError`.
    pub fn new(kind: GetSqlInjectionMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSqlInjectionMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSqlInjectionMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSqlInjectionMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSqlInjectionMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSqlInjectionMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSqlInjectionMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetSqlInjectionMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetSqlInjectionMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWebACLError {
    /// Kind of error that occurred.
    pub kind: GetWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWebACLErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWebACLError {
    fn code(&self) -> Option<&str> {
        GetWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWebACLError {
    /// Creates a new `GetWebACLError`.
    pub fn new(kind: GetWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(&self.kind, GetWebACLErrorKind::WafInternalErrorException(_))
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetWebACLErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetXssMatchSetError {
    /// Kind of error that occurred.
    pub kind: GetXssMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetXssMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetXssMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetXssMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            GetXssMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            GetXssMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            GetXssMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetXssMatchSetError {
    fn code(&self) -> Option<&str> {
        GetXssMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetXssMatchSetError {
    /// Creates a new `GetXssMatchSetError`.
    pub fn new(kind: GetXssMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetXssMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetXssMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetXssMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetXssMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetXssMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetXssMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetXssMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetXssMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `GetXssMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetXssMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for GetXssMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetXssMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            GetXssMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            GetXssMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            GetXssMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListActivatedRulesInRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListActivatedRulesInRuleGroupError {
    /// Kind of error that occurred.
    pub kind: ListActivatedRulesInRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListActivatedRulesInRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListActivatedRulesInRuleGroupErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListActivatedRulesInRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListActivatedRulesInRuleGroupErrorKind::WafInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListActivatedRulesInRuleGroupErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListActivatedRulesInRuleGroupErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            ListActivatedRulesInRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListActivatedRulesInRuleGroupError {
    fn code(&self) -> Option<&str> {
        ListActivatedRulesInRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListActivatedRulesInRuleGroupError {
    /// Creates a new `ListActivatedRulesInRuleGroupError`.
    pub fn new(
        kind: ListActivatedRulesInRuleGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListActivatedRulesInRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListActivatedRulesInRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListActivatedRulesInRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListActivatedRulesInRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListActivatedRulesInRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActivatedRulesInRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActivatedRulesInRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActivatedRulesInRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListActivatedRulesInRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListActivatedRulesInRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for ListActivatedRulesInRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListActivatedRulesInRuleGroupErrorKind::WafInternalErrorException(_inner) => {
                Some(_inner)
            }
            ListActivatedRulesInRuleGroupErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListActivatedRulesInRuleGroupErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            ListActivatedRulesInRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListByteMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListByteMatchSetsError {
    /// Kind of error that occurred.
    pub kind: ListByteMatchSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListByteMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListByteMatchSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListByteMatchSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListByteMatchSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListByteMatchSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListByteMatchSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListByteMatchSetsError {
    fn code(&self) -> Option<&str> {
        ListByteMatchSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListByteMatchSetsError {
    /// Creates a new `ListByteMatchSetsError`.
    pub fn new(kind: ListByteMatchSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListByteMatchSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListByteMatchSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListByteMatchSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListByteMatchSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListByteMatchSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListByteMatchSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListByteMatchSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListByteMatchSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListByteMatchSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListByteMatchSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListByteMatchSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListByteMatchSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGeoMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGeoMatchSetsError {
    /// Kind of error that occurred.
    pub kind: ListGeoMatchSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGeoMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGeoMatchSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGeoMatchSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGeoMatchSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListGeoMatchSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListGeoMatchSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGeoMatchSetsError {
    fn code(&self) -> Option<&str> {
        ListGeoMatchSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGeoMatchSetsError {
    /// Creates a new `ListGeoMatchSetsError`.
    pub fn new(kind: ListGeoMatchSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGeoMatchSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGeoMatchSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGeoMatchSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGeoMatchSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGeoMatchSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeoMatchSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGeoMatchSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGeoMatchSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListGeoMatchSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGeoMatchSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListGeoMatchSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListGeoMatchSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIPSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIPSetsError {
    /// Kind of error that occurred.
    pub kind: ListIPSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIPSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIPSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIPSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIPSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIPSetsError {
    fn code(&self) -> Option<&str> {
        ListIPSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIPSetsError {
    /// Creates a new `ListIPSetsError`.
    pub fn new(kind: ListIPSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIPSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIPSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIPSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIPSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIPSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIPSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListIPSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIPSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListIPSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListIPSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLoggingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLoggingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListLoggingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLoggingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLoggingConfigurationsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLoggingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLoggingConfigurationsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListLoggingConfigurationsErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListLoggingConfigurationsErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            ListLoggingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLoggingConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListLoggingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLoggingConfigurationsError {
    /// Creates a new `ListLoggingConfigurationsError`.
    pub fn new(kind: ListLoggingConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLoggingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLoggingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLoggingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLoggingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLoggingConfigurationsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLoggingConfigurationsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLoggingConfigurationsErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLoggingConfigurationsErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLoggingConfigurationsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLoggingConfigurationsErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for ListLoggingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLoggingConfigurationsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListLoggingConfigurationsErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListLoggingConfigurationsErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            ListLoggingConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRateBasedRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRateBasedRulesError {
    /// Kind of error that occurred.
    pub kind: ListRateBasedRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRateBasedRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRateBasedRulesErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRateBasedRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRateBasedRulesErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRateBasedRulesErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListRateBasedRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRateBasedRulesError {
    fn code(&self) -> Option<&str> {
        ListRateBasedRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRateBasedRulesError {
    /// Creates a new `ListRateBasedRulesError`.
    pub fn new(kind: ListRateBasedRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRateBasedRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRateBasedRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRateBasedRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRateBasedRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRateBasedRulesErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRateBasedRulesErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRateBasedRulesErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRateBasedRulesErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListRateBasedRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRateBasedRulesErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRateBasedRulesErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListRateBasedRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRegexMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRegexMatchSetsError {
    /// Kind of error that occurred.
    pub kind: ListRegexMatchSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRegexMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRegexMatchSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRegexMatchSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRegexMatchSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRegexMatchSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListRegexMatchSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRegexMatchSetsError {
    fn code(&self) -> Option<&str> {
        ListRegexMatchSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRegexMatchSetsError {
    /// Creates a new `ListRegexMatchSetsError`.
    pub fn new(kind: ListRegexMatchSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRegexMatchSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRegexMatchSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRegexMatchSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRegexMatchSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRegexMatchSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexMatchSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRegexMatchSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexMatchSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListRegexMatchSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRegexMatchSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRegexMatchSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListRegexMatchSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRegexPatternSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRegexPatternSetsError {
    /// Kind of error that occurred.
    pub kind: ListRegexPatternSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRegexPatternSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRegexPatternSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRegexPatternSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRegexPatternSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRegexPatternSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListRegexPatternSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRegexPatternSetsError {
    fn code(&self) -> Option<&str> {
        ListRegexPatternSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRegexPatternSetsError {
    /// Creates a new `ListRegexPatternSetsError`.
    pub fn new(kind: ListRegexPatternSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRegexPatternSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRegexPatternSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRegexPatternSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRegexPatternSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRegexPatternSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexPatternSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRegexPatternSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegexPatternSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListRegexPatternSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRegexPatternSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRegexPatternSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListRegexPatternSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRuleGroupsError {
    /// Kind of error that occurred.
    pub kind: ListRuleGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRuleGroupsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRuleGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRuleGroupsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRuleGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRuleGroupsError {
    fn code(&self) -> Option<&str> {
        ListRuleGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRuleGroupsError {
    /// Creates a new `ListRuleGroupsError`.
    pub fn new(kind: ListRuleGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRuleGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRuleGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRuleGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRuleGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRuleGroupsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleGroupsErrorKind::WafInternalErrorException(_)
        )
    }
}
impl std::error::Error for ListRuleGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRuleGroupsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRuleGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRulesError {
    /// Kind of error that occurred.
    pub kind: ListRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRulesErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRulesErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRulesError {
    fn code(&self) -> Option<&str> {
        ListRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRulesError {
    /// Creates a new `ListRulesError`.
    pub fn new(kind: ListRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::WafInternalErrorException(_))
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRulesErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRulesErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListRulesErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSizeConstraintSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSizeConstraintSetsError {
    /// Kind of error that occurred.
    pub kind: ListSizeConstraintSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSizeConstraintSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSizeConstraintSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSizeConstraintSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSizeConstraintSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListSizeConstraintSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListSizeConstraintSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSizeConstraintSetsError {
    fn code(&self) -> Option<&str> {
        ListSizeConstraintSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSizeConstraintSetsError {
    /// Creates a new `ListSizeConstraintSetsError`.
    pub fn new(kind: ListSizeConstraintSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSizeConstraintSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSizeConstraintSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSizeConstraintSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSizeConstraintSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSizeConstraintSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSizeConstraintSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSizeConstraintSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSizeConstraintSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListSizeConstraintSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSizeConstraintSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListSizeConstraintSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListSizeConstraintSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSqlInjectionMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSqlInjectionMatchSetsError {
    /// Kind of error that occurred.
    pub kind: ListSqlInjectionMatchSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSqlInjectionMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSqlInjectionMatchSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSqlInjectionMatchSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSqlInjectionMatchSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListSqlInjectionMatchSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListSqlInjectionMatchSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSqlInjectionMatchSetsError {
    fn code(&self) -> Option<&str> {
        ListSqlInjectionMatchSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSqlInjectionMatchSetsError {
    /// Creates a new `ListSqlInjectionMatchSetsError`.
    pub fn new(kind: ListSqlInjectionMatchSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSqlInjectionMatchSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSqlInjectionMatchSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSqlInjectionMatchSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSqlInjectionMatchSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSqlInjectionMatchSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSqlInjectionMatchSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSqlInjectionMatchSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSqlInjectionMatchSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListSqlInjectionMatchSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSqlInjectionMatchSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListSqlInjectionMatchSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListSqlInjectionMatchSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSubscribedRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSubscribedRuleGroupsError {
    /// Kind of error that occurred.
    pub kind: ListSubscribedRuleGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSubscribedRuleGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSubscribedRuleGroupsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSubscribedRuleGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSubscribedRuleGroupsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListSubscribedRuleGroupsErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            ListSubscribedRuleGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSubscribedRuleGroupsError {
    fn code(&self) -> Option<&str> {
        ListSubscribedRuleGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSubscribedRuleGroupsError {
    /// Creates a new `ListSubscribedRuleGroupsError`.
    pub fn new(kind: ListSubscribedRuleGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSubscribedRuleGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSubscribedRuleGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSubscribedRuleGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSubscribedRuleGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSubscribedRuleGroupsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscribedRuleGroupsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSubscribedRuleGroupsErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSubscribedRuleGroupsErrorKind::WafNonexistentItemException(_)
        )
    }
}
impl std::error::Error for ListSubscribedRuleGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSubscribedRuleGroupsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListSubscribedRuleGroupsErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            ListSubscribedRuleGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafBadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::WafBadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafTagOperationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::WafTagOperationInternalErrorException(_inner) => {
                Some(_inner)
            }
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWebACLs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWebACLsError {
    /// Kind of error that occurred.
    pub kind: ListWebACLsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWebACLs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWebACLsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWebACLsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWebACLsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListWebACLsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListWebACLsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWebACLsError {
    fn code(&self) -> Option<&str> {
        ListWebACLsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWebACLsError {
    /// Creates a new `ListWebACLsError`.
    pub fn new(kind: ListWebACLsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWebACLsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWebACLsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWebACLsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWebACLsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWebACLsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebACLsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWebACLsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWebACLsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListWebACLsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWebACLsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListWebACLsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListWebACLsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListXssMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListXssMatchSetsError {
    /// Kind of error that occurred.
    pub kind: ListXssMatchSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListXssMatchSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListXssMatchSetsErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListXssMatchSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListXssMatchSetsErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            ListXssMatchSetsErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            ListXssMatchSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListXssMatchSetsError {
    fn code(&self) -> Option<&str> {
        ListXssMatchSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListXssMatchSetsError {
    /// Creates a new `ListXssMatchSetsError`.
    pub fn new(kind: ListXssMatchSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListXssMatchSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListXssMatchSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListXssMatchSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListXssMatchSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListXssMatchSetsErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListXssMatchSetsErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListXssMatchSetsErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListXssMatchSetsErrorKind::WafInvalidAccountException(_)
        )
    }
}
impl std::error::Error for ListXssMatchSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListXssMatchSetsErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            ListXssMatchSetsErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            ListXssMatchSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLoggingConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutLoggingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLoggingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLoggingConfigurationErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>AWS WAF is not able to access the service linked role. This can be caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20 seconds. Please try your request again. The service linked role can also be locked by a previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you recently made a <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the request again. If you receive this same exception again, you will have to wait additional time until the role is unlocked.</p>
    WafServiceLinkedRoleErrorException(crate::error::WafServiceLinkedRoleErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLoggingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(_inner) => {
                _inner.fmt(f)
            }
            PutLoggingConfigurationErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            PutLoggingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLoggingConfigurationError {
    fn code(&self) -> Option<&str> {
        PutLoggingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLoggingConfigurationError {
    /// Creates a new `PutLoggingConfigurationError`.
    pub fn new(kind: PutLoggingConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLoggingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLoggingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLoggingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLoggingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException`.
    pub fn is_waf_service_linked_role_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLoggingConfigurationErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLoggingConfigurationErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for PutLoggingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLoggingConfigurationErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::WafServiceLinkedRoleErrorException(_inner) => {
                Some(_inner)
            }
            PutLoggingConfigurationErrorKind::WafStaleDataException(_inner) => Some(_inner),
            PutLoggingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPermissionPolicyError {
    /// Kind of error that occurred.
    pub kind: PutPermissionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPermissionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPermissionPolicyErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because the specified policy is not in the proper format. </p>
    /// <p>The policy is subject to the following restrictions:</p>
    /// <ul>
    /// <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li>
    /// <li> <p>The policy must include an <code>Effect</code>, <code>Action</code> and <code>Principal</code>. </p> </li>
    /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
    /// <li> <p>The <code>Action</code> in the policy must be <code>waf:UpdateWebACL</code>, <code>waf-regional:UpdateWebACL</code>, <code>waf:GetRuleGroup</code> and <code>waf-regional:GetRuleGroup</code> . Any extra or wildcard actions in the policy will be rejected.</p> </li>
    /// <li> <p>The policy cannot include a <code>Resource</code> parameter.</p> </li>
    /// <li> <p>The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.</p> </li>
    /// <li> <p>The user making the request must be the owner of the RuleGroup.</p> </li>
    /// <li> <p>Your policy must be composed using IAM Policy version 2012-10-17.</p> </li>
    /// </ul>
    WafInvalidPermissionPolicyException(crate::error::WafInvalidPermissionPolicyException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPermissionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPermissionPolicyErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(_inner) => {
                _inner.fmt(f)
            }
            PutPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            PutPermissionPolicyErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            PutPermissionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPermissionPolicyError {
    fn code(&self) -> Option<&str> {
        PutPermissionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPermissionPolicyError {
    /// Creates a new `PutPermissionPolicyError`.
    pub fn new(kind: PutPermissionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPermissionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPermissionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPermissionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPermissionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException`.
    pub fn is_waf_invalid_permission_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionPolicyErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionPolicyErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for PutPermissionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPermissionPolicyErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            PutPermissionPolicyErrorKind::WafInvalidPermissionPolicyException(_inner) => {
                Some(_inner)
            }
            PutPermissionPolicyErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            PutPermissionPolicyErrorKind::WafStaleDataException(_inner) => Some(_inner),
            PutPermissionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::WafBadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::WafBadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            TagResourceErrorKind::WafTagOperationException(_inner) => Some(_inner),
            TagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p></p>
    WafBadRequestException(crate::error::WafBadRequestException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p></p>
    WafTagOperationException(crate::error::WafTagOperationException),
    /// <p></p>
    WafTagOperationInternalErrorException(crate::error::WafTagOperationInternalErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::WafBadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafTagOperationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafBadRequestException`.
    pub fn is_waf_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafBadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafTagOperationException`.
    pub fn is_waf_tag_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafTagOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::WafTagOperationInternalErrorException`.
    pub fn is_waf_tag_operation_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::WafTagOperationInternalErrorException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::WafBadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafTagOperationException(_inner) => Some(_inner),
            UntagResourceErrorKind::WafTagOperationInternalErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateByteMatchSetError {
    /// Kind of error that occurred.
    pub kind: UpdateByteMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateByteMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateByteMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateByteMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateByteMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateByteMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateByteMatchSetError {
    fn code(&self) -> Option<&str> {
        UpdateByteMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateByteMatchSetError {
    /// Creates a new `UpdateByteMatchSetError`.
    pub fn new(kind: UpdateByteMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateByteMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateByteMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateByteMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateByteMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateByteMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateByteMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateByteMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateByteMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateByteMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGeoMatchSetError {
    /// Kind of error that occurred.
    pub kind: UpdateGeoMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGeoMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGeoMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGeoMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGeoMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateGeoMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGeoMatchSetError {
    fn code(&self) -> Option<&str> {
        UpdateGeoMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGeoMatchSetError {
    /// Creates a new `UpdateGeoMatchSetError`.
    pub fn new(kind: UpdateGeoMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGeoMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGeoMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGeoMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGeoMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGeoMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGeoMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateGeoMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGeoMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateGeoMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIPSetError {
    /// Kind of error that occurred.
    pub kind: UpdateIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIPSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIPSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIPSetError {
    fn code(&self) -> Option<&str> {
        UpdateIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIPSetError {
    /// Creates a new `UpdateIPSetError`.
    pub fn new(kind: UpdateIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIPSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, UpdateIPSetErrorKind::WafStaleDataException(_))
    }
}
impl std::error::Error for UpdateIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIPSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRateBasedRuleError {
    /// Kind of error that occurred.
    pub kind: UpdateRateBasedRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRateBasedRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRateBasedRuleErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRateBasedRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRateBasedRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateRateBasedRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRateBasedRuleError {
    fn code(&self) -> Option<&str> {
        UpdateRateBasedRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRateBasedRuleError {
    /// Creates a new `UpdateRateBasedRuleError`.
    pub fn new(kind: UpdateRateBasedRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRateBasedRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRateBasedRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRateBasedRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRateBasedRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRateBasedRuleErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRateBasedRuleErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateRateBasedRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRateBasedRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateRateBasedRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRegexMatchSetError {
    /// Kind of error that occurred.
    pub kind: UpdateRegexMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRegexMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRegexMatchSetErrorKind {
    /// <p>The name specified is invalid.</p>
    WafDisallowedNameException(crate::error::WafDisallowedNameException),
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRegexMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRegexMatchSetErrorKind::WafDisallowedNameException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateRegexMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRegexMatchSetError {
    fn code(&self) -> Option<&str> {
        UpdateRegexMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRegexMatchSetError {
    /// Creates a new `UpdateRegexMatchSetError`.
    pub fn new(kind: UpdateRegexMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRegexMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRegexMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRegexMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRegexMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafDisallowedNameException`.
    pub fn is_waf_disallowed_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafDisallowedNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateRegexMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRegexMatchSetErrorKind::WafDisallowedNameException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateRegexMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRegexPatternSetError {
    /// Kind of error that occurred.
    pub kind: UpdateRegexPatternSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRegexPatternSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRegexPatternSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The regular expression (regex) you specified in <code>RegexPatternString</code> is invalid.</p>
    WafInvalidRegexPatternException(crate::error::WafInvalidRegexPatternException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRegexPatternSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafInvalidRegexPatternException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafNonexistentContainerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateRegexPatternSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRegexPatternSetError {
    fn code(&self) -> Option<&str> {
        UpdateRegexPatternSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRegexPatternSetError {
    /// Creates a new `UpdateRegexPatternSetError`.
    pub fn new(kind: UpdateRegexPatternSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRegexPatternSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRegexPatternSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRegexPatternSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRegexPatternSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafInvalidRegexPatternException`.
    pub fn is_waf_invalid_regex_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafInvalidRegexPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegexPatternSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegexPatternSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateRegexPatternSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRegexPatternSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafInvalidRegexPatternException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafNonexistentContainerException(_inner) => {
                Some(_inner)
            }
            UpdateRegexPatternSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateRegexPatternSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuleError {
    /// Kind of error that occurred.
    pub kind: UpdateRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuleErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuleErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuleError {
    fn code(&self) -> Option<&str> {
        UpdateRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuleError {
    /// Creates a new `UpdateRuleError`.
    pub fn new(kind: UpdateRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, UpdateRuleErrorKind::WafStaleDataException(_))
    }
}
impl std::error::Error for UpdateRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuleErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            UpdateRuleErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRuleGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateRuleGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRuleGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRuleGroupErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRuleGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRuleGroupErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateRuleGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRuleGroupError {
    fn code(&self) -> Option<&str> {
        UpdateRuleGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRuleGroupError {
    /// Creates a new `UpdateRuleGroupError`.
    pub fn new(kind: UpdateRuleGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRuleGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRuleGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRuleGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRuleGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRuleGroupErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRuleGroupErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateRuleGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRuleGroupErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateRuleGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSizeConstraintSetError {
    /// Kind of error that occurred.
    pub kind: UpdateSizeConstraintSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSizeConstraintSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSizeConstraintSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSizeConstraintSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafNonexistentContainerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSizeConstraintSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateSizeConstraintSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSizeConstraintSetError {
    fn code(&self) -> Option<&str> {
        UpdateSizeConstraintSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSizeConstraintSetError {
    /// Creates a new `UpdateSizeConstraintSetError`.
    pub fn new(kind: UpdateSizeConstraintSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSizeConstraintSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSizeConstraintSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSizeConstraintSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSizeConstraintSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSizeConstraintSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSizeConstraintSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateSizeConstraintSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSizeConstraintSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafNonexistentContainerException(_inner) => {
                Some(_inner)
            }
            UpdateSizeConstraintSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateSizeConstraintSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSqlInjectionMatchSetError {
    /// Kind of error that occurred.
    pub kind: UpdateSqlInjectionMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSqlInjectionMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSqlInjectionMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSqlInjectionMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidOperationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafLimitsExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafNonexistentContainerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_inner) => {
                _inner.fmt(f)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateSqlInjectionMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSqlInjectionMatchSetError {
    fn code(&self) -> Option<&str> {
        UpdateSqlInjectionMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSqlInjectionMatchSetError {
    /// Creates a new `UpdateSqlInjectionMatchSetError`.
    pub fn new(kind: UpdateSqlInjectionMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSqlInjectionMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSqlInjectionMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSqlInjectionMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSqlInjectionMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSqlInjectionMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateSqlInjectionMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSqlInjectionMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidOperationException(_inner) => {
                Some(_inner)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafInvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateSqlInjectionMatchSetErrorKind::WafNonexistentContainerException(_inner) => {
                Some(_inner)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafNonexistentItemException(_inner) => {
                Some(_inner)
            }
            UpdateSqlInjectionMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateSqlInjectionMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWebACLError {
    /// Kind of error that occurred.
    pub kind: UpdateWebACLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWebACL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWebACLErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
    /// <ul>
    /// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
    /// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
    /// </ul>
    WafReferencedItemException(crate::error::WafReferencedItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// <p>The specified subscription does not exist.</p>
    WafSubscriptionNotFoundException(crate::error::WafSubscriptionNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWebACLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWebACLErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafReferencedItemException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::WafSubscriptionNotFoundException(_inner) => _inner.fmt(f),
            UpdateWebACLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWebACLError {
    fn code(&self) -> Option<&str> {
        UpdateWebACLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWebACLError {
    /// Creates a new `UpdateWebACLError`.
    pub fn new(kind: UpdateWebACLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWebACLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWebACLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWebACLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWebACLErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafReferencedItemException`.
    pub fn is_waf_referenced_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafReferencedItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(&self.kind, UpdateWebACLErrorKind::WafStaleDataException(_))
    }
    /// Returns `true` if the error kind is `UpdateWebACLErrorKind::WafSubscriptionNotFoundException`.
    pub fn is_waf_subscription_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebACLErrorKind::WafSubscriptionNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateWebACLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWebACLErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafReferencedItemException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::WafSubscriptionNotFoundException(_inner) => Some(_inner),
            UpdateWebACLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateXssMatchSetError {
    /// Kind of error that occurred.
    pub kind: UpdateXssMatchSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateXssMatchSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateXssMatchSetErrorKind {
    /// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
    WafInternalErrorException(crate::error::WafInternalErrorException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
    WafInvalidAccountException(crate::error::WafInvalidAccountException),
    /// <p>The operation failed because there was nothing to do. For example:</p>
    /// <ul>
    /// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
    /// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
    /// </ul>
    WafInvalidOperationException(crate::error::WafInvalidOperationException),
    /// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
    /// <ul>
    /// <li> <p>You specified an invalid parameter name.</p> </li>
    /// <li> <p>You specified an invalid value.</p> </li>
    /// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
    /// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
    /// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
    /// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
    /// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
    /// </ul>
    WafInvalidParameterException(crate::error::WafInvalidParameterException),
    /// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
    WafLimitsExceededException(crate::error::WafLimitsExceededException),
    /// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
    /// <ul>
    /// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
    /// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
    /// </ul>
    WafNonexistentContainerException(crate::error::WafNonexistentContainerException),
    /// <p>The operation failed because the referenced object doesn't exist.</p>
    WafNonexistentItemException(crate::error::WafNonexistentItemException),
    /// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
    WafStaleDataException(crate::error::WafStaleDataException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateXssMatchSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateXssMatchSetErrorKind::WafInternalErrorException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafInvalidAccountException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafInvalidOperationException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafInvalidParameterException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafLimitsExceededException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafNonexistentContainerException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafNonexistentItemException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::WafStaleDataException(_inner) => _inner.fmt(f),
            UpdateXssMatchSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateXssMatchSetError {
    fn code(&self) -> Option<&str> {
        UpdateXssMatchSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateXssMatchSetError {
    /// Creates a new `UpdateXssMatchSetError`.
    pub fn new(kind: UpdateXssMatchSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateXssMatchSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateXssMatchSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateXssMatchSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateXssMatchSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafInternalErrorException`.
    pub fn is_waf_internal_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafInternalErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafInvalidAccountException`.
    pub fn is_waf_invalid_account_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafInvalidAccountException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafInvalidOperationException`.
    pub fn is_waf_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafInvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafInvalidParameterException`.
    pub fn is_waf_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafInvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafLimitsExceededException`.
    pub fn is_waf_limits_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafLimitsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafNonexistentContainerException`.
    pub fn is_waf_nonexistent_container_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafNonexistentContainerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafNonexistentItemException`.
    pub fn is_waf_nonexistent_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafNonexistentItemException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateXssMatchSetErrorKind::WafStaleDataException`.
    pub fn is_waf_stale_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateXssMatchSetErrorKind::WafStaleDataException(_)
        )
    }
}
impl std::error::Error for UpdateXssMatchSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateXssMatchSetErrorKind::WafInternalErrorException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafInvalidAccountException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafInvalidOperationException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafInvalidParameterException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafLimitsExceededException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafNonexistentContainerException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafNonexistentItemException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::WafStaleDataException(_inner) => Some(_inner),
            UpdateXssMatchSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The operation failed because you tried to create, update, or delete an object by using a change token that has already been used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafStaleDataException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafStaleDataException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafStaleDataException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafStaleDataException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafStaleDataException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafStaleDataException [WAFStaleDataException]")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafStaleDataException {}
/// See [`WafStaleDataException`](crate::error::WafStaleDataException)
pub mod waf_stale_data_exception {
    /// A builder for [`WafStaleDataException`](crate::error::WafStaleDataException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafStaleDataException`](crate::error::WafStaleDataException)
        pub fn build(self) -> crate::error::WafStaleDataException {
            crate::error::WafStaleDataException {
                message: self.message,
            }
        }
    }
}
impl WafStaleDataException {
    /// Creates a new builder-style object to manufacture [`WafStaleDataException`](crate::error::WafStaleDataException)
    pub fn builder() -> crate::error::waf_stale_data_exception::Builder {
        crate::error::waf_stale_data_exception::Builder::default()
    }
}

/// <p>The operation failed because the referenced object doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafNonexistentItemException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafNonexistentItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafNonexistentItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafNonexistentItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafNonexistentItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafNonexistentItemException [WAFNonexistentItemException]"
        )?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafNonexistentItemException {}
/// See [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
pub mod waf_nonexistent_item_exception {
    /// A builder for [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
        pub fn build(self) -> crate::error::WafNonexistentItemException {
            crate::error::WafNonexistentItemException {
                message: self.message,
            }
        }
    }
}
impl WafNonexistentItemException {
    /// Creates a new builder-style object to manufacture [`WafNonexistentItemException`](crate::error::WafNonexistentItemException)
    pub fn builder() -> crate::error::waf_nonexistent_item_exception::Builder {
        crate::error::waf_nonexistent_item_exception::Builder::default()
    }
}

/// <p>The operation failed because you tried to add an object to or delete an object from another object that doesn't exist. For example:</p>
/// <ul>
/// <li> <p>You tried to add a <code>Rule</code> to or delete a <code>Rule</code> from a <code>WebACL</code> that doesn't exist.</p> </li>
/// <li> <p>You tried to add a <code>ByteMatchSet</code> to or delete a <code>ByteMatchSet</code> from a <code>Rule</code> that doesn't exist.</p> </li>
/// <li> <p>You tried to add an IP address to or delete an IP address from an <code>IPSet</code> that doesn't exist.</p> </li>
/// <li> <p>You tried to add a <code>ByteMatchTuple</code> to or delete a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code> that doesn't exist.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafNonexistentContainerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafNonexistentContainerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafNonexistentContainerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafNonexistentContainerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafNonexistentContainerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafNonexistentContainerException [WAFNonexistentContainerException]"
        )?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafNonexistentContainerException {}
/// See [`WafNonexistentContainerException`](crate::error::WafNonexistentContainerException)
pub mod waf_nonexistent_container_exception {
    /// A builder for [`WafNonexistentContainerException`](crate::error::WafNonexistentContainerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafNonexistentContainerException`](crate::error::WafNonexistentContainerException)
        pub fn build(self) -> crate::error::WafNonexistentContainerException {
            crate::error::WafNonexistentContainerException {
                message: self.message,
            }
        }
    }
}
impl WafNonexistentContainerException {
    /// Creates a new builder-style object to manufacture [`WafNonexistentContainerException`](crate::error::WafNonexistentContainerException)
    pub fn builder() -> crate::error::waf_nonexistent_container_exception::Builder {
        crate::error::waf_nonexistent_container_exception::Builder::default()
    }
}

/// <p>The operation exceeds a resource limit, for example, the maximum number of <code>WebACL</code> objects that you can create for an AWS account. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">Limits</a> in the <i>AWS WAF Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafLimitsExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafLimitsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafLimitsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafLimitsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafLimitsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafLimitsExceededException [WAFLimitsExceededException]")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafLimitsExceededException {}
/// See [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
pub mod waf_limits_exceeded_exception {
    /// A builder for [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
        pub fn build(self) -> crate::error::WafLimitsExceededException {
            crate::error::WafLimitsExceededException {
                message: self.message,
            }
        }
    }
}
impl WafLimitsExceededException {
    /// Creates a new builder-style object to manufacture [`WafLimitsExceededException`](crate::error::WafLimitsExceededException)
    pub fn builder() -> crate::error::waf_limits_exceeded_exception::Builder {
        crate::error::waf_limits_exceeded_exception::Builder::default()
    }
}

/// <p>The operation failed because AWS WAF didn't recognize a parameter in the request. For example:</p>
/// <ul>
/// <li> <p>You specified an invalid parameter name.</p> </li>
/// <li> <p>You specified an invalid value.</p> </li>
/// <li> <p>You tried to update an object (<code>ByteMatchSet</code>, <code>IPSet</code>, <code>Rule</code>, or <code>WebACL</code>) using an action other than <code>INSERT</code> or <code>DELETE</code>.</p> </li>
/// <li> <p>You tried to create a <code>WebACL</code> with a <code>DefaultAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
/// <li> <p>You tried to create a <code>RateBasedRule</code> with a <code>RateKey</code> value other than <code>IP</code>.</p> </li>
/// <li> <p>You tried to update a <code>WebACL</code> with a <code>WafAction</code> <code>Type</code> other than <code>ALLOW</code>, <code>BLOCK</code>, or <code>COUNT</code>.</p> </li>
/// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>FieldToMatch</code> <code>Type</code> other than HEADER, METHOD, QUERY_STRING, URI, or BODY.</p> </li>
/// <li> <p>You tried to update a <code>ByteMatchSet</code> with a <code>Field</code> of <code>HEADER</code> but no value for <code>Data</code>.</p> </li>
/// <li> <p>Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub field: std::option::Option<crate::model::ParameterExceptionField>,
    #[allow(missing_docs)] // documentation missing in model
    pub parameter: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::ParameterExceptionReason>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl WafInvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn field(&self) -> std::option::Option<&crate::model::ParameterExceptionField> {
        self.field.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn parameter(&self) -> std::option::Option<&str> {
        self.parameter.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&crate::model::ParameterExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for WafInvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidParameterException");
        formatter.field("field", &self.field);
        formatter.field("parameter", &self.parameter);
        formatter.field("reason", &self.reason);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidParameterException [WAFInvalidParameterException]"
        )?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidParameterException {}
/// See [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
pub mod waf_invalid_parameter_exception {
    /// A builder for [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<crate::model::ParameterExceptionField>,
        pub(crate) parameter: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ParameterExceptionReason>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn field(mut self, input: crate::model::ParameterExceptionField) -> Self {
            self.field = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_field(
            mut self,
            input: std::option::Option<crate::model::ParameterExceptionField>,
        ) -> Self {
            self.field = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_parameter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameter = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: crate::model::ParameterExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ParameterExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
        pub fn build(self) -> crate::error::WafInvalidParameterException {
            crate::error::WafInvalidParameterException {
                field: self.field,
                parameter: self.parameter,
                reason: self.reason,
                message: self.message,
            }
        }
    }
}
impl WafInvalidParameterException {
    /// Creates a new builder-style object to manufacture [`WafInvalidParameterException`](crate::error::WafInvalidParameterException)
    pub fn builder() -> crate::error::waf_invalid_parameter_exception::Builder {
        crate::error::waf_invalid_parameter_exception::Builder::default()
    }
}

/// <p>The operation failed because there was nothing to do. For example:</p>
/// <ul>
/// <li> <p>You tried to remove a <code>Rule</code> from a <code>WebACL</code>, but the <code>Rule</code> isn't in the specified <code>WebACL</code>.</p> </li>
/// <li> <p>You tried to remove an IP address from an <code>IPSet</code>, but the IP address isn't in the specified <code>IPSet</code>.</p> </li>
/// <li> <p>You tried to remove a <code>ByteMatchTuple</code> from a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> isn't in the specified <code>WebACL</code>.</p> </li>
/// <li> <p>You tried to add a <code>Rule</code> to a <code>WebACL</code>, but the <code>Rule</code> already exists in the specified <code>WebACL</code>.</p> </li>
/// <li> <p>You tried to add a <code>ByteMatchTuple</code> to a <code>ByteMatchSet</code>, but the <code>ByteMatchTuple</code> already exists in the specified <code>WebACL</code>.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidOperationException [WAFInvalidOperationException]"
        )?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidOperationException {}
/// See [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
pub mod waf_invalid_operation_exception {
    /// A builder for [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
        pub fn build(self) -> crate::error::WafInvalidOperationException {
            crate::error::WafInvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidOperationException {
    /// Creates a new builder-style object to manufacture [`WafInvalidOperationException`](crate::error::WafInvalidOperationException)
    pub fn builder() -> crate::error::waf_invalid_operation_exception::Builder {
        crate::error::waf_invalid_operation_exception::Builder::default()
    }
}

/// <p>The operation failed because you tried to create, update, or delete an object by using an invalid account identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidAccountException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidAccountException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidAccountException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidAccountException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafInvalidAccountException [WAFInvalidAccountException]")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidAccountException {}
/// See [`WafInvalidAccountException`](crate::error::WafInvalidAccountException)
pub mod waf_invalid_account_exception {
    /// A builder for [`WafInvalidAccountException`](crate::error::WafInvalidAccountException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidAccountException`](crate::error::WafInvalidAccountException)
        pub fn build(self) -> crate::error::WafInvalidAccountException {
            crate::error::WafInvalidAccountException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidAccountException {
    /// Creates a new builder-style object to manufacture [`WafInvalidAccountException`](crate::error::WafInvalidAccountException)
    pub fn builder() -> crate::error::waf_invalid_account_exception::Builder {
        crate::error::waf_invalid_account_exception::Builder::default()
    }
}

/// <p>The operation failed because of a system problem, even though the request was valid. Retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafInternalErrorException [WAFInternalErrorException]")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInternalErrorException {}
/// See [`WafInternalErrorException`](crate::error::WafInternalErrorException)
pub mod waf_internal_error_exception {
    /// A builder for [`WafInternalErrorException`](crate::error::WafInternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInternalErrorException`](crate::error::WafInternalErrorException)
        pub fn build(self) -> crate::error::WafInternalErrorException {
            crate::error::WafInternalErrorException {
                message: self.message,
            }
        }
    }
}
impl WafInternalErrorException {
    /// Creates a new builder-style object to manufacture [`WafInternalErrorException`](crate::error::WafInternalErrorException)
    pub fn builder() -> crate::error::waf_internal_error_exception::Builder {
        crate::error::waf_internal_error_exception::Builder::default()
    }
}

/// <p>The specified subscription does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafSubscriptionNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafSubscriptionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafSubscriptionNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafSubscriptionNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafSubscriptionNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafSubscriptionNotFoundException [WAFSubscriptionNotFoundException]"
        )?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafSubscriptionNotFoundException {}
/// See [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
pub mod waf_subscription_not_found_exception {
    /// A builder for [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
        pub fn build(self) -> crate::error::WafSubscriptionNotFoundException {
            crate::error::WafSubscriptionNotFoundException {
                message: self.message,
            }
        }
    }
}
impl WafSubscriptionNotFoundException {
    /// Creates a new builder-style object to manufacture [`WafSubscriptionNotFoundException`](crate::error::WafSubscriptionNotFoundException)
    pub fn builder() -> crate::error::waf_subscription_not_found_exception::Builder {
        crate::error::waf_subscription_not_found_exception::Builder::default()
    }
}

/// <p>The operation failed because you tried to delete an object that is still in use. For example:</p>
/// <ul>
/// <li> <p>You tried to delete a <code>ByteMatchSet</code> that is still referenced by a <code>Rule</code>.</p> </li>
/// <li> <p>You tried to delete a <code>Rule</code> that is still referenced by a <code>WebACL</code>.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafReferencedItemException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafReferencedItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafReferencedItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafReferencedItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafReferencedItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafReferencedItemException [WAFReferencedItemException]")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafReferencedItemException {}
/// See [`WafReferencedItemException`](crate::error::WafReferencedItemException)
pub mod waf_referenced_item_exception {
    /// A builder for [`WafReferencedItemException`](crate::error::WafReferencedItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafReferencedItemException`](crate::error::WafReferencedItemException)
        pub fn build(self) -> crate::error::WafReferencedItemException {
            crate::error::WafReferencedItemException {
                message: self.message,
            }
        }
    }
}
impl WafReferencedItemException {
    /// Creates a new builder-style object to manufacture [`WafReferencedItemException`](crate::error::WafReferencedItemException)
    pub fn builder() -> crate::error::waf_referenced_item_exception::Builder {
        crate::error::waf_referenced_item_exception::Builder::default()
    }
}

/// <p>The regular expression (regex) you specified in <code>RegexPatternString</code> is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidRegexPatternException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidRegexPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidRegexPatternException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidRegexPatternException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidRegexPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidRegexPatternException [WAFInvalidRegexPatternException]"
        )?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidRegexPatternException {}
/// See [`WafInvalidRegexPatternException`](crate::error::WafInvalidRegexPatternException)
pub mod waf_invalid_regex_pattern_exception {
    /// A builder for [`WafInvalidRegexPatternException`](crate::error::WafInvalidRegexPatternException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidRegexPatternException`](crate::error::WafInvalidRegexPatternException)
        pub fn build(self) -> crate::error::WafInvalidRegexPatternException {
            crate::error::WafInvalidRegexPatternException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidRegexPatternException {
    /// Creates a new builder-style object to manufacture [`WafInvalidRegexPatternException`](crate::error::WafInvalidRegexPatternException)
    pub fn builder() -> crate::error::waf_invalid_regex_pattern_exception::Builder {
        crate::error::waf_invalid_regex_pattern_exception::Builder::default()
    }
}

/// <p>The name specified is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafDisallowedNameException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafDisallowedNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafDisallowedNameException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafDisallowedNameException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafDisallowedNameException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafDisallowedNameException [WAFDisallowedNameException]")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafDisallowedNameException {}
/// See [`WafDisallowedNameException`](crate::error::WafDisallowedNameException)
pub mod waf_disallowed_name_exception {
    /// A builder for [`WafDisallowedNameException`](crate::error::WafDisallowedNameException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafDisallowedNameException`](crate::error::WafDisallowedNameException)
        pub fn build(self) -> crate::error::WafDisallowedNameException {
            crate::error::WafDisallowedNameException {
                message: self.message,
            }
        }
    }
}
impl WafDisallowedNameException {
    /// Creates a new builder-style object to manufacture [`WafDisallowedNameException`](crate::error::WafDisallowedNameException)
    pub fn builder() -> crate::error::waf_disallowed_name_exception::Builder {
        crate::error::waf_disallowed_name_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafTagOperationInternalErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafTagOperationInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafTagOperationInternalErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafTagOperationInternalErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafTagOperationInternalErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafTagOperationInternalErrorException [WAFTagOperationInternalErrorException]"
        )?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafTagOperationInternalErrorException {}
/// See [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
pub mod waf_tag_operation_internal_error_exception {
    /// A builder for [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
        pub fn build(self) -> crate::error::WafTagOperationInternalErrorException {
            crate::error::WafTagOperationInternalErrorException {
                message: self.message,
            }
        }
    }
}
impl WafTagOperationInternalErrorException {
    /// Creates a new builder-style object to manufacture [`WafTagOperationInternalErrorException`](crate::error::WafTagOperationInternalErrorException)
    pub fn builder() -> crate::error::waf_tag_operation_internal_error_exception::Builder {
        crate::error::waf_tag_operation_internal_error_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafTagOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafTagOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafTagOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafTagOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafTagOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafTagOperationException [WAFTagOperationException]")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafTagOperationException {}
/// See [`WafTagOperationException`](crate::error::WafTagOperationException)
pub mod waf_tag_operation_exception {
    /// A builder for [`WafTagOperationException`](crate::error::WafTagOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafTagOperationException`](crate::error::WafTagOperationException)
        pub fn build(self) -> crate::error::WafTagOperationException {
            crate::error::WafTagOperationException {
                message: self.message,
            }
        }
    }
}
impl WafTagOperationException {
    /// Creates a new builder-style object to manufacture [`WafTagOperationException`](crate::error::WafTagOperationException)
    pub fn builder() -> crate::error::waf_tag_operation_exception::Builder {
        crate::error::waf_tag_operation_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafBadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafBadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafBadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafBadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafBadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafBadRequestException [WAFBadRequestException]")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafBadRequestException {}
/// See [`WafBadRequestException`](crate::error::WafBadRequestException)
pub mod waf_bad_request_exception {
    /// A builder for [`WafBadRequestException`](crate::error::WafBadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafBadRequestException`](crate::error::WafBadRequestException)
        pub fn build(self) -> crate::error::WafBadRequestException {
            crate::error::WafBadRequestException {
                message: self.message,
            }
        }
    }
}
impl WafBadRequestException {
    /// Creates a new builder-style object to manufacture [`WafBadRequestException`](crate::error::WafBadRequestException)
    pub fn builder() -> crate::error::waf_bad_request_exception::Builder {
        crate::error::waf_bad_request_exception::Builder::default()
    }
}

/// <p>The operation failed because the specified policy is not in the proper format. </p>
/// <p>The policy is subject to the following restrictions:</p>
/// <ul>
/// <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li>
/// <li> <p>The policy must include an <code>Effect</code>, <code>Action</code> and <code>Principal</code>. </p> </li>
/// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
/// <li> <p>The <code>Action</code> in the policy must be <code>waf:UpdateWebACL</code>, <code>waf-regional:UpdateWebACL</code>, <code>waf:GetRuleGroup</code> and <code>waf-regional:GetRuleGroup</code> . Any extra or wildcard actions in the policy will be rejected.</p> </li>
/// <li> <p>The policy cannot include a <code>Resource</code> parameter.</p> </li>
/// <li> <p>The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.</p> </li>
/// <li> <p>The user making the request must be the owner of the RuleGroup.</p> </li>
/// <li> <p>Your policy must be composed using IAM Policy version 2012-10-17.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafInvalidPermissionPolicyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafInvalidPermissionPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafInvalidPermissionPolicyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafInvalidPermissionPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafInvalidPermissionPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafInvalidPermissionPolicyException [WAFInvalidPermissionPolicyException]"
        )?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafInvalidPermissionPolicyException {}
/// See [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
pub mod waf_invalid_permission_policy_exception {
    /// A builder for [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
        pub fn build(self) -> crate::error::WafInvalidPermissionPolicyException {
            crate::error::WafInvalidPermissionPolicyException {
                message: self.message,
            }
        }
    }
}
impl WafInvalidPermissionPolicyException {
    /// Creates a new builder-style object to manufacture [`WafInvalidPermissionPolicyException`](crate::error::WafInvalidPermissionPolicyException)
    pub fn builder() -> crate::error::waf_invalid_permission_policy_exception::Builder {
        crate::error::waf_invalid_permission_policy_exception::Builder::default()
    }
}

/// <p>AWS WAF is not able to access the service linked role. This can be caused by a previous <code>PutLoggingConfiguration</code> request, which can lock the service linked role for about 20 seconds. Please try your request again. The service linked role can also be locked by a previous <code>DeleteServiceLinkedRole</code> request, which can lock the role for 15 minutes or more. If you recently made a <code>DeleteServiceLinkedRole</code>, wait at least 15 minutes and try the request again. If you receive this same exception again, you will have to wait additional time until the role is unlocked.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafServiceLinkedRoleErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafServiceLinkedRoleErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafServiceLinkedRoleErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafServiceLinkedRoleErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafServiceLinkedRoleErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafServiceLinkedRoleErrorException [WAFServiceLinkedRoleErrorException]"
        )?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafServiceLinkedRoleErrorException {}
/// See [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
pub mod waf_service_linked_role_error_exception {
    /// A builder for [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
        pub fn build(self) -> crate::error::WafServiceLinkedRoleErrorException {
            crate::error::WafServiceLinkedRoleErrorException {
                message: self.message,
            }
        }
    }
}
impl WafServiceLinkedRoleErrorException {
    /// Creates a new builder-style object to manufacture [`WafServiceLinkedRoleErrorException`](crate::error::WafServiceLinkedRoleErrorException)
    pub fn builder() -> crate::error::waf_service_linked_role_error_exception::Builder {
        crate::error::waf_service_linked_role_error_exception::Builder::default()
    }
}

/// <p>The operation failed because you tried to delete an object that isn't empty. For example:</p>
/// <ul>
/// <li> <p>You tried to delete a <code>WebACL</code> that still contains one or more <code>Rule</code> objects.</p> </li>
/// <li> <p>You tried to delete a <code>Rule</code> that still contains one or more <code>ByteMatchSet</code> objects or other predicates.</p> </li>
/// <li> <p>You tried to delete a <code>ByteMatchSet</code> that contains one or more <code>ByteMatchTuple</code> objects.</p> </li>
/// <li> <p>You tried to delete an <code>IPSet</code> that references one or more IP addresses.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafNonEmptyEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for WafNonEmptyEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafNonEmptyEntityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl WafNonEmptyEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafNonEmptyEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "WafNonEmptyEntityException [WAFNonEmptyEntityException]")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafNonEmptyEntityException {}
/// See [`WafNonEmptyEntityException`](crate::error::WafNonEmptyEntityException)
pub mod waf_non_empty_entity_exception {
    /// A builder for [`WafNonEmptyEntityException`](crate::error::WafNonEmptyEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`WafNonEmptyEntityException`](crate::error::WafNonEmptyEntityException)
        pub fn build(self) -> crate::error::WafNonEmptyEntityException {
            crate::error::WafNonEmptyEntityException {
                message: self.message,
            }
        }
    }
}
impl WafNonEmptyEntityException {
    /// Creates a new builder-style object to manufacture [`WafNonEmptyEntityException`](crate::error::WafNonEmptyEntityException)
    pub fn builder() -> crate::error::waf_non_empty_entity_exception::Builder {
        crate::error::waf_non_empty_entity_exception::Builder::default()
    }
}

/// <p>The operation failed due to a problem with the migration. The failure cause is provided in the exception, in the <code>MigrationErrorType</code>: </p>
/// <ul>
/// <li> <p> <code>ENTITY_NOT_SUPPORTED</code> - The web ACL has an unsupported entity but the <code>IgnoreUnsupportedType</code> is not set to true.</p> </li>
/// <li> <p> <code>ENTITY_NOT_FOUND</code> - The web ACL doesn't exist. </p> </li>
/// <li> <p> <code>S3_BUCKET_NO_PERMISSION</code> - You don't have permission to perform the <code>PutObject</code> action to the specified Amazon S3 bucket.</p> </li>
/// <li> <p> <code>S3_BUCKET_NOT_ACCESSIBLE</code> - The bucket policy doesn't allow AWS WAF to perform the <code>PutObject</code> action in the bucket.</p> </li>
/// <li> <p> <code>S3_BUCKET_NOT_FOUND</code> - The S3 bucket doesn't exist. </p> </li>
/// <li> <p> <code>S3_BUCKET_INVALID_REGION</code> - The S3 bucket is not in the same Region as the web ACL.</p> </li>
/// <li> <p> <code>S3_INTERNAL_ERROR</code> - AWS WAF failed to create the template in the S3 bucket for another reason.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WafEntityMigrationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub migration_error_type: std::option::Option<crate::model::MigrationErrorType>,
    #[allow(missing_docs)] // documentation missing in model
    pub migration_error_reason: std::option::Option<std::string::String>,
}
impl WafEntityMigrationException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn migration_error_type(&self) -> std::option::Option<&crate::model::MigrationErrorType> {
        self.migration_error_type.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn migration_error_reason(&self) -> std::option::Option<&str> {
        self.migration_error_reason.as_deref()
    }
}
impl std::fmt::Debug for WafEntityMigrationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WafEntityMigrationException");
        formatter.field("message", &self.message);
        formatter.field("migration_error_type", &self.migration_error_type);
        formatter.field("migration_error_reason", &self.migration_error_reason);
        formatter.finish()
    }
}
impl WafEntityMigrationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for WafEntityMigrationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "WafEntityMigrationException [WAFEntityMigrationException]"
        )?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for WafEntityMigrationException {}
/// See [`WafEntityMigrationException`](crate::error::WafEntityMigrationException)
pub mod waf_entity_migration_exception {
    /// A builder for [`WafEntityMigrationException`](crate::error::WafEntityMigrationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) migration_error_type: std::option::Option<crate::model::MigrationErrorType>,
        pub(crate) migration_error_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn migration_error_type(mut self, input: crate::model::MigrationErrorType) -> Self {
            self.migration_error_type = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_migration_error_type(
            mut self,
            input: std::option::Option<crate::model::MigrationErrorType>,
        ) -> Self {
            self.migration_error_type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn migration_error_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_error_reason = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_migration_error_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.migration_error_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`WafEntityMigrationException`](crate::error::WafEntityMigrationException)
        pub fn build(self) -> crate::error::WafEntityMigrationException {
            crate::error::WafEntityMigrationException {
                message: self.message,
                migration_error_type: self.migration_error_type,
                migration_error_reason: self.migration_error_reason,
            }
        }
    }
}
impl WafEntityMigrationException {
    /// Creates a new builder-style object to manufacture [`WafEntityMigrationException`](crate::error::WafEntityMigrationException)
    pub fn builder() -> crate::error::waf_entity_migration_exception::Builder {
        crate::error::waf_entity_migration_exception::Builder::default()
    }
}
