// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS WAF
///
/// Client for invoking operations on AWS WAF. Each operation on AWS WAF is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_waf::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_waf::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_waf::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateByteMatchSet`](crate::client::fluent_builders::CreateByteMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateByteMatchSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateByteMatchSet::set_name): <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateByteMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateByteMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateByteMatchSetOutput`](crate::output::CreateByteMatchSetOutput) with field(s):
    ///   - [`byte_match_set(Option<ByteMatchSet>)`](crate::output::CreateByteMatchSetOutput::byte_match_set): <p>A <code>ByteMatchSet</code> that contains no <code>ByteMatchTuple</code> objects.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateByteMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateByteMatchSetError>`](crate::error::CreateByteMatchSetError)
    pub fn create_byte_match_set(&self) -> fluent_builders::CreateByteMatchSet {
        fluent_builders::CreateByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGeoMatchSet`](crate::client::fluent_builders::CreateGeoMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateGeoMatchSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateGeoMatchSet::set_name): <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change <code>Name</code> after you create the <code>GeoMatchSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateGeoMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateGeoMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateGeoMatchSetOutput`](crate::output::CreateGeoMatchSetOutput) with field(s):
    ///   - [`geo_match_set(Option<GeoMatchSet>)`](crate::output::CreateGeoMatchSetOutput::geo_match_set): <p>The <code>GeoMatchSet</code> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateGeoMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateGeoMatchSetError>`](crate::error::CreateGeoMatchSetError)
    pub fn create_geo_match_set(&self) -> fluent_builders::CreateGeoMatchSet {
        fluent_builders::CreateGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIPSet`](crate::client::fluent_builders::CreateIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateIPSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateIPSet::set_name): <p>A friendly name or description of the <code>IPSet</code>. You can't change <code>Name</code> after you create the <code>IPSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateIPSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateIPSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateIpSetOutput`](crate::output::CreateIpSetOutput) with field(s):
    ///   - [`ip_set(Option<IpSet>)`](crate::output::CreateIpSetOutput::ip_set): <p>The <code>IPSet</code> returned in the <code>CreateIPSet</code> response.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateIpSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateIPSetError>`](crate::error::CreateIPSetError)
    pub fn create_ip_set(&self) -> fluent_builders::CreateIPSet {
        fluent_builders::CreateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRateBasedRule`](crate::client::fluent_builders::CreateRateBasedRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRateBasedRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRateBasedRule::set_name): <p>A friendly name or description of the <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::CreateRateBasedRule::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::CreateRateBasedRule::set_metric_name): <p>A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
    ///   - [`rate_key(RateKey)`](crate::client::fluent_builders::CreateRateBasedRule::rate_key) / [`set_rate_key(Option<RateKey>)`](crate::client::fluent_builders::CreateRateBasedRule::set_rate_key): <p>The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests that arrive from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
    ///   - [`rate_limit(i64)`](crate::client::fluent_builders::CreateRateBasedRule::rate_limit) / [`set_rate_limit(i64)`](crate::client::fluent_builders::CreateRateBasedRule::set_rate_limit): <p>The maximum number of requests, which have an identical value in the field that is specified by <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateRateBasedRule::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateRateBasedRule::set_change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRateBasedRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRateBasedRule::set_tags): <p></p>
    /// - On success, responds with [`CreateRateBasedRuleOutput`](crate::output::CreateRateBasedRuleOutput) with field(s):
    ///   - [`rule(Option<RateBasedRule>)`](crate::output::CreateRateBasedRuleOutput::rule): <p>The <code>RateBasedRule</code> that is returned in the <code>CreateRateBasedRule</code> response.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateRateBasedRuleOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRateBasedRuleError>`](crate::error::CreateRateBasedRuleError)
    pub fn create_rate_based_rule(&self) -> fluent_builders::CreateRateBasedRule {
        fluent_builders::CreateRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRegexMatchSet`](crate::client::fluent_builders::CreateRegexMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRegexMatchSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRegexMatchSet::set_name): <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateRegexMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateRegexMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateRegexMatchSetOutput`](crate::output::CreateRegexMatchSetOutput) with field(s):
    ///   - [`regex_match_set(Option<RegexMatchSet>)`](crate::output::CreateRegexMatchSetOutput::regex_match_set): <p>A <code>RegexMatchSet</code> that contains no <code>RegexMatchTuple</code> objects.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateRegexMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRegexMatchSetError>`](crate::error::CreateRegexMatchSetError)
    pub fn create_regex_match_set(&self) -> fluent_builders::CreateRegexMatchSet {
        fluent_builders::CreateRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRegexPatternSet`](crate::client::fluent_builders::CreateRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_name): <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateRegexPatternSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateRegexPatternSetOutput`](crate::output::CreateRegexPatternSetOutput) with field(s):
    ///   - [`regex_pattern_set(Option<RegexPatternSet>)`](crate::output::CreateRegexPatternSetOutput::regex_pattern_set): <p>A <code>RegexPatternSet</code> that contains no objects.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateRegexPatternSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRegexPatternSetError>`](crate::error::CreateRegexPatternSetError)
    pub fn create_regex_pattern_set(&self) -> fluent_builders::CreateRegexPatternSet {
        fluent_builders::CreateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRule`](crate::client::fluent_builders::CreateRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRule::set_name): <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::CreateRule::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::CreateRule::set_metric_name): <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>Rule</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateRule::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateRule::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRule::set_tags): <p></p>
    /// - On success, responds with [`CreateRuleOutput`](crate::output::CreateRuleOutput) with field(s):
    ///   - [`rule(Option<Rule>)`](crate::output::CreateRuleOutput::rule): <p>The <code>Rule</code> returned in the <code>CreateRule</code> response.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateRuleOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRuleError>`](crate::error::CreateRuleError)
    pub fn create_rule(&self) -> fluent_builders::CreateRule {
        fluent_builders::CreateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRuleGroup`](crate::client::fluent_builders::CreateRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_name): <p>A friendly name or description of the <code>RuleGroup</code>. You can't change <code>Name</code> after you create a <code>RuleGroup</code>.</p>
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_metric_name): <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateRuleGroup::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateRuleGroup::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRuleGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRuleGroup::set_tags): <p></p>
    /// - On success, responds with [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput) with field(s):
    ///   - [`rule_group(Option<RuleGroup>)`](crate::output::CreateRuleGroupOutput::rule_group): <p>An empty <code>RuleGroup</code>.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateRuleGroupOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateRuleGroupError>`](crate::error::CreateRuleGroupError)
    pub fn create_rule_group(&self) -> fluent_builders::CreateRuleGroup {
        fluent_builders::CreateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSizeConstraintSet`](crate::client::fluent_builders::CreateSizeConstraintSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSizeConstraintSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSizeConstraintSet::set_name): <p>A friendly name or description of the <code>SizeConstraintSet</code>. You can't change <code>Name</code> after you create a <code>SizeConstraintSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateSizeConstraintSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateSizeConstraintSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateSizeConstraintSetOutput`](crate::output::CreateSizeConstraintSetOutput) with field(s):
    ///   - [`size_constraint_set(Option<SizeConstraintSet>)`](crate::output::CreateSizeConstraintSetOutput::size_constraint_set): <p>A <code>SizeConstraintSet</code> that contains no <code>SizeConstraint</code> objects.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateSizeConstraintSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateSizeConstraintSetError>`](crate::error::CreateSizeConstraintSetError)
    pub fn create_size_constraint_set(&self) -> fluent_builders::CreateSizeConstraintSet {
        fluent_builders::CreateSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSqlInjectionMatchSet`](crate::client::fluent_builders::CreateSqlInjectionMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSqlInjectionMatchSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSqlInjectionMatchSet::set_name): <p>A friendly name or description for the <code>SqlInjectionMatchSet</code> that you're creating. You can't change <code>Name</code> after you create the <code>SqlInjectionMatchSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateSqlInjectionMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateSqlInjectionMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateSqlInjectionMatchSetOutput`](crate::output::CreateSqlInjectionMatchSetOutput) with field(s):
    ///   - [`sql_injection_match_set(Option<SqlInjectionMatchSet>)`](crate::output::CreateSqlInjectionMatchSetOutput::sql_injection_match_set): <p>A <code>SqlInjectionMatchSet</code>.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateSqlInjectionMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateSqlInjectionMatchSetError>`](crate::error::CreateSqlInjectionMatchSetError)
    pub fn create_sql_injection_match_set(&self) -> fluent_builders::CreateSqlInjectionMatchSet {
        fluent_builders::CreateSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWebACL`](crate::client::fluent_builders::CreateWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateWebACL::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateWebACL::set_name): <p>A friendly name or description of the <code>WebACL</code>. You can't change <code>Name</code> after you create the <code>WebACL</code>.</p>
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::CreateWebACL::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::CreateWebACL::set_metric_name): <p>A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
    ///   - [`default_action(WafAction)`](crate::client::fluent_builders::CreateWebACL::default_action) / [`set_default_action(Option<WafAction>)`](crate::client::fluent_builders::CreateWebACL::set_default_action): <p>The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of the <code>Rule</code> objects that are associated with the <code>WebACL</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateWebACL::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateWebACL::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWebACL::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWebACL::set_tags): <p></p>
    /// - On success, responds with [`CreateWebAclOutput`](crate::output::CreateWebAclOutput) with field(s):
    ///   - [`web_acl(Option<WebAcl>)`](crate::output::CreateWebAclOutput::web_acl): <p>The <code>WebACL</code> returned in the <code>CreateWebACL</code> response.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateWebAclOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateWebACLError>`](crate::error::CreateWebACLError)
    pub fn create_web_acl(&self) -> fluent_builders::CreateWebACL {
        fluent_builders::CreateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWebACLMigrationStack`](crate::client::fluent_builders::CreateWebACLMigrationStack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::CreateWebACLMigrationStack::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::CreateWebACLMigrationStack::set_web_acl_id): <p>The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.</p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::CreateWebACLMigrationStack::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::CreateWebACLMigrationStack::set_s3_bucket_name): <p>The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be configured as follows for the migration: </p>  <ul>   <li> <p>The bucket name must start with <code>aws-waf-migration-</code>. For example, <code>aws-waf-migration-my-web-acl</code>.</p> </li>   <li> <p>The bucket must be in the Region where you are deploying the template. For example, for a web ACL in us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2. </p> </li>   <li> <p>The bucket policies must permit the migration process to write data. For listings of the bucket policies, see the Examples section. </p> </li>  </ul>
    ///   - [`ignore_unsupported_type(bool)`](crate::client::fluent_builders::CreateWebACLMigrationStack::ignore_unsupported_type) / [`set_ignore_unsupported_type(Option<bool>)`](crate::client::fluent_builders::CreateWebACLMigrationStack::set_ignore_unsupported_type): <p>Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to true to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported entities, it stops the process and throws an exception. </p>
    /// - On success, responds with [`CreateWebAclMigrationStackOutput`](crate::output::CreateWebAclMigrationStackOutput) with field(s):
    ///   - [`s3_object_url(Option<String>)`](crate::output::CreateWebAclMigrationStackOutput::s3_object_url): <p>The URL of the template created in Amazon S3. </p>
    /// - On failure, responds with [`SdkError<CreateWebACLMigrationStackError>`](crate::error::CreateWebACLMigrationStackError)
    pub fn create_web_acl_migration_stack(&self) -> fluent_builders::CreateWebACLMigrationStack {
        fluent_builders::CreateWebACLMigrationStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateXssMatchSet`](crate::client::fluent_builders::CreateXssMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateXssMatchSet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateXssMatchSet::set_name): <p>A friendly name or description for the <code>XssMatchSet</code> that you're creating. You can't change <code>Name</code> after you create the <code>XssMatchSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::CreateXssMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::CreateXssMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`CreateXssMatchSetOutput`](crate::output::CreateXssMatchSetOutput) with field(s):
    ///   - [`xss_match_set(Option<XssMatchSet>)`](crate::output::CreateXssMatchSetOutput::xss_match_set): <p>An <code>XssMatchSet</code>.</p>
    ///   - [`change_token(Option<String>)`](crate::output::CreateXssMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<CreateXssMatchSetError>`](crate::error::CreateXssMatchSetError)
    pub fn create_xss_match_set(&self) -> fluent_builders::CreateXssMatchSet {
        fluent_builders::CreateXssMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteByteMatchSet`](crate::client::fluent_builders::DeleteByteMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`byte_match_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteByteMatchSet::byte_match_set_id) / [`set_byte_match_set_id(Option<String>)`](crate::client::fluent_builders::DeleteByteMatchSet::set_byte_match_set_id): <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to delete. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteByteMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteByteMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteByteMatchSetOutput`](crate::output::DeleteByteMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteByteMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteByteMatchSetError>`](crate::error::DeleteByteMatchSetError)
    pub fn delete_byte_match_set(&self) -> fluent_builders::DeleteByteMatchSet {
        fluent_builders::DeleteByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGeoMatchSet`](crate::client::fluent_builders::DeleteGeoMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`geo_match_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGeoMatchSet::geo_match_set_id) / [`set_geo_match_set_id(Option<String>)`](crate::client::fluent_builders::DeleteGeoMatchSet::set_geo_match_set_id): <p>The <code>GeoMatchSetID</code> of the <code>GeoMatchSet</code> that you want to delete. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteGeoMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteGeoMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteGeoMatchSetOutput`](crate::output::DeleteGeoMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteGeoMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteGeoMatchSetError>`](crate::error::DeleteGeoMatchSetError)
    pub fn delete_geo_match_set(&self) -> fluent_builders::DeleteGeoMatchSet {
        fluent_builders::DeleteGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIPSet`](crate::client::fluent_builders::DeleteIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIPSet::ip_set_id) / [`set_ip_set_id(Option<String>)`](crate::client::fluent_builders::DeleteIPSet::set_ip_set_id): <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to delete. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteIPSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteIPSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteIpSetOutput`](crate::output::DeleteIpSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteIpSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteIPSetError>`](crate::error::DeleteIPSetError)
    pub fn delete_ip_set(&self) -> fluent_builders::DeleteIPSet {
        fluent_builders::DeleteIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLoggingConfiguration`](crate::client::fluent_builders::DeleteLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLoggingConfiguration::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteLoggingConfiguration::set_resource_arn): <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
    /// - On success, responds with [`DeleteLoggingConfigurationOutput`](crate::output::DeleteLoggingConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteLoggingConfigurationError>`](crate::error::DeleteLoggingConfigurationError)
    pub fn delete_logging_configuration(&self) -> fluent_builders::DeleteLoggingConfiguration {
        fluent_builders::DeleteLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePermissionPolicy`](crate::client::fluent_builders::DeletePermissionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeletePermissionPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeletePermissionPolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete the policy.</p>  <p>The user making the request must be the owner of the RuleGroup.</p>
    /// - On success, responds with [`DeletePermissionPolicyOutput`](crate::output::DeletePermissionPolicyOutput)

    /// - On failure, responds with [`SdkError<DeletePermissionPolicyError>`](crate::error::DeletePermissionPolicyError)
    pub fn delete_permission_policy(&self) -> fluent_builders::DeletePermissionPolicy {
        fluent_builders::DeletePermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRateBasedRule`](crate::client::fluent_builders::DeleteRateBasedRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRateBasedRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::DeleteRateBasedRule::set_rule_id): <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to delete. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRateBasedRule::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteRateBasedRule::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteRateBasedRuleOutput`](crate::output::DeleteRateBasedRuleOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteRateBasedRuleOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteRateBasedRuleError>`](crate::error::DeleteRateBasedRuleError)
    pub fn delete_rate_based_rule(&self) -> fluent_builders::DeleteRateBasedRule {
        fluent_builders::DeleteRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRegexMatchSet`](crate::client::fluent_builders::DeleteRegexMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`regex_match_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexMatchSet::regex_match_set_id) / [`set_regex_match_set_id(Option<String>)`](crate::client::fluent_builders::DeleteRegexMatchSet::set_regex_match_set_id): <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to delete. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteRegexMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteRegexMatchSetOutput`](crate::output::DeleteRegexMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteRegexMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteRegexMatchSetError>`](crate::error::DeleteRegexMatchSetError)
    pub fn delete_regex_match_set(&self) -> fluent_builders::DeleteRegexMatchSet {
        fluent_builders::DeleteRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRegexPatternSet`](crate::client::fluent_builders::DeleteRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`regex_pattern_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::regex_pattern_set_id) / [`set_regex_pattern_set_id(Option<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::set_regex_pattern_set_id): <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to delete. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteRegexPatternSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteRegexPatternSetOutput`](crate::output::DeleteRegexPatternSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteRegexPatternSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteRegexPatternSetError>`](crate::error::DeleteRegexPatternSetError)
    pub fn delete_regex_pattern_set(&self) -> fluent_builders::DeleteRegexPatternSet {
        fluent_builders::DeleteRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRule`](crate::client::fluent_builders::DeleteRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::DeleteRule::set_rule_id): <p>The <code>RuleId</code> of the <code>Rule</code> that you want to delete. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRule::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteRule::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteRuleOutput`](crate::output::DeleteRuleOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteRuleOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteRuleError>`](crate::error::DeleteRuleError)
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRuleGroup`](crate::client::fluent_builders::DeleteRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::rule_group_id) / [`set_rule_group_id(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_rule_group_id): <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to delete. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRuleGroup::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteRuleGroup::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteRuleGroupOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteRuleGroupError>`](crate::error::DeleteRuleGroupError)
    pub fn delete_rule_group(&self) -> fluent_builders::DeleteRuleGroup {
        fluent_builders::DeleteRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSizeConstraintSet`](crate::client::fluent_builders::DeleteSizeConstraintSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`size_constraint_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSizeConstraintSet::size_constraint_set_id) / [`set_size_constraint_set_id(Option<String>)`](crate::client::fluent_builders::DeleteSizeConstraintSet::set_size_constraint_set_id): <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to delete. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteSizeConstraintSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteSizeConstraintSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteSizeConstraintSetOutput`](crate::output::DeleteSizeConstraintSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteSizeConstraintSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteSizeConstraintSetError>`](crate::error::DeleteSizeConstraintSetError)
    pub fn delete_size_constraint_set(&self) -> fluent_builders::DeleteSizeConstraintSet {
        fluent_builders::DeleteSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSqlInjectionMatchSet`](crate::client::fluent_builders::DeleteSqlInjectionMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sql_injection_match_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSqlInjectionMatchSet::sql_injection_match_set_id) / [`set_sql_injection_match_set_id(Option<String>)`](crate::client::fluent_builders::DeleteSqlInjectionMatchSet::set_sql_injection_match_set_id): <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to delete. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteSqlInjectionMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteSqlInjectionMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteSqlInjectionMatchSetOutput`](crate::output::DeleteSqlInjectionMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteSqlInjectionMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteSqlInjectionMatchSetError>`](crate::error::DeleteSqlInjectionMatchSetError)
    pub fn delete_sql_injection_match_set(&self) -> fluent_builders::DeleteSqlInjectionMatchSet {
        fluent_builders::DeleteSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWebACL`](crate::client::fluent_builders::DeleteWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWebACL::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::DeleteWebACL::set_web_acl_id): <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to delete. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteWebACL::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteWebACL::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteWebAclOutput`](crate::output::DeleteWebAclOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteWebAclOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteWebACLError>`](crate::error::DeleteWebACLError)
    pub fn delete_web_acl(&self) -> fluent_builders::DeleteWebACL {
        fluent_builders::DeleteWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteXssMatchSet`](crate::client::fluent_builders::DeleteXssMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`xss_match_set_id(impl Into<String>)`](crate::client::fluent_builders::DeleteXssMatchSet::xss_match_set_id) / [`set_xss_match_set_id(Option<String>)`](crate::client::fluent_builders::DeleteXssMatchSet::set_xss_match_set_id): <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to delete. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::DeleteXssMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::DeleteXssMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`DeleteXssMatchSetOutput`](crate::output::DeleteXssMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::DeleteXssMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteXssMatchSetError>`](crate::error::DeleteXssMatchSetError)
    pub fn delete_xss_match_set(&self) -> fluent_builders::DeleteXssMatchSet {
        fluent_builders::DeleteXssMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetByteMatchSet`](crate::client::fluent_builders::GetByteMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`byte_match_set_id(impl Into<String>)`](crate::client::fluent_builders::GetByteMatchSet::byte_match_set_id) / [`set_byte_match_set_id(Option<String>)`](crate::client::fluent_builders::GetByteMatchSet::set_byte_match_set_id): <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to get. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    /// - On success, responds with [`GetByteMatchSetOutput`](crate::output::GetByteMatchSetOutput) with field(s):
    ///   - [`byte_match_set(Option<ByteMatchSet>)`](crate::output::GetByteMatchSetOutput::byte_match_set): <p>Information about the <code>ByteMatchSet</code> that you specified in the <code>GetByteMatchSet</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>ByteMatchSet</code>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and <code>Name</code> </p> </li>   <li> <p> <code>ByteMatchTuples</code>: Contains an array of <code>ByteMatchTuple</code> objects. Each <code>ByteMatchTuple</code> object contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetByteMatchSetError>`](crate::error::GetByteMatchSetError)
    pub fn get_byte_match_set(&self) -> fluent_builders::GetByteMatchSet {
        fluent_builders::GetByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChangeToken`](crate::client::fluent_builders::GetChangeToken) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetChangeToken::send) it.

    /// - On success, responds with [`GetChangeTokenOutput`](crate::output::GetChangeTokenOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::GetChangeTokenOutput::change_token): <p>The <code>ChangeToken</code> that you used in the request. Use this value in a <code>GetChangeTokenStatus</code> request to get the current status of the request. </p>
    /// - On failure, responds with [`SdkError<GetChangeTokenError>`](crate::error::GetChangeTokenError)
    pub fn get_change_token(&self) -> fluent_builders::GetChangeToken {
        fluent_builders::GetChangeToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChangeTokenStatus`](crate::client::fluent_builders::GetChangeTokenStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::GetChangeTokenStatus::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::GetChangeTokenStatus::set_change_token): <p>The change token for which you want to get the status. This change token was previously returned in the <code>GetChangeToken</code> response.</p>
    /// - On success, responds with [`GetChangeTokenStatusOutput`](crate::output::GetChangeTokenStatusOutput) with field(s):
    ///   - [`change_token_status(Option<ChangeTokenStatus>)`](crate::output::GetChangeTokenStatusOutput::change_token_status): <p>The status of the change token.</p>
    /// - On failure, responds with [`SdkError<GetChangeTokenStatusError>`](crate::error::GetChangeTokenStatusError)
    pub fn get_change_token_status(&self) -> fluent_builders::GetChangeTokenStatus {
        fluent_builders::GetChangeTokenStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGeoMatchSet`](crate::client::fluent_builders::GetGeoMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`geo_match_set_id(impl Into<String>)`](crate::client::fluent_builders::GetGeoMatchSet::geo_match_set_id) / [`set_geo_match_set_id(Option<String>)`](crate::client::fluent_builders::GetGeoMatchSet::set_geo_match_set_id): <p>The <code>GeoMatchSetId</code> of the <code>GeoMatchSet</code> that you want to get. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
    /// - On success, responds with [`GetGeoMatchSetOutput`](crate::output::GetGeoMatchSetOutput) with field(s):
    ///   - [`geo_match_set(Option<GeoMatchSet>)`](crate::output::GetGeoMatchSetOutput::geo_match_set): <p>Information about the <code>GeoMatchSet</code> that you specified in the <code>GetGeoMatchSet</code> request. This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific country.</p>
    /// - On failure, responds with [`SdkError<GetGeoMatchSetError>`](crate::error::GetGeoMatchSetError)
    pub fn get_geo_match_set(&self) -> fluent_builders::GetGeoMatchSet {
        fluent_builders::GetGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIPSet`](crate::client::fluent_builders::GetIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip_set_id(impl Into<String>)`](crate::client::fluent_builders::GetIPSet::ip_set_id) / [`set_ip_set_id(Option<String>)`](crate::client::fluent_builders::GetIPSet::set_ip_set_id): <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to get. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
    /// - On success, responds with [`GetIpSetOutput`](crate::output::GetIpSetOutput) with field(s):
    ///   - [`ip_set(Option<IpSet>)`](crate::output::GetIpSetOutput::ip_set): <p>Information about the <code>IPSet</code> that you specified in the <code>GetIPSet</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>IPSet</code>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code> </p> </li>   <li> <p> <code>IPSetDescriptors</code>: Contains an array of <code>IPSetDescriptor</code> objects. Each <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetIPSetError>`](crate::error::GetIPSetError)
    pub fn get_ip_set(&self) -> fluent_builders::GetIPSet {
        fluent_builders::GetIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLoggingConfiguration`](crate::client::fluent_builders::GetLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetLoggingConfiguration::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetLoggingConfiguration::set_resource_arn): <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
    /// - On success, responds with [`GetLoggingConfigurationOutput`](crate::output::GetLoggingConfigurationOutput) with field(s):
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::GetLoggingConfigurationOutput::logging_configuration): <p>The <code>LoggingConfiguration</code> for the specified web ACL.</p>
    /// - On failure, responds with [`SdkError<GetLoggingConfigurationError>`](crate::error::GetLoggingConfigurationError)
    pub fn get_logging_configuration(&self) -> fluent_builders::GetLoggingConfiguration {
        fluent_builders::GetLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPermissionPolicy`](crate::client::fluent_builders::GetPermissionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetPermissionPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetPermissionPolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the RuleGroup for which you want to get the policy.</p>
    /// - On success, responds with [`GetPermissionPolicyOutput`](crate::output::GetPermissionPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetPermissionPolicyOutput::policy): <p>The IAM policy attached to the specified RuleGroup.</p>
    /// - On failure, responds with [`SdkError<GetPermissionPolicyError>`](crate::error::GetPermissionPolicyError)
    pub fn get_permission_policy(&self) -> fluent_builders::GetPermissionPolicy {
        fluent_builders::GetPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRateBasedRule`](crate::client::fluent_builders::GetRateBasedRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::GetRateBasedRule::set_rule_id): <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to get. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
    /// - On success, responds with [`GetRateBasedRuleOutput`](crate::output::GetRateBasedRuleOutput) with field(s):
    ///   - [`rule(Option<RateBasedRule>)`](crate::output::GetRateBasedRuleOutput::rule): <p>Information about the <code>RateBasedRule</code> that you specified in the <code>GetRateBasedRule</code> request.</p>
    /// - On failure, responds with [`SdkError<GetRateBasedRuleError>`](crate::error::GetRateBasedRuleError)
    pub fn get_rate_based_rule(&self) -> fluent_builders::GetRateBasedRule {
        fluent_builders::GetRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRateBasedRuleManagedKeys`](crate::client::fluent_builders::GetRateBasedRuleManagedKeys) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedRuleManagedKeys::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::GetRateBasedRuleManagedKeys::set_rule_id): <p>The <code>RuleId</code> of the <code>RateBasedRule</code> for which you want to get a list of <code>ManagedKeys</code>. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::GetRateBasedRuleManagedKeys::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::GetRateBasedRuleManagedKeys::set_next_marker): <p>A null value and not currently used. Do not include this in your request.</p>
    /// - On success, responds with [`GetRateBasedRuleManagedKeysOutput`](crate::output::GetRateBasedRuleManagedKeysOutput) with field(s):
    ///   - [`managed_keys(Option<Vec<String>>)`](crate::output::GetRateBasedRuleManagedKeysOutput::managed_keys): <p>An array of IP addresses that currently are blocked by the specified <code>RateBasedRule</code>. </p>
    ///   - [`next_marker(Option<String>)`](crate::output::GetRateBasedRuleManagedKeysOutput::next_marker): <p>A null value and not currently used.</p>
    /// - On failure, responds with [`SdkError<GetRateBasedRuleManagedKeysError>`](crate::error::GetRateBasedRuleManagedKeysError)
    pub fn get_rate_based_rule_managed_keys(&self) -> fluent_builders::GetRateBasedRuleManagedKeys {
        fluent_builders::GetRateBasedRuleManagedKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRegexMatchSet`](crate::client::fluent_builders::GetRegexMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`regex_match_set_id(impl Into<String>)`](crate::client::fluent_builders::GetRegexMatchSet::regex_match_set_id) / [`set_regex_match_set_id(Option<String>)`](crate::client::fluent_builders::GetRegexMatchSet::set_regex_match_set_id): <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to get. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    /// - On success, responds with [`GetRegexMatchSetOutput`](crate::output::GetRegexMatchSetOutput) with field(s):
    ///   - [`regex_match_set(Option<RegexMatchSet>)`](crate::output::GetRegexMatchSetOutput::regex_match_set): <p>Information about the <code>RegexMatchSet</code> that you specified in the <code>GetRegexMatchSet</code> request. For more information, see <code>RegexMatchTuple</code>.</p>
    /// - On failure, responds with [`SdkError<GetRegexMatchSetError>`](crate::error::GetRegexMatchSetError)
    pub fn get_regex_match_set(&self) -> fluent_builders::GetRegexMatchSet {
        fluent_builders::GetRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRegexPatternSet`](crate::client::fluent_builders::GetRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`regex_pattern_set_id(impl Into<String>)`](crate::client::fluent_builders::GetRegexPatternSet::regex_pattern_set_id) / [`set_regex_pattern_set_id(Option<String>)`](crate::client::fluent_builders::GetRegexPatternSet::set_regex_pattern_set_id): <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to get. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    /// - On success, responds with [`GetRegexPatternSetOutput`](crate::output::GetRegexPatternSetOutput) with field(s):
    ///   - [`regex_pattern_set(Option<RegexPatternSet>)`](crate::output::GetRegexPatternSetOutput::regex_pattern_set): <p>Information about the <code>RegexPatternSet</code> that you specified in the <code>GetRegexPatternSet</code> request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to search for. </p>
    /// - On failure, responds with [`SdkError<GetRegexPatternSetError>`](crate::error::GetRegexPatternSetError)
    pub fn get_regex_pattern_set(&self) -> fluent_builders::GetRegexPatternSet {
        fluent_builders::GetRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRule`](crate::client::fluent_builders::GetRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::GetRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::GetRule::set_rule_id): <p>The <code>RuleId</code> of the <code>Rule</code> that you want to get. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    /// - On success, responds with [`GetRuleOutput`](crate::output::GetRuleOutput) with field(s):
    ///   - [`rule(Option<Rule>)`](crate::output::GetRuleOutput::rule): <p>Information about the <code>Rule</code> that you specified in the <code>GetRule</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>Rule</code>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects, and <code>RuleId</code> </p> </li>   <li> <p> <code>Predicate</code>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetRuleError>`](crate::error::GetRuleError)
    pub fn get_rule(&self) -> fluent_builders::GetRule {
        fluent_builders::GetRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRuleGroup`](crate::client::fluent_builders::GetRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_id(impl Into<String>)`](crate::client::fluent_builders::GetRuleGroup::rule_group_id) / [`set_rule_group_id(Option<String>)`](crate::client::fluent_builders::GetRuleGroup::set_rule_group_id): <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to get. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    /// - On success, responds with [`GetRuleGroupOutput`](crate::output::GetRuleGroupOutput) with field(s):
    ///   - [`rule_group(Option<RuleGroup>)`](crate::output::GetRuleGroupOutput::rule_group): <p>Information about the <code>RuleGroup</code> that you specified in the <code>GetRuleGroup</code> request. </p>
    /// - On failure, responds with [`SdkError<GetRuleGroupError>`](crate::error::GetRuleGroupError)
    pub fn get_rule_group(&self) -> fluent_builders::GetRuleGroup {
        fluent_builders::GetRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSampledRequests`](crate::client::fluent_builders::GetSampledRequests) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::GetSampledRequests::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::GetSampledRequests::set_web_acl_id): <p>The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::GetSampledRequests::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::GetSampledRequests::set_rule_id): <p> <code>RuleId</code> is one of three values:</p>  <ul>   <li> <p>The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p> </li>   <li> <p> <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests that didn't match any of the rules in the specified <code>WebACL</code>.</p> </li>  </ul>
    ///   - [`time_window(TimeWindow)`](crate::client::fluent_builders::GetSampledRequests::time_window) / [`set_time_window(Option<TimeWindow>)`](crate::client::fluent_builders::GetSampledRequests::set_time_window): <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
    ///   - [`max_items(i64)`](crate::client::fluent_builders::GetSampledRequests::max_items) / [`set_max_items(i64)`](crate::client::fluent_builders::GetSampledRequests::set_max_items): <p>The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
    /// - On success, responds with [`GetSampledRequestsOutput`](crate::output::GetSampledRequestsOutput) with field(s):
    ///   - [`sampled_requests(Option<Vec<SampledHttpRequest>>)`](crate::output::GetSampledRequestsOutput::sampled_requests): <p>A complex type that contains detailed information about each of the requests in the sample.</p>
    ///   - [`population_size(i64)`](crate::output::GetSampledRequestsOutput::population_size): <p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your AWS resource received during the specified time range.</p>
    ///   - [`time_window(Option<TimeWindow>)`](crate::output::GetSampledRequestsOutput::time_window): <p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>
    /// - On failure, responds with [`SdkError<GetSampledRequestsError>`](crate::error::GetSampledRequestsError)
    pub fn get_sampled_requests(&self) -> fluent_builders::GetSampledRequests {
        fluent_builders::GetSampledRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSizeConstraintSet`](crate::client::fluent_builders::GetSizeConstraintSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`size_constraint_set_id(impl Into<String>)`](crate::client::fluent_builders::GetSizeConstraintSet::size_constraint_set_id) / [`set_size_constraint_set_id(Option<String>)`](crate::client::fluent_builders::GetSizeConstraintSet::set_size_constraint_set_id): <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to get. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    /// - On success, responds with [`GetSizeConstraintSetOutput`](crate::output::GetSizeConstraintSetOutput) with field(s):
    ///   - [`size_constraint_set(Option<SizeConstraintSet>)`](crate::output::GetSizeConstraintSetOutput::size_constraint_set): <p>Information about the <code>SizeConstraintSet</code> that you specified in the <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>SizeConstraintSet</code>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and <code>Name</code> </p> </li>   <li> <p> <code>SizeConstraints</code>: Contains an array of <code>SizeConstraint</code> objects. Each <code>SizeConstraint</code> object contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetSizeConstraintSetError>`](crate::error::GetSizeConstraintSetError)
    pub fn get_size_constraint_set(&self) -> fluent_builders::GetSizeConstraintSet {
        fluent_builders::GetSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSqlInjectionMatchSet`](crate::client::fluent_builders::GetSqlInjectionMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sql_injection_match_set_id(impl Into<String>)`](crate::client::fluent_builders::GetSqlInjectionMatchSet::sql_injection_match_set_id) / [`set_sql_injection_match_set_id(Option<String>)`](crate::client::fluent_builders::GetSqlInjectionMatchSet::set_sql_injection_match_set_id): <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to get. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    /// - On success, responds with [`GetSqlInjectionMatchSetOutput`](crate::output::GetSqlInjectionMatchSetOutput) with field(s):
    ///   - [`sql_injection_match_set(Option<SqlInjectionMatchSet>)`](crate::output::GetSqlInjectionMatchSetOutput::sql_injection_match_set): <p>Information about the <code>SqlInjectionMatchSet</code> that you specified in the <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>SqlInjectionMatchSet</code>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of <code>SqlInjectionMatchTuple</code> objects</p> </li>   <li> <p> <code>SqlInjectionMatchTuple</code>: Each <code>SqlInjectionMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetSqlInjectionMatchSetError>`](crate::error::GetSqlInjectionMatchSetError)
    pub fn get_sql_injection_match_set(&self) -> fluent_builders::GetSqlInjectionMatchSet {
        fluent_builders::GetSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWebACL`](crate::client::fluent_builders::GetWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::GetWebACL::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::GetWebACL::set_web_acl_id): <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to get. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    /// - On success, responds with [`GetWebAclOutput`](crate::output::GetWebAclOutput) with field(s):
    ///   - [`web_acl(Option<WebAcl>)`](crate::output::GetWebAclOutput::web_acl): <p>Information about the <code>WebACL</code> that you specified in the <code>GetWebACL</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>WebACL</code>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of <code>Rule</code> objects, and <code>WebACLId</code> </p> </li>   <li> <p> <code>DefaultAction</code> (Data type is <code>WafAction</code>): Contains <code>Type</code> </p> </li>   <li> <p> <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain <code>Action</code>, <code>Priority</code>, and <code>RuleId</code> </p> </li>   <li> <p> <code>Action</code>: Contains <code>Type</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetWebACLError>`](crate::error::GetWebACLError)
    pub fn get_web_acl(&self) -> fluent_builders::GetWebACL {
        fluent_builders::GetWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetXssMatchSet`](crate::client::fluent_builders::GetXssMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`xss_match_set_id(impl Into<String>)`](crate::client::fluent_builders::GetXssMatchSet::xss_match_set_id) / [`set_xss_match_set_id(Option<String>)`](crate::client::fluent_builders::GetXssMatchSet::set_xss_match_set_id): <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to get. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    /// - On success, responds with [`GetXssMatchSetOutput`](crate::output::GetXssMatchSetOutput) with field(s):
    ///   - [`xss_match_set(Option<XssMatchSet>)`](crate::output::GetXssMatchSetOutput::xss_match_set): <p>Information about the <code>XssMatchSet</code> that you specified in the <code>GetXssMatchSet</code> request. For more information, see the following topics:</p>  <ul>   <li> <p> <code>XssMatchSet</code>: Contains <code>Name</code>, <code>XssMatchSetId</code>, and an array of <code>XssMatchTuple</code> objects</p> </li>   <li> <p> <code>XssMatchTuple</code>: Each <code>XssMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetXssMatchSetError>`](crate::error::GetXssMatchSetError)
    pub fn get_xss_match_set(&self) -> fluent_builders::GetXssMatchSet {
        fluent_builders::GetXssMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListActivatedRulesInRuleGroup`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_id(impl Into<String>)`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup::rule_group_id) / [`set_rule_group_id(Option<String>)`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup::set_rule_group_id): <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want to get a list of <code>ActivatedRule</code> objects.</p>
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ActivatedRules</code>. For the second and subsequent <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ActivatedRules</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup::set_limit): <p>Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>.</p>
    /// - On success, responds with [`ListActivatedRulesInRuleGroupOutput`](crate::output::ListActivatedRulesInRuleGroupOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListActivatedRulesInRuleGroupOutput::next_marker): <p>If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`activated_rules(Option<Vec<ActivatedRule>>)`](crate::output::ListActivatedRulesInRuleGroupOutput::activated_rules): <p>An array of <code>ActivatedRules</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListActivatedRulesInRuleGroupError>`](crate::error::ListActivatedRulesInRuleGroupError)
    pub fn list_activated_rules_in_rule_group(
        &self,
    ) -> fluent_builders::ListActivatedRulesInRuleGroup {
        fluent_builders::ListActivatedRulesInRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListByteMatchSets`](crate::client::fluent_builders::ListByteMatchSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListByteMatchSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListByteMatchSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>. For the second and subsequent <code>ListByteMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ByteMatchSets</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListByteMatchSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListByteMatchSets::set_limit): <p>Specifies the number of <code>ByteMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>ByteMatchSets</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>ByteMatchSet</code> objects.</p>
    /// - On success, responds with [`ListByteMatchSetsOutput`](crate::output::ListByteMatchSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListByteMatchSetsOutput::next_marker): <p>If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`byte_match_sets(Option<Vec<ByteMatchSetSummary>>)`](crate::output::ListByteMatchSetsOutput::byte_match_sets): <p>An array of <code>ByteMatchSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListByteMatchSetsError>`](crate::error::ListByteMatchSetsError)
    pub fn list_byte_match_sets(&self) -> fluent_builders::ListByteMatchSets {
        fluent_builders::ListByteMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGeoMatchSets`](crate::client::fluent_builders::ListGeoMatchSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListGeoMatchSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListGeoMatchSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>GeoMatchSet</code>s than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>GeoMatchSet</code> objects. For the second and subsequent <code>ListGeoMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>GeoMatchSet</code> objects.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListGeoMatchSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListGeoMatchSets::set_limit): <p>Specifies the number of <code>GeoMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>GeoMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>GeoMatchSet</code> objects.</p>
    /// - On success, responds with [`ListGeoMatchSetsOutput`](crate::output::ListGeoMatchSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListGeoMatchSetsOutput::next_marker): <p>If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`geo_match_sets(Option<Vec<GeoMatchSetSummary>>)`](crate::output::ListGeoMatchSetsOutput::geo_match_sets): <p>An array of <code>GeoMatchSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListGeoMatchSetsError>`](crate::error::ListGeoMatchSetsError)
    pub fn list_geo_match_sets(&self) -> fluent_builders::ListGeoMatchSets {
        fluent_builders::ListGeoMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIPSets`](crate::client::fluent_builders::ListIPSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListIPSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListIPSets::set_next_marker): <p>AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>IPSets</code>. For the second and subsequent <code>ListIPSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>IPSets</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListIPSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListIPSets::set_limit): <p>Specifies the number of <code>IPSet</code> objects that you want AWS WAF to return for this request. If you have more <code>IPSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>IPSet</code> objects.</p>
    /// - On success, responds with [`ListIpSetsOutput`](crate::output::ListIpSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListIpSetsOutput::next_marker): <p>To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.</p>
    ///   - [`ip_sets(Option<Vec<IpSetSummary>>)`](crate::output::ListIpSetsOutput::ip_sets): <p>An array of <code>IPSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListIPSetsError>`](crate::error::ListIPSetsError)
    pub fn list_ip_sets(&self) -> fluent_builders::ListIPSets {
        fluent_builders::ListIPSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLoggingConfigurations`](crate::client::fluent_builders::ListLoggingConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListLoggingConfigurations::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListLoggingConfigurations::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>LoggingConfigurations</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>LoggingConfigurations</code>. For the second and subsequent <code>ListLoggingConfigurations</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ListLoggingConfigurations</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListLoggingConfigurations::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListLoggingConfigurations::set_limit): <p>Specifies the number of <code>LoggingConfigurations</code> that you want AWS WAF to return for this request. If you have more <code>LoggingConfigurations</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>LoggingConfigurations</code>.</p>
    /// - On success, responds with [`ListLoggingConfigurationsOutput`](crate::output::ListLoggingConfigurationsOutput) with field(s):
    ///   - [`logging_configurations(Option<Vec<LoggingConfiguration>>)`](crate::output::ListLoggingConfigurationsOutput::logging_configurations): <p>An array of <code>LoggingConfiguration</code> objects.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListLoggingConfigurationsOutput::next_marker): <p>If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    /// - On failure, responds with [`SdkError<ListLoggingConfigurationsError>`](crate::error::ListLoggingConfigurationsError)
    pub fn list_logging_configurations(&self) -> fluent_builders::ListLoggingConfigurations {
        fluent_builders::ListLoggingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRateBasedRules`](crate::client::fluent_builders::ListRateBasedRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRateBasedRules::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRateBasedRules::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>. For the second and subsequent <code>ListRateBasedRules</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>Rules</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRateBasedRules::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListRateBasedRules::set_limit): <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
    /// - On success, responds with [`ListRateBasedRulesOutput`](crate::output::ListRateBasedRulesOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRateBasedRulesOutput::next_marker): <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRateBasedRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`rules(Option<Vec<RuleSummary>>)`](crate::output::ListRateBasedRulesOutput::rules): <p>An array of <code>RuleSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListRateBasedRulesError>`](crate::error::ListRateBasedRulesError)
    pub fn list_rate_based_rules(&self) -> fluent_builders::ListRateBasedRules {
        fluent_builders::ListRateBasedRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRegexMatchSets`](crate::client::fluent_builders::ListRegexMatchSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRegexMatchSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRegexMatchSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>RegexMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>. For the second and subsequent <code>ListRegexMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RegexMatchSet</code> objects.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRegexMatchSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListRegexMatchSets::set_limit): <p>Specifies the number of <code>RegexMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>RegexMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RegexMatchSet</code> objects.</p>
    /// - On success, responds with [`ListRegexMatchSetsOutput`](crate::output::ListRegexMatchSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRegexMatchSetsOutput::next_marker): <p>If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`regex_match_sets(Option<Vec<RegexMatchSetSummary>>)`](crate::output::ListRegexMatchSetsOutput::regex_match_sets): <p>An array of <code>RegexMatchSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListRegexMatchSetsError>`](crate::error::ListRegexMatchSetsError)
    pub fn list_regex_match_sets(&self) -> fluent_builders::ListRegexMatchSets {
        fluent_builders::ListRegexMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRegexPatternSets`](crate::client::fluent_builders::ListRegexPatternSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRegexPatternSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRegexPatternSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>RegexPatternSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RegexPatternSet</code> objects. For the second and subsequent <code>ListRegexPatternSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RegexPatternSet</code> objects.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRegexPatternSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListRegexPatternSets::set_limit): <p>Specifies the number of <code>RegexPatternSet</code> objects that you want AWS WAF to return for this request. If you have more <code>RegexPatternSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RegexPatternSet</code> objects.</p>
    /// - On success, responds with [`ListRegexPatternSetsOutput`](crate::output::ListRegexPatternSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRegexPatternSetsOutput::next_marker): <p>If you have more <code>RegexPatternSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`regex_pattern_sets(Option<Vec<RegexPatternSetSummary>>)`](crate::output::ListRegexPatternSetsOutput::regex_pattern_sets): <p>An array of <code>RegexPatternSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListRegexPatternSetsError>`](crate::error::ListRegexPatternSetsError)
    pub fn list_regex_pattern_sets(&self) -> fluent_builders::ListRegexPatternSets {
        fluent_builders::ListRegexPatternSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRuleGroups`](crate::client::fluent_builders::ListRuleGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRuleGroups::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRuleGroups::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>RuleGroups</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RuleGroups</code>. For the second and subsequent <code>ListRuleGroups</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RuleGroups</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRuleGroups::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListRuleGroups::set_limit): <p>Specifies the number of <code>RuleGroups</code> that you want AWS WAF to return for this request. If you have more <code>RuleGroups</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RuleGroups</code>.</p>
    /// - On success, responds with [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRuleGroupsOutput::next_marker): <p>If you have more <code>RuleGroups</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RuleGroups</code>, submit another <code>ListRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`rule_groups(Option<Vec<RuleGroupSummary>>)`](crate::output::ListRuleGroupsOutput::rule_groups): <p>An array of <code>RuleGroup</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListRuleGroupsError>`](crate::error::ListRuleGroupsError)
    pub fn list_rule_groups(&self) -> fluent_builders::ListRuleGroups {
        fluent_builders::ListRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRules`](crate::client::fluent_builders::ListRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListRules::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListRules::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>. For the second and subsequent <code>ListRules</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>Rules</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRules::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListRules::set_limit): <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
    /// - On success, responds with [`ListRulesOutput`](crate::output::ListRulesOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListRulesOutput::next_marker): <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`rules(Option<Vec<RuleSummary>>)`](crate::output::ListRulesOutput::rules): <p>An array of <code>RuleSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListRulesError>`](crate::error::ListRulesError)
    pub fn list_rules(&self) -> fluent_builders::ListRules {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSizeConstraintSets`](crate::client::fluent_builders::ListSizeConstraintSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListSizeConstraintSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListSizeConstraintSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>SizeConstraintSets</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SizeConstraintSets</code>. For the second and subsequent <code>ListSizeConstraintSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SizeConstraintSets</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListSizeConstraintSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListSizeConstraintSets::set_limit): <p>Specifies the number of <code>SizeConstraintSet</code> objects that you want AWS WAF to return for this request. If you have more <code>SizeConstraintSets</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>SizeConstraintSet</code> objects.</p>
    /// - On success, responds with [`ListSizeConstraintSetsOutput`](crate::output::ListSizeConstraintSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListSizeConstraintSetsOutput::next_marker): <p>If you have more <code>SizeConstraintSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SizeConstraintSet</code> objects, submit another <code>ListSizeConstraintSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`size_constraint_sets(Option<Vec<SizeConstraintSetSummary>>)`](crate::output::ListSizeConstraintSetsOutput::size_constraint_sets): <p>An array of <code>SizeConstraintSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListSizeConstraintSetsError>`](crate::error::ListSizeConstraintSetsError)
    pub fn list_size_constraint_sets(&self) -> fluent_builders::ListSizeConstraintSets {
        fluent_builders::ListSizeConstraintSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSqlInjectionMatchSets`](crate::client::fluent_builders::ListSqlInjectionMatchSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListSqlInjectionMatchSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListSqlInjectionMatchSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>SqlInjectionMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SqlInjectionMatchSets</code>. For the second and subsequent <code>ListSqlInjectionMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SqlInjectionMatchSets</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListSqlInjectionMatchSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListSqlInjectionMatchSets::set_limit): <p>Specifies the number of <code>SqlInjectionMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>SqlInjectionMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
    /// - On success, responds with [`ListSqlInjectionMatchSetsOutput`](crate::output::ListSqlInjectionMatchSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListSqlInjectionMatchSetsOutput::next_marker): <p>If you have more <code>SqlInjectionMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SqlInjectionMatchSet</code> objects, submit another <code>ListSqlInjectionMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`sql_injection_match_sets(Option<Vec<SqlInjectionMatchSetSummary>>)`](crate::output::ListSqlInjectionMatchSetsOutput::sql_injection_match_sets): <p>An array of <code>SqlInjectionMatchSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListSqlInjectionMatchSetsError>`](crate::error::ListSqlInjectionMatchSetsError)
    pub fn list_sql_injection_match_sets(&self) -> fluent_builders::ListSqlInjectionMatchSets {
        fluent_builders::ListSqlInjectionMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSubscribedRuleGroups`](crate::client::fluent_builders::ListSubscribedRuleGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListSubscribedRuleGroups::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListSubscribedRuleGroups::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code>subscribed rule groups than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of subscribed rule groups. For the second and subsequent <code>ListSubscribedRuleGroupsRequest</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of subscribed rule groups.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListSubscribedRuleGroups::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListSubscribedRuleGroups::set_limit): <p>Specifies the number of subscribed rule groups that you want AWS WAF to return for this request. If you have more objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of objects.</p>
    /// - On success, responds with [`ListSubscribedRuleGroupsOutput`](crate::output::ListSubscribedRuleGroupsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListSubscribedRuleGroupsOutput::next_marker): <p>If you have more objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more objects, submit another <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`rule_groups(Option<Vec<SubscribedRuleGroupSummary>>)`](crate::output::ListSubscribedRuleGroupsOutput::rule_groups): <p>An array of <code>RuleGroup</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListSubscribedRuleGroupsError>`](crate::error::ListSubscribedRuleGroupsError)
    pub fn list_subscribed_rule_groups(&self) -> fluent_builders::ListSubscribedRuleGroups {
        fluent_builders::ListSubscribedRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_marker): <p></p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTagsForResource::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListTagsForResource::set_limit): <p></p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p></p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListTagsForResourceOutput::next_marker): <p></p>
    ///   - [`tag_info_for_resource(Option<TagInfoForResource>)`](crate::output::ListTagsForResourceOutput::tag_info_for_resource): <p></p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWebACLs`](crate::client::fluent_builders::ListWebACLs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListWebACLs::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListWebACLs::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>WebACL</code> objects. For the second and subsequent <code>ListWebACLs</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>WebACL</code> objects.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListWebACLs::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListWebACLs::set_limit): <p>Specifies the number of <code>WebACL</code> objects that you want AWS WAF to return for this request. If you have more <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>WebACL</code> objects.</p>
    /// - On success, responds with [`ListWebAcLsOutput`](crate::output::ListWebAcLsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListWebAcLsOutput::next_marker): <p>If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`web_ac_ls(Option<Vec<WebAclSummary>>)`](crate::output::ListWebAcLsOutput::web_ac_ls): <p>An array of <code>WebACLSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListWebACLsError>`](crate::error::ListWebACLsError)
    pub fn list_web_ac_ls(&self) -> fluent_builders::ListWebACLs {
        fluent_builders::ListWebACLs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListXssMatchSets`](crate::client::fluent_builders::ListXssMatchSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_marker(impl Into<String>)`](crate::client::fluent_builders::ListXssMatchSets::next_marker) / [`set_next_marker(Option<String>)`](crate::client::fluent_builders::ListXssMatchSets::set_next_marker): <p>If you specify a value for <code>Limit</code> and you have more <code>XssMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>XssMatchSets</code>. For the second and subsequent <code>ListXssMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>XssMatchSets</code>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListXssMatchSets::limit) / [`set_limit(i32)`](crate::client::fluent_builders::ListXssMatchSets::set_limit): <p>Specifies the number of <code>XssMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>XssMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
    /// - On success, responds with [`ListXssMatchSetsOutput`](crate::output::ListXssMatchSetsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListXssMatchSetsOutput::next_marker): <p>If you have more <code>XssMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>XssMatchSet</code> objects, submit another <code>ListXssMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    ///   - [`xss_match_sets(Option<Vec<XssMatchSetSummary>>)`](crate::output::ListXssMatchSetsOutput::xss_match_sets): <p>An array of <code>XssMatchSetSummary</code> objects.</p>
    /// - On failure, responds with [`SdkError<ListXssMatchSetsError>`](crate::error::ListXssMatchSetsError)
    pub fn list_xss_match_sets(&self) -> fluent_builders::ListXssMatchSets {
        fluent_builders::ListXssMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLoggingConfiguration`](crate::client::fluent_builders::PutLoggingConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`logging_configuration(LoggingConfiguration)`](crate::client::fluent_builders::PutLoggingConfiguration::logging_configuration) / [`set_logging_configuration(Option<LoggingConfiguration>)`](crate::client::fluent_builders::PutLoggingConfiguration::set_logging_configuration): <p>The Amazon Kinesis Data Firehose that contains the inspected traffic information, the redacted fields details, and the Amazon Resource Name (ARN) of the web ACL to monitor.</p> <note>   <p>When specifying <code>Type</code> in <code>RedactedFields</code>, you must use one of the following values: <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p>  </note>
    /// - On success, responds with [`PutLoggingConfigurationOutput`](crate::output::PutLoggingConfigurationOutput) with field(s):
    ///   - [`logging_configuration(Option<LoggingConfiguration>)`](crate::output::PutLoggingConfigurationOutput::logging_configuration): <p>The <code>LoggingConfiguration</code> that you submitted in the request.</p>
    /// - On failure, responds with [`SdkError<PutLoggingConfigurationError>`](crate::error::PutLoggingConfigurationError)
    pub fn put_logging_configuration(&self) -> fluent_builders::PutLoggingConfiguration {
        fluent_builders::PutLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPermissionPolicy`](crate::client::fluent_builders::PutPermissionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutPermissionPolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutPermissionPolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach the policy.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutPermissionPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutPermissionPolicy::set_policy): <p>The policy to attach to the specified RuleGroup.</p>
    /// - On success, responds with [`PutPermissionPolicyOutput`](crate::output::PutPermissionPolicyOutput)

    /// - On failure, responds with [`SdkError<PutPermissionPolicyError>`](crate::error::PutPermissionPolicyError)
    pub fn put_permission_policy(&self) -> fluent_builders::PutPermissionPolicy {
        fluent_builders::PutPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p></p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p></p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p></p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p></p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateByteMatchSet`](crate::client::fluent_builders::UpdateByteMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`byte_match_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateByteMatchSet::byte_match_set_id) / [`set_byte_match_set_id(Option<String>)`](crate::client::fluent_builders::UpdateByteMatchSet::set_byte_match_set_id): <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to update. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateByteMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateByteMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<ByteMatchSetUpdate>)`](crate::client::fluent_builders::UpdateByteMatchSet::updates) / [`set_updates(Option<Vec<ByteMatchSetUpdate>>)`](crate::client::fluent_builders::UpdateByteMatchSet::set_updates): <p>An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a <code>ByteMatchSet</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>ByteMatchSetUpdate</code>: Contains <code>Action</code> and <code>ByteMatchTuple</code> </p> </li>   <li> <p> <code>ByteMatchTuple</code>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateByteMatchSetOutput`](crate::output::UpdateByteMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateByteMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateByteMatchSetError>`](crate::error::UpdateByteMatchSetError)
    pub fn update_byte_match_set(&self) -> fluent_builders::UpdateByteMatchSet {
        fluent_builders::UpdateByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGeoMatchSet`](crate::client::fluent_builders::UpdateGeoMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`geo_match_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGeoMatchSet::geo_match_set_id) / [`set_geo_match_set_id(Option<String>)`](crate::client::fluent_builders::UpdateGeoMatchSet::set_geo_match_set_id): <p>The <code>GeoMatchSetId</code> of the <code>GeoMatchSet</code> that you want to update. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateGeoMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateGeoMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<GeoMatchSetUpdate>)`](crate::client::fluent_builders::UpdateGeoMatchSet::updates) / [`set_updates(Option<Vec<GeoMatchSetUpdate>>)`](crate::client::fluent_builders::UpdateGeoMatchSet::set_updates): <p>An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an <code>GeoMatchSet</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>GeoMatchSetUpdate</code>: Contains <code>Action</code> and <code>GeoMatchConstraint</code> </p> </li>   <li> <p> <code>GeoMatchConstraint</code>: Contains <code>Type</code> and <code>Value</code> </p> <p>You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.</p> </li>  </ul>
    /// - On success, responds with [`UpdateGeoMatchSetOutput`](crate::output::UpdateGeoMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateGeoMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateGeoMatchSetError>`](crate::error::UpdateGeoMatchSetError)
    pub fn update_geo_match_set(&self) -> fluent_builders::UpdateGeoMatchSet {
        fluent_builders::UpdateGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIPSet`](crate::client::fluent_builders::UpdateIPSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ip_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIPSet::ip_set_id) / [`set_ip_set_id(Option<String>)`](crate::client::fluent_builders::UpdateIPSet::set_ip_set_id): <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to update. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateIPSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateIPSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<IpSetUpdate>)`](crate::client::fluent_builders::UpdateIPSet::updates) / [`set_updates(Option<Vec<IpSetUpdate>>)`](crate::client::fluent_builders::UpdateIPSet::set_updates): <p>An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <code>IPSet</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>IPSetUpdate</code>: Contains <code>Action</code> and <code>IPSetDescriptor</code> </p> </li>   <li> <p> <code>IPSetDescriptor</code>: Contains <code>Type</code> and <code>Value</code> </p> </li>  </ul>  <p>You can insert a maximum of 1000 addresses in a single request.</p>
    /// - On success, responds with [`UpdateIpSetOutput`](crate::output::UpdateIpSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateIpSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateIPSetError>`](crate::error::UpdateIPSetError)
    pub fn update_ip_set(&self) -> fluent_builders::UpdateIPSet {
        fluent_builders::UpdateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRateBasedRule`](crate::client::fluent_builders::UpdateRateBasedRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRateBasedRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::UpdateRateBasedRule::set_rule_id): <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRateBasedRule::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateRateBasedRule::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<RuleUpdate>)`](crate::client::fluent_builders::UpdateRateBasedRule::updates) / [`set_updates(Option<Vec<RuleUpdate>>)`](crate::client::fluent_builders::UpdateRateBasedRule::set_updates): <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <code>RateBasedRule</code>. </p>
    ///   - [`rate_limit(i64)`](crate::client::fluent_builders::UpdateRateBasedRule::rate_limit) / [`set_rate_limit(i64)`](crate::client::fluent_builders::UpdateRateBasedRule::set_rate_limit): <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
    /// - On success, responds with [`UpdateRateBasedRuleOutput`](crate::output::UpdateRateBasedRuleOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateRateBasedRuleOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateRateBasedRuleError>`](crate::error::UpdateRateBasedRuleError)
    pub fn update_rate_based_rule(&self) -> fluent_builders::UpdateRateBasedRule {
        fluent_builders::UpdateRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRegexMatchSet`](crate::client::fluent_builders::UpdateRegexMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`regex_match_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexMatchSet::regex_match_set_id) / [`set_regex_match_set_id(Option<String>)`](crate::client::fluent_builders::UpdateRegexMatchSet::set_regex_match_set_id): <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to update. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
    ///   - [`updates(Vec<RegexMatchSetUpdate>)`](crate::client::fluent_builders::UpdateRegexMatchSet::updates) / [`set_updates(Option<Vec<RegexMatchSetUpdate>>)`](crate::client::fluent_builders::UpdateRegexMatchSet::set_updates): <p>An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a <code>RegexMatchSet</code>. For more information, see <code>RegexMatchTuple</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateRegexMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`UpdateRegexMatchSetOutput`](crate::output::UpdateRegexMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateRegexMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateRegexMatchSetError>`](crate::error::UpdateRegexMatchSetError)
    pub fn update_regex_match_set(&self) -> fluent_builders::UpdateRegexMatchSet {
        fluent_builders::UpdateRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRegexPatternSet`](crate::client::fluent_builders::UpdateRegexPatternSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`regex_pattern_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::regex_pattern_set_id) / [`set_regex_pattern_set_id(Option<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_regex_pattern_set_id): <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to update. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
    ///   - [`updates(Vec<RegexPatternSetUpdate>)`](crate::client::fluent_builders::UpdateRegexPatternSet::updates) / [`set_updates(Option<Vec<RegexPatternSetUpdate>>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_updates): <p>An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a <code>RegexPatternSet</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateRegexPatternSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`UpdateRegexPatternSetOutput`](crate::output::UpdateRegexPatternSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateRegexPatternSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateRegexPatternSetError>`](crate::error::UpdateRegexPatternSetError)
    pub fn update_regex_pattern_set(&self) -> fluent_builders::UpdateRegexPatternSet {
        fluent_builders::UpdateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRule`](crate::client::fluent_builders::UpdateRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRule::rule_id) / [`set_rule_id(Option<String>)`](crate::client::fluent_builders::UpdateRule::set_rule_id): <p>The <code>RuleId</code> of the <code>Rule</code> that you want to update. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRule::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateRule::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<RuleUpdate>)`](crate::client::fluent_builders::UpdateRule::updates) / [`set_updates(Option<Vec<RuleUpdate>>)`](crate::client::fluent_builders::UpdateRule::set_updates): <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <code>Rule</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>RuleUpdate</code>: Contains <code>Action</code> and <code>Predicate</code> </p> </li>   <li> <p> <code>Predicate</code>: Contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateRuleOutput`](crate::output::UpdateRuleOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateRuleOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateRuleError>`](crate::error::UpdateRuleError)
    pub fn update_rule(&self) -> fluent_builders::UpdateRule {
        fluent_builders::UpdateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRuleGroup`](crate::client::fluent_builders::UpdateRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rule_group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::rule_group_id) / [`set_rule_group_id(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_rule_group_id): <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to update. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
    ///   - [`updates(Vec<RuleGroupUpdate>)`](crate::client::fluent_builders::UpdateRuleGroup::updates) / [`set_updates(Option<Vec<RuleGroupUpdate>>)`](crate::client::fluent_builders::UpdateRuleGroup::set_updates): <p>An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a <code>RuleGroup</code>.</p>  <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>  <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRuleGroup::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateRuleGroup::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    /// - On success, responds with [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateRuleGroupOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateRuleGroupError>`](crate::error::UpdateRuleGroupError)
    pub fn update_rule_group(&self) -> fluent_builders::UpdateRuleGroup {
        fluent_builders::UpdateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSizeConstraintSet`](crate::client::fluent_builders::UpdateSizeConstraintSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`size_constraint_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSizeConstraintSet::size_constraint_set_id) / [`set_size_constraint_set_id(Option<String>)`](crate::client::fluent_builders::UpdateSizeConstraintSet::set_size_constraint_set_id): <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to update. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateSizeConstraintSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateSizeConstraintSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<SizeConstraintSetUpdate>)`](crate::client::fluent_builders::UpdateSizeConstraintSet::updates) / [`set_updates(Option<Vec<SizeConstraintSetUpdate>>)`](crate::client::fluent_builders::UpdateSizeConstraintSet::set_updates): <p>An array of <code>SizeConstraintSetUpdate</code> objects that you want to insert into or delete from a <code>SizeConstraintSet</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>SizeConstraintSetUpdate</code>: Contains <code>Action</code> and <code>SizeConstraint</code> </p> </li>   <li> <p> <code>SizeConstraint</code>: Contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateSizeConstraintSetOutput`](crate::output::UpdateSizeConstraintSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateSizeConstraintSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateSizeConstraintSetError>`](crate::error::UpdateSizeConstraintSetError)
    pub fn update_size_constraint_set(&self) -> fluent_builders::UpdateSizeConstraintSet {
        fluent_builders::UpdateSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSqlInjectionMatchSet`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sql_injection_match_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet::sql_injection_match_set_id) / [`set_sql_injection_match_set_id(Option<String>)`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet::set_sql_injection_match_set_id): <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<SqlInjectionMatchSetUpdate>)`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet::updates) / [`set_updates(Option<Vec<SqlInjectionMatchSetUpdate>>)`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet::set_updates): <p>An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a <code>SqlInjectionMatchSet</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>SqlInjectionMatchSetUpdate</code>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code> </p> </li>   <li> <p> <code>SqlInjectionMatchTuple</code>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateSqlInjectionMatchSetOutput`](crate::output::UpdateSqlInjectionMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateSqlInjectionMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateSqlInjectionMatchSetError>`](crate::error::UpdateSqlInjectionMatchSetError)
    pub fn update_sql_injection_match_set(&self) -> fluent_builders::UpdateSqlInjectionMatchSet {
        fluent_builders::UpdateSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWebACL`](crate::client::fluent_builders::UpdateWebACL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`web_acl_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWebACL::web_acl_id) / [`set_web_acl_id(Option<String>)`](crate::client::fluent_builders::UpdateWebACL::set_web_acl_id): <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to update. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateWebACL::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateWebACL::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<WebAclUpdate>)`](crate::client::fluent_builders::UpdateWebACL::updates) / [`set_updates(Option<Vec<WebAclUpdate>>)`](crate::client::fluent_builders::UpdateWebACL::set_updates): <p>An array of updates to make to the <code>WebACL</code>.</p>  <p>An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <code>WebACL</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>WebACLUpdate</code>: Contains <code>Action</code> and <code>ActivatedRule</code> </p> </li>   <li> <p> <code>ActivatedRule</code>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>. </p> </li>   <li> <p> <code>WafAction</code>: Contains <code>Type</code> </p> </li>  </ul>
    ///   - [`default_action(WafAction)`](crate::client::fluent_builders::UpdateWebACL::default_action) / [`set_default_action(Option<WafAction>)`](crate::client::fluent_builders::UpdateWebACL::set_default_action): <p>A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request doesn't match the criteria in any of the rules in a web ACL.</p>
    /// - On success, responds with [`UpdateWebAclOutput`](crate::output::UpdateWebAclOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateWebAclOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateWebACLError>`](crate::error::UpdateWebACLError)
    pub fn update_web_acl(&self) -> fluent_builders::UpdateWebACL {
        fluent_builders::UpdateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateXssMatchSet`](crate::client::fluent_builders::UpdateXssMatchSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`xss_match_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateXssMatchSet::xss_match_set_id) / [`set_xss_match_set_id(Option<String>)`](crate::client::fluent_builders::UpdateXssMatchSet::set_xss_match_set_id): <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to update. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
    ///   - [`change_token(impl Into<String>)`](crate::client::fluent_builders::UpdateXssMatchSet::change_token) / [`set_change_token(Option<String>)`](crate::client::fluent_builders::UpdateXssMatchSet::set_change_token): <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
    ///   - [`updates(Vec<XssMatchSetUpdate>)`](crate::client::fluent_builders::UpdateXssMatchSet::updates) / [`set_updates(Option<Vec<XssMatchSetUpdate>>)`](crate::client::fluent_builders::UpdateXssMatchSet::set_updates): <p>An array of <code>XssMatchSetUpdate</code> objects that you want to insert into or delete from an <code>XssMatchSet</code>. For more information, see the applicable data types:</p>  <ul>   <li> <p> <code>XssMatchSetUpdate</code>: Contains <code>Action</code> and <code>XssMatchTuple</code> </p> </li>   <li> <p> <code>XssMatchTuple</code>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>   <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>  </ul>
    /// - On success, responds with [`UpdateXssMatchSetOutput`](crate::output::UpdateXssMatchSetOutput) with field(s):
    ///   - [`change_token(Option<String>)`](crate::output::UpdateXssMatchSetOutput::change_token): <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateXssMatchSetError>`](crate::error::UpdateXssMatchSetError)
    pub fn update_xss_match_set(&self) -> fluent_builders::UpdateXssMatchSet {
        fluent_builders::UpdateXssMatchSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>ByteMatchSet</code>. You then use <code>UpdateByteMatchSet</code> to identify the part of a web request that you want AWS WAF to inspect, such as the values of the <code>User-Agent</code> header or the query string. For example, you can create a <code>ByteMatchSet</code> that matches any requests with <code>User-Agent</code> headers that contain the string <code>BadBot</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>ByteMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateByteMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateByteMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateByteMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateByteMatchSet</code> request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateByteMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_byte_match_set_input::Builder,
    }
    impl CreateByteMatchSet {
        /// Creates a new `CreateByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateByteMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>ByteMatchSet</code>. You can't change <code>Name</code> after you create a <code>ByteMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates an <code>GeoMatchSet</code>, which you use to specify which web requests you want to allow or block based on the country that the requests originate from. For example, if you're receiving a lot of requests from one or more countries and you want to block the requests, you can create an <code>GeoMatchSet</code> that contains those countries and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure a <code>GeoMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateGeoMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateGeoMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateGeoMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateGeoMatchSetSet</code> request to specify the countries that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGeoMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_geo_match_set_input::Builder,
    }
    impl CreateGeoMatchSet {
        /// Creates a new `CreateGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGeoMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change <code>Name</code> after you create the <code>GeoMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>GeoMatchSet</code>. You can't change <code>Name</code> after you create the <code>GeoMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates an <code>IPSet</code>, which you use to specify which web requests that you want to allow or block based on the IP addresses that the requests originate from. For example, if you're receiving a lot of requests from one or more individual IP addresses or one or more ranges of IP addresses and you want to block the requests, you can create an <code>IPSet</code> that contains those IP addresses and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure an <code>IPSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateIPSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateIPSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateIPSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateIPSet</code> request to specify the IP addresses that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ip_set_input::Builder,
    }
    impl CreateIPSet {
        /// Creates a new `CreateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>IPSet</code>. You can't change <code>Name</code> after you create the <code>IPSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>IPSet</code>. You can't change <code>Name</code> after you create the <code>IPSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>RateBasedRule</code>. The <code>RateBasedRule</code> contains a <code>RateLimit</code>, which specifies the maximum number of requests that AWS WAF allows from a specified IP address in a five-minute period. The <code>RateBasedRule</code> also contains the <code>IPSet</code> objects, <code>ByteMatchSet</code> objects, and other predicates that identify the requests that you want to count or block if these requests exceed the <code>RateLimit</code>.</p>
    /// <p>If you add more than one predicate to a <code>RateBasedRule</code>, a request not only must exceed the <code>RateLimit</code>, but it also must match all the conditions to be counted or blocked. For example, suppose you add the following to a <code>RateBasedRule</code>:</p>
    /// <ul>
    /// <li> <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44/32</code> </p> </li>
    /// <li> <p>A <code>ByteMatchSet</code> that matches <code>BadBot</code> in the <code>User-Agent</code> header</p> </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>You then add the <code>RateBasedRule</code> to a <code>WebACL</code> and specify that you want to block requests that meet the conditions in the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 <i>and</i> the <code>User-Agent</code> header in the request must contain the value <code>BadBot</code>. Further, requests that match these two conditions must be received at a rate of more than 1,000 requests every five minutes. If both conditions are met and the rate is exceeded, AWS WAF blocks the requests. If the rate drops below 1,000 for a five-minute period, AWS WAF no longer blocks the requests.</p>
    /// <p>As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a <code>RateBasedRule</code>:</p>
    /// <ul>
    /// <li> <p>A <code>ByteMatchSet</code> with <code>FieldToMatch</code> of <code>URI</code> </p> </li>
    /// <li> <p>A <code>PositionalConstraint</code> of <code>STARTS_WITH</code> </p> </li>
    /// <li> <p>A <code>TargetString</code> of <code>login</code> </p> </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>By adding this <code>RateBasedRule</code> to a <code>WebACL</code>, you could limit requests to your login page without affecting the rest of your site.</p>
    /// <p>To create and configure a <code>RateBasedRule</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create and update the predicates that you want to include in the rule. For more information, see <code>CreateByteMatchSet</code>, <code>CreateIPSet</code>, and <code>CreateSqlInjectionMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateRule</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateRateBasedRule</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRule</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRateBasedRule</code> request to specify the predicates that you want to include in the rule.</p> </li>
    /// <li> <p>Create and update a <code>WebACL</code> that contains the <code>RateBasedRule</code>. For more information, see <code>CreateWebACL</code>.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRateBasedRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rate_based_rule_input::Builder,
    }
    impl CreateRateBasedRule {
        /// Creates a new `CreateRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRateBasedRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RateBasedRule</code>. You can't change the name of a <code>RateBasedRule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RateBasedRule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests that arrive from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
        pub fn rate_key(mut self, input: crate::model::RateKey) -> Self {
            self.inner = self.inner.rate_key(input);
            self
        }
        /// <p>The field that AWS WAF uses to determine if requests are likely arriving from a single source and thus subject to rate monitoring. The only valid value for <code>RateKey</code> is <code>IP</code>. <code>IP</code> indicates that requests that arrive from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code>.</p>
        pub fn set_rate_key(mut self, input: std::option::Option<crate::model::RateKey>) -> Self {
            self.inner = self.inner.set_rate_key(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field that is specified by <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn rate_limit(mut self, input: i64) -> Self {
            self.inner = self.inner.rate_limit(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field that is specified by <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_rate_limit(input);
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>RegexMatchSet</code>. You then use <code>UpdateRegexMatchSet</code> to identify the part of a web request that you want AWS WAF to inspect, such as the values of the <code>User-Agent</code> header or the query string. For example, you can create a <code>RegexMatchSet</code> that contains a <code>RegexMatchTuple</code> that looks for any requests with <code>User-Agent</code> headers that match a <code>RegexPatternSet</code> with pattern <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>RegexMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateRegexMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateRegexMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRegexMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRegexMatchSet</code> request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value, using a <code>RegexPatternSet</code>, that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRegexMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_regex_match_set_input::Builder,
    }
    impl CreateRegexMatchSet {
        /// Creates a new `CreateRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegexMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RegexMatchSet</code>. You can't change <code>Name</code> after you create a <code>RegexMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>RegexPatternSet</code>. You then use <code>UpdateRegexPatternSet</code> to specify the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>RegexPatternSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateRegexPatternSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateRegexPatternSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRegexPatternSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRegexPatternSet</code> request to specify the string that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_regex_pattern_set_input::Builder,
    }
    impl CreateRegexPatternSet {
        /// Creates a new `CreateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RegexPatternSet</code>. You can't change <code>Name</code> after you create a <code>RegexPatternSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>Rule</code>, which contains the <code>IPSet</code> objects, <code>ByteMatchSet</code> objects, and other predicates that identify the requests that you want to block. If you add more than one predicate to a <code>Rule</code>, a request must match all of the specifications to be allowed or blocked. For example, suppose that you add the following to a <code>Rule</code>:</p>
    /// <ul>
    /// <li> <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44/32</code> </p> </li>
    /// <li> <p>A <code>ByteMatchSet</code> that matches <code>BadBot</code> in the <code>User-Agent</code> header</p> </li>
    /// </ul>
    /// <p>You then add the <code>Rule</code> to a <code>WebACL</code> and specify that you want to blocks requests that satisfy the <code>Rule</code>. For a request to be blocked, it must come from the IP address 192.0.2.44 <i>and</i> the <code>User-Agent</code> header in the request must contain the value <code>BadBot</code>.</p>
    /// <p>To create and configure a <code>Rule</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create and update the predicates that you want to include in the <code>Rule</code>. For more information, see <code>CreateByteMatchSet</code>, <code>CreateIPSet</code>, and <code>CreateSqlInjectionMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateRule</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateRule</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRule</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRule</code> request to specify the predicates that you want to include in the <code>Rule</code>.</p> </li>
    /// <li> <p>Create and update a <code>WebACL</code> that contains the <code>Rule</code>. For more information, see <code>CreateWebACL</code>.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rule_input::Builder,
    }
    impl CreateRule {
        /// Creates a new `CreateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>Rule</code>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>Rule</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>Rule</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>RuleGroup</code>. A rule group is a collection of predefined rules that you add to a web ACL. You use <code>UpdateRuleGroup</code> to add rules to the rule group.</p>
    /// <p>Rule groups are subject to the following limits:</p>
    /// <ul>
    /// <li> <p>Three rule groups per account. You can request an increase to this limit by contacting customer support.</p> </li>
    /// <li> <p>One rule group per web ACL.</p> </li>
    /// <li> <p>Ten rules per rule group.</p> </li>
    /// </ul>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_rule_group_input::Builder,
    }
    impl CreateRuleGroup {
        /// Creates a new `CreateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change <code>Name</code> after you create a <code>RuleGroup</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>RuleGroup</code>. You can't change <code>Name</code> after you create a <code>RuleGroup</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>SizeConstraintSet</code>. You then use <code>UpdateSizeConstraintSet</code> to identify the part of a web request that you want AWS WAF to check for length, such as the length of the <code>User-Agent</code> header or the length of the query string. For example, you can create a <code>SizeConstraintSet</code> that matches any requests that have a query string that is longer than 100 bytes. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>SizeConstraintSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateSizeConstraintSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateSizeConstraintSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateSizeConstraintSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateSizeConstraintSet</code> request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSizeConstraintSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_size_constraint_set_input::Builder,
    }
    impl CreateSizeConstraintSet {
        /// Creates a new `CreateSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSizeConstraintSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>SizeConstraintSet</code>. You can't change <code>Name</code> after you create a <code>SizeConstraintSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>SizeConstraintSet</code>. You can't change <code>Name</code> after you create a <code>SizeConstraintSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>SqlInjectionMatchSet</code>, which you use to allow, block, or count requests that contain snippets of SQL code in a specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.</p>
    /// <p>To create and configure a <code>SqlInjectionMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateSqlInjectionMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateSqlInjectionMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateSqlInjectionMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateSqlInjectionMatchSet</code> request to specify the parts of web requests in which you want to allow, block, or count malicious SQL code.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSqlInjectionMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_sql_injection_match_set_input::Builder,
    }
    impl CreateSqlInjectionMatchSet {
        /// Creates a new `CreateSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSqlInjectionMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description for the <code>SqlInjectionMatchSet</code> that you're creating. You can't change <code>Name</code> after you create the <code>SqlInjectionMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description for the <code>SqlInjectionMatchSet</code> that you're creating. You can't change <code>Name</code> after you create the <code>SqlInjectionMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>WebACL</code>, which contains the <code>Rules</code> that identify the CloudFront web requests that you want to allow, block, or count. AWS WAF evaluates <code>Rules</code> in order based on the value of <code>Priority</code> for each <code>Rule</code>.</p>
    /// <p>You also specify a default action, either <code>ALLOW</code> or <code>BLOCK</code>. If a web request doesn't match any of the <code>Rules</code> in a <code>WebACL</code>, AWS WAF responds to the request with the default action. </p>
    /// <p>To create and configure a <code>WebACL</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create and update the <code>ByteMatchSet</code> objects and other predicates that you want to include in <code>Rules</code>. For more information, see <code>CreateByteMatchSet</code>, <code>UpdateByteMatchSet</code>, <code>CreateIPSet</code>, <code>UpdateIPSet</code>, <code>CreateSqlInjectionMatchSet</code>, and <code>UpdateSqlInjectionMatchSet</code>.</p> </li>
    /// <li> <p>Create and update the <code>Rules</code> that you want to include in the <code>WebACL</code>. For more information, see <code>CreateRule</code> and <code>UpdateRule</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateWebACL</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateWebACL</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateWebACL</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateWebACL</code> request to specify the <code>Rules</code> that you want to include in the <code>WebACL</code>, to specify the default action, and to associate the <code>WebACL</code> with a CloudFront distribution.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_web_acl_input::Builder,
    }
    impl CreateWebACL {
        /// Creates a new `CreateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <code>WebACL</code>. You can't change <code>Name</code> after you create the <code>WebACL</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description of the <code>WebACL</code>. You can't change <code>Name</code> after you create the <code>WebACL</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>WebACL</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of the <code>Rule</code> objects that are associated with the <code>WebACL</code>.</p>
        pub fn default_action(mut self, input: crate::model::WafAction) -> Self {
            self.inner = self.inner.default_action(input);
            self
        }
        /// <p>The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of the <code>Rule</code> objects that are associated with the <code>WebACL</code>.</p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::WafAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebACLMigrationStack`.
    ///
    /// <p>Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket. Then, in CloudFormation, you create a stack from the template, to create the web ACL and its resources in AWS WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest version of AWS WAF.</p>
    /// <p>This is part of a larger migration procedure for web ACLs from AWS WAF Classic to the latest version of AWS WAF. For the full procedure, including caveats and manual steps to complete the migration and switch over to the new web ACL, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-migrating-from-classic.html">Migrating your AWS WAF Classic resources to AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebACLMigrationStack {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_web_acl_migration_stack_input::Builder,
    }
    impl CreateWebACLMigrationStack {
        /// Creates a new `CreateWebACLMigrationStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebAclMigrationStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebACLMigrationStackError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be configured as follows for the migration: </p>
        /// <ul>
        /// <li> <p>The bucket name must start with <code>aws-waf-migration-</code>. For example, <code>aws-waf-migration-my-web-acl</code>.</p> </li>
        /// <li> <p>The bucket must be in the Region where you are deploying the template. For example, for a web ACL in us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2. </p> </li>
        /// <li> <p>The bucket policies must permit the migration process to write data. For listings of the bucket policies, see the Examples section. </p> </li>
        /// </ul>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be configured as follows for the migration: </p>
        /// <ul>
        /// <li> <p>The bucket name must start with <code>aws-waf-migration-</code>. For example, <code>aws-waf-migration-my-web-acl</code>.</p> </li>
        /// <li> <p>The bucket must be in the Region where you are deploying the template. For example, for a web ACL in us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2. </p> </li>
        /// <li> <p>The bucket policies must permit the migration process to write data. For listings of the bucket policies, see the Examples section. </p> </li>
        /// </ul>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to true to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported entities, it stops the process and throws an exception. </p>
        pub fn ignore_unsupported_type(mut self, input: bool) -> Self {
            self.inner = self.inner.ignore_unsupported_type(input);
            self
        }
        /// <p>Indicates whether to exclude entities that can't be migrated or to stop the migration. Set this to true to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported entities, it stops the process and throws an exception. </p>
        pub fn set_ignore_unsupported_type(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ignore_unsupported_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates an <code>XssMatchSet</code>, which you use to allow, block, or count requests that contain cross-site scripting attacks in the specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.</p>
    /// <p>To create and configure an <code>XssMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>CreateXssMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>CreateXssMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateXssMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateXssMatchSet</code> request to specify the parts of web requests in which you want to allow, block, or count cross-site scripting attacks.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateXssMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_xss_match_set_input::Builder,
    }
    impl CreateXssMatchSet {
        /// Creates a new `CreateXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateXssMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description for the <code>XssMatchSet</code> that you're creating. You can't change <code>Name</code> after you create the <code>XssMatchSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name or description for the <code>XssMatchSet</code> that you're creating. You can't change <code>Name</code> after you create the <code>XssMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>ByteMatchSet</code>. You can't delete a <code>ByteMatchSet</code> if it's still used in any <code>Rules</code> or if it still includes any <code>ByteMatchTuple</code> objects (any filters).</p>
    /// <p>If you just want to remove a <code>ByteMatchSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete a <code>ByteMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>ByteMatchSet</code> to remove filters, if any. For more information, see <code>UpdateByteMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteByteMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteByteMatchSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteByteMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_byte_match_set_input::Builder,
    }
    impl DeleteByteMatchSet {
        /// Creates a new `DeleteByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteByteMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to delete. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn byte_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.byte_match_set_id(input.into());
            self
        }
        /// <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to delete. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_byte_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>GeoMatchSet</code>. You can't delete a <code>GeoMatchSet</code> if it's still used in any <code>Rules</code> or if it still includes any countries.</p>
    /// <p>If you just want to remove a <code>GeoMatchSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete a <code>GeoMatchSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>GeoMatchSet</code> to remove any countries. For more information, see <code>UpdateGeoMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteGeoMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteGeoMatchSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGeoMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_geo_match_set_input::Builder,
    }
    impl DeleteGeoMatchSet {
        /// Creates a new `DeleteGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGeoMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GeoMatchSetID</code> of the <code>GeoMatchSet</code> that you want to delete. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn geo_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geo_match_set_id(input.into());
            self
        }
        /// <p>The <code>GeoMatchSetID</code> of the <code>GeoMatchSet</code> that you want to delete. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes an <code>IPSet</code>. You can't delete an <code>IPSet</code> if it's still used in any <code>Rules</code> or if it still includes any IP addresses.</p>
    /// <p>If you just want to remove an <code>IPSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete an <code>IPSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>IPSet</code> to remove IP address ranges, if any. For more information, see <code>UpdateIPSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteIPSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteIPSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ip_set_input::Builder,
    }
    impl DeleteIPSet {
        /// Creates a new `DeleteIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to delete. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(input.into());
            self
        }
        /// <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to delete. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoggingConfiguration`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes the <code>LoggingConfiguration</code> from the specified web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_logging_configuration_input::Builder,
    }
    impl DeleteLoggingConfiguration {
        /// Creates a new `DeleteLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <code>LoggingConfiguration</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermissionPolicy`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes an IAM policy from the specified RuleGroup.</p>
    /// <p>The user making the request must be the owner of the RuleGroup.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePermissionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_permission_policy_input::Builder,
    }
    impl DeletePermissionPolicy {
        /// Creates a new `DeletePermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete the policy.</p>
        /// <p>The user making the request must be the owner of the RuleGroup.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete the policy.</p>
        /// <p>The user making the request must be the owner of the RuleGroup.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>RateBasedRule</code>. You can't delete a rule if it's still used in any <code>WebACL</code> objects or if it still includes any predicates, such as <code>ByteMatchSet</code> objects.</p>
    /// <p>If you just want to remove a rule from a <code>WebACL</code>, use <code>UpdateWebACL</code>.</p>
    /// <p>To permanently delete a <code>RateBasedRule</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>RateBasedRule</code> to remove predicates, if any. For more information, see <code>UpdateRateBasedRule</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteRateBasedRule</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteRateBasedRule</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRateBasedRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rate_based_rule_input::Builder,
    }
    impl DeleteRateBasedRule {
        /// Creates a new `DeleteRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRateBasedRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to delete. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to delete. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>RegexMatchSet</code>. You can't delete a <code>RegexMatchSet</code> if it's still used in any <code>Rules</code> or if it still includes any <code>RegexMatchTuples</code> objects (any filters).</p>
    /// <p>If you just want to remove a <code>RegexMatchSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete a <code>RegexMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>RegexMatchSet</code> to remove filters, if any. For more information, see <code>UpdateRegexMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteRegexMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteRegexMatchSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegexMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_regex_match_set_input::Builder,
    }
    impl DeleteRegexMatchSet {
        /// Creates a new `DeleteRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegexMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to delete. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn regex_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_match_set_id(input.into());
            self
        }
        /// <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to delete. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>RegexPatternSet</code>. You can't delete a <code>RegexPatternSet</code> if it's still used in any <code>RegexMatchSet</code> or if the <code>RegexPatternSet</code> is not empty. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_regex_pattern_set_input::Builder,
    }
    impl DeleteRegexPatternSet {
        /// Creates a new `DeleteRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to delete. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn regex_pattern_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_pattern_set_id(input.into());
            self
        }
        /// <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to delete. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_pattern_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>Rule</code>. You can't delete a <code>Rule</code> if it's still used in any <code>WebACL</code> objects or if it still includes any predicates, such as <code>ByteMatchSet</code> objects.</p>
    /// <p>If you just want to remove a <code>Rule</code> from a <code>WebACL</code>, use <code>UpdateWebACL</code>.</p>
    /// <p>To permanently delete a <code>Rule</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>Rule</code> to remove predicates, if any. For more information, see <code>UpdateRule</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteRule</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteRule</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl DeleteRule {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to delete. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to delete. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>RuleGroup</code>. You can't delete a <code>RuleGroup</code> if it's still used in any <code>WebACL</code> objects or if it still includes any rules.</p>
    /// <p>If you just want to remove a <code>RuleGroup</code> from a <code>WebACL</code>, use <code>UpdateWebACL</code>.</p>
    /// <p>To permanently delete a <code>RuleGroup</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>RuleGroup</code> to remove rules, if any. For more information, see <code>UpdateRuleGroup</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteRuleGroup</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteRuleGroup</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_rule_group_input::Builder,
    }
    impl DeleteRuleGroup {
        /// Creates a new `DeleteRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to delete. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(input.into());
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to delete. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>SizeConstraintSet</code>. You can't delete a <code>SizeConstraintSet</code> if it's still used in any <code>Rules</code> or if it still includes any <code>SizeConstraint</code> objects (any filters).</p>
    /// <p>If you just want to remove a <code>SizeConstraintSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete a <code>SizeConstraintSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>SizeConstraintSet</code> to remove filters, if any. For more information, see <code>UpdateSizeConstraintSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteSizeConstraintSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteSizeConstraintSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSizeConstraintSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_size_constraint_set_input::Builder,
    }
    impl DeleteSizeConstraintSet {
        /// Creates a new `DeleteSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSizeConstraintSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to delete. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn size_constraint_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.size_constraint_set_id(input.into());
            self
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to delete. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_size_constraint_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>SqlInjectionMatchSet</code>. You can't delete a <code>SqlInjectionMatchSet</code> if it's still used in any <code>Rules</code> or if it still contains any <code>SqlInjectionMatchTuple</code> objects.</p>
    /// <p>If you just want to remove a <code>SqlInjectionMatchSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete a <code>SqlInjectionMatchSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>SqlInjectionMatchSet</code> to remove filters, if any. For more information, see <code>UpdateSqlInjectionMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteSqlInjectionMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteSqlInjectionMatchSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSqlInjectionMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_sql_injection_match_set_input::Builder,
    }
    impl DeleteSqlInjectionMatchSet {
        /// Creates a new `DeleteSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSqlInjectionMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to delete. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn sql_injection_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_injection_match_set_id(input.into());
            self
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to delete. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_injection_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <code>WebACL</code>. You can't delete a <code>WebACL</code> if it still contains any <code>Rules</code>.</p>
    /// <p>To delete a <code>WebACL</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>WebACL</code> to remove <code>Rules</code>, if any. For more information, see <code>UpdateWebACL</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteWebACL</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteWebACL</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_web_acl_input::Builder,
    }
    impl DeleteWebACL {
        /// Creates a new `DeleteWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to delete. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to delete. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes an <code>XssMatchSet</code>. You can't delete an <code>XssMatchSet</code> if it's still used in any <code>Rules</code> or if it still contains any <code>XssMatchTuple</code> objects.</p>
    /// <p>If you just want to remove an <code>XssMatchSet</code> from a <code>Rule</code>, use <code>UpdateRule</code>.</p>
    /// <p>To permanently delete an <code>XssMatchSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Update the <code>XssMatchSet</code> to remove filters, if any. For more information, see <code>UpdateXssMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of a <code>DeleteXssMatchSet</code> request.</p> </li>
    /// <li> <p>Submit a <code>DeleteXssMatchSet</code> request.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteXssMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_xss_match_set_input::Builder,
    }
    impl DeleteXssMatchSet {
        /// Creates a new `DeleteXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteXssMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to delete. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn xss_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.xss_match_set_id(input.into());
            self
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to delete. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_xss_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>ByteMatchSet</code> specified by <code>ByteMatchSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetByteMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_byte_match_set_input::Builder,
    }
    impl GetByteMatchSet {
        /// Creates a new `GetByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetByteMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to get. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn byte_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.byte_match_set_id(input.into());
            self
        }
        /// <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to get. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_byte_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChangeToken`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>When you want to create, update, or delete AWS WAF objects, get a change token and include the change token in the create, update, or delete request. Change tokens ensure that your application doesn't submit conflicting requests to AWS WAF.</p>
    /// <p>Each create, update, or delete request must use a unique change token. If your application submits a <code>GetChangeToken</code> request and then submits a second <code>GetChangeToken</code> request before submitting a create, update, or delete request, the second <code>GetChangeToken</code> request returns the same value as the first <code>GetChangeToken</code> request.</p>
    /// <p>When you use a change token in a create, update, or delete request, the status of the change token changes to <code>PENDING</code>, which indicates that AWS WAF is propagating the change to all AWS WAF servers. Use <code>GetChangeTokenStatus</code> to determine the status of your change token.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChangeToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_change_token_input::Builder,
    }
    impl GetChangeToken {
        /// Creates a new `GetChangeToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetChangeTokenStatus`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the status of a <code>ChangeToken</code> that you got by calling <code>GetChangeToken</code>. <code>ChangeTokenStatus</code> is one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>PROVISIONED</code>: You requested the change token by calling <code>GetChangeToken</code>, but you haven't used it yet in a call to create, update, or delete an AWS WAF object.</p> </li>
    /// <li> <p> <code>PENDING</code>: AWS WAF is propagating the create, update, or delete request to all AWS WAF servers.</p> </li>
    /// <li> <p> <code>INSYNC</code>: Propagation is complete.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChangeTokenStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_change_token_status_input::Builder,
    }
    impl GetChangeTokenStatus {
        /// Creates a new `GetChangeTokenStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeTokenStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeTokenStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The change token for which you want to get the status. This change token was previously returned in the <code>GetChangeToken</code> response.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The change token for which you want to get the status. This change token was previously returned in the <code>GetChangeToken</code> response.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>GeoMatchSet</code> that is specified by <code>GeoMatchSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGeoMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_geo_match_set_input::Builder,
    }
    impl GetGeoMatchSet {
        /// Creates a new `GetGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeoMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GeoMatchSetId</code> of the <code>GeoMatchSet</code> that you want to get. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn geo_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geo_match_set_id(input.into());
            self
        }
        /// <p>The <code>GeoMatchSetId</code> of the <code>GeoMatchSet</code> that you want to get. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>IPSet</code> that is specified by <code>IPSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_ip_set_input::Builder,
    }
    impl GetIPSet {
        /// Creates a new `GetIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to get. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(input.into());
            self
        }
        /// <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to get. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggingConfiguration`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>LoggingConfiguration</code> for the specified web ACL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_logging_configuration_input::Builder,
    }
    impl GetLoggingConfiguration {
        /// Creates a new `GetLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <code>LoggingConfiguration</code>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPermissionPolicy`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the IAM policy attached to the RuleGroup.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPermissionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_permission_policy_input::Builder,
    }
    impl GetPermissionPolicy {
        /// Creates a new `GetPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPermissionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup for which you want to get the policy.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup for which you want to get the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>RateBasedRule</code> that is specified by the <code>RuleId</code> that you included in the <code>GetRateBasedRule</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRateBasedRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rate_based_rule_input::Builder,
    }
    impl GetRateBasedRule {
        /// Creates a new `GetRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRateBasedRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to get. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to get. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRateBasedRuleManagedKeys`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of IP addresses currently being blocked by the <code>RateBasedRule</code> that is specified by the <code>RuleId</code>. The maximum number of managed keys that will be blocked is 10,000. If more than 10,000 addresses exceed the rate limit, the 10,000 addresses with the highest rates will be blocked.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRateBasedRuleManagedKeys {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rate_based_rule_managed_keys_input::Builder,
    }
    impl GetRateBasedRuleManagedKeys {
        /// Creates a new `GetRateBasedRuleManagedKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRateBasedRuleManagedKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRateBasedRuleManagedKeysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> for which you want to get a list of <code>ManagedKeys</code>. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> for which you want to get a list of <code>ManagedKeys</code>. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>A null value and not currently used. Do not include this in your request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>A null value and not currently used. Do not include this in your request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>RegexMatchSet</code> specified by <code>RegexMatchSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegexMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_regex_match_set_input::Builder,
    }
    impl GetRegexMatchSet {
        /// Creates a new `GetRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegexMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to get. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn regex_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_match_set_id(input.into());
            self
        }
        /// <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to get. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>RegexPatternSet</code> specified by <code>RegexPatternSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_regex_pattern_set_input::Builder,
    }
    impl GetRegexPatternSet {
        /// Creates a new `GetRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to get. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn regex_pattern_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_pattern_set_id(input.into());
            self
        }
        /// <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to get. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_pattern_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>Rule</code> that is specified by the <code>RuleId</code> that you included in the <code>GetRule</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rule_input::Builder,
    }
    impl GetRule {
        /// Creates a new `GetRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to get. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to get. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>RuleGroup</code> that is specified by the <code>RuleGroupId</code> that you included in the <code>GetRuleGroup</code> request.</p>
    /// <p>To view the rules in a rule group, use <code>ListActivatedRulesInRuleGroup</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_rule_group_input::Builder,
    }
    impl GetRuleGroup {
        /// Creates a new `GetRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to get. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(input.into());
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to get. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSampledRequests`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from among the first 5,000 requests that your AWS resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.</p>
    /// <p> <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, <code>GetSampledRequests</code> returns an updated time range. This new time range indicates the actual period during which AWS WAF selected the requests in the sample.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSampledRequests {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sampled_requests_input::Builder,
    }
    impl GetSampledRequests {
        /// Creates a new `GetSampledRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSampledRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSampledRequestsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p> <code>RuleId</code> is one of three values:</p>
        /// <ul>
        /// <li> <p>The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p> </li>
        /// <li> <p> <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests that didn't match any of the rules in the specified <code>WebACL</code>.</p> </li>
        /// </ul>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p> <code>RuleId</code> is one of three values:</p>
        /// <ul>
        /// <li> <p>The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p> </li>
        /// <li> <p> <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests that didn't match any of the rules in the specified <code>WebACL</code>.</p> </li>
        /// </ul>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn time_window(mut self, input: crate::model::TimeWindow) -> Self {
            self.inner = self.inner.time_window(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn set_time_window(
            mut self,
            input: std::option::Option<crate::model::TimeWindow>,
        ) -> Self {
            self.inner = self.inner.set_time_window(input);
            self
        }
        /// <p>The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
        pub fn max_items(mut self, input: i64) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code> returns information about all of them. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>SizeConstraintSet</code> specified by <code>SizeConstraintSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSizeConstraintSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_size_constraint_set_input::Builder,
    }
    impl GetSizeConstraintSet {
        /// Creates a new `GetSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSizeConstraintSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to get. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn size_constraint_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.size_constraint_set_id(input.into());
            self
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to get. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_size_constraint_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>SqlInjectionMatchSet</code> that is specified by <code>SqlInjectionMatchSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSqlInjectionMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_sql_injection_match_set_input::Builder,
    }
    impl GetSqlInjectionMatchSet {
        /// Creates a new `GetSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSqlInjectionMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to get. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn sql_injection_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_injection_match_set_id(input.into());
            self
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to get. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_injection_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>WebACL</code> that is specified by <code>WebACLId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_web_acl_input::Builder,
    }
    impl GetWebACL {
        /// Creates a new `GetWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to get. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to get. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <code>XssMatchSet</code> that is specified by <code>XssMatchSetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetXssMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_xss_match_set_input::Builder,
    }
    impl GetXssMatchSet {
        /// Creates a new `GetXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetXssMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to get. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn xss_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.xss_match_set_id(input.into());
            self
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to get. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_xss_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActivatedRulesInRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>ActivatedRule</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListActivatedRulesInRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_activated_rules_in_rule_group_input::Builder,
    }
    impl ListActivatedRulesInRuleGroup {
        /// Creates a new `ListActivatedRulesInRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActivatedRulesInRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActivatedRulesInRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want to get a list of <code>ActivatedRule</code> objects.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(input.into());
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want to get a list of <code>ActivatedRule</code> objects.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ActivatedRules</code>. For the second and subsequent <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ActivatedRules</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ActivatedRules</code>. For the second and subsequent <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ActivatedRules</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListByteMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>ByteMatchSetSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListByteMatchSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_byte_match_sets_input::Builder,
    }
    impl ListByteMatchSets {
        /// Creates a new `ListByteMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListByteMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListByteMatchSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>. For the second and subsequent <code>ListByteMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ByteMatchSets</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>. For the second and subsequent <code>ListByteMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ByteMatchSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>ByteMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>ByteMatchSets</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>ByteMatchSet</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>ByteMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>ByteMatchSets</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>ByteMatchSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeoMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>GeoMatchSetSummary</code> objects in the response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGeoMatchSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_geo_match_sets_input::Builder,
    }
    impl ListGeoMatchSets {
        /// Creates a new `ListGeoMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeoMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeoMatchSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>GeoMatchSet</code>s than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>GeoMatchSet</code> objects. For the second and subsequent <code>ListGeoMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>GeoMatchSet</code>s than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>GeoMatchSet</code> objects. For the second and subsequent <code>ListGeoMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>GeoMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>GeoMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>GeoMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>GeoMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIPSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>IPSetSummary</code> objects in the response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIPSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_ip_sets_input::Builder,
    }
    impl ListIPSets {
        /// Creates a new `ListIPSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIPSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>IPSets</code>. For the second and subsequent <code>ListIPSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>IPSets</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>IPSets</code>. For the second and subsequent <code>ListIPSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>IPSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>IPSet</code> objects that you want AWS WAF to return for this request. If you have more <code>IPSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>IPSet</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>IPSet</code> objects that you want AWS WAF to return for this request. If you have more <code>IPSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>IPSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLoggingConfigurations`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>LoggingConfiguration</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLoggingConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_logging_configurations_input::Builder,
    }
    impl ListLoggingConfigurations {
        /// Creates a new `ListLoggingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLoggingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLoggingConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>LoggingConfigurations</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>LoggingConfigurations</code>. For the second and subsequent <code>ListLoggingConfigurations</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ListLoggingConfigurations</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>LoggingConfigurations</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>LoggingConfigurations</code>. For the second and subsequent <code>ListLoggingConfigurations</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>ListLoggingConfigurations</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>LoggingConfigurations</code> that you want AWS WAF to return for this request. If you have more <code>LoggingConfigurations</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>LoggingConfigurations</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>LoggingConfigurations</code> that you want AWS WAF to return for this request. If you have more <code>LoggingConfigurations</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>LoggingConfigurations</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRateBasedRules`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>RuleSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRateBasedRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rate_based_rules_input::Builder,
    }
    impl ListRateBasedRules {
        /// Creates a new `ListRateBasedRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRateBasedRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRateBasedRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>. For the second and subsequent <code>ListRateBasedRules</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>Rules</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>. For the second and subsequent <code>ListRateBasedRules</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>Rules</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegexMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>RegexMatchSetSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRegexMatchSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_regex_match_sets_input::Builder,
    }
    impl ListRegexMatchSets {
        /// Creates a new `ListRegexMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegexMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegexMatchSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>. For the second and subsequent <code>ListRegexMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>. For the second and subsequent <code>ListRegexMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>RegexMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>RegexMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>RegexMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>RegexMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegexPatternSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>RegexPatternSetSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRegexPatternSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_regex_pattern_sets_input::Builder,
    }
    impl ListRegexPatternSets {
        /// Creates a new `ListRegexPatternSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegexPatternSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegexPatternSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexPatternSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RegexPatternSet</code> objects. For the second and subsequent <code>ListRegexPatternSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexPatternSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RegexPatternSet</code> objects. For the second and subsequent <code>ListRegexPatternSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>RegexPatternSet</code> objects that you want AWS WAF to return for this request. If you have more <code>RegexPatternSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>RegexPatternSet</code> objects that you want AWS WAF to return for this request. If you have more <code>RegexPatternSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroups`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>RuleGroup</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rule_groups_input::Builder,
    }
    impl ListRuleGroups {
        /// Creates a new `ListRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RuleGroups</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RuleGroups</code>. For the second and subsequent <code>ListRuleGroups</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RuleGroups</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RuleGroups</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RuleGroups</code>. For the second and subsequent <code>ListRuleGroups</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>RuleGroups</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>RuleGroups</code> that you want AWS WAF to return for this request. If you have more <code>RuleGroups</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RuleGroups</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>RuleGroups</code> that you want AWS WAF to return for this request. If you have more <code>RuleGroups</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RuleGroups</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>RuleSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl ListRules {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>. For the second and subsequent <code>ListRules</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>Rules</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>. For the second and subsequent <code>ListRules</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>Rules</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSizeConstraintSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>SizeConstraintSetSummary</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSizeConstraintSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_size_constraint_sets_input::Builder,
    }
    impl ListSizeConstraintSets {
        /// Creates a new `ListSizeConstraintSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSizeConstraintSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSizeConstraintSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>SizeConstraintSets</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SizeConstraintSets</code>. For the second and subsequent <code>ListSizeConstraintSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SizeConstraintSets</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>SizeConstraintSets</code> than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SizeConstraintSets</code>. For the second and subsequent <code>ListSizeConstraintSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SizeConstraintSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>SizeConstraintSet</code> objects that you want AWS WAF to return for this request. If you have more <code>SizeConstraintSets</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>SizeConstraintSet</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>SizeConstraintSet</code> objects that you want AWS WAF to return for this request. If you have more <code>SizeConstraintSets</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>SizeConstraintSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSqlInjectionMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>SqlInjectionMatchSet</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSqlInjectionMatchSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_sql_injection_match_sets_input::Builder,
    }
    impl ListSqlInjectionMatchSets {
        /// Creates a new `ListSqlInjectionMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSqlInjectionMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSqlInjectionMatchSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>SqlInjectionMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SqlInjectionMatchSets</code>. For the second and subsequent <code>ListSqlInjectionMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SqlInjectionMatchSets</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>SqlInjectionMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SqlInjectionMatchSets</code>. For the second and subsequent <code>ListSqlInjectionMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SqlInjectionMatchSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>SqlInjectionMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>SqlInjectionMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>SqlInjectionMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>SqlInjectionMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSubscribedRuleGroups`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>RuleGroup</code> objects that you are subscribed to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSubscribedRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_subscribed_rule_groups_input::Builder,
    }
    impl ListSubscribedRuleGroups {
        /// Creates a new `ListSubscribedRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSubscribedRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSubscribedRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code>subscribed rule groups than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of subscribed rule groups. For the second and subsequent <code>ListSubscribedRuleGroupsRequest</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of subscribed rule groups.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code>subscribed rule groups than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of subscribed rule groups. For the second and subsequent <code>ListSubscribedRuleGroupsRequest</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of subscribed rule groups.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of subscribed rule groups that you want AWS WAF to return for this request. If you have more objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of subscribed rule groups that you want AWS WAF to return for this request. If you have more objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Retrieves the tags associated with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p></p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p></p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p></p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebACLs`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>WebACLSummary</code> objects in the response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWebACLs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_web_ac_ls_input::Builder,
    }
    impl ListWebACLs {
        /// Creates a new `ListWebACLs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebAcLsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebACLsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>WebACL</code> objects. For the second and subsequent <code>ListWebACLs</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>WebACL</code> objects.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>WebACL</code> objects. For the second and subsequent <code>ListWebACLs</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>WebACL</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>WebACL</code> objects that you want AWS WAF to return for this request. If you have more <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>WebACL</code> objects.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>WebACL</code> objects that you want AWS WAF to return for this request. If you have more <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>WebACL</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListXssMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <code>XssMatchSet</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListXssMatchSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_xss_match_sets_input::Builder,
    }
    impl ListXssMatchSets {
        /// Creates a new `ListXssMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListXssMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListXssMatchSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>XssMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>XssMatchSets</code>. For the second and subsequent <code>ListXssMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>XssMatchSets</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(input.into());
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>XssMatchSet</code> objects than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>XssMatchSets</code>. For the second and subsequent <code>ListXssMatchSets</code> requests, specify the value of <code>NextMarker</code> from the previous response to get information about another batch of <code>XssMatchSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>XssMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>XssMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifies the number of <code>XssMatchSet</code> objects that you want AWS WAF to return for this request. If you have more <code>XssMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingConfiguration`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Associates a <code>LoggingConfiguration</code> with a specified web ACL.</p>
    /// <p>You can access information about all traffic that AWS WAF inspects using the following steps:</p>
    /// <ol>
    /// <li> <p>Create an Amazon Kinesis Data Firehose. </p> <p>Create the data firehose with a PUT source and in the region that you are operating. However, if you are capturing logs for Amazon CloudFront, always create the firehose in US East (N. Virginia). </p> <note>
    /// <p>Do not create the data firehose using a <code>Kinesis stream</code> as your source.</p>
    /// </note> </li>
    /// <li> <p>Associate that firehose to your web ACL using a <code>PutLoggingConfiguration</code> request.</p> </li>
    /// </ol>
    /// <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF will create a service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL Traffic Information</a> in the <i>AWS WAF Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLoggingConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_logging_configuration_input::Builder,
    }
    impl PutLoggingConfiguration {
        /// Creates a new `PutLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Kinesis Data Firehose that contains the inspected traffic information, the redacted fields details, and the Amazon Resource Name (ARN) of the web ACL to monitor.</p> <note>
        /// <p>When specifying <code>Type</code> in <code>RedactedFields</code>, you must use one of the following values: <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p>
        /// </note>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(input);
            self
        }
        /// <p>The Amazon Kinesis Data Firehose that contains the inspected traffic information, the redacted fields details, and the Amazon Resource Name (ARN) of the web ACL to monitor.</p> <note>
        /// <p>When specifying <code>Type</code> in <code>RedactedFields</code>, you must use one of the following values: <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or <code>METHOD</code>.</p>
        /// </note>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermissionPolicy`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Attaches an IAM policy to the specified resource. The only supported use for this action is to share a RuleGroup across accounts.</p>
    /// <p>The <code>PutPermissionPolicy</code> is subject to the following restrictions:</p>
    /// <ul>
    /// <li> <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p> </li>
    /// <li> <p>The policy must include an <code>Effect</code>, <code>Action</code> and <code>Principal</code>. </p> </li>
    /// <li> <p> <code>Effect</code> must specify <code>Allow</code>.</p> </li>
    /// <li> <p>The <code>Action</code> in the policy must be <code>waf:UpdateWebACL</code>, <code>waf-regional:UpdateWebACL</code>, <code>waf:GetRuleGroup</code> and <code>waf-regional:GetRuleGroup</code> . Any extra or wildcard actions in the policy will be rejected.</p> </li>
    /// <li> <p>The policy cannot include a <code>Resource</code> parameter.</p> </li>
    /// <li> <p>The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.</p> </li>
    /// <li> <p>The user making the request must be the owner of the RuleGroup.</p> </li>
    /// <li> <p>Your policy must be composed using IAM Policy version 2012-10-17.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>. </p>
    /// <p>An example of a valid policy parameter is shown in the Examples section below.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPermissionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_permission_policy_input::Builder,
    }
    impl PutPermissionPolicy {
        /// Creates a new `PutPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach the policy.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The policy to attach to the specified RuleGroup.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to attach to the specified RuleGroup.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Associates tags with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can use this action to tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p></p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p></p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>ByteMatchTuple</code> objects (filters) in a <code>ByteMatchSet</code>. For each <code>ByteMatchTuple</code> object, you specify the following values: </p>
    /// <ul>
    /// <li> <p>Whether to insert or delete the object from the array. If you want to change a <code>ByteMatchSetUpdate</code> object, you delete the existing object and add a new one.</p> </li>
    /// <li> <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
    /// <li> <p>The bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to look for. For more information, including how you specify the values for the AWS WAF API and the AWS CLI or SDKs, see <code>TargetString</code> in the <code>ByteMatchTuple</code> data type. </p> </li>
    /// <li> <p>Where to look, such as at the beginning or the end of a query string.</p> </li>
    /// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
    /// </ul>
    /// <p>For example, you can add a <code>ByteMatchSetUpdate</code> object that matches web requests in which <code>User-Agent</code> headers contain the string <code>BadBot</code>. You can then configure AWS WAF to block those requests.</p>
    /// <p>To create and configure a <code>ByteMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create a <code>ByteMatchSet.</code> For more information, see <code>CreateByteMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateByteMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateByteMatchSet</code> request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateByteMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_byte_match_set_input::Builder,
    }
    impl UpdateByteMatchSet {
        /// Creates a new `UpdateByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateByteMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to update. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn byte_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.byte_match_set_id(input.into());
            self
        }
        /// <p>The <code>ByteMatchSetId</code> of the <code>ByteMatchSet</code> that you want to update. <code>ByteMatchSetId</code> is returned by <code>CreateByteMatchSet</code> and by <code>ListByteMatchSets</code>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_byte_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a <code>ByteMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>ByteMatchSetUpdate</code>: Contains <code>Action</code> and <code>ByteMatchTuple</code> </p> </li>
        /// <li> <p> <code>ByteMatchTuple</code>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::ByteMatchSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a <code>ByteMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>ByteMatchSetUpdate</code>: Contains <code>Action</code> and <code>ByteMatchTuple</code> </p> </li>
        /// <li> <p> <code>ByteMatchTuple</code>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ByteMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>GeoMatchConstraint</code> objects in an <code>GeoMatchSet</code>. For each <code>GeoMatchConstraint</code> object, you specify the following values: </p>
    /// <ul>
    /// <li> <p>Whether to insert or delete the object from the array. If you want to change an <code>GeoMatchConstraint</code> object, you delete the existing object and add a new one.</p> </li>
    /// <li> <p>The <code>Type</code>. The only valid value for <code>Type</code> is <code>Country</code>.</p> </li>
    /// <li> <p>The <code>Value</code>, which is a two character code for the country to add to the <code>GeoMatchConstraint</code> object. Valid codes are listed in <code>GeoMatchConstraint$Value</code>.</p> </li>
    /// </ul>
    /// <p>To create and configure an <code>GeoMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Submit a <code>CreateGeoMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateGeoMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateGeoMatchSet</code> request to specify the country that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>When you update an <code>GeoMatchSet</code>, you specify the country that you want to add and/or the country that you want to delete. If you want to change a country, you delete the existing country and add the new one.</p>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGeoMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_geo_match_set_input::Builder,
    }
    impl UpdateGeoMatchSet {
        /// Creates a new `UpdateGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGeoMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GeoMatchSetId</code> of the <code>GeoMatchSet</code> that you want to update. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn geo_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geo_match_set_id(input.into());
            self
        }
        /// <p>The <code>GeoMatchSetId</code> of the <code>GeoMatchSet</code> that you want to update. <code>GeoMatchSetId</code> is returned by <code>CreateGeoMatchSet</code> and by <code>ListGeoMatchSets</code>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an <code>GeoMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>GeoMatchSetUpdate</code>: Contains <code>Action</code> and <code>GeoMatchConstraint</code> </p> </li>
        /// <li> <p> <code>GeoMatchConstraint</code>: Contains <code>Type</code> and <code>Value</code> </p> <p>You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.</p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::GeoMatchSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an <code>GeoMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>GeoMatchSetUpdate</code>: Contains <code>Action</code> and <code>GeoMatchConstraint</code> </p> </li>
        /// <li> <p> <code>GeoMatchConstraint</code>: Contains <code>Type</code> and <code>Value</code> </p> <p>You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.</p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeoMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>IPSetDescriptor</code> objects in an <code>IPSet</code>. For each <code>IPSetDescriptor</code> object, you specify the following values: </p>
    /// <ul>
    /// <li> <p>Whether to insert or delete the object from the array. If you want to change an <code>IPSetDescriptor</code> object, you delete the existing object and add a new one.</p> </li>
    /// <li> <p>The IP address version, <code>IPv4</code> or <code>IPv6</code>. </p> </li>
    /// <li> <p>The IP address in CIDR notation, for example, <code>192.0.2.0/24</code> (for the range of IP addresses from <code>192.0.2.0</code> to <code>192.0.2.255</code>) or <code>192.0.2.44/32</code> (for the individual IP address <code>192.0.2.44</code>). </p> </li>
    /// </ul>
    /// <p>AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128. For more information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>.</p>
    /// <p>IPv6 addresses can be represented using any of the following formats:</p>
    /// <ul>
    /// <li> <p>1111:0000:0000:0000:0000:0000:0000:0111/128</p> </li>
    /// <li> <p>1111:0:0:0:0:0:0:0111/128</p> </li>
    /// <li> <p>1111::0111/128</p> </li>
    /// <li> <p>1111::111/128</p> </li>
    /// </ul>
    /// <p>You use an <code>IPSet</code> to specify which web requests you want to allow or block based on the IP addresses that the requests originated from. For example, if you're receiving a lot of requests from one or a small number of IP addresses and you want to block the requests, you can create an <code>IPSet</code> that specifies those IP addresses, and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure an <code>IPSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Submit a <code>CreateIPSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateIPSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateIPSet</code> request to specify the IP addresses that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>When you update an <code>IPSet</code>, you specify the IP addresses that you want to add and/or the IP addresses that you want to delete. If you want to change an IP address, you delete the existing IP address and add the new one.</p>
    /// <p>You can insert a maximum of 1000 addresses in a single request.</p>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIPSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_ip_set_input::Builder,
    }
    impl UpdateIPSet {
        /// Creates a new `UpdateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIPSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to update. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(input.into());
            self
        }
        /// <p>The <code>IPSetId</code> of the <code>IPSet</code> that you want to update. <code>IPSetId</code> is returned by <code>CreateIPSet</code> and by <code>ListIPSets</code>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <code>IPSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>IPSetUpdate</code>: Contains <code>Action</code> and <code>IPSetDescriptor</code> </p> </li>
        /// <li> <p> <code>IPSetDescriptor</code>: Contains <code>Type</code> and <code>Value</code> </p> </li>
        /// </ul>
        /// <p>You can insert a maximum of 1000 addresses in a single request.</p>
        pub fn updates(mut self, input: crate::model::IpSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <code>IPSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>IPSetUpdate</code>: Contains <code>Action</code> and <code>IPSetDescriptor</code> </p> </li>
        /// <li> <p> <code>IPSetDescriptor</code>: Contains <code>Type</code> and <code>Value</code> </p> </li>
        /// </ul>
        /// <p>You can insert a maximum of 1000 addresses in a single request.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>Predicate</code> objects in a rule and updates the <code>RateLimit</code> in the rule. </p>
    /// <p>Each <code>Predicate</code> object identifies a predicate, such as a <code>ByteMatchSet</code> or an <code>IPSet</code>, that specifies the web requests that you want to block or count. The <code>RateLimit</code> specifies the number of requests every five minutes that triggers the rule.</p>
    /// <p>If you add more than one predicate to a <code>RateBasedRule</code>, a request must match all the predicates and exceed the <code>RateLimit</code> to be counted or blocked. For example, suppose you add the following to a <code>RateBasedRule</code>:</p>
    /// <ul>
    /// <li> <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44/32</code> </p> </li>
    /// <li> <p>A <code>ByteMatchSet</code> that matches <code>BadBot</code> in the <code>User-Agent</code> header</p> </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>You then add the <code>RateBasedRule</code> to a <code>WebACL</code> and specify that you want to block requests that satisfy the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 <i>and</i> the <code>User-Agent</code> header in the request must contain the value <code>BadBot</code>. Further, requests that match these two conditions much be received at a rate of more than 1,000 every five minutes. If the rate drops below this limit, AWS WAF no longer blocks the requests.</p>
    /// <p>As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a <code>RateBasedRule</code>:</p>
    /// <ul>
    /// <li> <p>A <code>ByteMatchSet</code> with <code>FieldToMatch</code> of <code>URI</code> </p> </li>
    /// <li> <p>A <code>PositionalConstraint</code> of <code>STARTS_WITH</code> </p> </li>
    /// <li> <p>A <code>TargetString</code> of <code>login</code> </p> </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>By adding this <code>RateBasedRule</code> to a <code>WebACL</code>, you could limit requests to your login page without affecting the rest of your site.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRateBasedRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rate_based_rule_input::Builder,
    }
    impl UpdateRateBasedRule {
        /// Creates a new `UpdateRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRateBasedRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update. <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <code>ListRateBasedRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <code>RateBasedRule</code>. </p>
        pub fn updates(mut self, input: crate::model::RuleUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <code>RateBasedRule</code>. </p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn rate_limit(mut self, input: i64) -> Self {
            self.inner = self.inner.rate_limit(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_rate_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>RegexMatchTuple</code> objects (filters) in a <code>RegexMatchSet</code>. For each <code>RegexMatchSetUpdate</code> object, you specify the following values: </p>
    /// <ul>
    /// <li> <p>Whether to insert or delete the object from the array. If you want to change a <code>RegexMatchSetUpdate</code> object, you delete the existing object and add a new one.</p> </li>
    /// <li> <p>The part of a web request that you want AWS WAF to inspectupdate, such as a query string or the value of the <code>User-Agent</code> header. </p> </li>
    /// <li> <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <code>RegexPatternSet</code>. </p> </li>
    /// <li> <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p> </li>
    /// </ul>
    /// <p> For example, you can create a <code>RegexPatternSet</code> that matches any requests with <code>User-Agent</code> headers that contain the string <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>RegexMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create a <code>RegexMatchSet.</code> For more information, see <code>CreateRegexMatchSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRegexMatchSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRegexMatchSet</code> request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the identifier of the <code>RegexPatternSet</code> that contain the regular expression patters you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRegexMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_regex_match_set_input::Builder,
    }
    impl UpdateRegexMatchSet {
        /// Creates a new `UpdateRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegexMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to update. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn regex_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_match_set_id(input.into());
            self
        }
        /// <p>The <code>RegexMatchSetId</code> of the <code>RegexMatchSet</code> that you want to update. <code>RegexMatchSetId</code> is returned by <code>CreateRegexMatchSet</code> and by <code>ListRegexMatchSets</code>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_match_set_id(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a <code>RegexMatchSet</code>. For more information, see <code>RegexMatchTuple</code>.</p>
        pub fn updates(mut self, input: crate::model::RegexMatchSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a <code>RegexMatchSet</code>. For more information, see <code>RegexMatchTuple</code>.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>RegexPatternString</code> objects in a <code>RegexPatternSet</code>. For each <code>RegexPatternString</code> object, you specify the following values: </p>
    /// <ul>
    /// <li> <p>Whether to insert or delete the <code>RegexPatternString</code>.</p> </li>
    /// <li> <p>The regular expression pattern that you want to insert or delete. For more information, see <code>RegexPatternSet</code>. </p> </li>
    /// </ul>
    /// <p> For example, you can create a <code>RegexPatternString</code> such as <code>B[a@]dB[o0]t</code>. AWS WAF will match this <code>RegexPatternString</code> to:</p>
    /// <ul>
    /// <li> <p>BadBot</p> </li>
    /// <li> <p>BadB0t</p> </li>
    /// <li> <p>B@dBot</p> </li>
    /// <li> <p>B@dB0t</p> </li>
    /// </ul>
    /// <p>To create and configure a <code>RegexPatternSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create a <code>RegexPatternSet.</code> For more information, see <code>CreateRegexPatternSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRegexPatternSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRegexPatternSet</code> request to specify the regular expression pattern that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRegexPatternSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_regex_pattern_set_input::Builder,
    }
    impl UpdateRegexPatternSet {
        /// Creates a new `UpdateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegexPatternSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to update. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn regex_pattern_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_pattern_set_id(input.into());
            self
        }
        /// <p>The <code>RegexPatternSetId</code> of the <code>RegexPatternSet</code> that you want to update. <code>RegexPatternSetId</code> is returned by <code>CreateRegexPatternSet</code> and by <code>ListRegexPatternSets</code>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_pattern_set_id(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a <code>RegexPatternSet</code>.</p>
        pub fn updates(mut self, input: crate::model::RegexPatternSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a <code>RegexPatternSet</code>.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexPatternSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>Predicate</code> objects in a <code>Rule</code>. Each <code>Predicate</code> object identifies a predicate, such as a <code>ByteMatchSet</code> or an <code>IPSet</code>, that specifies the web requests that you want to allow, block, or count. If you add more than one predicate to a <code>Rule</code>, a request must match all of the specifications to be allowed, blocked, or counted. For example, suppose that you add the following to a <code>Rule</code>: </p>
    /// <ul>
    /// <li> <p>A <code>ByteMatchSet</code> that matches the value <code>BadBot</code> in the <code>User-Agent</code> header</p> </li>
    /// <li> <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44</code> </p> </li>
    /// </ul>
    /// <p>You then add the <code>Rule</code> to a <code>WebACL</code> and specify that you want to block requests that satisfy the <code>Rule</code>. For a request to be blocked, the <code>User-Agent</code> header in the request must contain the value <code>BadBot</code> <i>and</i> the request must originate from the IP address 192.0.2.44.</p>
    /// <p>To create and configure a <code>Rule</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create and update the predicates that you want to include in the <code>Rule</code>.</p> </li>
    /// <li> <p>Create the <code>Rule</code>. See <code>CreateRule</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRule</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRule</code> request to add predicates to the <code>Rule</code>.</p> </li>
    /// <li> <p>Create and update a <code>WebACL</code> that contains the <code>Rule</code>. See <code>CreateWebACL</code>.</p> </li>
    /// </ol>
    /// <p>If you want to replace one <code>ByteMatchSet</code> or <code>IPSet</code> with another, you delete the existing one and add the new one.</p>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rule_input::Builder,
    }
    impl UpdateRule {
        /// Creates a new `UpdateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to update. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(input.into());
            self
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to update. <code>RuleId</code> is returned by <code>CreateRule</code> and by <code>ListRules</code>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <code>Rule</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>RuleUpdate</code>: Contains <code>Action</code> and <code>Predicate</code> </p> </li>
        /// <li> <p> <code>Predicate</code>: Contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::RuleUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a <code>Rule</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>RuleUpdate</code>: Contains <code>Action</code> and <code>Predicate</code> </p> </li>
        /// <li> <p> <code>Predicate</code>: Contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>ActivatedRule</code> objects in a <code>RuleGroup</code>.</p>
    /// <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>
    /// <p>You can have a maximum of ten rules per rule group.</p>
    /// <p>To create and configure a <code>RuleGroup</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create and update the <code>Rules</code> that you want to include in the <code>RuleGroup</code>. See <code>CreateRule</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateRuleGroup</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateRuleGroup</code> request to add <code>Rules</code> to the <code>RuleGroup</code>.</p> </li>
    /// <li> <p>Create and update a <code>WebACL</code> that contains the <code>RuleGroup</code>. See <code>CreateWebACL</code>.</p> </li>
    /// </ol>
    /// <p>If you want to replace one <code>Rule</code> with another, you delete the existing one and add the new one.</p>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_rule_group_input::Builder,
    }
    impl UpdateRuleGroup {
        /// Creates a new `UpdateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to update. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(input.into());
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <code>RuleGroup</code> that you want to update. <code>RuleGroupId</code> is returned by <code>CreateRuleGroup</code> and by <code>ListRuleGroups</code>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a <code>RuleGroup</code>.</p>
        /// <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>
        /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn updates(mut self, input: crate::model::RuleGroupUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a <code>RuleGroup</code>.</p>
        /// <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>
        /// <p> <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleGroupUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>SizeConstraint</code> objects (filters) in a <code>SizeConstraintSet</code>. For each <code>SizeConstraint</code> object, you specify the following values: </p>
    /// <ul>
    /// <li> <p>Whether to insert or delete the object from the array. If you want to change a <code>SizeConstraintSetUpdate</code> object, you delete the existing object and add a new one.</p> </li>
    /// <li> <p>The part of a web request that you want AWS WAF to evaluate, such as the length of a query string or the length of the <code>User-Agent</code> header.</p> </li>
    /// <li> <p>Whether to perform any transformations on the request, such as converting it to lowercase, before checking its length. Note that transformations of the request body are not supported because the AWS resource forwards only the first <code>8192</code> bytes of your request to AWS WAF.</p> <p>You can only specify a single type of TextTransformation.</p> </li>
    /// <li> <p>A <code>ComparisonOperator</code> used for evaluating the selected part of the request against the specified <code>Size</code>, such as equals, greater than, less than, and so on.</p> </li>
    /// <li> <p>The length, in bytes, that you want AWS WAF to watch for in selected part of the request. The length is computed after applying the transformation.</p> </li>
    /// </ul>
    /// <p>For example, you can add a <code>SizeConstraintSetUpdate</code> object that matches web requests in which the length of the <code>User-Agent</code> header is greater than 100 bytes. You can then configure AWS WAF to block those requests.</p>
    /// <p>To create and configure a <code>SizeConstraintSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create a <code>SizeConstraintSet.</code> For more information, see <code>CreateSizeConstraintSet</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateSizeConstraintSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateSizeConstraintSet</code> request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSizeConstraintSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_size_constraint_set_input::Builder,
    }
    impl UpdateSizeConstraintSet {
        /// Creates a new `UpdateSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSizeConstraintSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to update. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn size_constraint_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.size_constraint_set_id(input.into());
            self
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <code>SizeConstraintSet</code> that you want to update. <code>SizeConstraintSetId</code> is returned by <code>CreateSizeConstraintSet</code> and by <code>ListSizeConstraintSets</code>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_size_constraint_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>SizeConstraintSetUpdate</code> objects that you want to insert into or delete from a <code>SizeConstraintSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>SizeConstraintSetUpdate</code>: Contains <code>Action</code> and <code>SizeConstraint</code> </p> </li>
        /// <li> <p> <code>SizeConstraint</code>: Contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::SizeConstraintSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>SizeConstraintSetUpdate</code> objects that you want to insert into or delete from a <code>SizeConstraintSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>SizeConstraintSetUpdate</code>: Contains <code>Action</code> and <code>SizeConstraint</code> </p> </li>
        /// <li> <p> <code>SizeConstraint</code>: Contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SizeConstraintSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>SqlInjectionMatchTuple</code> objects (filters) in a <code>SqlInjectionMatchSet</code>. For each <code>SqlInjectionMatchTuple</code> object, you specify the following values:</p>
    /// <ul>
    /// <li> <p> <code>Action</code>: Whether to insert the object into or delete the object from the array. To change a <code>SqlInjectionMatchTuple</code>, you delete the existing object and add a new one.</p> </li>
    /// <li> <p> <code>FieldToMatch</code>: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.</p> </li>
    /// <li> <p> <code>TextTransformation</code>: Which text transformation, if any, to perform on the web request before inspecting the request for snippets of malicious SQL code.</p> <p>You can only specify a single type of TextTransformation.</p> </li>
    /// </ul>
    /// <p>You use <code>SqlInjectionMatchSet</code> objects to specify which CloudFront requests that you want to allow, block, or count. For example, if you're receiving requests that contain snippets of SQL code in the query string and you want to block the requests, you can create a <code>SqlInjectionMatchSet</code> with the applicable settings, and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure a <code>SqlInjectionMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Submit a <code>CreateSqlInjectionMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateIPSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateSqlInjectionMatchSet</code> request to specify the parts of web requests that you want AWS WAF to inspect for snippets of SQL code.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSqlInjectionMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_sql_injection_match_set_input::Builder,
    }
    impl UpdateSqlInjectionMatchSet {
        /// Creates a new `UpdateSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSqlInjectionMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn sql_injection_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_injection_match_set_id(input.into());
            self
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update. <code>SqlInjectionMatchSetId</code> is returned by <code>CreateSqlInjectionMatchSet</code> and by <code>ListSqlInjectionMatchSets</code>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_injection_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a <code>SqlInjectionMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>SqlInjectionMatchSetUpdate</code>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code> </p> </li>
        /// <li> <p> <code>SqlInjectionMatchTuple</code>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::SqlInjectionMatchSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a <code>SqlInjectionMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>SqlInjectionMatchSetUpdate</code>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code> </p> </li>
        /// <li> <p> <code>SqlInjectionMatchTuple</code>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>ActivatedRule</code> objects in a <code>WebACL</code>. Each <code>Rule</code> identifies web requests that you want to allow, block, or count. When you update a <code>WebACL</code>, you specify the following values:</p>
    /// <ul>
    /// <li> <p>A default action for the <code>WebACL</code>, either <code>ALLOW</code> or <code>BLOCK</code>. AWS WAF performs the default action if a request doesn't match the criteria in any of the <code>Rules</code> in a <code>WebACL</code>.</p> </li>
    /// <li> <p>The <code>Rules</code> that you want to add or delete. If you want to replace one <code>Rule</code> with another, you delete the existing <code>Rule</code> and add the new one.</p> </li>
    /// <li> <p>For each <code>Rule</code>, whether you want AWS WAF to allow requests, block requests, or count requests that match the conditions in the <code>Rule</code>.</p> </li>
    /// <li> <p>The order in which you want AWS WAF to evaluate the <code>Rules</code> in a <code>WebACL</code>. If you add more than one <code>Rule</code> to a <code>WebACL</code>, AWS WAF evaluates each request against the <code>Rules</code> in order based on the value of <code>Priority</code>. (The <code>Rule</code> that has the lowest value for <code>Priority</code> is evaluated first.) When a web request matches all the predicates (such as <code>ByteMatchSets</code> and <code>IPSets</code>) in a <code>Rule</code>, AWS WAF immediately takes the corresponding action, allow or block, and doesn't evaluate the request against the remaining <code>Rules</code> in the <code>WebACL</code>, if any. </p> </li>
    /// </ul>
    /// <p>To create and configure a <code>WebACL</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create and update the predicates that you want to include in <code>Rules</code>. For more information, see <code>CreateByteMatchSet</code>, <code>UpdateByteMatchSet</code>, <code>CreateIPSet</code>, <code>UpdateIPSet</code>, <code>CreateSqlInjectionMatchSet</code>, and <code>UpdateSqlInjectionMatchSet</code>.</p> </li>
    /// <li> <p>Create and update the <code>Rules</code> that you want to include in the <code>WebACL</code>. For more information, see <code>CreateRule</code> and <code>UpdateRule</code>.</p> </li>
    /// <li> <p>Create a <code>WebACL</code>. See <code>CreateWebACL</code>.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateWebACL</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateWebACL</code> request to specify the <code>Rules</code> that you want to include in the <code>WebACL</code>, to specify the default action, and to associate the <code>WebACL</code> with a CloudFront distribution. </p> <p>The <code>ActivatedRule</code> can be a rule group. If you specify a rule group as your <code>ActivatedRule</code> , you can exclude specific rules from that rule group.</p> <p>If you already have a rule group associated with a web ACL and want to submit an <code>UpdateWebACL</code> request to exclude certain rules from that rule group, you must first remove the rule group from the web ACL, the re-insert it again, specifying the excluded rules. For details, see <code>ActivatedRule$ExcludedRules</code> . </p> </li>
    /// </ol>
    /// <p>Be aware that if you try to add a RATE_BASED rule to a web ACL without setting the rule type when first creating the rule, the <code>UpdateWebACL</code> request will fail because the request tries to add a REGULAR rule (the default rule type) with the specified ID, which does not exist. </p>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWebACL {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_web_acl_input::Builder,
    }
    impl UpdateWebACL {
        /// Creates a new `UpdateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebACLError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to update. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn web_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(input.into());
            self
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> that you want to update. <code>WebACLId</code> is returned by <code>CreateWebACL</code> and by <code>ListWebACLs</code>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of updates to make to the <code>WebACL</code>.</p>
        /// <p>An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <code>WebACL</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>WebACLUpdate</code>: Contains <code>Action</code> and <code>ActivatedRule</code> </p> </li>
        /// <li> <p> <code>ActivatedRule</code>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>. </p> </li>
        /// <li> <p> <code>WafAction</code>: Contains <code>Type</code> </p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::WebAclUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of updates to make to the <code>WebACL</code>.</p>
        /// <p>An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a <code>WebACL</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>WebACLUpdate</code>: Contains <code>Action</code> and <code>ActivatedRule</code> </p> </li>
        /// <li> <p> <code>ActivatedRule</code>: Contains <code>Action</code>, <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case, you do not use <code>ActivatedRule|Action</code>. For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>. </p> </li>
        /// <li> <p> <code>WafAction</code>: Contains <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WebAclUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request doesn't match the criteria in any of the rules in a web ACL.</p>
        pub fn default_action(mut self, input: crate::model::WafAction) -> Self {
            self.inner = self.inner.default_action(input);
            self
        }
        /// <p>A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default action if a request doesn't match the criteria in any of the rules in a web ACL.</p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::WafAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.</p>
    /// <p> <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>XssMatchTuple</code> objects (filters) in an <code>XssMatchSet</code>. For each <code>XssMatchTuple</code> object, you specify the following values:</p>
    /// <ul>
    /// <li> <p> <code>Action</code>: Whether to insert the object into or delete the object from the array. To change an <code>XssMatchTuple</code>, you delete the existing object and add a new one.</p> </li>
    /// <li> <p> <code>FieldToMatch</code>: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.</p> </li>
    /// <li> <p> <code>TextTransformation</code>: Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.</p> <p>You can only specify a single type of TextTransformation.</p> </li>
    /// </ul>
    /// <p>You use <code>XssMatchSet</code> objects to specify which CloudFront requests that you want to allow, block, or count. For example, if you're receiving requests that contain cross-site scripting attacks in the request body and you want to block the requests, you can create an <code>XssMatchSet</code> with the applicable settings, and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure an <code>XssMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li> <p>Submit a <code>CreateXssMatchSet</code> request.</p> </li>
    /// <li> <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an <code>UpdateIPSet</code> request.</p> </li>
    /// <li> <p>Submit an <code>UpdateXssMatchSet</code> request to specify the parts of web requests that you want AWS WAF to inspect for cross-site scripting attacks.</p> </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateXssMatchSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_xss_match_set_input::Builder,
    }
    impl UpdateXssMatchSet {
        /// Creates a new `UpdateXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateXssMatchSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to update. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn xss_match_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.xss_match_set_id(input.into());
            self
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to update. <code>XssMatchSetId</code> is returned by <code>CreateXssMatchSet</code> and by <code>ListXssMatchSets</code>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_xss_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(input.into());
            self
        }
        /// <p>The value returned by the most recent call to <code>GetChangeToken</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>XssMatchSetUpdate</code> objects that you want to insert into or delete from an <code>XssMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>XssMatchSetUpdate</code>: Contains <code>Action</code> and <code>XssMatchTuple</code> </p> </li>
        /// <li> <p> <code>XssMatchTuple</code>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn updates(mut self, input: crate::model::XssMatchSetUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>An array of <code>XssMatchSetUpdate</code> objects that you want to insert into or delete from an <code>XssMatchSet</code>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li> <p> <code>XssMatchSetUpdate</code>: Contains <code>Action</code> and <code>XssMatchTuple</code> </p> </li>
        /// <li> <p> <code>XssMatchTuple</code>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::XssMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
