// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The response to an <code>UpdateXssMatchSets</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateXssMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateXssMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateXssMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateXssMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateXssMatchSetOutput`](crate::output::UpdateXssMatchSetOutput)
pub mod update_xss_match_set_output {
    /// A builder for [`UpdateXssMatchSetOutput`](crate::output::UpdateXssMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateXssMatchSetOutput`](crate::output::UpdateXssMatchSetOutput)
        pub fn build(self) -> crate::output::UpdateXssMatchSetOutput {
            crate::output::UpdateXssMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateXssMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateXssMatchSetOutput`](crate::output::UpdateXssMatchSetOutput)
    pub fn builder() -> crate::output::update_xss_match_set_output::Builder {
        crate::output::update_xss_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWebAclOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateWebAclOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateWebAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWebAclOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateWebAclOutput`](crate::output::UpdateWebAclOutput)
pub mod update_web_acl_output {
    /// A builder for [`UpdateWebAclOutput`](crate::output::UpdateWebAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWebAclOutput`](crate::output::UpdateWebAclOutput)
        pub fn build(self) -> crate::output::UpdateWebAclOutput {
            crate::output::UpdateWebAclOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateWebAclOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWebAclOutput`](crate::output::UpdateWebAclOutput)
    pub fn builder() -> crate::output::update_web_acl_output::Builder {
        crate::output::update_web_acl_output::Builder::default()
    }
}

/// <p>The response to an <code>UpdateSqlInjectionMatchSets</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSqlInjectionMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateSqlInjectionMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateSqlInjectionMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSqlInjectionMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateSqlInjectionMatchSetOutput`](crate::output::UpdateSqlInjectionMatchSetOutput)
pub mod update_sql_injection_match_set_output {
    /// A builder for [`UpdateSqlInjectionMatchSetOutput`](crate::output::UpdateSqlInjectionMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSqlInjectionMatchSetOutput`](crate::output::UpdateSqlInjectionMatchSetOutput)
        pub fn build(self) -> crate::output::UpdateSqlInjectionMatchSetOutput {
            crate::output::UpdateSqlInjectionMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateSqlInjectionMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSqlInjectionMatchSetOutput`](crate::output::UpdateSqlInjectionMatchSetOutput)
    pub fn builder() -> crate::output::update_sql_injection_match_set_output::Builder {
        crate::output::update_sql_injection_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSizeConstraintSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateSizeConstraintSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateSizeConstraintSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSizeConstraintSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateSizeConstraintSetOutput`](crate::output::UpdateSizeConstraintSetOutput)
pub mod update_size_constraint_set_output {
    /// A builder for [`UpdateSizeConstraintSetOutput`](crate::output::UpdateSizeConstraintSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSizeConstraintSetOutput`](crate::output::UpdateSizeConstraintSetOutput)
        pub fn build(self) -> crate::output::UpdateSizeConstraintSetOutput {
            crate::output::UpdateSizeConstraintSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateSizeConstraintSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSizeConstraintSetOutput`](crate::output::UpdateSizeConstraintSetOutput)
    pub fn builder() -> crate::output::update_size_constraint_set_output::Builder {
        crate::output::update_size_constraint_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleGroupOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateRuleGroupOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleGroupOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
pub mod update_rule_group_output {
    /// A builder for [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
        pub fn build(self) -> crate::output::UpdateRuleGroupOutput {
            crate::output::UpdateRuleGroupOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuleGroupOutput`](crate::output::UpdateRuleGroupOutput)
    pub fn builder() -> crate::output::update_rule_group_output::Builder {
        crate::output::update_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRuleOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
pub mod update_rule_output {
    /// A builder for [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
        pub fn build(self) -> crate::output::UpdateRuleOutput {
            crate::output::UpdateRuleOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRuleOutput`](crate::output::UpdateRuleOutput)
    pub fn builder() -> crate::output::update_rule_output::Builder {
        crate::output::update_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegexPatternSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateRegexPatternSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateRegexPatternSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegexPatternSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateRegexPatternSetOutput`](crate::output::UpdateRegexPatternSetOutput)
pub mod update_regex_pattern_set_output {
    /// A builder for [`UpdateRegexPatternSetOutput`](crate::output::UpdateRegexPatternSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRegexPatternSetOutput`](crate::output::UpdateRegexPatternSetOutput)
        pub fn build(self) -> crate::output::UpdateRegexPatternSetOutput {
            crate::output::UpdateRegexPatternSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateRegexPatternSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRegexPatternSetOutput`](crate::output::UpdateRegexPatternSetOutput)
    pub fn builder() -> crate::output::update_regex_pattern_set_output::Builder {
        crate::output::update_regex_pattern_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegexMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateRegexMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateRegexMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegexMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateRegexMatchSetOutput`](crate::output::UpdateRegexMatchSetOutput)
pub mod update_regex_match_set_output {
    /// A builder for [`UpdateRegexMatchSetOutput`](crate::output::UpdateRegexMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRegexMatchSetOutput`](crate::output::UpdateRegexMatchSetOutput)
        pub fn build(self) -> crate::output::UpdateRegexMatchSetOutput {
            crate::output::UpdateRegexMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateRegexMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRegexMatchSetOutput`](crate::output::UpdateRegexMatchSetOutput)
    pub fn builder() -> crate::output::update_regex_match_set_output::Builder {
        crate::output::update_regex_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRateBasedRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateRateBasedRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateRateBasedRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRateBasedRuleOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateRateBasedRuleOutput`](crate::output::UpdateRateBasedRuleOutput)
pub mod update_rate_based_rule_output {
    /// A builder for [`UpdateRateBasedRuleOutput`](crate::output::UpdateRateBasedRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRateBasedRuleOutput`](crate::output::UpdateRateBasedRuleOutput)
        pub fn build(self) -> crate::output::UpdateRateBasedRuleOutput {
            crate::output::UpdateRateBasedRuleOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateRateBasedRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRateBasedRuleOutput`](crate::output::UpdateRateBasedRuleOutput)
    pub fn builder() -> crate::output::update_rate_based_rule_output::Builder {
        crate::output::update_rate_based_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIpSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateIpSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateIpSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIpSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateIpSetOutput`](crate::output::UpdateIpSetOutput)
pub mod update_ip_set_output {
    /// A builder for [`UpdateIpSetOutput`](crate::output::UpdateIpSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIpSetOutput`](crate::output::UpdateIpSetOutput)
        pub fn build(self) -> crate::output::UpdateIpSetOutput {
            crate::output::UpdateIpSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateIpSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIpSetOutput`](crate::output::UpdateIpSetOutput)
    pub fn builder() -> crate::output::update_ip_set_output::Builder {
        crate::output::update_ip_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGeoMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateGeoMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateGeoMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGeoMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateGeoMatchSetOutput`](crate::output::UpdateGeoMatchSetOutput)
pub mod update_geo_match_set_output {
    /// A builder for [`UpdateGeoMatchSetOutput`](crate::output::UpdateGeoMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGeoMatchSetOutput`](crate::output::UpdateGeoMatchSetOutput)
        pub fn build(self) -> crate::output::UpdateGeoMatchSetOutput {
            crate::output::UpdateGeoMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateGeoMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGeoMatchSetOutput`](crate::output::UpdateGeoMatchSetOutput)
    pub fn builder() -> crate::output::update_geo_match_set_output::Builder {
        crate::output::update_geo_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateByteMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl UpdateByteMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateByteMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateByteMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`UpdateByteMatchSetOutput`](crate::output::UpdateByteMatchSetOutput)
pub mod update_byte_match_set_output {
    /// A builder for [`UpdateByteMatchSetOutput`](crate::output::UpdateByteMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>UpdateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateByteMatchSetOutput`](crate::output::UpdateByteMatchSetOutput)
        pub fn build(self) -> crate::output::UpdateByteMatchSetOutput {
            crate::output::UpdateByteMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl UpdateByteMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateByteMatchSetOutput`](crate::output::UpdateByteMatchSetOutput)
    pub fn builder() -> crate::output::update_byte_match_set_output::Builder {
        crate::output::update_byte_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPermissionPolicyOutput {}
impl std::fmt::Debug for PutPermissionPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPermissionPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutPermissionPolicyOutput`](crate::output::PutPermissionPolicyOutput)
pub mod put_permission_policy_output {
    /// A builder for [`PutPermissionPolicyOutput`](crate::output::PutPermissionPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutPermissionPolicyOutput`](crate::output::PutPermissionPolicyOutput)
        pub fn build(self) -> crate::output::PutPermissionPolicyOutput {
            crate::output::PutPermissionPolicyOutput {}
        }
    }
}
impl PutPermissionPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutPermissionPolicyOutput`](crate::output::PutPermissionPolicyOutput)
    pub fn builder() -> crate::output::put_permission_policy_output::Builder {
        crate::output::put_permission_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLoggingConfigurationOutput {
    /// <p>The <code>LoggingConfiguration</code> that you submitted in the request.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
}
impl PutLoggingConfigurationOutput {
    /// <p>The <code>LoggingConfiguration</code> that you submitted in the request.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutLoggingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLoggingConfigurationOutput");
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.finish()
    }
}
/// See [`PutLoggingConfigurationOutput`](crate::output::PutLoggingConfigurationOutput)
pub mod put_logging_configuration_output {
    /// A builder for [`PutLoggingConfigurationOutput`](crate::output::PutLoggingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    }
    impl Builder {
        /// <p>The <code>LoggingConfiguration</code> that you submitted in the request.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> that you submitted in the request.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLoggingConfigurationOutput`](crate::output::PutLoggingConfigurationOutput)
        pub fn build(self) -> crate::output::PutLoggingConfigurationOutput {
            crate::output::PutLoggingConfigurationOutput {
                logging_configuration: self.logging_configuration,
            }
        }
    }
}
impl PutLoggingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutLoggingConfigurationOutput`](crate::output::PutLoggingConfigurationOutput)
    pub fn builder() -> crate::output::put_logging_configuration_output::Builder {
        crate::output::put_logging_configuration_output::Builder::default()
    }
}

/// <p>The response to a <code>ListXssMatchSets</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListXssMatchSetsOutput {
    /// <p>If you have more <code>XssMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>XssMatchSet</code> objects, submit another <code>ListXssMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>XssMatchSetSummary</code> objects.</p>
    pub xss_match_sets: std::option::Option<std::vec::Vec<crate::model::XssMatchSetSummary>>,
}
impl ListXssMatchSetsOutput {
    /// <p>If you have more <code>XssMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>XssMatchSet</code> objects, submit another <code>ListXssMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>XssMatchSetSummary</code> objects.</p>
    pub fn xss_match_sets(&self) -> std::option::Option<&[crate::model::XssMatchSetSummary]> {
        self.xss_match_sets.as_deref()
    }
}
impl std::fmt::Debug for ListXssMatchSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListXssMatchSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("xss_match_sets", &self.xss_match_sets);
        formatter.finish()
    }
}
/// See [`ListXssMatchSetsOutput`](crate::output::ListXssMatchSetsOutput)
pub mod list_xss_match_sets_output {
    /// A builder for [`ListXssMatchSetsOutput`](crate::output::ListXssMatchSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) xss_match_sets:
            std::option::Option<std::vec::Vec<crate::model::XssMatchSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>XssMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>XssMatchSet</code> objects, submit another <code>ListXssMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>XssMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>XssMatchSet</code> objects, submit another <code>ListXssMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `xss_match_sets`.
        ///
        /// To override the contents of this collection use [`set_xss_match_sets`](Self::set_xss_match_sets).
        ///
        /// <p>An array of <code>XssMatchSetSummary</code> objects.</p>
        pub fn xss_match_sets(mut self, input: crate::model::XssMatchSetSummary) -> Self {
            let mut v = self.xss_match_sets.unwrap_or_default();
            v.push(input);
            self.xss_match_sets = Some(v);
            self
        }
        /// <p>An array of <code>XssMatchSetSummary</code> objects.</p>
        pub fn set_xss_match_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::XssMatchSetSummary>>,
        ) -> Self {
            self.xss_match_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListXssMatchSetsOutput`](crate::output::ListXssMatchSetsOutput)
        pub fn build(self) -> crate::output::ListXssMatchSetsOutput {
            crate::output::ListXssMatchSetsOutput {
                next_marker: self.next_marker,
                xss_match_sets: self.xss_match_sets,
            }
        }
    }
}
impl ListXssMatchSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListXssMatchSetsOutput`](crate::output::ListXssMatchSetsOutput)
    pub fn builder() -> crate::output::list_xss_match_sets_output::Builder {
        crate::output::list_xss_match_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWebAcLsOutput {
    /// <p>If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>WebACLSummary</code> objects.</p>
    pub web_ac_ls: std::option::Option<std::vec::Vec<crate::model::WebAclSummary>>,
}
impl ListWebAcLsOutput {
    /// <p>If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>WebACLSummary</code> objects.</p>
    pub fn web_ac_ls(&self) -> std::option::Option<&[crate::model::WebAclSummary]> {
        self.web_ac_ls.as_deref()
    }
}
impl std::fmt::Debug for ListWebAcLsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWebAcLsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("web_ac_ls", &self.web_ac_ls);
        formatter.finish()
    }
}
/// See [`ListWebAcLsOutput`](crate::output::ListWebAcLsOutput)
pub mod list_web_ac_ls_output {
    /// A builder for [`ListWebAcLsOutput`](crate::output::ListWebAcLsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) web_ac_ls: std::option::Option<std::vec::Vec<crate::model::WebAclSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>WebACL</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit another <code>ListWebACLs</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `web_ac_ls`.
        ///
        /// To override the contents of this collection use [`set_web_ac_ls`](Self::set_web_ac_ls).
        ///
        /// <p>An array of <code>WebACLSummary</code> objects.</p>
        pub fn web_ac_ls(mut self, input: crate::model::WebAclSummary) -> Self {
            let mut v = self.web_ac_ls.unwrap_or_default();
            v.push(input);
            self.web_ac_ls = Some(v);
            self
        }
        /// <p>An array of <code>WebACLSummary</code> objects.</p>
        pub fn set_web_ac_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WebAclSummary>>,
        ) -> Self {
            self.web_ac_ls = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWebAcLsOutput`](crate::output::ListWebAcLsOutput)
        pub fn build(self) -> crate::output::ListWebAcLsOutput {
            crate::output::ListWebAcLsOutput {
                next_marker: self.next_marker,
                web_ac_ls: self.web_ac_ls,
            }
        }
    }
}
impl ListWebAcLsOutput {
    /// Creates a new builder-style object to manufacture [`ListWebAcLsOutput`](crate::output::ListWebAcLsOutput)
    pub fn builder() -> crate::output::list_web_ac_ls_output::Builder {
        crate::output::list_web_ac_ls_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p></p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p></p>
    pub tag_info_for_resource: std::option::Option<crate::model::TagInfoForResource>,
}
impl ListTagsForResourceOutput {
    /// <p></p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p></p>
    pub fn tag_info_for_resource(&self) -> std::option::Option<&crate::model::TagInfoForResource> {
        self.tag_info_for_resource.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("tag_info_for_resource", &self.tag_info_for_resource);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) tag_info_for_resource: std::option::Option<crate::model::TagInfoForResource>,
    }
    impl Builder {
        /// <p></p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p></p>
        pub fn tag_info_for_resource(mut self, input: crate::model::TagInfoForResource) -> Self {
            self.tag_info_for_resource = Some(input);
            self
        }
        /// <p></p>
        pub fn set_tag_info_for_resource(
            mut self,
            input: std::option::Option<crate::model::TagInfoForResource>,
        ) -> Self {
            self.tag_info_for_resource = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                next_marker: self.next_marker,
                tag_info_for_resource: self.tag_info_for_resource,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSubscribedRuleGroupsOutput {
    /// <p>If you have more objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more objects, submit another <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>RuleGroup</code> objects.</p>
    pub rule_groups: std::option::Option<std::vec::Vec<crate::model::SubscribedRuleGroupSummary>>,
}
impl ListSubscribedRuleGroupsOutput {
    /// <p>If you have more objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more objects, submit another <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>RuleGroup</code> objects.</p>
    pub fn rule_groups(&self) -> std::option::Option<&[crate::model::SubscribedRuleGroupSummary]> {
        self.rule_groups.as_deref()
    }
}
impl std::fmt::Debug for ListSubscribedRuleGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSubscribedRuleGroupsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("rule_groups", &self.rule_groups);
        formatter.finish()
    }
}
/// See [`ListSubscribedRuleGroupsOutput`](crate::output::ListSubscribedRuleGroupsOutput)
pub mod list_subscribed_rule_groups_output {
    /// A builder for [`ListSubscribedRuleGroupsOutput`](crate::output::ListSubscribedRuleGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) rule_groups:
            std::option::Option<std::vec::Vec<crate::model::SubscribedRuleGroupSummary>>,
    }
    impl Builder {
        /// <p>If you have more objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more objects, submit another <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more objects, submit another <code>ListSubscribedRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `rule_groups`.
        ///
        /// To override the contents of this collection use [`set_rule_groups`](Self::set_rule_groups).
        ///
        /// <p>An array of <code>RuleGroup</code> objects.</p>
        pub fn rule_groups(mut self, input: crate::model::SubscribedRuleGroupSummary) -> Self {
            let mut v = self.rule_groups.unwrap_or_default();
            v.push(input);
            self.rule_groups = Some(v);
            self
        }
        /// <p>An array of <code>RuleGroup</code> objects.</p>
        pub fn set_rule_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubscribedRuleGroupSummary>>,
        ) -> Self {
            self.rule_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSubscribedRuleGroupsOutput`](crate::output::ListSubscribedRuleGroupsOutput)
        pub fn build(self) -> crate::output::ListSubscribedRuleGroupsOutput {
            crate::output::ListSubscribedRuleGroupsOutput {
                next_marker: self.next_marker,
                rule_groups: self.rule_groups,
            }
        }
    }
}
impl ListSubscribedRuleGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListSubscribedRuleGroupsOutput`](crate::output::ListSubscribedRuleGroupsOutput)
    pub fn builder() -> crate::output::list_subscribed_rule_groups_output::Builder {
        crate::output::list_subscribed_rule_groups_output::Builder::default()
    }
}

/// <p>The response to a <code>ListSqlInjectionMatchSets</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSqlInjectionMatchSetsOutput {
    /// <p>If you have more <code>SqlInjectionMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SqlInjectionMatchSet</code> objects, submit another <code>ListSqlInjectionMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>SqlInjectionMatchSetSummary</code> objects.</p>
    pub sql_injection_match_sets:
        std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchSetSummary>>,
}
impl ListSqlInjectionMatchSetsOutput {
    /// <p>If you have more <code>SqlInjectionMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SqlInjectionMatchSet</code> objects, submit another <code>ListSqlInjectionMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>SqlInjectionMatchSetSummary</code> objects.</p>
    pub fn sql_injection_match_sets(
        &self,
    ) -> std::option::Option<&[crate::model::SqlInjectionMatchSetSummary]> {
        self.sql_injection_match_sets.as_deref()
    }
}
impl std::fmt::Debug for ListSqlInjectionMatchSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSqlInjectionMatchSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("sql_injection_match_sets", &self.sql_injection_match_sets);
        formatter.finish()
    }
}
/// See [`ListSqlInjectionMatchSetsOutput`](crate::output::ListSqlInjectionMatchSetsOutput)
pub mod list_sql_injection_match_sets_output {
    /// A builder for [`ListSqlInjectionMatchSetsOutput`](crate::output::ListSqlInjectionMatchSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) sql_injection_match_sets:
            std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>SqlInjectionMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SqlInjectionMatchSet</code> objects, submit another <code>ListSqlInjectionMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>SqlInjectionMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SqlInjectionMatchSet</code> objects, submit another <code>ListSqlInjectionMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `sql_injection_match_sets`.
        ///
        /// To override the contents of this collection use [`set_sql_injection_match_sets`](Self::set_sql_injection_match_sets).
        ///
        /// <p>An array of <code>SqlInjectionMatchSetSummary</code> objects.</p>
        pub fn sql_injection_match_sets(
            mut self,
            input: crate::model::SqlInjectionMatchSetSummary,
        ) -> Self {
            let mut v = self.sql_injection_match_sets.unwrap_or_default();
            v.push(input);
            self.sql_injection_match_sets = Some(v);
            self
        }
        /// <p>An array of <code>SqlInjectionMatchSetSummary</code> objects.</p>
        pub fn set_sql_injection_match_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchSetSummary>>,
        ) -> Self {
            self.sql_injection_match_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSqlInjectionMatchSetsOutput`](crate::output::ListSqlInjectionMatchSetsOutput)
        pub fn build(self) -> crate::output::ListSqlInjectionMatchSetsOutput {
            crate::output::ListSqlInjectionMatchSetsOutput {
                next_marker: self.next_marker,
                sql_injection_match_sets: self.sql_injection_match_sets,
            }
        }
    }
}
impl ListSqlInjectionMatchSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListSqlInjectionMatchSetsOutput`](crate::output::ListSqlInjectionMatchSetsOutput)
    pub fn builder() -> crate::output::list_sql_injection_match_sets_output::Builder {
        crate::output::list_sql_injection_match_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSizeConstraintSetsOutput {
    /// <p>If you have more <code>SizeConstraintSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SizeConstraintSet</code> objects, submit another <code>ListSizeConstraintSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>SizeConstraintSetSummary</code> objects.</p>
    pub size_constraint_sets:
        std::option::Option<std::vec::Vec<crate::model::SizeConstraintSetSummary>>,
}
impl ListSizeConstraintSetsOutput {
    /// <p>If you have more <code>SizeConstraintSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SizeConstraintSet</code> objects, submit another <code>ListSizeConstraintSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>SizeConstraintSetSummary</code> objects.</p>
    pub fn size_constraint_sets(
        &self,
    ) -> std::option::Option<&[crate::model::SizeConstraintSetSummary]> {
        self.size_constraint_sets.as_deref()
    }
}
impl std::fmt::Debug for ListSizeConstraintSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSizeConstraintSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("size_constraint_sets", &self.size_constraint_sets);
        formatter.finish()
    }
}
/// See [`ListSizeConstraintSetsOutput`](crate::output::ListSizeConstraintSetsOutput)
pub mod list_size_constraint_sets_output {
    /// A builder for [`ListSizeConstraintSetsOutput`](crate::output::ListSizeConstraintSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) size_constraint_sets:
            std::option::Option<std::vec::Vec<crate::model::SizeConstraintSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>SizeConstraintSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SizeConstraintSet</code> objects, submit another <code>ListSizeConstraintSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>SizeConstraintSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>SizeConstraintSet</code> objects, submit another <code>ListSizeConstraintSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `size_constraint_sets`.
        ///
        /// To override the contents of this collection use [`set_size_constraint_sets`](Self::set_size_constraint_sets).
        ///
        /// <p>An array of <code>SizeConstraintSetSummary</code> objects.</p>
        pub fn size_constraint_sets(
            mut self,
            input: crate::model::SizeConstraintSetSummary,
        ) -> Self {
            let mut v = self.size_constraint_sets.unwrap_or_default();
            v.push(input);
            self.size_constraint_sets = Some(v);
            self
        }
        /// <p>An array of <code>SizeConstraintSetSummary</code> objects.</p>
        pub fn set_size_constraint_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SizeConstraintSetSummary>>,
        ) -> Self {
            self.size_constraint_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSizeConstraintSetsOutput`](crate::output::ListSizeConstraintSetsOutput)
        pub fn build(self) -> crate::output::ListSizeConstraintSetsOutput {
            crate::output::ListSizeConstraintSetsOutput {
                next_marker: self.next_marker,
                size_constraint_sets: self.size_constraint_sets,
            }
        }
    }
}
impl ListSizeConstraintSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListSizeConstraintSetsOutput`](crate::output::ListSizeConstraintSetsOutput)
    pub fn builder() -> crate::output::list_size_constraint_sets_output::Builder {
        crate::output::list_size_constraint_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesOutput {
    /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>RuleSummary</code> objects.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
}
impl ListRulesOutput {
    /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>RuleSummary</code> objects.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::RuleSummary]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for ListRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`ListRulesOutput`](crate::output::ListRulesOutput)
pub mod list_rules_output {
    /// A builder for [`ListRulesOutput`](crate::output::ListRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of <code>RuleSummary</code> objects.</p>
        pub fn rules(mut self, input: crate::model::RuleSummary) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>An array of <code>RuleSummary</code> objects.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesOutput`](crate::output::ListRulesOutput)
        pub fn build(self) -> crate::output::ListRulesOutput {
            crate::output::ListRulesOutput {
                next_marker: self.next_marker,
                rules: self.rules,
            }
        }
    }
}
impl ListRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListRulesOutput`](crate::output::ListRulesOutput)
    pub fn builder() -> crate::output::list_rules_output::Builder {
        crate::output::list_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRuleGroupsOutput {
    /// <p>If you have more <code>RuleGroups</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RuleGroups</code>, submit another <code>ListRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>RuleGroup</code> objects.</p>
    pub rule_groups: std::option::Option<std::vec::Vec<crate::model::RuleGroupSummary>>,
}
impl ListRuleGroupsOutput {
    /// <p>If you have more <code>RuleGroups</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RuleGroups</code>, submit another <code>ListRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>RuleGroup</code> objects.</p>
    pub fn rule_groups(&self) -> std::option::Option<&[crate::model::RuleGroupSummary]> {
        self.rule_groups.as_deref()
    }
}
impl std::fmt::Debug for ListRuleGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRuleGroupsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("rule_groups", &self.rule_groups);
        formatter.finish()
    }
}
/// See [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
pub mod list_rule_groups_output {
    /// A builder for [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) rule_groups: std::option::Option<std::vec::Vec<crate::model::RuleGroupSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>RuleGroups</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RuleGroups</code>, submit another <code>ListRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>RuleGroups</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RuleGroups</code>, submit another <code>ListRuleGroups</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `rule_groups`.
        ///
        /// To override the contents of this collection use [`set_rule_groups`](Self::set_rule_groups).
        ///
        /// <p>An array of <code>RuleGroup</code> objects.</p>
        pub fn rule_groups(mut self, input: crate::model::RuleGroupSummary) -> Self {
            let mut v = self.rule_groups.unwrap_or_default();
            v.push(input);
            self.rule_groups = Some(v);
            self
        }
        /// <p>An array of <code>RuleGroup</code> objects.</p>
        pub fn set_rule_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleGroupSummary>>,
        ) -> Self {
            self.rule_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
        pub fn build(self) -> crate::output::ListRuleGroupsOutput {
            crate::output::ListRuleGroupsOutput {
                next_marker: self.next_marker,
                rule_groups: self.rule_groups,
            }
        }
    }
}
impl ListRuleGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListRuleGroupsOutput`](crate::output::ListRuleGroupsOutput)
    pub fn builder() -> crate::output::list_rule_groups_output::Builder {
        crate::output::list_rule_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegexPatternSetsOutput {
    /// <p>If you have more <code>RegexPatternSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>RegexPatternSetSummary</code> objects.</p>
    pub regex_pattern_sets:
        std::option::Option<std::vec::Vec<crate::model::RegexPatternSetSummary>>,
}
impl ListRegexPatternSetsOutput {
    /// <p>If you have more <code>RegexPatternSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>RegexPatternSetSummary</code> objects.</p>
    pub fn regex_pattern_sets(
        &self,
    ) -> std::option::Option<&[crate::model::RegexPatternSetSummary]> {
        self.regex_pattern_sets.as_deref()
    }
}
impl std::fmt::Debug for ListRegexPatternSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegexPatternSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("regex_pattern_sets", &self.regex_pattern_sets);
        formatter.finish()
    }
}
/// See [`ListRegexPatternSetsOutput`](crate::output::ListRegexPatternSetsOutput)
pub mod list_regex_pattern_sets_output {
    /// A builder for [`ListRegexPatternSetsOutput`](crate::output::ListRegexPatternSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) regex_pattern_sets:
            std::option::Option<std::vec::Vec<crate::model::RegexPatternSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>RegexPatternSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>RegexPatternSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexPatternSet</code> objects, submit another <code>ListRegexPatternSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `regex_pattern_sets`.
        ///
        /// To override the contents of this collection use [`set_regex_pattern_sets`](Self::set_regex_pattern_sets).
        ///
        /// <p>An array of <code>RegexPatternSetSummary</code> objects.</p>
        pub fn regex_pattern_sets(mut self, input: crate::model::RegexPatternSetSummary) -> Self {
            let mut v = self.regex_pattern_sets.unwrap_or_default();
            v.push(input);
            self.regex_pattern_sets = Some(v);
            self
        }
        /// <p>An array of <code>RegexPatternSetSummary</code> objects.</p>
        pub fn set_regex_pattern_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexPatternSetSummary>>,
        ) -> Self {
            self.regex_pattern_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegexPatternSetsOutput`](crate::output::ListRegexPatternSetsOutput)
        pub fn build(self) -> crate::output::ListRegexPatternSetsOutput {
            crate::output::ListRegexPatternSetsOutput {
                next_marker: self.next_marker,
                regex_pattern_sets: self.regex_pattern_sets,
            }
        }
    }
}
impl ListRegexPatternSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListRegexPatternSetsOutput`](crate::output::ListRegexPatternSetsOutput)
    pub fn builder() -> crate::output::list_regex_pattern_sets_output::Builder {
        crate::output::list_regex_pattern_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegexMatchSetsOutput {
    /// <p>If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>RegexMatchSetSummary</code> objects.</p>
    pub regex_match_sets: std::option::Option<std::vec::Vec<crate::model::RegexMatchSetSummary>>,
}
impl ListRegexMatchSetsOutput {
    /// <p>If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>RegexMatchSetSummary</code> objects.</p>
    pub fn regex_match_sets(&self) -> std::option::Option<&[crate::model::RegexMatchSetSummary]> {
        self.regex_match_sets.as_deref()
    }
}
impl std::fmt::Debug for ListRegexMatchSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegexMatchSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("regex_match_sets", &self.regex_match_sets);
        formatter.finish()
    }
}
/// See [`ListRegexMatchSetsOutput`](crate::output::ListRegexMatchSetsOutput)
pub mod list_regex_match_sets_output {
    /// A builder for [`ListRegexMatchSetsOutput`](crate::output::ListRegexMatchSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) regex_match_sets:
            std::option::Option<std::vec::Vec<crate::model::RegexMatchSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>RegexMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>RegexMatchSet</code> objects, submit another <code>ListRegexMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `regex_match_sets`.
        ///
        /// To override the contents of this collection use [`set_regex_match_sets`](Self::set_regex_match_sets).
        ///
        /// <p>An array of <code>RegexMatchSetSummary</code> objects.</p>
        pub fn regex_match_sets(mut self, input: crate::model::RegexMatchSetSummary) -> Self {
            let mut v = self.regex_match_sets.unwrap_or_default();
            v.push(input);
            self.regex_match_sets = Some(v);
            self
        }
        /// <p>An array of <code>RegexMatchSetSummary</code> objects.</p>
        pub fn set_regex_match_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexMatchSetSummary>>,
        ) -> Self {
            self.regex_match_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegexMatchSetsOutput`](crate::output::ListRegexMatchSetsOutput)
        pub fn build(self) -> crate::output::ListRegexMatchSetsOutput {
            crate::output::ListRegexMatchSetsOutput {
                next_marker: self.next_marker,
                regex_match_sets: self.regex_match_sets,
            }
        }
    }
}
impl ListRegexMatchSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListRegexMatchSetsOutput`](crate::output::ListRegexMatchSetsOutput)
    pub fn builder() -> crate::output::list_regex_match_sets_output::Builder {
        crate::output::list_regex_match_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRateBasedRulesOutput {
    /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRateBasedRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>RuleSummary</code> objects.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
}
impl ListRateBasedRulesOutput {
    /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRateBasedRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>RuleSummary</code> objects.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::RuleSummary]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for ListRateBasedRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRateBasedRulesOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`ListRateBasedRulesOutput`](crate::output::ListRateBasedRulesOutput)
pub mod list_rate_based_rules_output {
    /// A builder for [`ListRateBasedRulesOutput`](crate::output::ListRateBasedRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRateBasedRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>Rules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>Rules</code>, submit another <code>ListRateBasedRules</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>An array of <code>RuleSummary</code> objects.</p>
        pub fn rules(mut self, input: crate::model::RuleSummary) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>An array of <code>RuleSummary</code> objects.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleSummary>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRateBasedRulesOutput`](crate::output::ListRateBasedRulesOutput)
        pub fn build(self) -> crate::output::ListRateBasedRulesOutput {
            crate::output::ListRateBasedRulesOutput {
                next_marker: self.next_marker,
                rules: self.rules,
            }
        }
    }
}
impl ListRateBasedRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListRateBasedRulesOutput`](crate::output::ListRateBasedRulesOutput)
    pub fn builder() -> crate::output::list_rate_based_rules_output::Builder {
        crate::output::list_rate_based_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLoggingConfigurationsOutput {
    /// <p>An array of <code>LoggingConfiguration</code> objects.</p>
    pub logging_configurations:
        std::option::Option<std::vec::Vec<crate::model::LoggingConfiguration>>,
    /// <p>If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListLoggingConfigurationsOutput {
    /// <p>An array of <code>LoggingConfiguration</code> objects.</p>
    pub fn logging_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LoggingConfiguration]> {
        self.logging_configurations.as_deref()
    }
    /// <p>If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListLoggingConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLoggingConfigurationsOutput");
        formatter.field("logging_configurations", &self.logging_configurations);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListLoggingConfigurationsOutput`](crate::output::ListLoggingConfigurationsOutput)
pub mod list_logging_configurations_output {
    /// A builder for [`ListLoggingConfigurationsOutput`](crate::output::ListLoggingConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_configurations:
            std::option::Option<std::vec::Vec<crate::model::LoggingConfiguration>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `logging_configurations`.
        ///
        /// To override the contents of this collection use [`set_logging_configurations`](Self::set_logging_configurations).
        ///
        /// <p>An array of <code>LoggingConfiguration</code> objects.</p>
        pub fn logging_configurations(mut self, input: crate::model::LoggingConfiguration) -> Self {
            let mut v = self.logging_configurations.unwrap_or_default();
            v.push(input);
            self.logging_configurations = Some(v);
            self
        }
        /// <p>An array of <code>LoggingConfiguration</code> objects.</p>
        pub fn set_logging_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoggingConfiguration>>,
        ) -> Self {
            self.logging_configurations = input;
            self
        }
        /// <p>If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>LoggingConfigurations</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>LoggingConfigurations</code>, submit another <code>ListLoggingConfigurations</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLoggingConfigurationsOutput`](crate::output::ListLoggingConfigurationsOutput)
        pub fn build(self) -> crate::output::ListLoggingConfigurationsOutput {
            crate::output::ListLoggingConfigurationsOutput {
                logging_configurations: self.logging_configurations,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListLoggingConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListLoggingConfigurationsOutput`](crate::output::ListLoggingConfigurationsOutput)
    pub fn builder() -> crate::output::list_logging_configurations_output::Builder {
        crate::output::list_logging_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIpSetsOutput {
    /// <p>To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>IPSetSummary</code> objects.</p>
    pub ip_sets: std::option::Option<std::vec::Vec<crate::model::IpSetSummary>>,
}
impl ListIpSetsOutput {
    /// <p>To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>IPSetSummary</code> objects.</p>
    pub fn ip_sets(&self) -> std::option::Option<&[crate::model::IpSetSummary]> {
        self.ip_sets.as_deref()
    }
}
impl std::fmt::Debug for ListIpSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIpSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("ip_sets", &self.ip_sets);
        formatter.finish()
    }
}
/// See [`ListIpSetsOutput`](crate::output::ListIpSetsOutput)
pub mod list_ip_sets_output {
    /// A builder for [`ListIpSetsOutput`](crate::output::ListIpSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) ip_sets: std::option::Option<std::vec::Vec<crate::model::IpSetSummary>>,
    }
    impl Builder {
        /// <p>To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>To list more <code>IPSet</code> objects, submit another <code>ListIPSets</code> request, and in the next request use the <code>NextMarker</code> response value as the <code>NextMarker</code> value.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `ip_sets`.
        ///
        /// To override the contents of this collection use [`set_ip_sets`](Self::set_ip_sets).
        ///
        /// <p>An array of <code>IPSetSummary</code> objects.</p>
        pub fn ip_sets(mut self, input: crate::model::IpSetSummary) -> Self {
            let mut v = self.ip_sets.unwrap_or_default();
            v.push(input);
            self.ip_sets = Some(v);
            self
        }
        /// <p>An array of <code>IPSetSummary</code> objects.</p>
        pub fn set_ip_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpSetSummary>>,
        ) -> Self {
            self.ip_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIpSetsOutput`](crate::output::ListIpSetsOutput)
        pub fn build(self) -> crate::output::ListIpSetsOutput {
            crate::output::ListIpSetsOutput {
                next_marker: self.next_marker,
                ip_sets: self.ip_sets,
            }
        }
    }
}
impl ListIpSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListIpSetsOutput`](crate::output::ListIpSetsOutput)
    pub fn builder() -> crate::output::list_ip_sets_output::Builder {
        crate::output::list_ip_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeoMatchSetsOutput {
    /// <p>If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>GeoMatchSetSummary</code> objects.</p>
    pub geo_match_sets: std::option::Option<std::vec::Vec<crate::model::GeoMatchSetSummary>>,
}
impl ListGeoMatchSetsOutput {
    /// <p>If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>GeoMatchSetSummary</code> objects.</p>
    pub fn geo_match_sets(&self) -> std::option::Option<&[crate::model::GeoMatchSetSummary]> {
        self.geo_match_sets.as_deref()
    }
}
impl std::fmt::Debug for ListGeoMatchSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeoMatchSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("geo_match_sets", &self.geo_match_sets);
        formatter.finish()
    }
}
/// See [`ListGeoMatchSetsOutput`](crate::output::ListGeoMatchSetsOutput)
pub mod list_geo_match_sets_output {
    /// A builder for [`ListGeoMatchSetsOutput`](crate::output::ListGeoMatchSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) geo_match_sets:
            std::option::Option<std::vec::Vec<crate::model::GeoMatchSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>GeoMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>GeoMatchSet</code> objects, submit another <code>ListGeoMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `geo_match_sets`.
        ///
        /// To override the contents of this collection use [`set_geo_match_sets`](Self::set_geo_match_sets).
        ///
        /// <p>An array of <code>GeoMatchSetSummary</code> objects.</p>
        pub fn geo_match_sets(mut self, input: crate::model::GeoMatchSetSummary) -> Self {
            let mut v = self.geo_match_sets.unwrap_or_default();
            v.push(input);
            self.geo_match_sets = Some(v);
            self
        }
        /// <p>An array of <code>GeoMatchSetSummary</code> objects.</p>
        pub fn set_geo_match_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeoMatchSetSummary>>,
        ) -> Self {
            self.geo_match_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeoMatchSetsOutput`](crate::output::ListGeoMatchSetsOutput)
        pub fn build(self) -> crate::output::ListGeoMatchSetsOutput {
            crate::output::ListGeoMatchSetsOutput {
                next_marker: self.next_marker,
                geo_match_sets: self.geo_match_sets,
            }
        }
    }
}
impl ListGeoMatchSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListGeoMatchSetsOutput`](crate::output::ListGeoMatchSetsOutput)
    pub fn builder() -> crate::output::list_geo_match_sets_output::Builder {
        crate::output::list_geo_match_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListByteMatchSetsOutput {
    /// <p>If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>ByteMatchSetSummary</code> objects.</p>
    pub byte_match_sets: std::option::Option<std::vec::Vec<crate::model::ByteMatchSetSummary>>,
}
impl ListByteMatchSetsOutput {
    /// <p>If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>ByteMatchSetSummary</code> objects.</p>
    pub fn byte_match_sets(&self) -> std::option::Option<&[crate::model::ByteMatchSetSummary]> {
        self.byte_match_sets.as_deref()
    }
}
impl std::fmt::Debug for ListByteMatchSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListByteMatchSetsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("byte_match_sets", &self.byte_match_sets);
        formatter.finish()
    }
}
/// See [`ListByteMatchSetsOutput`](crate::output::ListByteMatchSetsOutput)
pub mod list_byte_match_sets_output {
    /// A builder for [`ListByteMatchSetsOutput`](crate::output::ListByteMatchSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) byte_match_sets:
            std::option::Option<std::vec::Vec<crate::model::ByteMatchSetSummary>>,
    }
    impl Builder {
        /// <p>If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>ByteMatchSet</code> objects than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ByteMatchSet</code> objects, submit another <code>ListByteMatchSets</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `byte_match_sets`.
        ///
        /// To override the contents of this collection use [`set_byte_match_sets`](Self::set_byte_match_sets).
        ///
        /// <p>An array of <code>ByteMatchSetSummary</code> objects.</p>
        pub fn byte_match_sets(mut self, input: crate::model::ByteMatchSetSummary) -> Self {
            let mut v = self.byte_match_sets.unwrap_or_default();
            v.push(input);
            self.byte_match_sets = Some(v);
            self
        }
        /// <p>An array of <code>ByteMatchSetSummary</code> objects.</p>
        pub fn set_byte_match_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ByteMatchSetSummary>>,
        ) -> Self {
            self.byte_match_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListByteMatchSetsOutput`](crate::output::ListByteMatchSetsOutput)
        pub fn build(self) -> crate::output::ListByteMatchSetsOutput {
            crate::output::ListByteMatchSetsOutput {
                next_marker: self.next_marker,
                byte_match_sets: self.byte_match_sets,
            }
        }
    }
}
impl ListByteMatchSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListByteMatchSetsOutput`](crate::output::ListByteMatchSetsOutput)
    pub fn builder() -> crate::output::list_byte_match_sets_output::Builder {
        crate::output::list_byte_match_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActivatedRulesInRuleGroupOutput {
    /// <p>If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>An array of <code>ActivatedRules</code> objects.</p>
    pub activated_rules: std::option::Option<std::vec::Vec<crate::model::ActivatedRule>>,
}
impl ListActivatedRulesInRuleGroupOutput {
    /// <p>If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>An array of <code>ActivatedRules</code> objects.</p>
    pub fn activated_rules(&self) -> std::option::Option<&[crate::model::ActivatedRule]> {
        self.activated_rules.as_deref()
    }
}
impl std::fmt::Debug for ListActivatedRulesInRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActivatedRulesInRuleGroupOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("activated_rules", &self.activated_rules);
        formatter.finish()
    }
}
/// See [`ListActivatedRulesInRuleGroupOutput`](crate::output::ListActivatedRulesInRuleGroupOutput)
pub mod list_activated_rules_in_rule_group_output {
    /// A builder for [`ListActivatedRulesInRuleGroupOutput`](crate::output::ListActivatedRulesInRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) activated_rules: std::option::Option<std::vec::Vec<crate::model::ActivatedRule>>,
    }
    impl Builder {
        /// <p>If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If you have more <code>ActivatedRules</code> than the number that you specified for <code>Limit</code> in the request, the response includes a <code>NextMarker</code> value. To list more <code>ActivatedRules</code>, submit another <code>ListActivatedRulesInRuleGroup</code> request, and specify the <code>NextMarker</code> value from the response in the <code>NextMarker</code> value in the next request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `activated_rules`.
        ///
        /// To override the contents of this collection use [`set_activated_rules`](Self::set_activated_rules).
        ///
        /// <p>An array of <code>ActivatedRules</code> objects.</p>
        pub fn activated_rules(mut self, input: crate::model::ActivatedRule) -> Self {
            let mut v = self.activated_rules.unwrap_or_default();
            v.push(input);
            self.activated_rules = Some(v);
            self
        }
        /// <p>An array of <code>ActivatedRules</code> objects.</p>
        pub fn set_activated_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActivatedRule>>,
        ) -> Self {
            self.activated_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActivatedRulesInRuleGroupOutput`](crate::output::ListActivatedRulesInRuleGroupOutput)
        pub fn build(self) -> crate::output::ListActivatedRulesInRuleGroupOutput {
            crate::output::ListActivatedRulesInRuleGroupOutput {
                next_marker: self.next_marker,
                activated_rules: self.activated_rules,
            }
        }
    }
}
impl ListActivatedRulesInRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`ListActivatedRulesInRuleGroupOutput`](crate::output::ListActivatedRulesInRuleGroupOutput)
    pub fn builder() -> crate::output::list_activated_rules_in_rule_group_output::Builder {
        crate::output::list_activated_rules_in_rule_group_output::Builder::default()
    }
}

/// <p>The response to a <code>GetXssMatchSet</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetXssMatchSetOutput {
    /// <p>Information about the <code>XssMatchSet</code> that you specified in the <code>GetXssMatchSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>XssMatchSet</code>: Contains <code>Name</code>, <code>XssMatchSetId</code>, and an array of <code>XssMatchTuple</code> objects</p> </li>
    /// <li> <p> <code>XssMatchTuple</code>: Each <code>XssMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub xss_match_set: std::option::Option<crate::model::XssMatchSet>,
}
impl GetXssMatchSetOutput {
    /// <p>Information about the <code>XssMatchSet</code> that you specified in the <code>GetXssMatchSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>XssMatchSet</code>: Contains <code>Name</code>, <code>XssMatchSetId</code>, and an array of <code>XssMatchTuple</code> objects</p> </li>
    /// <li> <p> <code>XssMatchTuple</code>: Each <code>XssMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub fn xss_match_set(&self) -> std::option::Option<&crate::model::XssMatchSet> {
        self.xss_match_set.as_ref()
    }
}
impl std::fmt::Debug for GetXssMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetXssMatchSetOutput");
        formatter.field("xss_match_set", &self.xss_match_set);
        formatter.finish()
    }
}
/// See [`GetXssMatchSetOutput`](crate::output::GetXssMatchSetOutput)
pub mod get_xss_match_set_output {
    /// A builder for [`GetXssMatchSetOutput`](crate::output::GetXssMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xss_match_set: std::option::Option<crate::model::XssMatchSet>,
    }
    impl Builder {
        /// <p>Information about the <code>XssMatchSet</code> that you specified in the <code>GetXssMatchSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>XssMatchSet</code>: Contains <code>Name</code>, <code>XssMatchSetId</code>, and an array of <code>XssMatchTuple</code> objects</p> </li>
        /// <li> <p> <code>XssMatchTuple</code>: Each <code>XssMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn xss_match_set(mut self, input: crate::model::XssMatchSet) -> Self {
            self.xss_match_set = Some(input);
            self
        }
        /// <p>Information about the <code>XssMatchSet</code> that you specified in the <code>GetXssMatchSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>XssMatchSet</code>: Contains <code>Name</code>, <code>XssMatchSetId</code>, and an array of <code>XssMatchTuple</code> objects</p> </li>
        /// <li> <p> <code>XssMatchTuple</code>: Each <code>XssMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_xss_match_set(
            mut self,
            input: std::option::Option<crate::model::XssMatchSet>,
        ) -> Self {
            self.xss_match_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetXssMatchSetOutput`](crate::output::GetXssMatchSetOutput)
        pub fn build(self) -> crate::output::GetXssMatchSetOutput {
            crate::output::GetXssMatchSetOutput {
                xss_match_set: self.xss_match_set,
            }
        }
    }
}
impl GetXssMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`GetXssMatchSetOutput`](crate::output::GetXssMatchSetOutput)
    pub fn builder() -> crate::output::get_xss_match_set_output::Builder {
        crate::output::get_xss_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWebAclOutput {
    /// <p>Information about the <code>WebACL</code> that you specified in the <code>GetWebACL</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>WebACL</code>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of <code>Rule</code> objects, and <code>WebACLId</code> </p> </li>
    /// <li> <p> <code>DefaultAction</code> (Data type is <code>WafAction</code>): Contains <code>Type</code> </p> </li>
    /// <li> <p> <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain <code>Action</code>, <code>Priority</code>, and <code>RuleId</code> </p> </li>
    /// <li> <p> <code>Action</code>: Contains <code>Type</code> </p> </li>
    /// </ul>
    pub web_acl: std::option::Option<crate::model::WebAcl>,
}
impl GetWebAclOutput {
    /// <p>Information about the <code>WebACL</code> that you specified in the <code>GetWebACL</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>WebACL</code>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of <code>Rule</code> objects, and <code>WebACLId</code> </p> </li>
    /// <li> <p> <code>DefaultAction</code> (Data type is <code>WafAction</code>): Contains <code>Type</code> </p> </li>
    /// <li> <p> <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain <code>Action</code>, <code>Priority</code>, and <code>RuleId</code> </p> </li>
    /// <li> <p> <code>Action</code>: Contains <code>Type</code> </p> </li>
    /// </ul>
    pub fn web_acl(&self) -> std::option::Option<&crate::model::WebAcl> {
        self.web_acl.as_ref()
    }
}
impl std::fmt::Debug for GetWebAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWebAclOutput");
        formatter.field("web_acl", &self.web_acl);
        formatter.finish()
    }
}
/// See [`GetWebAclOutput`](crate::output::GetWebAclOutput)
pub mod get_web_acl_output {
    /// A builder for [`GetWebAclOutput`](crate::output::GetWebAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) web_acl: std::option::Option<crate::model::WebAcl>,
    }
    impl Builder {
        /// <p>Information about the <code>WebACL</code> that you specified in the <code>GetWebACL</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>WebACL</code>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of <code>Rule</code> objects, and <code>WebACLId</code> </p> </li>
        /// <li> <p> <code>DefaultAction</code> (Data type is <code>WafAction</code>): Contains <code>Type</code> </p> </li>
        /// <li> <p> <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain <code>Action</code>, <code>Priority</code>, and <code>RuleId</code> </p> </li>
        /// <li> <p> <code>Action</code>: Contains <code>Type</code> </p> </li>
        /// </ul>
        pub fn web_acl(mut self, input: crate::model::WebAcl) -> Self {
            self.web_acl = Some(input);
            self
        }
        /// <p>Information about the <code>WebACL</code> that you specified in the <code>GetWebACL</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>WebACL</code>: Contains <code>DefaultAction</code>, <code>MetricName</code>, <code>Name</code>, an array of <code>Rule</code> objects, and <code>WebACLId</code> </p> </li>
        /// <li> <p> <code>DefaultAction</code> (Data type is <code>WafAction</code>): Contains <code>Type</code> </p> </li>
        /// <li> <p> <code>Rules</code>: Contains an array of <code>ActivatedRule</code> objects, which contain <code>Action</code>, <code>Priority</code>, and <code>RuleId</code> </p> </li>
        /// <li> <p> <code>Action</code>: Contains <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_web_acl(mut self, input: std::option::Option<crate::model::WebAcl>) -> Self {
            self.web_acl = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWebAclOutput`](crate::output::GetWebAclOutput)
        pub fn build(self) -> crate::output::GetWebAclOutput {
            crate::output::GetWebAclOutput {
                web_acl: self.web_acl,
            }
        }
    }
}
impl GetWebAclOutput {
    /// Creates a new builder-style object to manufacture [`GetWebAclOutput`](crate::output::GetWebAclOutput)
    pub fn builder() -> crate::output::get_web_acl_output::Builder {
        crate::output::get_web_acl_output::Builder::default()
    }
}

/// <p>The response to a <code>GetSqlInjectionMatchSet</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSqlInjectionMatchSetOutput {
    /// <p>Information about the <code>SqlInjectionMatchSet</code> that you specified in the <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>SqlInjectionMatchSet</code>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of <code>SqlInjectionMatchTuple</code> objects</p> </li>
    /// <li> <p> <code>SqlInjectionMatchTuple</code>: Each <code>SqlInjectionMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub sql_injection_match_set: std::option::Option<crate::model::SqlInjectionMatchSet>,
}
impl GetSqlInjectionMatchSetOutput {
    /// <p>Information about the <code>SqlInjectionMatchSet</code> that you specified in the <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>SqlInjectionMatchSet</code>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of <code>SqlInjectionMatchTuple</code> objects</p> </li>
    /// <li> <p> <code>SqlInjectionMatchTuple</code>: Each <code>SqlInjectionMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub fn sql_injection_match_set(
        &self,
    ) -> std::option::Option<&crate::model::SqlInjectionMatchSet> {
        self.sql_injection_match_set.as_ref()
    }
}
impl std::fmt::Debug for GetSqlInjectionMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSqlInjectionMatchSetOutput");
        formatter.field("sql_injection_match_set", &self.sql_injection_match_set);
        formatter.finish()
    }
}
/// See [`GetSqlInjectionMatchSetOutput`](crate::output::GetSqlInjectionMatchSetOutput)
pub mod get_sql_injection_match_set_output {
    /// A builder for [`GetSqlInjectionMatchSetOutput`](crate::output::GetSqlInjectionMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql_injection_match_set: std::option::Option<crate::model::SqlInjectionMatchSet>,
    }
    impl Builder {
        /// <p>Information about the <code>SqlInjectionMatchSet</code> that you specified in the <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>SqlInjectionMatchSet</code>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of <code>SqlInjectionMatchTuple</code> objects</p> </li>
        /// <li> <p> <code>SqlInjectionMatchTuple</code>: Each <code>SqlInjectionMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn sql_injection_match_set(
            mut self,
            input: crate::model::SqlInjectionMatchSet,
        ) -> Self {
            self.sql_injection_match_set = Some(input);
            self
        }
        /// <p>Information about the <code>SqlInjectionMatchSet</code> that you specified in the <code>GetSqlInjectionMatchSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>SqlInjectionMatchSet</code>: Contains <code>Name</code>, <code>SqlInjectionMatchSetId</code>, and an array of <code>SqlInjectionMatchTuple</code> objects</p> </li>
        /// <li> <p> <code>SqlInjectionMatchTuple</code>: Each <code>SqlInjectionMatchTuple</code> object contains <code>FieldToMatch</code> and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_sql_injection_match_set(
            mut self,
            input: std::option::Option<crate::model::SqlInjectionMatchSet>,
        ) -> Self {
            self.sql_injection_match_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSqlInjectionMatchSetOutput`](crate::output::GetSqlInjectionMatchSetOutput)
        pub fn build(self) -> crate::output::GetSqlInjectionMatchSetOutput {
            crate::output::GetSqlInjectionMatchSetOutput {
                sql_injection_match_set: self.sql_injection_match_set,
            }
        }
    }
}
impl GetSqlInjectionMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`GetSqlInjectionMatchSetOutput`](crate::output::GetSqlInjectionMatchSetOutput)
    pub fn builder() -> crate::output::get_sql_injection_match_set_output::Builder {
        crate::output::get_sql_injection_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSizeConstraintSetOutput {
    /// <p>Information about the <code>SizeConstraintSet</code> that you specified in the <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>SizeConstraintSet</code>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and <code>Name</code> </p> </li>
    /// <li> <p> <code>SizeConstraints</code>: Contains an array of <code>SizeConstraint</code> objects. Each <code>SizeConstraint</code> object contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub size_constraint_set: std::option::Option<crate::model::SizeConstraintSet>,
}
impl GetSizeConstraintSetOutput {
    /// <p>Information about the <code>SizeConstraintSet</code> that you specified in the <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>SizeConstraintSet</code>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and <code>Name</code> </p> </li>
    /// <li> <p> <code>SizeConstraints</code>: Contains an array of <code>SizeConstraint</code> objects. Each <code>SizeConstraint</code> object contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub fn size_constraint_set(&self) -> std::option::Option<&crate::model::SizeConstraintSet> {
        self.size_constraint_set.as_ref()
    }
}
impl std::fmt::Debug for GetSizeConstraintSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSizeConstraintSetOutput");
        formatter.field("size_constraint_set", &self.size_constraint_set);
        formatter.finish()
    }
}
/// See [`GetSizeConstraintSetOutput`](crate::output::GetSizeConstraintSetOutput)
pub mod get_size_constraint_set_output {
    /// A builder for [`GetSizeConstraintSetOutput`](crate::output::GetSizeConstraintSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_constraint_set: std::option::Option<crate::model::SizeConstraintSet>,
    }
    impl Builder {
        /// <p>Information about the <code>SizeConstraintSet</code> that you specified in the <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>SizeConstraintSet</code>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and <code>Name</code> </p> </li>
        /// <li> <p> <code>SizeConstraints</code>: Contains an array of <code>SizeConstraint</code> objects. Each <code>SizeConstraint</code> object contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn size_constraint_set(mut self, input: crate::model::SizeConstraintSet) -> Self {
            self.size_constraint_set = Some(input);
            self
        }
        /// <p>Information about the <code>SizeConstraintSet</code> that you specified in the <code>GetSizeConstraintSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>SizeConstraintSet</code>: Contains <code>SizeConstraintSetId</code>, <code>SizeConstraints</code>, and <code>Name</code> </p> </li>
        /// <li> <p> <code>SizeConstraints</code>: Contains an array of <code>SizeConstraint</code> objects. Each <code>SizeConstraint</code> object contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>, and <code>Size</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_size_constraint_set(
            mut self,
            input: std::option::Option<crate::model::SizeConstraintSet>,
        ) -> Self {
            self.size_constraint_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSizeConstraintSetOutput`](crate::output::GetSizeConstraintSetOutput)
        pub fn build(self) -> crate::output::GetSizeConstraintSetOutput {
            crate::output::GetSizeConstraintSetOutput {
                size_constraint_set: self.size_constraint_set,
            }
        }
    }
}
impl GetSizeConstraintSetOutput {
    /// Creates a new builder-style object to manufacture [`GetSizeConstraintSetOutput`](crate::output::GetSizeConstraintSetOutput)
    pub fn builder() -> crate::output::get_size_constraint_set_output::Builder {
        crate::output::get_size_constraint_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSampledRequestsOutput {
    /// <p>A complex type that contains detailed information about each of the requests in the sample.</p>
    pub sampled_requests: std::option::Option<std::vec::Vec<crate::model::SampledHttpRequest>>,
    /// <p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your AWS resource received during the specified time range.</p>
    pub population_size: i64,
    /// <p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>
    pub time_window: std::option::Option<crate::model::TimeWindow>,
}
impl GetSampledRequestsOutput {
    /// <p>A complex type that contains detailed information about each of the requests in the sample.</p>
    pub fn sampled_requests(&self) -> std::option::Option<&[crate::model::SampledHttpRequest]> {
        self.sampled_requests.as_deref()
    }
    /// <p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your AWS resource received during the specified time range.</p>
    pub fn population_size(&self) -> i64 {
        self.population_size
    }
    /// <p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>
    pub fn time_window(&self) -> std::option::Option<&crate::model::TimeWindow> {
        self.time_window.as_ref()
    }
}
impl std::fmt::Debug for GetSampledRequestsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSampledRequestsOutput");
        formatter.field("sampled_requests", &self.sampled_requests);
        formatter.field("population_size", &self.population_size);
        formatter.field("time_window", &self.time_window);
        formatter.finish()
    }
}
/// See [`GetSampledRequestsOutput`](crate::output::GetSampledRequestsOutput)
pub mod get_sampled_requests_output {
    /// A builder for [`GetSampledRequestsOutput`](crate::output::GetSampledRequestsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sampled_requests:
            std::option::Option<std::vec::Vec<crate::model::SampledHttpRequest>>,
        pub(crate) population_size: std::option::Option<i64>,
        pub(crate) time_window: std::option::Option<crate::model::TimeWindow>,
    }
    impl Builder {
        /// Appends an item to `sampled_requests`.
        ///
        /// To override the contents of this collection use [`set_sampled_requests`](Self::set_sampled_requests).
        ///
        /// <p>A complex type that contains detailed information about each of the requests in the sample.</p>
        pub fn sampled_requests(mut self, input: crate::model::SampledHttpRequest) -> Self {
            let mut v = self.sampled_requests.unwrap_or_default();
            v.push(input);
            self.sampled_requests = Some(v);
            self
        }
        /// <p>A complex type that contains detailed information about each of the requests in the sample.</p>
        pub fn set_sampled_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampledHttpRequest>>,
        ) -> Self {
            self.sampled_requests = input;
            self
        }
        /// <p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your AWS resource received during the specified time range.</p>
        pub fn population_size(mut self, input: i64) -> Self {
            self.population_size = Some(input);
            self
        }
        /// <p>The total number of requests from which <code>GetSampledRequests</code> got a sample of <code>MaxItems</code> requests. If <code>PopulationSize</code> is less than <code>MaxItems</code>, the sample includes every request that your AWS resource received during the specified time range.</p>
        pub fn set_population_size(mut self, input: std::option::Option<i64>) -> Self {
            self.population_size = input;
            self
        }
        /// <p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>
        pub fn time_window(mut self, input: crate::model::TimeWindow) -> Self {
            self.time_window = Some(input);
            self
        }
        /// <p>Usually, <code>TimeWindow</code> is the time range that you specified in the <code>GetSampledRequests</code> request. However, if your AWS resource received more than 5,000 requests during the time range that you specified in the request, <code>GetSampledRequests</code> returns the time range for the first 5,000 requests. Times are in Coordinated Universal Time (UTC) format.</p>
        pub fn set_time_window(
            mut self,
            input: std::option::Option<crate::model::TimeWindow>,
        ) -> Self {
            self.time_window = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSampledRequestsOutput`](crate::output::GetSampledRequestsOutput)
        pub fn build(self) -> crate::output::GetSampledRequestsOutput {
            crate::output::GetSampledRequestsOutput {
                sampled_requests: self.sampled_requests,
                population_size: self.population_size.unwrap_or_default(),
                time_window: self.time_window,
            }
        }
    }
}
impl GetSampledRequestsOutput {
    /// Creates a new builder-style object to manufacture [`GetSampledRequestsOutput`](crate::output::GetSampledRequestsOutput)
    pub fn builder() -> crate::output::get_sampled_requests_output::Builder {
        crate::output::get_sampled_requests_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRuleGroupOutput {
    /// <p>Information about the <code>RuleGroup</code> that you specified in the <code>GetRuleGroup</code> request. </p>
    pub rule_group: std::option::Option<crate::model::RuleGroup>,
}
impl GetRuleGroupOutput {
    /// <p>Information about the <code>RuleGroup</code> that you specified in the <code>GetRuleGroup</code> request. </p>
    pub fn rule_group(&self) -> std::option::Option<&crate::model::RuleGroup> {
        self.rule_group.as_ref()
    }
}
impl std::fmt::Debug for GetRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRuleGroupOutput");
        formatter.field("rule_group", &self.rule_group);
        formatter.finish()
    }
}
/// See [`GetRuleGroupOutput`](crate::output::GetRuleGroupOutput)
pub mod get_rule_group_output {
    /// A builder for [`GetRuleGroupOutput`](crate::output::GetRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group: std::option::Option<crate::model::RuleGroup>,
    }
    impl Builder {
        /// <p>Information about the <code>RuleGroup</code> that you specified in the <code>GetRuleGroup</code> request. </p>
        pub fn rule_group(mut self, input: crate::model::RuleGroup) -> Self {
            self.rule_group = Some(input);
            self
        }
        /// <p>Information about the <code>RuleGroup</code> that you specified in the <code>GetRuleGroup</code> request. </p>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.rule_group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRuleGroupOutput`](crate::output::GetRuleGroupOutput)
        pub fn build(self) -> crate::output::GetRuleGroupOutput {
            crate::output::GetRuleGroupOutput {
                rule_group: self.rule_group,
            }
        }
    }
}
impl GetRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetRuleGroupOutput`](crate::output::GetRuleGroupOutput)
    pub fn builder() -> crate::output::get_rule_group_output::Builder {
        crate::output::get_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRuleOutput {
    /// <p>Information about the <code>Rule</code> that you specified in the <code>GetRule</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>Rule</code>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects, and <code>RuleId</code> </p> </li>
    /// <li> <p> <code>Predicate</code>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>
    /// </ul>
    pub rule: std::option::Option<crate::model::Rule>,
}
impl GetRuleOutput {
    /// <p>Information about the <code>Rule</code> that you specified in the <code>GetRule</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>Rule</code>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects, and <code>RuleId</code> </p> </li>
    /// <li> <p> <code>Predicate</code>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>
    /// </ul>
    pub fn rule(&self) -> std::option::Option<&crate::model::Rule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for GetRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRuleOutput");
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`GetRuleOutput`](crate::output::GetRuleOutput)
pub mod get_rule_output {
    /// A builder for [`GetRuleOutput`](crate::output::GetRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
    }
    impl Builder {
        /// <p>Information about the <code>Rule</code> that you specified in the <code>GetRule</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>Rule</code>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects, and <code>RuleId</code> </p> </li>
        /// <li> <p> <code>Predicate</code>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>
        /// </ul>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>Information about the <code>Rule</code> that you specified in the <code>GetRule</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>Rule</code>: Contains <code>MetricName</code>, <code>Name</code>, an array of <code>Predicate</code> objects, and <code>RuleId</code> </p> </li>
        /// <li> <p> <code>Predicate</code>: Each <code>Predicate</code> object contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRuleOutput`](crate::output::GetRuleOutput)
        pub fn build(self) -> crate::output::GetRuleOutput {
            crate::output::GetRuleOutput { rule: self.rule }
        }
    }
}
impl GetRuleOutput {
    /// Creates a new builder-style object to manufacture [`GetRuleOutput`](crate::output::GetRuleOutput)
    pub fn builder() -> crate::output::get_rule_output::Builder {
        crate::output::get_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegexPatternSetOutput {
    /// <p>Information about the <code>RegexPatternSet</code> that you specified in the <code>GetRegexPatternSet</code> request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to search for. </p>
    pub regex_pattern_set: std::option::Option<crate::model::RegexPatternSet>,
}
impl GetRegexPatternSetOutput {
    /// <p>Information about the <code>RegexPatternSet</code> that you specified in the <code>GetRegexPatternSet</code> request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to search for. </p>
    pub fn regex_pattern_set(&self) -> std::option::Option<&crate::model::RegexPatternSet> {
        self.regex_pattern_set.as_ref()
    }
}
impl std::fmt::Debug for GetRegexPatternSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegexPatternSetOutput");
        formatter.field("regex_pattern_set", &self.regex_pattern_set);
        formatter.finish()
    }
}
/// See [`GetRegexPatternSetOutput`](crate::output::GetRegexPatternSetOutput)
pub mod get_regex_pattern_set_output {
    /// A builder for [`GetRegexPatternSetOutput`](crate::output::GetRegexPatternSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_pattern_set: std::option::Option<crate::model::RegexPatternSet>,
    }
    impl Builder {
        /// <p>Information about the <code>RegexPatternSet</code> that you specified in the <code>GetRegexPatternSet</code> request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to search for. </p>
        pub fn regex_pattern_set(mut self, input: crate::model::RegexPatternSet) -> Self {
            self.regex_pattern_set = Some(input);
            self
        }
        /// <p>Information about the <code>RegexPatternSet</code> that you specified in the <code>GetRegexPatternSet</code> request, including the identifier of the pattern set and the regular expression patterns you want AWS WAF to search for. </p>
        pub fn set_regex_pattern_set(
            mut self,
            input: std::option::Option<crate::model::RegexPatternSet>,
        ) -> Self {
            self.regex_pattern_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegexPatternSetOutput`](crate::output::GetRegexPatternSetOutput)
        pub fn build(self) -> crate::output::GetRegexPatternSetOutput {
            crate::output::GetRegexPatternSetOutput {
                regex_pattern_set: self.regex_pattern_set,
            }
        }
    }
}
impl GetRegexPatternSetOutput {
    /// Creates a new builder-style object to manufacture [`GetRegexPatternSetOutput`](crate::output::GetRegexPatternSetOutput)
    pub fn builder() -> crate::output::get_regex_pattern_set_output::Builder {
        crate::output::get_regex_pattern_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegexMatchSetOutput {
    /// <p>Information about the <code>RegexMatchSet</code> that you specified in the <code>GetRegexMatchSet</code> request. For more information, see <code>RegexMatchTuple</code>.</p>
    pub regex_match_set: std::option::Option<crate::model::RegexMatchSet>,
}
impl GetRegexMatchSetOutput {
    /// <p>Information about the <code>RegexMatchSet</code> that you specified in the <code>GetRegexMatchSet</code> request. For more information, see <code>RegexMatchTuple</code>.</p>
    pub fn regex_match_set(&self) -> std::option::Option<&crate::model::RegexMatchSet> {
        self.regex_match_set.as_ref()
    }
}
impl std::fmt::Debug for GetRegexMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegexMatchSetOutput");
        formatter.field("regex_match_set", &self.regex_match_set);
        formatter.finish()
    }
}
/// See [`GetRegexMatchSetOutput`](crate::output::GetRegexMatchSetOutput)
pub mod get_regex_match_set_output {
    /// A builder for [`GetRegexMatchSetOutput`](crate::output::GetRegexMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_match_set: std::option::Option<crate::model::RegexMatchSet>,
    }
    impl Builder {
        /// <p>Information about the <code>RegexMatchSet</code> that you specified in the <code>GetRegexMatchSet</code> request. For more information, see <code>RegexMatchTuple</code>.</p>
        pub fn regex_match_set(mut self, input: crate::model::RegexMatchSet) -> Self {
            self.regex_match_set = Some(input);
            self
        }
        /// <p>Information about the <code>RegexMatchSet</code> that you specified in the <code>GetRegexMatchSet</code> request. For more information, see <code>RegexMatchTuple</code>.</p>
        pub fn set_regex_match_set(
            mut self,
            input: std::option::Option<crate::model::RegexMatchSet>,
        ) -> Self {
            self.regex_match_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegexMatchSetOutput`](crate::output::GetRegexMatchSetOutput)
        pub fn build(self) -> crate::output::GetRegexMatchSetOutput {
            crate::output::GetRegexMatchSetOutput {
                regex_match_set: self.regex_match_set,
            }
        }
    }
}
impl GetRegexMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`GetRegexMatchSetOutput`](crate::output::GetRegexMatchSetOutput)
    pub fn builder() -> crate::output::get_regex_match_set_output::Builder {
        crate::output::get_regex_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRateBasedRuleManagedKeysOutput {
    /// <p>An array of IP addresses that currently are blocked by the specified <code>RateBasedRule</code>. </p>
    pub managed_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A null value and not currently used.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl GetRateBasedRuleManagedKeysOutput {
    /// <p>An array of IP addresses that currently are blocked by the specified <code>RateBasedRule</code>. </p>
    pub fn managed_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.managed_keys.as_deref()
    }
    /// <p>A null value and not currently used.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for GetRateBasedRuleManagedKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRateBasedRuleManagedKeysOutput");
        formatter.field("managed_keys", &self.managed_keys);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`GetRateBasedRuleManagedKeysOutput`](crate::output::GetRateBasedRuleManagedKeysOutput)
pub mod get_rate_based_rule_managed_keys_output {
    /// A builder for [`GetRateBasedRuleManagedKeysOutput`](crate::output::GetRateBasedRuleManagedKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) managed_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `managed_keys`.
        ///
        /// To override the contents of this collection use [`set_managed_keys`](Self::set_managed_keys).
        ///
        /// <p>An array of IP addresses that currently are blocked by the specified <code>RateBasedRule</code>. </p>
        pub fn managed_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.managed_keys.unwrap_or_default();
            v.push(input.into());
            self.managed_keys = Some(v);
            self
        }
        /// <p>An array of IP addresses that currently are blocked by the specified <code>RateBasedRule</code>. </p>
        pub fn set_managed_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.managed_keys = input;
            self
        }
        /// <p>A null value and not currently used.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A null value and not currently used.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRateBasedRuleManagedKeysOutput`](crate::output::GetRateBasedRuleManagedKeysOutput)
        pub fn build(self) -> crate::output::GetRateBasedRuleManagedKeysOutput {
            crate::output::GetRateBasedRuleManagedKeysOutput {
                managed_keys: self.managed_keys,
                next_marker: self.next_marker,
            }
        }
    }
}
impl GetRateBasedRuleManagedKeysOutput {
    /// Creates a new builder-style object to manufacture [`GetRateBasedRuleManagedKeysOutput`](crate::output::GetRateBasedRuleManagedKeysOutput)
    pub fn builder() -> crate::output::get_rate_based_rule_managed_keys_output::Builder {
        crate::output::get_rate_based_rule_managed_keys_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRateBasedRuleOutput {
    /// <p>Information about the <code>RateBasedRule</code> that you specified in the <code>GetRateBasedRule</code> request.</p>
    pub rule: std::option::Option<crate::model::RateBasedRule>,
}
impl GetRateBasedRuleOutput {
    /// <p>Information about the <code>RateBasedRule</code> that you specified in the <code>GetRateBasedRule</code> request.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::RateBasedRule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for GetRateBasedRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRateBasedRuleOutput");
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`GetRateBasedRuleOutput`](crate::output::GetRateBasedRuleOutput)
pub mod get_rate_based_rule_output {
    /// A builder for [`GetRateBasedRuleOutput`](crate::output::GetRateBasedRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::RateBasedRule>,
    }
    impl Builder {
        /// <p>Information about the <code>RateBasedRule</code> that you specified in the <code>GetRateBasedRule</code> request.</p>
        pub fn rule(mut self, input: crate::model::RateBasedRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>Information about the <code>RateBasedRule</code> that you specified in the <code>GetRateBasedRule</code> request.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::RateBasedRule>) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRateBasedRuleOutput`](crate::output::GetRateBasedRuleOutput)
        pub fn build(self) -> crate::output::GetRateBasedRuleOutput {
            crate::output::GetRateBasedRuleOutput { rule: self.rule }
        }
    }
}
impl GetRateBasedRuleOutput {
    /// Creates a new builder-style object to manufacture [`GetRateBasedRuleOutput`](crate::output::GetRateBasedRuleOutput)
    pub fn builder() -> crate::output::get_rate_based_rule_output::Builder {
        crate::output::get_rate_based_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPermissionPolicyOutput {
    /// <p>The IAM policy attached to the specified RuleGroup.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetPermissionPolicyOutput {
    /// <p>The IAM policy attached to the specified RuleGroup.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetPermissionPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPermissionPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetPermissionPolicyOutput`](crate::output::GetPermissionPolicyOutput)
pub mod get_permission_policy_output {
    /// A builder for [`GetPermissionPolicyOutput`](crate::output::GetPermissionPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM policy attached to the specified RuleGroup.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The IAM policy attached to the specified RuleGroup.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPermissionPolicyOutput`](crate::output::GetPermissionPolicyOutput)
        pub fn build(self) -> crate::output::GetPermissionPolicyOutput {
            crate::output::GetPermissionPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetPermissionPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetPermissionPolicyOutput`](crate::output::GetPermissionPolicyOutput)
    pub fn builder() -> crate::output::get_permission_policy_output::Builder {
        crate::output::get_permission_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLoggingConfigurationOutput {
    /// <p>The <code>LoggingConfiguration</code> for the specified web ACL.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
}
impl GetLoggingConfigurationOutput {
    /// <p>The <code>LoggingConfiguration</code> for the specified web ACL.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetLoggingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLoggingConfigurationOutput");
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.finish()
    }
}
/// See [`GetLoggingConfigurationOutput`](crate::output::GetLoggingConfigurationOutput)
pub mod get_logging_configuration_output {
    /// A builder for [`GetLoggingConfigurationOutput`](crate::output::GetLoggingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    }
    impl Builder {
        /// <p>The <code>LoggingConfiguration</code> for the specified web ACL.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The <code>LoggingConfiguration</code> for the specified web ACL.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoggingConfigurationOutput`](crate::output::GetLoggingConfigurationOutput)
        pub fn build(self) -> crate::output::GetLoggingConfigurationOutput {
            crate::output::GetLoggingConfigurationOutput {
                logging_configuration: self.logging_configuration,
            }
        }
    }
}
impl GetLoggingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetLoggingConfigurationOutput`](crate::output::GetLoggingConfigurationOutput)
    pub fn builder() -> crate::output::get_logging_configuration_output::Builder {
        crate::output::get_logging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIpSetOutput {
    /// <p>Information about the <code>IPSet</code> that you specified in the <code>GetIPSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>IPSet</code>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code> </p> </li>
    /// <li> <p> <code>IPSetDescriptors</code>: Contains an array of <code>IPSetDescriptor</code> objects. Each <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code> </p> </li>
    /// </ul>
    pub ip_set: std::option::Option<crate::model::IpSet>,
}
impl GetIpSetOutput {
    /// <p>Information about the <code>IPSet</code> that you specified in the <code>GetIPSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>IPSet</code>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code> </p> </li>
    /// <li> <p> <code>IPSetDescriptors</code>: Contains an array of <code>IPSetDescriptor</code> objects. Each <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code> </p> </li>
    /// </ul>
    pub fn ip_set(&self) -> std::option::Option<&crate::model::IpSet> {
        self.ip_set.as_ref()
    }
}
impl std::fmt::Debug for GetIpSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIpSetOutput");
        formatter.field("ip_set", &self.ip_set);
        formatter.finish()
    }
}
/// See [`GetIpSetOutput`](crate::output::GetIpSetOutput)
pub mod get_ip_set_output {
    /// A builder for [`GetIpSetOutput`](crate::output::GetIpSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_set: std::option::Option<crate::model::IpSet>,
    }
    impl Builder {
        /// <p>Information about the <code>IPSet</code> that you specified in the <code>GetIPSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>IPSet</code>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code> </p> </li>
        /// <li> <p> <code>IPSetDescriptors</code>: Contains an array of <code>IPSetDescriptor</code> objects. Each <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code> </p> </li>
        /// </ul>
        pub fn ip_set(mut self, input: crate::model::IpSet) -> Self {
            self.ip_set = Some(input);
            self
        }
        /// <p>Information about the <code>IPSet</code> that you specified in the <code>GetIPSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>IPSet</code>: Contains <code>IPSetDescriptors</code>, <code>IPSetId</code>, and <code>Name</code> </p> </li>
        /// <li> <p> <code>IPSetDescriptors</code>: Contains an array of <code>IPSetDescriptor</code> objects. Each <code>IPSetDescriptor</code> object contains <code>Type</code> and <code>Value</code> </p> </li>
        /// </ul>
        pub fn set_ip_set(mut self, input: std::option::Option<crate::model::IpSet>) -> Self {
            self.ip_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIpSetOutput`](crate::output::GetIpSetOutput)
        pub fn build(self) -> crate::output::GetIpSetOutput {
            crate::output::GetIpSetOutput {
                ip_set: self.ip_set,
            }
        }
    }
}
impl GetIpSetOutput {
    /// Creates a new builder-style object to manufacture [`GetIpSetOutput`](crate::output::GetIpSetOutput)
    pub fn builder() -> crate::output::get_ip_set_output::Builder {
        crate::output::get_ip_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeoMatchSetOutput {
    /// <p>Information about the <code>GeoMatchSet</code> that you specified in the <code>GetGeoMatchSet</code> request. This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific country.</p>
    pub geo_match_set: std::option::Option<crate::model::GeoMatchSet>,
}
impl GetGeoMatchSetOutput {
    /// <p>Information about the <code>GeoMatchSet</code> that you specified in the <code>GetGeoMatchSet</code> request. This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific country.</p>
    pub fn geo_match_set(&self) -> std::option::Option<&crate::model::GeoMatchSet> {
        self.geo_match_set.as_ref()
    }
}
impl std::fmt::Debug for GetGeoMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeoMatchSetOutput");
        formatter.field("geo_match_set", &self.geo_match_set);
        formatter.finish()
    }
}
/// See [`GetGeoMatchSetOutput`](crate::output::GetGeoMatchSetOutput)
pub mod get_geo_match_set_output {
    /// A builder for [`GetGeoMatchSetOutput`](crate::output::GetGeoMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_match_set: std::option::Option<crate::model::GeoMatchSet>,
    }
    impl Builder {
        /// <p>Information about the <code>GeoMatchSet</code> that you specified in the <code>GetGeoMatchSet</code> request. This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific country.</p>
        pub fn geo_match_set(mut self, input: crate::model::GeoMatchSet) -> Self {
            self.geo_match_set = Some(input);
            self
        }
        /// <p>Information about the <code>GeoMatchSet</code> that you specified in the <code>GetGeoMatchSet</code> request. This includes the <code>Type</code>, which for a <code>GeoMatchContraint</code> is always <code>Country</code>, as well as the <code>Value</code>, which is the identifier for a specific country.</p>
        pub fn set_geo_match_set(
            mut self,
            input: std::option::Option<crate::model::GeoMatchSet>,
        ) -> Self {
            self.geo_match_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeoMatchSetOutput`](crate::output::GetGeoMatchSetOutput)
        pub fn build(self) -> crate::output::GetGeoMatchSetOutput {
            crate::output::GetGeoMatchSetOutput {
                geo_match_set: self.geo_match_set,
            }
        }
    }
}
impl GetGeoMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`GetGeoMatchSetOutput`](crate::output::GetGeoMatchSetOutput)
    pub fn builder() -> crate::output::get_geo_match_set_output::Builder {
        crate::output::get_geo_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangeTokenStatusOutput {
    /// <p>The status of the change token.</p>
    pub change_token_status: std::option::Option<crate::model::ChangeTokenStatus>,
}
impl GetChangeTokenStatusOutput {
    /// <p>The status of the change token.</p>
    pub fn change_token_status(&self) -> std::option::Option<&crate::model::ChangeTokenStatus> {
        self.change_token_status.as_ref()
    }
}
impl std::fmt::Debug for GetChangeTokenStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangeTokenStatusOutput");
        formatter.field("change_token_status", &self.change_token_status);
        formatter.finish()
    }
}
/// See [`GetChangeTokenStatusOutput`](crate::output::GetChangeTokenStatusOutput)
pub mod get_change_token_status_output {
    /// A builder for [`GetChangeTokenStatusOutput`](crate::output::GetChangeTokenStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token_status: std::option::Option<crate::model::ChangeTokenStatus>,
    }
    impl Builder {
        /// <p>The status of the change token.</p>
        pub fn change_token_status(mut self, input: crate::model::ChangeTokenStatus) -> Self {
            self.change_token_status = Some(input);
            self
        }
        /// <p>The status of the change token.</p>
        pub fn set_change_token_status(
            mut self,
            input: std::option::Option<crate::model::ChangeTokenStatus>,
        ) -> Self {
            self.change_token_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangeTokenStatusOutput`](crate::output::GetChangeTokenStatusOutput)
        pub fn build(self) -> crate::output::GetChangeTokenStatusOutput {
            crate::output::GetChangeTokenStatusOutput {
                change_token_status: self.change_token_status,
            }
        }
    }
}
impl GetChangeTokenStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetChangeTokenStatusOutput`](crate::output::GetChangeTokenStatusOutput)
    pub fn builder() -> crate::output::get_change_token_status_output::Builder {
        crate::output::get_change_token_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangeTokenOutput {
    /// <p>The <code>ChangeToken</code> that you used in the request. Use this value in a <code>GetChangeTokenStatus</code> request to get the current status of the request. </p>
    pub change_token: std::option::Option<std::string::String>,
}
impl GetChangeTokenOutput {
    /// <p>The <code>ChangeToken</code> that you used in the request. Use this value in a <code>GetChangeTokenStatus</code> request to get the current status of the request. </p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for GetChangeTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangeTokenOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`GetChangeTokenOutput`](crate::output::GetChangeTokenOutput)
pub mod get_change_token_output {
    /// A builder for [`GetChangeTokenOutput`](crate::output::GetChangeTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used in the request. Use this value in a <code>GetChangeTokenStatus</code> request to get the current status of the request. </p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used in the request. Use this value in a <code>GetChangeTokenStatus</code> request to get the current status of the request. </p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangeTokenOutput`](crate::output::GetChangeTokenOutput)
        pub fn build(self) -> crate::output::GetChangeTokenOutput {
            crate::output::GetChangeTokenOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl GetChangeTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetChangeTokenOutput`](crate::output::GetChangeTokenOutput)
    pub fn builder() -> crate::output::get_change_token_output::Builder {
        crate::output::get_change_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetByteMatchSetOutput {
    /// <p>Information about the <code>ByteMatchSet</code> that you specified in the <code>GetByteMatchSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>ByteMatchSet</code>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and <code>Name</code> </p> </li>
    /// <li> <p> <code>ByteMatchTuples</code>: Contains an array of <code>ByteMatchTuple</code> objects. Each <code>ByteMatchTuple</code> object contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub byte_match_set: std::option::Option<crate::model::ByteMatchSet>,
}
impl GetByteMatchSetOutput {
    /// <p>Information about the <code>ByteMatchSet</code> that you specified in the <code>GetByteMatchSet</code> request. For more information, see the following topics:</p>
    /// <ul>
    /// <li> <p> <code>ByteMatchSet</code>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and <code>Name</code> </p> </li>
    /// <li> <p> <code>ByteMatchTuples</code>: Contains an array of <code>ByteMatchTuple</code> objects. Each <code>ByteMatchTuple</code> object contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>
    /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
    /// </ul>
    pub fn byte_match_set(&self) -> std::option::Option<&crate::model::ByteMatchSet> {
        self.byte_match_set.as_ref()
    }
}
impl std::fmt::Debug for GetByteMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetByteMatchSetOutput");
        formatter.field("byte_match_set", &self.byte_match_set);
        formatter.finish()
    }
}
/// See [`GetByteMatchSetOutput`](crate::output::GetByteMatchSetOutput)
pub mod get_byte_match_set_output {
    /// A builder for [`GetByteMatchSetOutput`](crate::output::GetByteMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) byte_match_set: std::option::Option<crate::model::ByteMatchSet>,
    }
    impl Builder {
        /// <p>Information about the <code>ByteMatchSet</code> that you specified in the <code>GetByteMatchSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>ByteMatchSet</code>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and <code>Name</code> </p> </li>
        /// <li> <p> <code>ByteMatchTuples</code>: Contains an array of <code>ByteMatchTuple</code> objects. Each <code>ByteMatchTuple</code> object contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn byte_match_set(mut self, input: crate::model::ByteMatchSet) -> Self {
            self.byte_match_set = Some(input);
            self
        }
        /// <p>Information about the <code>ByteMatchSet</code> that you specified in the <code>GetByteMatchSet</code> request. For more information, see the following topics:</p>
        /// <ul>
        /// <li> <p> <code>ByteMatchSet</code>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and <code>Name</code> </p> </li>
        /// <li> <p> <code>ByteMatchTuples</code>: Contains an array of <code>ByteMatchTuple</code> objects. Each <code>ByteMatchTuple</code> object contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>, and <code>TextTransformation</code> </p> </li>
        /// <li> <p> <code>FieldToMatch</code>: Contains <code>Data</code> and <code>Type</code> </p> </li>
        /// </ul>
        pub fn set_byte_match_set(
            mut self,
            input: std::option::Option<crate::model::ByteMatchSet>,
        ) -> Self {
            self.byte_match_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetByteMatchSetOutput`](crate::output::GetByteMatchSetOutput)
        pub fn build(self) -> crate::output::GetByteMatchSetOutput {
            crate::output::GetByteMatchSetOutput {
                byte_match_set: self.byte_match_set,
            }
        }
    }
}
impl GetByteMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`GetByteMatchSetOutput`](crate::output::GetByteMatchSetOutput)
    pub fn builder() -> crate::output::get_byte_match_set_output::Builder {
        crate::output::get_byte_match_set_output::Builder::default()
    }
}

/// <p>The response to a request to delete an <code>XssMatchSet</code> from AWS WAF.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteXssMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteXssMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteXssMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteXssMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteXssMatchSetOutput`](crate::output::DeleteXssMatchSetOutput)
pub mod delete_xss_match_set_output {
    /// A builder for [`DeleteXssMatchSetOutput`](crate::output::DeleteXssMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteXssMatchSetOutput`](crate::output::DeleteXssMatchSetOutput)
        pub fn build(self) -> crate::output::DeleteXssMatchSetOutput {
            crate::output::DeleteXssMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteXssMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteXssMatchSetOutput`](crate::output::DeleteXssMatchSetOutput)
    pub fn builder() -> crate::output::delete_xss_match_set_output::Builder {
        crate::output::delete_xss_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWebAclOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteWebAclOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteWebAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWebAclOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteWebAclOutput`](crate::output::DeleteWebAclOutput)
pub mod delete_web_acl_output {
    /// A builder for [`DeleteWebAclOutput`](crate::output::DeleteWebAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWebAclOutput`](crate::output::DeleteWebAclOutput)
        pub fn build(self) -> crate::output::DeleteWebAclOutput {
            crate::output::DeleteWebAclOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteWebAclOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWebAclOutput`](crate::output::DeleteWebAclOutput)
    pub fn builder() -> crate::output::delete_web_acl_output::Builder {
        crate::output::delete_web_acl_output::Builder::default()
    }
}

/// <p>The response to a request to delete a <code>SqlInjectionMatchSet</code> from AWS WAF.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSqlInjectionMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteSqlInjectionMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteSqlInjectionMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSqlInjectionMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteSqlInjectionMatchSetOutput`](crate::output::DeleteSqlInjectionMatchSetOutput)
pub mod delete_sql_injection_match_set_output {
    /// A builder for [`DeleteSqlInjectionMatchSetOutput`](crate::output::DeleteSqlInjectionMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSqlInjectionMatchSetOutput`](crate::output::DeleteSqlInjectionMatchSetOutput)
        pub fn build(self) -> crate::output::DeleteSqlInjectionMatchSetOutput {
            crate::output::DeleteSqlInjectionMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteSqlInjectionMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSqlInjectionMatchSetOutput`](crate::output::DeleteSqlInjectionMatchSetOutput)
    pub fn builder() -> crate::output::delete_sql_injection_match_set_output::Builder {
        crate::output::delete_sql_injection_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSizeConstraintSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteSizeConstraintSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteSizeConstraintSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSizeConstraintSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteSizeConstraintSetOutput`](crate::output::DeleteSizeConstraintSetOutput)
pub mod delete_size_constraint_set_output {
    /// A builder for [`DeleteSizeConstraintSetOutput`](crate::output::DeleteSizeConstraintSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSizeConstraintSetOutput`](crate::output::DeleteSizeConstraintSetOutput)
        pub fn build(self) -> crate::output::DeleteSizeConstraintSetOutput {
            crate::output::DeleteSizeConstraintSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteSizeConstraintSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSizeConstraintSetOutput`](crate::output::DeleteSizeConstraintSetOutput)
    pub fn builder() -> crate::output::delete_size_constraint_set_output::Builder {
        crate::output::delete_size_constraint_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleGroupOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteRuleGroupOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleGroupOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
pub mod delete_rule_group_output {
    /// A builder for [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
        pub fn build(self) -> crate::output::DeleteRuleGroupOutput {
            crate::output::DeleteRuleGroupOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleGroupOutput`](crate::output::DeleteRuleGroupOutput)
    pub fn builder() -> crate::output::delete_rule_group_output::Builder {
        crate::output::delete_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRuleOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
pub mod delete_rule_output {
    /// A builder for [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
        pub fn build(self) -> crate::output::DeleteRuleOutput {
            crate::output::DeleteRuleOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRuleOutput`](crate::output::DeleteRuleOutput)
    pub fn builder() -> crate::output::delete_rule_output::Builder {
        crate::output::delete_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegexPatternSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteRegexPatternSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteRegexPatternSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegexPatternSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteRegexPatternSetOutput`](crate::output::DeleteRegexPatternSetOutput)
pub mod delete_regex_pattern_set_output {
    /// A builder for [`DeleteRegexPatternSetOutput`](crate::output::DeleteRegexPatternSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRegexPatternSetOutput`](crate::output::DeleteRegexPatternSetOutput)
        pub fn build(self) -> crate::output::DeleteRegexPatternSetOutput {
            crate::output::DeleteRegexPatternSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteRegexPatternSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRegexPatternSetOutput`](crate::output::DeleteRegexPatternSetOutput)
    pub fn builder() -> crate::output::delete_regex_pattern_set_output::Builder {
        crate::output::delete_regex_pattern_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegexMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteRegexMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteRegexMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegexMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteRegexMatchSetOutput`](crate::output::DeleteRegexMatchSetOutput)
pub mod delete_regex_match_set_output {
    /// A builder for [`DeleteRegexMatchSetOutput`](crate::output::DeleteRegexMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRegexMatchSetOutput`](crate::output::DeleteRegexMatchSetOutput)
        pub fn build(self) -> crate::output::DeleteRegexMatchSetOutput {
            crate::output::DeleteRegexMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteRegexMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRegexMatchSetOutput`](crate::output::DeleteRegexMatchSetOutput)
    pub fn builder() -> crate::output::delete_regex_match_set_output::Builder {
        crate::output::delete_regex_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRateBasedRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteRateBasedRuleOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteRateBasedRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRateBasedRuleOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteRateBasedRuleOutput`](crate::output::DeleteRateBasedRuleOutput)
pub mod delete_rate_based_rule_output {
    /// A builder for [`DeleteRateBasedRuleOutput`](crate::output::DeleteRateBasedRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRateBasedRuleOutput`](crate::output::DeleteRateBasedRuleOutput)
        pub fn build(self) -> crate::output::DeleteRateBasedRuleOutput {
            crate::output::DeleteRateBasedRuleOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteRateBasedRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRateBasedRuleOutput`](crate::output::DeleteRateBasedRuleOutput)
    pub fn builder() -> crate::output::delete_rate_based_rule_output::Builder {
        crate::output::delete_rate_based_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePermissionPolicyOutput {}
impl std::fmt::Debug for DeletePermissionPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePermissionPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeletePermissionPolicyOutput`](crate::output::DeletePermissionPolicyOutput)
pub mod delete_permission_policy_output {
    /// A builder for [`DeletePermissionPolicyOutput`](crate::output::DeletePermissionPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePermissionPolicyOutput`](crate::output::DeletePermissionPolicyOutput)
        pub fn build(self) -> crate::output::DeletePermissionPolicyOutput {
            crate::output::DeletePermissionPolicyOutput {}
        }
    }
}
impl DeletePermissionPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeletePermissionPolicyOutput`](crate::output::DeletePermissionPolicyOutput)
    pub fn builder() -> crate::output::delete_permission_policy_output::Builder {
        crate::output::delete_permission_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoggingConfigurationOutput {}
impl std::fmt::Debug for DeleteLoggingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoggingConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteLoggingConfigurationOutput`](crate::output::DeleteLoggingConfigurationOutput)
pub mod delete_logging_configuration_output {
    /// A builder for [`DeleteLoggingConfigurationOutput`](crate::output::DeleteLoggingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLoggingConfigurationOutput`](crate::output::DeleteLoggingConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteLoggingConfigurationOutput {
            crate::output::DeleteLoggingConfigurationOutput {}
        }
    }
}
impl DeleteLoggingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLoggingConfigurationOutput`](crate::output::DeleteLoggingConfigurationOutput)
    pub fn builder() -> crate::output::delete_logging_configuration_output::Builder {
        crate::output::delete_logging_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIpSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteIpSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteIpSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIpSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteIpSetOutput`](crate::output::DeleteIpSetOutput)
pub mod delete_ip_set_output {
    /// A builder for [`DeleteIpSetOutput`](crate::output::DeleteIpSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIpSetOutput`](crate::output::DeleteIpSetOutput)
        pub fn build(self) -> crate::output::DeleteIpSetOutput {
            crate::output::DeleteIpSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteIpSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIpSetOutput`](crate::output::DeleteIpSetOutput)
    pub fn builder() -> crate::output::delete_ip_set_output::Builder {
        crate::output::delete_ip_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGeoMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteGeoMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteGeoMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGeoMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteGeoMatchSetOutput`](crate::output::DeleteGeoMatchSetOutput)
pub mod delete_geo_match_set_output {
    /// A builder for [`DeleteGeoMatchSetOutput`](crate::output::DeleteGeoMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGeoMatchSetOutput`](crate::output::DeleteGeoMatchSetOutput)
        pub fn build(self) -> crate::output::DeleteGeoMatchSetOutput {
            crate::output::DeleteGeoMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteGeoMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGeoMatchSetOutput`](crate::output::DeleteGeoMatchSetOutput)
    pub fn builder() -> crate::output::delete_geo_match_set_output::Builder {
        crate::output::delete_geo_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteByteMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl DeleteByteMatchSetOutput {
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteByteMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteByteMatchSetOutput");
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`DeleteByteMatchSetOutput`](crate::output::DeleteByteMatchSetOutput)
pub mod delete_byte_match_set_output {
    /// A builder for [`DeleteByteMatchSetOutput`](crate::output::DeleteByteMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>DeleteByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteByteMatchSetOutput`](crate::output::DeleteByteMatchSetOutput)
        pub fn build(self) -> crate::output::DeleteByteMatchSetOutput {
            crate::output::DeleteByteMatchSetOutput {
                change_token: self.change_token,
            }
        }
    }
}
impl DeleteByteMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteByteMatchSetOutput`](crate::output::DeleteByteMatchSetOutput)
    pub fn builder() -> crate::output::delete_byte_match_set_output::Builder {
        crate::output::delete_byte_match_set_output::Builder::default()
    }
}

/// <p>The response to a <code>CreateXssMatchSet</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateXssMatchSetOutput {
    /// <p>An <code>XssMatchSet</code>.</p>
    pub xss_match_set: std::option::Option<crate::model::XssMatchSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateXssMatchSetOutput {
    /// <p>An <code>XssMatchSet</code>.</p>
    pub fn xss_match_set(&self) -> std::option::Option<&crate::model::XssMatchSet> {
        self.xss_match_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateXssMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateXssMatchSetOutput");
        formatter.field("xss_match_set", &self.xss_match_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateXssMatchSetOutput`](crate::output::CreateXssMatchSetOutput)
pub mod create_xss_match_set_output {
    /// A builder for [`CreateXssMatchSetOutput`](crate::output::CreateXssMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xss_match_set: std::option::Option<crate::model::XssMatchSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An <code>XssMatchSet</code>.</p>
        pub fn xss_match_set(mut self, input: crate::model::XssMatchSet) -> Self {
            self.xss_match_set = Some(input);
            self
        }
        /// <p>An <code>XssMatchSet</code>.</p>
        pub fn set_xss_match_set(
            mut self,
            input: std::option::Option<crate::model::XssMatchSet>,
        ) -> Self {
            self.xss_match_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateXssMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateXssMatchSetOutput`](crate::output::CreateXssMatchSetOutput)
        pub fn build(self) -> crate::output::CreateXssMatchSetOutput {
            crate::output::CreateXssMatchSetOutput {
                xss_match_set: self.xss_match_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateXssMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateXssMatchSetOutput`](crate::output::CreateXssMatchSetOutput)
    pub fn builder() -> crate::output::create_xss_match_set_output::Builder {
        crate::output::create_xss_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWebAclMigrationStackOutput {
    /// <p>The URL of the template created in Amazon S3. </p>
    pub s3_object_url: std::option::Option<std::string::String>,
}
impl CreateWebAclMigrationStackOutput {
    /// <p>The URL of the template created in Amazon S3. </p>
    pub fn s3_object_url(&self) -> std::option::Option<&str> {
        self.s3_object_url.as_deref()
    }
}
impl std::fmt::Debug for CreateWebAclMigrationStackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWebAclMigrationStackOutput");
        formatter.field("s3_object_url", &self.s3_object_url);
        formatter.finish()
    }
}
/// See [`CreateWebAclMigrationStackOutput`](crate::output::CreateWebAclMigrationStackOutput)
pub mod create_web_acl_migration_stack_output {
    /// A builder for [`CreateWebAclMigrationStackOutput`](crate::output::CreateWebAclMigrationStackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_object_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of the template created in Amazon S3. </p>
        pub fn s3_object_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_object_url = Some(input.into());
            self
        }
        /// <p>The URL of the template created in Amazon S3. </p>
        pub fn set_s3_object_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_object_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWebAclMigrationStackOutput`](crate::output::CreateWebAclMigrationStackOutput)
        pub fn build(self) -> crate::output::CreateWebAclMigrationStackOutput {
            crate::output::CreateWebAclMigrationStackOutput {
                s3_object_url: self.s3_object_url,
            }
        }
    }
}
impl CreateWebAclMigrationStackOutput {
    /// Creates a new builder-style object to manufacture [`CreateWebAclMigrationStackOutput`](crate::output::CreateWebAclMigrationStackOutput)
    pub fn builder() -> crate::output::create_web_acl_migration_stack_output::Builder {
        crate::output::create_web_acl_migration_stack_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWebAclOutput {
    /// <p>The <code>WebACL</code> returned in the <code>CreateWebACL</code> response.</p>
    pub web_acl: std::option::Option<crate::model::WebAcl>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateWebAclOutput {
    /// <p>The <code>WebACL</code> returned in the <code>CreateWebACL</code> response.</p>
    pub fn web_acl(&self) -> std::option::Option<&crate::model::WebAcl> {
        self.web_acl.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateWebAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWebAclOutput");
        formatter.field("web_acl", &self.web_acl);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateWebAclOutput`](crate::output::CreateWebAclOutput)
pub mod create_web_acl_output {
    /// A builder for [`CreateWebAclOutput`](crate::output::CreateWebAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) web_acl: std::option::Option<crate::model::WebAcl>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>WebACL</code> returned in the <code>CreateWebACL</code> response.</p>
        pub fn web_acl(mut self, input: crate::model::WebAcl) -> Self {
            self.web_acl = Some(input);
            self
        }
        /// <p>The <code>WebACL</code> returned in the <code>CreateWebACL</code> response.</p>
        pub fn set_web_acl(mut self, input: std::option::Option<crate::model::WebAcl>) -> Self {
            self.web_acl = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateWebACL</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWebAclOutput`](crate::output::CreateWebAclOutput)
        pub fn build(self) -> crate::output::CreateWebAclOutput {
            crate::output::CreateWebAclOutput {
                web_acl: self.web_acl,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateWebAclOutput {
    /// Creates a new builder-style object to manufacture [`CreateWebAclOutput`](crate::output::CreateWebAclOutput)
    pub fn builder() -> crate::output::create_web_acl_output::Builder {
        crate::output::create_web_acl_output::Builder::default()
    }
}

/// <p>The response to a <code>CreateSqlInjectionMatchSet</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSqlInjectionMatchSetOutput {
    /// <p>A <code>SqlInjectionMatchSet</code>.</p>
    pub sql_injection_match_set: std::option::Option<crate::model::SqlInjectionMatchSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateSqlInjectionMatchSetOutput {
    /// <p>A <code>SqlInjectionMatchSet</code>.</p>
    pub fn sql_injection_match_set(
        &self,
    ) -> std::option::Option<&crate::model::SqlInjectionMatchSet> {
        self.sql_injection_match_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateSqlInjectionMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSqlInjectionMatchSetOutput");
        formatter.field("sql_injection_match_set", &self.sql_injection_match_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateSqlInjectionMatchSetOutput`](crate::output::CreateSqlInjectionMatchSetOutput)
pub mod create_sql_injection_match_set_output {
    /// A builder for [`CreateSqlInjectionMatchSetOutput`](crate::output::CreateSqlInjectionMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql_injection_match_set: std::option::Option<crate::model::SqlInjectionMatchSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>SqlInjectionMatchSet</code>.</p>
        pub fn sql_injection_match_set(
            mut self,
            input: crate::model::SqlInjectionMatchSet,
        ) -> Self {
            self.sql_injection_match_set = Some(input);
            self
        }
        /// <p>A <code>SqlInjectionMatchSet</code>.</p>
        pub fn set_sql_injection_match_set(
            mut self,
            input: std::option::Option<crate::model::SqlInjectionMatchSet>,
        ) -> Self {
            self.sql_injection_match_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSqlInjectionMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSqlInjectionMatchSetOutput`](crate::output::CreateSqlInjectionMatchSetOutput)
        pub fn build(self) -> crate::output::CreateSqlInjectionMatchSetOutput {
            crate::output::CreateSqlInjectionMatchSetOutput {
                sql_injection_match_set: self.sql_injection_match_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateSqlInjectionMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateSqlInjectionMatchSetOutput`](crate::output::CreateSqlInjectionMatchSetOutput)
    pub fn builder() -> crate::output::create_sql_injection_match_set_output::Builder {
        crate::output::create_sql_injection_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSizeConstraintSetOutput {
    /// <p>A <code>SizeConstraintSet</code> that contains no <code>SizeConstraint</code> objects.</p>
    pub size_constraint_set: std::option::Option<crate::model::SizeConstraintSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateSizeConstraintSetOutput {
    /// <p>A <code>SizeConstraintSet</code> that contains no <code>SizeConstraint</code> objects.</p>
    pub fn size_constraint_set(&self) -> std::option::Option<&crate::model::SizeConstraintSet> {
        self.size_constraint_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateSizeConstraintSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSizeConstraintSetOutput");
        formatter.field("size_constraint_set", &self.size_constraint_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateSizeConstraintSetOutput`](crate::output::CreateSizeConstraintSetOutput)
pub mod create_size_constraint_set_output {
    /// A builder for [`CreateSizeConstraintSetOutput`](crate::output::CreateSizeConstraintSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_constraint_set: std::option::Option<crate::model::SizeConstraintSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>SizeConstraintSet</code> that contains no <code>SizeConstraint</code> objects.</p>
        pub fn size_constraint_set(mut self, input: crate::model::SizeConstraintSet) -> Self {
            self.size_constraint_set = Some(input);
            self
        }
        /// <p>A <code>SizeConstraintSet</code> that contains no <code>SizeConstraint</code> objects.</p>
        pub fn set_size_constraint_set(
            mut self,
            input: std::option::Option<crate::model::SizeConstraintSet>,
        ) -> Self {
            self.size_constraint_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateSizeConstraintSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSizeConstraintSetOutput`](crate::output::CreateSizeConstraintSetOutput)
        pub fn build(self) -> crate::output::CreateSizeConstraintSetOutput {
            crate::output::CreateSizeConstraintSetOutput {
                size_constraint_set: self.size_constraint_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateSizeConstraintSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateSizeConstraintSetOutput`](crate::output::CreateSizeConstraintSetOutput)
    pub fn builder() -> crate::output::create_size_constraint_set_output::Builder {
        crate::output::create_size_constraint_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleGroupOutput {
    /// <p>An empty <code>RuleGroup</code>.</p>
    pub rule_group: std::option::Option<crate::model::RuleGroup>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateRuleGroupOutput {
    /// <p>An empty <code>RuleGroup</code>.</p>
    pub fn rule_group(&self) -> std::option::Option<&crate::model::RuleGroup> {
        self.rule_group.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleGroupOutput");
        formatter.field("rule_group", &self.rule_group);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
pub mod create_rule_group_output {
    /// A builder for [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_group: std::option::Option<crate::model::RuleGroup>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An empty <code>RuleGroup</code>.</p>
        pub fn rule_group(mut self, input: crate::model::RuleGroup) -> Self {
            self.rule_group = Some(input);
            self
        }
        /// <p>An empty <code>RuleGroup</code>.</p>
        pub fn set_rule_group(
            mut self,
            input: std::option::Option<crate::model::RuleGroup>,
        ) -> Self {
            self.rule_group = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
        pub fn build(self) -> crate::output::CreateRuleGroupOutput {
            crate::output::CreateRuleGroupOutput {
                rule_group: self.rule_group,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleGroupOutput`](crate::output::CreateRuleGroupOutput)
    pub fn builder() -> crate::output::create_rule_group_output::Builder {
        crate::output::create_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRuleOutput {
    /// <p>The <code>Rule</code> returned in the <code>CreateRule</code> response.</p>
    pub rule: std::option::Option<crate::model::Rule>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateRuleOutput {
    /// <p>The <code>Rule</code> returned in the <code>CreateRule</code> response.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::Rule> {
        self.rule.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRuleOutput");
        formatter.field("rule", &self.rule);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateRuleOutput`](crate::output::CreateRuleOutput)
pub mod create_rule_output {
    /// A builder for [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::Rule>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>Rule</code> returned in the <code>CreateRule</code> response.</p>
        pub fn rule(mut self, input: crate::model::Rule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The <code>Rule</code> returned in the <code>CreateRule</code> response.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Rule>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRuleOutput`](crate::output::CreateRuleOutput)
        pub fn build(self) -> crate::output::CreateRuleOutput {
            crate::output::CreateRuleOutput {
                rule: self.rule,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateRuleOutput`](crate::output::CreateRuleOutput)
    pub fn builder() -> crate::output::create_rule_output::Builder {
        crate::output::create_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRegexPatternSetOutput {
    /// <p>A <code>RegexPatternSet</code> that contains no objects.</p>
    pub regex_pattern_set: std::option::Option<crate::model::RegexPatternSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateRegexPatternSetOutput {
    /// <p>A <code>RegexPatternSet</code> that contains no objects.</p>
    pub fn regex_pattern_set(&self) -> std::option::Option<&crate::model::RegexPatternSet> {
        self.regex_pattern_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateRegexPatternSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRegexPatternSetOutput");
        formatter.field("regex_pattern_set", &self.regex_pattern_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateRegexPatternSetOutput`](crate::output::CreateRegexPatternSetOutput)
pub mod create_regex_pattern_set_output {
    /// A builder for [`CreateRegexPatternSetOutput`](crate::output::CreateRegexPatternSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_pattern_set: std::option::Option<crate::model::RegexPatternSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>RegexPatternSet</code> that contains no objects.</p>
        pub fn regex_pattern_set(mut self, input: crate::model::RegexPatternSet) -> Self {
            self.regex_pattern_set = Some(input);
            self
        }
        /// <p>A <code>RegexPatternSet</code> that contains no objects.</p>
        pub fn set_regex_pattern_set(
            mut self,
            input: std::option::Option<crate::model::RegexPatternSet>,
        ) -> Self {
            self.regex_pattern_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexPatternSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRegexPatternSetOutput`](crate::output::CreateRegexPatternSetOutput)
        pub fn build(self) -> crate::output::CreateRegexPatternSetOutput {
            crate::output::CreateRegexPatternSetOutput {
                regex_pattern_set: self.regex_pattern_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateRegexPatternSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateRegexPatternSetOutput`](crate::output::CreateRegexPatternSetOutput)
    pub fn builder() -> crate::output::create_regex_pattern_set_output::Builder {
        crate::output::create_regex_pattern_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRegexMatchSetOutput {
    /// <p>A <code>RegexMatchSet</code> that contains no <code>RegexMatchTuple</code> objects.</p>
    pub regex_match_set: std::option::Option<crate::model::RegexMatchSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateRegexMatchSetOutput {
    /// <p>A <code>RegexMatchSet</code> that contains no <code>RegexMatchTuple</code> objects.</p>
    pub fn regex_match_set(&self) -> std::option::Option<&crate::model::RegexMatchSet> {
        self.regex_match_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateRegexMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRegexMatchSetOutput");
        formatter.field("regex_match_set", &self.regex_match_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateRegexMatchSetOutput`](crate::output::CreateRegexMatchSetOutput)
pub mod create_regex_match_set_output {
    /// A builder for [`CreateRegexMatchSetOutput`](crate::output::CreateRegexMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_match_set: std::option::Option<crate::model::RegexMatchSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>RegexMatchSet</code> that contains no <code>RegexMatchTuple</code> objects.</p>
        pub fn regex_match_set(mut self, input: crate::model::RegexMatchSet) -> Self {
            self.regex_match_set = Some(input);
            self
        }
        /// <p>A <code>RegexMatchSet</code> that contains no <code>RegexMatchTuple</code> objects.</p>
        pub fn set_regex_match_set(
            mut self,
            input: std::option::Option<crate::model::RegexMatchSet>,
        ) -> Self {
            self.regex_match_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRegexMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRegexMatchSetOutput`](crate::output::CreateRegexMatchSetOutput)
        pub fn build(self) -> crate::output::CreateRegexMatchSetOutput {
            crate::output::CreateRegexMatchSetOutput {
                regex_match_set: self.regex_match_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateRegexMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateRegexMatchSetOutput`](crate::output::CreateRegexMatchSetOutput)
    pub fn builder() -> crate::output::create_regex_match_set_output::Builder {
        crate::output::create_regex_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRateBasedRuleOutput {
    /// <p>The <code>RateBasedRule</code> that is returned in the <code>CreateRateBasedRule</code> response.</p>
    pub rule: std::option::Option<crate::model::RateBasedRule>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateRateBasedRuleOutput {
    /// <p>The <code>RateBasedRule</code> that is returned in the <code>CreateRateBasedRule</code> response.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::RateBasedRule> {
        self.rule.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateRateBasedRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRateBasedRuleOutput");
        formatter.field("rule", &self.rule);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateRateBasedRuleOutput`](crate::output::CreateRateBasedRuleOutput)
pub mod create_rate_based_rule_output {
    /// A builder for [`CreateRateBasedRuleOutput`](crate::output::CreateRateBasedRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule: std::option::Option<crate::model::RateBasedRule>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>RateBasedRule</code> that is returned in the <code>CreateRateBasedRule</code> response.</p>
        pub fn rule(mut self, input: crate::model::RateBasedRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>The <code>RateBasedRule</code> that is returned in the <code>CreateRateBasedRule</code> response.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::RateBasedRule>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateRateBasedRule</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRateBasedRuleOutput`](crate::output::CreateRateBasedRuleOutput)
        pub fn build(self) -> crate::output::CreateRateBasedRuleOutput {
            crate::output::CreateRateBasedRuleOutput {
                rule: self.rule,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateRateBasedRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateRateBasedRuleOutput`](crate::output::CreateRateBasedRuleOutput)
    pub fn builder() -> crate::output::create_rate_based_rule_output::Builder {
        crate::output::create_rate_based_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIpSetOutput {
    /// <p>The <code>IPSet</code> returned in the <code>CreateIPSet</code> response.</p>
    pub ip_set: std::option::Option<crate::model::IpSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateIpSetOutput {
    /// <p>The <code>IPSet</code> returned in the <code>CreateIPSet</code> response.</p>
    pub fn ip_set(&self) -> std::option::Option<&crate::model::IpSet> {
        self.ip_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateIpSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIpSetOutput");
        formatter.field("ip_set", &self.ip_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateIpSetOutput`](crate::output::CreateIpSetOutput)
pub mod create_ip_set_output {
    /// A builder for [`CreateIpSetOutput`](crate::output::CreateIpSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_set: std::option::Option<crate::model::IpSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>IPSet</code> returned in the <code>CreateIPSet</code> response.</p>
        pub fn ip_set(mut self, input: crate::model::IpSet) -> Self {
            self.ip_set = Some(input);
            self
        }
        /// <p>The <code>IPSet</code> returned in the <code>CreateIPSet</code> response.</p>
        pub fn set_ip_set(mut self, input: std::option::Option<crate::model::IpSet>) -> Self {
            self.ip_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateIPSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIpSetOutput`](crate::output::CreateIpSetOutput)
        pub fn build(self) -> crate::output::CreateIpSetOutput {
            crate::output::CreateIpSetOutput {
                ip_set: self.ip_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateIpSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateIpSetOutput`](crate::output::CreateIpSetOutput)
    pub fn builder() -> crate::output::create_ip_set_output::Builder {
        crate::output::create_ip_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGeoMatchSetOutput {
    /// <p>The <code>GeoMatchSet</code> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.</p>
    pub geo_match_set: std::option::Option<crate::model::GeoMatchSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateGeoMatchSetOutput {
    /// <p>The <code>GeoMatchSet</code> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.</p>
    pub fn geo_match_set(&self) -> std::option::Option<&crate::model::GeoMatchSet> {
        self.geo_match_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateGeoMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGeoMatchSetOutput");
        formatter.field("geo_match_set", &self.geo_match_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateGeoMatchSetOutput`](crate::output::CreateGeoMatchSetOutput)
pub mod create_geo_match_set_output {
    /// A builder for [`CreateGeoMatchSetOutput`](crate::output::CreateGeoMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_match_set: std::option::Option<crate::model::GeoMatchSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>GeoMatchSet</code> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.</p>
        pub fn geo_match_set(mut self, input: crate::model::GeoMatchSet) -> Self {
            self.geo_match_set = Some(input);
            self
        }
        /// <p>The <code>GeoMatchSet</code> returned in the <code>CreateGeoMatchSet</code> response. The <code>GeoMatchSet</code> contains no <code>GeoMatchConstraints</code>.</p>
        pub fn set_geo_match_set(
            mut self,
            input: std::option::Option<crate::model::GeoMatchSet>,
        ) -> Self {
            self.geo_match_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateGeoMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGeoMatchSetOutput`](crate::output::CreateGeoMatchSetOutput)
        pub fn build(self) -> crate::output::CreateGeoMatchSetOutput {
            crate::output::CreateGeoMatchSetOutput {
                geo_match_set: self.geo_match_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateGeoMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateGeoMatchSetOutput`](crate::output::CreateGeoMatchSetOutput)
    pub fn builder() -> crate::output::create_geo_match_set_output::Builder {
        crate::output::create_geo_match_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateByteMatchSetOutput {
    /// <p>A <code>ByteMatchSet</code> that contains no <code>ByteMatchTuple</code> objects.</p>
    pub byte_match_set: std::option::Option<crate::model::ByteMatchSet>,
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub change_token: std::option::Option<std::string::String>,
}
impl CreateByteMatchSetOutput {
    /// <p>A <code>ByteMatchSet</code> that contains no <code>ByteMatchTuple</code> objects.</p>
    pub fn byte_match_set(&self) -> std::option::Option<&crate::model::ByteMatchSet> {
        self.byte_match_set.as_ref()
    }
    /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
    pub fn change_token(&self) -> std::option::Option<&str> {
        self.change_token.as_deref()
    }
}
impl std::fmt::Debug for CreateByteMatchSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateByteMatchSetOutput");
        formatter.field("byte_match_set", &self.byte_match_set);
        formatter.field("change_token", &self.change_token);
        formatter.finish()
    }
}
/// See [`CreateByteMatchSetOutput`](crate::output::CreateByteMatchSetOutput)
pub mod create_byte_match_set_output {
    /// A builder for [`CreateByteMatchSetOutput`](crate::output::CreateByteMatchSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) byte_match_set: std::option::Option<crate::model::ByteMatchSet>,
        pub(crate) change_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <code>ByteMatchSet</code> that contains no <code>ByteMatchTuple</code> objects.</p>
        pub fn byte_match_set(mut self, input: crate::model::ByteMatchSet) -> Self {
            self.byte_match_set = Some(input);
            self
        }
        /// <p>A <code>ByteMatchSet</code> that contains no <code>ByteMatchTuple</code> objects.</p>
        pub fn set_byte_match_set(
            mut self,
            input: std::option::Option<crate::model::ByteMatchSet>,
        ) -> Self {
            self.byte_match_set = input;
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn change_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_token = Some(input.into());
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the <code>CreateByteMatchSet</code> request. You can also use this value to query the status of the request. For more information, see <code>GetChangeTokenStatus</code>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateByteMatchSetOutput`](crate::output::CreateByteMatchSetOutput)
        pub fn build(self) -> crate::output::CreateByteMatchSetOutput {
            crate::output::CreateByteMatchSetOutput {
                byte_match_set: self.byte_match_set,
                change_token: self.change_token,
            }
        }
    }
}
impl CreateByteMatchSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateByteMatchSetOutput`](crate::output::CreateByteMatchSetOutput)
    pub fn builder() -> crate::output::create_byte_match_set_output::Builder {
        crate::output::create_byte_match_set_output::Builder::default()
    }
}
