// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSWAF_20150824`.
///
/// This client allows ergonomic access to a `AWSWAF_20150824`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateByteMatchSet` operation.
    ///
    /// See [`CreateByteMatchSet`](crate::client::fluent_builders::CreateByteMatchSet) for more information about the
    /// operation and its arguments.
    pub fn create_byte_match_set(&self) -> fluent_builders::CreateByteMatchSet<C, M, R> {
        fluent_builders::CreateByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGeoMatchSet` operation.
    ///
    /// See [`CreateGeoMatchSet`](crate::client::fluent_builders::CreateGeoMatchSet) for more information about the
    /// operation and its arguments.
    pub fn create_geo_match_set(&self) -> fluent_builders::CreateGeoMatchSet<C, M, R> {
        fluent_builders::CreateGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIPSet` operation.
    ///
    /// See [`CreateIPSet`](crate::client::fluent_builders::CreateIPSet) for more information about the
    /// operation and its arguments.
    pub fn create_ip_set(&self) -> fluent_builders::CreateIPSet<C, M, R> {
        fluent_builders::CreateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRateBasedRule` operation.
    ///
    /// See [`CreateRateBasedRule`](crate::client::fluent_builders::CreateRateBasedRule) for more information about the
    /// operation and its arguments.
    pub fn create_rate_based_rule(&self) -> fluent_builders::CreateRateBasedRule<C, M, R> {
        fluent_builders::CreateRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRegexMatchSet` operation.
    ///
    /// See [`CreateRegexMatchSet`](crate::client::fluent_builders::CreateRegexMatchSet) for more information about the
    /// operation and its arguments.
    pub fn create_regex_match_set(&self) -> fluent_builders::CreateRegexMatchSet<C, M, R> {
        fluent_builders::CreateRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRegexPatternSet` operation.
    ///
    /// See [`CreateRegexPatternSet`](crate::client::fluent_builders::CreateRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn create_regex_pattern_set(&self) -> fluent_builders::CreateRegexPatternSet<C, M, R> {
        fluent_builders::CreateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRule` operation.
    ///
    /// See [`CreateRule`](crate::client::fluent_builders::CreateRule) for more information about the
    /// operation and its arguments.
    pub fn create_rule(&self) -> fluent_builders::CreateRule<C, M, R> {
        fluent_builders::CreateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRuleGroup` operation.
    ///
    /// See [`CreateRuleGroup`](crate::client::fluent_builders::CreateRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn create_rule_group(&self) -> fluent_builders::CreateRuleGroup<C, M, R> {
        fluent_builders::CreateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSizeConstraintSet` operation.
    ///
    /// See [`CreateSizeConstraintSet`](crate::client::fluent_builders::CreateSizeConstraintSet) for more information about the
    /// operation and its arguments.
    pub fn create_size_constraint_set(&self) -> fluent_builders::CreateSizeConstraintSet<C, M, R> {
        fluent_builders::CreateSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSqlInjectionMatchSet` operation.
    ///
    /// See [`CreateSqlInjectionMatchSet`](crate::client::fluent_builders::CreateSqlInjectionMatchSet) for more information about the
    /// operation and its arguments.
    pub fn create_sql_injection_match_set(
        &self,
    ) -> fluent_builders::CreateSqlInjectionMatchSet<C, M, R> {
        fluent_builders::CreateSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWebACL` operation.
    ///
    /// See [`CreateWebACL`](crate::client::fluent_builders::CreateWebACL) for more information about the
    /// operation and its arguments.
    pub fn create_web_acl(&self) -> fluent_builders::CreateWebACL<C, M, R> {
        fluent_builders::CreateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWebACLMigrationStack` operation.
    ///
    /// See [`CreateWebACLMigrationStack`](crate::client::fluent_builders::CreateWebACLMigrationStack) for more information about the
    /// operation and its arguments.
    pub fn create_web_acl_migration_stack(
        &self,
    ) -> fluent_builders::CreateWebACLMigrationStack<C, M, R> {
        fluent_builders::CreateWebACLMigrationStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateXssMatchSet` operation.
    ///
    /// See [`CreateXssMatchSet`](crate::client::fluent_builders::CreateXssMatchSet) for more information about the
    /// operation and its arguments.
    pub fn create_xss_match_set(&self) -> fluent_builders::CreateXssMatchSet<C, M, R> {
        fluent_builders::CreateXssMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteByteMatchSet` operation.
    ///
    /// See [`DeleteByteMatchSet`](crate::client::fluent_builders::DeleteByteMatchSet) for more information about the
    /// operation and its arguments.
    pub fn delete_byte_match_set(&self) -> fluent_builders::DeleteByteMatchSet<C, M, R> {
        fluent_builders::DeleteByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGeoMatchSet` operation.
    ///
    /// See [`DeleteGeoMatchSet`](crate::client::fluent_builders::DeleteGeoMatchSet) for more information about the
    /// operation and its arguments.
    pub fn delete_geo_match_set(&self) -> fluent_builders::DeleteGeoMatchSet<C, M, R> {
        fluent_builders::DeleteGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIPSet` operation.
    ///
    /// See [`DeleteIPSet`](crate::client::fluent_builders::DeleteIPSet) for more information about the
    /// operation and its arguments.
    pub fn delete_ip_set(&self) -> fluent_builders::DeleteIPSet<C, M, R> {
        fluent_builders::DeleteIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoggingConfiguration` operation.
    ///
    /// See [`DeleteLoggingConfiguration`](crate::client::fluent_builders::DeleteLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_logging_configuration(
        &self,
    ) -> fluent_builders::DeleteLoggingConfiguration<C, M, R> {
        fluent_builders::DeleteLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePermissionPolicy` operation.
    ///
    /// See [`DeletePermissionPolicy`](crate::client::fluent_builders::DeletePermissionPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_permission_policy(&self) -> fluent_builders::DeletePermissionPolicy<C, M, R> {
        fluent_builders::DeletePermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRateBasedRule` operation.
    ///
    /// See [`DeleteRateBasedRule`](crate::client::fluent_builders::DeleteRateBasedRule) for more information about the
    /// operation and its arguments.
    pub fn delete_rate_based_rule(&self) -> fluent_builders::DeleteRateBasedRule<C, M, R> {
        fluent_builders::DeleteRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRegexMatchSet` operation.
    ///
    /// See [`DeleteRegexMatchSet`](crate::client::fluent_builders::DeleteRegexMatchSet) for more information about the
    /// operation and its arguments.
    pub fn delete_regex_match_set(&self) -> fluent_builders::DeleteRegexMatchSet<C, M, R> {
        fluent_builders::DeleteRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRegexPatternSet` operation.
    ///
    /// See [`DeleteRegexPatternSet`](crate::client::fluent_builders::DeleteRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn delete_regex_pattern_set(&self) -> fluent_builders::DeleteRegexPatternSet<C, M, R> {
        fluent_builders::DeleteRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRule` operation.
    ///
    /// See [`DeleteRule`](crate::client::fluent_builders::DeleteRule) for more information about the
    /// operation and its arguments.
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule<C, M, R> {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRuleGroup` operation.
    ///
    /// See [`DeleteRuleGroup`](crate::client::fluent_builders::DeleteRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_rule_group(&self) -> fluent_builders::DeleteRuleGroup<C, M, R> {
        fluent_builders::DeleteRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSizeConstraintSet` operation.
    ///
    /// See [`DeleteSizeConstraintSet`](crate::client::fluent_builders::DeleteSizeConstraintSet) for more information about the
    /// operation and its arguments.
    pub fn delete_size_constraint_set(&self) -> fluent_builders::DeleteSizeConstraintSet<C, M, R> {
        fluent_builders::DeleteSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSqlInjectionMatchSet` operation.
    ///
    /// See [`DeleteSqlInjectionMatchSet`](crate::client::fluent_builders::DeleteSqlInjectionMatchSet) for more information about the
    /// operation and its arguments.
    pub fn delete_sql_injection_match_set(
        &self,
    ) -> fluent_builders::DeleteSqlInjectionMatchSet<C, M, R> {
        fluent_builders::DeleteSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWebACL` operation.
    ///
    /// See [`DeleteWebACL`](crate::client::fluent_builders::DeleteWebACL) for more information about the
    /// operation and its arguments.
    pub fn delete_web_acl(&self) -> fluent_builders::DeleteWebACL<C, M, R> {
        fluent_builders::DeleteWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteXssMatchSet` operation.
    ///
    /// See [`DeleteXssMatchSet`](crate::client::fluent_builders::DeleteXssMatchSet) for more information about the
    /// operation and its arguments.
    pub fn delete_xss_match_set(&self) -> fluent_builders::DeleteXssMatchSet<C, M, R> {
        fluent_builders::DeleteXssMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetByteMatchSet` operation.
    ///
    /// See [`GetByteMatchSet`](crate::client::fluent_builders::GetByteMatchSet) for more information about the
    /// operation and its arguments.
    pub fn get_byte_match_set(&self) -> fluent_builders::GetByteMatchSet<C, M, R> {
        fluent_builders::GetByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChangeToken` operation.
    ///
    /// See [`GetChangeToken`](crate::client::fluent_builders::GetChangeToken) for more information about the
    /// operation and its arguments.
    pub fn get_change_token(&self) -> fluent_builders::GetChangeToken<C, M, R> {
        fluent_builders::GetChangeToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChangeTokenStatus` operation.
    ///
    /// See [`GetChangeTokenStatus`](crate::client::fluent_builders::GetChangeTokenStatus) for more information about the
    /// operation and its arguments.
    pub fn get_change_token_status(&self) -> fluent_builders::GetChangeTokenStatus<C, M, R> {
        fluent_builders::GetChangeTokenStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGeoMatchSet` operation.
    ///
    /// See [`GetGeoMatchSet`](crate::client::fluent_builders::GetGeoMatchSet) for more information about the
    /// operation and its arguments.
    pub fn get_geo_match_set(&self) -> fluent_builders::GetGeoMatchSet<C, M, R> {
        fluent_builders::GetGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIPSet` operation.
    ///
    /// See [`GetIPSet`](crate::client::fluent_builders::GetIPSet) for more information about the
    /// operation and its arguments.
    pub fn get_ip_set(&self) -> fluent_builders::GetIPSet<C, M, R> {
        fluent_builders::GetIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoggingConfiguration` operation.
    ///
    /// See [`GetLoggingConfiguration`](crate::client::fluent_builders::GetLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_logging_configuration(&self) -> fluent_builders::GetLoggingConfiguration<C, M, R> {
        fluent_builders::GetLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPermissionPolicy` operation.
    ///
    /// See [`GetPermissionPolicy`](crate::client::fluent_builders::GetPermissionPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_permission_policy(&self) -> fluent_builders::GetPermissionPolicy<C, M, R> {
        fluent_builders::GetPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRateBasedRule` operation.
    ///
    /// See [`GetRateBasedRule`](crate::client::fluent_builders::GetRateBasedRule) for more information about the
    /// operation and its arguments.
    pub fn get_rate_based_rule(&self) -> fluent_builders::GetRateBasedRule<C, M, R> {
        fluent_builders::GetRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRateBasedRuleManagedKeys` operation.
    ///
    /// See [`GetRateBasedRuleManagedKeys`](crate::client::fluent_builders::GetRateBasedRuleManagedKeys) for more information about the
    /// operation and its arguments.
    pub fn get_rate_based_rule_managed_keys(
        &self,
    ) -> fluent_builders::GetRateBasedRuleManagedKeys<C, M, R> {
        fluent_builders::GetRateBasedRuleManagedKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegexMatchSet` operation.
    ///
    /// See [`GetRegexMatchSet`](crate::client::fluent_builders::GetRegexMatchSet) for more information about the
    /// operation and its arguments.
    pub fn get_regex_match_set(&self) -> fluent_builders::GetRegexMatchSet<C, M, R> {
        fluent_builders::GetRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegexPatternSet` operation.
    ///
    /// See [`GetRegexPatternSet`](crate::client::fluent_builders::GetRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn get_regex_pattern_set(&self) -> fluent_builders::GetRegexPatternSet<C, M, R> {
        fluent_builders::GetRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRule` operation.
    ///
    /// See [`GetRule`](crate::client::fluent_builders::GetRule) for more information about the
    /// operation and its arguments.
    pub fn get_rule(&self) -> fluent_builders::GetRule<C, M, R> {
        fluent_builders::GetRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRuleGroup` operation.
    ///
    /// See [`GetRuleGroup`](crate::client::fluent_builders::GetRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn get_rule_group(&self) -> fluent_builders::GetRuleGroup<C, M, R> {
        fluent_builders::GetRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSampledRequests` operation.
    ///
    /// See [`GetSampledRequests`](crate::client::fluent_builders::GetSampledRequests) for more information about the
    /// operation and its arguments.
    pub fn get_sampled_requests(&self) -> fluent_builders::GetSampledRequests<C, M, R> {
        fluent_builders::GetSampledRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSizeConstraintSet` operation.
    ///
    /// See [`GetSizeConstraintSet`](crate::client::fluent_builders::GetSizeConstraintSet) for more information about the
    /// operation and its arguments.
    pub fn get_size_constraint_set(&self) -> fluent_builders::GetSizeConstraintSet<C, M, R> {
        fluent_builders::GetSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSqlInjectionMatchSet` operation.
    ///
    /// See [`GetSqlInjectionMatchSet`](crate::client::fluent_builders::GetSqlInjectionMatchSet) for more information about the
    /// operation and its arguments.
    pub fn get_sql_injection_match_set(&self) -> fluent_builders::GetSqlInjectionMatchSet<C, M, R> {
        fluent_builders::GetSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWebACL` operation.
    ///
    /// See [`GetWebACL`](crate::client::fluent_builders::GetWebACL) for more information about the
    /// operation and its arguments.
    pub fn get_web_acl(&self) -> fluent_builders::GetWebACL<C, M, R> {
        fluent_builders::GetWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetXssMatchSet` operation.
    ///
    /// See [`GetXssMatchSet`](crate::client::fluent_builders::GetXssMatchSet) for more information about the
    /// operation and its arguments.
    pub fn get_xss_match_set(&self) -> fluent_builders::GetXssMatchSet<C, M, R> {
        fluent_builders::GetXssMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActivatedRulesInRuleGroup` operation.
    ///
    /// See [`ListActivatedRulesInRuleGroup`](crate::client::fluent_builders::ListActivatedRulesInRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn list_activated_rules_in_rule_group(
        &self,
    ) -> fluent_builders::ListActivatedRulesInRuleGroup<C, M, R> {
        fluent_builders::ListActivatedRulesInRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListByteMatchSets` operation.
    ///
    /// See [`ListByteMatchSets`](crate::client::fluent_builders::ListByteMatchSets) for more information about the
    /// operation and its arguments.
    pub fn list_byte_match_sets(&self) -> fluent_builders::ListByteMatchSets<C, M, R> {
        fluent_builders::ListByteMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGeoMatchSets` operation.
    ///
    /// See [`ListGeoMatchSets`](crate::client::fluent_builders::ListGeoMatchSets) for more information about the
    /// operation and its arguments.
    pub fn list_geo_match_sets(&self) -> fluent_builders::ListGeoMatchSets<C, M, R> {
        fluent_builders::ListGeoMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIPSets` operation.
    ///
    /// See [`ListIPSets`](crate::client::fluent_builders::ListIPSets) for more information about the
    /// operation and its arguments.
    pub fn list_ip_sets(&self) -> fluent_builders::ListIPSets<C, M, R> {
        fluent_builders::ListIPSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLoggingConfigurations` operation.
    ///
    /// See [`ListLoggingConfigurations`](crate::client::fluent_builders::ListLoggingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_logging_configurations(
        &self,
    ) -> fluent_builders::ListLoggingConfigurations<C, M, R> {
        fluent_builders::ListLoggingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRateBasedRules` operation.
    ///
    /// See [`ListRateBasedRules`](crate::client::fluent_builders::ListRateBasedRules) for more information about the
    /// operation and its arguments.
    pub fn list_rate_based_rules(&self) -> fluent_builders::ListRateBasedRules<C, M, R> {
        fluent_builders::ListRateBasedRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRegexMatchSets` operation.
    ///
    /// See [`ListRegexMatchSets`](crate::client::fluent_builders::ListRegexMatchSets) for more information about the
    /// operation and its arguments.
    pub fn list_regex_match_sets(&self) -> fluent_builders::ListRegexMatchSets<C, M, R> {
        fluent_builders::ListRegexMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRegexPatternSets` operation.
    ///
    /// See [`ListRegexPatternSets`](crate::client::fluent_builders::ListRegexPatternSets) for more information about the
    /// operation and its arguments.
    pub fn list_regex_pattern_sets(&self) -> fluent_builders::ListRegexPatternSets<C, M, R> {
        fluent_builders::ListRegexPatternSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRuleGroups` operation.
    ///
    /// See [`ListRuleGroups`](crate::client::fluent_builders::ListRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn list_rule_groups(&self) -> fluent_builders::ListRuleGroups<C, M, R> {
        fluent_builders::ListRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRules` operation.
    ///
    /// See [`ListRules`](crate::client::fluent_builders::ListRules) for more information about the
    /// operation and its arguments.
    pub fn list_rules(&self) -> fluent_builders::ListRules<C, M, R> {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSizeConstraintSets` operation.
    ///
    /// See [`ListSizeConstraintSets`](crate::client::fluent_builders::ListSizeConstraintSets) for more information about the
    /// operation and its arguments.
    pub fn list_size_constraint_sets(&self) -> fluent_builders::ListSizeConstraintSets<C, M, R> {
        fluent_builders::ListSizeConstraintSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSqlInjectionMatchSets` operation.
    ///
    /// See [`ListSqlInjectionMatchSets`](crate::client::fluent_builders::ListSqlInjectionMatchSets) for more information about the
    /// operation and its arguments.
    pub fn list_sql_injection_match_sets(
        &self,
    ) -> fluent_builders::ListSqlInjectionMatchSets<C, M, R> {
        fluent_builders::ListSqlInjectionMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSubscribedRuleGroups` operation.
    ///
    /// See [`ListSubscribedRuleGroups`](crate::client::fluent_builders::ListSubscribedRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn list_subscribed_rule_groups(
        &self,
    ) -> fluent_builders::ListSubscribedRuleGroups<C, M, R> {
        fluent_builders::ListSubscribedRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWebACLs` operation.
    ///
    /// See [`ListWebACLs`](crate::client::fluent_builders::ListWebACLs) for more information about the
    /// operation and its arguments.
    pub fn list_web_ac_ls(&self) -> fluent_builders::ListWebACLs<C, M, R> {
        fluent_builders::ListWebACLs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListXssMatchSets` operation.
    ///
    /// See [`ListXssMatchSets`](crate::client::fluent_builders::ListXssMatchSets) for more information about the
    /// operation and its arguments.
    pub fn list_xss_match_sets(&self) -> fluent_builders::ListXssMatchSets<C, M, R> {
        fluent_builders::ListXssMatchSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLoggingConfiguration` operation.
    ///
    /// See [`PutLoggingConfiguration`](crate::client::fluent_builders::PutLoggingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_logging_configuration(&self) -> fluent_builders::PutLoggingConfiguration<C, M, R> {
        fluent_builders::PutLoggingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPermissionPolicy` operation.
    ///
    /// See [`PutPermissionPolicy`](crate::client::fluent_builders::PutPermissionPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_permission_policy(&self) -> fluent_builders::PutPermissionPolicy<C, M, R> {
        fluent_builders::PutPermissionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateByteMatchSet` operation.
    ///
    /// See [`UpdateByteMatchSet`](crate::client::fluent_builders::UpdateByteMatchSet) for more information about the
    /// operation and its arguments.
    pub fn update_byte_match_set(&self) -> fluent_builders::UpdateByteMatchSet<C, M, R> {
        fluent_builders::UpdateByteMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGeoMatchSet` operation.
    ///
    /// See [`UpdateGeoMatchSet`](crate::client::fluent_builders::UpdateGeoMatchSet) for more information about the
    /// operation and its arguments.
    pub fn update_geo_match_set(&self) -> fluent_builders::UpdateGeoMatchSet<C, M, R> {
        fluent_builders::UpdateGeoMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIPSet` operation.
    ///
    /// See [`UpdateIPSet`](crate::client::fluent_builders::UpdateIPSet) for more information about the
    /// operation and its arguments.
    pub fn update_ip_set(&self) -> fluent_builders::UpdateIPSet<C, M, R> {
        fluent_builders::UpdateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRateBasedRule` operation.
    ///
    /// See [`UpdateRateBasedRule`](crate::client::fluent_builders::UpdateRateBasedRule) for more information about the
    /// operation and its arguments.
    pub fn update_rate_based_rule(&self) -> fluent_builders::UpdateRateBasedRule<C, M, R> {
        fluent_builders::UpdateRateBasedRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRegexMatchSet` operation.
    ///
    /// See [`UpdateRegexMatchSet`](crate::client::fluent_builders::UpdateRegexMatchSet) for more information about the
    /// operation and its arguments.
    pub fn update_regex_match_set(&self) -> fluent_builders::UpdateRegexMatchSet<C, M, R> {
        fluent_builders::UpdateRegexMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRegexPatternSet` operation.
    ///
    /// See [`UpdateRegexPatternSet`](crate::client::fluent_builders::UpdateRegexPatternSet) for more information about the
    /// operation and its arguments.
    pub fn update_regex_pattern_set(&self) -> fluent_builders::UpdateRegexPatternSet<C, M, R> {
        fluent_builders::UpdateRegexPatternSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRule` operation.
    ///
    /// See [`UpdateRule`](crate::client::fluent_builders::UpdateRule) for more information about the
    /// operation and its arguments.
    pub fn update_rule(&self) -> fluent_builders::UpdateRule<C, M, R> {
        fluent_builders::UpdateRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRuleGroup` operation.
    ///
    /// See [`UpdateRuleGroup`](crate::client::fluent_builders::UpdateRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn update_rule_group(&self) -> fluent_builders::UpdateRuleGroup<C, M, R> {
        fluent_builders::UpdateRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSizeConstraintSet` operation.
    ///
    /// See [`UpdateSizeConstraintSet`](crate::client::fluent_builders::UpdateSizeConstraintSet) for more information about the
    /// operation and its arguments.
    pub fn update_size_constraint_set(&self) -> fluent_builders::UpdateSizeConstraintSet<C, M, R> {
        fluent_builders::UpdateSizeConstraintSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSqlInjectionMatchSet` operation.
    ///
    /// See [`UpdateSqlInjectionMatchSet`](crate::client::fluent_builders::UpdateSqlInjectionMatchSet) for more information about the
    /// operation and its arguments.
    pub fn update_sql_injection_match_set(
        &self,
    ) -> fluent_builders::UpdateSqlInjectionMatchSet<C, M, R> {
        fluent_builders::UpdateSqlInjectionMatchSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWebACL` operation.
    ///
    /// See [`UpdateWebACL`](crate::client::fluent_builders::UpdateWebACL) for more information about the
    /// operation and its arguments.
    pub fn update_web_acl(&self) -> fluent_builders::UpdateWebACL<C, M, R> {
        fluent_builders::UpdateWebACL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateXssMatchSet` operation.
    ///
    /// See [`UpdateXssMatchSet`](crate::client::fluent_builders::UpdateXssMatchSet) for more information about the
    /// operation and its arguments.
    pub fn update_xss_match_set(&self) -> fluent_builders::UpdateXssMatchSet<C, M, R> {
        fluent_builders::UpdateXssMatchSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>ByteMatchSet</code>. You then use <a>UpdateByteMatchSet</a> to identify the part of a
    /// web request that you want AWS WAF to inspect, such as the values of the <code>User-Agent</code> header or the query string.
    /// For example, you can create a <code>ByteMatchSet</code> that matches any requests with <code>User-Agent</code> headers
    /// that contain the string <code>BadBot</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>ByteMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateByteMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateByteMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateByteMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateByteMatchSet</a> request to specify the part of the request that you want AWS WAF to inspect
    /// (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateByteMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_byte_match_set_input::Builder,
    }
    impl<C, M, R> CreateByteMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateByteMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateByteMatchSetInputOperationOutputAlias,
                crate::output::CreateByteMatchSetOutput,
                crate::error::CreateByteMatchSetError,
                crate::input::CreateByteMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>ByteMatchSet</a>. You can't change <code>Name</code> after you create a
        /// <code>ByteMatchSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>ByteMatchSet</a>. You can't change <code>Name</code> after you create a
        /// <code>ByteMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates an <a>GeoMatchSet</a>, which you use to specify which web requests you want to allow or block based on the country
    /// that the requests originate from. For example, if you're receiving a lot of requests from one or more countries and you want to block the requests, you can create an <code>GeoMatchSet</code> that contains those countries and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure a <code>GeoMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateGeoMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateGeoMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateGeoMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateGeoMatchSetSet</code> request to specify the countries that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGeoMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_geo_match_set_input::Builder,
    }
    impl<C, M, R> CreateGeoMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGeoMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGeoMatchSetInputOperationOutputAlias,
                crate::output::CreateGeoMatchSetOutput,
                crate::error::CreateGeoMatchSetError,
                crate::input::CreateGeoMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>GeoMatchSet</a>. You can't change <code>Name</code> after you create the <code>GeoMatchSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>GeoMatchSet</a>. You can't change <code>Name</code> after you create the <code>GeoMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates an <a>IPSet</a>, which you use to specify which web requests
    /// that
    /// you want to allow or block based on the IP addresses that the requests
    /// originate from. For example, if you're receiving a lot of requests from one or more
    /// individual IP addresses or one or more ranges of IP addresses and you want to block the
    /// requests, you can create an <code>IPSet</code> that contains those IP addresses and then
    /// configure AWS WAF to block the requests. </p>
    /// <p>To create and configure an <code>IPSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateIPSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateIPSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateIPSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateIPSet</code> request to specify the IP addresses that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ip_set_input::Builder,
    }
    impl<C, M, R> CreateIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpSetInputOperationOutputAlias,
                crate::output::CreateIpSetOutput,
                crate::error::CreateIPSetError,
                crate::input::CreateIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>IPSet</a>. You can't change <code>Name</code> after you create the <code>IPSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>IPSet</a>. You can't change <code>Name</code> after you create the <code>IPSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <a>RateBasedRule</a>. The <code>RateBasedRule</code> contains a
    /// <code>RateLimit</code>, which specifies the maximum number of requests that AWS WAF allows
    /// from a specified IP address in a five-minute period.  
    /// The <code>RateBasedRule</code> also
    /// contains the <code>IPSet</code> objects, <code>ByteMatchSet</code> objects, and other
    /// predicates that identify the requests that you want to count or block if these requests
    /// exceed the <code>RateLimit</code>.</p>
    /// <p>If you add more than one predicate to a <code>RateBasedRule</code>, a request not
    /// only must exceed the <code>RateLimit</code>, but it also must match all the
    /// conditions to be counted or blocked. For example, suppose you add the following to a
    /// <code>RateBasedRule</code>:</p>
    /// <ul>
    /// <li>
    /// <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44/32</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>ByteMatchSet</code> that matches <code>BadBot</code> in the
    /// <code>User-Agent</code> header</p>
    /// </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>You then add the <code>RateBasedRule</code> to a <code>WebACL</code> and specify that
    /// you want to block requests that meet the conditions in the rule. For a request to be
    /// blocked, it must come from the IP address 192.0.2.44 <i>and</i> the
    /// <code>User-Agent</code> header in the request must contain the value
    /// <code>BadBot</code>. Further, requests that match these two conditions must be received at
    /// a rate of more than 1,000 requests every five minutes. If both conditions are met and the
    /// rate is exceeded, AWS WAF blocks the requests. If the rate drops below 1,000 for a
    /// five-minute period, AWS WAF no longer blocks the requests.</p>
    ///
    /// <p>As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a
    /// <code>RateBasedRule</code>:</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>A <code>ByteMatchSet</code> with <code>FieldToMatch</code> of <code>URI</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>PositionalConstraint</code> of <code>STARTS_WITH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>TargetString</code> of <code>login</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>By adding this <code>RateBasedRule</code> to a <code>WebACL</code>, you could limit requests to your login page without affecting the rest of your site.</p>
    ///
    ///
    /// <p>To create and configure a <code>RateBasedRule</code>, perform the following
    /// steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create and update the predicates that you want to include in the rule. For more
    /// information, see <a>CreateByteMatchSet</a>, <a>CreateIPSet</a>,
    /// and <a>CreateSqlInjectionMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide
    /// in the <code>ChangeToken</code> parameter of a <code>CreateRule</code>
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateRateBasedRule</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the
    /// <code>ChangeToken</code> parameter of an <a>UpdateRule</a>
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateRateBasedRule</code> request to specify the predicates
    /// that you want to include in the rule.</p>
    /// </li>
    /// <li>
    /// <p>Create and update a <code>WebACL</code> that contains the
    /// <code>RateBasedRule</code>. For more information, see <a>CreateWebACL</a>.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests,
    /// see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer
    /// Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRateBasedRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rate_based_rule_input::Builder,
    }
    impl<C, M, R> CreateRateBasedRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRateBasedRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRateBasedRuleInputOperationOutputAlias,
                crate::output::CreateRateBasedRuleOutput,
                crate::error::CreateRateBasedRuleError,
                crate::input::CreateRateBasedRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>RateBasedRule</a>. You can't
        /// change the name of a <code>RateBasedRule</code> after you create it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>RateBasedRule</a>. You can't
        /// change the name of a <code>RateBasedRule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RateBasedRule</code>.
        /// The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the
        /// <code>RateBasedRule</code>.</p>
        pub fn metric_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RateBasedRule</code>.
        /// The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the
        /// <code>RateBasedRule</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The field that AWS WAF uses to determine if requests are likely arriving from a single
        /// source and thus subject to rate monitoring. The only valid value for <code>RateKey</code>
        /// is <code>IP</code>. <code>IP</code> indicates that requests that arrive from the same IP
        /// address are subject to the <code>RateLimit</code> that is specified in
        /// the <code>RateBasedRule</code>.</p>
        pub fn rate_key(mut self, inp: crate::model::RateKey) -> Self {
            self.inner = self.inner.rate_key(inp);
            self
        }
        /// <p>The field that AWS WAF uses to determine if requests are likely arriving from a single
        /// source and thus subject to rate monitoring. The only valid value for <code>RateKey</code>
        /// is <code>IP</code>. <code>IP</code> indicates that requests that arrive from the same IP
        /// address are subject to the <code>RateLimit</code> that is specified in
        /// the <code>RateBasedRule</code>.</p>
        pub fn set_rate_key(mut self, input: std::option::Option<crate::model::RateKey>) -> Self {
            self.inner = self.inner.set_rate_key(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field that is
        /// specified by <code>RateKey</code>, allowed in a five-minute period. If the number of
        /// requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule
        /// are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn rate_limit(mut self, inp: i64) -> Self {
            self.inner = self.inner.rate_limit(inp);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field that is
        /// specified by <code>RateKey</code>, allowed in a five-minute period. If the number of
        /// requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule
        /// are also met, AWS WAF triggers the action that is specified for this rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_rate_limit(input);
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the
        /// <code>CreateRateBasedRule</code> request. You can also use this value to query the
        /// status of the request. For more information, see <a>GetChangeTokenStatus</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The <code>ChangeToken</code> that you used to submit the
        /// <code>CreateRateBasedRule</code> request. You can also use this value to query the
        /// status of the request. For more information, see <a>GetChangeTokenStatus</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <a>RegexMatchSet</a>. You then use <a>UpdateRegexMatchSet</a> to identify the part of a
    /// web request that you want AWS WAF to inspect, such as the values of the <code>User-Agent</code> header or the query string.
    /// For example, you can create a <code>RegexMatchSet</code> that contains a <code>RegexMatchTuple</code> that looks for any requests with <code>User-Agent</code> headers
    /// that match a <code>RegexPatternSet</code> with pattern <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>RegexMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateRegexMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateRegexMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateRegexMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateRegexMatchSet</a> request to specify the part of the request that you want AWS WAF to inspect
    /// (for example, the header or the URI) and the value, using a <code>RegexPatternSet</code>, that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRegexMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_regex_match_set_input::Builder,
    }
    impl<C, M, R> CreateRegexMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegexMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRegexMatchSetInputOperationOutputAlias,
                crate::output::CreateRegexMatchSetOutput,
                crate::error::CreateRegexMatchSetError,
                crate::input::CreateRegexMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you create a
        /// <code>RegexMatchSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>RegexMatchSet</a>. You can't change <code>Name</code> after you create a
        /// <code>RegexMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>RegexPatternSet</code>. You then use <a>UpdateRegexPatternSet</a> to specify the regular expression (regex) pattern that you want AWS WAF to search for, such as <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>RegexPatternSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateRegexPatternSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateRegexPatternSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateRegexPatternSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateRegexPatternSet</a> request to specify the string that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> CreateRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRegexPatternSetInputOperationOutputAlias,
                crate::output::CreateRegexPatternSetOutput,
                crate::error::CreateRegexPatternSetError,
                crate::input::CreateRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>RegexPatternSet</a>. You can't change <code>Name</code> after you create a
        /// <code>RegexPatternSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>RegexPatternSet</a>. You can't change <code>Name</code> after you create a
        /// <code>RegexPatternSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>Rule</code>, which contains the <code>IPSet</code> objects,
    /// <code>ByteMatchSet</code> objects, and other predicates that identify the requests that
    /// you want to block. If you add more than one predicate to a <code>Rule</code>, a request
    /// must match all of the specifications to be allowed or blocked. For example, suppose
    /// that
    /// you add the following to a <code>Rule</code>:</p>
    /// <ul>
    /// <li>
    /// <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44/32</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>ByteMatchSet</code> that matches <code>BadBot</code> in the <code>User-Agent</code> header</p>
    /// </li>
    /// </ul>
    /// <p>You then add the <code>Rule</code> to a <code>WebACL</code> and specify that you want to blocks requests that satisfy the <code>Rule</code>.
    /// For a request to be blocked, it must come from the IP address 192.0.2.44 <i>and</i> the <code>User-Agent</code> header in the request
    /// must contain the value <code>BadBot</code>.</p>
    /// <p>To create and configure a <code>Rule</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create and update the predicates that you want to include in the <code>Rule</code>. For more information, see
    /// <a>CreateByteMatchSet</a>, <a>CreateIPSet</a>, and <a>CreateSqlInjectionMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateRule</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateRule</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateRule</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateRule</code> request to specify the predicates that you want to include in the <code>Rule</code>.</p>
    /// </li>
    /// <li>
    /// <p>Create and update a <code>WebACL</code> that contains the <code>Rule</code>. For more information, see <a>CreateWebACL</a>.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_input::Builder,
    }
    impl<C, M, R> CreateRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleInputOperationOutputAlias,
                crate::output::CreateRuleOutput,
                crate::error::CreateRuleError,
                crate::input::CreateRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>Rule</a>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>Rule</a>. You can't change the name of a <code>Rule</code> after you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the
        /// <code>Rule</code>.</p>
        pub fn metric_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>Rule</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the
        /// <code>Rule</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>RuleGroup</code>. A rule group is a collection of predefined rules that you add to a web ACL. You use <a>UpdateRuleGroup</a> to add rules to the rule group.</p>
    /// <p>Rule groups are subject to the following limits:</p>
    /// <ul>
    /// <li>
    /// <p>Three rule groups per account. You can request an increase to this limit by contacting customer support.</p>
    /// </li>
    /// <li>
    /// <p>One rule group per web ACL.</p>
    /// </li>
    /// <li>
    /// <p>Ten rules per rule group.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_rule_group_input::Builder,
    }
    impl<C, M, R> CreateRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRuleGroupInputOperationOutputAlias,
                crate::output::CreateRuleGroupOutput,
                crate::error::CreateRuleGroupError,
                crate::input::CreateRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>RuleGroup</a>. You can't change <code>Name</code> after you create a
        /// <code>RuleGroup</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>RuleGroup</a>. You can't change <code>Name</code> after you create a
        /// <code>RuleGroup</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn metric_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>RuleGroup</code>. The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RuleGroup</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>SizeConstraintSet</code>. You then use <a>UpdateSizeConstraintSet</a> to identify the part of a
    /// web request that you want AWS WAF to check for length, such as the length of the <code>User-Agent</code> header or the length of the query string.
    /// For example, you can create a <code>SizeConstraintSet</code> that matches any requests that have a query string that is longer than 100 bytes.
    /// You can then configure AWS WAF to reject those requests.</p>
    /// <p>To create and configure a <code>SizeConstraintSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateSizeConstraintSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateSizeConstraintSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateSizeConstraintSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateSizeConstraintSet</a> request to specify the part of the request that you want AWS WAF to inspect
    /// (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSizeConstraintSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_size_constraint_set_input::Builder,
    }
    impl<C, M, R> CreateSizeConstraintSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSizeConstraintSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSizeConstraintSetInputOperationOutputAlias,
                crate::output::CreateSizeConstraintSetOutput,
                crate::error::CreateSizeConstraintSetError,
                crate::input::CreateSizeConstraintSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>SizeConstraintSet</a>. You can't change <code>Name</code> after you create a
        /// <code>SizeConstraintSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>SizeConstraintSet</a>. You can't change <code>Name</code> after you create a
        /// <code>SizeConstraintSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <a>SqlInjectionMatchSet</a>, which you use to allow, block, or count requests that contain snippets of SQL code in a
    /// specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.</p>
    /// <p>To create and configure a <code>SqlInjectionMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateSqlInjectionMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateSqlInjectionMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateSqlInjectionMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateSqlInjectionMatchSet</a> request to specify the parts of web requests in which you want to
    /// allow, block, or count malicious SQL code.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSqlInjectionMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sql_injection_match_set_input::Builder,
    }
    impl<C, M, R> CreateSqlInjectionMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSqlInjectionMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSqlInjectionMatchSetInputOperationOutputAlias,
                crate::output::CreateSqlInjectionMatchSetOutput,
                crate::error::CreateSqlInjectionMatchSetError,
                crate::input::CreateSqlInjectionMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description for the <a>SqlInjectionMatchSet</a> that you're creating. You can't change <code>Name</code>
        /// after you create the <code>SqlInjectionMatchSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description for the <a>SqlInjectionMatchSet</a> that you're creating. You can't change <code>Name</code>
        /// after you create the <code>SqlInjectionMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates a <code>WebACL</code>, which contains the <code>Rules</code> that identify the CloudFront web requests that you want to allow, block, or count.
    /// AWS WAF evaluates <code>Rules</code> in order based on the value of <code>Priority</code> for each <code>Rule</code>.</p>      
    /// <p>You also specify a default action, either <code>ALLOW</code> or <code>BLOCK</code>. If a web request doesn't match
    /// any of the <code>Rules</code> in a <code>WebACL</code>, AWS WAF responds to the request with the default action. </p>      
    /// <p>To create and configure a <code>WebACL</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create and update the <code>ByteMatchSet</code> objects and other predicates that you want to include in <code>Rules</code>.
    /// For more information, see <a>CreateByteMatchSet</a>, <a>UpdateByteMatchSet</a>, <a>CreateIPSet</a>, <a>UpdateIPSet</a>,
    /// <a>CreateSqlInjectionMatchSet</a>, and <a>UpdateSqlInjectionMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Create and update the <code>Rules</code> that you want to include in the <code>WebACL</code>. For more information, see
    /// <a>CreateRule</a> and <a>UpdateRule</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateWebACL</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateWebACL</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateWebACL</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateWebACL</a> request to specify the <code>Rules</code> that you want to include in the <code>WebACL</code>,
    /// to specify the default action, and to associate the <code>WebACL</code> with a CloudFront distribution.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_web_acl_input::Builder,
    }
    impl<C, M, R> CreateWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWebAclInputOperationOutputAlias,
                crate::output::CreateWebAclOutput,
                crate::error::CreateWebACLError,
                crate::input::CreateWebAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description of the <a>WebACL</a>. You can't change <code>Name</code> after you create the <code>WebACL</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description of the <a>WebACL</a>. You can't change <code>Name</code> after you create the <code>WebACL</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the
        /// <code>WebACL</code>.</p>
        pub fn metric_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
        /// whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the
        /// <code>WebACL</code>.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The action that you want  AWS WAF to take when a request doesn't match the criteria specified in any of the <code>Rule</code>
        /// objects that are associated with the <code>WebACL</code>.</p>
        pub fn default_action(mut self, inp: crate::model::WafAction) -> Self {
            self.inner = self.inner.default_action(inp);
            self
        }
        /// <p>The action that you want  AWS WAF to take when a request doesn't match the criteria specified in any of the <code>Rule</code>
        /// objects that are associated with the <code>WebACL</code>.</p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::WafAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebACLMigrationStack`.
    ///
    /// <p>Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket.
    /// Then, in CloudFormation, you create a stack from the template, to create the web ACL and its resources in AWS WAFV2.
    /// Use this to migrate your AWS WAF Classic web ACL to the latest version of AWS WAF.</p>
    /// <p>This is part of a larger migration procedure for web ACLs from AWS WAF Classic to the latest version of AWS WAF.
    /// For the full procedure, including caveats and manual steps to complete
    /// the migration and switch over to the new web ACL, see  
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-migrating-from-classic.html">Migrating your AWS WAF Classic resources to AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF     
    /// Developer Guide</a>.  </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWebACLMigrationStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_web_acl_migration_stack_input::Builder,
    }
    impl<C, M, R> CreateWebACLMigrationStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWebACLMigrationStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebAclMigrationStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebACLMigrationStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWebAclMigrationStackInputOperationOutputAlias,
                crate::output::CreateWebAclMigrationStackOutput,
                crate::error::CreateWebACLMigrationStackError,
                crate::input::CreateWebAclMigrationStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.</p>
        pub fn web_acl_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(inp);
            self
        }
        /// <p>The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be
        /// configured as follows for the migration:  </p>
        /// <ul>
        /// <li>
        /// <p>The bucket name must start with <code>aws-waf-migration-</code>. For example, <code>aws-waf-migration-my-web-acl</code>.</p>
        /// </li>
        /// <li>
        /// <p>The bucket must be in the Region where you are deploying the template. For example, for a web ACL in us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2. </p>
        /// </li>
        /// <li>
        /// <p>The bucket policies must permit the migration process to write data. For listings of the
        /// bucket policies, see the Examples section. </p>
        /// </li>
        /// </ul>
        pub fn s3_bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_name(inp);
            self
        }
        /// <p>The name of the Amazon S3 bucket to store the CloudFormation template in. The S3 bucket must be
        /// configured as follows for the migration:  </p>
        /// <ul>
        /// <li>
        /// <p>The bucket name must start with <code>aws-waf-migration-</code>. For example, <code>aws-waf-migration-my-web-acl</code>.</p>
        /// </li>
        /// <li>
        /// <p>The bucket must be in the Region where you are deploying the template. For example, for a web ACL in us-west-2, you must use an Amazon S3 bucket in us-west-2 and you must deploy the template stack to us-west-2. </p>
        /// </li>
        /// <li>
        /// <p>The bucket policies must permit the migration process to write data. For listings of the
        /// bucket policies, see the Examples section. </p>
        /// </li>
        /// </ul>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_name(input);
            self
        }
        /// <p>Indicates whether to exclude entities that can't be migrated or to stop the migration.
        /// Set this to true to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported
        /// entities, it stops the process and throws an exception. </p>
        pub fn ignore_unsupported_type(mut self, inp: bool) -> Self {
            self.inner = self.inner.ignore_unsupported_type(inp);
            self
        }
        /// <p>Indicates whether to exclude entities that can't be migrated or to stop the migration.
        /// Set this to true to ignore unsupported entities in the web ACL during the migration. Otherwise, if AWS WAF encounters unsupported
        /// entities, it stops the process and throws an exception. </p>
        pub fn set_ignore_unsupported_type(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ignore_unsupported_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Creates an <a>XssMatchSet</a>, which you use to allow, block, or count requests that contain cross-site scripting attacks
    /// in the specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.</p>
    /// <p>To create and configure an <code>XssMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>CreateXssMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>CreateXssMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateXssMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <a>UpdateXssMatchSet</a> request to specify the parts of web requests in which you want to
    /// allow, block, or count cross-site scripting attacks.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateXssMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_xss_match_set_input::Builder,
    }
    impl<C, M, R> CreateXssMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateXssMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateXssMatchSetInputOperationOutputAlias,
                crate::output::CreateXssMatchSetOutput,
                crate::error::CreateXssMatchSetError,
                crate::input::CreateXssMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A friendly name or description for the <a>XssMatchSet</a> that you're creating. You can't change <code>Name</code>
        /// after you create the <code>XssMatchSet</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name or description for the <a>XssMatchSet</a> that you're creating. You can't change <code>Name</code>
        /// after you create the <code>XssMatchSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>ByteMatchSet</a>. You can't delete a <code>ByteMatchSet</code> if it's still used in any <code>Rules</code>
    /// or if it still includes any <a>ByteMatchTuple</a> objects (any filters).</p>    
    /// <p>If you just want to remove a <code>ByteMatchSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>    
    /// <p>To permanently delete a <code>ByteMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>ByteMatchSet</code> to remove filters, if any. For more information, see <a>UpdateByteMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteByteMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteByteMatchSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteByteMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_byte_match_set_input::Builder,
    }
    impl<C, M, R> DeleteByteMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteByteMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteByteMatchSetInputOperationOutputAlias,
                crate::output::DeleteByteMatchSetOutput,
                crate::error::DeleteByteMatchSetError,
                crate::input::DeleteByteMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to delete. <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by
        /// <a>ListByteMatchSets</a>.</p>
        pub fn byte_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.byte_match_set_id(inp);
            self
        }
        /// <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to delete. <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by
        /// <a>ListByteMatchSets</a>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_byte_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>GeoMatchSet</a>. You can't delete a <code>GeoMatchSet</code> if it's still used in any <code>Rules</code> or
    /// if it still includes any countries.</p>
    /// <p>If you just want to remove a <code>GeoMatchSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>
    /// <p>To permanently delete a <code>GeoMatchSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>GeoMatchSet</code> to remove any countries. For more information, see <a>UpdateGeoMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteGeoMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteGeoMatchSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGeoMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_geo_match_set_input::Builder,
    }
    impl<C, M, R> DeleteGeoMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGeoMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGeoMatchSetInputOperationOutputAlias,
                crate::output::DeleteGeoMatchSetOutput,
                crate::error::DeleteGeoMatchSetError,
                crate::input::DeleteGeoMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GeoMatchSetID</code> of the <a>GeoMatchSet</a> that you want to delete. <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by
        /// <a>ListGeoMatchSets</a>.</p>
        pub fn geo_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geo_match_set_id(inp);
            self
        }
        /// <p>The <code>GeoMatchSetID</code> of the <a>GeoMatchSet</a> that you want to delete. <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by
        /// <a>ListGeoMatchSets</a>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes an <a>IPSet</a>. You can't delete an <code>IPSet</code> if it's still used in any <code>Rules</code> or
    /// if it still includes any IP addresses.</p>
    /// <p>If you just want to remove an <code>IPSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>
    /// <p>To permanently delete an <code>IPSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>IPSet</code> to remove IP address ranges, if any. For more information, see <a>UpdateIPSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteIPSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteIPSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ip_set_input::Builder,
    }
    impl<C, M, R> DeleteIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIpSetInputOperationOutputAlias,
                crate::output::DeleteIpSetOutput,
                crate::error::DeleteIPSetError,
                crate::input::DeleteIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to delete. <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
        /// <a>ListIPSets</a>.</p>
        pub fn ip_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(inp);
            self
        }
        /// <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to delete. <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
        /// <a>ListIPSets</a>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoggingConfiguration`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes the <a>LoggingConfiguration</a> from the specified web
    /// ACL.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_logging_configuration_input::Builder,
    }
    impl<C, M, R> DeleteLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoggingConfigurationInputOperationOutputAlias,
                crate::output::DeleteLoggingConfigurationOutput,
                crate::error::DeleteLoggingConfigurationError,
                crate::input::DeleteLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <a>LoggingConfiguration</a>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL from which you want to delete the <a>LoggingConfiguration</a>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePermissionPolicy`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes an IAM policy from the specified RuleGroup.</p>
    /// <p>The user making the request must be the owner of the RuleGroup.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePermissionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_permission_policy_input::Builder,
    }
    impl<C, M, R> DeletePermissionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePermissionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePermissionPolicyInputOperationOutputAlias,
                crate::output::DeletePermissionPolicyOutput,
                crate::error::DeletePermissionPolicyError,
                crate::input::DeletePermissionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete the policy.</p>
        /// <p>The user making the request must be the owner of the RuleGroup.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete the policy.</p>
        /// <p>The user making the request must be the owner of the RuleGroup.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>RateBasedRule</a>. You can't delete a rule if
    /// it's still used in any <code>WebACL</code> objects or if it still includes any predicates,
    /// such as <code>ByteMatchSet</code> objects.</p>
    /// <p>If you just want to remove a rule from a <code>WebACL</code>, use <a>UpdateWebACL</a>.</p>
    /// <p>To permanently delete a <code>RateBasedRule</code> from AWS WAF, perform the following
    /// steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>RateBasedRule</code> to remove predicates, if any. For more
    /// information, see <a>UpdateRateBasedRule</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide
    /// in the <code>ChangeToken</code> parameter of a <code>DeleteRateBasedRule</code>
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteRateBasedRule</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRateBasedRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rate_based_rule_input::Builder,
    }
    impl<C, M, R> DeleteRateBasedRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRateBasedRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRateBasedRuleInputOperationOutputAlias,
                crate::output::DeleteRateBasedRuleOutput,
                crate::error::DeleteRateBasedRuleError,
                crate::input::DeleteRateBasedRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <a>RateBasedRule</a> that you want to
        /// delete. <code>RuleId</code> is returned by <a>CreateRateBasedRule</a> and by
        /// <a>ListRateBasedRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <a>RateBasedRule</a> that you want to
        /// delete. <code>RuleId</code> is returned by <a>CreateRateBasedRule</a> and by
        /// <a>ListRateBasedRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>RegexMatchSet</a>. You can't delete a <code>RegexMatchSet</code> if it's still used in any <code>Rules</code>
    /// or if it still includes any <code>RegexMatchTuples</code> objects (any filters).</p>    
    /// <p>If you just want to remove a <code>RegexMatchSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>    
    /// <p>To permanently delete a <code>RegexMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>RegexMatchSet</code> to remove filters, if any. For more information, see <a>UpdateRegexMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteRegexMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteRegexMatchSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRegexMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_regex_match_set_input::Builder,
    }
    impl<C, M, R> DeleteRegexMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegexMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegexMatchSetInputOperationOutputAlias,
                crate::output::DeleteRegexMatchSetOutput,
                crate::error::DeleteRegexMatchSetError,
                crate::input::DeleteRegexMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to delete. <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
        /// <a>ListRegexMatchSets</a>.</p>
        pub fn regex_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_match_set_id(inp);
            self
        }
        /// <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to delete. <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
        /// <a>ListRegexMatchSets</a>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>RegexPatternSet</a>. You can't delete a <code>RegexPatternSet</code> if it's still used in any <code>RegexMatchSet</code>
    /// or if the <code>RegexPatternSet</code> is not empty. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> DeleteRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegexPatternSetInputOperationOutputAlias,
                crate::output::DeleteRegexPatternSetOutput,
                crate::error::DeleteRegexPatternSetError,
                crate::input::DeleteRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to delete. <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
        /// <a>ListRegexPatternSets</a>.</p>
        pub fn regex_pattern_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_pattern_set_id(inp);
            self
        }
        /// <p>The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to delete. <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
        /// <a>ListRegexPatternSets</a>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_pattern_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>Rule</a>. You can't delete a <code>Rule</code> if it's still used in any <code>WebACL</code>
    /// objects or if it still includes any predicates, such as <code>ByteMatchSet</code> objects.</p>
    /// <p>If you just want to remove a <code>Rule</code> from a <code>WebACL</code>, use <a>UpdateWebACL</a>.</p>
    /// <p>To permanently delete a <code>Rule</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>Rule</code> to remove predicates, if any. For more information, see <a>UpdateRule</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteRule</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteRule</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl<C, M, R> DeleteRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleInputOperationOutputAlias,
                crate::output::DeleteRuleOutput,
                crate::error::DeleteRuleError,
                crate::input::DeleteRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <a>Rule</a> that you want to delete. <code>RuleId</code> is returned by <a>CreateRule</a> and by
        /// <a>ListRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <a>Rule</a> that you want to delete. <code>RuleId</code> is returned by <a>CreateRule</a> and by
        /// <a>ListRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>RuleGroup</a>. You can't delete a <code>RuleGroup</code> if it's still used in any <code>WebACL</code>
    /// objects or if it still includes any rules.</p>
    /// <p>If you just want to remove a <code>RuleGroup</code> from a <code>WebACL</code>, use <a>UpdateWebACL</a>.</p>
    /// <p>To permanently delete a <code>RuleGroup</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>RuleGroup</code> to remove rules, if any. For more information, see <a>UpdateRuleGroup</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteRuleGroup</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteRuleGroup</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_group_input::Builder,
    }
    impl<C, M, R> DeleteRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleGroupInputOperationOutputAlias,
                crate::output::DeleteRuleGroupOutput,
                crate::error::DeleteRuleGroupError,
                crate::input::DeleteRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to delete. <code>RuleGroupId</code> is returned by <a>CreateRuleGroup</a> and by
        /// <a>ListRuleGroups</a>.</p>
        pub fn rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(inp);
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to delete. <code>RuleGroupId</code> is returned by <a>CreateRuleGroup</a> and by
        /// <a>ListRuleGroups</a>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>SizeConstraintSet</a>. You can't delete a <code>SizeConstraintSet</code> if it's still used in any <code>Rules</code>
    /// or if it still includes any <a>SizeConstraint</a> objects (any filters).</p>    
    /// <p>If you just want to remove a <code>SizeConstraintSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>    
    /// <p>To permanently delete a <code>SizeConstraintSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>SizeConstraintSet</code> to remove filters, if any. For more information, see <a>UpdateSizeConstraintSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteSizeConstraintSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteSizeConstraintSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSizeConstraintSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_size_constraint_set_input::Builder,
    }
    impl<C, M, R> DeleteSizeConstraintSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSizeConstraintSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSizeConstraintSetInputOperationOutputAlias,
                crate::output::DeleteSizeConstraintSetOutput,
                crate::error::DeleteSizeConstraintSetError,
                crate::input::DeleteSizeConstraintSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <a>SizeConstraintSet</a> that you want to delete. <code>SizeConstraintSetId</code>
        /// is returned by <a>CreateSizeConstraintSet</a> and by <a>ListSizeConstraintSets</a>.</p>
        pub fn size_constraint_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.size_constraint_set_id(inp);
            self
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <a>SizeConstraintSet</a> that you want to delete. <code>SizeConstraintSetId</code>
        /// is returned by <a>CreateSizeConstraintSet</a> and by <a>ListSizeConstraintSets</a>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_size_constraint_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>SqlInjectionMatchSet</a>. You can't delete a <code>SqlInjectionMatchSet</code> if it's
    /// still used in any <code>Rules</code> or if it still contains any <a>SqlInjectionMatchTuple</a> objects.</p>
    /// <p>If you just want to remove a <code>SqlInjectionMatchSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>
    /// <p>To permanently delete a <code>SqlInjectionMatchSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>SqlInjectionMatchSet</code> to remove filters, if any. For more information, see
    /// <a>UpdateSqlInjectionMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteSqlInjectionMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteSqlInjectionMatchSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSqlInjectionMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_sql_injection_match_set_input::Builder,
    }
    impl<C, M, R> DeleteSqlInjectionMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSqlInjectionMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSqlInjectionMatchSetInputOperationOutputAlias,
                crate::output::DeleteSqlInjectionMatchSetOutput,
                crate::error::DeleteSqlInjectionMatchSetError,
                crate::input::DeleteSqlInjectionMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <a>SqlInjectionMatchSet</a> that you want to delete.
        /// <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by <a>ListSqlInjectionMatchSets</a>.</p>
        pub fn sql_injection_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_injection_match_set_id(inp);
            self
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <a>SqlInjectionMatchSet</a> that you want to delete.
        /// <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by <a>ListSqlInjectionMatchSets</a>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_injection_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes a <a>WebACL</a>. You can't delete a <code>WebACL</code> if it still contains any <code>Rules</code>.</p>
    /// <p>To delete a <code>WebACL</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>WebACL</code> to remove <code>Rules</code>, if any. For more information, see <a>UpdateWebACL</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteWebACL</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteWebACL</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_web_acl_input::Builder,
    }
    impl<C, M, R> DeleteWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWebAclInputOperationOutputAlias,
                crate::output::DeleteWebAclOutput,
                crate::error::DeleteWebACLError,
                crate::input::DeleteWebAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <a>WebACL</a> that you want to delete. <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by
        /// <a>ListWebACLs</a>.</p>
        pub fn web_acl_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(inp);
            self
        }
        /// <p>The <code>WebACLId</code> of the <a>WebACL</a> that you want to delete. <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by
        /// <a>ListWebACLs</a>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Permanently deletes an <a>XssMatchSet</a>. You can't delete an <code>XssMatchSet</code> if it's
    /// still used in any <code>Rules</code> or if it still contains any <a>XssMatchTuple</a> objects.</p>
    /// <p>If you just want to remove an <code>XssMatchSet</code> from a <code>Rule</code>, use <a>UpdateRule</a>.</p>
    /// <p>To permanently delete an <code>XssMatchSet</code> from AWS WAF, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Update the <code>XssMatchSet</code> to remove filters, if any. For more information, see
    /// <a>UpdateXssMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of a
    /// <code>DeleteXssMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit a <code>DeleteXssMatchSet</code> request.</p>
    /// </li>
    /// </ol>
    #[derive(std::fmt::Debug)]
    pub struct DeleteXssMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_xss_match_set_input::Builder,
    }
    impl<C, M, R> DeleteXssMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteXssMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteXssMatchSetInputOperationOutputAlias,
                crate::output::DeleteXssMatchSetOutput,
                crate::error::DeleteXssMatchSetError,
                crate::input::DeleteXssMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>XssMatchSetId</code> of the <a>XssMatchSet</a> that you want to delete.
        /// <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.</p>
        pub fn xss_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.xss_match_set_id(inp);
            self
        }
        /// <p>The <code>XssMatchSetId</code> of the <a>XssMatchSet</a> that you want to delete.
        /// <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_xss_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>ByteMatchSet</a> specified by <code>ByteMatchSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetByteMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_byte_match_set_input::Builder,
    }
    impl<C, M, R> GetByteMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetByteMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetByteMatchSetInputOperationOutputAlias,
                crate::output::GetByteMatchSetOutput,
                crate::error::GetByteMatchSetError,
                crate::input::GetByteMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to get. <code>ByteMatchSetId</code> is returned by
        /// <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.</p>
        pub fn byte_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.byte_match_set_id(inp);
            self
        }
        /// <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to get. <code>ByteMatchSetId</code> is returned by
        /// <a>CreateByteMatchSet</a> and by <a>ListByteMatchSets</a>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_byte_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChangeToken`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>When you want to create, update, or delete AWS WAF objects, get a change token and include the change token in the create, update, or delete request. Change tokens ensure that your application doesn't submit conflicting requests to AWS WAF.</p>
    /// <p>Each create, update, or delete request must use a unique change token. If your application submits a <code>GetChangeToken</code> request
    /// and then submits a second <code>GetChangeToken</code> request before submitting a create, update, or delete request, the second
    /// <code>GetChangeToken</code> request returns the same value as the first <code>GetChangeToken</code> request.</p>
    /// <p>When you use a change token in a create, update, or delete request, the status of the change token changes to <code>PENDING</code>,
    /// which indicates that AWS WAF is propagating the change to all AWS WAF servers. Use <code>GetChangeTokenStatus</code> to determine the
    /// status of your change token.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetChangeToken<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_change_token_input::Builder,
    }
    impl<C, M, R> GetChangeToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChangeToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChangeTokenInputOperationOutputAlias,
                crate::output::GetChangeTokenOutput,
                crate::error::GetChangeTokenError,
                crate::input::GetChangeTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetChangeTokenStatus`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the status of a <code>ChangeToken</code> that you got by calling <a>GetChangeToken</a>. <code>ChangeTokenStatus</code> is
    /// one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code>: You requested the change token by calling <code>GetChangeToken</code>, but you haven't used it yet
    /// in a call to create, update, or delete an AWS WAF object.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING</code>: AWS WAF is propagating the create, update, or delete request to all AWS WAF servers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INSYNC</code>: Propagation is complete.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetChangeTokenStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_change_token_status_input::Builder,
    }
    impl<C, M, R> GetChangeTokenStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChangeTokenStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeTokenStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeTokenStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChangeTokenStatusInputOperationOutputAlias,
                crate::output::GetChangeTokenStatusOutput,
                crate::error::GetChangeTokenStatusError,
                crate::input::GetChangeTokenStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The change token for which you want to get the status. This change token was previously returned in the <code>GetChangeToken</code> response.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The change token for which you want to get the status. This change token was previously returned in the <code>GetChangeToken</code> response.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>GeoMatchSet</a> that is specified by <code>GeoMatchSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGeoMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_geo_match_set_input::Builder,
    }
    impl<C, M, R> GetGeoMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeoMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGeoMatchSetInputOperationOutputAlias,
                crate::output::GetGeoMatchSetOutput,
                crate::error::GetGeoMatchSetError,
                crate::input::GetGeoMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to get. <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by
        /// <a>ListGeoMatchSets</a>.</p>
        pub fn geo_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geo_match_set_id(inp);
            self
        }
        /// <p>The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to get. <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by
        /// <a>ListGeoMatchSets</a>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>IPSet</a> that is specified by <code>IPSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ip_set_input::Builder,
    }
    impl<C, M, R> GetIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIpSetInputOperationOutputAlias,
                crate::output::GetIpSetOutput,
                crate::error::GetIPSetError,
                crate::input::GetIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to get. <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
        /// <a>ListIPSets</a>.</p>
        pub fn ip_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(inp);
            self
        }
        /// <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to get. <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
        /// <a>ListIPSets</a>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggingConfiguration`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>LoggingConfiguration</a> for the specified web ACL.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_logging_configuration_input::Builder,
    }
    impl<C, M, R> GetLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoggingConfigurationInputOperationOutputAlias,
                crate::output::GetLoggingConfigurationOutput,
                crate::error::GetLoggingConfigurationError,
                crate::input::GetLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the web ACL for which you want to get the <a>LoggingConfiguration</a>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPermissionPolicy`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the IAM policy attached to the RuleGroup.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPermissionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_permission_policy_input::Builder,
    }
    impl<C, M, R> GetPermissionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPermissionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPermissionPolicyInputOperationOutputAlias,
                crate::output::GetPermissionPolicyOutput,
                crate::error::GetPermissionPolicyError,
                crate::input::GetPermissionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup for which you want to get the policy.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup for which you want to get the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>RateBasedRule</a> that is specified by the
    /// <code>RuleId</code> that you included in the <code>GetRateBasedRule</code>
    /// request.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRateBasedRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rate_based_rule_input::Builder,
    }
    impl<C, M, R> GetRateBasedRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRateBasedRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRateBasedRuleInputOperationOutputAlias,
                crate::output::GetRateBasedRuleOutput,
                crate::error::GetRateBasedRuleError,
                crate::input::GetRateBasedRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <a>RateBasedRule</a> that you want to get.
        /// <code>RuleId</code> is returned by <a>CreateRateBasedRule</a> and by <a>ListRateBasedRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <a>RateBasedRule</a> that you want to get.
        /// <code>RuleId</code> is returned by <a>CreateRateBasedRule</a> and by <a>ListRateBasedRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRateBasedRuleManagedKeys`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of IP addresses currently being blocked by the <a>RateBasedRule</a> that is specified by the <code>RuleId</code>. The maximum
    /// number of managed keys that will be blocked is 10,000. If more than 10,000 addresses exceed
    /// the rate limit, the 10,000 addresses with the highest rates will be blocked.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRateBasedRuleManagedKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rate_based_rule_managed_keys_input::Builder,
    }
    impl<C, M, R> GetRateBasedRuleManagedKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRateBasedRuleManagedKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRateBasedRuleManagedKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRateBasedRuleManagedKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRateBasedRuleManagedKeysInputOperationOutputAlias,
                crate::output::GetRateBasedRuleManagedKeysOutput,
                crate::error::GetRateBasedRuleManagedKeysError,
                crate::input::GetRateBasedRuleManagedKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <a>RateBasedRule</a> for which you want to
        /// get a list of <code>ManagedKeys</code>. <code>RuleId</code> is returned by <a>CreateRateBasedRule</a> and by <a>ListRateBasedRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <a>RateBasedRule</a> for which you want to
        /// get a list of <code>ManagedKeys</code>. <code>RuleId</code> is returned by <a>CreateRateBasedRule</a> and by <a>ListRateBasedRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>A null value and not currently used. Do not include this in your request.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>A null value and not currently used. Do not include this in your request.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>RegexMatchSet</a> specified by <code>RegexMatchSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegexMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_regex_match_set_input::Builder,
    }
    impl<C, M, R> GetRegexMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegexMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegexMatchSetInputOperationOutputAlias,
                crate::output::GetRegexMatchSetOutput,
                crate::error::GetRegexMatchSetError,
                crate::input::GetRegexMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to get. <code>RegexMatchSetId</code> is returned by
        /// <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.</p>
        pub fn regex_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_match_set_id(inp);
            self
        }
        /// <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to get. <code>RegexMatchSetId</code> is returned by
        /// <a>CreateRegexMatchSet</a> and by <a>ListRegexMatchSets</a>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>RegexPatternSet</a> specified by <code>RegexPatternSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> GetRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegexPatternSetInputOperationOutputAlias,
                crate::output::GetRegexPatternSetOutput,
                crate::error::GetRegexPatternSetError,
                crate::input::GetRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to get. <code>RegexPatternSetId</code> is returned by
        /// <a>CreateRegexPatternSet</a> and by <a>ListRegexPatternSets</a>.</p>
        pub fn regex_pattern_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_pattern_set_id(inp);
            self
        }
        /// <p>The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to get. <code>RegexPatternSetId</code> is returned by
        /// <a>CreateRegexPatternSet</a> and by <a>ListRegexPatternSets</a>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_pattern_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>Rule</a> that is specified by the <code>RuleId</code> that you included in the <code>GetRule</code> request.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rule_input::Builder,
    }
    impl<C, M, R> GetRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRuleInputOperationOutputAlias,
                crate::output::GetRuleOutput,
                crate::error::GetRuleError,
                crate::input::GetRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <a>Rule</a> that you want to get. <code>RuleId</code> is returned by <a>CreateRule</a> and by
        /// <a>ListRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <a>Rule</a> that you want to get. <code>RuleId</code> is returned by <a>CreateRule</a> and by
        /// <a>ListRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>RuleGroup</a> that is specified by the <code>RuleGroupId</code> that you included in the <code>GetRuleGroup</code> request.</p>
    /// <p>To view the rules in a rule group, use <a>ListActivatedRulesInRuleGroup</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rule_group_input::Builder,
    }
    impl<C, M, R> GetRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRuleGroupInputOperationOutputAlias,
                crate::output::GetRuleGroupOutput,
                crate::error::GetRuleGroupError,
                crate::input::GetRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to get. <code>RuleGroupId</code> is returned by <a>CreateRuleGroup</a> and by
        /// <a>ListRuleGroups</a>.</p>
        pub fn rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(inp);
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to get. <code>RuleGroupId</code> is returned by <a>CreateRuleGroup</a> and by
        /// <a>ListRuleGroups</a>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSampledRequests`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from among the first 5,000 requests that your AWS resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.</p>
    /// <p>
    /// <code>GetSampledRequests</code> returns a time range, which is usually the time range that you specified. However, if your resource
    /// (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, <code>GetSampledRequests</code>
    /// returns an updated time range. This new time range indicates the actual period during which AWS WAF selected the requests in the sample.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSampledRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sampled_requests_input::Builder,
    }
    impl<C, M, R> GetSampledRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSampledRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSampledRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSampledRequestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSampledRequestsInputOperationOutputAlias,
                crate::output::GetSampledRequestsOutput,
                crate::error::GetSampledRequestsError,
                crate::input::GetSampledRequestsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
        pub fn web_acl_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(inp);
            self
        }
        /// <p>The <code>WebACLId</code> of the <code>WebACL</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>
        /// <code>RuleId</code> is one of three values:</p>
        /// <ul>
        /// <li>
        /// <p>The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests that
        /// didn't match any of the rules in the specified <code>WebACL</code>.</p>
        /// </li>
        /// </ul>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>
        /// <code>RuleId</code> is one of three values:</p>
        /// <ul>
        /// <li>
        /// <p>The <code>RuleId</code> of the <code>Rule</code> or the <code>RuleGroupId</code> of the <code>RuleGroup</code> for which you want <code>GetSampledRequests</code> to return a sample of requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Default_Action</code>, which causes <code>GetSampledRequests</code> to return a sample of the requests that
        /// didn't match any of the rules in the specified <code>WebACL</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a
        /// sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special  
        /// designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn time_window(mut self, inp: crate::model::TimeWindow) -> Self {
            self.inner = self.inner.time_window(inp);
            self
        }
        /// <p>The start date and time and the end date and time of the range for which you want <code>GetSampledRequests</code> to return a
        /// sample of requests. You must specify the times in Coordinated Universal Time (UTC) format. UTC format includes the special  
        /// designator, <code>Z</code>. For example, <code>"2016-09-27T14:50Z"</code>. You can specify any time range in the previous three hours.</p>
        pub fn set_time_window(
            mut self,
            input: std::option::Option<crate::model::TimeWindow>,
        ) -> Self {
            self.inner = self.inner.set_time_window(input);
            self
        }
        /// <p>The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received
        /// during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code>
        /// returns information about all of them. </p>
        pub fn max_items(mut self, inp: i64) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The number of requests that you want AWS WAF to return from among the first 5,000 requests that your AWS resource received
        /// during the time range. If your resource received fewer requests than the value of <code>MaxItems</code>, <code>GetSampledRequests</code>
        /// returns information about all of them. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>SizeConstraintSet</a> specified by <code>SizeConstraintSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSizeConstraintSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_size_constraint_set_input::Builder,
    }
    impl<C, M, R> GetSizeConstraintSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSizeConstraintSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSizeConstraintSetInputOperationOutputAlias,
                crate::output::GetSizeConstraintSetOutput,
                crate::error::GetSizeConstraintSetError,
                crate::input::GetSizeConstraintSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <a>SizeConstraintSet</a> that you want to get. <code>SizeConstraintSetId</code> is returned by
        /// <a>CreateSizeConstraintSet</a> and by <a>ListSizeConstraintSets</a>.</p>
        pub fn size_constraint_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.size_constraint_set_id(inp);
            self
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <a>SizeConstraintSet</a> that you want to get. <code>SizeConstraintSetId</code> is returned by
        /// <a>CreateSizeConstraintSet</a> and by <a>ListSizeConstraintSets</a>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_size_constraint_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>SqlInjectionMatchSet</a> that is specified by <code>SqlInjectionMatchSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSqlInjectionMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sql_injection_match_set_input::Builder,
    }
    impl<C, M, R> GetSqlInjectionMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSqlInjectionMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSqlInjectionMatchSetInputOperationOutputAlias,
                crate::output::GetSqlInjectionMatchSetOutput,
                crate::error::GetSqlInjectionMatchSetError,
                crate::input::GetSqlInjectionMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <a>SqlInjectionMatchSet</a> that you want to get. <code>SqlInjectionMatchSetId</code>
        /// is returned by <a>CreateSqlInjectionMatchSet</a> and by <a>ListSqlInjectionMatchSets</a>.</p>
        pub fn sql_injection_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_injection_match_set_id(inp);
            self
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <a>SqlInjectionMatchSet</a> that you want to get. <code>SqlInjectionMatchSetId</code>
        /// is returned by <a>CreateSqlInjectionMatchSet</a> and by <a>ListSqlInjectionMatchSets</a>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_injection_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>WebACL</a> that is specified by <code>WebACLId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_web_acl_input::Builder,
    }
    impl<C, M, R> GetWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWebAclInputOperationOutputAlias,
                crate::output::GetWebAclOutput,
                crate::error::GetWebACLError,
                crate::input::GetWebAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <a>WebACL</a> that you want to get. <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by
        /// <a>ListWebACLs</a>.</p>
        pub fn web_acl_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(inp);
            self
        }
        /// <p>The <code>WebACLId</code> of the <a>WebACL</a> that you want to get. <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by
        /// <a>ListWebACLs</a>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns the <a>XssMatchSet</a> that is specified by <code>XssMatchSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetXssMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_xss_match_set_input::Builder,
    }
    impl<C, M, R> GetXssMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetXssMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetXssMatchSetInputOperationOutputAlias,
                crate::output::GetXssMatchSetOutput,
                crate::error::GetXssMatchSetError,
                crate::input::GetXssMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>XssMatchSetId</code> of the <a>XssMatchSet</a> that you want to get. <code>XssMatchSetId</code>
        /// is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.</p>
        pub fn xss_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.xss_match_set_id(inp);
            self
        }
        /// <p>The <code>XssMatchSetId</code> of the <a>XssMatchSet</a> that you want to get. <code>XssMatchSetId</code>
        /// is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_xss_match_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActivatedRulesInRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>ActivatedRule</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListActivatedRulesInRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_activated_rules_in_rule_group_input::Builder,
    }
    impl<C, M, R> ListActivatedRulesInRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActivatedRulesInRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActivatedRulesInRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActivatedRulesInRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActivatedRulesInRuleGroupInputOperationOutputAlias,
                crate::output::ListActivatedRulesInRuleGroupOutput,
                crate::error::ListActivatedRulesInRuleGroupError,
                crate::input::ListActivatedRulesInRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> for which you want to get a list of <a>ActivatedRule</a> objects.</p>
        pub fn rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(inp);
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> for which you want to get a list of <a>ActivatedRule</a> objects.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ActivatedRules</code>.
        /// For the second and subsequent <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>ActivatedRules</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ActivatedRules</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ActivatedRules</code>.
        /// For the second and subsequent <code>ListActivatedRulesInRuleGroup</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>ActivatedRules</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>ActivatedRules</code> that you want AWS WAF to return for this request. If you have more <code>ActivatedRules</code> than the number that you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>ActivatedRules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListByteMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>ByteMatchSetSummary</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListByteMatchSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_byte_match_sets_input::Builder,
    }
    impl<C, M, R> ListByteMatchSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListByteMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListByteMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListByteMatchSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListByteMatchSetsInputOperationOutputAlias,
                crate::output::ListByteMatchSetsOutput,
                crate::error::ListByteMatchSetsError,
                crate::input::ListByteMatchSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>.
        /// For the second and subsequent <code>ListByteMatchSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>ByteMatchSets</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>.
        /// For the second and subsequent <code>ListByteMatchSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>ByteMatchSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>ByteMatchSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>ByteMatchSets</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>ByteMatchSet</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>ByteMatchSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>ByteMatchSets</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>ByteMatchSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeoMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>GeoMatchSetSummary</a> objects in the response.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGeoMatchSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_geo_match_sets_input::Builder,
    }
    impl<C, M, R> ListGeoMatchSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGeoMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeoMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeoMatchSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGeoMatchSetsInputOperationOutputAlias,
                crate::output::ListGeoMatchSetsOutput,
                crate::error::ListGeoMatchSetsError,
                crate::input::ListGeoMatchSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>GeoMatchSet</code>s than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>GeoMatchSet</code> objects.
        /// For the second and subsequent <code>ListGeoMatchSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>GeoMatchSet</code>s than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>GeoMatchSet</code> objects.
        /// For the second and subsequent <code>ListGeoMatchSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>GeoMatchSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>GeoMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>GeoMatchSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>GeoMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>GeoMatchSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIPSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>IPSetSummary</a> objects in the response.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIPSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ip_sets_input::Builder,
    }
    impl<C, M, R> ListIPSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIPSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIPSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIpSetsInputOperationOutputAlias,
                crate::output::ListIpSetsOutput,
                crate::error::ListIPSetsError,
                crate::input::ListIpSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>AWS WAF returns a <code>NextMarker</code> value in the response that allows you to
        /// list another group of <code>IPSets</code>. For the second and subsequent
        /// <code>ListIPSets</code> requests, specify the value of <code>NextMarker</code> from the
        /// previous response to get information about another batch of <code>IPSets</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>AWS WAF returns a <code>NextMarker</code> value in the response that allows you to
        /// list another group of <code>IPSets</code>. For the second and subsequent
        /// <code>ListIPSets</code> requests, specify the value of <code>NextMarker</code> from the
        /// previous response to get information about another batch of <code>IPSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>IPSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>IPSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>IPSet</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>IPSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>IPSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>IPSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLoggingConfigurations`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>LoggingConfiguration</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLoggingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_logging_configurations_input::Builder,
    }
    impl<C, M, R> ListLoggingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLoggingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLoggingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLoggingConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLoggingConfigurationsInputOperationOutputAlias,
                crate::output::ListLoggingConfigurationsOutput,
                crate::error::ListLoggingConfigurationsError,
                crate::input::ListLoggingConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>LoggingConfigurations</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>LoggingConfigurations</code>.
        /// For the second and subsequent <code>ListLoggingConfigurations</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>ListLoggingConfigurations</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>LoggingConfigurations</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>LoggingConfigurations</code>.
        /// For the second and subsequent <code>ListLoggingConfigurations</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>ListLoggingConfigurations</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>LoggingConfigurations</code> that you want AWS WAF to return for this request. If you have more <code>LoggingConfigurations</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>LoggingConfigurations</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>LoggingConfigurations</code> that you want AWS WAF to return for this request. If you have more <code>LoggingConfigurations</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>LoggingConfigurations</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRateBasedRules`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>RuleSummary</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRateBasedRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rate_based_rules_input::Builder,
    }
    impl<C, M, R> ListRateBasedRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRateBasedRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRateBasedRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRateBasedRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRateBasedRulesInputOperationOutputAlias,
                crate::output::ListRateBasedRulesOutput,
                crate::error::ListRateBasedRulesError,
                crate::input::ListRateBasedRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code>
        /// than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the
        /// response that allows you to list another group of <code>Rules</code>. For the second and
        /// subsequent <code>ListRateBasedRules</code> requests, specify the value of
        /// <code>NextMarker</code> from the previous response to get information about another
        /// batch of <code>Rules</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code>
        /// than the value of <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the
        /// response that allows you to list another group of <code>Rules</code>. For the second and
        /// subsequent <code>ListRateBasedRules</code> requests, specify the value of
        /// <code>NextMarker</code> from the previous response to get information about another
        /// batch of <code>Rules</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this
        /// request. If you have more <code>Rules</code> than the number that you specify for
        /// <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can
        /// use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this
        /// request. If you have more <code>Rules</code> than the number that you specify for
        /// <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can
        /// use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegexMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>RegexMatchSetSummary</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRegexMatchSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_regex_match_sets_input::Builder,
    }
    impl<C, M, R> ListRegexMatchSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRegexMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegexMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegexMatchSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRegexMatchSetsInputOperationOutputAlias,
                crate::output::ListRegexMatchSetsOutput,
                crate::error::ListRegexMatchSetsError,
                crate::input::ListRegexMatchSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexMatchSet</code> objects than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>.
        /// For the second and subsequent <code>ListRegexMatchSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexMatchSet</code> objects than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>ByteMatchSets</code>.
        /// For the second and subsequent <code>ListRegexMatchSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>RegexMatchSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>RegexMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>RegexMatchSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>RegexMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>RegexMatchSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegexPatternSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>RegexPatternSetSummary</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRegexPatternSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_regex_pattern_sets_input::Builder,
    }
    impl<C, M, R> ListRegexPatternSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRegexPatternSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegexPatternSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegexPatternSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRegexPatternSetsInputOperationOutputAlias,
                crate::output::ListRegexPatternSetsOutput,
                crate::error::ListRegexPatternSetsError,
                crate::input::ListRegexPatternSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexPatternSet</code> objects than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RegexPatternSet</code> objects.
        /// For the second and subsequent <code>ListRegexPatternSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RegexPatternSet</code> objects than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RegexPatternSet</code> objects.
        /// For the second and subsequent <code>ListRegexPatternSets</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>RegexPatternSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>RegexPatternSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>RegexPatternSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>RegexPatternSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>RegexPatternSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleGroups`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>RuleGroup</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rule_groups_input::Builder,
    }
    impl<C, M, R> ListRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRuleGroupsInputOperationOutputAlias,
                crate::output::ListRuleGroupsOutput,
                crate::error::ListRuleGroupsError,
                crate::input::ListRuleGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RuleGroups</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RuleGroups</code>.
        /// For the second and subsequent <code>ListRuleGroups</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>RuleGroups</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>RuleGroups</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>RuleGroups</code>.
        /// For the second and subsequent <code>ListRuleGroups</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>RuleGroups</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>RuleGroups</code> that you want AWS WAF to return for this request. If you have more <code>RuleGroups</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RuleGroups</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>RuleGroups</code> that you want AWS WAF to return for this request. If you have more <code>RuleGroups</code> than the number that you specify for <code>Limit</code>, the response includes a <code>NextMarker</code> value that you can use to get another batch of <code>RuleGroups</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>RuleSummary</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl<C, M, R> ListRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRulesInputOperationOutputAlias,
                crate::output::ListRulesOutput,
                crate::error::ListRulesError,
                crate::input::ListRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>.
        /// For the second and subsequent <code>ListRules</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>Rules</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>Rules</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>Rules</code>.
        /// For the second and subsequent <code>ListRules</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>Rules</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more       <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>Rules</code> that you want AWS WAF to return for this request. If you have more       <code>Rules</code> than the number that you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSizeConstraintSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>SizeConstraintSetSummary</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSizeConstraintSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_size_constraint_sets_input::Builder,
    }
    impl<C, M, R> ListSizeConstraintSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSizeConstraintSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSizeConstraintSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSizeConstraintSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSizeConstraintSetsInputOperationOutputAlias,
                crate::output::ListSizeConstraintSetsOutput,
                crate::error::ListSizeConstraintSetsError,
                crate::input::ListSizeConstraintSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>SizeConstraintSets</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SizeConstraintSets</code>.
        /// For the second and subsequent <code>ListSizeConstraintSets</code> requests, specify the value of <code>NextMarker</code>       from the previous response to get information about another batch of <code>SizeConstraintSets</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>SizeConstraintSets</code> than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of <code>SizeConstraintSets</code>.
        /// For the second and subsequent <code>ListSizeConstraintSets</code> requests, specify the value of <code>NextMarker</code>       from the previous response to get information about another batch of <code>SizeConstraintSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>SizeConstraintSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>SizeConstraintSets</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>SizeConstraintSet</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>SizeConstraintSet</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>SizeConstraintSets</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>SizeConstraintSet</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSqlInjectionMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>SqlInjectionMatchSet</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSqlInjectionMatchSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sql_injection_match_sets_input::Builder,
    }
    impl<C, M, R> ListSqlInjectionMatchSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSqlInjectionMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSqlInjectionMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSqlInjectionMatchSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSqlInjectionMatchSetsInputOperationOutputAlias,
                crate::output::ListSqlInjectionMatchSetsOutput,
                crate::error::ListSqlInjectionMatchSetsError,
                crate::input::ListSqlInjectionMatchSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <a>SqlInjectionMatchSet</a> objects than the value of
        /// <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of
        /// <code>SqlInjectionMatchSets</code>. For the second and subsequent <code>ListSqlInjectionMatchSets</code> requests, specify the
        /// value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SqlInjectionMatchSets</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <a>SqlInjectionMatchSet</a> objects than the value of
        /// <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of
        /// <code>SqlInjectionMatchSets</code>. For the second and subsequent <code>ListSqlInjectionMatchSets</code> requests, specify the
        /// value of <code>NextMarker</code> from the previous response to get information about another batch of <code>SqlInjectionMatchSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <a>SqlInjectionMatchSet</a> objects that you want AWS WAF to return for this request. If you have more
        /// <code>SqlInjectionMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <a>SqlInjectionMatchSet</a> objects that you want AWS WAF to return for this request. If you have more
        /// <code>SqlInjectionMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSubscribedRuleGroups`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>RuleGroup</a> objects that you are subscribed to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSubscribedRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_subscribed_rule_groups_input::Builder,
    }
    impl<C, M, R> ListSubscribedRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSubscribedRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSubscribedRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSubscribedRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSubscribedRuleGroupsInputOperationOutputAlias,
                crate::output::ListSubscribedRuleGroupsOutput,
                crate::error::ListSubscribedRuleGroupsError,
                crate::input::ListSubscribedRuleGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code>subscribed rule groups than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of subscribed rule groups.
        /// For the second and subsequent <code>ListSubscribedRuleGroupsRequest</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of subscribed rule groups.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>ByteMatchSets</code>subscribed rule groups than the value of <code>Limit</code>,
        /// AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of subscribed rule groups.
        /// For the second and subsequent <code>ListSubscribedRuleGroupsRequest</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of subscribed rule groups.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of subscribed rule groups that you want AWS WAF to return for this request. If you have more
        /// objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of subscribed rule groups that you want AWS WAF to return for this request. If you have more
        /// objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Retrieves the tags associated with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.  </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p></p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p></p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p></p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p></p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWebACLs`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>WebACLSummary</a> objects in the response.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWebACLs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_web_ac_ls_input::Builder,
    }
    impl<C, M, R> ListWebACLs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWebACLs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWebAcLsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWebACLsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWebAcLsInputOperationOutputAlias,
                crate::output::ListWebAcLsOutput,
                crate::error::ListWebACLsError,
                crate::input::ListWebAcLsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>WebACL</code> objects than the number that you specify
        /// for <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of
        /// <code>WebACL</code> objects. For the second and subsequent <code>ListWebACLs</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>WebACL</code> objects.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <code>WebACL</code> objects than the number that you specify
        /// for <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of
        /// <code>WebACL</code> objects. For the second and subsequent <code>ListWebACLs</code> requests, specify the value of <code>NextMarker</code>
        /// from the previous response to get information about another batch of <code>WebACL</code> objects.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <code>WebACL</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>WebACL</code> objects.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <code>WebACL</code> objects that you want AWS WAF to return for this request. If you have more
        /// <code>WebACL</code> objects than the number that you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>WebACL</code> objects.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListXssMatchSets`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Returns an array of <a>XssMatchSet</a> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListXssMatchSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_xss_match_sets_input::Builder,
    }
    impl<C, M, R> ListXssMatchSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListXssMatchSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListXssMatchSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListXssMatchSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListXssMatchSetsInputOperationOutputAlias,
                crate::output::ListXssMatchSetsOutput,
                crate::error::ListXssMatchSetsError,
                crate::input::ListXssMatchSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <a>XssMatchSet</a> objects than the value of
        /// <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of
        /// <code>XssMatchSets</code>. For the second and subsequent <code>ListXssMatchSets</code> requests, specify the
        /// value of <code>NextMarker</code> from the previous response to get information about another batch of <code>XssMatchSets</code>.</p>
        pub fn next_marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_marker(inp);
            self
        }
        /// <p>If you specify a value for <code>Limit</code> and you have more <a>XssMatchSet</a> objects than the value of
        /// <code>Limit</code>, AWS WAF returns a <code>NextMarker</code> value in the response that allows you to list another group of
        /// <code>XssMatchSets</code>. For the second and subsequent <code>ListXssMatchSets</code> requests, specify the
        /// value of <code>NextMarker</code> from the previous response to get information about another batch of <code>XssMatchSets</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_marker(input);
            self
        }
        /// <p>Specifies the number of <a>XssMatchSet</a> objects that you want AWS WAF to return for this request. If you have more
        /// <code>XssMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>Specifies the number of <a>XssMatchSet</a> objects that you want AWS WAF to return for this request. If you have more
        /// <code>XssMatchSet</code> objects than the number you specify for <code>Limit</code>, the response includes a
        /// <code>NextMarker</code> value that you can use to get another batch of <code>Rules</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLoggingConfiguration`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Associates a <a>LoggingConfiguration</a> with a specified web ACL.</p>
    /// <p>You can access information about all traffic that AWS WAF inspects using the following
    /// steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create an Amazon Kinesis Data
    /// Firehose. </p>
    /// <p>Create the data firehose with a PUT source and in the region that you are operating. However, if you are capturing logs for Amazon CloudFront, always create the firehose in US East (N. Virginia). </p>
    /// <note>
    /// <p>Do not create the data firehose using a <code>Kinesis stream</code> as your source.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>Associate that firehose to your web ACL using a <code>PutLoggingConfiguration</code> request.</p>
    /// </li>
    /// </ol>
    ///
    /// <p>When you successfully enable logging using a <code>PutLoggingConfiguration</code> request, AWS WAF will create a service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose.  For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging Web ACL Traffic Information</a> in the <i>AWS WAF Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLoggingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_logging_configuration_input::Builder,
    }
    impl<C, M, R> PutLoggingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLoggingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLoggingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLoggingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLoggingConfigurationInputOperationOutputAlias,
                crate::output::PutLoggingConfigurationOutput,
                crate::error::PutLoggingConfigurationError,
                crate::input::PutLoggingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Kinesis Data Firehose that contains the inspected traffic
        /// information, the redacted fields details, and the Amazon Resource Name (ARN) of the web ACL
        /// to monitor.</p>
        /// <note>
        /// <p>When specifying <code>Type</code> in <code>RedactedFields</code>, you must use one of
        /// the following values: <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>,
        /// or <code>METHOD</code>.</p>
        /// </note>
        pub fn logging_configuration(mut self, inp: crate::model::LoggingConfiguration) -> Self {
            self.inner = self.inner.logging_configuration(inp);
            self
        }
        /// <p>The Amazon Kinesis Data Firehose that contains the inspected traffic
        /// information, the redacted fields details, and the Amazon Resource Name (ARN) of the web ACL
        /// to monitor.</p>
        /// <note>
        /// <p>When specifying <code>Type</code> in <code>RedactedFields</code>, you must use one of
        /// the following values: <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>,
        /// or <code>METHOD</code>.</p>
        /// </note>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_logging_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermissionPolicy`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Attaches an IAM policy to the specified resource. The only supported use for this action is to share a RuleGroup across accounts.</p>
    /// <p>The <code>PutPermissionPolicy</code> is subject to the following restrictions:</p>
    /// <ul>
    /// <li>
    /// <p>You can attach only one policy with each <code>PutPermissionPolicy</code> request.</p>
    /// </li>
    /// <li>
    /// <p>The policy must include an <code>Effect</code>, <code>Action</code> and <code>Principal</code>. </p>
    /// </li>
    /// <li>
    ///
    /// <p>
    /// <code>Effect</code> must specify <code>Allow</code>.</p>
    /// </li>
    /// <li>
    /// <p>The <code>Action</code> in the policy must be <code>waf:UpdateWebACL</code>, <code>waf-regional:UpdateWebACL</code>, <code>waf:GetRuleGroup</code> and <code>waf-regional:GetRuleGroup</code> . Any extra or wildcard actions in the policy will be rejected.</p>
    /// </li>
    /// <li>
    /// <p>The policy cannot include a <code>Resource</code> parameter.</p>
    /// </li>
    /// <li>
    /// <p>The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.</p>
    /// </li>
    /// <li>
    /// <p>The user making the request must be the owner of the RuleGroup.</p>
    /// </li>
    /// <li>
    /// <p>Your policy must be composed using IAM Policy version 2012-10-17.</p>
    /// </li>
    /// </ul>     
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM Policies</a>.  </p>  
    ///
    /// <p>An example of a valid policy parameter is shown in the Examples section below.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutPermissionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_permission_policy_input::Builder,
    }
    impl<C, M, R> PutPermissionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPermissionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPermissionPolicyInputOperationOutputAlias,
                crate::output::PutPermissionPolicyOutput,
                crate::error::PutPermissionPolicyError,
                crate::input::PutPermissionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach the policy.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach the policy.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The policy to attach to the specified RuleGroup.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The policy to attach to the specified RuleGroup.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Associates tags with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.</p>
    /// <p>Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can use this action to tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.  </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p></p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p></p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p></p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p></p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateByteMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>ByteMatchTuple</a> objects (filters) in a <a>ByteMatchSet</a>. For each <code>ByteMatchTuple</code> object,
    /// you specify the following values: </p>
    /// <ul>
    /// <li>
    /// <p>Whether to insert or delete the object from the array. If you want to change a <code>ByteMatchSetUpdate</code> object,
    /// you delete the existing object and add a new one.</p>
    /// </li>
    /// <li>
    /// <p>The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the <code>User-Agent</code> header. </p>
    /// </li>
    /// <li>
    /// <p>The bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to look for. For more information, including how you specify  
    /// the values for the AWS WAF API and the AWS CLI or SDKs, see <code>TargetString</code> in the <a>ByteMatchTuple</a> data type. </p>
    /// </li>
    /// <li>
    /// <p>Where to look, such as at the beginning or the end of a query string.</p>
    /// </li>
    /// <li>
    /// <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p>
    /// </li>
    /// </ul>
    /// <p>For example, you can add a <code>ByteMatchSetUpdate</code> object that matches web requests in which <code>User-Agent</code> headers contain
    /// the string <code>BadBot</code>. You can then configure AWS WAF to block those requests.</p>    
    /// <p>To create and configure a <code>ByteMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create a <code>ByteMatchSet.</code> For more information, see <a>CreateByteMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateByteMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateByteMatchSet</code> request to specify the part of the request that you want AWS WAF to inspect
    /// (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateByteMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_byte_match_set_input::Builder,
    }
    impl<C, M, R> UpdateByteMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateByteMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateByteMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateByteMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateByteMatchSetInputOperationOutputAlias,
                crate::output::UpdateByteMatchSetOutput,
                crate::error::UpdateByteMatchSetError,
                crate::input::UpdateByteMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to update. <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by
        /// <a>ListByteMatchSets</a>.</p>
        pub fn byte_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.byte_match_set_id(inp);
            self
        }
        /// <p>The <code>ByteMatchSetId</code> of the <a>ByteMatchSet</a> that you want to update. <code>ByteMatchSetId</code> is returned by <a>CreateByteMatchSet</a> and by
        /// <a>ListByteMatchSets</a>.</p>
        pub fn set_byte_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_byte_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a <a>ByteMatchSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>,
        /// and <code>TextTransformation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::ByteMatchSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>ByteMatchSetUpdate</code> objects that you want to insert into or delete from a <a>ByteMatchSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>ByteMatchSetUpdate</a>: Contains <code>Action</code> and <code>ByteMatchTuple</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>ByteMatchTuple</a>: Contains <code>FieldToMatch</code>, <code>PositionalConstraint</code>, <code>TargetString</code>,
        /// and <code>TextTransformation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ByteMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGeoMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>GeoMatchConstraint</a> objects in an <code>GeoMatchSet</code>. For each <code>GeoMatchConstraint</code> object,
    /// you specify the following values: </p>
    /// <ul>
    /// <li>
    /// <p>Whether to insert or delete the object from the array. If you want to change an <code>GeoMatchConstraint</code> object, you delete the existing object and add a new one.</p>
    /// </li>
    /// <li>
    /// <p>The <code>Type</code>. The only valid value for <code>Type</code> is <code>Country</code>.</p>
    /// </li>
    /// <li>
    /// <p>The <code>Value</code>, which is a two character code for the country to add to the <code>GeoMatchConstraint</code> object. Valid codes are listed in <a>GeoMatchConstraint$Value</a>.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>To create and configure an <code>GeoMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Submit a <a>CreateGeoMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateGeoMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateGeoMatchSet</code> request to specify the country that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>When you update an <code>GeoMatchSet</code>, you specify the country that you want to add and/or the country that you want to delete.
    /// If you want to change a country, you delete the existing country and add the new one.</p>    
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGeoMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_geo_match_set_input::Builder,
    }
    impl<C, M, R> UpdateGeoMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGeoMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGeoMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGeoMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGeoMatchSetInputOperationOutputAlias,
                crate::output::UpdateGeoMatchSetOutput,
                crate::error::UpdateGeoMatchSetError,
                crate::input::UpdateGeoMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to update. <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by
        /// <a>ListGeoMatchSets</a>.</p>
        pub fn geo_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geo_match_set_id(inp);
            self
        }
        /// <p>The <code>GeoMatchSetId</code> of the <a>GeoMatchSet</a> that you want to update. <code>GeoMatchSetId</code> is returned by <a>CreateGeoMatchSet</a> and by
        /// <a>ListGeoMatchSets</a>.</p>
        pub fn set_geo_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_geo_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an <a>GeoMatchSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
        /// </p>
        /// <p>You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.</p>      
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::GeoMatchSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>GeoMatchSetUpdate</code> objects that you want to insert into or delete from an <a>GeoMatchSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>GeoMatchSetUpdate</a>: Contains <code>Action</code> and <code>GeoMatchConstraint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>GeoMatchConstraint</a>: Contains <code>Type</code> and <code>Value</code>
        /// </p>
        /// <p>You can have only one <code>Type</code> and <code>Value</code> per <code>GeoMatchConstraint</code>. To add multiple countries, include multiple <code>GeoMatchSetUpdate</code> objects in your request.</p>      
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeoMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIPSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>IPSetDescriptor</a> objects in an
    /// <code>IPSet</code>. For each <code>IPSetDescriptor</code> object, you specify the following
    /// values: </p>
    /// <ul>
    /// <li>
    /// <p>Whether to insert or delete the object from the array. If you want to change an
    /// <code>IPSetDescriptor</code> object, you delete the existing object and add a new
    /// one.</p>
    /// </li>
    /// <li>
    /// <p>The IP address version, <code>IPv4</code> or <code>IPv6</code>. </p>
    /// </li>
    /// <li>
    /// <p>The IP address in CIDR notation, for example, <code>192.0.2.0/24</code> (for
    /// the range of IP addresses from <code>192.0.2.0</code> to <code>192.0.2.255</code>) or
    /// <code>192.0.2.44/32</code> (for the individual IP address
    /// <code>192.0.2.44</code>). </p>
    /// </li>
    /// </ul>
    /// <p>AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS
    /// WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128. For more
    /// information about CIDR notation, see the Wikipedia entry <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
    /// Inter-Domain Routing</a>.</p>
    /// <p>IPv6 addresses can be represented using any of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>1111:0000:0000:0000:0000:0000:0000:0111/128</p>
    /// </li>
    /// <li>
    /// <p>1111:0:0:0:0:0:0:0111/128</p>
    /// </li>
    /// <li>
    /// <p>1111::0111/128</p>
    /// </li>
    /// <li>
    /// <p>1111::111/128</p>
    /// </li>
    /// </ul>
    /// <p>You use an <code>IPSet</code> to specify which web requests you want to allow or
    /// block based on the IP addresses that the requests originated from. For example, if you're
    /// receiving a lot of requests from one or a small number of IP addresses and you want to
    /// block the requests, you can create an <code>IPSet</code> that specifies those IP addresses,
    /// and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure an <code>IPSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Submit a <a>CreateIPSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide
    /// in the <code>ChangeToken</code> parameter of an <a>UpdateIPSet</a>
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateIPSet</code> request to specify the IP addresses that you
    /// want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>When you update an <code>IPSet</code>, you specify the IP addresses that you want to
    /// add and/or the IP addresses that you want to delete. If you want to change an IP address,
    /// you delete the existing IP address and add the new one.</p>
    /// <p>You can insert a maximum of 1000 addresses in a single
    /// request.</p>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP
    /// requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF
    /// Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ip_set_input::Builder,
    }
    impl<C, M, R> UpdateIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIpSetInputOperationOutputAlias,
                crate::output::UpdateIpSetOutput,
                crate::error::UpdateIPSetError,
                crate::input::UpdateIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
        /// <a>ListIPSets</a>.</p>
        pub fn ip_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(inp);
            self
        }
        /// <p>The <code>IPSetId</code> of the <a>IPSet</a> that you want to update. <code>IPSetId</code> is returned by <a>CreateIPSet</a> and by
        /// <a>ListIPSets</a>.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You can insert a maximum of 1000 addresses in a single request.</p>
        pub fn updates(mut self, inp: impl Into<crate::model::IpSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>IPSetUpdate</code> objects that you want to insert into or delete from an <a>IPSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>IPSetUpdate</a>: Contains <code>Action</code> and <code>IPSetDescriptor</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>IPSetDescriptor</a>: Contains <code>Type</code> and <code>Value</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You can insert a maximum of 1000 addresses in a single request.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRateBasedRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>Predicate</a> objects in a rule and updates the
    /// <code>RateLimit</code> in the rule. </p>
    /// <p>Each <code>Predicate</code> object identifies a predicate, such as a <a>ByteMatchSet</a> or an <a>IPSet</a>, that specifies the web requests
    /// that you want to block or count. The <code>RateLimit</code> specifies the number of
    /// requests every five minutes that triggers the rule.</p>
    /// <p>If you add more than one predicate to a <code>RateBasedRule</code>, a request must
    /// match all the predicates and exceed the <code>RateLimit</code> to be counted or blocked.
    /// For example, suppose you add the following to a <code>RateBasedRule</code>:</p>
    /// <ul>
    /// <li>
    /// <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44/32</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>ByteMatchSet</code> that matches <code>BadBot</code> in the
    /// <code>User-Agent</code> header</p>
    /// </li>
    /// </ul>
    /// <p>Further, you specify a
    /// <code>RateLimit</code> of 1,000.</p>
    /// <p>You then add the <code>RateBasedRule</code> to a <code>WebACL</code> and specify that
    /// you want to block requests that satisfy the rule. For a request to be blocked, it must come
    /// from the IP address 192.0.2.44 <i>and</i> the <code>User-Agent</code> header
    /// in the request must contain the value <code>BadBot</code>. Further, requests that match
    /// these two conditions much be received at a rate of more than 1,000 every five minutes. If
    /// the rate drops below this limit, AWS WAF no longer blocks the requests.</p>
    ///
    /// <p>As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a
    /// <code>RateBasedRule</code>:</p>
    ///
    ///
    /// <ul>
    /// <li>
    /// <p>A <code>ByteMatchSet</code> with <code>FieldToMatch</code> of <code>URI</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>PositionalConstraint</code> of <code>STARTS_WITH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>A <code>TargetString</code> of <code>login</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Further, you specify a <code>RateLimit</code> of 1,000.</p>
    /// <p>By adding this <code>RateBasedRule</code> to a <code>WebACL</code>, you could limit requests to your login page without affecting the rest of your site.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRateBasedRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rate_based_rule_input::Builder,
    }
    impl<C, M, R> UpdateRateBasedRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRateBasedRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRateBasedRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRateBasedRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRateBasedRuleInputOperationOutputAlias,
                crate::output::UpdateRateBasedRuleOutput,
                crate::error::UpdateRateBasedRuleError,
                crate::input::UpdateRateBasedRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update.
        /// <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <a>ListRateBasedRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <code>RateBasedRule</code> that you want to update.
        /// <code>RuleId</code> is returned by <code>CreateRateBasedRule</code> and by <a>ListRateBasedRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete
        /// from a <a>RateBasedRule</a>. </p>
        pub fn updates(mut self, inp: impl Into<crate::model::RuleUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete
        /// from a <a>RateBasedRule</a>. </p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a
        /// five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other
        /// predicates specified in the rule are also met,
        /// AWS WAF triggers the action that is specified for this rule.</p>
        pub fn rate_limit(mut self, inp: i64) -> Self {
            self.inner = self.inner.rate_limit(inp);
            self
        }
        /// <p>The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code>, allowed in a
        /// five-minute period. If the number of requests exceeds the <code>RateLimit</code> and the other
        /// predicates specified in the rule are also met,
        /// AWS WAF triggers the action that is specified for this rule.</p>
        pub fn set_rate_limit(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_rate_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegexMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>RegexMatchTuple</a> objects (filters) in a <a>RegexMatchSet</a>. For each <code>RegexMatchSetUpdate</code> object,
    /// you specify the following values: </p>
    /// <ul>
    /// <li>
    /// <p>Whether to insert or delete the object from the array. If you want to change a <code>RegexMatchSetUpdate</code> object,
    /// you delete the existing object and add a new one.</p>
    /// </li>
    /// <li>
    /// <p>The part of a web request that you want AWS WAF to inspectupdate, such as a query string or the value of the <code>User-Agent</code> header. </p>
    /// </li>
    /// <li>
    /// <p>The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see <a>RegexPatternSet</a>. </p>
    /// </li>
    /// <li>
    /// <p>Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.</p>
    /// </li>
    /// </ul>
    /// <p> For example, you can create a <code>RegexPatternSet</code> that matches any requests with <code>User-Agent</code> headers
    /// that contain the string <code>B[a@]dB[o0]t</code>. You can then configure AWS WAF to reject those requests.</p>    
    /// <p>To create and configure a <code>RegexMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create a <code>RegexMatchSet.</code> For more information, see <a>CreateRegexMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateRegexMatchSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateRegexMatchSet</code> request to specify the part of the request that you want AWS WAF to inspect
    /// (for example, the header or the URI) and the identifier of the <code>RegexPatternSet</code> that contain the regular expression patters you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRegexMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_regex_match_set_input::Builder,
    }
    impl<C, M, R> UpdateRegexMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRegexMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegexMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegexMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRegexMatchSetInputOperationOutputAlias,
                crate::output::UpdateRegexMatchSetOutput,
                crate::error::UpdateRegexMatchSetError,
                crate::input::UpdateRegexMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to update. <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
        /// <a>ListRegexMatchSets</a>.</p>
        pub fn regex_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_match_set_id(inp);
            self
        }
        /// <p>The <code>RegexMatchSetId</code> of the <a>RegexMatchSet</a> that you want to update. <code>RegexMatchSetId</code> is returned by <a>CreateRegexMatchSet</a> and by
        /// <a>ListRegexMatchSets</a>.</p>
        pub fn set_regex_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_match_set_id(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a <a>RegexMatchSet</a>.
        /// For more information, see <a>RegexMatchTuple</a>.</p>
        pub fn updates(mut self, inp: impl Into<crate::model::RegexMatchSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>RegexMatchSetUpdate</code> objects that you want to insert into or delete from a <a>RegexMatchSet</a>.
        /// For more information, see <a>RegexMatchTuple</a>.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegexPatternSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <code>RegexPatternString</code> objects in a <a>RegexPatternSet</a>. For each <code>RegexPatternString</code> object,
    /// you specify the following values: </p>
    /// <ul>
    /// <li>
    /// <p>Whether to insert or delete the <code>RegexPatternString</code>.</p>
    /// </li>
    /// <li>
    /// <p>The regular expression pattern that you want to insert or delete. For more information, see <a>RegexPatternSet</a>. </p>
    /// </li>
    /// </ul>
    /// <p> For example, you can create a <code>RegexPatternString</code> such as <code>B[a@]dB[o0]t</code>. AWS WAF will match this <code>RegexPatternString</code> to:</p>
    /// <ul>
    /// <li>
    /// <p>BadBot</p>
    /// </li>
    /// <li>
    /// <p>BadB0t</p>
    /// </li>
    /// <li>
    /// <p>B@dBot</p>
    /// </li>
    /// <li>
    /// <p>B@dB0t</p>
    /// </li>
    /// </ul>
    /// <p>To create and configure a <code>RegexPatternSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create a <code>RegexPatternSet.</code> For more information, see <a>CreateRegexPatternSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateRegexPatternSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateRegexPatternSet</code> request to specify the regular expression pattern that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRegexPatternSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_regex_pattern_set_input::Builder,
    }
    impl<C, M, R> UpdateRegexPatternSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRegexPatternSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegexPatternSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegexPatternSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRegexPatternSetInputOperationOutputAlias,
                crate::output::UpdateRegexPatternSetOutput,
                crate::error::UpdateRegexPatternSetError,
                crate::input::UpdateRegexPatternSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to update. <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
        /// <a>ListRegexPatternSets</a>.</p>
        pub fn regex_pattern_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex_pattern_set_id(inp);
            self
        }
        /// <p>The <code>RegexPatternSetId</code> of the <a>RegexPatternSet</a> that you want to update. <code>RegexPatternSetId</code> is returned by <a>CreateRegexPatternSet</a> and by
        /// <a>ListRegexPatternSets</a>.</p>
        pub fn set_regex_pattern_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_regex_pattern_set_id(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a <a>RegexPatternSet</a>.</p>
        pub fn updates(mut self, inp: impl Into<crate::model::RegexPatternSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>RegexPatternSetUpdate</code> objects that you want to insert into or delete from a <a>RegexPatternSet</a>.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegexPatternSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRule`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>Predicate</a> objects in a <code>Rule</code>. Each
    /// <code>Predicate</code> object identifies a predicate, such as a <a>ByteMatchSet</a> or an <a>IPSet</a>, that specifies the web requests
    /// that you want to allow, block, or count. If you add more than one predicate to a
    /// <code>Rule</code>, a request must match all of the specifications to be allowed,
    /// blocked, or counted. For example, suppose
    /// that
    /// you add the following to a <code>Rule</code>: </p>    
    /// <ul>
    /// <li>
    /// <p>A <code>ByteMatchSet</code> that matches the value <code>BadBot</code> in the <code>User-Agent</code> header</p>
    /// </li>
    /// <li>
    /// <p>An <code>IPSet</code> that matches the IP address <code>192.0.2.44</code>
    /// </p>
    /// </li>
    /// </ul>    
    /// <p>You then add the <code>Rule</code> to a <code>WebACL</code> and specify that you want to block requests that satisfy the <code>Rule</code>.
    /// For a request to be blocked, the <code>User-Agent</code> header in the request must contain the value <code>BadBot</code>
    /// <i>and</i> the request must originate from the IP address 192.0.2.44.</p>    
    /// <p>To create and configure a <code>Rule</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create and update the predicates that you want to include in the <code>Rule</code>.</p>
    /// </li>
    /// <li>
    /// <p>Create the <code>Rule</code>. See <a>CreateRule</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateRule</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateRule</code> request to add predicates to the <code>Rule</code>.</p>
    /// </li>
    /// <li>
    /// <p>Create and update a <code>WebACL</code> that contains the <code>Rule</code>. See <a>CreateWebACL</a>.</p>
    /// </li>
    /// </ol>
    /// <p>If you want to replace one <code>ByteMatchSet</code> or <code>IPSet</code> with another, you delete the existing one and
    /// add the new one.</p>    
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rule_input::Builder,
    }
    impl<C, M, R> UpdateRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRuleInputOperationOutputAlias,
                crate::output::UpdateRuleOutput,
                crate::error::UpdateRuleError,
                crate::input::UpdateRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to update. <code>RuleId</code> is returned by
        /// <code>CreateRule</code> and by <a>ListRules</a>.</p>
        pub fn rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_id(inp);
            self
        }
        /// <p>The <code>RuleId</code> of the <code>Rule</code> that you want to update. <code>RuleId</code> is returned by
        /// <code>CreateRule</code> and by <a>ListRules</a>.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
        /// <a>Rule</a>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>RuleUpdate</a>: Contains <code>Action</code> and <code>Predicate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>Predicate</a>: Contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::RuleUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>RuleUpdate</code> objects that you want to insert into or delete from a
        /// <a>Rule</a>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>RuleUpdate</a>: Contains <code>Action</code> and <code>Predicate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>Predicate</a>: Contains <code>DataId</code>, <code>Negated</code>, and <code>Type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRuleGroup`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>ActivatedRule</a> objects in a <code>RuleGroup</code>.</p>
    /// <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>
    /// <p>You can have a maximum of ten rules per rule group.</p>
    ///
    ///
    /// <p>To create and configure a <code>RuleGroup</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create and update the <code>Rules</code> that you want to include in the <code>RuleGroup</code>. See <a>CreateRule</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateRuleGroup</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateRuleGroup</code> request to add <code>Rules</code> to the <code>RuleGroup</code>.</p>
    /// </li>
    /// <li>
    /// <p>Create and update a <code>WebACL</code> that contains the <code>RuleGroup</code>. See <a>CreateWebACL</a>.</p>
    /// </li>
    /// </ol>
    /// <p>If you want to replace one <code>Rule</code> with another, you delete the existing one and
    /// add the new one.</p>    
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_rule_group_input::Builder,
    }
    impl<C, M, R> UpdateRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRuleGroupInputOperationOutputAlias,
                crate::output::UpdateRuleGroupOutput,
                crate::error::UpdateRuleGroupError,
                crate::input::UpdateRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to update. <code>RuleGroupId</code> is returned by <a>CreateRuleGroup</a> and by
        /// <a>ListRuleGroups</a>.</p>
        pub fn rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule_group_id(inp);
            self
        }
        /// <p>The <code>RuleGroupId</code> of the <a>RuleGroup</a> that you want to update. <code>RuleGroupId</code> is returned by <a>CreateRuleGroup</a> and by
        /// <a>ListRuleGroups</a>.</p>
        pub fn set_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_rule_group_id(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
        /// <a>RuleGroup</a>.</p>
        /// <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>
        /// <p>
        /// <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>.  For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn updates(mut self, inp: impl Into<crate::model::RuleGroupUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>RuleGroupUpdate</code> objects that you want to insert into or delete from a
        /// <a>RuleGroup</a>.</p>
        /// <p>You can only insert <code>REGULAR</code> rules into a rule group.</p>
        /// <p>
        /// <code>ActivatedRule|OverrideAction</code> applies only when updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this case you do not use <code>ActivatedRule|Action</code>.  For all other update requests, <code>ActivatedRule|Action</code> is used instead of <code>ActivatedRule|OverrideAction</code>.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleGroupUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSizeConstraintSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>SizeConstraint</a> objects (filters) in a <a>SizeConstraintSet</a>. For each <code>SizeConstraint</code> object,
    /// you specify the following values: </p>
    /// <ul>
    /// <li>
    /// <p>Whether to insert or delete the object from the array. If you want to change a <code>SizeConstraintSetUpdate</code> object,
    /// you delete the existing object and add a new one.</p>
    /// </li>
    /// <li>
    /// <p>The part of a web request that you want AWS WAF to evaluate, such as the length of a query string or the length of the
    /// <code>User-Agent</code> header.</p>
    /// </li>
    /// <li>
    /// <p>Whether to perform any transformations on the request, such as converting it to lowercase, before checking its length.
    /// Note that transformations of the request body are not supported because the AWS resource forwards only the first <code>8192</code> bytes
    /// of your request to AWS WAF.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// </li>
    /// <li>
    /// <p>A <code>ComparisonOperator</code> used for evaluating the selected part of the request against the specified <code>Size</code>, such as  
    /// equals, greater than, less than, and so on.</p>
    /// </li>
    /// <li>
    /// <p>The length, in bytes, that you want AWS WAF to watch for in selected part of the request. The length is computed after applying the transformation.</p>
    /// </li>
    /// </ul>
    /// <p>For example, you can add a <code>SizeConstraintSetUpdate</code> object that matches web requests in which the length of the
    /// <code>User-Agent</code> header is greater than 100 bytes. You can then configure AWS WAF to block those requests.</p>
    /// <p>To create and configure a <code>SizeConstraintSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create a <code>SizeConstraintSet.</code> For more information, see <a>CreateSizeConstraintSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <code>UpdateSizeConstraintSet</code> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateSizeConstraintSet</code> request to specify the part of the request that you want AWS WAF to inspect
    /// (for example, the header or the URI) and the value that you want AWS WAF to watch for.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSizeConstraintSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_size_constraint_set_input::Builder,
    }
    impl<C, M, R> UpdateSizeConstraintSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSizeConstraintSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSizeConstraintSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSizeConstraintSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSizeConstraintSetInputOperationOutputAlias,
                crate::output::UpdateSizeConstraintSetOutput,
                crate::error::UpdateSizeConstraintSetError,
                crate::input::UpdateSizeConstraintSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <a>SizeConstraintSet</a> that you want to update. <code>SizeConstraintSetId</code>
        /// is returned by <a>CreateSizeConstraintSet</a> and by <a>ListSizeConstraintSets</a>.</p>
        pub fn size_constraint_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.size_constraint_set_id(inp);
            self
        }
        /// <p>The <code>SizeConstraintSetId</code> of the <a>SizeConstraintSet</a> that you want to update. <code>SizeConstraintSetId</code>
        /// is returned by <a>CreateSizeConstraintSet</a> and by <a>ListSizeConstraintSets</a>.</p>
        pub fn set_size_constraint_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_size_constraint_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>SizeConstraintSetUpdate</code> objects that you want to insert into or delete from a <a>SizeConstraintSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>SizeConstraintSetUpdate</a>: Contains <code>Action</code> and <code>SizeConstraint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>SizeConstraint</a>: Contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>,
        /// and <code>Size</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::SizeConstraintSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>SizeConstraintSetUpdate</code> objects that you want to insert into or delete from a <a>SizeConstraintSet</a>.
        /// For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>SizeConstraintSetUpdate</a>: Contains <code>Action</code> and <code>SizeConstraint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>SizeConstraint</a>: Contains <code>FieldToMatch</code>, <code>TextTransformation</code>, <code>ComparisonOperator</code>,
        /// and <code>Size</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SizeConstraintSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSqlInjectionMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>SqlInjectionMatchTuple</a> objects (filters) in a <a>SqlInjectionMatchSet</a>.
    /// For each <code>SqlInjectionMatchTuple</code> object, you specify the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Action</code>: Whether to insert the object into or delete the object from the array. To change a
    /// <code>SqlInjectionMatchTuple</code>, you delete the existing object and add a new one.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FieldToMatch</code>: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter,
    /// the name of the header or parameter.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TextTransformation</code>: Which text transformation, if any, to perform on the web request before
    /// inspecting the request for snippets of malicious SQL code.</p>
    /// <p>You can only specify a single type of  TextTransformation.</p>
    /// </li>
    /// </ul>
    /// <p>You use <code>SqlInjectionMatchSet</code> objects to specify which CloudFront
    /// requests that
    /// you want to allow, block, or count. For example, if you're receiving
    /// requests that contain snippets of SQL code in the query string and you want to block the
    /// requests, you can create a <code>SqlInjectionMatchSet</code> with the applicable settings,
    /// and then configure AWS WAF to block the requests. </p>
    /// <p>To create and configure a <code>SqlInjectionMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Submit a <a>CreateSqlInjectionMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateIPSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateSqlInjectionMatchSet</code> request to specify the parts of web requests that you want AWS WAF to
    /// inspect for snippets of SQL code.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSqlInjectionMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_sql_injection_match_set_input::Builder,
    }
    impl<C, M, R> UpdateSqlInjectionMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSqlInjectionMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSqlInjectionMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSqlInjectionMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSqlInjectionMatchSetInputOperationOutputAlias,
                crate::output::UpdateSqlInjectionMatchSetOutput,
                crate::error::UpdateSqlInjectionMatchSetError,
                crate::input::UpdateSqlInjectionMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update.
        /// <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by <a>ListSqlInjectionMatchSets</a>.</p>
        pub fn sql_injection_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_injection_match_set_id(inp);
            self
        }
        /// <p>The <code>SqlInjectionMatchSetId</code> of the <code>SqlInjectionMatchSet</code> that you want to update.
        /// <code>SqlInjectionMatchSetId</code> is returned by <a>CreateSqlInjectionMatchSet</a> and by <a>ListSqlInjectionMatchSets</a>.</p>
        pub fn set_sql_injection_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_injection_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
        /// <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::SqlInjectionMatchSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>SqlInjectionMatchSetUpdate</code> objects that you want to insert into or delete from a
        /// <a>SqlInjectionMatchSet</a>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>SqlInjectionMatchSetUpdate</a>: Contains <code>Action</code> and <code>SqlInjectionMatchTuple</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>SqlInjectionMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlInjectionMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebACL`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>ActivatedRule</a> objects in a <code>WebACL</code>. Each <code>Rule</code> identifies
    /// web requests that you want to allow, block, or count. When you update a <code>WebACL</code>, you specify the following values:</p>
    /// <ul>
    /// <li>
    /// <p>A default action for the <code>WebACL</code>, either <code>ALLOW</code> or <code>BLOCK</code>.
    /// AWS WAF performs the default action if a request doesn't match the criteria in any of the <code>Rules</code> in a <code>WebACL</code>.</p>
    /// </li>
    /// <li>
    /// <p>The <code>Rules</code> that you want to add
    /// or
    /// delete. If you want to replace one <code>Rule</code> with another, you delete the
    /// existing <code>Rule</code> and add the new one.</p>
    /// </li>
    /// <li>
    /// <p>For each <code>Rule</code>, whether you want AWS WAF to allow requests, block requests, or count requests that match
    /// the conditions in the <code>Rule</code>.</p>
    /// </li>
    /// <li>
    /// <p>The order in which you want AWS WAF to evaluate the <code>Rules</code> in a
    /// <code>WebACL</code>. If you add more than one <code>Rule</code> to a
    /// <code>WebACL</code>, AWS WAF evaluates each request against the <code>Rules</code>
    /// in order based on the value of <code>Priority</code>. (The <code>Rule</code> that has
    /// the lowest value for <code>Priority</code> is evaluated first.) When a web request
    /// matches all
    /// the
    /// predicates (such as <code>ByteMatchSets</code> and <code>IPSets</code>) in a
    /// <code>Rule</code>, AWS WAF immediately takes the corresponding action, allow or
    /// block, and doesn't evaluate the request against the remaining <code>Rules</code> in
    /// the <code>WebACL</code>, if any. </p>
    /// </li>
    /// </ul>
    ///
    /// <p>To create and configure a <code>WebACL</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Create and update the predicates that you want to include in <code>Rules</code>.
    /// For more information, see <a>CreateByteMatchSet</a>, <a>UpdateByteMatchSet</a>, <a>CreateIPSet</a>, <a>UpdateIPSet</a>,
    /// <a>CreateSqlInjectionMatchSet</a>, and <a>UpdateSqlInjectionMatchSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>Create and update the <code>Rules</code> that you want to include in the <code>WebACL</code>. For more information, see
    /// <a>CreateRule</a> and <a>UpdateRule</a>.</p>
    /// </li>
    /// <li>
    /// <p>Create a <code>WebACL</code>. See <a>CreateWebACL</a>.</p>
    /// </li>
    /// <li>
    /// <p>Use <code>GetChangeToken</code> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateWebACL</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateWebACL</code> request to specify the <code>Rules</code>
    /// that you want to include in the <code>WebACL</code>, to specify the default action,
    /// and to associate the <code>WebACL</code> with a CloudFront distribution. </p>
    /// <p>The <code>ActivatedRule</code> can be a rule group. If you specify a rule group
    /// as your
    /// <code>ActivatedRule</code>
    /// ,
    /// you can exclude specific rules from that rule group.</p>
    /// <p>If you already have a rule group associated with a web ACL and want to submit
    /// an <code>UpdateWebACL</code> request to exclude certain rules from that rule group,
    /// you must first remove the rule group from the web ACL, the re-insert it again,
    /// specifying the excluded rules.
    /// For details,
    /// see
    /// <a>ActivatedRule$ExcludedRules</a>
    /// .
    /// </p>
    /// </li>
    /// </ol>
    /// <p>Be aware that if you try to add a RATE_BASED rule to a web ACL without setting the rule type when first creating the rule, the  <a>UpdateWebACL</a> request will fail because the request tries to add a REGULAR rule (the default rule type) with the specified ID, which does not exist.     </p>      
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWebACL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_web_acl_input::Builder,
    }
    impl<C, M, R> UpdateWebACL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWebACL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebAclOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebACLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWebAclInputOperationOutputAlias,
                crate::output::UpdateWebAclOutput,
                crate::error::UpdateWebACLError,
                crate::input::UpdateWebAclInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>WebACLId</code> of the <a>WebACL</a> that you want to update. <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by
        /// <a>ListWebACLs</a>.</p>
        pub fn web_acl_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.web_acl_id(inp);
            self
        }
        /// <p>The <code>WebACLId</code> of the <a>WebACL</a> that you want to update. <code>WebACLId</code> is returned by <a>CreateWebACL</a> and by
        /// <a>ListWebACLs</a>.</p>
        pub fn set_web_acl_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_web_acl_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of updates to make to the <a>WebACL</a>.</p>    
        /// <p>An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a
        /// <a>WebACL</a>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>ActivatedRule</a>: Contains <code>Action</code>,
        /// <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and
        /// <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when
        /// updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this
        /// case,
        /// you do not use <code>ActivatedRule|Action</code>. For all other update requests,
        /// <code>ActivatedRule|Action</code> is used instead of
        /// <code>ActivatedRule|OverrideAction</code>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>WafAction</a>: Contains <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::WebAclUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of updates to make to the <a>WebACL</a>.</p>    
        /// <p>An array of <code>WebACLUpdate</code> objects that you want to insert into or delete from a
        /// <a>WebACL</a>. For more information, see the applicable data types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>WebACLUpdate</a>: Contains <code>Action</code> and <code>ActivatedRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>ActivatedRule</a>: Contains <code>Action</code>,
        /// <code>OverrideAction</code>, <code>Priority</code>, <code>RuleId</code>, and
        /// <code>Type</code>. <code>ActivatedRule|OverrideAction</code> applies only when
        /// updating or adding a <code>RuleGroup</code> to a <code>WebACL</code>. In this
        /// case,
        /// you do not use <code>ActivatedRule|Action</code>. For all other update requests,
        /// <code>ActivatedRule|Action</code> is used instead of
        /// <code>ActivatedRule|OverrideAction</code>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>WafAction</a>: Contains <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WebAclUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
        /// <p>A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default
        /// action if a request doesn't match the criteria in any of the rules in a web ACL.</p>
        pub fn default_action(mut self, inp: crate::model::WafAction) -> Self {
            self.inner = self.inner.default_action(inp);
            self
        }
        /// <p>A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs the default
        /// action if a request doesn't match the criteria in any of the rules in a web ACL.</p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::WafAction>,
        ) -> Self {
            self.inner = self.inner.set_default_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateXssMatchSet`.
    ///
    /// <note>
    /// <p>This is <b>AWS WAF Classic</b> documentation. For
    /// more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS
    /// WAF Classic</a> in the developer guide.</p>
    /// <p>
    /// <b>For the latest version of AWS
    /// WAF</b>, use the AWS WAFV2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the latest version, AWS WAF has a single set of endpoints for regional and global use. </p>
    /// </note>
    /// <p>Inserts or deletes <a>XssMatchTuple</a> objects (filters) in an <a>XssMatchSet</a>.
    /// For each <code>XssMatchTuple</code> object, you specify the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Action</code>: Whether to insert the object into or delete the object from the
    /// array. To change an
    /// <code>XssMatchTuple</code>, you delete the existing object and add a new
    /// one.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FieldToMatch</code>: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter,
    /// the name of the header or parameter.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TextTransformation</code>: Which text transformation, if any, to perform on the web request before
    /// inspecting the request for cross-site scripting attacks.</p>
    /// <p>You can only specify a single type of TextTransformation.</p>
    /// </li>
    /// </ul>
    /// <p>You use <code>XssMatchSet</code> objects to specify which CloudFront requests
    /// that
    /// you want to allow, block, or count. For example, if you're receiving
    /// requests that contain cross-site scripting attacks in the request body and you want to
    /// block the requests, you can create an <code>XssMatchSet</code> with the applicable
    /// settings, and then configure AWS WAF to block the requests. </p>    
    /// <p>To create and configure an <code>XssMatchSet</code>, perform the following steps:</p>
    /// <ol>
    /// <li>
    /// <p>Submit a <a>CreateXssMatchSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Use <a>GetChangeToken</a> to get the change token that you provide in the <code>ChangeToken</code> parameter of an
    /// <a>UpdateIPSet</a> request.</p>
    /// </li>
    /// <li>
    /// <p>Submit an <code>UpdateXssMatchSet</code> request to specify the parts of web requests that you want AWS WAF to
    /// inspect for cross-site scripting attacks.</p>
    /// </li>
    /// </ol>
    /// <p>For more information about how to use the AWS WAF API to allow or block HTTP requests, see the
    /// <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">AWS WAF Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateXssMatchSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_xss_match_set_input::Builder,
    }
    impl<C, M, R> UpdateXssMatchSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateXssMatchSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateXssMatchSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateXssMatchSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateXssMatchSetInputOperationOutputAlias,
                crate::output::UpdateXssMatchSetOutput,
                crate::error::UpdateXssMatchSetError,
                crate::input::UpdateXssMatchSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to update.
        /// <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.</p>
        pub fn xss_match_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.xss_match_set_id(inp);
            self
        }
        /// <p>The <code>XssMatchSetId</code> of the <code>XssMatchSet</code> that you want to update.
        /// <code>XssMatchSetId</code> is returned by <a>CreateXssMatchSet</a> and by <a>ListXssMatchSets</a>.</p>
        pub fn set_xss_match_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_xss_match_set_id(input);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn change_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_token(inp);
            self
        }
        /// <p>The value returned by the most recent call to <a>GetChangeToken</a>.</p>
        pub fn set_change_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_change_token(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>An array of <code>XssMatchSetUpdate</code> objects that you want to insert into or
        /// delete from an
        /// <a>XssMatchSet</a>. For more information, see the applicable data
        /// types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>XssMatchSetUpdate</a>: Contains <code>Action</code> and <code>XssMatchTuple</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>XssMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn updates(mut self, inp: impl Into<crate::model::XssMatchSetUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>An array of <code>XssMatchSetUpdate</code> objects that you want to insert into or
        /// delete from an
        /// <a>XssMatchSet</a>. For more information, see the applicable data
        /// types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>XssMatchSetUpdate</a>: Contains <code>Action</code> and <code>XssMatchTuple</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>XssMatchTuple</a>: Contains <code>FieldToMatch</code> and <code>TextTransformation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::XssMatchSetUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
