// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Voice ID
///
/// Client for invoking operations on Amazon Voice ID. Each operation on Amazon Voice ID is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_voiceid::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_voiceid::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_voiceid::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateDomain`](crate::client::fluent_builders::CreateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_name): <p>The name of the domain.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_description): <p>A brief description of this domain.</p>
    ///   - [`server_side_encryption_configuration(ServerSideEncryptionConfiguration)`](crate::client::fluent_builders::CreateDomain::server_side_encryption_configuration) / [`set_server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::client::fluent_builders::CreateDomain::set_server_side_encryption_configuration): <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side encryption of your data. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid"> Amazon Connect VoiceID encryption at rest</a> for more details on how the KMS Key is used. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_client_token): <p>The idempotency token for creating a new domain. If not provided, Amazon Web Services SDK populates this field.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDomain::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDomain::set_tags): <p>A list of tags you want added to the domain.</p>
    /// - On success, responds with [`CreateDomainOutput`](crate::output::CreateDomainOutput) with field(s):
    ///   - [`domain(Option<Domain>)`](crate::output::CreateDomainOutput::domain): <p>Information about the newly created domain.</p>
    /// - On failure, responds with [`SdkError<CreateDomainError>`](crate::error::CreateDomainError)
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDomain::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DeleteDomain::set_domain_id): <p>The identifier of the domain you want to delete.</p>
    /// - On success, responds with [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)

    /// - On failure, responds with [`SdkError<DeleteDomainError>`](crate::error::DeleteDomainError)
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFraudster`](crate::client::fluent_builders::DeleteFraudster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFraudster::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DeleteFraudster::set_domain_id): <p>The identifier of the domain containing the fraudster.</p>
    ///   - [`fraudster_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFraudster::fraudster_id) / [`set_fraudster_id(Option<String>)`](crate::client::fluent_builders::DeleteFraudster::set_fraudster_id): <p>The identifier of the fraudster you want to delete.</p>
    /// - On success, responds with [`DeleteFraudsterOutput`](crate::output::DeleteFraudsterOutput)

    /// - On failure, responds with [`SdkError<DeleteFraudsterError>`](crate::error::DeleteFraudsterError)
    pub fn delete_fraudster(&self) -> fluent_builders::DeleteFraudster<C, M, R> {
        fluent_builders::DeleteFraudster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSpeaker`](crate::client::fluent_builders::DeleteSpeaker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSpeaker::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DeleteSpeaker::set_domain_id): <p>The identifier of the domain containing the speaker.</p>
    ///   - [`speaker_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSpeaker::speaker_id) / [`set_speaker_id(Option<String>)`](crate::client::fluent_builders::DeleteSpeaker::set_speaker_id): <p>The identifier of the speaker you want to delete.</p>
    /// - On success, responds with [`DeleteSpeakerOutput`](crate::output::DeleteSpeakerOutput)

    /// - On failure, responds with [`SdkError<DeleteSpeakerError>`](crate::error::DeleteSpeakerError)
    pub fn delete_speaker(&self) -> fluent_builders::DeleteSpeaker<C, M, R> {
        fluent_builders::DeleteSpeaker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_domain_id): <p>The identifier of the domain you are describing.</p>
    /// - On success, responds with [`DescribeDomainOutput`](crate::output::DescribeDomainOutput) with field(s):
    ///   - [`domain(Option<Domain>)`](crate::output::DescribeDomainOutput::domain): <p>Information about the specified domain.</p>
    /// - On failure, responds with [`SdkError<DescribeDomainError>`](crate::error::DescribeDomainError)
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFraudster`](crate::client::fluent_builders::DescribeFraudster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFraudster::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DescribeFraudster::set_domain_id): <p>The identifier of the domain containing the fraudster.</p>
    ///   - [`fraudster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFraudster::fraudster_id) / [`set_fraudster_id(Option<String>)`](crate::client::fluent_builders::DescribeFraudster::set_fraudster_id): <p>The identifier of the fraudster you are describing.</p>
    /// - On success, responds with [`DescribeFraudsterOutput`](crate::output::DescribeFraudsterOutput) with field(s):
    ///   - [`fraudster(Option<Fraudster>)`](crate::output::DescribeFraudsterOutput::fraudster): <p>Information about the specified fraudster.</p>
    /// - On failure, responds with [`SdkError<DescribeFraudsterError>`](crate::error::DescribeFraudsterError)
    pub fn describe_fraudster(&self) -> fluent_builders::DescribeFraudster<C, M, R> {
        fluent_builders::DescribeFraudster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFraudsterRegistrationJob`](crate::client::fluent_builders::DescribeFraudsterRegistrationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFraudsterRegistrationJob::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DescribeFraudsterRegistrationJob::set_domain_id): <p>The identifier for the domain containing the fraudster registration job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFraudsterRegistrationJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeFraudsterRegistrationJob::set_job_id): <p>The identifier for the fraudster registration job you are describing.</p>
    /// - On success, responds with [`DescribeFraudsterRegistrationJobOutput`](crate::output::DescribeFraudsterRegistrationJobOutput) with field(s):
    ///   - [`job(Option<FraudsterRegistrationJob>)`](crate::output::DescribeFraudsterRegistrationJobOutput::job): <p>Contains details about the specified fraudster registration job.</p>
    /// - On failure, responds with [`SdkError<DescribeFraudsterRegistrationJobError>`](crate::error::DescribeFraudsterRegistrationJobError)
    pub fn describe_fraudster_registration_job(
        &self,
    ) -> fluent_builders::DescribeFraudsterRegistrationJob<C, M, R> {
        fluent_builders::DescribeFraudsterRegistrationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpeaker`](crate::client::fluent_builders::DescribeSpeaker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSpeaker::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DescribeSpeaker::set_domain_id): <p>The identifier of the domain that contains the speaker.</p>
    ///   - [`speaker_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSpeaker::speaker_id) / [`set_speaker_id(Option<String>)`](crate::client::fluent_builders::DescribeSpeaker::set_speaker_id): <p>The identifier of the speaker you are describing.</p>
    /// - On success, responds with [`DescribeSpeakerOutput`](crate::output::DescribeSpeakerOutput) with field(s):
    ///   - [`speaker(Option<Speaker>)`](crate::output::DescribeSpeakerOutput::speaker): <p>Information about the specified speaker.</p>
    /// - On failure, responds with [`SdkError<DescribeSpeakerError>`](crate::error::DescribeSpeakerError)
    pub fn describe_speaker(&self) -> fluent_builders::DescribeSpeaker<C, M, R> {
        fluent_builders::DescribeSpeaker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpeakerEnrollmentJob`](crate::client::fluent_builders::DescribeSpeakerEnrollmentJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSpeakerEnrollmentJob::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::DescribeSpeakerEnrollmentJob::set_domain_id): <p>The identifier of the domain containing the speaker enrollment job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSpeakerEnrollmentJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeSpeakerEnrollmentJob::set_job_id): <p>The identifier of the speaker enrollment job you are describing.</p>
    /// - On success, responds with [`DescribeSpeakerEnrollmentJobOutput`](crate::output::DescribeSpeakerEnrollmentJobOutput) with field(s):
    ///   - [`job(Option<SpeakerEnrollmentJob>)`](crate::output::DescribeSpeakerEnrollmentJobOutput::job): <p>Contains details about the specified speaker enrollment job.</p>
    /// - On failure, responds with [`SdkError<DescribeSpeakerEnrollmentJobError>`](crate::error::DescribeSpeakerEnrollmentJobError)
    pub fn describe_speaker_enrollment_job(
        &self,
    ) -> fluent_builders::DescribeSpeakerEnrollmentJob<C, M, R> {
        fluent_builders::DescribeSpeakerEnrollmentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EvaluateSession`](crate::client::fluent_builders::EvaluateSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::EvaluateSession::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::EvaluateSession::set_domain_id): <p>The identifier of the domain where the session started.</p>
    ///   - [`session_name_or_id(impl Into<String>)`](crate::client::fluent_builders::EvaluateSession::session_name_or_id) / [`set_session_name_or_id(Option<String>)`](crate::client::fluent_builders::EvaluateSession::set_session_name_or_id): <p>The session identifier, or name of the session, that you want to evaluate. In Voice ID integration, this is the Contact-Id.</p>
    /// - On success, responds with [`EvaluateSessionOutput`](crate::output::EvaluateSessionOutput) with field(s):
    ///   - [`domain_id(Option<String>)`](crate::output::EvaluateSessionOutput::domain_id): <p>The identifier of the domain containing the session.</p>
    ///   - [`session_id(Option<String>)`](crate::output::EvaluateSessionOutput::session_id): <p>The service-generated identifier of the session.</p>
    ///   - [`session_name(Option<String>)`](crate::output::EvaluateSessionOutput::session_name): <p>The client-provided name of the session.</p>
    ///   - [`streaming_status(Option<StreamingStatus>)`](crate::output::EvaluateSessionOutput::streaming_status): <p>The current status of audio streaming for this session. This field is useful to infer next steps when the Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>. In this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can mean that the client should call the API again later, once Voice ID has enough audio to produce a result. If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>, it means that the previously streamed session did not have enough speech to perform evaluation, and a new streaming session is needed to try again.</p>
    ///   - [`authentication_result(Option<AuthenticationResult>)`](crate::output::EvaluateSessionOutput::authentication_result): <p>Details resulting from the authentication process, such as authentication decision and authentication score.</p>
    ///   - [`fraud_detection_result(Option<FraudDetectionResult>)`](crate::output::EvaluateSessionOutput::fraud_detection_result): <p>Details resulting from the fraud detection process, such as fraud detection decision and risk score.</p>
    /// - On failure, responds with [`SdkError<EvaluateSessionError>`](crate::error::EvaluateSessionError)
    pub fn evaluate_session(&self) -> fluent_builders::EvaluateSession<C, M, R> {
        fluent_builders::EvaluateSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomains`](crate::client::fluent_builders::ListDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDomains::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomains::set_next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On success, responds with [`ListDomainsOutput`](crate::output::ListDomainsOutput) with field(s):
    ///   - [`domain_summaries(Option<Vec<DomainSummary>>)`](crate::output::ListDomainsOutput::domain_summaries): <p>A list containing details about each domain in the Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainsOutput::next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On failure, responds with [`SdkError<ListDomainsError>`](crate::error::ListDomainsError)
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFraudsterRegistrationJobs`](crate::client::fluent_builders::ListFraudsterRegistrationJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::set_domain_id): <p>The identifier of the domain containing the fraudster registration Jobs.</p>
    ///   - [`job_status(FraudsterRegistrationJobStatus)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::job_status) / [`set_job_status(Option<FraudsterRegistrationJobStatus>)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::set_job_status): <p>Provides the status of your fraudster registration job.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFraudsterRegistrationJobs::set_next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On success, responds with [`ListFraudsterRegistrationJobsOutput`](crate::output::ListFraudsterRegistrationJobsOutput) with field(s):
    ///   - [`job_summaries(Option<Vec<FraudsterRegistrationJobSummary>>)`](crate::output::ListFraudsterRegistrationJobsOutput::job_summaries): <p>A list containing details about each specified fraudster registration job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFraudsterRegistrationJobsOutput::next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On failure, responds with [`SdkError<ListFraudsterRegistrationJobsError>`](crate::error::ListFraudsterRegistrationJobsError)
    pub fn list_fraudster_registration_jobs(
        &self,
    ) -> fluent_builders::ListFraudsterRegistrationJobs<C, M, R> {
        fluent_builders::ListFraudsterRegistrationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSpeakerEnrollmentJobs`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::set_domain_id): <p>The identifier of the domain containing the speaker enrollment jobs.</p>
    ///   - [`job_status(SpeakerEnrollmentJobStatus)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::job_status) / [`set_job_status(Option<SpeakerEnrollmentJobStatus>)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::set_job_status): <p>Provides the status of your speaker enrollment Job.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs::set_next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On success, responds with [`ListSpeakerEnrollmentJobsOutput`](crate::output::ListSpeakerEnrollmentJobsOutput) with field(s):
    ///   - [`job_summaries(Option<Vec<SpeakerEnrollmentJobSummary>>)`](crate::output::ListSpeakerEnrollmentJobsOutput::job_summaries): <p>A list containing details about each specified speaker enrollment job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSpeakerEnrollmentJobsOutput::next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On failure, responds with [`SdkError<ListSpeakerEnrollmentJobsError>`](crate::error::ListSpeakerEnrollmentJobsError)
    pub fn list_speaker_enrollment_jobs(
        &self,
    ) -> fluent_builders::ListSpeakerEnrollmentJobs<C, M, R> {
        fluent_builders::ListSpeakerEnrollmentJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSpeakers`](crate::client::fluent_builders::ListSpeakers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSpeakers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::ListSpeakers::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::ListSpeakers::set_domain_id): <p>The identifier of the domain.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSpeakers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSpeakers::set_max_results): <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSpeakers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSpeakers::set_next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On success, responds with [`ListSpeakersOutput`](crate::output::ListSpeakersOutput) with field(s):
    ///   - [`speaker_summaries(Option<Vec<SpeakerSummary>>)`](crate::output::ListSpeakersOutput::speaker_summaries): <p>A list containing details about each speaker in the Amazon Web Services account. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSpeakersOutput::next_token): <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
    /// - On failure, responds with [`SdkError<ListSpeakersError>`](crate::error::ListSpeakersError)
    pub fn list_speakers(&self) -> fluent_builders::ListSpeakers<C, M, R> {
        fluent_builders::ListSpeakers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Voice ID resource for which you want to list the tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tags associated with the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`OptOutSpeaker`](crate::client::fluent_builders::OptOutSpeaker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::OptOutSpeaker::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::OptOutSpeaker::set_domain_id): <p>The identifier of the domain containing the speaker.</p>
    ///   - [`speaker_id(impl Into<String>)`](crate::client::fluent_builders::OptOutSpeaker::speaker_id) / [`set_speaker_id(Option<String>)`](crate::client::fluent_builders::OptOutSpeaker::set_speaker_id): <p>The identifier of the speaker you want opted-out.</p>
    /// - On success, responds with [`OptOutSpeakerOutput`](crate::output::OptOutSpeakerOutput) with field(s):
    ///   - [`speaker(Option<Speaker>)`](crate::output::OptOutSpeakerOutput::speaker): <p>Details about the opted-out speaker.</p>
    /// - On failure, responds with [`SdkError<OptOutSpeakerError>`](crate::error::OptOutSpeakerError)
    pub fn opt_out_speaker(&self) -> fluent_builders::OptOutSpeaker<C, M, R> {
        fluent_builders::OptOutSpeaker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFraudsterRegistrationJob`](crate::client::fluent_builders::StartFraudsterRegistrationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_client_token): <p>The idempotency token for starting a new fraudster registration job. If not provided, Amazon Web Services SDK populates this field.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_job_name): <p>The name of the new fraudster registration job.</p>
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_domain_id): <p>The identifier of the domain containing the fraudster registration job and in which the fraudsters are registered.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_data_access_role_arn): <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the Job output file. Refer to the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html">Create and edit a fraudster watchlist</a> documentation for the permissions needed in this role.</p>
    ///   - [`registration_config(RegistrationConfig)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::registration_config) / [`set_registration_config(Option<RegistrationConfig>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_registration_config): <p>The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_input_data_config): <p>The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration requests.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartFraudsterRegistrationJob::set_output_data_config): <p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS Key ID to encrypt the file.</p>
    /// - On success, responds with [`StartFraudsterRegistrationJobOutput`](crate::output::StartFraudsterRegistrationJobOutput) with field(s):
    ///   - [`job(Option<FraudsterRegistrationJob>)`](crate::output::StartFraudsterRegistrationJobOutput::job): <p>Details about the started fraudster registration job.</p>
    /// - On failure, responds with [`SdkError<StartFraudsterRegistrationJobError>`](crate::error::StartFraudsterRegistrationJobError)
    pub fn start_fraudster_registration_job(
        &self,
    ) -> fluent_builders::StartFraudsterRegistrationJob<C, M, R> {
        fluent_builders::StartFraudsterRegistrationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSpeakerEnrollmentJob`](crate::client::fluent_builders::StartSpeakerEnrollmentJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_client_token): <p>The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK populates this field.</p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_job_name): <p>A name for your speaker enrollment job.</p>
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_domain_id): <p>The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled. </p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_data_access_role_arn): <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using audio data from prior calls</a> documentation for the permissions needed in this role.</p>
    ///   - [`enrollment_config(EnrollmentConfig)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::enrollment_config) / [`set_enrollment_config(Option<EnrollmentConfig>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_enrollment_config): <p>The enrollment config that contains details such as the action to take when a speaker is already enrolled in the Voice ID system or when a speaker is identified as a fraudster.</p>
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_input_data_config): <p>The input data config containing the S3 location for the input manifest file that contains the list of speaker enrollment requests.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartSpeakerEnrollmentJob::set_output_data_config): <p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS Key ID to encrypt the file.</p>
    /// - On success, responds with [`StartSpeakerEnrollmentJobOutput`](crate::output::StartSpeakerEnrollmentJobOutput) with field(s):
    ///   - [`job(Option<SpeakerEnrollmentJob>)`](crate::output::StartSpeakerEnrollmentJobOutput::job): <p>Details about the started speaker enrollment job.</p>
    /// - On failure, responds with [`SdkError<StartSpeakerEnrollmentJobError>`](crate::error::StartSpeakerEnrollmentJobError)
    pub fn start_speaker_enrollment_job(
        &self,
    ) -> fluent_builders::StartSpeakerEnrollmentJob<C, M, R> {
        fluent_builders::StartSpeakerEnrollmentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of tags to assign to the specified resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys you want to remove from the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomain`](crate::client::fluent_builders::UpdateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDomain::domain_id) / [`set_domain_id(Option<String>)`](crate::client::fluent_builders::UpdateDomain::set_domain_id): <p>The identifier of the domain to be updated.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomain::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDomain::set_name): <p>The name of the domain.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDomain::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDomain::set_description): <p>A brief description about this domain.</p>
    ///   - [`server_side_encryption_configuration(ServerSideEncryptionConfiguration)`](crate::client::fluent_builders::UpdateDomain::server_side_encryption_configuration) / [`set_server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::client::fluent_builders::UpdateDomain::set_server_side_encryption_configuration): <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side encryption of your data. Note that all the existing data in the domain are still encrypted using the existing key, only the data added to domain after updating the key is encrypted using the new key. </p>
    /// - On success, responds with [`UpdateDomainOutput`](crate::output::UpdateDomainOutput) with field(s):
    ///   - [`domain(Option<Domain>)`](crate::output::UpdateDomainOutput::domain): <p>Details about the updated domain</p>
    /// - On failure, responds with [`SdkError<UpdateDomainError>`](crate::error::UpdateDomainError)
    pub fn update_domain(&self) -> fluent_builders::UpdateDomain<C, M, R> {
        fluent_builders::UpdateDomain::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A brief description of this domain.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A brief description of this domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side encryption of your data. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid"> Amazon Connect VoiceID encryption at rest</a> for more details on how the KMS Key is used. </p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(input);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side encryption of your data. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid"> Amazon Connect VoiceID encryption at rest</a> for more details on how the KMS Key is used. </p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
        /// <p>The idempotency token for creating a new domain. If not provided, Amazon Web Services SDK populates this field.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for creating a new domain. If not provided, Amazon Web Services SDK populates this field.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags you want added to the domain.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags you want added to the domain.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Deletes the specified domain from the Amazon Connect Voice ID system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain you want to delete.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain you want to delete.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFraudster`.
    ///
    /// <p>Deletes the specified fraudster from the Amazon Connect Voice ID system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFraudster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fraudster_input::Builder,
    }
    impl<C, M, R> DeleteFraudster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFraudster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFraudsterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFraudsterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFraudsterInputOperationOutputAlias,
                crate::output::DeleteFraudsterOutput,
                crate::error::DeleteFraudsterError,
                crate::input::DeleteFraudsterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the fraudster you want to delete.</p>
        pub fn fraudster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fraudster_id(input.into());
            self
        }
        /// <p>The identifier of the fraudster you want to delete.</p>
        pub fn set_fraudster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fraudster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSpeaker`.
    ///
    /// <p>Deletes the specified speaker from the Amazon Connect Voice ID system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSpeaker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_speaker_input::Builder,
    }
    impl<C, M, R> DeleteSpeaker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSpeaker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSpeakerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSpeakerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSpeakerInputOperationOutputAlias,
                crate::output::DeleteSpeakerOutput,
                crate::error::DeleteSpeakerError,
                crate::input::DeleteSpeakerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker you want to delete.</p>
        pub fn speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.speaker_id(input.into());
            self
        }
        /// <p>The identifier of the speaker you want to delete.</p>
        pub fn set_speaker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_speaker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Describes the specified domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain you are describing.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain you are describing.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFraudster`.
    ///
    /// <p>Describes the specified fraudster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFraudster<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fraudster_input::Builder,
    }
    impl<C, M, R> DescribeFraudster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFraudster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFraudsterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFraudsterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFraudsterInputOperationOutputAlias,
                crate::output::DescribeFraudsterOutput,
                crate::error::DescribeFraudsterError,
                crate::input::DescribeFraudsterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the fraudster you are describing.</p>
        pub fn fraudster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fraudster_id(input.into());
            self
        }
        /// <p>The identifier of the fraudster you are describing.</p>
        pub fn set_fraudster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fraudster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFraudsterRegistrationJob`.
    ///
    /// <p>Describes the specified fraudster registration job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFraudsterRegistrationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fraudster_registration_job_input::Builder,
    }
    impl<C, M, R> DescribeFraudsterRegistrationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFraudsterRegistrationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFraudsterRegistrationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFraudsterRegistrationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFraudsterRegistrationJobInputOperationOutputAlias,
                crate::output::DescribeFraudsterRegistrationJobOutput,
                crate::error::DescribeFraudsterRegistrationJobError,
                crate::input::DescribeFraudsterRegistrationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the domain containing the fraudster registration job.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier for the domain containing the fraudster registration job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier for the fraudster registration job you are describing.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier for the fraudster registration job you are describing.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSpeaker`.
    ///
    /// <p>Describes the specified speaker.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSpeaker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_speaker_input::Builder,
    }
    impl<C, M, R> DescribeSpeaker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSpeaker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSpeakerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSpeakerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSpeakerInputOperationOutputAlias,
                crate::output::DescribeSpeakerOutput,
                crate::error::DescribeSpeakerError,
                crate::input::DescribeSpeakerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker you are describing.</p>
        pub fn speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.speaker_id(input.into());
            self
        }
        /// <p>The identifier of the speaker you are describing.</p>
        pub fn set_speaker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_speaker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSpeakerEnrollmentJob`.
    ///
    /// <p>Describes the specified speaker enrollment job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSpeakerEnrollmentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_speaker_enrollment_job_input::Builder,
    }
    impl<C, M, R> DescribeSpeakerEnrollmentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSpeakerEnrollmentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSpeakerEnrollmentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSpeakerEnrollmentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSpeakerEnrollmentJobInputOperationOutputAlias,
                crate::output::DescribeSpeakerEnrollmentJobOutput,
                crate::error::DescribeSpeakerEnrollmentJobError,
                crate::input::DescribeSpeakerEnrollmentJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker enrollment job.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the speaker enrollment job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker enrollment job you are describing.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier of the speaker enrollment job you are describing.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluateSession`.
    ///
    /// <p>Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EvaluateSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::evaluate_session_input::Builder,
    }
    impl<C, M, R> EvaluateSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EvaluateSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluateSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluateSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EvaluateSessionInputOperationOutputAlias,
                crate::output::EvaluateSessionOutput,
                crate::error::EvaluateSessionError,
                crate::input::EvaluateSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain where the session started.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain where the session started.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The session identifier, or name of the session, that you want to evaluate. In Voice ID integration, this is the Contact-Id.</p>
        pub fn session_name_or_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_name_or_id(input.into());
            self
        }
        /// <p>The session identifier, or name of the session, that you want to evaluate. In Voice ID integration, this is the Contact-Id.</p>
        pub fn set_session_name_or_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_name_or_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Lists all the domains in the Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsPaginator<C, M, R> {
            crate::paginator::ListDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFraudsterRegistrationJobs`.
    ///
    /// <p>Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>. If <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFraudsterRegistrationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fraudster_registration_jobs_input::Builder,
    }
    impl<C, M, R> ListFraudsterRegistrationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFraudsterRegistrationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFraudsterRegistrationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFraudsterRegistrationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFraudsterRegistrationJobsInputOperationOutputAlias,
                crate::output::ListFraudsterRegistrationJobsOutput,
                crate::error::ListFraudsterRegistrationJobsError,
                crate::input::ListFraudsterRegistrationJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFraudsterRegistrationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListFraudsterRegistrationJobsPaginator<C, M, R> {
            crate::paginator::ListFraudsterRegistrationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the domain containing the fraudster registration Jobs.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration Jobs.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>Provides the status of your fraudster registration job.</p>
        pub fn job_status(mut self, input: crate::model::FraudsterRegistrationJobStatus) -> Self {
            self.inner = self.inner.job_status(input);
            self
        }
        /// <p>Provides the status of your fraudster registration job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSpeakerEnrollmentJobs`.
    ///
    /// <p>Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job statuses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSpeakerEnrollmentJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_speaker_enrollment_jobs_input::Builder,
    }
    impl<C, M, R> ListSpeakerEnrollmentJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSpeakerEnrollmentJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSpeakerEnrollmentJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSpeakerEnrollmentJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSpeakerEnrollmentJobsInputOperationOutputAlias,
                crate::output::ListSpeakerEnrollmentJobsOutput,
                crate::error::ListSpeakerEnrollmentJobsError,
                crate::input::ListSpeakerEnrollmentJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSpeakerEnrollmentJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSpeakerEnrollmentJobsPaginator<C, M, R> {
            crate::paginator::ListSpeakerEnrollmentJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the domain containing the speaker enrollment jobs.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the speaker enrollment jobs.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>Provides the status of your speaker enrollment Job.</p>
        pub fn job_status(mut self, input: crate::model::SpeakerEnrollmentJobStatus) -> Self {
            self.inner = self.inner.job_status(input);
            self
        }
        /// <p>Provides the status of your speaker enrollment Job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSpeakers`.
    ///
    /// <p>Lists all speakers in a specified domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSpeakers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_speakers_input::Builder,
    }
    impl<C, M, R> ListSpeakers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSpeakers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSpeakersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSpeakersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSpeakersInputOperationOutputAlias,
                crate::output::ListSpeakersOutput,
                crate::error::ListSpeakersError,
                crate::input::ListSpeakersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSpeakersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSpeakersPaginator<C, M, R> {
            crate::paginator::ListSpeakersPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain further pages of results. The default is 100; the maximum allowed page size is also 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with a specified Voice ID resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource for which you want to list the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource for which you want to list the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `OptOutSpeaker`.
    ///
    /// <p>Opts out a speaker from Voice ID system. A speaker can be opted out regardless of whether or not they already exist in the system. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in the system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct OptOutSpeaker<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::opt_out_speaker_input::Builder,
    }
    impl<C, M, R> OptOutSpeaker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `OptOutSpeaker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::OptOutSpeakerOutput,
            aws_smithy_http::result::SdkError<crate::error::OptOutSpeakerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::OptOutSpeakerInputOperationOutputAlias,
                crate::output::OptOutSpeakerOutput,
                crate::error::OptOutSpeakerError,
                crate::input::OptOutSpeakerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker you want opted-out.</p>
        pub fn speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.speaker_id(input.into());
            self
        }
        /// <p>The identifier of the speaker you want opted-out.</p>
        pub fn set_speaker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_speaker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFraudsterRegistrationJob`.
    ///
    /// <p>Starts a new batch fraudster registration job using provided details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFraudsterRegistrationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fraudster_registration_job_input::Builder,
    }
    impl<C, M, R> StartFraudsterRegistrationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFraudsterRegistrationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFraudsterRegistrationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFraudsterRegistrationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFraudsterRegistrationJobInputOperationOutputAlias,
                crate::output::StartFraudsterRegistrationJobOutput,
                crate::error::StartFraudsterRegistrationJobError,
                crate::input::StartFraudsterRegistrationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for starting a new fraudster registration job. If not provided, Amazon Web Services SDK populates this field.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for starting a new fraudster registration job. If not provided, Amazon Web Services SDK populates this field.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the new fraudster registration job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The name of the new fraudster registration job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job and in which the fraudsters are registered.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job and in which the fraudsters are registered.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the Job output file. Refer to the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html">Create and edit a fraudster watchlist</a> documentation for the permissions needed in this role.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the Job output file. Refer to the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html">Create and edit a fraudster watchlist</a> documentation for the permissions needed in this role.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
        pub fn registration_config(mut self, input: crate::model::RegistrationConfig) -> Self {
            self.inner = self.inner.registration_config(input);
            self
        }
        /// <p>The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
        pub fn set_registration_config(
            mut self,
            input: std::option::Option<crate::model::RegistrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_registration_config(input);
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration requests.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration requests.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS Key ID to encrypt the file.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS Key ID to encrypt the file.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSpeakerEnrollmentJob`.
    ///
    /// <p>Starts a new batch speaker enrollment job using specified details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSpeakerEnrollmentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_speaker_enrollment_job_input::Builder,
    }
    impl<C, M, R> StartSpeakerEnrollmentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSpeakerEnrollmentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSpeakerEnrollmentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSpeakerEnrollmentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSpeakerEnrollmentJobInputOperationOutputAlias,
                crate::output::StartSpeakerEnrollmentJobOutput,
                crate::error::StartSpeakerEnrollmentJobError,
                crate::input::StartSpeakerEnrollmentJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK populates this field.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK populates this field.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A name for your speaker enrollment job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>A name for your speaker enrollment job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled. </p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled. </p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using audio data from prior calls</a> documentation for the permissions needed in this role.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using audio data from prior calls</a> documentation for the permissions needed in this role.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The enrollment config that contains details such as the action to take when a speaker is already enrolled in the Voice ID system or when a speaker is identified as a fraudster.</p>
        pub fn enrollment_config(mut self, input: crate::model::EnrollmentConfig) -> Self {
            self.inner = self.inner.enrollment_config(input);
            self
        }
        /// <p>The enrollment config that contains details such as the action to take when a speaker is already enrolled in the Voice ID system or when a speaker is identified as a fraudster.</p>
        pub fn set_enrollment_config(
            mut self,
            input: std::option::Option<crate::model::EnrollmentConfig>,
        ) -> Self {
            self.inner = self.inner.set_enrollment_config(input);
            self
        }
        /// <p>The input data config containing the S3 location for the input manifest file that contains the list of speaker enrollment requests.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>The input data config containing the S3 location for the input manifest file that contains the list of speaker enrollment requests.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS Key ID to encrypt the file.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS Key ID to encrypt the file.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags an Amazon Connect Voice ID resource with the provided list of tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to assign to the specified resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of tags to assign to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes specified tags from a specified Amazon Connect Voice ID resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys you want to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys you want to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomain`.
    ///
    /// <p>Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_input::Builder,
    }
    impl<C, M, R> UpdateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainInputOperationOutputAlias,
                crate::output::UpdateDomainOutput,
                crate::error::UpdateDomainError,
                crate::input::UpdateDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain to be updated.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The identifier of the domain to be updated.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A brief description about this domain.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A brief description about this domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side encryption of your data. Note that all the existing data in the domain are still encrypted using the existing key, only the data added to domain after updating the key is encrypted using the new key. </p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(input);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side encryption of your data. Note that all the existing data in the domain are still encrypted using the existing key, only the data added to domain after updating the key is encrypted using the new key. </p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
