// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Voice ID
///
/// Client for invoking operations on Amazon Voice ID. Each operation on Amazon Voice ID is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_voiceid::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_voiceid::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_voiceid::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateDomain` operation.
    ///
    /// See [`CreateDomain`](crate::client::fluent_builders::CreateDomain) for more information about the
    /// operation and its arguments.
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomain` operation.
    ///
    /// See [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFraudster` operation.
    ///
    /// See [`DeleteFraudster`](crate::client::fluent_builders::DeleteFraudster) for more information about the
    /// operation and its arguments.
    pub fn delete_fraudster(&self) -> fluent_builders::DeleteFraudster<C, M, R> {
        fluent_builders::DeleteFraudster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSpeaker` operation.
    ///
    /// See [`DeleteSpeaker`](crate::client::fluent_builders::DeleteSpeaker) for more information about the
    /// operation and its arguments.
    pub fn delete_speaker(&self) -> fluent_builders::DeleteSpeaker<C, M, R> {
        fluent_builders::DeleteSpeaker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomain` operation.
    ///
    /// See [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFraudster` operation.
    ///
    /// See [`DescribeFraudster`](crate::client::fluent_builders::DescribeFraudster) for more information about the
    /// operation and its arguments.
    pub fn describe_fraudster(&self) -> fluent_builders::DescribeFraudster<C, M, R> {
        fluent_builders::DescribeFraudster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFraudsterRegistrationJob` operation.
    ///
    /// See [`DescribeFraudsterRegistrationJob`](crate::client::fluent_builders::DescribeFraudsterRegistrationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_fraudster_registration_job(
        &self,
    ) -> fluent_builders::DescribeFraudsterRegistrationJob<C, M, R> {
        fluent_builders::DescribeFraudsterRegistrationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpeaker` operation.
    ///
    /// See [`DescribeSpeaker`](crate::client::fluent_builders::DescribeSpeaker) for more information about the
    /// operation and its arguments.
    pub fn describe_speaker(&self) -> fluent_builders::DescribeSpeaker<C, M, R> {
        fluent_builders::DescribeSpeaker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpeakerEnrollmentJob` operation.
    ///
    /// See [`DescribeSpeakerEnrollmentJob`](crate::client::fluent_builders::DescribeSpeakerEnrollmentJob) for more information about the
    /// operation and its arguments.
    pub fn describe_speaker_enrollment_job(
        &self,
    ) -> fluent_builders::DescribeSpeakerEnrollmentJob<C, M, R> {
        fluent_builders::DescribeSpeakerEnrollmentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EvaluateSession` operation.
    ///
    /// See [`EvaluateSession`](crate::client::fluent_builders::EvaluateSession) for more information about the
    /// operation and its arguments.
    pub fn evaluate_session(&self) -> fluent_builders::EvaluateSession<C, M, R> {
        fluent_builders::EvaluateSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFraudsterRegistrationJobs` operation.
    ///
    /// See [`ListFraudsterRegistrationJobs`](crate::client::fluent_builders::ListFraudsterRegistrationJobs) for more information about the
    /// operation and its arguments.
    pub fn list_fraudster_registration_jobs(
        &self,
    ) -> fluent_builders::ListFraudsterRegistrationJobs<C, M, R> {
        fluent_builders::ListFraudsterRegistrationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSpeakerEnrollmentJobs` operation.
    ///
    /// See [`ListSpeakerEnrollmentJobs`](crate::client::fluent_builders::ListSpeakerEnrollmentJobs) for more information about the
    /// operation and its arguments.
    pub fn list_speaker_enrollment_jobs(
        &self,
    ) -> fluent_builders::ListSpeakerEnrollmentJobs<C, M, R> {
        fluent_builders::ListSpeakerEnrollmentJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSpeakers` operation.
    ///
    /// See [`ListSpeakers`](crate::client::fluent_builders::ListSpeakers) for more information about the
    /// operation and its arguments.
    pub fn list_speakers(&self) -> fluent_builders::ListSpeakers<C, M, R> {
        fluent_builders::ListSpeakers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `OptOutSpeaker` operation.
    ///
    /// See [`OptOutSpeaker`](crate::client::fluent_builders::OptOutSpeaker) for more information about the
    /// operation and its arguments.
    pub fn opt_out_speaker(&self) -> fluent_builders::OptOutSpeaker<C, M, R> {
        fluent_builders::OptOutSpeaker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFraudsterRegistrationJob` operation.
    ///
    /// See [`StartFraudsterRegistrationJob`](crate::client::fluent_builders::StartFraudsterRegistrationJob) for more information about the
    /// operation and its arguments.
    pub fn start_fraudster_registration_job(
        &self,
    ) -> fluent_builders::StartFraudsterRegistrationJob<C, M, R> {
        fluent_builders::StartFraudsterRegistrationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSpeakerEnrollmentJob` operation.
    ///
    /// See [`StartSpeakerEnrollmentJob`](crate::client::fluent_builders::StartSpeakerEnrollmentJob) for more information about the
    /// operation and its arguments.
    pub fn start_speaker_enrollment_job(
        &self,
    ) -> fluent_builders::StartSpeakerEnrollmentJob<C, M, R> {
        fluent_builders::StartSpeakerEnrollmentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomain` operation.
    ///
    /// See [`UpdateDomain`](crate::client::fluent_builders::UpdateDomain) for more information about the
    /// operation and its arguments.
    pub fn update_domain(&self) -> fluent_builders::UpdateDomain<C, M, R> {
        fluent_builders::UpdateDomain::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer
    /// audio, and voiceprints.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A brief description of this domain.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A brief description of this domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for
        /// the server-side encryption of your data. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid">
        /// Amazon Connect VoiceID encryption at rest</a> for more details on how the KMS Key is used.
        /// </p>
        pub fn server_side_encryption_configuration(
            mut self,
            inp: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(inp);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for
        /// the server-side encryption of your data. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid">
        /// Amazon Connect VoiceID encryption at rest</a> for more details on how the KMS Key is used.
        /// </p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
        /// <p>The idempotency token for creating a new domain. If not provided, Amazon Web Services SDK populates
        /// this field.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for creating a new domain. If not provided, Amazon Web Services SDK populates
        /// this field.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags you want added to the domain.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags you want added to the domain.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Deletes the specified domain from the Amazon Connect Voice ID system.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain you want to delete.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain you want to delete.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFraudster`.
    ///
    /// <p>Deletes the specified fraudster from the Amazon Connect Voice ID system.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFraudster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fraudster_input::Builder,
    }
    impl<C, M, R> DeleteFraudster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFraudster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFraudsterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFraudsterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFraudsterInputOperationOutputAlias,
                crate::output::DeleteFraudsterOutput,
                crate::error::DeleteFraudsterError,
                crate::input::DeleteFraudsterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the fraudster you want to delete.</p>
        pub fn fraudster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fraudster_id(inp);
            self
        }
        /// <p>The identifier of the fraudster you want to delete.</p>
        pub fn set_fraudster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fraudster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSpeaker`.
    ///
    /// <p>Deletes the specified speaker from the Amazon Connect Voice ID system.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSpeaker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_speaker_input::Builder,
    }
    impl<C, M, R> DeleteSpeaker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSpeaker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSpeakerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSpeakerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSpeakerInputOperationOutputAlias,
                crate::output::DeleteSpeakerOutput,
                crate::error::DeleteSpeakerError,
                crate::input::DeleteSpeakerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker you want to delete.</p>
        pub fn speaker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.speaker_id(inp);
            self
        }
        /// <p>The identifier of the speaker you want to delete.</p>
        pub fn set_speaker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_speaker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>Describes the specified domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain you are describing.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain you are describing.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFraudster`.
    ///
    /// <p>Describes the specified fraudster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFraudster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fraudster_input::Builder,
    }
    impl<C, M, R> DescribeFraudster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFraudster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFraudsterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFraudsterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFraudsterInputOperationOutputAlias,
                crate::output::DescribeFraudsterOutput,
                crate::error::DescribeFraudsterError,
                crate::input::DescribeFraudsterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the fraudster.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the fraudster you are describing.</p>
        pub fn fraudster_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fraudster_id(inp);
            self
        }
        /// <p>The identifier of the fraudster you are describing.</p>
        pub fn set_fraudster_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fraudster_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFraudsterRegistrationJob`.
    ///
    /// <p>Describes the specified fraudster registration job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFraudsterRegistrationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fraudster_registration_job_input::Builder,
    }
    impl<C, M, R> DescribeFraudsterRegistrationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFraudsterRegistrationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFraudsterRegistrationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFraudsterRegistrationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFraudsterRegistrationJobInputOperationOutputAlias,
                crate::output::DescribeFraudsterRegistrationJobOutput,
                crate::error::DescribeFraudsterRegistrationJobError,
                crate::input::DescribeFraudsterRegistrationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the domain containing the fraudster registration job.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier for the domain containing the fraudster registration job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier for the fraudster registration job you are describing.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier for the fraudster registration job you are describing.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSpeaker`.
    ///
    /// <p>Describes the specified speaker.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSpeaker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_speaker_input::Builder,
    }
    impl<C, M, R> DescribeSpeaker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSpeaker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSpeakerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSpeakerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSpeakerInputOperationOutputAlias,
                crate::output::DescribeSpeakerOutput,
                crate::error::DescribeSpeakerError,
                crate::input::DescribeSpeakerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker you are describing.</p>
        pub fn speaker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.speaker_id(inp);
            self
        }
        /// <p>The identifier of the speaker you are describing.</p>
        pub fn set_speaker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_speaker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSpeakerEnrollmentJob`.
    ///
    /// <p>Describes the specified speaker enrollment job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSpeakerEnrollmentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_speaker_enrollment_job_input::Builder,
    }
    impl<C, M, R> DescribeSpeakerEnrollmentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSpeakerEnrollmentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSpeakerEnrollmentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSpeakerEnrollmentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSpeakerEnrollmentJobInputOperationOutputAlias,
                crate::output::DescribeSpeakerEnrollmentJobOutput,
                crate::error::DescribeSpeakerEnrollmentJobError,
                crate::input::DescribeSpeakerEnrollmentJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker enrollment job.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the speaker enrollment job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker enrollment job you are describing.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the speaker enrollment job you are describing.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluateSession`.
    ///
    /// <p>Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice
    /// ID call.</p>
    #[derive(std::fmt::Debug)]
    pub struct EvaluateSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::evaluate_session_input::Builder,
    }
    impl<C, M, R> EvaluateSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EvaluateSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluateSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluateSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EvaluateSessionInputOperationOutputAlias,
                crate::output::EvaluateSessionOutput,
                crate::error::EvaluateSessionError,
                crate::input::EvaluateSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain where the session started.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain where the session started.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The session identifier, or name of the session, that you want to evaluate. In Voice ID
        /// integration, this is the Contact-Id.</p>
        pub fn session_name_or_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_name_or_id(inp);
            self
        }
        /// <p>The session identifier, or name of the session, that you want to evaluate. In Voice ID
        /// integration, this is the Contact-Id.</p>
        pub fn set_session_name_or_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_name_or_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Lists all the domains in the Amazon Web Services account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFraudsterRegistrationJobs`.
    ///
    /// <p>Lists all the fraudster registration jobs in the domain with the given <code>JobStatus</code>.
    /// If <code>JobStatus</code> is not provided, this lists all fraudster registration jobs in the given
    /// domain.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFraudsterRegistrationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fraudster_registration_jobs_input::Builder,
    }
    impl<C, M, R> ListFraudsterRegistrationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFraudsterRegistrationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFraudsterRegistrationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFraudsterRegistrationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFraudsterRegistrationJobsInputOperationOutputAlias,
                crate::output::ListFraudsterRegistrationJobsOutput,
                crate::error::ListFraudsterRegistrationJobsError,
                crate::input::ListFraudsterRegistrationJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the fraudster registration Jobs.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration Jobs.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>Provides the status of your fraudster registration job.</p>
        pub fn job_status(mut self, inp: crate::model::FraudsterRegistrationJobStatus) -> Self {
            self.inner = self.inner.job_status(inp);
            self
        }
        /// <p>Provides the status of your fraudster registration job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSpeakerEnrollmentJobs`.
    ///
    /// <p>Lists all the speaker enrollment jobs in the domain with the specified <code>JobStatus</code>. If
    /// <code>JobStatus</code> is not provided, this lists all jobs with all possible speaker enrollment job
    /// statuses.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSpeakerEnrollmentJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_speaker_enrollment_jobs_input::Builder,
    }
    impl<C, M, R> ListSpeakerEnrollmentJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSpeakerEnrollmentJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSpeakerEnrollmentJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSpeakerEnrollmentJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSpeakerEnrollmentJobsInputOperationOutputAlias,
                crate::output::ListSpeakerEnrollmentJobsOutput,
                crate::error::ListSpeakerEnrollmentJobsError,
                crate::input::ListSpeakerEnrollmentJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker enrollment jobs.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the speaker enrollment jobs.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>Provides the status of your speaker enrollment Job.</p>
        pub fn job_status(mut self, inp: crate::model::SpeakerEnrollmentJobStatus) -> Self {
            self.inner = self.inner.job_status(inp);
            self
        }
        /// <p>Provides the status of your speaker enrollment Job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSpeakers`.
    ///
    /// <p>Lists all speakers in a specified domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSpeakers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_speakers_input::Builder,
    }
    impl<C, M, R> ListSpeakers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSpeakers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSpeakersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSpeakersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSpeakersInputOperationOutputAlias,
                crate::output::ListSpeakersOutput,
                crate::error::ListSpeakersError,
                crate::input::ListSpeakersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that are returned per call. You can use <code>NextToken</code> to obtain
        /// further pages of results. The default is 100; the maximum allowed page size is also 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with a specified Voice ID resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource for which you want to list the tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource for which you want to list the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `OptOutSpeaker`.
    ///
    /// <p>Opts out a speaker from Voice ID system. A speaker can be opted out regardless of whether or not they
    /// already exist in the system. If they don't yet exist, a new speaker is created in an opted out state.
    /// If they already exist, their existing status is overridden and they are opted out. Enrollment and
    /// evaluation authentication requests are rejected for opted out speakers, and opted out speakers have
    /// no voice embeddings stored in the system.</p>
    #[derive(std::fmt::Debug)]
    pub struct OptOutSpeaker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::opt_out_speaker_input::Builder,
    }
    impl<C, M, R> OptOutSpeaker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `OptOutSpeaker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::OptOutSpeakerOutput,
            aws_smithy_http::result::SdkError<crate::error::OptOutSpeakerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::OptOutSpeakerInputOperationOutputAlias,
                crate::output::OptOutSpeakerOutput,
                crate::error::OptOutSpeakerError,
                crate::input::OptOutSpeakerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The identifier of the speaker you want opted-out.</p>
        pub fn speaker_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.speaker_id(inp);
            self
        }
        /// <p>The identifier of the speaker you want opted-out.</p>
        pub fn set_speaker_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_speaker_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFraudsterRegistrationJob`.
    ///
    /// <p>Starts a new batch fraudster registration job using provided details.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartFraudsterRegistrationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fraudster_registration_job_input::Builder,
    }
    impl<C, M, R> StartFraudsterRegistrationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFraudsterRegistrationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFraudsterRegistrationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFraudsterRegistrationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFraudsterRegistrationJobInputOperationOutputAlias,
                crate::output::StartFraudsterRegistrationJobOutput,
                crate::error::StartFraudsterRegistrationJobError,
                crate::input::StartFraudsterRegistrationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for starting a new fraudster registration job. If not provided, Amazon Web Services
        /// SDK populates this field.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for starting a new fraudster registration job. If not provided, Amazon Web Services
        /// SDK populates this field.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the new fraudster registration job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the new fraudster registration job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job and in which the fraudsters are
        /// registered.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job and in which the fraudsters are
        /// registered.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the Job output file. Refer to the
        /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html">Create and
        /// edit a fraudster watchlist</a> documentation for the permissions needed in this role.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the Job output file. Refer to the
        /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html">Create and
        /// edit a fraudster watchlist</a> documentation for the permissions needed in this role.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The registration config containing details such as the action to take when a duplicate fraudster is
        /// detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
        pub fn registration_config(mut self, inp: crate::model::RegistrationConfig) -> Self {
            self.inner = self.inner.registration_config(inp);
            self
        }
        /// <p>The registration config containing details such as the action to take when a duplicate fraudster is
        /// detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
        pub fn set_registration_config(
            mut self,
            input: std::option::Option<crate::model::RegistrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_registration_config(input);
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
        /// of fraudster registration requests.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
        /// of fraudster registration requests.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
        /// also include a KMS Key ID to encrypt the file.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
        /// also include a KMS Key ID to encrypt the file.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSpeakerEnrollmentJob`.
    ///
    /// <p>Starts a new batch speaker enrollment job using specified details.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSpeakerEnrollmentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_speaker_enrollment_job_input::Builder,
    }
    impl<C, M, R> StartSpeakerEnrollmentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSpeakerEnrollmentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSpeakerEnrollmentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSpeakerEnrollmentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSpeakerEnrollmentJobInputOperationOutputAlias,
                crate::output::StartSpeakerEnrollmentJobOutput,
                crate::error::StartSpeakerEnrollmentJobError,
                crate::input::StartSpeakerEnrollmentJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services
        /// SDK populates this field.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services
        /// SDK populates this field.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A name for your speaker enrollment job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>A name for your speaker enrollment job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job and in which the speakers are
        /// enrolled.
        /// </p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job and in which the speakers are
        /// enrolled.
        /// </p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the job output file. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using audio data from prior
        /// calls</a> documentation for the permissions needed in this role.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the job output file. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html">Batch enrollment using audio data from prior
        /// calls</a> documentation for the permissions needed in this role.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The enrollment config that contains details such as the action to take when a speaker is already
        /// enrolled in the Voice ID system or when a speaker is identified as a fraudster.</p>
        pub fn enrollment_config(mut self, inp: crate::model::EnrollmentConfig) -> Self {
            self.inner = self.inner.enrollment_config(inp);
            self
        }
        /// <p>The enrollment config that contains details such as the action to take when a speaker is already
        /// enrolled in the Voice ID system or when a speaker is identified as a fraudster.</p>
        pub fn set_enrollment_config(
            mut self,
            input: std::option::Option<crate::model::EnrollmentConfig>,
        ) -> Self {
            self.inner = self.inner.set_enrollment_config(input);
            self
        }
        /// <p>The input data config containing the S3 location for the input manifest file that contains the list of
        /// speaker enrollment requests.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>The input data config containing the S3 location for the input manifest file that contains the list of
        /// speaker enrollment requests.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
        /// also include a KMS Key ID to encrypt the file.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
        /// also include a KMS Key ID to encrypt the file.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags an Amazon Connect Voice ID resource with the provided list of tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to assign to the specified resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags to assign to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes specified tags from a specified Amazon Connect Voice ID resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Voice ID resource you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys you want to remove from the specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tag keys you want to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomain`.
    ///
    /// <p>Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes.
    /// If an optional field, such as 'Description' is not provided, it is removed from the domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_input::Builder,
    }
    impl<C, M, R> UpdateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainInputOperationOutputAlias,
                crate::output::UpdateDomainOutput,
                crate::error::UpdateDomainError,
                crate::input::UpdateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the domain to be updated.</p>
        pub fn domain_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(inp);
            self
        }
        /// <p>The identifier of the domain to be updated.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A brief description about this domain.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A brief description about this domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side
        /// encryption of your data. Note that all the existing data in the domain are still encrypted using the
        /// existing key, only the data added to domain after updating the key is encrypted using the new key. </p>
        pub fn server_side_encryption_configuration(
            mut self,
            inp: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(inp);
            self
        }
        /// <p>The configuration, containing the KMS Key Identifier, to be used by Voice ID for the server-side
        /// encryption of your data. Note that all the existing data in the domain are still encrypted using the
        /// existing key, only the data added to domain after updating the key is encrypted using the new key. </p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
