// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainError {
    /// Kind of error that occurred.
    pub kind: CreateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeded the service quota. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas">Voice ID Service
    /// Quotas</a> and try your request again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainError {
    fn code(&self) -> Option<&str> {
        CreateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainError {
    /// Creates a new `CreateDomainError`.
    pub fn new(kind: CreateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDomainErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDomainErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDomainErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFraudster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFraudsterError {
    /// Kind of error that occurred.
    pub kind: DeleteFraudsterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFraudster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFraudsterErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFraudsterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFraudsterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFraudsterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFraudsterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFraudsterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFraudsterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFraudsterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFraudsterError {
    fn code(&self) -> Option<&str> {
        DeleteFraudsterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFraudsterError {
    /// Creates a new `DeleteFraudsterError`.
    pub fn new(kind: DeleteFraudsterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFraudsterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFraudsterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFraudsterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFraudsterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFraudsterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFraudsterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFraudsterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFraudsterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFraudsterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFraudsterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFraudsterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteFraudsterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteFraudsterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteFraudsterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteFraudsterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFraudsterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFraudsterErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFraudsterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFraudsterErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFraudsterErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFraudsterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSpeaker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSpeakerError {
    /// Kind of error that occurred.
    pub kind: DeleteSpeakerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSpeaker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSpeakerErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSpeakerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSpeakerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSpeakerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSpeakerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSpeakerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSpeakerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSpeakerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSpeakerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSpeakerError {
    fn code(&self) -> Option<&str> {
        DeleteSpeakerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSpeakerError {
    /// Creates a new `DeleteSpeakerError`.
    pub fn new(kind: DeleteSpeakerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSpeakerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSpeakerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSpeakerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSpeakerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSpeakerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteSpeakerErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteSpeakerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSpeakerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteSpeakerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSpeakerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSpeakerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSpeakerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSpeakerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteSpeakerErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteSpeakerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSpeakerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSpeakerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSpeakerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSpeakerErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSpeakerErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSpeakerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSpeakerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSpeakerErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSpeakerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainError {
    fn code(&self) -> Option<&str> {
        DescribeDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainError {
    /// Creates a new `DescribeDomainError`.
    pub fn new(kind: DescribeDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFraudster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFraudsterError {
    /// Kind of error that occurred.
    pub kind: DescribeFraudsterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFraudster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFraudsterErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFraudsterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFraudsterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeFraudsterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFraudsterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFraudsterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFraudsterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFraudsterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFraudsterError {
    fn code(&self) -> Option<&str> {
        DescribeFraudsterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFraudsterError {
    /// Creates a new `DescribeFraudsterError`.
    pub fn new(kind: DescribeFraudsterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFraudsterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFraudsterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFraudsterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFraudsterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFraudsterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFraudsterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFraudsterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeFraudsterErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFraudsterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFraudsterErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFraudsterErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFraudsterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFraudsterRegistrationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFraudsterRegistrationJobError {
    /// Kind of error that occurred.
    pub kind: DescribeFraudsterRegistrationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFraudsterRegistrationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFraudsterRegistrationJobErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFraudsterRegistrationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFraudsterRegistrationJobErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFraudsterRegistrationJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFraudsterRegistrationJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeFraudsterRegistrationJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFraudsterRegistrationJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFraudsterRegistrationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFraudsterRegistrationJobError {
    fn code(&self) -> Option<&str> {
        DescribeFraudsterRegistrationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFraudsterRegistrationJobError {
    /// Creates a new `DescribeFraudsterRegistrationJobError`.
    pub fn new(
        kind: DescribeFraudsterRegistrationJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFraudsterRegistrationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFraudsterRegistrationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFraudsterRegistrationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFraudsterRegistrationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFraudsterRegistrationJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterRegistrationJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterRegistrationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterRegistrationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterRegistrationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterRegistrationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterRegistrationJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterRegistrationJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFraudsterRegistrationJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFraudsterRegistrationJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFraudsterRegistrationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFraudsterRegistrationJobErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeFraudsterRegistrationJobErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeFraudsterRegistrationJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeFraudsterRegistrationJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFraudsterRegistrationJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFraudsterRegistrationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSpeaker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSpeakerError {
    /// Kind of error that occurred.
    pub kind: DescribeSpeakerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSpeaker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSpeakerErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSpeakerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSpeakerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeSpeakerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSpeakerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSpeakerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSpeakerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSpeakerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSpeakerError {
    fn code(&self) -> Option<&str> {
        DescribeSpeakerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSpeakerError {
    /// Creates a new `DescribeSpeakerError`.
    pub fn new(kind: DescribeSpeakerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSpeakerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSpeakerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSpeakerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSpeakerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSpeakerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeSpeakerErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeSpeakerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeSpeakerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeSpeakerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSpeakerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeSpeakerErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSpeakerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSpeakerErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSpeakerErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSpeakerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSpeakerEnrollmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSpeakerEnrollmentJobError {
    /// Kind of error that occurred.
    pub kind: DescribeSpeakerEnrollmentJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSpeakerEnrollmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSpeakerEnrollmentJobErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSpeakerEnrollmentJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSpeakerEnrollmentJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeSpeakerEnrollmentJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSpeakerEnrollmentJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSpeakerEnrollmentJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSpeakerEnrollmentJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSpeakerEnrollmentJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSpeakerEnrollmentJobError {
    fn code(&self) -> Option<&str> {
        DescribeSpeakerEnrollmentJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSpeakerEnrollmentJobError {
    /// Creates a new `DescribeSpeakerEnrollmentJobError`.
    pub fn new(kind: DescribeSpeakerEnrollmentJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSpeakerEnrollmentJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSpeakerEnrollmentJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSpeakerEnrollmentJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSpeakerEnrollmentJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSpeakerEnrollmentJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerEnrollmentJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerEnrollmentJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerEnrollmentJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerEnrollmentJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerEnrollmentJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerEnrollmentJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerEnrollmentJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSpeakerEnrollmentJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSpeakerEnrollmentJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSpeakerEnrollmentJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSpeakerEnrollmentJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeSpeakerEnrollmentJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSpeakerEnrollmentJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeSpeakerEnrollmentJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSpeakerEnrollmentJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSpeakerEnrollmentJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EvaluateSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EvaluateSessionError {
    /// Kind of error that occurred.
    pub kind: EvaluateSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EvaluateSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EvaluateSessionErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EvaluateSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EvaluateSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EvaluateSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            EvaluateSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EvaluateSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EvaluateSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EvaluateSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EvaluateSessionError {
    fn code(&self) -> Option<&str> {
        EvaluateSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EvaluateSessionError {
    /// Creates a new `EvaluateSessionError`.
    pub fn new(kind: EvaluateSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EvaluateSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EvaluateSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EvaluateSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EvaluateSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EvaluateSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluateSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluateSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluateSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluateSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluateSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluateSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, EvaluateSessionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `EvaluateSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, EvaluateSessionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for EvaluateSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EvaluateSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EvaluateSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            EvaluateSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EvaluateSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            EvaluateSessionErrorKind::ValidationException(_inner) => Some(_inner),
            EvaluateSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsError {
    /// Kind of error that occurred.
    pub kind: ListDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsError {
    fn code(&self) -> Option<&str> {
        ListDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsError {
    /// Creates a new `ListDomainsError`.
    pub fn new(kind: ListDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDomainsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDomainsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDomainsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFraudsterRegistrationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFraudsterRegistrationJobsError {
    /// Kind of error that occurred.
    pub kind: ListFraudsterRegistrationJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFraudsterRegistrationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFraudsterRegistrationJobsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFraudsterRegistrationJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFraudsterRegistrationJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFraudsterRegistrationJobsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListFraudsterRegistrationJobsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListFraudsterRegistrationJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFraudsterRegistrationJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFraudsterRegistrationJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFraudsterRegistrationJobsError {
    fn code(&self) -> Option<&str> {
        ListFraudsterRegistrationJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFraudsterRegistrationJobsError {
    /// Creates a new `ListFraudsterRegistrationJobsError`.
    pub fn new(
        kind: ListFraudsterRegistrationJobsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFraudsterRegistrationJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFraudsterRegistrationJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFraudsterRegistrationJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFraudsterRegistrationJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFraudsterRegistrationJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFraudsterRegistrationJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFraudsterRegistrationJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFraudsterRegistrationJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFraudsterRegistrationJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFraudsterRegistrationJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFraudsterRegistrationJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFraudsterRegistrationJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFraudsterRegistrationJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFraudsterRegistrationJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFraudsterRegistrationJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFraudsterRegistrationJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFraudsterRegistrationJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFraudsterRegistrationJobsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListFraudsterRegistrationJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFraudsterRegistrationJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFraudsterRegistrationJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSpeakerEnrollmentJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSpeakerEnrollmentJobsError {
    /// Kind of error that occurred.
    pub kind: ListSpeakerEnrollmentJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSpeakerEnrollmentJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSpeakerEnrollmentJobsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSpeakerEnrollmentJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSpeakerEnrollmentJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSpeakerEnrollmentJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSpeakerEnrollmentJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSpeakerEnrollmentJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSpeakerEnrollmentJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSpeakerEnrollmentJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSpeakerEnrollmentJobsError {
    fn code(&self) -> Option<&str> {
        ListSpeakerEnrollmentJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSpeakerEnrollmentJobsError {
    /// Creates a new `ListSpeakerEnrollmentJobsError`.
    pub fn new(kind: ListSpeakerEnrollmentJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSpeakerEnrollmentJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSpeakerEnrollmentJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSpeakerEnrollmentJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSpeakerEnrollmentJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSpeakerEnrollmentJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakerEnrollmentJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSpeakerEnrollmentJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakerEnrollmentJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSpeakerEnrollmentJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakerEnrollmentJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSpeakerEnrollmentJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakerEnrollmentJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSpeakerEnrollmentJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakerEnrollmentJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListSpeakerEnrollmentJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSpeakerEnrollmentJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSpeakerEnrollmentJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSpeakerEnrollmentJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSpeakerEnrollmentJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSpeakerEnrollmentJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListSpeakerEnrollmentJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSpeakers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSpeakersError {
    /// Kind of error that occurred.
    pub kind: ListSpeakersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSpeakers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSpeakersErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSpeakersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSpeakersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSpeakersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSpeakersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSpeakersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSpeakersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSpeakersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSpeakersError {
    fn code(&self) -> Option<&str> {
        ListSpeakersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSpeakersError {
    /// Creates a new `ListSpeakersError`.
    pub fn new(kind: ListSpeakersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSpeakersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSpeakersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSpeakersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSpeakersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSpeakersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListSpeakersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListSpeakersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSpeakersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSpeakersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSpeakersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListSpeakersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListSpeakersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListSpeakersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListSpeakersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSpeakersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSpeakersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSpeakersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSpeakersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSpeakersErrorKind::ValidationException(_inner) => Some(_inner),
            ListSpeakersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `OptOutSpeaker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct OptOutSpeakerError {
    /// Kind of error that occurred.
    pub kind: OptOutSpeakerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `OptOutSpeaker` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum OptOutSpeakerErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for OptOutSpeakerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            OptOutSpeakerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            OptOutSpeakerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            OptOutSpeakerErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            OptOutSpeakerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            OptOutSpeakerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            OptOutSpeakerErrorKind::ValidationException(_inner) => _inner.fmt(f),
            OptOutSpeakerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for OptOutSpeakerError {
    fn code(&self) -> Option<&str> {
        OptOutSpeakerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl OptOutSpeakerError {
    /// Creates a new `OptOutSpeakerError`.
    pub fn new(kind: OptOutSpeakerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `OptOutSpeakerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: OptOutSpeakerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `OptOutSpeakerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: OptOutSpeakerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `OptOutSpeakerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, OptOutSpeakerErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `OptOutSpeakerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, OptOutSpeakerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `OptOutSpeakerErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            OptOutSpeakerErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `OptOutSpeakerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            OptOutSpeakerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `OptOutSpeakerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, OptOutSpeakerErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `OptOutSpeakerErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, OptOutSpeakerErrorKind::ValidationException(_))
    }
}
impl std::error::Error for OptOutSpeakerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            OptOutSpeakerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            OptOutSpeakerErrorKind::ConflictException(_inner) => Some(_inner),
            OptOutSpeakerErrorKind::InternalServerException(_inner) => Some(_inner),
            OptOutSpeakerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            OptOutSpeakerErrorKind::ThrottlingException(_inner) => Some(_inner),
            OptOutSpeakerErrorKind::ValidationException(_inner) => Some(_inner),
            OptOutSpeakerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFraudsterRegistrationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFraudsterRegistrationJobError {
    /// Kind of error that occurred.
    pub kind: StartFraudsterRegistrationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFraudsterRegistrationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFraudsterRegistrationJobErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeded the service quota. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas">Voice ID Service
    /// Quotas</a> and try your request again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFraudsterRegistrationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFraudsterRegistrationJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartFraudsterRegistrationJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartFraudsterRegistrationJobErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StartFraudsterRegistrationJobErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartFraudsterRegistrationJobErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartFraudsterRegistrationJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartFraudsterRegistrationJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartFraudsterRegistrationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFraudsterRegistrationJobError {
    fn code(&self) -> Option<&str> {
        StartFraudsterRegistrationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFraudsterRegistrationJobError {
    /// Creates a new `StartFraudsterRegistrationJobError`.
    pub fn new(
        kind: StartFraudsterRegistrationJobErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFraudsterRegistrationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFraudsterRegistrationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFraudsterRegistrationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFraudsterRegistrationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFraudsterRegistrationJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFraudsterRegistrationJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartFraudsterRegistrationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFraudsterRegistrationJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartFraudsterRegistrationJobErrorKind::ConflictException(_inner) => Some(_inner),
            StartFraudsterRegistrationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartFraudsterRegistrationJobErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartFraudsterRegistrationJobErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            StartFraudsterRegistrationJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartFraudsterRegistrationJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartFraudsterRegistrationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSpeakerEnrollmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSpeakerEnrollmentJobError {
    /// Kind of error that occurred.
    pub kind: StartSpeakerEnrollmentJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSpeakerEnrollmentJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSpeakerEnrollmentJobErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeded the service quota. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas">Voice ID Service
    /// Quotas</a> and try your request again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSpeakerEnrollmentJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSpeakerEnrollmentJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartSpeakerEnrollmentJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartSpeakerEnrollmentJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartSpeakerEnrollmentJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartSpeakerEnrollmentJobErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartSpeakerEnrollmentJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartSpeakerEnrollmentJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartSpeakerEnrollmentJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSpeakerEnrollmentJobError {
    fn code(&self) -> Option<&str> {
        StartSpeakerEnrollmentJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSpeakerEnrollmentJobError {
    /// Creates a new `StartSpeakerEnrollmentJobError`.
    pub fn new(kind: StartSpeakerEnrollmentJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSpeakerEnrollmentJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSpeakerEnrollmentJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSpeakerEnrollmentJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSpeakerEnrollmentJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSpeakerEnrollmentJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSpeakerEnrollmentJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartSpeakerEnrollmentJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSpeakerEnrollmentJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartSpeakerEnrollmentJobErrorKind::ConflictException(_inner) => Some(_inner),
            StartSpeakerEnrollmentJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartSpeakerEnrollmentJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartSpeakerEnrollmentJobErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            StartSpeakerEnrollmentJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartSpeakerEnrollmentJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartSpeakerEnrollmentJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. Check the error message and try
    /// again.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
    /// more details.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request failed due to an unknown error on the server side.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
    /// more details.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
    /// Amazon Connect Voice ID Service API throttling quotas
    /// </a> and try your request again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request failed one or more validations; check the error message for more details.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainError {
    fn code(&self) -> Option<&str> {
        UpdateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainError {
    /// Creates a new `UpdateDomainError`.
    pub fn new(kind: UpdateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateDomainErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDomainErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDomainErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request failed one or more validations; check the error message for more details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to request throttling. Please slow down your request rate. Refer to
/// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html##voiceid-api-quotas">
/// Amazon Connect Voice ID Service API throttling quotas
/// </a> and try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The specified resource cannot be found. Check the <code>ResourceType</code> and error message for
/// more details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of resource which cannot not be found. Possible types are <code>BATCH_JOB</code>, <code>COMPLIANCE_CONSENT</code>,
    /// <code>DOMAIN</code>, <code>FRAUDSTER</code>, <code>SESSION</code> and <code>SPEAKER</code>.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ResourceNotFoundException {
    /// <p>The type of resource which cannot not be found. Possible types are <code>BATCH_JOB</code>, <code>COMPLIANCE_CONSENT</code>,
    /// <code>DOMAIN</code>, <code>FRAUDSTER</code>, <code>SESSION</code> and <code>SPEAKER</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of resource which cannot not be found. Possible types are <code>BATCH_JOB</code>, <code>COMPLIANCE_CONSENT</code>,
        /// <code>DOMAIN</code>, <code>FRAUDSTER</code>, <code>SESSION</code> and <code>SPEAKER</code>.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource which cannot not be found. Possible types are <code>BATCH_JOB</code>, <code>COMPLIANCE_CONSENT</code>,
        /// <code>DOMAIN</code>, <code>FRAUDSTER</code>, <code>SESSION</code> and <code>SPEAKER</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request failed due to an unknown error on the server side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request failed due to a conflict. Check the <code>ConflictType</code> and error message for
/// more details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of conflict which caused a ConflictException. Possible types and the corresponding error messages
    /// are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has been requested.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another request during execution.</p>
    /// </li>
    /// </ul>
    pub conflict_type: std::option::Option<crate::model::ConflictType>,
}
impl ConflictException {
    /// <p>The type of conflict which caused a ConflictException. Possible types and the corresponding error messages
    /// are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has been requested.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another request during execution.</p>
    /// </li>
    /// </ul>
    pub fn conflict_type(&self) -> std::option::Option<&crate::model::ConflictType> {
        self.conflict_type.as_ref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("conflict_type", &self.conflict_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) conflict_type: std::option::Option<crate::model::ConflictType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of conflict which caused a ConflictException. Possible types and the corresponding error messages
        /// are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has been requested.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another request during execution.</p>
        /// </li>
        /// </ul>
        pub fn conflict_type(mut self, input: crate::model::ConflictType) -> Self {
            self.conflict_type = Some(input);
            self
        }
        /// <p>The type of conflict which caused a ConflictException. Possible types and the corresponding error messages
        /// are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DOMAIN_NOT_ACTIVE</code>: The domain is not active.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT</code>: You cannot change the speaker ID after an enrollment has been requested.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENROLLMENT_ALREADY_EXISTS</code>: There is already an enrollment for this session.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPEAKER_NOT_SET</code>: You must set the speaker ID before requesting an enrollment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPEAKER_OPTED_OUT</code>: You cannot request an enrollment for an opted out speaker.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONCURRENT_CHANGES</code>: The request could not be processed as the resource was modified by another request during execution.</p>
        /// </li>
        /// </ul>
        pub fn set_conflict_type(
            mut self,
            input: std::option::Option<crate::model::ConflictType>,
        ) -> Self {
            self.conflict_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                conflict_type: self.conflict_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have sufficient permissions to perform this action. Check the error message and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request exceeded the service quota. Refer to <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#voiceid-quotas">Voice ID Service
/// Quotas</a> and try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
