// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainOutput {
    /// <p>Details about the updated domain</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl std::fmt::Debug for UpdateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainOutput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
pub mod update_domain_output {
    /// A builder for [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>Details about the updated domain</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>Details about the updated domain</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
        pub fn build(self) -> crate::output::UpdateDomainOutput {
            crate::output::UpdateDomainOutput {
                domain: self.domain,
            }
        }
    }
}
impl UpdateDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
    pub fn builder() -> crate::output::update_domain_output::Builder {
        crate::output::update_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSpeakerEnrollmentJobOutput {
    /// <p>Details about the started speaker enrollment job.</p>
    pub job: std::option::Option<crate::model::SpeakerEnrollmentJob>,
}
impl std::fmt::Debug for StartSpeakerEnrollmentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSpeakerEnrollmentJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StartSpeakerEnrollmentJobOutput`](crate::output::StartSpeakerEnrollmentJobOutput)
pub mod start_speaker_enrollment_job_output {
    /// A builder for [`StartSpeakerEnrollmentJobOutput`](crate::output::StartSpeakerEnrollmentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::SpeakerEnrollmentJob>,
    }
    impl Builder {
        /// <p>Details about the started speaker enrollment job.</p>
        pub fn job(mut self, input: crate::model::SpeakerEnrollmentJob) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Details about the started speaker enrollment job.</p>
        pub fn set_job(
            mut self,
            input: std::option::Option<crate::model::SpeakerEnrollmentJob>,
        ) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSpeakerEnrollmentJobOutput`](crate::output::StartSpeakerEnrollmentJobOutput)
        pub fn build(self) -> crate::output::StartSpeakerEnrollmentJobOutput {
            crate::output::StartSpeakerEnrollmentJobOutput { job: self.job }
        }
    }
}
impl StartSpeakerEnrollmentJobOutput {
    /// Creates a new builder-style object to manufacture [`StartSpeakerEnrollmentJobOutput`](crate::output::StartSpeakerEnrollmentJobOutput)
    pub fn builder() -> crate::output::start_speaker_enrollment_job_output::Builder {
        crate::output::start_speaker_enrollment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFraudsterRegistrationJobOutput {
    /// <p>Details about the started fraudster registration job.</p>
    pub job: std::option::Option<crate::model::FraudsterRegistrationJob>,
}
impl std::fmt::Debug for StartFraudsterRegistrationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFraudsterRegistrationJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`StartFraudsterRegistrationJobOutput`](crate::output::StartFraudsterRegistrationJobOutput)
pub mod start_fraudster_registration_job_output {
    /// A builder for [`StartFraudsterRegistrationJobOutput`](crate::output::StartFraudsterRegistrationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::FraudsterRegistrationJob>,
    }
    impl Builder {
        /// <p>Details about the started fraudster registration job.</p>
        pub fn job(mut self, input: crate::model::FraudsterRegistrationJob) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Details about the started fraudster registration job.</p>
        pub fn set_job(
            mut self,
            input: std::option::Option<crate::model::FraudsterRegistrationJob>,
        ) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFraudsterRegistrationJobOutput`](crate::output::StartFraudsterRegistrationJobOutput)
        pub fn build(self) -> crate::output::StartFraudsterRegistrationJobOutput {
            crate::output::StartFraudsterRegistrationJobOutput { job: self.job }
        }
    }
}
impl StartFraudsterRegistrationJobOutput {
    /// Creates a new builder-style object to manufacture [`StartFraudsterRegistrationJobOutput`](crate::output::StartFraudsterRegistrationJobOutput)
    pub fn builder() -> crate::output::start_fraudster_registration_job_output::Builder {
        crate::output::start_fraudster_registration_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptOutSpeakerOutput {
    /// <p>Details about the opted-out speaker.</p>
    pub speaker: std::option::Option<crate::model::Speaker>,
}
impl std::fmt::Debug for OptOutSpeakerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptOutSpeakerOutput");
        formatter.field("speaker", &self.speaker);
        formatter.finish()
    }
}
/// See [`OptOutSpeakerOutput`](crate::output::OptOutSpeakerOutput)
pub mod opt_out_speaker_output {
    /// A builder for [`OptOutSpeakerOutput`](crate::output::OptOutSpeakerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speaker: std::option::Option<crate::model::Speaker>,
    }
    impl Builder {
        /// <p>Details about the opted-out speaker.</p>
        pub fn speaker(mut self, input: crate::model::Speaker) -> Self {
            self.speaker = Some(input);
            self
        }
        /// <p>Details about the opted-out speaker.</p>
        pub fn set_speaker(mut self, input: std::option::Option<crate::model::Speaker>) -> Self {
            self.speaker = input;
            self
        }
        /// Consumes the builder and constructs a [`OptOutSpeakerOutput`](crate::output::OptOutSpeakerOutput)
        pub fn build(self) -> crate::output::OptOutSpeakerOutput {
            crate::output::OptOutSpeakerOutput {
                speaker: self.speaker,
            }
        }
    }
}
impl OptOutSpeakerOutput {
    /// Creates a new builder-style object to manufacture [`OptOutSpeakerOutput`](crate::output::OptOutSpeakerOutput)
    pub fn builder() -> crate::output::opt_out_speaker_output::Builder {
        crate::output::opt_out_speaker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of tags associated with the specified resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags associated with the specified resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags associated with the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSpeakersOutput {
    /// <p>A list containing details about each speaker in the Amazon Web Services account.
    /// </p>
    pub speaker_summaries: std::option::Option<std::vec::Vec<crate::model::SpeakerSummary>>,
    /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
    /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
    /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSpeakersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSpeakersOutput");
        formatter.field("speaker_summaries", &self.speaker_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSpeakersOutput`](crate::output::ListSpeakersOutput)
pub mod list_speakers_output {
    /// A builder for [`ListSpeakersOutput`](crate::output::ListSpeakersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speaker_summaries:
            std::option::Option<std::vec::Vec<crate::model::SpeakerSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `speaker_summaries`.
        ///
        /// To override the contents of this collection use [`set_speaker_summaries`](Self::set_speaker_summaries).
        ///
        /// <p>A list containing details about each speaker in the Amazon Web Services account.
        /// </p>
        pub fn speaker_summaries(mut self, input: impl Into<crate::model::SpeakerSummary>) -> Self {
            let mut v = self.speaker_summaries.unwrap_or_default();
            v.push(input.into());
            self.speaker_summaries = Some(v);
            self
        }
        /// <p>A list containing details about each speaker in the Amazon Web Services account.
        /// </p>
        pub fn set_speaker_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeakerSummary>>,
        ) -> Self {
            self.speaker_summaries = input;
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSpeakersOutput`](crate::output::ListSpeakersOutput)
        pub fn build(self) -> crate::output::ListSpeakersOutput {
            crate::output::ListSpeakersOutput {
                speaker_summaries: self.speaker_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSpeakersOutput {
    /// Creates a new builder-style object to manufacture [`ListSpeakersOutput`](crate::output::ListSpeakersOutput)
    pub fn builder() -> crate::output::list_speakers_output::Builder {
        crate::output::list_speakers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSpeakerEnrollmentJobsOutput {
    /// <p>A list containing details about each specified speaker enrollment job.</p>
    pub job_summaries:
        std::option::Option<std::vec::Vec<crate::model::SpeakerEnrollmentJobSummary>>,
    /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
    /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
    /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSpeakerEnrollmentJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSpeakerEnrollmentJobsOutput");
        formatter.field("job_summaries", &self.job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSpeakerEnrollmentJobsOutput`](crate::output::ListSpeakerEnrollmentJobsOutput)
pub mod list_speaker_enrollment_jobs_output {
    /// A builder for [`ListSpeakerEnrollmentJobsOutput`](crate::output::ListSpeakerEnrollmentJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summaries:
            std::option::Option<std::vec::Vec<crate::model::SpeakerEnrollmentJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_summaries`](Self::set_job_summaries).
        ///
        /// <p>A list containing details about each specified speaker enrollment job.</p>
        pub fn job_summaries(
            mut self,
            input: impl Into<crate::model::SpeakerEnrollmentJobSummary>,
        ) -> Self {
            let mut v = self.job_summaries.unwrap_or_default();
            v.push(input.into());
            self.job_summaries = Some(v);
            self
        }
        /// <p>A list containing details about each specified speaker enrollment job.</p>
        pub fn set_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SpeakerEnrollmentJobSummary>>,
        ) -> Self {
            self.job_summaries = input;
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSpeakerEnrollmentJobsOutput`](crate::output::ListSpeakerEnrollmentJobsOutput)
        pub fn build(self) -> crate::output::ListSpeakerEnrollmentJobsOutput {
            crate::output::ListSpeakerEnrollmentJobsOutput {
                job_summaries: self.job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSpeakerEnrollmentJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListSpeakerEnrollmentJobsOutput`](crate::output::ListSpeakerEnrollmentJobsOutput)
    pub fn builder() -> crate::output::list_speaker_enrollment_jobs_output::Builder {
        crate::output::list_speaker_enrollment_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFraudsterRegistrationJobsOutput {
    /// <p>A list containing details about each specified fraudster registration job.</p>
    pub job_summaries:
        std::option::Option<std::vec::Vec<crate::model::FraudsterRegistrationJobSummary>>,
    /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
    /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
    /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListFraudsterRegistrationJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFraudsterRegistrationJobsOutput");
        formatter.field("job_summaries", &self.job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFraudsterRegistrationJobsOutput`](crate::output::ListFraudsterRegistrationJobsOutput)
pub mod list_fraudster_registration_jobs_output {
    /// A builder for [`ListFraudsterRegistrationJobsOutput`](crate::output::ListFraudsterRegistrationJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_summaries:
            std::option::Option<std::vec::Vec<crate::model::FraudsterRegistrationJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_summaries`](Self::set_job_summaries).
        ///
        /// <p>A list containing details about each specified fraudster registration job.</p>
        pub fn job_summaries(
            mut self,
            input: impl Into<crate::model::FraudsterRegistrationJobSummary>,
        ) -> Self {
            let mut v = self.job_summaries.unwrap_or_default();
            v.push(input.into());
            self.job_summaries = Some(v);
            self
        }
        /// <p>A list containing details about each specified fraudster registration job.</p>
        pub fn set_job_summaries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::FraudsterRegistrationJobSummary>,
            >,
        ) -> Self {
            self.job_summaries = input;
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFraudsterRegistrationJobsOutput`](crate::output::ListFraudsterRegistrationJobsOutput)
        pub fn build(self) -> crate::output::ListFraudsterRegistrationJobsOutput {
            crate::output::ListFraudsterRegistrationJobsOutput {
                job_summaries: self.job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFraudsterRegistrationJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListFraudsterRegistrationJobsOutput`](crate::output::ListFraudsterRegistrationJobsOutput)
    pub fn builder() -> crate::output::list_fraudster_registration_jobs_output::Builder {
        crate::output::list_fraudster_registration_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsOutput {
    /// <p>A list containing details about each domain in the Amazon Web Services account.</p>
    pub domain_summaries: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
    /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
    /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
    /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsOutput");
        formatter.field("domain_summaries", &self.domain_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainsOutput`](crate::output::ListDomainsOutput)
pub mod list_domains_output {
    /// A builder for [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_summaries:
            std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domain_summaries`.
        ///
        /// To override the contents of this collection use [`set_domain_summaries`](Self::set_domain_summaries).
        ///
        /// <p>A list containing details about each domain in the Amazon Web Services account.</p>
        pub fn domain_summaries(mut self, input: impl Into<crate::model::DomainSummary>) -> Self {
            let mut v = self.domain_summaries.unwrap_or_default();
            v.push(input.into());
            self.domain_summaries = Some(v);
            self
        }
        /// <p>A list containing details about each domain in the Amazon Web Services account.</p>
        pub fn set_domain_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
        ) -> Self {
            self.domain_summaries = input;
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
        /// is a unique pagination token for each page. Make the call again using the returned token to retrieve the
        /// next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsOutput`](crate::output::ListDomainsOutput)
        pub fn build(self) -> crate::output::ListDomainsOutput {
            crate::output::ListDomainsOutput {
                domain_summaries: self.domain_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    pub fn builder() -> crate::output::list_domains_output::Builder {
        crate::output::list_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluateSessionOutput {
    /// <p>The identifier of the domain containing the session.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier of the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The client-provided name of the session.</p>
    pub session_name: std::option::Option<std::string::String>,
    /// <p>The current status of audio streaming for this session. This field is useful to infer next steps when
    /// the Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>.
    /// In this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
    /// mean that the client should call the API again later, once Voice ID has enough audio to produce a result.
    /// If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>,
    /// it means that the previously streamed session did not have enough speech to perform evaluation, and a new
    /// streaming session is needed to try again.</p>
    pub streaming_status: std::option::Option<crate::model::StreamingStatus>,
    /// <p>Details resulting from the authentication process, such as authentication decision and
    /// authentication score.</p>
    pub authentication_result: std::option::Option<crate::model::AuthenticationResult>,
    /// <p>Details resulting from the fraud detection process, such as fraud detection decision and risk score.</p>
    pub fraud_detection_result: std::option::Option<crate::model::FraudDetectionResult>,
}
impl std::fmt::Debug for EvaluateSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluateSessionOutput");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("session_id", &self.session_id);
        formatter.field("session_name", &self.session_name);
        formatter.field("streaming_status", &self.streaming_status);
        formatter.field("authentication_result", &self.authentication_result);
        formatter.field("fraud_detection_result", &self.fraud_detection_result);
        formatter.finish()
    }
}
/// See [`EvaluateSessionOutput`](crate::output::EvaluateSessionOutput)
pub mod evaluate_session_output {
    /// A builder for [`EvaluateSessionOutput`](crate::output::EvaluateSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) session_name: std::option::Option<std::string::String>,
        pub(crate) streaming_status: std::option::Option<crate::model::StreamingStatus>,
        pub(crate) authentication_result: std::option::Option<crate::model::AuthenticationResult>,
        pub(crate) fraud_detection_result: std::option::Option<crate::model::FraudDetectionResult>,
    }
    impl Builder {
        /// <p>The identifier of the domain containing the session.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain containing the session.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The service-generated identifier of the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier of the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The client-provided name of the session.</p>
        pub fn session_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_name = Some(input.into());
            self
        }
        /// <p>The client-provided name of the session.</p>
        pub fn set_session_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_name = input;
            self
        }
        /// <p>The current status of audio streaming for this session. This field is useful to infer next steps when
        /// the Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>.
        /// In this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
        /// mean that the client should call the API again later, once Voice ID has enough audio to produce a result.
        /// If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>,
        /// it means that the previously streamed session did not have enough speech to perform evaluation, and a new
        /// streaming session is needed to try again.</p>
        pub fn streaming_status(mut self, input: crate::model::StreamingStatus) -> Self {
            self.streaming_status = Some(input);
            self
        }
        /// <p>The current status of audio streaming for this session. This field is useful to infer next steps when
        /// the Authentication or Fraud Detection results are empty or the decision is <code>NOT_ENOUGH_SPEECH</code>.
        /// In this situation, if the <code>StreamingStatus</code> is <code>ONGOING/PENDING_CONFIGURATION</code>, it can
        /// mean that the client should call the API again later, once Voice ID has enough audio to produce a result.
        /// If the decision remains <code>NOT_ENOUGH_SPEECH</code> even after <code>StreamingStatus</code> is <code>ENDED</code>,
        /// it means that the previously streamed session did not have enough speech to perform evaluation, and a new
        /// streaming session is needed to try again.</p>
        pub fn set_streaming_status(
            mut self,
            input: std::option::Option<crate::model::StreamingStatus>,
        ) -> Self {
            self.streaming_status = input;
            self
        }
        /// <p>Details resulting from the authentication process, such as authentication decision and
        /// authentication score.</p>
        pub fn authentication_result(mut self, input: crate::model::AuthenticationResult) -> Self {
            self.authentication_result = Some(input);
            self
        }
        /// <p>Details resulting from the authentication process, such as authentication decision and
        /// authentication score.</p>
        pub fn set_authentication_result(
            mut self,
            input: std::option::Option<crate::model::AuthenticationResult>,
        ) -> Self {
            self.authentication_result = input;
            self
        }
        /// <p>Details resulting from the fraud detection process, such as fraud detection decision and risk score.</p>
        pub fn fraud_detection_result(mut self, input: crate::model::FraudDetectionResult) -> Self {
            self.fraud_detection_result = Some(input);
            self
        }
        /// <p>Details resulting from the fraud detection process, such as fraud detection decision and risk score.</p>
        pub fn set_fraud_detection_result(
            mut self,
            input: std::option::Option<crate::model::FraudDetectionResult>,
        ) -> Self {
            self.fraud_detection_result = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluateSessionOutput`](crate::output::EvaluateSessionOutput)
        pub fn build(self) -> crate::output::EvaluateSessionOutput {
            crate::output::EvaluateSessionOutput {
                domain_id: self.domain_id,
                session_id: self.session_id,
                session_name: self.session_name,
                streaming_status: self.streaming_status,
                authentication_result: self.authentication_result,
                fraud_detection_result: self.fraud_detection_result,
            }
        }
    }
}
impl EvaluateSessionOutput {
    /// Creates a new builder-style object to manufacture [`EvaluateSessionOutput`](crate::output::EvaluateSessionOutput)
    pub fn builder() -> crate::output::evaluate_session_output::Builder {
        crate::output::evaluate_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSpeakerEnrollmentJobOutput {
    /// <p>Contains details about the specified speaker enrollment job.</p>
    pub job: std::option::Option<crate::model::SpeakerEnrollmentJob>,
}
impl std::fmt::Debug for DescribeSpeakerEnrollmentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSpeakerEnrollmentJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`DescribeSpeakerEnrollmentJobOutput`](crate::output::DescribeSpeakerEnrollmentJobOutput)
pub mod describe_speaker_enrollment_job_output {
    /// A builder for [`DescribeSpeakerEnrollmentJobOutput`](crate::output::DescribeSpeakerEnrollmentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::SpeakerEnrollmentJob>,
    }
    impl Builder {
        /// <p>Contains details about the specified speaker enrollment job.</p>
        pub fn job(mut self, input: crate::model::SpeakerEnrollmentJob) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Contains details about the specified speaker enrollment job.</p>
        pub fn set_job(
            mut self,
            input: std::option::Option<crate::model::SpeakerEnrollmentJob>,
        ) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSpeakerEnrollmentJobOutput`](crate::output::DescribeSpeakerEnrollmentJobOutput)
        pub fn build(self) -> crate::output::DescribeSpeakerEnrollmentJobOutput {
            crate::output::DescribeSpeakerEnrollmentJobOutput { job: self.job }
        }
    }
}
impl DescribeSpeakerEnrollmentJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSpeakerEnrollmentJobOutput`](crate::output::DescribeSpeakerEnrollmentJobOutput)
    pub fn builder() -> crate::output::describe_speaker_enrollment_job_output::Builder {
        crate::output::describe_speaker_enrollment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSpeakerOutput {
    /// <p>Information about the specified speaker.</p>
    pub speaker: std::option::Option<crate::model::Speaker>,
}
impl std::fmt::Debug for DescribeSpeakerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSpeakerOutput");
        formatter.field("speaker", &self.speaker);
        formatter.finish()
    }
}
/// See [`DescribeSpeakerOutput`](crate::output::DescribeSpeakerOutput)
pub mod describe_speaker_output {
    /// A builder for [`DescribeSpeakerOutput`](crate::output::DescribeSpeakerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) speaker: std::option::Option<crate::model::Speaker>,
    }
    impl Builder {
        /// <p>Information about the specified speaker.</p>
        pub fn speaker(mut self, input: crate::model::Speaker) -> Self {
            self.speaker = Some(input);
            self
        }
        /// <p>Information about the specified speaker.</p>
        pub fn set_speaker(mut self, input: std::option::Option<crate::model::Speaker>) -> Self {
            self.speaker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSpeakerOutput`](crate::output::DescribeSpeakerOutput)
        pub fn build(self) -> crate::output::DescribeSpeakerOutput {
            crate::output::DescribeSpeakerOutput {
                speaker: self.speaker,
            }
        }
    }
}
impl DescribeSpeakerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSpeakerOutput`](crate::output::DescribeSpeakerOutput)
    pub fn builder() -> crate::output::describe_speaker_output::Builder {
        crate::output::describe_speaker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFraudsterRegistrationJobOutput {
    /// <p>Contains details about the specified fraudster registration job.</p>
    pub job: std::option::Option<crate::model::FraudsterRegistrationJob>,
}
impl std::fmt::Debug for DescribeFraudsterRegistrationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFraudsterRegistrationJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`DescribeFraudsterRegistrationJobOutput`](crate::output::DescribeFraudsterRegistrationJobOutput)
pub mod describe_fraudster_registration_job_output {
    /// A builder for [`DescribeFraudsterRegistrationJobOutput`](crate::output::DescribeFraudsterRegistrationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::FraudsterRegistrationJob>,
    }
    impl Builder {
        /// <p>Contains details about the specified fraudster registration job.</p>
        pub fn job(mut self, input: crate::model::FraudsterRegistrationJob) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Contains details about the specified fraudster registration job.</p>
        pub fn set_job(
            mut self,
            input: std::option::Option<crate::model::FraudsterRegistrationJob>,
        ) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFraudsterRegistrationJobOutput`](crate::output::DescribeFraudsterRegistrationJobOutput)
        pub fn build(self) -> crate::output::DescribeFraudsterRegistrationJobOutput {
            crate::output::DescribeFraudsterRegistrationJobOutput { job: self.job }
        }
    }
}
impl DescribeFraudsterRegistrationJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFraudsterRegistrationJobOutput`](crate::output::DescribeFraudsterRegistrationJobOutput)
    pub fn builder() -> crate::output::describe_fraudster_registration_job_output::Builder {
        crate::output::describe_fraudster_registration_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFraudsterOutput {
    /// <p>Information about the specified fraudster.</p>
    pub fraudster: std::option::Option<crate::model::Fraudster>,
}
impl std::fmt::Debug for DescribeFraudsterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFraudsterOutput");
        formatter.field("fraudster", &self.fraudster);
        formatter.finish()
    }
}
/// See [`DescribeFraudsterOutput`](crate::output::DescribeFraudsterOutput)
pub mod describe_fraudster_output {
    /// A builder for [`DescribeFraudsterOutput`](crate::output::DescribeFraudsterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fraudster: std::option::Option<crate::model::Fraudster>,
    }
    impl Builder {
        /// <p>Information about the specified fraudster.</p>
        pub fn fraudster(mut self, input: crate::model::Fraudster) -> Self {
            self.fraudster = Some(input);
            self
        }
        /// <p>Information about the specified fraudster.</p>
        pub fn set_fraudster(
            mut self,
            input: std::option::Option<crate::model::Fraudster>,
        ) -> Self {
            self.fraudster = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFraudsterOutput`](crate::output::DescribeFraudsterOutput)
        pub fn build(self) -> crate::output::DescribeFraudsterOutput {
            crate::output::DescribeFraudsterOutput {
                fraudster: self.fraudster,
            }
        }
    }
}
impl DescribeFraudsterOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFraudsterOutput`](crate::output::DescribeFraudsterOutput)
    pub fn builder() -> crate::output::describe_fraudster_output::Builder {
        crate::output::describe_fraudster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainOutput {
    /// <p>Information about the specified domain.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl std::fmt::Debug for DescribeDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainOutput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
pub mod describe_domain_output {
    /// A builder for [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>Information about the specified domain.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>Information about the specified domain.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
        pub fn build(self) -> crate::output::DescribeDomainOutput {
            crate::output::DescribeDomainOutput {
                domain: self.domain,
            }
        }
    }
}
impl DescribeDomainOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
    pub fn builder() -> crate::output::describe_domain_output::Builder {
        crate::output::describe_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSpeakerOutput {}
impl std::fmt::Debug for DeleteSpeakerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSpeakerOutput");
        formatter.finish()
    }
}
/// See [`DeleteSpeakerOutput`](crate::output::DeleteSpeakerOutput)
pub mod delete_speaker_output {
    /// A builder for [`DeleteSpeakerOutput`](crate::output::DeleteSpeakerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSpeakerOutput`](crate::output::DeleteSpeakerOutput)
        pub fn build(self) -> crate::output::DeleteSpeakerOutput {
            crate::output::DeleteSpeakerOutput {}
        }
    }
}
impl DeleteSpeakerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSpeakerOutput`](crate::output::DeleteSpeakerOutput)
    pub fn builder() -> crate::output::delete_speaker_output::Builder {
        crate::output::delete_speaker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFraudsterOutput {}
impl std::fmt::Debug for DeleteFraudsterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFraudsterOutput");
        formatter.finish()
    }
}
/// See [`DeleteFraudsterOutput`](crate::output::DeleteFraudsterOutput)
pub mod delete_fraudster_output {
    /// A builder for [`DeleteFraudsterOutput`](crate::output::DeleteFraudsterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFraudsterOutput`](crate::output::DeleteFraudsterOutput)
        pub fn build(self) -> crate::output::DeleteFraudsterOutput {
            crate::output::DeleteFraudsterOutput {}
        }
    }
}
impl DeleteFraudsterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFraudsterOutput`](crate::output::DeleteFraudsterOutput)
    pub fn builder() -> crate::output::delete_fraudster_output::Builder {
        crate::output::delete_fraudster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainOutput {}
impl std::fmt::Debug for DeleteDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainOutput");
        formatter.finish()
    }
}
/// See [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
pub mod delete_domain_output {
    /// A builder for [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
        pub fn build(self) -> crate::output::DeleteDomainOutput {
            crate::output::DeleteDomainOutput {}
        }
    }
}
impl DeleteDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    pub fn builder() -> crate::output::delete_domain_output::Builder {
        crate::output::delete_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainOutput {
    /// <p>Information about the newly created domain.</p>
    pub domain: std::option::Option<crate::model::Domain>,
}
impl std::fmt::Debug for CreateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainOutput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`CreateDomainOutput`](crate::output::CreateDomainOutput)
pub mod create_domain_output {
    /// A builder for [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::Domain>,
    }
    impl Builder {
        /// <p>Information about the newly created domain.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>Information about the newly created domain.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainOutput`](crate::output::CreateDomainOutput)
        pub fn build(self) -> crate::output::CreateDomainOutput {
            crate::output::CreateDomainOutput {
                domain: self.domain,
            }
        }
    }
}
impl CreateDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    pub fn builder() -> crate::output::create_domain_output::Builder {
        crate::output::create_domain_output::Builder::default()
    }
}
