// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    BatchJob,
    #[allow(missing_docs)] // documentation missing in model
    ComplianceConsent,
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    Fraudster,
    #[allow(missing_docs)] // documentation missing in model
    Session,
    #[allow(missing_docs)] // documentation missing in model
    Speaker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "BATCH_JOB" => ResourceType::BatchJob,
            "COMPLIANCE_CONSENT" => ResourceType::ComplianceConsent,
            "DOMAIN" => ResourceType::Domain,
            "FRAUDSTER" => ResourceType::Fraudster,
            "SESSION" => ResourceType::Session,
            "SPEAKER" => ResourceType::Speaker,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::BatchJob => "BATCH_JOB",
            ResourceType::ComplianceConsent => "COMPLIANCE_CONSENT",
            ResourceType::Domain => "DOMAIN",
            ResourceType::Fraudster => "FRAUDSTER",
            ResourceType::Session => "SESSION",
            ResourceType::Speaker => "SPEAKER",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BATCH_JOB",
            "COMPLIANCE_CONSENT",
            "DOMAIN",
            "FRAUDSTER",
            "SESSION",
            "SPEAKER",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConflictType {
    #[allow(missing_docs)] // documentation missing in model
    AnotherActiveStream,
    #[allow(missing_docs)] // documentation missing in model
    CannotChangeSpeakerAfterEnrollment,
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentChanges,
    #[allow(missing_docs)] // documentation missing in model
    DomainNotActive,
    #[allow(missing_docs)] // documentation missing in model
    EnrollmentAlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    SpeakerNotSet,
    #[allow(missing_docs)] // documentation missing in model
    SpeakerOptedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConflictType {
    fn from(s: &str) -> Self {
        match s {
            "ANOTHER_ACTIVE_STREAM" => ConflictType::AnotherActiveStream,
            "CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT" => {
                ConflictType::CannotChangeSpeakerAfterEnrollment
            }
            "CONCURRENT_CHANGES" => ConflictType::ConcurrentChanges,
            "DOMAIN_NOT_ACTIVE" => ConflictType::DomainNotActive,
            "ENROLLMENT_ALREADY_EXISTS" => ConflictType::EnrollmentAlreadyExists,
            "SPEAKER_NOT_SET" => ConflictType::SpeakerNotSet,
            "SPEAKER_OPTED_OUT" => ConflictType::SpeakerOptedOut,
            other => ConflictType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConflictType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConflictType::from(s))
    }
}
impl ConflictType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConflictType::AnotherActiveStream => "ANOTHER_ACTIVE_STREAM",
            ConflictType::CannotChangeSpeakerAfterEnrollment => {
                "CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT"
            }
            ConflictType::ConcurrentChanges => "CONCURRENT_CHANGES",
            ConflictType::DomainNotActive => "DOMAIN_NOT_ACTIVE",
            ConflictType::EnrollmentAlreadyExists => "ENROLLMENT_ALREADY_EXISTS",
            ConflictType::SpeakerNotSet => "SPEAKER_NOT_SET",
            ConflictType::SpeakerOptedOut => "SPEAKER_OPTED_OUT",
            ConflictType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANOTHER_ACTIVE_STREAM",
            "CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT",
            "CONCURRENT_CHANGES",
            "DOMAIN_NOT_ACTIVE",
            "ENROLLMENT_ALREADY_EXISTS",
            "SPEAKER_NOT_SET",
            "SPEAKER_OPTED_OUT",
        ]
    }
}
impl AsRef<str> for ConflictType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains all the information about a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Domain {
    /// <p>The service-generated identifier for the domain.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the domain.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The client-provided name for the domain.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The client-provided description of the domain.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the domain.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
    /// <p>The server-side encryption configuration containing the KMS Key Identifier you want Voice ID to use
    /// to encrypt your data.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    /// <p>The timestamp at which the domain is created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp showing the domain's last update.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Domain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Domain");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("domain_status", &self.domain_status);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Domain`](crate::model::Domain)
pub mod domain {
    /// A builder for [`Domain`](crate::model::Domain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The service-generated identifier for the domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the domain.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the domain.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The client-provided name for the domain.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The client-provided name for the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The client-provided description of the domain.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The client-provided description of the domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the domain.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The current status of the domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// <p>The server-side encryption configuration containing the KMS Key Identifier you want Voice ID to use
        /// to encrypt your data.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The server-side encryption configuration containing the KMS Key Identifier you want Voice ID to use
        /// to encrypt your data.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The timestamp at which the domain is created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp at which the domain is created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp showing the domain's last update.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The timestamp showing the domain's last update.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Domain`](crate::model::Domain)
        pub fn build(self) -> crate::model::Domain {
            crate::model::Domain {
                domain_id: self.domain_id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                domain_status: self.domain_status,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Domain {
    /// Creates a new builder-style object to manufacture [`Domain`](crate::model::Domain)
    pub fn builder() -> crate::model::domain::Builder {
        crate::model::domain::Builder::default()
    }
}

/// <p>The configuration containing information about the customer-managed KMS Key used for encrypting
/// customer data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryptionConfiguration {
    /// <p>The identifier of the KMS Key you want Voice ID to use to encrypt your data.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerSideEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryptionConfiguration");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
pub mod server_side_encryption_configuration {
    /// A builder for [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the KMS Key you want Voice ID to use to encrypt your data.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The identifier of the KMS Key you want Voice ID to use to encrypt your data.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
        pub fn build(self) -> crate::model::ServerSideEncryptionConfiguration {
            crate::model::ServerSideEncryptionConfiguration {
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ServerSideEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    pub fn builder() -> crate::model::server_side_encryption_configuration::Builder {
        crate::model::server_side_encryption_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DomainStatus::Active,
            "PENDING" => DomainStatus::Pending,
            "SUSPENDED" => DomainStatus::Suspended,
            other => DomainStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainStatus::from(s))
    }
}
impl DomainStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainStatus::Active => "ACTIVE",
            DomainStatus::Pending => "PENDING",
            DomainStatus::Suspended => "SUSPENDED",
            DomainStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "PENDING", "SUSPENDED"]
    }
}
impl AsRef<str> for DomainStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A tag that can be assigned to a Voice ID resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The first part of a key:value pair that forms a tag associated with a given resource. For example,
    /// in the tag ‘Department’:’Sales’, the key is 'Department'.
    /// </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The second part of a key:value pair that forms a tag associated with a given resource. For example,
    /// in the tag ‘Department’:’Sales’, the value is 'Sales'.
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &"*** Sensitive Data Redacted ***");
        formatter.field("value", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The first part of a key:value pair that forms a tag associated with a given resource. For example,
        /// in the tag ‘Department’:’Sales’, the key is 'Department'.
        /// </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The first part of a key:value pair that forms a tag associated with a given resource. For example,
        /// in the tag ‘Department’:’Sales’, the key is 'Department'.
        /// </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The second part of a key:value pair that forms a tag associated with a given resource. For example,
        /// in the tag ‘Department’:’Sales’, the value is 'Sales'.
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The second part of a key:value pair that forms a tag associated with a given resource. For example,
        /// in the tag ‘Department’:’Sales’, the value is 'Sales'.
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains all the information about a speaker enrollment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpeakerEnrollmentJob {
    /// <p>The client-provided name for the speaker enrollment job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the speaker enrollment job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the speaker enrollment job.</p>
    pub job_status: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
    /// <p>The identifier of the domain that contains the speaker enrollment job.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
    /// to read the input manifest file and write the job output file.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the
    /// <code>FraudDetectionConfig</code> to use.</p>
    pub enrollment_config: std::option::Option<crate::model::EnrollmentConfig>,
    /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
    /// of speaker enrollment job requests.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
    /// also include a KMS Key ID to encrypt the file.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>A timestamp showing the creation of the speaker enrollment job.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp showing when the speaker enrollment job ended. </p>
    pub ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
    /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
    /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
    /// registration requests that failed.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
    /// <p>Provides details on job progress. This field shows the completed percentage of registration
    /// requests listed in the input file.</p>
    pub job_progress: std::option::Option<crate::model::JobProgress>,
}
impl std::fmt::Debug for SpeakerEnrollmentJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpeakerEnrollmentJob");
        formatter.field("job_name", &"*** Sensitive Data Redacted ***");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("domain_id", &self.domain_id);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("enrollment_config", &self.enrollment_config);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("created_at", &self.created_at);
        formatter.field("ended_at", &self.ended_at);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("job_progress", &self.job_progress);
        formatter.finish()
    }
}
/// See [`SpeakerEnrollmentJob`](crate::model::SpeakerEnrollmentJob)
pub mod speaker_enrollment_job {
    /// A builder for [`SpeakerEnrollmentJob`](crate::model::SpeakerEnrollmentJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) enrollment_config: std::option::Option<crate::model::EnrollmentConfig>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
        pub(crate) job_progress: std::option::Option<crate::model::JobProgress>,
    }
    impl Builder {
        /// <p>The client-provided name for the speaker enrollment job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The client-provided name for the speaker enrollment job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The service-generated identifier for the speaker enrollment job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the speaker enrollment job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the speaker enrollment job.</p>
        pub fn job_status(mut self, input: crate::model::SpeakerEnrollmentJobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the speaker enrollment job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the job output file.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the job output file.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the
        /// <code>FraudDetectionConfig</code> to use.</p>
        pub fn enrollment_config(mut self, input: crate::model::EnrollmentConfig) -> Self {
            self.enrollment_config = Some(input);
            self
        }
        /// <p>The configuration that defines the action to take when the speaker is already enrolled in Voice ID, and the
        /// <code>FraudDetectionConfig</code> to use.</p>
        pub fn set_enrollment_config(
            mut self,
            input: std::option::Option<crate::model::EnrollmentConfig>,
        ) -> Self {
            self.enrollment_config = input;
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
        /// of speaker enrollment job requests.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
        /// of speaker enrollment job requests.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
        /// also include a KMS Key ID to encrypt the file.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data config containing the S3 location where Voice ID writes the job output file; you must
        /// also include a KMS Key ID to encrypt the file.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>A timestamp showing the creation of the speaker enrollment job.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp showing the creation of the speaker enrollment job.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A timestamp showing when the speaker enrollment job ended. </p>
        pub fn ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the speaker enrollment job ended. </p>
        pub fn set_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ended_at = input;
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>Provides details on job progress. This field shows the completed percentage of registration
        /// requests listed in the input file.</p>
        pub fn job_progress(mut self, input: crate::model::JobProgress) -> Self {
            self.job_progress = Some(input);
            self
        }
        /// <p>Provides details on job progress. This field shows the completed percentage of registration
        /// requests listed in the input file.</p>
        pub fn set_job_progress(
            mut self,
            input: std::option::Option<crate::model::JobProgress>,
        ) -> Self {
            self.job_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`SpeakerEnrollmentJob`](crate::model::SpeakerEnrollmentJob)
        pub fn build(self) -> crate::model::SpeakerEnrollmentJob {
            crate::model::SpeakerEnrollmentJob {
                job_name: self.job_name,
                job_id: self.job_id,
                job_status: self.job_status,
                domain_id: self.domain_id,
                data_access_role_arn: self.data_access_role_arn,
                enrollment_config: self.enrollment_config,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                created_at: self.created_at,
                ended_at: self.ended_at,
                failure_details: self.failure_details,
                job_progress: self.job_progress,
            }
        }
    }
}
impl SpeakerEnrollmentJob {
    /// Creates a new builder-style object to manufacture [`SpeakerEnrollmentJob`](crate::model::SpeakerEnrollmentJob)
    pub fn builder() -> crate::model::speaker_enrollment_job::Builder {
        crate::model::speaker_enrollment_job::Builder::default()
    }
}

/// <p>Indicates the completion progress for a batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobProgress {
    /// <p>Shows the completed percentage of enrollment or registration requests listed in the input file.</p>
    pub percent_complete: std::option::Option<i32>,
}
impl std::fmt::Debug for JobProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobProgress");
        formatter.field("percent_complete", &self.percent_complete);
        formatter.finish()
    }
}
/// See [`JobProgress`](crate::model::JobProgress)
pub mod job_progress {
    /// A builder for [`JobProgress`](crate::model::JobProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percent_complete: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Shows the completed percentage of enrollment or registration requests listed in the input file.</p>
        pub fn percent_complete(mut self, input: i32) -> Self {
            self.percent_complete = Some(input);
            self
        }
        /// <p>Shows the completed percentage of enrollment or registration requests listed in the input file.</p>
        pub fn set_percent_complete(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_complete = input;
            self
        }
        /// Consumes the builder and constructs a [`JobProgress`](crate::model::JobProgress)
        pub fn build(self) -> crate::model::JobProgress {
            crate::model::JobProgress {
                percent_complete: self.percent_complete,
            }
        }
    }
}
impl JobProgress {
    /// Creates a new builder-style object to manufacture [`JobProgress`](crate::model::JobProgress)
    pub fn builder() -> crate::model::job_progress::Builder {
        crate::model::job_progress::Builder::default()
    }
}

/// <p>Contains error details for a failed batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureDetails {
    /// <p>An HTTP status code representing the nature of the error.</p>
    pub status_code: std::option::Option<i32>,
    /// <p>A description of the error that caused the batch job failure.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FailureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureDetails");
        formatter.field("status_code", &self.status_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`FailureDetails`](crate::model::FailureDetails)
pub mod failure_details {
    /// A builder for [`FailureDetails`](crate::model::FailureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An HTTP status code representing the nature of the error.</p>
        pub fn status_code(mut self, input: i32) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>An HTTP status code representing the nature of the error.</p>
        pub fn set_status_code(mut self, input: std::option::Option<i32>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A description of the error that caused the batch job failure.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error that caused the batch job failure.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureDetails`](crate::model::FailureDetails)
        pub fn build(self) -> crate::model::FailureDetails {
            crate::model::FailureDetails {
                status_code: self.status_code,
                message: self.message,
            }
        }
    }
}
impl FailureDetails {
    /// Creates a new builder-style object to manufacture [`FailureDetails`](crate::model::FailureDetails)
    pub fn builder() -> crate::model::failure_details::Builder {
        crate::model::failure_details::Builder::default()
    }
}

/// <p>The configuration containing output file information for a batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputDataConfig {
    /// <p>The S3 path of the folder to which Voice ID writes the job output file, which has a
    /// <code>*.out</code> extension. For example, if the input file name is <code>input-file.json</code> and
    /// the output folder path is <code>s3://output-bucket/output-folder</code>, the full output file path is
    /// <code>s3://output-bucket/output-folder/job-Id/input-file.json.out</code>.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>the identifier of the KMS key you want Voice ID to use to encrypt the output file of the fraudster
    /// registration job.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OutputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`OutputDataConfig`](crate::model::OutputDataConfig)
pub mod output_data_config {
    /// A builder for [`OutputDataConfig`](crate::model::OutputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 path of the folder to which Voice ID writes the job output file, which has a
        /// <code>*.out</code> extension. For example, if the input file name is <code>input-file.json</code> and
        /// the output folder path is <code>s3://output-bucket/output-folder</code>, the full output file path is
        /// <code>s3://output-bucket/output-folder/job-Id/input-file.json.out</code>.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 path of the folder to which Voice ID writes the job output file, which has a
        /// <code>*.out</code> extension. For example, if the input file name is <code>input-file.json</code> and
        /// the output folder path is <code>s3://output-bucket/output-folder</code>, the full output file path is
        /// <code>s3://output-bucket/output-folder/job-Id/input-file.json.out</code>.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>the identifier of the KMS key you want Voice ID to use to encrypt the output file of the fraudster
        /// registration job.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>the identifier of the KMS key you want Voice ID to use to encrypt the output file of the fraudster
        /// registration job.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputDataConfig`](crate::model::OutputDataConfig)
        pub fn build(self) -> crate::model::OutputDataConfig {
            crate::model::OutputDataConfig {
                s3_uri: self.s3_uri,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl OutputDataConfig {
    /// Creates a new builder-style object to manufacture [`OutputDataConfig`](crate::model::OutputDataConfig)
    pub fn builder() -> crate::model::output_data_config::Builder {
        crate::model::output_data_config::Builder::default()
    }
}

/// <p>The configuration containing input file information for a batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDataConfig {
    /// <p>The S3 location for the input manifest file that contains the list of individual enrollment or registration
    /// job requests.</p>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`InputDataConfig`](crate::model::InputDataConfig)
pub mod input_data_config {
    /// A builder for [`InputDataConfig`](crate::model::InputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 location for the input manifest file that contains the list of individual enrollment or registration
        /// job requests.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 location for the input manifest file that contains the list of individual enrollment or registration
        /// job requests.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDataConfig`](crate::model::InputDataConfig)
        pub fn build(self) -> crate::model::InputDataConfig {
            crate::model::InputDataConfig {
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl InputDataConfig {
    /// Creates a new builder-style object to manufacture [`InputDataConfig`](crate::model::InputDataConfig)
    pub fn builder() -> crate::model::input_data_config::Builder {
        crate::model::input_data_config::Builder::default()
    }
}

/// <p>Contains configurations defining enrollment behavior for the batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnrollmentConfig {
    /// <p> The action to take when the specified speaker is already enrolled in the specified domain. The default
    /// value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
    /// <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
    /// with new data generated from the latest audio.</p>
    pub existing_enrollment_action: std::option::Option<crate::model::ExistingEnrollmentAction>,
    /// <p>The fraud detection configuration to use for the speaker enrollment job.</p>
    pub fraud_detection_config:
        std::option::Option<crate::model::EnrollmentJobFraudDetectionConfig>,
}
impl std::fmt::Debug for EnrollmentConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnrollmentConfig");
        formatter.field(
            "existing_enrollment_action",
            &self.existing_enrollment_action,
        );
        formatter.field("fraud_detection_config", &self.fraud_detection_config);
        formatter.finish()
    }
}
/// See [`EnrollmentConfig`](crate::model::EnrollmentConfig)
pub mod enrollment_config {
    /// A builder for [`EnrollmentConfig`](crate::model::EnrollmentConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) existing_enrollment_action:
            std::option::Option<crate::model::ExistingEnrollmentAction>,
        pub(crate) fraud_detection_config:
            std::option::Option<crate::model::EnrollmentJobFraudDetectionConfig>,
    }
    impl Builder {
        /// <p> The action to take when the specified speaker is already enrolled in the specified domain. The default
        /// value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
        /// <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
        /// with new data generated from the latest audio.</p>
        pub fn existing_enrollment_action(
            mut self,
            input: crate::model::ExistingEnrollmentAction,
        ) -> Self {
            self.existing_enrollment_action = Some(input);
            self
        }
        /// <p> The action to take when the specified speaker is already enrolled in the specified domain. The default
        /// value is <code>SKIP</code>, which skips the enrollment for the existing speaker. Setting the value to
        /// <code>OVERWRITE</code> replaces the existing voice prints and enrollment audio stored for that speaker
        /// with new data generated from the latest audio.</p>
        pub fn set_existing_enrollment_action(
            mut self,
            input: std::option::Option<crate::model::ExistingEnrollmentAction>,
        ) -> Self {
            self.existing_enrollment_action = input;
            self
        }
        /// <p>The fraud detection configuration to use for the speaker enrollment job.</p>
        pub fn fraud_detection_config(
            mut self,
            input: crate::model::EnrollmentJobFraudDetectionConfig,
        ) -> Self {
            self.fraud_detection_config = Some(input);
            self
        }
        /// <p>The fraud detection configuration to use for the speaker enrollment job.</p>
        pub fn set_fraud_detection_config(
            mut self,
            input: std::option::Option<crate::model::EnrollmentJobFraudDetectionConfig>,
        ) -> Self {
            self.fraud_detection_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EnrollmentConfig`](crate::model::EnrollmentConfig)
        pub fn build(self) -> crate::model::EnrollmentConfig {
            crate::model::EnrollmentConfig {
                existing_enrollment_action: self.existing_enrollment_action,
                fraud_detection_config: self.fraud_detection_config,
            }
        }
    }
}
impl EnrollmentConfig {
    /// Creates a new builder-style object to manufacture [`EnrollmentConfig`](crate::model::EnrollmentConfig)
    pub fn builder() -> crate::model::enrollment_config::Builder {
        crate::model::enrollment_config::Builder::default()
    }
}

/// <p>The configuration defining the action to take when a speaker is flagged by the fraud detection system
/// during a batch speaker enrollment job, and the risk threshold to use for identification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnrollmentJobFraudDetectionConfig {
    /// <p>The action to take when the given speaker is flagged by the fraud detection system. The default value is
    /// <code>FAIL</code>, which fails the speaker enrollment. Changing this value to <code>IGNORE</code>
    /// results in the speaker being enrolled even if they are flagged by the fraud detection system.</p>
    pub fraud_detection_action: std::option::Option<crate::model::FraudDetectionAction>,
    /// <p>Threshold value for determining whether the speaker is a high risk to be fraudulent. If the detected risk
    /// score calculated by Voice ID is greater than or equal to the threshold, the speaker is considered a fraudster.</p>
    pub risk_threshold: std::option::Option<i32>,
}
impl std::fmt::Debug for EnrollmentJobFraudDetectionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnrollmentJobFraudDetectionConfig");
        formatter.field("fraud_detection_action", &self.fraud_detection_action);
        formatter.field("risk_threshold", &self.risk_threshold);
        formatter.finish()
    }
}
/// See [`EnrollmentJobFraudDetectionConfig`](crate::model::EnrollmentJobFraudDetectionConfig)
pub mod enrollment_job_fraud_detection_config {
    /// A builder for [`EnrollmentJobFraudDetectionConfig`](crate::model::EnrollmentJobFraudDetectionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fraud_detection_action: std::option::Option<crate::model::FraudDetectionAction>,
        pub(crate) risk_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The action to take when the given speaker is flagged by the fraud detection system. The default value is
        /// <code>FAIL</code>, which fails the speaker enrollment. Changing this value to <code>IGNORE</code>
        /// results in the speaker being enrolled even if they are flagged by the fraud detection system.</p>
        pub fn fraud_detection_action(mut self, input: crate::model::FraudDetectionAction) -> Self {
            self.fraud_detection_action = Some(input);
            self
        }
        /// <p>The action to take when the given speaker is flagged by the fraud detection system. The default value is
        /// <code>FAIL</code>, which fails the speaker enrollment. Changing this value to <code>IGNORE</code>
        /// results in the speaker being enrolled even if they are flagged by the fraud detection system.</p>
        pub fn set_fraud_detection_action(
            mut self,
            input: std::option::Option<crate::model::FraudDetectionAction>,
        ) -> Self {
            self.fraud_detection_action = input;
            self
        }
        /// <p>Threshold value for determining whether the speaker is a high risk to be fraudulent. If the detected risk
        /// score calculated by Voice ID is greater than or equal to the threshold, the speaker is considered a fraudster.</p>
        pub fn risk_threshold(mut self, input: i32) -> Self {
            self.risk_threshold = Some(input);
            self
        }
        /// <p>Threshold value for determining whether the speaker is a high risk to be fraudulent. If the detected risk
        /// score calculated by Voice ID is greater than or equal to the threshold, the speaker is considered a fraudster.</p>
        pub fn set_risk_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.risk_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`EnrollmentJobFraudDetectionConfig`](crate::model::EnrollmentJobFraudDetectionConfig)
        pub fn build(self) -> crate::model::EnrollmentJobFraudDetectionConfig {
            crate::model::EnrollmentJobFraudDetectionConfig {
                fraud_detection_action: self.fraud_detection_action,
                risk_threshold: self.risk_threshold,
            }
        }
    }
}
impl EnrollmentJobFraudDetectionConfig {
    /// Creates a new builder-style object to manufacture [`EnrollmentJobFraudDetectionConfig`](crate::model::EnrollmentJobFraudDetectionConfig)
    pub fn builder() -> crate::model::enrollment_job_fraud_detection_config::Builder {
        crate::model::enrollment_job_fraud_detection_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FraudDetectionAction {
    #[allow(missing_docs)] // documentation missing in model
    Fail,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FraudDetectionAction {
    fn from(s: &str) -> Self {
        match s {
            "FAIL" => FraudDetectionAction::Fail,
            "IGNORE" => FraudDetectionAction::Ignore,
            other => FraudDetectionAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FraudDetectionAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FraudDetectionAction::from(s))
    }
}
impl FraudDetectionAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FraudDetectionAction::Fail => "FAIL",
            FraudDetectionAction::Ignore => "IGNORE",
            FraudDetectionAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAIL", "IGNORE"]
    }
}
impl AsRef<str> for FraudDetectionAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExistingEnrollmentAction {
    #[allow(missing_docs)] // documentation missing in model
    Overwrite,
    #[allow(missing_docs)] // documentation missing in model
    Skip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExistingEnrollmentAction {
    fn from(s: &str) -> Self {
        match s {
            "OVERWRITE" => ExistingEnrollmentAction::Overwrite,
            "SKIP" => ExistingEnrollmentAction::Skip,
            other => ExistingEnrollmentAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExistingEnrollmentAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExistingEnrollmentAction::from(s))
    }
}
impl ExistingEnrollmentAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExistingEnrollmentAction::Overwrite => "OVERWRITE",
            ExistingEnrollmentAction::Skip => "SKIP",
            ExistingEnrollmentAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OVERWRITE", "SKIP"]
    }
}
impl AsRef<str> for ExistingEnrollmentAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpeakerEnrollmentJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpeakerEnrollmentJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => SpeakerEnrollmentJobStatus::Completed,
            "COMPLETED_WITH_ERRORS" => SpeakerEnrollmentJobStatus::CompletedWithErrors,
            "FAILED" => SpeakerEnrollmentJobStatus::Failed,
            "IN_PROGRESS" => SpeakerEnrollmentJobStatus::InProgress,
            "SUBMITTED" => SpeakerEnrollmentJobStatus::Submitted,
            other => SpeakerEnrollmentJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpeakerEnrollmentJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpeakerEnrollmentJobStatus::from(s))
    }
}
impl SpeakerEnrollmentJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpeakerEnrollmentJobStatus::Completed => "COMPLETED",
            SpeakerEnrollmentJobStatus::CompletedWithErrors => "COMPLETED_WITH_ERRORS",
            SpeakerEnrollmentJobStatus::Failed => "FAILED",
            SpeakerEnrollmentJobStatus::InProgress => "IN_PROGRESS",
            SpeakerEnrollmentJobStatus::Submitted => "SUBMITTED",
            SpeakerEnrollmentJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "COMPLETED_WITH_ERRORS",
            "FAILED",
            "IN_PROGRESS",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for SpeakerEnrollmentJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains all the information about a fraudster registration job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FraudsterRegistrationJob {
    /// <p>The client-provied name for the fraudster registration job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the fraudster registration job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the fraudster registration job.</p>
    pub job_status: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
    /// <p>The identifier of the domain containing the fraudster registration job.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
    /// to read the input manifest file and write the job output file.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The registration config containing details such as the action to take when a duplicate fraudster is
    /// detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
    pub registration_config: std::option::Option<crate::model::RegistrationConfig>,
    /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
    /// of fraudster registration job requests.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data config containing the S3 location where you want Voice ID to write your job output
    /// file; you must also include a KMS Key ID in order to encrypt the file.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>A timestamp showing the creation time of the fraudster registration job.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp showing when the fraudster registration job ended.</p>
    pub ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
    /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
    /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
    /// registration requests that failed.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
    /// <p>Shows the completed percentage of registration requests listed in the input file.</p>
    pub job_progress: std::option::Option<crate::model::JobProgress>,
}
impl std::fmt::Debug for FraudsterRegistrationJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FraudsterRegistrationJob");
        formatter.field("job_name", &"*** Sensitive Data Redacted ***");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("domain_id", &self.domain_id);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("registration_config", &self.registration_config);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("created_at", &self.created_at);
        formatter.field("ended_at", &self.ended_at);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("job_progress", &self.job_progress);
        formatter.finish()
    }
}
/// See [`FraudsterRegistrationJob`](crate::model::FraudsterRegistrationJob)
pub mod fraudster_registration_job {
    /// A builder for [`FraudsterRegistrationJob`](crate::model::FraudsterRegistrationJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) registration_config: std::option::Option<crate::model::RegistrationConfig>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
        pub(crate) job_progress: std::option::Option<crate::model::JobProgress>,
    }
    impl Builder {
        /// <p>The client-provied name for the fraudster registration job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The client-provied name for the fraudster registration job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The service-generated identifier for the fraudster registration job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the fraudster registration job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the fraudster registration job.</p>
        pub fn job_status(mut self, input: crate::model::FraudsterRegistrationJobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the fraudster registration job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the job output file.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets
        /// to read the input manifest file and write the job output file.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The registration config containing details such as the action to take when a duplicate fraudster is
        /// detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
        pub fn registration_config(mut self, input: crate::model::RegistrationConfig) -> Self {
            self.registration_config = Some(input);
            self
        }
        /// <p>The registration config containing details such as the action to take when a duplicate fraudster is
        /// detected, and the similarity threshold to use for detecting a duplicate fraudster.</p>
        pub fn set_registration_config(
            mut self,
            input: std::option::Option<crate::model::RegistrationConfig>,
        ) -> Self {
            self.registration_config = input;
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
        /// of fraudster registration job requests.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data config containing an S3 URI for the input manifest file that contains the list
        /// of fraudster registration job requests.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data config containing the S3 location where you want Voice ID to write your job output
        /// file; you must also include a KMS Key ID in order to encrypt the file.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data config containing the S3 location where you want Voice ID to write your job output
        /// file; you must also include a KMS Key ID in order to encrypt the file.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>A timestamp showing the creation time of the fraudster registration job.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp showing the creation time of the fraudster registration job.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A timestamp showing when the fraudster registration job ended.</p>
        pub fn ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the fraudster registration job ended.</p>
        pub fn set_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ended_at = input;
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>Shows the completed percentage of registration requests listed in the input file.</p>
        pub fn job_progress(mut self, input: crate::model::JobProgress) -> Self {
            self.job_progress = Some(input);
            self
        }
        /// <p>Shows the completed percentage of registration requests listed in the input file.</p>
        pub fn set_job_progress(
            mut self,
            input: std::option::Option<crate::model::JobProgress>,
        ) -> Self {
            self.job_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`FraudsterRegistrationJob`](crate::model::FraudsterRegistrationJob)
        pub fn build(self) -> crate::model::FraudsterRegistrationJob {
            crate::model::FraudsterRegistrationJob {
                job_name: self.job_name,
                job_id: self.job_id,
                job_status: self.job_status,
                domain_id: self.domain_id,
                data_access_role_arn: self.data_access_role_arn,
                registration_config: self.registration_config,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                created_at: self.created_at,
                ended_at: self.ended_at,
                failure_details: self.failure_details,
                job_progress: self.job_progress,
            }
        }
    }
}
impl FraudsterRegistrationJob {
    /// Creates a new builder-style object to manufacture [`FraudsterRegistrationJob`](crate::model::FraudsterRegistrationJob)
    pub fn builder() -> crate::model::fraudster_registration_job::Builder {
        crate::model::fraudster_registration_job::Builder::default()
    }
}

/// <p>The configuration definining the action to take when a duplicate fraudster is detected, and the
/// similarity threshold to use for detecting a duplicate fraudster during a batch fraudster registration job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistrationConfig {
    /// <p>The action to take when a fraudster is identified as a duplicate. The default action is
    /// <code>SKIP</code>, which skips registering the duplicate fraudster. Setting the value to
    /// <code>REGISTER_AS_NEW</code> always registers a new fraudster into the specified domain.</p>
    pub duplicate_registration_action:
        std::option::Option<crate::model::DuplicateRegistrationAction>,
    /// <p>The minimum similarity score between the new and old fraudsters in order to consider the new
    /// fraudster a duplicate.</p>
    pub fraudster_similarity_threshold: std::option::Option<i32>,
}
impl std::fmt::Debug for RegistrationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistrationConfig");
        formatter.field(
            "duplicate_registration_action",
            &self.duplicate_registration_action,
        );
        formatter.field(
            "fraudster_similarity_threshold",
            &self.fraudster_similarity_threshold,
        );
        formatter.finish()
    }
}
/// See [`RegistrationConfig`](crate::model::RegistrationConfig)
pub mod registration_config {
    /// A builder for [`RegistrationConfig`](crate::model::RegistrationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duplicate_registration_action:
            std::option::Option<crate::model::DuplicateRegistrationAction>,
        pub(crate) fraudster_similarity_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The action to take when a fraudster is identified as a duplicate. The default action is
        /// <code>SKIP</code>, which skips registering the duplicate fraudster. Setting the value to
        /// <code>REGISTER_AS_NEW</code> always registers a new fraudster into the specified domain.</p>
        pub fn duplicate_registration_action(
            mut self,
            input: crate::model::DuplicateRegistrationAction,
        ) -> Self {
            self.duplicate_registration_action = Some(input);
            self
        }
        /// <p>The action to take when a fraudster is identified as a duplicate. The default action is
        /// <code>SKIP</code>, which skips registering the duplicate fraudster. Setting the value to
        /// <code>REGISTER_AS_NEW</code> always registers a new fraudster into the specified domain.</p>
        pub fn set_duplicate_registration_action(
            mut self,
            input: std::option::Option<crate::model::DuplicateRegistrationAction>,
        ) -> Self {
            self.duplicate_registration_action = input;
            self
        }
        /// <p>The minimum similarity score between the new and old fraudsters in order to consider the new
        /// fraudster a duplicate.</p>
        pub fn fraudster_similarity_threshold(mut self, input: i32) -> Self {
            self.fraudster_similarity_threshold = Some(input);
            self
        }
        /// <p>The minimum similarity score between the new and old fraudsters in order to consider the new
        /// fraudster a duplicate.</p>
        pub fn set_fraudster_similarity_threshold(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.fraudster_similarity_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistrationConfig`](crate::model::RegistrationConfig)
        pub fn build(self) -> crate::model::RegistrationConfig {
            crate::model::RegistrationConfig {
                duplicate_registration_action: self.duplicate_registration_action,
                fraudster_similarity_threshold: self.fraudster_similarity_threshold,
            }
        }
    }
}
impl RegistrationConfig {
    /// Creates a new builder-style object to manufacture [`RegistrationConfig`](crate::model::RegistrationConfig)
    pub fn builder() -> crate::model::registration_config::Builder {
        crate::model::registration_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DuplicateRegistrationAction {
    #[allow(missing_docs)] // documentation missing in model
    RegisterAsNew,
    #[allow(missing_docs)] // documentation missing in model
    Skip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DuplicateRegistrationAction {
    fn from(s: &str) -> Self {
        match s {
            "REGISTER_AS_NEW" => DuplicateRegistrationAction::RegisterAsNew,
            "SKIP" => DuplicateRegistrationAction::Skip,
            other => DuplicateRegistrationAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DuplicateRegistrationAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DuplicateRegistrationAction::from(s))
    }
}
impl DuplicateRegistrationAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DuplicateRegistrationAction::RegisterAsNew => "REGISTER_AS_NEW",
            DuplicateRegistrationAction::Skip => "SKIP",
            DuplicateRegistrationAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REGISTER_AS_NEW", "SKIP"]
    }
}
impl AsRef<str> for DuplicateRegistrationAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FraudsterRegistrationJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FraudsterRegistrationJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => FraudsterRegistrationJobStatus::Completed,
            "COMPLETED_WITH_ERRORS" => FraudsterRegistrationJobStatus::CompletedWithErrors,
            "FAILED" => FraudsterRegistrationJobStatus::Failed,
            "IN_PROGRESS" => FraudsterRegistrationJobStatus::InProgress,
            "SUBMITTED" => FraudsterRegistrationJobStatus::Submitted,
            other => FraudsterRegistrationJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FraudsterRegistrationJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FraudsterRegistrationJobStatus::from(s))
    }
}
impl FraudsterRegistrationJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FraudsterRegistrationJobStatus::Completed => "COMPLETED",
            FraudsterRegistrationJobStatus::CompletedWithErrors => "COMPLETED_WITH_ERRORS",
            FraudsterRegistrationJobStatus::Failed => "FAILED",
            FraudsterRegistrationJobStatus::InProgress => "IN_PROGRESS",
            FraudsterRegistrationJobStatus::Submitted => "SUBMITTED",
            FraudsterRegistrationJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "COMPLETED_WITH_ERRORS",
            "FAILED",
            "IN_PROGRESS",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for FraudsterRegistrationJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains all the information about a speaker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Speaker {
    /// <p>The identifier of the domain that contains the speaker.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The client-provided identifier for the speaker.</p>
    pub customer_speaker_id: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the speaker.</p>
    pub generated_speaker_id: std::option::Option<std::string::String>,
    /// <p>The current status of the speaker.</p>
    pub status: std::option::Option<crate::model::SpeakerStatus>,
    /// <p>A timestamp showing when the speaker is created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp showing the speaker's last update.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Speaker {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Speaker");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("customer_speaker_id", &"*** Sensitive Data Redacted ***");
        formatter.field("generated_speaker_id", &self.generated_speaker_id);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Speaker`](crate::model::Speaker)
pub mod speaker {
    /// A builder for [`Speaker`](crate::model::Speaker)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) customer_speaker_id: std::option::Option<std::string::String>,
        pub(crate) generated_speaker_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SpeakerStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The client-provided identifier for the speaker.</p>
        pub fn customer_speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_speaker_id = Some(input.into());
            self
        }
        /// <p>The client-provided identifier for the speaker.</p>
        pub fn set_customer_speaker_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_speaker_id = input;
            self
        }
        /// <p>The service-generated identifier for the speaker.</p>
        pub fn generated_speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_speaker_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the speaker.</p>
        pub fn set_generated_speaker_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_speaker_id = input;
            self
        }
        /// <p>The current status of the speaker.</p>
        pub fn status(mut self, input: crate::model::SpeakerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the speaker.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SpeakerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp showing when the speaker is created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the speaker is created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A timestamp showing the speaker's last update.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>A timestamp showing the speaker's last update.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Speaker`](crate::model::Speaker)
        pub fn build(self) -> crate::model::Speaker {
            crate::model::Speaker {
                domain_id: self.domain_id,
                customer_speaker_id: self.customer_speaker_id,
                generated_speaker_id: self.generated_speaker_id,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Speaker {
    /// Creates a new builder-style object to manufacture [`Speaker`](crate::model::Speaker)
    pub fn builder() -> crate::model::speaker::Builder {
        crate::model::speaker::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpeakerStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enrolled,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    OptedOut,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpeakerStatus {
    fn from(s: &str) -> Self {
        match s {
            "ENROLLED" => SpeakerStatus::Enrolled,
            "EXPIRED" => SpeakerStatus::Expired,
            "OPTED_OUT" => SpeakerStatus::OptedOut,
            "PENDING" => SpeakerStatus::Pending,
            other => SpeakerStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpeakerStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpeakerStatus::from(s))
    }
}
impl SpeakerStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpeakerStatus::Enrolled => "ENROLLED",
            SpeakerStatus::Expired => "EXPIRED",
            SpeakerStatus::OptedOut => "OPTED_OUT",
            SpeakerStatus::Pending => "PENDING",
            SpeakerStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENROLLED", "EXPIRED", "OPTED_OUT", "PENDING"]
    }
}
impl AsRef<str> for SpeakerStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a summary of information about a speaker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpeakerSummary {
    /// <p>The identifier of the domain that contains the speaker.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The client-provided identifier for the speaker.</p>
    pub customer_speaker_id: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the speaker. </p>
    pub generated_speaker_id: std::option::Option<std::string::String>,
    /// <p>The current status of the speaker.</p>
    pub status: std::option::Option<crate::model::SpeakerStatus>,
    /// <p>A timestamp showing the speaker's creation time. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp showing the speaker's last update.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SpeakerSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpeakerSummary");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("customer_speaker_id", &"*** Sensitive Data Redacted ***");
        formatter.field("generated_speaker_id", &self.generated_speaker_id);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`SpeakerSummary`](crate::model::SpeakerSummary)
pub mod speaker_summary {
    /// A builder for [`SpeakerSummary`](crate::model::SpeakerSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) customer_speaker_id: std::option::Option<std::string::String>,
        pub(crate) generated_speaker_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SpeakerStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain that contains the speaker.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The client-provided identifier for the speaker.</p>
        pub fn customer_speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_speaker_id = Some(input.into());
            self
        }
        /// <p>The client-provided identifier for the speaker.</p>
        pub fn set_customer_speaker_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_speaker_id = input;
            self
        }
        /// <p>The service-generated identifier for the speaker. </p>
        pub fn generated_speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_speaker_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the speaker. </p>
        pub fn set_generated_speaker_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_speaker_id = input;
            self
        }
        /// <p>The current status of the speaker.</p>
        pub fn status(mut self, input: crate::model::SpeakerStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the speaker.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SpeakerStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp showing the speaker's creation time. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp showing the speaker's creation time. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A timestamp showing the speaker's last update.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>A timestamp showing the speaker's last update.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`SpeakerSummary`](crate::model::SpeakerSummary)
        pub fn build(self) -> crate::model::SpeakerSummary {
            crate::model::SpeakerSummary {
                domain_id: self.domain_id,
                customer_speaker_id: self.customer_speaker_id,
                generated_speaker_id: self.generated_speaker_id,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl SpeakerSummary {
    /// Creates a new builder-style object to manufacture [`SpeakerSummary`](crate::model::SpeakerSummary)
    pub fn builder() -> crate::model::speaker_summary::Builder {
        crate::model::speaker_summary::Builder::default()
    }
}

/// <p>Contains a summary of information about a speaker enrollment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpeakerEnrollmentJobSummary {
    /// <p>The client-provided name for the speaker enrollment job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the speaker enrollment job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the speaker enrollment job.</p>
    pub job_status: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
    /// <p>The identifier of the domain that contains the speaker enrollment job.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>A timestamp showing the creation time of the speaker enrollment job.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp showing when the speaker enrollment job ended.</p>
    pub ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
    /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
    /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
    /// registration requests that failed.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
    /// <p>Provides details regarding job progress. This field shows the completed percentage of enrollment
    /// requests listed in the input file.</p>
    pub job_progress: std::option::Option<crate::model::JobProgress>,
}
impl std::fmt::Debug for SpeakerEnrollmentJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpeakerEnrollmentJobSummary");
        formatter.field("job_name", &"*** Sensitive Data Redacted ***");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("domain_id", &self.domain_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("ended_at", &self.ended_at);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("job_progress", &self.job_progress);
        formatter.finish()
    }
}
/// See [`SpeakerEnrollmentJobSummary`](crate::model::SpeakerEnrollmentJobSummary)
pub mod speaker_enrollment_job_summary {
    /// A builder for [`SpeakerEnrollmentJobSummary`](crate::model::SpeakerEnrollmentJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
        pub(crate) job_progress: std::option::Option<crate::model::JobProgress>,
    }
    impl Builder {
        /// <p>The client-provided name for the speaker enrollment job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The client-provided name for the speaker enrollment job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The service-generated identifier for the speaker enrollment job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the speaker enrollment job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the speaker enrollment job.</p>
        pub fn job_status(mut self, input: crate::model::SpeakerEnrollmentJobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the speaker enrollment job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::SpeakerEnrollmentJobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain that contains the speaker enrollment job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>A timestamp showing the creation time of the speaker enrollment job.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp showing the creation time of the speaker enrollment job.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A timestamp showing when the speaker enrollment job ended.</p>
        pub fn ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the speaker enrollment job ended.</p>
        pub fn set_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ended_at = input;
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>Provides details regarding job progress. This field shows the completed percentage of enrollment
        /// requests listed in the input file.</p>
        pub fn job_progress(mut self, input: crate::model::JobProgress) -> Self {
            self.job_progress = Some(input);
            self
        }
        /// <p>Provides details regarding job progress. This field shows the completed percentage of enrollment
        /// requests listed in the input file.</p>
        pub fn set_job_progress(
            mut self,
            input: std::option::Option<crate::model::JobProgress>,
        ) -> Self {
            self.job_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`SpeakerEnrollmentJobSummary`](crate::model::SpeakerEnrollmentJobSummary)
        pub fn build(self) -> crate::model::SpeakerEnrollmentJobSummary {
            crate::model::SpeakerEnrollmentJobSummary {
                job_name: self.job_name,
                job_id: self.job_id,
                job_status: self.job_status,
                domain_id: self.domain_id,
                created_at: self.created_at,
                ended_at: self.ended_at,
                failure_details: self.failure_details,
                job_progress: self.job_progress,
            }
        }
    }
}
impl SpeakerEnrollmentJobSummary {
    /// Creates a new builder-style object to manufacture [`SpeakerEnrollmentJobSummary`](crate::model::SpeakerEnrollmentJobSummary)
    pub fn builder() -> crate::model::speaker_enrollment_job_summary::Builder {
        crate::model::speaker_enrollment_job_summary::Builder::default()
    }
}

/// <p>Contains a summary of information about a fraudster registration job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FraudsterRegistrationJobSummary {
    /// <p>The client-provied name for the fraudster registration job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the fraudster registration job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the fraudster registration job.</p>
    pub job_status: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
    /// <p>The identifier of the domain containing the fraudster registration job.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>A timestamp showing when the fraudster registration job is created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp showing when the fraudster registration job ended.</p>
    pub ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
    /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
    /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
    /// registration requests that failed.</p>
    pub failure_details: std::option::Option<crate::model::FailureDetails>,
    /// <p>Shows the completed percentage of registration requests listed in the input file.</p>
    pub job_progress: std::option::Option<crate::model::JobProgress>,
}
impl std::fmt::Debug for FraudsterRegistrationJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FraudsterRegistrationJobSummary");
        formatter.field("job_name", &"*** Sensitive Data Redacted ***");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("domain_id", &self.domain_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("ended_at", &self.ended_at);
        formatter.field("failure_details", &self.failure_details);
        formatter.field("job_progress", &self.job_progress);
        formatter.finish()
    }
}
/// See [`FraudsterRegistrationJobSummary`](crate::model::FraudsterRegistrationJobSummary)
pub mod fraudster_registration_job_summary {
    /// A builder for [`FraudsterRegistrationJobSummary`](crate::model::FraudsterRegistrationJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) failure_details: std::option::Option<crate::model::FailureDetails>,
        pub(crate) job_progress: std::option::Option<crate::model::JobProgress>,
    }
    impl Builder {
        /// <p>The client-provied name for the fraudster registration job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The client-provied name for the fraudster registration job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The service-generated identifier for the fraudster registration job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the fraudster registration job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the fraudster registration job.</p>
        pub fn job_status(mut self, input: crate::model::FraudsterRegistrationJobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the fraudster registration job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::FraudsterRegistrationJobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier of the domain containing the fraudster registration job.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>A timestamp showing when the fraudster registration job is created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the fraudster registration job is created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A timestamp showing when the fraudster registration job ended.</p>
        pub fn ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.ended_at = Some(input);
            self
        }
        /// <p>A timestamp showing when the fraudster registration job ended.</p>
        pub fn set_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.ended_at = input;
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn failure_details(mut self, input: crate::model::FailureDetails) -> Self {
            self.failure_details = Some(input);
            self
        }
        /// <p>Contains details that are populated when an entire batch job fails. In cases of individual registration
        /// job failures, the batch job as a whole doesn't fail; it is completed with a <code>JobStatus</code> of
        /// <code>COMPLETED_WITH_ERRORS</code>. You can use the job output file to identify the individual
        /// registration requests that failed.</p>
        pub fn set_failure_details(
            mut self,
            input: std::option::Option<crate::model::FailureDetails>,
        ) -> Self {
            self.failure_details = input;
            self
        }
        /// <p>Shows the completed percentage of registration requests listed in the input file.</p>
        pub fn job_progress(mut self, input: crate::model::JobProgress) -> Self {
            self.job_progress = Some(input);
            self
        }
        /// <p>Shows the completed percentage of registration requests listed in the input file.</p>
        pub fn set_job_progress(
            mut self,
            input: std::option::Option<crate::model::JobProgress>,
        ) -> Self {
            self.job_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`FraudsterRegistrationJobSummary`](crate::model::FraudsterRegistrationJobSummary)
        pub fn build(self) -> crate::model::FraudsterRegistrationJobSummary {
            crate::model::FraudsterRegistrationJobSummary {
                job_name: self.job_name,
                job_id: self.job_id,
                job_status: self.job_status,
                domain_id: self.domain_id,
                created_at: self.created_at,
                ended_at: self.ended_at,
                failure_details: self.failure_details,
                job_progress: self.job_progress,
            }
        }
    }
}
impl FraudsterRegistrationJobSummary {
    /// Creates a new builder-style object to manufacture [`FraudsterRegistrationJobSummary`](crate::model::FraudsterRegistrationJobSummary)
    pub fn builder() -> crate::model::fraudster_registration_job_summary::Builder {
        crate::model::fraudster_registration_job_summary::Builder::default()
    }
}

/// <p>Contains a summary of information about a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainSummary {
    /// <p>The service-generated identifier for the domain.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the domain.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The client-provided name for the domain.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The client-provided description of the domain.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the domain.</p>
    pub domain_status: std::option::Option<crate::model::DomainStatus>,
    /// <p>The server-side encryption configuration containing the KMS Key Identifier you want Voice ID to use
    /// to encrypt your data..</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    /// <p>The timestamp showing when the domain is created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp showing the domain's last update.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DomainSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainSummary");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("domain_status", &self.domain_status);
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`DomainSummary`](crate::model::DomainSummary)
pub mod domain_summary {
    /// A builder for [`DomainSummary`](crate::model::DomainSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) domain_status: std::option::Option<crate::model::DomainStatus>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The service-generated identifier for the domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the domain.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the domain.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The client-provided name for the domain.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The client-provided name for the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The client-provided description of the domain.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The client-provided description of the domain.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the domain.</p>
        pub fn domain_status(mut self, input: crate::model::DomainStatus) -> Self {
            self.domain_status = Some(input);
            self
        }
        /// <p>The current status of the domain.</p>
        pub fn set_domain_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.domain_status = input;
            self
        }
        /// <p>The server-side encryption configuration containing the KMS Key Identifier you want Voice ID to use
        /// to encrypt your data..</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>The server-side encryption configuration containing the KMS Key Identifier you want Voice ID to use
        /// to encrypt your data..</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The timestamp showing when the domain is created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp showing when the domain is created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp showing the domain's last update.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The timestamp showing the domain's last update.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainSummary`](crate::model::DomainSummary)
        pub fn build(self) -> crate::model::DomainSummary {
            crate::model::DomainSummary {
                domain_id: self.domain_id,
                arn: self.arn,
                name: self.name,
                description: self.description,
                domain_status: self.domain_status,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl DomainSummary {
    /// Creates a new builder-style object to manufacture [`DomainSummary`](crate::model::DomainSummary)
    pub fn builder() -> crate::model::domain_summary::Builder {
        crate::model::domain_summary::Builder::default()
    }
}

/// <p>The fraud detection result produced by Voice ID, processed against the current session state and streamed
/// audio of the speaker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FraudDetectionResult {
    /// <p>The unique identifier for this fraud detection result. Given there can be multiple fraud detections
    /// for a given session, this field helps in identifying if the returned result is from previous streaming
    /// activity or a new result. Note that in the absence of any new streaming activity or risk threshold
    /// changes, Voice ID always returns cached Fraud Detection result for this API.</p>
    pub fraud_detection_result_id: std::option::Option<std::string::String>,
    /// <p>A timestamp indicating when audio aggregation started for this fraud detection result.</p>
    pub audio_aggregation_started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp indicating when audio aggregation ended for this fraud detection result.</p>
    pub audio_aggregation_ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The <code>FraudDetectionConfiguration</code> used to generate this fraud detection result.</p>
    pub configuration: std::option::Option<crate::model::FraudDetectionConfiguration>,
    /// <p>The fraud detection decision produced by Voice ID, processed against the current session state and
    /// streamed audio of the speaker.</p>
    pub decision: std::option::Option<crate::model::FraudDetectionDecision>,
    /// <p>The reason speaker was flagged by the fraud detection system. This is only be populated if fraud
    /// detection Decision is <code>HIGH_RISK</code>, and only has one possible value:
    /// <code>KNOWN_FRAUDSTER</code>.</p>
    pub reasons: std::option::Option<std::vec::Vec<crate::model::FraudDetectionReason>>,
    /// <p>Details about each risk analyzed for this speaker.</p>
    pub risk_details: std::option::Option<crate::model::FraudRiskDetails>,
}
impl std::fmt::Debug for FraudDetectionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FraudDetectionResult");
        formatter.field("fraud_detection_result_id", &self.fraud_detection_result_id);
        formatter.field(
            "audio_aggregation_started_at",
            &self.audio_aggregation_started_at,
        );
        formatter.field(
            "audio_aggregation_ended_at",
            &self.audio_aggregation_ended_at,
        );
        formatter.field("configuration", &self.configuration);
        formatter.field("decision", &self.decision);
        formatter.field("reasons", &self.reasons);
        formatter.field("risk_details", &self.risk_details);
        formatter.finish()
    }
}
/// See [`FraudDetectionResult`](crate::model::FraudDetectionResult)
pub mod fraud_detection_result {
    /// A builder for [`FraudDetectionResult`](crate::model::FraudDetectionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fraud_detection_result_id: std::option::Option<std::string::String>,
        pub(crate) audio_aggregation_started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) audio_aggregation_ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) configuration: std::option::Option<crate::model::FraudDetectionConfiguration>,
        pub(crate) decision: std::option::Option<crate::model::FraudDetectionDecision>,
        pub(crate) reasons: std::option::Option<std::vec::Vec<crate::model::FraudDetectionReason>>,
        pub(crate) risk_details: std::option::Option<crate::model::FraudRiskDetails>,
    }
    impl Builder {
        /// <p>The unique identifier for this fraud detection result. Given there can be multiple fraud detections
        /// for a given session, this field helps in identifying if the returned result is from previous streaming
        /// activity or a new result. Note that in the absence of any new streaming activity or risk threshold
        /// changes, Voice ID always returns cached Fraud Detection result for this API.</p>
        pub fn fraud_detection_result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.fraud_detection_result_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for this fraud detection result. Given there can be multiple fraud detections
        /// for a given session, this field helps in identifying if the returned result is from previous streaming
        /// activity or a new result. Note that in the absence of any new streaming activity or risk threshold
        /// changes, Voice ID always returns cached Fraud Detection result for this API.</p>
        pub fn set_fraud_detection_result_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fraud_detection_result_id = input;
            self
        }
        /// <p>A timestamp indicating when audio aggregation started for this fraud detection result.</p>
        pub fn audio_aggregation_started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.audio_aggregation_started_at = Some(input);
            self
        }
        /// <p>A timestamp indicating when audio aggregation started for this fraud detection result.</p>
        pub fn set_audio_aggregation_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.audio_aggregation_started_at = input;
            self
        }
        /// <p>A timestamp indicating when audio aggregation ended for this fraud detection result.</p>
        pub fn audio_aggregation_ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.audio_aggregation_ended_at = Some(input);
            self
        }
        /// <p>A timestamp indicating when audio aggregation ended for this fraud detection result.</p>
        pub fn set_audio_aggregation_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.audio_aggregation_ended_at = input;
            self
        }
        /// <p>The <code>FraudDetectionConfiguration</code> used to generate this fraud detection result.</p>
        pub fn configuration(mut self, input: crate::model::FraudDetectionConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The <code>FraudDetectionConfiguration</code> used to generate this fraud detection result.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::FraudDetectionConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The fraud detection decision produced by Voice ID, processed against the current session state and
        /// streamed audio of the speaker.</p>
        pub fn decision(mut self, input: crate::model::FraudDetectionDecision) -> Self {
            self.decision = Some(input);
            self
        }
        /// <p>The fraud detection decision produced by Voice ID, processed against the current session state and
        /// streamed audio of the speaker.</p>
        pub fn set_decision(
            mut self,
            input: std::option::Option<crate::model::FraudDetectionDecision>,
        ) -> Self {
            self.decision = input;
            self
        }
        /// Appends an item to `reasons`.
        ///
        /// To override the contents of this collection use [`set_reasons`](Self::set_reasons).
        ///
        /// <p>The reason speaker was flagged by the fraud detection system. This is only be populated if fraud
        /// detection Decision is <code>HIGH_RISK</code>, and only has one possible value:
        /// <code>KNOWN_FRAUDSTER</code>.</p>
        pub fn reasons(mut self, input: impl Into<crate::model::FraudDetectionReason>) -> Self {
            let mut v = self.reasons.unwrap_or_default();
            v.push(input.into());
            self.reasons = Some(v);
            self
        }
        /// <p>The reason speaker was flagged by the fraud detection system. This is only be populated if fraud
        /// detection Decision is <code>HIGH_RISK</code>, and only has one possible value:
        /// <code>KNOWN_FRAUDSTER</code>.</p>
        pub fn set_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FraudDetectionReason>>,
        ) -> Self {
            self.reasons = input;
            self
        }
        /// <p>Details about each risk analyzed for this speaker.</p>
        pub fn risk_details(mut self, input: crate::model::FraudRiskDetails) -> Self {
            self.risk_details = Some(input);
            self
        }
        /// <p>Details about each risk analyzed for this speaker.</p>
        pub fn set_risk_details(
            mut self,
            input: std::option::Option<crate::model::FraudRiskDetails>,
        ) -> Self {
            self.risk_details = input;
            self
        }
        /// Consumes the builder and constructs a [`FraudDetectionResult`](crate::model::FraudDetectionResult)
        pub fn build(self) -> crate::model::FraudDetectionResult {
            crate::model::FraudDetectionResult {
                fraud_detection_result_id: self.fraud_detection_result_id,
                audio_aggregation_started_at: self.audio_aggregation_started_at,
                audio_aggregation_ended_at: self.audio_aggregation_ended_at,
                configuration: self.configuration,
                decision: self.decision,
                reasons: self.reasons,
                risk_details: self.risk_details,
            }
        }
    }
}
impl FraudDetectionResult {
    /// Creates a new builder-style object to manufacture [`FraudDetectionResult`](crate::model::FraudDetectionResult)
    pub fn builder() -> crate::model::fraud_detection_result::Builder {
        crate::model::fraud_detection_result::Builder::default()
    }
}

/// <p>Details regarding various fraud risk analyses performed against the current session state and streamed
/// audio of the speaker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FraudRiskDetails {
    /// <p>The details resulting from 'Known Fraudster Risk' analysis of the speaker.</p>
    pub known_fraudster_risk: std::option::Option<crate::model::KnownFraudsterRisk>,
}
impl std::fmt::Debug for FraudRiskDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FraudRiskDetails");
        formatter.field("known_fraudster_risk", &self.known_fraudster_risk);
        formatter.finish()
    }
}
/// See [`FraudRiskDetails`](crate::model::FraudRiskDetails)
pub mod fraud_risk_details {
    /// A builder for [`FraudRiskDetails`](crate::model::FraudRiskDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) known_fraudster_risk: std::option::Option<crate::model::KnownFraudsterRisk>,
    }
    impl Builder {
        /// <p>The details resulting from 'Known Fraudster Risk' analysis of the speaker.</p>
        pub fn known_fraudster_risk(mut self, input: crate::model::KnownFraudsterRisk) -> Self {
            self.known_fraudster_risk = Some(input);
            self
        }
        /// <p>The details resulting from 'Known Fraudster Risk' analysis of the speaker.</p>
        pub fn set_known_fraudster_risk(
            mut self,
            input: std::option::Option<crate::model::KnownFraudsterRisk>,
        ) -> Self {
            self.known_fraudster_risk = input;
            self
        }
        /// Consumes the builder and constructs a [`FraudRiskDetails`](crate::model::FraudRiskDetails)
        pub fn build(self) -> crate::model::FraudRiskDetails {
            crate::model::FraudRiskDetails {
                known_fraudster_risk: self.known_fraudster_risk,
            }
        }
    }
}
impl FraudRiskDetails {
    /// Creates a new builder-style object to manufacture [`FraudRiskDetails`](crate::model::FraudRiskDetails)
    pub fn builder() -> crate::model::fraud_risk_details::Builder {
        crate::model::fraud_risk_details::Builder::default()
    }
}

/// <p>Contains details produced as a result of performing known fraudster risk analysis on a speaker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KnownFraudsterRisk {
    /// <p>The score indicating the likelihood the speaker is a known fraudster.</p>
    pub risk_score: std::option::Option<i32>,
    /// <p>The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters
    /// registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is
    /// <code>null</code>.</p>
    pub generated_fraudster_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KnownFraudsterRisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KnownFraudsterRisk");
        formatter.field("risk_score", &self.risk_score);
        formatter.field("generated_fraudster_id", &self.generated_fraudster_id);
        formatter.finish()
    }
}
/// See [`KnownFraudsterRisk`](crate::model::KnownFraudsterRisk)
pub mod known_fraudster_risk {
    /// A builder for [`KnownFraudsterRisk`](crate::model::KnownFraudsterRisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) risk_score: std::option::Option<i32>,
        pub(crate) generated_fraudster_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The score indicating the likelihood the speaker is a known fraudster.</p>
        pub fn risk_score(mut self, input: i32) -> Self {
            self.risk_score = Some(input);
            self
        }
        /// <p>The score indicating the likelihood the speaker is a known fraudster.</p>
        pub fn set_risk_score(mut self, input: std::option::Option<i32>) -> Self {
            self.risk_score = input;
            self
        }
        /// <p>The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters
        /// registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is
        /// <code>null</code>.</p>
        pub fn generated_fraudster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_fraudster_id = Some(input.into());
            self
        }
        /// <p>The identifier of the fraudster that is the closest match to the speaker. If there are no fraudsters
        /// registered in a given domain, or if there are no fraudsters with a non-zero RiskScore, this value is
        /// <code>null</code>.</p>
        pub fn set_generated_fraudster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_fraudster_id = input;
            self
        }
        /// Consumes the builder and constructs a [`KnownFraudsterRisk`](crate::model::KnownFraudsterRisk)
        pub fn build(self) -> crate::model::KnownFraudsterRisk {
            crate::model::KnownFraudsterRisk {
                risk_score: self.risk_score,
                generated_fraudster_id: self.generated_fraudster_id,
            }
        }
    }
}
impl KnownFraudsterRisk {
    /// Creates a new builder-style object to manufacture [`KnownFraudsterRisk`](crate::model::KnownFraudsterRisk)
    pub fn builder() -> crate::model::known_fraudster_risk::Builder {
        crate::model::known_fraudster_risk::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FraudDetectionReason {
    #[allow(missing_docs)] // documentation missing in model
    KnownFraudster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FraudDetectionReason {
    fn from(s: &str) -> Self {
        match s {
            "KNOWN_FRAUDSTER" => FraudDetectionReason::KnownFraudster,
            other => FraudDetectionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FraudDetectionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FraudDetectionReason::from(s))
    }
}
impl FraudDetectionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FraudDetectionReason::KnownFraudster => "KNOWN_FRAUDSTER",
            FraudDetectionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KNOWN_FRAUDSTER"]
    }
}
impl AsRef<str> for FraudDetectionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FraudDetectionDecision {
    #[allow(missing_docs)] // documentation missing in model
    HighRisk,
    #[allow(missing_docs)] // documentation missing in model
    LowRisk,
    #[allow(missing_docs)] // documentation missing in model
    NotEnoughSpeech,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FraudDetectionDecision {
    fn from(s: &str) -> Self {
        match s {
            "HIGH_RISK" => FraudDetectionDecision::HighRisk,
            "LOW_RISK" => FraudDetectionDecision::LowRisk,
            "NOT_ENOUGH_SPEECH" => FraudDetectionDecision::NotEnoughSpeech,
            other => FraudDetectionDecision::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FraudDetectionDecision {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FraudDetectionDecision::from(s))
    }
}
impl FraudDetectionDecision {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FraudDetectionDecision::HighRisk => "HIGH_RISK",
            FraudDetectionDecision::LowRisk => "LOW_RISK",
            FraudDetectionDecision::NotEnoughSpeech => "NOT_ENOUGH_SPEECH",
            FraudDetectionDecision::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH_RISK", "LOW_RISK", "NOT_ENOUGH_SPEECH"]
    }
}
impl AsRef<str> for FraudDetectionDecision {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration used for performing fraud detection over a speaker during a session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FraudDetectionConfiguration {
    /// <p>Threshold value for determining whether the speaker is a fraudster. If the detected risk score
    /// calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.</p>
    pub risk_threshold: std::option::Option<i32>,
}
impl std::fmt::Debug for FraudDetectionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FraudDetectionConfiguration");
        formatter.field("risk_threshold", &self.risk_threshold);
        formatter.finish()
    }
}
/// See [`FraudDetectionConfiguration`](crate::model::FraudDetectionConfiguration)
pub mod fraud_detection_configuration {
    /// A builder for [`FraudDetectionConfiguration`](crate::model::FraudDetectionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) risk_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Threshold value for determining whether the speaker is a fraudster. If the detected risk score
        /// calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.</p>
        pub fn risk_threshold(mut self, input: i32) -> Self {
            self.risk_threshold = Some(input);
            self
        }
        /// <p>Threshold value for determining whether the speaker is a fraudster. If the detected risk score
        /// calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.</p>
        pub fn set_risk_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.risk_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`FraudDetectionConfiguration`](crate::model::FraudDetectionConfiguration)
        pub fn build(self) -> crate::model::FraudDetectionConfiguration {
            crate::model::FraudDetectionConfiguration {
                risk_threshold: self.risk_threshold,
            }
        }
    }
}
impl FraudDetectionConfiguration {
    /// Creates a new builder-style object to manufacture [`FraudDetectionConfiguration`](crate::model::FraudDetectionConfiguration)
    pub fn builder() -> crate::model::fraud_detection_configuration::Builder {
        crate::model::fraud_detection_configuration::Builder::default()
    }
}

/// <p>The authentication result produced by Voice ID, processed against the current session state and streamed
/// audio of the speaker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationResult {
    /// <p>The unique identifier for this authentication result. Because there can be multiple authentications
    /// for a given session, this field helps to identify if the returned result is from a previous streaming
    /// activity or a new result. Note that in absence of any new streaming activity,
    /// <code>AcceptanceThreshold</code> changes, or <code>SpeakerId</code> changes, Voice ID
    /// always returns cached Authentication Result for this API.</p>
    pub authentication_result_id: std::option::Option<std::string::String>,
    /// <p>A timestamp indicating when audio aggregation started for this authentication result.</p>
    pub audio_aggregation_started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp indicating when audio aggregation ended for this authentication result.</p>
    pub audio_aggregation_ended_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The client-provided identifier for the speaker whose authentication result is produced. Only present if a
    /// <code>SpeakerId</code> is provided for the session.</p>
    pub customer_speaker_id: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the speaker whose authentication result is produced.</p>
    pub generated_speaker_id: std::option::Option<std::string::String>,
    /// <p>The authentication decision produced by Voice ID, processed against the current session state and streamed
    /// audio of the speaker.</p>
    pub decision: std::option::Option<crate::model::AuthenticationDecision>,
    /// <p>The authentication score for the speaker whose authentication result is produced. This value is
    /// only present if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.</p>
    pub score: std::option::Option<i32>,
    /// <p>The <code>AuthenticationConfiguration</code> used to generate this authentication result.</p>
    pub configuration: std::option::Option<crate::model::AuthenticationConfiguration>,
}
impl std::fmt::Debug for AuthenticationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationResult");
        formatter.field("authentication_result_id", &self.authentication_result_id);
        formatter.field(
            "audio_aggregation_started_at",
            &self.audio_aggregation_started_at,
        );
        formatter.field(
            "audio_aggregation_ended_at",
            &self.audio_aggregation_ended_at,
        );
        formatter.field("customer_speaker_id", &"*** Sensitive Data Redacted ***");
        formatter.field("generated_speaker_id", &self.generated_speaker_id);
        formatter.field("decision", &self.decision);
        formatter.field("score", &self.score);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`AuthenticationResult`](crate::model::AuthenticationResult)
pub mod authentication_result {
    /// A builder for [`AuthenticationResult`](crate::model::AuthenticationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_result_id: std::option::Option<std::string::String>,
        pub(crate) audio_aggregation_started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) audio_aggregation_ended_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) customer_speaker_id: std::option::Option<std::string::String>,
        pub(crate) generated_speaker_id: std::option::Option<std::string::String>,
        pub(crate) decision: std::option::Option<crate::model::AuthenticationDecision>,
        pub(crate) score: std::option::Option<i32>,
        pub(crate) configuration: std::option::Option<crate::model::AuthenticationConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier for this authentication result. Because there can be multiple authentications
        /// for a given session, this field helps to identify if the returned result is from a previous streaming
        /// activity or a new result. Note that in absence of any new streaming activity,
        /// <code>AcceptanceThreshold</code> changes, or <code>SpeakerId</code> changes, Voice ID
        /// always returns cached Authentication Result for this API.</p>
        pub fn authentication_result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_result_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for this authentication result. Because there can be multiple authentications
        /// for a given session, this field helps to identify if the returned result is from a previous streaming
        /// activity or a new result. Note that in absence of any new streaming activity,
        /// <code>AcceptanceThreshold</code> changes, or <code>SpeakerId</code> changes, Voice ID
        /// always returns cached Authentication Result for this API.</p>
        pub fn set_authentication_result_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_result_id = input;
            self
        }
        /// <p>A timestamp indicating when audio aggregation started for this authentication result.</p>
        pub fn audio_aggregation_started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.audio_aggregation_started_at = Some(input);
            self
        }
        /// <p>A timestamp indicating when audio aggregation started for this authentication result.</p>
        pub fn set_audio_aggregation_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.audio_aggregation_started_at = input;
            self
        }
        /// <p>A timestamp indicating when audio aggregation ended for this authentication result.</p>
        pub fn audio_aggregation_ended_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.audio_aggregation_ended_at = Some(input);
            self
        }
        /// <p>A timestamp indicating when audio aggregation ended for this authentication result.</p>
        pub fn set_audio_aggregation_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.audio_aggregation_ended_at = input;
            self
        }
        /// <p>The client-provided identifier for the speaker whose authentication result is produced. Only present if a
        /// <code>SpeakerId</code> is provided for the session.</p>
        pub fn customer_speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_speaker_id = Some(input.into());
            self
        }
        /// <p>The client-provided identifier for the speaker whose authentication result is produced. Only present if a
        /// <code>SpeakerId</code> is provided for the session.</p>
        pub fn set_customer_speaker_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_speaker_id = input;
            self
        }
        /// <p>The service-generated identifier for the speaker whose authentication result is produced.</p>
        pub fn generated_speaker_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_speaker_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the speaker whose authentication result is produced.</p>
        pub fn set_generated_speaker_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_speaker_id = input;
            self
        }
        /// <p>The authentication decision produced by Voice ID, processed against the current session state and streamed
        /// audio of the speaker.</p>
        pub fn decision(mut self, input: crate::model::AuthenticationDecision) -> Self {
            self.decision = Some(input);
            self
        }
        /// <p>The authentication decision produced by Voice ID, processed against the current session state and streamed
        /// audio of the speaker.</p>
        pub fn set_decision(
            mut self,
            input: std::option::Option<crate::model::AuthenticationDecision>,
        ) -> Self {
            self.decision = input;
            self
        }
        /// <p>The authentication score for the speaker whose authentication result is produced. This value is
        /// only present if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.</p>
        pub fn score(mut self, input: i32) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The authentication score for the speaker whose authentication result is produced. This value is
        /// only present if the authentication decision is either <code>ACCEPT</code> or <code>REJECT</code>.</p>
        pub fn set_score(mut self, input: std::option::Option<i32>) -> Self {
            self.score = input;
            self
        }
        /// <p>The <code>AuthenticationConfiguration</code> used to generate this authentication result.</p>
        pub fn configuration(mut self, input: crate::model::AuthenticationConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The <code>AuthenticationConfiguration</code> used to generate this authentication result.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::AuthenticationConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationResult`](crate::model::AuthenticationResult)
        pub fn build(self) -> crate::model::AuthenticationResult {
            crate::model::AuthenticationResult {
                authentication_result_id: self.authentication_result_id,
                audio_aggregation_started_at: self.audio_aggregation_started_at,
                audio_aggregation_ended_at: self.audio_aggregation_ended_at,
                customer_speaker_id: self.customer_speaker_id,
                generated_speaker_id: self.generated_speaker_id,
                decision: self.decision,
                score: self.score,
                configuration: self.configuration,
            }
        }
    }
}
impl AuthenticationResult {
    /// Creates a new builder-style object to manufacture [`AuthenticationResult`](crate::model::AuthenticationResult)
    pub fn builder() -> crate::model::authentication_result::Builder {
        crate::model::authentication_result::Builder::default()
    }
}

/// <p>The configuration used to authenticate a speaker during a session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationConfiguration {
    /// <p>The minimum threshold needed to successfully authenticate a speaker.</p>
    pub acceptance_threshold: std::option::Option<i32>,
}
impl std::fmt::Debug for AuthenticationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationConfiguration");
        formatter.field("acceptance_threshold", &self.acceptance_threshold);
        formatter.finish()
    }
}
/// See [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
pub mod authentication_configuration {
    /// A builder for [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acceptance_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum threshold needed to successfully authenticate a speaker.</p>
        pub fn acceptance_threshold(mut self, input: i32) -> Self {
            self.acceptance_threshold = Some(input);
            self
        }
        /// <p>The minimum threshold needed to successfully authenticate a speaker.</p>
        pub fn set_acceptance_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.acceptance_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
        pub fn build(self) -> crate::model::AuthenticationConfiguration {
            crate::model::AuthenticationConfiguration {
                acceptance_threshold: self.acceptance_threshold,
            }
        }
    }
}
impl AuthenticationConfiguration {
    /// Creates a new builder-style object to manufacture [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
    pub fn builder() -> crate::model::authentication_configuration::Builder {
        crate::model::authentication_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationDecision {
    #[allow(missing_docs)] // documentation missing in model
    Accept,
    #[allow(missing_docs)] // documentation missing in model
    NotEnoughSpeech,
    #[allow(missing_docs)] // documentation missing in model
    Reject,
    #[allow(missing_docs)] // documentation missing in model
    SpeakerIdNotProvided,
    #[allow(missing_docs)] // documentation missing in model
    SpeakerNotEnrolled,
    #[allow(missing_docs)] // documentation missing in model
    SpeakerOptedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationDecision {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPT" => AuthenticationDecision::Accept,
            "NOT_ENOUGH_SPEECH" => AuthenticationDecision::NotEnoughSpeech,
            "REJECT" => AuthenticationDecision::Reject,
            "SPEAKER_ID_NOT_PROVIDED" => AuthenticationDecision::SpeakerIdNotProvided,
            "SPEAKER_NOT_ENROLLED" => AuthenticationDecision::SpeakerNotEnrolled,
            "SPEAKER_OPTED_OUT" => AuthenticationDecision::SpeakerOptedOut,
            other => AuthenticationDecision::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationDecision {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationDecision::from(s))
    }
}
impl AuthenticationDecision {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationDecision::Accept => "ACCEPT",
            AuthenticationDecision::NotEnoughSpeech => "NOT_ENOUGH_SPEECH",
            AuthenticationDecision::Reject => "REJECT",
            AuthenticationDecision::SpeakerIdNotProvided => "SPEAKER_ID_NOT_PROVIDED",
            AuthenticationDecision::SpeakerNotEnrolled => "SPEAKER_NOT_ENROLLED",
            AuthenticationDecision::SpeakerOptedOut => "SPEAKER_OPTED_OUT",
            AuthenticationDecision::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCEPT",
            "NOT_ENOUGH_SPEECH",
            "REJECT",
            "SPEAKER_ID_NOT_PROVIDED",
            "SPEAKER_NOT_ENROLLED",
            "SPEAKER_OPTED_OUT",
        ]
    }
}
impl AsRef<str> for AuthenticationDecision {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Ended,
    #[allow(missing_docs)] // documentation missing in model
    Ongoing,
    #[allow(missing_docs)] // documentation missing in model
    PendingConfiguration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamingStatus {
    fn from(s: &str) -> Self {
        match s {
            "ENDED" => StreamingStatus::Ended,
            "ONGOING" => StreamingStatus::Ongoing,
            "PENDING_CONFIGURATION" => StreamingStatus::PendingConfiguration,
            other => StreamingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamingStatus::from(s))
    }
}
impl StreamingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamingStatus::Ended => "ENDED",
            StreamingStatus::Ongoing => "ONGOING",
            StreamingStatus::PendingConfiguration => "PENDING_CONFIGURATION",
            StreamingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENDED", "ONGOING", "PENDING_CONFIGURATION"]
    }
}
impl AsRef<str> for StreamingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains all the information about a fraudster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Fraudster {
    /// <p>The identifier for the domain containing the fraudster.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The service-generated identifier for the fraudster.</p>
    pub generated_fraudster_id: std::option::Option<std::string::String>,
    /// <p>The timestamp when Voice ID identified the fraudster.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Fraudster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Fraudster");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("generated_fraudster_id", &self.generated_fraudster_id);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`Fraudster`](crate::model::Fraudster)
pub mod fraudster {
    /// A builder for [`Fraudster`](crate::model::Fraudster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) generated_fraudster_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier for the domain containing the fraudster.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The identifier for the domain containing the fraudster.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The service-generated identifier for the fraudster.</p>
        pub fn generated_fraudster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_fraudster_id = Some(input.into());
            self
        }
        /// <p>The service-generated identifier for the fraudster.</p>
        pub fn set_generated_fraudster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generated_fraudster_id = input;
            self
        }
        /// <p>The timestamp when Voice ID identified the fraudster.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when Voice ID identified the fraudster.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Fraudster`](crate::model::Fraudster)
        pub fn build(self) -> crate::model::Fraudster {
            crate::model::Fraudster {
                domain_id: self.domain_id,
                generated_fraudster_id: self.generated_fraudster_id,
                created_at: self.created_at,
            }
        }
    }
}
impl Fraudster {
    /// Creates a new builder-style object to manufacture [`Fraudster`](crate::model::Fraudster)
    pub fn builder() -> crate::model::fraudster::Builder {
        crate::model::fraudster::Builder::default()
    }
}
