// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Translate
///
/// Client for invoking operations on Amazon Translate. Each operation on Amazon Translate is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_translate::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_translate::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_translate::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateParallelData`](crate::client::fluent_builders::CreateParallelData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateParallelData::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateParallelData::set_name): <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateParallelData::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateParallelData::set_description): <p>A custom description for the parallel data resource in Amazon Translate.</p>
    ///   - [`parallel_data_config(ParallelDataConfig)`](crate::client::fluent_builders::CreateParallelData::parallel_data_config) / [`set_parallel_data_config(Option<ParallelDataConfig>)`](crate::client::fluent_builders::CreateParallelData::set_parallel_data_config): <p>Specifies the format and S3 location of the parallel data input file.</p>
    ///   - [`encryption_key(EncryptionKey)`](crate::client::fluent_builders::CreateParallelData::encryption_key) / [`set_encryption_key(Option<EncryptionKey>)`](crate::client::fluent_builders::CreateParallelData::set_encryption_key): <p>The encryption key used to encrypt this object.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateParallelData::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateParallelData::set_client_token): <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    /// - On success, responds with [`CreateParallelDataOutput`](crate::output::CreateParallelDataOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateParallelDataOutput::name): <p>The custom name that you assigned to the parallel data resource.</p>
    ///   - [`status(Option<ParallelDataStatus>)`](crate::output::CreateParallelDataOutput::status): <p>The status of the parallel data resource. When the resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    /// - On failure, responds with [`SdkError<CreateParallelDataError>`](crate::error::CreateParallelDataError)
    pub fn create_parallel_data(&self) -> fluent_builders::CreateParallelData {
        fluent_builders::CreateParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteParallelData`](crate::client::fluent_builders::DeleteParallelData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteParallelData::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteParallelData::set_name): <p>The name of the parallel data resource that is being deleted.</p>
    /// - On success, responds with [`DeleteParallelDataOutput`](crate::output::DeleteParallelDataOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DeleteParallelDataOutput::name): <p>The name of the parallel data resource that is being deleted.</p>
    ///   - [`status(Option<ParallelDataStatus>)`](crate::output::DeleteParallelDataOutput::status): <p>The status of the parallel data deletion.</p>
    /// - On failure, responds with [`SdkError<DeleteParallelDataError>`](crate::error::DeleteParallelDataError)
    pub fn delete_parallel_data(&self) -> fluent_builders::DeleteParallelData {
        fluent_builders::DeleteParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTerminology`](crate::client::fluent_builders::DeleteTerminology) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteTerminology::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteTerminology::set_name): <p>The name of the custom terminology being deleted. </p>
    /// - On success, responds with [`DeleteTerminologyOutput`](crate::output::DeleteTerminologyOutput)

    /// - On failure, responds with [`SdkError<DeleteTerminologyError>`](crate::error::DeleteTerminologyError)
    pub fn delete_terminology(&self) -> fluent_builders::DeleteTerminology {
        fluent_builders::DeleteTerminology::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTextTranslationJob`](crate::client::fluent_builders::DescribeTextTranslationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTextTranslationJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeTextTranslationJob::set_job_id): <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
    /// - On success, responds with [`DescribeTextTranslationJobOutput`](crate::output::DescribeTextTranslationJobOutput) with field(s):
    ///   - [`text_translation_job_properties(Option<TextTranslationJobProperties>)`](crate::output::DescribeTextTranslationJobOutput::text_translation_job_properties): <p>An object that contains the properties associated with an asynchronous batch translation job.</p>
    /// - On failure, responds with [`SdkError<DescribeTextTranslationJobError>`](crate::error::DescribeTextTranslationJobError)
    pub fn describe_text_translation_job(&self) -> fluent_builders::DescribeTextTranslationJob {
        fluent_builders::DescribeTextTranslationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetParallelData`](crate::client::fluent_builders::GetParallelData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetParallelData::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetParallelData::set_name): <p>The name of the parallel data resource that is being retrieved.</p>
    /// - On success, responds with [`GetParallelDataOutput`](crate::output::GetParallelDataOutput) with field(s):
    ///   - [`parallel_data_properties(Option<ParallelDataProperties>)`](crate::output::GetParallelDataOutput::parallel_data_properties): <p>The properties of the parallel data resource that is being retrieved.</p>
    ///   - [`data_location(Option<ParallelDataDataLocation>)`](crate::output::GetParallelDataOutput::data_location): <p>The Amazon S3 location of the most recent parallel data input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30 minute expiration.</p> <important>   <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks. </p>   <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>   <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>  </important>
    ///   - [`auxiliary_data_location(Option<ParallelDataDataLocation>)`](crate::output::GetParallelDataOutput::auxiliary_data_location): <p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a parallel data resource. The location is returned as a presigned URL to that has a 30 minute expiration.</p>
    ///   - [`latest_update_attempt_auxiliary_data_location(Option<ParallelDataDataLocation>)`](crate::output::GetParallelDataOutput::latest_update_attempt_auxiliary_data_location): <p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to update a parallel data resource. The location is returned as a presigned URL to that has a 30 minute expiration.</p>
    /// - On failure, responds with [`SdkError<GetParallelDataError>`](crate::error::GetParallelDataError)
    pub fn get_parallel_data(&self) -> fluent_builders::GetParallelData {
        fluent_builders::GetParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTerminology`](crate::client::fluent_builders::GetTerminology) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetTerminology::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetTerminology::set_name): <p>The name of the custom terminology being retrieved.</p>
    ///   - [`terminology_data_format(TerminologyDataFormat)`](crate::client::fluent_builders::GetTerminology::terminology_data_format) / [`set_terminology_data_format(Option<TerminologyDataFormat>)`](crate::client::fluent_builders::GetTerminology::set_terminology_data_format): <p>The data format of the custom terminology being retrieved.</p>  <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>  <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    /// - On success, responds with [`GetTerminologyOutput`](crate::output::GetTerminologyOutput) with field(s):
    ///   - [`terminology_properties(Option<TerminologyProperties>)`](crate::output::GetTerminologyOutput::terminology_properties): <p>The properties of the custom terminology being retrieved.</p>
    ///   - [`terminology_data_location(Option<TerminologyDataLocation>)`](crate::output::GetTerminologyOutput::terminology_data_location): <p>The Amazon S3 location of the most recent custom terminology input file that was successfully imported into Amazon Translate. The location is returned as a presigned URL that has a 30 minute expiration.</p> <important>   <p>Amazon Translate doesn't scan all input files for the risk of CSV injection attacks. </p>   <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the program might interpret the record as a formula and run the code within it.</p>   <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>  </important>
    ///   - [`auxiliary_data_location(Option<TerminologyDataLocation>)`](crate::output::GetTerminologyOutput::auxiliary_data_location): <p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a presigned URL to that has a 30 minute expiration.</p>
    /// - On failure, responds with [`SdkError<GetTerminologyError>`](crate::error::GetTerminologyError)
    pub fn get_terminology(&self) -> fluent_builders::GetTerminology {
        fluent_builders::GetTerminology::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportTerminology`](crate::client::fluent_builders::ImportTerminology) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ImportTerminology::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ImportTerminology::set_name): <p>The name of the custom terminology being imported.</p>
    ///   - [`merge_strategy(MergeStrategy)`](crate::client::fluent_builders::ImportTerminology::merge_strategy) / [`set_merge_strategy(Option<MergeStrategy>)`](crate::client::fluent_builders::ImportTerminology::set_merge_strategy): <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ImportTerminology::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ImportTerminology::set_description): <p>The description of the custom terminology being imported.</p>
    ///   - [`terminology_data(TerminologyData)`](crate::client::fluent_builders::ImportTerminology::terminology_data) / [`set_terminology_data(Option<TerminologyData>)`](crate::client::fluent_builders::ImportTerminology::set_terminology_data): <p>The terminology data for the custom terminology being imported.</p>
    ///   - [`encryption_key(EncryptionKey)`](crate::client::fluent_builders::ImportTerminology::encryption_key) / [`set_encryption_key(Option<EncryptionKey>)`](crate::client::fluent_builders::ImportTerminology::set_encryption_key): <p>The encryption key for the custom terminology being imported.</p>
    /// - On success, responds with [`ImportTerminologyOutput`](crate::output::ImportTerminologyOutput) with field(s):
    ///   - [`terminology_properties(Option<TerminologyProperties>)`](crate::output::ImportTerminologyOutput::terminology_properties): <p>The properties of the custom terminology being imported.</p>
    ///   - [`auxiliary_data_location(Option<TerminologyDataLocation>)`](crate::output::ImportTerminologyOutput::auxiliary_data_location): <p>The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a presigned URL to that has a 30 minute expiration.</p>
    /// - On failure, responds with [`SdkError<ImportTerminologyError>`](crate::error::ImportTerminologyError)
    pub fn import_terminology(&self) -> fluent_builders::ImportTerminology {
        fluent_builders::ImportTerminology::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListParallelData`](crate::client::fluent_builders::ListParallelData) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListParallelData::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListParallelData::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListParallelData::set_next_token): <p>A string that specifies the next page of results to return in a paginated response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListParallelData::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListParallelData::set_max_results): <p>The maximum number of parallel data resources returned for each request.</p>
    /// - On success, responds with [`ListParallelDataOutput`](crate::output::ListParallelDataOutput) with field(s):
    ///   - [`parallel_data_properties_list(Option<Vec<ParallelDataProperties>>)`](crate::output::ListParallelDataOutput::parallel_data_properties_list): <p>The properties of the parallel data resources returned by this request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListParallelDataOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListParallelDataError>`](crate::error::ListParallelDataError)
    pub fn list_parallel_data(&self) -> fluent_builders::ListParallelData {
        fluent_builders::ListParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTerminologies`](crate::client::fluent_builders::ListTerminologies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTerminologies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTerminologies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTerminologies::set_next_token): <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTerminologies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTerminologies::set_max_results): <p>The maximum number of custom terminologies returned per list request.</p>
    /// - On success, responds with [`ListTerminologiesOutput`](crate::output::ListTerminologiesOutput) with field(s):
    ///   - [`terminology_properties_list(Option<Vec<TerminologyProperties>>)`](crate::output::ListTerminologiesOutput::terminology_properties_list): <p>The properties list of the custom terminologies returned on the list request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTerminologiesOutput::next_token): <p> If the response to the ListTerminologies was truncated, the NextToken fetches the next group of custom terminologies.</p>
    /// - On failure, responds with [`SdkError<ListTerminologiesError>`](crate::error::ListTerminologiesError)
    pub fn list_terminologies(&self) -> fluent_builders::ListTerminologies {
        fluent_builders::ListTerminologies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTextTranslationJobs`](crate::client::fluent_builders::ListTextTranslationJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTextTranslationJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(TextTranslationJobFilter)`](crate::client::fluent_builders::ListTextTranslationJobs::filter) / [`set_filter(Option<TextTranslationJobFilter>)`](crate::client::fluent_builders::ListTextTranslationJobs::set_filter): <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTextTranslationJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTextTranslationJobs::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTextTranslationJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTextTranslationJobs::set_max_results): <p>The maximum number of results to return in each page. The default value is 100.</p>
    /// - On success, responds with [`ListTextTranslationJobsOutput`](crate::output::ListTextTranslationJobsOutput) with field(s):
    ///   - [`text_translation_job_properties_list(Option<Vec<TextTranslationJobProperties>>)`](crate::output::ListTextTranslationJobsOutput::text_translation_job_properties_list): <p>A list containing the properties of each job that is returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTextTranslationJobsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTextTranslationJobsError>`](crate::error::ListTextTranslationJobsError)
    pub fn list_text_translation_jobs(&self) -> fluent_builders::ListTextTranslationJobs {
        fluent_builders::ListTextTranslationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTextTranslationJob`](crate::client::fluent_builders::StartTextTranslationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartTextTranslationJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartTextTranslationJob::set_job_name): <p>The name of the batch translation job to be performed.</p>
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartTextTranslationJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartTextTranslationJob::set_input_data_config): <p>Specifies the format and S3 location of the input documents for the translation job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartTextTranslationJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartTextTranslationJob::set_output_data_config): <p>Specifies the S3 folder to which your job output will be saved. </p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartTextTranslationJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartTextTranslationJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
    ///   - [`source_language_code(impl Into<String>)`](crate::client::fluent_builders::StartTextTranslationJob::source_language_code) / [`set_source_language_code(Option<String>)`](crate::client::fluent_builders::StartTextTranslationJob::set_source_language_code): <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>  <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
    ///   - [`target_language_codes(Vec<String>)`](crate::client::fluent_builders::StartTextTranslationJob::target_language_codes) / [`set_target_language_codes(Option<Vec<String>>)`](crate::client::fluent_builders::StartTextTranslationJob::set_target_language_codes): <p>The language code of the output language.</p>
    ///   - [`terminology_names(Vec<String>)`](crate::client::fluent_builders::StartTextTranslationJob::terminology_names) / [`set_terminology_names(Option<Vec<String>>)`](crate::client::fluent_builders::StartTextTranslationJob::set_terminology_names): <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>  <p>This parameter accepts only one custom terminology resource.</p>  <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>  <p>For more information, see <code>how-custom-terminology</code>.</p>
    ///   - [`parallel_data_names(Vec<String>)`](crate::client::fluent_builders::StartTextTranslationJob::parallel_data_names) / [`set_parallel_data_names(Option<Vec<String>>)`](crate::client::fluent_builders::StartTextTranslationJob::set_parallel_data_names): <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>  <p>This parameter accepts only one parallel data resource.</p> <note>   <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>  </note>  <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>  <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartTextTranslationJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartTextTranslationJob::set_client_token): <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
    ///   - [`settings(TranslationSettings)`](crate::client::fluent_builders::StartTextTranslationJob::settings) / [`set_settings(Option<TranslationSettings>)`](crate::client::fluent_builders::StartTextTranslationJob::set_settings): <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
    /// - On success, responds with [`StartTextTranslationJobOutput`](crate::output::StartTextTranslationJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartTextTranslationJobOutput::job_id): <p>The identifier generated for the job. To get the status of a job, use this ID with the <code>DescribeTextTranslationJob</code> operation.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartTextTranslationJobOutput::job_status): <p>The status of the job. Possible values include:</p>  <ul>   <li> <p> <code>SUBMITTED</code> - The job has been received and is queued for processing.</p> </li>   <li> <p> <code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p> </li>   <li> <p> <code>COMPLETED</code> - The job was successfully completed and the output is available.</p> </li>   <li> <p> <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can be analyzed in the job's output.</p> </li>   <li> <p> <code>FAILED</code> - The job did not complete. To get details, use the <code>DescribeTextTranslationJob</code> operation.</p> </li>   <li> <p> <code>STOP_REQUESTED</code> - The user who started the job has requested that it be stopped.</p> </li>   <li> <p> <code>STOPPED</code> - The job has been stopped.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<StartTextTranslationJobError>`](crate::error::StartTextTranslationJobError)
    pub fn start_text_translation_job(&self) -> fluent_builders::StartTextTranslationJob {
        fluent_builders::StartTextTranslationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopTextTranslationJob`](crate::client::fluent_builders::StopTextTranslationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::StopTextTranslationJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::StopTextTranslationJob::set_job_id): <p>The job ID of the job to be stopped.</p>
    /// - On success, responds with [`StopTextTranslationJobOutput`](crate::output::StopTextTranslationJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StopTextTranslationJobOutput::job_id): <p>The job ID of the stopped batch translation job.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StopTextTranslationJobOutput::job_status): <p>The status of the designated job. Upon successful completion, the job's status will be <code>STOPPED</code>.</p>
    /// - On failure, responds with [`SdkError<StopTextTranslationJobError>`](crate::error::StopTextTranslationJobError)
    pub fn stop_text_translation_job(&self) -> fluent_builders::StopTextTranslationJob {
        fluent_builders::StopTextTranslationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TranslateText`](crate::client::fluent_builders::TranslateText) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::TranslateText::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::TranslateText::set_text): <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
    ///   - [`terminology_names(Vec<String>)`](crate::client::fluent_builders::TranslateText::terminology_names) / [`set_terminology_names(Option<Vec<String>>)`](crate::client::fluent_builders::TranslateText::set_terminology_names): <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
    ///   - [`source_language_code(impl Into<String>)`](crate::client::fluent_builders::TranslateText::source_language_code) / [`set_source_language_code(Option<String>)`](crate::client::fluent_builders::TranslateText::set_source_language_code): <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>  <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
    ///   - [`target_language_code(impl Into<String>)`](crate::client::fluent_builders::TranslateText::target_language_code) / [`set_target_language_code(Option<String>)`](crate::client::fluent_builders::TranslateText::set_target_language_code): <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
    ///   - [`settings(TranslationSettings)`](crate::client::fluent_builders::TranslateText::settings) / [`set_settings(Option<TranslationSettings>)`](crate::client::fluent_builders::TranslateText::set_settings): <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
    /// - On success, responds with [`TranslateTextOutput`](crate::output::TranslateTextOutput) with field(s):
    ///   - [`translated_text(Option<String>)`](crate::output::TranslateTextOutput::translated_text): <p>The translated text.</p>
    ///   - [`source_language_code(Option<String>)`](crate::output::TranslateTextOutput::source_language_code): <p>The language code for the language of the source text.</p>
    ///   - [`target_language_code(Option<String>)`](crate::output::TranslateTextOutput::target_language_code): <p>The language code for the language of the target text. </p>
    ///   - [`applied_terminologies(Option<Vec<AppliedTerminology>>)`](crate::output::TranslateTextOutput::applied_terminologies): <p>The names of the custom terminologies applied to the input text by Amazon Translate for the translated text response.</p>
    ///   - [`applied_settings(Option<TranslationSettings>)`](crate::output::TranslateTextOutput::applied_settings): <p>Settings that configure the translation output.</p>
    /// - On failure, responds with [`SdkError<TranslateTextError>`](crate::error::TranslateTextError)
    pub fn translate_text(&self) -> fluent_builders::TranslateText {
        fluent_builders::TranslateText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateParallelData`](crate::client::fluent_builders::UpdateParallelData) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateParallelData::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateParallelData::set_name): <p>The name of the parallel data resource being updated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateParallelData::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateParallelData::set_description): <p>A custom description for the parallel data resource in Amazon Translate.</p>
    ///   - [`parallel_data_config(ParallelDataConfig)`](crate::client::fluent_builders::UpdateParallelData::parallel_data_config) / [`set_parallel_data_config(Option<ParallelDataConfig>)`](crate::client::fluent_builders::UpdateParallelData::set_parallel_data_config): <p>Specifies the format and S3 location of the parallel data input file.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateParallelData::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateParallelData::set_client_token): <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    /// - On success, responds with [`UpdateParallelDataOutput`](crate::output::UpdateParallelDataOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::UpdateParallelDataOutput::name): <p>The name of the parallel data resource being updated.</p>
    ///   - [`status(Option<ParallelDataStatus>)`](crate::output::UpdateParallelDataOutput::status): <p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>
    ///   - [`latest_update_attempt_status(Option<ParallelDataStatus>)`](crate::output::UpdateParallelDataOutput::latest_update_attempt_status): <p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    ///   - [`latest_update_attempt_at(Option<DateTime>)`](crate::output::UpdateParallelDataOutput::latest_update_attempt_at): <p>The time that the most recent update was attempted.</p>
    /// - On failure, responds with [`SdkError<UpdateParallelDataError>`](crate::error::UpdateParallelDataError)
    pub fn update_parallel_data(&self) -> fluent_builders::UpdateParallelData {
        fluent_builders::UpdateParallelData::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateParallelData`.
    ///
    /// <p>Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data files contain examples that show how you want segments of text to be translated. By adding parallel data, you can influence the style, tone, and word choice in your translation output.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateParallelData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_parallel_data_input::Builder,
    }
    impl CreateParallelData {
        /// Creates a new `CreateParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateParallelDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, input: crate::model::ParallelDataConfig) -> Self {
            self.inner = self.inner.parallel_data_config(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_parallel_data_config(input);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.inner = self.inner.encryption_key(input);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParallelData`.
    ///
    /// <p>Deletes a parallel data resource in Amazon Translate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteParallelData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_parallel_data_input::Builder,
    }
    impl DeleteParallelData {
        /// Creates a new `DeleteParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParallelDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTerminology`.
    ///
    /// <p>A synchronous action that deletes a custom terminology.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTerminology {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_terminology_input::Builder,
    }
    impl DeleteTerminology {
        /// Creates a new `DeleteTerminology`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTerminologyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTerminologyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom terminology being deleted. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the custom terminology being deleted. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTextTranslationJob`.
    ///
    /// <p>Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTextTranslationJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_text_translation_job_input::Builder,
    }
    impl DescribeTextTranslationJob {
        /// Creates a new `DescribeTextTranslationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTextTranslationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTextTranslationJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParallelData`.
    ///
    /// <p>Provides information about a parallel data resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetParallelData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_parallel_data_input::Builder,
    }
    impl GetParallelData {
        /// Creates a new `GetParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParallelDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parallel data resource that is being retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the parallel data resource that is being retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTerminology`.
    ///
    /// <p>Retrieves a custom terminology.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTerminology {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_terminology_input::Builder,
    }
    impl GetTerminology {
        /// Creates a new `GetTerminology`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTerminologyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTerminologyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom terminology being retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the custom terminology being retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The data format of the custom terminology being retrieved.</p>
        /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>
        /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
        pub fn terminology_data_format(
            mut self,
            input: crate::model::TerminologyDataFormat,
        ) -> Self {
            self.inner = self.inner.terminology_data_format(input);
            self
        }
        /// <p>The data format of the custom terminology being retrieved.</p>
        /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>
        /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
        pub fn set_terminology_data_format(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataFormat>,
        ) -> Self {
            self.inner = self.inner.set_terminology_data_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportTerminology`.
    ///
    /// <p>Creates or updates a custom terminology, depending on whether or not one already exists for the given terminology name. Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen merge strategy. Currently, the only supported merge strategy is OVERWRITE, and so the imported terminology will overwrite an existing terminology of the same name.</p>
    /// <p>If you import a terminology that overwrites an existing one, the new terminology take up to 10 minutes to fully propagate and be available for use in a translation due to cache policies with the DataPlane service that performs the translations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportTerminology {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_terminology_input::Builder,
    }
    impl ImportTerminology {
        /// Creates a new `ImportTerminology`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportTerminologyOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportTerminologyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom terminology being imported.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the custom terminology being imported.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.inner = self.inner.merge_strategy(input);
            self
        }
        /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.inner = self.inner.set_merge_strategy(input);
            self
        }
        /// <p>The description of the custom terminology being imported.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the custom terminology being imported.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The terminology data for the custom terminology being imported.</p>
        pub fn terminology_data(mut self, input: crate::model::TerminologyData) -> Self {
            self.inner = self.inner.terminology_data(input);
            self
        }
        /// <p>The terminology data for the custom terminology being imported.</p>
        pub fn set_terminology_data(
            mut self,
            input: std::option::Option<crate::model::TerminologyData>,
        ) -> Self {
            self.inner = self.inner.set_terminology_data(input);
            self
        }
        /// <p>The encryption key for the custom terminology being imported.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.inner = self.inner.encryption_key(input);
            self
        }
        /// <p>The encryption key for the custom terminology being imported.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListParallelData`.
    ///
    /// <p>Provides a list of your parallel data resources in Amazon Translate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListParallelData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_parallel_data_input::Builder,
    }
    impl ListParallelData {
        /// Creates a new `ListParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::ListParallelDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListParallelDataPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListParallelDataPaginator {
            crate::paginator::ListParallelDataPaginator::new(self.handle, self.inner)
        }
        /// <p>A string that specifies the next page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A string that specifies the next page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of parallel data resources returned for each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of parallel data resources returned for each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTerminologies`.
    ///
    /// <p>Provides a list of custom terminologies associated with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTerminologies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_terminologies_input::Builder,
    }
    impl ListTerminologies {
        /// Creates a new `ListTerminologies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTerminologiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTerminologiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTerminologiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTerminologiesPaginator {
            crate::paginator::ListTerminologiesPaginator::new(self.handle, self.inner)
        }
        /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of custom terminologies returned per list request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of custom terminologies returned per list request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTextTranslationJobs`.
    ///
    /// <p>Gets a list of the batch translation jobs that you have submitted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTextTranslationJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_text_translation_jobs_input::Builder,
    }
    impl ListTextTranslationJobs {
        /// Creates a new `ListTextTranslationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTextTranslationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTextTranslationJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTextTranslationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTextTranslationJobsPaginator {
            crate::paginator::ListTextTranslationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::TextTranslationJobFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TextTranslationJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTextTranslationJob`.
    ///
    /// <p>Starts an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once. For more information, see <code>async</code>.</p>
    /// <p>Batch translation jobs can be described with the <code>DescribeTextTranslationJob</code> operation, listed with the <code>ListTextTranslationJobs</code> operation, and stopped with the <code>StopTextTranslationJob</code> operation.</p> <note>
    /// <p>Amazon Translate does not support batch translation of multiple source languages at once.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTextTranslationJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_text_translation_job_input::Builder,
    }
    impl StartTextTranslationJob {
        /// Creates a new `StartTextTranslationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTextTranslationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTextTranslationJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the batch translation job to be performed.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The name of the batch translation job to be performed.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>Specifies the format and S3 location of the input documents for the translation job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>Specifies the format and S3 location of the input documents for the translation job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies the S3 folder to which your job output will be saved. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies the S3 folder to which your job output will be saved. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_language_code(input.into());
            self
        }
        /// <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_language_code(input);
            self
        }
        /// Appends an item to `TargetLanguageCodes`.
        ///
        /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
        ///
        /// <p>The language code of the output language.</p>
        pub fn target_language_codes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_language_codes(input.into());
            self
        }
        /// <p>The language code of the output language.</p>
        pub fn set_target_language_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_language_codes(input);
            self
        }
        /// Appends an item to `TerminologyNames`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
        /// <p>This parameter accepts only one custom terminology resource.</p>
        /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
        /// <p>For more information, see <code>how-custom-terminology</code>.</p>
        pub fn terminology_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.terminology_names(input.into());
            self
        }
        /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
        /// <p>This parameter accepts only one custom terminology resource.</p>
        /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
        /// <p>For more information, see <code>how-custom-terminology</code>.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_terminology_names(input);
            self
        }
        /// Appends an item to `ParallelDataNames`.
        ///
        /// To override the contents of this collection use [`set_parallel_data_names`](Self::set_parallel_data_names).
        ///
        /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
        /// <p>This parameter accepts only one parallel data resource.</p> <note>
        /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
        /// </note>
        /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
        /// <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
        pub fn parallel_data_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parallel_data_names(input.into());
            self
        }
        /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
        /// <p>This parameter accepts only one parallel data resource.</p> <note>
        /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
        /// </note>
        /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
        /// <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
        pub fn set_parallel_data_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_parallel_data_names(input);
            self
        }
        /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn settings(mut self, input: crate::model::TranslationSettings) -> Self {
            self.inner = self.inner.settings(input);
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::TranslationSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTextTranslationJob`.
    ///
    /// <p>Stops an asynchronous batch translation job that is in progress.</p>
    /// <p>If the job's state is <code>IN_PROGRESS</code>, the job will be marked for termination and put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the <code>COMPLETED</code> state. Otherwise, the job is put into the <code>STOPPED</code> state.</p>
    /// <p>Asynchronous batch translation jobs are started with the <code>StartTextTranslationJob</code> operation. You can use the <code>DescribeTextTranslationJob</code> or <code>ListTextTranslationJobs</code> operations to get a batch translation job's <code>JobId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopTextTranslationJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_text_translation_job_input::Builder,
    }
    impl StopTextTranslationJob {
        /// Creates a new `StopTextTranslationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTextTranslationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTextTranslationJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job ID of the job to be stopped.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job ID of the job to be stopped.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TranslateText`.
    ///
    /// <p>Translates input text from the source language to the target language. For a list of available languages and language codes, see <code>what-is-languages</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TranslateText {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::translate_text_input::Builder,
    }
    impl TranslateText {
        /// Creates a new `TranslateText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TranslateTextOutput,
            aws_smithy_http::result::SdkError<crate::error::TranslateTextError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// Appends an item to `TerminologyNames`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
        pub fn terminology_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.terminology_names(input.into());
            self
        }
        /// <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_terminology_names(input);
            self
        }
        /// <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_language_code(input.into());
            self
        }
        /// <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_language_code(input);
            self
        }
        /// <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
        pub fn target_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_language_code(input.into());
            self
        }
        /// <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
        pub fn set_target_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_language_code(input);
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn settings(mut self, input: crate::model::TranslationSettings) -> Self {
            self.inner = self.inner.settings(input);
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::TranslationSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateParallelData`.
    ///
    /// <p>Updates a previously created parallel data resource by importing a new input file from Amazon S3.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateParallelData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_parallel_data_input::Builder,
    }
    impl UpdateParallelData {
        /// Creates a new `UpdateParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateParallelDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, input: crate::model::ParallelDataConfig) -> Self {
            self.inner = self.inner.parallel_data_config(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_parallel_data_config(input);
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
