// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateParallelDataInput`](crate::input::CreateParallelDataInput)
pub mod create_parallel_data_input {
    /// A builder for [`CreateParallelDataInput`](crate::input::CreateParallelDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parallel_data_config: std::option::Option<crate::model::ParallelDataConfig>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, input: crate::model::ParallelDataConfig) -> Self {
            self.parallel_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.parallel_data_config = input;
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateParallelDataInput`](crate::input::CreateParallelDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateParallelDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateParallelDataInput {
                name: self.name,
                description: self.description,
                parallel_data_config: self.parallel_data_config,
                encryption_key: self.encryption_key,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateParallelDataInputOperationOutputAlias = crate::operation::CreateParallelData;
#[doc(hidden)]
pub type CreateParallelDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateParallelDataInput {
    /// Consumes the builder and constructs an Operation<[`CreateParallelData`](crate::operation::CreateParallelData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateParallelData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateParallelDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateParallelDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateParallelDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.CreateParallelData",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_parallel_data(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateParallelData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateParallelData",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateParallelDataInput`](crate::input::CreateParallelDataInput)
    pub fn builder() -> crate::input::create_parallel_data_input::Builder {
        crate::input::create_parallel_data_input::Builder::default()
    }
}

/// See [`DeleteParallelDataInput`](crate::input::DeleteParallelDataInput)
pub mod delete_parallel_data_input {
    /// A builder for [`DeleteParallelDataInput`](crate::input::DeleteParallelDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParallelDataInput`](crate::input::DeleteParallelDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteParallelDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteParallelDataInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteParallelDataInputOperationOutputAlias = crate::operation::DeleteParallelData;
#[doc(hidden)]
pub type DeleteParallelDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteParallelDataInput {
    /// Consumes the builder and constructs an Operation<[`DeleteParallelData`](crate::operation::DeleteParallelData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteParallelData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteParallelDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteParallelDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteParallelDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.DeleteParallelData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_parallel_data(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteParallelData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteParallelData",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteParallelDataInput`](crate::input::DeleteParallelDataInput)
    pub fn builder() -> crate::input::delete_parallel_data_input::Builder {
        crate::input::delete_parallel_data_input::Builder::default()
    }
}

/// See [`DeleteTerminologyInput`](crate::input::DeleteTerminologyInput)
pub mod delete_terminology_input {
    /// A builder for [`DeleteTerminologyInput`](crate::input::DeleteTerminologyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the custom terminology being deleted. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom terminology being deleted. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTerminologyInput`](crate::input::DeleteTerminologyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTerminologyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTerminologyInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteTerminologyInputOperationOutputAlias = crate::operation::DeleteTerminology;
#[doc(hidden)]
pub type DeleteTerminologyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTerminologyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTerminology`](crate::operation::DeleteTerminology)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTerminology,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTerminologyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTerminologyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTerminologyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.DeleteTerminology",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_terminology(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTerminology::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTerminology",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTerminologyInput`](crate::input::DeleteTerminologyInput)
    pub fn builder() -> crate::input::delete_terminology_input::Builder {
        crate::input::delete_terminology_input::Builder::default()
    }
}

/// See [`DescribeTextTranslationJobInput`](crate::input::DescribeTextTranslationJobInput)
pub mod describe_text_translation_job_input {
    /// A builder for [`DescribeTextTranslationJobInput`](crate::input::DescribeTextTranslationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTextTranslationJobInput`](crate::input::DescribeTextTranslationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTextTranslationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTextTranslationJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTextTranslationJobInputOperationOutputAlias =
    crate::operation::DescribeTextTranslationJob;
#[doc(hidden)]
pub type DescribeTextTranslationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTextTranslationJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTextTranslationJob`](crate::operation::DescribeTextTranslationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTextTranslationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTextTranslationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTextTranslationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTextTranslationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.DescribeTextTranslationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_text_translation_job(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTextTranslationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTextTranslationJob",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTextTranslationJobInput`](crate::input::DescribeTextTranslationJobInput)
    pub fn builder() -> crate::input::describe_text_translation_job_input::Builder {
        crate::input::describe_text_translation_job_input::Builder::default()
    }
}

/// See [`GetParallelDataInput`](crate::input::GetParallelDataInput)
pub mod get_parallel_data_input {
    /// A builder for [`GetParallelDataInput`](crate::input::GetParallelDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parallel data resource that is being retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parallel data resource that is being retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParallelDataInput`](crate::input::GetParallelDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetParallelDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetParallelDataInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetParallelDataInputOperationOutputAlias = crate::operation::GetParallelData;
#[doc(hidden)]
pub type GetParallelDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetParallelDataInput {
    /// Consumes the builder and constructs an Operation<[`GetParallelData`](crate::operation::GetParallelData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetParallelData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetParallelDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetParallelDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetParallelDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.GetParallelData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_parallel_data(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetParallelData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetParallelData",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetParallelDataInput`](crate::input::GetParallelDataInput)
    pub fn builder() -> crate::input::get_parallel_data_input::Builder {
        crate::input::get_parallel_data_input::Builder::default()
    }
}

/// See [`GetTerminologyInput`](crate::input::GetTerminologyInput)
pub mod get_terminology_input {
    /// A builder for [`GetTerminologyInput`](crate::input::GetTerminologyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) terminology_data_format:
            std::option::Option<crate::model::TerminologyDataFormat>,
    }
    impl Builder {
        /// <p>The name of the custom terminology being retrieved.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom terminology being retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data format of the custom terminology being retrieved.</p>
        /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>
        /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
        pub fn terminology_data_format(
            mut self,
            input: crate::model::TerminologyDataFormat,
        ) -> Self {
            self.terminology_data_format = Some(input);
            self
        }
        /// <p>The data format of the custom terminology being retrieved.</p>
        /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>
        /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
        pub fn set_terminology_data_format(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataFormat>,
        ) -> Self {
            self.terminology_data_format = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTerminologyInput`](crate::input::GetTerminologyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTerminologyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTerminologyInput {
                name: self.name,
                terminology_data_format: self.terminology_data_format,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTerminologyInputOperationOutputAlias = crate::operation::GetTerminology;
#[doc(hidden)]
pub type GetTerminologyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTerminologyInput {
    /// Consumes the builder and constructs an Operation<[`GetTerminology`](crate::operation::GetTerminology)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTerminology,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTerminologyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTerminologyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTerminologyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.GetTerminology",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_terminology(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTerminology::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTerminology",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTerminologyInput`](crate::input::GetTerminologyInput)
    pub fn builder() -> crate::input::get_terminology_input::Builder {
        crate::input::get_terminology_input::Builder::default()
    }
}

/// See [`ImportTerminologyInput`](crate::input::ImportTerminologyInput)
pub mod import_terminology_input {
    /// A builder for [`ImportTerminologyInput`](crate::input::ImportTerminologyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) terminology_data: std::option::Option<crate::model::TerminologyData>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
    }
    impl Builder {
        /// <p>The name of the custom terminology being imported.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom terminology being imported.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The description of the custom terminology being imported.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the custom terminology being imported.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The terminology data for the custom terminology being imported.</p>
        pub fn terminology_data(mut self, input: crate::model::TerminologyData) -> Self {
            self.terminology_data = Some(input);
            self
        }
        /// <p>The terminology data for the custom terminology being imported.</p>
        pub fn set_terminology_data(
            mut self,
            input: std::option::Option<crate::model::TerminologyData>,
        ) -> Self {
            self.terminology_data = input;
            self
        }
        /// <p>The encryption key for the custom terminology being imported.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key for the custom terminology being imported.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportTerminologyInput`](crate::input::ImportTerminologyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportTerminologyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportTerminologyInput {
                name: self.name,
                merge_strategy: self.merge_strategy,
                description: self.description,
                terminology_data: self.terminology_data,
                encryption_key: self.encryption_key,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportTerminologyInputOperationOutputAlias = crate::operation::ImportTerminology;
#[doc(hidden)]
pub type ImportTerminologyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportTerminologyInput {
    /// Consumes the builder and constructs an Operation<[`ImportTerminology`](crate::operation::ImportTerminology)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportTerminology,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportTerminologyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportTerminologyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportTerminologyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.ImportTerminology",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_terminology(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportTerminology::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportTerminology",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportTerminologyInput`](crate::input::ImportTerminologyInput)
    pub fn builder() -> crate::input::import_terminology_input::Builder {
        crate::input::import_terminology_input::Builder::default()
    }
}

/// See [`ListParallelDataInput`](crate::input::ListParallelDataInput)
pub mod list_parallel_data_input {
    /// A builder for [`ListParallelDataInput`](crate::input::ListParallelDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A string that specifies the next page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A string that specifies the next page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of parallel data resources returned for each request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of parallel data resources returned for each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListParallelDataInput`](crate::input::ListParallelDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListParallelDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListParallelDataInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListParallelDataInputOperationOutputAlias = crate::operation::ListParallelData;
#[doc(hidden)]
pub type ListParallelDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListParallelDataInput {
    /// Consumes the builder and constructs an Operation<[`ListParallelData`](crate::operation::ListParallelData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListParallelData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListParallelDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListParallelDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListParallelDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.ListParallelData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_parallel_data(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListParallelData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListParallelData",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListParallelDataInput`](crate::input::ListParallelDataInput)
    pub fn builder() -> crate::input::list_parallel_data_input::Builder {
        crate::input::list_parallel_data_input::Builder::default()
    }
}

/// See [`ListTerminologiesInput`](crate::input::ListTerminologiesInput)
pub mod list_terminologies_input {
    /// A builder for [`ListTerminologiesInput`](crate::input::ListTerminologiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of custom terminologies returned per list request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of custom terminologies returned per list request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTerminologiesInput`](crate::input::ListTerminologiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTerminologiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTerminologiesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTerminologiesInputOperationOutputAlias = crate::operation::ListTerminologies;
#[doc(hidden)]
pub type ListTerminologiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTerminologiesInput {
    /// Consumes the builder and constructs an Operation<[`ListTerminologies`](crate::operation::ListTerminologies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTerminologies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTerminologiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTerminologiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTerminologiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.ListTerminologies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_terminologies(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTerminologies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTerminologies",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTerminologiesInput`](crate::input::ListTerminologiesInput)
    pub fn builder() -> crate::input::list_terminologies_input::Builder {
        crate::input::list_terminologies_input::Builder::default()
    }
}

/// See [`ListTextTranslationJobsInput`](crate::input::ListTextTranslationJobsInput)
pub mod list_text_translation_jobs_input {
    /// A builder for [`ListTextTranslationJobsInput`](crate::input::ListTextTranslationJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::TextTranslationJobFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
        pub fn filter(mut self, input: crate::model::TextTranslationJobFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TextTranslationJobFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in each page. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTextTranslationJobsInput`](crate::input::ListTextTranslationJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTextTranslationJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTextTranslationJobsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTextTranslationJobsInputOperationOutputAlias =
    crate::operation::ListTextTranslationJobs;
#[doc(hidden)]
pub type ListTextTranslationJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTextTranslationJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListTextTranslationJobs`](crate::operation::ListTextTranslationJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTextTranslationJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTextTranslationJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTextTranslationJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTextTranslationJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.ListTextTranslationJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_text_translation_jobs(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTextTranslationJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTextTranslationJobs",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTextTranslationJobsInput`](crate::input::ListTextTranslationJobsInput)
    pub fn builder() -> crate::input::list_text_translation_jobs_input::Builder {
        crate::input::list_text_translation_jobs_input::Builder::default()
    }
}

/// See [`StartTextTranslationJobInput`](crate::input::StartTextTranslationJobInput)
pub mod start_text_translation_job_input {
    /// A builder for [`StartTextTranslationJobInput`](crate::input::StartTextTranslationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) terminology_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parallel_data_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<crate::model::TranslationSettings>,
    }
    impl Builder {
        /// <p>The name of the batch translation job to be performed.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the batch translation job to be performed.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Specifies the format and S3 location of the input documents for the translation job.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and S3 location of the input documents for the translation job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies the S3 folder to which your job output will be saved. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies the S3 folder to which your job output will be saved. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// Appends an item to `target_language_codes`.
        ///
        /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
        ///
        /// <p>The language code of the output language.</p>
        pub fn target_language_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_language_codes.unwrap_or_default();
            v.push(input.into());
            self.target_language_codes = Some(v);
            self
        }
        /// <p>The language code of the output language.</p>
        pub fn set_target_language_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_language_codes = input;
            self
        }
        /// Appends an item to `terminology_names`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
        /// <p>This parameter accepts only one custom terminology resource.</p>
        /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
        /// <p>For more information, see <code>how-custom-terminology</code>.</p>
        pub fn terminology_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.terminology_names.unwrap_or_default();
            v.push(input.into());
            self.terminology_names = Some(v);
            self
        }
        /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
        /// <p>This parameter accepts only one custom terminology resource.</p>
        /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
        /// <p>For more information, see <code>how-custom-terminology</code>.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.terminology_names = input;
            self
        }
        /// Appends an item to `parallel_data_names`.
        ///
        /// To override the contents of this collection use [`set_parallel_data_names`](Self::set_parallel_data_names).
        ///
        /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
        /// <p>This parameter accepts only one parallel data resource.</p> <note>
        /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
        /// </note>
        /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
        /// <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
        pub fn parallel_data_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parallel_data_names.unwrap_or_default();
            v.push(input.into());
            self.parallel_data_names = Some(v);
            self
        }
        /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
        /// <p>This parameter accepts only one parallel data resource.</p> <note>
        /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
        /// </note>
        /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
        /// <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
        pub fn set_parallel_data_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parallel_data_names = input;
            self
        }
        /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn settings(mut self, input: crate::model::TranslationSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::TranslationSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTextTranslationJobInput`](crate::input::StartTextTranslationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartTextTranslationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartTextTranslationJobInput {
                job_name: self.job_name,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                source_language_code: self.source_language_code,
                target_language_codes: self.target_language_codes,
                terminology_names: self.terminology_names,
                parallel_data_names: self.parallel_data_names,
                client_token: self.client_token,
                settings: self.settings,
            })
        }
    }
}
#[doc(hidden)]
pub type StartTextTranslationJobInputOperationOutputAlias =
    crate::operation::StartTextTranslationJob;
#[doc(hidden)]
pub type StartTextTranslationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartTextTranslationJobInput {
    /// Consumes the builder and constructs an Operation<[`StartTextTranslationJob`](crate::operation::StartTextTranslationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartTextTranslationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartTextTranslationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartTextTranslationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartTextTranslationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.StartTextTranslationJob",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_text_translation_job(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartTextTranslationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartTextTranslationJob",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartTextTranslationJobInput`](crate::input::StartTextTranslationJobInput)
    pub fn builder() -> crate::input::start_text_translation_job_input::Builder {
        crate::input::start_text_translation_job_input::Builder::default()
    }
}

/// See [`StopTextTranslationJobInput`](crate::input::StopTextTranslationJobInput)
pub mod stop_text_translation_job_input {
    /// A builder for [`StopTextTranslationJobInput`](crate::input::StopTextTranslationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job ID of the job to be stopped.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID of the job to be stopped.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTextTranslationJobInput`](crate::input::StopTextTranslationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopTextTranslationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopTextTranslationJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopTextTranslationJobInputOperationOutputAlias = crate::operation::StopTextTranslationJob;
#[doc(hidden)]
pub type StopTextTranslationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopTextTranslationJobInput {
    /// Consumes the builder and constructs an Operation<[`StopTextTranslationJob`](crate::operation::StopTextTranslationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopTextTranslationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopTextTranslationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopTextTranslationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopTextTranslationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.StopTextTranslationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_text_translation_job(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopTextTranslationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopTextTranslationJob",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopTextTranslationJobInput`](crate::input::StopTextTranslationJobInput)
    pub fn builder() -> crate::input::stop_text_translation_job_input::Builder {
        crate::input::stop_text_translation_job_input::Builder::default()
    }
}

/// See [`TranslateTextInput`](crate::input::TranslateTextInput)
pub mod translate_text_input {
    /// A builder for [`TranslateTextInput`](crate::input::TranslateTextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) terminology_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_code: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<crate::model::TranslationSettings>,
    }
    impl Builder {
        /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `terminology_names`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
        pub fn terminology_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.terminology_names.unwrap_or_default();
            v.push(input.into());
            self.terminology_names = Some(v);
            self
        }
        /// <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.terminology_names = input;
            self
        }
        /// <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>
        /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
        pub fn target_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_language_code = Some(input.into());
            self
        }
        /// <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
        pub fn set_target_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_language_code = input;
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn settings(mut self, input: crate::model::TranslationSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::TranslationSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`TranslateTextInput`](crate::input::TranslateTextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TranslateTextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TranslateTextInput {
                text: self.text,
                terminology_names: self.terminology_names,
                source_language_code: self.source_language_code,
                target_language_code: self.target_language_code,
                settings: self.settings,
            })
        }
    }
}
#[doc(hidden)]
pub type TranslateTextInputOperationOutputAlias = crate::operation::TranslateText;
#[doc(hidden)]
pub type TranslateTextInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TranslateTextInput {
    /// Consumes the builder and constructs an Operation<[`TranslateText`](crate::operation::TranslateText)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TranslateText,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TranslateTextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TranslateTextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TranslateTextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.TranslateText",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_translate_text(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TranslateText::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TranslateText",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TranslateTextInput`](crate::input::TranslateTextInput)
    pub fn builder() -> crate::input::translate_text_input::Builder {
        crate::input::translate_text_input::Builder::default()
    }
}

/// See [`UpdateParallelDataInput`](crate::input::UpdateParallelDataInput)
pub mod update_parallel_data_input {
    /// A builder for [`UpdateParallelDataInput`](crate::input::UpdateParallelDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parallel_data_config: std::option::Option<crate::model::ParallelDataConfig>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, input: crate::model::ParallelDataConfig) -> Self {
            self.parallel_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.parallel_data_config = input;
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateParallelDataInput`](crate::input::UpdateParallelDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateParallelDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateParallelDataInput {
                name: self.name,
                description: self.description,
                parallel_data_config: self.parallel_data_config,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateParallelDataInputOperationOutputAlias = crate::operation::UpdateParallelData;
#[doc(hidden)]
pub type UpdateParallelDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateParallelDataInput {
    /// Consumes the builder and constructs an Operation<[`UpdateParallelData`](crate::operation::UpdateParallelData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateParallelData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateParallelDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateParallelDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateParallelDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSShineFrontendService_20170701.UpdateParallelData",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_parallel_data(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateParallelData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateParallelData",
            "translate",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateParallelDataInput`](crate::input::UpdateParallelDataInput)
    pub fn builder() -> crate::input::update_parallel_data_input::Builder {
        crate::input::update_parallel_data_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateParallelDataInput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub parallel_data_config: std::option::Option<crate::model::ParallelDataConfig>,
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateParallelDataInput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub fn parallel_data_config(&self) -> std::option::Option<&crate::model::ParallelDataConfig> {
        self.parallel_data_config.as_ref()
    }
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateParallelDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateParallelDataInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("parallel_data_config", &self.parallel_data_config);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TranslateTextInput {
    /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
    pub terminology_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
    pub target_language_code: std::option::Option<std::string::String>,
    /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
    pub settings: std::option::Option<crate::model::TranslationSettings>,
}
impl TranslateTextInput {
    /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on your character set, this may be fewer than 5,000 characters.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The name of the terminology list file to be used in the TranslateText request. You can use 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can contain a maximum of 256 terms.</p>
    pub fn terminology_names(&self) -> std::option::Option<&[std::string::String]> {
        self.terminology_names.as_deref()
    }
    /// <p>The language code for the language of the source text. The language must be a language supported by Amazon Translate. For a list of language codes, see <code>what-is-languages</code>.</p>
    /// <p>To have Amazon Translate determine the source language of your text, you can specify <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon Comprehend</a> to determine the source language.</p>
    pub fn source_language_code(&self) -> std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language code requested for the language of the target text. The language must be a language supported by Amazon Translate.</p>
    pub fn target_language_code(&self) -> std::option::Option<&str> {
        self.target_language_code.as_deref()
    }
    /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
    pub fn settings(&self) -> std::option::Option<&crate::model::TranslationSettings> {
        self.settings.as_ref()
    }
}
impl std::fmt::Debug for TranslateTextInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TranslateTextInput");
        formatter.field("text", &self.text);
        formatter.field("terminology_names", &self.terminology_names);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_code", &self.target_language_code);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTextTranslationJobInput {
    /// <p>The job ID of the job to be stopped.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl StopTextTranslationJobInput {
    /// <p>The job ID of the job to be stopped.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for StopTextTranslationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTextTranslationJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTextTranslationJobInput {
    /// <p>The name of the batch translation job to be performed.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Specifies the format and S3 location of the input documents for the translation job.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>Specifies the S3 folder to which your job output will be saved. </p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>
    /// <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language code of the output language.</p>
    pub target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
    /// <p>This parameter accepts only one custom terminology resource.</p>
    /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
    /// <p>For more information, see <code>how-custom-terminology</code>.</p>
    pub terminology_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
    /// <p>This parameter accepts only one parallel data resource.</p> <note>
    /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
    /// </note>
    /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
    /// <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
    pub parallel_data_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
    pub settings: std::option::Option<crate::model::TranslationSettings>,
}
impl StartTextTranslationJobInput {
    /// <p>The name of the batch translation job to be performed.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Specifies the format and S3 location of the input documents for the translation job.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>Specifies the S3 folder to which your job output will be saved. </p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate read access to your input data. For more information, see <code>identity-and-access-management</code>.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>The language code of the input language. For a list of language codes, see <code>what-is-languages</code>.</p>
    /// <p>Amazon Translate does not automatically detect a source language during batch translation jobs.</p>
    pub fn source_language_code(&self) -> std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language code of the output language.</p>
    pub fn target_language_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.target_language_codes.as_deref()
    }
    /// <p>The name of a custom terminology resource to add to the translation job. This resource lists examples source terms and the desired translation for each term.</p>
    /// <p>This parameter accepts only one custom terminology resource.</p>
    /// <p>For a list of available custom terminology resources, use the <code>ListTerminologies</code> operation.</p>
    /// <p>For more information, see <code>how-custom-terminology</code>.</p>
    pub fn terminology_names(&self) -> std::option::Option<&[std::string::String]> {
        self.terminology_names.as_deref()
    }
    /// <p>The name of a parallel data resource to add to the translation job. This resource consists of examples that show how you want segments of text to be translated. When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
    /// <p>This parameter accepts only one parallel data resource.</p> <note>
    /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
    /// </note>
    /// <p>For a list of available parallel data resources, use the <code>ListParallelData</code> operation.</p>
    /// <p>For more information, see <code>customizing-translations-parallel-data</code>.</p>
    pub fn parallel_data_names(&self) -> std::option::Option<&[std::string::String]> {
        self.parallel_data_names.as_deref()
    }
    /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Settings to configure your translation output, including the option to mask profane words and phrases.</p>
    pub fn settings(&self) -> std::option::Option<&crate::model::TranslationSettings> {
        self.settings.as_ref()
    }
}
impl std::fmt::Debug for StartTextTranslationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTextTranslationJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_codes", &self.target_language_codes);
        formatter.field("terminology_names", &self.terminology_names);
        formatter.field("parallel_data_names", &self.parallel_data_names);
        formatter.field("client_token", &self.client_token);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTextTranslationJobsInput {
    /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
    pub filter: std::option::Option<crate::model::TextTranslationJobFilter>,
    /// <p>The token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in each page. The default value is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTextTranslationJobsInput {
    /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job name, job status, and submission time. You can only set one filter at a time.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::TextTranslationJobFilter> {
        self.filter.as_ref()
    }
    /// <p>The token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in each page. The default value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTextTranslationJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTextTranslationJobsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTerminologiesInput {
    /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of custom terminologies returned per list request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTerminologiesInput {
    /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to fetch the next group of custom terminologies. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of custom terminologies returned per list request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTerminologiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTerminologiesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListParallelDataInput {
    /// <p>A string that specifies the next page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of parallel data resources returned for each request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListParallelDataInput {
    /// <p>A string that specifies the next page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of parallel data resources returned for each request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListParallelDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListParallelDataInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportTerminologyInput {
    /// <p>The name of the custom terminology being imported.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The description of the custom terminology being imported.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The terminology data for the custom terminology being imported.</p>
    pub terminology_data: std::option::Option<crate::model::TerminologyData>,
    /// <p>The encryption key for the custom terminology being imported.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
}
impl ImportTerminologyInput {
    /// <p>The name of the custom terminology being imported.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is supported. In this case, the imported terminology will overwrite an existing terminology of the same name.</p>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>The description of the custom terminology being imported.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The terminology data for the custom terminology being imported.</p>
    pub fn terminology_data(&self) -> std::option::Option<&crate::model::TerminologyData> {
        self.terminology_data.as_ref()
    }
    /// <p>The encryption key for the custom terminology being imported.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
}
impl std::fmt::Debug for ImportTerminologyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportTerminologyInput");
        formatter.field("name", &self.name);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("description", &self.description);
        formatter.field("terminology_data", &self.terminology_data);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTerminologyInput {
    /// <p>The name of the custom terminology being retrieved.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub terminology_data_format: std::option::Option<crate::model::TerminologyDataFormat>,
}
impl GetTerminologyInput {
    /// <p>The name of the custom terminology being retrieved.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The data format of the custom terminology being retrieved.</p>
    /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same format as the file that was imported to create the terminology. </p>
    /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the same format as that of the input file that was imported to create it. Otherwise, Amazon Translate throws an error.</p>
    pub fn terminology_data_format(
        &self,
    ) -> std::option::Option<&crate::model::TerminologyDataFormat> {
        self.terminology_data_format.as_ref()
    }
}
impl std::fmt::Debug for GetTerminologyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTerminologyInput");
        formatter.field("name", &self.name);
        formatter.field("terminology_data_format", &self.terminology_data_format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParallelDataInput {
    /// <p>The name of the parallel data resource that is being retrieved.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetParallelDataInput {
    /// <p>The name of the parallel data resource that is being retrieved.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetParallelDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParallelDataInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTextTranslationJobInput {
    /// <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeTextTranslationJobInput {
    /// <p>The identifier that Amazon Translate generated for the job. The <code>StartTextTranslationJob</code> operation returns this identifier in its response.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTextTranslationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTextTranslationJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTerminologyInput {
    /// <p>The name of the custom terminology being deleted. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteTerminologyInput {
    /// <p>The name of the custom terminology being deleted. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTerminologyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTerminologyInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParallelDataInput {
    /// <p>The name of the parallel data resource that is being deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteParallelDataInput {
    /// <p>The name of the parallel data resource that is being deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteParallelDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParallelDataInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateParallelDataInput {
    /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub parallel_data_config: std::option::Option<crate::model::ParallelDataConfig>,
    /// <p>The encryption key used to encrypt this object.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateParallelDataInput {
    /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the account and region.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub fn parallel_data_config(&self) -> std::option::Option<&crate::model::ParallelDataConfig> {
        self.parallel_data_config.as_ref()
    }
    /// <p>The encryption key used to encrypt this object.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
    /// <p>A unique identifier for the request. This token is automatically generated when you use Amazon Translate through an AWS SDK.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateParallelDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateParallelDataInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("parallel_data_config", &self.parallel_data_config);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
