// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParallelDataStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParallelDataStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ParallelDataStatus::Active,
            "CREATING" => ParallelDataStatus::Creating,
            "DELETING" => ParallelDataStatus::Deleting,
            "FAILED" => ParallelDataStatus::Failed,
            "UPDATING" => ParallelDataStatus::Updating,
            other => ParallelDataStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParallelDataStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParallelDataStatus::from(s))
    }
}
impl ParallelDataStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParallelDataStatus::Active => "ACTIVE",
            ParallelDataStatus::Creating => "CREATING",
            ParallelDataStatus::Deleting => "DELETING",
            ParallelDataStatus::Failed => "FAILED",
            ParallelDataStatus::Updating => "UPDATING",
            ParallelDataStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for ParallelDataStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the format and S3 location of the parallel data input file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParallelDataConfig {
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder
    /// must be in the same Region as the API endpoint you are calling.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>The format of the parallel data input file.</p>
    pub format: std::option::Option<crate::model::ParallelDataFormat>,
}
impl ParallelDataConfig {
    /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder
    /// must be in the same Region as the API endpoint you are calling.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The format of the parallel data input file.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::ParallelDataFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for ParallelDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParallelDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`ParallelDataConfig`](crate::model::ParallelDataConfig)
pub mod parallel_data_config {
    /// A builder for [`ParallelDataConfig`](crate::model::ParallelDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::ParallelDataFormat>,
    }
    impl Builder {
        /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder
        /// must be in the same Region as the API endpoint you are calling.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The URI of the Amazon S3 folder that contains the parallel data input file. The folder
        /// must be in the same Region as the API endpoint you are calling.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>The format of the parallel data input file.</p>
        pub fn format(mut self, input: crate::model::ParallelDataFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the parallel data input file.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ParallelDataFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`ParallelDataConfig`](crate::model::ParallelDataConfig)
        pub fn build(self) -> crate::model::ParallelDataConfig {
            crate::model::ParallelDataConfig {
                s3_uri: self.s3_uri,
                format: self.format,
            }
        }
    }
}
impl ParallelDataConfig {
    /// Creates a new builder-style object to manufacture [`ParallelDataConfig`](crate::model::ParallelDataConfig)
    pub fn builder() -> crate::model::parallel_data_config::Builder {
        crate::model::parallel_data_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParallelDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Tmx,
    #[allow(missing_docs)] // documentation missing in model
    Tsv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParallelDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => ParallelDataFormat::Csv,
            "TMX" => ParallelDataFormat::Tmx,
            "TSV" => ParallelDataFormat::Tsv,
            other => ParallelDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParallelDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParallelDataFormat::from(s))
    }
}
impl ParallelDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParallelDataFormat::Csv => "CSV",
            ParallelDataFormat::Tmx => "TMX",
            ParallelDataFormat::Tsv => "TSV",
            ParallelDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "TMX", "TSV"]
    }
}
impl AsRef<str> for ParallelDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings that configure the translation output.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TranslationSettings {
    /// <p>Enable the profanity setting if you want Amazon Translate to mask profane words and
    /// phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string
    /// “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the
    /// length or number of words.</p>
    /// <p>Amazon Translate does not detect profanity in all of its supported languages. For
    /// languages that support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported
    /// Languages and Language Codes in the Amazon Translate Developer Guide</a>.</p>
    pub profanity: std::option::Option<crate::model::Profanity>,
}
impl TranslationSettings {
    /// <p>Enable the profanity setting if you want Amazon Translate to mask profane words and
    /// phrases in your translation output.</p>
    /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string
    /// “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the
    /// length or number of words.</p>
    /// <p>Amazon Translate does not detect profanity in all of its supported languages. For
    /// languages that support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported
    /// Languages and Language Codes in the Amazon Translate Developer Guide</a>.</p>
    pub fn profanity(&self) -> std::option::Option<&crate::model::Profanity> {
        self.profanity.as_ref()
    }
}
impl std::fmt::Debug for TranslationSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TranslationSettings");
        formatter.field("profanity", &self.profanity);
        formatter.finish()
    }
}
/// See [`TranslationSettings`](crate::model::TranslationSettings)
pub mod translation_settings {
    /// A builder for [`TranslationSettings`](crate::model::TranslationSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profanity: std::option::Option<crate::model::Profanity>,
    }
    impl Builder {
        /// <p>Enable the profanity setting if you want Amazon Translate to mask profane words and
        /// phrases in your translation output.</p>
        /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string
        /// “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the
        /// length or number of words.</p>
        /// <p>Amazon Translate does not detect profanity in all of its supported languages. For
        /// languages that support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported
        /// Languages and Language Codes in the Amazon Translate Developer Guide</a>.</p>
        pub fn profanity(mut self, input: crate::model::Profanity) -> Self {
            self.profanity = Some(input);
            self
        }
        /// <p>Enable the profanity setting if you want Amazon Translate to mask profane words and
        /// phrases in your translation output.</p>
        /// <p>To mask profane words and phrases, Amazon Translate replaces them with the grawlix string
        /// “?$#@$“. This 5-character sequence is used for each profane word or phrase, regardless of the
        /// length or number of words.</p>
        /// <p>Amazon Translate does not detect profanity in all of its supported languages. For
        /// languages that support profanity detection, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported
        /// Languages and Language Codes in the Amazon Translate Developer Guide</a>.</p>
        pub fn set_profanity(
            mut self,
            input: std::option::Option<crate::model::Profanity>,
        ) -> Self {
            self.profanity = input;
            self
        }
        /// Consumes the builder and constructs a [`TranslationSettings`](crate::model::TranslationSettings)
        pub fn build(self) -> crate::model::TranslationSettings {
            crate::model::TranslationSettings {
                profanity: self.profanity,
            }
        }
    }
}
impl TranslationSettings {
    /// Creates a new builder-style object to manufacture [`TranslationSettings`](crate::model::TranslationSettings)
    pub fn builder() -> crate::model::translation_settings::Builder {
        crate::model::translation_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Profanity {
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Profanity {
    fn from(s: &str) -> Self {
        match s {
            "MASK" => Profanity::Mask,
            other => Profanity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Profanity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Profanity::from(s))
    }
}
impl Profanity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Profanity::Mask => "MASK",
            Profanity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MASK"]
    }
}
impl AsRef<str> for Profanity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The custom terminology applied to the input text by Amazon Translate for the translated text
/// response. This is optional in the response and will only be present if you specified
/// terminology input in the request. Currently, only one terminology can be applied per
/// TranslateText request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppliedTerminology {
    /// <p>The name of the custom terminology applied to the input text by Amazon Translate for the translated
    /// text response.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The specific terms of the custom terminology applied to the input text by Amazon Translate for the
    /// translated text response. A maximum of 250 terms will be returned, and the specific terms
    /// applied will be the first 250 terms in the source text. </p>
    pub terms: std::option::Option<std::vec::Vec<crate::model::Term>>,
}
impl AppliedTerminology {
    /// <p>The name of the custom terminology applied to the input text by Amazon Translate for the translated
    /// text response.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The specific terms of the custom terminology applied to the input text by Amazon Translate for the
    /// translated text response. A maximum of 250 terms will be returned, and the specific terms
    /// applied will be the first 250 terms in the source text. </p>
    pub fn terms(&self) -> std::option::Option<&[crate::model::Term]> {
        self.terms.as_deref()
    }
}
impl std::fmt::Debug for AppliedTerminology {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppliedTerminology");
        formatter.field("name", &self.name);
        formatter.field("terms", &self.terms);
        formatter.finish()
    }
}
/// See [`AppliedTerminology`](crate::model::AppliedTerminology)
pub mod applied_terminology {
    /// A builder for [`AppliedTerminology`](crate::model::AppliedTerminology)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) terms: std::option::Option<std::vec::Vec<crate::model::Term>>,
    }
    impl Builder {
        /// <p>The name of the custom terminology applied to the input text by Amazon Translate for the translated
        /// text response.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom terminology applied to the input text by Amazon Translate for the translated
        /// text response.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `terms`.
        ///
        /// To override the contents of this collection use [`set_terms`](Self::set_terms).
        ///
        /// <p>The specific terms of the custom terminology applied to the input text by Amazon Translate for the
        /// translated text response. A maximum of 250 terms will be returned, and the specific terms
        /// applied will be the first 250 terms in the source text. </p>
        pub fn terms(mut self, input: impl Into<crate::model::Term>) -> Self {
            let mut v = self.terms.unwrap_or_default();
            v.push(input.into());
            self.terms = Some(v);
            self
        }
        /// <p>The specific terms of the custom terminology applied to the input text by Amazon Translate for the
        /// translated text response. A maximum of 250 terms will be returned, and the specific terms
        /// applied will be the first 250 terms in the source text. </p>
        pub fn set_terms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Term>>,
        ) -> Self {
            self.terms = input;
            self
        }
        /// Consumes the builder and constructs a [`AppliedTerminology`](crate::model::AppliedTerminology)
        pub fn build(self) -> crate::model::AppliedTerminology {
            crate::model::AppliedTerminology {
                name: self.name,
                terms: self.terms,
            }
        }
    }
}
impl AppliedTerminology {
    /// Creates a new builder-style object to manufacture [`AppliedTerminology`](crate::model::AppliedTerminology)
    pub fn builder() -> crate::model::applied_terminology::Builder {
        crate::model::applied_terminology::Builder::default()
    }
}

/// <p>The term being translated by the custom terminology.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Term {
    /// <p>The source text of the term being translated by the custom terminology.</p>
    pub source_text: std::option::Option<std::string::String>,
    /// <p>The target text of the term being translated by the custom terminology.</p>
    pub target_text: std::option::Option<std::string::String>,
}
impl Term {
    /// <p>The source text of the term being translated by the custom terminology.</p>
    pub fn source_text(&self) -> std::option::Option<&str> {
        self.source_text.as_deref()
    }
    /// <p>The target text of the term being translated by the custom terminology.</p>
    pub fn target_text(&self) -> std::option::Option<&str> {
        self.target_text.as_deref()
    }
}
impl std::fmt::Debug for Term {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Term");
        formatter.field("source_text", &self.source_text);
        formatter.field("target_text", &self.target_text);
        formatter.finish()
    }
}
/// See [`Term`](crate::model::Term)
pub mod term {
    /// A builder for [`Term`](crate::model::Term)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_text: std::option::Option<std::string::String>,
        pub(crate) target_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source text of the term being translated by the custom terminology.</p>
        pub fn source_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_text = Some(input.into());
            self
        }
        /// <p>The source text of the term being translated by the custom terminology.</p>
        pub fn set_source_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_text = input;
            self
        }
        /// <p>The target text of the term being translated by the custom terminology.</p>
        pub fn target_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_text = Some(input.into());
            self
        }
        /// <p>The target text of the term being translated by the custom terminology.</p>
        pub fn set_target_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_text = input;
            self
        }
        /// Consumes the builder and constructs a [`Term`](crate::model::Term)
        pub fn build(self) -> crate::model::Term {
            crate::model::Term {
                source_text: self.source_text,
                target_text: self.target_text,
            }
        }
    }
}
impl Term {
    /// Creates a new builder-style object to manufacture [`Term`](crate::model::Term)
    pub fn builder() -> crate::model::term::Builder {
        crate::model::term::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithError,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    StopRequested,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatus::Completed,
            "COMPLETED_WITH_ERROR" => JobStatus::CompletedWithError,
            "FAILED" => JobStatus::Failed,
            "IN_PROGRESS" => JobStatus::InProgress,
            "STOPPED" => JobStatus::Stopped,
            "STOP_REQUESTED" => JobStatus::StopRequested,
            "SUBMITTED" => JobStatus::Submitted,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Completed => "COMPLETED",
            JobStatus::CompletedWithError => "COMPLETED_WITH_ERROR",
            JobStatus::Failed => "FAILED",
            JobStatus::InProgress => "IN_PROGRESS",
            JobStatus::Stopped => "STOPPED",
            JobStatus::StopRequested => "STOP_REQUESTED",
            JobStatus::Submitted => "SUBMITTED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "COMPLETED_WITH_ERROR",
            "FAILED",
            "IN_PROGRESS",
            "STOPPED",
            "STOP_REQUESTED",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The output configuration properties for a batch translation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputDataConfig {
    /// <p>The URI of the S3 folder that contains a translation job's output file. The folder must
    /// be in the same Region as the API endpoint that you are calling.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>The encryption key used to encrypt this object.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
}
impl OutputDataConfig {
    /// <p>The URI of the S3 folder that contains a translation job's output file. The folder must
    /// be in the same Region as the API endpoint that you are calling.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The encryption key used to encrypt this object.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
}
impl std::fmt::Debug for OutputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}
/// See [`OutputDataConfig`](crate::model::OutputDataConfig)
pub mod output_data_config {
    /// A builder for [`OutputDataConfig`](crate::model::OutputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
    }
    impl Builder {
        /// <p>The URI of the S3 folder that contains a translation job's output file. The folder must
        /// be in the same Region as the API endpoint that you are calling.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 folder that contains a translation job's output file. The folder must
        /// be in the same Region as the API endpoint that you are calling.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputDataConfig`](crate::model::OutputDataConfig)
        pub fn build(self) -> crate::model::OutputDataConfig {
            crate::model::OutputDataConfig {
                s3_uri: self.s3_uri,
                encryption_key: self.encryption_key,
            }
        }
    }
}
impl OutputDataConfig {
    /// Creates a new builder-style object to manufacture [`OutputDataConfig`](crate::model::OutputDataConfig)
    pub fn builder() -> crate::model::output_data_config::Builder {
        crate::model::output_data_config::Builder::default()
    }
}

/// <p>The encryption key used to encrypt this object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionKey {
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    pub r#type: std::option::Option<crate::model::EncryptionKeyType>,
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    pub id: std::option::Option<std::string::String>,
}
impl EncryptionKey {
    /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EncryptionKeyType> {
        self.r#type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for EncryptionKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionKey");
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`EncryptionKey`](crate::model::EncryptionKey)
pub mod encryption_key {
    /// A builder for [`EncryptionKey`](crate::model::EncryptionKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::EncryptionKeyType>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
        pub fn r#type(mut self, input: crate::model::EncryptionKeyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of encryption key used by Amazon Translate to encrypt this object.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionKeyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the encryption key being used to encrypt this object.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionKey`](crate::model::EncryptionKey)
        pub fn build(self) -> crate::model::EncryptionKey {
            crate::model::EncryptionKey {
                r#type: self.r#type,
                id: self.id,
            }
        }
    }
}
impl EncryptionKey {
    /// Creates a new builder-style object to manufacture [`EncryptionKey`](crate::model::EncryptionKey)
    pub fn builder() -> crate::model::encryption_key::Builder {
        crate::model::encryption_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionKeyType {
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionKeyType {
    fn from(s: &str) -> Self {
        match s {
            "KMS" => EncryptionKeyType::Kms,
            other => EncryptionKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionKeyType::from(s))
    }
}
impl EncryptionKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionKeyType::Kms => "KMS",
            EncryptionKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KMS"]
    }
}
impl AsRef<str> for EncryptionKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The input configuration properties for requesting a batch translation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDataConfig {
    /// <p>The URI of the AWS S3 folder that contains the input file. The folder must be in the
    /// same Region as the API endpoint you are calling.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>Describes the format of the data that you submit to Amazon Translate as input. You can
    /// specify one of the following multipurpose internet mail extension (MIME) types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>text/html</code>: The input data consists of one or more HTML files. Amazon
    /// Translate translates only the text that resides in the <code>html</code> element in each
    /// file.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>text/plain</code>: The input data consists of one or more unformatted text
    /// files. Amazon Translate translates every character in this type of input.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>:
    /// The input data consists of one or more Word documents (.docx).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>:
    /// The input data consists of one or more PowerPoint Presentation files (.pptx).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The
    /// input data consists of one or more Excel Workbook files (.xlsx).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/x-xliff+xml</code>: The input data consists of one or more XML
    /// Localization Interchange File Format (XLIFF) files (.xlf). Amazon Translate supports only
    /// XLIFF version 1.2.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>If you structure your input data as HTML, ensure that you set this parameter to
    /// <code>text/html</code>. By doing so, you cut costs by limiting the translation to the
    /// contents of the <code>html</code> element in each file. Otherwise, if you set this parameter
    /// to <code>text/plain</code>, your costs will cover the translation of every character.</p>
    /// </important>
    pub content_type: std::option::Option<std::string::String>,
}
impl InputDataConfig {
    /// <p>The URI of the AWS S3 folder that contains the input file. The folder must be in the
    /// same Region as the API endpoint you are calling.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>Describes the format of the data that you submit to Amazon Translate as input. You can
    /// specify one of the following multipurpose internet mail extension (MIME) types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>text/html</code>: The input data consists of one or more HTML files. Amazon
    /// Translate translates only the text that resides in the <code>html</code> element in each
    /// file.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>text/plain</code>: The input data consists of one or more unformatted text
    /// files. Amazon Translate translates every character in this type of input.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>:
    /// The input data consists of one or more Word documents (.docx).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>:
    /// The input data consists of one or more PowerPoint Presentation files (.pptx).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The
    /// input data consists of one or more Excel Workbook files (.xlsx).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>application/x-xliff+xml</code>: The input data consists of one or more XML
    /// Localization Interchange File Format (XLIFF) files (.xlf). Amazon Translate supports only
    /// XLIFF version 1.2.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>If you structure your input data as HTML, ensure that you set this parameter to
    /// <code>text/html</code>. By doing so, you cut costs by limiting the translation to the
    /// contents of the <code>html</code> element in each file. Otherwise, if you set this parameter
    /// to <code>text/plain</code>, your costs will cover the translation of every character.</p>
    /// </important>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for InputDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDataConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`InputDataConfig`](crate::model::InputDataConfig)
pub mod input_data_config {
    /// A builder for [`InputDataConfig`](crate::model::InputDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URI of the AWS S3 folder that contains the input file. The folder must be in the
        /// same Region as the API endpoint you are calling.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The URI of the AWS S3 folder that contains the input file. The folder must be in the
        /// same Region as the API endpoint you are calling.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>Describes the format of the data that you submit to Amazon Translate as input. You can
        /// specify one of the following multipurpose internet mail extension (MIME) types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>text/html</code>: The input data consists of one or more HTML files. Amazon
        /// Translate translates only the text that resides in the <code>html</code> element in each
        /// file.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>text/plain</code>: The input data consists of one or more unformatted text
        /// files. Amazon Translate translates every character in this type of input.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>:
        /// The input data consists of one or more Word documents (.docx).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>:
        /// The input data consists of one or more PowerPoint Presentation files (.pptx).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The
        /// input data consists of one or more Excel Workbook files (.xlsx).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/x-xliff+xml</code>: The input data consists of one or more XML
        /// Localization Interchange File Format (XLIFF) files (.xlf). Amazon Translate supports only
        /// XLIFF version 1.2.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>If you structure your input data as HTML, ensure that you set this parameter to
        /// <code>text/html</code>. By doing so, you cut costs by limiting the translation to the
        /// contents of the <code>html</code> element in each file. Otherwise, if you set this parameter
        /// to <code>text/plain</code>, your costs will cover the translation of every character.</p>
        /// </important>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>Describes the format of the data that you submit to Amazon Translate as input. You can
        /// specify one of the following multipurpose internet mail extension (MIME) types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>text/html</code>: The input data consists of one or more HTML files. Amazon
        /// Translate translates only the text that resides in the <code>html</code> element in each
        /// file.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>text/plain</code>: The input data consists of one or more unformatted text
        /// files. Amazon Translate translates every character in this type of input.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>:
        /// The input data consists of one or more Word documents (.docx).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>:
        /// The input data consists of one or more PowerPoint Presentation files (.pptx).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The
        /// input data consists of one or more Excel Workbook files (.xlsx).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application/x-xliff+xml</code>: The input data consists of one or more XML
        /// Localization Interchange File Format (XLIFF) files (.xlf). Amazon Translate supports only
        /// XLIFF version 1.2.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>If you structure your input data as HTML, ensure that you set this parameter to
        /// <code>text/html</code>. By doing so, you cut costs by limiting the translation to the
        /// contents of the <code>html</code> element in each file. Otherwise, if you set this parameter
        /// to <code>text/plain</code>, your costs will cover the translation of every character.</p>
        /// </important>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDataConfig`](crate::model::InputDataConfig)
        pub fn build(self) -> crate::model::InputDataConfig {
            crate::model::InputDataConfig {
                s3_uri: self.s3_uri,
                content_type: self.content_type,
            }
        }
    }
}
impl InputDataConfig {
    /// Creates a new builder-style object to manufacture [`InputDataConfig`](crate::model::InputDataConfig)
    pub fn builder() -> crate::model::input_data_config::Builder {
        crate::model::input_data_config::Builder::default()
    }
}

/// <p>Provides information about a translation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextTranslationJobProperties {
    /// <p>The ID of the translation job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The user-defined name of the translation job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The status of the translation job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The number of documents successfully and unsuccessfully processed during the translation
    /// job.</p>
    pub job_details: std::option::Option<crate::model::JobDetails>,
    /// <p>The language code of the language of the source text. The language must be a language
    /// supported by Amazon Translate.</p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language code of the language of the target text. The language must be a language
    /// supported by Amazon Translate.</p>
    pub target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list containing the names of the terminologies applied to a translation job. Only one
    /// terminology can be applied per <a>StartTextTranslationJob</a> request at this
    /// time.</p>
    pub terminology_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list containing the names of the parallel data resources applied to the translation
    /// job.</p>
    pub parallel_data_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An explanation of any errors that may have occurred during the translation job.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time at which the translation job was submitted.</p>
    pub submitted_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the translation job ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The input configuration properties that were specified when the job was requested.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output configuration properties that were specified when the job was requested.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role
    /// that granted Amazon Translate read access to the job's input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Settings that configure the translation output.</p>
    pub settings: std::option::Option<crate::model::TranslationSettings>,
}
impl TextTranslationJobProperties {
    /// <p>The ID of the translation job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The user-defined name of the translation job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The status of the translation job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>The number of documents successfully and unsuccessfully processed during the translation
    /// job.</p>
    pub fn job_details(&self) -> std::option::Option<&crate::model::JobDetails> {
        self.job_details.as_ref()
    }
    /// <p>The language code of the language of the source text. The language must be a language
    /// supported by Amazon Translate.</p>
    pub fn source_language_code(&self) -> std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language code of the language of the target text. The language must be a language
    /// supported by Amazon Translate.</p>
    pub fn target_language_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.target_language_codes.as_deref()
    }
    /// <p>A list containing the names of the terminologies applied to a translation job. Only one
    /// terminology can be applied per <a>StartTextTranslationJob</a> request at this
    /// time.</p>
    pub fn terminology_names(&self) -> std::option::Option<&[std::string::String]> {
        self.terminology_names.as_deref()
    }
    /// <p>A list containing the names of the parallel data resources applied to the translation
    /// job.</p>
    pub fn parallel_data_names(&self) -> std::option::Option<&[std::string::String]> {
        self.parallel_data_names.as_deref()
    }
    /// <p>An explanation of any errors that may have occurred during the translation job.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time at which the translation job was submitted.</p>
    pub fn submitted_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_time.as_ref()
    }
    /// <p>The time at which the translation job ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The input configuration properties that were specified when the job was requested.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output configuration properties that were specified when the job was requested.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role
    /// that granted Amazon Translate read access to the job's input data.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>Settings that configure the translation output.</p>
    pub fn settings(&self) -> std::option::Option<&crate::model::TranslationSettings> {
        self.settings.as_ref()
    }
}
impl std::fmt::Debug for TextTranslationJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextTranslationJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("job_details", &self.job_details);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_codes", &self.target_language_codes);
        formatter.field("terminology_names", &self.terminology_names);
        formatter.field("parallel_data_names", &self.parallel_data_names);
        formatter.field("message", &self.message);
        formatter.field("submitted_time", &self.submitted_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`TextTranslationJobProperties`](crate::model::TextTranslationJobProperties)
pub mod text_translation_job_properties {
    /// A builder for [`TextTranslationJobProperties`](crate::model::TextTranslationJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) job_details: std::option::Option<crate::model::JobDetails>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) terminology_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parallel_data_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) submitted_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<crate::model::TranslationSettings>,
    }
    impl Builder {
        /// <p>The ID of the translation job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the translation job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The user-defined name of the translation job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The user-defined name of the translation job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The status of the translation job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the translation job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The number of documents successfully and unsuccessfully processed during the translation
        /// job.</p>
        pub fn job_details(mut self, input: crate::model::JobDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>The number of documents successfully and unsuccessfully processed during the translation
        /// job.</p>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::JobDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// <p>The language code of the language of the source text. The language must be a language
        /// supported by Amazon Translate.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The language code of the language of the source text. The language must be a language
        /// supported by Amazon Translate.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// Appends an item to `target_language_codes`.
        ///
        /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
        ///
        /// <p>The language code of the language of the target text. The language must be a language
        /// supported by Amazon Translate.</p>
        pub fn target_language_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_language_codes.unwrap_or_default();
            v.push(input.into());
            self.target_language_codes = Some(v);
            self
        }
        /// <p>The language code of the language of the target text. The language must be a language
        /// supported by Amazon Translate.</p>
        pub fn set_target_language_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_language_codes = input;
            self
        }
        /// Appends an item to `terminology_names`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>A list containing the names of the terminologies applied to a translation job. Only one
        /// terminology can be applied per <a>StartTextTranslationJob</a> request at this
        /// time.</p>
        pub fn terminology_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.terminology_names.unwrap_or_default();
            v.push(input.into());
            self.terminology_names = Some(v);
            self
        }
        /// <p>A list containing the names of the terminologies applied to a translation job. Only one
        /// terminology can be applied per <a>StartTextTranslationJob</a> request at this
        /// time.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.terminology_names = input;
            self
        }
        /// Appends an item to `parallel_data_names`.
        ///
        /// To override the contents of this collection use [`set_parallel_data_names`](Self::set_parallel_data_names).
        ///
        /// <p>A list containing the names of the parallel data resources applied to the translation
        /// job.</p>
        pub fn parallel_data_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parallel_data_names.unwrap_or_default();
            v.push(input.into());
            self.parallel_data_names = Some(v);
            self
        }
        /// <p>A list containing the names of the parallel data resources applied to the translation
        /// job.</p>
        pub fn set_parallel_data_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parallel_data_names = input;
            self
        }
        /// <p>An explanation of any errors that may have occurred during the translation job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An explanation of any errors that may have occurred during the translation job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time at which the translation job was submitted.</p>
        pub fn submitted_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_time = Some(input);
            self
        }
        /// <p>The time at which the translation job was submitted.</p>
        pub fn set_submitted_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_time = input;
            self
        }
        /// <p>The time at which the translation job ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time at which the translation job ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The input configuration properties that were specified when the job was requested.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input configuration properties that were specified when the job was requested.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output configuration properties that were specified when the job was requested.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output configuration properties that were specified when the job was requested.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role
        /// that granted Amazon Translate read access to the job's input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role
        /// that granted Amazon Translate read access to the job's input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>Settings that configure the translation output.</p>
        pub fn settings(mut self, input: crate::model::TranslationSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p>Settings that configure the translation output.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::TranslationSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`TextTranslationJobProperties`](crate::model::TextTranslationJobProperties)
        pub fn build(self) -> crate::model::TextTranslationJobProperties {
            crate::model::TextTranslationJobProperties {
                job_id: self.job_id,
                job_name: self.job_name,
                job_status: self.job_status,
                job_details: self.job_details,
                source_language_code: self.source_language_code,
                target_language_codes: self.target_language_codes,
                terminology_names: self.terminology_names,
                parallel_data_names: self.parallel_data_names,
                message: self.message,
                submitted_time: self.submitted_time,
                end_time: self.end_time,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                settings: self.settings,
            }
        }
    }
}
impl TextTranslationJobProperties {
    /// Creates a new builder-style object to manufacture [`TextTranslationJobProperties`](crate::model::TextTranslationJobProperties)
    pub fn builder() -> crate::model::text_translation_job_properties::Builder {
        crate::model::text_translation_job_properties::Builder::default()
    }
}

/// <p>The number of documents successfully and unsuccessfully processed during a translation
/// job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobDetails {
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub translated_documents_count: std::option::Option<i32>,
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub documents_with_errors_count: std::option::Option<i32>,
    /// <p>The number of documents used as input in a translation job.</p>
    pub input_documents_count: std::option::Option<i32>,
}
impl JobDetails {
    /// <p>The number of documents successfully processed during a translation job.</p>
    pub fn translated_documents_count(&self) -> std::option::Option<i32> {
        self.translated_documents_count
    }
    /// <p>The number of documents that could not be processed during a translation job.</p>
    pub fn documents_with_errors_count(&self) -> std::option::Option<i32> {
        self.documents_with_errors_count
    }
    /// <p>The number of documents used as input in a translation job.</p>
    pub fn input_documents_count(&self) -> std::option::Option<i32> {
        self.input_documents_count
    }
}
impl std::fmt::Debug for JobDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobDetails");
        formatter.field(
            "translated_documents_count",
            &self.translated_documents_count,
        );
        formatter.field(
            "documents_with_errors_count",
            &self.documents_with_errors_count,
        );
        formatter.field("input_documents_count", &self.input_documents_count);
        formatter.finish()
    }
}
/// See [`JobDetails`](crate::model::JobDetails)
pub mod job_details {
    /// A builder for [`JobDetails`](crate::model::JobDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) translated_documents_count: std::option::Option<i32>,
        pub(crate) documents_with_errors_count: std::option::Option<i32>,
        pub(crate) input_documents_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of documents successfully processed during a translation job.</p>
        pub fn translated_documents_count(mut self, input: i32) -> Self {
            self.translated_documents_count = Some(input);
            self
        }
        /// <p>The number of documents successfully processed during a translation job.</p>
        pub fn set_translated_documents_count(mut self, input: std::option::Option<i32>) -> Self {
            self.translated_documents_count = input;
            self
        }
        /// <p>The number of documents that could not be processed during a translation job.</p>
        pub fn documents_with_errors_count(mut self, input: i32) -> Self {
            self.documents_with_errors_count = Some(input);
            self
        }
        /// <p>The number of documents that could not be processed during a translation job.</p>
        pub fn set_documents_with_errors_count(mut self, input: std::option::Option<i32>) -> Self {
            self.documents_with_errors_count = input;
            self
        }
        /// <p>The number of documents used as input in a translation job.</p>
        pub fn input_documents_count(mut self, input: i32) -> Self {
            self.input_documents_count = Some(input);
            self
        }
        /// <p>The number of documents used as input in a translation job.</p>
        pub fn set_input_documents_count(mut self, input: std::option::Option<i32>) -> Self {
            self.input_documents_count = input;
            self
        }
        /// Consumes the builder and constructs a [`JobDetails`](crate::model::JobDetails)
        pub fn build(self) -> crate::model::JobDetails {
            crate::model::JobDetails {
                translated_documents_count: self.translated_documents_count,
                documents_with_errors_count: self.documents_with_errors_count,
                input_documents_count: self.input_documents_count,
            }
        }
    }
}
impl JobDetails {
    /// Creates a new builder-style object to manufacture [`JobDetails`](crate::model::JobDetails)
    pub fn builder() -> crate::model::job_details::Builder {
        crate::model::job_details::Builder::default()
    }
}

/// <p>Provides information for filtering a list of translation jobs. For more information, see
/// <a>ListTextTranslationJobs</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextTranslationJobFilter {
    /// <p>Filters the list of jobs by name.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>Filters the list of jobs based by job status.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
    /// returns only the jobs submitted before the specified time. Jobs are returned in ascending
    /// order, oldest to newest.</p>
    pub submitted_before_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
    /// returns only the jobs submitted after the specified time. Jobs are returned in descending
    /// order, newest to oldest.</p>
    pub submitted_after_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl TextTranslationJobFilter {
    /// <p>Filters the list of jobs by name.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>Filters the list of jobs based by job status.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
    /// returns only the jobs submitted before the specified time. Jobs are returned in ascending
    /// order, oldest to newest.</p>
    pub fn submitted_before_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_before_time.as_ref()
    }
    /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
    /// returns only the jobs submitted after the specified time. Jobs are returned in descending
    /// order, newest to oldest.</p>
    pub fn submitted_after_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_after_time.as_ref()
    }
}
impl std::fmt::Debug for TextTranslationJobFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextTranslationJobFilter");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submitted_before_time", &self.submitted_before_time);
        formatter.field("submitted_after_time", &self.submitted_after_time);
        formatter.finish()
    }
}
/// See [`TextTranslationJobFilter`](crate::model::TextTranslationJobFilter)
pub mod text_translation_job_filter {
    /// A builder for [`TextTranslationJobFilter`](crate::model::TextTranslationJobFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submitted_before_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) submitted_after_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Filters the list of jobs by name.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Filters the list of jobs by name.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>Filters the list of jobs based by job status.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>Filters the list of jobs based by job status.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
        /// returns only the jobs submitted before the specified time. Jobs are returned in ascending
        /// order, oldest to newest.</p>
        pub fn submitted_before_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_before_time = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
        /// returns only the jobs submitted before the specified time. Jobs are returned in ascending
        /// order, oldest to newest.</p>
        pub fn set_submitted_before_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_before_time = input;
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
        /// returns only the jobs submitted after the specified time. Jobs are returned in descending
        /// order, newest to oldest.</p>
        pub fn submitted_after_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_after_time = Some(input);
            self
        }
        /// <p>Filters the list of jobs based on the time that the job was submitted for processing and
        /// returns only the jobs submitted after the specified time. Jobs are returned in descending
        /// order, newest to oldest.</p>
        pub fn set_submitted_after_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_after_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TextTranslationJobFilter`](crate::model::TextTranslationJobFilter)
        pub fn build(self) -> crate::model::TextTranslationJobFilter {
            crate::model::TextTranslationJobFilter {
                job_name: self.job_name,
                job_status: self.job_status,
                submitted_before_time: self.submitted_before_time,
                submitted_after_time: self.submitted_after_time,
            }
        }
    }
}
impl TextTranslationJobFilter {
    /// Creates a new builder-style object to manufacture [`TextTranslationJobFilter`](crate::model::TextTranslationJobFilter)
    pub fn builder() -> crate::model::text_translation_job_filter::Builder {
        crate::model::text_translation_job_filter::Builder::default()
    }
}

/// <p>The properties of the custom terminology.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminologyProperties {
    /// <p>The name of the custom terminology.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the custom terminology properties.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the custom terminology. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The language code for the source text of the translation request for which the custom
    /// terminology is being used.</p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language codes for the target languages available with the custom terminology
    /// resource. All possible target languages are returned in array.</p>
    pub target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The encryption key for the custom terminology.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub size_bytes: std::option::Option<i32>,
    /// <p>The number of terms included in the custom terminology.</p>
    pub term_count: std::option::Option<i32>,
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The directionality of your terminology resource indicates whether it has one source
    /// language (uni-directional) or multiple (multi-directional). </p>
    /// <dl>
    /// <dt>UNI</dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file),
    /// and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>MULTI</dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub directionality: std::option::Option<crate::model::Directionality>,
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or
    /// updated the terminology resource.</p>
    pub skipped_term_count: std::option::Option<i32>,
    /// <p>The format of the custom terminology input file.</p>
    pub format: std::option::Option<crate::model::TerminologyDataFormat>,
}
impl TerminologyProperties {
    /// <p>The name of the custom terminology.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the custom terminology properties.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the custom terminology. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The language code for the source text of the translation request for which the custom
    /// terminology is being used.</p>
    pub fn source_language_code(&self) -> std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language codes for the target languages available with the custom terminology
    /// resource. All possible target languages are returned in array.</p>
    pub fn target_language_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.target_language_codes.as_deref()
    }
    /// <p>The encryption key for the custom terminology.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub fn size_bytes(&self) -> std::option::Option<i32> {
        self.size_bytes
    }
    /// <p>The number of terms included in the custom terminology.</p>
    pub fn term_count(&self) -> std::option::Option<i32> {
        self.term_count
    }
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source
    /// language (uni-directional) or multiple (multi-directional). </p>
    /// <dl>
    /// <dt>UNI</dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file),
    /// and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>MULTI</dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub fn directionality(&self) -> std::option::Option<&crate::model::Directionality> {
        self.directionality.as_ref()
    }
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or
    /// updated the terminology resource.</p>
    pub fn skipped_term_count(&self) -> std::option::Option<i32> {
        self.skipped_term_count
    }
    /// <p>The format of the custom terminology input file.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TerminologyDataFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for TerminologyProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminologyProperties");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("arn", &self.arn);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_codes", &self.target_language_codes);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("size_bytes", &self.size_bytes);
        formatter.field("term_count", &self.term_count);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("directionality", &self.directionality);
        formatter.field("message", &self.message);
        formatter.field("skipped_term_count", &self.skipped_term_count);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`TerminologyProperties`](crate::model::TerminologyProperties)
pub mod terminology_properties {
    /// A builder for [`TerminologyProperties`](crate::model::TerminologyProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
        pub(crate) size_bytes: std::option::Option<i32>,
        pub(crate) term_count: std::option::Option<i32>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) directionality: std::option::Option<crate::model::Directionality>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) skipped_term_count: std::option::Option<i32>,
        pub(crate) format: std::option::Option<crate::model::TerminologyDataFormat>,
    }
    impl Builder {
        /// <p>The name of the custom terminology.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom terminology.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the custom terminology properties.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the custom terminology properties.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the custom terminology. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the custom terminology. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The language code for the source text of the translation request for which the custom
        /// terminology is being used.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The language code for the source text of the translation request for which the custom
        /// terminology is being used.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// Appends an item to `target_language_codes`.
        ///
        /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
        ///
        /// <p>The language codes for the target languages available with the custom terminology
        /// resource. All possible target languages are returned in array.</p>
        pub fn target_language_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_language_codes.unwrap_or_default();
            v.push(input.into());
            self.target_language_codes = Some(v);
            self
        }
        /// <p>The language codes for the target languages available with the custom terminology
        /// resource. All possible target languages are returned in array.</p>
        pub fn set_target_language_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_language_codes = input;
            self
        }
        /// <p>The encryption key for the custom terminology.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key for the custom terminology.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>The size of the file used when importing a custom terminology.</p>
        pub fn size_bytes(mut self, input: i32) -> Self {
            self.size_bytes = Some(input);
            self
        }
        /// <p>The size of the file used when importing a custom terminology.</p>
        pub fn set_size_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.size_bytes = input;
            self
        }
        /// <p>The number of terms included in the custom terminology.</p>
        pub fn term_count(mut self, input: i32) -> Self {
            self.term_count = Some(input);
            self
        }
        /// <p>The number of terms included in the custom terminology.</p>
        pub fn set_term_count(mut self, input: std::option::Option<i32>) -> Self {
            self.term_count = input;
            self
        }
        /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The directionality of your terminology resource indicates whether it has one source
        /// language (uni-directional) or multiple (multi-directional). </p>
        /// <dl>
        /// <dt>UNI</dt>
        /// <dd>
        /// <p>The terminology resource has one source language (the first column in a CSV file),
        /// and all of its other languages are target languages.</p>
        /// </dd>
        /// <dt>MULTI</dt>
        /// <dd>
        /// <p>Any language in the terminology resource can be the source language.</p>
        /// </dd>
        /// </dl>
        pub fn directionality(mut self, input: crate::model::Directionality) -> Self {
            self.directionality = Some(input);
            self
        }
        /// <p>The directionality of your terminology resource indicates whether it has one source
        /// language (uni-directional) or multiple (multi-directional). </p>
        /// <dl>
        /// <dt>UNI</dt>
        /// <dd>
        /// <p>The terminology resource has one source language (the first column in a CSV file),
        /// and all of its other languages are target languages.</p>
        /// </dd>
        /// <dt>MULTI</dt>
        /// <dd>
        /// <p>Any language in the terminology resource can be the source language.</p>
        /// </dd>
        /// </dl>
        pub fn set_directionality(
            mut self,
            input: std::option::Option<crate::model::Directionality>,
        ) -> Self {
            self.directionality = input;
            self
        }
        /// <p>Additional information from Amazon Translate about the terminology resource.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information from Amazon Translate about the terminology resource.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of terms in the input file that Amazon Translate skipped when you created or
        /// updated the terminology resource.</p>
        pub fn skipped_term_count(mut self, input: i32) -> Self {
            self.skipped_term_count = Some(input);
            self
        }
        /// <p>The number of terms in the input file that Amazon Translate skipped when you created or
        /// updated the terminology resource.</p>
        pub fn set_skipped_term_count(mut self, input: std::option::Option<i32>) -> Self {
            self.skipped_term_count = input;
            self
        }
        /// <p>The format of the custom terminology input file.</p>
        pub fn format(mut self, input: crate::model::TerminologyDataFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the custom terminology input file.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminologyProperties`](crate::model::TerminologyProperties)
        pub fn build(self) -> crate::model::TerminologyProperties {
            crate::model::TerminologyProperties {
                name: self.name,
                description: self.description,
                arn: self.arn,
                source_language_code: self.source_language_code,
                target_language_codes: self.target_language_codes,
                encryption_key: self.encryption_key,
                size_bytes: self.size_bytes,
                term_count: self.term_count,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                directionality: self.directionality,
                message: self.message,
                skipped_term_count: self.skipped_term_count,
                format: self.format,
            }
        }
    }
}
impl TerminologyProperties {
    /// Creates a new builder-style object to manufacture [`TerminologyProperties`](crate::model::TerminologyProperties)
    pub fn builder() -> crate::model::terminology_properties::Builder {
        crate::model::terminology_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TerminologyDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Tmx,
    #[allow(missing_docs)] // documentation missing in model
    Tsv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TerminologyDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => TerminologyDataFormat::Csv,
            "TMX" => TerminologyDataFormat::Tmx,
            "TSV" => TerminologyDataFormat::Tsv,
            other => TerminologyDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TerminologyDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TerminologyDataFormat::from(s))
    }
}
impl TerminologyDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TerminologyDataFormat::Csv => "CSV",
            TerminologyDataFormat::Tmx => "TMX",
            TerminologyDataFormat::Tsv => "TSV",
            TerminologyDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "TMX", "TSV"]
    }
}
impl AsRef<str> for TerminologyDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Directionality {
    #[allow(missing_docs)] // documentation missing in model
    Multi,
    #[allow(missing_docs)] // documentation missing in model
    Uni,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Directionality {
    fn from(s: &str) -> Self {
        match s {
            "MULTI" => Directionality::Multi,
            "UNI" => Directionality::Uni,
            other => Directionality::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Directionality {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Directionality::from(s))
    }
}
impl Directionality {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Directionality::Multi => "MULTI",
            Directionality::Uni => "UNI",
            Directionality::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI", "UNI"]
    }
}
impl AsRef<str> for Directionality {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The properties of a parallel data resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParallelDataProperties {
    /// <p>The custom name assigned to the parallel data resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the parallel data resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The description assigned to the parallel data resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the parallel data resource. When the parallel data is ready for you to use,
    /// the status is <code>ACTIVE</code>.</p>
    pub status: std::option::Option<crate::model::ParallelDataStatus>,
    /// <p>The source language of the translations in the parallel data file.</p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language codes for the target languages available in the parallel data file. All
    /// possible target languages are returned as an array.</p>
    pub target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub parallel_data_config: std::option::Option<crate::model::ParallelDataConfig>,
    /// <p>Additional information from Amazon Translate about the parallel data resource. </p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The number of UTF-8 characters that Amazon Translate imported from the parallel data input
    /// file. This number includes only the characters in your translation examples. It does not
    /// include characters that are used to format your file. For example, if you provided a
    /// Translation Memory Exchange (.tmx) file, this number does not include the tags.</p>
    pub imported_data_size: std::option::Option<i64>,
    /// <p>The number of records successfully imported from the parallel data input file.</p>
    pub imported_record_count: std::option::Option<i64>,
    /// <p>The number of records unsuccessfully imported from the parallel data input file.</p>
    pub failed_record_count: std::option::Option<i64>,
    /// <p>The number of items in the input file that Amazon Translate skipped when you created or
    /// updated the parallel data resource. For example, Amazon Translate skips empty records, empty
    /// target texts, and empty lines.</p>
    pub skipped_record_count: std::option::Option<i64>,
    /// <p>The encryption key used to encrypt this object.</p>
    pub encryption_key: std::option::Option<crate::model::EncryptionKey>,
    /// <p>The time at which the parallel data resource was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the parallel data resource was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the most recent update attempt for the parallel data resource.</p>
    pub latest_update_attempt_status: std::option::Option<crate::model::ParallelDataStatus>,
    /// <p>The time that the most recent update was attempted.</p>
    pub latest_update_attempt_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl ParallelDataProperties {
    /// <p>The custom name assigned to the parallel data resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the parallel data resource.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The description assigned to the parallel data resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the parallel data resource. When the parallel data is ready for you to use,
    /// the status is <code>ACTIVE</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ParallelDataStatus> {
        self.status.as_ref()
    }
    /// <p>The source language of the translations in the parallel data file.</p>
    pub fn source_language_code(&self) -> std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language codes for the target languages available in the parallel data file. All
    /// possible target languages are returned as an array.</p>
    pub fn target_language_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.target_language_codes.as_deref()
    }
    /// <p>Specifies the format and S3 location of the parallel data input file.</p>
    pub fn parallel_data_config(&self) -> std::option::Option<&crate::model::ParallelDataConfig> {
        self.parallel_data_config.as_ref()
    }
    /// <p>Additional information from Amazon Translate about the parallel data resource. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The number of UTF-8 characters that Amazon Translate imported from the parallel data input
    /// file. This number includes only the characters in your translation examples. It does not
    /// include characters that are used to format your file. For example, if you provided a
    /// Translation Memory Exchange (.tmx) file, this number does not include the tags.</p>
    pub fn imported_data_size(&self) -> std::option::Option<i64> {
        self.imported_data_size
    }
    /// <p>The number of records successfully imported from the parallel data input file.</p>
    pub fn imported_record_count(&self) -> std::option::Option<i64> {
        self.imported_record_count
    }
    /// <p>The number of records unsuccessfully imported from the parallel data input file.</p>
    pub fn failed_record_count(&self) -> std::option::Option<i64> {
        self.failed_record_count
    }
    /// <p>The number of items in the input file that Amazon Translate skipped when you created or
    /// updated the parallel data resource. For example, Amazon Translate skips empty records, empty
    /// target texts, and empty lines.</p>
    pub fn skipped_record_count(&self) -> std::option::Option<i64> {
        self.skipped_record_count
    }
    /// <p>The encryption key used to encrypt this object.</p>
    pub fn encryption_key(&self) -> std::option::Option<&crate::model::EncryptionKey> {
        self.encryption_key.as_ref()
    }
    /// <p>The time at which the parallel data resource was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time at which the parallel data resource was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The status of the most recent update attempt for the parallel data resource.</p>
    pub fn latest_update_attempt_status(
        &self,
    ) -> std::option::Option<&crate::model::ParallelDataStatus> {
        self.latest_update_attempt_status.as_ref()
    }
    /// <p>The time that the most recent update was attempted.</p>
    pub fn latest_update_attempt_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_update_attempt_at.as_ref()
    }
}
impl std::fmt::Debug for ParallelDataProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParallelDataProperties");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_codes", &self.target_language_codes);
        formatter.field("parallel_data_config", &self.parallel_data_config);
        formatter.field("message", &self.message);
        formatter.field("imported_data_size", &self.imported_data_size);
        formatter.field("imported_record_count", &self.imported_record_count);
        formatter.field("failed_record_count", &self.failed_record_count);
        formatter.field("skipped_record_count", &self.skipped_record_count);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field(
            "latest_update_attempt_status",
            &self.latest_update_attempt_status,
        );
        formatter.field("latest_update_attempt_at", &self.latest_update_attempt_at);
        formatter.finish()
    }
}
/// See [`ParallelDataProperties`](crate::model::ParallelDataProperties)
pub mod parallel_data_properties {
    /// A builder for [`ParallelDataProperties`](crate::model::ParallelDataProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ParallelDataStatus>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parallel_data_config: std::option::Option<crate::model::ParallelDataConfig>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) imported_data_size: std::option::Option<i64>,
        pub(crate) imported_record_count: std::option::Option<i64>,
        pub(crate) failed_record_count: std::option::Option<i64>,
        pub(crate) skipped_record_count: std::option::Option<i64>,
        pub(crate) encryption_key: std::option::Option<crate::model::EncryptionKey>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_update_attempt_status:
            std::option::Option<crate::model::ParallelDataStatus>,
        pub(crate) latest_update_attempt_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The custom name assigned to the parallel data resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name assigned to the parallel data resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parallel data resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the parallel data resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The description assigned to the parallel data resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description assigned to the parallel data resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the parallel data resource. When the parallel data is ready for you to use,
        /// the status is <code>ACTIVE</code>.</p>
        pub fn status(mut self, input: crate::model::ParallelDataStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the parallel data resource. When the parallel data is ready for you to use,
        /// the status is <code>ACTIVE</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ParallelDataStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The source language of the translations in the parallel data file.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The source language of the translations in the parallel data file.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// Appends an item to `target_language_codes`.
        ///
        /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
        ///
        /// <p>The language codes for the target languages available in the parallel data file. All
        /// possible target languages are returned as an array.</p>
        pub fn target_language_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_language_codes.unwrap_or_default();
            v.push(input.into());
            self.target_language_codes = Some(v);
            self
        }
        /// <p>The language codes for the target languages available in the parallel data file. All
        /// possible target languages are returned as an array.</p>
        pub fn set_target_language_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_language_codes = input;
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, input: crate::model::ParallelDataConfig) -> Self {
            self.parallel_data_config = Some(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.parallel_data_config = input;
            self
        }
        /// <p>Additional information from Amazon Translate about the parallel data resource. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Additional information from Amazon Translate about the parallel data resource. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The number of UTF-8 characters that Amazon Translate imported from the parallel data input
        /// file. This number includes only the characters in your translation examples. It does not
        /// include characters that are used to format your file. For example, if you provided a
        /// Translation Memory Exchange (.tmx) file, this number does not include the tags.</p>
        pub fn imported_data_size(mut self, input: i64) -> Self {
            self.imported_data_size = Some(input);
            self
        }
        /// <p>The number of UTF-8 characters that Amazon Translate imported from the parallel data input
        /// file. This number includes only the characters in your translation examples. It does not
        /// include characters that are used to format your file. For example, if you provided a
        /// Translation Memory Exchange (.tmx) file, this number does not include the tags.</p>
        pub fn set_imported_data_size(mut self, input: std::option::Option<i64>) -> Self {
            self.imported_data_size = input;
            self
        }
        /// <p>The number of records successfully imported from the parallel data input file.</p>
        pub fn imported_record_count(mut self, input: i64) -> Self {
            self.imported_record_count = Some(input);
            self
        }
        /// <p>The number of records successfully imported from the parallel data input file.</p>
        pub fn set_imported_record_count(mut self, input: std::option::Option<i64>) -> Self {
            self.imported_record_count = input;
            self
        }
        /// <p>The number of records unsuccessfully imported from the parallel data input file.</p>
        pub fn failed_record_count(mut self, input: i64) -> Self {
            self.failed_record_count = Some(input);
            self
        }
        /// <p>The number of records unsuccessfully imported from the parallel data input file.</p>
        pub fn set_failed_record_count(mut self, input: std::option::Option<i64>) -> Self {
            self.failed_record_count = input;
            self
        }
        /// <p>The number of items in the input file that Amazon Translate skipped when you created or
        /// updated the parallel data resource. For example, Amazon Translate skips empty records, empty
        /// target texts, and empty lines.</p>
        pub fn skipped_record_count(mut self, input: i64) -> Self {
            self.skipped_record_count = Some(input);
            self
        }
        /// <p>The number of items in the input file that Amazon Translate skipped when you created or
        /// updated the parallel data resource. For example, Amazon Translate skips empty records, empty
        /// target texts, and empty lines.</p>
        pub fn set_skipped_record_count(mut self, input: std::option::Option<i64>) -> Self {
            self.skipped_record_count = input;
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn encryption_key(mut self, input: crate::model::EncryptionKey) -> Self {
            self.encryption_key = Some(input);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>The time at which the parallel data resource was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time at which the parallel data resource was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time at which the parallel data resource was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time at which the parallel data resource was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The status of the most recent update attempt for the parallel data resource.</p>
        pub fn latest_update_attempt_status(
            mut self,
            input: crate::model::ParallelDataStatus,
        ) -> Self {
            self.latest_update_attempt_status = Some(input);
            self
        }
        /// <p>The status of the most recent update attempt for the parallel data resource.</p>
        pub fn set_latest_update_attempt_status(
            mut self,
            input: std::option::Option<crate::model::ParallelDataStatus>,
        ) -> Self {
            self.latest_update_attempt_status = input;
            self
        }
        /// <p>The time that the most recent update was attempted.</p>
        pub fn latest_update_attempt_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_update_attempt_at = Some(input);
            self
        }
        /// <p>The time that the most recent update was attempted.</p>
        pub fn set_latest_update_attempt_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_update_attempt_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ParallelDataProperties`](crate::model::ParallelDataProperties)
        pub fn build(self) -> crate::model::ParallelDataProperties {
            crate::model::ParallelDataProperties {
                name: self.name,
                arn: self.arn,
                description: self.description,
                status: self.status,
                source_language_code: self.source_language_code,
                target_language_codes: self.target_language_codes,
                parallel_data_config: self.parallel_data_config,
                message: self.message,
                imported_data_size: self.imported_data_size,
                imported_record_count: self.imported_record_count,
                failed_record_count: self.failed_record_count,
                skipped_record_count: self.skipped_record_count,
                encryption_key: self.encryption_key,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                latest_update_attempt_status: self.latest_update_attempt_status,
                latest_update_attempt_at: self.latest_update_attempt_at,
            }
        }
    }
}
impl ParallelDataProperties {
    /// Creates a new builder-style object to manufacture [`ParallelDataProperties`](crate::model::ParallelDataProperties)
    pub fn builder() -> crate::model::parallel_data_properties::Builder {
        crate::model::parallel_data_properties::Builder::default()
    }
}

/// <p>The location of the custom terminology data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminologyDataLocation {
    /// <p>The repository type for the custom terminology data.</p>
    pub repository_type: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was
    /// successfully imported into Amazon Translate. The location is returned as a presigned URL that
    /// has a 30 minute expiration.</p>
    ///
    /// <important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
    /// attacks. </p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
    /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
    /// file is opened in a spreadsheet program, the program might interpret the record as a formula
    /// and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub location: std::option::Option<std::string::String>,
}
impl TerminologyDataLocation {
    /// <p>The repository type for the custom terminology data.</p>
    pub fn repository_type(&self) -> std::option::Option<&str> {
        self.repository_type.as_deref()
    }
    /// <p>The Amazon S3 location of the most recent custom terminology input file that was
    /// successfully imported into Amazon Translate. The location is returned as a presigned URL that
    /// has a 30 minute expiration.</p>
    ///
    /// <important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
    /// attacks. </p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
    /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
    /// file is opened in a spreadsheet program, the program might interpret the record as a formula
    /// and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for TerminologyDataLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminologyDataLocation");
        formatter.field("repository_type", &self.repository_type);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`TerminologyDataLocation`](crate::model::TerminologyDataLocation)
pub mod terminology_data_location {
    /// A builder for [`TerminologyDataLocation`](crate::model::TerminologyDataLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_type: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The repository type for the custom terminology data.</p>
        pub fn repository_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_type = Some(input.into());
            self
        }
        /// <p>The repository type for the custom terminology data.</p>
        pub fn set_repository_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_type = input;
            self
        }
        /// <p>The Amazon S3 location of the most recent custom terminology input file that was
        /// successfully imported into Amazon Translate. The location is returned as a presigned URL that
        /// has a 30 minute expiration.</p>
        ///
        /// <important>
        /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
        /// attacks. </p>
        /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
        /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
        /// file is opened in a spreadsheet program, the program might interpret the record as a formula
        /// and run the code within it.</p>
        /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
        /// </important>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the most recent custom terminology input file that was
        /// successfully imported into Amazon Translate. The location is returned as a presigned URL that
        /// has a 30 minute expiration.</p>
        ///
        /// <important>
        /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
        /// attacks. </p>
        /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
        /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
        /// file is opened in a spreadsheet program, the program might interpret the record as a formula
        /// and run the code within it.</p>
        /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
        /// </important>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminologyDataLocation`](crate::model::TerminologyDataLocation)
        pub fn build(self) -> crate::model::TerminologyDataLocation {
            crate::model::TerminologyDataLocation {
                repository_type: self.repository_type,
                location: self.location,
            }
        }
    }
}
impl TerminologyDataLocation {
    /// Creates a new builder-style object to manufacture [`TerminologyDataLocation`](crate::model::TerminologyDataLocation)
    pub fn builder() -> crate::model::terminology_data_location::Builder {
        crate::model::terminology_data_location::Builder::default()
    }
}

/// <p>The data associated with the custom terminology.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminologyData {
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a
    /// Base64-encoding on this field before sending a request to the AWS service. Users of the SDK
    /// should not perform Base64-encoding themselves.</p>
    pub file: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The data format of the custom terminology.</p>
    pub format: std::option::Option<crate::model::TerminologyDataFormat>,
    /// <p>The directionality of your terminology resource indicates whether it has one source
    /// language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>UNI</dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a
    /// CSV file), and all of its other languages are target languages. </p>
    /// </dd>
    /// <dt>MULTI</dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target
    /// language. A single multi-directional terminology resource can be used for jobs that
    /// translate different language pairs. For example, if the terminology contains terms in
    /// English and Spanish, then it can be used for jobs that translate English to Spanish and
    /// jobs that translate Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it
    /// behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub directionality: std::option::Option<crate::model::Directionality>,
}
impl TerminologyData {
    /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a
    /// Base64-encoding on this field before sending a request to the AWS service. Users of the SDK
    /// should not perform Base64-encoding themselves.</p>
    pub fn file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.file.as_ref()
    }
    /// <p>The data format of the custom terminology.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TerminologyDataFormat> {
        self.format.as_ref()
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source
    /// language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>UNI</dt>
    /// <dd>
    /// <p>The terminology resource has one source language (for example, the first column in a
    /// CSV file), and all of its other languages are target languages. </p>
    /// </dd>
    /// <dt>MULTI</dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language or a target
    /// language. A single multi-directional terminology resource can be used for jobs that
    /// translate different language pairs. For example, if the terminology contains terms in
    /// English and Spanish, then it can be used for jobs that translate English to Spanish and
    /// jobs that translate Spanish to English.</p>
    /// </dd>
    /// </dl>
    /// <p>When you create a custom terminology resource without specifying the directionality, it
    /// behaves as uni-directional terminology, although this parameter will have a null value.</p>
    pub fn directionality(&self) -> std::option::Option<&crate::model::Directionality> {
        self.directionality.as_ref()
    }
}
impl std::fmt::Debug for TerminologyData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminologyData");
        formatter.field("file", &"*** Sensitive Data Redacted ***");
        formatter.field("format", &self.format);
        formatter.field("directionality", &self.directionality);
        formatter.finish()
    }
}
/// See [`TerminologyData`](crate::model::TerminologyData)
pub mod terminology_data {
    /// A builder for [`TerminologyData`](crate::model::TerminologyData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) format: std::option::Option<crate::model::TerminologyDataFormat>,
        pub(crate) directionality: std::option::Option<crate::model::Directionality>,
    }
    impl Builder {
        /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a
        /// Base64-encoding on this field before sending a request to the AWS service. Users of the SDK
        /// should not perform Base64-encoding themselves.</p>
        pub fn file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.file = Some(input);
            self
        }
        /// <p>The file containing the custom terminology data. Your version of the AWS SDK performs a
        /// Base64-encoding on this field before sending a request to the AWS service. Users of the SDK
        /// should not perform Base64-encoding themselves.</p>
        pub fn set_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.file = input;
            self
        }
        /// <p>The data format of the custom terminology.</p>
        pub fn format(mut self, input: crate::model::TerminologyDataFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The data format of the custom terminology.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The directionality of your terminology resource indicates whether it has one source
        /// language (uni-directional) or multiple (multi-directional).</p>
        /// <dl>
        /// <dt>UNI</dt>
        /// <dd>
        /// <p>The terminology resource has one source language (for example, the first column in a
        /// CSV file), and all of its other languages are target languages. </p>
        /// </dd>
        /// <dt>MULTI</dt>
        /// <dd>
        /// <p>Any language in the terminology resource can be the source language or a target
        /// language. A single multi-directional terminology resource can be used for jobs that
        /// translate different language pairs. For example, if the terminology contains terms in
        /// English and Spanish, then it can be used for jobs that translate English to Spanish and
        /// jobs that translate Spanish to English.</p>
        /// </dd>
        /// </dl>
        /// <p>When you create a custom terminology resource without specifying the directionality, it
        /// behaves as uni-directional terminology, although this parameter will have a null value.</p>
        pub fn directionality(mut self, input: crate::model::Directionality) -> Self {
            self.directionality = Some(input);
            self
        }
        /// <p>The directionality of your terminology resource indicates whether it has one source
        /// language (uni-directional) or multiple (multi-directional).</p>
        /// <dl>
        /// <dt>UNI</dt>
        /// <dd>
        /// <p>The terminology resource has one source language (for example, the first column in a
        /// CSV file), and all of its other languages are target languages. </p>
        /// </dd>
        /// <dt>MULTI</dt>
        /// <dd>
        /// <p>Any language in the terminology resource can be the source language or a target
        /// language. A single multi-directional terminology resource can be used for jobs that
        /// translate different language pairs. For example, if the terminology contains terms in
        /// English and Spanish, then it can be used for jobs that translate English to Spanish and
        /// jobs that translate Spanish to English.</p>
        /// </dd>
        /// </dl>
        /// <p>When you create a custom terminology resource without specifying the directionality, it
        /// behaves as uni-directional terminology, although this parameter will have a null value.</p>
        pub fn set_directionality(
            mut self,
            input: std::option::Option<crate::model::Directionality>,
        ) -> Self {
            self.directionality = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminologyData`](crate::model::TerminologyData)
        pub fn build(self) -> crate::model::TerminologyData {
            crate::model::TerminologyData {
                file: self.file,
                format: self.format,
                directionality: self.directionality,
            }
        }
    }
}
impl TerminologyData {
    /// Creates a new builder-style object to manufacture [`TerminologyData`](crate::model::TerminologyData)
    pub fn builder() -> crate::model::terminology_data::Builder {
        crate::model::terminology_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MergeStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Overwrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MergeStrategy {
    fn from(s: &str) -> Self {
        match s {
            "OVERWRITE" => MergeStrategy::Overwrite,
            other => MergeStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MergeStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MergeStrategy::from(s))
    }
}
impl MergeStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MergeStrategy::Overwrite => "OVERWRITE",
            MergeStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OVERWRITE"]
    }
}
impl AsRef<str> for MergeStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The location of the most recent parallel data input file that was successfully imported
/// into Amazon Translate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParallelDataDataLocation {
    /// <p>Describes the repository that contains the parallel data input file.</p>
    pub repository_type: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a
    /// presigned URL to that has a 30 minute expiration.</p>
    ///
    /// <important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
    /// attacks. </p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
    /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
    /// file is opened in a spreadsheet program, the program might interpret the record as a formula
    /// and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub location: std::option::Option<std::string::String>,
}
impl ParallelDataDataLocation {
    /// <p>Describes the repository that contains the parallel data input file.</p>
    pub fn repository_type(&self) -> std::option::Option<&str> {
        self.repository_type.as_deref()
    }
    /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a
    /// presigned URL to that has a 30 minute expiration.</p>
    ///
    /// <important>
    /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
    /// attacks. </p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
    /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
    /// file is opened in a spreadsheet program, the program might interpret the record as a formula
    /// and run the code within it.</p>
    /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for ParallelDataDataLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParallelDataDataLocation");
        formatter.field("repository_type", &self.repository_type);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`ParallelDataDataLocation`](crate::model::ParallelDataDataLocation)
pub mod parallel_data_data_location {
    /// A builder for [`ParallelDataDataLocation`](crate::model::ParallelDataDataLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_type: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the repository that contains the parallel data input file.</p>
        pub fn repository_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_type = Some(input.into());
            self
        }
        /// <p>Describes the repository that contains the parallel data input file.</p>
        pub fn set_repository_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_type = input;
            self
        }
        /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a
        /// presigned URL to that has a 30 minute expiration.</p>
        ///
        /// <important>
        /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
        /// attacks. </p>
        /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
        /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
        /// file is opened in a spreadsheet program, the program might interpret the record as a formula
        /// and run the code within it.</p>
        /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
        /// </important>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The Amazon S3 location of the parallel data input file. The location is returned as a
        /// presigned URL to that has a 30 minute expiration.</p>
        ///
        /// <important>
        /// <p>Amazon Translate doesn't scan all input files for the risk of CSV injection
        /// attacks. </p>
        /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
        /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
        /// file is opened in a spreadsheet program, the program might interpret the record as a formula
        /// and run the code within it.</p>
        /// <p>Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
        /// </important>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`ParallelDataDataLocation`](crate::model::ParallelDataDataLocation)
        pub fn build(self) -> crate::model::ParallelDataDataLocation {
            crate::model::ParallelDataDataLocation {
                repository_type: self.repository_type,
                location: self.location,
            }
        }
    }
}
impl ParallelDataDataLocation {
    /// Creates a new builder-style object to manufacture [`ParallelDataDataLocation`](crate::model::ParallelDataDataLocation)
    pub fn builder() -> crate::model::parallel_data_data_location::Builder {
        crate::model::parallel_data_data_location::Builder::default()
    }
}
