// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateParallelDataOutput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the parallel data resource that you are attempting to update. Your update
    /// request is accepted only if this status is either <code>ACTIVE</code> or
    /// <code>FAILED</code>.</p>
    pub status: std::option::Option<crate::model::ParallelDataStatus>,
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is
    /// ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub latest_update_attempt_status: std::option::Option<crate::model::ParallelDataStatus>,
    /// <p>The time that the most recent update was attempted.</p>
    pub latest_update_attempt_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateParallelDataOutput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the parallel data resource that you are attempting to update. Your update
    /// request is accepted only if this status is either <code>ACTIVE</code> or
    /// <code>FAILED</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ParallelDataStatus> {
        self.status.as_ref()
    }
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is
    /// ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub fn latest_update_attempt_status(
        &self,
    ) -> std::option::Option<&crate::model::ParallelDataStatus> {
        self.latest_update_attempt_status.as_ref()
    }
    /// <p>The time that the most recent update was attempted.</p>
    pub fn latest_update_attempt_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_update_attempt_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateParallelDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateParallelDataOutput");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field(
            "latest_update_attempt_status",
            &self.latest_update_attempt_status,
        );
        formatter.field("latest_update_attempt_at", &self.latest_update_attempt_at);
        formatter.finish()
    }
}
/// See [`UpdateParallelDataOutput`](crate::output::UpdateParallelDataOutput)
pub mod update_parallel_data_output {
    /// A builder for [`UpdateParallelDataOutput`](crate::output::UpdateParallelDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ParallelDataStatus>,
        pub(crate) latest_update_attempt_status:
            std::option::Option<crate::model::ParallelDataStatus>,
        pub(crate) latest_update_attempt_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the parallel data resource that you are attempting to update. Your update
        /// request is accepted only if this status is either <code>ACTIVE</code> or
        /// <code>FAILED</code>.</p>
        pub fn status(mut self, input: crate::model::ParallelDataStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the parallel data resource that you are attempting to update. Your update
        /// request is accepted only if this status is either <code>ACTIVE</code> or
        /// <code>FAILED</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ParallelDataStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status of the parallel data update attempt. When the updated parallel data resource is
        /// ready for you to use, the status is <code>ACTIVE</code>.</p>
        pub fn latest_update_attempt_status(
            mut self,
            input: crate::model::ParallelDataStatus,
        ) -> Self {
            self.latest_update_attempt_status = Some(input);
            self
        }
        /// <p>The status of the parallel data update attempt. When the updated parallel data resource is
        /// ready for you to use, the status is <code>ACTIVE</code>.</p>
        pub fn set_latest_update_attempt_status(
            mut self,
            input: std::option::Option<crate::model::ParallelDataStatus>,
        ) -> Self {
            self.latest_update_attempt_status = input;
            self
        }
        /// <p>The time that the most recent update was attempted.</p>
        pub fn latest_update_attempt_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_update_attempt_at = Some(input);
            self
        }
        /// <p>The time that the most recent update was attempted.</p>
        pub fn set_latest_update_attempt_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_update_attempt_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateParallelDataOutput`](crate::output::UpdateParallelDataOutput)
        pub fn build(self) -> crate::output::UpdateParallelDataOutput {
            crate::output::UpdateParallelDataOutput {
                name: self.name,
                status: self.status,
                latest_update_attempt_status: self.latest_update_attempt_status,
                latest_update_attempt_at: self.latest_update_attempt_at,
            }
        }
    }
}
impl UpdateParallelDataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateParallelDataOutput`](crate::output::UpdateParallelDataOutput)
    pub fn builder() -> crate::output::update_parallel_data_output::Builder {
        crate::output::update_parallel_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TranslateTextOutput {
    /// <p>The translated text.</p>
    pub translated_text: std::option::Option<std::string::String>,
    /// <p>The language code for the language of the source text.</p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language code for the language of the target text. </p>
    pub target_language_code: std::option::Option<std::string::String>,
    /// <p>The names of the custom terminologies applied to the input text by Amazon Translate for the
    /// translated text response.</p>
    pub applied_terminologies: std::option::Option<std::vec::Vec<crate::model::AppliedTerminology>>,
}
impl TranslateTextOutput {
    /// <p>The translated text.</p>
    pub fn translated_text(&self) -> std::option::Option<&str> {
        self.translated_text.as_deref()
    }
    /// <p>The language code for the language of the source text.</p>
    pub fn source_language_code(&self) -> std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language code for the language of the target text. </p>
    pub fn target_language_code(&self) -> std::option::Option<&str> {
        self.target_language_code.as_deref()
    }
    /// <p>The names of the custom terminologies applied to the input text by Amazon Translate for the
    /// translated text response.</p>
    pub fn applied_terminologies(
        &self,
    ) -> std::option::Option<&[crate::model::AppliedTerminology]> {
        self.applied_terminologies.as_deref()
    }
}
impl std::fmt::Debug for TranslateTextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TranslateTextOutput");
        formatter.field("translated_text", &self.translated_text);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_code", &self.target_language_code);
        formatter.field("applied_terminologies", &self.applied_terminologies);
        formatter.finish()
    }
}
/// See [`TranslateTextOutput`](crate::output::TranslateTextOutput)
pub mod translate_text_output {
    /// A builder for [`TranslateTextOutput`](crate::output::TranslateTextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) translated_text: std::option::Option<std::string::String>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_code: std::option::Option<std::string::String>,
        pub(crate) applied_terminologies:
            std::option::Option<std::vec::Vec<crate::model::AppliedTerminology>>,
    }
    impl Builder {
        /// <p>The translated text.</p>
        pub fn translated_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.translated_text = Some(input.into());
            self
        }
        /// <p>The translated text.</p>
        pub fn set_translated_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.translated_text = input;
            self
        }
        /// <p>The language code for the language of the source text.</p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The language code for the language of the source text.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// <p>The language code for the language of the target text. </p>
        pub fn target_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_language_code = Some(input.into());
            self
        }
        /// <p>The language code for the language of the target text. </p>
        pub fn set_target_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_language_code = input;
            self
        }
        /// Appends an item to `applied_terminologies`.
        ///
        /// To override the contents of this collection use [`set_applied_terminologies`](Self::set_applied_terminologies).
        ///
        /// <p>The names of the custom terminologies applied to the input text by Amazon Translate for the
        /// translated text response.</p>
        pub fn applied_terminologies(
            mut self,
            input: impl Into<crate::model::AppliedTerminology>,
        ) -> Self {
            let mut v = self.applied_terminologies.unwrap_or_default();
            v.push(input.into());
            self.applied_terminologies = Some(v);
            self
        }
        /// <p>The names of the custom terminologies applied to the input text by Amazon Translate for the
        /// translated text response.</p>
        pub fn set_applied_terminologies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppliedTerminology>>,
        ) -> Self {
            self.applied_terminologies = input;
            self
        }
        /// Consumes the builder and constructs a [`TranslateTextOutput`](crate::output::TranslateTextOutput)
        pub fn build(self) -> crate::output::TranslateTextOutput {
            crate::output::TranslateTextOutput {
                translated_text: self.translated_text,
                source_language_code: self.source_language_code,
                target_language_code: self.target_language_code,
                applied_terminologies: self.applied_terminologies,
            }
        }
    }
}
impl TranslateTextOutput {
    /// Creates a new builder-style object to manufacture [`TranslateTextOutput`](crate::output::TranslateTextOutput)
    pub fn builder() -> crate::output::translate_text_output::Builder {
        crate::output::translate_text_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTextTranslationJobOutput {
    /// <p>The job ID of the stopped batch translation job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status of the designated job. Upon successful completion, the job's status will be
    /// <code>STOPPED</code>.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
}
impl StopTextTranslationJobOutput {
    /// <p>The job ID of the stopped batch translation job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status of the designated job. Upon successful completion, the job's status will be
    /// <code>STOPPED</code>.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
}
impl std::fmt::Debug for StopTextTranslationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTextTranslationJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.finish()
    }
}
/// See [`StopTextTranslationJobOutput`](crate::output::StopTextTranslationJobOutput)
pub mod stop_text_translation_job_output {
    /// A builder for [`StopTextTranslationJobOutput`](crate::output::StopTextTranslationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
    }
    impl Builder {
        /// <p>The job ID of the stopped batch translation job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID of the stopped batch translation job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status of the designated job. Upon successful completion, the job's status will be
        /// <code>STOPPED</code>.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the designated job. Upon successful completion, the job's status will be
        /// <code>STOPPED</code>.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTextTranslationJobOutput`](crate::output::StopTextTranslationJobOutput)
        pub fn build(self) -> crate::output::StopTextTranslationJobOutput {
            crate::output::StopTextTranslationJobOutput {
                job_id: self.job_id,
                job_status: self.job_status,
            }
        }
    }
}
impl StopTextTranslationJobOutput {
    /// Creates a new builder-style object to manufacture [`StopTextTranslationJobOutput`](crate::output::StopTextTranslationJobOutput)
    pub fn builder() -> crate::output::stop_text_translation_job_output::Builder {
        crate::output::stop_text_translation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTextTranslationJobOutput {
    /// <p>The identifier generated for the job. To get the status of a job, use this ID with the
    /// <a>DescribeTextTranslationJob</a> operation.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status of the job. Possible values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUBMITTED</code> - The job has been received and is queued for
    /// processing.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The job was successfully completed and the output is
    /// available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can
    /// be analyzed in the job's output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The job did not complete. To get details, use the <a>DescribeTextTranslationJob</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOP_REQUESTED</code> - The user who started the job has requested that it be
    /// stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> - The job has been stopped.</p>
    /// </li>
    /// </ul>
    pub job_status: std::option::Option<crate::model::JobStatus>,
}
impl StartTextTranslationJobOutput {
    /// <p>The identifier generated for the job. To get the status of a job, use this ID with the
    /// <a>DescribeTextTranslationJob</a> operation.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status of the job. Possible values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUBMITTED</code> - The job has been received and is queued for
    /// processing.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The job was successfully completed and the output is
    /// available.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can
    /// be analyzed in the job's output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The job did not complete. To get details, use the <a>DescribeTextTranslationJob</a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOP_REQUESTED</code> - The user who started the job has requested that it be
    /// stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> - The job has been stopped.</p>
    /// </li>
    /// </ul>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
}
impl std::fmt::Debug for StartTextTranslationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTextTranslationJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.finish()
    }
}
/// See [`StartTextTranslationJobOutput`](crate::output::StartTextTranslationJobOutput)
pub mod start_text_translation_job_output {
    /// A builder for [`StartTextTranslationJobOutput`](crate::output::StartTextTranslationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
    }
    impl Builder {
        /// <p>The identifier generated for the job. To get the status of a job, use this ID with the
        /// <a>DescribeTextTranslationJob</a> operation.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier generated for the job. To get the status of a job, use this ID with the
        /// <a>DescribeTextTranslationJob</a> operation.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status of the job. Possible values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUBMITTED</code> - The job has been received and is queued for
        /// processing.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The job was successfully completed and the output is
        /// available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can
        /// be analyzed in the job's output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The job did not complete. To get details, use the <a>DescribeTextTranslationJob</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_REQUESTED</code> - The user who started the job has requested that it be
        /// stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> - The job has been stopped.</p>
        /// </li>
        /// </ul>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the job. Possible values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUBMITTED</code> - The job has been received and is queued for
        /// processing.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Amazon Translate is processing the job.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The job was successfully completed and the output is
        /// available.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED_WITH_ERROR</code> - The job was completed with errors. The errors can
        /// be analyzed in the job's output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The job did not complete. To get details, use the <a>DescribeTextTranslationJob</a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOP_REQUESTED</code> - The user who started the job has requested that it be
        /// stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> - The job has been stopped.</p>
        /// </li>
        /// </ul>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTextTranslationJobOutput`](crate::output::StartTextTranslationJobOutput)
        pub fn build(self) -> crate::output::StartTextTranslationJobOutput {
            crate::output::StartTextTranslationJobOutput {
                job_id: self.job_id,
                job_status: self.job_status,
            }
        }
    }
}
impl StartTextTranslationJobOutput {
    /// Creates a new builder-style object to manufacture [`StartTextTranslationJobOutput`](crate::output::StartTextTranslationJobOutput)
    pub fn builder() -> crate::output::start_text_translation_job_output::Builder {
        crate::output::start_text_translation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTextTranslationJobsOutput {
    /// <p>A list containing the properties of each job that is returned.</p>
    pub text_translation_job_properties_list:
        std::option::Option<std::vec::Vec<crate::model::TextTranslationJobProperties>>,
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTextTranslationJobsOutput {
    /// <p>A list containing the properties of each job that is returned.</p>
    pub fn text_translation_job_properties_list(
        &self,
    ) -> std::option::Option<&[crate::model::TextTranslationJobProperties]> {
        self.text_translation_job_properties_list.as_deref()
    }
    /// <p>The token to use to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTextTranslationJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTextTranslationJobsOutput");
        formatter.field(
            "text_translation_job_properties_list",
            &self.text_translation_job_properties_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTextTranslationJobsOutput`](crate::output::ListTextTranslationJobsOutput)
pub mod list_text_translation_jobs_output {
    /// A builder for [`ListTextTranslationJobsOutput`](crate::output::ListTextTranslationJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_translation_job_properties_list:
            std::option::Option<std::vec::Vec<crate::model::TextTranslationJobProperties>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `text_translation_job_properties_list`.
        ///
        /// To override the contents of this collection use [`set_text_translation_job_properties_list`](Self::set_text_translation_job_properties_list).
        ///
        /// <p>A list containing the properties of each job that is returned.</p>
        pub fn text_translation_job_properties_list(
            mut self,
            input: impl Into<crate::model::TextTranslationJobProperties>,
        ) -> Self {
            let mut v = self
                .text_translation_job_properties_list
                .unwrap_or_default();
            v.push(input.into());
            self.text_translation_job_properties_list = Some(v);
            self
        }
        /// <p>A list containing the properties of each job that is returned.</p>
        pub fn set_text_translation_job_properties_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TextTranslationJobProperties>>,
        ) -> Self {
            self.text_translation_job_properties_list = input;
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTextTranslationJobsOutput`](crate::output::ListTextTranslationJobsOutput)
        pub fn build(self) -> crate::output::ListTextTranslationJobsOutput {
            crate::output::ListTextTranslationJobsOutput {
                text_translation_job_properties_list: self.text_translation_job_properties_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTextTranslationJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListTextTranslationJobsOutput`](crate::output::ListTextTranslationJobsOutput)
    pub fn builder() -> crate::output::list_text_translation_jobs_output::Builder {
        crate::output::list_text_translation_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTerminologiesOutput {
    /// <p>The properties list of the custom terminologies returned on the list request.</p>
    pub terminology_properties_list:
        std::option::Option<std::vec::Vec<crate::model::TerminologyProperties>>,
    /// <p> If the response to the ListTerminologies was truncated, the NextToken fetches the next
    /// group of custom terminologies.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTerminologiesOutput {
    /// <p>The properties list of the custom terminologies returned on the list request.</p>
    pub fn terminology_properties_list(
        &self,
    ) -> std::option::Option<&[crate::model::TerminologyProperties]> {
        self.terminology_properties_list.as_deref()
    }
    /// <p> If the response to the ListTerminologies was truncated, the NextToken fetches the next
    /// group of custom terminologies.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTerminologiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTerminologiesOutput");
        formatter.field(
            "terminology_properties_list",
            &self.terminology_properties_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTerminologiesOutput`](crate::output::ListTerminologiesOutput)
pub mod list_terminologies_output {
    /// A builder for [`ListTerminologiesOutput`](crate::output::ListTerminologiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terminology_properties_list:
            std::option::Option<std::vec::Vec<crate::model::TerminologyProperties>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `terminology_properties_list`.
        ///
        /// To override the contents of this collection use [`set_terminology_properties_list`](Self::set_terminology_properties_list).
        ///
        /// <p>The properties list of the custom terminologies returned on the list request.</p>
        pub fn terminology_properties_list(
            mut self,
            input: impl Into<crate::model::TerminologyProperties>,
        ) -> Self {
            let mut v = self.terminology_properties_list.unwrap_or_default();
            v.push(input.into());
            self.terminology_properties_list = Some(v);
            self
        }
        /// <p>The properties list of the custom terminologies returned on the list request.</p>
        pub fn set_terminology_properties_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TerminologyProperties>>,
        ) -> Self {
            self.terminology_properties_list = input;
            self
        }
        /// <p> If the response to the ListTerminologies was truncated, the NextToken fetches the next
        /// group of custom terminologies.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If the response to the ListTerminologies was truncated, the NextToken fetches the next
        /// group of custom terminologies.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTerminologiesOutput`](crate::output::ListTerminologiesOutput)
        pub fn build(self) -> crate::output::ListTerminologiesOutput {
            crate::output::ListTerminologiesOutput {
                terminology_properties_list: self.terminology_properties_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTerminologiesOutput {
    /// Creates a new builder-style object to manufacture [`ListTerminologiesOutput`](crate::output::ListTerminologiesOutput)
    pub fn builder() -> crate::output::list_terminologies_output::Builder {
        crate::output::list_terminologies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListParallelDataOutput {
    /// <p>The properties of the parallel data resources returned by this request.</p>
    pub parallel_data_properties_list:
        std::option::Option<std::vec::Vec<crate::model::ParallelDataProperties>>,
    /// <p>The string to use in a subsequent request to get the next page of results in a paginated
    /// response. This value is null if there are no additional pages.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListParallelDataOutput {
    /// <p>The properties of the parallel data resources returned by this request.</p>
    pub fn parallel_data_properties_list(
        &self,
    ) -> std::option::Option<&[crate::model::ParallelDataProperties]> {
        self.parallel_data_properties_list.as_deref()
    }
    /// <p>The string to use in a subsequent request to get the next page of results in a paginated
    /// response. This value is null if there are no additional pages.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListParallelDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListParallelDataOutput");
        formatter.field(
            "parallel_data_properties_list",
            &self.parallel_data_properties_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListParallelDataOutput`](crate::output::ListParallelDataOutput)
pub mod list_parallel_data_output {
    /// A builder for [`ListParallelDataOutput`](crate::output::ListParallelDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parallel_data_properties_list:
            std::option::Option<std::vec::Vec<crate::model::ParallelDataProperties>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parallel_data_properties_list`.
        ///
        /// To override the contents of this collection use [`set_parallel_data_properties_list`](Self::set_parallel_data_properties_list).
        ///
        /// <p>The properties of the parallel data resources returned by this request.</p>
        pub fn parallel_data_properties_list(
            mut self,
            input: impl Into<crate::model::ParallelDataProperties>,
        ) -> Self {
            let mut v = self.parallel_data_properties_list.unwrap_or_default();
            v.push(input.into());
            self.parallel_data_properties_list = Some(v);
            self
        }
        /// <p>The properties of the parallel data resources returned by this request.</p>
        pub fn set_parallel_data_properties_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParallelDataProperties>>,
        ) -> Self {
            self.parallel_data_properties_list = input;
            self
        }
        /// <p>The string to use in a subsequent request to get the next page of results in a paginated
        /// response. This value is null if there are no additional pages.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The string to use in a subsequent request to get the next page of results in a paginated
        /// response. This value is null if there are no additional pages.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListParallelDataOutput`](crate::output::ListParallelDataOutput)
        pub fn build(self) -> crate::output::ListParallelDataOutput {
            crate::output::ListParallelDataOutput {
                parallel_data_properties_list: self.parallel_data_properties_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListParallelDataOutput {
    /// Creates a new builder-style object to manufacture [`ListParallelDataOutput`](crate::output::ListParallelDataOutput)
    pub fn builder() -> crate::output::list_parallel_data_output::Builder {
        crate::output::list_parallel_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportTerminologyOutput {
    /// <p>The properties of the custom terminology being imported.</p>
    pub terminology_properties: std::option::Option<crate::model::TerminologyProperties>,
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to create a
    /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub auxiliary_data_location: std::option::Option<crate::model::TerminologyDataLocation>,
}
impl ImportTerminologyOutput {
    /// <p>The properties of the custom terminology being imported.</p>
    pub fn terminology_properties(
        &self,
    ) -> std::option::Option<&crate::model::TerminologyProperties> {
        self.terminology_properties.as_ref()
    }
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to create a
    /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub fn auxiliary_data_location(
        &self,
    ) -> std::option::Option<&crate::model::TerminologyDataLocation> {
        self.auxiliary_data_location.as_ref()
    }
}
impl std::fmt::Debug for ImportTerminologyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportTerminologyOutput");
        formatter.field("terminology_properties", &self.terminology_properties);
        formatter.field("auxiliary_data_location", &self.auxiliary_data_location);
        formatter.finish()
    }
}
/// See [`ImportTerminologyOutput`](crate::output::ImportTerminologyOutput)
pub mod import_terminology_output {
    /// A builder for [`ImportTerminologyOutput`](crate::output::ImportTerminologyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terminology_properties: std::option::Option<crate::model::TerminologyProperties>,
        pub(crate) auxiliary_data_location:
            std::option::Option<crate::model::TerminologyDataLocation>,
    }
    impl Builder {
        /// <p>The properties of the custom terminology being imported.</p>
        pub fn terminology_properties(
            mut self,
            input: crate::model::TerminologyProperties,
        ) -> Self {
            self.terminology_properties = Some(input);
            self
        }
        /// <p>The properties of the custom terminology being imported.</p>
        pub fn set_terminology_properties(
            mut self,
            input: std::option::Option<crate::model::TerminologyProperties>,
        ) -> Self {
            self.terminology_properties = input;
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to create a
        /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn auxiliary_data_location(
            mut self,
            input: crate::model::TerminologyDataLocation,
        ) -> Self {
            self.auxiliary_data_location = Some(input);
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to create a
        /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn set_auxiliary_data_location(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataLocation>,
        ) -> Self {
            self.auxiliary_data_location = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportTerminologyOutput`](crate::output::ImportTerminologyOutput)
        pub fn build(self) -> crate::output::ImportTerminologyOutput {
            crate::output::ImportTerminologyOutput {
                terminology_properties: self.terminology_properties,
                auxiliary_data_location: self.auxiliary_data_location,
            }
        }
    }
}
impl ImportTerminologyOutput {
    /// Creates a new builder-style object to manufacture [`ImportTerminologyOutput`](crate::output::ImportTerminologyOutput)
    pub fn builder() -> crate::output::import_terminology_output::Builder {
        crate::output::import_terminology_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTerminologyOutput {
    /// <p>The properties of the custom terminology being retrieved.</p>
    pub terminology_properties: std::option::Option<crate::model::TerminologyProperties>,
    /// <p>The data location of the custom terminology being retrieved. The custom terminology file
    /// is returned in a presigned url that has a 30 minute expiration.</p>
    pub terminology_data_location: std::option::Option<crate::model::TerminologyDataLocation>,
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to create a
    /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub auxiliary_data_location: std::option::Option<crate::model::TerminologyDataLocation>,
}
impl GetTerminologyOutput {
    /// <p>The properties of the custom terminology being retrieved.</p>
    pub fn terminology_properties(
        &self,
    ) -> std::option::Option<&crate::model::TerminologyProperties> {
        self.terminology_properties.as_ref()
    }
    /// <p>The data location of the custom terminology being retrieved. The custom terminology file
    /// is returned in a presigned url that has a 30 minute expiration.</p>
    pub fn terminology_data_location(
        &self,
    ) -> std::option::Option<&crate::model::TerminologyDataLocation> {
        self.terminology_data_location.as_ref()
    }
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to create a
    /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub fn auxiliary_data_location(
        &self,
    ) -> std::option::Option<&crate::model::TerminologyDataLocation> {
        self.auxiliary_data_location.as_ref()
    }
}
impl std::fmt::Debug for GetTerminologyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTerminologyOutput");
        formatter.field("terminology_properties", &self.terminology_properties);
        formatter.field("terminology_data_location", &self.terminology_data_location);
        formatter.field("auxiliary_data_location", &self.auxiliary_data_location);
        formatter.finish()
    }
}
/// See [`GetTerminologyOutput`](crate::output::GetTerminologyOutput)
pub mod get_terminology_output {
    /// A builder for [`GetTerminologyOutput`](crate::output::GetTerminologyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) terminology_properties: std::option::Option<crate::model::TerminologyProperties>,
        pub(crate) terminology_data_location:
            std::option::Option<crate::model::TerminologyDataLocation>,
        pub(crate) auxiliary_data_location:
            std::option::Option<crate::model::TerminologyDataLocation>,
    }
    impl Builder {
        /// <p>The properties of the custom terminology being retrieved.</p>
        pub fn terminology_properties(
            mut self,
            input: crate::model::TerminologyProperties,
        ) -> Self {
            self.terminology_properties = Some(input);
            self
        }
        /// <p>The properties of the custom terminology being retrieved.</p>
        pub fn set_terminology_properties(
            mut self,
            input: std::option::Option<crate::model::TerminologyProperties>,
        ) -> Self {
            self.terminology_properties = input;
            self
        }
        /// <p>The data location of the custom terminology being retrieved. The custom terminology file
        /// is returned in a presigned url that has a 30 minute expiration.</p>
        pub fn terminology_data_location(
            mut self,
            input: crate::model::TerminologyDataLocation,
        ) -> Self {
            self.terminology_data_location = Some(input);
            self
        }
        /// <p>The data location of the custom terminology being retrieved. The custom terminology file
        /// is returned in a presigned url that has a 30 minute expiration.</p>
        pub fn set_terminology_data_location(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataLocation>,
        ) -> Self {
            self.terminology_data_location = input;
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to create a
        /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn auxiliary_data_location(
            mut self,
            input: crate::model::TerminologyDataLocation,
        ) -> Self {
            self.auxiliary_data_location = Some(input);
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to create a
        /// terminology resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn set_auxiliary_data_location(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataLocation>,
        ) -> Self {
            self.auxiliary_data_location = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTerminologyOutput`](crate::output::GetTerminologyOutput)
        pub fn build(self) -> crate::output::GetTerminologyOutput {
            crate::output::GetTerminologyOutput {
                terminology_properties: self.terminology_properties,
                terminology_data_location: self.terminology_data_location,
                auxiliary_data_location: self.auxiliary_data_location,
            }
        }
    }
}
impl GetTerminologyOutput {
    /// Creates a new builder-style object to manufacture [`GetTerminologyOutput`](crate::output::GetTerminologyOutput)
    pub fn builder() -> crate::output::get_terminology_output::Builder {
        crate::output::get_terminology_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetParallelDataOutput {
    /// <p>The properties of the parallel data resource that is being retrieved.</p>
    pub parallel_data_properties: std::option::Option<crate::model::ParallelDataProperties>,
    /// <p>The Amazon S3 location of the most recent parallel data input file that was successfully
    /// imported into Amazon Translate. The location is returned as a presigned URL that has a 30
    /// minute expiration.</p>
    ///
    /// <important>
    /// <p>Amazon Translate doesn't scan parallel data input files for the risk of CSV injection
    /// attacks. </p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
    /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
    /// file is opened in a spreadsheet program, the program might interpret the record as a formula
    /// and run the code within it.</p>
    /// <p>Before you download a parallel data input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub data_location: std::option::Option<crate::model::ParallelDataDataLocation>,
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to create a parallel
    /// data resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub auxiliary_data_location: std::option::Option<crate::model::ParallelDataDataLocation>,
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to update a parallel
    /// data resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub latest_update_attempt_auxiliary_data_location:
        std::option::Option<crate::model::ParallelDataDataLocation>,
}
impl GetParallelDataOutput {
    /// <p>The properties of the parallel data resource that is being retrieved.</p>
    pub fn parallel_data_properties(
        &self,
    ) -> std::option::Option<&crate::model::ParallelDataProperties> {
        self.parallel_data_properties.as_ref()
    }
    /// <p>The Amazon S3 location of the most recent parallel data input file that was successfully
    /// imported into Amazon Translate. The location is returned as a presigned URL that has a 30
    /// minute expiration.</p>
    ///
    /// <important>
    /// <p>Amazon Translate doesn't scan parallel data input files for the risk of CSV injection
    /// attacks. </p>
    /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
    /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
    /// file is opened in a spreadsheet program, the program might interpret the record as a formula
    /// and run the code within it.</p>
    /// <p>Before you download a parallel data input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
    /// </important>
    pub fn data_location(&self) -> std::option::Option<&crate::model::ParallelDataDataLocation> {
        self.data_location.as_ref()
    }
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to create a parallel
    /// data resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub fn auxiliary_data_location(
        &self,
    ) -> std::option::Option<&crate::model::ParallelDataDataLocation> {
        self.auxiliary_data_location.as_ref()
    }
    /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
    /// by your input file. This file was created when Amazon Translate attempted to update a parallel
    /// data resource. The location is returned as a presigned URL to that has a 30 minute
    /// expiration.</p>
    pub fn latest_update_attempt_auxiliary_data_location(
        &self,
    ) -> std::option::Option<&crate::model::ParallelDataDataLocation> {
        self.latest_update_attempt_auxiliary_data_location.as_ref()
    }
}
impl std::fmt::Debug for GetParallelDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetParallelDataOutput");
        formatter.field("parallel_data_properties", &self.parallel_data_properties);
        formatter.field("data_location", &self.data_location);
        formatter.field("auxiliary_data_location", &self.auxiliary_data_location);
        formatter.field(
            "latest_update_attempt_auxiliary_data_location",
            &self.latest_update_attempt_auxiliary_data_location,
        );
        formatter.finish()
    }
}
/// See [`GetParallelDataOutput`](crate::output::GetParallelDataOutput)
pub mod get_parallel_data_output {
    /// A builder for [`GetParallelDataOutput`](crate::output::GetParallelDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parallel_data_properties:
            std::option::Option<crate::model::ParallelDataProperties>,
        pub(crate) data_location: std::option::Option<crate::model::ParallelDataDataLocation>,
        pub(crate) auxiliary_data_location:
            std::option::Option<crate::model::ParallelDataDataLocation>,
        pub(crate) latest_update_attempt_auxiliary_data_location:
            std::option::Option<crate::model::ParallelDataDataLocation>,
    }
    impl Builder {
        /// <p>The properties of the parallel data resource that is being retrieved.</p>
        pub fn parallel_data_properties(
            mut self,
            input: crate::model::ParallelDataProperties,
        ) -> Self {
            self.parallel_data_properties = Some(input);
            self
        }
        /// <p>The properties of the parallel data resource that is being retrieved.</p>
        pub fn set_parallel_data_properties(
            mut self,
            input: std::option::Option<crate::model::ParallelDataProperties>,
        ) -> Self {
            self.parallel_data_properties = input;
            self
        }
        /// <p>The Amazon S3 location of the most recent parallel data input file that was successfully
        /// imported into Amazon Translate. The location is returned as a presigned URL that has a 30
        /// minute expiration.</p>
        ///
        /// <important>
        /// <p>Amazon Translate doesn't scan parallel data input files for the risk of CSV injection
        /// attacks. </p>
        /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
        /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
        /// file is opened in a spreadsheet program, the program might interpret the record as a formula
        /// and run the code within it.</p>
        /// <p>Before you download a parallel data input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
        /// </important>
        pub fn data_location(mut self, input: crate::model::ParallelDataDataLocation) -> Self {
            self.data_location = Some(input);
            self
        }
        /// <p>The Amazon S3 location of the most recent parallel data input file that was successfully
        /// imported into Amazon Translate. The location is returned as a presigned URL that has a 30
        /// minute expiration.</p>
        ///
        /// <important>
        /// <p>Amazon Translate doesn't scan parallel data input files for the risk of CSV injection
        /// attacks. </p>
        /// <p>CSV injection occurs when a .csv or .tsv file is altered so that a record contains
        /// malicious code. The record begins with a special character, such as =, +, -, or @. When the
        /// file is opened in a spreadsheet program, the program might interpret the record as a formula
        /// and run the code within it.</p>
        /// <p>Before you download a parallel data input file from Amazon S3, ensure that you recognize the file and trust its creator.</p>
        /// </important>
        pub fn set_data_location(
            mut self,
            input: std::option::Option<crate::model::ParallelDataDataLocation>,
        ) -> Self {
            self.data_location = input;
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to create a parallel
        /// data resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn auxiliary_data_location(
            mut self,
            input: crate::model::ParallelDataDataLocation,
        ) -> Self {
            self.auxiliary_data_location = Some(input);
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to create a parallel
        /// data resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn set_auxiliary_data_location(
            mut self,
            input: std::option::Option<crate::model::ParallelDataDataLocation>,
        ) -> Self {
            self.auxiliary_data_location = input;
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to update a parallel
        /// data resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn latest_update_attempt_auxiliary_data_location(
            mut self,
            input: crate::model::ParallelDataDataLocation,
        ) -> Self {
            self.latest_update_attempt_auxiliary_data_location = Some(input);
            self
        }
        /// <p>The Amazon S3 location of a file that provides any errors or warnings that were produced
        /// by your input file. This file was created when Amazon Translate attempted to update a parallel
        /// data resource. The location is returned as a presigned URL to that has a 30 minute
        /// expiration.</p>
        pub fn set_latest_update_attempt_auxiliary_data_location(
            mut self,
            input: std::option::Option<crate::model::ParallelDataDataLocation>,
        ) -> Self {
            self.latest_update_attempt_auxiliary_data_location = input;
            self
        }
        /// Consumes the builder and constructs a [`GetParallelDataOutput`](crate::output::GetParallelDataOutput)
        pub fn build(self) -> crate::output::GetParallelDataOutput {
            crate::output::GetParallelDataOutput {
                parallel_data_properties: self.parallel_data_properties,
                data_location: self.data_location,
                auxiliary_data_location: self.auxiliary_data_location,
                latest_update_attempt_auxiliary_data_location: self
                    .latest_update_attempt_auxiliary_data_location,
            }
        }
    }
}
impl GetParallelDataOutput {
    /// Creates a new builder-style object to manufacture [`GetParallelDataOutput`](crate::output::GetParallelDataOutput)
    pub fn builder() -> crate::output::get_parallel_data_output::Builder {
        crate::output::get_parallel_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTextTranslationJobOutput {
    /// <p>An object that contains the properties associated with an asynchronous batch translation
    /// job.</p>
    pub text_translation_job_properties:
        std::option::Option<crate::model::TextTranslationJobProperties>,
}
impl DescribeTextTranslationJobOutput {
    /// <p>An object that contains the properties associated with an asynchronous batch translation
    /// job.</p>
    pub fn text_translation_job_properties(
        &self,
    ) -> std::option::Option<&crate::model::TextTranslationJobProperties> {
        self.text_translation_job_properties.as_ref()
    }
}
impl std::fmt::Debug for DescribeTextTranslationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTextTranslationJobOutput");
        formatter.field(
            "text_translation_job_properties",
            &self.text_translation_job_properties,
        );
        formatter.finish()
    }
}
/// See [`DescribeTextTranslationJobOutput`](crate::output::DescribeTextTranslationJobOutput)
pub mod describe_text_translation_job_output {
    /// A builder for [`DescribeTextTranslationJobOutput`](crate::output::DescribeTextTranslationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_translation_job_properties:
            std::option::Option<crate::model::TextTranslationJobProperties>,
    }
    impl Builder {
        /// <p>An object that contains the properties associated with an asynchronous batch translation
        /// job.</p>
        pub fn text_translation_job_properties(
            mut self,
            input: crate::model::TextTranslationJobProperties,
        ) -> Self {
            self.text_translation_job_properties = Some(input);
            self
        }
        /// <p>An object that contains the properties associated with an asynchronous batch translation
        /// job.</p>
        pub fn set_text_translation_job_properties(
            mut self,
            input: std::option::Option<crate::model::TextTranslationJobProperties>,
        ) -> Self {
            self.text_translation_job_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTextTranslationJobOutput`](crate::output::DescribeTextTranslationJobOutput)
        pub fn build(self) -> crate::output::DescribeTextTranslationJobOutput {
            crate::output::DescribeTextTranslationJobOutput {
                text_translation_job_properties: self.text_translation_job_properties,
            }
        }
    }
}
impl DescribeTextTranslationJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTextTranslationJobOutput`](crate::output::DescribeTextTranslationJobOutput)
    pub fn builder() -> crate::output::describe_text_translation_job_output::Builder {
        crate::output::describe_text_translation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTerminologyOutput {}
impl std::fmt::Debug for DeleteTerminologyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTerminologyOutput");
        formatter.finish()
    }
}
/// See [`DeleteTerminologyOutput`](crate::output::DeleteTerminologyOutput)
pub mod delete_terminology_output {
    /// A builder for [`DeleteTerminologyOutput`](crate::output::DeleteTerminologyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTerminologyOutput`](crate::output::DeleteTerminologyOutput)
        pub fn build(self) -> crate::output::DeleteTerminologyOutput {
            crate::output::DeleteTerminologyOutput {}
        }
    }
}
impl DeleteTerminologyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTerminologyOutput`](crate::output::DeleteTerminologyOutput)
    pub fn builder() -> crate::output::delete_terminology_output::Builder {
        crate::output::delete_terminology_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteParallelDataOutput {
    /// <p>The name of the parallel data resource that is being deleted.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the parallel data deletion.</p>
    pub status: std::option::Option<crate::model::ParallelDataStatus>,
}
impl DeleteParallelDataOutput {
    /// <p>The name of the parallel data resource that is being deleted.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the parallel data deletion.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ParallelDataStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DeleteParallelDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteParallelDataOutput");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteParallelDataOutput`](crate::output::DeleteParallelDataOutput)
pub mod delete_parallel_data_output {
    /// A builder for [`DeleteParallelDataOutput`](crate::output::DeleteParallelDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ParallelDataStatus>,
    }
    impl Builder {
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the parallel data deletion.</p>
        pub fn status(mut self, input: crate::model::ParallelDataStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the parallel data deletion.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ParallelDataStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteParallelDataOutput`](crate::output::DeleteParallelDataOutput)
        pub fn build(self) -> crate::output::DeleteParallelDataOutput {
            crate::output::DeleteParallelDataOutput {
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl DeleteParallelDataOutput {
    /// Creates a new builder-style object to manufacture [`DeleteParallelDataOutput`](crate::output::DeleteParallelDataOutput)
    pub fn builder() -> crate::output::delete_parallel_data_output::Builder {
        crate::output::delete_parallel_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateParallelDataOutput {
    /// <p>The custom name that you assigned to the parallel data resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the parallel data resource. When the resource is ready for you to use, the
    /// status is <code>ACTIVE</code>.</p>
    pub status: std::option::Option<crate::model::ParallelDataStatus>,
}
impl CreateParallelDataOutput {
    /// <p>The custom name that you assigned to the parallel data resource.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the parallel data resource. When the resource is ready for you to use, the
    /// status is <code>ACTIVE</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ParallelDataStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CreateParallelDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateParallelDataOutput");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateParallelDataOutput`](crate::output::CreateParallelDataOutput)
pub mod create_parallel_data_output {
    /// A builder for [`CreateParallelDataOutput`](crate::output::CreateParallelDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ParallelDataStatus>,
    }
    impl Builder {
        /// <p>The custom name that you assigned to the parallel data resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name that you assigned to the parallel data resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the parallel data resource. When the resource is ready for you to use, the
        /// status is <code>ACTIVE</code>.</p>
        pub fn status(mut self, input: crate::model::ParallelDataStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the parallel data resource. When the resource is ready for you to use, the
        /// status is <code>ACTIVE</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ParallelDataStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateParallelDataOutput`](crate::output::CreateParallelDataOutput)
        pub fn build(self) -> crate::output::CreateParallelDataOutput {
            crate::output::CreateParallelDataOutput {
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl CreateParallelDataOutput {
    /// Creates a new builder-style object to manufacture [`CreateParallelDataOutput`](crate::output::CreateParallelDataOutput)
    pub fn builder() -> crate::output::create_parallel_data_output::Builder {
        crate::output::create_parallel_data_output::Builder::default()
    }
}
