// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSShineFrontendService_20170701`.
///
/// This client allows ergonomic access to a `AWSShineFrontendService_20170701`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateParallelData` operation.
    ///
    /// See [`CreateParallelData`](crate::client::fluent_builders::CreateParallelData) for more information about the
    /// operation and its arguments.
    pub fn create_parallel_data(&self) -> fluent_builders::CreateParallelData<C, M, R> {
        fluent_builders::CreateParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteParallelData` operation.
    ///
    /// See [`DeleteParallelData`](crate::client::fluent_builders::DeleteParallelData) for more information about the
    /// operation and its arguments.
    pub fn delete_parallel_data(&self) -> fluent_builders::DeleteParallelData<C, M, R> {
        fluent_builders::DeleteParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTerminology` operation.
    ///
    /// See [`DeleteTerminology`](crate::client::fluent_builders::DeleteTerminology) for more information about the
    /// operation and its arguments.
    pub fn delete_terminology(&self) -> fluent_builders::DeleteTerminology<C, M, R> {
        fluent_builders::DeleteTerminology::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTextTranslationJob` operation.
    ///
    /// See [`DescribeTextTranslationJob`](crate::client::fluent_builders::DescribeTextTranslationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_text_translation_job(
        &self,
    ) -> fluent_builders::DescribeTextTranslationJob<C, M, R> {
        fluent_builders::DescribeTextTranslationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetParallelData` operation.
    ///
    /// See [`GetParallelData`](crate::client::fluent_builders::GetParallelData) for more information about the
    /// operation and its arguments.
    pub fn get_parallel_data(&self) -> fluent_builders::GetParallelData<C, M, R> {
        fluent_builders::GetParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTerminology` operation.
    ///
    /// See [`GetTerminology`](crate::client::fluent_builders::GetTerminology) for more information about the
    /// operation and its arguments.
    pub fn get_terminology(&self) -> fluent_builders::GetTerminology<C, M, R> {
        fluent_builders::GetTerminology::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportTerminology` operation.
    ///
    /// See [`ImportTerminology`](crate::client::fluent_builders::ImportTerminology) for more information about the
    /// operation and its arguments.
    pub fn import_terminology(&self) -> fluent_builders::ImportTerminology<C, M, R> {
        fluent_builders::ImportTerminology::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListParallelData` operation.
    ///
    /// See [`ListParallelData`](crate::client::fluent_builders::ListParallelData) for more information about the
    /// operation and its arguments.
    pub fn list_parallel_data(&self) -> fluent_builders::ListParallelData<C, M, R> {
        fluent_builders::ListParallelData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTerminologies` operation.
    ///
    /// See [`ListTerminologies`](crate::client::fluent_builders::ListTerminologies) for more information about the
    /// operation and its arguments.
    pub fn list_terminologies(&self) -> fluent_builders::ListTerminologies<C, M, R> {
        fluent_builders::ListTerminologies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTextTranslationJobs` operation.
    ///
    /// See [`ListTextTranslationJobs`](crate::client::fluent_builders::ListTextTranslationJobs) for more information about the
    /// operation and its arguments.
    pub fn list_text_translation_jobs(&self) -> fluent_builders::ListTextTranslationJobs<C, M, R> {
        fluent_builders::ListTextTranslationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTextTranslationJob` operation.
    ///
    /// See [`StartTextTranslationJob`](crate::client::fluent_builders::StartTextTranslationJob) for more information about the
    /// operation and its arguments.
    pub fn start_text_translation_job(&self) -> fluent_builders::StartTextTranslationJob<C, M, R> {
        fluent_builders::StartTextTranslationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopTextTranslationJob` operation.
    ///
    /// See [`StopTextTranslationJob`](crate::client::fluent_builders::StopTextTranslationJob) for more information about the
    /// operation and its arguments.
    pub fn stop_text_translation_job(&self) -> fluent_builders::StopTextTranslationJob<C, M, R> {
        fluent_builders::StopTextTranslationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TranslateText` operation.
    ///
    /// See [`TranslateText`](crate::client::fluent_builders::TranslateText) for more information about the
    /// operation and its arguments.
    pub fn translate_text(&self) -> fluent_builders::TranslateText<C, M, R> {
        fluent_builders::TranslateText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateParallelData` operation.
    ///
    /// See [`UpdateParallelData`](crate::client::fluent_builders::UpdateParallelData) for more information about the
    /// operation and its arguments.
    pub fn update_parallel_data(&self) -> fluent_builders::UpdateParallelData<C, M, R> {
        fluent_builders::UpdateParallelData::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateParallelData`.
    ///
    /// <p>Creates a parallel data resource in Amazon Translate by importing an input file from
    /// Amazon S3. Parallel data files contain examples that show how you want segments of text to be
    /// translated. By adding parallel data, you can influence the style, tone, and word choice in
    /// your translation output.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateParallelData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_parallel_data_input::Builder,
    }
    impl<C, M, R> CreateParallelData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateParallelDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateParallelDataInputOperationOutputAlias,
                crate::output::CreateParallelDataOutput,
                crate::error::CreateParallelDataError,
                crate::input::CreateParallelDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name
        /// that is unique in the account and region.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A custom name for the parallel data resource in Amazon Translate. You must assign a name
        /// that is unique in the account and region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, inp: crate::model::ParallelDataConfig) -> Self {
            self.inner = self.inner.parallel_data_config(inp);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_parallel_data_config(input);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn encryption_key(mut self, inp: crate::model::EncryptionKey) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>The encryption key used to encrypt this object.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use
        /// Amazon Translate through an AWS SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use
        /// Amazon Translate through an AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteParallelData`.
    ///
    /// <p>Deletes a parallel data resource in Amazon Translate.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteParallelData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_parallel_data_input::Builder,
    }
    impl<C, M, R> DeleteParallelData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteParallelDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteParallelDataInputOperationOutputAlias,
                crate::output::DeleteParallelDataOutput,
                crate::error::DeleteParallelDataError,
                crate::input::DeleteParallelDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parallel data resource that is being deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTerminology`.
    ///
    /// <p>A synchronous action that deletes a custom terminology.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTerminology<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_terminology_input::Builder,
    }
    impl<C, M, R> DeleteTerminology<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTerminology`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTerminologyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTerminologyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTerminologyInputOperationOutputAlias,
                crate::output::DeleteTerminologyOutput,
                crate::error::DeleteTerminologyError,
                crate::input::DeleteTerminologyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom terminology being deleted. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the custom terminology being deleted. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTextTranslationJob`.
    ///
    /// <p>Gets the properties associated with an asynchronous batch translation job including name,
    /// ID, status, source and target languages, input/output S3 buckets, and so on.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTextTranslationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_text_translation_job_input::Builder,
    }
    impl<C, M, R> DescribeTextTranslationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTextTranslationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTextTranslationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTextTranslationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTextTranslationJobInputOperationOutputAlias,
                crate::output::DescribeTextTranslationJobOutput,
                crate::error::DescribeTextTranslationJobError,
                crate::input::DescribeTextTranslationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Translate generated for the job. The <a>StartTextTranslationJob</a> operation returns this identifier in its
        /// response.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier that Amazon Translate generated for the job. The <a>StartTextTranslationJob</a> operation returns this identifier in its
        /// response.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetParallelData`.
    ///
    /// <p>Provides information about a parallel data resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetParallelData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_parallel_data_input::Builder,
    }
    impl<C, M, R> GetParallelData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetParallelDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetParallelDataInputOperationOutputAlias,
                crate::output::GetParallelDataOutput,
                crate::error::GetParallelDataError,
                crate::input::GetParallelDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parallel data resource that is being retrieved.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parallel data resource that is being retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTerminology`.
    ///
    /// <p>Retrieves a custom terminology.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTerminology<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_terminology_input::Builder,
    }
    impl<C, M, R> GetTerminology<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTerminology`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTerminologyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTerminologyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTerminologyInputOperationOutputAlias,
                crate::output::GetTerminologyOutput,
                crate::error::GetTerminologyError,
                crate::input::GetTerminologyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom terminology being retrieved.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the custom terminology being retrieved.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The data format of the custom terminology being retrieved.</p>
        /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same
        /// format as the file that was imported to create the terminology. </p>
        /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource,
        /// you must specify the same format as that of the input file that was imported to create it.
        /// Otherwise, Amazon Translate throws an error.</p>
        pub fn terminology_data_format(mut self, inp: crate::model::TerminologyDataFormat) -> Self {
            self.inner = self.inner.terminology_data_format(inp);
            self
        }
        /// <p>The data format of the custom terminology being retrieved.</p>
        /// <p>If you don't specify this parameter, Amazon Translate returns a file that has the same
        /// format as the file that was imported to create the terminology. </p>
        /// <p>If you specify this parameter when you retrieve a multi-directional terminology resource,
        /// you must specify the same format as that of the input file that was imported to create it.
        /// Otherwise, Amazon Translate throws an error.</p>
        pub fn set_terminology_data_format(
            mut self,
            input: std::option::Option<crate::model::TerminologyDataFormat>,
        ) -> Self {
            self.inner = self.inner.set_terminology_data_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportTerminology`.
    ///
    /// <p>Creates or updates a custom terminology, depending on whether or not one already exists
    /// for the given terminology name. Importing a terminology with the same name as an existing one
    /// will merge the terminologies based on the chosen merge strategy. Currently, the only supported
    /// merge strategy is OVERWRITE, and so the imported terminology will overwrite an existing
    /// terminology of the same name.</p>
    /// <p>If you import a terminology that overwrites an existing one, the new terminology take up
    /// to 10 minutes to fully propagate and be available for use in a translation due to cache
    /// policies with the DataPlane service that performs the translations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportTerminology<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_terminology_input::Builder,
    }
    impl<C, M, R> ImportTerminology<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportTerminology`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportTerminologyOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportTerminologyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportTerminologyInputOperationOutputAlias,
                crate::output::ImportTerminologyOutput,
                crate::error::ImportTerminologyError,
                crate::input::ImportTerminologyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the custom terminology being imported.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the custom terminology being imported.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE
        /// merge strategy is supported. In this case, the imported terminology will overwrite an existing
        /// terminology of the same name.</p>
        pub fn merge_strategy(mut self, inp: crate::model::MergeStrategy) -> Self {
            self.inner = self.inner.merge_strategy(inp);
            self
        }
        /// <p>The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE
        /// merge strategy is supported. In this case, the imported terminology will overwrite an existing
        /// terminology of the same name.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.inner = self.inner.set_merge_strategy(input);
            self
        }
        /// <p>The description of the custom terminology being imported.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the custom terminology being imported.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The terminology data for the custom terminology being imported.</p>
        pub fn terminology_data(mut self, inp: crate::model::TerminologyData) -> Self {
            self.inner = self.inner.terminology_data(inp);
            self
        }
        /// <p>The terminology data for the custom terminology being imported.</p>
        pub fn set_terminology_data(
            mut self,
            input: std::option::Option<crate::model::TerminologyData>,
        ) -> Self {
            self.inner = self.inner.set_terminology_data(input);
            self
        }
        /// <p>The encryption key for the custom terminology being imported.</p>
        pub fn encryption_key(mut self, inp: crate::model::EncryptionKey) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>The encryption key for the custom terminology being imported.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<crate::model::EncryptionKey>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListParallelData`.
    ///
    /// <p>Provides a list of your parallel data resources in Amazon Translate.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListParallelData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_parallel_data_input::Builder,
    }
    impl<C, M, R> ListParallelData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::ListParallelDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListParallelDataInputOperationOutputAlias,
                crate::output::ListParallelDataOutput,
                crate::error::ListParallelDataError,
                crate::input::ListParallelDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string that specifies the next page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A string that specifies the next page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of parallel data resources returned for each request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of parallel data resources returned for each request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTerminologies`.
    ///
    /// <p>Provides a list of custom terminologies associated with your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTerminologies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_terminologies_input::Builder,
    }
    impl<C, M, R> ListTerminologies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTerminologies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTerminologiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTerminologiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTerminologiesInputOperationOutputAlias,
                crate::output::ListTerminologiesOutput,
                crate::error::ListTerminologiesError,
                crate::input::ListTerminologiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to
        /// fetch the next group of custom terminologies. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the request to ListTerminologies was truncated, include the NextToken to
        /// fetch the next group of custom terminologies. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of custom terminologies returned per list request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of custom terminologies returned per list request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTextTranslationJobs`.
    ///
    /// <p>Gets a list of the batch translation jobs that you have submitted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTextTranslationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_text_translation_jobs_input::Builder,
    }
    impl<C, M, R> ListTextTranslationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTextTranslationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTextTranslationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTextTranslationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTextTranslationJobsInputOperationOutputAlias,
                crate::output::ListTextTranslationJobsOutput,
                crate::error::ListTextTranslationJobsError,
                crate::input::ListTextTranslationJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job
        /// name, job status, and submission time. You can only set one filter at a time.</p>
        pub fn filter(mut self, inp: crate::model::TextTranslationJobFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The parameters that specify which batch translation jobs to retrieve. Filters include job
        /// name, job status, and submission time. You can only set one filter at a time.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TextTranslationJobFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in each page. The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in each page. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTextTranslationJob`.
    ///
    /// <p>Starts an asynchronous batch translation job. Batch translation jobs can be used to
    /// translate large volumes of text across multiple documents at once. For more information, see
    /// <a>async</a>.</p>
    ///
    /// <p>Batch translation jobs can be described with the <a>DescribeTextTranslationJob</a> operation, listed with the <a>ListTextTranslationJobs</a> operation, and stopped with the <a>StopTextTranslationJob</a> operation.</p>
    /// <note>
    /// <p>Amazon Translate does not support batch translation of multiple source languages at once.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StartTextTranslationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_text_translation_job_input::Builder,
    }
    impl<C, M, R> StartTextTranslationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTextTranslationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTextTranslationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTextTranslationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTextTranslationJobInputOperationOutputAlias,
                crate::output::StartTextTranslationJobOutput,
                crate::error::StartTextTranslationJobError,
                crate::input::StartTextTranslationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the batch translation job to be performed.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the batch translation job to be performed.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>Specifies the format and S3 location of the input documents for the translation
        /// job.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>Specifies the format and S3 location of the input documents for the translation
        /// job.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies the S3 folder to which your job output will be saved.
        /// </p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>Specifies the S3 folder to which your job output will be saved.
        /// </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role
        /// that grants Amazon Translate read access to your input data. For more information, see <a>identity-and-access-management</a>.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role
        /// that grants Amazon Translate read access to your input data. For more information, see <a>identity-and-access-management</a>.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>The language code of the input language. For a list of language codes, see <a>what-is-languages</a>.</p>
        /// <p>Amazon Translate does not automatically detect a source language during batch translation
        /// jobs.</p>
        pub fn source_language_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_language_code(inp);
            self
        }
        /// <p>The language code of the input language. For a list of language codes, see <a>what-is-languages</a>.</p>
        /// <p>Amazon Translate does not automatically detect a source language during batch translation
        /// jobs.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_language_code(input);
            self
        }
        /// Appends an item to `TargetLanguageCodes`.
        ///
        /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
        ///
        /// <p>The language code of the output language.</p>
        pub fn target_language_codes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_language_codes(inp);
            self
        }
        /// <p>The language code of the output language.</p>
        pub fn set_target_language_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_target_language_codes(input);
            self
        }
        /// Appends an item to `TerminologyNames`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>The name of a custom terminology resource to add to the translation job. This resource
        /// lists examples source terms and the desired translation for each term.</p>
        /// <p>This parameter accepts only one custom terminology resource.</p>
        /// <p>For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.</p>
        /// <p>For more information, see <a>how-custom-terminology</a>.</p>
        pub fn terminology_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.terminology_names(inp);
            self
        }
        /// <p>The name of a custom terminology resource to add to the translation job. This resource
        /// lists examples source terms and the desired translation for each term.</p>
        /// <p>This parameter accepts only one custom terminology resource.</p>
        /// <p>For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.</p>
        /// <p>For more information, see <a>how-custom-terminology</a>.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_terminology_names(input);
            self
        }
        /// Appends an item to `ParallelDataNames`.
        ///
        /// To override the contents of this collection use [`set_parallel_data_names`](Self::set_parallel_data_names).
        ///
        /// <p>The name of a parallel data resource to add to the translation job. This resource consists
        /// of examples that show how you want segments of text to be translated. When you add parallel
        /// data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
        /// <p>This parameter accepts only one parallel data resource.</p>
        /// <note>
        /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't
        /// use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
        /// </note>
        /// <p>For a list of available parallel data resources, use the <a>ListParallelData</a> operation.</p>
        /// <p>For more information, see <a>customizing-translations-parallel-data</a>.</p>
        pub fn parallel_data_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parallel_data_names(inp);
            self
        }
        /// <p>The name of a parallel data resource to add to the translation job. This resource consists
        /// of examples that show how you want segments of text to be translated. When you add parallel
        /// data to a translation job, you create an <i>Active Custom Translation</i> job. </p>
        /// <p>This parameter accepts only one parallel data resource.</p>
        /// <note>
        /// <p>Active Custom Translation jobs are priced at a higher rate than other jobs that don't
        /// use parallel data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.</p>
        /// </note>
        /// <p>For a list of available parallel data resources, use the <a>ListParallelData</a> operation.</p>
        /// <p>For more information, see <a>customizing-translations-parallel-data</a>.</p>
        pub fn set_parallel_data_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_parallel_data_names(input);
            self
        }
        /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate
        /// SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique identifier for the request. This token is auto-generated when using the Amazon Translate
        /// SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTextTranslationJob`.
    ///
    /// <p>Stops an asynchronous batch translation job that is in progress.</p>
    /// <p>If the job's state is <code>IN_PROGRESS</code>, the job will be marked for termination and
    /// put into the <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped,
    /// it is put into the <code>COMPLETED</code> state. Otherwise, the job is put into the
    /// <code>STOPPED</code> state.</p>
    /// <p>Asynchronous batch translation jobs are started with the <a>StartTextTranslationJob</a> operation. You can use the <a>DescribeTextTranslationJob</a> or <a>ListTextTranslationJobs</a>
    /// operations to get a batch translation job's <code>JobId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopTextTranslationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_text_translation_job_input::Builder,
    }
    impl<C, M, R> StopTextTranslationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopTextTranslationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTextTranslationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTextTranslationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopTextTranslationJobInputOperationOutputAlias,
                crate::output::StopTextTranslationJobOutput,
                crate::error::StopTextTranslationJobError,
                crate::input::StopTextTranslationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job ID of the job to be stopped.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The job ID of the job to be stopped.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TranslateText`.
    ///
    /// <p>Translates input text from the source language to the target language. For a list of
    /// available languages and language codes, see <a>what-is-languages</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TranslateText<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::translate_text_input::Builder,
    }
    impl<C, M, R> TranslateText<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TranslateText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TranslateTextOutput,
            aws_smithy_http::result::SdkError<crate::error::TranslateTextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TranslateTextInputOperationOutputAlias,
                crate::output::TranslateTextOutput,
                crate::error::TranslateTextError,
                crate::input::TranslateTextInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on
        /// your character set, this may be fewer than 5,000 characters.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>The text to translate. The text string can be a maximum of 5,000 bytes long. Depending on
        /// your character set, this may be fewer than 5,000 characters.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// Appends an item to `TerminologyNames`.
        ///
        /// To override the contents of this collection use [`set_terminology_names`](Self::set_terminology_names).
        ///
        /// <p>The name of the terminology list file to be used in the TranslateText request. You can use
        /// 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can
        /// contain a maximum of 256 terms.</p>
        pub fn terminology_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.terminology_names(inp);
            self
        }
        /// <p>The name of the terminology list file to be used in the TranslateText request. You can use
        /// 1 terminology list at most in a <code>TranslateText</code> request. Terminology lists can
        /// contain a maximum of 256 terms.</p>
        pub fn set_terminology_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_terminology_names(input);
            self
        }
        /// <p>The language code for the language of the source text. The language must be a language
        /// supported by Amazon Translate. For a list of language codes, see <a>what-is-languages</a>.</p>
        /// <p>To have Amazon Translate determine the source language of your text, you can specify
        /// <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify
        /// <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon
        /// Comprehend</a> to determine the source language.</p>
        pub fn source_language_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_language_code(inp);
            self
        }
        /// <p>The language code for the language of the source text. The language must be a language
        /// supported by Amazon Translate. For a list of language codes, see <a>what-is-languages</a>.</p>
        /// <p>To have Amazon Translate determine the source language of your text, you can specify
        /// <code>auto</code> in the <code>SourceLanguageCode</code> field. If you specify
        /// <code>auto</code>, Amazon Translate will call <a href="https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html">Amazon
        /// Comprehend</a> to determine the source language.</p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_language_code(input);
            self
        }
        /// <p>The language code requested for the language of the target text. The language must be a
        /// language supported by Amazon Translate.</p>
        pub fn target_language_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_language_code(inp);
            self
        }
        /// <p>The language code requested for the language of the target text. The language must be a
        /// language supported by Amazon Translate.</p>
        pub fn set_target_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateParallelData`.
    ///
    /// <p>Updates a previously created parallel data resource by importing a new input file from
    /// Amazon S3.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateParallelData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_parallel_data_input::Builder,
    }
    impl<C, M, R> UpdateParallelData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateParallelData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateParallelDataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateParallelDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateParallelDataInputOperationOutputAlias,
                crate::output::UpdateParallelDataOutput,
                crate::error::UpdateParallelDataError,
                crate::input::UpdateParallelDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the parallel data resource being updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A custom description for the parallel data resource in Amazon Translate.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn parallel_data_config(mut self, inp: crate::model::ParallelDataConfig) -> Self {
            self.inner = self.inner.parallel_data_config(inp);
            self
        }
        /// <p>Specifies the format and S3 location of the parallel data input file.</p>
        pub fn set_parallel_data_config(
            mut self,
            input: std::option::Option<crate::model::ParallelDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_parallel_data_config(input);
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use
        /// Amazon Translate through an AWS SDK.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique identifier for the request. This token is automatically generated when you use
        /// Amazon Translate through an AWS SDK.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
