// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateParallelDataError {
    /// Kind of error that occurred.
    pub kind: CreateParallelDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateParallelDataErrorKind {
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p> The request that you made is invalid. Check your request to determine why it's invalid
    /// and then retry the request. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified limit has been exceeded. Review your request and retry it with a quantity
    /// below the stated limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateParallelDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateParallelDataErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateParallelDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateParallelDataErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateParallelDataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateParallelDataErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateParallelDataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateParallelDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateParallelDataError {
    fn code(&self) -> Option<&str> {
        CreateParallelDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateParallelDataError {
    /// Creates a new `CreateParallelDataError`.
    pub fn new(kind: CreateParallelDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateParallelDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateParallelDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateParallelDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateParallelDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateParallelDataErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParallelDataErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParallelDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParallelDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParallelDataErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParallelDataErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParallelDataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParallelDataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParallelDataErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParallelDataErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateParallelDataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateParallelDataErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateParallelDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateParallelDataErrorKind::ConflictException(_inner) => Some(_inner),
            CreateParallelDataErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateParallelDataErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateParallelDataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateParallelDataErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateParallelDataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateParallelDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteParallelDataError {
    /// Kind of error that occurred.
    pub kind: DeleteParallelDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteParallelDataErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make
    /// your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteParallelDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteParallelDataErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteParallelDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteParallelDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteParallelDataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteParallelDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteParallelDataError {
    fn code(&self) -> Option<&str> {
        DeleteParallelDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteParallelDataError {
    /// Creates a new `DeleteParallelDataError`.
    pub fn new(kind: DeleteParallelDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteParallelDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteParallelDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteParallelDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteParallelDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteParallelDataErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParallelDataErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParallelDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParallelDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParallelDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParallelDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteParallelDataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteParallelDataErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteParallelDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteParallelDataErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteParallelDataErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteParallelDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteParallelDataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteParallelDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTerminology` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTerminologyError {
    /// Kind of error that occurred.
    pub kind: DeleteTerminologyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTerminology` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTerminologyErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTerminologyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTerminologyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteTerminologyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteTerminologyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTerminologyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteTerminologyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTerminologyError {
    fn code(&self) -> Option<&str> {
        DeleteTerminologyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTerminologyError {
    /// Creates a new `DeleteTerminologyError`.
    pub fn new(kind: DeleteTerminologyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTerminologyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTerminologyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTerminologyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTerminologyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTerminologyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTerminologyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTerminologyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTerminologyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTerminologyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTerminologyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTerminologyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTerminologyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteTerminologyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTerminologyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteTerminologyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteTerminologyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTerminologyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteTerminologyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTextTranslationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTextTranslationJobError {
    /// Kind of error that occurred.
    pub kind: DescribeTextTranslationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTextTranslationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTextTranslationJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTextTranslationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTextTranslationJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeTextTranslationJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTextTranslationJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeTextTranslationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTextTranslationJobError {
    fn code(&self) -> Option<&str> {
        DescribeTextTranslationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTextTranslationJobError {
    /// Creates a new `DescribeTextTranslationJobError`.
    pub fn new(kind: DescribeTextTranslationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTextTranslationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTextTranslationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTextTranslationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTextTranslationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTextTranslationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTextTranslationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTextTranslationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTextTranslationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTextTranslationJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTextTranslationJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeTextTranslationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTextTranslationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeTextTranslationJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTextTranslationJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeTextTranslationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetParallelDataError {
    /// Kind of error that occurred.
    pub kind: GetParallelDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetParallelDataErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetParallelDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetParallelDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetParallelDataErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetParallelDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetParallelDataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetParallelDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetParallelDataError {
    fn code(&self) -> Option<&str> {
        GetParallelDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetParallelDataError {
    /// Creates a new `GetParallelDataError`.
    pub fn new(kind: GetParallelDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetParallelDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetParallelDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetParallelDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetParallelDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetParallelDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParallelDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParallelDataErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParallelDataErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParallelDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParallelDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetParallelDataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetParallelDataErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetParallelDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetParallelDataErrorKind::InternalServerException(_inner) => Some(_inner),
            GetParallelDataErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetParallelDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetParallelDataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetParallelDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTerminology` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTerminologyError {
    /// Kind of error that occurred.
    pub kind: GetTerminologyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTerminology` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTerminologyErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTerminologyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTerminologyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTerminologyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetTerminologyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetTerminologyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetTerminologyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTerminologyError {
    fn code(&self) -> Option<&str> {
        GetTerminologyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTerminologyError {
    /// Creates a new `GetTerminologyError`.
    pub fn new(kind: GetTerminologyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTerminologyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTerminologyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTerminologyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTerminologyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTerminologyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTerminologyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTerminologyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTerminologyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTerminologyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTerminologyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTerminologyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTerminologyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetTerminologyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTerminologyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTerminologyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetTerminologyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetTerminologyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetTerminologyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportTerminology` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportTerminologyError {
    /// Kind of error that occurred.
    pub kind: ImportTerminologyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportTerminology` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportTerminologyErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified limit has been exceeded. Review your request and retry it with a quantity
    /// below the stated limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportTerminologyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportTerminologyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ImportTerminologyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ImportTerminologyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ImportTerminologyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ImportTerminologyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportTerminologyError {
    fn code(&self) -> Option<&str> {
        ImportTerminologyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportTerminologyError {
    /// Creates a new `ImportTerminologyError`.
    pub fn new(kind: ImportTerminologyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportTerminologyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportTerminologyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportTerminologyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportTerminologyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportTerminologyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportTerminologyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportTerminologyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportTerminologyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportTerminologyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportTerminologyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportTerminologyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportTerminologyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ImportTerminologyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportTerminologyErrorKind::InternalServerException(_inner) => Some(_inner),
            ImportTerminologyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ImportTerminologyErrorKind::LimitExceededException(_inner) => Some(_inner),
            ImportTerminologyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ImportTerminologyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListParallelDataError {
    /// Kind of error that occurred.
    pub kind: ListParallelDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListParallelDataErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListParallelDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListParallelDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListParallelDataErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListParallelDataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListParallelDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListParallelDataError {
    fn code(&self) -> Option<&str> {
        ListParallelDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListParallelDataError {
    /// Creates a new `ListParallelDataError`.
    pub fn new(kind: ListParallelDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListParallelDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListParallelDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListParallelDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListParallelDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListParallelDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListParallelDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListParallelDataErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListParallelDataErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListParallelDataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListParallelDataErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListParallelDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListParallelDataErrorKind::InternalServerException(_inner) => Some(_inner),
            ListParallelDataErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListParallelDataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListParallelDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTerminologies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTerminologiesError {
    /// Kind of error that occurred.
    pub kind: ListTerminologiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTerminologies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTerminologiesErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTerminologiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTerminologiesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTerminologiesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTerminologiesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTerminologiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTerminologiesError {
    fn code(&self) -> Option<&str> {
        ListTerminologiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTerminologiesError {
    /// Creates a new `ListTerminologiesError`.
    pub fn new(kind: ListTerminologiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTerminologiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTerminologiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTerminologiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTerminologiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTerminologiesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTerminologiesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTerminologiesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTerminologiesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTerminologiesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTerminologiesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTerminologiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTerminologiesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTerminologiesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTerminologiesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTerminologiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTextTranslationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTextTranslationJobsError {
    /// Kind of error that occurred.
    pub kind: ListTextTranslationJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTextTranslationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTextTranslationJobsErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
    InvalidFilterException(crate::error::InvalidFilterException),
    /// <p> The request that you made is invalid. Check your request to determine why it's invalid
    /// and then retry the request. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTextTranslationJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTextTranslationJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTextTranslationJobsErrorKind::InvalidFilterException(_inner) => _inner.fmt(f),
            ListTextTranslationJobsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTextTranslationJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTextTranslationJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTextTranslationJobsError {
    fn code(&self) -> Option<&str> {
        ListTextTranslationJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTextTranslationJobsError {
    /// Creates a new `ListTextTranslationJobsError`.
    pub fn new(kind: ListTextTranslationJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTextTranslationJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTextTranslationJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTextTranslationJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTextTranslationJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTextTranslationJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTextTranslationJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTextTranslationJobsErrorKind::InvalidFilterException`.
    pub fn is_invalid_filter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTextTranslationJobsErrorKind::InvalidFilterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTextTranslationJobsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTextTranslationJobsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTextTranslationJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTextTranslationJobsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTextTranslationJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTextTranslationJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTextTranslationJobsErrorKind::InvalidFilterException(_inner) => Some(_inner),
            ListTextTranslationJobsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTextTranslationJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTextTranslationJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTextTranslationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTextTranslationJobError {
    /// Kind of error that occurred.
    pub kind: StartTextTranslationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTextTranslationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTextTranslationJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request that you made is invalid. Check your request to determine why it's invalid
    /// and then retry the request. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>Amazon Translate does not support translation from the language of the source text into the requested
    /// target language. For more information, see <a>how-to-error-msg</a>. </p>
    UnsupportedLanguagePairException(crate::error::UnsupportedLanguagePairException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTextTranslationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTextTranslationJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartTextTranslationJobErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartTextTranslationJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartTextTranslationJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartTextTranslationJobErrorKind::UnsupportedLanguagePairException(_inner) => {
                _inner.fmt(f)
            }
            StartTextTranslationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTextTranslationJobError {
    fn code(&self) -> Option<&str> {
        StartTextTranslationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTextTranslationJobError {
    /// Creates a new `StartTextTranslationJobError`.
    pub fn new(kind: StartTextTranslationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTextTranslationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTextTranslationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTextTranslationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTextTranslationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTextTranslationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTextTranslationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTextTranslationJobErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTextTranslationJobErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTextTranslationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTextTranslationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTextTranslationJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTextTranslationJobErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTextTranslationJobErrorKind::UnsupportedLanguagePairException`.
    pub fn is_unsupported_language_pair_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTextTranslationJobErrorKind::UnsupportedLanguagePairException(_)
        )
    }
}
impl std::error::Error for StartTextTranslationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTextTranslationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartTextTranslationJobErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartTextTranslationJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartTextTranslationJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartTextTranslationJobErrorKind::UnsupportedLanguagePairException(_inner) => {
                Some(_inner)
            }
            StartTextTranslationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopTextTranslationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopTextTranslationJobError {
    /// Kind of error that occurred.
    pub kind: StopTextTranslationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopTextTranslationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopTextTranslationJobErrorKind {
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopTextTranslationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopTextTranslationJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopTextTranslationJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopTextTranslationJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StopTextTranslationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopTextTranslationJobError {
    fn code(&self) -> Option<&str> {
        StopTextTranslationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopTextTranslationJobError {
    /// Creates a new `StopTextTranslationJobError`.
    pub fn new(kind: StopTextTranslationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopTextTranslationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopTextTranslationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopTextTranslationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopTextTranslationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopTextTranslationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTextTranslationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTextTranslationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTextTranslationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTextTranslationJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTextTranslationJobErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StopTextTranslationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopTextTranslationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StopTextTranslationJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopTextTranslationJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StopTextTranslationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TranslateText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TranslateTextError {
    /// Kind of error that occurred.
    pub kind: TranslateTextErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TranslateText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TranslateTextErrorKind {
    /// <p>The confidence that Amazon Comprehend accurately detected the source language is low. If a
    /// low confidence level is acceptable for your application, you can use the language in the
    /// exception to call Amazon Translate again. For more information, see the <a href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer
    /// Guide</i>. </p>
    DetectedLanguageLowConfidenceException(crate::error::DetectedLanguageLowConfidenceException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request that you made is invalid. Check your request to determine why it's invalid
    /// and then retry the request. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Amazon Translate service is temporarily unavailable. Please wait a bit and then retry your
    /// request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p> The size of the text you submitted exceeds the size limit. Reduce the size of the text or
    /// use a smaller document and then retry your request. </p>
    TextSizeLimitExceededException(crate::error::TextSizeLimitExceededException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>Amazon Translate does not support translation from the language of the source text into the requested
    /// target language. For more information, see <a>how-to-error-msg</a>. </p>
    UnsupportedLanguagePairException(crate::error::UnsupportedLanguagePairException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TranslateTextError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TranslateTextErrorKind::DetectedLanguageLowConfidenceException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::TextSizeLimitExceededException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::UnsupportedLanguagePairException(_inner) => _inner.fmt(f),
            TranslateTextErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TranslateTextError {
    fn code(&self) -> Option<&str> {
        TranslateTextError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TranslateTextError {
    /// Creates a new `TranslateTextError`.
    pub fn new(kind: TranslateTextErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TranslateTextError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TranslateTextErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TranslateTextError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TranslateTextErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::DetectedLanguageLowConfidenceException`.
    pub fn is_detected_language_low_confidence_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::DetectedLanguageLowConfidenceException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::TextSizeLimitExceededException`.
    pub fn is_text_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::TextSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `TranslateTextErrorKind::UnsupportedLanguagePairException`.
    pub fn is_unsupported_language_pair_exception(&self) -> bool {
        matches!(
            &self.kind,
            TranslateTextErrorKind::UnsupportedLanguagePairException(_)
        )
    }
}
impl std::error::Error for TranslateTextError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TranslateTextErrorKind::DetectedLanguageLowConfidenceException(_inner) => Some(_inner),
            TranslateTextErrorKind::InternalServerException(_inner) => Some(_inner),
            TranslateTextErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TranslateTextErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TranslateTextErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TranslateTextErrorKind::TextSizeLimitExceededException(_inner) => Some(_inner),
            TranslateTextErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TranslateTextErrorKind::UnsupportedLanguagePairException(_inner) => Some(_inner),
            TranslateTextErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateParallelDataError {
    /// Kind of error that occurred.
    pub kind: UpdateParallelDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateParallelData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateParallelDataErrorKind {
    /// <p>Another modification is being made. That modification must complete before you can make
    /// your change.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
    /// correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p> The request that you made is invalid. Check your request to determine why it's invalid
    /// and then retry the request. </p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified limit has been exceeded. Review your request and retry it with a quantity
    /// below the stated limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking
    /// for and see if a different resource will accomplish your needs before retrying the revised
    /// request.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You have made too many requests within a short period of time. Wait for a short time and
    /// then try your request again.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateParallelDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateParallelDataErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateParallelDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateParallelDataError {
    fn code(&self) -> Option<&str> {
        UpdateParallelDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateParallelDataError {
    /// Creates a new `UpdateParallelDataError`.
    pub fn new(kind: UpdateParallelDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateParallelDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateParallelDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateParallelDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateParallelDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateParallelDataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateParallelDataErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateParallelDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateParallelDataErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateParallelDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> You have made too many requests within a short period of time. Wait for a short time and
/// then try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The resource you are looking for has not been found. Review the resource you're looking
/// for and see if a different resource will accomplish your needs before retrying the revised
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The specified limit has been exceeded. Review your request and retry it with a quantity
/// below the stated limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p> The request that you made is invalid. Check your request to determine why it's invalid
/// and then retry the request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The value of the parameter is invalid. Review the value of the parameter you are using to
/// correct it, and then retry your operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>An internal server error occurred. Retry your request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>There was a conflict processing the request. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Another modification is being made. That modification must complete before you can make
/// your change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>Amazon Translate does not support translation from the language of the source text into the requested
/// target language. For more information, see <a>how-to-error-msg</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedLanguagePairException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The language code for the language of the input text. </p>
    pub source_language_code: std::option::Option<std::string::String>,
    /// <p>The language code for the language of the translated text. </p>
    pub target_language_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedLanguagePairException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedLanguagePairException");
        formatter.field("message", &self.message);
        formatter.field("source_language_code", &self.source_language_code);
        formatter.field("target_language_code", &self.target_language_code);
        formatter.finish()
    }
}
impl UnsupportedLanguagePairException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedLanguagePairException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedLanguagePairException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedLanguagePairException {}
/// See [`UnsupportedLanguagePairException`](crate::error::UnsupportedLanguagePairException)
pub mod unsupported_language_pair_exception {
    /// A builder for [`UnsupportedLanguagePairException`](crate::error::UnsupportedLanguagePairException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) source_language_code: std::option::Option<std::string::String>,
        pub(crate) target_language_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The language code for the language of the input text. </p>
        pub fn source_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_language_code = Some(input.into());
            self
        }
        /// <p>The language code for the language of the input text. </p>
        pub fn set_source_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_language_code = input;
            self
        }
        /// <p>The language code for the language of the translated text. </p>
        pub fn target_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_language_code = Some(input.into());
            self
        }
        /// <p>The language code for the language of the translated text. </p>
        pub fn set_target_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedLanguagePairException`](crate::error::UnsupportedLanguagePairException)
        pub fn build(self) -> crate::error::UnsupportedLanguagePairException {
            crate::error::UnsupportedLanguagePairException {
                message: self.message,
                source_language_code: self.source_language_code,
                target_language_code: self.target_language_code,
            }
        }
    }
}
impl UnsupportedLanguagePairException {
    /// Creates a new builder-style object to manufacture [`UnsupportedLanguagePairException`](crate::error::UnsupportedLanguagePairException)
    pub fn builder() -> crate::error::unsupported_language_pair_exception::Builder {
        crate::error::unsupported_language_pair_exception::Builder::default()
    }
}

/// <p> The size of the text you submitted exceeds the size limit. Reduce the size of the text or
/// use a smaller document and then retry your request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextSizeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TextSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextSizeLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TextSizeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TextSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TextSizeLimitExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for TextSizeLimitExceededException {}
/// See [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
pub mod text_size_limit_exceeded_exception {
    /// A builder for [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
        pub fn build(self) -> crate::error::TextSizeLimitExceededException {
            crate::error::TextSizeLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TextSizeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TextSizeLimitExceededException`](crate::error::TextSizeLimitExceededException)
    pub fn builder() -> crate::error::text_size_limit_exceeded_exception::Builder {
        crate::error::text_size_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The Amazon Translate service is temporarily unavailable. Please wait a bit and then retry your
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The confidence that Amazon Comprehend accurately detected the source language is low. If a
/// low confidence level is acceptable for your application, you can use the language in the
/// exception to call Amazon Translate again. For more information, see the <a href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer
/// Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectedLanguageLowConfidenceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
    pub detected_language_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DetectedLanguageLowConfidenceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectedLanguageLowConfidenceException");
        formatter.field("message", &self.message);
        formatter.field("detected_language_code", &self.detected_language_code);
        formatter.finish()
    }
}
impl DetectedLanguageLowConfidenceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DetectedLanguageLowConfidenceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DetectedLanguageLowConfidenceException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for DetectedLanguageLowConfidenceException {}
/// See [`DetectedLanguageLowConfidenceException`](crate::error::DetectedLanguageLowConfidenceException)
pub mod detected_language_low_confidence_exception {
    /// A builder for [`DetectedLanguageLowConfidenceException`](crate::error::DetectedLanguageLowConfidenceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) detected_language_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
        pub fn detected_language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.detected_language_code = Some(input.into());
            self
        }
        /// <p>The language code of the auto-detected language from Amazon Comprehend.</p>
        pub fn set_detected_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detected_language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectedLanguageLowConfidenceException`](crate::error::DetectedLanguageLowConfidenceException)
        pub fn build(self) -> crate::error::DetectedLanguageLowConfidenceException {
            crate::error::DetectedLanguageLowConfidenceException {
                message: self.message,
                detected_language_code: self.detected_language_code,
            }
        }
    }
}
impl DetectedLanguageLowConfidenceException {
    /// Creates a new builder-style object to manufacture [`DetectedLanguageLowConfidenceException`](crate::error::DetectedLanguageLowConfidenceException)
    pub fn builder() -> crate::error::detected_language_low_confidence_exception::Builder {
        crate::error::detected_language_low_confidence_exception::Builder::default()
    }
}

/// <p>The filter specified for the operation is invalid. Specify a different filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFilterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFilterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFilterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFilterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFilterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFilterException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFilterException {}
/// See [`InvalidFilterException`](crate::error::InvalidFilterException)
pub mod invalid_filter_exception {
    /// A builder for [`InvalidFilterException`](crate::error::InvalidFilterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFilterException`](crate::error::InvalidFilterException)
        pub fn build(self) -> crate::error::InvalidFilterException {
            crate::error::InvalidFilterException {
                message: self.message,
            }
        }
    }
}
impl InvalidFilterException {
    /// Creates a new builder-style object to manufacture [`InvalidFilterException`](crate::error::InvalidFilterException)
    pub fn builder() -> crate::error::invalid_filter_exception::Builder {
        crate::error::invalid_filter_exception::Builder::default()
    }
}
