// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Transfer Family
///
/// Client for invoking operations on AWS Transfer Family. Each operation on AWS Transfer Family is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_transfer::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_transfer::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_transfer::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAccess`](crate::client::fluent_builders::CreateAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`home_directory(impl Into<String>)`](crate::client::fluent_builders::CreateAccess::home_directory) / [`set_home_directory(Option<String>)`](crate::client::fluent_builders::CreateAccess::set_home_directory): <p>The landing directory (folder) for a user when they log in to the server using the client.</p>  <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    ///   - [`home_directory_type(HomeDirectoryType)`](crate::client::fluent_builders::CreateAccess::home_directory_type) / [`set_home_directory_type(Option<HomeDirectoryType>)`](crate::client::fluent_builders::CreateAccess::set_home_directory_type): <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    ///   - [`home_directory_mappings(Vec<HomeDirectoryMapEntry>)`](crate::client::fluent_builders::CreateAccess::home_directory_mappings) / [`set_home_directory_mappings(Option<Vec<HomeDirectoryMapEntry>>)`](crate::client::fluent_builders::CreateAccess::set_home_directory_mappings): <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>  <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>  <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>  <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::CreateAccess::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::CreateAccess::set_policy): <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>   <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>   <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>   <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>   <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>  </note>
    ///   - [`posix_profile(PosixProfile)`](crate::client::fluent_builders::CreateAccess::posix_profile) / [`set_posix_profile(Option<PosixProfile>)`](crate::client::fluent_builders::CreateAccess::set_posix_profile): <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateAccess::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateAccess::set_role): <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccess::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::CreateAccess::set_server_id): <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccess::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::CreateAccess::set_external_id): <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>  <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>  <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>  <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    /// - On success, responds with [`CreateAccessOutput`](crate::output::CreateAccessOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::CreateAccessOutput::server_id): <p>The ID of the server that the user is attached to.</p>
    ///   - [`external_id(Option<String>)`](crate::output::CreateAccessOutput::external_id): <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family.</p>
    /// - On failure, responds with [`SdkError<CreateAccessError>`](crate::error::CreateAccessError)
    pub fn create_access(&self) -> fluent_builders::CreateAccess {
        fluent_builders::CreateAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateServer`](crate::client::fluent_builders::CreateServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate(impl Into<String>)`](crate::client::fluent_builders::CreateServer::certificate) / [`set_certificate(Option<String>)`](crate::client::fluent_builders::CreateServer::set_certificate): <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>  <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>  <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>  <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>  <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p>  <ul>   <li> <p>2048-bit RSA (RSA_2048)</p> </li>   <li> <p>4096-bit RSA (RSA_4096)</p> </li>   <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li>   <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li>   <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li>  </ul> <note>   <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p>  </note>
    ///   - [`domain(Domain)`](crate::client::fluent_builders::CreateServer::domain) / [`set_domain(Option<Domain>)`](crate::client::fluent_builders::CreateServer::set_domain): <p>The domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.</p> <note>   <p>After the server is created, the domain cannot be changed.</p>  </note>
    ///   - [`endpoint_details(EndpointDetails)`](crate::client::fluent_builders::CreateServer::endpoint_details) / [`set_endpoint_details(Option<EndpointDetails>)`](crate::client::fluent_builders::CreateServer::set_endpoint_details): <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
    ///   - [`endpoint_type(EndpointType)`](crate::client::fluent_builders::CreateServer::endpoint_type) / [`set_endpoint_type(Option<EndpointType>)`](crate::client::fluent_builders::CreateServer::set_endpoint_type): <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note>   <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>   <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>   <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>  </note>
    ///   - [`host_key(impl Into<String>)`](crate::client::fluent_builders::CreateServer::host_key) / [`set_host_key(Option<String>)`](crate::client::fluent_builders::CreateServer::set_host_key): <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code> command.</p> <important>   <p>If you aren't planning to migrate existing users from an existing SFTP-enabled server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.</p>  </important>  <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer Family User Guide</i>.</p>
    ///   - [`identity_provider_details(IdentityProviderDetails)`](crate::client::fluent_builders::CreateServer::identity_provider_details) / [`set_identity_provider_details(Option<IdentityProviderDetails>)`](crate::client::fluent_builders::CreateServer::set_identity_provider_details): <p>Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
    ///   - [`identity_provider_type(IdentityProviderType)`](crate::client::fluent_builders::CreateServer::identity_provider_type) / [`set_identity_provider_type(Option<IdentityProviderType>)`](crate::client::fluent_builders::CreateServer::set_identity_provider_type): <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>  <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>  <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>  <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    ///   - [`logging_role(impl Into<String>)`](crate::client::fluent_builders::CreateServer::logging_role) / [`set_logging_role(Option<String>)`](crate::client::fluent_builders::CreateServer::set_logging_role): <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    ///   - [`post_authentication_login_banner(impl Into<String>)`](crate::client::fluent_builders::CreateServer::post_authentication_login_banner) / [`set_post_authentication_login_banner(Option<String>)`](crate::client::fluent_builders::CreateServer::set_post_authentication_login_banner): <p>Specify a string to display when users connect to a server. This string is displayed after the user authenticates.</p> <note>   <p>The SFTP protocol does not support post-authentication display banners.</p>  </note>
    ///   - [`pre_authentication_login_banner(impl Into<String>)`](crate::client::fluent_builders::CreateServer::pre_authentication_login_banner) / [`set_pre_authentication_login_banner(Option<String>)`](crate::client::fluent_builders::CreateServer::set_pre_authentication_login_banner): <p>Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.</p>  <p> <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code> </p>
    ///   - [`protocols(Vec<Protocol>)`](crate::client::fluent_builders::CreateServer::protocols) / [`set_protocols(Option<Vec<Protocol>>)`](crate::client::fluent_builders::CreateServer::set_protocols): <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>  <ul>   <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>   <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>   <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>  </ul> <note>   <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.</p>   <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>   <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p>   <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p>  </note>
    ///   - [`protocol_details(ProtocolDetails)`](crate::client::fluent_builders::CreateServer::protocol_details) / [`set_protocol_details(Option<ProtocolDetails>)`](crate::client::fluent_builders::CreateServer::set_protocol_details): <p>The protocol settings that are configured for your server.</p>  <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>  <p>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</p>
    ///   - [`security_policy_name(impl Into<String>)`](crate::client::fluent_builders::CreateServer::security_policy_name) / [`set_security_policy_name(Option<String>)`](crate::client::fluent_builders::CreateServer::set_security_policy_name): <p>Specifies the name of the security policy that is attached to the server.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateServer::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateServer::set_tags): <p>Key-value pairs that can be used to group and search for servers.</p>
    ///   - [`workflow_details(WorkflowDetails)`](crate::client::fluent_builders::CreateServer::workflow_details) / [`set_workflow_details(Option<WorkflowDetails>)`](crate::client::fluent_builders::CreateServer::set_workflow_details): <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    /// - On success, responds with [`CreateServerOutput`](crate::output::CreateServerOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::CreateServerOutput::server_id): <p>The service-assigned ID of the server that is created.</p>
    /// - On failure, responds with [`SdkError<CreateServerError>`](crate::error::CreateServerError)
    pub fn create_server(&self) -> fluent_builders::CreateServer {
        fluent_builders::CreateServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`home_directory(impl Into<String>)`](crate::client::fluent_builders::CreateUser::home_directory) / [`set_home_directory(Option<String>)`](crate::client::fluent_builders::CreateUser::set_home_directory): <p>The landing directory (folder) for a user when they log in to the server using the client.</p>  <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    ///   - [`home_directory_type(HomeDirectoryType)`](crate::client::fluent_builders::CreateUser::home_directory_type) / [`set_home_directory_type(Option<HomeDirectoryType>)`](crate::client::fluent_builders::CreateUser::set_home_directory_type): <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    ///   - [`home_directory_mappings(Vec<HomeDirectoryMapEntry>)`](crate::client::fluent_builders::CreateUser::home_directory_mappings) / [`set_home_directory_mappings(Option<Vec<HomeDirectoryMapEntry>>)`](crate::client::fluent_builders::CreateUser::set_home_directory_mappings): <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>  <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>  <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory parameter value.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>  <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::CreateUser::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::CreateUser::set_policy): <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>   <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>   <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>   <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>   <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>  </note>
    ///   - [`posix_profile(PosixProfile)`](crate::client::fluent_builders::CreateUser::posix_profile) / [`set_posix_profile(Option<PosixProfile>)`](crate::client::fluent_builders::CreateUser::set_posix_profile): <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in Amazon EFS determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateUser::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateUser::set_role): <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_server_id): <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    ///   - [`ssh_public_key_body(impl Into<String>)`](crate::client::fluent_builders::CreateUser::ssh_public_key_body) / [`set_ssh_public_key_body(Option<String>)`](crate::client::fluent_builders::CreateUser::set_ssh_public_key_body): <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the server.</p> <note>   <p> Currently, Transfer Family does not accept elliptical curve keys (keys beginning with <code>ecdsa</code>). </p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUser::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUser::set_tags): <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached to users for any purpose.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_user_name): <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::CreateUserOutput::server_id): <p>The ID of the server that the user is attached to.</p>
    ///   - [`user_name(Option<String>)`](crate::output::CreateUserOutput::user_name): <p>A unique string that identifies a user account associated with a server.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkflow`](crate::client::fluent_builders::CreateWorkflow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateWorkflow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateWorkflow::set_description): <p>A textual description for the workflow.</p>
    ///   - [`steps(Vec<WorkflowStep>)`](crate::client::fluent_builders::CreateWorkflow::steps) / [`set_steps(Option<Vec<WorkflowStep>>)`](crate::client::fluent_builders::CreateWorkflow::set_steps): <p>Specifies the details for the steps that are in the specified workflow.</p>  <p> The <code>TYPE</code> specifies which of the following actions is being taken for this step. </p>  <ul>   <li> <p> <i>Copy</i>: copy the file to another location</p> </li>   <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>   <li> <p> <i>Delete</i>: delete the file</p> </li>   <li> <p> <i>Tag</i>: add a tag to the file</p> </li>  </ul> <note>   <p> Currently, copying and tagging are supported only on S3. </p>  </note>  <p> For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path. </p>
    ///   - [`on_exception_steps(Vec<WorkflowStep>)`](crate::client::fluent_builders::CreateWorkflow::on_exception_steps) / [`set_on_exception_steps(Option<Vec<WorkflowStep>>)`](crate::client::fluent_builders::CreateWorkflow::set_on_exception_steps): <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p> <note>   <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the exception steps are executed.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateWorkflow::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateWorkflow::set_tags): <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
    /// - On success, responds with [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput) with field(s):
    ///   - [`workflow_id(Option<String>)`](crate::output::CreateWorkflowOutput::workflow_id): <p>A unique identifier for the workflow.</p>
    /// - On failure, responds with [`SdkError<CreateWorkflowError>`](crate::error::CreateWorkflowError)
    pub fn create_workflow(&self) -> fluent_builders::CreateWorkflow {
        fluent_builders::CreateWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccess`](crate::client::fluent_builders::DeleteAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccess::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DeleteAccess::set_server_id): <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccess::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::DeleteAccess::set_external_id): <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>  <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>  <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>  <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    /// - On success, responds with [`DeleteAccessOutput`](crate::output::DeleteAccessOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessError>`](crate::error::DeleteAccessError)
    pub fn delete_access(&self) -> fluent_builders::DeleteAccess {
        fluent_builders::DeleteAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteServer`](crate::client::fluent_builders::DeleteServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DeleteServer::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DeleteServer::set_server_id): <p>A unique system-assigned identifier for a server instance.</p>
    /// - On success, responds with [`DeleteServerOutput`](crate::output::DeleteServerOutput)

    /// - On failure, responds with [`SdkError<DeleteServerError>`](crate::error::DeleteServerError)
    pub fn delete_server(&self) -> fluent_builders::DeleteServer {
        fluent_builders::DeleteServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSshPublicKey`](crate::client::fluent_builders::DeleteSshPublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSshPublicKey::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DeleteSshPublicKey::set_server_id): <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance that has the user assigned to it.</p>
    ///   - [`ssh_public_key_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSshPublicKey::ssh_public_key_id) / [`set_ssh_public_key_id(Option<String>)`](crate::client::fluent_builders::DeleteSshPublicKey::set_ssh_public_key_id): <p>A unique identifier used to reference your user's specific SSH key.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSshPublicKey::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DeleteSshPublicKey::set_user_name): <p>A unique string that identifies a user whose public key is being deleted.</p>
    /// - On success, responds with [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)

    /// - On failure, responds with [`SdkError<DeleteSshPublicKeyError>`](crate::error::DeleteSshPublicKeyError)
    pub fn delete_ssh_public_key(&self) -> fluent_builders::DeleteSshPublicKey {
        fluent_builders::DeleteSshPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_server_id): <p>A system-assigned unique identifier for a server instance that has the user assigned to it.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_name): <p>A unique string that identifies a user that is being deleted from a server.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkflow`](crate::client::fluent_builders::DeleteWorkflow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkflow::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkflow::set_workflow_id): <p>A unique identifier for the workflow.</p>
    /// - On success, responds with [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkflowError>`](crate::error::DeleteWorkflowError)
    pub fn delete_workflow(&self) -> fluent_builders::DeleteWorkflow {
        fluent_builders::DeleteWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccess`](crate::client::fluent_builders::DescribeAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccess::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DescribeAccess::set_server_id): <p>A system-assigned unique identifier for a server that has this access assigned.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccess::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::DescribeAccess::set_external_id): <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>  <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>  <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>  <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    /// - On success, responds with [`DescribeAccessOutput`](crate::output::DescribeAccessOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::DescribeAccessOutput::server_id): <p>A system-assigned unique identifier for a server that has this access assigned.</p>
    ///   - [`access(Option<DescribedAccess>)`](crate::output::DescribeAccessOutput::access): <p>The external ID of the server that the access is attached to.</p>
    /// - On failure, responds with [`SdkError<DescribeAccessError>`](crate::error::DescribeAccessError)
    pub fn describe_access(&self) -> fluent_builders::DescribeAccess {
        fluent_builders::DescribeAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExecution`](crate::client::fluent_builders::DescribeExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`execution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeExecution::execution_id) / [`set_execution_id(Option<String>)`](crate::client::fluent_builders::DescribeExecution::set_execution_id): <p>A unique identifier for the execution of a workflow.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::DescribeExecution::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::DescribeExecution::set_workflow_id): <p>A unique identifier for the workflow.</p>
    /// - On success, responds with [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput) with field(s):
    ///   - [`workflow_id(Option<String>)`](crate::output::DescribeExecutionOutput::workflow_id): <p>A unique identifier for the workflow.</p>
    ///   - [`execution(Option<DescribedExecution>)`](crate::output::DescribeExecutionOutput::execution): <p>The structure that contains the details of the workflow' execution.</p>
    /// - On failure, responds with [`SdkError<DescribeExecutionError>`](crate::error::DescribeExecutionError)
    pub fn describe_execution(&self) -> fluent_builders::DescribeExecution {
        fluent_builders::DescribeExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityPolicy`](crate::client::fluent_builders::DescribeSecurityPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_policy_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityPolicy::security_policy_name) / [`set_security_policy_name(Option<String>)`](crate::client::fluent_builders::DescribeSecurityPolicy::set_security_policy_name): <p>Specifies the name of the security policy that is attached to the server.</p>
    /// - On success, responds with [`DescribeSecurityPolicyOutput`](crate::output::DescribeSecurityPolicyOutput) with field(s):
    ///   - [`security_policy(Option<DescribedSecurityPolicy>)`](crate::output::DescribeSecurityPolicyOutput::security_policy): <p>An array containing the properties of the security policy.</p>
    /// - On failure, responds with [`SdkError<DescribeSecurityPolicyError>`](crate::error::DescribeSecurityPolicyError)
    pub fn describe_security_policy(&self) -> fluent_builders::DescribeSecurityPolicy {
        fluent_builders::DescribeSecurityPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServer`](crate::client::fluent_builders::DescribeServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DescribeServer::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DescribeServer::set_server_id): <p>A system-assigned unique identifier for a server.</p>
    /// - On success, responds with [`DescribeServerOutput`](crate::output::DescribeServerOutput) with field(s):
    ///   - [`server(Option<DescribedServer>)`](crate::output::DescribeServerOutput::server): <p>An array containing the properties of a server with the <code>ServerID</code> you specified.</p>
    /// - On failure, responds with [`SdkError<DescribeServerError>`](crate::error::DescribeServerError)
    pub fn describe_server(&self) -> fluent_builders::DescribeServer {
        fluent_builders::DescribeServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUser`](crate::client::fluent_builders::DescribeUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_server_id): <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_user_name): <p>The name of the user assigned to one or more servers. User names are part of the sign-in credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
    /// - On success, responds with [`DescribeUserOutput`](crate::output::DescribeUserOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::DescribeUserOutput::server_id): <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    ///   - [`user(Option<DescribedUser>)`](crate::output::DescribeUserOutput::user): <p>An array containing the properties of the user account for the <code>ServerID</code> value that you specified.</p>
    /// - On failure, responds with [`SdkError<DescribeUserError>`](crate::error::DescribeUserError)
    pub fn describe_user(&self) -> fluent_builders::DescribeUser {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkflow`](crate::client::fluent_builders::DescribeWorkflow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkflow::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkflow::set_workflow_id): <p>A unique identifier for the workflow.</p>
    /// - On success, responds with [`DescribeWorkflowOutput`](crate::output::DescribeWorkflowOutput) with field(s):
    ///   - [`workflow(Option<DescribedWorkflow>)`](crate::output::DescribeWorkflowOutput::workflow): <p>The structure that contains the details of the workflow.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkflowError>`](crate::error::DescribeWorkflowError)
    pub fn describe_workflow(&self) -> fluent_builders::DescribeWorkflow {
        fluent_builders::DescribeWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportSshPublicKey`](crate::client::fluent_builders::ImportSshPublicKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::ImportSshPublicKey::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::ImportSshPublicKey::set_server_id): <p>A system-assigned unique identifier for a server.</p>
    ///   - [`ssh_public_key_body(impl Into<String>)`](crate::client::fluent_builders::ImportSshPublicKey::ssh_public_key_body) / [`set_ssh_public_key_body(Option<String>)`](crate::client::fluent_builders::ImportSshPublicKey::set_ssh_public_key_body): <p>The public key portion of an SSH key pair.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::ImportSshPublicKey::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::ImportSshPublicKey::set_user_name): <p>The name of the user account that is assigned to one or more servers.</p>
    /// - On success, responds with [`ImportSshPublicKeyOutput`](crate::output::ImportSshPublicKeyOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::ImportSshPublicKeyOutput::server_id): <p>A system-assigned unique identifier for a server.</p>
    ///   - [`ssh_public_key_id(Option<String>)`](crate::output::ImportSshPublicKeyOutput::ssh_public_key_id): <p>The name given to a public key by the system that was imported.</p>
    ///   - [`user_name(Option<String>)`](crate::output::ImportSshPublicKeyOutput::user_name): <p>A user name assigned to the <code>ServerID</code> value that you specified.</p>
    /// - On failure, responds with [`SdkError<ImportSshPublicKeyError>`](crate::error::ImportSshPublicKeyError)
    pub fn import_ssh_public_key(&self) -> fluent_builders::ImportSshPublicKey {
        fluent_builders::ImportSshPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccesses`](crate::client::fluent_builders::ListAccesses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccesses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccesses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccesses::set_max_results): <p>Specifies the maximum number of access SIDs to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccesses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccesses::set_next_token): <p>When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional accesses.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::ListAccesses::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::ListAccesses::set_server_id): <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    /// - On success, responds with [`ListAccessesOutput`](crate::output::ListAccessesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListAccessesOutput::next_token): <p>When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional accesses.</p>
    ///   - [`server_id(Option<String>)`](crate::output::ListAccessesOutput::server_id): <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    ///   - [`accesses(Option<Vec<ListedAccess>>)`](crate::output::ListAccessesOutput::accesses): <p>Returns the accesses and their properties for the <code>ServerId</code> value that you specify.</p>
    /// - On failure, responds with [`SdkError<ListAccessesError>`](crate::error::ListAccessesError)
    pub fn list_accesses(&self) -> fluent_builders::ListAccesses {
        fluent_builders::ListAccesses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExecutions`](crate::client::fluent_builders::ListExecutions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExecutions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExecutions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExecutions::set_max_results): <p>Specifies the aximum number of executions to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExecutions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExecutions::set_next_token): <p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.</p>  <p> This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>: </p>  <p> <code>aws transfer list-executions --max-results 10</code> </p>  <p> This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you received: </p>  <p> <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code> </p>  <p> This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details for all 100 executions have been returned. </p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::ListExecutions::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::ListExecutions::set_workflow_id): <p>A unique identifier for the workflow.</p>
    /// - On success, responds with [`ListExecutionsOutput`](crate::output::ListExecutionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListExecutionsOutput::next_token): <p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.</p>
    ///   - [`workflow_id(Option<String>)`](crate::output::ListExecutionsOutput::workflow_id): <p>A unique identifier for the workflow.</p>
    ///   - [`executions(Option<Vec<ListedExecution>>)`](crate::output::ListExecutionsOutput::executions): <p>Returns the details for each execution.</p>  <ul>   <li> <p> <b>NextToken</b>: returned from a call to several APIs, you can use pass it to a subsequent command to continue listing additional executions.</p> </li>   <li> <p> <b>StartTime</b>: timestamp indicating when the execution began.</p> </li>   <li> <p> <b>Executions</b>: details of the execution, including the execution ID, initial file location, and Service metadata.</p> </li>   <li> <p> <b>Status</b>: one of the following values: <code>IN_PROGRESS</code>, <code>COMPLETED</code>, <code>EXCEPTION</code>, <code>HANDLING_EXEPTION</code>. </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListExecutionsError>`](crate::error::ListExecutionsError)
    pub fn list_executions(&self) -> fluent_builders::ListExecutions {
        fluent_builders::ListExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityPolicies`](crate::client::fluent_builders::ListSecurityPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecurityPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecurityPolicies::set_max_results): <p>Specifies the number of security policies to return as a response to the <code>ListSecurityPolicies</code> query.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecurityPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecurityPolicies::set_next_token): <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional security policies.</p>
    /// - On success, responds with [`ListSecurityPoliciesOutput`](crate::output::ListSecurityPoliciesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListSecurityPoliciesOutput::next_token): <p>When you can get additional results from the <code>ListSecurityPolicies</code> operation, a <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code> parameter to continue listing security policies.</p>
    ///   - [`security_policy_names(Option<Vec<String>>)`](crate::output::ListSecurityPoliciesOutput::security_policy_names): <p>An array of security policies that were listed.</p>
    /// - On failure, responds with [`SdkError<ListSecurityPoliciesError>`](crate::error::ListSecurityPoliciesError)
    pub fn list_security_policies(&self) -> fluent_builders::ListSecurityPolicies {
        fluent_builders::ListSecurityPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServers`](crate::client::fluent_builders::ListServers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServers::set_max_results): <p>Specifies the number of servers to return as a response to the <code>ListServers</code> query.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServers::set_next_token): <p>When additional results are obtained from the <code>ListServers</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional servers.</p>
    /// - On success, responds with [`ListServersOutput`](crate::output::ListServersOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListServersOutput::next_token): <p>When you can get additional results from the <code>ListServers</code> operation, a <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code> parameter to continue listing additional servers.</p>
    ///   - [`servers(Option<Vec<ListedServer>>)`](crate::output::ListServersOutput::servers): <p>An array of servers that were listed.</p>
    /// - On failure, responds with [`SdkError<ListServersError>`](crate::error::ListServersError)
    pub fn list_servers(&self) -> fluent_builders::ListServers {
        fluent_builders::ListServers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_arn): <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>Specifies the number of tags to return as a response to the <code>ListTagsForResource</code> request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>When you request additional results from the <code>ListTagsForResource</code> operation, a <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::ListTagsForResourceOutput::arn): <p>The ARN you specified to list the tags of.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>When you can get additional results from the <code>ListTagsForResource</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and searching for items. Tags are metadata that you define.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsers::set_max_results): <p>Specifies the number of users to return as a response to the <code>ListUsers</code> request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_next_token): <p>When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional users.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_server_id): <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersOutput::next_token): <p>When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional users.</p>
    ///   - [`server_id(Option<String>)`](crate::output::ListUsersOutput::server_id): <p>A system-assigned unique identifier for a server that the users are assigned to.</p>
    ///   - [`users(Option<Vec<ListedUser>>)`](crate::output::ListUsersOutput::users): <p>Returns the user accounts and their properties for the <code>ServerId</code> value that you specify.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkflows`](crate::client::fluent_builders::ListWorkflows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkflows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkflows::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkflows::set_max_results): <p>Specifies the maximum number of workflows to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkflows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkflows::set_next_token): <p> <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.</p>
    /// - On success, responds with [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkflowsOutput::next_token): <p> <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.</p>
    ///   - [`workflows(Option<Vec<ListedWorkflow>>)`](crate::output::ListWorkflowsOutput::workflows): <p>Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.</p>
    /// - On failure, responds with [`SdkError<ListWorkflowsError>`](crate::error::ListWorkflowsError)
    pub fn list_workflows(&self) -> fluent_builders::ListWorkflows {
        fluent_builders::ListWorkflows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SendWorkflowStepState`](crate::client::fluent_builders::SendWorkflowStepState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::SendWorkflowStepState::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::SendWorkflowStepState::set_workflow_id): <p>A unique identifier for the workflow.</p>
    ///   - [`execution_id(impl Into<String>)`](crate::client::fluent_builders::SendWorkflowStepState::execution_id) / [`set_execution_id(Option<String>)`](crate::client::fluent_builders::SendWorkflowStepState::set_execution_id): <p>A unique identifier for the execution of a workflow.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::SendWorkflowStepState::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::SendWorkflowStepState::set_token): <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
    ///   - [`status(CustomStepStatus)`](crate::client::fluent_builders::SendWorkflowStepState::status) / [`set_status(Option<CustomStepStatus>)`](crate::client::fluent_builders::SendWorkflowStepState::set_status): <p>Indicates whether the specified step succeeded or failed.</p>
    /// - On success, responds with [`SendWorkflowStepStateOutput`](crate::output::SendWorkflowStepStateOutput)

    /// - On failure, responds with [`SdkError<SendWorkflowStepStateError>`](crate::error::SendWorkflowStepStateError)
    pub fn send_workflow_step_state(&self) -> fluent_builders::SendWorkflowStepState {
        fluent_builders::SendWorkflowStepState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartServer`](crate::client::fluent_builders::StartServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::StartServer::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::StartServer::set_server_id): <p>A system-assigned unique identifier for a server that you start.</p>
    /// - On success, responds with [`StartServerOutput`](crate::output::StartServerOutput)

    /// - On failure, responds with [`SdkError<StartServerError>`](crate::error::StartServerError)
    pub fn start_server(&self) -> fluent_builders::StartServer {
        fluent_builders::StartServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopServer`](crate::client::fluent_builders::StopServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::StopServer::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::StopServer::set_server_id): <p>A system-assigned unique identifier for a server that you stopped.</p>
    /// - On success, responds with [`StopServerOutput`](crate::output::StopServerOutput)

    /// - On failure, responds with [`SdkError<StopServerError>`](crate::error::StopServerError)
    pub fn stop_server(&self) -> fluent_builders::StopServer {
        fluent_builders::StopServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_arn): <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to user accounts for any purpose.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestIdentityProvider`](crate::client::fluent_builders::TestIdentityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::TestIdentityProvider::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::TestIdentityProvider::set_server_id): <p>A system-assigned identifier for a specific server. That server's user authentication method is tested with a user name and password.</p>
    ///   - [`server_protocol(Protocol)`](crate::client::fluent_builders::TestIdentityProvider::server_protocol) / [`set_server_protocol(Option<Protocol>)`](crate::client::fluent_builders::TestIdentityProvider::set_server_protocol): <p>The type of file transfer protocol to be tested.</p>  <p>The available protocols are:</p>  <ul>   <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p> </li>   <li> <p>File Transfer Protocol Secure (FTPS)</p> </li>   <li> <p>File Transfer Protocol (FTP)</p> </li>  </ul>
    ///   - [`source_ip(impl Into<String>)`](crate::client::fluent_builders::TestIdentityProvider::source_ip) / [`set_source_ip(Option<String>)`](crate::client::fluent_builders::TestIdentityProvider::set_source_ip): <p>The source IP address of the user account to be tested.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::TestIdentityProvider::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::TestIdentityProvider::set_user_name): <p>The name of the user account to be tested.</p>
    ///   - [`user_password(impl Into<String>)`](crate::client::fluent_builders::TestIdentityProvider::user_password) / [`set_user_password(Option<String>)`](crate::client::fluent_builders::TestIdentityProvider::set_user_password): <p>The password of the user account to be tested.</p>
    /// - On success, responds with [`TestIdentityProviderOutput`](crate::output::TestIdentityProviderOutput) with field(s):
    ///   - [`response(Option<String>)`](crate::output::TestIdentityProviderOutput::response): <p>The response that is returned from your API Gateway.</p>
    ///   - [`status_code(i32)`](crate::output::TestIdentityProviderOutput::status_code): <p>The HTTP status code that is the response from your API Gateway.</p>
    ///   - [`message(Option<String>)`](crate::output::TestIdentityProviderOutput::message): <p>A message that indicates whether the test was successful or not.</p> <note>   <p>If an empty string is returned, the most likely cause is that the authentication failed due to an incorrect username or password.</p>  </note>
    ///   - [`url(Option<String>)`](crate::output::TestIdentityProviderOutput::url): <p>The endpoint of the service used to authenticate a user.</p>
    /// - On failure, responds with [`SdkError<TestIdentityProviderError>`](crate::error::TestIdentityProviderError)
    pub fn test_identity_provider(&self) -> fluent_builders::TestIdentityProvider {
        fluent_builders::TestIdentityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_arn): <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for resources by type. This metadata can be attached to resources for any purpose.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccess`](crate::client::fluent_builders::UpdateAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`home_directory(impl Into<String>)`](crate::client::fluent_builders::UpdateAccess::home_directory) / [`set_home_directory(Option<String>)`](crate::client::fluent_builders::UpdateAccess::set_home_directory): <p>The landing directory (folder) for a user when they log in to the server using the client.</p>  <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    ///   - [`home_directory_type(HomeDirectoryType)`](crate::client::fluent_builders::UpdateAccess::home_directory_type) / [`set_home_directory_type(Option<HomeDirectoryType>)`](crate::client::fluent_builders::UpdateAccess::set_home_directory_type): <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    ///   - [`home_directory_mappings(Vec<HomeDirectoryMapEntry>)`](crate::client::fluent_builders::UpdateAccess::home_directory_mappings) / [`set_home_directory_mappings(Option<Vec<HomeDirectoryMapEntry>>)`](crate::client::fluent_builders::UpdateAccess::set_home_directory_mappings): <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>  <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>  <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>  <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::UpdateAccess::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::UpdateAccess::set_policy): <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>   <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>   <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>   <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>   <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API Reference</i>.</p>  </note>
    ///   - [`posix_profile(PosixProfile)`](crate::client::fluent_builders::UpdateAccess::posix_profile) / [`set_posix_profile(Option<PosixProfile>)`](crate::client::fluent_builders::UpdateAccess::set_posix_profile): <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::UpdateAccess::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::UpdateAccess::set_role): <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccess::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::UpdateAccess::set_server_id): <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAccess::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::UpdateAccess::set_external_id): <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>  <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>  <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>  <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    /// - On success, responds with [`UpdateAccessOutput`](crate::output::UpdateAccessOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::UpdateAccessOutput::server_id): <p>The ID of the server that the user is attached to.</p>
    ///   - [`external_id(Option<String>)`](crate::output::UpdateAccessOutput::external_id): <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web ServicesTransfer Family.</p>
    /// - On failure, responds with [`SdkError<UpdateAccessError>`](crate::error::UpdateAccessError)
    pub fn update_access(&self) -> fluent_builders::UpdateAccess {
        fluent_builders::UpdateAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServer`](crate::client::fluent_builders::UpdateServer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::certificate) / [`set_certificate(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_certificate): <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>  <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>  <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>  <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>  <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p>  <ul>   <li> <p>2048-bit RSA (RSA_2048)</p> </li>   <li> <p>4096-bit RSA (RSA_4096)</p> </li>   <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li>   <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li>   <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li>  </ul> <note>   <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p>  </note>
    ///   - [`protocol_details(ProtocolDetails)`](crate::client::fluent_builders::UpdateServer::protocol_details) / [`set_protocol_details(Option<ProtocolDetails>)`](crate::client::fluent_builders::UpdateServer::set_protocol_details): <p> The protocol settings that are configured for your server. </p>  <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>  <p>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</p>
    ///   - [`endpoint_details(EndpointDetails)`](crate::client::fluent_builders::UpdateServer::endpoint_details) / [`set_endpoint_details(Option<EndpointDetails>)`](crate::client::fluent_builders::UpdateServer::set_endpoint_details): <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
    ///   - [`endpoint_type(EndpointType)`](crate::client::fluent_builders::UpdateServer::endpoint_type) / [`set_endpoint_type(Option<EndpointType>)`](crate::client::fluent_builders::UpdateServer::set_endpoint_type): <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note>   <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>   <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>   <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>  </note>
    ///   - [`host_key(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::host_key) / [`set_host_key(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_host_key): <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code>.</p> <important>   <p>If you aren't planning to migrate existing users from an existing server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.</p>  </important>  <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer Family User Guide</i>.</p>
    ///   - [`identity_provider_details(IdentityProviderDetails)`](crate::client::fluent_builders::UpdateServer::identity_provider_details) / [`set_identity_provider_details(Option<IdentityProviderDetails>)`](crate::client::fluent_builders::UpdateServer::set_identity_provider_details): <p>An array containing all of the information required to call a customer's authentication API method.</p>
    ///   - [`logging_role(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::logging_role) / [`set_logging_role(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_logging_role): <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    ///   - [`post_authentication_login_banner(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::post_authentication_login_banner) / [`set_post_authentication_login_banner(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_post_authentication_login_banner): <p>Specify a string to display when users connect to a server. This string is displayed after the user authenticates.</p> <note>   <p>The SFTP protocol does not support post-authentication display banners.</p>  </note>
    ///   - [`pre_authentication_login_banner(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::pre_authentication_login_banner) / [`set_pre_authentication_login_banner(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_pre_authentication_login_banner): <p>Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.</p>  <p> <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code> </p>
    ///   - [`protocols(Vec<Protocol>)`](crate::client::fluent_builders::UpdateServer::protocols) / [`set_protocols(Option<Vec<Protocol>>)`](crate::client::fluent_builders::UpdateServer::set_protocols): <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>  <ul>   <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p> </li>   <li> <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p> </li>   <li> <p>File Transfer Protocol (FTP): Unencrypted file transfer</p> </li>  </ul> <note>   <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate Manager (ACM) which will be used to identify your server when clients connect to it over FTPS.</p>   <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>   <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p>   <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p>  </note>
    ///   - [`security_policy_name(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::security_policy_name) / [`set_security_policy_name(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_security_policy_name): <p>Specifies the name of the security policy that is attached to the server.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateServer::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::UpdateServer::set_server_id): <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
    ///   - [`workflow_details(WorkflowDetails)`](crate::client::fluent_builders::UpdateServer::workflow_details) / [`set_workflow_details(Option<WorkflowDetails>)`](crate::client::fluent_builders::UpdateServer::set_workflow_details): <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    /// - On success, responds with [`UpdateServerOutput`](crate::output::UpdateServerOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::UpdateServerOutput::server_id): <p>A system-assigned unique identifier for a server that the user account is assigned to.</p>
    /// - On failure, responds with [`SdkError<UpdateServerError>`](crate::error::UpdateServerError)
    pub fn update_server(&self) -> fluent_builders::UpdateServer {
        fluent_builders::UpdateServer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUser`](crate::client::fluent_builders::UpdateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`home_directory(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::home_directory) / [`set_home_directory(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_home_directory): <p>The landing directory (folder) for a user when they log in to the server using the client.</p>  <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    ///   - [`home_directory_type(HomeDirectoryType)`](crate::client::fluent_builders::UpdateUser::home_directory_type) / [`set_home_directory_type(Option<HomeDirectoryType>)`](crate::client::fluent_builders::UpdateUser::set_home_directory_type): <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    ///   - [`home_directory_mappings(Vec<HomeDirectoryMapEntry>)`](crate::client::fluent_builders::UpdateUser::home_directory_mappings) / [`set_home_directory_mappings(Option<Vec<HomeDirectoryMapEntry>>)`](crate::client::fluent_builders::UpdateUser::set_home_directory_mappings): <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>  <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>  <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>  <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>  <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_policy): <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>   <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>   <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>   <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session policy</a>.</p>   <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>  </note>
    ///   - [`posix_profile(PosixProfile)`](crate::client::fluent_builders::UpdateUser::posix_profile) / [`set_posix_profile(Option<PosixProfile>)`](crate::client::fluent_builders::UpdateUser::set_posix_profile): <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that are set on files and directories in your file system determines the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_role): <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    ///   - [`server_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::server_id) / [`set_server_id(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_server_id): <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::UpdateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::UpdateUser::set_user_name): <p>A unique string that identifies a user and is associated with a server as specified by the <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.</p>
    /// - On success, responds with [`UpdateUserOutput`](crate::output::UpdateUserOutput) with field(s):
    ///   - [`server_id(Option<String>)`](crate::output::UpdateUserOutput::server_id): <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
    ///   - [`user_name(Option<String>)`](crate::output::UpdateUserOutput::user_name): <p>The unique identifier for a user that is assigned to a server instance that was specified in the request.</p>
    /// - On failure, responds with [`SdkError<UpdateUserError>`](crate::error::UpdateUserError)
    pub fn update_user(&self) -> fluent_builders::UpdateUser {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAccess`.
    ///
    /// <p>Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Amazon Web Services Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use <code>CreateAccess</code> to limit the access to the correct set of users who need this ability.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_access_input::Builder,
    }
    impl CreateAccess {
        /// Creates a new `CreateAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_directory(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_directory(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.inner = self.inner.home_directory_type(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_type(input);
            self
        }
        /// Appends an item to `HomeDirectoryMappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn home_directory_mappings(
            mut self,
            input: crate::model::HomeDirectoryMapEntry,
        ) -> Self {
            self.inner = self.inner.home_directory_mappings(input);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_mappings(input);
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.inner = self.inner.posix_profile(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.inner = self.inner.set_posix_profile(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServer`.
    ///
    /// <p>Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated <code>ServerId</code> property that is assigned to the newly created server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_server_input::Builder,
    }
    impl CreateServer {
        /// Creates a new `CreateServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        /// <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p>
        /// <ul>
        /// <li> <p>2048-bit RSA (RSA_2048)</p> </li>
        /// <li> <p>4096-bit RSA (RSA_4096)</p> </li>
        /// <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li>
        /// </ul> <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p>
        /// </note>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        /// <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p>
        /// <ul>
        /// <li> <p>2048-bit RSA (RSA_2048)</p> </li>
        /// <li> <p>4096-bit RSA (RSA_4096)</p> </li>
        /// <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li>
        /// </ul> <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p>
        /// </note>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
        /// <p>The domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.</p> <note>
        /// <p>After the server is created, the domain cannot be changed.</p>
        /// </note>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.inner = self.inner.domain(input);
            self
        }
        /// <p>The domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.</p> <note>
        /// <p>After the server is created, the domain cannot be changed.</p>
        /// </note>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
        pub fn endpoint_details(mut self, input: crate::model::EndpointDetails) -> Self {
            self.inner = self.inner.endpoint_details(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<crate::model::EndpointDetails>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_details(input);
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note>
        /// <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>
        /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.inner = self.inner.endpoint_type(input);
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note>
        /// <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>
        /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code> command.</p> <important>
        /// <p>If you aren't planning to migrate existing users from an existing SFTP-enabled server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.</p>
        /// </important>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer Family User Guide</i>.</p>
        pub fn host_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_key(input.into());
            self
        }
        /// <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code> command.</p> <important>
        /// <p>If you aren't planning to migrate existing users from an existing SFTP-enabled server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.</p>
        /// </important>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer Family User Guide</i>.</p>
        pub fn set_host_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host_key(input);
            self
        }
        /// <p>Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
        pub fn identity_provider_details(
            mut self,
            input: crate::model::IdentityProviderDetails,
        ) -> Self {
            self.inner = self.inner.identity_provider_details(input);
            self
        }
        /// <p>Required when <code>IdentityProviderType</code> is set to <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or invoke a customer-supplied authentication API, including the API Gateway URL. Not required when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderDetails>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_details(input);
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.inner = self.inner.identity_provider_type(input);
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_type(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logging_role(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_logging_role(input);
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed after the user authenticates.</p> <note>
        /// <p>The SFTP protocol does not support post-authentication display banners.</p>
        /// </note>
        pub fn post_authentication_login_banner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.post_authentication_login_banner(input.into());
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed after the user authenticates.</p> <note>
        /// <p>The SFTP protocol does not support post-authentication display banners.</p>
        /// </note>
        pub fn set_post_authentication_login_banner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_post_authentication_login_banner(input);
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.</p>
        /// <p> <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code> </p>
        pub fn pre_authentication_login_banner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pre_authentication_login_banner(input.into());
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.</p>
        /// <p> <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code> </p>
        pub fn set_pre_authentication_login_banner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_authentication_login_banner(input);
            self
        }
        /// Appends an item to `Protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
        /// <ul>
        /// <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>
        /// <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>
        /// <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>
        /// </ul> <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.</p>
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p>
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn protocols(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocols(input);
            self
        }
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
        /// <ul>
        /// <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>
        /// <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>
        /// <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>
        /// </ul> <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.</p>
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p>
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.inner = self.inner.set_protocols(input);
            self
        }
        /// <p>The protocol settings that are configured for your server.</p>
        /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
        /// <p>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</p>
        pub fn protocol_details(mut self, input: crate::model::ProtocolDetails) -> Self {
            self.inner = self.inner.protocol_details(input);
            self
        }
        /// <p>The protocol settings that are configured for your server.</p>
        /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
        /// <p>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</p>
        pub fn set_protocol_details(
            mut self,
            input: std::option::Option<crate::model::ProtocolDetails>,
        ) -> Self {
            self.inner = self.inner.set_protocol_details(input);
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_policy_name(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_policy_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for servers.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for servers.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn workflow_details(mut self, input: crate::model::WorkflowDetails) -> Self {
            self.inner = self.inner.workflow_details(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn set_workflow_details(
            mut self,
            input: std::option::Option<crate::model::WorkflowDetails>,
        ) -> Self {
            self.inner = self.inner.set_workflow_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the <code>IdentityProviderType</code> set to <code>SERVICE_MANAGED</code>. Using parameters for <code>CreateUser</code>, you can specify the user name, set the home directory, store the user's public key, and assign the user's Amazon Web Services Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_user_input::Builder,
    }
    impl CreateUser {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_directory(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_directory(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.inner = self.inner.home_directory_type(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_type(input);
            self
        }
        /// Appends an item to `HomeDirectoryMappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn home_directory_mappings(
            mut self,
            input: crate::model::HomeDirectoryMapEntry,
        ) -> Self {
            self.inner = self.inner.home_directory_mappings(input);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_mappings(input);
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in Amazon EFS determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.inner = self.inner.posix_profile(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in Amazon EFS determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.inner = self.inner.set_posix_profile(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the server.</p> <note>
        /// <p> Currently, Transfer Family does not accept elliptical curve keys (keys beginning with <code>ecdsa</code>). </p>
        /// </note>
        pub fn ssh_public_key_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key_body(input.into());
            self
        }
        /// <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the server.</p> <note>
        /// <p> Currently, Transfer Family does not accept elliptical curve keys (keys beginning with <code>ecdsa</code>). </p>
        /// </note>
        pub fn set_ssh_public_key_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key_body(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached to users for any purpose.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached to users for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkflow`.
    ///
    /// <p> Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code> operations. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkflow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_workflow_input::Builder,
    }
    impl CreateWorkflow {
        /// Creates a new `CreateWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkflowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A textual description for the workflow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A textual description for the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        /// <p> The <code>TYPE</code> specifies which of the following actions is being taken for this step. </p>
        /// <ul>
        /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
        /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
        /// <li> <p> <i>Delete</i>: delete the file</p> </li>
        /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
        /// </ul> <note>
        /// <p> Currently, copying and tagging are supported only on S3. </p>
        /// </note>
        /// <p> For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path. </p>
        pub fn steps(mut self, input: crate::model::WorkflowStep) -> Self {
            self.inner = self.inner.steps(input);
            self
        }
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        /// <p> The <code>TYPE</code> specifies which of the following actions is being taken for this step. </p>
        /// <ul>
        /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
        /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
        /// <li> <p> <i>Delete</i>: delete the file</p> </li>
        /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
        /// </ul> <note>
        /// <p> Currently, copying and tagging are supported only on S3. </p>
        /// </note>
        /// <p> For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path. </p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        ) -> Self {
            self.inner = self.inner.set_steps(input);
            self
        }
        /// Appends an item to `OnExceptionSteps`.
        ///
        /// To override the contents of this collection use [`set_on_exception_steps`](Self::set_on_exception_steps).
        ///
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p> <note>
        /// <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the exception steps are executed.</p>
        /// </note>
        pub fn on_exception_steps(mut self, input: crate::model::WorkflowStep) -> Self {
            self.inner = self.inner.on_exception_steps(input);
            self
        }
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p> <note>
        /// <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the exception steps are executed.</p>
        /// </note>
        pub fn set_on_exception_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        ) -> Self {
            self.inner = self.inner.set_on_exception_steps(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccess`.
    ///
    /// <p>Allows you to delete the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_input::Builder,
    }
    impl DeleteAccess {
        /// Creates a new `DeleteAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServer`.
    ///
    /// <p>Deletes the file transfer protocol-enabled server that you specify.</p>
    /// <p>No response returns from this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_server_input::Builder,
    }
    impl DeleteServer {
        /// Creates a new `DeleteServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique system-assigned identifier for a server instance.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A unique system-assigned identifier for a server instance.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSshPublicKey`.
    ///
    /// <p>Deletes a user's Secure Shell (SSH) public key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSshPublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ssh_public_key_input::Builder,
    }
    impl DeleteSshPublicKey {
        /// Creates a new `DeleteSshPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSshPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSshPublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance that has the user assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance that has the user assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique identifier used to reference your user's specific SSH key.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key_id(input.into());
            self
        }
        /// <p>A unique identifier used to reference your user's specific SSH key.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key_id(input);
            self
        }
        /// <p>A unique string that identifies a user whose public key is being deleted.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>A unique string that identifies a user whose public key is being deleted.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes the user belonging to a file transfer protocol-enabled server you specify.</p>
    /// <p>No response returns from this operation.</p> <note>
    /// <p>When you delete a user from a server, the user's information is lost.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl DeleteUser {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server instance that has the user assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that has the user assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique string that identifies a user that is being deleted from a server.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>A unique string that identifies a user that is being deleted from a server.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkflow`.
    ///
    /// <p>Deletes the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkflow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_workflow_input::Builder,
    }
    impl DeleteWorkflow {
        /// Creates a new `DeleteWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkflowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccess`.
    ///
    /// <p>Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its <code>ServerId</code> property and its <code>ExternalID</code>.</p>
    /// <p>The response from this call returns the properties of the access that is associated with the <code>ServerId</code> value that was specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_access_input::Builder,
    }
    impl DescribeAccess {
        /// Creates a new `DescribeAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExecution`.
    ///
    /// <p>You can use <code>DescribeExecution</code> to check the details of the execution of the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_execution_input::Builder,
    }
    impl DescribeExecution {
        /// Creates a new `DescribeExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_id(input.into());
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_execution_id(input);
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecurityPolicy`.
    ///
    /// <p>Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security policies</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecurityPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_security_policy_input::Builder,
    }
    impl DescribeSecurityPolicy {
        /// Creates a new `DescribeSecurityPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecurityPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecurityPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_policy_name(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServer`.
    ///
    /// <p>Describes a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code> parameter.</p>
    /// <p>The response contains a description of a server's properties. When you set <code>EndpointType</code> to VPC, the response will contain the <code>EndpointDetails</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_server_input::Builder,
    }
    impl DescribeServer {
        /// Creates a new `DescribeServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its <code>ServerId</code> property.</p>
    /// <p>The response from this call returns the properties of the user associated with the <code>ServerId</code> value that was specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl DescribeUser {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>The name of the user assigned to one or more servers. User names are part of the sign-in credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user assigned to one or more servers. User names are part of the sign-in credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkflow`.
    ///
    /// <p>Describes the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkflow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workflow_input::Builder,
    }
    impl DescribeWorkflow {
        /// Creates a new `DescribeWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkflowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportSshPublicKey`.
    ///
    /// <p>Adds a Secure Shell (SSH) public key to a user account identified by a <code>UserName</code> value assigned to the specific file transfer protocol-enabled server, identified by <code>ServerId</code>.</p>
    /// <p>The response returns the <code>UserName</code> value, the <code>ServerId</code> value, and the name of the <code>SshPublicKeyId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportSshPublicKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_ssh_public_key_input::Builder,
    }
    impl ImportSshPublicKey {
        /// Creates a new `ImportSshPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportSshPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportSshPublicKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>The public key portion of an SSH key pair.</p>
        pub fn ssh_public_key_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key_body(input.into());
            self
        }
        /// <p>The public key portion of an SSH key pair.</p>
        pub fn set_ssh_public_key_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key_body(input);
            self
        }
        /// <p>The name of the user account that is assigned to one or more servers.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user account that is assigned to one or more servers.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccesses`.
    ///
    /// <p>Lists the details for all the accesses you have on your server.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccesses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_accesses_input::Builder,
    }
    impl ListAccesses {
        /// Creates a new `ListAccesses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccessesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccessesPaginator {
            crate::paginator::ListAccessesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the maximum number of access SIDs to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the maximum number of access SIDs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional accesses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional accesses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExecutions`.
    ///
    /// <p>Lists all executions for the specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExecutions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_executions_input::Builder,
    }
    impl ListExecutions {
        /// Creates a new `ListExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExecutionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExecutionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExecutionsPaginator {
            crate::paginator::ListExecutionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the aximum number of executions to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the aximum number of executions to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.</p>
        /// <p> This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>: </p>
        /// <p> <code>aws transfer list-executions --max-results 10</code> </p>
        /// <p> This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you received: </p>
        /// <p> <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code> </p>
        /// <p> This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details for all 100 executions have been returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.</p>
        /// <p> This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>: </p>
        /// <p> <code>aws transfer list-executions --max-results 10</code> </p>
        /// <p> This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you received: </p>
        /// <p> <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code> </p>
        /// <p> This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details for all 100 executions have been returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityPolicies`.
    ///
    /// <p>Lists the security policies that are attached to your file transfer protocol-enabled servers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_security_policies_input::Builder,
    }
    impl ListSecurityPolicies {
        /// Creates a new `ListSecurityPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecurityPoliciesPaginator {
            crate::paginator::ListSecurityPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the number of security policies to return as a response to the <code>ListSecurityPolicies</code> query.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of security policies to return as a response to the <code>ListSecurityPolicies</code> query.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional security policies.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional security policies.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServers`.
    ///
    /// <p>Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_servers_input::Builder,
    }
    impl ListServers {
        /// Creates a new `ListServers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServersPaginator {
            crate::paginator::ListServersPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the number of servers to return as a response to the <code>ListServers</code> query.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of servers to return as a response to the <code>ListServers</code> query.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When additional results are obtained from the <code>ListServers</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional servers.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When additional results are obtained from the <code>ListServers</code> command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional servers.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>Specifies the number of tags to return as a response to the <code>ListTagsForResource</code> request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of tags to return as a response to the <code>ListTagsForResource</code> request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When you request additional results from the <code>ListTagsForResource</code> operation, a <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you request additional results from the <code>ListTagsForResource</code> operation, a <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_users_input::Builder,
    }
    impl ListUsers {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsersPaginator {
            crate::paginator::ListUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the number of users to return as a response to the <code>ListUsers</code> request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the number of users to return as a response to the <code>ListUsers</code> request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional users.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListUsers</code> call, a <code>NextToken</code> parameter is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to continue listing additional users.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkflows`.
    ///
    /// <p>Lists all of your workflows.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkflows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_workflows_input::Builder,
    }
    impl ListWorkflows {
        /// Creates a new `ListWorkflows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkflowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkflowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkflowsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkflowsPaginator {
            crate::paginator::ListWorkflowsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the maximum number of workflows to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Specifies the maximum number of workflows to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional workflows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendWorkflowStepState`.
    ///
    /// <p>Sends a callback for asynchronous custom steps.</p>
    /// <p> The <code>ExecutionId</code>, <code>WorkflowId</code>, and <code>Token</code> are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SendWorkflowStepState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::send_workflow_step_state_input::Builder,
    }
    impl SendWorkflowStepState {
        /// Creates a new `SendWorkflowStepState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendWorkflowStepStateOutput,
            aws_smithy_http::result::SdkError<crate::error::SendWorkflowStepStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_id(input.into());
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_execution_id(input);
            self
        }
        /// <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// <p>Indicates whether the specified step succeeded or failed.</p>
        pub fn status(mut self, input: crate::model::CustomStepStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Indicates whether the specified step succeeded or failed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CustomStepStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartServer`.
    ///
    /// <p>Changes the state of a file transfer protocol-enabled server from <code>OFFLINE</code> to <code>ONLINE</code>. It has no impact on a server that is already <code>ONLINE</code>. An <code>ONLINE</code> server can accept and process file transfer jobs.</p>
    /// <p>The state of <code>STARTING</code> indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of <code>START_FAILED</code> can indicate an error condition.</p>
    /// <p>No response is returned from this call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_server_input::Builder,
    }
    impl StartServer {
        /// Creates a new `StartServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartServerOutput,
            aws_smithy_http::result::SdkError<crate::error::StartServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server that you start.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that you start.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopServer`.
    ///
    /// <p>Changes the state of a file transfer protocol-enabled server from <code>ONLINE</code> to <code>OFFLINE</code>. An <code>OFFLINE</code> server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.</p> <note>
    /// <p>Stopping the server will not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.</p>
    /// </note>
    /// <p>The state of <code>STOPPING</code> indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>STOP_FAILED</code> can indicate an error condition.</p>
    /// <p>No response is returned from this call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_server_input::Builder,
    }
    impl StopServer {
        /// Creates a new `StopServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopServerOutput,
            aws_smithy_http::result::SdkError<crate::error::StopServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned unique identifier for a server that you stopped.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that you stopped.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.</p>
    /// <p>There is no response returned from this call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to user accounts for any purpose.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to user accounts for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestIdentityProvider`.
    ///
    /// <p>If the <code>IdentityProviderType</code> of a file transfer protocol-enabled server is <code>AWS_DIRECTORY_SERVICE</code> or <code>API_Gateway</code>, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.</p>
    /// <p> The <code>ServerId</code> and <code>UserName</code> parameters are required. The <code>ServerProtocol</code>, <code>SourceIp</code>, and <code>UserPassword</code> are all optional. </p> <note>
    /// <p> You cannot use <code>TestIdentityProvider</code> if the <code>IdentityProviderType</code> of your server is <code>SERVICE_MANAGED</code>. </p>
    /// </note>
    /// <ul>
    /// <li> <p> If you provide any incorrect values for any parameters, the <code>Response</code> field is empty. </p> </li>
    /// <li> <p> If you provide a server ID for a server that uses service-managed users, you get an error: </p> <p> <code> An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth </code> </p> </li>
    /// <li> <p> If you enter a Server ID for the <code>--server-id</code> parameter that does not identify an actual Transfer server, you receive the following error: </p> <p> <code>An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestIdentityProvider {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_identity_provider_input::Builder,
    }
    impl TestIdentityProvider {
        /// Creates a new `TestIdentityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestIdentityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::TestIdentityProviderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A system-assigned identifier for a specific server. That server's user authentication method is tested with a user name and password.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned identifier for a specific server. That server's user authentication method is tested with a user name and password.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>The type of file transfer protocol to be tested.</p>
        /// <p>The available protocols are:</p>
        /// <ul>
        /// <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p> </li>
        /// <li> <p>File Transfer Protocol Secure (FTPS)</p> </li>
        /// <li> <p>File Transfer Protocol (FTP)</p> </li>
        /// </ul>
        pub fn server_protocol(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.server_protocol(input);
            self
        }
        /// <p>The type of file transfer protocol to be tested.</p>
        /// <p>The available protocols are:</p>
        /// <ul>
        /// <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p> </li>
        /// <li> <p>File Transfer Protocol Secure (FTPS)</p> </li>
        /// <li> <p>File Transfer Protocol (FTP)</p> </li>
        /// </ul>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::Protocol>,
        ) -> Self {
            self.inner = self.inner.set_server_protocol(input);
            self
        }
        /// <p>The source IP address of the user account to be tested.</p>
        pub fn source_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ip(input.into());
            self
        }
        /// <p>The source IP address of the user account to be tested.</p>
        pub fn set_source_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_ip(input);
            self
        }
        /// <p>The name of the user account to be tested.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The name of the user account to be tested.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The password of the user account to be tested.</p>
        pub fn user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_password(input.into());
            self
        }
        /// <p>The password of the user account to be tested.</p>
        pub fn set_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.</p>
    /// <p>No response is returned from this call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for resources by type. This metadata can be attached to resources for any purpose.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for resources by type. This metadata can be attached to resources for any purpose.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccess`.
    ///
    /// <p>Allows you to update parameters for the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_access_input::Builder,
    }
    impl UpdateAccess {
        /// Creates a new `UpdateAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_directory(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_directory(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.inner = self.inner.home_directory_type(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_type(input);
            self
        }
        /// Appends an item to `HomeDirectoryMappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn home_directory_mappings(
            mut self,
            input: crate::model::HomeDirectoryMapEntry,
        ) -> Self {
            self.inner = self.inner.home_directory_mappings(input);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to <code>/</code> and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_mappings(input);
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.inner = self.inner.posix_profile(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.inner = self.inner.set_posix_profile(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServer`.
    ///
    /// <p>Updates the file transfer protocol-enabled server's properties after that server has been created.</p>
    /// <p>The <code>UpdateServer</code> call returns the <code>ServerId</code> of the server you updated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateServer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_server_input::Builder,
    }
    impl UpdateServer {
        /// Creates a new `UpdateServer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        /// <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p>
        /// <ul>
        /// <li> <p>2048-bit RSA (RSA_2048)</p> </li>
        /// <li> <p>4096-bit RSA (RSA_4096)</p> </li>
        /// <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li>
        /// </ul> <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p>
        /// </note>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        /// <p>Certificates with the following cryptographic algorithms and key sizes are supported:</p>
        /// <ul>
        /// <li> <p>2048-bit RSA (RSA_2048)</p> </li>
        /// <li> <p>4096-bit RSA (RSA_4096)</p> </li>
        /// <li> <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p> </li>
        /// <li> <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p> </li>
        /// </ul> <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.</p>
        /// </note>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_certificate(input);
            self
        }
        /// <p> The protocol settings that are configured for your server. </p>
        /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
        /// <p>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</p>
        pub fn protocol_details(mut self, input: crate::model::ProtocolDetails) -> Self {
            self.inner = self.inner.protocol_details(input);
            self
        }
        /// <p> The protocol settings that are configured for your server. </p>
        /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
        /// <p>Use the <code>TlsSessionResumptionMode</code> parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.</p>
        pub fn set_protocol_details(
            mut self,
            input: std::option::Option<crate::model::ProtocolDetails>,
        ) -> Self {
            self.inner = self.inner.set_protocol_details(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
        pub fn endpoint_details(mut self, input: crate::model::EndpointDetails) -> Self {
            self.inner = self.inner.endpoint_details(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<crate::model::EndpointDetails>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_details(input);
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note>
        /// <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>
        /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.inner = self.inner.endpoint_type(input);
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p> <note>
        /// <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>
        /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code>.</p> <important>
        /// <p>If you aren't planning to migrate existing users from an existing server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.</p>
        /// </important>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer Family User Guide</i>.</p>
        pub fn host_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.host_key(input.into());
            self
        }
        /// <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f my-new-server-key</code>.</p> <important>
        /// <p>If you aren't planning to migrate existing users from an existing server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.</p>
        /// </important>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer Family User Guide</i>.</p>
        pub fn set_host_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_host_key(input);
            self
        }
        /// <p>An array containing all of the information required to call a customer's authentication API method.</p>
        pub fn identity_provider_details(
            mut self,
            input: crate::model::IdentityProviderDetails,
        ) -> Self {
            self.inner = self.inner.identity_provider_details(input);
            self
        }
        /// <p>An array containing all of the information required to call a customer's authentication API method.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderDetails>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_details(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logging_role(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_logging_role(input);
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed after the user authenticates.</p> <note>
        /// <p>The SFTP protocol does not support post-authentication display banners.</p>
        /// </note>
        pub fn post_authentication_login_banner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.post_authentication_login_banner(input.into());
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed after the user authenticates.</p> <note>
        /// <p>The SFTP protocol does not support post-authentication display banners.</p>
        /// </note>
        pub fn set_post_authentication_login_banner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_post_authentication_login_banner(input);
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.</p>
        /// <p> <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code> </p>
        pub fn pre_authentication_login_banner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.pre_authentication_login_banner(input.into());
            self
        }
        /// <p>Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.</p>
        /// <p> <code>This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.</code> </p>
        pub fn set_pre_authentication_login_banner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_authentication_login_banner(input);
            self
        }
        /// Appends an item to `Protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
        /// <ul>
        /// <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p> </li>
        /// <li> <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p> </li>
        /// <li> <p>File Transfer Protocol (FTP): Unencrypted file transfer</p> </li>
        /// </ul> <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate Manager (ACM) which will be used to identify your server when clients connect to it over FTPS.</p>
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p>
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn protocols(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocols(input);
            self
        }
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
        /// <ul>
        /// <li> <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p> </li>
        /// <li> <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p> </li>
        /// <li> <p>File Transfer Protocol (FTP): Unencrypted file transfer</p> </li>
        /// </ul> <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate Manager (ACM) which will be used to identify your server when clients connect to it over FTPS.</p>
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the <code>EndpointType</code> must be <code>VPC</code> and the <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then <code>AddressAllocationIds</code> cannot be associated.</p>
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code> can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.inner = self.inner.set_protocols(input);
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_policy_name(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_policy_name(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn workflow_details(mut self, input: crate::model::WorkflowDetails) -> Self {
            self.inner = self.inner.workflow_details(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn set_workflow_details(
            mut self,
            input: std::option::Option<crate::model::WorkflowDetails>,
        ) -> Self {
            self.inner = self.inner.set_workflow_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUser`.
    ///
    /// <p>Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the <code>UserName</code> and <code>ServerId</code> you specify.</p>
    /// <p>The response returns the <code>ServerId</code> and the <code>UserName</code> for the updated user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_user_input::Builder,
    }
    impl UpdateUser {
        /// Creates a new `UpdateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_directory(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_directory(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.inner = self.inner.home_directory_type(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_type(input);
            self
        }
        /// Appends an item to `HomeDirectoryMappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn home_directory_mappings(
            mut self,
            input: crate::model::HomeDirectoryMapEntry,
        ) -> Self {
            self.inner = self.inner.home_directory_mappings(input);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p> <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your user to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.inner = self.inner.set_home_directory_mappings(input);
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p> <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that are set on files and directories in your file system determines the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.inner = self.inner.posix_profile(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that are set on files and directories in your file system determines the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.inner = self.inner.set_posix_profile(input);
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_id(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is assigned to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_id(input);
            self
        }
        /// <p>A unique string that identifies a user and is associated with a server as specified by the <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>A unique string that identifies a user and is associated with a server as specified by the <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at sign.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
