// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_access`](crate::client::Client::create_access).
///
/// See [`crate::client::fluent_builders::CreateAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccess {
    _private: (),
}
impl CreateAccess {
    /// Creates a new builder-style object to manufacture [`CreateAccessInput`](crate::input::CreateAccessInput)
    pub fn builder() -> crate::input::create_access_input::Builder {
        crate::input::create_access_input::Builder::default()
    }
    /// Creates a new `CreateAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccess {
    type Output =
        std::result::Result<crate::output::CreateAccessOutput, crate::error::CreateAccessError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_access_error(response)
        } else {
            crate::operation_deser::parse_create_access_response(response)
        }
    }
}

/// Operation shape for `CreateServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_server`](crate::client::Client::create_server).
///
/// See [`crate::client::fluent_builders::CreateServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateServer {
    _private: (),
}
impl CreateServer {
    /// Creates a new builder-style object to manufacture [`CreateServerInput`](crate::input::CreateServerInput)
    pub fn builder() -> crate::input::create_server_input::Builder {
        crate::input::create_server_input::Builder::default()
    }
    /// Creates a new `CreateServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateServer {
    type Output =
        std::result::Result<crate::output::CreateServerOutput, crate::error::CreateServerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_server_error(response)
        } else {
            crate::operation_deser::parse_create_server_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `CreateWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workflow`](crate::client::Client::create_workflow).
///
/// See [`crate::client::fluent_builders::CreateWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkflow {
    _private: (),
}
impl CreateWorkflow {
    /// Creates a new builder-style object to manufacture [`CreateWorkflowInput`](crate::input::CreateWorkflowInput)
    pub fn builder() -> crate::input::create_workflow_input::Builder {
        crate::input::create_workflow_input::Builder::default()
    }
    /// Creates a new `CreateWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkflow {
    type Output =
        std::result::Result<crate::output::CreateWorkflowOutput, crate::error::CreateWorkflowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workflow_error(response)
        } else {
            crate::operation_deser::parse_create_workflow_response(response)
        }
    }
}

/// Operation shape for `DeleteAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access`](crate::client::Client::delete_access).
///
/// See [`crate::client::fluent_builders::DeleteAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccess {
    _private: (),
}
impl DeleteAccess {
    /// Creates a new builder-style object to manufacture [`DeleteAccessInput`](crate::input::DeleteAccessInput)
    pub fn builder() -> crate::input::delete_access_input::Builder {
        crate::input::delete_access_input::Builder::default()
    }
    /// Creates a new `DeleteAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccess {
    type Output =
        std::result::Result<crate::output::DeleteAccessOutput, crate::error::DeleteAccessError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_access_error(response)
        } else {
            crate::operation_deser::parse_delete_access_response(response)
        }
    }
}

/// Operation shape for `DeleteServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_server`](crate::client::Client::delete_server).
///
/// See [`crate::client::fluent_builders::DeleteServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteServer {
    _private: (),
}
impl DeleteServer {
    /// Creates a new builder-style object to manufacture [`DeleteServerInput`](crate::input::DeleteServerInput)
    pub fn builder() -> crate::input::delete_server_input::Builder {
        crate::input::delete_server_input::Builder::default()
    }
    /// Creates a new `DeleteServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteServer {
    type Output =
        std::result::Result<crate::output::DeleteServerOutput, crate::error::DeleteServerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_server_error(response)
        } else {
            crate::operation_deser::parse_delete_server_response(response)
        }
    }
}

/// Operation shape for `DeleteSshPublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ssh_public_key`](crate::client::Client::delete_ssh_public_key).
///
/// See [`crate::client::fluent_builders::DeleteSshPublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSshPublicKey {
    _private: (),
}
impl DeleteSshPublicKey {
    /// Creates a new builder-style object to manufacture [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
    pub fn builder() -> crate::input::delete_ssh_public_key_input::Builder {
        crate::input::delete_ssh_public_key_input::Builder::default()
    }
    /// Creates a new `DeleteSshPublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSshPublicKey {
    type Output = std::result::Result<
        crate::output::DeleteSshPublicKeyOutput,
        crate::error::DeleteSshPublicKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ssh_public_key_error(response)
        } else {
            crate::operation_deser::parse_delete_ssh_public_key_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workflow`](crate::client::Client::delete_workflow).
///
/// See [`crate::client::fluent_builders::DeleteWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkflow {
    _private: (),
}
impl DeleteWorkflow {
    /// Creates a new builder-style object to manufacture [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
    pub fn builder() -> crate::input::delete_workflow_input::Builder {
        crate::input::delete_workflow_input::Builder::default()
    }
    /// Creates a new `DeleteWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkflow {
    type Output =
        std::result::Result<crate::output::DeleteWorkflowOutput, crate::error::DeleteWorkflowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workflow_error(response)
        } else {
            crate::operation_deser::parse_delete_workflow_response(response)
        }
    }
}

/// Operation shape for `DescribeAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_access`](crate::client::Client::describe_access).
///
/// See [`crate::client::fluent_builders::DescribeAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccess {
    _private: (),
}
impl DescribeAccess {
    /// Creates a new builder-style object to manufacture [`DescribeAccessInput`](crate::input::DescribeAccessInput)
    pub fn builder() -> crate::input::describe_access_input::Builder {
        crate::input::describe_access_input::Builder::default()
    }
    /// Creates a new `DescribeAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccess {
    type Output =
        std::result::Result<crate::output::DescribeAccessOutput, crate::error::DescribeAccessError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_access_error(response)
        } else {
            crate::operation_deser::parse_describe_access_response(response)
        }
    }
}

/// Operation shape for `DescribeExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_execution`](crate::client::Client::describe_execution).
///
/// See [`crate::client::fluent_builders::DescribeExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExecution {
    _private: (),
}
impl DescribeExecution {
    /// Creates a new builder-style object to manufacture [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    pub fn builder() -> crate::input::describe_execution_input::Builder {
        crate::input::describe_execution_input::Builder::default()
    }
    /// Creates a new `DescribeExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExecution {
    type Output = std::result::Result<
        crate::output::DescribeExecutionOutput,
        crate::error::DescribeExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeSecurityPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_security_policy`](crate::client::Client::describe_security_policy).
///
/// See [`crate::client::fluent_builders::DescribeSecurityPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSecurityPolicy {
    _private: (),
}
impl DescribeSecurityPolicy {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityPolicyInput`](crate::input::DescribeSecurityPolicyInput)
    pub fn builder() -> crate::input::describe_security_policy_input::Builder {
        crate::input::describe_security_policy_input::Builder::default()
    }
    /// Creates a new `DescribeSecurityPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSecurityPolicy {
    type Output = std::result::Result<
        crate::output::DescribeSecurityPolicyOutput,
        crate::error::DescribeSecurityPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_security_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_security_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_server`](crate::client::Client::describe_server).
///
/// See [`crate::client::fluent_builders::DescribeServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServer {
    _private: (),
}
impl DescribeServer {
    /// Creates a new builder-style object to manufacture [`DescribeServerInput`](crate::input::DescribeServerInput)
    pub fn builder() -> crate::input::describe_server_input::Builder {
        crate::input::describe_server_input::Builder::default()
    }
    /// Creates a new `DescribeServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServer {
    type Output =
        std::result::Result<crate::output::DescribeServerOutput, crate::error::DescribeServerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_server_error(response)
        } else {
            crate::operation_deser::parse_describe_server_response(response)
        }
    }
}

/// Operation shape for `DescribeUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user`](crate::client::Client::describe_user).
///
/// See [`crate::client::fluent_builders::DescribeUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUser {
    _private: (),
}
impl DescribeUser {
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
    /// Creates a new `DescribeUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUser {
    type Output =
        std::result::Result<crate::output::DescribeUserOutput, crate::error::DescribeUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_error(response)
        } else {
            crate::operation_deser::parse_describe_user_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workflow`](crate::client::Client::describe_workflow).
///
/// See [`crate::client::fluent_builders::DescribeWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkflow {
    _private: (),
}
impl DescribeWorkflow {
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowInput`](crate::input::DescribeWorkflowInput)
    pub fn builder() -> crate::input::describe_workflow_input::Builder {
        crate::input::describe_workflow_input::Builder::default()
    }
    /// Creates a new `DescribeWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkflow {
    type Output = std::result::Result<
        crate::output::DescribeWorkflowOutput,
        crate::error::DescribeWorkflowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workflow_error(response)
        } else {
            crate::operation_deser::parse_describe_workflow_response(response)
        }
    }
}

/// Operation shape for `ImportSshPublicKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_ssh_public_key`](crate::client::Client::import_ssh_public_key).
///
/// See [`crate::client::fluent_builders::ImportSshPublicKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportSshPublicKey {
    _private: (),
}
impl ImportSshPublicKey {
    /// Creates a new builder-style object to manufacture [`ImportSshPublicKeyInput`](crate::input::ImportSshPublicKeyInput)
    pub fn builder() -> crate::input::import_ssh_public_key_input::Builder {
        crate::input::import_ssh_public_key_input::Builder::default()
    }
    /// Creates a new `ImportSshPublicKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportSshPublicKey {
    type Output = std::result::Result<
        crate::output::ImportSshPublicKeyOutput,
        crate::error::ImportSshPublicKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_ssh_public_key_error(response)
        } else {
            crate::operation_deser::parse_import_ssh_public_key_response(response)
        }
    }
}

/// Operation shape for `ListAccesses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accesses`](crate::client::Client::list_accesses).
///
/// See [`crate::client::fluent_builders::ListAccesses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccesses {
    _private: (),
}
impl ListAccesses {
    /// Creates a new builder-style object to manufacture [`ListAccessesInput`](crate::input::ListAccessesInput)
    pub fn builder() -> crate::input::list_accesses_input::Builder {
        crate::input::list_accesses_input::Builder::default()
    }
    /// Creates a new `ListAccesses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccesses {
    type Output =
        std::result::Result<crate::output::ListAccessesOutput, crate::error::ListAccessesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accesses_error(response)
        } else {
            crate::operation_deser::parse_list_accesses_response(response)
        }
    }
}

/// Operation shape for `ListExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_executions`](crate::client::Client::list_executions).
///
/// See [`crate::client::fluent_builders::ListExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExecutions {
    _private: (),
}
impl ListExecutions {
    /// Creates a new builder-style object to manufacture [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    pub fn builder() -> crate::input::list_executions_input::Builder {
        crate::input::list_executions_input::Builder::default()
    }
    /// Creates a new `ListExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExecutions {
    type Output =
        std::result::Result<crate::output::ListExecutionsOutput, crate::error::ListExecutionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_executions_error(response)
        } else {
            crate::operation_deser::parse_list_executions_response(response)
        }
    }
}

/// Operation shape for `ListSecurityPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_security_policies`](crate::client::Client::list_security_policies).
///
/// See [`crate::client::fluent_builders::ListSecurityPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSecurityPolicies {
    _private: (),
}
impl ListSecurityPolicies {
    /// Creates a new builder-style object to manufacture [`ListSecurityPoliciesInput`](crate::input::ListSecurityPoliciesInput)
    pub fn builder() -> crate::input::list_security_policies_input::Builder {
        crate::input::list_security_policies_input::Builder::default()
    }
    /// Creates a new `ListSecurityPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSecurityPolicies {
    type Output = std::result::Result<
        crate::output::ListSecurityPoliciesOutput,
        crate::error::ListSecurityPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_security_policies_error(response)
        } else {
            crate::operation_deser::parse_list_security_policies_response(response)
        }
    }
}

/// Operation shape for `ListServers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_servers`](crate::client::Client::list_servers).
///
/// See [`crate::client::fluent_builders::ListServers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServers {
    _private: (),
}
impl ListServers {
    /// Creates a new builder-style object to manufacture [`ListServersInput`](crate::input::ListServersInput)
    pub fn builder() -> crate::input::list_servers_input::Builder {
        crate::input::list_servers_input::Builder::default()
    }
    /// Creates a new `ListServers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServers {
    type Output =
        std::result::Result<crate::output::ListServersOutput, crate::error::ListServersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_servers_error(response)
        } else {
            crate::operation_deser::parse_list_servers_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_users`](crate::client::Client::list_users).
///
/// See [`crate::client::fluent_builders::ListUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsers {
    _private: (),
}
impl ListUsers {
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
    /// Creates a new `ListUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsers {
    type Output = std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_users_error(response)
        } else {
            crate::operation_deser::parse_list_users_response(response)
        }
    }
}

/// Operation shape for `ListWorkflows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workflows`](crate::client::Client::list_workflows).
///
/// See [`crate::client::fluent_builders::ListWorkflows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkflows {
    _private: (),
}
impl ListWorkflows {
    /// Creates a new builder-style object to manufacture [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
    pub fn builder() -> crate::input::list_workflows_input::Builder {
        crate::input::list_workflows_input::Builder::default()
    }
    /// Creates a new `ListWorkflows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkflows {
    type Output =
        std::result::Result<crate::output::ListWorkflowsOutput, crate::error::ListWorkflowsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workflows_error(response)
        } else {
            crate::operation_deser::parse_list_workflows_response(response)
        }
    }
}

/// Operation shape for `SendWorkflowStepState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_workflow_step_state`](crate::client::Client::send_workflow_step_state).
///
/// See [`crate::client::fluent_builders::SendWorkflowStepState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendWorkflowStepState {
    _private: (),
}
impl SendWorkflowStepState {
    /// Creates a new builder-style object to manufacture [`SendWorkflowStepStateInput`](crate::input::SendWorkflowStepStateInput)
    pub fn builder() -> crate::input::send_workflow_step_state_input::Builder {
        crate::input::send_workflow_step_state_input::Builder::default()
    }
    /// Creates a new `SendWorkflowStepState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendWorkflowStepState {
    type Output = std::result::Result<
        crate::output::SendWorkflowStepStateOutput,
        crate::error::SendWorkflowStepStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_workflow_step_state_error(response)
        } else {
            crate::operation_deser::parse_send_workflow_step_state_response(response)
        }
    }
}

/// Operation shape for `StartServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_server`](crate::client::Client::start_server).
///
/// See [`crate::client::fluent_builders::StartServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartServer {
    _private: (),
}
impl StartServer {
    /// Creates a new builder-style object to manufacture [`StartServerInput`](crate::input::StartServerInput)
    pub fn builder() -> crate::input::start_server_input::Builder {
        crate::input::start_server_input::Builder::default()
    }
    /// Creates a new `StartServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartServer {
    type Output =
        std::result::Result<crate::output::StartServerOutput, crate::error::StartServerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_server_error(response)
        } else {
            crate::operation_deser::parse_start_server_response(response)
        }
    }
}

/// Operation shape for `StopServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_server`](crate::client::Client::stop_server).
///
/// See [`crate::client::fluent_builders::StopServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopServer {
    _private: (),
}
impl StopServer {
    /// Creates a new builder-style object to manufacture [`StopServerInput`](crate::input::StopServerInput)
    pub fn builder() -> crate::input::stop_server_input::Builder {
        crate::input::stop_server_input::Builder::default()
    }
    /// Creates a new `StopServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopServer {
    type Output =
        std::result::Result<crate::output::StopServerOutput, crate::error::StopServerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_server_error(response)
        } else {
            crate::operation_deser::parse_stop_server_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestIdentityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_identity_provider`](crate::client::Client::test_identity_provider).
///
/// See [`crate::client::fluent_builders::TestIdentityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestIdentityProvider {
    _private: (),
}
impl TestIdentityProvider {
    /// Creates a new builder-style object to manufacture [`TestIdentityProviderInput`](crate::input::TestIdentityProviderInput)
    pub fn builder() -> crate::input::test_identity_provider_input::Builder {
        crate::input::test_identity_provider_input::Builder::default()
    }
    /// Creates a new `TestIdentityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestIdentityProvider {
    type Output = std::result::Result<
        crate::output::TestIdentityProviderOutput,
        crate::error::TestIdentityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_identity_provider_error(response)
        } else {
            crate::operation_deser::parse_test_identity_provider_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_access`](crate::client::Client::update_access).
///
/// See [`crate::client::fluent_builders::UpdateAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccess {
    _private: (),
}
impl UpdateAccess {
    /// Creates a new builder-style object to manufacture [`UpdateAccessInput`](crate::input::UpdateAccessInput)
    pub fn builder() -> crate::input::update_access_input::Builder {
        crate::input::update_access_input::Builder::default()
    }
    /// Creates a new `UpdateAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccess {
    type Output =
        std::result::Result<crate::output::UpdateAccessOutput, crate::error::UpdateAccessError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_access_error(response)
        } else {
            crate::operation_deser::parse_update_access_response(response)
        }
    }
}

/// Operation shape for `UpdateServer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_server`](crate::client::Client::update_server).
///
/// See [`crate::client::fluent_builders::UpdateServer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServer {
    _private: (),
}
impl UpdateServer {
    /// Creates a new builder-style object to manufacture [`UpdateServerInput`](crate::input::UpdateServerInput)
    pub fn builder() -> crate::input::update_server_input::Builder {
        crate::input::update_server_input::Builder::default()
    }
    /// Creates a new `UpdateServer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServer {
    type Output =
        std::result::Result<crate::output::UpdateServerOutput, crate::error::UpdateServerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_server_error(response)
        } else {
            crate::operation_deser::parse_update_server_response(response)
        }
    }
}

/// Operation shape for `UpdateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user`](crate::client::Client::update_user).
///
/// See [`crate::client::fluent_builders::UpdateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUser {
    _private: (),
}
impl UpdateUser {
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
    /// Creates a new `UpdateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUser {
    type Output =
        std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_error(response)
        } else {
            crate::operation_deser::parse_update_user_response(response)
        }
    }
}
