// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PosixProfile {
    /// <p>The POSIX user ID used for all EFS operations by this user.</p>
    pub uid: std::option::Option<i64>,
    /// <p>The POSIX group ID used for all EFS operations by this user.</p>
    pub gid: std::option::Option<i64>,
    /// <p>The secondary POSIX group IDs used for all EFS operations by this user.</p>
    pub secondary_gids: std::option::Option<std::vec::Vec<i64>>,
}
impl PosixProfile {
    /// <p>The POSIX user ID used for all EFS operations by this user.</p>
    pub fn uid(&self) -> std::option::Option<i64> {
        self.uid
    }
    /// <p>The POSIX group ID used for all EFS operations by this user.</p>
    pub fn gid(&self) -> std::option::Option<i64> {
        self.gid
    }
    /// <p>The secondary POSIX group IDs used for all EFS operations by this user.</p>
    pub fn secondary_gids(&self) -> std::option::Option<&[i64]> {
        self.secondary_gids.as_deref()
    }
}
impl std::fmt::Debug for PosixProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PosixProfile");
        formatter.field("uid", &self.uid);
        formatter.field("gid", &self.gid);
        formatter.field("secondary_gids", &self.secondary_gids);
        formatter.finish()
    }
}
/// See [`PosixProfile`](crate::model::PosixProfile)
pub mod posix_profile {
    /// A builder for [`PosixProfile`](crate::model::PosixProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uid: std::option::Option<i64>,
        pub(crate) gid: std::option::Option<i64>,
        pub(crate) secondary_gids: std::option::Option<std::vec::Vec<i64>>,
    }
    impl Builder {
        /// <p>The POSIX user ID used for all EFS operations by this user.</p>
        pub fn uid(mut self, input: i64) -> Self {
            self.uid = Some(input);
            self
        }
        /// <p>The POSIX user ID used for all EFS operations by this user.</p>
        pub fn set_uid(mut self, input: std::option::Option<i64>) -> Self {
            self.uid = input;
            self
        }
        /// <p>The POSIX group ID used for all EFS operations by this user.</p>
        pub fn gid(mut self, input: i64) -> Self {
            self.gid = Some(input);
            self
        }
        /// <p>The POSIX group ID used for all EFS operations by this user.</p>
        pub fn set_gid(mut self, input: std::option::Option<i64>) -> Self {
            self.gid = input;
            self
        }
        /// Appends an item to `secondary_gids`.
        ///
        /// To override the contents of this collection use [`set_secondary_gids`](Self::set_secondary_gids).
        ///
        /// <p>The secondary POSIX group IDs used for all EFS operations by this user.</p>
        pub fn secondary_gids(mut self, input: i64) -> Self {
            let mut v = self.secondary_gids.unwrap_or_default();
            v.push(input);
            self.secondary_gids = Some(v);
            self
        }
        /// <p>The secondary POSIX group IDs used for all EFS operations by this user.</p>
        pub fn set_secondary_gids(
            mut self,
            input: std::option::Option<std::vec::Vec<i64>>,
        ) -> Self {
            self.secondary_gids = input;
            self
        }
        /// Consumes the builder and constructs a [`PosixProfile`](crate::model::PosixProfile)
        pub fn build(self) -> crate::model::PosixProfile {
            crate::model::PosixProfile {
                uid: self.uid,
                gid: self.gid,
                secondary_gids: self.secondary_gids,
            }
        }
    }
}
impl PosixProfile {
    /// Creates a new builder-style object to manufacture [`PosixProfile`](crate::model::PosixProfile)
    pub fn builder() -> crate::model::posix_profile::Builder {
        crate::model::posix_profile::Builder::default()
    }
}

/// <p>Represents an object that contains entries and targets for <code>HomeDirectoryMappings</code>.</p>
/// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
/// <p> <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HomeDirectoryMapEntry {
    /// <p>Represents an entry for <code>HomeDirectoryMappings</code>.</p>
    pub entry: std::option::Option<std::string::String>,
    /// <p>Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.</p>
    pub target: std::option::Option<std::string::String>,
}
impl HomeDirectoryMapEntry {
    /// <p>Represents an entry for <code>HomeDirectoryMappings</code>.</p>
    pub fn entry(&self) -> std::option::Option<&str> {
        self.entry.as_deref()
    }
    /// <p>Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for HomeDirectoryMapEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HomeDirectoryMapEntry");
        formatter.field("entry", &self.entry);
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`HomeDirectoryMapEntry`](crate::model::HomeDirectoryMapEntry)
pub mod home_directory_map_entry {
    /// A builder for [`HomeDirectoryMapEntry`](crate::model::HomeDirectoryMapEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents an entry for <code>HomeDirectoryMappings</code>.</p>
        pub fn entry(mut self, input: impl Into<std::string::String>) -> Self {
            self.entry = Some(input.into());
            self
        }
        /// <p>Represents an entry for <code>HomeDirectoryMappings</code>.</p>
        pub fn set_entry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entry = input;
            self
        }
        /// <p>Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`HomeDirectoryMapEntry`](crate::model::HomeDirectoryMapEntry)
        pub fn build(self) -> crate::model::HomeDirectoryMapEntry {
            crate::model::HomeDirectoryMapEntry {
                entry: self.entry,
                target: self.target,
            }
        }
    }
}
impl HomeDirectoryMapEntry {
    /// Creates a new builder-style object to manufacture [`HomeDirectoryMapEntry`](crate::model::HomeDirectoryMapEntry)
    pub fn builder() -> crate::model::home_directory_map_entry::Builder {
        crate::model::home_directory_map_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HomeDirectoryType {
    #[allow(missing_docs)] // documentation missing in model
    Logical,
    #[allow(missing_docs)] // documentation missing in model
    Path,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HomeDirectoryType {
    fn from(s: &str) -> Self {
        match s {
            "LOGICAL" => HomeDirectoryType::Logical,
            "PATH" => HomeDirectoryType::Path,
            other => HomeDirectoryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HomeDirectoryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HomeDirectoryType::from(s))
    }
}
impl HomeDirectoryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HomeDirectoryType::Logical => "LOGICAL",
            HomeDirectoryType::Path => "PATH",
            HomeDirectoryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOGICAL", "PATH"]
    }
}
impl AsRef<str> for HomeDirectoryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for the <code>WorkflowDetail</code> data type. It is used by actions that trigger a workflow to begin execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowDetails {
    /// <p>A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
    pub on_upload: std::option::Option<std::vec::Vec<crate::model::WorkflowDetail>>,
}
impl WorkflowDetails {
    /// <p>A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
    pub fn on_upload(&self) -> std::option::Option<&[crate::model::WorkflowDetail]> {
        self.on_upload.as_deref()
    }
}
impl std::fmt::Debug for WorkflowDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowDetails");
        formatter.field("on_upload", &self.on_upload);
        formatter.finish()
    }
}
/// See [`WorkflowDetails`](crate::model::WorkflowDetails)
pub mod workflow_details {
    /// A builder for [`WorkflowDetails`](crate::model::WorkflowDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_upload: std::option::Option<std::vec::Vec<crate::model::WorkflowDetail>>,
    }
    impl Builder {
        /// Appends an item to `on_upload`.
        ///
        /// To override the contents of this collection use [`set_on_upload`](Self::set_on_upload).
        ///
        /// <p>A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
        pub fn on_upload(mut self, input: crate::model::WorkflowDetail) -> Self {
            let mut v = self.on_upload.unwrap_or_default();
            v.push(input);
            self.on_upload = Some(v);
            self
        }
        /// <p>A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
        pub fn set_on_upload(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowDetail>>,
        ) -> Self {
            self.on_upload = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowDetails`](crate::model::WorkflowDetails)
        pub fn build(self) -> crate::model::WorkflowDetails {
            crate::model::WorkflowDetails {
                on_upload: self.on_upload,
            }
        }
    }
}
impl WorkflowDetails {
    /// Creates a new builder-style object to manufacture [`WorkflowDetails`](crate::model::WorkflowDetails)
    pub fn builder() -> crate::model::workflow_details::Builder {
        crate::model::workflow_details::Builder::default()
    }
}

/// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowDetail {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources</p>
    pub execution_role: std::option::Option<std::string::String>,
}
impl WorkflowDetail {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources</p>
    pub fn execution_role(&self) -> std::option::Option<&str> {
        self.execution_role.as_deref()
    }
}
impl std::fmt::Debug for WorkflowDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowDetail");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("execution_role", &self.execution_role);
        formatter.finish()
    }
}
/// See [`WorkflowDetail`](crate::model::WorkflowDetail)
pub mod workflow_detail {
    /// A builder for [`WorkflowDetail`](crate::model::WorkflowDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) execution_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources</p>
        pub fn execution_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role = Some(input.into());
            self
        }
        /// <p>Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources</p>
        pub fn set_execution_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowDetail`](crate::model::WorkflowDetail)
        pub fn build(self) -> crate::model::WorkflowDetail {
            crate::model::WorkflowDetail {
                workflow_id: self.workflow_id,
                execution_role: self.execution_role,
            }
        }
    }
}
impl WorkflowDetail {
    /// Creates a new builder-style object to manufacture [`WorkflowDetail`](crate::model::WorkflowDetail)
    pub fn builder() -> crate::model::workflow_detail::Builder {
        crate::model::workflow_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Protocol {
    #[allow(missing_docs)] // documentation missing in model
    Ftp,
    #[allow(missing_docs)] // documentation missing in model
    Ftps,
    #[allow(missing_docs)] // documentation missing in model
    Sftp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Protocol {
    fn from(s: &str) -> Self {
        match s {
            "FTP" => Protocol::Ftp,
            "FTPS" => Protocol::Ftps,
            "SFTP" => Protocol::Sftp,
            other => Protocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Protocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Protocol::from(s))
    }
}
impl Protocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Protocol::Ftp => "FTP",
            Protocol::Ftps => "FTPS",
            Protocol::Sftp => "SFTP",
            Protocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FTP", "FTPS", "SFTP"]
    }
}
impl AsRef<str> for Protocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information related to the type of user authentication that is in use for a file transfer protocol-enabled server's users. A server can have only one method of authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityProviderDetails {
    /// <p>Provides the location of the service endpoint used to authenticate users.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>Provides the type of <code>InvocationRole</code> used to authenticate the user account.</p>
    pub invocation_role: std::option::Option<std::string::String>,
    /// <p>The identifier of the Amazon Web Services Directory Service directory that you want to stop sharing.</p>
    pub directory_id: std::option::Option<std::string::String>,
    /// <p>The ARN for a lambda function to use for the Identity provider.</p>
    pub function: std::option::Option<std::string::String>,
}
impl IdentityProviderDetails {
    /// <p>Provides the location of the service endpoint used to authenticate users.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>Provides the type of <code>InvocationRole</code> used to authenticate the user account.</p>
    pub fn invocation_role(&self) -> std::option::Option<&str> {
        self.invocation_role.as_deref()
    }
    /// <p>The identifier of the Amazon Web Services Directory Service directory that you want to stop sharing.</p>
    pub fn directory_id(&self) -> std::option::Option<&str> {
        self.directory_id.as_deref()
    }
    /// <p>The ARN for a lambda function to use for the Identity provider.</p>
    pub fn function(&self) -> std::option::Option<&str> {
        self.function.as_deref()
    }
}
impl std::fmt::Debug for IdentityProviderDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityProviderDetails");
        formatter.field("url", &self.url);
        formatter.field("invocation_role", &self.invocation_role);
        formatter.field("directory_id", &self.directory_id);
        formatter.field("function", &self.function);
        formatter.finish()
    }
}
/// See [`IdentityProviderDetails`](crate::model::IdentityProviderDetails)
pub mod identity_provider_details {
    /// A builder for [`IdentityProviderDetails`](crate::model::IdentityProviderDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) invocation_role: std::option::Option<std::string::String>,
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) function: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the location of the service endpoint used to authenticate users.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>Provides the location of the service endpoint used to authenticate users.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>Provides the type of <code>InvocationRole</code> used to authenticate the user account.</p>
        pub fn invocation_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_role = Some(input.into());
            self
        }
        /// <p>Provides the type of <code>InvocationRole</code> used to authenticate the user account.</p>
        pub fn set_invocation_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_role = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services Directory Service directory that you want to stop sharing.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services Directory Service directory that you want to stop sharing.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>The ARN for a lambda function to use for the Identity provider.</p>
        pub fn function(mut self, input: impl Into<std::string::String>) -> Self {
            self.function = Some(input.into());
            self
        }
        /// <p>The ARN for a lambda function to use for the Identity provider.</p>
        pub fn set_function(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityProviderDetails`](crate::model::IdentityProviderDetails)
        pub fn build(self) -> crate::model::IdentityProviderDetails {
            crate::model::IdentityProviderDetails {
                url: self.url,
                invocation_role: self.invocation_role,
                directory_id: self.directory_id,
                function: self.function,
            }
        }
    }
}
impl IdentityProviderDetails {
    /// Creates a new builder-style object to manufacture [`IdentityProviderDetails`](crate::model::IdentityProviderDetails)
    pub fn builder() -> crate::model::identity_provider_details::Builder {
        crate::model::identity_provider_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Public,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpoint,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointType {
    fn from(s: &str) -> Self {
        match s {
            "PUBLIC" => EndpointType::Public,
            "VPC" => EndpointType::Vpc,
            "VPC_ENDPOINT" => EndpointType::VpcEndpoint,
            other => EndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointType::from(s))
    }
}
impl EndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointType::Public => "PUBLIC",
            EndpointType::Vpc => "VPC",
            EndpointType::VpcEndpoint => "VPC_ENDPOINT",
            EndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PUBLIC", "VPC", "VPC_ENDPOINT"]
    }
}
impl AsRef<str> for EndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The virtual private cloud (VPC) endpoint settings that are configured for your file transfer protocol-enabled server. With a VPC endpoint, you can restrict access to your server and resources only within your VPC. To control incoming internet traffic, invoke the <code>UpdateServer</code> API and attach an Elastic IP address to your server's endpoint.</p> <note>
/// <p> After May 19, 2021, you won't be able to create a server using <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use <code>EndpointType</code>=<code>VPC</code>.</p>
/// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointDetails {
    /// <p>A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.</p>
    /// </note>
    pub address_allocation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
    /// </note>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the VPC endpoint.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.</p>
    /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
    /// </note>
    pub vpc_endpoint_id: std::option::Option<std::string::String>,
    /// <p>The VPC ID of the VPC in which a server's endpoint will be hosted.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
    /// </note>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
    /// <p>You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code>. To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.</p>
    /// </note>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EndpointDetails {
    /// <p>A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.</p>
    /// </note>
    pub fn address_allocation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.address_allocation_ids.as_deref()
    }
    /// <p>A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
    /// </note>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The ID of the VPC endpoint.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.</p>
    /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
    /// </note>
    pub fn vpc_endpoint_id(&self) -> std::option::Option<&str> {
        self.vpc_endpoint_id.as_deref()
    }
    /// <p>The VPC ID of the VPC in which a server's endpoint will be hosted.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
    /// </note>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
    /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
    /// <p>You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code>. To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.</p>
    /// </note>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for EndpointDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointDetails");
        formatter.field("address_allocation_ids", &self.address_allocation_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("vpc_endpoint_id", &self.vpc_endpoint_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`EndpointDetails`](crate::model::EndpointDetails)
pub mod endpoint_details {
    /// A builder for [`EndpointDetails`](crate::model::EndpointDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address_allocation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `address_allocation_ids`.
        ///
        /// To override the contents of this collection use [`set_address_allocation_ids`](Self::set_address_allocation_ids).
        ///
        /// <p>A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.</p>
        /// </note>
        pub fn address_allocation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.address_allocation_ids.unwrap_or_default();
            v.push(input.into());
            self.address_allocation_ids = Some(v);
            self
        }
        /// <p>A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in the <code>UpdateServer</code> API.</p>
        /// </note>
        pub fn set_address_allocation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.address_allocation_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
        /// </note>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
        /// </note>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The ID of the VPC endpoint.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.</p>
        /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// </note>
        pub fn vpc_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC endpoint.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.</p>
        /// <p>For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// </note>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_id = input;
            self
        }
        /// <p>The VPC ID of the VPC in which a server's endpoint will be hosted.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
        /// </note>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID of the VPC in which a server's endpoint will be hosted.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
        /// </note>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
        /// <p>You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code>. To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.</p>
        /// </note>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
        /// <p>This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.</p>
        /// <p>You can edit the <code>SecurityGroupIds</code> property in the <a href="https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html">UpdateServer</a> API only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to <code>VPC</code>. To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html">ModifyVpcEndpoint</a> API.</p>
        /// </note>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointDetails`](crate::model::EndpointDetails)
        pub fn build(self) -> crate::model::EndpointDetails {
            crate::model::EndpointDetails {
                address_allocation_ids: self.address_allocation_ids,
                subnet_ids: self.subnet_ids,
                vpc_endpoint_id: self.vpc_endpoint_id,
                vpc_id: self.vpc_id,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl EndpointDetails {
    /// Creates a new builder-style object to manufacture [`EndpointDetails`](crate::model::EndpointDetails)
    pub fn builder() -> crate::model::endpoint_details::Builder {
        crate::model::endpoint_details::Builder::default()
    }
}

/// <p> The protocol settings that are configured for your server. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtocolDetails {
    /// <p> Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. For example: </p>
    /// <p> <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code> </p>
    /// <p>Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.</p> <note>
    /// <p> If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>. </p>
    /// </note>
    pub passive_ip: std::option::Option<std::string::String>,
    /// <p>A property used with Transfer servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during CreateServer, it is set to <code>ENFORCED</code> by default.</p>
    /// <ul>
    /// <li> <p> <code>DISABLED</code>: the server does not process TLS session resumption client requests and creates a new TLS session for each request. </p> </li>
    /// <li> <p> <code>ENABLED</code>: the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</p> </li>
    /// <li> <p> <code>ENFORCED</code>: the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code>, test your clients.</p> <note>
    /// <p>Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.</p>
    /// </note> </li>
    /// </ul>
    pub tls_session_resumption_mode: std::option::Option<crate::model::TlsSessionResumptionMode>,
}
impl ProtocolDetails {
    /// <p> Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. For example: </p>
    /// <p> <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code> </p>
    /// <p>Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.</p> <note>
    /// <p> If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>. </p>
    /// </note>
    pub fn passive_ip(&self) -> std::option::Option<&str> {
        self.passive_ip.as_deref()
    }
    /// <p>A property used with Transfer servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during CreateServer, it is set to <code>ENFORCED</code> by default.</p>
    /// <ul>
    /// <li> <p> <code>DISABLED</code>: the server does not process TLS session resumption client requests and creates a new TLS session for each request. </p> </li>
    /// <li> <p> <code>ENABLED</code>: the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</p> </li>
    /// <li> <p> <code>ENFORCED</code>: the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code>, test your clients.</p> <note>
    /// <p>Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.</p>
    /// </note> </li>
    /// </ul>
    pub fn tls_session_resumption_mode(
        &self,
    ) -> std::option::Option<&crate::model::TlsSessionResumptionMode> {
        self.tls_session_resumption_mode.as_ref()
    }
}
impl std::fmt::Debug for ProtocolDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtocolDetails");
        formatter.field("passive_ip", &self.passive_ip);
        formatter.field(
            "tls_session_resumption_mode",
            &self.tls_session_resumption_mode,
        );
        formatter.finish()
    }
}
/// See [`ProtocolDetails`](crate::model::ProtocolDetails)
pub mod protocol_details {
    /// A builder for [`ProtocolDetails`](crate::model::ProtocolDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) passive_ip: std::option::Option<std::string::String>,
        pub(crate) tls_session_resumption_mode:
            std::option::Option<crate::model::TlsSessionResumptionMode>,
    }
    impl Builder {
        /// <p> Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. For example: </p>
        /// <p> <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code> </p>
        /// <p>Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.</p> <note>
        /// <p> If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>. </p>
        /// </note>
        pub fn passive_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.passive_ip = Some(input.into());
            self
        }
        /// <p> Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. For example: </p>
        /// <p> <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code> </p>
        /// <p>Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.</p> <note>
        /// <p> If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>. </p>
        /// </note>
        pub fn set_passive_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.passive_ip = input;
            self
        }
        /// <p>A property used with Transfer servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during CreateServer, it is set to <code>ENFORCED</code> by default.</p>
        /// <ul>
        /// <li> <p> <code>DISABLED</code>: the server does not process TLS session resumption client requests and creates a new TLS session for each request. </p> </li>
        /// <li> <p> <code>ENABLED</code>: the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</p> </li>
        /// <li> <p> <code>ENFORCED</code>: the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code>, test your clients.</p> <note>
        /// <p>Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.</p>
        /// </note> </li>
        /// </ul>
        pub fn tls_session_resumption_mode(
            mut self,
            input: crate::model::TlsSessionResumptionMode,
        ) -> Self {
            self.tls_session_resumption_mode = Some(input);
            self
        }
        /// <p>A property used with Transfer servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. <code>TlsSessionResumptionMode</code> determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during <code>CreateServer</code> and <code>UpdateServer</code> calls. If a <code>TlsSessionResumptionMode</code> value is not specified during CreateServer, it is set to <code>ENFORCED</code> by default.</p>
        /// <ul>
        /// <li> <p> <code>DISABLED</code>: the server does not process TLS session resumption client requests and creates a new TLS session for each request. </p> </li>
        /// <li> <p> <code>ENABLED</code>: the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.</p> </li>
        /// <li> <p> <code>ENFORCED</code>: the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to <code>ENFORCED</code>, test your clients.</p> <note>
        /// <p>Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the <code>ENFORCED</code> value, you need to test your clients.</p>
        /// </note> </li>
        /// </ul>
        pub fn set_tls_session_resumption_mode(
            mut self,
            input: std::option::Option<crate::model::TlsSessionResumptionMode>,
        ) -> Self {
            self.tls_session_resumption_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtocolDetails`](crate::model::ProtocolDetails)
        pub fn build(self) -> crate::model::ProtocolDetails {
            crate::model::ProtocolDetails {
                passive_ip: self.passive_ip,
                tls_session_resumption_mode: self.tls_session_resumption_mode,
            }
        }
    }
}
impl ProtocolDetails {
    /// Creates a new builder-style object to manufacture [`ProtocolDetails`](crate::model::ProtocolDetails)
    pub fn builder() -> crate::model::protocol_details::Builder {
        crate::model::protocol_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TlsSessionResumptionMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enforced,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TlsSessionResumptionMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => TlsSessionResumptionMode::Disabled,
            "ENABLED" => TlsSessionResumptionMode::Enabled,
            "ENFORCED" => TlsSessionResumptionMode::Enforced,
            other => TlsSessionResumptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TlsSessionResumptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TlsSessionResumptionMode::from(s))
    }
}
impl TlsSessionResumptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TlsSessionResumptionMode::Disabled => "DISABLED",
            TlsSessionResumptionMode::Enabled => "ENABLED",
            TlsSessionResumptionMode::Enforced => "ENFORCED",
            TlsSessionResumptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED", "ENFORCED"]
    }
}
impl AsRef<str> for TlsSessionResumptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Creates a key-value pair for a specific resource. Tags are metadata that you can use to search for and group a resource for various purposes. You can apply tags to servers, users, and roles. A tag key can take more than one value. For example, to group servers for accounting purposes, you might create a tag called <code>Group</code> and assign the values <code>Research</code> and <code>Accounting</code> to that group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The name assigned to the tag that you create.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Contains one or more values that you assigned to the key name you create.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The name assigned to the tag that you create.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Contains one or more values that you assigned to the key name you create.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name assigned to the tag that you create.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name assigned to the tag that you create.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Contains one or more values that you assigned to the key name you create.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Contains one or more values that you assigned to the key name you create.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomStepStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomStepStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILURE" => CustomStepStatus::Failure,
            "SUCCESS" => CustomStepStatus::Success,
            other => CustomStepStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomStepStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomStepStatus::from(s))
    }
}
impl CustomStepStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomStepStatus::Failure => "FAILURE",
            CustomStepStatus::Success => "SUCCESS",
            CustomStepStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILURE", "SUCCESS"]
    }
}
impl AsRef<str> for CustomStepStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the ID, text description, and Amazon Resource Name (ARN) for the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedWorkflow {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>Specifies the text description for the workflow.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl ListedWorkflow {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>Specifies the text description for the workflow.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for ListedWorkflow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedWorkflow");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("description", &self.description);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ListedWorkflow`](crate::model::ListedWorkflow)
pub mod listed_workflow {
    /// A builder for [`ListedWorkflow`](crate::model::ListedWorkflow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>Specifies the text description for the workflow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Specifies the text description for the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedWorkflow`](crate::model::ListedWorkflow)
        pub fn build(self) -> crate::model::ListedWorkflow {
            crate::model::ListedWorkflow {
                workflow_id: self.workflow_id,
                description: self.description,
                arn: self.arn,
            }
        }
    }
}
impl ListedWorkflow {
    /// Creates a new builder-style object to manufacture [`ListedWorkflow`](crate::model::ListedWorkflow)
    pub fn builder() -> crate::model::listed_workflow::Builder {
        crate::model::listed_workflow::Builder::default()
    }
}

/// <p>Returns properties of the user that you specify.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedUser {
    /// <p>Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p> <note>
    /// <p>The IAM role that controls your users' access to your Amazon S3 bucket for servers with <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>. </p>
    /// <p>The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.</p>
    /// </note>
    pub role: std::option::Option<std::string::String>,
    /// <p>Specifies the number of SSH public keys stored for the user you specified.</p>
    pub ssh_public_key_count: std::option::Option<i32>,
    /// <p>Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl ListedUser {
    /// <p>Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p> <note>
    /// <p>The IAM role that controls your users' access to your Amazon S3 bucket for servers with <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>. </p>
    /// <p>The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.</p>
    /// </note>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>Specifies the number of SSH public keys stored for the user you specified.</p>
    pub fn ssh_public_key_count(&self) -> std::option::Option<i32> {
        self.ssh_public_key_count
    }
    /// <p>Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for ListedUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedUser");
        formatter.field("arn", &self.arn);
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("role", &self.role);
        formatter.field("ssh_public_key_count", &self.ssh_public_key_count);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`ListedUser`](crate::model::ListedUser)
pub mod listed_user {
    /// A builder for [`ListedUser`](crate::model::ListedUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_count: std::option::Option<i32>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p> <note>
        /// <p>The IAM role that controls your users' access to your Amazon S3 bucket for servers with <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>. </p>
        /// <p>The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.</p>
        /// </note>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p> <note>
        /// <p>The IAM role that controls your users' access to your Amazon S3 bucket for servers with <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>. </p>
        /// <p>The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.</p>
        /// </note>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>Specifies the number of SSH public keys stored for the user you specified.</p>
        pub fn ssh_public_key_count(mut self, input: i32) -> Self {
            self.ssh_public_key_count = Some(input);
            self
        }
        /// <p>Specifies the number of SSH public keys stored for the user you specified.</p>
        pub fn set_ssh_public_key_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ssh_public_key_count = input;
            self
        }
        /// <p>Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedUser`](crate::model::ListedUser)
        pub fn build(self) -> crate::model::ListedUser {
            crate::model::ListedUser {
                arn: self.arn,
                home_directory: self.home_directory,
                home_directory_type: self.home_directory_type,
                role: self.role,
                ssh_public_key_count: self.ssh_public_key_count,
                user_name: self.user_name,
            }
        }
    }
}
impl ListedUser {
    /// Creates a new builder-style object to manufacture [`ListedUser`](crate::model::ListedUser)
    pub fn builder() -> crate::model::listed_user::Builder {
        crate::model::listed_user::Builder::default()
    }
}

/// <p>Returns properties of a file transfer protocol-enabled server that was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedServer {
    /// <p>Specifies the unique Amazon Resource Name (ARN) for a server to be listed.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
    pub domain: std::option::Option<crate::model::Domain>,
    /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
    /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    /// <p>Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
    pub endpoint_type: std::option::Option<crate::model::EndpointType>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    pub logging_role: std::option::Option<std::string::String>,
    /// <p>Specifies the unique system assigned identifier for the servers that were listed.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
    /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
    pub user_count: std::option::Option<i32>,
}
impl ListedServer {
    /// <p>Specifies the unique Amazon Resource Name (ARN) for a server to be listed.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
    /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
    /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
    /// <p>Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::EndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    pub fn logging_role(&self) -> std::option::Option<&str> {
        self.logging_role.as_deref()
    }
    /// <p>Specifies the unique system assigned identifier for the servers that were listed.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
    /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
    pub fn user_count(&self) -> std::option::Option<i32> {
        self.user_count
    }
}
impl std::fmt::Debug for ListedServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedServer");
        formatter.field("arn", &self.arn);
        formatter.field("domain", &self.domain);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("logging_role", &self.logging_role);
        formatter.field("server_id", &self.server_id);
        formatter.field("state", &self.state);
        formatter.field("user_count", &self.user_count);
        formatter.finish()
    }
}
/// See [`ListedServer`](crate::model::ListedServer)
pub mod listed_server {
    /// A builder for [`ListedServer`](crate::model::ListedServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
        pub(crate) endpoint_type: std::option::Option<crate::model::EndpointType>,
        pub(crate) logging_role: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) user_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the unique Amazon Resource Name (ARN) for a server to be listed.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) for a server to be listed.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// <p>Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.logging_role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logging_role = input;
            self
        }
        /// <p>Specifies the unique system assigned identifier for the servers that were listed.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>Specifies the unique system assigned identifier for the servers that were listed.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
        /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
        /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
        pub fn user_count(mut self, input: i32) -> Self {
            self.user_count = Some(input);
            self
        }
        /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
        pub fn set_user_count(mut self, input: std::option::Option<i32>) -> Self {
            self.user_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedServer`](crate::model::ListedServer)
        pub fn build(self) -> crate::model::ListedServer {
            crate::model::ListedServer {
                arn: self.arn,
                domain: self.domain,
                identity_provider_type: self.identity_provider_type,
                endpoint_type: self.endpoint_type,
                logging_role: self.logging_role,
                server_id: self.server_id,
                state: self.state,
                user_count: self.user_count,
            }
        }
    }
}
impl ListedServer {
    /// Creates a new builder-style object to manufacture [`ListedServer`](crate::model::ListedServer)
    pub fn builder() -> crate::model::listed_server::Builder {
        crate::model::listed_server::Builder::default()
    }
}

/// <p>Describes the condition of a file transfer protocol-enabled server with respect to its
/// ability to perform file operations. There are six possible states: <code>OFFLINE</code>,
/// <code>ONLINE</code>, <code>STARTING</code>, <code>STOPPING</code>,
/// <code>START_FAILED</code>, and <code>STOP_FAILED</code>.</p>
///
/// <p>
/// <code>OFFLINE</code> indicates that the server exists, but that it is not available for
/// file operations. <code>ONLINE</code> indicates that the server is available to perform file
/// operations. <code>STARTING</code> indicates that the server's was instantiated, but the
/// server is not yet available to perform file operations. Under normal conditions, it can take a
/// couple of minutes for the server to be completely operational. Both <code>START_FAILED</code>
/// and <code>STOP_FAILED</code> are error conditions.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Offline,
    #[allow(missing_docs)] // documentation missing in model
    Online,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    StartFailed,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    StopFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "OFFLINE" => State::Offline,
            "ONLINE" => State::Online,
            "STARTING" => State::Starting,
            "START_FAILED" => State::StartFailed,
            "STOPPING" => State::Stopping,
            "STOP_FAILED" => State::StopFailed,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Offline => "OFFLINE",
            State::Online => "ONLINE",
            State::Starting => "STARTING",
            State::StartFailed => "START_FAILED",
            State::Stopping => "STOPPING",
            State::StopFailed => "STOP_FAILED",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OFFLINE",
            "ONLINE",
            "STARTING",
            "START_FAILED",
            "STOPPING",
            "STOP_FAILED",
        ]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information related to the type of user authentication that is in use for a file
/// transfer protocol-enabled server's users. For <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code>
/// authentication, the Secure Shell (SSH) public keys are stored with a user on the server
/// instance. For <code>API_GATEWAY</code> authentication, your custom authentication method is
/// implemented by using an API call. The server can have only one method of
/// authentication.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IdentityProviderType {
    #[allow(missing_docs)] // documentation missing in model
    ApiGateway,
    #[allow(missing_docs)] // documentation missing in model
    AwsDirectoryService,
    #[allow(missing_docs)] // documentation missing in model
    AwsLambda,
    #[allow(missing_docs)] // documentation missing in model
    ServiceManaged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IdentityProviderType {
    fn from(s: &str) -> Self {
        match s {
            "API_GATEWAY" => IdentityProviderType::ApiGateway,
            "AWS_DIRECTORY_SERVICE" => IdentityProviderType::AwsDirectoryService,
            "AWS_LAMBDA" => IdentityProviderType::AwsLambda,
            "SERVICE_MANAGED" => IdentityProviderType::ServiceManaged,
            other => IdentityProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IdentityProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IdentityProviderType::from(s))
    }
}
impl IdentityProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IdentityProviderType::ApiGateway => "API_GATEWAY",
            IdentityProviderType::AwsDirectoryService => "AWS_DIRECTORY_SERVICE",
            IdentityProviderType::AwsLambda => "AWS_LAMBDA",
            IdentityProviderType::ServiceManaged => "SERVICE_MANAGED",
            IdentityProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "API_GATEWAY",
            "AWS_DIRECTORY_SERVICE",
            "AWS_LAMBDA",
            "SERVICE_MANAGED",
        ]
    }
}
impl AsRef<str> for IdentityProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Domain {
    #[allow(missing_docs)] // documentation missing in model
    Efs,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Domain {
    fn from(s: &str) -> Self {
        match s {
            "EFS" => Domain::Efs,
            "S3" => Domain::S3,
            other => Domain::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Domain {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Domain::from(s))
    }
}
impl Domain {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Domain::Efs => "EFS",
            Domain::S3 => "S3",
            Domain::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EFS", "S3"]
    }
}
impl AsRef<str> for Domain {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns properties of the execution that is specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedExecution {
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
    pub initial_file_location: std::option::Option<crate::model::FileLocation>,
    /// <p>A container object for the session details associated with a workflow.</p>
    pub service_metadata: std::option::Option<crate::model::ServiceMetadata>,
    /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.</p>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
}
impl ListedExecution {
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
    pub fn initial_file_location(&self) -> std::option::Option<&crate::model::FileLocation> {
        self.initial_file_location.as_ref()
    }
    /// <p>A container object for the session details associated with a workflow.</p>
    pub fn service_metadata(&self) -> std::option::Option<&crate::model::ServiceMetadata> {
        self.service_metadata.as_ref()
    }
    /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ListedExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedExecution");
        formatter.field("execution_id", &self.execution_id);
        formatter.field("initial_file_location", &self.initial_file_location);
        formatter.field("service_metadata", &self.service_metadata);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListedExecution`](crate::model::ListedExecution)
pub mod listed_execution {
    /// A builder for [`ListedExecution`](crate::model::ListedExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) initial_file_location: std::option::Option<crate::model::FileLocation>,
        pub(crate) service_metadata: std::option::Option<crate::model::ServiceMetadata>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
    }
    impl Builder {
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
        pub fn initial_file_location(mut self, input: crate::model::FileLocation) -> Self {
            self.initial_file_location = Some(input);
            self
        }
        /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
        pub fn set_initial_file_location(
            mut self,
            input: std::option::Option<crate::model::FileLocation>,
        ) -> Self {
            self.initial_file_location = input;
            self
        }
        /// <p>A container object for the session details associated with a workflow.</p>
        pub fn service_metadata(mut self, input: crate::model::ServiceMetadata) -> Self {
            self.service_metadata = Some(input);
            self
        }
        /// <p>A container object for the session details associated with a workflow.</p>
        pub fn set_service_metadata(
            mut self,
            input: std::option::Option<crate::model::ServiceMetadata>,
        ) -> Self {
            self.service_metadata = input;
            self
        }
        /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.</p>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedExecution`](crate::model::ListedExecution)
        pub fn build(self) -> crate::model::ListedExecution {
            crate::model::ListedExecution {
                execution_id: self.execution_id,
                initial_file_location: self.initial_file_location,
                service_metadata: self.service_metadata,
                status: self.status,
            }
        }
    }
}
impl ListedExecution {
    /// Creates a new builder-style object to manufacture [`ListedExecution`](crate::model::ListedExecution)
    pub fn builder() -> crate::model::listed_execution::Builder {
        crate::model::listed_execution::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Exception,
    #[allow(missing_docs)] // documentation missing in model
    HandlingException,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => ExecutionStatus::Completed,
            "EXCEPTION" => ExecutionStatus::Exception,
            "HANDLING_EXCEPTION" => ExecutionStatus::HandlingException,
            "IN_PROGRESS" => ExecutionStatus::InProgress,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Completed => "COMPLETED",
            ExecutionStatus::Exception => "EXCEPTION",
            ExecutionStatus::HandlingException => "HANDLING_EXCEPTION",
            ExecutionStatus::InProgress => "IN_PROGRESS",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "EXCEPTION",
            "HANDLING_EXCEPTION",
            "IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container object for the session details associated with a workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceMetadata {
    /// <p>The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>) make up the <code>UserDetails</code>.</p>
    pub user_details: std::option::Option<crate::model::UserDetails>,
}
impl ServiceMetadata {
    /// <p>The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>) make up the <code>UserDetails</code>.</p>
    pub fn user_details(&self) -> std::option::Option<&crate::model::UserDetails> {
        self.user_details.as_ref()
    }
}
impl std::fmt::Debug for ServiceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceMetadata");
        formatter.field("user_details", &self.user_details);
        formatter.finish()
    }
}
/// See [`ServiceMetadata`](crate::model::ServiceMetadata)
pub mod service_metadata {
    /// A builder for [`ServiceMetadata`](crate::model::ServiceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_details: std::option::Option<crate::model::UserDetails>,
    }
    impl Builder {
        /// <p>The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>) make up the <code>UserDetails</code>.</p>
        pub fn user_details(mut self, input: crate::model::UserDetails) -> Self {
            self.user_details = Some(input);
            self
        }
        /// <p>The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>) make up the <code>UserDetails</code>.</p>
        pub fn set_user_details(
            mut self,
            input: std::option::Option<crate::model::UserDetails>,
        ) -> Self {
            self.user_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceMetadata`](crate::model::ServiceMetadata)
        pub fn build(self) -> crate::model::ServiceMetadata {
            crate::model::ServiceMetadata {
                user_details: self.user_details,
            }
        }
    }
}
impl ServiceMetadata {
    /// Creates a new builder-style object to manufacture [`ServiceMetadata`](crate::model::ServiceMetadata)
    pub fn builder() -> crate::model::service_metadata::Builder {
        crate::model::service_metadata::Builder::default()
    }
}

/// <p>Specifies the user name, server ID, and session ID for a workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDetails {
    /// <p>A unique string that identifies a user account associated with a server.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The system-assigned unique identifier for a Transfer server instance. </p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The system-assigned unique identifier for a session that corresponds to the workflow.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl UserDetails {
    /// <p>A unique string that identifies a user account associated with a server.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The system-assigned unique identifier for a Transfer server instance. </p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The system-assigned unique identifier for a session that corresponds to the workflow.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for UserDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDetails");
        formatter.field("user_name", &self.user_name);
        formatter.field("server_id", &self.server_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}
/// See [`UserDetails`](crate::model::UserDetails)
pub mod user_details {
    /// A builder for [`UserDetails`](crate::model::UserDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string that identifies a user account associated with a server.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A unique string that identifies a user account associated with a server.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The system-assigned unique identifier for a Transfer server instance. </p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The system-assigned unique identifier for a Transfer server instance. </p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The system-assigned unique identifier for a session that corresponds to the workflow.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The system-assigned unique identifier for a session that corresponds to the workflow.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDetails`](crate::model::UserDetails)
        pub fn build(self) -> crate::model::UserDetails {
            crate::model::UserDetails {
                user_name: self.user_name,
                server_id: self.server_id,
                session_id: self.session_id,
            }
        }
    }
}
impl UserDetails {
    /// Creates a new builder-style object to manufacture [`UserDetails`](crate::model::UserDetails)
    pub fn builder() -> crate::model::user_details::Builder {
        crate::model::user_details::Builder::default()
    }
}

/// <p>Specifies the Amazon S3 or EFS file details to be used in the step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileLocation {
    /// <p>Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.</p>
    pub s3_file_location: std::option::Option<crate::model::S3FileLocation>,
    /// <p>Specifies the Amazon EFS ID and the path for the file being used.</p>
    pub efs_file_location: std::option::Option<crate::model::EfsFileLocation>,
}
impl FileLocation {
    /// <p>Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.</p>
    pub fn s3_file_location(&self) -> std::option::Option<&crate::model::S3FileLocation> {
        self.s3_file_location.as_ref()
    }
    /// <p>Specifies the Amazon EFS ID and the path for the file being used.</p>
    pub fn efs_file_location(&self) -> std::option::Option<&crate::model::EfsFileLocation> {
        self.efs_file_location.as_ref()
    }
}
impl std::fmt::Debug for FileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileLocation");
        formatter.field("s3_file_location", &self.s3_file_location);
        formatter.field("efs_file_location", &self.efs_file_location);
        formatter.finish()
    }
}
/// See [`FileLocation`](crate::model::FileLocation)
pub mod file_location {
    /// A builder for [`FileLocation`](crate::model::FileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_file_location: std::option::Option<crate::model::S3FileLocation>,
        pub(crate) efs_file_location: std::option::Option<crate::model::EfsFileLocation>,
    }
    impl Builder {
        /// <p>Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.</p>
        pub fn s3_file_location(mut self, input: crate::model::S3FileLocation) -> Self {
            self.s3_file_location = Some(input);
            self
        }
        /// <p>Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.</p>
        pub fn set_s3_file_location(
            mut self,
            input: std::option::Option<crate::model::S3FileLocation>,
        ) -> Self {
            self.s3_file_location = input;
            self
        }
        /// <p>Specifies the Amazon EFS ID and the path for the file being used.</p>
        pub fn efs_file_location(mut self, input: crate::model::EfsFileLocation) -> Self {
            self.efs_file_location = Some(input);
            self
        }
        /// <p>Specifies the Amazon EFS ID and the path for the file being used.</p>
        pub fn set_efs_file_location(
            mut self,
            input: std::option::Option<crate::model::EfsFileLocation>,
        ) -> Self {
            self.efs_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`FileLocation`](crate::model::FileLocation)
        pub fn build(self) -> crate::model::FileLocation {
            crate::model::FileLocation {
                s3_file_location: self.s3_file_location,
                efs_file_location: self.efs_file_location,
            }
        }
    }
}
impl FileLocation {
    /// Creates a new builder-style object to manufacture [`FileLocation`](crate::model::FileLocation)
    pub fn builder() -> crate::model::file_location::Builder {
        crate::model::file_location::Builder::default()
    }
}

/// <p>Reserved for future use.</p>
/// <p> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsFileLocation {
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The pathname for the folder being used by a workflow.</p>
    pub path: std::option::Option<std::string::String>,
}
impl EfsFileLocation {
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The pathname for the folder being used by a workflow.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for EfsFileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsFileLocation");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`EfsFileLocation`](crate::model::EfsFileLocation)
pub mod efs_file_location {
    /// A builder for [`EfsFileLocation`](crate::model::EfsFileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The pathname for the folder being used by a workflow.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The pathname for the folder being used by a workflow.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsFileLocation`](crate::model::EfsFileLocation)
        pub fn build(self) -> crate::model::EfsFileLocation {
            crate::model::EfsFileLocation {
                file_system_id: self.file_system_id,
                path: self.path,
            }
        }
    }
}
impl EfsFileLocation {
    /// Creates a new builder-style object to manufacture [`EfsFileLocation`](crate::model::EfsFileLocation)
    pub fn builder() -> crate::model::efs_file_location::Builder {
        crate::model::efs_file_location::Builder::default()
    }
}

/// <p>Specifies the details for the file location for the file being used in the workflow. Only applicable if you are using S3 storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3FileLocation {
    /// <p>Specifies the S3 bucket that contains the file being used.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Specifies the file version.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.</p>
    pub etag: std::option::Option<std::string::String>,
}
impl S3FileLocation {
    /// <p>Specifies the S3 bucket that contains the file being used.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Specifies the file version.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.</p>
    pub fn etag(&self) -> std::option::Option<&str> {
        self.etag.as_deref()
    }
}
impl std::fmt::Debug for S3FileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3FileLocation");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("version_id", &self.version_id);
        formatter.field("etag", &self.etag);
        formatter.finish()
    }
}
/// See [`S3FileLocation`](crate::model::S3FileLocation)
pub mod s3_file_location {
    /// A builder for [`S3FileLocation`](crate::model::S3FileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) etag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the S3 bucket that contains the file being used.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the S3 bucket that contains the file being used.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Specifies the file version.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Specifies the file version.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.</p>
        pub fn etag(mut self, input: impl Into<std::string::String>) -> Self {
            self.etag = Some(input.into());
            self
        }
        /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.</p>
        pub fn set_etag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.etag = input;
            self
        }
        /// Consumes the builder and constructs a [`S3FileLocation`](crate::model::S3FileLocation)
        pub fn build(self) -> crate::model::S3FileLocation {
            crate::model::S3FileLocation {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                etag: self.etag,
            }
        }
    }
}
impl S3FileLocation {
    /// Creates a new builder-style object to manufacture [`S3FileLocation`](crate::model::S3FileLocation)
    pub fn builder() -> crate::model::s3_file_location::Builder {
        crate::model::s3_file_location::Builder::default()
    }
}

/// <p>Lists the properties for one or more specified associated accesses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedAccess {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
    /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl ListedAccess {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
    /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for ListedAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedAccess");
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("role", &self.role);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}
/// See [`ListedAccess`](crate::model::ListedAccess)
pub mod listed_access {
    /// A builder for [`ListedAccess`](crate::model::ListedAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedAccess`](crate::model::ListedAccess)
        pub fn build(self) -> crate::model::ListedAccess {
            crate::model::ListedAccess {
                home_directory: self.home_directory,
                home_directory_type: self.home_directory_type,
                role: self.role,
                external_id: self.external_id,
            }
        }
    }
}
impl ListedAccess {
    /// Creates a new builder-style object to manufacture [`ListedAccess`](crate::model::ListedAccess)
    pub fn builder() -> crate::model::listed_access::Builder {
        crate::model::listed_access::Builder::default()
    }
}

/// <p>Describes the properties of the specified workflow</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribedWorkflow {
    /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the text description for the workflow.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the details for the steps that are in the specified workflow.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
    /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
    pub on_exception_steps: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DescribedWorkflow {
    /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the text description for the workflow.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the details for the steps that are in the specified workflow.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::WorkflowStep]> {
        self.steps.as_deref()
    }
    /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
    pub fn on_exception_steps(&self) -> std::option::Option<&[crate::model::WorkflowStep]> {
        self.on_exception_steps.as_deref()
    }
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for DescribedWorkflow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribedWorkflow");
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("steps", &self.steps);
        formatter.field("on_exception_steps", &self.on_exception_steps);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribedWorkflow`](crate::model::DescribedWorkflow)
pub mod described_workflow {
    /// A builder for [`DescribedWorkflow`](crate::model::DescribedWorkflow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        pub(crate) on_exception_steps:
            std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) for the workflow.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the text description for the workflow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Specifies the text description for the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        pub fn steps(mut self, input: crate::model::WorkflowStep) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Appends an item to `on_exception_steps`.
        ///
        /// To override the contents of this collection use [`set_on_exception_steps`](Self::set_on_exception_steps).
        ///
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
        pub fn on_exception_steps(mut self, input: crate::model::WorkflowStep) -> Self {
            let mut v = self.on_exception_steps.unwrap_or_default();
            v.push(input);
            self.on_exception_steps = Some(v);
            self
        }
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
        pub fn set_on_exception_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        ) -> Self {
            self.on_exception_steps = input;
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribedWorkflow`](crate::model::DescribedWorkflow)
        pub fn build(self) -> crate::model::DescribedWorkflow {
            crate::model::DescribedWorkflow {
                arn: self.arn,
                description: self.description,
                steps: self.steps,
                on_exception_steps: self.on_exception_steps,
                workflow_id: self.workflow_id,
                tags: self.tags,
            }
        }
    }
}
impl DescribedWorkflow {
    /// Creates a new builder-style object to manufacture [`DescribedWorkflow`](crate::model::DescribedWorkflow)
    pub fn builder() -> crate::model::described_workflow::Builder {
        crate::model::described_workflow::Builder::default()
    }
}

/// <p>The basic building block of a workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowStep {
    /// <p> Currently, the following step types are supported. </p>
    /// <ul>
    /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
    /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
    /// <li> <p> <i>Delete</i>: delete the file</p> </li>
    /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::WorkflowStepType>,
    /// <p>Details for a step that performs a file copy.</p>
    /// <p> Consists of the following values: </p>
    /// <ul>
    /// <li> <p>A description</p> </li>
    /// <li> <p>An S3 location for the destination of the file copy.</p> </li>
    /// <li> <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p> </li>
    /// </ul>
    pub copy_step_details: std::option::Option<crate::model::CopyStepDetails>,
    /// <p>Details for a step that invokes a lambda function.</p>
    /// <p> Consists of the lambda function name, target, and timeout (in seconds). </p>
    pub custom_step_details: std::option::Option<crate::model::CustomStepDetails>,
    /// <p>Details for a step that deletes the file.</p>
    pub delete_step_details: std::option::Option<crate::model::DeleteStepDetails>,
    /// <p>Details for a step that creates one or more tags.</p>
    /// <p>You specify one or more tags: each tag contains a key/value pair.</p>
    pub tag_step_details: std::option::Option<crate::model::TagStepDetails>,
}
impl WorkflowStep {
    /// <p> Currently, the following step types are supported. </p>
    /// <ul>
    /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
    /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
    /// <li> <p> <i>Delete</i>: delete the file</p> </li>
    /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WorkflowStepType> {
        self.r#type.as_ref()
    }
    /// <p>Details for a step that performs a file copy.</p>
    /// <p> Consists of the following values: </p>
    /// <ul>
    /// <li> <p>A description</p> </li>
    /// <li> <p>An S3 location for the destination of the file copy.</p> </li>
    /// <li> <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p> </li>
    /// </ul>
    pub fn copy_step_details(&self) -> std::option::Option<&crate::model::CopyStepDetails> {
        self.copy_step_details.as_ref()
    }
    /// <p>Details for a step that invokes a lambda function.</p>
    /// <p> Consists of the lambda function name, target, and timeout (in seconds). </p>
    pub fn custom_step_details(&self) -> std::option::Option<&crate::model::CustomStepDetails> {
        self.custom_step_details.as_ref()
    }
    /// <p>Details for a step that deletes the file.</p>
    pub fn delete_step_details(&self) -> std::option::Option<&crate::model::DeleteStepDetails> {
        self.delete_step_details.as_ref()
    }
    /// <p>Details for a step that creates one or more tags.</p>
    /// <p>You specify one or more tags: each tag contains a key/value pair.</p>
    pub fn tag_step_details(&self) -> std::option::Option<&crate::model::TagStepDetails> {
        self.tag_step_details.as_ref()
    }
}
impl std::fmt::Debug for WorkflowStep {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowStep");
        formatter.field("r#type", &self.r#type);
        formatter.field("copy_step_details", &self.copy_step_details);
        formatter.field("custom_step_details", &self.custom_step_details);
        formatter.field("delete_step_details", &self.delete_step_details);
        formatter.field("tag_step_details", &self.tag_step_details);
        formatter.finish()
    }
}
/// See [`WorkflowStep`](crate::model::WorkflowStep)
pub mod workflow_step {
    /// A builder for [`WorkflowStep`](crate::model::WorkflowStep)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WorkflowStepType>,
        pub(crate) copy_step_details: std::option::Option<crate::model::CopyStepDetails>,
        pub(crate) custom_step_details: std::option::Option<crate::model::CustomStepDetails>,
        pub(crate) delete_step_details: std::option::Option<crate::model::DeleteStepDetails>,
        pub(crate) tag_step_details: std::option::Option<crate::model::TagStepDetails>,
    }
    impl Builder {
        /// <p> Currently, the following step types are supported. </p>
        /// <ul>
        /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
        /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
        /// <li> <p> <i>Delete</i>: delete the file</p> </li>
        /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::WorkflowStepType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> Currently, the following step types are supported. </p>
        /// <ul>
        /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
        /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
        /// <li> <p> <i>Delete</i>: delete the file</p> </li>
        /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowStepType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Details for a step that performs a file copy.</p>
        /// <p> Consists of the following values: </p>
        /// <ul>
        /// <li> <p>A description</p> </li>
        /// <li> <p>An S3 location for the destination of the file copy.</p> </li>
        /// <li> <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p> </li>
        /// </ul>
        pub fn copy_step_details(mut self, input: crate::model::CopyStepDetails) -> Self {
            self.copy_step_details = Some(input);
            self
        }
        /// <p>Details for a step that performs a file copy.</p>
        /// <p> Consists of the following values: </p>
        /// <ul>
        /// <li> <p>A description</p> </li>
        /// <li> <p>An S3 location for the destination of the file copy.</p> </li>
        /// <li> <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p> </li>
        /// </ul>
        pub fn set_copy_step_details(
            mut self,
            input: std::option::Option<crate::model::CopyStepDetails>,
        ) -> Self {
            self.copy_step_details = input;
            self
        }
        /// <p>Details for a step that invokes a lambda function.</p>
        /// <p> Consists of the lambda function name, target, and timeout (in seconds). </p>
        pub fn custom_step_details(mut self, input: crate::model::CustomStepDetails) -> Self {
            self.custom_step_details = Some(input);
            self
        }
        /// <p>Details for a step that invokes a lambda function.</p>
        /// <p> Consists of the lambda function name, target, and timeout (in seconds). </p>
        pub fn set_custom_step_details(
            mut self,
            input: std::option::Option<crate::model::CustomStepDetails>,
        ) -> Self {
            self.custom_step_details = input;
            self
        }
        /// <p>Details for a step that deletes the file.</p>
        pub fn delete_step_details(mut self, input: crate::model::DeleteStepDetails) -> Self {
            self.delete_step_details = Some(input);
            self
        }
        /// <p>Details for a step that deletes the file.</p>
        pub fn set_delete_step_details(
            mut self,
            input: std::option::Option<crate::model::DeleteStepDetails>,
        ) -> Self {
            self.delete_step_details = input;
            self
        }
        /// <p>Details for a step that creates one or more tags.</p>
        /// <p>You specify one or more tags: each tag contains a key/value pair.</p>
        pub fn tag_step_details(mut self, input: crate::model::TagStepDetails) -> Self {
            self.tag_step_details = Some(input);
            self
        }
        /// <p>Details for a step that creates one or more tags.</p>
        /// <p>You specify one or more tags: each tag contains a key/value pair.</p>
        pub fn set_tag_step_details(
            mut self,
            input: std::option::Option<crate::model::TagStepDetails>,
        ) -> Self {
            self.tag_step_details = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowStep`](crate::model::WorkflowStep)
        pub fn build(self) -> crate::model::WorkflowStep {
            crate::model::WorkflowStep {
                r#type: self.r#type,
                copy_step_details: self.copy_step_details,
                custom_step_details: self.custom_step_details,
                delete_step_details: self.delete_step_details,
                tag_step_details: self.tag_step_details,
            }
        }
    }
}
impl WorkflowStep {
    /// Creates a new builder-style object to manufacture [`WorkflowStep`](crate::model::WorkflowStep)
    pub fn builder() -> crate::model::workflow_step::Builder {
        crate::model::workflow_step::Builder::default()
    }
}

/// <p>Each step type has its own <code>StepDetails</code> structure.</p>
/// <p>The key/value pairs used to tag a file during the execution of a workflow step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Array that contains from 1 to 10 key/value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub source_file_location: std::option::Option<std::string::String>,
}
impl TagStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Array that contains from 1 to 10 key/value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tags.as_deref()
    }
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub fn source_file_location(&self) -> std::option::Option<&str> {
        self.source_file_location.as_deref()
    }
}
impl std::fmt::Debug for TagStepDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagStepDetails");
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.field("source_file_location", &self.source_file_location);
        formatter.finish()
    }
}
/// See [`TagStepDetails`](crate::model::TagStepDetails)
pub mod tag_step_details {
    /// A builder for [`TagStepDetails`](crate::model::TagStepDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        pub(crate) source_file_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the step, used as an identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the step, used as an identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Array that contains from 1 to 10 key/value pairs.</p>
        pub fn tags(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Array that contains from 1 to 10 key/value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn source_file_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_location = Some(input.into());
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn set_source_file_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`TagStepDetails`](crate::model::TagStepDetails)
        pub fn build(self) -> crate::model::TagStepDetails {
            crate::model::TagStepDetails {
                name: self.name,
                tags: self.tags,
                source_file_location: self.source_file_location,
            }
        }
    }
}
impl TagStepDetails {
    /// Creates a new builder-style object to manufacture [`TagStepDetails`](crate::model::TagStepDetails)
    pub fn builder() -> crate::model::tag_step_details::Builder {
        crate::model::tag_step_details::Builder::default()
    }
}

/// <p>Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Tag {
    /// <p>The name assigned to the tag that you create.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value that corresponds to the key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl S3Tag {
    /// <p>The name assigned to the tag that you create.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value that corresponds to the key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for S3Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`S3Tag`](crate::model::S3Tag)
pub mod s3_tag {
    /// A builder for [`S3Tag`](crate::model::S3Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name assigned to the tag that you create.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name assigned to the tag that you create.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value that corresponds to the key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value that corresponds to the key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Tag`](crate::model::S3Tag)
        pub fn build(self) -> crate::model::S3Tag {
            crate::model::S3Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl S3Tag {
    /// Creates a new builder-style object to manufacture [`S3Tag`](crate::model::S3Tag)
    pub fn builder() -> crate::model::s3_tag::Builder {
        crate::model::s3_tag::Builder::default()
    }
}

/// <p>The name of the step, used to identify the delete step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub source_file_location: std::option::Option<std::string::String>,
}
impl DeleteStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub fn source_file_location(&self) -> std::option::Option<&str> {
        self.source_file_location.as_deref()
    }
}
impl std::fmt::Debug for DeleteStepDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStepDetails");
        formatter.field("name", &self.name);
        formatter.field("source_file_location", &self.source_file_location);
        formatter.finish()
    }
}
/// See [`DeleteStepDetails`](crate::model::DeleteStepDetails)
pub mod delete_step_details {
    /// A builder for [`DeleteStepDetails`](crate::model::DeleteStepDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_file_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the step, used as an identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the step, used as an identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn source_file_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_location = Some(input.into());
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn set_source_file_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStepDetails`](crate::model::DeleteStepDetails)
        pub fn build(self) -> crate::model::DeleteStepDetails {
            crate::model::DeleteStepDetails {
                name: self.name,
                source_file_location: self.source_file_location,
            }
        }
    }
}
impl DeleteStepDetails {
    /// Creates a new builder-style object to manufacture [`DeleteStepDetails`](crate::model::DeleteStepDetails)
    pub fn builder() -> crate::model::delete_step_details::Builder {
        crate::model::delete_step_details::Builder::default()
    }
}

/// <p>Each step type has its own <code>StepDetails</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN for the lambda function that is being called.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>Timeout, in seconds, for the step.</p>
    pub timeout_seconds: std::option::Option<i32>,
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub source_file_location: std::option::Option<std::string::String>,
}
impl CustomStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN for the lambda function that is being called.</p>
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
    /// <p>Timeout, in seconds, for the step.</p>
    pub fn timeout_seconds(&self) -> std::option::Option<i32> {
        self.timeout_seconds
    }
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub fn source_file_location(&self) -> std::option::Option<&str> {
        self.source_file_location.as_deref()
    }
}
impl std::fmt::Debug for CustomStepDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomStepDetails");
        formatter.field("name", &self.name);
        formatter.field("target", &self.target);
        formatter.field("timeout_seconds", &self.timeout_seconds);
        formatter.field("source_file_location", &self.source_file_location);
        formatter.finish()
    }
}
/// See [`CustomStepDetails`](crate::model::CustomStepDetails)
pub mod custom_step_details {
    /// A builder for [`CustomStepDetails`](crate::model::CustomStepDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) timeout_seconds: std::option::Option<i32>,
        pub(crate) source_file_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the step, used as an identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the step, used as an identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN for the lambda function that is being called.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The ARN for the lambda function that is being called.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>Timeout, in seconds, for the step.</p>
        pub fn timeout_seconds(mut self, input: i32) -> Self {
            self.timeout_seconds = Some(input);
            self
        }
        /// <p>Timeout, in seconds, for the step.</p>
        pub fn set_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_seconds = input;
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn source_file_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_location = Some(input.into());
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn set_source_file_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomStepDetails`](crate::model::CustomStepDetails)
        pub fn build(self) -> crate::model::CustomStepDetails {
            crate::model::CustomStepDetails {
                name: self.name,
                target: self.target,
                timeout_seconds: self.timeout_seconds,
                source_file_location: self.source_file_location,
            }
        }
    }
}
impl CustomStepDetails {
    /// Creates a new builder-style object to manufacture [`CustomStepDetails`](crate::model::CustomStepDetails)
    pub fn builder() -> crate::model::custom_step_details::Builder {
        crate::model::custom_step_details::Builder::default()
    }
}

/// <p>Each step type has its own <code>StepDetails</code> structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the location for the file being copied. Only applicable for Copy type workflow steps. Use <code>${Transfer:username}</code> in this field to parametrize the destination prefix by username.</p>
    pub destination_file_location: std::option::Option<crate::model::InputFileLocation>,
    /// <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p>
    pub overwrite_existing: std::option::Option<crate::model::OverwriteExisting>,
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub source_file_location: std::option::Option<std::string::String>,
}
impl CopyStepDetails {
    /// <p>The name of the step, used as an identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the location for the file being copied. Only applicable for Copy type workflow steps. Use <code>${Transfer:username}</code> in this field to parametrize the destination prefix by username.</p>
    pub fn destination_file_location(
        &self,
    ) -> std::option::Option<&crate::model::InputFileLocation> {
        self.destination_file_location.as_ref()
    }
    /// <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p>
    pub fn overwrite_existing(&self) -> std::option::Option<&crate::model::OverwriteExisting> {
        self.overwrite_existing.as_ref()
    }
    /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
    /// <ul>
    /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
    /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
    /// </ul>
    pub fn source_file_location(&self) -> std::option::Option<&str> {
        self.source_file_location.as_deref()
    }
}
impl std::fmt::Debug for CopyStepDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyStepDetails");
        formatter.field("name", &self.name);
        formatter.field("destination_file_location", &self.destination_file_location);
        formatter.field("overwrite_existing", &self.overwrite_existing);
        formatter.field("source_file_location", &self.source_file_location);
        formatter.finish()
    }
}
/// See [`CopyStepDetails`](crate::model::CopyStepDetails)
pub mod copy_step_details {
    /// A builder for [`CopyStepDetails`](crate::model::CopyStepDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_file_location: std::option::Option<crate::model::InputFileLocation>,
        pub(crate) overwrite_existing: std::option::Option<crate::model::OverwriteExisting>,
        pub(crate) source_file_location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the step, used as an identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the step, used as an identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the location for the file being copied. Only applicable for Copy type workflow steps. Use <code>${Transfer:username}</code> in this field to parametrize the destination prefix by username.</p>
        pub fn destination_file_location(mut self, input: crate::model::InputFileLocation) -> Self {
            self.destination_file_location = Some(input);
            self
        }
        /// <p>Specifies the location for the file being copied. Only applicable for Copy type workflow steps. Use <code>${Transfer:username}</code> in this field to parametrize the destination prefix by username.</p>
        pub fn set_destination_file_location(
            mut self,
            input: std::option::Option<crate::model::InputFileLocation>,
        ) -> Self {
            self.destination_file_location = input;
            self
        }
        /// <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p>
        pub fn overwrite_existing(mut self, input: crate::model::OverwriteExisting) -> Self {
            self.overwrite_existing = Some(input);
            self
        }
        /// <p>A flag that indicates whether or not to overwrite an existing file of the same name. The default is <code>FALSE</code>.</p>
        pub fn set_overwrite_existing(
            mut self,
            input: std::option::Option<crate::model::OverwriteExisting>,
        ) -> Self {
            self.overwrite_existing = input;
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn source_file_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_location = Some(input.into());
            self
        }
        /// <p>Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow.</p>
        /// <ul>
        /// <li> <p>Enter <code>${previous.file}</code> to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value.</p> </li>
        /// <li> <p>Enter <code>${original.file}</code> to use the originally-uploaded file location as input for this step.</p> </li>
        /// </ul>
        pub fn set_source_file_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyStepDetails`](crate::model::CopyStepDetails)
        pub fn build(self) -> crate::model::CopyStepDetails {
            crate::model::CopyStepDetails {
                name: self.name,
                destination_file_location: self.destination_file_location,
                overwrite_existing: self.overwrite_existing,
                source_file_location: self.source_file_location,
            }
        }
    }
}
impl CopyStepDetails {
    /// Creates a new builder-style object to manufacture [`CopyStepDetails`](crate::model::CopyStepDetails)
    pub fn builder() -> crate::model::copy_step_details::Builder {
        crate::model::copy_step_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OverwriteExisting {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OverwriteExisting {
    fn from(s: &str) -> Self {
        match s {
            "FALSE" => OverwriteExisting::False,
            "TRUE" => OverwriteExisting::True,
            other => OverwriteExisting::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OverwriteExisting {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OverwriteExisting::from(s))
    }
}
impl OverwriteExisting {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OverwriteExisting::False => "FALSE",
            OverwriteExisting::True => "TRUE",
            OverwriteExisting::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALSE", "TRUE"]
    }
}
impl AsRef<str> for OverwriteExisting {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputFileLocation {
    /// <p>Specifies the details for the S3 file being copied.</p>
    pub s3_file_location: std::option::Option<crate::model::S3InputFileLocation>,
    /// <p>Reserved for future use.</p>
    pub efs_file_location: std::option::Option<crate::model::EfsFileLocation>,
}
impl InputFileLocation {
    /// <p>Specifies the details for the S3 file being copied.</p>
    pub fn s3_file_location(&self) -> std::option::Option<&crate::model::S3InputFileLocation> {
        self.s3_file_location.as_ref()
    }
    /// <p>Reserved for future use.</p>
    pub fn efs_file_location(&self) -> std::option::Option<&crate::model::EfsFileLocation> {
        self.efs_file_location.as_ref()
    }
}
impl std::fmt::Debug for InputFileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputFileLocation");
        formatter.field("s3_file_location", &self.s3_file_location);
        formatter.field("efs_file_location", &self.efs_file_location);
        formatter.finish()
    }
}
/// See [`InputFileLocation`](crate::model::InputFileLocation)
pub mod input_file_location {
    /// A builder for [`InputFileLocation`](crate::model::InputFileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_file_location: std::option::Option<crate::model::S3InputFileLocation>,
        pub(crate) efs_file_location: std::option::Option<crate::model::EfsFileLocation>,
    }
    impl Builder {
        /// <p>Specifies the details for the S3 file being copied.</p>
        pub fn s3_file_location(mut self, input: crate::model::S3InputFileLocation) -> Self {
            self.s3_file_location = Some(input);
            self
        }
        /// <p>Specifies the details for the S3 file being copied.</p>
        pub fn set_s3_file_location(
            mut self,
            input: std::option::Option<crate::model::S3InputFileLocation>,
        ) -> Self {
            self.s3_file_location = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn efs_file_location(mut self, input: crate::model::EfsFileLocation) -> Self {
            self.efs_file_location = Some(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_efs_file_location(
            mut self,
            input: std::option::Option<crate::model::EfsFileLocation>,
        ) -> Self {
            self.efs_file_location = input;
            self
        }
        /// Consumes the builder and constructs a [`InputFileLocation`](crate::model::InputFileLocation)
        pub fn build(self) -> crate::model::InputFileLocation {
            crate::model::InputFileLocation {
                s3_file_location: self.s3_file_location,
                efs_file_location: self.efs_file_location,
            }
        }
    }
}
impl InputFileLocation {
    /// Creates a new builder-style object to manufacture [`InputFileLocation`](crate::model::InputFileLocation)
    pub fn builder() -> crate::model::input_file_location::Builder {
        crate::model::input_file_location::Builder::default()
    }
}

/// <p>Specifies the customer input S3 file location. If it is used inside <code>copyStepDetails.DestinationFileLocation</code>, it should be the S3 copy destination.</p>
/// <p> You need to provide the bucket and key. The key can represent either a path or a file. This is determined by whether or not you end the key value with the forward slash (/) character. If the final character is "/", then your file is copied to the folder, and its name does not change. If, rather, the final character is alphanumeric, your uploaded file is renamed to the path value. In this case, if a file with that name already exists, it is overwritten. </p>
/// <p>For example, if your path is <code>shared-files/bob/</code>, your uploaded files are copied to the <code>shared-files/bob/</code>, folder. If your path is <code>shared-files/today</code>, each uploaded file is copied to the <code>shared-files</code> folder and named <code>today</code>: each upload overwrites the previous version of the <i>bob</i> file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3InputFileLocation {
    /// <p>Specifies the S3 bucket for the customer input file.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
    pub key: std::option::Option<std::string::String>,
}
impl S3InputFileLocation {
    /// <p>Specifies the S3 bucket for the customer input file.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for S3InputFileLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3InputFileLocation");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`S3InputFileLocation`](crate::model::S3InputFileLocation)
pub mod s3_input_file_location {
    /// A builder for [`S3InputFileLocation`](crate::model::S3InputFileLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the S3 bucket for the customer input file.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the S3 bucket for the customer input file.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name assigned to the file when it was created in S3. You use the object key to retrieve the object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`S3InputFileLocation`](crate::model::S3InputFileLocation)
        pub fn build(self) -> crate::model::S3InputFileLocation {
            crate::model::S3InputFileLocation {
                bucket: self.bucket,
                key: self.key,
            }
        }
    }
}
impl S3InputFileLocation {
    /// Creates a new builder-style object to manufacture [`S3InputFileLocation`](crate::model::S3InputFileLocation)
    pub fn builder() -> crate::model::s3_input_file_location::Builder {
        crate::model::s3_input_file_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowStepType {
    #[allow(missing_docs)] // documentation missing in model
    Copy,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Tag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowStepType {
    fn from(s: &str) -> Self {
        match s {
            "COPY" => WorkflowStepType::Copy,
            "CUSTOM" => WorkflowStepType::Custom,
            "DELETE" => WorkflowStepType::Delete,
            "TAG" => WorkflowStepType::Tag,
            other => WorkflowStepType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowStepType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowStepType::from(s))
    }
}
impl WorkflowStepType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowStepType::Copy => "COPY",
            WorkflowStepType::Custom => "CUSTOM",
            WorkflowStepType::Delete => "DELETE",
            WorkflowStepType::Tag => "TAG",
            WorkflowStepType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COPY", "CUSTOM", "DELETE", "TAG"]
    }
}
impl AsRef<str> for WorkflowStepType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the properties of a user that was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribedUser {
    /// <p>Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
    /// <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>
    pub home_directory_mappings:
        std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.</p>
    pub ssh_public_keys: std::option::Option<std::vec::Vec<crate::model::SshPublicKey>>,
    /// <p>Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl DescribedUser {
    /// <p>Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
    /// <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>
    pub fn home_directory_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::HomeDirectoryMapEntry]> {
        self.home_directory_mappings.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.</p>
    pub fn ssh_public_keys(&self) -> std::option::Option<&[crate::model::SshPublicKey]> {
        self.ssh_public_keys.as_deref()
    }
    /// <p>Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for DescribedUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribedUser");
        formatter.field("arn", &self.arn);
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_mappings", &self.home_directory_mappings);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("policy", &self.policy);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("role", &self.role);
        formatter.field("ssh_public_keys", &self.ssh_public_keys);
        formatter.field("tags", &self.tags);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`DescribedUser`](crate::model::DescribedUser)
pub mod described_user {
    /// A builder for [`DescribedUser`](crate::model::DescribedUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_mappings:
            std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) ssh_public_keys: std::option::Option<std::vec::Vec<crate::model::SshPublicKey>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// Appends an item to `home_directory_mappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>
        pub fn home_directory_mappings(
            mut self,
            input: crate::model::HomeDirectoryMapEntry,
        ) -> Self {
            let mut v = self.home_directory_mappings.unwrap_or_default();
            v.push(input);
            self.home_directory_mappings = Some(v);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory parameter value.</p>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.home_directory_mappings = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// Appends an item to `ssh_public_keys`.
        ///
        /// To override the contents of this collection use [`set_ssh_public_keys`](Self::set_ssh_public_keys).
        ///
        /// <p>Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.</p>
        pub fn ssh_public_keys(mut self, input: crate::model::SshPublicKey) -> Self {
            let mut v = self.ssh_public_keys.unwrap_or_default();
            v.push(input);
            self.ssh_public_keys = Some(v);
            self
        }
        /// <p>Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.</p>
        pub fn set_ssh_public_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SshPublicKey>>,
        ) -> Self {
            self.ssh_public_keys = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribedUser`](crate::model::DescribedUser)
        pub fn build(self) -> crate::model::DescribedUser {
            crate::model::DescribedUser {
                arn: self.arn,
                home_directory: self.home_directory,
                home_directory_mappings: self.home_directory_mappings,
                home_directory_type: self.home_directory_type,
                policy: self.policy,
                posix_profile: self.posix_profile,
                role: self.role,
                ssh_public_keys: self.ssh_public_keys,
                tags: self.tags,
                user_name: self.user_name,
            }
        }
    }
}
impl DescribedUser {
    /// Creates a new builder-style object to manufacture [`DescribedUser`](crate::model::DescribedUser)
    pub fn builder() -> crate::model::described_user::Builder {
        crate::model::described_user::Builder::default()
    }
}

/// <p>Provides information about the public Secure Shell (SSH) key that is associated with a user account for the specific file transfer protocol-enabled server (as identified by <code>ServerId</code>). The information returned includes the date the key was imported, the public key contents, and the public key ID. A user can store more than one SSH public key associated with their user name on a specific server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SshPublicKey {
    /// <p>Specifies the date that the public key was added to the user account.</p>
    pub date_imported: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>
    pub ssh_public_key_body: std::option::Option<std::string::String>,
    /// <p>Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.</p>
    pub ssh_public_key_id: std::option::Option<std::string::String>,
}
impl SshPublicKey {
    /// <p>Specifies the date that the public key was added to the user account.</p>
    pub fn date_imported(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date_imported.as_ref()
    }
    /// <p>Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>
    pub fn ssh_public_key_body(&self) -> std::option::Option<&str> {
        self.ssh_public_key_body.as_deref()
    }
    /// <p>Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.</p>
    pub fn ssh_public_key_id(&self) -> std::option::Option<&str> {
        self.ssh_public_key_id.as_deref()
    }
}
impl std::fmt::Debug for SshPublicKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SshPublicKey");
        formatter.field("date_imported", &self.date_imported);
        formatter.field("ssh_public_key_body", &self.ssh_public_key_body);
        formatter.field("ssh_public_key_id", &self.ssh_public_key_id);
        formatter.finish()
    }
}
/// See [`SshPublicKey`](crate::model::SshPublicKey)
pub mod ssh_public_key {
    /// A builder for [`SshPublicKey`](crate::model::SshPublicKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date_imported: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ssh_public_key_body: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the date that the public key was added to the user account.</p>
        pub fn date_imported(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date_imported = Some(input);
            self
        }
        /// <p>Specifies the date that the public key was added to the user account.</p>
        pub fn set_date_imported(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.date_imported = input;
            self
        }
        /// <p>Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>
        pub fn ssh_public_key_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_body = Some(input.into());
            self
        }
        /// <p>Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>
        pub fn set_ssh_public_key_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_body = input;
            self
        }
        /// <p>Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SshPublicKey`](crate::model::SshPublicKey)
        pub fn build(self) -> crate::model::SshPublicKey {
            crate::model::SshPublicKey {
                date_imported: self.date_imported,
                ssh_public_key_body: self.ssh_public_key_body,
                ssh_public_key_id: self.ssh_public_key_id,
            }
        }
    }
}
impl SshPublicKey {
    /// Creates a new builder-style object to manufacture [`SshPublicKey`](crate::model::SshPublicKey)
    pub fn builder() -> crate::model::ssh_public_key::Builder {
        crate::model::ssh_public_key::Builder::default()
    }
}

/// <p>Describes the properties of a file transfer protocol-enabled server that was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribedServer {
    /// <p>Specifies the unique Amazon Resource Name (ARN) of the server.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p> The protocol settings that are configured for your server. </p>
    /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
    pub protocol_details: std::option::Option<crate::model::ProtocolDetails>,
    /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
    pub domain: std::option::Option<crate::model::Domain>,
    /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
    pub endpoint_details: std::option::Option<crate::model::EndpointDetails>,
    /// <p>Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
    pub endpoint_type: std::option::Option<crate::model::EndpointType>,
    /// <p>Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This value is equivalent to the output of the <code>ssh-keygen -l -f my-new-server-key</code> command.</p>
    pub host_key_fingerprint: std::option::Option<std::string::String>,
    /// <p>Specifies information to call a customer-supplied authentication API. This field is not populated when the <code>IdentityProviderType</code> of a server is <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code>.</p>
    pub identity_provider_details: std::option::Option<crate::model::IdentityProviderDetails>,
    /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
    /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    pub logging_role: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub post_authentication_login_banner: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub pre_authentication_login_banner: std::option::Option<std::string::String>,
    /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
    /// <ul>
    /// <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>
    /// <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>
    /// <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>
    /// </ul>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub security_policy_name: std::option::Option<std::string::String>,
    /// <p>Specifies the unique system-assigned identifier for a server that you instantiate.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
    /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
    pub user_count: std::option::Option<i32>,
    /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    pub workflow_details: std::option::Option<crate::model::WorkflowDetails>,
}
impl DescribedServer {
    /// <p>Specifies the unique Amazon Resource Name (ARN) of the server.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p> The protocol settings that are configured for your server. </p>
    /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
    pub fn protocol_details(&self) -> std::option::Option<&crate::model::ProtocolDetails> {
        self.protocol_details.as_ref()
    }
    /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
    /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
    pub fn endpoint_details(&self) -> std::option::Option<&crate::model::EndpointDetails> {
        self.endpoint_details.as_ref()
    }
    /// <p>Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::EndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This value is equivalent to the output of the <code>ssh-keygen -l -f my-new-server-key</code> command.</p>
    pub fn host_key_fingerprint(&self) -> std::option::Option<&str> {
        self.host_key_fingerprint.as_deref()
    }
    /// <p>Specifies information to call a customer-supplied authentication API. This field is not populated when the <code>IdentityProviderType</code> of a server is <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code>.</p>
    pub fn identity_provider_details(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderDetails> {
        self.identity_provider_details.as_ref()
    }
    /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
    /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    pub fn logging_role(&self) -> std::option::Option<&str> {
        self.logging_role.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn post_authentication_login_banner(&self) -> std::option::Option<&str> {
        self.post_authentication_login_banner.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn pre_authentication_login_banner(&self) -> std::option::Option<&str> {
        self.pre_authentication_login_banner.as_deref()
    }
    /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
    /// <ul>
    /// <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>
    /// <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>
    /// <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>
    /// </ul>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::Protocol]> {
        self.protocols.as_deref()
    }
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub fn security_policy_name(&self) -> std::option::Option<&str> {
        self.security_policy_name.as_deref()
    }
    /// <p>Specifies the unique system-assigned identifier for a server that you instantiate.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
    /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
    pub fn user_count(&self) -> std::option::Option<i32> {
        self.user_count
    }
    /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    pub fn workflow_details(&self) -> std::option::Option<&crate::model::WorkflowDetails> {
        self.workflow_details.as_ref()
    }
}
impl std::fmt::Debug for DescribedServer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribedServer");
        formatter.field("arn", &self.arn);
        formatter.field("certificate", &self.certificate);
        formatter.field("protocol_details", &self.protocol_details);
        formatter.field("domain", &self.domain);
        formatter.field("endpoint_details", &self.endpoint_details);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("host_key_fingerprint", &self.host_key_fingerprint);
        formatter.field("identity_provider_details", &self.identity_provider_details);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.field("logging_role", &self.logging_role);
        formatter.field(
            "post_authentication_login_banner",
            &self.post_authentication_login_banner,
        );
        formatter.field(
            "pre_authentication_login_banner",
            &self.pre_authentication_login_banner,
        );
        formatter.field("protocols", &self.protocols);
        formatter.field("security_policy_name", &self.security_policy_name);
        formatter.field("server_id", &self.server_id);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("user_count", &self.user_count);
        formatter.field("workflow_details", &self.workflow_details);
        formatter.finish()
    }
}
/// See [`DescribedServer`](crate::model::DescribedServer)
pub mod described_server {
    /// A builder for [`DescribedServer`](crate::model::DescribedServer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) protocol_details: std::option::Option<crate::model::ProtocolDetails>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
        pub(crate) endpoint_details: std::option::Option<crate::model::EndpointDetails>,
        pub(crate) endpoint_type: std::option::Option<crate::model::EndpointType>,
        pub(crate) host_key_fingerprint: std::option::Option<std::string::String>,
        pub(crate) identity_provider_details:
            std::option::Option<crate::model::IdentityProviderDetails>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
        pub(crate) logging_role: std::option::Option<std::string::String>,
        pub(crate) post_authentication_login_banner: std::option::Option<std::string::String>,
        pub(crate) pre_authentication_login_banner: std::option::Option<std::string::String>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        pub(crate) security_policy_name: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) user_count: std::option::Option<i32>,
        pub(crate) workflow_details: std::option::Option<crate::model::WorkflowDetails>,
    }
    impl Builder {
        /// <p>Specifies the unique Amazon Resource Name (ARN) of the server.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Specifies the unique Amazon Resource Name (ARN) of the server.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p> The protocol settings that are configured for your server. </p>
        /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
        pub fn protocol_details(mut self, input: crate::model::ProtocolDetails) -> Self {
            self.protocol_details = Some(input);
            self
        }
        /// <p> The protocol settings that are configured for your server. </p>
        /// <p> Use the <code>PassiveIp</code> parameter to indicate passive mode. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer. </p>
        pub fn set_protocol_details(
            mut self,
            input: std::option::Option<crate::model::ProtocolDetails>,
        ) -> Self {
            self.protocol_details = input;
            self
        }
        /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>Specifies the domain of the storage system that is used for file transfers.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
        pub fn endpoint_details(mut self, input: crate::model::EndpointDetails) -> Self {
            self.endpoint_details = Some(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<crate::model::EndpointDetails>,
        ) -> Self {
            self.endpoint_details = input;
            self
        }
        /// <p>Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This value is equivalent to the output of the <code>ssh-keygen -l -f my-new-server-key</code> command.</p>
        pub fn host_key_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_key_fingerprint = Some(input.into());
            self
        }
        /// <p>Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This value is equivalent to the output of the <code>ssh-keygen -l -f my-new-server-key</code> command.</p>
        pub fn set_host_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_key_fingerprint = input;
            self
        }
        /// <p>Specifies information to call a customer-supplied authentication API. This field is not populated when the <code>IdentityProviderType</code> of a server is <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code>.</p>
        pub fn identity_provider_details(
            mut self,
            input: crate::model::IdentityProviderDetails,
        ) -> Self {
            self.identity_provider_details = Some(input);
            self
        }
        /// <p>Specifies information to call a customer-supplied authentication API. This field is not populated when the <code>IdentityProviderType</code> of a server is <code>AWS_DIRECTORY_SERVICE</code> or <code>SERVICE_MANAGED</code>.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderDetails>,
        ) -> Self {
            self.identity_provider_details = input;
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>AWS_LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.logging_role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logging_role = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn post_authentication_login_banner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.post_authentication_login_banner = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_post_authentication_login_banner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.post_authentication_login_banner = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn pre_authentication_login_banner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pre_authentication_login_banner = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_pre_authentication_login_banner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_authentication_login_banner = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
        /// <ul>
        /// <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>
        /// <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>
        /// <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>
        /// </ul>
        pub fn protocols(mut self, input: crate::model::Protocol) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input);
            self.protocols = Some(v);
            self
        }
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:</p>
        /// <ul>
        /// <li> <p> <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH</p> </li>
        /// <li> <p> <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS encryption</p> </li>
        /// <li> <p> <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p> </li>
        /// </ul>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_policy_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_policy_name = input;
            self
        }
        /// <p>Specifies the unique system-assigned identifier for a server that you instantiate.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>Specifies the unique system-assigned identifier for a server that you instantiate.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
        /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Specifies the condition of a server for the server that was described. A value of <code>ONLINE</code> indicates that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
        /// <p>The states of <code>STARTING</code> and <code>STOPPING</code> indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
        pub fn user_count(mut self, input: i32) -> Self {
            self.user_count = Some(input);
            self
        }
        /// <p>Specifies the number of users that are assigned to a server you specified with the <code>ServerId</code>.</p>
        pub fn set_user_count(mut self, input: std::option::Option<i32>) -> Self {
            self.user_count = input;
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn workflow_details(mut self, input: crate::model::WorkflowDetails) -> Self {
            self.workflow_details = Some(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn set_workflow_details(
            mut self,
            input: std::option::Option<crate::model::WorkflowDetails>,
        ) -> Self {
            self.workflow_details = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribedServer`](crate::model::DescribedServer)
        pub fn build(self) -> crate::model::DescribedServer {
            crate::model::DescribedServer {
                arn: self.arn,
                certificate: self.certificate,
                protocol_details: self.protocol_details,
                domain: self.domain,
                endpoint_details: self.endpoint_details,
                endpoint_type: self.endpoint_type,
                host_key_fingerprint: self.host_key_fingerprint,
                identity_provider_details: self.identity_provider_details,
                identity_provider_type: self.identity_provider_type,
                logging_role: self.logging_role,
                post_authentication_login_banner: self.post_authentication_login_banner,
                pre_authentication_login_banner: self.pre_authentication_login_banner,
                protocols: self.protocols,
                security_policy_name: self.security_policy_name,
                server_id: self.server_id,
                state: self.state,
                tags: self.tags,
                user_count: self.user_count,
                workflow_details: self.workflow_details,
            }
        }
    }
}
impl DescribedServer {
    /// Creates a new builder-style object to manufacture [`DescribedServer`](crate::model::DescribedServer)
    pub fn builder() -> crate::model::described_server::Builder {
        crate::model::described_server::Builder::default()
    }
}

/// <p>Describes the properties of a security policy that was specified. For more information about security policies, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security policies</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribedSecurityPolicy {
    /// <p>Specifies whether this policy enables Federal Information Processing Standards (FIPS).</p>
    pub fips: std::option::Option<bool>,
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub security_policy_name: std::option::Option<std::string::String>,
    /// <p>Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.</p>
    pub ssh_ciphers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.</p>
    pub ssh_kexs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.</p>
    pub ssh_macs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.</p>
    pub tls_ciphers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribedSecurityPolicy {
    /// <p>Specifies whether this policy enables Federal Information Processing Standards (FIPS).</p>
    pub fn fips(&self) -> std::option::Option<bool> {
        self.fips
    }
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub fn security_policy_name(&self) -> std::option::Option<&str> {
        self.security_policy_name.as_deref()
    }
    /// <p>Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.</p>
    pub fn ssh_ciphers(&self) -> std::option::Option<&[std::string::String]> {
        self.ssh_ciphers.as_deref()
    }
    /// <p>Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.</p>
    pub fn ssh_kexs(&self) -> std::option::Option<&[std::string::String]> {
        self.ssh_kexs.as_deref()
    }
    /// <p>Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.</p>
    pub fn ssh_macs(&self) -> std::option::Option<&[std::string::String]> {
        self.ssh_macs.as_deref()
    }
    /// <p>Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.</p>
    pub fn tls_ciphers(&self) -> std::option::Option<&[std::string::String]> {
        self.tls_ciphers.as_deref()
    }
}
impl std::fmt::Debug for DescribedSecurityPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribedSecurityPolicy");
        formatter.field("fips", &self.fips);
        formatter.field("security_policy_name", &self.security_policy_name);
        formatter.field("ssh_ciphers", &self.ssh_ciphers);
        formatter.field("ssh_kexs", &self.ssh_kexs);
        formatter.field("ssh_macs", &self.ssh_macs);
        formatter.field("tls_ciphers", &self.tls_ciphers);
        formatter.finish()
    }
}
/// See [`DescribedSecurityPolicy`](crate::model::DescribedSecurityPolicy)
pub mod described_security_policy {
    /// A builder for [`DescribedSecurityPolicy`](crate::model::DescribedSecurityPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fips: std::option::Option<bool>,
        pub(crate) security_policy_name: std::option::Option<std::string::String>,
        pub(crate) ssh_ciphers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ssh_kexs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ssh_macs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tls_ciphers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies whether this policy enables Federal Information Processing Standards (FIPS).</p>
        pub fn fips(mut self, input: bool) -> Self {
            self.fips = Some(input);
            self
        }
        /// <p>Specifies whether this policy enables Federal Information Processing Standards (FIPS).</p>
        pub fn set_fips(mut self, input: std::option::Option<bool>) -> Self {
            self.fips = input;
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_policy_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_policy_name = input;
            self
        }
        /// Appends an item to `ssh_ciphers`.
        ///
        /// To override the contents of this collection use [`set_ssh_ciphers`](Self::set_ssh_ciphers).
        ///
        /// <p>Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.</p>
        pub fn ssh_ciphers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ssh_ciphers.unwrap_or_default();
            v.push(input.into());
            self.ssh_ciphers = Some(v);
            self
        }
        /// <p>Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.</p>
        pub fn set_ssh_ciphers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ssh_ciphers = input;
            self
        }
        /// Appends an item to `ssh_kexs`.
        ///
        /// To override the contents of this collection use [`set_ssh_kexs`](Self::set_ssh_kexs).
        ///
        /// <p>Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.</p>
        pub fn ssh_kexs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ssh_kexs.unwrap_or_default();
            v.push(input.into());
            self.ssh_kexs = Some(v);
            self
        }
        /// <p>Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.</p>
        pub fn set_ssh_kexs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ssh_kexs = input;
            self
        }
        /// Appends an item to `ssh_macs`.
        ///
        /// To override the contents of this collection use [`set_ssh_macs`](Self::set_ssh_macs).
        ///
        /// <p>Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.</p>
        pub fn ssh_macs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ssh_macs.unwrap_or_default();
            v.push(input.into());
            self.ssh_macs = Some(v);
            self
        }
        /// <p>Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.</p>
        pub fn set_ssh_macs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ssh_macs = input;
            self
        }
        /// Appends an item to `tls_ciphers`.
        ///
        /// To override the contents of this collection use [`set_tls_ciphers`](Self::set_tls_ciphers).
        ///
        /// <p>Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.</p>
        pub fn tls_ciphers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tls_ciphers.unwrap_or_default();
            v.push(input.into());
            self.tls_ciphers = Some(v);
            self
        }
        /// <p>Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.</p>
        pub fn set_tls_ciphers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tls_ciphers = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribedSecurityPolicy`](crate::model::DescribedSecurityPolicy)
        pub fn build(self) -> crate::model::DescribedSecurityPolicy {
            crate::model::DescribedSecurityPolicy {
                fips: self.fips,
                security_policy_name: self.security_policy_name,
                ssh_ciphers: self.ssh_ciphers,
                ssh_kexs: self.ssh_kexs,
                ssh_macs: self.ssh_macs,
                tls_ciphers: self.tls_ciphers,
            }
        }
    }
}
impl DescribedSecurityPolicy {
    /// Creates a new builder-style object to manufacture [`DescribedSecurityPolicy`](crate::model::DescribedSecurityPolicy)
    pub fn builder() -> crate::model::described_security_policy::Builder {
        crate::model::described_security_policy::Builder::default()
    }
}

/// <p>The details for an execution object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribedExecution {
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
    pub initial_file_location: std::option::Option<crate::model::FileLocation>,
    /// <p>A container object for the session details associated with a workflow.</p>
    pub service_metadata: std::option::Option<crate::model::ServiceMetadata>,
    /// <p>The IAM role associated with the execution.</p>
    pub execution_role: std::option::Option<std::string::String>,
    /// <p>The IAM logging role associated with the execution.</p>
    pub logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception. </p>
    pub status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.</p>
    pub results: std::option::Option<crate::model::ExecutionResults>,
}
impl DescribedExecution {
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
    pub fn initial_file_location(&self) -> std::option::Option<&crate::model::FileLocation> {
        self.initial_file_location.as_ref()
    }
    /// <p>A container object for the session details associated with a workflow.</p>
    pub fn service_metadata(&self) -> std::option::Option<&crate::model::ServiceMetadata> {
        self.service_metadata.as_ref()
    }
    /// <p>The IAM role associated with the execution.</p>
    pub fn execution_role(&self) -> std::option::Option<&str> {
        self.execution_role.as_deref()
    }
    /// <p>The IAM logging role associated with the execution.</p>
    pub fn logging_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LoggingConfiguration> {
        self.logging_configuration.as_ref()
    }
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.status.as_ref()
    }
    /// <p>A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.</p>
    pub fn results(&self) -> std::option::Option<&crate::model::ExecutionResults> {
        self.results.as_ref()
    }
}
impl std::fmt::Debug for DescribedExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribedExecution");
        formatter.field("execution_id", &self.execution_id);
        formatter.field("initial_file_location", &self.initial_file_location);
        formatter.field("service_metadata", &self.service_metadata);
        formatter.field("execution_role", &self.execution_role);
        formatter.field("logging_configuration", &self.logging_configuration);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("status", &self.status);
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`DescribedExecution`](crate::model::DescribedExecution)
pub mod described_execution {
    /// A builder for [`DescribedExecution`](crate::model::DescribedExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) initial_file_location: std::option::Option<crate::model::FileLocation>,
        pub(crate) service_metadata: std::option::Option<crate::model::ServiceMetadata>,
        pub(crate) execution_role: std::option::Option<std::string::String>,
        pub(crate) logging_configuration: std::option::Option<crate::model::LoggingConfiguration>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) results: std::option::Option<crate::model::ExecutionResults>,
    }
    impl Builder {
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
        pub fn initial_file_location(mut self, input: crate::model::FileLocation) -> Self {
            self.initial_file_location = Some(input);
            self
        }
        /// <p>A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.</p>
        pub fn set_initial_file_location(
            mut self,
            input: std::option::Option<crate::model::FileLocation>,
        ) -> Self {
            self.initial_file_location = input;
            self
        }
        /// <p>A container object for the session details associated with a workflow.</p>
        pub fn service_metadata(mut self, input: crate::model::ServiceMetadata) -> Self {
            self.service_metadata = Some(input);
            self
        }
        /// <p>A container object for the session details associated with a workflow.</p>
        pub fn set_service_metadata(
            mut self,
            input: std::option::Option<crate::model::ServiceMetadata>,
        ) -> Self {
            self.service_metadata = input;
            self
        }
        /// <p>The IAM role associated with the execution.</p>
        pub fn execution_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role = Some(input.into());
            self
        }
        /// <p>The IAM role associated with the execution.</p>
        pub fn set_execution_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role = input;
            self
        }
        /// <p>The IAM logging role associated with the execution.</p>
        pub fn logging_configuration(mut self, input: crate::model::LoggingConfiguration) -> Self {
            self.logging_configuration = Some(input);
            self
        }
        /// <p>The IAM logging role associated with the execution.</p>
        pub fn set_logging_configuration(
            mut self,
            input: std::option::Option<crate::model::LoggingConfiguration>,
        ) -> Self {
            self.logging_configuration = input;
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception. </p>
        pub fn status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.</p>
        pub fn results(mut self, input: crate::model::ExecutionResults) -> Self {
            self.results = Some(input);
            self
        }
        /// <p>A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<crate::model::ExecutionResults>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribedExecution`](crate::model::DescribedExecution)
        pub fn build(self) -> crate::model::DescribedExecution {
            crate::model::DescribedExecution {
                execution_id: self.execution_id,
                initial_file_location: self.initial_file_location,
                service_metadata: self.service_metadata,
                execution_role: self.execution_role,
                logging_configuration: self.logging_configuration,
                posix_profile: self.posix_profile,
                status: self.status,
                results: self.results,
            }
        }
    }
}
impl DescribedExecution {
    /// Creates a new builder-style object to manufacture [`DescribedExecution`](crate::model::DescribedExecution)
    pub fn builder() -> crate::model::described_execution::Builder {
        crate::model::described_execution::Builder::default()
    }
}

/// <p>Specifies the steps in the workflow, as well as the steps to execute in case of any errors during workflow execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionResults {
    /// <p>Specifies the details for the steps that are in the specified workflow.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::ExecutionStepResult>>,
    /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
    pub on_exception_steps: std::option::Option<std::vec::Vec<crate::model::ExecutionStepResult>>,
}
impl ExecutionResults {
    /// <p>Specifies the details for the steps that are in the specified workflow.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::ExecutionStepResult]> {
        self.steps.as_deref()
    }
    /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
    pub fn on_exception_steps(&self) -> std::option::Option<&[crate::model::ExecutionStepResult]> {
        self.on_exception_steps.as_deref()
    }
}
impl std::fmt::Debug for ExecutionResults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionResults");
        formatter.field("steps", &self.steps);
        formatter.field("on_exception_steps", &self.on_exception_steps);
        formatter.finish()
    }
}
/// See [`ExecutionResults`](crate::model::ExecutionResults)
pub mod execution_results {
    /// A builder for [`ExecutionResults`](crate::model::ExecutionResults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::ExecutionStepResult>>,
        pub(crate) on_exception_steps:
            std::option::Option<std::vec::Vec<crate::model::ExecutionStepResult>>,
    }
    impl Builder {
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        pub fn steps(mut self, input: crate::model::ExecutionStepResult) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionStepResult>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Appends an item to `on_exception_steps`.
        ///
        /// To override the contents of this collection use [`set_on_exception_steps`](Self::set_on_exception_steps).
        ///
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
        pub fn on_exception_steps(mut self, input: crate::model::ExecutionStepResult) -> Self {
            let mut v = self.on_exception_steps.unwrap_or_default();
            v.push(input);
            self.on_exception_steps = Some(v);
            self
        }
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
        pub fn set_on_exception_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionStepResult>>,
        ) -> Self {
            self.on_exception_steps = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionResults`](crate::model::ExecutionResults)
        pub fn build(self) -> crate::model::ExecutionResults {
            crate::model::ExecutionResults {
                steps: self.steps,
                on_exception_steps: self.on_exception_steps,
            }
        }
    }
}
impl ExecutionResults {
    /// Creates a new builder-style object to manufacture [`ExecutionResults`](crate::model::ExecutionResults)
    pub fn builder() -> crate::model::execution_results::Builder {
        crate::model::execution_results::Builder::default()
    }
}

/// <p>Specifies the following details for the step: error (if any), outputs (if any), and the step type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionStepResult {
    /// <p>One of the available step types.</p>
    /// <ul>
    /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
    /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
    /// <li> <p> <i>Delete</i>: delete the file</p> </li>
    /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
    /// </ul>
    pub step_type: std::option::Option<crate::model::WorkflowStepType>,
    /// <p>The values for the key/value pair applied as a tag to the file. Only applicable if the step type is <code>TAG</code>.</p>
    pub outputs: std::option::Option<std::string::String>,
    /// <p>Specifies the details for an error, if it occurred during execution of the specified workfow step.</p>
    pub error: std::option::Option<crate::model::ExecutionError>,
}
impl ExecutionStepResult {
    /// <p>One of the available step types.</p>
    /// <ul>
    /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
    /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
    /// <li> <p> <i>Delete</i>: delete the file</p> </li>
    /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
    /// </ul>
    pub fn step_type(&self) -> std::option::Option<&crate::model::WorkflowStepType> {
        self.step_type.as_ref()
    }
    /// <p>The values for the key/value pair applied as a tag to the file. Only applicable if the step type is <code>TAG</code>.</p>
    pub fn outputs(&self) -> std::option::Option<&str> {
        self.outputs.as_deref()
    }
    /// <p>Specifies the details for an error, if it occurred during execution of the specified workfow step.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ExecutionError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for ExecutionStepResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionStepResult");
        formatter.field("step_type", &self.step_type);
        formatter.field("outputs", &self.outputs);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`ExecutionStepResult`](crate::model::ExecutionStepResult)
pub mod execution_step_result {
    /// A builder for [`ExecutionStepResult`](crate::model::ExecutionStepResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) step_type: std::option::Option<crate::model::WorkflowStepType>,
        pub(crate) outputs: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::ExecutionError>,
    }
    impl Builder {
        /// <p>One of the available step types.</p>
        /// <ul>
        /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
        /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
        /// <li> <p> <i>Delete</i>: delete the file</p> </li>
        /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
        /// </ul>
        pub fn step_type(mut self, input: crate::model::WorkflowStepType) -> Self {
            self.step_type = Some(input);
            self
        }
        /// <p>One of the available step types.</p>
        /// <ul>
        /// <li> <p> <i>Copy</i>: copy the file to another location</p> </li>
        /// <li> <p> <i>Custom</i>: custom step with a lambda target</p> </li>
        /// <li> <p> <i>Delete</i>: delete the file</p> </li>
        /// <li> <p> <i>Tag</i>: add a tag to the file</p> </li>
        /// </ul>
        pub fn set_step_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowStepType>,
        ) -> Self {
            self.step_type = input;
            self
        }
        /// <p>The values for the key/value pair applied as a tag to the file. Only applicable if the step type is <code>TAG</code>.</p>
        pub fn outputs(mut self, input: impl Into<std::string::String>) -> Self {
            self.outputs = Some(input.into());
            self
        }
        /// <p>The values for the key/value pair applied as a tag to the file. Only applicable if the step type is <code>TAG</code>.</p>
        pub fn set_outputs(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outputs = input;
            self
        }
        /// <p>Specifies the details for an error, if it occurred during execution of the specified workfow step.</p>
        pub fn error(mut self, input: crate::model::ExecutionError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Specifies the details for an error, if it occurred during execution of the specified workfow step.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ExecutionError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionStepResult`](crate::model::ExecutionStepResult)
        pub fn build(self) -> crate::model::ExecutionStepResult {
            crate::model::ExecutionStepResult {
                step_type: self.step_type,
                outputs: self.outputs,
                error: self.error,
            }
        }
    }
}
impl ExecutionStepResult {
    /// Creates a new builder-style object to manufacture [`ExecutionStepResult`](crate::model::ExecutionStepResult)
    pub fn builder() -> crate::model::execution_step_result::Builder {
        crate::model::execution_step_result::Builder::default()
    }
}

/// <p>Specifies the error message and type, for an error that occurs during the execution of the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionError {
    /// <p>Specifies the error type: currently, the only valid value is <code>PERMISSION_DENIED</code>, which occurs if your policy does not contain the correct permissions to complete one or more of the steps in the workflow.</p>
    pub r#type: std::option::Option<crate::model::ExecutionErrorType>,
    /// <p>Specifies the descriptive message that corresponds to the <code>ErrorType</code>.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ExecutionError {
    /// <p>Specifies the error type: currently, the only valid value is <code>PERMISSION_DENIED</code>, which occurs if your policy does not contain the correct permissions to complete one or more of the steps in the workflow.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ExecutionErrorType> {
        self.r#type.as_ref()
    }
    /// <p>Specifies the descriptive message that corresponds to the <code>ErrorType</code>.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionError");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ExecutionError`](crate::model::ExecutionError)
pub mod execution_error {
    /// A builder for [`ExecutionError`](crate::model::ExecutionError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ExecutionErrorType>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the error type: currently, the only valid value is <code>PERMISSION_DENIED</code>, which occurs if your policy does not contain the correct permissions to complete one or more of the steps in the workflow.</p>
        pub fn r#type(mut self, input: crate::model::ExecutionErrorType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the error type: currently, the only valid value is <code>PERMISSION_DENIED</code>, which occurs if your policy does not contain the correct permissions to complete one or more of the steps in the workflow.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ExecutionErrorType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies the descriptive message that corresponds to the <code>ErrorType</code>.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Specifies the descriptive message that corresponds to the <code>ErrorType</code>.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionError`](crate::model::ExecutionError)
        pub fn build(self) -> crate::model::ExecutionError {
            crate::model::ExecutionError {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ExecutionError {
    /// Creates a new builder-style object to manufacture [`ExecutionError`](crate::model::ExecutionError)
    pub fn builder() -> crate::model::execution_error::Builder {
        crate::model::execution_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionErrorType {
    #[allow(missing_docs)] // documentation missing in model
    PermissionDenied,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionErrorType {
    fn from(s: &str) -> Self {
        match s {
            "PERMISSION_DENIED" => ExecutionErrorType::PermissionDenied,
            other => ExecutionErrorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionErrorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionErrorType::from(s))
    }
}
impl ExecutionErrorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionErrorType::PermissionDenied => "PERMISSION_DENIED",
            ExecutionErrorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PERMISSION_DENIED"]
    }
}
impl AsRef<str> for ExecutionErrorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Consists of the logging role and the log group name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfiguration {
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    pub logging_role: std::option::Option<std::string::String>,
    /// <p>The name of the CloudWatch logging group for the Amazon Web Services Transfer server to which this workflow belongs.</p>
    pub log_group_name: std::option::Option<std::string::String>,
}
impl LoggingConfiguration {
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
    pub fn logging_role(&self) -> std::option::Option<&str> {
        self.logging_role.as_deref()
    }
    /// <p>The name of the CloudWatch logging group for the Amazon Web Services Transfer server to which this workflow belongs.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
}
impl std::fmt::Debug for LoggingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfiguration");
        formatter.field("logging_role", &self.logging_role);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`LoggingConfiguration`](crate::model::LoggingConfiguration)
pub mod logging_configuration {
    /// A builder for [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_role: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.logging_role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logging_role = input;
            self
        }
        /// <p>The name of the CloudWatch logging group for the Amazon Web Services Transfer server to which this workflow belongs.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch logging group for the Amazon Web Services Transfer server to which this workflow belongs.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfiguration`](crate::model::LoggingConfiguration)
        pub fn build(self) -> crate::model::LoggingConfiguration {
            crate::model::LoggingConfiguration {
                logging_role: self.logging_role,
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl LoggingConfiguration {
    /// Creates a new builder-style object to manufacture [`LoggingConfiguration`](crate::model::LoggingConfiguration)
    pub fn builder() -> crate::model::logging_configuration::Builder {
        crate::model::logging_configuration::Builder::default()
    }
}

/// <p>Describes the properties of the access that was specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribedAccess {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
    /// <p>In most cases, you can use this value instead of the session policy to lock down the associated access to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
    pub home_directory_mappings:
        std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
    /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl DescribedAccess {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
    /// <p>In most cases, you can use this value instead of the session policy to lock down the associated access to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
    pub fn home_directory_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::HomeDirectoryMapEntry]> {
        self.home_directory_mappings.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
    /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for DescribedAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribedAccess");
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_mappings", &self.home_directory_mappings);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("policy", &self.policy);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("role", &self.role);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}
/// See [`DescribedAccess`](crate::model::DescribedAccess)
pub mod described_access {
    /// A builder for [`DescribedAccess`](crate::model::DescribedAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_mappings:
            std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// Appends an item to `home_directory_mappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down the associated access to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
        pub fn home_directory_mappings(
            mut self,
            input: crate::model::HomeDirectoryMapEntry,
        ) -> Self {
            let mut v = self.home_directory_mappings.unwrap_or_default();
            v.push(input);
            self.home_directory_mappings = Some(v);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in <code>Target</code>. This value can only be set when <code>HomeDirectoryType</code> is set to <i>LOGICAL</i>.</p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down the associated access to the designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set <code>Target</code> to the <code>HomeDirectory</code> parameter value.</p>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.home_directory_mappings = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>, <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.</p>
        /// <p> <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code> </p>
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribedAccess`](crate::model::DescribedAccess)
        pub fn build(self) -> crate::model::DescribedAccess {
            crate::model::DescribedAccess {
                home_directory: self.home_directory,
                home_directory_mappings: self.home_directory_mappings,
                home_directory_type: self.home_directory_type,
                policy: self.policy,
                posix_profile: self.posix_profile,
                role: self.role,
                external_id: self.external_id,
            }
        }
    }
}
impl DescribedAccess {
    /// Creates a new builder-style object to manufacture [`DescribedAccess`](crate::model::DescribedAccess)
    pub fn builder() -> crate::model::described_access::Builder {
        crate::model::described_access::Builder::default()
    }
}
