// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAccessInput`](crate::input::CreateAccessInput)
pub mod create_access_input {
    /// A builder for [`CreateAccessInput`](crate::input::CreateAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) home_directory_mappings:
            std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// Appends an item to `home_directory_mappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your
        /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
        /// <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn home_directory_mappings(
            mut self,
            input: impl Into<crate::model::HomeDirectoryMapEntry>,
        ) -> Self {
            let mut v = self.home_directory_mappings.unwrap_or_default();
            v.push(input.into());
            self.home_directory_mappings = Some(v);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your
        /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
        /// <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.home_directory_mappings = input;
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>      
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
        /// session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API
        /// Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>      
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
        /// session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API
        /// Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
        /// files and directories in your file system determine the level of access your users get when
        /// transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
        /// files and directories in your file system determine the level of access your users get when
        /// transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessInput`](crate::input::CreateAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessInput {
                home_directory: self.home_directory,
                home_directory_type: self.home_directory_type,
                home_directory_mappings: self.home_directory_mappings,
                policy: self.policy,
                posix_profile: self.posix_profile,
                role: self.role,
                server_id: self.server_id,
                external_id: self.external_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessInputOperationOutputAlias = crate::operation::CreateAccess;
#[doc(hidden)]
pub type CreateAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAccessInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccess`](crate::operation::CreateAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.CreateAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccess",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessInput`](crate::input::CreateAccessInput)
    pub fn builder() -> crate::input::create_access_input::Builder {
        crate::input::create_access_input::Builder::default()
    }
}

/// See [`CreateServerInput`](crate::input::CreateServerInput)
pub mod create_server_input {
    /// A builder for [`CreateServerInput`](crate::input::CreateServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<crate::model::Domain>,
        pub(crate) endpoint_details: std::option::Option<crate::model::EndpointDetails>,
        pub(crate) endpoint_type: std::option::Option<crate::model::EndpointType>,
        pub(crate) host_key: std::option::Option<std::string::String>,
        pub(crate) identity_provider_details:
            std::option::Option<crate::model::IdentityProviderDetails>,
        pub(crate) identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
        pub(crate) logging_role: std::option::Option<std::string::String>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        pub(crate) security_policy_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) workflow_details: std::option::Option<crate::model::WorkflowDetails>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required
        /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        ///
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
        /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        ///
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
        /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        ///
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
        /// private certificate</a> in the <i> Amazon Web Services Certificate Manager User
        /// Guide</i>.</p>
        ///
        /// <p>Certificates with the following cryptographic algorithms and key sizes are
        /// supported:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>2048-bit RSA (RSA_2048)</p>
        /// </li>
        /// <li>
        /// <p>4096-bit RSA (RSA_4096)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
        /// address specified and information about the issuer.</p>
        /// </note>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required
        /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        ///
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
        /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        ///
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
        /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
        ///
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
        /// private certificate</a> in the <i> Amazon Web Services Certificate Manager User
        /// Guide</i>.</p>
        ///
        /// <p>Certificates with the following cryptographic algorithms and key sizes are
        /// supported:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>2048-bit RSA (RSA_2048)</p>
        /// </li>
        /// <li>
        /// <p>4096-bit RSA (RSA_4096)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
        /// address specified and information about the issuer.</p>
        /// </note>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>The domain of the storage system that is used for file transfers. There are two domains
        /// available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The
        /// default value is S3.</p>
        ///
        /// <note>
        /// <p>After the server is created, the domain cannot be changed.</p>
        /// </note>
        pub fn domain(mut self, input: crate::model::Domain) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>The domain of the storage system that is used for file transfers. There are two domains
        /// available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The
        /// default value is S3.</p>
        ///
        /// <note>
        /// <p>After the server is created, the domain cannot be changed.</p>
        /// </note>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::Domain>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
        /// When you host your endpoint within your VPC, you can make it accessible only to resources
        /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
        /// the internet. Your VPC's default security groups are automatically assigned to your
        /// endpoint.</p>
        pub fn endpoint_details(mut self, input: crate::model::EndpointDetails) -> Self {
            self.endpoint_details = Some(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
        /// When you host your endpoint within your VPC, you can make it accessible only to resources
        /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
        /// the internet. Your VPC's default security groups are automatically assigned to your
        /// endpoint.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<crate::model::EndpointDetails>,
        ) -> Self {
            self.endpoint_details = input;
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
        /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
        /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
        /// <note>
        /// <p> After May 19, 2021, you won't be able to create a server using
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already
        /// done so before May 19, 2021. If you have already created servers with
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021,
        /// you will not be affected. After this date, use
        /// <code>EndpointType</code>=<code>VPC</code>.</p>
        ///
        /// <p>For more information, see
        /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
        /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
        /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
        /// restrict traffic by the client's public IP address. This is not possible with
        /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
        /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
        /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
        /// <note>
        /// <p> After May 19, 2021, you won't be able to create a server using
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already
        /// done so before May 19, 2021. If you have already created servers with
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021,
        /// you will not be affected. After this date, use
        /// <code>EndpointType</code>=<code>VPC</code>.</p>
        ///
        /// <p>For more information, see
        /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
        /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
        /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
        /// restrict traffic by the client's public IP address. This is not possible with
        /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f
        /// my-new-server-key</code> command.</p>
        ///
        /// <important>
        /// <p>If you aren't planning to migrate existing users from an existing SFTP-enabled
        /// server to a new server, don't update the host key. Accidentally changing a
        /// server's host key can be disruptive.</p>
        /// </important>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer
        /// Family User Guide</i>.</p>
        pub fn host_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_key = Some(input.into());
            self
        }
        /// <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f
        /// my-new-server-key</code> command.</p>
        ///
        /// <important>
        /// <p>If you aren't planning to migrate existing users from an existing SFTP-enabled
        /// server to a new server, don't update the host key. Accidentally changing a
        /// server's host key can be disruptive.</p>
        /// </important>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer
        /// Family User Guide</i>.</p>
        pub fn set_host_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_key = input;
            self
        }
        /// <p>Required when <code>IdentityProviderType</code> is set to
        /// <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing
        /// all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or
        /// invoke a customer-supplied authentication API, including the API Gateway URL. Not required
        /// when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
        pub fn identity_provider_details(
            mut self,
            input: crate::model::IdentityProviderDetails,
        ) -> Self {
            self.identity_provider_details = Some(input);
            self
        }
        /// <p>Required when <code>IdentityProviderType</code> is set to
        /// <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing
        /// all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or
        /// invoke a customer-supplied authentication API, including the API Gateway URL. Not required
        /// when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderDetails>,
        ) -> Self {
            self.identity_provider_details = input;
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is
        /// <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within
        /// the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to
        /// Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your
        /// on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to
        /// provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
        /// <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call
        /// for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value,
        /// you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn identity_provider_type(mut self, input: crate::model::IdentityProviderType) -> Self {
            self.identity_provider_type = Some(input);
            self
        }
        /// <p>Specifies the mode of authentication for a server. The default value is
        /// <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within
        /// the Amazon Web Services Transfer Family service.</p>
        /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to
        /// Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your
        /// on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to
        /// provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
        /// <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call
        /// for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
        /// <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value,
        /// you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
        pub fn set_identity_provider_type(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderType>,
        ) -> Self {
            self.identity_provider_type = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
        /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
        /// your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.logging_role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
        /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
        /// your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logging_role = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
        /// client can connect to your server's endpoint. The available protocols are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over
        /// SSH</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS
        /// encryption</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate
        /// Manager (ACM) which is used to identify your server when clients connect to it over
        /// FTPS.</p>
        ///
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
        /// <code>EndpointType</code> must be <code>VPC</code> and the
        /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        ///
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
        /// <code>AddressAllocationIds</code> cannot be associated.</p>
        ///
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
        /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
        /// <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn protocols(mut self, input: impl Into<crate::model::Protocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
        /// client can connect to your server's endpoint. The available protocols are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over
        /// SSH</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS
        /// encryption</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate
        /// Manager (ACM) which is used to identify your server when clients connect to it over
        /// FTPS.</p>
        ///
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
        /// <code>EndpointType</code> must be <code>VPC</code> and the
        /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        ///
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
        /// <code>AddressAllocationIds</code> cannot be associated.</p>
        ///
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
        /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
        /// <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_policy_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_policy_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for servers.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for servers.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn workflow_details(mut self, input: crate::model::WorkflowDetails) -> Self {
            self.workflow_details = Some(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn set_workflow_details(
            mut self,
            input: std::option::Option<crate::model::WorkflowDetails>,
        ) -> Self {
            self.workflow_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServerInput`](crate::input::CreateServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServerInput {
                certificate: self.certificate,
                domain: self.domain,
                endpoint_details: self.endpoint_details,
                endpoint_type: self.endpoint_type,
                host_key: self.host_key,
                identity_provider_details: self.identity_provider_details,
                identity_provider_type: self.identity_provider_type,
                logging_role: self.logging_role,
                protocols: self.protocols,
                security_policy_name: self.security_policy_name,
                tags: self.tags,
                workflow_details: self.workflow_details,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServerInputOperationOutputAlias = crate::operation::CreateServer;
#[doc(hidden)]
pub type CreateServerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServerInput {
    /// Consumes the builder and constructs an Operation<[`CreateServer`](crate::operation::CreateServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.CreateServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServer",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServerInput`](crate::input::CreateServerInput)
    pub fn builder() -> crate::input::create_server_input::Builder {
        crate::input::create_server_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) home_directory_mappings:
            std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_body: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// Appends an item to `home_directory_mappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        ///
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        ///
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target":
        /// "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <p>In most cases, you can use this value instead of the session policy to lock your user
        /// down to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory
        /// parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn home_directory_mappings(
            mut self,
            input: impl Into<crate::model::HomeDirectoryMapEntry>,
        ) -> Self {
            let mut v = self.home_directory_mappings.unwrap_or_default();
            v.push(input.into());
            self.home_directory_mappings = Some(v);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        ///
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        ///
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target":
        /// "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <p>In most cases, you can use this value instead of the session policy to lock your user
        /// down to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory
        /// parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.home_directory_mappings = input;
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>
        ///
        ///
        ///
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session
        /// policy</a>.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
        /// Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>
        ///
        ///
        ///
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session
        /// policy</a>.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
        /// Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
        /// files and directories in Amazon EFS determine the level of access your users get when
        /// transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
        /// files and directories in Amazon EFS determine the level of access your users get when
        /// transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server
        /// that you added your user to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server
        /// that you added your user to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the
        /// server.</p>
        pub fn ssh_public_key_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_body = Some(input.into());
            self
        }
        /// <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the
        /// server.</p>
        pub fn set_ssh_public_key_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_body = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached
        /// to users for any purpose.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached
        /// to users for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
        /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
        /// '-', period '.', and at sign '@'. The user name can't start
        /// with a hyphen, period, or at sign.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
        /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
        /// '-', period '.', and at sign '@'. The user name can't start
        /// with a hyphen, period, or at sign.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                home_directory: self.home_directory,
                home_directory_type: self.home_directory_type,
                home_directory_mappings: self.home_directory_mappings,
                policy: self.policy,
                posix_profile: self.posix_profile,
                role: self.role,
                server_id: self.server_id,
                ssh_public_key_body: self.ssh_public_key_body,
                tags: self.tags,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.CreateUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`CreateWorkflowInput`](crate::input::CreateWorkflowInput)
pub mod create_workflow_input {
    /// A builder for [`CreateWorkflowInput`](crate::input::CreateWorkflowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        pub(crate) on_exception_steps:
            std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A textual description for the workflow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A textual description for the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        /// <p>
        /// The <code>TYPE</code> specifies which of the following actions is being taken for this step.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>Copy</i>: copy the file to another location</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Custom</i>: custom step with a lambda target</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Delete</i>: delete the file</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Tag</i>: add a tag to the file</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>
        /// Currently, copying and tagging are supported only on S3.
        /// </p>
        /// </note>
        /// <p>
        /// For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
        /// </p>
        pub fn steps(mut self, input: impl Into<crate::model::WorkflowStep>) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input.into());
            self.steps = Some(v);
            self
        }
        /// <p>Specifies the details for the steps that are in the specified workflow.</p>
        /// <p>
        /// The <code>TYPE</code> specifies which of the following actions is being taken for this step.
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>Copy</i>: copy the file to another location</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Custom</i>: custom step with a lambda target</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Delete</i>: delete the file</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Tag</i>: add a tag to the file</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>
        /// Currently, copying and tagging are supported only on S3.
        /// </p>
        /// </note>
        /// <p>
        /// For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
        /// </p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Appends an item to `on_exception_steps`.
        ///
        /// To override the contents of this collection use [`set_on_exception_steps`](Self::set_on_exception_steps).
        ///
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
        /// <note>
        /// <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call
        /// back API to kick off the exception steps. Additionally, if the lambda does not send
        /// <code>SUCCESS</code> before it times out, the exception steps are executed.</p>
        /// </note>
        pub fn on_exception_steps(mut self, input: impl Into<crate::model::WorkflowStep>) -> Self {
            let mut v = self.on_exception_steps.unwrap_or_default();
            v.push(input.into());
            self.on_exception_steps = Some(v);
            self
        }
        /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
        /// <note>
        /// <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call
        /// back API to kick off the exception steps. Additionally, if the lambda does not send
        /// <code>SUCCESS</code> before it times out, the exception steps are executed.</p>
        /// </note>
        pub fn set_on_exception_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
        ) -> Self {
            self.on_exception_steps = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached
        /// to workflows for any purpose.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached
        /// to workflows for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkflowInput`](crate::input::CreateWorkflowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkflowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkflowInput {
                description: self.description,
                steps: self.steps,
                on_exception_steps: self.on_exception_steps,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkflowInputOperationOutputAlias = crate::operation::CreateWorkflow;
#[doc(hidden)]
pub type CreateWorkflowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkflowInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkflow`](crate::operation::CreateWorkflow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkflow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkflowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkflowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkflowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.CreateWorkflow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workflow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkflow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkflow",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkflowInput`](crate::input::CreateWorkflowInput)
    pub fn builder() -> crate::input::create_workflow_input::Builder {
        crate::input::create_workflow_input::Builder::default()
    }
}

/// See [`DeleteAccessInput`](crate::input::DeleteAccessInput)
pub mod delete_access_input {
    /// A builder for [`DeleteAccessInput`](crate::input::DeleteAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessInput`](crate::input::DeleteAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessInput {
                server_id: self.server_id,
                external_id: self.external_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessInputOperationOutputAlias = crate::operation::DeleteAccess;
#[doc(hidden)]
pub type DeleteAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccessInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccess`](crate::operation::DeleteAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DeleteAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccess",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessInput`](crate::input::DeleteAccessInput)
    pub fn builder() -> crate::input::delete_access_input::Builder {
        crate::input::delete_access_input::Builder::default()
    }
}

/// See [`DeleteServerInput`](crate::input::DeleteServerInput)
pub mod delete_server_input {
    /// A builder for [`DeleteServerInput`](crate::input::DeleteServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique system-assigned identifier for a server instance.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A unique system-assigned identifier for a server instance.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServerInput`](crate::input::DeleteServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServerInput {
                server_id: self.server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServerInputOperationOutputAlias = crate::operation::DeleteServer;
#[doc(hidden)]
pub type DeleteServerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServer`](crate::operation::DeleteServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DeleteServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServer",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServerInput`](crate::input::DeleteServerInput)
    pub fn builder() -> crate::input::delete_server_input::Builder {
        crate::input::delete_server_input::Builder::default()
    }
}

/// See [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
pub mod delete_ssh_public_key_input {
    /// A builder for [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance
        /// that has the user assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance
        /// that has the user assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique identifier used to reference your user's specific SSH key.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>A unique identifier used to reference your user's specific SSH key.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// <p>A unique string that identifies a user whose public key is being deleted.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A unique string that identifies a user whose public key is being deleted.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSshPublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSshPublicKeyInput {
                server_id: self.server_id,
                ssh_public_key_id: self.ssh_public_key_id,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSshPublicKeyInputOperationOutputAlias = crate::operation::DeleteSshPublicKey;
#[doc(hidden)]
pub type DeleteSshPublicKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSshPublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSshPublicKey`](crate::operation::DeleteSshPublicKey)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSshPublicKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSshPublicKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSshPublicKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSshPublicKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DeleteSshPublicKey",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_ssh_public_key(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSshPublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSshPublicKey",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
    pub fn builder() -> crate::input::delete_ssh_public_key_input::Builder {
        crate::input::delete_ssh_public_key_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server instance that has the user assigned to
        /// it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that has the user assigned to
        /// it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique string that identifies a user that is being deleted from a server.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A unique string that identifies a user that is being deleted from a server.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                server_id: self.server_id,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DeleteUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
pub mod delete_workflow_input {
    /// A builder for [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkflowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkflowInput {
                workflow_id: self.workflow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkflowInputOperationOutputAlias = crate::operation::DeleteWorkflow;
#[doc(hidden)]
pub type DeleteWorkflowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkflowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkflow`](crate::operation::DeleteWorkflow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkflow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkflowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkflowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkflowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DeleteWorkflow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_workflow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkflow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkflow",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
    pub fn builder() -> crate::input::delete_workflow_input::Builder {
        crate::input::delete_workflow_input::Builder::default()
    }
}

/// See [`DescribeAccessInput`](crate::input::DescribeAccessInput)
pub mod describe_access_input {
    /// A builder for [`DescribeAccessInput`](crate::input::DescribeAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccessInput`](crate::input::DescribeAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccessInput {
                server_id: self.server_id,
                external_id: self.external_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccessInputOperationOutputAlias = crate::operation::DescribeAccess;
#[doc(hidden)]
pub type DescribeAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccessInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccess`](crate::operation::DescribeAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DescribeAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccess",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccessInput`](crate::input::DescribeAccessInput)
    pub fn builder() -> crate::input::describe_access_input::Builder {
        crate::input::describe_access_input::Builder::default()
    }
}

/// See [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
pub mod describe_execution_input {
    /// A builder for [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExecutionInput {
                execution_id: self.execution_id,
                workflow_id: self.workflow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExecutionInputOperationOutputAlias = crate::operation::DescribeExecution;
#[doc(hidden)]
pub type DescribeExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeExecutionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExecution`](crate::operation::DescribeExecution)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DescribeExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeExecution",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeExecutionInput`](crate::input::DescribeExecutionInput)
    pub fn builder() -> crate::input::describe_execution_input::Builder {
        crate::input::describe_execution_input::Builder::default()
    }
}

/// See [`DescribeSecurityPolicyInput`](crate::input::DescribeSecurityPolicyInput)
pub mod describe_security_policy_input {
    /// A builder for [`DescribeSecurityPolicyInput`](crate::input::DescribeSecurityPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_policy_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecurityPolicyInput`](crate::input::DescribeSecurityPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSecurityPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSecurityPolicyInput {
                security_policy_name: self.security_policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSecurityPolicyInputOperationOutputAlias = crate::operation::DescribeSecurityPolicy;
#[doc(hidden)]
pub type DescribeSecurityPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSecurityPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSecurityPolicy`](crate::operation::DescribeSecurityPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSecurityPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSecurityPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSecurityPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSecurityPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DescribeSecurityPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_security_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSecurityPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSecurityPolicy",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSecurityPolicyInput`](crate::input::DescribeSecurityPolicyInput)
    pub fn builder() -> crate::input::describe_security_policy_input::Builder {
        crate::input::describe_security_policy_input::Builder::default()
    }
}

/// See [`DescribeServerInput`](crate::input::DescribeServerInput)
pub mod describe_server_input {
    /// A builder for [`DescribeServerInput`](crate::input::DescribeServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServerInput`](crate::input::DescribeServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServerInput {
                server_id: self.server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServerInputOperationOutputAlias = crate::operation::DescribeServer;
#[doc(hidden)]
pub type DescribeServerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeServerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServer`](crate::operation::DescribeServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DescribeServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServer",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServerInput`](crate::input::DescribeServerInput)
    pub fn builder() -> crate::input::describe_server_input::Builder {
        crate::input::describe_server_input::Builder::default()
    }
}

/// See [`DescribeUserInput`](crate::input::DescribeUserInput)
pub mod describe_user_input {
    /// A builder for [`DescribeUserInput`](crate::input::DescribeUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The name of the user assigned to one or more servers. User names are part of the sign-in
        /// credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user assigned to one or more servers. User names are part of the sign-in
        /// credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserInput`](crate::input::DescribeUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserInput {
                server_id: self.server_id,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserInputOperationOutputAlias = crate::operation::DescribeUser;
#[doc(hidden)]
pub type DescribeUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUser`](crate::operation::DescribeUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DescribeUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUser",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
}

/// See [`DescribeWorkflowInput`](crate::input::DescribeWorkflowInput)
pub mod describe_workflow_input {
    /// A builder for [`DescribeWorkflowInput`](crate::input::DescribeWorkflowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkflowInput`](crate::input::DescribeWorkflowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkflowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkflowInput {
                workflow_id: self.workflow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkflowInputOperationOutputAlias = crate::operation::DescribeWorkflow;
#[doc(hidden)]
pub type DescribeWorkflowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkflowInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkflow`](crate::operation::DescribeWorkflow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkflow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkflowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkflowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkflowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.DescribeWorkflow",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_workflow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkflow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkflow",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowInput`](crate::input::DescribeWorkflowInput)
    pub fn builder() -> crate::input::describe_workflow_input::Builder {
        crate::input::describe_workflow_input::Builder::default()
    }
}

/// See [`ImportSshPublicKeyInput`](crate::input::ImportSshPublicKeyInput)
pub mod import_ssh_public_key_input {
    /// A builder for [`ImportSshPublicKeyInput`](crate::input::ImportSshPublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_body: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The public key portion of an SSH key pair.</p>
        pub fn ssh_public_key_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_body = Some(input.into());
            self
        }
        /// <p>The public key portion of an SSH key pair.</p>
        pub fn set_ssh_public_key_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_body = input;
            self
        }
        /// <p>The name of the user account that is assigned to one or more servers.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user account that is assigned to one or more servers.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportSshPublicKeyInput`](crate::input::ImportSshPublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportSshPublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportSshPublicKeyInput {
                server_id: self.server_id,
                ssh_public_key_body: self.ssh_public_key_body,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportSshPublicKeyInputOperationOutputAlias = crate::operation::ImportSshPublicKey;
#[doc(hidden)]
pub type ImportSshPublicKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportSshPublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`ImportSshPublicKey`](crate::operation::ImportSshPublicKey)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportSshPublicKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportSshPublicKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportSshPublicKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportSshPublicKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ImportSshPublicKey",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_ssh_public_key(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportSshPublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportSshPublicKey",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportSshPublicKeyInput`](crate::input::ImportSshPublicKeyInput)
    pub fn builder() -> crate::input::import_ssh_public_key_input::Builder {
        crate::input::import_ssh_public_key_input::Builder::default()
    }
}

/// See [`ListAccessesInput`](crate::input::ListAccessesInput)
pub mod list_accesses_input {
    /// A builder for [`ListAccessesInput`](crate::input::ListAccessesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the maximum number of access SIDs to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of access SIDs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// accesses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// accesses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessesInput`](crate::input::ListAccessesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessesInput {
                max_results: self.max_results,
                next_token: self.next_token,
                server_id: self.server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessesInputOperationOutputAlias = crate::operation::ListAccesses;
#[doc(hidden)]
pub type ListAccessesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccessesInput {
    /// Consumes the builder and constructs an Operation<[`ListAccesses`](crate::operation::ListAccesses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccesses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListAccesses",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_accesses(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccesses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccesses",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessesInput`](crate::input::ListAccessesInput)
    pub fn builder() -> crate::input::list_accesses_input::Builder {
        crate::input::list_accesses_input::Builder::default()
    }
}

/// See [`ListExecutionsInput`](crate::input::ListExecutionsInput)
pub mod list_executions_input {
    /// A builder for [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the aximum number of executions to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the aximum number of executions to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional executions.</p>
        /// <p>
        /// This is useful for pagination, for instance.
        /// If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>:
        /// </p>
        /// <p>
        /// <code>aws transfer list-executions --max-results 10</code>
        /// </p>
        /// <p>
        /// This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution.
        /// You can now call the API again, suppling the <code>NextToken</code> value you received:
        /// </p>
        /// <p>
        /// <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
        /// </p>
        /// <p>
        /// This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details
        /// for all 100 executions have been returned.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional executions.</p>
        /// <p>
        /// This is useful for pagination, for instance.
        /// If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>:
        /// </p>
        /// <p>
        /// <code>aws transfer list-executions --max-results 10</code>
        /// </p>
        /// <p>
        /// This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution.
        /// You can now call the API again, suppling the <code>NextToken</code> value you received:
        /// </p>
        /// <p>
        /// <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
        /// </p>
        /// <p>
        /// This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details
        /// for all 100 executions have been returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExecutionsInput`](crate::input::ListExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExecutionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                workflow_id: self.workflow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExecutionsInputOperationOutputAlias = crate::operation::ListExecutions;
#[doc(hidden)]
pub type ListExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListExecutions`](crate::operation::ListExecutions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_executions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExecutions",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExecutionsInput`](crate::input::ListExecutionsInput)
    pub fn builder() -> crate::input::list_executions_input::Builder {
        crate::input::list_executions_input::Builder::default()
    }
}

/// See [`ListSecurityPoliciesInput`](crate::input::ListSecurityPoliciesInput)
pub mod list_security_policies_input {
    /// A builder for [`ListSecurityPoliciesInput`](crate::input::ListSecurityPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the number of security policies to return as a response to the
        /// <code>ListSecurityPolicies</code> query.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the number of security policies to return as a response to the
        /// <code>ListSecurityPolicies</code> query.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass the
        /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
        /// security policies.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass the
        /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
        /// security policies.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityPoliciesInput`](crate::input::ListSecurityPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSecurityPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSecurityPoliciesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSecurityPoliciesInputOperationOutputAlias = crate::operation::ListSecurityPolicies;
#[doc(hidden)]
pub type ListSecurityPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSecurityPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListSecurityPolicies`](crate::operation::ListSecurityPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSecurityPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSecurityPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSecurityPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSecurityPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListSecurityPolicies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_security_policies(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSecurityPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSecurityPolicies",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSecurityPoliciesInput`](crate::input::ListSecurityPoliciesInput)
    pub fn builder() -> crate::input::list_security_policies_input::Builder {
        crate::input::list_security_policies_input::Builder::default()
    }
}

/// See [`ListServersInput`](crate::input::ListServersInput)
pub mod list_servers_input {
    /// A builder for [`ListServersInput`](crate::input::ListServersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the number of servers to return as a response to the <code>ListServers</code>
        /// query.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the number of servers to return as a response to the <code>ListServers</code>
        /// query.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>When additional results are obtained from the <code>ListServers</code> command, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass the
        /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
        /// servers.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When additional results are obtained from the <code>ListServers</code> command, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass the
        /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
        /// servers.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServersInput`](crate::input::ListServersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServersInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServersInputOperationOutputAlias = crate::operation::ListServers;
#[doc(hidden)]
pub type ListServersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServersInput {
    /// Consumes the builder and constructs an Operation<[`ListServers`](crate::operation::ListServers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListServers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_servers(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServers",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServersInput`](crate::input::ListServersInput)
    pub fn builder() -> crate::input::list_servers_input::Builder {
        crate::input::list_servers_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an
        /// identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an
        /// identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the number of tags to return as a response to the
        /// <code>ListTagsForResource</code> request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the number of tags to return as a response to the
        /// <code>ListTagsForResource</code> request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>When you request additional results from the <code>ListTagsForResource</code> operation, a
        /// <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent
        /// command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you request additional results from the <code>ListTagsForResource</code> operation, a
        /// <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent
        /// command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                arn: self.arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the number of users to return as a response to the <code>ListUsers</code>
        /// request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the number of users to return as a response to the <code>ListUsers</code>
        /// request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>When you can get additional results from the <code>ListUsers</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// users.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListUsers</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// users.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                max_results: self.max_results,
                next_token: self.next_token,
                server_id: self.server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListUsers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_users(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "transfer",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
pub mod list_workflows_input {
    /// A builder for [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the maximum number of workflows to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of workflows to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional workflows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional workflows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkflowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkflowsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkflowsInputOperationOutputAlias = crate::operation::ListWorkflows;
#[doc(hidden)]
pub type ListWorkflowsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkflowsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkflows`](crate::operation::ListWorkflows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkflows,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkflowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkflowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkflowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.ListWorkflows",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_workflows(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkflows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkflows",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
    pub fn builder() -> crate::input::list_workflows_input::Builder {
        crate::input::list_workflows_input::Builder::default()
    }
}

/// See [`SendWorkflowStepStateInput`](crate::input::SendWorkflowStepStateInput)
pub mod send_workflow_step_state_input {
    /// A builder for [`SendWorkflowStepStateInput`](crate::input::SendWorkflowStepStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CustomStepStatus>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the execution of a workflow.</p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>Indicates whether the specified step succeeded or failed.</p>
        pub fn status(mut self, input: crate::model::CustomStepStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates whether the specified step succeeded or failed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CustomStepStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SendWorkflowStepStateInput`](crate::input::SendWorkflowStepStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SendWorkflowStepStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SendWorkflowStepStateInput {
                workflow_id: self.workflow_id,
                execution_id: self.execution_id,
                token: self.token,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type SendWorkflowStepStateInputOperationOutputAlias = crate::operation::SendWorkflowStepState;
#[doc(hidden)]
pub type SendWorkflowStepStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SendWorkflowStepStateInput {
    /// Consumes the builder and constructs an Operation<[`SendWorkflowStepState`](crate::operation::SendWorkflowStepState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SendWorkflowStepState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SendWorkflowStepStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SendWorkflowStepStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SendWorkflowStepStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.SendWorkflowStepState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_send_workflow_step_state(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SendWorkflowStepState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SendWorkflowStepState",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SendWorkflowStepStateInput`](crate::input::SendWorkflowStepStateInput)
    pub fn builder() -> crate::input::send_workflow_step_state_input::Builder {
        crate::input::send_workflow_step_state_input::Builder::default()
    }
}

/// See [`StartServerInput`](crate::input::StartServerInput)
pub mod start_server_input {
    /// A builder for [`StartServerInput`](crate::input::StartServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that you start.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that you start.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartServerInput`](crate::input::StartServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartServerInput {
                server_id: self.server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartServerInputOperationOutputAlias = crate::operation::StartServer;
#[doc(hidden)]
pub type StartServerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartServerInput {
    /// Consumes the builder and constructs an Operation<[`StartServer`](crate::operation::StartServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.StartServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartServer",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartServerInput`](crate::input::StartServerInput)
    pub fn builder() -> crate::input::start_server_input::Builder {
        crate::input::start_server_input::Builder::default()
    }
}

/// See [`StopServerInput`](crate::input::StopServerInput)
pub mod stop_server_input {
    /// A builder for [`StopServerInput`](crate::input::StopServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that you stopped.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that you stopped.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopServerInput`](crate::input::StopServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopServerInput {
                server_id: self.server_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopServerInputOperationOutputAlias = crate::operation::StopServer;
#[doc(hidden)]
pub type StopServerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopServerInput {
    /// Consumes the builder and constructs an Operation<[`StopServer`](crate::operation::StopServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.StopServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopServer",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopServerInput`](crate::input::StopServerInput)
    pub fn builder() -> crate::input::stop_server_input::Builder {
        crate::input::stop_server_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or
        /// role.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or
        /// role.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by
        /// type. You can attach this metadata to user accounts for any purpose.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by
        /// type. You can attach this metadata to user accounts for any purpose.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                arn: self.arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestIdentityProviderInput`](crate::input::TestIdentityProviderInput)
pub mod test_identity_provider_input {
    /// A builder for [`TestIdentityProviderInput`](crate::input::TestIdentityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) server_protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) source_ip: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) user_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned identifier for a specific server. That server's user authentication
        /// method is tested with a user name and password.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned identifier for a specific server. That server's user authentication
        /// method is tested with a user name and password.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The type of file transfer protocol to be tested.</p>
        ///
        /// <p>The available protocols are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol Secure (FTPS)</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol (FTP)</p>
        /// </li>
        /// </ul>
        pub fn server_protocol(mut self, input: crate::model::Protocol) -> Self {
            self.server_protocol = Some(input);
            self
        }
        /// <p>The type of file transfer protocol to be tested.</p>
        ///
        /// <p>The available protocols are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol Secure (FTPS)</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol (FTP)</p>
        /// </li>
        /// </ul>
        pub fn set_server_protocol(
            mut self,
            input: std::option::Option<crate::model::Protocol>,
        ) -> Self {
            self.server_protocol = input;
            self
        }
        /// <p>The source IP address of the user account to be tested.</p>
        pub fn source_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_ip = Some(input.into());
            self
        }
        /// <p>The source IP address of the user account to be tested.</p>
        pub fn set_source_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_ip = input;
            self
        }
        /// <p>The name of the user account to be tested.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user account to be tested.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The password of the user account to be tested.</p>
        pub fn user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_password = Some(input.into());
            self
        }
        /// <p>The password of the user account to be tested.</p>
        pub fn set_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_password = input;
            self
        }
        /// Consumes the builder and constructs a [`TestIdentityProviderInput`](crate::input::TestIdentityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestIdentityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestIdentityProviderInput {
                server_id: self.server_id,
                server_protocol: self.server_protocol,
                source_ip: self.source_ip,
                user_name: self.user_name,
                user_password: self.user_password,
            })
        }
    }
}
#[doc(hidden)]
pub type TestIdentityProviderInputOperationOutputAlias = crate::operation::TestIdentityProvider;
#[doc(hidden)]
pub type TestIdentityProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestIdentityProviderInput {
    /// Consumes the builder and constructs an Operation<[`TestIdentityProvider`](crate::operation::TestIdentityProvider)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestIdentityProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestIdentityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestIdentityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestIdentityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.TestIdentityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_test_identity_provider(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestIdentityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestIdentityProvider",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestIdentityProviderInput`](crate::input::TestIdentityProviderInput)
    pub fn builder() -> crate::input::test_identity_provider_input::Builder {
        crate::input::test_identity_provider_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is
        /// an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is
        /// an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for
        /// resources by type. This metadata can be attached to resources for any purpose.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for
        /// resources by type. This metadata can be attached to resources for any purpose.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                arn: self.arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAccessInput`](crate::input::UpdateAccessInput)
pub mod update_access_input {
    /// A builder for [`UpdateAccessInput`](crate::input::UpdateAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) home_directory_mappings:
            std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// Appends an item to `home_directory_mappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your
        /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
        /// <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn home_directory_mappings(
            mut self,
            input: impl Into<crate::model::HomeDirectoryMapEntry>,
        ) -> Self {
            let mut v = self.home_directory_mappings.unwrap_or_default();
            v.push(input.into());
            self.home_directory_mappings = Some(v);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        /// <p>In most cases, you can use this value instead of the session policy to lock down your
        /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
        /// <code>HomeDirectory</code> parameter value.</p>
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.home_directory_mappings = input;
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
        /// session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API
        /// Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
        /// session policy</a>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API
        /// Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
        /// files and directories in your file system determine the level of access your users get when
        /// transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
        /// files and directories in your file system determine the level of access your users get when
        /// transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is required to identify specific groups within your directory.
        /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
        /// you can view the SID values by running the following command using Windows PowerShell.</p>
        ///
        /// <p>
        /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
        /// </p>
        ///
        /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
        ///
        /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
        /// You can also include underscores or any of the following characters: =,.@:/-</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccessInput`](crate::input::UpdateAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAccessInput {
                home_directory: self.home_directory,
                home_directory_type: self.home_directory_type,
                home_directory_mappings: self.home_directory_mappings,
                policy: self.policy,
                posix_profile: self.posix_profile,
                role: self.role,
                server_id: self.server_id,
                external_id: self.external_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAccessInputOperationOutputAlias = crate::operation::UpdateAccess;
#[doc(hidden)]
pub type UpdateAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAccessInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccess`](crate::operation::UpdateAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.UpdateAccess",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_access(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccess",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAccessInput`](crate::input::UpdateAccessInput)
    pub fn builder() -> crate::input::update_access_input::Builder {
        crate::input::update_access_input::Builder::default()
    }
}

/// See [`UpdateServerInput`](crate::input::UpdateServerInput)
pub mod update_server_input {
    /// A builder for [`UpdateServerInput`](crate::input::UpdateServerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) protocol_details: std::option::Option<crate::model::ProtocolDetails>,
        pub(crate) endpoint_details: std::option::Option<crate::model::EndpointDetails>,
        pub(crate) endpoint_type: std::option::Option<crate::model::EndpointType>,
        pub(crate) host_key: std::option::Option<std::string::String>,
        pub(crate) identity_provider_details:
            std::option::Option<crate::model::IdentityProviderDetails>,
        pub(crate) logging_role: std::option::Option<std::string::String>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        pub(crate) security_policy_name: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) workflow_details: std::option::Option<crate::model::WorkflowDetails>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required
        /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        ///
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
        /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        ///
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
        /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        ///
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
        /// private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User
        /// Guide</i>.</p>
        ///
        /// <p>Certificates with the following cryptographic algorithms and key sizes are
        /// supported:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>2048-bit RSA (RSA_2048)</p>
        /// </li>
        /// <li>
        /// <p>4096-bit RSA (RSA_4096)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
        /// address specified and information about the issuer.</p>
        /// </note>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required
        /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
        ///
        /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
        /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        ///
        /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
        /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
        ///
        /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
        /// private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User
        /// Guide</i>.</p>
        ///
        /// <p>Certificates with the following cryptographic algorithms and key sizes are
        /// supported:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>2048-bit RSA (RSA_2048)</p>
        /// </li>
        /// <li>
        /// <p>4096-bit RSA (RSA_4096)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
        /// </li>
        /// <li>
        /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
        /// address specified and information about the issuer.</p>
        /// </note>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p>
        /// The protocol settings that are configured for your server.
        /// </p>
        /// <p>
        /// Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols).
        /// Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
        /// </p>
        pub fn protocol_details(mut self, input: crate::model::ProtocolDetails) -> Self {
            self.protocol_details = Some(input);
            self
        }
        /// <p>
        /// The protocol settings that are configured for your server.
        /// </p>
        /// <p>
        /// Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols).
        /// Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
        /// </p>
        pub fn set_protocol_details(
            mut self,
            input: std::option::Option<crate::model::ProtocolDetails>,
        ) -> Self {
            self.protocol_details = input;
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
        /// When you host your endpoint within your VPC, you can make it accessible only to resources
        /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
        /// the internet. Your VPC's default security groups are automatically assigned to your
        /// endpoint.</p>
        pub fn endpoint_details(mut self, input: crate::model::EndpointDetails) -> Self {
            self.endpoint_details = Some(input);
            self
        }
        /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
        /// When you host your endpoint within your VPC, you can make it accessible only to resources
        /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
        /// the internet. Your VPC's default security groups are automatically assigned to your
        /// endpoint.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<crate::model::EndpointDetails>,
        ) -> Self {
            self.endpoint_details = input;
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
        /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
        /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
        /// <note>
        /// <p> After May 19, 2021, you won't be able to create a server using
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already
        /// done so before May 19, 2021. If you have already created servers with
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021,
        /// you will not be affected. After this date, use
        /// <code>EndpointType</code>=<code>VPC</code>.</p>
        ///
        /// <p>For more information, see
        /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
        /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
        /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
        /// restrict traffic by the client's public IP address. This is not possible with
        /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn endpoint_type(mut self, input: crate::model::EndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
        /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
        /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
        /// <note>
        /// <p> After May 19, 2021, you won't be able to create a server using
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already
        /// done so before May 19, 2021. If you have already created servers with
        /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021,
        /// you will not be affected. After this date, use
        /// <code>EndpointType</code>=<code>VPC</code>.</p>
        ///
        /// <p>For more information, see
        /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
        /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
        /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
        /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
        /// restrict traffic by the client's public IP address. This is not possible with
        /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
        /// </note>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::EndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f
        /// my-new-server-key</code>.</p>
        ///
        /// <important>
        /// <p>If you aren't planning to migrate existing users from an existing server to a new
        /// server, don't update the host key. Accidentally changing a server's host key can
        /// be disruptive.</p>
        /// </important>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer
        /// Family User Guide</i>.</p>
        pub fn host_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_key = Some(input.into());
            self
        }
        /// <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f
        /// my-new-server-key</code>.</p>
        ///
        /// <important>
        /// <p>If you aren't planning to migrate existing users from an existing server to a new
        /// server, don't update the host key. Accidentally changing a server's host key can
        /// be disruptive.</p>
        /// </important>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer
        /// Family User Guide</i>.</p>
        pub fn set_host_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_key = input;
            self
        }
        /// <p>An array containing all of the information required to call a customer's
        /// authentication API method.</p>
        pub fn identity_provider_details(
            mut self,
            input: crate::model::IdentityProviderDetails,
        ) -> Self {
            self.identity_provider_details = Some(input);
            self
        }
        /// <p>An array containing all of the information required to call a customer's
        /// authentication API method.</p>
        pub fn set_identity_provider_details(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderDetails>,
        ) -> Self {
            self.identity_provider_details = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
        /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
        /// your CloudWatch logs.</p>
        pub fn logging_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.logging_role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
        /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
        /// your CloudWatch logs.</p>
        pub fn set_logging_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logging_role = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
        /// client can connect to your server's endpoint. The available protocols are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol (FTP): Unencrypted file transfer</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate
        /// Manager (ACM) which will be used to identify your server when clients connect to it over
        /// FTPS.</p>
        ///
        ///
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
        /// <code>EndpointType</code> must be <code>VPC</code> and the
        /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        ///
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
        /// <code>AddressAllocationIds</code> cannot be associated.</p>
        ///
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
        /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
        /// <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn protocols(mut self, input: impl Into<crate::model::Protocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
        /// client can connect to your server's endpoint. The available protocols are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p>
        /// </li>
        /// <li>
        /// <p>File Transfer Protocol (FTP): Unencrypted file transfer</p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate
        /// Manager (ACM) which will be used to identify your server when clients connect to it over
        /// FTPS.</p>
        ///
        ///
        /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
        /// <code>EndpointType</code> must be <code>VPC</code> and the
        /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
        ///
        /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
        /// <code>AddressAllocationIds</code> cannot be associated.</p>
        ///
        /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
        /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
        /// <code>SERVICE_MANAGED</code>.</p>
        /// </note>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn security_policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_policy_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the security policy that is attached to the server.</p>
        pub fn set_security_policy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_policy_name = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is
        /// assigned to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is
        /// assigned to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn workflow_details(mut self, input: crate::model::WorkflowDetails) -> Self {
            self.workflow_details = Some(input);
            self
        }
        /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
        pub fn set_workflow_details(
            mut self,
            input: std::option::Option<crate::model::WorkflowDetails>,
        ) -> Self {
            self.workflow_details = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServerInput`](crate::input::UpdateServerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServerInput {
                certificate: self.certificate,
                protocol_details: self.protocol_details,
                endpoint_details: self.endpoint_details,
                endpoint_type: self.endpoint_type,
                host_key: self.host_key,
                identity_provider_details: self.identity_provider_details,
                logging_role: self.logging_role,
                protocols: self.protocols,
                security_policy_name: self.security_policy_name,
                server_id: self.server_id,
                workflow_details: self.workflow_details,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServerInputOperationOutputAlias = crate::operation::UpdateServer;
#[doc(hidden)]
pub type UpdateServerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServer`](crate::operation::UpdateServer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.UpdateServer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_server(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServer",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServerInput`](crate::input::UpdateServerInput)
    pub fn builder() -> crate::input::update_server_input::Builder {
        crate::input::update_server_input::Builder::default()
    }
}

/// See [`UpdateUserInput`](crate::input::UpdateUserInput)
pub mod update_user_input {
    /// A builder for [`UpdateUserInput`](crate::input::UpdateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) home_directory: std::option::Option<std::string::String>,
        pub(crate) home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
        pub(crate) home_directory_mappings:
            std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) posix_profile: std::option::Option<crate::model::PosixProfile>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn home_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_directory = Some(input.into());
            self
        }
        /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
        /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
        pub fn set_home_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_directory = input;
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn home_directory_type(mut self, input: crate::model::HomeDirectoryType) -> Self {
            self.home_directory_type = Some(input);
            self
        }
        /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
        /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
        /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
        /// S3 or EFS paths visible to your users.</p>
        pub fn set_home_directory_type(
            mut self,
            input: std::option::Option<crate::model::HomeDirectoryType>,
        ) -> Self {
            self.home_directory_type = input;
            self
        }
        /// Appends an item to `home_directory_mappings`.
        ///
        /// To override the contents of this collection use [`set_home_directory_mappings`](Self::set_home_directory_mappings).
        ///
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        ///
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target":
        /// "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <p>In most cases, you can use this value instead of the session policy to lock down your
        /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory
        /// parameter value.</p>
        ///
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn home_directory_mappings(
            mut self,
            input: impl Into<crate::model::HomeDirectoryMapEntry>,
        ) -> Self {
            let mut v = self.home_directory_mappings.unwrap_or_default();
            v.push(input.into());
            self.home_directory_mappings = Some(v);
            self
        }
        /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
        /// be visible to your user and how you want to make them visible. You must specify the
        /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
        /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
        /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
        /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
        /// can only be set when <code>HomeDirectoryType</code> is set to
        /// <i>LOGICAL</i>.</p>
        ///
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
        /// <p>
        /// <code>[ { "Entry": "/directory1", "Target":
        /// "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <p>In most cases, you can use this value instead of the session policy to lock down your
        /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
        /// <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory
        /// parameter value.</p>
        ///
        /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
        /// <p>
        /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
        /// </p>
        ///
        /// <note>
        /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
        /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
        /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
        /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
        /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
        /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
        /// </note>
        pub fn set_home_directory_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
        ) -> Self {
            self.home_directory_mappings = input;
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>
        ///
        ///
        ///
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session
        /// policy</a>.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
        /// Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
        /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
        /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
        ///
        /// <note>
        /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
        /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
        /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
        /// it in the <code>Policy</code> argument.</p>
        ///
        ///
        ///
        /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session
        /// policy</a>.</p>
        ///
        ///
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
        /// Security Token Service API Reference</i>.</p>
        /// </note>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions
        /// that are set on files and directories in your file system determines the level of access your
        /// users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn posix_profile(mut self, input: crate::model::PosixProfile) -> Self {
            self.posix_profile = Some(input);
            self
        }
        /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
        /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
        /// your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions
        /// that are set on files and directories in your file system determines the level of access your
        /// users get when transferring files into and out of your Amazon EFS file systems.</p>
        pub fn set_posix_profile(
            mut self,
            input: std::option::Option<crate::model::PosixProfile>,
        ) -> Self {
            self.posix_profile = input;
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
        /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
        /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
        /// server to access your resources when servicing your users' transfer requests.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is
        /// assigned to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is
        /// assigned to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique string that identifies a user and is associated with a server as specified by the
        /// <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
        /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
        /// '-', period '.', and at sign '@'. The user name can't start
        /// with a hyphen, period, or at sign.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A unique string that identifies a user and is associated with a server as specified by the
        /// <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
        /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
        /// '-', period '.', and at sign '@'. The user name can't start
        /// with a hyphen, period, or at sign.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserInput`](crate::input::UpdateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateUserInput {
                home_directory: self.home_directory,
                home_directory_type: self.home_directory_type,
                home_directory_mappings: self.home_directory_mappings,
                policy: self.policy,
                posix_profile: self.posix_profile,
                role: self.role,
                server_id: self.server_id,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateUserInputOperationOutputAlias = crate::operation::UpdateUser;
#[doc(hidden)]
pub type UpdateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateUserInput {
    /// Consumes the builder and constructs an Operation<[`UpdateUser`](crate::operation::UpdateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "TransferService.UpdateUser",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateUser",
            "transfer",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateUserInput`](crate::input::UpdateUserInput)
    pub fn builder() -> crate::input::update_user_input::Builder {
        crate::input::update_user_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    ///
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target":
    /// "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <p>In most cases, you can use this value instead of the session policy to lock down your
    /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory
    /// parameter value.</p>
    ///
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub home_directory_mappings:
        std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>
    ///
    ///
    ///
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session
    /// policy</a>.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
    /// Security Token Service API Reference</i>.</p>
    /// </note>
    pub policy: std::option::Option<std::string::String>,
    /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions
    /// that are set on files and directories in your file system determines the level of access your
    /// users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server instance that the user account is
    /// assigned to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies a user and is associated with a server as specified by the
    /// <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
    /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
    /// '-', period '.', and at sign '@'. The user name can't start
    /// with a hyphen, period, or at sign.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl UpdateUserInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    ///
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target":
    /// "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <p>In most cases, you can use this value instead of the session policy to lock down your
    /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to '/' and set <code>Target</code> to the HomeDirectory
    /// parameter value.</p>
    ///
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub fn home_directory_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::HomeDirectoryMapEntry]> {
        self.home_directory_mappings.as_deref()
    }
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>
    ///
    ///
    ///
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy">Creating a session
    /// policy</a>.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
    /// Security Token Service API Reference</i>.</p>
    /// </note>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions
    /// that are set on files and directories in your file system determines the level of access your
    /// users get when transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server instance that the user account is
    /// assigned to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique string that identifies a user and is associated with a server as specified by the
    /// <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
    /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
    /// '-', period '.', and at sign '@'. The user name can't start
    /// with a hyphen, period, or at sign.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserInput");
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("home_directory_mappings", &self.home_directory_mappings);
        formatter.field("policy", &self.policy);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("role", &self.role);
        formatter.field("server_id", &self.server_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServerInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required
    /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
    ///
    /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
    /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
    ///
    /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
    /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
    ///
    /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
    /// private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User
    /// Guide</i>.</p>
    ///
    /// <p>Certificates with the following cryptographic algorithms and key sizes are
    /// supported:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>2048-bit RSA (RSA_2048)</p>
    /// </li>
    /// <li>
    /// <p>4096-bit RSA (RSA_4096)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
    /// address specified and information about the issuer.</p>
    /// </note>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>
    /// The protocol settings that are configured for your server.
    /// </p>
    /// <p>
    /// Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols).
    /// Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
    /// </p>
    pub protocol_details: std::option::Option<crate::model::ProtocolDetails>,
    /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
    /// When you host your endpoint within your VPC, you can make it accessible only to resources
    /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
    /// the internet. Your VPC's default security groups are automatically assigned to your
    /// endpoint.</p>
    pub endpoint_details: std::option::Option<crate::model::EndpointDetails>,
    /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
    /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
    /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
    /// <note>
    /// <p> After May 19, 2021, you won't be able to create a server using
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already
    /// done so before May 19, 2021. If you have already created servers with
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021,
    /// you will not be affected. After this date, use
    /// <code>EndpointType</code>=<code>VPC</code>.</p>
    ///
    /// <p>For more information, see
    /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
    /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
    /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
    /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
    /// restrict traffic by the client's public IP address. This is not possible with
    /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
    /// </note>
    pub endpoint_type: std::option::Option<crate::model::EndpointType>,
    /// <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f
    /// my-new-server-key</code>.</p>
    ///
    /// <important>
    /// <p>If you aren't planning to migrate existing users from an existing server to a new
    /// server, don't update the host key. Accidentally changing a server's host key can
    /// be disruptive.</p>
    /// </important>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer
    /// Family User Guide</i>.</p>
    pub host_key: std::option::Option<std::string::String>,
    /// <p>An array containing all of the information required to call a customer's
    /// authentication API method.</p>
    pub identity_provider_details: std::option::Option<crate::model::IdentityProviderDetails>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
    /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
    /// your CloudWatch logs.</p>
    pub logging_role: std::option::Option<std::string::String>,
    /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
    /// client can connect to your server's endpoint. The available protocols are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol (FTP): Unencrypted file transfer</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate
    /// Manager (ACM) which will be used to identify your server when clients connect to it over
    /// FTPS.</p>
    ///
    ///
    /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
    /// <code>EndpointType</code> must be <code>VPC</code> and the
    /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
    ///
    /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
    /// <code>AddressAllocationIds</code> cannot be associated.</p>
    ///
    /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
    /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
    /// <code>SERVICE_MANAGED</code>.</p>
    /// </note>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub security_policy_name: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server instance that the user account is
    /// assigned to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    pub workflow_details: std::option::Option<crate::model::WorkflowDetails>,
}
impl UpdateServerInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required
    /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
    ///
    /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
    /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
    ///
    /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
    /// in the <i> Amazon Web ServicesCertificate Manager User Guide</i>.</p>
    ///
    /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
    /// private certificate</a> in the <i> Amazon Web ServicesCertificate Manager User
    /// Guide</i>.</p>
    ///
    /// <p>Certificates with the following cryptographic algorithms and key sizes are
    /// supported:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>2048-bit RSA (RSA_2048)</p>
    /// </li>
    /// <li>
    /// <p>4096-bit RSA (RSA_4096)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
    /// address specified and information about the issuer.</p>
    /// </note>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>
    /// The protocol settings that are configured for your server.
    /// </p>
    /// <p>
    /// Use the <code>PassiveIp</code> parameter to indicate passive mode (for FTP and FTPS protocols).
    /// Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
    /// </p>
    pub fn protocol_details(&self) -> std::option::Option<&crate::model::ProtocolDetails> {
        self.protocol_details.as_ref()
    }
    /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
    /// When you host your endpoint within your VPC, you can make it accessible only to resources
    /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
    /// the internet. Your VPC's default security groups are automatically assigned to your
    /// endpoint.</p>
    pub fn endpoint_details(&self) -> std::option::Option<&crate::model::EndpointDetails> {
        self.endpoint_details.as_ref()
    }
    /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
    /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
    /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
    /// <note>
    /// <p> After May 19, 2021, you won't be able to create a server using
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount if your account hasn't already
    /// done so before May 19, 2021. If you have already created servers with
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Servicesaccount on or before May 19, 2021,
    /// you will not be affected. After this date, use
    /// <code>EndpointType</code>=<code>VPC</code>.</p>
    ///
    /// <p>For more information, see
    /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
    /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
    /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
    /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
    /// restrict traffic by the client's public IP address. This is not possible with
    /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
    /// </note>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::EndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The RSA private key as generated by <code>ssh-keygen -N "" -m PEM -f
    /// my-new-server-key</code>.</p>
    ///
    /// <important>
    /// <p>If you aren't planning to migrate existing users from an existing server to a new
    /// server, don't update the host key. Accidentally changing a server's host key can
    /// be disruptive.</p>
    /// </important>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web ServicesTransfer
    /// Family User Guide</i>.</p>
    pub fn host_key(&self) -> std::option::Option<&str> {
        self.host_key.as_deref()
    }
    /// <p>An array containing all of the information required to call a customer's
    /// authentication API method.</p>
    pub fn identity_provider_details(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderDetails> {
        self.identity_provider_details.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
    /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
    /// your CloudWatch logs.</p>
    pub fn logging_role(&self) -> std::option::Option<&str> {
        self.logging_role.as_deref()
    }
    /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
    /// client can connect to your server's endpoint. The available protocols are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol Secure (FTPS): File transfer with TLS encryption</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol (FTP): Unencrypted file transfer</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web ServicesCertificate
    /// Manager (ACM) which will be used to identify your server when clients connect to it over
    /// FTPS.</p>
    ///
    ///
    /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
    /// <code>EndpointType</code> must be <code>VPC</code> and the
    /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
    ///
    /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
    /// <code>AddressAllocationIds</code> cannot be associated.</p>
    ///
    /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
    /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
    /// <code>SERVICE_MANAGED</code>.</p>
    /// </note>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::Protocol]> {
        self.protocols.as_deref()
    }
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub fn security_policy_name(&self) -> std::option::Option<&str> {
        self.security_policy_name.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server instance that the user account is
    /// assigned to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    pub fn workflow_details(&self) -> std::option::Option<&crate::model::WorkflowDetails> {
        self.workflow_details.as_ref()
    }
}
impl std::fmt::Debug for UpdateServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServerInput");
        formatter.field("certificate", &self.certificate);
        formatter.field("protocol_details", &self.protocol_details);
        formatter.field("endpoint_details", &self.endpoint_details);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("host_key", &"*** Sensitive Data Redacted ***");
        formatter.field("identity_provider_details", &self.identity_provider_details);
        formatter.field("logging_role", &self.logging_role);
        formatter.field("protocols", &self.protocols);
        formatter.field("security_policy_name", &self.security_policy_name);
        formatter.field("server_id", &self.server_id);
        formatter.field("workflow_details", &self.workflow_details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccessInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    /// <p>In most cases, you can use this value instead of the session policy to lock down your
    /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
    /// <code>HomeDirectory</code> parameter value.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub home_directory_mappings:
        std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
    /// session policy</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API
    /// Reference</i>.</p>
    /// </note>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
    /// files and directories in your file system determine the level of access your users get when
    /// transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl UpdateAccessInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    /// <p>In most cases, you can use this value instead of the session policy to lock down your
    /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
    /// <code>HomeDirectory</code> parameter value.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub fn home_directory_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::HomeDirectoryMapEntry]> {
        self.home_directory_mappings.as_deref()
    }
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
    /// session policy</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web ServicesSecurity Token Service API
    /// Reference</i>.</p>
    /// </note>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
    /// files and directories in your file system determine the level of access your users get when
    /// transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccessInput");
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("home_directory_mappings", &self.home_directory_mappings);
        formatter.field("policy", &self.policy);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("role", &self.role);
        formatter.field("server_id", &self.server_id);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is
    /// an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for
    /// resources by type. This metadata can be attached to resources for any purpose.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The value of the resource that will have the tag removed. An Amazon Resource Name (ARN) is
    /// an identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>TagKeys are key-value pairs assigned to ARNs that can be used to group and search for
    /// resources by type. This metadata can be attached to resources for any purpose.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestIdentityProviderInput {
    /// <p>A system-assigned identifier for a specific server. That server's user authentication
    /// method is tested with a user name and password.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The type of file transfer protocol to be tested.</p>
    ///
    /// <p>The available protocols are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol Secure (FTPS)</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol (FTP)</p>
    /// </li>
    /// </ul>
    pub server_protocol: std::option::Option<crate::model::Protocol>,
    /// <p>The source IP address of the user account to be tested.</p>
    pub source_ip: std::option::Option<std::string::String>,
    /// <p>The name of the user account to be tested.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The password of the user account to be tested.</p>
    pub user_password: std::option::Option<std::string::String>,
}
impl TestIdentityProviderInput {
    /// <p>A system-assigned identifier for a specific server. That server's user authentication
    /// method is tested with a user name and password.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The type of file transfer protocol to be tested.</p>
    ///
    /// <p>The available protocols are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Secure Shell (SSH) File Transfer Protocol (SFTP)</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol Secure (FTPS)</p>
    /// </li>
    /// <li>
    /// <p>File Transfer Protocol (FTP)</p>
    /// </li>
    /// </ul>
    pub fn server_protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.server_protocol.as_ref()
    }
    /// <p>The source IP address of the user account to be tested.</p>
    pub fn source_ip(&self) -> std::option::Option<&str> {
        self.source_ip.as_deref()
    }
    /// <p>The name of the user account to be tested.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The password of the user account to be tested.</p>
    pub fn user_password(&self) -> std::option::Option<&str> {
        self.user_password.as_deref()
    }
}
impl std::fmt::Debug for TestIdentityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestIdentityProviderInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("server_protocol", &self.server_protocol);
        formatter.field("source_ip", &self.source_ip);
        formatter.field("user_name", &self.user_name);
        formatter.field("user_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or
    /// role.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by
    /// type. You can attach this metadata to user accounts for any purpose.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a server, user, or
    /// role.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Key-value pairs assigned to ARNs that you can use to group and search for resources by
    /// type. You can attach this metadata to user accounts for any purpose.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopServerInput {
    /// <p>A system-assigned unique identifier for a server that you stopped.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl StopServerInput {
    /// <p>A system-assigned unique identifier for a server that you stopped.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for StopServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopServerInput");
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartServerInput {
    /// <p>A system-assigned unique identifier for a server that you start.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl StartServerInput {
    /// <p>A system-assigned unique identifier for a server that you start.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for StartServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartServerInput");
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendWorkflowStepStateInput {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>Indicates whether the specified step succeeded or failed.</p>
    pub status: std::option::Option<crate::model::CustomStepStatus>,
}
impl SendWorkflowStepStateInput {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>Used to distinguish between multiple callbacks for multiple Lambda steps within the same execution.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
    /// <p>Indicates whether the specified step succeeded or failed.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CustomStepStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SendWorkflowStepStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendWorkflowStepStateInput");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("execution_id", &self.execution_id);
        formatter.field("token", &self.token);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkflowsInput {
    /// <p>Specifies the maximum number of workflows to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional workflows.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkflowsInput {
    /// <p>Specifies the maximum number of workflows to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional workflows.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkflowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkflowsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersInput {
    /// <p>Specifies the number of users to return as a response to the <code>ListUsers</code>
    /// request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>When you can get additional results from the <code>ListUsers</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// users.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl ListUsersInput {
    /// <p>Specifies the number of users to return as a response to the <code>ListUsers</code>
    /// request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>When you can get additional results from the <code>ListUsers</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// users.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for ListUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an
    /// identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the number of tags to return as a response to the
    /// <code>ListTagsForResource</code> request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>When you request additional results from the <code>ListTagsForResource</code> operation, a
    /// <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent
    /// command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an
    /// identifier for a specific Amazon Web Services resource, such as a server, user, or role.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Specifies the number of tags to return as a response to the
    /// <code>ListTagsForResource</code> request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>When you request additional results from the <code>ListTagsForResource</code> operation, a
    /// <code>NextToken</code> parameter is returned in the input. You can then pass in a subsequent
    /// command to the <code>NextToken</code> parameter to continue listing additional tags.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("arn", &self.arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServersInput {
    /// <p>Specifies the number of servers to return as a response to the <code>ListServers</code>
    /// query.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>When additional results are obtained from the <code>ListServers</code> command, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass the
    /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
    /// servers.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListServersInput {
    /// <p>Specifies the number of servers to return as a response to the <code>ListServers</code>
    /// query.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>When additional results are obtained from the <code>ListServers</code> command, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass the
    /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
    /// servers.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListServersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecurityPoliciesInput {
    /// <p>Specifies the number of security policies to return as a response to the
    /// <code>ListSecurityPolicies</code> query.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass the
    /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
    /// security policies.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSecurityPoliciesInput {
    /// <p>Specifies the number of security policies to return as a response to the
    /// <code>ListSecurityPolicies</code> query.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>When additional results are obtained from the <code>ListSecurityPolicies</code> command, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass the
    /// <code>NextToken</code> parameter in a subsequent command to continue listing additional
    /// security policies.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSecurityPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecurityPoliciesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExecutionsInput {
    /// <p>Specifies the aximum number of executions to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional executions.</p>
    /// <p>
    /// This is useful for pagination, for instance.
    /// If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>:
    /// </p>
    /// <p>
    /// <code>aws transfer list-executions --max-results 10</code>
    /// </p>
    /// <p>
    /// This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution.
    /// You can now call the API again, suppling the <code>NextToken</code> value you received:
    /// </p>
    /// <p>
    /// <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
    /// </p>
    /// <p>
    /// This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details
    /// for all 100 executions have been returned.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl ListExecutionsInput {
    /// <p>Specifies the aximum number of executions to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional executions.</p>
    /// <p>
    /// This is useful for pagination, for instance.
    /// If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the <code>max-results</code>:
    /// </p>
    /// <p>
    /// <code>aws transfer list-executions --max-results 10</code>
    /// </p>
    /// <p>
    /// This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh execution.
    /// You can now call the API again, suppling the <code>NextToken</code> value you received:
    /// </p>
    /// <p>
    /// <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
    /// </p>
    /// <p>
    /// This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details
    /// for all 100 executions have been returned.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for ListExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExecutionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessesInput {
    /// <p>Specifies the maximum number of access SIDs to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// accesses.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl ListAccessesInput {
    /// <p>Specifies the maximum number of access SIDs to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// accesses.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for ListAccessesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportSshPublicKeyInput {
    /// <p>A system-assigned unique identifier for a server.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The public key portion of an SSH key pair.</p>
    pub ssh_public_key_body: std::option::Option<std::string::String>,
    /// <p>The name of the user account that is assigned to one or more servers.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl ImportSshPublicKeyInput {
    /// <p>A system-assigned unique identifier for a server.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The public key portion of an SSH key pair.</p>
    pub fn ssh_public_key_body(&self) -> std::option::Option<&str> {
        self.ssh_public_key_body.as_deref()
    }
    /// <p>The name of the user account that is assigned to one or more servers.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for ImportSshPublicKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportSshPublicKeyInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("ssh_public_key_body", &self.ssh_public_key_body);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkflowInput {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl DescribeWorkflowInput {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkflowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkflowInput");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserInput {
    /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The name of the user assigned to one or more servers. User names are part of the sign-in
    /// credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl DescribeUserInput {
    /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The name of the user assigned to one or more servers. User names are part of the sign-in
    /// credentials to use the Amazon Web Services Transfer Family service and perform file transfer tasks.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServerInput {
    /// <p>A system-assigned unique identifier for a server.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl DescribeServerInput {
    /// <p>A system-assigned unique identifier for a server.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServerInput");
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSecurityPolicyInput {
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub security_policy_name: std::option::Option<std::string::String>,
}
impl DescribeSecurityPolicyInput {
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub fn security_policy_name(&self) -> std::option::Option<&str> {
        self.security_policy_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeSecurityPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSecurityPolicyInput");
        formatter.field("security_policy_name", &self.security_policy_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExecutionInput {
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl DescribeExecutionInput {
    /// <p>A unique identifier for the execution of a workflow.</p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExecutionInput");
        formatter.field("execution_id", &self.execution_id);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccessInput {
    /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl DescribeAccessInput {
    /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccessInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkflowInput {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl DeleteWorkflowInput {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorkflowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkflowInput");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>A system-assigned unique identifier for a server instance that has the user assigned to
    /// it.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies a user that is being deleted from a server.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl DeleteUserInput {
    /// <p>A system-assigned unique identifier for a server instance that has the user assigned to
    /// it.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique string that identifies a user that is being deleted from a server.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSshPublicKeyInput {
    /// <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance
    /// that has the user assigned to it.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier used to reference your user's specific SSH key.</p>
    pub ssh_public_key_id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies a user whose public key is being deleted.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl DeleteSshPublicKeyInput {
    /// <p>A system-assigned unique identifier for a file transfer protocol-enabled server instance
    /// that has the user assigned to it.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique identifier used to reference your user's specific SSH key.</p>
    pub fn ssh_public_key_id(&self) -> std::option::Option<&str> {
        self.ssh_public_key_id.as_deref()
    }
    /// <p>A unique string that identifies a user whose public key is being deleted.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteSshPublicKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSshPublicKeyInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("ssh_public_key_id", &self.ssh_public_key_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServerInput {
    /// <p>A unique system-assigned identifier for a server instance.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl DeleteServerInput {
    /// <p>A unique system-assigned identifier for a server instance.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServerInput");
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessInput {
    /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl DeleteAccessInput {
    /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessInput");
        formatter.field("server_id", &self.server_id);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkflowInput {
    /// <p>A textual description for the workflow.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the details for the steps that are in the specified workflow.</p>
    /// <p>
    /// The <code>TYPE</code> specifies which of the following actions is being taken for this step.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>Copy</i>: copy the file to another location</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Custom</i>: custom step with a lambda target</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Delete</i>: delete the file</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Tag</i>: add a tag to the file</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>
    /// Currently, copying and tagging are supported only on S3.
    /// </p>
    /// </note>
    /// <p>
    /// For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
    /// </p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
    /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
    /// <note>
    /// <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call
    /// back API to kick off the exception steps. Additionally, if the lambda does not send
    /// <code>SUCCESS</code> before it times out, the exception steps are executed.</p>
    /// </note>
    pub on_exception_steps: std::option::Option<std::vec::Vec<crate::model::WorkflowStep>>,
    /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached
    /// to workflows for any purpose.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateWorkflowInput {
    /// <p>A textual description for the workflow.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the details for the steps that are in the specified workflow.</p>
    /// <p>
    /// The <code>TYPE</code> specifies which of the following actions is being taken for this step.
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>Copy</i>: copy the file to another location</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Custom</i>: custom step with a lambda target</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Delete</i>: delete the file</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Tag</i>: add a tag to the file</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>
    /// Currently, copying and tagging are supported only on S3.
    /// </p>
    /// </note>
    /// <p>
    /// For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
    /// </p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::WorkflowStep]> {
        self.steps.as_deref()
    }
    /// <p>Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
    /// <note>
    /// <p>For custom steps, the lambda function needs to send <code>FAILURE</code> to the call
    /// back API to kick off the exception steps. Additionally, if the lambda does not send
    /// <code>SUCCESS</code> before it times out, the exception steps are executed.</p>
    /// </note>
    pub fn on_exception_steps(&self) -> std::option::Option<&[crate::model::WorkflowStep]> {
        self.on_exception_steps.as_deref()
    }
    /// <p>Key-value pairs that can be used to group and search for workflows. Tags are metadata attached
    /// to workflows for any purpose.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkflowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkflowInput");
        formatter.field("description", &self.description);
        formatter.field("steps", &self.steps);
        formatter.field("on_exception_steps", &self.on_exception_steps);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    ///
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    ///
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target":
    /// "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <p>In most cases, you can use this value instead of the session policy to lock your user
    /// down to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory
    /// parameter value.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub home_directory_mappings:
        std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>
    ///
    ///
    ///
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session
    /// policy</a>.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
    /// Security Token Service API Reference</i>.</p>
    /// </note>
    pub policy: std::option::Option<std::string::String>,
    /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
    /// files and directories in Amazon EFS determine the level of access your users get when
    /// transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server instance. This is the specific server
    /// that you added your user to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the
    /// server.</p>
    pub ssh_public_key_body: std::option::Option<std::string::String>,
    /// <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached
    /// to users for any purpose.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
    /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
    /// '-', period '.', and at sign '@'. The user name can't start
    /// with a hyphen, period, or at sign.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl CreateUserInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    ///
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    ///
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target":
    /// "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <p>In most cases, you can use this value instead of the session policy to lock your user
    /// down to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the HomeDirectory
    /// parameter value.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub fn home_directory_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::HomeDirectoryMapEntry]> {
        self.home_directory_mappings.as_deref()
    }
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>
    ///
    ///
    ///
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example session
    /// policy</a>.</p>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services
    /// Security Token Service API Reference</i>.</p>
    /// </note>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
    /// files and directories in Amazon EFS determine the level of access your users get when
    /// transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server instance. This is the specific server
    /// that you added your user to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The public portion of the Secure Shell (SSH) key used to authenticate the user to the
    /// server.</p>
    pub fn ssh_public_key_body(&self) -> std::option::Option<&str> {
        self.ssh_public_key_body.as_deref()
    }
    /// <p>Key-value pairs that can be used to group and search for users. Tags are metadata attached
    /// to users for any purpose.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A unique string that identifies a user and is associated with a <code>ServerId</code>. This user name must be a minimum of 3 and a maximum of 100 characters
    /// long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
    /// '-', period '.', and at sign '@'. The user name can't start
    /// with a hyphen, period, or at sign.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("home_directory_mappings", &self.home_directory_mappings);
        formatter.field("policy", &self.policy);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("role", &self.role);
        formatter.field("server_id", &self.server_id);
        formatter.field("ssh_public_key_body", &self.ssh_public_key_body);
        formatter.field("tags", &self.tags);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServerInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required
    /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
    ///
    /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
    /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
    ///
    /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
    /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
    ///
    /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
    /// private certificate</a> in the <i> Amazon Web Services Certificate Manager User
    /// Guide</i>.</p>
    ///
    /// <p>Certificates with the following cryptographic algorithms and key sizes are
    /// supported:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>2048-bit RSA (RSA_2048)</p>
    /// </li>
    /// <li>
    /// <p>4096-bit RSA (RSA_4096)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
    /// address specified and information about the issuer.</p>
    /// </note>
    pub certificate: std::option::Option<std::string::String>,
    /// <p>The domain of the storage system that is used for file transfers. There are two domains
    /// available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The
    /// default value is S3.</p>
    ///
    /// <note>
    /// <p>After the server is created, the domain cannot be changed.</p>
    /// </note>
    pub domain: std::option::Option<crate::model::Domain>,
    /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
    /// When you host your endpoint within your VPC, you can make it accessible only to resources
    /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
    /// the internet. Your VPC's default security groups are automatically assigned to your
    /// endpoint.</p>
    pub endpoint_details: std::option::Option<crate::model::EndpointDetails>,
    /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
    /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
    /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
    /// <note>
    /// <p> After May 19, 2021, you won't be able to create a server using
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already
    /// done so before May 19, 2021. If you have already created servers with
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021,
    /// you will not be affected. After this date, use
    /// <code>EndpointType</code>=<code>VPC</code>.</p>
    ///
    /// <p>For more information, see
    /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
    /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
    /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
    /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
    /// restrict traffic by the client's public IP address. This is not possible with
    /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
    /// </note>
    pub endpoint_type: std::option::Option<crate::model::EndpointType>,
    /// <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f
    /// my-new-server-key</code> command.</p>
    ///
    /// <important>
    /// <p>If you aren't planning to migrate existing users from an existing SFTP-enabled
    /// server to a new server, don't update the host key. Accidentally changing a
    /// server's host key can be disruptive.</p>
    /// </important>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer
    /// Family User Guide</i>.</p>
    pub host_key: std::option::Option<std::string::String>,
    /// <p>Required when <code>IdentityProviderType</code> is set to
    /// <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing
    /// all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or
    /// invoke a customer-supplied authentication API, including the API Gateway URL. Not required
    /// when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
    pub identity_provider_details: std::option::Option<crate::model::IdentityProviderDetails>,
    /// <p>Specifies the mode of authentication for a server. The default value is
    /// <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within
    /// the Amazon Web Services Transfer Family service.</p>
    /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to
    /// Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your
    /// on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to
    /// provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
    /// <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call
    /// for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value,
    /// you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    pub identity_provider_type: std::option::Option<crate::model::IdentityProviderType>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
    /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
    /// your CloudWatch logs.</p>
    pub logging_role: std::option::Option<std::string::String>,
    /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
    /// client can connect to your server's endpoint. The available protocols are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over
    /// SSH</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS
    /// encryption</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate
    /// Manager (ACM) which is used to identify your server when clients connect to it over
    /// FTPS.</p>
    ///
    /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
    /// <code>EndpointType</code> must be <code>VPC</code> and the
    /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
    ///
    /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
    /// <code>AddressAllocationIds</code> cannot be associated.</p>
    ///
    /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
    /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
    /// <code>SERVICE_MANAGED</code>.</p>
    /// </note>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub security_policy_name: std::option::Option<std::string::String>,
    /// <p>Key-value pairs that can be used to group and search for servers.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    pub workflow_details: std::option::Option<crate::model::WorkflowDetails>,
}
impl CreateServerInput {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required
    /// when <code>Protocols</code> is set to <code>FTPS</code>.</p>
    ///
    /// <p>To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate</a>
    /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
    ///
    /// <p>To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM</a>
    /// in the <i> Amazon Web Services Certificate Manager User Guide</i>.</p>
    ///
    /// <p>To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
    /// private certificate</a> in the <i> Amazon Web Services Certificate Manager User
    /// Guide</i>.</p>
    ///
    /// <p>Certificates with the following cryptographic algorithms and key sizes are
    /// supported:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>2048-bit RSA (RSA_2048)</p>
    /// </li>
    /// <li>
    /// <p>4096-bit RSA (RSA_4096)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 256 bit (EC_prime256v1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 384 bit (EC_secp384r1)</p>
    /// </li>
    /// <li>
    /// <p>Elliptic Prime Curve 521 bit (EC_secp521r1)</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
    /// address specified and information about the issuer.</p>
    /// </note>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p>The domain of the storage system that is used for file transfers. There are two domains
    /// available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The
    /// default value is S3.</p>
    ///
    /// <note>
    /// <p>After the server is created, the domain cannot be changed.</p>
    /// </note>
    pub fn domain(&self) -> std::option::Option<&crate::model::Domain> {
        self.domain.as_ref()
    }
    /// <p>The virtual private cloud (VPC) endpoint settings that are configured for your server.
    /// When you host your endpoint within your VPC, you can make it accessible only to resources
    /// within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
    /// the internet. Your VPC's default security groups are automatically assigned to your
    /// endpoint.</p>
    pub fn endpoint_details(&self) -> std::option::Option<&crate::model::EndpointDetails> {
        self.endpoint_details.as_ref()
    }
    /// <p>The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
    /// or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
    /// resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.</p>
    /// <note>
    /// <p> After May 19, 2021, you won't be able to create a server using
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account if your account hasn't already
    /// done so before May 19, 2021. If you have already created servers with
    /// <code>EndpointType=VPC_ENDPOINT</code> in your Amazon Web Services account on or before May 19, 2021,
    /// you will not be affected. After this date, use
    /// <code>EndpointType</code>=<code>VPC</code>.</p>
    ///
    /// <p>For more information, see
    /// https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.</p>
    /// <p>It is recommended that you use <code>VPC</code> as the <code>EndpointType</code>. With
    /// this endpoint type, you have the option to directly associate up to three Elastic IPv4
    /// addresses (BYO IP included) with your server's endpoint and use VPC security groups to
    /// restrict traffic by the client's public IP address. This is not possible with
    /// <code>EndpointType</code> set to <code>VPC_ENDPOINT</code>.</p>
    /// </note>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::EndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The RSA private key as generated by the <code>ssh-keygen -N "" -m PEM -f
    /// my-new-server-key</code> command.</p>
    ///
    /// <important>
    /// <p>If you aren't planning to migrate existing users from an existing SFTP-enabled
    /// server to a new server, don't update the host key. Accidentally changing a
    /// server's host key can be disruptive.</p>
    /// </important>
    ///
    ///
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server</a> in the <i>Amazon Web Services Transfer
    /// Family User Guide</i>.</p>
    pub fn host_key(&self) -> std::option::Option<&str> {
        self.host_key.as_deref()
    }
    /// <p>Required when <code>IdentityProviderType</code> is set to
    /// <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>. Accepts an array containing
    /// all of the information required to use a directory in <code>AWS_DIRECTORY_SERVICE</code> or
    /// invoke a customer-supplied authentication API, including the API Gateway URL. Not required
    /// when <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.</p>
    pub fn identity_provider_details(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderDetails> {
        self.identity_provider_details.as_ref()
    }
    /// <p>Specifies the mode of authentication for a server. The default value is
    /// <code>SERVICE_MANAGED</code>, which allows you to store and access user credentials within
    /// the Amazon Web Services Transfer Family service.</p>
    /// <p>Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to
    /// Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your
    /// on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to
    /// provide a Directory ID using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
    /// <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call
    /// for authentication using the <code>IdentityProviderDetails</code> parameter.</p>
    /// <p>Use the <code>LAMBDA</code> value to directly use a Lambda function as your identity provider. If you choose this value,
    /// you must specify the ARN for the lambda function in the <code>Function</code> parameter for the <code>IdentityProviderDetails</code> data type.</p>
    pub fn identity_provider_type(
        &self,
    ) -> std::option::Option<&crate::model::IdentityProviderType> {
        self.identity_provider_type.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
    /// on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
    /// your CloudWatch logs.</p>
    pub fn logging_role(&self) -> std::option::Option<&str> {
        self.logging_role.as_deref()
    }
    /// <p>Specifies the file transfer protocol or protocols over which your file transfer protocol
    /// client can connect to your server's endpoint. The available protocols are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SFTP</code> (Secure Shell (SSH) File Transfer Protocol): File transfer over
    /// SSH</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FTPS</code> (File Transfer Protocol Secure): File transfer with TLS
    /// encryption</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FTP</code> (File Transfer Protocol): Unencrypted file transfer</p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>If you select <code>FTPS</code>, you must choose a certificate stored in Amazon Web Services Certificate
    /// Manager (ACM) which is used to identify your server when clients connect to it over
    /// FTPS.</p>
    ///
    /// <p>If <code>Protocol</code> includes either <code>FTP</code> or <code>FTPS</code>, then the
    /// <code>EndpointType</code> must be <code>VPC</code> and the
    /// <code>IdentityProviderType</code> must be <code>AWS_DIRECTORY_SERVICE</code> or <code>API_GATEWAY</code>.</p>
    ///
    /// <p>If <code>Protocol</code> includes <code>FTP</code>, then
    /// <code>AddressAllocationIds</code> cannot be associated.</p>
    ///
    /// <p>If <code>Protocol</code> is set only to <code>SFTP</code>, the <code>EndpointType</code>
    /// can be set to <code>PUBLIC</code> and the <code>IdentityProviderType</code> can be set to
    /// <code>SERVICE_MANAGED</code>.</p>
    /// </note>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::Protocol]> {
        self.protocols.as_deref()
    }
    /// <p>Specifies the name of the security policy that is attached to the server.</p>
    pub fn security_policy_name(&self) -> std::option::Option<&str> {
        self.security_policy_name.as_deref()
    }
    /// <p>Key-value pairs that can be used to group and search for servers.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.</p>
    pub fn workflow_details(&self) -> std::option::Option<&crate::model::WorkflowDetails> {
        self.workflow_details.as_ref()
    }
}
impl std::fmt::Debug for CreateServerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServerInput");
        formatter.field("certificate", &self.certificate);
        formatter.field("domain", &self.domain);
        formatter.field("endpoint_details", &self.endpoint_details);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("host_key", &"*** Sensitive Data Redacted ***");
        formatter.field("identity_provider_details", &self.identity_provider_details);
        formatter.field("identity_provider_type", &self.identity_provider_type);
        formatter.field("logging_role", &self.logging_role);
        formatter.field("protocols", &self.protocols);
        formatter.field("security_policy_name", &self.security_policy_name);
        formatter.field("tags", &self.tags);
        formatter.field("workflow_details", &self.workflow_details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub home_directory: std::option::Option<std::string::String>,
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub home_directory_type: std::option::Option<crate::model::HomeDirectoryType>,
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    /// <p>In most cases, you can use this value instead of the session policy to lock down your
    /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
    /// <code>HomeDirectory</code> parameter value.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub home_directory_mappings:
        std::option::Option<std::vec::Vec<crate::model::HomeDirectoryMapEntry>>,
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>      
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
    /// session policy</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API
    /// Reference</i>.</p>
    /// </note>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
    /// files and directories in your file system determine the level of access your users get when
    /// transferring files into and out of your Amazon EFS file systems.</p>
    pub posix_profile: std::option::Option<crate::model::PosixProfile>,
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl CreateAccessInput {
    /// <p>The landing directory (folder) for a user when they log in to the server using the client.</p>
    /// <p>A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.</p>
    pub fn home_directory(&self) -> std::option::Option<&str> {
        self.home_directory.as_deref()
    }
    /// <p>The type of landing directory (folder) you want your users' home directory to be when they log into the server.
    /// If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
    /// If you set it <code>LOGICAL</code>, you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
    /// S3 or EFS paths visible to your users.</p>
    pub fn home_directory_type(&self) -> std::option::Option<&crate::model::HomeDirectoryType> {
        self.home_directory_type.as_ref()
    }
    /// <p>Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should
    /// be visible to your user and how you want to make them visible. You must specify the
    /// <code>Entry</code> and <code>Target</code> pair, where <code>Entry</code> shows how the path
    /// is made visible and <code>Target</code> is the actual Amazon S3 or Amazon EFS path. If you
    /// only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity
    /// and Access Management (IAM) role provides access to paths in <code>Target</code>. This value
    /// can only be set when <code>HomeDirectoryType</code> is set to
    /// <i>LOGICAL</i>.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example.</p>
    /// <p>
    /// <code>[ { "Entry": "/directory1", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    /// <p>In most cases, you can use this value instead of the session policy to lock down your
    /// user to the designated home directory ("<code>chroot</code>"). To do this, you can set
    /// <code>Entry</code> to <code>/</code> and set <code>Target</code> to the
    /// <code>HomeDirectory</code> parameter value.</p>
    /// <p>The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.</p>
    /// <p>
    /// <code>[ { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
    /// </p>
    ///
    /// <note>
    /// <p>If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
    /// ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
    /// holders for your directory. If using the CLI, use the <code>s3api</code> or <code>efsapi</code> call instead of
    /// <code>s3</code> or <code>efs</code> so you can use the put-object operation. For example, you use the
    /// following: <code>aws s3api put-object --bucket bucketname --key path/to/folder/</code>. Make
    /// sure that the end of the key name ends in a <code>/</code> for it to be considered a folder.</p>
    /// </note>
    pub fn home_directory_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::HomeDirectoryMapEntry]> {
        self.home_directory_mappings.as_deref()
    }
    /// <p>A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user
    /// access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include <code>${Transfer:UserName}</code>,
    /// <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.</p>
    ///
    /// <note>
    /// <p>This only applies when the domain of <code>ServerId</code> is S3. EFS does not use session policies.</p>
    /// <p>For session policies, Amazon Web Services Transfer Family stores the policy as a JSON blob, instead
    /// of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob and pass
    /// it in the <code>Policy</code> argument.</p>      
    /// <p>For an example of a session policy, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/session-policy.html">Example
    /// session policy</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html">AssumeRole</a> in the <i>Amazon Web Services Security Token Service API
    /// Reference</i>.</p>
    /// </note>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The full POSIX identity, including user ID (<code>Uid</code>), group ID
    /// (<code>Gid</code>), and any secondary groups IDs (<code>SecondaryGids</code>), that controls
    /// your users' access to your Amazon EFS file systems. The POSIX permissions that are set on
    /// files and directories in your file system determine the level of access your users get when
    /// transferring files into and out of your Amazon EFS file systems.</p>
    pub fn posix_profile(&self) -> std::option::Option<&crate::model::PosixProfile> {
        self.posix_profile.as_ref()
    }
    /// <p>Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
    /// file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
    /// files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
    /// server to access your resources when servicing your users' transfer requests.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server instance. This is the specific server that you added your user to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique identifier that is required to identify specific groups within your directory.
    /// The users of the group that you associate have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name,
    /// you can view the SID values by running the following command using Windows PowerShell.</p>
    ///
    /// <p>
    /// <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
    /// </p>
    ///
    /// <p>In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.</p>
    ///
    /// <p>The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces.
    /// You can also include underscores or any of the following characters: =,.@:/-</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAccessInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessInput");
        formatter.field("home_directory", &self.home_directory);
        formatter.field("home_directory_type", &self.home_directory_type);
        formatter.field("home_directory_mappings", &self.home_directory_mappings);
        formatter.field("policy", &self.policy);
        formatter.field("posix_profile", &self.posix_profile);
        formatter.field("role", &self.role);
        formatter.field("server_id", &self.server_id);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}
