// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccessError {
    /// Kind of error that occurred.
    pub kind: CreateAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccessErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccessErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            CreateAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAccessErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAccessErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccessError {
    fn code(&self) -> Option<&str> {
        CreateAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccessError {
    /// Creates a new `CreateAccessError`.
    pub fn new(kind: CreateAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccessErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, CreateAccessErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `CreateAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccessErrorKind::InternalServiceError(_inner) => Some(_inner),
            CreateAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAccessErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAccessErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServerError {
    /// Kind of error that occurred.
    pub kind: CreateServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            CreateServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServerError {
    fn code(&self) -> Option<&str> {
        CreateServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServerError {
    /// Creates a new `CreateServerError`.
    pub fn new(kind: CreateServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateServerErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, CreateServerErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServerErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateServerErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServerErrorKind::InternalServiceError(_inner) => Some(_inner),
            CreateServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateServerErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateServerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateServerErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ResourceExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::InternalServiceError(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateUserErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkflowError {
    /// Kind of error that occurred.
    pub kind: CreateWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkflowErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkflowErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkflowError {
    fn code(&self) -> Option<&str> {
        CreateWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkflowError {
    /// Creates a new `CreateWorkflowError`.
    pub fn new(kind: CreateWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, CreateWorkflowErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkflowErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkflowErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::InternalServiceError(_inner) => Some(_inner),
            CreateWorkflowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::ResourceExistsException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccessError {
    /// Kind of error that occurred.
    pub kind: DeleteAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccessErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccessErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAccessErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccessError {
    fn code(&self) -> Option<&str> {
        DeleteAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccessError {
    /// Creates a new `DeleteAccessError`.
    pub fn new(kind: DeleteAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccessErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DeleteAccessErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DeleteAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccessErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccessErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAccessErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServerError {
    /// Kind of error that occurred.
    pub kind: DeleteServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServerError {
    fn code(&self) -> Option<&str> {
        DeleteServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServerError {
    /// Creates a new `DeleteServerError`.
    pub fn new(kind: DeleteServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteServerErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DeleteServerErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteServerErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSshPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSshPublicKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteSshPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSshPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSshPublicKeyErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSshPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSshPublicKeyErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteSshPublicKeyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteSshPublicKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSshPublicKeyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteSshPublicKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSshPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSshPublicKeyError {
    fn code(&self) -> Option<&str> {
        DeleteSshPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSshPublicKeyError {
    /// Creates a new `DeleteSshPublicKeyError`.
    pub fn new(kind: DeleteSshPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSshPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSshPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSshPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSshPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSshPublicKeyErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSshPublicKeyErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSshPublicKeyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSshPublicKeyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSshPublicKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSshPublicKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSshPublicKeyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSshPublicKeyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSshPublicKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSshPublicKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteSshPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSshPublicKeyErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteSshPublicKeyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteSshPublicKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSshPublicKeyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteSshPublicKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSshPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkflowError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkflowErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkflowErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkflowError {
    fn code(&self) -> Option<&str> {
        DeleteWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkflowError {
    /// Creates a new `DeleteWorkflowError`.
    pub fn new(kind: DeleteWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DeleteWorkflowErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkflowErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::InternalServiceError(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccessError {
    /// Kind of error that occurred.
    pub kind: DescribeAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccessErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccessErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DescribeAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAccessErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccessError {
    fn code(&self) -> Option<&str> {
        DescribeAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccessError {
    /// Creates a new `DescribeAccessError`.
    pub fn new(kind: DescribeAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccessErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DescribeAccessErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DescribeAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccessErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccessErrorKind::InternalServiceError(_inner) => Some(_inner),
            DescribeAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAccessErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExecutionError {
    /// Kind of error that occurred.
    pub kind: DescribeExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExecutionErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExecutionErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DescribeExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeExecutionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeExecutionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExecutionError {
    fn code(&self) -> Option<&str> {
        DescribeExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExecutionError {
    /// Creates a new `DescribeExecutionError`.
    pub fn new(kind: DescribeExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExecutionErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExecutionErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExecutionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExecutionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExecutionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExecutionErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExecutionErrorKind::InternalServiceError(_inner) => Some(_inner),
            DescribeExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeExecutionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeExecutionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSecurityPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSecurityPolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeSecurityPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSecurityPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSecurityPolicyErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSecurityPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSecurityPolicyErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DescribeSecurityPolicyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeSecurityPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSecurityPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeSecurityPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSecurityPolicyError {
    fn code(&self) -> Option<&str> {
        DescribeSecurityPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSecurityPolicyError {
    /// Creates a new `DescribeSecurityPolicyError`.
    pub fn new(kind: DescribeSecurityPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSecurityPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSecurityPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSecurityPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSecurityPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSecurityPolicyErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityPolicyErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityPolicyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityPolicyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeSecurityPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSecurityPolicyErrorKind::InternalServiceError(_inner) => Some(_inner),
            DescribeSecurityPolicyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeSecurityPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSecurityPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeSecurityPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServerError {
    /// Kind of error that occurred.
    pub kind: DescribeServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServerErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServerErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DescribeServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeServerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServerError {
    fn code(&self) -> Option<&str> {
        DescribeServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServerError {
    /// Creates a new `DescribeServerError`.
    pub fn new(kind: DescribeServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeServerErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DescribeServerErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DescribeServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServerErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServerErrorKind::InternalServiceError(_inner) => Some(_inner),
            DescribeServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeServerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserError {
    /// Kind of error that occurred.
    pub kind: DescribeUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserError {
    fn code(&self) -> Option<&str> {
        DescribeUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserError {
    /// Creates a new `DescribeUserError`.
    pub fn new(kind: DescribeUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserErrorKind::InternalServiceError(_inner) => Some(_inner),
            DescribeUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkflowError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkflowErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkflowErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            DescribeWorkflowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeWorkflowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeWorkflowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkflowError {
    fn code(&self) -> Option<&str> {
        DescribeWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeWorkflowError {
    /// Creates a new `DescribeWorkflowError`.
    pub fn new(kind: DescribeWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkflowErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkflowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkflowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkflowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkflowErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkflowErrorKind::InternalServiceError(_inner) => Some(_inner),
            DescribeWorkflowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeWorkflowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeWorkflowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportSshPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportSshPublicKeyError {
    /// Kind of error that occurred.
    pub kind: ImportSshPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportSshPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportSshPublicKeyErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportSshPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportSshPublicKeyErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ImportSshPublicKeyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ImportSshPublicKeyErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            ImportSshPublicKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ImportSshPublicKeyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ImportSshPublicKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ImportSshPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportSshPublicKeyError {
    fn code(&self) -> Option<&str> {
        ImportSshPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportSshPublicKeyError {
    /// Creates a new `ImportSshPublicKeyError`.
    pub fn new(kind: ImportSshPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportSshPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportSshPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportSshPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportSshPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportSshPublicKeyErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ImportSshPublicKeyErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSshPublicKeyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSshPublicKeyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSshPublicKeyErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSshPublicKeyErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSshPublicKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSshPublicKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSshPublicKeyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSshPublicKeyErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSshPublicKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSshPublicKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ImportSshPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportSshPublicKeyErrorKind::InternalServiceError(_inner) => Some(_inner),
            ImportSshPublicKeyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ImportSshPublicKeyErrorKind::ResourceExistsException(_inner) => Some(_inner),
            ImportSshPublicKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ImportSshPublicKeyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ImportSshPublicKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            ImportSshPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccesses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccessesError {
    /// Kind of error that occurred.
    pub kind: ListAccessesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccesses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccessesErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccessesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccessesErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListAccessesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListAccessesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAccessesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAccessesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListAccessesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccessesError {
    fn code(&self) -> Option<&str> {
        ListAccessesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccessesError {
    /// Creates a new `ListAccessesError`.
    pub fn new(kind: ListAccessesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccessesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccessesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccessesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccessesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccessesErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, ListAccessesErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `ListAccessesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccessesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccessesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccessesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListAccessesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccessesErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListAccessesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListAccessesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAccessesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAccessesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListAccessesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExecutionsErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExecutionsErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExecutionsError {
    fn code(&self) -> Option<&str> {
        ListExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExecutionsError {
    /// Creates a new `ListExecutionsError`.
    pub fn new(kind: ListExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, ListExecutionsErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExecutionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExecutionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExecutionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListExecutionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListExecutionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExecutionsErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListExecutionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListExecutionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListExecutionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListExecutionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSecurityPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSecurityPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListSecurityPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSecurityPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSecurityPoliciesErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSecurityPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSecurityPoliciesErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListSecurityPoliciesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListSecurityPoliciesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListSecurityPoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListSecurityPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSecurityPoliciesError {
    fn code(&self) -> Option<&str> {
        ListSecurityPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSecurityPoliciesError {
    /// Creates a new `ListSecurityPoliciesError`.
    pub fn new(kind: ListSecurityPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSecurityPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSecurityPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSecurityPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSecurityPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSecurityPoliciesErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityPoliciesErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityPoliciesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityPoliciesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityPoliciesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityPoliciesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityPoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityPoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListSecurityPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSecurityPoliciesErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListSecurityPoliciesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListSecurityPoliciesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListSecurityPoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListSecurityPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServersError {
    /// Kind of error that occurred.
    pub kind: ListServersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServersErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServersErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListServersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListServersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListServersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListServersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServersError {
    fn code(&self) -> Option<&str> {
        ListServersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServersError {
    /// Creates a new `ListServersError`.
    pub fn new(kind: ListServersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, ListServersErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServersErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListServersErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListServersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServersErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListServersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServersErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListServersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListServersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListServersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListServersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidNextTokenException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsersErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkflows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkflowsError {
    /// Kind of error that occurred.
    pub kind: ListWorkflowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkflows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkflowsErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkflowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkflowsErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkflowsError {
    fn code(&self) -> Option<&str> {
        ListWorkflowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkflowsError {
    /// Creates a new `ListWorkflowsError`.
    pub fn new(kind: ListWorkflowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkflowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkflowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkflowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkflowsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, ListWorkflowsErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListWorkflowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkflowsErrorKind::InternalServiceError(_inner) => Some(_inner),
            ListWorkflowsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            ListWorkflowsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListWorkflowsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListWorkflowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendWorkflowStepState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendWorkflowStepStateError {
    /// Kind of error that occurred.
    pub kind: SendWorkflowStepStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendWorkflowStepState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendWorkflowStepStateErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendWorkflowStepStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendWorkflowStepStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendWorkflowStepStateErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            SendWorkflowStepStateErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            SendWorkflowStepStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SendWorkflowStepStateErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            SendWorkflowStepStateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendWorkflowStepStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendWorkflowStepStateError {
    fn code(&self) -> Option<&str> {
        SendWorkflowStepStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendWorkflowStepStateError {
    /// Creates a new `SendWorkflowStepStateError`.
    pub fn new(kind: SendWorkflowStepStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendWorkflowStepStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendWorkflowStepStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendWorkflowStepStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendWorkflowStepStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendWorkflowStepStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendWorkflowStepStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendWorkflowStepStateErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            SendWorkflowStepStateErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `SendWorkflowStepStateErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendWorkflowStepStateErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SendWorkflowStepStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendWorkflowStepStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendWorkflowStepStateErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendWorkflowStepStateErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `SendWorkflowStepStateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendWorkflowStepStateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for SendWorkflowStepStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendWorkflowStepStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendWorkflowStepStateErrorKind::InternalServiceError(_inner) => Some(_inner),
            SendWorkflowStepStateErrorKind::InvalidRequestException(_inner) => Some(_inner),
            SendWorkflowStepStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SendWorkflowStepStateErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            SendWorkflowStepStateErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendWorkflowStepStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartServerError {
    /// Kind of error that occurred.
    pub kind: StartServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartServerErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartServerErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            StartServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartServerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartServerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartServerError {
    fn code(&self) -> Option<&str> {
        StartServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartServerError {
    /// Creates a new `StartServerError`.
    pub fn new(kind: StartServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartServerErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, StartServerErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `StartServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, StartServerErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `StartServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartServerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartServerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartServerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartServerErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for StartServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartServerErrorKind::InternalServiceError(_inner) => Some(_inner),
            StartServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartServerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartServerErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopServerError {
    /// Kind of error that occurred.
    pub kind: StopServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopServerErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopServerErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            StopServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopServerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StopServerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopServerError {
    fn code(&self) -> Option<&str> {
        StopServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopServerError {
    /// Creates a new `StopServerError`.
    pub fn new(kind: StopServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopServerErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, StopServerErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `StopServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, StopServerErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `StopServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopServerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopServerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StopServerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopServerErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for StopServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopServerErrorKind::InternalServiceError(_inner) => Some(_inner),
            StopServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopServerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StopServerErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServiceError(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestIdentityProviderError {
    /// Kind of error that occurred.
    pub kind: TestIdentityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestIdentityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestIdentityProviderErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestIdentityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestIdentityProviderErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            TestIdentityProviderErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TestIdentityProviderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TestIdentityProviderErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TestIdentityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestIdentityProviderError {
    fn code(&self) -> Option<&str> {
        TestIdentityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestIdentityProviderError {
    /// Creates a new `TestIdentityProviderError`.
    pub fn new(kind: TestIdentityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestIdentityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestIdentityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestIdentityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestIdentityProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestIdentityProviderErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(
            &self.kind,
            TestIdentityProviderErrorKind::InternalServiceError(_)
        )
    }
    /// Returns `true` if the error kind is `TestIdentityProviderErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestIdentityProviderErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `TestIdentityProviderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestIdentityProviderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TestIdentityProviderErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestIdentityProviderErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for TestIdentityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestIdentityProviderErrorKind::InternalServiceError(_inner) => Some(_inner),
            TestIdentityProviderErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TestIdentityProviderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TestIdentityProviderErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TestIdentityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceError(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccessError {
    /// Kind of error that occurred.
    pub kind: UpdateAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccessErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccessErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UpdateAccessErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAccessErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateAccessErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAccessErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccessError {
    fn code(&self) -> Option<&str> {
        UpdateAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccessError {
    /// Creates a new `UpdateAccessError`.
    pub fn new(kind: UpdateAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAccessErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, UpdateAccessErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `UpdateAccessErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccessErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccessErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccessErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for UpdateAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccessErrorKind::InternalServiceError(_inner) => Some(_inner),
            UpdateAccessErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAccessErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateAccessErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAccessErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServerError {
    /// Kind of error that occurred.
    pub kind: UpdateServerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServerErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>This exception is thrown when the <code>UpdateServer</code> is called for a file transfer
    /// protocol-enabled server that has VPC as the endpoint type and the server's
    /// <code>VpcEndpointID</code> is not in the available state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The requested resource does not exist.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ResourceExistsException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateServerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServerError {
    fn code(&self) -> Option<&str> {
        UpdateServerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServerError {
    /// Creates a new `UpdateServerError`.
    pub fn new(kind: UpdateServerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateServerErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateServerErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, UpdateServerErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ResourceExistsException`.
    pub fn is_resource_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerErrorKind::ResourceExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateServerErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateServerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServerErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateServerErrorKind::InternalServiceError(_inner) => Some(_inner),
            UpdateServerErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateServerErrorKind::ResourceExistsException(_inner) => Some(_inner),
            UpdateServerErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServerErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateServerErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateServerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserError {
    /// Kind of error that occurred.
    pub kind: UpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserErrorKind {
    /// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
    InternalServiceError(crate::error::InternalServiceError),
    /// <p>This exception is thrown when the client submits a malformed request.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
    /// service.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The request was denied due to request throttling.</p>
    ///
    /// <p> HTTP Status Code: 400</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserErrorKind::InternalServiceError(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserError {
    fn code(&self) -> Option<&str> {
        UpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserError {
    /// Creates a new `UpdateUserError`.
    pub fn new(kind: UpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::InternalServiceError`.
    pub fn is_internal_service_error(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::InternalServiceError(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserErrorKind::InternalServiceError(_inner) => Some(_inner),
            UpdateUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was denied due to request throttling.</p>
///
/// <p> HTTP Status Code: 400</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn retry_after_seconds(&self) -> std::option::Option<&str> {
        self.retry_after_seconds.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The request has failed because the Amazon Web ServicesTransfer Family service is not available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family
/// service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource", &self.resource);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource: self.resource,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the client submits a malformed request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceError")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceError {}
/// See [`InternalServiceError`](crate::error::InternalServiceError)
pub mod internal_service_error {
    /// A builder for [`InternalServiceError`](crate::error::InternalServiceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceError`](crate::error::InternalServiceError)
        pub fn build(self) -> crate::error::InternalServiceError {
            crate::error::InternalServiceError {
                message: self.message,
            }
        }
    }
}
impl InternalServiceError {
    /// Creates a new builder-style object to manufacture [`InternalServiceError`](crate::error::InternalServiceError)
    pub fn builder() -> crate::error::internal_service_error::Builder {
        crate::error::internal_service_error::Builder::default()
    }
}

/// <p>The requested resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceExistsException");
        formatter.field("message", &self.message);
        formatter.field("resource", &self.resource);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceExistsException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceExistsException {}
/// See [`ResourceExistsException`](crate::error::ResourceExistsException)
pub mod resource_exists_exception {
    /// A builder for [`ResourceExistsException`](crate::error::ResourceExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceExistsException`](crate::error::ResourceExistsException)
        pub fn build(self) -> crate::error::ResourceExistsException {
            crate::error::ResourceExistsException {
                message: self.message,
                resource: self.resource,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceExistsException`](crate::error::ResourceExistsException)
    pub fn builder() -> crate::error::resource_exists_exception::Builder {
        crate::error::resource_exists_exception::Builder::default()
    }
}

/// <p>This exception is thrown when the <code>UpdateServer</code> is called for a file transfer
/// protocol-enabled server that has VPC as the endpoint type and the server's
/// <code>VpcEndpointID</code> is not in the available state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The <code>NextToken</code> parameter that was passed is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}
