// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>
/// <code>UpdateUserResponse</code> returns the user name and identifier for the request to
/// update a user's properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserOutput {
    /// <p>A system-assigned unique identifier for a server instance that the user account is
    /// assigned to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for a user that is assigned to a server instance that was specified
    /// in the request.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl UpdateUserOutput {
    /// <p>A system-assigned unique identifier for a server instance that the user account is
    /// assigned to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The unique identifier for a user that is assigned to a server instance that was specified
    /// in the request.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`UpdateUserOutput`](crate::output::UpdateUserOutput)
pub mod update_user_output {
    /// A builder for [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server instance that the user account is
        /// assigned to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server instance that the user account is
        /// assigned to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The unique identifier for a user that is assigned to a server instance that was specified
        /// in the request.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The unique identifier for a user that is assigned to a server instance that was specified
        /// in the request.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserOutput`](crate::output::UpdateUserOutput)
        pub fn build(self) -> crate::output::UpdateUserOutput {
            crate::output::UpdateUserOutput {
                server_id: self.server_id,
                user_name: self.user_name,
            }
        }
    }
}
impl UpdateUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    pub fn builder() -> crate::output::update_user_output::Builder {
        crate::output::update_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServerOutput {
    /// <p>A system-assigned unique identifier for a server that the user account is assigned
    /// to.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl UpdateServerOutput {
    /// <p>A system-assigned unique identifier for a server that the user account is assigned
    /// to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServerOutput");
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}
/// See [`UpdateServerOutput`](crate::output::UpdateServerOutput)
pub mod update_server_output {
    /// A builder for [`UpdateServerOutput`](crate::output::UpdateServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that the user account is assigned
        /// to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that the user account is assigned
        /// to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServerOutput`](crate::output::UpdateServerOutput)
        pub fn build(self) -> crate::output::UpdateServerOutput {
            crate::output::UpdateServerOutput {
                server_id: self.server_id,
            }
        }
    }
}
impl UpdateServerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServerOutput`](crate::output::UpdateServerOutput)
    pub fn builder() -> crate::output::update_server_output::Builder {
        crate::output::update_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccessOutput {
    /// <p>The ID of the server that the user is attached to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web ServicesTransfer Family.</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl UpdateAccessOutput {
    /// <p>The ID of the server that the user is attached to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web ServicesTransfer Family.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccessOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}
/// See [`UpdateAccessOutput`](crate::output::UpdateAccessOutput)
pub mod update_access_output {
    /// A builder for [`UpdateAccessOutput`](crate::output::UpdateAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the server that the user is attached to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server that the user is attached to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web ServicesTransfer Family.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web ServicesTransfer Family.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAccessOutput`](crate::output::UpdateAccessOutput)
        pub fn build(self) -> crate::output::UpdateAccessOutput {
            crate::output::UpdateAccessOutput {
                server_id: self.server_id,
                external_id: self.external_id,
            }
        }
    }
}
impl UpdateAccessOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccessOutput`](crate::output::UpdateAccessOutput)
    pub fn builder() -> crate::output::update_access_output::Builder {
        crate::output::update_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestIdentityProviderOutput {
    /// <p>The response that is returned from your API Gateway.</p>
    pub response: std::option::Option<std::string::String>,
    /// <p>The HTTP status code that is the response from your API Gateway.</p>
    pub status_code: i32,
    /// <p>A message that indicates whether the test was successful or not.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The endpoint of the service used to authenticate a user.</p>
    pub url: std::option::Option<std::string::String>,
}
impl TestIdentityProviderOutput {
    /// <p>The response that is returned from your API Gateway.</p>
    pub fn response(&self) -> std::option::Option<&str> {
        self.response.as_deref()
    }
    /// <p>The HTTP status code that is the response from your API Gateway.</p>
    pub fn status_code(&self) -> i32 {
        self.status_code
    }
    /// <p>A message that indicates whether the test was successful or not.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The endpoint of the service used to authenticate a user.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for TestIdentityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestIdentityProviderOutput");
        formatter.field("response", &self.response);
        formatter.field("status_code", &self.status_code);
        formatter.field("message", &self.message);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`TestIdentityProviderOutput`](crate::output::TestIdentityProviderOutput)
pub mod test_identity_provider_output {
    /// A builder for [`TestIdentityProviderOutput`](crate::output::TestIdentityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) response: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The response that is returned from your API Gateway.</p>
        pub fn response(mut self, input: impl Into<std::string::String>) -> Self {
            self.response = Some(input.into());
            self
        }
        /// <p>The response that is returned from your API Gateway.</p>
        pub fn set_response(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.response = input;
            self
        }
        /// <p>The HTTP status code that is the response from your API Gateway.</p>
        pub fn status_code(mut self, input: i32) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The HTTP status code that is the response from your API Gateway.</p>
        pub fn set_status_code(mut self, input: std::option::Option<i32>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A message that indicates whether the test was successful or not.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates whether the test was successful or not.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The endpoint of the service used to authenticate a user.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The endpoint of the service used to authenticate a user.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`TestIdentityProviderOutput`](crate::output::TestIdentityProviderOutput)
        pub fn build(self) -> crate::output::TestIdentityProviderOutput {
            crate::output::TestIdentityProviderOutput {
                response: self.response,
                status_code: self.status_code.unwrap_or_default(),
                message: self.message,
                url: self.url,
            }
        }
    }
}
impl TestIdentityProviderOutput {
    /// Creates a new builder-style object to manufacture [`TestIdentityProviderOutput`](crate::output::TestIdentityProviderOutput)
    pub fn builder() -> crate::output::test_identity_provider_output::Builder {
        crate::output::test_identity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopServerOutput {}
impl std::fmt::Debug for StopServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopServerOutput");
        formatter.finish()
    }
}
/// See [`StopServerOutput`](crate::output::StopServerOutput)
pub mod stop_server_output {
    /// A builder for [`StopServerOutput`](crate::output::StopServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopServerOutput`](crate::output::StopServerOutput)
        pub fn build(self) -> crate::output::StopServerOutput {
            crate::output::StopServerOutput {}
        }
    }
}
impl StopServerOutput {
    /// Creates a new builder-style object to manufacture [`StopServerOutput`](crate::output::StopServerOutput)
    pub fn builder() -> crate::output::stop_server_output::Builder {
        crate::output::stop_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartServerOutput {}
impl std::fmt::Debug for StartServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartServerOutput");
        formatter.finish()
    }
}
/// See [`StartServerOutput`](crate::output::StartServerOutput)
pub mod start_server_output {
    /// A builder for [`StartServerOutput`](crate::output::StartServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartServerOutput`](crate::output::StartServerOutput)
        pub fn build(self) -> crate::output::StartServerOutput {
            crate::output::StartServerOutput {}
        }
    }
}
impl StartServerOutput {
    /// Creates a new builder-style object to manufacture [`StartServerOutput`](crate::output::StartServerOutput)
    pub fn builder() -> crate::output::start_server_output::Builder {
        crate::output::start_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendWorkflowStepStateOutput {}
impl std::fmt::Debug for SendWorkflowStepStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendWorkflowStepStateOutput");
        formatter.finish()
    }
}
/// See [`SendWorkflowStepStateOutput`](crate::output::SendWorkflowStepStateOutput)
pub mod send_workflow_step_state_output {
    /// A builder for [`SendWorkflowStepStateOutput`](crate::output::SendWorkflowStepStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SendWorkflowStepStateOutput`](crate::output::SendWorkflowStepStateOutput)
        pub fn build(self) -> crate::output::SendWorkflowStepStateOutput {
            crate::output::SendWorkflowStepStateOutput {}
        }
    }
}
impl SendWorkflowStepStateOutput {
    /// Creates a new builder-style object to manufacture [`SendWorkflowStepStateOutput`](crate::output::SendWorkflowStepStateOutput)
    pub fn builder() -> crate::output::send_workflow_step_state_output::Builder {
        crate::output::send_workflow_step_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkflowsOutput {
    /// <p>
    /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional workflows.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.</p>
    pub workflows: std::option::Option<std::vec::Vec<crate::model::ListedWorkflow>>,
}
impl ListWorkflowsOutput {
    /// <p>
    /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional workflows.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.</p>
    pub fn workflows(&self) -> std::option::Option<&[crate::model::ListedWorkflow]> {
        self.workflows.as_deref()
    }
}
impl std::fmt::Debug for ListWorkflowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkflowsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("workflows", &self.workflows);
        formatter.finish()
    }
}
/// See [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
pub mod list_workflows_output {
    /// A builder for [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workflows: std::option::Option<std::vec::Vec<crate::model::ListedWorkflow>>,
    }
    impl Builder {
        /// <p>
        /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional workflows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>ListWorkflows</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional workflows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `workflows`.
        ///
        /// To override the contents of this collection use [`set_workflows`](Self::set_workflows).
        ///
        /// <p>Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.</p>
        pub fn workflows(mut self, input: impl Into<crate::model::ListedWorkflow>) -> Self {
            let mut v = self.workflows.unwrap_or_default();
            v.push(input.into());
            self.workflows = Some(v);
            self
        }
        /// <p>Returns the <code>Arn</code>, <code>WorkflowId</code>, and <code>Description</code> for each workflow.</p>
        pub fn set_workflows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedWorkflow>>,
        ) -> Self {
            self.workflows = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
        pub fn build(self) -> crate::output::ListWorkflowsOutput {
            crate::output::ListWorkflowsOutput {
                next_token: self.next_token,
                workflows: self.workflows,
            }
        }
    }
}
impl ListWorkflowsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
    pub fn builder() -> crate::output::list_workflows_output::Builder {
        crate::output::list_workflows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersOutput {
    /// <p>When you can get additional results from the <code>ListUsers</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// users.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server that the users are assigned to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>Returns the user accounts and their properties for the <code>ServerId</code> value that
    /// you specify.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::ListedUser>>,
}
impl ListUsersOutput {
    /// <p>When you can get additional results from the <code>ListUsers</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// users.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server that the users are assigned to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>Returns the user accounts and their properties for the <code>ServerId</code> value that
    /// you specify.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::ListedUser]> {
        self.users.as_deref()
    }
}
impl std::fmt::Debug for ListUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("server_id", &self.server_id);
        formatter.field("users", &self.users);
        formatter.finish()
    }
}
/// See [`ListUsersOutput`](crate::output::ListUsersOutput)
pub mod list_users_output {
    /// A builder for [`ListUsersOutput`](crate::output::ListUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::ListedUser>>,
    }
    impl Builder {
        /// <p>When you can get additional results from the <code>ListUsers</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// users.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListUsers</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// users.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server that the users are assigned to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that the users are assigned to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Returns the user accounts and their properties for the <code>ServerId</code> value that
        /// you specify.</p>
        pub fn users(mut self, input: impl Into<crate::model::ListedUser>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>Returns the user accounts and their properties for the <code>ServerId</code> value that
        /// you specify.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedUser>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersOutput`](crate::output::ListUsersOutput)
        pub fn build(self) -> crate::output::ListUsersOutput {
            crate::output::ListUsersOutput {
                next_token: self.next_token,
                server_id: self.server_id,
                users: self.users,
            }
        }
    }
}
impl ListUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersOutput`](crate::output::ListUsersOutput)
    pub fn builder() -> crate::output::list_users_output::Builder {
        crate::output::list_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The ARN you specified to list the tags of.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>When you can get additional results from the <code>ListTagsForResource</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// tags.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and
    /// searching for items. Tags are metadata that you define.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The ARN you specified to list the tags of.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>When you can get additional results from the <code>ListTagsForResource</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// tags.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and
    /// searching for items. Tags are metadata that you define.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("arn", &self.arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN you specified to list the tags of.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN you specified to list the tags of.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>When you can get additional results from the <code>ListTagsForResource</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// tags.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListTagsForResource</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// tags.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and
        /// searching for items. Tags are metadata that you define.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Key-value pairs that are assigned to a resource, usually for the purpose of grouping and
        /// searching for items. Tags are metadata that you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                arn: self.arn,
                next_token: self.next_token,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServersOutput {
    /// <p>When you can get additional results from the <code>ListServers</code> operation, a
    /// <code>NextToken</code> parameter is returned in the output. In a following command, you can
    /// pass in the <code>NextToken</code> parameter to continue listing additional servers.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of servers that were listed.</p>
    pub servers: std::option::Option<std::vec::Vec<crate::model::ListedServer>>,
}
impl ListServersOutput {
    /// <p>When you can get additional results from the <code>ListServers</code> operation, a
    /// <code>NextToken</code> parameter is returned in the output. In a following command, you can
    /// pass in the <code>NextToken</code> parameter to continue listing additional servers.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of servers that were listed.</p>
    pub fn servers(&self) -> std::option::Option<&[crate::model::ListedServer]> {
        self.servers.as_deref()
    }
}
impl std::fmt::Debug for ListServersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServersOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("servers", &self.servers);
        formatter.finish()
    }
}
/// See [`ListServersOutput`](crate::output::ListServersOutput)
pub mod list_servers_output {
    /// A builder for [`ListServersOutput`](crate::output::ListServersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) servers: std::option::Option<std::vec::Vec<crate::model::ListedServer>>,
    }
    impl Builder {
        /// <p>When you can get additional results from the <code>ListServers</code> operation, a
        /// <code>NextToken</code> parameter is returned in the output. In a following command, you can
        /// pass in the <code>NextToken</code> parameter to continue listing additional servers.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListServers</code> operation, a
        /// <code>NextToken</code> parameter is returned in the output. In a following command, you can
        /// pass in the <code>NextToken</code> parameter to continue listing additional servers.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `servers`.
        ///
        /// To override the contents of this collection use [`set_servers`](Self::set_servers).
        ///
        /// <p>An array of servers that were listed.</p>
        pub fn servers(mut self, input: impl Into<crate::model::ListedServer>) -> Self {
            let mut v = self.servers.unwrap_or_default();
            v.push(input.into());
            self.servers = Some(v);
            self
        }
        /// <p>An array of servers that were listed.</p>
        pub fn set_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedServer>>,
        ) -> Self {
            self.servers = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServersOutput`](crate::output::ListServersOutput)
        pub fn build(self) -> crate::output::ListServersOutput {
            crate::output::ListServersOutput {
                next_token: self.next_token,
                servers: self.servers,
            }
        }
    }
}
impl ListServersOutput {
    /// Creates a new builder-style object to manufacture [`ListServersOutput`](crate::output::ListServersOutput)
    pub fn builder() -> crate::output::list_servers_output::Builder {
        crate::output::list_servers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSecurityPoliciesOutput {
    /// <p>When you can get additional results from the <code>ListSecurityPolicies</code> operation,
    /// a <code>NextToken</code> parameter is returned in the output. In a following command, you can
    /// pass in the <code>NextToken</code> parameter to continue listing security policies.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of security policies that were listed.</p>
    pub security_policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListSecurityPoliciesOutput {
    /// <p>When you can get additional results from the <code>ListSecurityPolicies</code> operation,
    /// a <code>NextToken</code> parameter is returned in the output. In a following command, you can
    /// pass in the <code>NextToken</code> parameter to continue listing security policies.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of security policies that were listed.</p>
    pub fn security_policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.security_policy_names.as_deref()
    }
}
impl std::fmt::Debug for ListSecurityPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSecurityPoliciesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("security_policy_names", &self.security_policy_names);
        formatter.finish()
    }
}
/// See [`ListSecurityPoliciesOutput`](crate::output::ListSecurityPoliciesOutput)
pub mod list_security_policies_output {
    /// A builder for [`ListSecurityPoliciesOutput`](crate::output::ListSecurityPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) security_policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>When you can get additional results from the <code>ListSecurityPolicies</code> operation,
        /// a <code>NextToken</code> parameter is returned in the output. In a following command, you can
        /// pass in the <code>NextToken</code> parameter to continue listing security policies.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListSecurityPolicies</code> operation,
        /// a <code>NextToken</code> parameter is returned in the output. In a following command, you can
        /// pass in the <code>NextToken</code> parameter to continue listing security policies.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `security_policy_names`.
        ///
        /// To override the contents of this collection use [`set_security_policy_names`](Self::set_security_policy_names).
        ///
        /// <p>An array of security policies that were listed.</p>
        pub fn security_policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_policy_names.unwrap_or_default();
            v.push(input.into());
            self.security_policy_names = Some(v);
            self
        }
        /// <p>An array of security policies that were listed.</p>
        pub fn set_security_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_policy_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityPoliciesOutput`](crate::output::ListSecurityPoliciesOutput)
        pub fn build(self) -> crate::output::ListSecurityPoliciesOutput {
            crate::output::ListSecurityPoliciesOutput {
                next_token: self.next_token,
                security_policy_names: self.security_policy_names,
            }
        }
    }
}
impl ListSecurityPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListSecurityPoliciesOutput`](crate::output::ListSecurityPoliciesOutput)
    pub fn builder() -> crate::output::list_security_policies_output::Builder {
        crate::output::list_security_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExecutionsOutput {
    /// <p>
    /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional executions.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>Returns the details for each execution.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NextToken</b>: returned from a call to several APIs,
    /// you can use pass it to a subsequent command to continue listing additional executions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>StartTime</b>: timestamp indicating when the execution began.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Executions</b>: details of the execution, including the execution ID, initial file location,
    /// and Service metadata.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Status</b>: one of the following values:
    /// <code>IN_PROGRESS</code>, <code>COMPLETED</code>, <code>EXCEPTION</code>, <code>HANDLING_EXEPTION</code>.
    /// </p>
    /// </li>
    /// </ul>
    pub executions: std::option::Option<std::vec::Vec<crate::model::ListedExecution>>,
}
impl ListExecutionsOutput {
    /// <p>
    /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
    /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
    /// continue listing additional executions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>Returns the details for each execution.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NextToken</b>: returned from a call to several APIs,
    /// you can use pass it to a subsequent command to continue listing additional executions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>StartTime</b>: timestamp indicating when the execution began.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Executions</b>: details of the execution, including the execution ID, initial file location,
    /// and Service metadata.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Status</b>: one of the following values:
    /// <code>IN_PROGRESS</code>, <code>COMPLETED</code>, <code>EXCEPTION</code>, <code>HANDLING_EXEPTION</code>.
    /// </p>
    /// </li>
    /// </ul>
    pub fn executions(&self) -> std::option::Option<&[crate::model::ListedExecution]> {
        self.executions.as_deref()
    }
}
impl std::fmt::Debug for ListExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExecutionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("executions", &self.executions);
        formatter.finish()
    }
}
/// See [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
pub mod list_executions_output {
    /// A builder for [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) executions: std::option::Option<std::vec::Vec<crate::model::ListedExecution>>,
    }
    impl Builder {
        /// <p>
        /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional executions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output.
        /// You can then pass the <code>NextToken</code> parameter in a subsequent command to
        /// continue listing additional executions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Appends an item to `executions`.
        ///
        /// To override the contents of this collection use [`set_executions`](Self::set_executions).
        ///
        /// <p>Returns the details for each execution.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NextToken</b>: returned from a call to several APIs,
        /// you can use pass it to a subsequent command to continue listing additional executions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>StartTime</b>: timestamp indicating when the execution began.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Executions</b>: details of the execution, including the execution ID, initial file location,
        /// and Service metadata.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Status</b>: one of the following values:
        /// <code>IN_PROGRESS</code>, <code>COMPLETED</code>, <code>EXCEPTION</code>, <code>HANDLING_EXEPTION</code>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn executions(mut self, input: impl Into<crate::model::ListedExecution>) -> Self {
            let mut v = self.executions.unwrap_or_default();
            v.push(input.into());
            self.executions = Some(v);
            self
        }
        /// <p>Returns the details for each execution.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NextToken</b>: returned from a call to several APIs,
        /// you can use pass it to a subsequent command to continue listing additional executions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>StartTime</b>: timestamp indicating when the execution began.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Executions</b>: details of the execution, including the execution ID, initial file location,
        /// and Service metadata.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Status</b>: one of the following values:
        /// <code>IN_PROGRESS</code>, <code>COMPLETED</code>, <code>EXCEPTION</code>, <code>HANDLING_EXEPTION</code>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedExecution>>,
        ) -> Self {
            self.executions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
        pub fn build(self) -> crate::output::ListExecutionsOutput {
            crate::output::ListExecutionsOutput {
                next_token: self.next_token,
                workflow_id: self.workflow_id,
                executions: self.executions,
            }
        }
    }
}
impl ListExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListExecutionsOutput`](crate::output::ListExecutionsOutput)
    pub fn builder() -> crate::output::list_executions_output::Builder {
        crate::output::list_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessesOutput {
    /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// accesses.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>Returns the accesses and their properties for the <code>ServerId</code> value that you
    /// specify.</p>
    pub accesses: std::option::Option<std::vec::Vec<crate::model::ListedAccess>>,
}
impl ListAccessesOutput {
    /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
    /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
    /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
    /// accesses.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>Returns the accesses and their properties for the <code>ServerId</code> value that you
    /// specify.</p>
    pub fn accesses(&self) -> std::option::Option<&[crate::model::ListedAccess]> {
        self.accesses.as_deref()
    }
}
impl std::fmt::Debug for ListAccessesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("server_id", &self.server_id);
        formatter.field("accesses", &self.accesses);
        formatter.finish()
    }
}
/// See [`ListAccessesOutput`](crate::output::ListAccessesOutput)
pub mod list_accesses_output {
    /// A builder for [`ListAccessesOutput`](crate::output::ListAccessesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) accesses: std::option::Option<std::vec::Vec<crate::model::ListedAccess>>,
    }
    impl Builder {
        /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// accesses.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When you can get additional results from the <code>ListAccesses</code> call, a
        /// <code>NextToken</code> parameter is returned in the output. You can then pass in a
        /// subsequent command to the <code>NextToken</code> parameter to continue listing additional
        /// accesses.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has users assigned to it.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Appends an item to `accesses`.
        ///
        /// To override the contents of this collection use [`set_accesses`](Self::set_accesses).
        ///
        /// <p>Returns the accesses and their properties for the <code>ServerId</code> value that you
        /// specify.</p>
        pub fn accesses(mut self, input: impl Into<crate::model::ListedAccess>) -> Self {
            let mut v = self.accesses.unwrap_or_default();
            v.push(input.into());
            self.accesses = Some(v);
            self
        }
        /// <p>Returns the accesses and their properties for the <code>ServerId</code> value that you
        /// specify.</p>
        pub fn set_accesses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedAccess>>,
        ) -> Self {
            self.accesses = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessesOutput`](crate::output::ListAccessesOutput)
        pub fn build(self) -> crate::output::ListAccessesOutput {
            crate::output::ListAccessesOutput {
                next_token: self.next_token,
                server_id: self.server_id,
                accesses: self.accesses,
            }
        }
    }
}
impl ListAccessesOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessesOutput`](crate::output::ListAccessesOutput)
    pub fn builder() -> crate::output::list_accesses_output::Builder {
        crate::output::list_accesses_output::Builder::default()
    }
}

/// <p>Identifies the user, the server they belong to, and the identifier of the SSH public key
/// associated with that user. A user can have more than one key on each server that they are
/// associated with.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportSshPublicKeyOutput {
    /// <p>A system-assigned unique identifier for a server.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The name given to a public key by the system that was imported.</p>
    pub ssh_public_key_id: std::option::Option<std::string::String>,
    /// <p>A user name assigned to the <code>ServerID</code> value that you specified.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl ImportSshPublicKeyOutput {
    /// <p>A system-assigned unique identifier for a server.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The name given to a public key by the system that was imported.</p>
    pub fn ssh_public_key_id(&self) -> std::option::Option<&str> {
        self.ssh_public_key_id.as_deref()
    }
    /// <p>A user name assigned to the <code>ServerID</code> value that you specified.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for ImportSshPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportSshPublicKeyOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("ssh_public_key_id", &self.ssh_public_key_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`ImportSshPublicKeyOutput`](crate::output::ImportSshPublicKeyOutput)
pub mod import_ssh_public_key_output {
    /// A builder for [`ImportSshPublicKeyOutput`](crate::output::ImportSshPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The name given to a public key by the system that was imported.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>The name given to a public key by the system that was imported.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// <p>A user name assigned to the <code>ServerID</code> value that you specified.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A user name assigned to the <code>ServerID</code> value that you specified.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportSshPublicKeyOutput`](crate::output::ImportSshPublicKeyOutput)
        pub fn build(self) -> crate::output::ImportSshPublicKeyOutput {
            crate::output::ImportSshPublicKeyOutput {
                server_id: self.server_id,
                ssh_public_key_id: self.ssh_public_key_id,
                user_name: self.user_name,
            }
        }
    }
}
impl ImportSshPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`ImportSshPublicKeyOutput`](crate::output::ImportSshPublicKeyOutput)
    pub fn builder() -> crate::output::import_ssh_public_key_output::Builder {
        crate::output::import_ssh_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkflowOutput {
    /// <p>The structure that contains the details of the workflow.</p>
    pub workflow: std::option::Option<crate::model::DescribedWorkflow>,
}
impl DescribeWorkflowOutput {
    /// <p>The structure that contains the details of the workflow.</p>
    pub fn workflow(&self) -> std::option::Option<&crate::model::DescribedWorkflow> {
        self.workflow.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkflowOutput");
        formatter.field("workflow", &self.workflow);
        formatter.finish()
    }
}
/// See [`DescribeWorkflowOutput`](crate::output::DescribeWorkflowOutput)
pub mod describe_workflow_output {
    /// A builder for [`DescribeWorkflowOutput`](crate::output::DescribeWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow: std::option::Option<crate::model::DescribedWorkflow>,
    }
    impl Builder {
        /// <p>The structure that contains the details of the workflow.</p>
        pub fn workflow(mut self, input: crate::model::DescribedWorkflow) -> Self {
            self.workflow = Some(input);
            self
        }
        /// <p>The structure that contains the details of the workflow.</p>
        pub fn set_workflow(
            mut self,
            input: std::option::Option<crate::model::DescribedWorkflow>,
        ) -> Self {
            self.workflow = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkflowOutput`](crate::output::DescribeWorkflowOutput)
        pub fn build(self) -> crate::output::DescribeWorkflowOutput {
            crate::output::DescribeWorkflowOutput {
                workflow: self.workflow,
            }
        }
    }
}
impl DescribeWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkflowOutput`](crate::output::DescribeWorkflowOutput)
    pub fn builder() -> crate::output::describe_workflow_output::Builder {
        crate::output::describe_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserOutput {
    /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>An array containing the properties of the user account for the <code>ServerID</code> value
    /// that you specified.</p>
    pub user: std::option::Option<crate::model::DescribedUser>,
}
impl DescribeUserOutput {
    /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>An array containing the properties of the user account for the <code>ServerID</code> value
    /// that you specified.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::DescribedUser> {
        self.user.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`DescribeUserOutput`](crate::output::DescribeUserOutput)
pub mod describe_user_output {
    /// A builder for [`DescribeUserOutput`](crate::output::DescribeUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) user: std::option::Option<crate::model::DescribedUser>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this user assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>An array containing the properties of the user account for the <code>ServerID</code> value
        /// that you specified.</p>
        pub fn user(mut self, input: crate::model::DescribedUser) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>An array containing the properties of the user account for the <code>ServerID</code> value
        /// that you specified.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::DescribedUser>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserOutput`](crate::output::DescribeUserOutput)
        pub fn build(self) -> crate::output::DescribeUserOutput {
            crate::output::DescribeUserOutput {
                server_id: self.server_id,
                user: self.user,
            }
        }
    }
}
impl DescribeUserOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserOutput`](crate::output::DescribeUserOutput)
    pub fn builder() -> crate::output::describe_user_output::Builder {
        crate::output::describe_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServerOutput {
    /// <p>An array containing the properties of a server with the <code>ServerID</code> you
    /// specified.</p>
    pub server: std::option::Option<crate::model::DescribedServer>,
}
impl DescribeServerOutput {
    /// <p>An array containing the properties of a server with the <code>ServerID</code> you
    /// specified.</p>
    pub fn server(&self) -> std::option::Option<&crate::model::DescribedServer> {
        self.server.as_ref()
    }
}
impl std::fmt::Debug for DescribeServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServerOutput");
        formatter.field("server", &self.server);
        formatter.finish()
    }
}
/// See [`DescribeServerOutput`](crate::output::DescribeServerOutput)
pub mod describe_server_output {
    /// A builder for [`DescribeServerOutput`](crate::output::DescribeServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server: std::option::Option<crate::model::DescribedServer>,
    }
    impl Builder {
        /// <p>An array containing the properties of a server with the <code>ServerID</code> you
        /// specified.</p>
        pub fn server(mut self, input: crate::model::DescribedServer) -> Self {
            self.server = Some(input);
            self
        }
        /// <p>An array containing the properties of a server with the <code>ServerID</code> you
        /// specified.</p>
        pub fn set_server(
            mut self,
            input: std::option::Option<crate::model::DescribedServer>,
        ) -> Self {
            self.server = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServerOutput`](crate::output::DescribeServerOutput)
        pub fn build(self) -> crate::output::DescribeServerOutput {
            crate::output::DescribeServerOutput {
                server: self.server,
            }
        }
    }
}
impl DescribeServerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServerOutput`](crate::output::DescribeServerOutput)
    pub fn builder() -> crate::output::describe_server_output::Builder {
        crate::output::describe_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSecurityPolicyOutput {
    /// <p>An array containing the properties of the security policy.</p>
    pub security_policy: std::option::Option<crate::model::DescribedSecurityPolicy>,
}
impl DescribeSecurityPolicyOutput {
    /// <p>An array containing the properties of the security policy.</p>
    pub fn security_policy(&self) -> std::option::Option<&crate::model::DescribedSecurityPolicy> {
        self.security_policy.as_ref()
    }
}
impl std::fmt::Debug for DescribeSecurityPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSecurityPolicyOutput");
        formatter.field("security_policy", &self.security_policy);
        formatter.finish()
    }
}
/// See [`DescribeSecurityPolicyOutput`](crate::output::DescribeSecurityPolicyOutput)
pub mod describe_security_policy_output {
    /// A builder for [`DescribeSecurityPolicyOutput`](crate::output::DescribeSecurityPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_policy: std::option::Option<crate::model::DescribedSecurityPolicy>,
    }
    impl Builder {
        /// <p>An array containing the properties of the security policy.</p>
        pub fn security_policy(mut self, input: crate::model::DescribedSecurityPolicy) -> Self {
            self.security_policy = Some(input);
            self
        }
        /// <p>An array containing the properties of the security policy.</p>
        pub fn set_security_policy(
            mut self,
            input: std::option::Option<crate::model::DescribedSecurityPolicy>,
        ) -> Self {
            self.security_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecurityPolicyOutput`](crate::output::DescribeSecurityPolicyOutput)
        pub fn build(self) -> crate::output::DescribeSecurityPolicyOutput {
            crate::output::DescribeSecurityPolicyOutput {
                security_policy: self.security_policy,
            }
        }
    }
}
impl DescribeSecurityPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityPolicyOutput`](crate::output::DescribeSecurityPolicyOutput)
    pub fn builder() -> crate::output::describe_security_policy_output::Builder {
        crate::output::describe_security_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExecutionOutput {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The structure that contains the details of the workflow' execution.</p>
    pub execution: std::option::Option<crate::model::DescribedExecution>,
}
impl DescribeExecutionOutput {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The structure that contains the details of the workflow' execution.</p>
    pub fn execution(&self) -> std::option::Option<&crate::model::DescribedExecution> {
        self.execution.as_ref()
    }
}
impl std::fmt::Debug for DescribeExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExecutionOutput");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("execution", &self.execution);
        formatter.finish()
    }
}
/// See [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
pub mod describe_execution_output {
    /// A builder for [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) execution: std::option::Option<crate::model::DescribedExecution>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The structure that contains the details of the workflow' execution.</p>
        pub fn execution(mut self, input: crate::model::DescribedExecution) -> Self {
            self.execution = Some(input);
            self
        }
        /// <p>The structure that contains the details of the workflow' execution.</p>
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::DescribedExecution>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
        pub fn build(self) -> crate::output::DescribeExecutionOutput {
            crate::output::DescribeExecutionOutput {
                workflow_id: self.workflow_id,
                execution: self.execution,
            }
        }
    }
}
impl DescribeExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExecutionOutput`](crate::output::DescribeExecutionOutput)
    pub fn builder() -> crate::output::describe_execution_output::Builder {
        crate::output::describe_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccessOutput {
    /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The external ID of the server that the access is attached to.</p>
    pub access: std::option::Option<crate::model::DescribedAccess>,
}
impl DescribeAccessOutput {
    /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The external ID of the server that the access is attached to.</p>
    pub fn access(&self) -> std::option::Option<&crate::model::DescribedAccess> {
        self.access.as_ref()
    }
}
impl std::fmt::Debug for DescribeAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccessOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("access", &self.access);
        formatter.finish()
    }
}
/// See [`DescribeAccessOutput`](crate::output::DescribeAccessOutput)
pub mod describe_access_output {
    /// A builder for [`DescribeAccessOutput`](crate::output::DescribeAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) access: std::option::Option<crate::model::DescribedAccess>,
    }
    impl Builder {
        /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>A system-assigned unique identifier for a server that has this access assigned.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The external ID of the server that the access is attached to.</p>
        pub fn access(mut self, input: crate::model::DescribedAccess) -> Self {
            self.access = Some(input);
            self
        }
        /// <p>The external ID of the server that the access is attached to.</p>
        pub fn set_access(
            mut self,
            input: std::option::Option<crate::model::DescribedAccess>,
        ) -> Self {
            self.access = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccessOutput`](crate::output::DescribeAccessOutput)
        pub fn build(self) -> crate::output::DescribeAccessOutput {
            crate::output::DescribeAccessOutput {
                server_id: self.server_id,
                access: self.access,
            }
        }
    }
}
impl DescribeAccessOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccessOutput`](crate::output::DescribeAccessOutput)
    pub fn builder() -> crate::output::describe_access_output::Builder {
        crate::output::describe_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkflowOutput {}
impl std::fmt::Debug for DeleteWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkflowOutput");
        formatter.finish()
    }
}
/// See [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
pub mod delete_workflow_output {
    /// A builder for [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
        pub fn build(self) -> crate::output::DeleteWorkflowOutput {
            crate::output::DeleteWorkflowOutput {}
        }
    }
}
impl DeleteWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
    pub fn builder() -> crate::output::delete_workflow_output::Builder {
        crate::output::delete_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {}
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSshPublicKeyOutput {}
impl std::fmt::Debug for DeleteSshPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSshPublicKeyOutput");
        formatter.finish()
    }
}
/// See [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
pub mod delete_ssh_public_key_output {
    /// A builder for [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
        pub fn build(self) -> crate::output::DeleteSshPublicKeyOutput {
            crate::output::DeleteSshPublicKeyOutput {}
        }
    }
}
impl DeleteSshPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
    pub fn builder() -> crate::output::delete_ssh_public_key_output::Builder {
        crate::output::delete_ssh_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServerOutput {}
impl std::fmt::Debug for DeleteServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServerOutput");
        formatter.finish()
    }
}
/// See [`DeleteServerOutput`](crate::output::DeleteServerOutput)
pub mod delete_server_output {
    /// A builder for [`DeleteServerOutput`](crate::output::DeleteServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServerOutput`](crate::output::DeleteServerOutput)
        pub fn build(self) -> crate::output::DeleteServerOutput {
            crate::output::DeleteServerOutput {}
        }
    }
}
impl DeleteServerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServerOutput`](crate::output::DeleteServerOutput)
    pub fn builder() -> crate::output::delete_server_output::Builder {
        crate::output::delete_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessOutput {}
impl std::fmt::Debug for DeleteAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessOutput`](crate::output::DeleteAccessOutput)
pub mod delete_access_output {
    /// A builder for [`DeleteAccessOutput`](crate::output::DeleteAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessOutput`](crate::output::DeleteAccessOutput)
        pub fn build(self) -> crate::output::DeleteAccessOutput {
            crate::output::DeleteAccessOutput {}
        }
    }
}
impl DeleteAccessOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessOutput`](crate::output::DeleteAccessOutput)
    pub fn builder() -> crate::output::delete_access_output::Builder {
        crate::output::delete_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkflowOutput {
    /// <p>A unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl CreateWorkflowOutput {
    /// <p>A unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkflowOutput");
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}
/// See [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
pub mod create_workflow_output {
    /// A builder for [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
        pub fn build(self) -> crate::output::CreateWorkflowOutput {
            crate::output::CreateWorkflowOutput {
                workflow_id: self.workflow_id,
            }
        }
    }
}
impl CreateWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
    pub fn builder() -> crate::output::create_workflow_output::Builder {
        crate::output::create_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {
    /// <p>The ID of the server that the user is attached to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies a user account associated with a server.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl CreateUserOutput {
    /// <p>The ID of the server that the user is attached to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>A unique string that identifies a user account associated with a server.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the server that the user is attached to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server that the user is attached to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>A unique string that identifies a user account associated with a server.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>A unique string that identifies a user account associated with a server.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput {
                server_id: self.server_id,
                user_name: self.user_name,
            }
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServerOutput {
    /// <p>The service-assigned ID of the server that is created.</p>
    pub server_id: std::option::Option<std::string::String>,
}
impl CreateServerOutput {
    /// <p>The service-assigned ID of the server that is created.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
}
impl std::fmt::Debug for CreateServerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServerOutput");
        formatter.field("server_id", &self.server_id);
        formatter.finish()
    }
}
/// See [`CreateServerOutput`](crate::output::CreateServerOutput)
pub mod create_server_output {
    /// A builder for [`CreateServerOutput`](crate::output::CreateServerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service-assigned ID of the server that is created.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The service-assigned ID of the server that is created.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServerOutput`](crate::output::CreateServerOutput)
        pub fn build(self) -> crate::output::CreateServerOutput {
            crate::output::CreateServerOutput {
                server_id: self.server_id,
            }
        }
    }
}
impl CreateServerOutput {
    /// Creates a new builder-style object to manufacture [`CreateServerOutput`](crate::output::CreateServerOutput)
    pub fn builder() -> crate::output::create_server_output::Builder {
        crate::output::create_server_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessOutput {
    /// <p>The ID of the server that the user is attached to.</p>
    pub server_id: std::option::Option<std::string::String>,
    /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family.</p>
    pub external_id: std::option::Option<std::string::String>,
}
impl CreateAccessOutput {
    /// <p>The ID of the server that the user is attached to.</p>
    pub fn server_id(&self) -> std::option::Option<&str> {
        self.server_id.as_deref()
    }
    /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
    /// resources over the enabled protocols using Amazon Web Services Transfer Family.</p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessOutput");
        formatter.field("server_id", &self.server_id);
        formatter.field("external_id", &self.external_id);
        formatter.finish()
    }
}
/// See [`CreateAccessOutput`](crate::output::CreateAccessOutput)
pub mod create_access_output {
    /// A builder for [`CreateAccessOutput`](crate::output::CreateAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_id: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the server that the user is attached to.</p>
        pub fn server_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_id = Some(input.into());
            self
        }
        /// <p>The ID of the server that the user is attached to.</p>
        pub fn set_server_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_id = input;
            self
        }
        /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID of the group whose users have access to your Amazon S3 or Amazon EFS
        /// resources over the enabled protocols using Amazon Web Services Transfer Family.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessOutput`](crate::output::CreateAccessOutput)
        pub fn build(self) -> crate::output::CreateAccessOutput {
            crate::output::CreateAccessOutput {
                server_id: self.server_id,
                external_id: self.external_id,
            }
        }
    }
}
impl CreateAccessOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessOutput`](crate::output::CreateAccessOutput)
    pub fn builder() -> crate::output::create_access_output::Builder {
        crate::output::create_access_output::Builder::default()
    }
}
