// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct StartStreamTranscriptionOutput {
    /// <p>An identifier for the streaming transcription.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The language code of the input audio stream.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The sample rate, in Hertz (Hz), for the input audio stream. Use 8,000 Hz for low quality audio and 16,000 Hz or higher for high quality audio.</p>
    pub media_sample_rate_hertz: std::option::Option<i32>,
    /// <p>The encoding used for the input audio stream.</p>
    pub media_encoding: std::option::Option<crate::model::MediaEncoding>,
    /// <p>The name of the vocabulary used when processing the stream.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>An identifier for a specific transcription session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>Represents the stream of transcription events from Amazon Transcribe to your application.</p>
    pub transcript_result_stream: aws_smithy_http::event_stream::Receiver<
        crate::model::TranscriptResultStream,
        crate::error::StartStreamTranscriptionError,
    >,
    /// <p>The name of the vocabulary filter used in your media stream.</p>
    pub vocabulary_filter_name: std::option::Option<std::string::String>,
    /// <p>The vocabulary filtering method used in the media stream.</p>
    pub vocabulary_filter_method: std::option::Option<crate::model::VocabularyFilterMethod>,
    /// <p>Shows whether speaker identification was enabled in the stream.</p>
    pub show_speaker_label: bool,
    /// <p>Shows whether channel identification has been enabled in the stream.</p>
    pub enable_channel_identification: bool,
    /// <p>The number of channels identified in the stream.</p>
    pub number_of_channels: std::option::Option<i32>,
    /// <p>Shows whether partial results stabilization has been enabled in the stream.</p>
    pub enable_partial_results_stabilization: bool,
    /// <p>If partial results stabilization has been enabled in the stream, shows the stability level.</p>
    pub partial_results_stability: std::option::Option<crate::model::PartialResultsStability>,
    /// <p>Shows whether content identification was enabled in this stream.</p>
    pub content_identification_type: std::option::Option<crate::model::ContentIdentificationType>,
    /// <p>Shows whether content redaction was enabled in this stream.</p>
    pub content_redaction_type: std::option::Option<crate::model::ContentRedactionType>,
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub pii_entity_types: std::option::Option<std::string::String>,
    /// <p>The name of the language model used in your media stream.</p>
    pub language_model_name: std::option::Option<std::string::String>,
    /// <p>The language code of the language identified in your media stream.</p>
    pub identify_language: bool,
    /// <p>The language codes used in the identification of your media stream's predominant language.</p>
    pub language_options: std::option::Option<std::string::String>,
    /// <p>The preferred language you specified in your request.</p>
    pub preferred_language: std::option::Option<crate::model::LanguageCode>,
}
impl StartStreamTranscriptionOutput {
    /// <p>An identifier for the streaming transcription.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The language code of the input audio stream.</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The sample rate, in Hertz (Hz), for the input audio stream. Use 8,000 Hz for low quality audio and 16,000 Hz or higher for high quality audio.</p>
    pub fn media_sample_rate_hertz(&self) -> std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>The encoding used for the input audio stream.</p>
    pub fn media_encoding(&self) -> std::option::Option<&crate::model::MediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>The name of the vocabulary used when processing the stream.</p>
    pub fn vocabulary_name(&self) -> std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>An identifier for a specific transcription session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>Represents the stream of transcription events from Amazon Transcribe to your application.</p>
    pub fn transcript_result_stream(
        &self,
    ) -> &aws_smithy_http::event_stream::Receiver<
        crate::model::TranscriptResultStream,
        crate::error::StartStreamTranscriptionError,
    > {
        &self.transcript_result_stream
    }
    /// <p>The name of the vocabulary filter used in your media stream.</p>
    pub fn vocabulary_filter_name(&self) -> std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>The vocabulary filtering method used in the media stream.</p>
    pub fn vocabulary_filter_method(
        &self,
    ) -> std::option::Option<&crate::model::VocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>Shows whether speaker identification was enabled in the stream.</p>
    pub fn show_speaker_label(&self) -> bool {
        self.show_speaker_label
    }
    /// <p>Shows whether channel identification has been enabled in the stream.</p>
    pub fn enable_channel_identification(&self) -> bool {
        self.enable_channel_identification
    }
    /// <p>The number of channels identified in the stream.</p>
    pub fn number_of_channels(&self) -> std::option::Option<i32> {
        self.number_of_channels
    }
    /// <p>Shows whether partial results stabilization has been enabled in the stream.</p>
    pub fn enable_partial_results_stabilization(&self) -> bool {
        self.enable_partial_results_stabilization
    }
    /// <p>If partial results stabilization has been enabled in the stream, shows the stability level.</p>
    pub fn partial_results_stability(
        &self,
    ) -> std::option::Option<&crate::model::PartialResultsStability> {
        self.partial_results_stability.as_ref()
    }
    /// <p>Shows whether content identification was enabled in this stream.</p>
    pub fn content_identification_type(
        &self,
    ) -> std::option::Option<&crate::model::ContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
    /// <p>Shows whether content redaction was enabled in this stream.</p>
    pub fn content_redaction_type(
        &self,
    ) -> std::option::Option<&crate::model::ContentRedactionType> {
        self.content_redaction_type.as_ref()
    }
    /// <p>Lists the PII entity types you specified in your request.</p>
    pub fn pii_entity_types(&self) -> std::option::Option<&str> {
        self.pii_entity_types.as_deref()
    }
    /// <p>The name of the language model used in your media stream.</p>
    pub fn language_model_name(&self) -> std::option::Option<&str> {
        self.language_model_name.as_deref()
    }
    /// <p>The language code of the language identified in your media stream.</p>
    pub fn identify_language(&self) -> bool {
        self.identify_language
    }
    /// <p>The language codes used in the identification of your media stream's predominant language.</p>
    pub fn language_options(&self) -> std::option::Option<&str> {
        self.language_options.as_deref()
    }
    /// <p>The preferred language you specified in your request.</p>
    pub fn preferred_language(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.preferred_language.as_ref()
    }
}
impl std::fmt::Debug for StartStreamTranscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStreamTranscriptionOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("language_code", &self.language_code);
        formatter.field("media_sample_rate_hertz", &self.media_sample_rate_hertz);
        formatter.field("media_encoding", &self.media_encoding);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("session_id", &self.session_id);
        formatter.field("transcript_result_stream", &self.transcript_result_stream);
        formatter.field("vocabulary_filter_name", &self.vocabulary_filter_name);
        formatter.field("vocabulary_filter_method", &self.vocabulary_filter_method);
        formatter.field("show_speaker_label", &self.show_speaker_label);
        formatter.field(
            "enable_channel_identification",
            &self.enable_channel_identification,
        );
        formatter.field("number_of_channels", &self.number_of_channels);
        formatter.field(
            "enable_partial_results_stabilization",
            &self.enable_partial_results_stabilization,
        );
        formatter.field("partial_results_stability", &self.partial_results_stability);
        formatter.field(
            "content_identification_type",
            &self.content_identification_type,
        );
        formatter.field("content_redaction_type", &self.content_redaction_type);
        formatter.field("pii_entity_types", &self.pii_entity_types);
        formatter.field("language_model_name", &self.language_model_name);
        formatter.field("identify_language", &self.identify_language);
        formatter.field("language_options", &self.language_options);
        formatter.field("preferred_language", &self.preferred_language);
        formatter.finish()
    }
}
/// See [`StartStreamTranscriptionOutput`](crate::output::StartStreamTranscriptionOutput)
pub mod start_stream_transcription_output {
    /// A builder for [`StartStreamTranscriptionOutput`](crate::output::StartStreamTranscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) media_sample_rate_hertz: std::option::Option<i32>,
        pub(crate) media_encoding: std::option::Option<crate::model::MediaEncoding>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) transcript_result_stream: std::option::Option<
            aws_smithy_http::event_stream::Receiver<
                crate::model::TranscriptResultStream,
                crate::error::StartStreamTranscriptionError,
            >,
        >,
        pub(crate) vocabulary_filter_name: std::option::Option<std::string::String>,
        pub(crate) vocabulary_filter_method:
            std::option::Option<crate::model::VocabularyFilterMethod>,
        pub(crate) show_speaker_label: std::option::Option<bool>,
        pub(crate) enable_channel_identification: std::option::Option<bool>,
        pub(crate) number_of_channels: std::option::Option<i32>,
        pub(crate) enable_partial_results_stabilization: std::option::Option<bool>,
        pub(crate) partial_results_stability:
            std::option::Option<crate::model::PartialResultsStability>,
        pub(crate) content_identification_type:
            std::option::Option<crate::model::ContentIdentificationType>,
        pub(crate) content_redaction_type: std::option::Option<crate::model::ContentRedactionType>,
        pub(crate) pii_entity_types: std::option::Option<std::string::String>,
        pub(crate) language_model_name: std::option::Option<std::string::String>,
        pub(crate) identify_language: std::option::Option<bool>,
        pub(crate) language_options: std::option::Option<std::string::String>,
        pub(crate) preferred_language: std::option::Option<crate::model::LanguageCode>,
    }
    impl Builder {
        /// <p>An identifier for the streaming transcription.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>An identifier for the streaming transcription.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The language code of the input audio stream.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the input audio stream.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The sample rate, in Hertz (Hz), for the input audio stream. Use 8,000 Hz for low quality audio and 16,000 Hz or higher for high quality audio.</p>
        pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
            self.media_sample_rate_hertz = Some(input);
            self
        }
        /// <p>The sample rate, in Hertz (Hz), for the input audio stream. Use 8,000 Hz for low quality audio and 16,000 Hz or higher for high quality audio.</p>
        pub fn set_media_sample_rate_hertz(mut self, input: std::option::Option<i32>) -> Self {
            self.media_sample_rate_hertz = input;
            self
        }
        /// <p>The encoding used for the input audio stream.</p>
        pub fn media_encoding(mut self, input: crate::model::MediaEncoding) -> Self {
            self.media_encoding = Some(input);
            self
        }
        /// <p>The encoding used for the input audio stream.</p>
        pub fn set_media_encoding(
            mut self,
            input: std::option::Option<crate::model::MediaEncoding>,
        ) -> Self {
            self.media_encoding = input;
            self
        }
        /// <p>The name of the vocabulary used when processing the stream.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary used when processing the stream.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>An identifier for a specific transcription session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>An identifier for a specific transcription session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>Represents the stream of transcription events from Amazon Transcribe to your application.</p>
        pub fn transcript_result_stream(
            mut self,
            input: aws_smithy_http::event_stream::Receiver<
                crate::model::TranscriptResultStream,
                crate::error::StartStreamTranscriptionError,
            >,
        ) -> Self {
            self.transcript_result_stream = Some(input);
            self
        }
        /// <p>Represents the stream of transcription events from Amazon Transcribe to your application.</p>
        pub fn set_transcript_result_stream(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::Receiver<
                    crate::model::TranscriptResultStream,
                    crate::error::StartStreamTranscriptionError,
                >,
            >,
        ) -> Self {
            self.transcript_result_stream = input;
            self
        }
        /// <p>The name of the vocabulary filter used in your media stream.</p>
        pub fn vocabulary_filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_filter_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary filter used in your media stream.</p>
        pub fn set_vocabulary_filter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_filter_name = input;
            self
        }
        /// <p>The vocabulary filtering method used in the media stream.</p>
        pub fn vocabulary_filter_method(
            mut self,
            input: crate::model::VocabularyFilterMethod,
        ) -> Self {
            self.vocabulary_filter_method = Some(input);
            self
        }
        /// <p>The vocabulary filtering method used in the media stream.</p>
        pub fn set_vocabulary_filter_method(
            mut self,
            input: std::option::Option<crate::model::VocabularyFilterMethod>,
        ) -> Self {
            self.vocabulary_filter_method = input;
            self
        }
        /// <p>Shows whether speaker identification was enabled in the stream.</p>
        pub fn show_speaker_label(mut self, input: bool) -> Self {
            self.show_speaker_label = Some(input);
            self
        }
        /// <p>Shows whether speaker identification was enabled in the stream.</p>
        pub fn set_show_speaker_label(mut self, input: std::option::Option<bool>) -> Self {
            self.show_speaker_label = input;
            self
        }
        /// <p>Shows whether channel identification has been enabled in the stream.</p>
        pub fn enable_channel_identification(mut self, input: bool) -> Self {
            self.enable_channel_identification = Some(input);
            self
        }
        /// <p>Shows whether channel identification has been enabled in the stream.</p>
        pub fn set_enable_channel_identification(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_channel_identification = input;
            self
        }
        /// <p>The number of channels identified in the stream.</p>
        pub fn number_of_channels(mut self, input: i32) -> Self {
            self.number_of_channels = Some(input);
            self
        }
        /// <p>The number of channels identified in the stream.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_channels = input;
            self
        }
        /// <p>Shows whether partial results stabilization has been enabled in the stream.</p>
        pub fn enable_partial_results_stabilization(mut self, input: bool) -> Self {
            self.enable_partial_results_stabilization = Some(input);
            self
        }
        /// <p>Shows whether partial results stabilization has been enabled in the stream.</p>
        pub fn set_enable_partial_results_stabilization(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_partial_results_stabilization = input;
            self
        }
        /// <p>If partial results stabilization has been enabled in the stream, shows the stability level.</p>
        pub fn partial_results_stability(
            mut self,
            input: crate::model::PartialResultsStability,
        ) -> Self {
            self.partial_results_stability = Some(input);
            self
        }
        /// <p>If partial results stabilization has been enabled in the stream, shows the stability level.</p>
        pub fn set_partial_results_stability(
            mut self,
            input: std::option::Option<crate::model::PartialResultsStability>,
        ) -> Self {
            self.partial_results_stability = input;
            self
        }
        /// <p>Shows whether content identification was enabled in this stream.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::ContentIdentificationType,
        ) -> Self {
            self.content_identification_type = Some(input);
            self
        }
        /// <p>Shows whether content identification was enabled in this stream.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::ContentIdentificationType>,
        ) -> Self {
            self.content_identification_type = input;
            self
        }
        /// <p>Shows whether content redaction was enabled in this stream.</p>
        pub fn content_redaction_type(mut self, input: crate::model::ContentRedactionType) -> Self {
            self.content_redaction_type = Some(input);
            self
        }
        /// <p>Shows whether content redaction was enabled in this stream.</p>
        pub fn set_content_redaction_type(
            mut self,
            input: std::option::Option<crate::model::ContentRedactionType>,
        ) -> Self {
            self.content_redaction_type = input;
            self
        }
        /// <p>Lists the PII entity types you specified in your request.</p>
        pub fn pii_entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.pii_entity_types = Some(input.into());
            self
        }
        /// <p>Lists the PII entity types you specified in your request.</p>
        pub fn set_pii_entity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pii_entity_types = input;
            self
        }
        /// <p>The name of the language model used in your media stream.</p>
        pub fn language_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_model_name = Some(input.into());
            self
        }
        /// <p>The name of the language model used in your media stream.</p>
        pub fn set_language_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_model_name = input;
            self
        }
        /// <p>The language code of the language identified in your media stream.</p>
        pub fn identify_language(mut self, input: bool) -> Self {
            self.identify_language = Some(input);
            self
        }
        /// <p>The language code of the language identified in your media stream.</p>
        pub fn set_identify_language(mut self, input: std::option::Option<bool>) -> Self {
            self.identify_language = input;
            self
        }
        /// <p>The language codes used in the identification of your media stream's predominant language.</p>
        pub fn language_options(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_options = Some(input.into());
            self
        }
        /// <p>The language codes used in the identification of your media stream's predominant language.</p>
        pub fn set_language_options(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_options = input;
            self
        }
        /// <p>The preferred language you specified in your request.</p>
        pub fn preferred_language(mut self, input: crate::model::LanguageCode) -> Self {
            self.preferred_language = Some(input);
            self
        }
        /// <p>The preferred language you specified in your request.</p>
        pub fn set_preferred_language(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.preferred_language = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStreamTranscriptionOutput`](crate::output::StartStreamTranscriptionOutput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::output::StartStreamTranscriptionOutput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::output::StartStreamTranscriptionOutput {
                    request_id: self.request_id
                    ,
                    language_code: self.language_code
                    ,
                    media_sample_rate_hertz: self.media_sample_rate_hertz
                    ,
                    media_encoding: self.media_encoding
                    ,
                    vocabulary_name: self.vocabulary_name
                    ,
                    session_id: self.session_id
                    ,
                    transcript_result_stream: self.transcript_result_stream
                        .ok_or(
                            aws_smithy_http::operation::BuildError::MissingField { field: "transcript_result_stream", details: "transcript_result_stream was not specified but it is required when building StartStreamTranscriptionOutput"}
                        )?
                    ,
                    vocabulary_filter_name: self.vocabulary_filter_name
                    ,
                    vocabulary_filter_method: self.vocabulary_filter_method
                    ,
                    show_speaker_label: self.show_speaker_label
                        .unwrap_or_default()
                    ,
                    enable_channel_identification: self.enable_channel_identification
                        .unwrap_or_default()
                    ,
                    number_of_channels: self.number_of_channels
                    ,
                    enable_partial_results_stabilization: self.enable_partial_results_stabilization
                        .unwrap_or_default()
                    ,
                    partial_results_stability: self.partial_results_stability
                    ,
                    content_identification_type: self.content_identification_type
                    ,
                    content_redaction_type: self.content_redaction_type
                    ,
                    pii_entity_types: self.pii_entity_types
                    ,
                    language_model_name: self.language_model_name
                    ,
                    identify_language: self.identify_language
                        .unwrap_or_default()
                    ,
                    language_options: self.language_options
                    ,
                    preferred_language: self.preferred_language
                    ,
                }
            )
        }
    }
}
impl StartStreamTranscriptionOutput {
    /// Creates a new builder-style object to manufacture [`StartStreamTranscriptionOutput`](crate::output::StartStreamTranscriptionOutput)
    pub fn builder() -> crate::output::start_stream_transcription_output::Builder {
        crate::output::start_stream_transcription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct StartMedicalStreamTranscriptionOutput {
    /// <p>An identifier for the streaming transcription.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The sample rate of the input audio in Hertz.</p>
    pub media_sample_rate_hertz: std::option::Option<i32>,
    /// <p>The encoding used for the input audio stream.</p>
    pub media_encoding: std::option::Option<crate::model::MediaEncoding>,
    /// <p>The name of the vocabulary used when processing the stream.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>The specialty in the medical domain.</p>
    pub specialty: std::option::Option<crate::model::Specialty>,
    /// <p>The type of audio that was transcribed. </p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>Shows whether speaker identification was enabled in the stream.</p>
    pub show_speaker_label: bool,
    /// <p>Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>Represents the stream of transcription events from Amazon Transcribe Medical to your application. </p>
    pub transcript_result_stream: aws_smithy_http::event_stream::Receiver<
        crate::model::MedicalTranscriptResultStream,
        crate::error::StartMedicalStreamTranscriptionError,
    >,
    /// <p>Shows whether channel identification has been enabled in the stream.</p>
    pub enable_channel_identification: bool,
    /// <p>The number of channels identified in the stream.</p>
    pub number_of_channels: std::option::Option<i32>,
    /// <p>If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health information.</p>
    pub content_identification_type:
        std::option::Option<crate::model::MedicalContentIdentificationType>,
}
impl StartMedicalStreamTranscriptionOutput {
    /// <p>An identifier for the streaming transcription.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).</p>
    pub fn language_code(&self) -> std::option::Option<&crate::model::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The sample rate of the input audio in Hertz.</p>
    pub fn media_sample_rate_hertz(&self) -> std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>The encoding used for the input audio stream.</p>
    pub fn media_encoding(&self) -> std::option::Option<&crate::model::MediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>The name of the vocabulary used when processing the stream.</p>
    pub fn vocabulary_name(&self) -> std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>The specialty in the medical domain.</p>
    pub fn specialty(&self) -> std::option::Option<&crate::model::Specialty> {
        self.specialty.as_ref()
    }
    /// <p>The type of audio that was transcribed. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
    /// <p>Shows whether speaker identification was enabled in the stream.</p>
    pub fn show_speaker_label(&self) -> bool {
        self.show_speaker_label
    }
    /// <p>Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>Represents the stream of transcription events from Amazon Transcribe Medical to your application. </p>
    pub fn transcript_result_stream(
        &self,
    ) -> &aws_smithy_http::event_stream::Receiver<
        crate::model::MedicalTranscriptResultStream,
        crate::error::StartMedicalStreamTranscriptionError,
    > {
        &self.transcript_result_stream
    }
    /// <p>Shows whether channel identification has been enabled in the stream.</p>
    pub fn enable_channel_identification(&self) -> bool {
        self.enable_channel_identification
    }
    /// <p>The number of channels identified in the stream.</p>
    pub fn number_of_channels(&self) -> std::option::Option<i32> {
        self.number_of_channels
    }
    /// <p>If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health information.</p>
    pub fn content_identification_type(
        &self,
    ) -> std::option::Option<&crate::model::MedicalContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
}
impl std::fmt::Debug for StartMedicalStreamTranscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMedicalStreamTranscriptionOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("language_code", &self.language_code);
        formatter.field("media_sample_rate_hertz", &self.media_sample_rate_hertz);
        formatter.field("media_encoding", &self.media_encoding);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("specialty", &self.specialty);
        formatter.field("r#type", &self.r#type);
        formatter.field("show_speaker_label", &self.show_speaker_label);
        formatter.field("session_id", &self.session_id);
        formatter.field("transcript_result_stream", &self.transcript_result_stream);
        formatter.field(
            "enable_channel_identification",
            &self.enable_channel_identification,
        );
        formatter.field("number_of_channels", &self.number_of_channels);
        formatter.field(
            "content_identification_type",
            &self.content_identification_type,
        );
        formatter.finish()
    }
}
/// See [`StartMedicalStreamTranscriptionOutput`](crate::output::StartMedicalStreamTranscriptionOutput)
pub mod start_medical_stream_transcription_output {
    /// A builder for [`StartMedicalStreamTranscriptionOutput`](crate::output::StartMedicalStreamTranscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) media_sample_rate_hertz: std::option::Option<i32>,
        pub(crate) media_encoding: std::option::Option<crate::model::MediaEncoding>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) specialty: std::option::Option<crate::model::Specialty>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) show_speaker_label: std::option::Option<bool>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) transcript_result_stream: std::option::Option<
            aws_smithy_http::event_stream::Receiver<
                crate::model::MedicalTranscriptResultStream,
                crate::error::StartMedicalStreamTranscriptionError,
            >,
        >,
        pub(crate) enable_channel_identification: std::option::Option<bool>,
        pub(crate) number_of_channels: std::option::Option<i32>,
        pub(crate) content_identification_type:
            std::option::Option<crate::model::MedicalContentIdentificationType>,
    }
    impl Builder {
        /// <p>An identifier for the streaming transcription.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>An identifier for the streaming transcription.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The sample rate of the input audio in Hertz.</p>
        pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
            self.media_sample_rate_hertz = Some(input);
            self
        }
        /// <p>The sample rate of the input audio in Hertz.</p>
        pub fn set_media_sample_rate_hertz(mut self, input: std::option::Option<i32>) -> Self {
            self.media_sample_rate_hertz = input;
            self
        }
        /// <p>The encoding used for the input audio stream.</p>
        pub fn media_encoding(mut self, input: crate::model::MediaEncoding) -> Self {
            self.media_encoding = Some(input);
            self
        }
        /// <p>The encoding used for the input audio stream.</p>
        pub fn set_media_encoding(
            mut self,
            input: std::option::Option<crate::model::MediaEncoding>,
        ) -> Self {
            self.media_encoding = input;
            self
        }
        /// <p>The name of the vocabulary used when processing the stream.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary used when processing the stream.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The specialty in the medical domain.</p>
        pub fn specialty(mut self, input: crate::model::Specialty) -> Self {
            self.specialty = Some(input);
            self
        }
        /// <p>The specialty in the medical domain.</p>
        pub fn set_specialty(
            mut self,
            input: std::option::Option<crate::model::Specialty>,
        ) -> Self {
            self.specialty = input;
            self
        }
        /// <p>The type of audio that was transcribed. </p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of audio that was transcribed. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Shows whether speaker identification was enabled in the stream.</p>
        pub fn show_speaker_label(mut self, input: bool) -> Self {
            self.show_speaker_label = Some(input);
            self
        }
        /// <p>Shows whether speaker identification was enabled in the stream.</p>
        pub fn set_show_speaker_label(mut self, input: std::option::Option<bool>) -> Self {
            self.show_speaker_label = input;
            self
        }
        /// <p>Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>Represents the stream of transcription events from Amazon Transcribe Medical to your application. </p>
        pub fn transcript_result_stream(
            mut self,
            input: aws_smithy_http::event_stream::Receiver<
                crate::model::MedicalTranscriptResultStream,
                crate::error::StartMedicalStreamTranscriptionError,
            >,
        ) -> Self {
            self.transcript_result_stream = Some(input);
            self
        }
        /// <p>Represents the stream of transcription events from Amazon Transcribe Medical to your application. </p>
        pub fn set_transcript_result_stream(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::Receiver<
                    crate::model::MedicalTranscriptResultStream,
                    crate::error::StartMedicalStreamTranscriptionError,
                >,
            >,
        ) -> Self {
            self.transcript_result_stream = input;
            self
        }
        /// <p>Shows whether channel identification has been enabled in the stream.</p>
        pub fn enable_channel_identification(mut self, input: bool) -> Self {
            self.enable_channel_identification = Some(input);
            self
        }
        /// <p>Shows whether channel identification has been enabled in the stream.</p>
        pub fn set_enable_channel_identification(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_channel_identification = input;
            self
        }
        /// <p>The number of channels identified in the stream.</p>
        pub fn number_of_channels(mut self, input: i32) -> Self {
            self.number_of_channels = Some(input);
            self
        }
        /// <p>The number of channels identified in the stream.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_channels = input;
            self
        }
        /// <p>If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health information.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::MedicalContentIdentificationType,
        ) -> Self {
            self.content_identification_type = Some(input);
            self
        }
        /// <p>If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health information.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::MedicalContentIdentificationType>,
        ) -> Self {
            self.content_identification_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMedicalStreamTranscriptionOutput`](crate::output::StartMedicalStreamTranscriptionOutput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::output::StartMedicalStreamTranscriptionOutput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::output::StartMedicalStreamTranscriptionOutput {
                    request_id: self.request_id
                    ,
                    language_code: self.language_code
                    ,
                    media_sample_rate_hertz: self.media_sample_rate_hertz
                    ,
                    media_encoding: self.media_encoding
                    ,
                    vocabulary_name: self.vocabulary_name
                    ,
                    specialty: self.specialty
                    ,
                    r#type: self.r#type
                    ,
                    show_speaker_label: self.show_speaker_label
                        .unwrap_or_default()
                    ,
                    session_id: self.session_id
                    ,
                    transcript_result_stream: self.transcript_result_stream
                        .ok_or(
                            aws_smithy_http::operation::BuildError::MissingField { field: "transcript_result_stream", details: "transcript_result_stream was not specified but it is required when building StartMedicalStreamTranscriptionOutput"}
                        )?
                    ,
                    enable_channel_identification: self.enable_channel_identification
                        .unwrap_or_default()
                    ,
                    number_of_channels: self.number_of_channels
                    ,
                    content_identification_type: self.content_identification_type
                    ,
                }
            )
        }
    }
}
impl StartMedicalStreamTranscriptionOutput {
    /// Creates a new builder-style object to manufacture [`StartMedicalStreamTranscriptionOutput`](crate::output::StartMedicalStreamTranscriptionOutput)
    pub fn builder() -> crate::output::start_medical_stream_transcription_output::Builder {
        crate::output::start_medical_stream_transcription_output::Builder::default()
    }
}
