// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Transcribe Streaming Service
///
/// Client for invoking operations on Amazon Transcribe Streaming Service. Each operation on Amazon Transcribe Streaming Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_transcribestreaming::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_transcribestreaming::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_transcribestreaming::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`StartMedicalStreamTranscription`](crate::client::fluent_builders::StartMedicalStreamTranscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartMedicalStreamTranscription::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_language_code): <p> Indicates the source language used in the input audio stream. For Amazon Transcribe Medical, this is US English (en-US). </p>
    ///   - [`media_sample_rate_hertz(i32)`](crate::client::fluent_builders::StartMedicalStreamTranscription::media_sample_rate_hertz) / [`set_media_sample_rate_hertz(Option<i32>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_media_sample_rate_hertz): <p>The sample rate of the input audio (in Hertz). Amazon Transcribe medical supports a range from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    ///   - [`media_encoding(MediaEncoding)`](crate::client::fluent_builders::StartMedicalStreamTranscription::media_encoding) / [`set_media_encoding(Option<MediaEncoding>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_media_encoding): <p>The encoding used for the input audio.</p>
    ///   - [`vocabulary_name(impl Into<String>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::vocabulary_name) / [`set_vocabulary_name(Option<String>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_vocabulary_name): <p>The name of the medical custom vocabulary to use when processing the real-time stream.</p>
    ///   - [`specialty(Specialty)`](crate::client::fluent_builders::StartMedicalStreamTranscription::specialty) / [`set_specialty(Option<Specialty>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_specialty): <p>The medical specialty of the clinician or provider.</p>
    ///   - [`r#type(Type)`](crate::client::fluent_builders::StartMedicalStreamTranscription::type) / [`set_type(Option<Type>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_type): <p>The type of input audio. Choose <code>DICTATION</code> for a provider dictating patient notes. Choose <code>CONVERSATION</code> for a dialogue between a patient and one or more medical professionanls.</p>
    ///   - [`show_speaker_label(bool)`](crate::client::fluent_builders::StartMedicalStreamTranscription::show_speaker_label) / [`set_show_speaker_label(bool)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_show_speaker_label): <p>When <code>true</code>, enables speaker identification in your real-time stream.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_session_id): <p> Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response. </p>
    ///   - [`audio_stream(EventStreamInput<crate::model::AudioStream>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::audio_stream) / [`set_audio_stream(EventStreamInput<crate::model::AudioStream>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_audio_stream): <p>Represents the audio stream from your application to Amazon Transcribe.</p>
    ///   - [`enable_channel_identification(bool)`](crate::client::fluent_builders::StartMedicalStreamTranscription::enable_channel_identification) / [`set_enable_channel_identification(bool)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_enable_channel_identification): <p>When <code>true</code>, instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription output of each channel into a single transcription.</p>  <p>Amazon Transcribe Medical also produces a transcription of each item. An item includes the start time, end time, and any alternative transcriptions.</p>  <p>You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    ///   - [`number_of_channels(i32)`](crate::client::fluent_builders::StartMedicalStreamTranscription::number_of_channels) / [`set_number_of_channels(Option<i32>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_number_of_channels): <p>The number of channels that are in your audio stream.</p>
    ///   - [`content_identification_type(MedicalContentIdentificationType)`](crate::client::fluent_builders::StartMedicalStreamTranscription::content_identification_type) / [`set_content_identification_type(Option<MedicalContentIdentificationType>)`](crate::client::fluent_builders::StartMedicalStreamTranscription::set_content_identification_type): <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
    /// - On success, responds with [`StartMedicalStreamTranscriptionOutput`](crate::output::StartMedicalStreamTranscriptionOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::StartMedicalStreamTranscriptionOutput::request_id): <p>An identifier for the streaming transcription.</p>
    ///   - [`language_code(Option<LanguageCode>)`](crate::output::StartMedicalStreamTranscriptionOutput::language_code): <p>The language code for the response transcript. For Amazon Transcribe Medical, this is US English (en-US).</p>
    ///   - [`media_sample_rate_hertz(Option<i32>)`](crate::output::StartMedicalStreamTranscriptionOutput::media_sample_rate_hertz): <p>The sample rate of the input audio, in Hertz (Hz).</p>
    ///   - [`media_encoding(Option<MediaEncoding>)`](crate::output::StartMedicalStreamTranscriptionOutput::media_encoding): <p>The encoding used for the input audio stream.</p>
    ///   - [`vocabulary_name(Option<String>)`](crate::output::StartMedicalStreamTranscriptionOutput::vocabulary_name): <p>The name of the vocabulary used when processing the stream.</p>
    ///   - [`specialty(Option<Specialty>)`](crate::output::StartMedicalStreamTranscriptionOutput::specialty): <p>The specialty in the medical domain.</p>
    ///   - [`r#type(Option<Type>)`](crate::output::StartMedicalStreamTranscriptionOutput::type): <p>The type of audio that was transcribed. </p>
    ///   - [`show_speaker_label(bool)`](crate::output::StartMedicalStreamTranscriptionOutput::show_speaker_label): <p>Shows whether speaker identification was enabled in the stream.</p>
    ///   - [`session_id(Option<String>)`](crate::output::StartMedicalStreamTranscriptionOutput::session_id): <p>Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response.</p>
    ///   - [`transcript_result_stream(Receiver<crate::model::MedicalTranscriptResultStream, crate::error::StartMedicalStreamTranscriptionError>)`](crate::output::StartMedicalStreamTranscriptionOutput::transcript_result_stream): <p>Represents the stream of transcription events from Amazon Transcribe Medical to your application. </p>
    ///   - [`enable_channel_identification(bool)`](crate::output::StartMedicalStreamTranscriptionOutput::enable_channel_identification): <p>Shows whether channel identification has been enabled in the stream.</p>
    ///   - [`number_of_channels(Option<i32>)`](crate::output::StartMedicalStreamTranscriptionOutput::number_of_channels): <p>The number of channels identified in the stream.</p>
    ///   - [`content_identification_type(Option<MedicalContentIdentificationType>)`](crate::output::StartMedicalStreamTranscriptionOutput::content_identification_type): <p>If the value is <code>PHI</code>, indicates that you've configured your stream to identify personal health information.</p>
    /// - On failure, responds with [`SdkError<StartMedicalStreamTranscriptionError>`](crate::error::StartMedicalStreamTranscriptionError)
    pub fn start_medical_stream_transcription(
        &self,
    ) -> fluent_builders::StartMedicalStreamTranscription {
        fluent_builders::StartMedicalStreamTranscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartStreamTranscription`](crate::client::fluent_builders::StartStreamTranscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language_code(LanguageCode)`](crate::client::fluent_builders::StartStreamTranscription::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::client::fluent_builders::StartStreamTranscription::set_language_code): <p>The language code of the input audio stream.</p>
    ///   - [`media_sample_rate_hertz(i32)`](crate::client::fluent_builders::StartStreamTranscription::media_sample_rate_hertz) / [`set_media_sample_rate_hertz(Option<i32>)`](crate::client::fluent_builders::StartStreamTranscription::set_media_sample_rate_hertz): <p>The sample rate of the input audio (in Hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    ///   - [`media_encoding(MediaEncoding)`](crate::client::fluent_builders::StartStreamTranscription::media_encoding) / [`set_media_encoding(Option<MediaEncoding>)`](crate::client::fluent_builders::StartStreamTranscription::set_media_encoding): <p>The encoding used for the input audio.</p>
    ///   - [`vocabulary_name(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::vocabulary_name) / [`set_vocabulary_name(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_vocabulary_name): <p>The name of the custom vocabulary you want to use with your transcription.</p>  <p>This operation is not intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're using <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> operation instead.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_session_id): <p>A identifier for the transcription session. Use this parameter when you want to retry a session. If you don't provide a session ID, Amazon Transcribe will generate one for you and return it in the response.</p>
    ///   - [`audio_stream(EventStreamInput<crate::model::AudioStream>)`](crate::client::fluent_builders::StartStreamTranscription::audio_stream) / [`set_audio_stream(EventStreamInput<crate::model::AudioStream>)`](crate::client::fluent_builders::StartStreamTranscription::set_audio_stream): <p>PCM-encoded stream of audio blobs. The audio stream is encoded as an HTTP/2 data frame.</p>
    ///   - [`vocabulary_filter_name(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::vocabulary_filter_name) / [`set_vocabulary_filter_name(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_vocabulary_filter_name): <p>The name of the vocabulary filter you want to use with your transcription.</p>  <p>This operation is not intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're using <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> operation instead.</p>
    ///   - [`vocabulary_filter_method(VocabularyFilterMethod)`](crate::client::fluent_builders::StartStreamTranscription::vocabulary_filter_method) / [`set_vocabulary_filter_method(Option<VocabularyFilterMethod>)`](crate::client::fluent_builders::StartStreamTranscription::set_vocabulary_filter_method): <p>The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks filtered words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>.</p>
    ///   - [`show_speaker_label(bool)`](crate::client::fluent_builders::StartStreamTranscription::show_speaker_label) / [`set_show_speaker_label(bool)`](crate::client::fluent_builders::StartStreamTranscription::set_show_speaker_label): <p>When <code>true</code>, enables speaker identification in your media stream.</p>
    ///   - [`enable_channel_identification(bool)`](crate::client::fluent_builders::StartStreamTranscription::enable_channel_identification) / [`set_enable_channel_identification(bool)`](crate::client::fluent_builders::StartStreamTranscription::set_enable_channel_identification): <p>When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately, then merges the transcription output of each channel into a single transcription.</p>  <p>Amazon Transcribe also produces a transcription of each item. An item includes the start time, end time, and any alternative transcriptions.</p>
    ///   - [`number_of_channels(i32)`](crate::client::fluent_builders::StartStreamTranscription::number_of_channels) / [`set_number_of_channels(Option<i32>)`](crate::client::fluent_builders::StartStreamTranscription::set_number_of_channels): <p>The number of channels that are in your audio stream.</p>
    ///   - [`enable_partial_results_stabilization(bool)`](crate::client::fluent_builders::StartStreamTranscription::enable_partial_results_stabilization) / [`set_enable_partial_results_stabilization(bool)`](crate::client::fluent_builders::StartStreamTranscription::set_enable_partial_results_stabilization): <p>When <code>true</code>, instructs Amazon Transcribe to present transcription results that have the partial results stabilized. Normally, any word or phrase from one partial result can change in a subsequent partial result. With partial results stabilization enabled, only the last few words of one partial result can change in another partial result.</p>
    ///   - [`partial_results_stability(PartialResultsStability)`](crate::client::fluent_builders::StartStreamTranscription::partial_results_stability) / [`set_partial_results_stability(Option<PartialResultsStability>)`](crate::client::fluent_builders::StartStreamTranscription::set_partial_results_stability): <p>You can use this field to set the stability level of the transcription results. A higher stability level means that the transcription results are less likely to change. Higher stability levels can come with lower overall transcription accuracy.</p>
    ///   - [`content_identification_type(ContentIdentificationType)`](crate::client::fluent_builders::StartStreamTranscription::content_identification_type) / [`set_content_identification_type(Option<ContentIdentificationType>)`](crate::client::fluent_builders::StartStreamTranscription::set_content_identification_type): <p>Set this field to PII to identify personally identifiable information (PII) in the transcription output. Content identification is performed only upon complete transcription of the audio segments.</p>  <p>You can’t set both <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    ///   - [`content_redaction_type(ContentRedactionType)`](crate::client::fluent_builders::StartStreamTranscription::content_redaction_type) / [`set_content_redaction_type(Option<ContentRedactionType>)`](crate::client::fluent_builders::StartStreamTranscription::set_content_redaction_type): <p>Set this field to PII to redact personally identifiable information (PII) in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>  <p>You can’t set both <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    ///   - [`pii_entity_types(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::pii_entity_types) / [`set_pii_entity_types(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_pii_entity_types): <p>List the PII entity types you want to identify or redact. In order to specify entity types, you must have either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code> enabled.</p>  <p> <code>PIIEntityTypes</code> must be comma-separated; the available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>  <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
    ///   - [`language_model_name(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::language_model_name) / [`set_language_model_name(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_language_model_name): <p>The name of the language model you want to use.</p>
    ///   - [`identify_language(bool)`](crate::client::fluent_builders::StartStreamTranscription::identify_language) / [`set_identify_language(bool)`](crate::client::fluent_builders::StartStreamTranscription::set_identify_language): <p>Optional. Set this value to <code>true</code> to enable language identification for your media stream.</p>
    ///   - [`language_options(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::language_options) / [`set_language_options(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_language_options): <p>An object containing a list of languages that might be present in your audio.</p>  <p>You must provide two or more language codes to help Amazon Transcribe identify the correct language of your media stream with the highest possible accuracy. You can only select one variant per language; for example, you can't include both <code>en-US</code> and <code>en-UK</code> in the same request.</p>  <p>You can only use this parameter if you've set <code>IdentifyLanguage</code> to <code>true</code>in your request.</p>
    ///   - [`preferred_language(LanguageCode)`](crate::client::fluent_builders::StartStreamTranscription::preferred_language) / [`set_preferred_language(Option<LanguageCode>)`](crate::client::fluent_builders::StartStreamTranscription::set_preferred_language): <p>Optional. From the subset of languages codes you provided for <code>LanguageOptions</code>, you can select one preferred language for your transcription.</p>  <p>You can only use this parameter if you've set <code>IdentifyLanguage</code> to <code>true</code>in your request.</p>
    ///   - [`vocabulary_names(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::vocabulary_names) / [`set_vocabulary_names(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_vocabulary_names): <p>The names of the custom vocabularies you want to use with your transcription.</p>  <p>Note that if the custom vocabularies you specify are in languages that don't match the language identified in your media, your job fails.</p>  <p>This operation is only intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're not using <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> operation instead.</p>
    ///   - [`vocabulary_filter_names(impl Into<String>)`](crate::client::fluent_builders::StartStreamTranscription::vocabulary_filter_names) / [`set_vocabulary_filter_names(Option<String>)`](crate::client::fluent_builders::StartStreamTranscription::set_vocabulary_filter_names): <p>The names of the vocabulary filters you want to use with your transcription.</p>  <p>Note that if the vocabulary filters you specify are in languages that don't match the language identified in your media, your job fails.</p>  <p>This operation is only intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're not using <code>IdentifyLanguage</code> in your request and want to use a vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> operation instead.</p>
    /// - On success, responds with [`StartStreamTranscriptionOutput`](crate::output::StartStreamTranscriptionOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::StartStreamTranscriptionOutput::request_id): <p>An identifier for the transcription.</p>
    ///   - [`language_code(Option<LanguageCode>)`](crate::output::StartStreamTranscriptionOutput::language_code): <p>The language code of the input audio stream.</p>
    ///   - [`media_sample_rate_hertz(Option<i32>)`](crate::output::StartStreamTranscriptionOutput::media_sample_rate_hertz): <p>The sample rate, in Hertz (Hz), for the input audio stream.</p>
    ///   - [`media_encoding(Option<MediaEncoding>)`](crate::output::StartStreamTranscriptionOutput::media_encoding): <p>The encoding used for the input audio stream.</p>
    ///   - [`vocabulary_name(Option<String>)`](crate::output::StartStreamTranscriptionOutput::vocabulary_name): <p>The name of the custom vocabulary used when processing the stream.</p>
    ///   - [`session_id(Option<String>)`](crate::output::StartStreamTranscriptionOutput::session_id): <p>An identifier for a specific transcription session.</p>
    ///   - [`transcript_result_stream(Receiver<crate::model::TranscriptResultStream, crate::error::StartStreamTranscriptionError>)`](crate::output::StartStreamTranscriptionOutput::transcript_result_stream): <p>Represents the stream of transcription events from Amazon Transcribe to your application.</p>
    ///   - [`vocabulary_filter_name(Option<String>)`](crate::output::StartStreamTranscriptionOutput::vocabulary_filter_name): <p>The name of the vocabulary filter used when processing the stream.</p>
    ///   - [`vocabulary_filter_method(Option<VocabularyFilterMethod>)`](crate::output::StartStreamTranscriptionOutput::vocabulary_filter_method): <p>The vocabulary filtering method used when processing the stream.</p>
    ///   - [`show_speaker_label(bool)`](crate::output::StartStreamTranscriptionOutput::show_speaker_label): <p>Shows whether speaker identification was enabled in the transcription.</p>
    ///   - [`enable_channel_identification(bool)`](crate::output::StartStreamTranscriptionOutput::enable_channel_identification): <p>Shows whether channel identification was enabled in the stream.</p>
    ///   - [`number_of_channels(Option<i32>)`](crate::output::StartStreamTranscriptionOutput::number_of_channels): <p>The number of channels identified in the stream.</p>
    ///   - [`enable_partial_results_stabilization(bool)`](crate::output::StartStreamTranscriptionOutput::enable_partial_results_stabilization): <p>Shows whether partial results stabilization was enabled in the transcription.</p>
    ///   - [`partial_results_stability(Option<PartialResultsStability>)`](crate::output::StartStreamTranscriptionOutput::partial_results_stability): <p>If partial results stabilization has been enabled in the stream, shows the stability level.</p>
    ///   - [`content_identification_type(Option<ContentIdentificationType>)`](crate::output::StartStreamTranscriptionOutput::content_identification_type): <p>Shows whether content identification was enabled in this stream.</p>
    ///   - [`content_redaction_type(Option<ContentRedactionType>)`](crate::output::StartStreamTranscriptionOutput::content_redaction_type): <p>Shows whether content redaction was enabled in this stream.</p>
    ///   - [`pii_entity_types(Option<String>)`](crate::output::StartStreamTranscriptionOutput::pii_entity_types): <p>Lists the PII entity types you specified in your request.</p>
    ///   - [`language_model_name(Option<String>)`](crate::output::StartStreamTranscriptionOutput::language_model_name): <p>The name of the custom language model used in the transcription.</p>
    ///   - [`identify_language(bool)`](crate::output::StartStreamTranscriptionOutput::identify_language): <p>The language code of the language identified in your media stream.</p>
    ///   - [`language_options(Option<String>)`](crate::output::StartStreamTranscriptionOutput::language_options): <p>The language codes used in the identification of your media stream's predominant language.</p>
    ///   - [`preferred_language(Option<LanguageCode>)`](crate::output::StartStreamTranscriptionOutput::preferred_language): <p>The preferred language you specified in your request.</p>
    ///   - [`vocabulary_names(Option<String>)`](crate::output::StartStreamTranscriptionOutput::vocabulary_names): <p>The name of the custom vocabulary used when processing the stream.</p>
    ///   - [`vocabulary_filter_names(Option<String>)`](crate::output::StartStreamTranscriptionOutput::vocabulary_filter_names): <p>The name of the vocabulary filter used when processing the stream.</p>
    /// - On failure, responds with [`SdkError<StartStreamTranscriptionError>`](crate::error::StartStreamTranscriptionError)
    pub fn start_stream_transcription(&self) -> fluent_builders::StartStreamTranscription {
        fluent_builders::StartStreamTranscription::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `StartMedicalStreamTranscription`.
    ///
    /// <p>Starts a bidirectional HTTP/2 stream where audio is streamed to Amazon Transcribe Medical and the transcription results are streamed to your application.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartMedicalStreamTranscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_medical_stream_transcription_input::Builder,
    }
    impl StartMedicalStreamTranscription {
        /// Creates a new `StartMedicalStreamTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMedicalStreamTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMedicalStreamTranscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Indicates the source language used in the input audio stream. For Amazon Transcribe Medical, this is US English (en-US). </p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p> Indicates the source language used in the input audio stream. For Amazon Transcribe Medical, this is US English (en-US). </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The sample rate of the input audio (in Hertz). Amazon Transcribe medical supports a range from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
        pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
            self.inner = self.inner.media_sample_rate_hertz(input);
            self
        }
        /// <p>The sample rate of the input audio (in Hertz). Amazon Transcribe medical supports a range from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
        pub fn set_media_sample_rate_hertz(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_media_sample_rate_hertz(input);
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn media_encoding(mut self, input: crate::model::MediaEncoding) -> Self {
            self.inner = self.inner.media_encoding(input);
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn set_media_encoding(
            mut self,
            input: std::option::Option<crate::model::MediaEncoding>,
        ) -> Self {
            self.inner = self.inner.set_media_encoding(input);
            self
        }
        /// <p>The name of the medical custom vocabulary to use when processing the real-time stream.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_name(input.into());
            self
        }
        /// <p>The name of the medical custom vocabulary to use when processing the real-time stream.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_name(input);
            self
        }
        /// <p>The medical specialty of the clinician or provider.</p>
        pub fn specialty(mut self, input: crate::model::Specialty) -> Self {
            self.inner = self.inner.specialty(input);
            self
        }
        /// <p>The medical specialty of the clinician or provider.</p>
        pub fn set_specialty(
            mut self,
            input: std::option::Option<crate::model::Specialty>,
        ) -> Self {
            self.inner = self.inner.set_specialty(input);
            self
        }
        /// <p>The type of input audio. Choose <code>DICTATION</code> for a provider dictating patient notes. Choose <code>CONVERSATION</code> for a dialogue between a patient and one or more medical professionanls.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of input audio. Choose <code>DICTATION</code> for a provider dictating patient notes. Choose <code>CONVERSATION</code> for a dialogue between a patient and one or more medical professionanls.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your real-time stream.</p>
        pub fn show_speaker_label(mut self, input: bool) -> Self {
            self.inner = self.inner.show_speaker_label(input);
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your real-time stream.</p>
        pub fn set_show_speaker_label(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_speaker_label(input);
            self
        }
        /// <p> Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response. </p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p> Optional. An identifier for the transcription session. If you don't provide a session ID, Amazon Transcribe generates one for you and returns it in the response. </p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>Represents the audio stream from your application to Amazon Transcribe.</p>
        pub fn audio_stream(
            mut self,
            input: aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
        ) -> Self {
            self.inner = self.inner.audio_stream(input);
            self
        }
        /// <p>Represents the audio stream from your application to Amazon Transcribe.</p>
        pub fn set_audio_stream(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
            >,
        ) -> Self {
            self.inner = self.inner.set_audio_stream(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe Medical also produces a transcription of each item. An item includes the start time, end time, and any alternative transcriptions.</p>
        /// <p>You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn enable_channel_identification(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_channel_identification(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe Medical also produces a transcription of each item. An item includes the start time, end time, and any alternative transcriptions.</p>
        /// <p>You can't set both <code>ShowSpeakerLabel</code> and <code>EnableChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn set_enable_channel_identification(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_channel_identification(input);
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn number_of_channels(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_channels(input);
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_channels(input);
            self
        }
        /// <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::MedicalContentIdentificationType,
        ) -> Self {
            self.inner = self.inner.content_identification_type(input);
            self
        }
        /// <p>Set this field to <code>PHI</code> to identify personal health information in the transcription output.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::MedicalContentIdentificationType>,
        ) -> Self {
            self.inner = self.inner.set_content_identification_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStreamTranscription`.
    ///
    /// <p>Starts a bidirectional HTTP/2 stream where audio is streamed to Amazon Transcribe and the transcription results are streamed to your application.</p>
    /// <p>The following are encoded as HTTP/2 headers:</p>
    /// <ul>
    /// <li> <p>x-amzn-transcribe-language-code</p> </li>
    /// <li> <p>x-amzn-transcribe-media-encoding</p> </li>
    /// <li> <p>x-amzn-transcribe-sample-rate</p> </li>
    /// <li> <p>x-amzn-transcribe-session-id</p> </li>
    /// </ul>
    /// <p>See the <a href="https://docs.aws.amazon.com/sdk-for-go/api/service/transcribestreamingservice/#TranscribeStreamingService.StartStreamTranscription"> SDK for Go API Reference</a> for more detail.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartStreamTranscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_stream_transcription_input::Builder,
    }
    impl StartStreamTranscription {
        /// Creates a new `StartStreamTranscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStreamTranscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStreamTranscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The language code of the input audio stream.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the input audio stream.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The sample rate of the input audio (in Hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
        pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
            self.inner = self.inner.media_sample_rate_hertz(input);
            self
        }
        /// <p>The sample rate of the input audio (in Hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
        pub fn set_media_sample_rate_hertz(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_media_sample_rate_hertz(input);
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn media_encoding(mut self, input: crate::model::MediaEncoding) -> Self {
            self.inner = self.inner.media_encoding(input);
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn set_media_encoding(
            mut self,
            input: std::option::Option<crate::model::MediaEncoding>,
        ) -> Self {
            self.inner = self.inner.set_media_encoding(input);
            self
        }
        /// <p>The name of the custom vocabulary you want to use with your transcription.</p>
        /// <p>This operation is not intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're using <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> operation instead.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_name(input.into());
            self
        }
        /// <p>The name of the custom vocabulary you want to use with your transcription.</p>
        /// <p>This operation is not intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're using <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> operation instead.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_name(input);
            self
        }
        /// <p>A identifier for the transcription session. Use this parameter when you want to retry a session. If you don't provide a session ID, Amazon Transcribe will generate one for you and return it in the response.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>A identifier for the transcription session. Use this parameter when you want to retry a session. If you don't provide a session ID, Amazon Transcribe will generate one for you and return it in the response.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>PCM-encoded stream of audio blobs. The audio stream is encoded as an HTTP/2 data frame.</p>
        pub fn audio_stream(
            mut self,
            input: aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
        ) -> Self {
            self.inner = self.inner.audio_stream(input);
            self
        }
        /// <p>PCM-encoded stream of audio blobs. The audio stream is encoded as an HTTP/2 data frame.</p>
        pub fn set_audio_stream(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
            >,
        ) -> Self {
            self.inner = self.inner.set_audio_stream(input);
            self
        }
        /// <p>The name of the vocabulary filter you want to use with your transcription.</p>
        /// <p>This operation is not intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're using <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> operation instead.</p>
        pub fn vocabulary_filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_filter_name(input.into());
            self
        }
        /// <p>The name of the vocabulary filter you want to use with your transcription.</p>
        /// <p>This operation is not intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're using <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> operation instead.</p>
        pub fn set_vocabulary_filter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_filter_name(input);
            self
        }
        /// <p>The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks filtered words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>.</p>
        pub fn vocabulary_filter_method(
            mut self,
            input: crate::model::VocabularyFilterMethod,
        ) -> Self {
            self.inner = self.inner.vocabulary_filter_method(input);
            self
        }
        /// <p>The manner in which you use your vocabulary filter to filter words in your transcript. <code>Remove</code> removes filtered words from your transcription results. <code>Mask</code> masks filtered words with a <code>***</code> in your transcription results. <code>Tag</code> keeps the filtered words in your transcription results and tags them. The tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>.</p>
        pub fn set_vocabulary_filter_method(
            mut self,
            input: std::option::Option<crate::model::VocabularyFilterMethod>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_filter_method(input);
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your media stream.</p>
        pub fn show_speaker_label(mut self, input: bool) -> Self {
            self.inner = self.inner.show_speaker_label(input);
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your media stream.</p>
        pub fn set_show_speaker_label(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_speaker_label(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately, then merges the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe also produces a transcription of each item. An item includes the start time, end time, and any alternative transcriptions.</p>
        pub fn enable_channel_identification(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_channel_identification(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately, then merges the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe also produces a transcription of each item. An item includes the start time, end time, and any alternative transcriptions.</p>
        pub fn set_enable_channel_identification(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_channel_identification(input);
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn number_of_channels(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_channels(input);
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_channels(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to present transcription results that have the partial results stabilized. Normally, any word or phrase from one partial result can change in a subsequent partial result. With partial results stabilization enabled, only the last few words of one partial result can change in another partial result.</p>
        pub fn enable_partial_results_stabilization(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_partial_results_stabilization(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to present transcription results that have the partial results stabilized. Normally, any word or phrase from one partial result can change in a subsequent partial result. With partial results stabilization enabled, only the last few words of one partial result can change in another partial result.</p>
        pub fn set_enable_partial_results_stabilization(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_partial_results_stabilization(input);
            self
        }
        /// <p>You can use this field to set the stability level of the transcription results. A higher stability level means that the transcription results are less likely to change. Higher stability levels can come with lower overall transcription accuracy.</p>
        pub fn partial_results_stability(
            mut self,
            input: crate::model::PartialResultsStability,
        ) -> Self {
            self.inner = self.inner.partial_results_stability(input);
            self
        }
        /// <p>You can use this field to set the stability level of the transcription results. A higher stability level means that the transcription results are less likely to change. Higher stability levels can come with lower overall transcription accuracy.</p>
        pub fn set_partial_results_stability(
            mut self,
            input: std::option::Option<crate::model::PartialResultsStability>,
        ) -> Self {
            self.inner = self.inner.set_partial_results_stability(input);
            self
        }
        /// <p>Set this field to PII to identify personally identifiable information (PII) in the transcription output. Content identification is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::ContentIdentificationType,
        ) -> Self {
            self.inner = self.inner.content_identification_type(input);
            self
        }
        /// <p>Set this field to PII to identify personally identifiable information (PII) in the transcription output. Content identification is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::ContentIdentificationType>,
        ) -> Self {
            self.inner = self.inner.set_content_identification_type(input);
            self
        }
        /// <p>Set this field to PII to redact personally identifiable information (PII) in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn content_redaction_type(mut self, input: crate::model::ContentRedactionType) -> Self {
            self.inner = self.inner.content_redaction_type(input);
            self
        }
        /// <p>Set this field to PII to redact personally identifiable information (PII) in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn set_content_redaction_type(
            mut self,
            input: std::option::Option<crate::model::ContentRedactionType>,
        ) -> Self {
            self.inner = self.inner.set_content_redaction_type(input);
            self
        }
        /// <p>List the PII entity types you want to identify or redact. In order to specify entity types, you must have either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code> enabled.</p>
        /// <p> <code>PIIEntityTypes</code> must be comma-separated; the available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>
        /// <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
        pub fn pii_entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pii_entity_types(input.into());
            self
        }
        /// <p>List the PII entity types you want to identify or redact. In order to specify entity types, you must have either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code> enabled.</p>
        /// <p> <code>PIIEntityTypes</code> must be comma-separated; the available values are: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, and <code>ALL</code>.</p>
        /// <p> <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
        pub fn set_pii_entity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pii_entity_types(input);
            self
        }
        /// <p>The name of the language model you want to use.</p>
        pub fn language_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language_model_name(input.into());
            self
        }
        /// <p>The name of the language model you want to use.</p>
        pub fn set_language_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_language_model_name(input);
            self
        }
        /// <p>Optional. Set this value to <code>true</code> to enable language identification for your media stream.</p>
        pub fn identify_language(mut self, input: bool) -> Self {
            self.inner = self.inner.identify_language(input);
            self
        }
        /// <p>Optional. Set this value to <code>true</code> to enable language identification for your media stream.</p>
        pub fn set_identify_language(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_identify_language(input);
            self
        }
        /// <p>An object containing a list of languages that might be present in your audio.</p>
        /// <p>You must provide two or more language codes to help Amazon Transcribe identify the correct language of your media stream with the highest possible accuracy. You can only select one variant per language; for example, you can't include both <code>en-US</code> and <code>en-UK</code> in the same request.</p>
        /// <p>You can only use this parameter if you've set <code>IdentifyLanguage</code> to <code>true</code>in your request.</p>
        pub fn language_options(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language_options(input.into());
            self
        }
        /// <p>An object containing a list of languages that might be present in your audio.</p>
        /// <p>You must provide two or more language codes to help Amazon Transcribe identify the correct language of your media stream with the highest possible accuracy. You can only select one variant per language; for example, you can't include both <code>en-US</code> and <code>en-UK</code> in the same request.</p>
        /// <p>You can only use this parameter if you've set <code>IdentifyLanguage</code> to <code>true</code>in your request.</p>
        pub fn set_language_options(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_language_options(input);
            self
        }
        /// <p>Optional. From the subset of languages codes you provided for <code>LanguageOptions</code>, you can select one preferred language for your transcription.</p>
        /// <p>You can only use this parameter if you've set <code>IdentifyLanguage</code> to <code>true</code>in your request.</p>
        pub fn preferred_language(mut self, input: crate::model::LanguageCode) -> Self {
            self.inner = self.inner.preferred_language(input);
            self
        }
        /// <p>Optional. From the subset of languages codes you provided for <code>LanguageOptions</code>, you can select one preferred language for your transcription.</p>
        /// <p>You can only use this parameter if you've set <code>IdentifyLanguage</code> to <code>true</code>in your request.</p>
        pub fn set_preferred_language(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_preferred_language(input);
            self
        }
        /// <p>The names of the custom vocabularies you want to use with your transcription.</p>
        /// <p>Note that if the custom vocabularies you specify are in languages that don't match the language identified in your media, your job fails.</p>
        /// <p>This operation is only intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're not using <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> operation instead.</p>
        pub fn vocabulary_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_names(input.into());
            self
        }
        /// <p>The names of the custom vocabularies you want to use with your transcription.</p>
        /// <p>Note that if the custom vocabularies you specify are in languages that don't match the language identified in your media, your job fails.</p>
        /// <p>This operation is only intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're not using <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> operation instead.</p>
        pub fn set_vocabulary_names(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_names(input);
            self
        }
        /// <p>The names of the vocabulary filters you want to use with your transcription.</p>
        /// <p>Note that if the vocabulary filters you specify are in languages that don't match the language identified in your media, your job fails.</p>
        /// <p>This operation is only intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're not using <code>IdentifyLanguage</code> in your request and want to use a vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> operation instead.</p>
        pub fn vocabulary_filter_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_filter_names(input.into());
            self
        }
        /// <p>The names of the vocabulary filters you want to use with your transcription.</p>
        /// <p>Note that if the vocabulary filters you specify are in languages that don't match the language identified in your media, your job fails.</p>
        /// <p>This operation is only intended for use in conjunction with the <code>IdentifyLanguage</code> operation. If you're not using <code>IdentifyLanguage</code> in your request and want to use a vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> operation instead.</p>
        pub fn set_vocabulary_filter_names(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_filter_names(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
