// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`StartMedicalStreamTranscriptionInput`](crate::input::StartMedicalStreamTranscriptionInput)
pub mod start_medical_stream_transcription_input {
    /// A builder for [`StartMedicalStreamTranscriptionInput`](crate::input::StartMedicalStreamTranscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) media_sample_rate_hertz: std::option::Option<i32>,
        pub(crate) media_encoding: std::option::Option<crate::model::MediaEncoding>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) specialty: std::option::Option<crate::model::Specialty>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
        pub(crate) show_speaker_label: std::option::Option<bool>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) audio_stream: std::option::Option<
            aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
        >,
        pub(crate) enable_channel_identification: std::option::Option<bool>,
        pub(crate) number_of_channels: std::option::Option<i32>,
        pub(crate) content_identification_type:
            std::option::Option<crate::model::MedicalContentIdentificationType>,
    }
    impl Builder {
        /// <p> Indicates the source language used in the input audio stream. For Amazon Transcribe Medical, this is US
        /// English (en-US). </p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p> Indicates the source language used in the input audio stream. For Amazon Transcribe Medical, this is US
        /// English (en-US). </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The sample rate of the input audio in Hertz.</p>
        pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
            self.media_sample_rate_hertz = Some(input);
            self
        }
        /// <p>The sample rate of the input audio in Hertz.</p>
        pub fn set_media_sample_rate_hertz(mut self, input: std::option::Option<i32>) -> Self {
            self.media_sample_rate_hertz = input;
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn media_encoding(mut self, input: crate::model::MediaEncoding) -> Self {
            self.media_encoding = Some(input);
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn set_media_encoding(
            mut self,
            input: std::option::Option<crate::model::MediaEncoding>,
        ) -> Self {
            self.media_encoding = input;
            self
        }
        /// <p>The name of the medical custom vocabulary to use when processing the real-time
        /// stream.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the medical custom vocabulary to use when processing the real-time
        /// stream.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The medical specialty of the clinician or provider.</p>
        pub fn specialty(mut self, input: crate::model::Specialty) -> Self {
            self.specialty = Some(input);
            self
        }
        /// <p>The medical specialty of the clinician or provider.</p>
        pub fn set_specialty(
            mut self,
            input: std::option::Option<crate::model::Specialty>,
        ) -> Self {
            self.specialty = input;
            self
        }
        /// <p>The type of input audio. Choose <code>DICTATION</code> for a provider dictating
        /// patient notes. Choose <code>CONVERSATION</code> for a dialogue between a patient and one
        /// or more medical professionanls.</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of input audio. Choose <code>DICTATION</code> for a provider dictating
        /// patient notes. Choose <code>CONVERSATION</code> for a dialogue between a patient and one
        /// or more medical professionanls.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your real-time
        /// stream.</p>
        pub fn show_speaker_label(mut self, input: bool) -> Self {
            self.show_speaker_label = Some(input);
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your real-time
        /// stream.</p>
        pub fn set_show_speaker_label(mut self, input: std::option::Option<bool>) -> Self {
            self.show_speaker_label = input;
            self
        }
        /// <p> Optional. An identifier for the transcription session. If you don't provide a session
        /// ID, Amazon Transcribe generates one for you and returns it in the response. </p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p> Optional. An identifier for the transcription session. If you don't provide a session
        /// ID, Amazon Transcribe generates one for you and returns it in the response. </p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>Represents the audio stream from your application to Amazon Transcribe.</p>
        pub fn audio_stream(
            mut self,
            input: aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
        ) -> Self {
            self.audio_stream = Some(input);
            self
        }
        /// <p>Represents the audio stream from your application to Amazon Transcribe.</p>
        pub fn set_audio_stream(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
            >,
        ) -> Self {
            self.audio_stream = input;
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe Medical to process each audio channel separately and
        /// then merge the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe Medical also produces a transcription of each item. An item includes the start time,
        /// end time, and any alternative transcriptions.</p>
        /// <p>You can't set both <code>ShowSpeakerLabel</code> and
        /// <code>EnableChannelIdentification</code> in the same request. If you set both, your
        /// request returns a <code>BadRequestException</code>.</p>
        pub fn enable_channel_identification(mut self, input: bool) -> Self {
            self.enable_channel_identification = Some(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe Medical to process each audio channel separately and
        /// then merge the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe Medical also produces a transcription of each item. An item includes the start time,
        /// end time, and any alternative transcriptions.</p>
        /// <p>You can't set both <code>ShowSpeakerLabel</code> and
        /// <code>EnableChannelIdentification</code> in the same request. If you set both, your
        /// request returns a <code>BadRequestException</code>.</p>
        pub fn set_enable_channel_identification(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_channel_identification = input;
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn number_of_channels(mut self, input: i32) -> Self {
            self.number_of_channels = Some(input);
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_channels = input;
            self
        }
        /// <p>Set this field to <code>PHI</code> to identify personal health information in the
        /// transcription output.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::MedicalContentIdentificationType,
        ) -> Self {
            self.content_identification_type = Some(input);
            self
        }
        /// <p>Set this field to <code>PHI</code> to identify personal health information in the
        /// transcription output.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::MedicalContentIdentificationType>,
        ) -> Self {
            self.content_identification_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMedicalStreamTranscriptionInput`](crate::input::StartMedicalStreamTranscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMedicalStreamTranscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::StartMedicalStreamTranscriptionInput {
                    language_code: self.language_code
                    ,
                    media_sample_rate_hertz: self.media_sample_rate_hertz
                    ,
                    media_encoding: self.media_encoding
                    ,
                    vocabulary_name: self.vocabulary_name
                    ,
                    specialty: self.specialty
                    ,
                    r#type: self.r#type
                    ,
                    show_speaker_label: self.show_speaker_label
                        .unwrap_or_default()
                    ,
                    session_id: self.session_id
                    ,
                    audio_stream: self.audio_stream
                        .ok_or(
                            aws_smithy_http::operation::BuildError::MissingField { field: "audio_stream", details: "audio_stream was not specified but it is required when building StartMedicalStreamTranscriptionInput"}
                        )?
                    ,
                    enable_channel_identification: self.enable_channel_identification
                        .unwrap_or_default()
                    ,
                    number_of_channels: self.number_of_channels
                    ,
                    content_identification_type: self.content_identification_type
                    ,
                }
            )
        }
    }
}
#[doc(hidden)]
pub type StartMedicalStreamTranscriptionInputOperationOutputAlias =
    crate::operation::StartMedicalStreamTranscription;
#[doc(hidden)]
pub type StartMedicalStreamTranscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartMedicalStreamTranscriptionInput {
    /// Consumes the builder and constructs an Operation<[`StartMedicalStreamTranscription`](crate::operation::StartMedicalStreamTranscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMedicalStreamTranscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMedicalStreamTranscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/medical-stream-transcription").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::StartMedicalStreamTranscriptionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_1) = &_input.language_code {
                let formatted_2 = AsRef::<str>::as_ref(inner_1);
                if !formatted_2.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_2;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "language_code",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-language-code", header_value);
                }
            }
            if let Some(inner_3) = &_input.media_sample_rate_hertz {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(*inner_3);
                let formatted_4 = encoder.encode();
                if !formatted_4.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_4;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "media_sample_rate_hertz",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-sample-rate", header_value);
                }
            }
            if let Some(inner_5) = &_input.media_encoding {
                let formatted_6 = AsRef::<str>::as_ref(inner_5);
                if !formatted_6.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_6;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "media_encoding",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-media-encoding", header_value);
                }
            }
            if let Some(inner_7) = &_input.vocabulary_name {
                let formatted_8 = AsRef::<str>::as_ref(inner_7);
                if !formatted_8.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_8;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "vocabulary_name",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-vocabulary-name", header_value);
                }
            }
            if let Some(inner_9) = &_input.specialty {
                let formatted_10 = AsRef::<str>::as_ref(inner_9);
                if !formatted_10.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_10;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "specialty",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-specialty", header_value);
                }
            }
            if let Some(inner_11) = &_input.r#type {
                let formatted_12 = AsRef::<str>::as_ref(inner_11);
                if !formatted_12.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_12;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "r#type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-type", header_value);
                }
            }
            if _input.show_speaker_label {
                let mut encoder =
                    aws_smithy_types::primitive::Encoder::from(_input.show_speaker_label);
                let formatted_13 = encoder.encode();
                if !formatted_13.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_13;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "show_speaker_label",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-show-speaker-label", header_value);
                }
            }
            if let Some(inner_14) = &_input.session_id {
                let formatted_15 = AsRef::<str>::as_ref(inner_14);
                if !formatted_15.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_15;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "session_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-session-id", header_value);
                }
            }
            if _input.enable_channel_identification {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(
                    _input.enable_channel_identification,
                );
                let formatted_16 = encoder.encode();
                if !formatted_16.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_16;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "enable_channel_identification",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amzn-transcribe-enable-channel-identification",
                        header_value,
                    );
                }
            }
            if let Some(inner_17) = &_input.number_of_channels {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(*inner_17);
                let formatted_18 = encoder.encode();
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "number_of_channels",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-number-of-channels", header_value);
                }
            }
            if let Some(inner_19) = &_input.content_identification_type {
                let formatted_20 = AsRef::<str>::as_ref(inner_19);
                if !formatted_20.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_20;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_identification_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amzn-transcribe-content-identification-type",
                        header_value,
                    );
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMedicalStreamTranscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMedicalStreamTranscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = {
            let marshaller = crate::event_stream_serde::AudioStreamMarshaller::new();
            let signer = _config.new_event_stream_signer(properties.clone());
            let adapter: aws_smithy_http::event_stream::MessageStreamAdapter<
                _,
                crate::error::StartMedicalStreamTranscriptionError,
            > = self.audio_stream.into_body_stream(marshaller, signer);
            let body: aws_smithy_http::body::SdkBody = hyper::Body::wrap_stream(adapter).into();
            body
        };
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request
            .properties_mut()
            .insert(aws_sig_auth::signer::SignableBody::Bytes(&[]));
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMedicalStreamTranscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMedicalStreamTranscription",
            "transcribestreaming",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMedicalStreamTranscriptionInput`](crate::input::StartMedicalStreamTranscriptionInput)
    pub fn builder() -> crate::input::start_medical_stream_transcription_input::Builder {
        crate::input::start_medical_stream_transcription_input::Builder::default()
    }
}

/// See [`StartStreamTranscriptionInput`](crate::input::StartStreamTranscriptionInput)
pub mod start_stream_transcription_input {
    /// A builder for [`StartStreamTranscriptionInput`](crate::input::StartStreamTranscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<crate::model::LanguageCode>,
        pub(crate) media_sample_rate_hertz: std::option::Option<i32>,
        pub(crate) media_encoding: std::option::Option<crate::model::MediaEncoding>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) audio_stream: std::option::Option<
            aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
        >,
        pub(crate) vocabulary_filter_name: std::option::Option<std::string::String>,
        pub(crate) vocabulary_filter_method:
            std::option::Option<crate::model::VocabularyFilterMethod>,
        pub(crate) show_speaker_label: std::option::Option<bool>,
        pub(crate) enable_channel_identification: std::option::Option<bool>,
        pub(crate) number_of_channels: std::option::Option<i32>,
        pub(crate) enable_partial_results_stabilization: std::option::Option<bool>,
        pub(crate) partial_results_stability:
            std::option::Option<crate::model::PartialResultsStability>,
        pub(crate) content_identification_type:
            std::option::Option<crate::model::ContentIdentificationType>,
        pub(crate) content_redaction_type: std::option::Option<crate::model::ContentRedactionType>,
        pub(crate) pii_entity_types: std::option::Option<std::string::String>,
        pub(crate) language_model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates the source language used in the input audio stream.</p>
        pub fn language_code(mut self, input: crate::model::LanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>Indicates the source language used in the input audio stream.</p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::LanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The sample rate, in Hertz, of the input audio. We suggest that you use 8,000 Hz for low
        /// quality audio and 16,000 Hz for high quality audio.</p>
        pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
            self.media_sample_rate_hertz = Some(input);
            self
        }
        /// <p>The sample rate, in Hertz, of the input audio. We suggest that you use 8,000 Hz for low
        /// quality audio and 16,000 Hz for high quality audio.</p>
        pub fn set_media_sample_rate_hertz(mut self, input: std::option::Option<i32>) -> Self {
            self.media_sample_rate_hertz = input;
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn media_encoding(mut self, input: crate::model::MediaEncoding) -> Self {
            self.media_encoding = Some(input);
            self
        }
        /// <p>The encoding used for the input audio.</p>
        pub fn set_media_encoding(
            mut self,
            input: std::option::Option<crate::model::MediaEncoding>,
        ) -> Self {
            self.media_encoding = input;
            self
        }
        /// <p>The name of the vocabulary to use when processing the transcription job.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary to use when processing the transcription job.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>A identifier for the transcription session. Use this parameter when you want to retry a
        /// session. If you don't provide a session ID, Amazon Transcribe will generate one for you and return it in
        /// the response.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>A identifier for the transcription session. Use this parameter when you want to retry a
        /// session. If you don't provide a session ID, Amazon Transcribe will generate one for you and return it in
        /// the response.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>PCM-encoded stream of audio blobs. The audio stream is encoded as an HTTP/2 data
        /// frame.</p>
        pub fn audio_stream(
            mut self,
            input: aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
        ) -> Self {
            self.audio_stream = Some(input);
            self
        }
        /// <p>PCM-encoded stream of audio blobs. The audio stream is encoded as an HTTP/2 data
        /// frame.</p>
        pub fn set_audio_stream(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
            >,
        ) -> Self {
            self.audio_stream = input;
            self
        }
        /// <p>The name of the vocabulary filter you've created that is unique to your account.
        /// Provide the name in this field to successfully use it in a stream.</p>
        pub fn vocabulary_filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_filter_name = Some(input.into());
            self
        }
        /// <p>The name of the vocabulary filter you've created that is unique to your account.
        /// Provide the name in this field to successfully use it in a stream.</p>
        pub fn set_vocabulary_filter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_filter_name = input;
            self
        }
        /// <p>The manner in which you use your vocabulary filter to filter words in your transcript.
        /// <code>Remove</code> removes filtered words from your transcription results.
        /// <code>Mask</code> masks filtered words with a <code>***</code> in your transcription results.
        /// <code>Tag</code> keeps the filtered words in your transcription results and tags them. The
        /// tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>
        /// </p>
        pub fn vocabulary_filter_method(
            mut self,
            input: crate::model::VocabularyFilterMethod,
        ) -> Self {
            self.vocabulary_filter_method = Some(input);
            self
        }
        /// <p>The manner in which you use your vocabulary filter to filter words in your transcript.
        /// <code>Remove</code> removes filtered words from your transcription results.
        /// <code>Mask</code> masks filtered words with a <code>***</code> in your transcription results.
        /// <code>Tag</code> keeps the filtered words in your transcription results and tags them. The
        /// tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>
        /// </p>
        pub fn set_vocabulary_filter_method(
            mut self,
            input: std::option::Option<crate::model::VocabularyFilterMethod>,
        ) -> Self {
            self.vocabulary_filter_method = input;
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your real-time stream.</p>
        pub fn show_speaker_label(mut self, input: bool) -> Self {
            self.show_speaker_label = Some(input);
            self
        }
        /// <p>When <code>true</code>, enables speaker identification in your real-time stream.</p>
        pub fn set_show_speaker_label(mut self, input: std::option::Option<bool>) -> Self {
            self.show_speaker_label = input;
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then
        /// merge the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe also produces a transcription of each item. An item includes the start time, end
        /// time, and any alternative transcriptions.</p>
        /// <p>You can't set both <code>ShowSpeakerLabel</code> and
        /// <code>EnableChannelIdentification</code> in the same request. If you set both, your request
        /// returns a <code>BadRequestException</code>.</p>
        pub fn enable_channel_identification(mut self, input: bool) -> Self {
            self.enable_channel_identification = Some(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then
        /// merge the transcription output of each channel into a single transcription.</p>
        /// <p>Amazon Transcribe also produces a transcription of each item. An item includes the start time, end
        /// time, and any alternative transcriptions.</p>
        /// <p>You can't set both <code>ShowSpeakerLabel</code> and
        /// <code>EnableChannelIdentification</code> in the same request. If you set both, your request
        /// returns a <code>BadRequestException</code>.</p>
        pub fn set_enable_channel_identification(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_channel_identification = input;
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn number_of_channels(mut self, input: i32) -> Self {
            self.number_of_channels = Some(input);
            self
        }
        /// <p>The number of channels that are in your audio stream.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_channels = input;
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to present transcription results that have the
        /// partial results stabilized. Normally, any word or phrase from one partial result can change in
        /// a subsequent partial result. With partial results stabilization enabled, only the last few
        /// words of one partial result can change in another partial result.</p>
        pub fn enable_partial_results_stabilization(mut self, input: bool) -> Self {
            self.enable_partial_results_stabilization = Some(input);
            self
        }
        /// <p>When <code>true</code>, instructs Amazon Transcribe to present transcription results that have the
        /// partial results stabilized. Normally, any word or phrase from one partial result can change in
        /// a subsequent partial result. With partial results stabilization enabled, only the last few
        /// words of one partial result can change in another partial result.</p>
        pub fn set_enable_partial_results_stabilization(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_partial_results_stabilization = input;
            self
        }
        /// <p>You can use this field to set the stability level of the transcription results. A higher
        /// stability level means that the transcription results are less likely to change. Higher
        /// stability levels can come with lower overall transcription accuracy.</p>
        pub fn partial_results_stability(
            mut self,
            input: crate::model::PartialResultsStability,
        ) -> Self {
            self.partial_results_stability = Some(input);
            self
        }
        /// <p>You can use this field to set the stability level of the transcription results. A higher
        /// stability level means that the transcription results are less likely to change. Higher
        /// stability levels can come with lower overall transcription accuracy.</p>
        pub fn set_partial_results_stability(
            mut self,
            input: std::option::Option<crate::model::PartialResultsStability>,
        ) -> Self {
            self.partial_results_stability = input;
            self
        }
        /// <p>Set this field to PII to identify personally identifiable information (PII) in the transcription output. Content identification is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn content_identification_type(
            mut self,
            input: crate::model::ContentIdentificationType,
        ) -> Self {
            self.content_identification_type = Some(input);
            self
        }
        /// <p>Set this field to PII to identify personally identifiable information (PII) in the transcription output. Content identification is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn set_content_identification_type(
            mut self,
            input: std::option::Option<crate::model::ContentIdentificationType>,
        ) -> Self {
            self.content_identification_type = input;
            self
        }
        /// <p>Set this field to PII to redact personally identifiable information (PII) in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn content_redaction_type(mut self, input: crate::model::ContentRedactionType) -> Self {
            self.content_redaction_type = Some(input);
            self
        }
        /// <p>Set this field to PII to redact personally identifiable information (PII) in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
        /// <p>You can’t set both <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
        pub fn set_content_redaction_type(
            mut self,
            input: std::option::Option<crate::model::ContentRedactionType>,
        ) -> Self {
            self.content_redaction_type = input;
            self
        }
        /// <p>List the PII entity types you want to identify or redact. In order to specify entity types, you must have
        /// either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code> enabled.</p>    
        /// <p>
        /// <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
        pub fn pii_entity_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.pii_entity_types = Some(input.into());
            self
        }
        /// <p>List the PII entity types you want to identify or redact. In order to specify entity types, you must have
        /// either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code> enabled.</p>    
        /// <p>
        /// <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
        pub fn set_pii_entity_types(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pii_entity_types = input;
            self
        }
        /// <p>The name of the language model you want to use.</p>
        pub fn language_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_model_name = Some(input.into());
            self
        }
        /// <p>The name of the language model you want to use.</p>
        pub fn set_language_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartStreamTranscriptionInput`](crate::input::StartStreamTranscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartStreamTranscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::StartStreamTranscriptionInput {
                    language_code: self.language_code
                    ,
                    media_sample_rate_hertz: self.media_sample_rate_hertz
                    ,
                    media_encoding: self.media_encoding
                    ,
                    vocabulary_name: self.vocabulary_name
                    ,
                    session_id: self.session_id
                    ,
                    audio_stream: self.audio_stream
                        .ok_or(
                            aws_smithy_http::operation::BuildError::MissingField { field: "audio_stream", details: "audio_stream was not specified but it is required when building StartStreamTranscriptionInput"}
                        )?
                    ,
                    vocabulary_filter_name: self.vocabulary_filter_name
                    ,
                    vocabulary_filter_method: self.vocabulary_filter_method
                    ,
                    show_speaker_label: self.show_speaker_label
                        .unwrap_or_default()
                    ,
                    enable_channel_identification: self.enable_channel_identification
                        .unwrap_or_default()
                    ,
                    number_of_channels: self.number_of_channels
                    ,
                    enable_partial_results_stabilization: self.enable_partial_results_stabilization
                        .unwrap_or_default()
                    ,
                    partial_results_stability: self.partial_results_stability
                    ,
                    content_identification_type: self.content_identification_type
                    ,
                    content_redaction_type: self.content_redaction_type
                    ,
                    pii_entity_types: self.pii_entity_types
                    ,
                    language_model_name: self.language_model_name
                    ,
                }
            )
        }
    }
}
#[doc(hidden)]
pub type StartStreamTranscriptionInputOperationOutputAlias =
    crate::operation::StartStreamTranscription;
#[doc(hidden)]
pub type StartStreamTranscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartStreamTranscriptionInput {
    /// Consumes the builder and constructs an Operation<[`StartStreamTranscription`](crate::operation::StartStreamTranscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartStreamTranscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartStreamTranscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/stream-transcription").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::StartStreamTranscriptionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_21) = &_input.language_code {
                let formatted_22 = AsRef::<str>::as_ref(inner_21);
                if !formatted_22.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_22;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "language_code",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-language-code", header_value);
                }
            }
            if let Some(inner_23) = &_input.media_sample_rate_hertz {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(*inner_23);
                let formatted_24 = encoder.encode();
                if !formatted_24.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_24;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "media_sample_rate_hertz",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-sample-rate", header_value);
                }
            }
            if let Some(inner_25) = &_input.media_encoding {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "media_encoding",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-media-encoding", header_value);
                }
            }
            if let Some(inner_27) = &_input.vocabulary_name {
                let formatted_28 = AsRef::<str>::as_ref(inner_27);
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "vocabulary_name",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-vocabulary-name", header_value);
                }
            }
            if let Some(inner_29) = &_input.session_id {
                let formatted_30 = AsRef::<str>::as_ref(inner_29);
                if !formatted_30.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_30;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "session_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-session-id", header_value);
                }
            }
            if let Some(inner_31) = &_input.vocabulary_filter_name {
                let formatted_32 = AsRef::<str>::as_ref(inner_31);
                if !formatted_32.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_32;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "vocabulary_filter_name",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder =
                        builder.header("x-amzn-transcribe-vocabulary-filter-name", header_value);
                }
            }
            if let Some(inner_33) = &_input.vocabulary_filter_method {
                let formatted_34 = AsRef::<str>::as_ref(inner_33);
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "vocabulary_filter_method",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder =
                        builder.header("x-amzn-transcribe-vocabulary-filter-method", header_value);
                }
            }
            if _input.show_speaker_label {
                let mut encoder =
                    aws_smithy_types::primitive::Encoder::from(_input.show_speaker_label);
                let formatted_35 = encoder.encode();
                if !formatted_35.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_35;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "show_speaker_label",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-show-speaker-label", header_value);
                }
            }
            if _input.enable_channel_identification {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(
                    _input.enable_channel_identification,
                );
                let formatted_36 = encoder.encode();
                if !formatted_36.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_36;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "enable_channel_identification",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amzn-transcribe-enable-channel-identification",
                        header_value,
                    );
                }
            }
            if let Some(inner_37) = &_input.number_of_channels {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(*inner_37);
                let formatted_38 = encoder.encode();
                if !formatted_38.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_38;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "number_of_channels",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-number-of-channels", header_value);
                }
            }
            if _input.enable_partial_results_stabilization {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(
                    _input.enable_partial_results_stabilization,
                );
                let formatted_39 = encoder.encode();
                if !formatted_39.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_39;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "enable_partial_results_stabilization",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amzn-transcribe-enable-partial-results-stabilization",
                        header_value,
                    );
                }
            }
            if let Some(inner_40) = &_input.partial_results_stability {
                let formatted_41 = AsRef::<str>::as_ref(inner_40);
                if !formatted_41.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_41;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "partial_results_stability",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder =
                        builder.header("x-amzn-transcribe-partial-results-stability", header_value);
                }
            }
            if let Some(inner_42) = &_input.content_identification_type {
                let formatted_43 = AsRef::<str>::as_ref(inner_42);
                if !formatted_43.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_43;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_identification_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amzn-transcribe-content-identification-type",
                        header_value,
                    );
                }
            }
            if let Some(inner_44) = &_input.content_redaction_type {
                let formatted_45 = AsRef::<str>::as_ref(inner_44);
                if !formatted_45.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_45;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_redaction_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder =
                        builder.header("x-amzn-transcribe-content-redaction-type", header_value);
                }
            }
            if let Some(inner_46) = &_input.pii_entity_types {
                let formatted_47 = AsRef::<str>::as_ref(inner_46);
                if !formatted_47.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_47;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "pii_entity_types",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-pii-entity-types", header_value);
                }
            }
            if let Some(inner_48) = &_input.language_model_name {
                let formatted_49 = AsRef::<str>::as_ref(inner_48);
                if !formatted_49.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_49;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "language_model_name",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amzn-transcribe-language-model-name", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartStreamTranscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartStreamTranscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = {
            let marshaller = crate::event_stream_serde::AudioStreamMarshaller::new();
            let signer = _config.new_event_stream_signer(properties.clone());
            let adapter: aws_smithy_http::event_stream::MessageStreamAdapter<
                _,
                crate::error::StartStreamTranscriptionError,
            > = self.audio_stream.into_body_stream(marshaller, signer);
            let body: aws_smithy_http::body::SdkBody = hyper::Body::wrap_stream(adapter).into();
            body
        };
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request
            .properties_mut()
            .insert(aws_sig_auth::signer::SignableBody::Bytes(&[]));
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartStreamTranscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartStreamTranscription",
            "transcribestreaming",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartStreamTranscriptionInput`](crate::input::StartStreamTranscriptionInput)
    pub fn builder() -> crate::input::start_stream_transcription_input::Builder {
        crate::input::start_stream_transcription_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct StartStreamTranscriptionInput {
    /// <p>Indicates the source language used in the input audio stream.</p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The sample rate, in Hertz, of the input audio. We suggest that you use 8,000 Hz for low
    /// quality audio and 16,000 Hz for high quality audio.</p>
    pub media_sample_rate_hertz: std::option::Option<i32>,
    /// <p>The encoding used for the input audio.</p>
    pub media_encoding: std::option::Option<crate::model::MediaEncoding>,
    /// <p>The name of the vocabulary to use when processing the transcription job.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>A identifier for the transcription session. Use this parameter when you want to retry a
    /// session. If you don't provide a session ID, Amazon Transcribe will generate one for you and return it in
    /// the response.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>PCM-encoded stream of audio blobs. The audio stream is encoded as an HTTP/2 data
    /// frame.</p>
    pub audio_stream: aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
    /// <p>The name of the vocabulary filter you've created that is unique to your account.
    /// Provide the name in this field to successfully use it in a stream.</p>
    pub vocabulary_filter_name: std::option::Option<std::string::String>,
    /// <p>The manner in which you use your vocabulary filter to filter words in your transcript.
    /// <code>Remove</code> removes filtered words from your transcription results.
    /// <code>Mask</code> masks filtered words with a <code>***</code> in your transcription results.
    /// <code>Tag</code> keeps the filtered words in your transcription results and tags them. The
    /// tag appears as <code>VocabularyFilterMatch</code> equal to <code>True</code>
    /// </p>
    pub vocabulary_filter_method: std::option::Option<crate::model::VocabularyFilterMethod>,
    /// <p>When <code>true</code>, enables speaker identification in your real-time stream.</p>
    pub show_speaker_label: bool,
    /// <p>When <code>true</code>, instructs Amazon Transcribe to process each audio channel separately and then
    /// merge the transcription output of each channel into a single transcription.</p>
    /// <p>Amazon Transcribe also produces a transcription of each item. An item includes the start time, end
    /// time, and any alternative transcriptions.</p>
    /// <p>You can't set both <code>ShowSpeakerLabel</code> and
    /// <code>EnableChannelIdentification</code> in the same request. If you set both, your request
    /// returns a <code>BadRequestException</code>.</p>
    pub enable_channel_identification: bool,
    /// <p>The number of channels that are in your audio stream.</p>
    pub number_of_channels: std::option::Option<i32>,
    /// <p>When <code>true</code>, instructs Amazon Transcribe to present transcription results that have the
    /// partial results stabilized. Normally, any word or phrase from one partial result can change in
    /// a subsequent partial result. With partial results stabilization enabled, only the last few
    /// words of one partial result can change in another partial result.</p>
    pub enable_partial_results_stabilization: bool,
    /// <p>You can use this field to set the stability level of the transcription results. A higher
    /// stability level means that the transcription results are less likely to change. Higher
    /// stability levels can come with lower overall transcription accuracy.</p>
    pub partial_results_stability: std::option::Option<crate::model::PartialResultsStability>,
    /// <p>Set this field to PII to identify personally identifiable information (PII) in the transcription output. Content identification is performed only upon complete transcription of the audio segments.</p>
    /// <p>You can’t set both <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    pub content_identification_type: std::option::Option<crate::model::ContentIdentificationType>,
    /// <p>Set this field to PII to redact personally identifiable information (PII) in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.</p>
    /// <p>You can’t set both <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    pub content_redaction_type: std::option::Option<crate::model::ContentRedactionType>,
    /// <p>List the PII entity types you want to identify or redact. In order to specify entity types, you must have
    /// either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code> enabled.</p>    
    /// <p>
    /// <code>PiiEntityTypes</code> is an optional parameter with a default value of <code>ALL</code>.</p>
    pub pii_entity_types: std::option::Option<std::string::String>,
    /// <p>The name of the language model you want to use.</p>
    pub language_model_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartStreamTranscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartStreamTranscriptionInput");
        formatter.field("language_code", &self.language_code);
        formatter.field("media_sample_rate_hertz", &self.media_sample_rate_hertz);
        formatter.field("media_encoding", &self.media_encoding);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("session_id", &self.session_id);
        formatter.field("audio_stream", &self.audio_stream);
        formatter.field("vocabulary_filter_name", &self.vocabulary_filter_name);
        formatter.field("vocabulary_filter_method", &self.vocabulary_filter_method);
        formatter.field("show_speaker_label", &self.show_speaker_label);
        formatter.field(
            "enable_channel_identification",
            &self.enable_channel_identification,
        );
        formatter.field("number_of_channels", &self.number_of_channels);
        formatter.field(
            "enable_partial_results_stabilization",
            &self.enable_partial_results_stabilization,
        );
        formatter.field("partial_results_stability", &self.partial_results_stability);
        formatter.field(
            "content_identification_type",
            &self.content_identification_type,
        );
        formatter.field("content_redaction_type", &self.content_redaction_type);
        formatter.field("pii_entity_types", &self.pii_entity_types);
        formatter.field("language_model_name", &self.language_model_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct StartMedicalStreamTranscriptionInput {
    /// <p> Indicates the source language used in the input audio stream. For Amazon Transcribe Medical, this is US
    /// English (en-US). </p>
    pub language_code: std::option::Option<crate::model::LanguageCode>,
    /// <p>The sample rate of the input audio in Hertz.</p>
    pub media_sample_rate_hertz: std::option::Option<i32>,
    /// <p>The encoding used for the input audio.</p>
    pub media_encoding: std::option::Option<crate::model::MediaEncoding>,
    /// <p>The name of the medical custom vocabulary to use when processing the real-time
    /// stream.</p>
    pub vocabulary_name: std::option::Option<std::string::String>,
    /// <p>The medical specialty of the clinician or provider.</p>
    pub specialty: std::option::Option<crate::model::Specialty>,
    /// <p>The type of input audio. Choose <code>DICTATION</code> for a provider dictating
    /// patient notes. Choose <code>CONVERSATION</code> for a dialogue between a patient and one
    /// or more medical professionanls.</p>
    pub r#type: std::option::Option<crate::model::Type>,
    /// <p>When <code>true</code>, enables speaker identification in your real-time
    /// stream.</p>
    pub show_speaker_label: bool,
    /// <p> Optional. An identifier for the transcription session. If you don't provide a session
    /// ID, Amazon Transcribe generates one for you and returns it in the response. </p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>Represents the audio stream from your application to Amazon Transcribe.</p>
    pub audio_stream: aws_smithy_http::event_stream::EventStreamInput<crate::model::AudioStream>,
    /// <p>When <code>true</code>, instructs Amazon Transcribe Medical to process each audio channel separately and
    /// then merge the transcription output of each channel into a single transcription.</p>
    /// <p>Amazon Transcribe Medical also produces a transcription of each item. An item includes the start time,
    /// end time, and any alternative transcriptions.</p>
    /// <p>You can't set both <code>ShowSpeakerLabel</code> and
    /// <code>EnableChannelIdentification</code> in the same request. If you set both, your
    /// request returns a <code>BadRequestException</code>.</p>
    pub enable_channel_identification: bool,
    /// <p>The number of channels that are in your audio stream.</p>
    pub number_of_channels: std::option::Option<i32>,
    /// <p>Set this field to <code>PHI</code> to identify personal health information in the
    /// transcription output.</p>
    pub content_identification_type:
        std::option::Option<crate::model::MedicalContentIdentificationType>,
}
impl std::fmt::Debug for StartMedicalStreamTranscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMedicalStreamTranscriptionInput");
        formatter.field("language_code", &self.language_code);
        formatter.field("media_sample_rate_hertz", &self.media_sample_rate_hertz);
        formatter.field("media_encoding", &self.media_encoding);
        formatter.field("vocabulary_name", &self.vocabulary_name);
        formatter.field("specialty", &self.specialty);
        formatter.field("r#type", &self.r#type);
        formatter.field("show_speaker_label", &self.show_speaker_label);
        formatter.field("session_id", &self.session_id);
        formatter.field("audio_stream", &self.audio_stream);
        formatter.field(
            "enable_channel_identification",
            &self.enable_channel_identification,
        );
        formatter.field("number_of_channels", &self.number_of_channels);
        formatter.field(
            "content_identification_type",
            &self.content_identification_type,
        );
        formatter.finish()
    }
}
