// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentRedactionType {
    #[allow(missing_docs)] // documentation missing in model
    Pii,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentRedactionType {
    fn from(s: &str) -> Self {
        match s {
            "PII" => ContentRedactionType::Pii,
            other => ContentRedactionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentRedactionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentRedactionType::from(s))
    }
}
impl ContentRedactionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentRedactionType::Pii => "PII",
            ContentRedactionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PII"]
    }
}
impl AsRef<str> for ContentRedactionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentIdentificationType {
    #[allow(missing_docs)] // documentation missing in model
    Pii,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentIdentificationType {
    fn from(s: &str) -> Self {
        match s {
            "PII" => ContentIdentificationType::Pii,
            other => ContentIdentificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentIdentificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentIdentificationType::from(s))
    }
}
impl ContentIdentificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentIdentificationType::Pii => "PII",
            ContentIdentificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PII"]
    }
}
impl AsRef<str> for ContentIdentificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartialResultsStability {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartialResultsStability {
    fn from(s: &str) -> Self {
        match s {
            "high" => PartialResultsStability::High,
            "low" => PartialResultsStability::Low,
            "medium" => PartialResultsStability::Medium,
            other => PartialResultsStability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartialResultsStability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartialResultsStability::from(s))
    }
}
impl PartialResultsStability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartialResultsStability::High => "high",
            PartialResultsStability::Low => "low",
            PartialResultsStability::Medium => "medium",
            PartialResultsStability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["high", "low", "medium"]
    }
}
impl AsRef<str> for PartialResultsStability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VocabularyFilterMethod {
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Tag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VocabularyFilterMethod {
    fn from(s: &str) -> Self {
        match s {
            "mask" => VocabularyFilterMethod::Mask,
            "remove" => VocabularyFilterMethod::Remove,
            "tag" => VocabularyFilterMethod::Tag,
            other => VocabularyFilterMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VocabularyFilterMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VocabularyFilterMethod::from(s))
    }
}
impl VocabularyFilterMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VocabularyFilterMethod::Mask => "mask",
            VocabularyFilterMethod::Remove => "remove",
            VocabularyFilterMethod::Tag => "tag",
            VocabularyFilterMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["mask", "remove", "tag"]
    }
}
impl AsRef<str> for VocabularyFilterMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the transcription result stream from Amazon Transcribe to your application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum TranscriptResultStream {
    /// <p>A portion of the transcription of the audio stream. Events are sent periodically from
    /// Amazon Transcribe to your application. The event can be a partial transcription of a section of the audio
    /// stream, or it can be the entire transcription of that portion of the audio stream. </p>
    TranscriptEvent(crate::model::TranscriptEvent),
}
impl TranscriptResultStream {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into its [`TranscriptResultStream`](crate::model::TranscriptResultStream) variant.
    /// Returns `Err(&Self) if it can't be converted.`
    pub fn as_transcript_event(
        &self,
    ) -> std::result::Result<&crate::model::TranscriptEvent, &Self> {
        if let TranscriptResultStream::TranscriptEvent(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if the enum instance is the `TranscriptResultStream` variant.
    pub fn is_transcript_event(&self) -> bool {
        self.as_transcript_event().is_ok()
    }
}

/// <p>Represents a set of transcription results from the server to the client. It contains one
/// or more segments of the transcription.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TranscriptEvent {
    /// <p>The transcription of the audio stream. The transcription is composed of all of the items
    /// in the results list.</p>
    pub transcript: std::option::Option<crate::model::Transcript>,
}
impl std::fmt::Debug for TranscriptEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TranscriptEvent");
        formatter.field("transcript", &self.transcript);
        formatter.finish()
    }
}
/// See [`TranscriptEvent`](crate::model::TranscriptEvent)
pub mod transcript_event {
    /// A builder for [`TranscriptEvent`](crate::model::TranscriptEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transcript: std::option::Option<crate::model::Transcript>,
    }
    impl Builder {
        /// <p>The transcription of the audio stream. The transcription is composed of all of the items
        /// in the results list.</p>
        pub fn transcript(mut self, input: crate::model::Transcript) -> Self {
            self.transcript = Some(input);
            self
        }
        /// <p>The transcription of the audio stream. The transcription is composed of all of the items
        /// in the results list.</p>
        pub fn set_transcript(
            mut self,
            input: std::option::Option<crate::model::Transcript>,
        ) -> Self {
            self.transcript = input;
            self
        }
        /// Consumes the builder and constructs a [`TranscriptEvent`](crate::model::TranscriptEvent)
        pub fn build(self) -> crate::model::TranscriptEvent {
            crate::model::TranscriptEvent {
                transcript: self.transcript,
            }
        }
    }
}
impl TranscriptEvent {
    /// Creates a new builder-style object to manufacture [`TranscriptEvent`](crate::model::TranscriptEvent)
    pub fn builder() -> crate::model::transcript_event::Builder {
        crate::model::transcript_event::Builder::default()
    }
}

/// <p>The transcription in a <a>TranscriptEvent</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Transcript {
    /// <p>
    /// <a>Result</a> objects that contain the results of transcribing a portion of the
    /// input audio stream. The array can be empty.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::Result>>,
}
impl std::fmt::Debug for Transcript {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Transcript");
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`Transcript`](crate::model::Transcript)
pub mod transcript {
    /// A builder for [`Transcript`](crate::model::Transcript)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::Result>>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>
        /// <a>Result</a> objects that contain the results of transcribing a portion of the
        /// input audio stream. The array can be empty.</p>
        pub fn results(mut self, input: impl Into<crate::model::Result>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>
        /// <a>Result</a> objects that contain the results of transcribing a portion of the
        /// input audio stream. The array can be empty.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Result>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`Transcript`](crate::model::Transcript)
        pub fn build(self) -> crate::model::Transcript {
            crate::model::Transcript {
                results: self.results,
            }
        }
    }
}
impl Transcript {
    /// Creates a new builder-style object to manufacture [`Transcript`](crate::model::Transcript)
    pub fn builder() -> crate::model::transcript::Builder {
        crate::model::transcript::Builder::default()
    }
}

/// <p>The result of transcribing a portion of the input audio stream. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Result {
    /// <p>A unique identifier for the result. </p>
    pub result_id: std::option::Option<std::string::String>,
    /// <p>The offset in seconds from the beginning of the audio stream to the beginning of the
    /// result.</p>
    pub start_time: f64,
    /// <p>The offset in seconds from the beginning of the audio stream to the end of the
    /// result.</p>
    pub end_time: f64,
    /// <p>Amazon Transcribe divides the incoming audio stream into segments at natural points in the audio.
    /// Transcription results are returned based on these segments. </p>
    /// <p>The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe has
    /// additional transcription data to send, <code>false</code> to indicate that this is the last
    /// transcription result for the segment.</p>
    pub is_partial: bool,
    /// <p>A list of possible transcriptions for the audio. Each alternative typically contains one
    /// <code>item</code> that contains the result of the transcription.</p>
    pub alternatives: std::option::Option<std::vec::Vec<crate::model::Alternative>>,
    /// <p>When channel identification is enabled, Amazon Transcribe transcribes the speech from each audio
    /// channel separately.</p>
    /// <p>You can use <code>ChannelId</code> to retrieve the transcription results for a single
    /// channel in your audio stream.</p>
    pub channel_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Result {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Result");
        formatter.field("result_id", &self.result_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("is_partial", &self.is_partial);
        formatter.field("alternatives", &self.alternatives);
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}
/// See [`Result`](crate::model::Result)
pub mod result {
    /// A builder for [`Result`](crate::model::Result)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<f64>,
        pub(crate) end_time: std::option::Option<f64>,
        pub(crate) is_partial: std::option::Option<bool>,
        pub(crate) alternatives: std::option::Option<std::vec::Vec<crate::model::Alternative>>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the result. </p>
        pub fn result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the result. </p>
        pub fn set_result_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_id = input;
            self
        }
        /// <p>The offset in seconds from the beginning of the audio stream to the beginning of the
        /// result.</p>
        pub fn start_time(mut self, input: f64) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The offset in seconds from the beginning of the audio stream to the beginning of the
        /// result.</p>
        pub fn set_start_time(mut self, input: std::option::Option<f64>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The offset in seconds from the beginning of the audio stream to the end of the
        /// result.</p>
        pub fn end_time(mut self, input: f64) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The offset in seconds from the beginning of the audio stream to the end of the
        /// result.</p>
        pub fn set_end_time(mut self, input: std::option::Option<f64>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Amazon Transcribe divides the incoming audio stream into segments at natural points in the audio.
        /// Transcription results are returned based on these segments. </p>
        /// <p>The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe has
        /// additional transcription data to send, <code>false</code> to indicate that this is the last
        /// transcription result for the segment.</p>
        pub fn is_partial(mut self, input: bool) -> Self {
            self.is_partial = Some(input);
            self
        }
        /// <p>Amazon Transcribe divides the incoming audio stream into segments at natural points in the audio.
        /// Transcription results are returned based on these segments. </p>
        /// <p>The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe has
        /// additional transcription data to send, <code>false</code> to indicate that this is the last
        /// transcription result for the segment.</p>
        pub fn set_is_partial(mut self, input: std::option::Option<bool>) -> Self {
            self.is_partial = input;
            self
        }
        /// Appends an item to `alternatives`.
        ///
        /// To override the contents of this collection use [`set_alternatives`](Self::set_alternatives).
        ///
        /// <p>A list of possible transcriptions for the audio. Each alternative typically contains one
        /// <code>item</code> that contains the result of the transcription.</p>
        pub fn alternatives(mut self, input: impl Into<crate::model::Alternative>) -> Self {
            let mut v = self.alternatives.unwrap_or_default();
            v.push(input.into());
            self.alternatives = Some(v);
            self
        }
        /// <p>A list of possible transcriptions for the audio. Each alternative typically contains one
        /// <code>item</code> that contains the result of the transcription.</p>
        pub fn set_alternatives(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alternative>>,
        ) -> Self {
            self.alternatives = input;
            self
        }
        /// <p>When channel identification is enabled, Amazon Transcribe transcribes the speech from each audio
        /// channel separately.</p>
        /// <p>You can use <code>ChannelId</code> to retrieve the transcription results for a single
        /// channel in your audio stream.</p>
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// <p>When channel identification is enabled, Amazon Transcribe transcribes the speech from each audio
        /// channel separately.</p>
        /// <p>You can use <code>ChannelId</code> to retrieve the transcription results for a single
        /// channel in your audio stream.</p>
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Result`](crate::model::Result)
        pub fn build(self) -> crate::model::Result {
            crate::model::Result {
                result_id: self.result_id,
                start_time: self.start_time.unwrap_or_default(),
                end_time: self.end_time.unwrap_or_default(),
                is_partial: self.is_partial.unwrap_or_default(),
                alternatives: self.alternatives,
                channel_id: self.channel_id,
            }
        }
    }
}
impl Result {
    /// Creates a new builder-style object to manufacture [`Result`](crate::model::Result)
    pub fn builder() -> crate::model::result::Builder {
        crate::model::result::Builder::default()
    }
}

/// <p>A list of possible transcriptions for the audio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alternative {
    /// <p>The text that was transcribed from the audio.</p>
    pub transcript: std::option::Option<std::string::String>,
    /// <p>One or more alternative interpretations of the input audio. </p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Item>>,
    /// <p>Contains the entities identified as personally identifiable information (PII) in the transcription output.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
}
impl std::fmt::Debug for Alternative {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alternative");
        formatter.field("transcript", &self.transcript);
        formatter.field("items", &self.items);
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}
/// See [`Alternative`](crate::model::Alternative)
pub mod alternative {
    /// A builder for [`Alternative`](crate::model::Alternative)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transcript: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Item>>,
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::Entity>>,
    }
    impl Builder {
        /// <p>The text that was transcribed from the audio.</p>
        pub fn transcript(mut self, input: impl Into<std::string::String>) -> Self {
            self.transcript = Some(input.into());
            self
        }
        /// <p>The text that was transcribed from the audio.</p>
        pub fn set_transcript(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transcript = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>One or more alternative interpretations of the input audio. </p>
        pub fn items(mut self, input: impl Into<crate::model::Item>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>One or more alternative interpretations of the input audio. </p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Item>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>Contains the entities identified as personally identifiable information (PII) in the transcription output.</p>
        pub fn entities(mut self, input: impl Into<crate::model::Entity>) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input.into());
            self.entities = Some(v);
            self
        }
        /// <p>Contains the entities identified as personally identifiable information (PII) in the transcription output.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`Alternative`](crate::model::Alternative)
        pub fn build(self) -> crate::model::Alternative {
            crate::model::Alternative {
                transcript: self.transcript,
                items: self.items,
                entities: self.entities,
            }
        }
    }
}
impl Alternative {
    /// Creates a new builder-style object to manufacture [`Alternative`](crate::model::Alternative)
    pub fn builder() -> crate::model::alternative::Builder {
        crate::model::alternative::Builder::default()
    }
}

/// <p>The entity identified as personally identifiable information (PII).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entity {
    /// <p>The start time of speech that was identified as PII.</p>
    pub start_time: f64,
    /// <p>The end time of speech that was identified as PII.</p>
    pub end_time: f64,
    /// <p>The category of of information identified in this entity; for example, PII.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>The type of PII identified in this entity; for example, name or credit card number.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The words in the transcription output that have been identified as a PII entity.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>A value between zero and one that Amazon Transcribe assigns to PII identified in the source audio. Larger values indicate a higher confidence in PII identification.</p>
    pub confidence: std::option::Option<f64>,
}
impl std::fmt::Debug for Entity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entity");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("category", &self.category);
        formatter.field("r#type", &self.r#type);
        formatter.field("content", &self.content);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Entity`](crate::model::Entity)
pub mod entity {
    /// A builder for [`Entity`](crate::model::Entity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<f64>,
        pub(crate) end_time: std::option::Option<f64>,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The start time of speech that was identified as PII.</p>
        pub fn start_time(mut self, input: f64) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of speech that was identified as PII.</p>
        pub fn set_start_time(mut self, input: std::option::Option<f64>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of speech that was identified as PII.</p>
        pub fn end_time(mut self, input: f64) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of speech that was identified as PII.</p>
        pub fn set_end_time(mut self, input: std::option::Option<f64>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The category of of information identified in this entity; for example, PII.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>The category of of information identified in this entity; for example, PII.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// <p>The type of PII identified in this entity; for example, name or credit card number.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of PII identified in this entity; for example, name or credit card number.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The words in the transcription output that have been identified as a PII entity.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The words in the transcription output that have been identified as a PII entity.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>A value between zero and one that Amazon Transcribe assigns to PII identified in the source audio. Larger values indicate a higher confidence in PII identification.</p>
        pub fn confidence(mut self, input: f64) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>A value between zero and one that Amazon Transcribe assigns to PII identified in the source audio. Larger values indicate a higher confidence in PII identification.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f64>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Entity`](crate::model::Entity)
        pub fn build(self) -> crate::model::Entity {
            crate::model::Entity {
                start_time: self.start_time.unwrap_or_default(),
                end_time: self.end_time.unwrap_or_default(),
                category: self.category,
                r#type: self.r#type,
                content: self.content,
                confidence: self.confidence,
            }
        }
    }
}
impl Entity {
    /// Creates a new builder-style object to manufacture [`Entity`](crate::model::Entity)
    pub fn builder() -> crate::model::entity::Builder {
        crate::model::entity::Builder::default()
    }
}

/// <p>A word, phrase, or punctuation mark that is transcribed from the input audio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Item {
    /// <p>The offset from the beginning of the audio stream to the beginning of the audio that
    /// resulted in the item.</p>
    pub start_time: f64,
    /// <p>The offset from the beginning of the audio stream to the end of the audio that resulted in
    /// the item.</p>
    pub end_time: f64,
    /// <p>The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that
    /// was recognized in the input audio. <code>PUNCTUATION</code> indicates that the item was
    /// interpreted as a pause in the input audio.</p>
    pub r#type: std::option::Option<crate::model::ItemType>,
    /// <p>The word or punctuation that was recognized in the input audio.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>Indicates whether a word in the item matches a word in the vocabulary filter you've chosen
    /// for your real-time stream. If <code>true</code> then a word in the item matches your
    /// vocabulary filter.</p>
    pub vocabulary_filter_match: bool,
    /// <p>If speaker identification is enabled, shows the speakers identified in the real-time
    /// stream.</p>
    pub speaker: std::option::Option<std::string::String>,
    /// <p>A value between 0 and 1 for an item that is a confidence score that Amazon Transcribe assigns to each
    /// word or phrase that it transcribes.</p>
    pub confidence: std::option::Option<f64>,
    /// <p>If partial result stabilization has been enabled, indicates whether the word or phrase in
    /// the item is stable. If <code>Stable</code> is <code>true</code>, the result is stable.</p>
    pub stable: std::option::Option<bool>,
}
impl std::fmt::Debug for Item {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Item");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("r#type", &self.r#type);
        formatter.field("content", &self.content);
        formatter.field("vocabulary_filter_match", &self.vocabulary_filter_match);
        formatter.field("speaker", &self.speaker);
        formatter.field("confidence", &self.confidence);
        formatter.field("stable", &self.stable);
        formatter.finish()
    }
}
/// See [`Item`](crate::model::Item)
pub mod item {
    /// A builder for [`Item`](crate::model::Item)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<f64>,
        pub(crate) end_time: std::option::Option<f64>,
        pub(crate) r#type: std::option::Option<crate::model::ItemType>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) vocabulary_filter_match: std::option::Option<bool>,
        pub(crate) speaker: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f64>,
        pub(crate) stable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The offset from the beginning of the audio stream to the beginning of the audio that
        /// resulted in the item.</p>
        pub fn start_time(mut self, input: f64) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The offset from the beginning of the audio stream to the beginning of the audio that
        /// resulted in the item.</p>
        pub fn set_start_time(mut self, input: std::option::Option<f64>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The offset from the beginning of the audio stream to the end of the audio that resulted in
        /// the item.</p>
        pub fn end_time(mut self, input: f64) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The offset from the beginning of the audio stream to the end of the audio that resulted in
        /// the item.</p>
        pub fn set_end_time(mut self, input: std::option::Option<f64>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that
        /// was recognized in the input audio. <code>PUNCTUATION</code> indicates that the item was
        /// interpreted as a pause in the input audio.</p>
        pub fn r#type(mut self, input: crate::model::ItemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word that
        /// was recognized in the input audio. <code>PUNCTUATION</code> indicates that the item was
        /// interpreted as a pause in the input audio.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ItemType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The word or punctuation that was recognized in the input audio.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The word or punctuation that was recognized in the input audio.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>Indicates whether a word in the item matches a word in the vocabulary filter you've chosen
        /// for your real-time stream. If <code>true</code> then a word in the item matches your
        /// vocabulary filter.</p>
        pub fn vocabulary_filter_match(mut self, input: bool) -> Self {
            self.vocabulary_filter_match = Some(input);
            self
        }
        /// <p>Indicates whether a word in the item matches a word in the vocabulary filter you've chosen
        /// for your real-time stream. If <code>true</code> then a word in the item matches your
        /// vocabulary filter.</p>
        pub fn set_vocabulary_filter_match(mut self, input: std::option::Option<bool>) -> Self {
            self.vocabulary_filter_match = input;
            self
        }
        /// <p>If speaker identification is enabled, shows the speakers identified in the real-time
        /// stream.</p>
        pub fn speaker(mut self, input: impl Into<std::string::String>) -> Self {
            self.speaker = Some(input.into());
            self
        }
        /// <p>If speaker identification is enabled, shows the speakers identified in the real-time
        /// stream.</p>
        pub fn set_speaker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.speaker = input;
            self
        }
        /// <p>A value between 0 and 1 for an item that is a confidence score that Amazon Transcribe assigns to each
        /// word or phrase that it transcribes.</p>
        pub fn confidence(mut self, input: f64) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>A value between 0 and 1 for an item that is a confidence score that Amazon Transcribe assigns to each
        /// word or phrase that it transcribes.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f64>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>If partial result stabilization has been enabled, indicates whether the word or phrase in
        /// the item is stable. If <code>Stable</code> is <code>true</code>, the result is stable.</p>
        pub fn stable(mut self, input: bool) -> Self {
            self.stable = Some(input);
            self
        }
        /// <p>If partial result stabilization has been enabled, indicates whether the word or phrase in
        /// the item is stable. If <code>Stable</code> is <code>true</code>, the result is stable.</p>
        pub fn set_stable(mut self, input: std::option::Option<bool>) -> Self {
            self.stable = input;
            self
        }
        /// Consumes the builder and constructs a [`Item`](crate::model::Item)
        pub fn build(self) -> crate::model::Item {
            crate::model::Item {
                start_time: self.start_time.unwrap_or_default(),
                end_time: self.end_time.unwrap_or_default(),
                r#type: self.r#type,
                content: self.content,
                vocabulary_filter_match: self.vocabulary_filter_match.unwrap_or_default(),
                speaker: self.speaker,
                confidence: self.confidence,
                stable: self.stable,
            }
        }
    }
}
impl Item {
    /// Creates a new builder-style object to manufacture [`Item`](crate::model::Item)
    pub fn builder() -> crate::model::item::Builder {
        crate::model::item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ItemType {
    #[allow(missing_docs)] // documentation missing in model
    Pronunciation,
    #[allow(missing_docs)] // documentation missing in model
    Punctuation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ItemType {
    fn from(s: &str) -> Self {
        match s {
            "pronunciation" => ItemType::Pronunciation,
            "punctuation" => ItemType::Punctuation,
            other => ItemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ItemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ItemType::from(s))
    }
}
impl ItemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ItemType::Pronunciation => "pronunciation",
            ItemType::Punctuation => "punctuation",
            ItemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["pronunciation", "punctuation"]
    }
}
impl AsRef<str> for ItemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MediaEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Flac,
    #[allow(missing_docs)] // documentation missing in model
    OggOpus,
    #[allow(missing_docs)] // documentation missing in model
    Pcm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MediaEncoding {
    fn from(s: &str) -> Self {
        match s {
            "flac" => MediaEncoding::Flac,
            "ogg-opus" => MediaEncoding::OggOpus,
            "pcm" => MediaEncoding::Pcm,
            other => MediaEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MediaEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MediaEncoding::from(s))
    }
}
impl MediaEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MediaEncoding::Flac => "flac",
            MediaEncoding::OggOpus => "ogg-opus",
            MediaEncoding::Pcm => "pcm",
            MediaEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["flac", "ogg-opus", "pcm"]
    }
}
impl AsRef<str> for MediaEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LanguageCode {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnAu,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    EsUs,
    #[allow(missing_docs)] // documentation missing in model
    FrCa,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JaJp,
    #[allow(missing_docs)] // documentation missing in model
    KoKr,
    #[allow(missing_docs)] // documentation missing in model
    PtBr,
    #[allow(missing_docs)] // documentation missing in model
    ZhCn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LanguageCode {
    fn from(s: &str) -> Self {
        match s {
            "de-DE" => LanguageCode::DeDe,
            "en-AU" => LanguageCode::EnAu,
            "en-GB" => LanguageCode::EnGb,
            "en-US" => LanguageCode::EnUs,
            "es-US" => LanguageCode::EsUs,
            "fr-CA" => LanguageCode::FrCa,
            "fr-FR" => LanguageCode::FrFr,
            "it-IT" => LanguageCode::ItIt,
            "ja-JP" => LanguageCode::JaJp,
            "ko-KR" => LanguageCode::KoKr,
            "pt-BR" => LanguageCode::PtBr,
            "zh-CN" => LanguageCode::ZhCn,
            other => LanguageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LanguageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LanguageCode::from(s))
    }
}
impl LanguageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LanguageCode::DeDe => "de-DE",
            LanguageCode::EnAu => "en-AU",
            LanguageCode::EnGb => "en-GB",
            LanguageCode::EnUs => "en-US",
            LanguageCode::EsUs => "es-US",
            LanguageCode::FrCa => "fr-CA",
            LanguageCode::FrFr => "fr-FR",
            LanguageCode::ItIt => "it-IT",
            LanguageCode::JaJp => "ja-JP",
            LanguageCode::KoKr => "ko-KR",
            LanguageCode::PtBr => "pt-BR",
            LanguageCode::ZhCn => "zh-CN",
            LanguageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "de-DE", "en-AU", "en-GB", "en-US", "es-US", "fr-CA", "fr-FR", "it-IT", "ja-JP",
            "ko-KR", "pt-BR", "zh-CN",
        ]
    }
}
impl AsRef<str> for LanguageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the audio stream from your application to Amazon Transcribe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AudioStream {
    /// <p>A blob of audio from your application. You audio stream consists of one or more audio
    /// events.</p>
    /// <p>For information on audio encoding formats in Amazon Transcribe, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/input.html">Speech input</a>. For
    /// information on audio encoding formats in Amazon Transcribe Medical, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/input-med.html">Speech input</a>.</p>
    /// <p>For more information on stream encoding in Amazon Transcribe, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream encoding</a>. For
    /// information on stream encoding in Amazon Transcribe Medical, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream-med.html">Event stream encoding</a>.</p>
    AudioEvent(crate::model::AudioEvent),
}
impl AudioStream {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into its [`AudioStream`](crate::model::AudioStream) variant.
    /// Returns `Err(&Self) if it can't be converted.`
    pub fn as_audio_event(&self) -> std::result::Result<&crate::model::AudioEvent, &Self> {
        if let AudioStream::AudioEvent(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if the enum instance is the `AudioStream` variant.
    pub fn is_audio_event(&self) -> bool {
        self.as_audio_event().is_ok()
    }
}

/// <p>Provides a wrapper for the audio chunks that you are sending.</p>
/// <p>For information on audio encoding in Amazon Transcribe, see
/// <a href="https://docs.aws.amazon.com/transcribe/latest/dg/input.html">Speech input</a>. For information
/// on audio encoding formats in Amazon Transcribe Medical, see
/// <a href="https://docs.aws.amazon.com/transcribe/latest/dg/input-med.html">Speech input</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioEvent {
    /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The
    /// maximum audio chunk size is 32 KB.</p>
    pub audio_chunk: std::option::Option<aws_smithy_types::Blob>,
}
impl std::fmt::Debug for AudioEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioEvent");
        formatter.field("audio_chunk", &self.audio_chunk);
        formatter.finish()
    }
}
/// See [`AudioEvent`](crate::model::AudioEvent)
pub mod audio_event {
    /// A builder for [`AudioEvent`](crate::model::AudioEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_chunk: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The
        /// maximum audio chunk size is 32 KB.</p>
        pub fn audio_chunk(mut self, input: aws_smithy_types::Blob) -> Self {
            self.audio_chunk = Some(input);
            self
        }
        /// <p>An audio blob that contains the next part of the audio that you want to transcribe. The
        /// maximum audio chunk size is 32 KB.</p>
        pub fn set_audio_chunk(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.audio_chunk = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioEvent`](crate::model::AudioEvent)
        pub fn build(self) -> crate::model::AudioEvent {
            crate::model::AudioEvent {
                audio_chunk: self.audio_chunk,
            }
        }
    }
}
impl AudioEvent {
    /// Creates a new builder-style object to manufacture [`AudioEvent`](crate::model::AudioEvent)
    pub fn builder() -> crate::model::audio_event::Builder {
        crate::model::audio_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MedicalContentIdentificationType {
    #[allow(missing_docs)] // documentation missing in model
    Phi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MedicalContentIdentificationType {
    fn from(s: &str) -> Self {
        match s {
            "PHI" => MedicalContentIdentificationType::Phi,
            other => MedicalContentIdentificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MedicalContentIdentificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MedicalContentIdentificationType::from(s))
    }
}
impl MedicalContentIdentificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MedicalContentIdentificationType::Phi => "PHI",
            MedicalContentIdentificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PHI"]
    }
}
impl AsRef<str> for MedicalContentIdentificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the transcription result stream from Amazon Transcribe Medical to your application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum MedicalTranscriptResultStream {
    /// <p>A portion of the transcription of the audio stream. Events are sent periodically from
    /// Amazon Transcribe Medical to your application. The event can be a partial transcription of a section of the
    /// audio stream, or it can be the entire transcription of that portion of the audio
    /// stream.</p>
    TranscriptEvent(crate::model::MedicalTranscriptEvent),
}
impl MedicalTranscriptResultStream {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into its [`MedicalTranscriptResultStream`](crate::model::MedicalTranscriptResultStream) variant.
    /// Returns `Err(&Self) if it can't be converted.`
    pub fn as_transcript_event(
        &self,
    ) -> std::result::Result<&crate::model::MedicalTranscriptEvent, &Self> {
        if let MedicalTranscriptResultStream::TranscriptEvent(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if the enum instance is the `MedicalTranscriptResultStream` variant.
    pub fn is_transcript_event(&self) -> bool {
        self.as_transcript_event().is_ok()
    }
}

/// <p>Represents a set of transcription results from the server to the client. It contains
/// one or more segments of the transcription.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MedicalTranscriptEvent {
    /// <p>The transcription of the audio stream. The transcription is composed of all of the
    /// items in the results list.</p>
    pub transcript: std::option::Option<crate::model::MedicalTranscript>,
}
impl std::fmt::Debug for MedicalTranscriptEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MedicalTranscriptEvent");
        formatter.field("transcript", &self.transcript);
        formatter.finish()
    }
}
/// See [`MedicalTranscriptEvent`](crate::model::MedicalTranscriptEvent)
pub mod medical_transcript_event {
    /// A builder for [`MedicalTranscriptEvent`](crate::model::MedicalTranscriptEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transcript: std::option::Option<crate::model::MedicalTranscript>,
    }
    impl Builder {
        /// <p>The transcription of the audio stream. The transcription is composed of all of the
        /// items in the results list.</p>
        pub fn transcript(mut self, input: crate::model::MedicalTranscript) -> Self {
            self.transcript = Some(input);
            self
        }
        /// <p>The transcription of the audio stream. The transcription is composed of all of the
        /// items in the results list.</p>
        pub fn set_transcript(
            mut self,
            input: std::option::Option<crate::model::MedicalTranscript>,
        ) -> Self {
            self.transcript = input;
            self
        }
        /// Consumes the builder and constructs a [`MedicalTranscriptEvent`](crate::model::MedicalTranscriptEvent)
        pub fn build(self) -> crate::model::MedicalTranscriptEvent {
            crate::model::MedicalTranscriptEvent {
                transcript: self.transcript,
            }
        }
    }
}
impl MedicalTranscriptEvent {
    /// Creates a new builder-style object to manufacture [`MedicalTranscriptEvent`](crate::model::MedicalTranscriptEvent)
    pub fn builder() -> crate::model::medical_transcript_event::Builder {
        crate::model::medical_transcript_event::Builder::default()
    }
}

/// <p>The medical transcript in a <a>MedicalTranscriptEvent</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MedicalTranscript {
    /// <p>
    /// <a>MedicalResult</a> objects that contain the results of transcribing a
    /// portion of the input audio stream. The array can be empty.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::MedicalResult>>,
}
impl std::fmt::Debug for MedicalTranscript {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MedicalTranscript");
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`MedicalTranscript`](crate::model::MedicalTranscript)
pub mod medical_transcript {
    /// A builder for [`MedicalTranscript`](crate::model::MedicalTranscript)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::MedicalResult>>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>
        /// <a>MedicalResult</a> objects that contain the results of transcribing a
        /// portion of the input audio stream. The array can be empty.</p>
        pub fn results(mut self, input: impl Into<crate::model::MedicalResult>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>
        /// <a>MedicalResult</a> objects that contain the results of transcribing a
        /// portion of the input audio stream. The array can be empty.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MedicalResult>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`MedicalTranscript`](crate::model::MedicalTranscript)
        pub fn build(self) -> crate::model::MedicalTranscript {
            crate::model::MedicalTranscript {
                results: self.results,
            }
        }
    }
}
impl MedicalTranscript {
    /// Creates a new builder-style object to manufacture [`MedicalTranscript`](crate::model::MedicalTranscript)
    pub fn builder() -> crate::model::medical_transcript::Builder {
        crate::model::medical_transcript::Builder::default()
    }
}

/// <p>The results of transcribing a portion of the input audio stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MedicalResult {
    /// <p>A unique identifier for the result.</p>
    pub result_id: std::option::Option<std::string::String>,
    /// <p>The time, in seconds, from the beginning of the audio stream to the beginning of the
    /// result.</p>
    pub start_time: f64,
    /// <p>The time, in seconds, from the beginning of the audio stream to the end of the
    /// result.</p>
    pub end_time: f64,
    /// <p>Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the audio.
    /// Transcription results are returned based on these segments.</p>
    /// <p>The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has
    /// additional transcription data to send. The <code>IsPartial</code> field is
    /// <code>false</code> to indicate that this is the last transcription result for the
    /// segment.</p>
    pub is_partial: bool,
    /// <p>A list of possible transcriptions of the audio. Each alternative typically contains
    /// one <code>Item</code> that contains the result of the transcription.</p>
    pub alternatives: std::option::Option<std::vec::Vec<crate::model::MedicalAlternative>>,
    /// <p>When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each audio
    /// channel separately.</p>
    /// <p>You can use <code>ChannelId</code> to retrieve the transcription results for a single
    /// channel in your audio stream.</p>
    pub channel_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MedicalResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MedicalResult");
        formatter.field("result_id", &self.result_id);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("is_partial", &self.is_partial);
        formatter.field("alternatives", &self.alternatives);
        formatter.field("channel_id", &self.channel_id);
        formatter.finish()
    }
}
/// See [`MedicalResult`](crate::model::MedicalResult)
pub mod medical_result {
    /// A builder for [`MedicalResult`](crate::model::MedicalResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<f64>,
        pub(crate) end_time: std::option::Option<f64>,
        pub(crate) is_partial: std::option::Option<bool>,
        pub(crate) alternatives:
            std::option::Option<std::vec::Vec<crate::model::MedicalAlternative>>,
        pub(crate) channel_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the result.</p>
        pub fn result_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the result.</p>
        pub fn set_result_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result_id = input;
            self
        }
        /// <p>The time, in seconds, from the beginning of the audio stream to the beginning of the
        /// result.</p>
        pub fn start_time(mut self, input: f64) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time, in seconds, from the beginning of the audio stream to the beginning of the
        /// result.</p>
        pub fn set_start_time(mut self, input: std::option::Option<f64>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time, in seconds, from the beginning of the audio stream to the end of the
        /// result.</p>
        pub fn end_time(mut self, input: f64) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time, in seconds, from the beginning of the audio stream to the end of the
        /// result.</p>
        pub fn set_end_time(mut self, input: std::option::Option<f64>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the audio.
        /// Transcription results are returned based on these segments.</p>
        /// <p>The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has
        /// additional transcription data to send. The <code>IsPartial</code> field is
        /// <code>false</code> to indicate that this is the last transcription result for the
        /// segment.</p>
        pub fn is_partial(mut self, input: bool) -> Self {
            self.is_partial = Some(input);
            self
        }
        /// <p>Amazon Transcribe Medical divides the incoming audio stream into segments at natural points in the audio.
        /// Transcription results are returned based on these segments.</p>
        /// <p>The <code>IsPartial</code> field is <code>true</code> to indicate that Amazon Transcribe Medical has
        /// additional transcription data to send. The <code>IsPartial</code> field is
        /// <code>false</code> to indicate that this is the last transcription result for the
        /// segment.</p>
        pub fn set_is_partial(mut self, input: std::option::Option<bool>) -> Self {
            self.is_partial = input;
            self
        }
        /// Appends an item to `alternatives`.
        ///
        /// To override the contents of this collection use [`set_alternatives`](Self::set_alternatives).
        ///
        /// <p>A list of possible transcriptions of the audio. Each alternative typically contains
        /// one <code>Item</code> that contains the result of the transcription.</p>
        pub fn alternatives(mut self, input: impl Into<crate::model::MedicalAlternative>) -> Self {
            let mut v = self.alternatives.unwrap_or_default();
            v.push(input.into());
            self.alternatives = Some(v);
            self
        }
        /// <p>A list of possible transcriptions of the audio. Each alternative typically contains
        /// one <code>Item</code> that contains the result of the transcription.</p>
        pub fn set_alternatives(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MedicalAlternative>>,
        ) -> Self {
            self.alternatives = input;
            self
        }
        /// <p>When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each audio
        /// channel separately.</p>
        /// <p>You can use <code>ChannelId</code> to retrieve the transcription results for a single
        /// channel in your audio stream.</p>
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// <p>When channel identification is enabled, Amazon Transcribe Medical transcribes the speech from each audio
        /// channel separately.</p>
        /// <p>You can use <code>ChannelId</code> to retrieve the transcription results for a single
        /// channel in your audio stream.</p>
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MedicalResult`](crate::model::MedicalResult)
        pub fn build(self) -> crate::model::MedicalResult {
            crate::model::MedicalResult {
                result_id: self.result_id,
                start_time: self.start_time.unwrap_or_default(),
                end_time: self.end_time.unwrap_or_default(),
                is_partial: self.is_partial.unwrap_or_default(),
                alternatives: self.alternatives,
                channel_id: self.channel_id,
            }
        }
    }
}
impl MedicalResult {
    /// Creates a new builder-style object to manufacture [`MedicalResult`](crate::model::MedicalResult)
    pub fn builder() -> crate::model::medical_result::Builder {
        crate::model::medical_result::Builder::default()
    }
}

/// <p>A list of possible transcriptions for the audio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MedicalAlternative {
    /// <p>The text that was transcribed from the audio.</p>
    pub transcript: std::option::Option<std::string::String>,
    /// <p>A list of objects that contains words and punctuation marks that represents one or
    /// more interpretations of the input audio.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::MedicalItem>>,
    /// <p>Contains the medical entities identified as personal health information in the transcription output.</p>
    pub entities: std::option::Option<std::vec::Vec<crate::model::MedicalEntity>>,
}
impl std::fmt::Debug for MedicalAlternative {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MedicalAlternative");
        formatter.field("transcript", &self.transcript);
        formatter.field("items", &self.items);
        formatter.field("entities", &self.entities);
        formatter.finish()
    }
}
/// See [`MedicalAlternative`](crate::model::MedicalAlternative)
pub mod medical_alternative {
    /// A builder for [`MedicalAlternative`](crate::model::MedicalAlternative)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transcript: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::MedicalItem>>,
        pub(crate) entities: std::option::Option<std::vec::Vec<crate::model::MedicalEntity>>,
    }
    impl Builder {
        /// <p>The text that was transcribed from the audio.</p>
        pub fn transcript(mut self, input: impl Into<std::string::String>) -> Self {
            self.transcript = Some(input.into());
            self
        }
        /// <p>The text that was transcribed from the audio.</p>
        pub fn set_transcript(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transcript = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>A list of objects that contains words and punctuation marks that represents one or
        /// more interpretations of the input audio.</p>
        pub fn items(mut self, input: impl Into<crate::model::MedicalItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>A list of objects that contains words and punctuation marks that represents one or
        /// more interpretations of the input audio.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MedicalItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// Appends an item to `entities`.
        ///
        /// To override the contents of this collection use [`set_entities`](Self::set_entities).
        ///
        /// <p>Contains the medical entities identified as personal health information in the transcription output.</p>
        pub fn entities(mut self, input: impl Into<crate::model::MedicalEntity>) -> Self {
            let mut v = self.entities.unwrap_or_default();
            v.push(input.into());
            self.entities = Some(v);
            self
        }
        /// <p>Contains the medical entities identified as personal health information in the transcription output.</p>
        pub fn set_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MedicalEntity>>,
        ) -> Self {
            self.entities = input;
            self
        }
        /// Consumes the builder and constructs a [`MedicalAlternative`](crate::model::MedicalAlternative)
        pub fn build(self) -> crate::model::MedicalAlternative {
            crate::model::MedicalAlternative {
                transcript: self.transcript,
                items: self.items,
                entities: self.entities,
            }
        }
    }
}
impl MedicalAlternative {
    /// Creates a new builder-style object to manufacture [`MedicalAlternative`](crate::model::MedicalAlternative)
    pub fn builder() -> crate::model::medical_alternative::Builder {
        crate::model::medical_alternative::Builder::default()
    }
}

/// <p>The medical entity identified as personal health information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MedicalEntity {
    /// <p>The start time of the speech that was identified as a medical entity.</p>
    pub start_time: f64,
    /// <p>The end time of the speech that was identified as a medical entity.</p>
    pub end_time: f64,
    /// <p>The type of personal health information of the medical entity.</p>
    pub category: std::option::Option<std::string::String>,
    /// <p>The word or words in the transcription output that have been identified as a
    /// medical entity.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>A value between zero and one that Amazon Transcribe Medical assigned to the personal health information
    /// that it identified in the source audio. Larger values indicate that Amazon Transcribe Medical has higher
    /// confidence in the personal health information that it identified.</p>
    pub confidence: std::option::Option<f64>,
}
impl std::fmt::Debug for MedicalEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MedicalEntity");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("category", &self.category);
        formatter.field("content", &self.content);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`MedicalEntity`](crate::model::MedicalEntity)
pub mod medical_entity {
    /// A builder for [`MedicalEntity`](crate::model::MedicalEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<f64>,
        pub(crate) end_time: std::option::Option<f64>,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The start time of the speech that was identified as a medical entity.</p>
        pub fn start_time(mut self, input: f64) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the speech that was identified as a medical entity.</p>
        pub fn set_start_time(mut self, input: std::option::Option<f64>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the speech that was identified as a medical entity.</p>
        pub fn end_time(mut self, input: f64) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the speech that was identified as a medical entity.</p>
        pub fn set_end_time(mut self, input: std::option::Option<f64>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The type of personal health information of the medical entity.</p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p>The type of personal health information of the medical entity.</p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// <p>The word or words in the transcription output that have been identified as a
        /// medical entity.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The word or words in the transcription output that have been identified as a
        /// medical entity.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>A value between zero and one that Amazon Transcribe Medical assigned to the personal health information
        /// that it identified in the source audio. Larger values indicate that Amazon Transcribe Medical has higher
        /// confidence in the personal health information that it identified.</p>
        pub fn confidence(mut self, input: f64) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>A value between zero and one that Amazon Transcribe Medical assigned to the personal health information
        /// that it identified in the source audio. Larger values indicate that Amazon Transcribe Medical has higher
        /// confidence in the personal health information that it identified.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f64>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`MedicalEntity`](crate::model::MedicalEntity)
        pub fn build(self) -> crate::model::MedicalEntity {
            crate::model::MedicalEntity {
                start_time: self.start_time.unwrap_or_default(),
                end_time: self.end_time.unwrap_or_default(),
                category: self.category,
                content: self.content,
                confidence: self.confidence,
            }
        }
    }
}
impl MedicalEntity {
    /// Creates a new builder-style object to manufacture [`MedicalEntity`](crate::model::MedicalEntity)
    pub fn builder() -> crate::model::medical_entity::Builder {
        crate::model::medical_entity::Builder::default()
    }
}

/// <p>A word, phrase, or punctuation mark that is transcribed from the input audio.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MedicalItem {
    /// <p>The number of seconds into an audio stream that indicates the creation time of an
    /// item.</p>
    pub start_time: f64,
    /// <p>The number of seconds into an audio stream that indicates the creation time of an
    /// item.</p>
    pub end_time: f64,
    /// <p>The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word
    /// that was recognized in the input audio. <code>PUNCTUATION</code> indicates that the item
    /// was interpreted as a pause in the input audio, such as a period to indicate the end of a
    /// sentence.</p>
    pub r#type: std::option::Option<crate::model::ItemType>,
    /// <p>The word or punctuation mark that was recognized in the input audio.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>A value between 0 and 1 for an item that is a confidence score that Amazon Transcribe Medical assigns to
    /// each word that it transcribes.</p>
    pub confidence: std::option::Option<f64>,
    /// <p>If speaker identification is enabled, shows the integer values that correspond to the
    /// different speakers identified in the stream. For example, if the value of
    /// <code>Speaker</code> in the stream is either a <code>0</code> or a <code>1</code>,
    /// that indicates that Amazon Transcribe Medical has identified two speakers in the stream. The value of
    /// <code>0</code> corresponds to one speaker and the value of <code>1</code>
    /// corresponds to the other speaker.</p>
    pub speaker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MedicalItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MedicalItem");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("r#type", &self.r#type);
        formatter.field("content", &self.content);
        formatter.field("confidence", &self.confidence);
        formatter.field("speaker", &self.speaker);
        formatter.finish()
    }
}
/// See [`MedicalItem`](crate::model::MedicalItem)
pub mod medical_item {
    /// A builder for [`MedicalItem`](crate::model::MedicalItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<f64>,
        pub(crate) end_time: std::option::Option<f64>,
        pub(crate) r#type: std::option::Option<crate::model::ItemType>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f64>,
        pub(crate) speaker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of seconds into an audio stream that indicates the creation time of an
        /// item.</p>
        pub fn start_time(mut self, input: f64) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The number of seconds into an audio stream that indicates the creation time of an
        /// item.</p>
        pub fn set_start_time(mut self, input: std::option::Option<f64>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The number of seconds into an audio stream that indicates the creation time of an
        /// item.</p>
        pub fn end_time(mut self, input: f64) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The number of seconds into an audio stream that indicates the creation time of an
        /// item.</p>
        pub fn set_end_time(mut self, input: std::option::Option<f64>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word
        /// that was recognized in the input audio. <code>PUNCTUATION</code> indicates that the item
        /// was interpreted as a pause in the input audio, such as a period to indicate the end of a
        /// sentence.</p>
        pub fn r#type(mut self, input: crate::model::ItemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the item. <code>PRONUNCIATION</code> indicates that the item is a word
        /// that was recognized in the input audio. <code>PUNCTUATION</code> indicates that the item
        /// was interpreted as a pause in the input audio, such as a period to indicate the end of a
        /// sentence.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ItemType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The word or punctuation mark that was recognized in the input audio.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The word or punctuation mark that was recognized in the input audio.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>A value between 0 and 1 for an item that is a confidence score that Amazon Transcribe Medical assigns to
        /// each word that it transcribes.</p>
        pub fn confidence(mut self, input: f64) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>A value between 0 and 1 for an item that is a confidence score that Amazon Transcribe Medical assigns to
        /// each word that it transcribes.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f64>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>If speaker identification is enabled, shows the integer values that correspond to the
        /// different speakers identified in the stream. For example, if the value of
        /// <code>Speaker</code> in the stream is either a <code>0</code> or a <code>1</code>,
        /// that indicates that Amazon Transcribe Medical has identified two speakers in the stream. The value of
        /// <code>0</code> corresponds to one speaker and the value of <code>1</code>
        /// corresponds to the other speaker.</p>
        pub fn speaker(mut self, input: impl Into<std::string::String>) -> Self {
            self.speaker = Some(input.into());
            self
        }
        /// <p>If speaker identification is enabled, shows the integer values that correspond to the
        /// different speakers identified in the stream. For example, if the value of
        /// <code>Speaker</code> in the stream is either a <code>0</code> or a <code>1</code>,
        /// that indicates that Amazon Transcribe Medical has identified two speakers in the stream. The value of
        /// <code>0</code> corresponds to one speaker and the value of <code>1</code>
        /// corresponds to the other speaker.</p>
        pub fn set_speaker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.speaker = input;
            self
        }
        /// Consumes the builder and constructs a [`MedicalItem`](crate::model::MedicalItem)
        pub fn build(self) -> crate::model::MedicalItem {
            crate::model::MedicalItem {
                start_time: self.start_time.unwrap_or_default(),
                end_time: self.end_time.unwrap_or_default(),
                r#type: self.r#type,
                content: self.content,
                confidence: self.confidence,
                speaker: self.speaker,
            }
        }
    }
}
impl MedicalItem {
    /// Creates a new builder-style object to manufacture [`MedicalItem`](crate::model::MedicalItem)
    pub fn builder() -> crate::model::medical_item::Builder {
        crate::model::medical_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    Conversation,
    #[allow(missing_docs)] // documentation missing in model
    Dictation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "CONVERSATION" => Type::Conversation,
            "DICTATION" => Type::Dictation,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::Conversation => "CONVERSATION",
            Type::Dictation => "DICTATION",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONVERSATION", "DICTATION"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Specialty {
    #[allow(missing_docs)] // documentation missing in model
    Cardiology,
    #[allow(missing_docs)] // documentation missing in model
    Neurology,
    #[allow(missing_docs)] // documentation missing in model
    Oncology,
    #[allow(missing_docs)] // documentation missing in model
    Primarycare,
    #[allow(missing_docs)] // documentation missing in model
    Radiology,
    #[allow(missing_docs)] // documentation missing in model
    Urology,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Specialty {
    fn from(s: &str) -> Self {
        match s {
            "CARDIOLOGY" => Specialty::Cardiology,
            "NEUROLOGY" => Specialty::Neurology,
            "ONCOLOGY" => Specialty::Oncology,
            "PRIMARYCARE" => Specialty::Primarycare,
            "RADIOLOGY" => Specialty::Radiology,
            "UROLOGY" => Specialty::Urology,
            other => Specialty::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Specialty {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Specialty::from(s))
    }
}
impl Specialty {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Specialty::Cardiology => "CARDIOLOGY",
            Specialty::Neurology => "NEUROLOGY",
            Specialty::Oncology => "ONCOLOGY",
            Specialty::Primarycare => "PRIMARYCARE",
            Specialty::Radiology => "RADIOLOGY",
            Specialty::Urology => "UROLOGY",
            Specialty::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CARDIOLOGY",
            "NEUROLOGY",
            "ONCOLOGY",
            "PRIMARYCARE",
            "RADIOLOGY",
            "UROLOGY",
        ]
    }
}
impl AsRef<str> for Specialty {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
