// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Textract
///
/// Client for invoking operations on Amazon Textract. Each operation on Amazon Textract is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_textract::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_textract::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_textract::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AnalyzeDocument`](crate::client::fluent_builders::AnalyzeDocument) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document(Document)`](crate::client::fluent_builders::AnalyzeDocument::document) / [`set_document(Option<Document>)`](crate::client::fluent_builders::AnalyzeDocument::set_document): <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>  <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the <code>Bytes</code> field. </p>
    ///   - [`feature_types(Vec<FeatureType>)`](crate::client::fluent_builders::AnalyzeDocument::feature_types) / [`set_feature_types(Option<Vec<FeatureType>>)`](crate::client::fluent_builders::AnalyzeDocument::set_feature_types): <p>A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
    ///   - [`human_loop_config(HumanLoopConfig)`](crate::client::fluent_builders::AnalyzeDocument::human_loop_config) / [`set_human_loop_config(Option<HumanLoopConfig>)`](crate::client::fluent_builders::AnalyzeDocument::set_human_loop_config): <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
    /// - On success, responds with [`AnalyzeDocumentOutput`](crate::output::AnalyzeDocumentOutput) with field(s):
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::AnalyzeDocumentOutput::document_metadata): <p>Metadata about the analyzed document. An example is the number of pages.</p>
    ///   - [`blocks(Option<Vec<Block>>)`](crate::output::AnalyzeDocumentOutput::blocks): <p>The items that are detected and analyzed by <code>AnalyzeDocument</code>.</p>
    ///   - [`human_loop_activation_output(Option<HumanLoopActivationOutput>)`](crate::output::AnalyzeDocumentOutput::human_loop_activation_output): <p>Shows the results of the human in the loop evaluation.</p>
    ///   - [`analyze_document_model_version(Option<String>)`](crate::output::AnalyzeDocumentOutput::analyze_document_model_version): <p>The version of the model used to analyze the document.</p>
    /// - On failure, responds with [`SdkError<AnalyzeDocumentError>`](crate::error::AnalyzeDocumentError)
    pub fn analyze_document(&self) -> fluent_builders::AnalyzeDocument {
        fluent_builders::AnalyzeDocument::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AnalyzeExpense`](crate::client::fluent_builders::AnalyzeExpense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document(Document)`](crate::client::fluent_builders::AnalyzeExpense::document) / [`set_document(Option<Document>)`](crate::client::fluent_builders::AnalyzeExpense::set_document): <p>The input document, either as bytes or as an S3 object.</p>  <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass a document loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64 encoded. Your code might not need to encode document file bytes if you're using an AWS SDK to call Amazon Textract API operations. </p>  <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64 encoded.</p>  <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS Region that you use for Amazon Textract operations.</p>  <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using the Bytes property isn't supported. You must first upload the document to an Amazon S3 bucket, and then call the operation using the S3Object property.</p>  <p>For Amazon Textract to process an S3 object, the user must have permission to access the S3 object. </p>
    /// - On success, responds with [`AnalyzeExpenseOutput`](crate::output::AnalyzeExpenseOutput) with field(s):
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::AnalyzeExpenseOutput::document_metadata): <p>Information about the input document.</p>
    ///   - [`expense_documents(Option<Vec<ExpenseDocument>>)`](crate::output::AnalyzeExpenseOutput::expense_documents): <p>The expenses detected by Amazon Textract.</p>
    /// - On failure, responds with [`SdkError<AnalyzeExpenseError>`](crate::error::AnalyzeExpenseError)
    pub fn analyze_expense(&self) -> fluent_builders::AnalyzeExpense {
        fluent_builders::AnalyzeExpense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AnalyzeID`](crate::client::fluent_builders::AnalyzeID) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_pages(Vec<Document>)`](crate::client::fluent_builders::AnalyzeID::document_pages) / [`set_document_pages(Option<Vec<Document>>)`](crate::client::fluent_builders::AnalyzeID::set_document_pages): <p>The document being passed to AnalyzeID.</p>
    /// - On success, responds with [`AnalyzeIdOutput`](crate::output::AnalyzeIdOutput) with field(s):
    ///   - [`identity_documents(Option<Vec<IdentityDocument>>)`](crate::output::AnalyzeIdOutput::identity_documents): <p>The list of documents processed by AnalyzeID. Includes a number denoting their place in the list and the response structure for the document.</p>
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::AnalyzeIdOutput::document_metadata): <p>Information about the input document.</p>
    ///   - [`analyze_id_model_version(Option<String>)`](crate::output::AnalyzeIdOutput::analyze_id_model_version): <p>The version of the AnalyzeIdentity API being used to process documents.</p>
    /// - On failure, responds with [`SdkError<AnalyzeIDError>`](crate::error::AnalyzeIDError)
    pub fn analyze_id(&self) -> fluent_builders::AnalyzeID {
        fluent_builders::AnalyzeID::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectDocumentText`](crate::client::fluent_builders::DetectDocumentText) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document(Document)`](crate::client::fluent_builders::DetectDocumentText::document) / [`set_document(Option<Document>)`](crate::client::fluent_builders::DetectDocumentText::set_document): <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>  <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the <code>Bytes</code> field. </p>
    /// - On success, responds with [`DetectDocumentTextOutput`](crate::output::DetectDocumentTextOutput) with field(s):
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::DetectDocumentTextOutput::document_metadata): <p>Metadata about the document. It contains the number of pages that are detected in the document.</p>
    ///   - [`blocks(Option<Vec<Block>>)`](crate::output::DetectDocumentTextOutput::blocks): <p>An array of <code>Block</code> objects that contain the text that's detected in the document.</p>
    ///   - [`detect_document_text_model_version(Option<String>)`](crate::output::DetectDocumentTextOutput::detect_document_text_model_version): <p></p>
    /// - On failure, responds with [`SdkError<DetectDocumentTextError>`](crate::error::DetectDocumentTextError)
    pub fn detect_document_text(&self) -> fluent_builders::DetectDocumentText {
        fluent_builders::DetectDocumentText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentAnalysis`](crate::client::fluent_builders::GetDocumentAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentAnalysis::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetDocumentAnalysis::set_job_id): <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDocumentAnalysis::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDocumentAnalysis::set_max_results): <p>The maximum number of results to return per paginated call. The largest value that you can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDocumentAnalysis::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDocumentAnalysis::set_next_token): <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    /// - On success, responds with [`GetDocumentAnalysisOutput`](crate::output::GetDocumentAnalysisOutput) with field(s):
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::GetDocumentAnalysisOutput::document_metadata): <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in every page of paginated responses from an Amazon Textract video operation.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::GetDocumentAnalysisOutput::job_status): <p>The current status of the text detection job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDocumentAnalysisOutput::next_token): <p>If the response is truncated, Amazon Textract returns this token. You can use this token in the subsequent request to retrieve the next set of text detection results.</p>
    ///   - [`blocks(Option<Vec<Block>>)`](crate::output::GetDocumentAnalysisOutput::blocks): <p>The results of the text-analysis operation.</p>
    ///   - [`warnings(Option<Vec<Warning>>)`](crate::output::GetDocumentAnalysisOutput::warnings): <p>A list of warnings that occurred during the document-analysis operation.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetDocumentAnalysisOutput::status_message): <p>Returns if the detection job could not be completed. Contains explanation for what error occured.</p>
    ///   - [`analyze_document_model_version(Option<String>)`](crate::output::GetDocumentAnalysisOutput::analyze_document_model_version): <p></p>
    /// - On failure, responds with [`SdkError<GetDocumentAnalysisError>`](crate::error::GetDocumentAnalysisError)
    pub fn get_document_analysis(&self) -> fluent_builders::GetDocumentAnalysis {
        fluent_builders::GetDocumentAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDocumentTextDetection`](crate::client::fluent_builders::GetDocumentTextDetection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetDocumentTextDetection::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetDocumentTextDetection::set_job_id): <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDocumentTextDetection::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDocumentTextDetection::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDocumentTextDetection::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDocumentTextDetection::set_next_token): <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    /// - On success, responds with [`GetDocumentTextDetectionOutput`](crate::output::GetDocumentTextDetectionOutput) with field(s):
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::GetDocumentTextDetectionOutput::document_metadata): <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in every page of paginated responses from an Amazon Textract video operation.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::GetDocumentTextDetectionOutput::job_status): <p>The current status of the text detection job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDocumentTextDetectionOutput::next_token): <p>If the response is truncated, Amazon Textract returns this token. You can use this token in the subsequent request to retrieve the next set of text-detection results.</p>
    ///   - [`blocks(Option<Vec<Block>>)`](crate::output::GetDocumentTextDetectionOutput::blocks): <p>The results of the text-detection operation.</p>
    ///   - [`warnings(Option<Vec<Warning>>)`](crate::output::GetDocumentTextDetectionOutput::warnings): <p>A list of warnings that occurred during the text-detection operation for the document.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetDocumentTextDetectionOutput::status_message): <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
    ///   - [`detect_document_text_model_version(Option<String>)`](crate::output::GetDocumentTextDetectionOutput::detect_document_text_model_version): <p></p>
    /// - On failure, responds with [`SdkError<GetDocumentTextDetectionError>`](crate::error::GetDocumentTextDetectionError)
    pub fn get_document_text_detection(&self) -> fluent_builders::GetDocumentTextDetection {
        fluent_builders::GetDocumentTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExpenseAnalysis`](crate::client::fluent_builders::GetExpenseAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetExpenseAnalysis::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetExpenseAnalysis::set_job_id): <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetExpenseAnalysis::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetExpenseAnalysis::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 20. If you specify a value greater than 20, a maximum of 20 results is returned. The default value is 20.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetExpenseAnalysis::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetExpenseAnalysis::set_next_token): <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
    /// - On success, responds with [`GetExpenseAnalysisOutput`](crate::output::GetExpenseAnalysisOutput) with field(s):
    ///   - [`document_metadata(Option<DocumentMetadata>)`](crate::output::GetExpenseAnalysisOutput::document_metadata): <p>Information about a document that Amazon Textract processed. <code>DocumentMetadata</code> is returned in every page of paginated responses from an Amazon Textract operation.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::GetExpenseAnalysisOutput::job_status): <p>The current status of the text detection job.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetExpenseAnalysisOutput::next_token): <p>If the response is truncated, Amazon Textract returns this token. You can use this token in the subsequent request to retrieve the next set of text-detection results.</p>
    ///   - [`expense_documents(Option<Vec<ExpenseDocument>>)`](crate::output::GetExpenseAnalysisOutput::expense_documents): <p>The expenses detected by Amazon Textract.</p>
    ///   - [`warnings(Option<Vec<Warning>>)`](crate::output::GetExpenseAnalysisOutput::warnings): <p>A list of warnings that occurred during the text-detection operation for the document.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetExpenseAnalysisOutput::status_message): <p>Returns if the detection job could not be completed. Contains explanation for what error occured. </p>
    ///   - [`analyze_expense_model_version(Option<String>)`](crate::output::GetExpenseAnalysisOutput::analyze_expense_model_version): <p>The current model version of AnalyzeExpense.</p>
    /// - On failure, responds with [`SdkError<GetExpenseAnalysisError>`](crate::error::GetExpenseAnalysisError)
    pub fn get_expense_analysis(&self) -> fluent_builders::GetExpenseAnalysis {
        fluent_builders::GetExpenseAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDocumentAnalysis`](crate::client::fluent_builders::StartDocumentAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_location(DocumentLocation)`](crate::client::fluent_builders::StartDocumentAnalysis::document_location) / [`set_document_location(Option<DocumentLocation>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_document_location): <p>The location of the document to be processed.</p>
    ///   - [`feature_types(Vec<FeatureType>)`](crate::client::fluent_builders::StartDocumentAnalysis::feature_types) / [`set_feature_types(Option<Vec<FeatureType>>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_feature_types): <p>A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartDocumentAnalysis::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_client_request_token): <p>The idempotent token that you use to identify the start request. If you use the same token with multiple <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartDocumentAnalysis::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_job_tag): <p>An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartDocumentAnalysis::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_notification_channel): <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
    ///   - [`output_config(OutputConfig)`](crate::client::fluent_builders::StartDocumentAnalysis::output_config) / [`set_output_config(Option<OutputConfig>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_output_config): <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the GetDocumentAnalysis operation.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartDocumentAnalysis::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartDocumentAnalysis::set_kms_key_id): <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
    /// - On success, responds with [`StartDocumentAnalysisOutput`](crate::output::StartDocumentAnalysisOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartDocumentAnalysisOutput::job_id): <p>The identifier for the document text detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    /// - On failure, responds with [`SdkError<StartDocumentAnalysisError>`](crate::error::StartDocumentAnalysisError)
    pub fn start_document_analysis(&self) -> fluent_builders::StartDocumentAnalysis {
        fluent_builders::StartDocumentAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDocumentTextDetection`](crate::client::fluent_builders::StartDocumentTextDetection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_location(DocumentLocation)`](crate::client::fluent_builders::StartDocumentTextDetection::document_location) / [`set_document_location(Option<DocumentLocation>)`](crate::client::fluent_builders::StartDocumentTextDetection::set_document_location): <p>The location of the document to be processed.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartDocumentTextDetection::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartDocumentTextDetection::set_client_request_token): <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartDocumentTextDetection::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartDocumentTextDetection::set_job_tag): <p>An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartDocumentTextDetection::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartDocumentTextDetection::set_notification_channel): <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
    ///   - [`output_config(OutputConfig)`](crate::client::fluent_builders::StartDocumentTextDetection::output_config) / [`set_output_config(Option<OutputConfig>)`](crate::client::fluent_builders::StartDocumentTextDetection::set_output_config): <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartDocumentTextDetection::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartDocumentTextDetection::set_kms_key_id): <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
    /// - On success, responds with [`StartDocumentTextDetectionOutput`](crate::output::StartDocumentTextDetectionOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartDocumentTextDetectionOutput::job_id): <p>The identifier of the text detection job for the document. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    /// - On failure, responds with [`SdkError<StartDocumentTextDetectionError>`](crate::error::StartDocumentTextDetectionError)
    pub fn start_document_text_detection(&self) -> fluent_builders::StartDocumentTextDetection {
        fluent_builders::StartDocumentTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartExpenseAnalysis`](crate::client::fluent_builders::StartExpenseAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`document_location(DocumentLocation)`](crate::client::fluent_builders::StartExpenseAnalysis::document_location) / [`set_document_location(Option<DocumentLocation>)`](crate::client::fluent_builders::StartExpenseAnalysis::set_document_location): <p>The location of the document to be processed.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartExpenseAnalysis::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartExpenseAnalysis::set_client_request_token): <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a> </p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartExpenseAnalysis::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartExpenseAnalysis::set_job_tag): <p>An identifier you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartExpenseAnalysis::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartExpenseAnalysis::set_notification_channel): <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
    ///   - [`output_config(OutputConfig)`](crate::client::fluent_builders::StartExpenseAnalysis::output_config) / [`set_output_config(Option<OutputConfig>)`](crate::client::fluent_builders::StartExpenseAnalysis::set_output_config): <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the <code>GetExpenseAnalysis</code> operation.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartExpenseAnalysis::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartExpenseAnalysis::set_kms_key_id): <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
    /// - On success, responds with [`StartExpenseAnalysisOutput`](crate::output::StartExpenseAnalysisOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartExpenseAnalysisOutput::job_id): <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
    /// - On failure, responds with [`SdkError<StartExpenseAnalysisError>`](crate::error::StartExpenseAnalysisError)
    pub fn start_expense_analysis(&self) -> fluent_builders::StartExpenseAnalysis {
        fluent_builders::StartExpenseAnalysis::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AnalyzeDocument`.
    ///
    /// <p>Analyzes an input document for relationships between detected items. </p>
    /// <p>The types of information returned are as follows: </p>
    /// <ul>
    /// <li> <p>Form data (key-value pairs). The related information is returned in two <code>Block</code> objects, each of type <code>KEY_VALUE_SET</code>: a KEY <code>Block</code> object and a VALUE <code>Block</code> object. For example, <i>Name: Ana Silva Carolina</i> contains a key and value. <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is the value.</p> </li>
    /// <li> <p>Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL <code>Block</code> object is returned for each cell in a table.</p> </li>
    /// <li> <p>Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of <code>FeatureTypes</code>). </p> </li>
    /// </ul>
    /// <p>Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element, including the selection status.</p>
    /// <p>You can choose which type of analysis to perform by specifying the <code>FeatureTypes</code> list. </p>
    /// <p>The output is returned in a list of <code>Block</code> objects.</p>
    /// <p> <code>AnalyzeDocument</code> is a synchronous operation. To analyze documents asynchronously, use <code>StartDocumentAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AnalyzeDocument {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::analyze_document_input::Builder,
    }
    impl AnalyzeDocument {
        /// Creates a new `AnalyzeDocument`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AnalyzeDocumentOutput,
            aws_smithy_http::result::SdkError<crate::error::AnalyzeDocumentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.inner = self.inner.document(input);
            self
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// Appends an item to `FeatureTypes`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn feature_types(mut self, input: crate::model::FeatureType) -> Self {
            self.inner = self.inner.feature_types(input);
            self
        }
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        ) -> Self {
            self.inner = self.inner.set_feature_types(input);
            self
        }
        /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
        pub fn human_loop_config(mut self, input: crate::model::HumanLoopConfig) -> Self {
            self.inner = self.inner.human_loop_config(input);
            self
        }
        /// <p>Sets the configuration for the human in the loop workflow for analyzing documents.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AnalyzeExpense`.
    ///
    /// <p> <code>AnalyzeExpense</code> synchronously analyzes an input document for financially related relationships between text.</p>
    /// <p>Information is returned as <code>ExpenseDocuments</code> and seperated as follows.</p>
    /// <ul>
    /// <li> <p> <code>LineItemGroups</code>- A data set containing <code>LineItems</code> which store information about the lines of text, such as an item purchased and its price on a receipt.</p> </li>
    /// <li> <p> <code>SummaryFields</code>- Contains all other information a receipt, such as header information or the vendors name.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AnalyzeExpense {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::analyze_expense_input::Builder,
    }
    impl AnalyzeExpense {
        /// Creates a new `AnalyzeExpense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AnalyzeExpenseOutput,
            aws_smithy_http::result::SdkError<crate::error::AnalyzeExpenseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input document, either as bytes or as an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass a document loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64 encoded. Your code might not need to encode document file bytes if you're using an AWS SDK to call Amazon Textract API operations. </p>
        /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64 encoded.</p>
        /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS Region that you use for Amazon Textract operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using the Bytes property isn't supported. You must first upload the document to an Amazon S3 bucket, and then call the operation using the S3Object property.</p>
        /// <p>For Amazon Textract to process an S3 object, the user must have permission to access the S3 object. </p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.inner = self.inner.document(input);
            self
        }
        /// <p>The input document, either as bytes or as an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass a document loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64 encoded. Your code might not need to encode document file bytes if you're using an AWS SDK to call Amazon Textract API operations. </p>
        /// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64 encoded.</p>
        /// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS Region that you use for Amazon Textract operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using the Bytes property isn't supported. You must first upload the document to an Amazon S3 bucket, and then call the operation using the S3Object property.</p>
        /// <p>For Amazon Textract to process an S3 object, the user must have permission to access the S3 object. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AnalyzeID`.
    ///
    /// <p>Analyzes identity documents for relevant information. This information is extracted and returned as <code>IdentityDocumentFields</code>, which records both the normalized field and value of the extracted text.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AnalyzeID {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::analyze_id_input::Builder,
    }
    impl AnalyzeID {
        /// Creates a new `AnalyzeID`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AnalyzeIdOutput,
            aws_smithy_http::result::SdkError<crate::error::AnalyzeIDError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DocumentPages`.
        ///
        /// To override the contents of this collection use [`set_document_pages`](Self::set_document_pages).
        ///
        /// <p>The document being passed to AnalyzeID.</p>
        pub fn document_pages(mut self, input: crate::model::Document) -> Self {
            self.inner = self.inner.document_pages(input);
            self
        }
        /// <p>The document being passed to AnalyzeID.</p>
        pub fn set_document_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Document>>,
        ) -> Self {
            self.inner = self.inner.set_document_pages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectDocumentText`.
    ///
    /// <p>Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be an image in JPEG or PNG format. <code>DetectDocumentText</code> returns the detected text in an array of <code>Block</code> objects. </p>
    /// <p>Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object is the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE <code>Block</code> object is a parent for each word that makes up the line. Words are represented by <code>Block</code> objects of type WORD.</p>
    /// <p> <code>DetectDocumentText</code> is a synchronous operation. To analyze documents asynchronously, use <code>StartDocumentTextDetection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectDocumentText {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_document_text_input::Builder,
    }
    impl DetectDocumentText {
        /// Creates a new `DetectDocumentText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectDocumentTextOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectDocumentTextError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn document(mut self, input: crate::model::Document) -> Self {
            self.inner = self.inner.document(input);
            self
        }
        /// <p>The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG or PNG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the <code>Bytes</code> field. </p>
        pub fn set_document(mut self, input: std::option::Option<crate::model::Document>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentAnalysis`.
    ///
    /// <p>Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.</p>
    /// <p>You start asynchronous text analysis by calling <code>StartDocumentAnalysis</code>, which returns a job identifier (<code>JobId</code>). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to <code>StartDocumentAnalysis</code>. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetDocumentAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartDocumentAnalysis</code>.</p>
    /// <p> <code>GetDocumentAnalysis</code> returns an array of <code>Block</code> objects. The following types of information are returned: </p>
    /// <ul>
    /// <li> <p>Form data (key-value pairs). The related information is returned in two <code>Block</code> objects, each of type <code>KEY_VALUE_SET</code>: a KEY <code>Block</code> object and a VALUE <code>Block</code> object. For example, <i>Name: Ana Silva Carolina</i> contains a key and value. <i>Name:</i> is the key. <i>Ana Silva Carolina</i> is the value.</p> </li>
    /// <li> <p>Table and table cell data. A TABLE <code>Block</code> object contains information about a detected table. A CELL <code>Block</code> object is returned for each cell in a table.</p> </li>
    /// <li> <p>Lines and words of text. A LINE <code>Block</code> object contains one or more WORD <code>Block</code> objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of the <code>StartDocumentAnalysis</code> <code>FeatureTypes</code> input parameter). </p> </li>
    /// </ul>
    /// <p>Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT <code>Block</code> object contains information about a selection element, including the selection status.</p>
    /// <p>Use the <code>MaxResults</code> parameter to limit the number of blocks that are returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetDocumentAnalysis</code>, and populate the <code>NextToken</code> request parameter with the token value that's returned from the previous call to <code>GetDocumentAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_document_analysis_input::Builder,
    }
    impl GetDocumentAnalysis {
        /// Creates a new `GetDocumentAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>A unique identifier for the text-detection job. The <code>JobId</code> is returned from <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value that you can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value that you can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDocumentTextDetection`.
    ///
    /// <p>Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.</p>
    /// <p>You start asynchronous text detection by calling <code>StartDocumentTextDetection</code>, which returns a job identifier (<code>JobId</code>). When the text detection operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to <code>StartDocumentTextDetection</code>. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetDocumentTextDetection</code>, and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartDocumentTextDetection</code>.</p>
    /// <p> <code>GetDocumentTextDetection</code> returns an array of <code>Block</code> objects. </p>
    /// <p>Each document page has as an associated <code>Block</code> of type PAGE. Each PAGE <code>Block</code> object is the parent of LINE <code>Block</code> objects that represent the lines of detected text on a page. A LINE <code>Block</code> object is a parent for each word that makes up the line. Words are represented by <code>Block</code> objects of type WORD.</p>
    /// <p>Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetDocumentTextDetection</code>, and populate the <code>NextToken</code> request parameter with the token value that's returned from the previous call to <code>GetDocumentTextDetection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDocumentTextDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_document_text_detection_input::Builder,
    }
    impl GetDocumentTextDetection {
        /// Creates a new `GetDocumentTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDocumentTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDocumentTextDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartDocumentTextDetection</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExpenseAnalysis`.
    ///
    /// <p>Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.</p>
    /// <p>You start asynchronous invoice/receipt analysis by calling <code>StartExpenseAnalysis</code>, which returns a job identifier (<code>JobId</code>). Upon completion of the invoice/receipt analysis, Amazon Textract publishes the completion status to the Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in the initial call to <code>StartExpenseAnalysis</code>. To get the results of the invoice/receipt analysis operation, first ensure that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetExpenseAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartExpenseAnalysis</code>.</p>
    /// <p>Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetExpenseAnalysis</code>, and populate the <code>NextToken</code> request parameter with the token value that's returned from the previous call to <code>GetExpenseAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html">Analyzing Invoices and Receipts</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExpenseAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_expense_analysis_input::Builder,
    }
    impl GetExpenseAnalysis {
        /// Creates a new `GetExpenseAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExpenseAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExpenseAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>A unique identifier for the text detection job. The <code>JobId</code> is returned from <code>StartExpenseAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 20. If you specify a value greater than 20, a maximum of 20 results is returned. The default value is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 20. If you specify a value greater than 20, a maximum of 20 results is returned. The default value is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDocumentAnalysis`.
    ///
    /// <p>Starts the asynchronous analysis of an input document for relationships between detected items such as key-value pairs, tables, and selection elements.</p>
    /// <p> <code>StartDocumentAnalysis</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use <code>DocumentLocation</code> to specify the bucket name and file name of the document. </p>
    /// <p> <code>StartDocumentAnalysis</code> returns a job identifier (<code>JobId</code>) that you use to get the results of the operation. When text analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetDocumentAnalysis</code>, and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartDocumentAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html">Document Text Analysis</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDocumentAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_document_analysis_input::Builder,
    }
    impl StartDocumentAnalysis {
        /// Creates a new `StartDocumentAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDocumentAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDocumentAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, input: crate::model::DocumentLocation) -> Self {
            self.inner = self.inner.document_location(input);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.inner = self.inner.set_document_location(input);
            self
        }
        /// Appends an item to `FeatureTypes`.
        ///
        /// To override the contents of this collection use [`set_feature_types`](Self::set_feature_types).
        ///
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn feature_types(mut self, input: crate::model::FeatureType) -> Self {
            self.inner = self.inner.feature_types(input);
            self
        }
        /// <p>A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>). </p>
        pub fn set_feature_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureType>>,
        ) -> Self {
            self.inner = self.inner.set_feature_types(input);
            self
        }
        /// <p>The idempotent token that you use to identify the start request. If you use the same token with multiple <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The idempotent token that you use to identify the start request. If you use the same token with multiple <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the GetDocumentAnalysis operation.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the GetDocumentAnalysis operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDocumentTextDetection`.
    ///
    /// <p>Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.</p>
    /// <p> <code>StartDocumentTextDetection</code> can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use <code>DocumentLocation</code> to specify the bucket name and file name of the document. </p>
    /// <p> <code>StartTextDetection</code> returns a job identifier (<code>JobId</code>) that you use to get the results of the operation. When text detection is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in <code>NotificationChannel</code>. To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetDocumentTextDetection</code>, and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartDocumentTextDetection</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html">Document Text Detection</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartDocumentTextDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_document_text_detection_input::Builder,
    }
    impl StartDocumentTextDetection {
        /// Creates a new `StartDocumentTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDocumentTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDocumentTextDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, input: crate::model::DocumentLocation) -> Self {
            self.inner = self.inner.document_location(input);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.inner = self.inner.set_document_location(input);
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a>.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default Amazon Textract will save the results internally to be accessed with the GetDocumentTextDetection operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExpenseAnalysis`.
    ///
    /// <p>Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and vendor names.</p>
    /// <p> <code>StartExpenseAnalysis</code> can analyze text in documents that are in JPEG, PNG, and PDF format. The documents must be stored in an Amazon S3 bucket. Use the <code>DocumentLocation</code> parameter to specify the name of your S3 bucket and the name of the document in that bucket. </p>
    /// <p> <code>StartExpenseAnalysis</code> returns a job identifier (<code>JobId</code>) that you will provide to <code>GetExpenseAnalysis</code> to retrieve the results of the operation. When the analysis of the input invoices/receipts is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you provide to the <code>NotificationChannel</code>. To obtain the results of the invoice and receipt analysis operation, ensure that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetExpenseAnalysis</code>, and pass the job identifier (<code>JobId</code>) that was returned by your call to <code>StartExpenseAnalysis</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html">Analyzing Invoices and Receipts</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartExpenseAnalysis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_expense_analysis_input::Builder,
    }
    impl StartExpenseAnalysis {
        /// Creates a new `StartExpenseAnalysis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExpenseAnalysisOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExpenseAnalysisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location of the document to be processed.</p>
        pub fn document_location(mut self, input: crate::model::DocumentLocation) -> Self {
            self.inner = self.inner.document_location(input);
            self
        }
        /// <p>The location of the document to be processed.</p>
        pub fn set_document_location(
            mut self,
            input: std::option::Option<crate::model::DocumentLocation>,
        ) -> Self {
            self.inner = self.inner.set_document_location(input);
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a> </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The idempotent token that's used to identify the start request. If you use the same token with multiple <code>StartDocumentTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract Asynchronous Operations</a> </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An identifier you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to. </p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the <code>GetExpenseAnalysis</code> operation.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the <code>GetExpenseAnalysis</code> operation.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
