// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Sets whether or not your output will go to a user created bucket. Used to set the name
/// of the bucket, and the prefix on the output file.</p>
/// <p>
/// <code>OutputConfig</code> is an optional parameter which lets you adjust where your output will be placed.
/// By default, Amazon Textract will store the results internally and can only be accessed by the Get
/// API operations. With OutputConfig enabled, you can set the name of the bucket the output will be
/// sent to and the file prefix of the results where you can download your results. Additionally, you
/// can set the <code>KMSKeyID</code> parameter to a customer master key (CMK) to encrypt your output. Without this
/// parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.</p>
/// <p>Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account
/// is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after
/// the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html"> Managing AI services opt-out policy. </a>
/// </p>
/// <p>For more information on data privacy,
/// see the <a href="https://aws.amazon.com/compliance/data-privacy-faq/">Data Privacy
/// FAQ</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputConfig {
    /// <p>The name of the bucket your output will go to.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix of the object key that the output will be saved to. When not enabled, the
    /// prefix will be “textract_output".</p>
    pub s3_prefix: std::option::Option<std::string::String>,
}
impl OutputConfig {
    /// <p>The name of the bucket your output will go to.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The prefix of the object key that the output will be saved to. When not enabled, the
    /// prefix will be “textract_output".</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for OutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputConfig");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.finish()
    }
}
/// See [`OutputConfig`](crate::model::OutputConfig)
pub mod output_config {
    /// A builder for [`OutputConfig`](crate::model::OutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket your output will go to.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket your output will go to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The prefix of the object key that the output will be saved to. When not enabled, the
        /// prefix will be “textract_output".</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the object key that the output will be saved to. When not enabled, the
        /// prefix will be “textract_output".</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputConfig`](crate::model::OutputConfig)
        pub fn build(self) -> crate::model::OutputConfig {
            crate::model::OutputConfig {
                s3_bucket: self.s3_bucket,
                s3_prefix: self.s3_prefix,
            }
        }
    }
}
impl OutputConfig {
    /// Creates a new builder-style object to manufacture [`OutputConfig`](crate::model::OutputConfig)
    pub fn builder() -> crate::model::output_config::Builder {
        crate::model::output_config::Builder::default()
    }
}

/// <p>The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon Textract publishes the completion status of
/// an asynchronous document operation, such as <a>StartDocumentTextDetection</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationChannel {
    /// <p>The Amazon SNS topic that Amazon Textract posts the completion status to.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract publishing permissions to the Amazon SNS topic. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl NotificationChannel {
    /// <p>The Amazon SNS topic that Amazon Textract posts the completion status to.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract publishing permissions to the Amazon SNS topic. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for NotificationChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationChannel");
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`NotificationChannel`](crate::model::NotificationChannel)
pub mod notification_channel {
    /// A builder for [`NotificationChannel`](crate::model::NotificationChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon SNS topic that Amazon Textract posts the completion status to.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic that Amazon Textract posts the completion status to.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract publishing permissions to the Amazon SNS topic. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract publishing permissions to the Amazon SNS topic. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationChannel`](crate::model::NotificationChannel)
        pub fn build(self) -> crate::model::NotificationChannel {
            crate::model::NotificationChannel {
                sns_topic_arn: self.sns_topic_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl NotificationChannel {
    /// Creates a new builder-style object to manufacture [`NotificationChannel`](crate::model::NotificationChannel)
    pub fn builder() -> crate::model::notification_channel::Builder {
        crate::model::notification_channel::Builder::default()
    }
}

/// <p>The Amazon S3 bucket that contains the document to be processed. It's used by asynchronous
/// operations such as <a>StartDocumentTextDetection</a>.</p>
/// <p>The input document can be an image file in JPEG or PNG format. It can also be a file in
/// PDF format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentLocation {
    /// <p>The Amazon S3 bucket that contains the input document.</p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl DocumentLocation {
    /// <p>The Amazon S3 bucket that contains the input document.</p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for DocumentLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentLocation");
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`DocumentLocation`](crate::model::DocumentLocation)
pub mod document_location {
    /// A builder for [`DocumentLocation`](crate::model::DocumentLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket that contains the input document.</p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket that contains the input document.</p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentLocation`](crate::model::DocumentLocation)
        pub fn build(self) -> crate::model::DocumentLocation {
            crate::model::DocumentLocation {
                s3_object: self.s3_object,
            }
        }
    }
}
impl DocumentLocation {
    /// Creates a new builder-style object to manufacture [`DocumentLocation`](crate::model::DocumentLocation)
    pub fn builder() -> crate::model::document_location::Builder {
        crate::model::document_location::Builder::default()
    }
}

/// <p>The S3 bucket name and file name that identifies the document.</p>
/// <p>The AWS Region for the S3 bucket that contains the document must match the Region that
/// you use for Amazon Textract operations.</p>
///
/// <p>For Amazon Textract to process a file in an S3 bucket, the user must have
/// permission to access the S3 bucket and file.
///
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Object {
    /// <p>The name of the S3 bucket. Note that the # character is not valid in the file
    /// name.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The file name of the input document. Synchronous operations can use image files that are
    /// in JPEG or PNG format. Asynchronous operations also support PDF and TIFF format files.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If the bucket has versioning enabled, you can specify the object version. </p>
    pub version: std::option::Option<std::string::String>,
}
impl S3Object {
    /// <p>The name of the S3 bucket. Note that the # character is not valid in the file
    /// name.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The file name of the input document. Synchronous operations can use image files that are
    /// in JPEG or PNG format. Asynchronous operations also support PDF and TIFF format files.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If the bucket has versioning enabled, you can specify the object version. </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for S3Object {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Object");
        formatter.field("bucket", &self.bucket);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`S3Object`](crate::model::S3Object)
pub mod s3_object {
    /// A builder for [`S3Object`](crate::model::S3Object)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket. Note that the # character is not valid in the file
        /// name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket. Note that the # character is not valid in the file
        /// name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The file name of the input document. Synchronous operations can use image files that are
        /// in JPEG or PNG format. Asynchronous operations also support PDF and TIFF format files.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The file name of the input document. Synchronous operations can use image files that are
        /// in JPEG or PNG format. Asynchronous operations also support PDF and TIFF format files.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If the bucket has versioning enabled, you can specify the object version. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>If the bucket has versioning enabled, you can specify the object version. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Object`](crate::model::S3Object)
        pub fn build(self) -> crate::model::S3Object {
            crate::model::S3Object {
                bucket: self.bucket,
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl S3Object {
    /// Creates a new builder-style object to manufacture [`S3Object`](crate::model::S3Object)
    pub fn builder() -> crate::model::s3_object::Builder {
        crate::model::s3_object::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeatureType {
    #[allow(missing_docs)] // documentation missing in model
    Forms,
    #[allow(missing_docs)] // documentation missing in model
    Tables,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeatureType {
    fn from(s: &str) -> Self {
        match s {
            "FORMS" => FeatureType::Forms,
            "TABLES" => FeatureType::Tables,
            other => FeatureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeatureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeatureType::from(s))
    }
}
impl FeatureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeatureType::Forms => "FORMS",
            FeatureType::Tables => "TABLES",
            FeatureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORMS", "TABLES"]
    }
}
impl AsRef<str> for FeatureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A warning about an issue that occurred during asynchronous text analysis (<a>StartDocumentAnalysis</a>) or asynchronous document text detection (<a>StartDocumentTextDetection</a>). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Warning {
    /// <p>The error code for the warning.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>A list of the pages that the warning applies to.</p>
    pub pages: std::option::Option<std::vec::Vec<i32>>,
}
impl Warning {
    /// <p>The error code for the warning.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>A list of the pages that the warning applies to.</p>
    pub fn pages(&self) -> std::option::Option<&[i32]> {
        self.pages.as_deref()
    }
}
impl std::fmt::Debug for Warning {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Warning");
        formatter.field("error_code", &self.error_code);
        formatter.field("pages", &self.pages);
        formatter.finish()
    }
}
/// See [`Warning`](crate::model::Warning)
pub mod warning {
    /// A builder for [`Warning`](crate::model::Warning)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) pages: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// <p>The error code for the warning.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code for the warning.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// Appends an item to `pages`.
        ///
        /// To override the contents of this collection use [`set_pages`](Self::set_pages).
        ///
        /// <p>A list of the pages that the warning applies to.</p>
        pub fn pages(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.pages.unwrap_or_default();
            v.push(input.into());
            self.pages = Some(v);
            self
        }
        /// <p>A list of the pages that the warning applies to.</p>
        pub fn set_pages(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.pages = input;
            self
        }
        /// Consumes the builder and constructs a [`Warning`](crate::model::Warning)
        pub fn build(self) -> crate::model::Warning {
            crate::model::Warning {
                error_code: self.error_code,
                pages: self.pages,
            }
        }
    }
}
impl Warning {
    /// Creates a new builder-style object to manufacture [`Warning`](crate::model::Warning)
    pub fn builder() -> crate::model::warning::Builder {
        crate::model::warning::Builder::default()
    }
}

/// <p>The structure holding all the information returned by AnalyzeExpense</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpenseDocument {
    /// <p>Denotes which invoice or receipt in the document the information is coming from.
    /// First document will be 1, the second 2, and so on.</p>
    pub expense_index: std::option::Option<i32>,
    /// <p>Any information found outside of a table by Amazon Textract.</p>
    pub summary_fields: std::option::Option<std::vec::Vec<crate::model::ExpenseField>>,
    /// <p>Information detected on each table of a document, seperated into <code>LineItems</code>.</p>
    pub line_item_groups: std::option::Option<std::vec::Vec<crate::model::LineItemGroup>>,
}
impl ExpenseDocument {
    /// <p>Denotes which invoice or receipt in the document the information is coming from.
    /// First document will be 1, the second 2, and so on.</p>
    pub fn expense_index(&self) -> std::option::Option<i32> {
        self.expense_index
    }
    /// <p>Any information found outside of a table by Amazon Textract.</p>
    pub fn summary_fields(&self) -> std::option::Option<&[crate::model::ExpenseField]> {
        self.summary_fields.as_deref()
    }
    /// <p>Information detected on each table of a document, seperated into <code>LineItems</code>.</p>
    pub fn line_item_groups(&self) -> std::option::Option<&[crate::model::LineItemGroup]> {
        self.line_item_groups.as_deref()
    }
}
impl std::fmt::Debug for ExpenseDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpenseDocument");
        formatter.field("expense_index", &self.expense_index);
        formatter.field("summary_fields", &self.summary_fields);
        formatter.field("line_item_groups", &self.line_item_groups);
        formatter.finish()
    }
}
/// See [`ExpenseDocument`](crate::model::ExpenseDocument)
pub mod expense_document {
    /// A builder for [`ExpenseDocument`](crate::model::ExpenseDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expense_index: std::option::Option<i32>,
        pub(crate) summary_fields: std::option::Option<std::vec::Vec<crate::model::ExpenseField>>,
        pub(crate) line_item_groups:
            std::option::Option<std::vec::Vec<crate::model::LineItemGroup>>,
    }
    impl Builder {
        /// <p>Denotes which invoice or receipt in the document the information is coming from.
        /// First document will be 1, the second 2, and so on.</p>
        pub fn expense_index(mut self, input: i32) -> Self {
            self.expense_index = Some(input);
            self
        }
        /// <p>Denotes which invoice or receipt in the document the information is coming from.
        /// First document will be 1, the second 2, and so on.</p>
        pub fn set_expense_index(mut self, input: std::option::Option<i32>) -> Self {
            self.expense_index = input;
            self
        }
        /// Appends an item to `summary_fields`.
        ///
        /// To override the contents of this collection use [`set_summary_fields`](Self::set_summary_fields).
        ///
        /// <p>Any information found outside of a table by Amazon Textract.</p>
        pub fn summary_fields(mut self, input: impl Into<crate::model::ExpenseField>) -> Self {
            let mut v = self.summary_fields.unwrap_or_default();
            v.push(input.into());
            self.summary_fields = Some(v);
            self
        }
        /// <p>Any information found outside of a table by Amazon Textract.</p>
        pub fn set_summary_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpenseField>>,
        ) -> Self {
            self.summary_fields = input;
            self
        }
        /// Appends an item to `line_item_groups`.
        ///
        /// To override the contents of this collection use [`set_line_item_groups`](Self::set_line_item_groups).
        ///
        /// <p>Information detected on each table of a document, seperated into <code>LineItems</code>.</p>
        pub fn line_item_groups(mut self, input: impl Into<crate::model::LineItemGroup>) -> Self {
            let mut v = self.line_item_groups.unwrap_or_default();
            v.push(input.into());
            self.line_item_groups = Some(v);
            self
        }
        /// <p>Information detected on each table of a document, seperated into <code>LineItems</code>.</p>
        pub fn set_line_item_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItemGroup>>,
        ) -> Self {
            self.line_item_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpenseDocument`](crate::model::ExpenseDocument)
        pub fn build(self) -> crate::model::ExpenseDocument {
            crate::model::ExpenseDocument {
                expense_index: self.expense_index,
                summary_fields: self.summary_fields,
                line_item_groups: self.line_item_groups,
            }
        }
    }
}
impl ExpenseDocument {
    /// Creates a new builder-style object to manufacture [`ExpenseDocument`](crate::model::ExpenseDocument)
    pub fn builder() -> crate::model::expense_document::Builder {
        crate::model::expense_document::Builder::default()
    }
}

/// <p>A grouping of tables which contain LineItems, with each table identified by the table's <code>LineItemGroupIndex</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineItemGroup {
    /// <p>The number used to identify a specific table in a document. The first table encountered will have a LineItemGroupIndex of 1, the second 2, etc.</p>
    pub line_item_group_index: std::option::Option<i32>,
    /// <p>The breakdown of information on a particular line of a table. </p>
    pub line_items: std::option::Option<std::vec::Vec<crate::model::LineItemFields>>,
}
impl LineItemGroup {
    /// <p>The number used to identify a specific table in a document. The first table encountered will have a LineItemGroupIndex of 1, the second 2, etc.</p>
    pub fn line_item_group_index(&self) -> std::option::Option<i32> {
        self.line_item_group_index
    }
    /// <p>The breakdown of information on a particular line of a table. </p>
    pub fn line_items(&self) -> std::option::Option<&[crate::model::LineItemFields]> {
        self.line_items.as_deref()
    }
}
impl std::fmt::Debug for LineItemGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineItemGroup");
        formatter.field("line_item_group_index", &self.line_item_group_index);
        formatter.field("line_items", &self.line_items);
        formatter.finish()
    }
}
/// See [`LineItemGroup`](crate::model::LineItemGroup)
pub mod line_item_group {
    /// A builder for [`LineItemGroup`](crate::model::LineItemGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line_item_group_index: std::option::Option<i32>,
        pub(crate) line_items: std::option::Option<std::vec::Vec<crate::model::LineItemFields>>,
    }
    impl Builder {
        /// <p>The number used to identify a specific table in a document. The first table encountered will have a LineItemGroupIndex of 1, the second 2, etc.</p>
        pub fn line_item_group_index(mut self, input: i32) -> Self {
            self.line_item_group_index = Some(input);
            self
        }
        /// <p>The number used to identify a specific table in a document. The first table encountered will have a LineItemGroupIndex of 1, the second 2, etc.</p>
        pub fn set_line_item_group_index(mut self, input: std::option::Option<i32>) -> Self {
            self.line_item_group_index = input;
            self
        }
        /// Appends an item to `line_items`.
        ///
        /// To override the contents of this collection use [`set_line_items`](Self::set_line_items).
        ///
        /// <p>The breakdown of information on a particular line of a table. </p>
        pub fn line_items(mut self, input: impl Into<crate::model::LineItemFields>) -> Self {
            let mut v = self.line_items.unwrap_or_default();
            v.push(input.into());
            self.line_items = Some(v);
            self
        }
        /// <p>The breakdown of information on a particular line of a table. </p>
        pub fn set_line_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineItemFields>>,
        ) -> Self {
            self.line_items = input;
            self
        }
        /// Consumes the builder and constructs a [`LineItemGroup`](crate::model::LineItemGroup)
        pub fn build(self) -> crate::model::LineItemGroup {
            crate::model::LineItemGroup {
                line_item_group_index: self.line_item_group_index,
                line_items: self.line_items,
            }
        }
    }
}
impl LineItemGroup {
    /// Creates a new builder-style object to manufacture [`LineItemGroup`](crate::model::LineItemGroup)
    pub fn builder() -> crate::model::line_item_group::Builder {
        crate::model::line_item_group::Builder::default()
    }
}

/// <p>A structure that holds information about the different lines found in a document's tables.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineItemFields {
    /// <p>ExpenseFields used to show information from detected lines on a table.</p>
    pub line_item_expense_fields: std::option::Option<std::vec::Vec<crate::model::ExpenseField>>,
}
impl LineItemFields {
    /// <p>ExpenseFields used to show information from detected lines on a table.</p>
    pub fn line_item_expense_fields(&self) -> std::option::Option<&[crate::model::ExpenseField]> {
        self.line_item_expense_fields.as_deref()
    }
}
impl std::fmt::Debug for LineItemFields {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineItemFields");
        formatter.field("line_item_expense_fields", &self.line_item_expense_fields);
        formatter.finish()
    }
}
/// See [`LineItemFields`](crate::model::LineItemFields)
pub mod line_item_fields {
    /// A builder for [`LineItemFields`](crate::model::LineItemFields)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line_item_expense_fields:
            std::option::Option<std::vec::Vec<crate::model::ExpenseField>>,
    }
    impl Builder {
        /// Appends an item to `line_item_expense_fields`.
        ///
        /// To override the contents of this collection use [`set_line_item_expense_fields`](Self::set_line_item_expense_fields).
        ///
        /// <p>ExpenseFields used to show information from detected lines on a table.</p>
        pub fn line_item_expense_fields(
            mut self,
            input: impl Into<crate::model::ExpenseField>,
        ) -> Self {
            let mut v = self.line_item_expense_fields.unwrap_or_default();
            v.push(input.into());
            self.line_item_expense_fields = Some(v);
            self
        }
        /// <p>ExpenseFields used to show information from detected lines on a table.</p>
        pub fn set_line_item_expense_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExpenseField>>,
        ) -> Self {
            self.line_item_expense_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`LineItemFields`](crate::model::LineItemFields)
        pub fn build(self) -> crate::model::LineItemFields {
            crate::model::LineItemFields {
                line_item_expense_fields: self.line_item_expense_fields,
            }
        }
    }
}
impl LineItemFields {
    /// Creates a new builder-style object to manufacture [`LineItemFields`](crate::model::LineItemFields)
    pub fn builder() -> crate::model::line_item_fields::Builder {
        crate::model::line_item_fields::Builder::default()
    }
}

/// <p>Breakdown of detected information, seperated into
/// the catagories Type, LableDetection, and ValueDetection</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpenseField {
    /// <p>The implied label of a detected element. Present alongside LabelDetection for explicit elements.</p>
    pub r#type: std::option::Option<crate::model::ExpenseType>,
    /// <p>The explicitly stated label of a detected element.</p>
    pub label_detection: std::option::Option<crate::model::ExpenseDetection>,
    /// <p>The value of a detected element. Present in explicit and implicit elements.</p>
    pub value_detection: std::option::Option<crate::model::ExpenseDetection>,
    /// <p>The page number the value was detected on.</p>
    pub page_number: std::option::Option<i32>,
}
impl ExpenseField {
    /// <p>The implied label of a detected element. Present alongside LabelDetection for explicit elements.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ExpenseType> {
        self.r#type.as_ref()
    }
    /// <p>The explicitly stated label of a detected element.</p>
    pub fn label_detection(&self) -> std::option::Option<&crate::model::ExpenseDetection> {
        self.label_detection.as_ref()
    }
    /// <p>The value of a detected element. Present in explicit and implicit elements.</p>
    pub fn value_detection(&self) -> std::option::Option<&crate::model::ExpenseDetection> {
        self.value_detection.as_ref()
    }
    /// <p>The page number the value was detected on.</p>
    pub fn page_number(&self) -> std::option::Option<i32> {
        self.page_number
    }
}
impl std::fmt::Debug for ExpenseField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpenseField");
        formatter.field("r#type", &self.r#type);
        formatter.field("label_detection", &self.label_detection);
        formatter.field("value_detection", &self.value_detection);
        formatter.field("page_number", &self.page_number);
        formatter.finish()
    }
}
/// See [`ExpenseField`](crate::model::ExpenseField)
pub mod expense_field {
    /// A builder for [`ExpenseField`](crate::model::ExpenseField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ExpenseType>,
        pub(crate) label_detection: std::option::Option<crate::model::ExpenseDetection>,
        pub(crate) value_detection: std::option::Option<crate::model::ExpenseDetection>,
        pub(crate) page_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The implied label of a detected element. Present alongside LabelDetection for explicit elements.</p>
        pub fn r#type(mut self, input: crate::model::ExpenseType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The implied label of a detected element. Present alongside LabelDetection for explicit elements.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ExpenseType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The explicitly stated label of a detected element.</p>
        pub fn label_detection(mut self, input: crate::model::ExpenseDetection) -> Self {
            self.label_detection = Some(input);
            self
        }
        /// <p>The explicitly stated label of a detected element.</p>
        pub fn set_label_detection(
            mut self,
            input: std::option::Option<crate::model::ExpenseDetection>,
        ) -> Self {
            self.label_detection = input;
            self
        }
        /// <p>The value of a detected element. Present in explicit and implicit elements.</p>
        pub fn value_detection(mut self, input: crate::model::ExpenseDetection) -> Self {
            self.value_detection = Some(input);
            self
        }
        /// <p>The value of a detected element. Present in explicit and implicit elements.</p>
        pub fn set_value_detection(
            mut self,
            input: std::option::Option<crate::model::ExpenseDetection>,
        ) -> Self {
            self.value_detection = input;
            self
        }
        /// <p>The page number the value was detected on.</p>
        pub fn page_number(mut self, input: i32) -> Self {
            self.page_number = Some(input);
            self
        }
        /// <p>The page number the value was detected on.</p>
        pub fn set_page_number(mut self, input: std::option::Option<i32>) -> Self {
            self.page_number = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpenseField`](crate::model::ExpenseField)
        pub fn build(self) -> crate::model::ExpenseField {
            crate::model::ExpenseField {
                r#type: self.r#type,
                label_detection: self.label_detection,
                value_detection: self.value_detection,
                page_number: self.page_number,
            }
        }
    }
}
impl ExpenseField {
    /// Creates a new builder-style object to manufacture [`ExpenseField`](crate::model::ExpenseField)
    pub fn builder() -> crate::model::expense_field::Builder {
        crate::model::expense_field::Builder::default()
    }
}

/// <p>An object used to store information about the Value or Label detected by Amazon Textract.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpenseDetection {
    /// <p>The word or line of text recognized by Amazon Textract</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>Information about where the following items are located on a document page: detected
    /// page, text, key-value pairs, tables, table cells, and selection elements.</p>
    pub geometry: std::option::Option<crate::model::Geometry>,
    /// <p>The confidence in detection, as a percentage</p>
    pub confidence: std::option::Option<f32>,
}
impl ExpenseDetection {
    /// <p>The word or line of text recognized by Amazon Textract</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>Information about where the following items are located on a document page: detected
    /// page, text, key-value pairs, tables, table cells, and selection elements.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::Geometry> {
        self.geometry.as_ref()
    }
    /// <p>The confidence in detection, as a percentage</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for ExpenseDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpenseDetection");
        formatter.field("text", &self.text);
        formatter.field("geometry", &self.geometry);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`ExpenseDetection`](crate::model::ExpenseDetection)
pub mod expense_detection {
    /// A builder for [`ExpenseDetection`](crate::model::ExpenseDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) geometry: std::option::Option<crate::model::Geometry>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The word or line of text recognized by Amazon Textract</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The word or line of text recognized by Amazon Textract</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>Information about where the following items are located on a document page: detected
        /// page, text, key-value pairs, tables, table cells, and selection elements.</p>
        pub fn geometry(mut self, input: crate::model::Geometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Information about where the following items are located on a document page: detected
        /// page, text, key-value pairs, tables, table cells, and selection elements.</p>
        pub fn set_geometry(mut self, input: std::option::Option<crate::model::Geometry>) -> Self {
            self.geometry = input;
            self
        }
        /// <p>The confidence in detection, as a percentage</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence in detection, as a percentage</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpenseDetection`](crate::model::ExpenseDetection)
        pub fn build(self) -> crate::model::ExpenseDetection {
            crate::model::ExpenseDetection {
                text: self.text,
                geometry: self.geometry,
                confidence: self.confidence,
            }
        }
    }
}
impl ExpenseDetection {
    /// Creates a new builder-style object to manufacture [`ExpenseDetection`](crate::model::ExpenseDetection)
    pub fn builder() -> crate::model::expense_detection::Builder {
        crate::model::expense_detection::Builder::default()
    }
}

/// <p>Information about where the following items are located on a document page: detected
/// page, text, key-value pairs, tables, table cells, and selection elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Geometry {
    /// <p>An axis-aligned coarse representation of the location of the recognized item on the
    /// document page.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Within the bounding box, a fine-grained polygon around the recognized item.</p>
    pub polygon: std::option::Option<std::vec::Vec<crate::model::Point>>,
}
impl Geometry {
    /// <p>An axis-aligned coarse representation of the location of the recognized item on the
    /// document page.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Within the bounding box, a fine-grained polygon around the recognized item.</p>
    pub fn polygon(&self) -> std::option::Option<&[crate::model::Point]> {
        self.polygon.as_deref()
    }
}
impl std::fmt::Debug for Geometry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Geometry");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("polygon", &self.polygon);
        formatter.finish()
    }
}
/// See [`Geometry`](crate::model::Geometry)
pub mod geometry {
    /// A builder for [`Geometry`](crate::model::Geometry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) polygon: std::option::Option<std::vec::Vec<crate::model::Point>>,
    }
    impl Builder {
        /// <p>An axis-aligned coarse representation of the location of the recognized item on the
        /// document page.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>An axis-aligned coarse representation of the location of the recognized item on the
        /// document page.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// Appends an item to `polygon`.
        ///
        /// To override the contents of this collection use [`set_polygon`](Self::set_polygon).
        ///
        /// <p>Within the bounding box, a fine-grained polygon around the recognized item.</p>
        pub fn polygon(mut self, input: impl Into<crate::model::Point>) -> Self {
            let mut v = self.polygon.unwrap_or_default();
            v.push(input.into());
            self.polygon = Some(v);
            self
        }
        /// <p>Within the bounding box, a fine-grained polygon around the recognized item.</p>
        pub fn set_polygon(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Point>>,
        ) -> Self {
            self.polygon = input;
            self
        }
        /// Consumes the builder and constructs a [`Geometry`](crate::model::Geometry)
        pub fn build(self) -> crate::model::Geometry {
            crate::model::Geometry {
                bounding_box: self.bounding_box,
                polygon: self.polygon,
            }
        }
    }
}
impl Geometry {
    /// Creates a new builder-style object to manufacture [`Geometry`](crate::model::Geometry)
    pub fn builder() -> crate::model::geometry::Builder {
        crate::model::geometry::Builder::default()
    }
}

/// <p>The X and Y coordinates of a point on a document page. The X and Y
/// values that are returned are ratios of the overall document page size. For example, if the
/// input document is 700 x 200 and the operation returns X=0.5 and Y=0.25, then the point is
/// at the (350,50) pixel coordinate on the document page.</p>
///
/// <p>An array of <code>Point</code> objects, <code>Polygon</code>, is returned
/// by <a>DetectDocumentText</a>. <code>Polygon</code> represents a fine-grained
/// polygon around detected text. For more information, see Geometry in the Amazon Textract
/// Developer Guide. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Point {
    /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
    pub x: f32,
    /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
    pub y: f32,
}
impl Point {
    /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
    pub fn x(&self) -> f32 {
        self.x
    }
    /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
    pub fn y(&self) -> f32 {
        self.y
    }
}
impl std::fmt::Debug for Point {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Point");
        formatter.field("x", &self.x);
        formatter.field("y", &self.y);
        formatter.finish()
    }
}
/// See [`Point`](crate::model::Point)
pub mod point {
    /// A builder for [`Point`](crate::model::Point)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) x: std::option::Option<f32>,
        pub(crate) y: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
        pub fn x(mut self, input: f32) -> Self {
            self.x = Some(input);
            self
        }
        /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
        pub fn set_x(mut self, input: std::option::Option<f32>) -> Self {
            self.x = input;
            self
        }
        /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
        pub fn y(mut self, input: f32) -> Self {
            self.y = Some(input);
            self
        }
        /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
        pub fn set_y(mut self, input: std::option::Option<f32>) -> Self {
            self.y = input;
            self
        }
        /// Consumes the builder and constructs a [`Point`](crate::model::Point)
        pub fn build(self) -> crate::model::Point {
            crate::model::Point {
                x: self.x.unwrap_or_default(),
                y: self.y.unwrap_or_default(),
            }
        }
    }
}
impl Point {
    /// Creates a new builder-style object to manufacture [`Point`](crate::model::Point)
    pub fn builder() -> crate::model::point::Builder {
        crate::model::point::Builder::default()
    }
}

/// <p>The bounding box around the detected page, text, key-value pair, table, table cell, or
/// selection element on a document page. The <code>left</code> (x-coordinate) and
/// <code>top</code> (y-coordinate) are coordinates that represent the top and left sides of
/// the bounding box. Note that the upper-left corner of the image is the origin (0,0). </p>
/// <p>The <code>top</code> and <code>left</code> values returned are ratios of the overall
/// document page size. For example, if the input image is 700 x 200 pixels, and the top-left
/// coordinate of the bounding box is 350 x 50 pixels, the API returns a <code>left</code>
/// value of 0.5 (350/700) and a <code>top</code> value of 0.25 (50/200).</p>
/// <p>The <code>width</code> and <code>height</code> values represent the dimensions of the
/// bounding box as a ratio of the overall document page dimension. For example, if the
/// document page size is 700 x 200 pixels, and the bounding box width is 70 pixels, the width
/// returned is 0.1. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BoundingBox {
    /// <p>The width of the bounding box as a ratio of the overall document page
    /// width.</p>
    pub width: f32,
    /// <p>The height of the bounding box as a ratio of the overall document page
    /// height.</p>
    pub height: f32,
    /// <p>The left coordinate of the bounding box as a ratio of overall document page
    /// width.</p>
    pub left: f32,
    /// <p>The top coordinate of the bounding box as a ratio of overall document page
    /// height.</p>
    pub top: f32,
}
impl BoundingBox {
    /// <p>The width of the bounding box as a ratio of the overall document page
    /// width.</p>
    pub fn width(&self) -> f32 {
        self.width
    }
    /// <p>The height of the bounding box as a ratio of the overall document page
    /// height.</p>
    pub fn height(&self) -> f32 {
        self.height
    }
    /// <p>The left coordinate of the bounding box as a ratio of overall document page
    /// width.</p>
    pub fn left(&self) -> f32 {
        self.left
    }
    /// <p>The top coordinate of the bounding box as a ratio of overall document page
    /// height.</p>
    pub fn top(&self) -> f32 {
        self.top
    }
}
impl std::fmt::Debug for BoundingBox {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BoundingBox");
        formatter.field("width", &self.width);
        formatter.field("height", &self.height);
        formatter.field("left", &self.left);
        formatter.field("top", &self.top);
        formatter.finish()
    }
}
/// See [`BoundingBox`](crate::model::BoundingBox)
pub mod bounding_box {
    /// A builder for [`BoundingBox`](crate::model::BoundingBox)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) width: std::option::Option<f32>,
        pub(crate) height: std::option::Option<f32>,
        pub(crate) left: std::option::Option<f32>,
        pub(crate) top: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The width of the bounding box as a ratio of the overall document page
        /// width.</p>
        pub fn width(mut self, input: f32) -> Self {
            self.width = Some(input);
            self
        }
        /// <p>The width of the bounding box as a ratio of the overall document page
        /// width.</p>
        pub fn set_width(mut self, input: std::option::Option<f32>) -> Self {
            self.width = input;
            self
        }
        /// <p>The height of the bounding box as a ratio of the overall document page
        /// height.</p>
        pub fn height(mut self, input: f32) -> Self {
            self.height = Some(input);
            self
        }
        /// <p>The height of the bounding box as a ratio of the overall document page
        /// height.</p>
        pub fn set_height(mut self, input: std::option::Option<f32>) -> Self {
            self.height = input;
            self
        }
        /// <p>The left coordinate of the bounding box as a ratio of overall document page
        /// width.</p>
        pub fn left(mut self, input: f32) -> Self {
            self.left = Some(input);
            self
        }
        /// <p>The left coordinate of the bounding box as a ratio of overall document page
        /// width.</p>
        pub fn set_left(mut self, input: std::option::Option<f32>) -> Self {
            self.left = input;
            self
        }
        /// <p>The top coordinate of the bounding box as a ratio of overall document page
        /// height.</p>
        pub fn top(mut self, input: f32) -> Self {
            self.top = Some(input);
            self
        }
        /// <p>The top coordinate of the bounding box as a ratio of overall document page
        /// height.</p>
        pub fn set_top(mut self, input: std::option::Option<f32>) -> Self {
            self.top = input;
            self
        }
        /// Consumes the builder and constructs a [`BoundingBox`](crate::model::BoundingBox)
        pub fn build(self) -> crate::model::BoundingBox {
            crate::model::BoundingBox {
                width: self.width.unwrap_or_default(),
                height: self.height.unwrap_or_default(),
                left: self.left.unwrap_or_default(),
                top: self.top.unwrap_or_default(),
            }
        }
    }
}
impl BoundingBox {
    /// Creates a new builder-style object to manufacture [`BoundingBox`](crate::model::BoundingBox)
    pub fn builder() -> crate::model::bounding_box::Builder {
        crate::model::bounding_box::Builder::default()
    }
}

/// <p>An object used to store information about the Type detected by Amazon Textract.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpenseType {
    /// <p>The word or line of text detected by Amazon Textract.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The confidence of accuracy, as a percentage.</p>
    pub confidence: std::option::Option<f32>,
}
impl ExpenseType {
    /// <p>The word or line of text detected by Amazon Textract.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The confidence of accuracy, as a percentage.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for ExpenseType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpenseType");
        formatter.field("text", &self.text);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`ExpenseType`](crate::model::ExpenseType)
pub mod expense_type {
    /// A builder for [`ExpenseType`](crate::model::ExpenseType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The word or line of text detected by Amazon Textract.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The word or line of text detected by Amazon Textract.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The confidence of accuracy, as a percentage.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence of accuracy, as a percentage.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpenseType`](crate::model::ExpenseType)
        pub fn build(self) -> crate::model::ExpenseType {
            crate::model::ExpenseType {
                text: self.text,
                confidence: self.confidence,
            }
        }
    }
}
impl ExpenseType {
    /// Creates a new builder-style object to manufacture [`ExpenseType`](crate::model::ExpenseType)
    pub fn builder() -> crate::model::expense_type::Builder {
        crate::model::expense_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    PartialSuccess,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => JobStatus::Failed,
            "IN_PROGRESS" => JobStatus::InProgress,
            "PARTIAL_SUCCESS" => JobStatus::PartialSuccess,
            "SUCCEEDED" => JobStatus::Succeeded,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Failed => "FAILED",
            JobStatus::InProgress => "IN_PROGRESS",
            JobStatus::PartialSuccess => "PARTIAL_SUCCESS",
            JobStatus::Succeeded => "SUCCEEDED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "PARTIAL_SUCCESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the input document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocumentMetadata {
    /// <p>The number of pages that are detected in the document.</p>
    pub pages: std::option::Option<i32>,
}
impl DocumentMetadata {
    /// <p>The number of pages that are detected in the document.</p>
    pub fn pages(&self) -> std::option::Option<i32> {
        self.pages
    }
}
impl std::fmt::Debug for DocumentMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocumentMetadata");
        formatter.field("pages", &self.pages);
        formatter.finish()
    }
}
/// See [`DocumentMetadata`](crate::model::DocumentMetadata)
pub mod document_metadata {
    /// A builder for [`DocumentMetadata`](crate::model::DocumentMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pages: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of pages that are detected in the document.</p>
        pub fn pages(mut self, input: i32) -> Self {
            self.pages = Some(input);
            self
        }
        /// <p>The number of pages that are detected in the document.</p>
        pub fn set_pages(mut self, input: std::option::Option<i32>) -> Self {
            self.pages = input;
            self
        }
        /// Consumes the builder and constructs a [`DocumentMetadata`](crate::model::DocumentMetadata)
        pub fn build(self) -> crate::model::DocumentMetadata {
            crate::model::DocumentMetadata { pages: self.pages }
        }
    }
}
impl DocumentMetadata {
    /// Creates a new builder-style object to manufacture [`DocumentMetadata`](crate::model::DocumentMetadata)
    pub fn builder() -> crate::model::document_metadata::Builder {
        crate::model::document_metadata::Builder::default()
    }
}

/// <p>A <code>Block</code> represents items that are recognized in a document within a group
/// of pixels close to each other. The information returned in a <code>Block</code> object
/// depends on the type of operation. In text detection for documents (for example <a>DetectDocumentText</a>), you get information about the detected words and lines
/// of text. In text analysis (for example <a>AnalyzeDocument</a>), you can also get
/// information about the fields, tables, and selection elements that are detected in the
/// document.</p>
/// <p>An array of <code>Block</code> objects is returned by both synchronous and asynchronous
/// operations. In synchronous operations, such as <a>DetectDocumentText</a>, the
/// array of <code>Block</code> objects is the entire set of results. In asynchronous
/// operations, such as <a>GetDocumentAnalysis</a>, the array is returned over one
/// or more responses.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/how-it-works.html">How Amazon Textract Works</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Block {
    /// <p>The type of text item that's recognized. In operations for text detection, the following
    /// types are returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>PAGE</i> - Contains a list of the LINE <code>Block</code> objects
    /// that are detected on a document page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>WORD</i> - A word detected on a document page. A word is one or
    /// more ISO basic Latin script characters that aren't separated by spaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
    /// detected on a document page.</p>
    /// </li>
    /// </ul>
    /// <p>In text analysis operations, the following types are returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>PAGE</i> - Contains a list of child <code>Block</code> objects
    /// that are detected on a document page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>KEY_VALUE_SET</i> - Stores the KEY and VALUE <code>Block</code>
    /// objects for linked text that's detected on a document page. Use the
    /// <code>EntityType</code> field to determine if a KEY_VALUE_SET object is a KEY
    /// <code>Block</code> object or a VALUE <code>Block</code> object. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>WORD</i> - A word that's detected on a document page. A word is
    /// one or more ISO basic Latin script characters that aren't separated by spaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
    /// detected on a document page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>TABLE</i> - A table that's detected on a document page. A table
    /// is grid-based information with two or more rows or columns, with a cell span of one
    /// row and one column each. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>CELL</i> - A cell within a detected table. The cell is the parent
    /// of the block that contains the text in the cell.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>SELECTION_ELEMENT</i> - A selection element such as an option
    /// button (radio button) or a check box that's detected on a document page. Use the
    /// value of <code>SelectionStatus</code> to determine the status of the selection
    /// element.</p>
    /// </li>
    /// </ul>
    pub block_type: std::option::Option<crate::model::BlockType>,
    /// <p>The confidence score that Amazon Textract has in the accuracy of the recognized text and
    /// the accuracy of the geometry points around the recognized text.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>The word or line of text that's recognized by Amazon Textract. </p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The kind of text that Amazon Textract has detected. Can check for handwritten text and
    /// printed text.</p>
    pub text_type: std::option::Option<crate::model::TextType>,
    /// <p>The row in which a table cell is located. The first row position is 1.
    /// <code>RowIndex</code> isn't returned by <code>DetectDocumentText</code> and
    /// <code>GetDocumentTextDetection</code>.</p>
    pub row_index: std::option::Option<i32>,
    /// <p>The column in which a table cell appears. The first column position is 1.
    /// <code>ColumnIndex</code> isn't returned by <code>DetectDocumentText</code> and
    /// <code>GetDocumentTextDetection</code>.</p>
    pub column_index: std::option::Option<i32>,
    /// <p>The number of rows that a table cell spans. Currently this value is always 1, even if
    /// the number of rows spanned is greater than 1. <code>RowSpan</code> isn't returned by
    /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>.</p>
    pub row_span: std::option::Option<i32>,
    /// <p>The number of columns that a table cell spans. Currently this value is always 1, even if
    /// the number of columns spanned is greater than 1. <code>ColumnSpan</code> isn't returned by
    /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>. </p>
    pub column_span: std::option::Option<i32>,
    /// <p>The location of the recognized text on the image. It includes an axis-aligned, coarse
    /// bounding box that surrounds the text, and a finer-grain polygon for more accurate spatial
    /// information. </p>
    pub geometry: std::option::Option<crate::model::Geometry>,
    /// <p>The identifier for the recognized text. The identifier is only unique for a single
    /// operation. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A list of child blocks of the current block. For example, a LINE object has child blocks
    /// for each WORD block that's part of the line of text. There aren't Relationship objects in
    /// the list for relationships that don't exist, such as when the current block has no child
    /// blocks. The list size can be the following:</p>
    /// <ul>
    /// <li>
    /// <p>0 - The block has no child blocks.</p>
    /// </li>
    /// <li>
    /// <p>1 - The block has child blocks.</p>
    /// </li>
    /// </ul>
    pub relationships: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
    /// <p>The type of entity. The following can be returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>KEY</i> - An identifier for a field on the document.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>VALUE</i> - The field text.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>EntityTypes</code> isn't returned by <code>DetectDocumentText</code> and
    /// <code>GetDocumentTextDetection</code>.</p>
    pub entity_types: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
    /// <p>The selection status of a selection element, such as an option button or check box.
    /// </p>
    pub selection_status: std::option::Option<crate::model::SelectionStatus>,
    /// <p>The page on which a block was detected. <code>Page</code> is returned by asynchronous
    /// operations. Page values greater than 1 are only returned for multipage documents that are
    /// in PDF or TIFF format. A scanned image (JPEG/PNG), even if it contains multiple document pages, is
    /// considered to be a single-page document. The value of <code>Page</code> is always 1.
    /// Synchronous operations don't return <code>Page</code> because every input document is
    /// considered to be a single-page document.</p>
    pub page: std::option::Option<i32>,
}
impl Block {
    /// <p>The type of text item that's recognized. In operations for text detection, the following
    /// types are returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>PAGE</i> - Contains a list of the LINE <code>Block</code> objects
    /// that are detected on a document page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>WORD</i> - A word detected on a document page. A word is one or
    /// more ISO basic Latin script characters that aren't separated by spaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
    /// detected on a document page.</p>
    /// </li>
    /// </ul>
    /// <p>In text analysis operations, the following types are returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>PAGE</i> - Contains a list of child <code>Block</code> objects
    /// that are detected on a document page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>KEY_VALUE_SET</i> - Stores the KEY and VALUE <code>Block</code>
    /// objects for linked text that's detected on a document page. Use the
    /// <code>EntityType</code> field to determine if a KEY_VALUE_SET object is a KEY
    /// <code>Block</code> object or a VALUE <code>Block</code> object. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>WORD</i> - A word that's detected on a document page. A word is
    /// one or more ISO basic Latin script characters that aren't separated by spaces.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
    /// detected on a document page.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>TABLE</i> - A table that's detected on a document page. A table
    /// is grid-based information with two or more rows or columns, with a cell span of one
    /// row and one column each. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>CELL</i> - A cell within a detected table. The cell is the parent
    /// of the block that contains the text in the cell.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>SELECTION_ELEMENT</i> - A selection element such as an option
    /// button (radio button) or a check box that's detected on a document page. Use the
    /// value of <code>SelectionStatus</code> to determine the status of the selection
    /// element.</p>
    /// </li>
    /// </ul>
    pub fn block_type(&self) -> std::option::Option<&crate::model::BlockType> {
        self.block_type.as_ref()
    }
    /// <p>The confidence score that Amazon Textract has in the accuracy of the recognized text and
    /// the accuracy of the geometry points around the recognized text.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>The word or line of text that's recognized by Amazon Textract. </p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>The kind of text that Amazon Textract has detected. Can check for handwritten text and
    /// printed text.</p>
    pub fn text_type(&self) -> std::option::Option<&crate::model::TextType> {
        self.text_type.as_ref()
    }
    /// <p>The row in which a table cell is located. The first row position is 1.
    /// <code>RowIndex</code> isn't returned by <code>DetectDocumentText</code> and
    /// <code>GetDocumentTextDetection</code>.</p>
    pub fn row_index(&self) -> std::option::Option<i32> {
        self.row_index
    }
    /// <p>The column in which a table cell appears. The first column position is 1.
    /// <code>ColumnIndex</code> isn't returned by <code>DetectDocumentText</code> and
    /// <code>GetDocumentTextDetection</code>.</p>
    pub fn column_index(&self) -> std::option::Option<i32> {
        self.column_index
    }
    /// <p>The number of rows that a table cell spans. Currently this value is always 1, even if
    /// the number of rows spanned is greater than 1. <code>RowSpan</code> isn't returned by
    /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>.</p>
    pub fn row_span(&self) -> std::option::Option<i32> {
        self.row_span
    }
    /// <p>The number of columns that a table cell spans. Currently this value is always 1, even if
    /// the number of columns spanned is greater than 1. <code>ColumnSpan</code> isn't returned by
    /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>. </p>
    pub fn column_span(&self) -> std::option::Option<i32> {
        self.column_span
    }
    /// <p>The location of the recognized text on the image. It includes an axis-aligned, coarse
    /// bounding box that surrounds the text, and a finer-grain polygon for more accurate spatial
    /// information. </p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::Geometry> {
        self.geometry.as_ref()
    }
    /// <p>The identifier for the recognized text. The identifier is only unique for a single
    /// operation. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A list of child blocks of the current block. For example, a LINE object has child blocks
    /// for each WORD block that's part of the line of text. There aren't Relationship objects in
    /// the list for relationships that don't exist, such as when the current block has no child
    /// blocks. The list size can be the following:</p>
    /// <ul>
    /// <li>
    /// <p>0 - The block has no child blocks.</p>
    /// </li>
    /// <li>
    /// <p>1 - The block has child blocks.</p>
    /// </li>
    /// </ul>
    pub fn relationships(&self) -> std::option::Option<&[crate::model::Relationship]> {
        self.relationships.as_deref()
    }
    /// <p>The type of entity. The following can be returned:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>KEY</i> - An identifier for a field on the document.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>VALUE</i> - The field text.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// <code>EntityTypes</code> isn't returned by <code>DetectDocumentText</code> and
    /// <code>GetDocumentTextDetection</code>.</p>
    pub fn entity_types(&self) -> std::option::Option<&[crate::model::EntityType]> {
        self.entity_types.as_deref()
    }
    /// <p>The selection status of a selection element, such as an option button or check box.
    /// </p>
    pub fn selection_status(&self) -> std::option::Option<&crate::model::SelectionStatus> {
        self.selection_status.as_ref()
    }
    /// <p>The page on which a block was detected. <code>Page</code> is returned by asynchronous
    /// operations. Page values greater than 1 are only returned for multipage documents that are
    /// in PDF or TIFF format. A scanned image (JPEG/PNG), even if it contains multiple document pages, is
    /// considered to be a single-page document. The value of <code>Page</code> is always 1.
    /// Synchronous operations don't return <code>Page</code> because every input document is
    /// considered to be a single-page document.</p>
    pub fn page(&self) -> std::option::Option<i32> {
        self.page
    }
}
impl std::fmt::Debug for Block {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Block");
        formatter.field("block_type", &self.block_type);
        formatter.field("confidence", &self.confidence);
        formatter.field("text", &self.text);
        formatter.field("text_type", &self.text_type);
        formatter.field("row_index", &self.row_index);
        formatter.field("column_index", &self.column_index);
        formatter.field("row_span", &self.row_span);
        formatter.field("column_span", &self.column_span);
        formatter.field("geometry", &self.geometry);
        formatter.field("id", &self.id);
        formatter.field("relationships", &self.relationships);
        formatter.field("entity_types", &self.entity_types);
        formatter.field("selection_status", &self.selection_status);
        formatter.field("page", &self.page);
        formatter.finish()
    }
}
/// See [`Block`](crate::model::Block)
pub mod block {
    /// A builder for [`Block`](crate::model::Block)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_type: std::option::Option<crate::model::BlockType>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) text_type: std::option::Option<crate::model::TextType>,
        pub(crate) row_index: std::option::Option<i32>,
        pub(crate) column_index: std::option::Option<i32>,
        pub(crate) row_span: std::option::Option<i32>,
        pub(crate) column_span: std::option::Option<i32>,
        pub(crate) geometry: std::option::Option<crate::model::Geometry>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) relationships: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
        pub(crate) entity_types: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        pub(crate) selection_status: std::option::Option<crate::model::SelectionStatus>,
        pub(crate) page: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of text item that's recognized. In operations for text detection, the following
        /// types are returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>PAGE</i> - Contains a list of the LINE <code>Block</code> objects
        /// that are detected on a document page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>WORD</i> - A word detected on a document page. A word is one or
        /// more ISO basic Latin script characters that aren't separated by spaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
        /// detected on a document page.</p>
        /// </li>
        /// </ul>
        /// <p>In text analysis operations, the following types are returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>PAGE</i> - Contains a list of child <code>Block</code> objects
        /// that are detected on a document page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>KEY_VALUE_SET</i> - Stores the KEY and VALUE <code>Block</code>
        /// objects for linked text that's detected on a document page. Use the
        /// <code>EntityType</code> field to determine if a KEY_VALUE_SET object is a KEY
        /// <code>Block</code> object or a VALUE <code>Block</code> object. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>WORD</i> - A word that's detected on a document page. A word is
        /// one or more ISO basic Latin script characters that aren't separated by spaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
        /// detected on a document page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>TABLE</i> - A table that's detected on a document page. A table
        /// is grid-based information with two or more rows or columns, with a cell span of one
        /// row and one column each. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>CELL</i> - A cell within a detected table. The cell is the parent
        /// of the block that contains the text in the cell.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>SELECTION_ELEMENT</i> - A selection element such as an option
        /// button (radio button) or a check box that's detected on a document page. Use the
        /// value of <code>SelectionStatus</code> to determine the status of the selection
        /// element.</p>
        /// </li>
        /// </ul>
        pub fn block_type(mut self, input: crate::model::BlockType) -> Self {
            self.block_type = Some(input);
            self
        }
        /// <p>The type of text item that's recognized. In operations for text detection, the following
        /// types are returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>PAGE</i> - Contains a list of the LINE <code>Block</code> objects
        /// that are detected on a document page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>WORD</i> - A word detected on a document page. A word is one or
        /// more ISO basic Latin script characters that aren't separated by spaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
        /// detected on a document page.</p>
        /// </li>
        /// </ul>
        /// <p>In text analysis operations, the following types are returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>PAGE</i> - Contains a list of child <code>Block</code> objects
        /// that are detected on a document page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>KEY_VALUE_SET</i> - Stores the KEY and VALUE <code>Block</code>
        /// objects for linked text that's detected on a document page. Use the
        /// <code>EntityType</code> field to determine if a KEY_VALUE_SET object is a KEY
        /// <code>Block</code> object or a VALUE <code>Block</code> object. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>WORD</i> - A word that's detected on a document page. A word is
        /// one or more ISO basic Latin script characters that aren't separated by spaces.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>LINE</i> - A string of tab-delimited, contiguous words that are
        /// detected on a document page.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>TABLE</i> - A table that's detected on a document page. A table
        /// is grid-based information with two or more rows or columns, with a cell span of one
        /// row and one column each. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>CELL</i> - A cell within a detected table. The cell is the parent
        /// of the block that contains the text in the cell.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>SELECTION_ELEMENT</i> - A selection element such as an option
        /// button (radio button) or a check box that's detected on a document page. Use the
        /// value of <code>SelectionStatus</code> to determine the status of the selection
        /// element.</p>
        /// </li>
        /// </ul>
        pub fn set_block_type(
            mut self,
            input: std::option::Option<crate::model::BlockType>,
        ) -> Self {
            self.block_type = input;
            self
        }
        /// <p>The confidence score that Amazon Textract has in the accuracy of the recognized text and
        /// the accuracy of the geometry points around the recognized text.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence score that Amazon Textract has in the accuracy of the recognized text and
        /// the accuracy of the geometry points around the recognized text.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The word or line of text that's recognized by Amazon Textract. </p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The word or line of text that's recognized by Amazon Textract. </p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The kind of text that Amazon Textract has detected. Can check for handwritten text and
        /// printed text.</p>
        pub fn text_type(mut self, input: crate::model::TextType) -> Self {
            self.text_type = Some(input);
            self
        }
        /// <p>The kind of text that Amazon Textract has detected. Can check for handwritten text and
        /// printed text.</p>
        pub fn set_text_type(mut self, input: std::option::Option<crate::model::TextType>) -> Self {
            self.text_type = input;
            self
        }
        /// <p>The row in which a table cell is located. The first row position is 1.
        /// <code>RowIndex</code> isn't returned by <code>DetectDocumentText</code> and
        /// <code>GetDocumentTextDetection</code>.</p>
        pub fn row_index(mut self, input: i32) -> Self {
            self.row_index = Some(input);
            self
        }
        /// <p>The row in which a table cell is located. The first row position is 1.
        /// <code>RowIndex</code> isn't returned by <code>DetectDocumentText</code> and
        /// <code>GetDocumentTextDetection</code>.</p>
        pub fn set_row_index(mut self, input: std::option::Option<i32>) -> Self {
            self.row_index = input;
            self
        }
        /// <p>The column in which a table cell appears. The first column position is 1.
        /// <code>ColumnIndex</code> isn't returned by <code>DetectDocumentText</code> and
        /// <code>GetDocumentTextDetection</code>.</p>
        pub fn column_index(mut self, input: i32) -> Self {
            self.column_index = Some(input);
            self
        }
        /// <p>The column in which a table cell appears. The first column position is 1.
        /// <code>ColumnIndex</code> isn't returned by <code>DetectDocumentText</code> and
        /// <code>GetDocumentTextDetection</code>.</p>
        pub fn set_column_index(mut self, input: std::option::Option<i32>) -> Self {
            self.column_index = input;
            self
        }
        /// <p>The number of rows that a table cell spans. Currently this value is always 1, even if
        /// the number of rows spanned is greater than 1. <code>RowSpan</code> isn't returned by
        /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>.</p>
        pub fn row_span(mut self, input: i32) -> Self {
            self.row_span = Some(input);
            self
        }
        /// <p>The number of rows that a table cell spans. Currently this value is always 1, even if
        /// the number of rows spanned is greater than 1. <code>RowSpan</code> isn't returned by
        /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>.</p>
        pub fn set_row_span(mut self, input: std::option::Option<i32>) -> Self {
            self.row_span = input;
            self
        }
        /// <p>The number of columns that a table cell spans. Currently this value is always 1, even if
        /// the number of columns spanned is greater than 1. <code>ColumnSpan</code> isn't returned by
        /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>. </p>
        pub fn column_span(mut self, input: i32) -> Self {
            self.column_span = Some(input);
            self
        }
        /// <p>The number of columns that a table cell spans. Currently this value is always 1, even if
        /// the number of columns spanned is greater than 1. <code>ColumnSpan</code> isn't returned by
        /// <code>DetectDocumentText</code> and <code>GetDocumentTextDetection</code>. </p>
        pub fn set_column_span(mut self, input: std::option::Option<i32>) -> Self {
            self.column_span = input;
            self
        }
        /// <p>The location of the recognized text on the image. It includes an axis-aligned, coarse
        /// bounding box that surrounds the text, and a finer-grain polygon for more accurate spatial
        /// information. </p>
        pub fn geometry(mut self, input: crate::model::Geometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>The location of the recognized text on the image. It includes an axis-aligned, coarse
        /// bounding box that surrounds the text, and a finer-grain polygon for more accurate spatial
        /// information. </p>
        pub fn set_geometry(mut self, input: std::option::Option<crate::model::Geometry>) -> Self {
            self.geometry = input;
            self
        }
        /// <p>The identifier for the recognized text. The identifier is only unique for a single
        /// operation. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the recognized text. The identifier is only unique for a single
        /// operation. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `relationships`.
        ///
        /// To override the contents of this collection use [`set_relationships`](Self::set_relationships).
        ///
        /// <p>A list of child blocks of the current block. For example, a LINE object has child blocks
        /// for each WORD block that's part of the line of text. There aren't Relationship objects in
        /// the list for relationships that don't exist, such as when the current block has no child
        /// blocks. The list size can be the following:</p>
        /// <ul>
        /// <li>
        /// <p>0 - The block has no child blocks.</p>
        /// </li>
        /// <li>
        /// <p>1 - The block has child blocks.</p>
        /// </li>
        /// </ul>
        pub fn relationships(mut self, input: impl Into<crate::model::Relationship>) -> Self {
            let mut v = self.relationships.unwrap_or_default();
            v.push(input.into());
            self.relationships = Some(v);
            self
        }
        /// <p>A list of child blocks of the current block. For example, a LINE object has child blocks
        /// for each WORD block that's part of the line of text. There aren't Relationship objects in
        /// the list for relationships that don't exist, such as when the current block has no child
        /// blocks. The list size can be the following:</p>
        /// <ul>
        /// <li>
        /// <p>0 - The block has no child blocks.</p>
        /// </li>
        /// <li>
        /// <p>1 - The block has child blocks.</p>
        /// </li>
        /// </ul>
        pub fn set_relationships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Relationship>>,
        ) -> Self {
            self.relationships = input;
            self
        }
        /// Appends an item to `entity_types`.
        ///
        /// To override the contents of this collection use [`set_entity_types`](Self::set_entity_types).
        ///
        /// <p>The type of entity. The following can be returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>KEY</i> - An identifier for a field on the document.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>VALUE</i> - The field text.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>EntityTypes</code> isn't returned by <code>DetectDocumentText</code> and
        /// <code>GetDocumentTextDetection</code>.</p>
        pub fn entity_types(mut self, input: impl Into<crate::model::EntityType>) -> Self {
            let mut v = self.entity_types.unwrap_or_default();
            v.push(input.into());
            self.entity_types = Some(v);
            self
        }
        /// <p>The type of entity. The following can be returned:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>KEY</i> - An identifier for a field on the document.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>VALUE</i> - The field text.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <code>EntityTypes</code> isn't returned by <code>DetectDocumentText</code> and
        /// <code>GetDocumentTextDetection</code>.</p>
        pub fn set_entity_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.entity_types = input;
            self
        }
        /// <p>The selection status of a selection element, such as an option button or check box.
        /// </p>
        pub fn selection_status(mut self, input: crate::model::SelectionStatus) -> Self {
            self.selection_status = Some(input);
            self
        }
        /// <p>The selection status of a selection element, such as an option button or check box.
        /// </p>
        pub fn set_selection_status(
            mut self,
            input: std::option::Option<crate::model::SelectionStatus>,
        ) -> Self {
            self.selection_status = input;
            self
        }
        /// <p>The page on which a block was detected. <code>Page</code> is returned by asynchronous
        /// operations. Page values greater than 1 are only returned for multipage documents that are
        /// in PDF or TIFF format. A scanned image (JPEG/PNG), even if it contains multiple document pages, is
        /// considered to be a single-page document. The value of <code>Page</code> is always 1.
        /// Synchronous operations don't return <code>Page</code> because every input document is
        /// considered to be a single-page document.</p>
        pub fn page(mut self, input: i32) -> Self {
            self.page = Some(input);
            self
        }
        /// <p>The page on which a block was detected. <code>Page</code> is returned by asynchronous
        /// operations. Page values greater than 1 are only returned for multipage documents that are
        /// in PDF or TIFF format. A scanned image (JPEG/PNG), even if it contains multiple document pages, is
        /// considered to be a single-page document. The value of <code>Page</code> is always 1.
        /// Synchronous operations don't return <code>Page</code> because every input document is
        /// considered to be a single-page document.</p>
        pub fn set_page(mut self, input: std::option::Option<i32>) -> Self {
            self.page = input;
            self
        }
        /// Consumes the builder and constructs a [`Block`](crate::model::Block)
        pub fn build(self) -> crate::model::Block {
            crate::model::Block {
                block_type: self.block_type,
                confidence: self.confidence,
                text: self.text,
                text_type: self.text_type,
                row_index: self.row_index,
                column_index: self.column_index,
                row_span: self.row_span,
                column_span: self.column_span,
                geometry: self.geometry,
                id: self.id,
                relationships: self.relationships,
                entity_types: self.entity_types,
                selection_status: self.selection_status,
                page: self.page,
            }
        }
    }
}
impl Block {
    /// Creates a new builder-style object to manufacture [`Block`](crate::model::Block)
    pub fn builder() -> crate::model::block::Builder {
        crate::model::block::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SelectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    NotSelected,
    #[allow(missing_docs)] // documentation missing in model
    Selected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SelectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "NOT_SELECTED" => SelectionStatus::NotSelected,
            "SELECTED" => SelectionStatus::Selected,
            other => SelectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SelectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SelectionStatus::from(s))
    }
}
impl SelectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SelectionStatus::NotSelected => "NOT_SELECTED",
            SelectionStatus::Selected => "SELECTED",
            SelectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_SELECTED", "SELECTED"]
    }
}
impl AsRef<str> for SelectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityType {
    #[allow(missing_docs)] // documentation missing in model
    Key,
    #[allow(missing_docs)] // documentation missing in model
    Value,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityType {
    fn from(s: &str) -> Self {
        match s {
            "KEY" => EntityType::Key,
            "VALUE" => EntityType::Value,
            other => EntityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityType::from(s))
    }
}
impl EntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityType::Key => "KEY",
            EntityType::Value => "VALUE",
            EntityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KEY", "VALUE"]
    }
}
impl AsRef<str> for EntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about how blocks are related to each other. A <code>Block</code> object
/// contains 0 or more <code>Relation</code> objects in a list, <code>Relationships</code>. For
/// more information, see <a>Block</a>.</p>
/// <p>The <code>Type</code> element provides the type of the relationship for all blocks in
/// the <code>IDs</code> array. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Relationship {
    /// <p>The type of relationship that the blocks in the IDs array have with the current block.
    /// The relationship can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type
    /// VALUE is a list that contains the ID of the VALUE block that's associated with the KEY of a
    /// key-value pair. A relationship of type CHILD is a list of IDs that identify WORD blocks in
    /// the case of lines Cell blocks in the case of Tables, and WORD blocks in the case of
    /// Selection Elements.</p>
    pub r#type: std::option::Option<crate::model::RelationshipType>,
    /// <p>An
    /// array of IDs for related blocks. You can get the type of the relationship from the
    /// <code>Type</code> element.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Relationship {
    /// <p>The type of relationship that the blocks in the IDs array have with the current block.
    /// The relationship can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type
    /// VALUE is a list that contains the ID of the VALUE block that's associated with the KEY of a
    /// key-value pair. A relationship of type CHILD is a list of IDs that identify WORD blocks in
    /// the case of lines Cell blocks in the case of Tables, and WORD blocks in the case of
    /// Selection Elements.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RelationshipType> {
        self.r#type.as_ref()
    }
    /// <p>An
    /// array of IDs for related blocks. You can get the type of the relationship from the
    /// <code>Type</code> element.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
}
impl std::fmt::Debug for Relationship {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Relationship");
        formatter.field("r#type", &self.r#type);
        formatter.field("ids", &self.ids);
        formatter.finish()
    }
}
/// See [`Relationship`](crate::model::Relationship)
pub mod relationship {
    /// A builder for [`Relationship`](crate::model::Relationship)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::RelationshipType>,
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of relationship that the blocks in the IDs array have with the current block.
        /// The relationship can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type
        /// VALUE is a list that contains the ID of the VALUE block that's associated with the KEY of a
        /// key-value pair. A relationship of type CHILD is a list of IDs that identify WORD blocks in
        /// the case of lines Cell blocks in the case of Tables, and WORD blocks in the case of
        /// Selection Elements.</p>
        pub fn r#type(mut self, input: crate::model::RelationshipType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of relationship that the blocks in the IDs array have with the current block.
        /// The relationship can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type
        /// VALUE is a list that contains the ID of the VALUE block that's associated with the KEY of a
        /// key-value pair. A relationship of type CHILD is a list of IDs that identify WORD blocks in
        /// the case of lines Cell blocks in the case of Tables, and WORD blocks in the case of
        /// Selection Elements.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RelationshipType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An
        /// array of IDs for related blocks. You can get the type of the relationship from the
        /// <code>Type</code> element.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>An
        /// array of IDs for related blocks. You can get the type of the relationship from the
        /// <code>Type</code> element.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// Consumes the builder and constructs a [`Relationship`](crate::model::Relationship)
        pub fn build(self) -> crate::model::Relationship {
            crate::model::Relationship {
                r#type: self.r#type,
                ids: self.ids,
            }
        }
    }
}
impl Relationship {
    /// Creates a new builder-style object to manufacture [`Relationship`](crate::model::Relationship)
    pub fn builder() -> crate::model::relationship::Builder {
        crate::model::relationship::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationshipType {
    #[allow(missing_docs)] // documentation missing in model
    Child,
    #[allow(missing_docs)] // documentation missing in model
    ComplexFeatures,
    #[allow(missing_docs)] // documentation missing in model
    Value,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationshipType {
    fn from(s: &str) -> Self {
        match s {
            "CHILD" => RelationshipType::Child,
            "COMPLEX_FEATURES" => RelationshipType::ComplexFeatures,
            "VALUE" => RelationshipType::Value,
            other => RelationshipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationshipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationshipType::from(s))
    }
}
impl RelationshipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationshipType::Child => "CHILD",
            RelationshipType::ComplexFeatures => "COMPLEX_FEATURES",
            RelationshipType::Value => "VALUE",
            RelationshipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHILD", "COMPLEX_FEATURES", "VALUE"]
    }
}
impl AsRef<str> for RelationshipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TextType {
    #[allow(missing_docs)] // documentation missing in model
    Handwriting,
    #[allow(missing_docs)] // documentation missing in model
    Printed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TextType {
    fn from(s: &str) -> Self {
        match s {
            "HANDWRITING" => TextType::Handwriting,
            "PRINTED" => TextType::Printed,
            other => TextType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TextType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TextType::from(s))
    }
}
impl TextType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TextType::Handwriting => "HANDWRITING",
            TextType::Printed => "PRINTED",
            TextType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HANDWRITING", "PRINTED"]
    }
}
impl AsRef<str> for TextType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BlockType {
    #[allow(missing_docs)] // documentation missing in model
    Cell,
    #[allow(missing_docs)] // documentation missing in model
    KeyValueSet,
    #[allow(missing_docs)] // documentation missing in model
    Line,
    #[allow(missing_docs)] // documentation missing in model
    Page,
    #[allow(missing_docs)] // documentation missing in model
    SelectionElement,
    #[allow(missing_docs)] // documentation missing in model
    Table,
    #[allow(missing_docs)] // documentation missing in model
    Word,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BlockType {
    fn from(s: &str) -> Self {
        match s {
            "CELL" => BlockType::Cell,
            "KEY_VALUE_SET" => BlockType::KeyValueSet,
            "LINE" => BlockType::Line,
            "PAGE" => BlockType::Page,
            "SELECTION_ELEMENT" => BlockType::SelectionElement,
            "TABLE" => BlockType::Table,
            "WORD" => BlockType::Word,
            other => BlockType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BlockType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BlockType::from(s))
    }
}
impl BlockType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BlockType::Cell => "CELL",
            BlockType::KeyValueSet => "KEY_VALUE_SET",
            BlockType::Line => "LINE",
            BlockType::Page => "PAGE",
            BlockType::SelectionElement => "SELECTION_ELEMENT",
            BlockType::Table => "TABLE",
            BlockType::Word => "WORD",
            BlockType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CELL",
            "KEY_VALUE_SET",
            "LINE",
            "PAGE",
            "SELECTION_ELEMENT",
            "TABLE",
            "WORD",
        ]
    }
}
impl AsRef<str> for BlockType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The input document, either as bytes or as an S3 object.</p>
/// <p>You pass image bytes to an Amazon Textract API operation by using the <code>Bytes</code>
/// property. For example, you would use the <code>Bytes</code> property to pass a document
/// loaded from a local file system. Image bytes passed by using the <code>Bytes</code>
/// property must be base64 encoded. Your code might not need to encode document file bytes if
/// you're using an AWS SDK to call Amazon Textract API operations. </p>
/// <p>You pass images stored in an S3 bucket to an Amazon Textract API operation by using the
/// <code>S3Object</code> property. Documents stored in an S3 bucket don't need to be base64
/// encoded.</p>
/// <p>The AWS Region for the S3 bucket that contains the S3 object must match the AWS
/// Region that you use for Amazon Textract operations.</p>
/// <p>If you use the AWS CLI to call Amazon Textract operations, passing image bytes using
/// the Bytes property isn't supported. You must first upload the document to an Amazon S3
/// bucket, and then call the operation using the S3Object property.</p>
///
/// <p>For Amazon Textract to process an S3 object, the user must have permission
/// to access the S3 object. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Document {
    /// <p>A blob of base64-encoded document bytes. The maximum size of a document that's provided
    /// in a blob of bytes is 5 MB. The document bytes must be in PNG or JPEG format.</p>
    /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
    /// image bytes passed using the <code>Bytes</code> field. </p>
    pub bytes: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Identifies an S3 object as the document source. The maximum size of a document that's
    /// stored in an S3 bucket is 5 MB.</p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl Document {
    /// <p>A blob of base64-encoded document bytes. The maximum size of a document that's provided
    /// in a blob of bytes is 5 MB. The document bytes must be in PNG or JPEG format.</p>
    /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
    /// image bytes passed using the <code>Bytes</code> field. </p>
    pub fn bytes(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.bytes.as_ref()
    }
    /// <p>Identifies an S3 object as the document source. The maximum size of a document that's
    /// stored in an S3 bucket is 5 MB.</p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for Document {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Document");
        formatter.field("bytes", &self.bytes);
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`Document`](crate::model::Document)
pub mod document {
    /// A builder for [`Document`](crate::model::Document)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bytes: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>A blob of base64-encoded document bytes. The maximum size of a document that's provided
        /// in a blob of bytes is 5 MB. The document bytes must be in PNG or JPEG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes passed using the <code>Bytes</code> field. </p>
        pub fn bytes(mut self, input: aws_smithy_types::Blob) -> Self {
            self.bytes = Some(input);
            self
        }
        /// <p>A blob of base64-encoded document bytes. The maximum size of a document that's provided
        /// in a blob of bytes is 5 MB. The document bytes must be in PNG or JPEG format.</p>
        /// <p>If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode
        /// image bytes passed using the <code>Bytes</code> field. </p>
        pub fn set_bytes(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.bytes = input;
            self
        }
        /// <p>Identifies an S3 object as the document source. The maximum size of a document that's
        /// stored in an S3 bucket is 5 MB.</p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>Identifies an S3 object as the document source. The maximum size of a document that's
        /// stored in an S3 bucket is 5 MB.</p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`Document`](crate::model::Document)
        pub fn build(self) -> crate::model::Document {
            crate::model::Document {
                bytes: self.bytes,
                s3_object: self.s3_object,
            }
        }
    }
}
impl Document {
    /// Creates a new builder-style object to manufacture [`Document`](crate::model::Document)
    pub fn builder() -> crate::model::document::Builder {
        crate::model::document::Builder::default()
    }
}

/// <p>Shows the results of the human in the loop evaluation. If there is no HumanLoopArn, the
/// input did not trigger human review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopActivationOutput {
    /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
    pub human_loop_arn: std::option::Option<std::string::String>,
    /// <p>Shows if and why human review was needed.</p>
    pub human_loop_activation_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Shows the result of condition evaluations, including those conditions which activated a
    /// human review.</p>
    pub human_loop_activation_conditions_evaluation_results:
        std::option::Option<std::string::String>,
}
impl HumanLoopActivationOutput {
    /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
    pub fn human_loop_arn(&self) -> std::option::Option<&str> {
        self.human_loop_arn.as_deref()
    }
    /// <p>Shows if and why human review was needed.</p>
    pub fn human_loop_activation_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.human_loop_activation_reasons.as_deref()
    }
    /// <p>Shows the result of condition evaluations, including those conditions which activated a
    /// human review.</p>
    pub fn human_loop_activation_conditions_evaluation_results(&self) -> std::option::Option<&str> {
        self.human_loop_activation_conditions_evaluation_results
            .as_deref()
    }
}
impl std::fmt::Debug for HumanLoopActivationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopActivationOutput");
        formatter.field("human_loop_arn", &self.human_loop_arn);
        formatter.field(
            "human_loop_activation_reasons",
            &self.human_loop_activation_reasons,
        );
        formatter.field(
            "human_loop_activation_conditions_evaluation_results",
            &self.human_loop_activation_conditions_evaluation_results,
        );
        formatter.finish()
    }
}
/// See [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
pub mod human_loop_activation_output {
    /// A builder for [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_arn: std::option::Option<std::string::String>,
        pub(crate) human_loop_activation_reasons:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) human_loop_activation_conditions_evaluation_results:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
        pub fn human_loop_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
        pub fn set_human_loop_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_arn = input;
            self
        }
        /// Appends an item to `human_loop_activation_reasons`.
        ///
        /// To override the contents of this collection use [`set_human_loop_activation_reasons`](Self::set_human_loop_activation_reasons).
        ///
        /// <p>Shows if and why human review was needed.</p>
        pub fn human_loop_activation_reasons(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.human_loop_activation_reasons.unwrap_or_default();
            v.push(input.into());
            self.human_loop_activation_reasons = Some(v);
            self
        }
        /// <p>Shows if and why human review was needed.</p>
        pub fn set_human_loop_activation_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.human_loop_activation_reasons = input;
            self
        }
        /// <p>Shows the result of condition evaluations, including those conditions which activated a
        /// human review.</p>
        pub fn human_loop_activation_conditions_evaluation_results(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.human_loop_activation_conditions_evaluation_results = Some(input.into());
            self
        }
        /// <p>Shows the result of condition evaluations, including those conditions which activated a
        /// human review.</p>
        pub fn set_human_loop_activation_conditions_evaluation_results(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_activation_conditions_evaluation_results = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
        pub fn build(self) -> crate::model::HumanLoopActivationOutput {
            crate::model::HumanLoopActivationOutput {
                human_loop_arn: self.human_loop_arn,
                human_loop_activation_reasons: self.human_loop_activation_reasons,
                human_loop_activation_conditions_evaluation_results: self
                    .human_loop_activation_conditions_evaluation_results,
            }
        }
    }
}
impl HumanLoopActivationOutput {
    /// Creates a new builder-style object to manufacture [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
    pub fn builder() -> crate::model::human_loop_activation_output::Builder {
        crate::model::human_loop_activation_output::Builder::default()
    }
}

/// <p>Sets up the human review workflow the document will be sent to if one of the conditions
/// is met. You can also set certain attributes of the image before review. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopConfig {
    /// <p>The name of the human workflow used for this image. This should be kept unique within a
    /// region.</p>
    pub human_loop_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
    pub flow_definition_arn: std::option::Option<std::string::String>,
    /// <p>Sets attributes of the input data.</p>
    pub data_attributes: std::option::Option<crate::model::HumanLoopDataAttributes>,
}
impl HumanLoopConfig {
    /// <p>The name of the human workflow used for this image. This should be kept unique within a
    /// region.</p>
    pub fn human_loop_name(&self) -> std::option::Option<&str> {
        self.human_loop_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
    pub fn flow_definition_arn(&self) -> std::option::Option<&str> {
        self.flow_definition_arn.as_deref()
    }
    /// <p>Sets attributes of the input data.</p>
    pub fn data_attributes(&self) -> std::option::Option<&crate::model::HumanLoopDataAttributes> {
        self.data_attributes.as_ref()
    }
}
impl std::fmt::Debug for HumanLoopConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopConfig");
        formatter.field("human_loop_name", &self.human_loop_name);
        formatter.field("flow_definition_arn", &self.flow_definition_arn);
        formatter.field("data_attributes", &self.data_attributes);
        formatter.finish()
    }
}
/// See [`HumanLoopConfig`](crate::model::HumanLoopConfig)
pub mod human_loop_config {
    /// A builder for [`HumanLoopConfig`](crate::model::HumanLoopConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_name: std::option::Option<std::string::String>,
        pub(crate) flow_definition_arn: std::option::Option<std::string::String>,
        pub(crate) data_attributes: std::option::Option<crate::model::HumanLoopDataAttributes>,
    }
    impl Builder {
        /// <p>The name of the human workflow used for this image. This should be kept unique within a
        /// region.</p>
        pub fn human_loop_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_name = Some(input.into());
            self
        }
        /// <p>The name of the human workflow used for this image. This should be kept unique within a
        /// region.</p>
        pub fn set_human_loop_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
        pub fn flow_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
        pub fn set_flow_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_arn = input;
            self
        }
        /// <p>Sets attributes of the input data.</p>
        pub fn data_attributes(mut self, input: crate::model::HumanLoopDataAttributes) -> Self {
            self.data_attributes = Some(input);
            self
        }
        /// <p>Sets attributes of the input data.</p>
        pub fn set_data_attributes(
            mut self,
            input: std::option::Option<crate::model::HumanLoopDataAttributes>,
        ) -> Self {
            self.data_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopConfig`](crate::model::HumanLoopConfig)
        pub fn build(self) -> crate::model::HumanLoopConfig {
            crate::model::HumanLoopConfig {
                human_loop_name: self.human_loop_name,
                flow_definition_arn: self.flow_definition_arn,
                data_attributes: self.data_attributes,
            }
        }
    }
}
impl HumanLoopConfig {
    /// Creates a new builder-style object to manufacture [`HumanLoopConfig`](crate::model::HumanLoopConfig)
    pub fn builder() -> crate::model::human_loop_config::Builder {
        crate::model::human_loop_config::Builder::default()
    }
}

/// <p>Allows you to set attributes of the image. Currently, you can declare an image as free
/// of personally identifiable information and adult content. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopDataAttributes {
    /// <p>Sets whether the input image is free of personally identifiable information or adult
    /// content.</p>
    pub content_classifiers: std::option::Option<std::vec::Vec<crate::model::ContentClassifier>>,
}
impl HumanLoopDataAttributes {
    /// <p>Sets whether the input image is free of personally identifiable information or adult
    /// content.</p>
    pub fn content_classifiers(&self) -> std::option::Option<&[crate::model::ContentClassifier]> {
        self.content_classifiers.as_deref()
    }
}
impl std::fmt::Debug for HumanLoopDataAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopDataAttributes");
        formatter.field("content_classifiers", &self.content_classifiers);
        formatter.finish()
    }
}
/// See [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
pub mod human_loop_data_attributes {
    /// A builder for [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_classifiers:
            std::option::Option<std::vec::Vec<crate::model::ContentClassifier>>,
    }
    impl Builder {
        /// Appends an item to `content_classifiers`.
        ///
        /// To override the contents of this collection use [`set_content_classifiers`](Self::set_content_classifiers).
        ///
        /// <p>Sets whether the input image is free of personally identifiable information or adult
        /// content.</p>
        pub fn content_classifiers(
            mut self,
            input: impl Into<crate::model::ContentClassifier>,
        ) -> Self {
            let mut v = self.content_classifiers.unwrap_or_default();
            v.push(input.into());
            self.content_classifiers = Some(v);
            self
        }
        /// <p>Sets whether the input image is free of personally identifiable information or adult
        /// content.</p>
        pub fn set_content_classifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContentClassifier>>,
        ) -> Self {
            self.content_classifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
        pub fn build(self) -> crate::model::HumanLoopDataAttributes {
            crate::model::HumanLoopDataAttributes {
                content_classifiers: self.content_classifiers,
            }
        }
    }
}
impl HumanLoopDataAttributes {
    /// Creates a new builder-style object to manufacture [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
    pub fn builder() -> crate::model::human_loop_data_attributes::Builder {
        crate::model::human_loop_data_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentClassifier {
    #[allow(missing_docs)] // documentation missing in model
    FreeOfAdultContent,
    #[allow(missing_docs)] // documentation missing in model
    FreeOfPersonallyIdentifiableInformation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentClassifier {
    fn from(s: &str) -> Self {
        match s {
            "FreeOfAdultContent" => ContentClassifier::FreeOfAdultContent,
            "FreeOfPersonallyIdentifiableInformation" => {
                ContentClassifier::FreeOfPersonallyIdentifiableInformation
            }
            other => ContentClassifier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentClassifier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentClassifier::from(s))
    }
}
impl ContentClassifier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentClassifier::FreeOfAdultContent => "FreeOfAdultContent",
            ContentClassifier::FreeOfPersonallyIdentifiableInformation => {
                "FreeOfPersonallyIdentifiableInformation"
            }
            ContentClassifier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FreeOfAdultContent",
            "FreeOfPersonallyIdentifiableInformation",
        ]
    }
}
impl AsRef<str> for ContentClassifier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
